﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Sonic.Services;
using Sonic.Services.Controllers;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.Service;

namespace Sonic.Service.PL.Controllers.Echo
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    [Authorize]
    public class EchoPriceRequestController : BaseController
    {
        private readonly PriceRequestService _priceRequestService;
        private readonly IRequestRepository _requestRepository;
        private IHostingEnvironment _hostingEnvironment;

        public EchoPriceRequestController(IHostingEnvironment hostingEnvironment, IRequestRepository requestRepository) : base(requestRepository)
        {
            _requestRepository = requestRepository;
            _hostingEnvironment = hostingEnvironment;
            _priceRequestService = new PriceRequestService(_requestRepository, hostingEnvironment, null);
        }
        

        [HttpPost]
        [ActionName("SavePriceRequest")]
        public JsonResult SavePriceRequest([FromBody] PendingPriceListModel priceReqesut)
        {
            try
            {
                if (!ModelState.IsValid)
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
                var result = _priceRequestService.SavePriceRequest(priceReqesut);
                if (result == GlobalErrors.Success)
                {
                    return JSonResultResponse.GetSuccessJSon(string.Empty);
                }
                else
                {
                    return JSonResultResponse.GetErrorJSon(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Getting_Data, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return JSonResultResponse.GetErrorJSon();
            }
        }
        
    }
}