﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using Sonic.Web.Model;
using System;
using System.Security.Claims;

namespace Sonic.Services
{
    public static class WorkExtension
    {
        private static object _object = new object();

        public static bool IsAuthenticated(this Controller controller)
        {
            return controller.User != null && controller.User.Identity.IsAuthenticated;
        }

        public static WorkContext WorkContext(this Controller controller)
        {
            try
            {
                lock (_object)
                {
                    WorkContext _workContext = null;
                    LoginRoleType loginRoleType;
                    if (controller.Request.Path.HasValue && controller.Request.Path.Value.Contains("EchoSignup"))
                    {
                        loginRoleType = LoginRoleType.ECHO;
                    }
                    else
                    {
                        loginRoleType = (LoginRoleType)int.Parse(controller.User.FindFirstValue(ClaimTypes.Role));
                    }
                    switch (loginRoleType)
                    {
                        case LoginRoleType.ECHO:
                            EchoOperatorModel echoModel = null;
                            if (controller.IsAuthenticated())
                            {
                                var userSerialized = controller.User.FindFirstValue(ClaimTypes.Name);
                                echoModel = JsonConvert.DeserializeObject<EchoOperatorModel>(userSerialized);
                            }
                            _workContext = new WorkContext(echoModel);
                            break;
                        default:
                            OperatorModel model = null;
                            if (controller.IsAuthenticated())
                            {
                                var userSerialized = controller.User.FindFirstValue(ClaimTypes.Name);
                                model = JsonConvert.DeserializeObject<OperatorModel>(userSerialized);
                            }
                            _workContext = new WorkContext(model);
                            break;
                    }
                    return _workContext;
                }
            }
            catch (Exception ex)
            {
                return null;
            }
        }
    }
}