﻿using Microsoft.AspNetCore.Mvc;
using Sonic.Web.Model;

namespace Sonic.Services
{
    public class JSonResponse
    {
        public JSonResponse(dynamic data, int status, string message)
        {
            this.data = data;
            this.status = status;
            this.message = message;
        }

        public dynamic data { get; set; }
        public string message { get; set; }

        /// <summary>
        /// Status is Zero --> Success, otherwise it's Error.
        /// </summary>
        public int status { get; set; }
    }

    public class JSonResultResponse
    {
        private static JSonResponse _JSonResponse;
        private static JsonResult _JsonResult;

        public static JsonResult GetErrorJSon()
        {
            return GetErrorJSon("Error happened, Please Try again later.");
        }

        public static JsonResult GetErrorJSon(string message)
        {
            _JSonResponse = new JSonResponse(null, GlobalErrors.Error.GetHashCode(), message);
            _JsonResult = new JsonResult(_JSonResponse);
            _JsonResult.ContentType = "application/json";
            //_JsonResult.SerializerSettings = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetSuccessJSon()
        {
            return GetSuccessJSon("Success");
        }
        public static JsonResult GetSuccessJSon(string message)
        {
            _JSonResponse = new JSonResponse(null, GlobalErrors.Success.GetHashCode(), message);
            _JsonResult = new JsonResult(_JSonResponse);
            //_JsonResult.MaxJsonLength = Int32.MaxValue;
            _JsonResult.ContentType = "application/json";
            //_JsonResult.JsonRequestBehavior = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetErrorJSon(dynamic data, string message)
        {
            _JSonResponse = new JSonResponse(data, -1, message);
            _JsonResult = new JsonResult(_JSonResponse);
            _JsonResult.ContentType = "application/json";
            //_JsonResult.SerializerSettings = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
        public static JsonResult GetSuccessJSon(dynamic data, string message)
        {
            return GetSuccessJSon(data, GlobalErrors.Success.GetHashCode(), message);
        }
        public static JsonResult GetSuccessJSon(dynamic data, int status, string message)
        {
            _JSonResponse = new JSonResponse(data, status, message);
            _JsonResult = new JsonResult(_JSonResponse);
            //_JsonResult.MaxJsonLength = Int32.MaxValue;
            _JsonResult.ContentType = "application/json";
            //_JsonResult.JsonRequestBehavior = JsonRequestBehavior.AllowGet;
            return _JsonResult;
        }
    }
}