﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.AutoService;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core.AutoService
{
    public class AutoServiceManager
    {
        private readonly IRequestRepository _requestRepository;
        public AutoServiceManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public GlobalErrors GetAutoServiceWebList(ref List<AutoServiceModel> listModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<AutoServiceModel> dBHelper = new DBHelper<AutoServiceModel>();
                string query = $"select * from WindowsServices where IsWebService = 1 and IsEnabled = 1";
                result = dBHelper.GetQueryList(query, ref listModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors InsertWindowsServiceHistoryRecord(string actionName)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"insert into WindowsServicesHistory(ServiceID,StartDate,EndDate,MachineName,ServiceResult)
                               VALUES ((select ServiceID from WindowsServices where ServiceName = '{0}') , 
                               {1} ,{2} ,'{3}' ,'{4}')",
                               actionName,
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                               Environment.MachineName,
                               GlobalErrors.NotInitialized.ToString());

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors UpdateWindowsServiceHistory(int historyId, string serviceResult)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"Update WindowsServicesHistory SET EndDate = {0}, ServiceResult = '{1}' 
                                WHERE HistoryId = {2}",
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                               serviceResult,
                               historyId);

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors GetWindowsServiceHistoryId(ref int historyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                
                object field = new object();
                string query = string.Format("SELECT MAX(historyid) from WindowsServicesHistory");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    historyId = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }


        public GlobalErrors UpdateServiceRunTime(AutoServiceModel model, string resultString)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                DateTime current = DateTime.Now;
                dBHelper.BeginTransaction();
                string query = $@"insert into WindowsServicesHistory(ServiceID,StartDate,EndDate,MachineName,ServiceResult)
                               values({model.ServiceId},{LocalUtilities.ParseDateAndTimeToSQL(model.StartRunTime)},{LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)},'{Environment.MachineName}','{resultString}')";

                result = dBHelper.ExecuteNonQuery(query);  
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

    }
}
