﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class ChattingManager
    {
        public ChattingManager()
        {
        }

        public GlobalErrors GetUploadedFOUsersInChattingAssignment(int employeeId, bool uploadedOnly, int languageId, ref List<ChattingUserModel> uploadedFOUsers)
        {
            string uploadedFilter = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string employeeTypes = string.Format("{0},{1},{2}", EmployeeTypes.Employee.GetHashCode(), EmployeeTypes.SalesManager.GetHashCode(), EmployeeTypes.Supervisor.GetHashCode());

                if (uploadedOnly)
                {
                    uploadedFilter = " And (RouteHistory.Uploaded = 1)";
                }
                DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

                string query = string.Format(@" Select Distinct RouteHistory.EmployeeID  UserId, RouteHistory.DeviceSerial, EmployeeLanguage.Description UserName, DeviceLanguage.Description DeviceName, DeviceToken, 
                Case When RouteHistory.Uploaded = 1 then 1 else 2 End As  ChattingConnectionStatusValue
                From Employee
                inner join RouteHistory on RouteHistory.EmployeeID = Employee.EmployeeID
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {0}
                
                Inner JOIN ChattingListAssignment on 
                ChattingListAssignment.FirstUserID = {1} and ChattingListAssignment.SecondUserID = RouteHistory.EmployeeID
                OR 
                ChattingListAssignment.FirstUserID = RouteHistory.EmployeeID and ChattingListAssignment.SecondUserID = {1}
                And Employee.EmployeeID <> {1}

                inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
                WHERE (Employee.EmployeeTypeID NOT IN ({2})) And (RouteHistory.RouteHistoryID in (
                    Select Max(RouteHistoryID)
                    From RouteHistory
                    group by RouteHistory.EmployeeID))  {3}
                Order By EmployeeLanguage.Description",
                languageId, //0
                employeeId, //1
                employeeTypes, //2
                uploadedFilter //3
                );
                string query2 = string.Format(@" Select Distinct Employee.EmployeeID  UserId, RouteHistory.DeviceSerial, EmployeeLanguage.Description UserName, DeviceLanguage.Description DeviceName, DeviceToken, 
                Case When RouteHistory.Uploaded = 1 then 1 else 2 End As  ChattingConnectionStatusValue
                From Employee
                left join RouteHistory on RouteHistory.EmployeeID = Employee.EmployeeID
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {0}             
                Inner JOIN ChattingListAssignment on 
                ChattingListAssignment.FirstUserID = {1} and ChattingListAssignment.SecondUserID = Employee.EmployeeID
                OR 
                ChattingListAssignment.FirstUserID = Employee.EmployeeID and ChattingListAssignment.SecondUserID = {1}
                And Employee.EmployeeID <> {1}
                left join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
                WHERE --(Employee.EmployeeTypeID NOT IN ({2}))
               -- And 
                ( (RouteHistory.RouteHistoryID in (
                Select Max(RouteHistoryID)
                From RouteHistory
                group by RouteHistory.EmployeeID)) OR RouteHistory.RouteHistoryID IS NULL )
                Order By EmployeeLanguage.Description",
                languageId, //0
                employeeId, //1
                employeeTypes, //2
                uploadedFilter //3
                );

                result = dBHelper.GetQueryList(query2, ref uploadedFOUsers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAvailableUsersForChatting(int employeeId , int languageId, ref List<ChattingUserModel> availableUsers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

                string query = string.Format(@"Select distinct Employee.EmployeeID UserId, EmployeeLanguage.Description UserName ,ISNULL(Employee.Inactive,0) as Inactive,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then IsNull(LastBOLogin.IsLoggedIn,0) Else IsNull(LastFOLogin.Uploaded,0) End As IsLoggedIn,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then (case when IsNull(LastBOLogin.IsLoggedIn,0) = 1 then 1 else 2 end) Else (case when IsNull(LastFOLogin.Uploaded,0) = 1 then 1 else 2 end) End As Status,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then 1 Else 0 End As IsBOUser,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceToken, '') End As DeviceToken ,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceSerial, '') End As DeviceSerial ,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceName, '') End As DeviceName 
From Employee
inner join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
left join OperatorSecurityGroup on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
Inner join
(

Select FirstUserID EmployeeID From ChattingListAssignment
Where SecondUserID = {0} And IsNull(FirstUserID,-1)<>-1
Union
Select SecondUserID EmployeeID From ChattingListAssignment
Where FirstUserID = {0} And IsNull(SecondUserID,-1)<>-1
Union
Select EmployeeOperator.EmployeeID From EmployeeOperator
Inner Join OperatorSecurityGroup On OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
Inner Join ChattingListAssignment On ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
Where ChattingListAssignment.FirstUserID = {0}
Union
Select ChattingListAssignment.FirstUserID From ChattingListAssignment
Inner Join OperatorSecurityGroup On ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
Inner Join EmployeeOperator On OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
Where EmployeeOperator.EmployeeID = {0}
Union
Select EmployeeOperator.EmployeeID From EmployeeOperator
Inner Join OperatorSecurityGroup On OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
Inner Join ChattingListAssignment On ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
Inner Join OperatorSecurityGroup OperatorSecurityGroup2 On ChattingListAssignment.SecondSecurityGroupID = OperatorSecurityGroup2.SecurityGroupID
Inner Join EmployeeOperator EmployeeOperator2 On OperatorSecurityGroup2.OperatorID = EmployeeOperator2.OperatorID
Where EmployeeOperator2.EmployeeID ={0}

Union

Select EmployeeOperator.EmployeeID From EmployeeOperator
Inner Join OperatorSecurityGroup On OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
Inner Join ChattingListAssignment On ChattingListAssignment.SecondSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
Inner Join OperatorSecurityGroup OperatorSecurityGroup2 On ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup2.SecurityGroupID
Inner Join EmployeeOperator EmployeeOperator2 On OperatorSecurityGroup2.OperatorID = EmployeeOperator2.OperatorID
Where EmployeeOperator2.EmployeeID ={0}
)
T On T.EmployeeID = Employee.EmployeeID And T.EmployeeID <> {0}  --and Employee.Inactive <> 1
left join (
Select OperatorLoginHistory.OperatorID,OperatorLoginHistory.IsLoggedIn from OperatorLoginHistory
inner join
(Select OperatorID,max(OperatorCounter)OperatorCounter From OperatorLoginHistory group by operatorid)x on x.OperatorID = OperatorLoginHistory.OperatorID and OperatorLoginHistory.OperatorCounter = x.OperatorCounter
)LastBOLogin On LastBOLogin.OperatorID = EmployeeOperator.OperatorID
left Join(
Select RouteHistory.EmployeeID,Uploaded,DeviceToken.DeviceToken,RouteHistory.DeviceSerial,DeviceLanguage.Description DeviceName from RouteHistory
inner join (Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID)z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {1}            
)LastFOLogin On LastFOLogin.EmployeeID = Employee.EmployeeID
Order By EmployeeLanguage.Description
                ", employeeId, languageId);

                result = dBHelper.GetQueryList(query, ref availableUsers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetUsersToNotifyOfAssignmentChange(int employeeId,int securityGroupId , int languageId, bool empToemp, bool SGToemp,bool empToSG, bool SGToSG ,string addedIds, ref List<ChattingUserModel> availableUsers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string chattingListAssignmentJoin = string.Empty;
            try
            {
                DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

                if (empToemp && addedIds != string.Empty)
                {
                    chattingListAssignmentJoin = string.Format(@"ChattingListAssignment.FirstUserID = {0} and ChattingListAssignment.SecondUserID = Employee.EmployeeID and ChattingListAssignment.SecondUserID in ({1})
                    or 
                    ChattingListAssignment.SecondUserID = {0} and ChattingListAssignment.FirstUserID = Employee.EmployeeID and ChattingListAssignment.FirstUserID  in ({1}) or Employee.EmployeeID = {0}", employeeId, addedIds);

                }
                else if (SGToemp && addedIds != string.Empty)
                {
                    chattingListAssignmentJoin = string.Format(@"  ChattingListAssignment.FirstSecurityGroupID = {0} and ChattingListAssignment.FirstUserID = Employee.EmployeeID and ChattingListAssignment.FirstUserID in ({1}) or OperatorSecurityGroup.SecurityGroupID = {0}", securityGroupId,addedIds);
                }
                else if (empToSG && addedIds != string.Empty)
                {
                    chattingListAssignmentJoin = string.Format(@" ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID 
                    and ChattingListAssignment.FirstSecurityGroupID in ({1})
                    and ChattingListAssignment.FirstUserID = {0}  or Employee.EmployeeID = {0}", employeeId,addedIds);

                }
                else if (SGToSG && addedIds != string.Empty)
                {
                    chattingListAssignmentJoin = string.Format(@"   ChattingListAssignment.FirstSecurityGroupID = {0} and ChattingListAssignment.SecondSecurityGroupID = OperatorSecurityGroup.SecurityGroupID and ChattingListAssignment.SecondSecurityGroupID in ({1})
                or
                ChattingListAssignment.SecondSecurityGroupID  = {0} and ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID and ChattingListAssignment.FirstSecurityGroupID in ({1}) or OperatorSecurityGroup.SecurityGroupID = {0}", securityGroupId, addedIds);
                }
                string query = string.Format(@"
Select distinct Employee.EmployeeID UserId, EmployeeLanguage.Description UserName   , ISNULL(Employee.inactive,0) as Inactive,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then IsNull(LastBOLogin.IsLoggedIn,0) Else IsNull(LastFOLogin.Uploaded,0) End As IsLoggedIn,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then (case when IsNull(LastBOLogin.IsLoggedIn,0) = 1 then 1 else 2 end) Else (case when IsNull(LastFOLogin.Uploaded,0) = 1 then 1 else 2 end) End As Status,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then 1 Else 0 End As IsBOUser,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceToken, '') End As DeviceToken ,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceSerial, '') End As DeviceSerial ,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceName, '') End As DeviceName 
                From Employee
                inner join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID and Employee.Inactive <> 1
                left join OperatorSecurityGroup on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}

                inner join ChattingListAssignment on 
                {0}
                left join (
                Select OperatorLoginHistory.OperatorID,OperatorLoginHistory.IsLoggedIn from OperatorLoginHistory
                inner join
                (Select OperatorID,max(OperatorCounter)OperatorCounter From OperatorLoginHistory group by operatorid)x on x.OperatorID = OperatorLoginHistory.OperatorID and OperatorLoginHistory.OperatorCounter = x.OperatorCounter
                )LastBOLogin On LastBOLogin.OperatorID = EmployeeOperator.OperatorID
                left Join(
                Select RouteHistory.EmployeeID,Uploaded,DeviceToken.DeviceToken,RouteHistory.DeviceSerial,DeviceLanguage.Description DeviceName from RouteHistory
                inner join (Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID)z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
                inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {1}             
                )LastFOLogin On LastFOLogin.EmployeeID = Employee.EmployeeID
                Order By EmployeeLanguage.Description", chattingListAssignmentJoin, languageId);
                result = dBHelper.GetQueryList(query,ref availableUsers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetChattingUserData(int userId, int languageId, ref ChattingUserModel user)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

                string query = string.Format(@"Select distinct Employee.EmployeeID UserId, EmployeeLanguage.Description UserName ,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then IsNull(LastBOLogin.IsLoggedIn,0) Else IsNull(LastFOLogin.Uploaded,0) End As IsLoggedIn,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then (case when IsNull(LastBOLogin.IsLoggedIn,0) = 1 then 1 else 2 end) Else (case when IsNull(LastFOLogin.Uploaded,0) = 1 then 1 else 2 end) End As Status,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then 1 Else 0 End As IsBOUser,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceToken, '') End As DeviceToken ,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceSerial, '') End As DeviceSerial ,
                Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceName, '') End As DeviceName 
                From Employee
                inner join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
                left join OperatorSecurityGroup on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
                left join (
                Select OperatorLoginHistory.OperatorID,OperatorLoginHistory.IsLoggedIn from OperatorLoginHistory
                inner join
                (Select OperatorID,max(OperatorCounter)OperatorCounter From OperatorLoginHistory group by operatorid)x on x.OperatorID = OperatorLoginHistory.OperatorID and OperatorLoginHistory.OperatorCounter = x.OperatorCounter
                )LastBOLogin On LastBOLogin.OperatorID = EmployeeOperator.OperatorID
                left Join(
                Select RouteHistory.EmployeeID,Uploaded,DeviceToken.DeviceToken,RouteHistory.DeviceSerial,DeviceLanguage.Description DeviceName from RouteHistory
                inner join (Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID)z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
                inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {1}            
                )LastFOLogin On LastFOLogin.EmployeeID = Employee.EmployeeID
                where  Employee.EmployeeID = {0}
                Order By EmployeeLanguage.Description
                ", userId, languageId);

                result = dBHelper.GetQuerySingle(query,ref user);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetChattingHistory(ChattingHistoryModel chatInfo, int languageId,ref List<ChattingHistoryModel> chattingHistory)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            string customerFilter = string.Empty;
            string outletFilter = string.Empty;
            try
            {

                if (chatInfo.CustomerId != -1)
                {
                    customerFilter = string.Format(" And (ChattingHistory.CustomerID = {0}) ", chatInfo.CustomerId);
                }
                if (chatInfo.OutletId != -1)
                {
                    outletFilter = string.Format(" And (ChattingHistory.OutletID = {0}) ", chatInfo.OutletId);
                }
                DBHelper<ChattingHistoryModel> dBHelper = new DBHelper<ChattingHistoryModel>();

                string query = string.Format(@"Select
                --ChattingHistory.*
                convert(nvarchar(max),ChattingHistory.MessageID) MessageId ,
                ChattingHistory.MessageBody, ChattingHistory.SenderID, ChattingHistory.ReceiverID, ChattingHistory.CustomerID,ChattingHistory.OutletID, ChattingHistory.MessageDate, ChattingHistory.IsRead, ChattingHistory.ReadingDate
                , ChattingHistory.SenderName , ChattingHistory.ReceiverName, ChattingHistory.IsMessageReceived
                , Customer.CustomerCode As CustomerCode, CustomerOutlet.CustomerCode As OutletCode, CustomerLanguage.Description As CustomerName, CustomerOutletLanguage.Description As OutletName,
                ChattingHistoryMedia.FileName,
				ChattingHistoryMedia.MediaType,
				ChattingHistoryMedia.IsDownloaded,
                CASE WHEN ChattingHistory.MessageBody != '' THEN 1 else 0 END AS HasText,
				CASE WHEN ChattingHistoryMedia.MessageID IS NOT NULL THEN 1 ELSE 0 END AS HasMedia,
                CASE WHEN ChattingHistory.BroadcastID IS NOT NULL THEN 1 ELSE 0 END AS IsBroadcast,
                convert(nvarchar(max),ChattingHistory.BroadcastID) BroadcastID,
				ChattingHistoryMedia.DownloadDate,
                ChattingHistory.MessageDate MessageDateTime
                From ChattingHistory 
                Left outer join Customer on Customer.CustomerID = ChattingHistory.CustomerID
                Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID And CustomerLanguage.LanguageID = {4}
                Left outer join CustomerOutlet on CustomerOutlet.CustomerID = ChattingHistory.CustomerID And CustomerOutlet.OutletID = ChattingHistory.OutletID
                Left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID And CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID And CustomerOutletLanguage.LanguageID = {4}
				LEFT JOIN ChattingHistoryMedia on ChattingHistoryMedia.MessageID = ChattingHistory.MessageID
                where ((SenderID = {0} and ReceiverID = {1}) or (SenderID = {1} and ReceiverID = {0}) )
                {2} {3}
                Order By MessageDate",
                chatInfo.SenderId,
                chatInfo.ReceiverId,
                customerFilter,
                outletFilter,
                languageId);
                result = dBHelper.GetQueryList(query, ref chattingHistory);
                if (result == GlobalErrors.Success && chattingHistory != null && chattingHistory.Count > 0)
                {
                    chattingHistory = chattingHistory.GroupBy(m => m.MessageId).Select(grp => new ChattingHistoryModel
                    {
                        MessageId = grp.Key,
                        MessageBody = grp.First().MessageBody,
                        SenderId = grp.First().SenderId,
                        ReceiverId = grp.First().ReceiverId,
                        CustomerId = grp.First().CustomerId,
                        OutletId = grp.First().OutletId,
                        MessageDate = grp.First().MessageDate,
                        MessageDateTime = grp.First().MessageDateTime,
                        IsRead = grp.First().IsRead,
                        ReadingDate = grp.First().ReadingDate,
                        SenderName = grp.First().SenderName,
                        ReceiverName = grp.First().ReceiverName,
                        IsMessageReceived = grp.First().IsMessageReceived,
                        CustomerCode = grp.First().CustomerCode,
                        OutletCode = grp.First().OutletCode,
                        CustomerName = grp.First().CustomerName,
                        OutletName = grp.First().OutletName,
                        HasText = grp.First().HasText,
                        HasMedia = grp.First().HasMedia,
                        IsBroadcast = grp.First().IsBroadcast,
                        BroadcastId = grp.First().BroadcastId,
                        MediaList = grp.First().HasMedia ? grp.Select(x => new ChattingHistoryMediaModel { 
                            FileName = x.FileName,
                            MediaType = x.MediaType,
                            IsDownloaded = x.IsDownloaded,
                            MessageId = grp.Key,
                            DownloadDate = x.DownloadDate,
                            ImagePath = x.MediaType == ChattingMediaTypes.Image ? $"wwwroot/ChattingMedia/{(!grp.First().IsBroadcast ? grp.Key : grp.First().BroadcastId)}/{x.FileName}" : string.Empty
                        }).ToList() : new List<ChattingHistoryMediaModel>(),
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetChattingCustomers(int employeeId, int languageId,ref List<CustomerModel> chattingCustomers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                DBHelper<CustomerModel> dBHelper = new DBHelper<CustomerModel>();
                string territoryJoin = string.Empty;
                if (employeeId != -1)
                {
                    territoryJoin = string.Format(@" 
                    inner join CustOutTerritory on CustOutTerritory.CustomerID = customer.CustomerID
                    inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeID = {0} ", employeeId);
                }
                string query = string.Format(@"select distinct Customer.CustomerID, Customer.CustomerCode,CustomerLanguage.Description CustomerDescription ,
                    IsNull( Customer.CustomerCode , '--') + ' - ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                    from Customer 
                    inner join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.LanguageID = 1
                    where customer.Inactive <> 1 
                    Order By CustomerLanguage.Description", languageId, territoryJoin);
                result = dBHelper.GetQueryList(query, ref chattingCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveChattingHistory(ChattingHistoryModel message, bool isBroadCast, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string broadcastIdColumn = string.Empty;
                string broadcastIdValue = string.Empty;
                if (isBroadCast)
                {
                    broadcastIdColumn = " ,BroadcastId";
                    broadcastIdValue = string.Format(" ,'{0}' ", message.BroadcastId);
                }
                string query = string.Format(@"insert into ChattingHistory(MessageID, SenderID, ReceiverID, MessageBody, IsRead, MessageDate, ReadingDate, SenderName, ReceiverName, CustomerID, OutletID {11}) 
                values('{0}',{1},{2},'{3}',{4},{5},{6},'{7}','{8}', {9}, {10} {12})",
                message.MessageId,
                message.SenderId,
                message.ReceiverId,
                message.MessageBody.Replace("'", "''"),
                0, // Message not read yet
                LocalUtilities.ParseDateAndTimeToSQL(message.MessageDateTimeModel.Date),
                "Null", // Message not read yet
                message.SenderName.Replace("'", "''"),
                message.ReceiverName.Replace("'", "''"),
                message.CustomerId,
                message.OutletId,
                broadcastIdColumn,
                broadcastIdValue
                );

                if (!isBroadCast && dBHelper == null)
                {
                    DBHelper<int> dbHelper = new DBHelper<int>();
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else if (isBroadCast && dBHelper != null)
                {
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveChattingHistoryMedia(string messageId,DateModel mediaExpiryDateModel,List<ChattingHistoryMediaModel> attachedFiles, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                var values = new StringBuilder();
                foreach (var file in attachedFiles)
                {
                    values.AppendFormat(" ('{0}',{1},'{2}',{3},{4}),", messageId, file.MediaType.GetHashCode(), file.FileName, 0, mediaExpiryDateModel != null ? LocalUtilities.ParseEndDateToSQLString(mediaExpiryDateModel.Date) : "null");
                }
                string query = string.Format(@"Insert Into ChattingHistoryMedia (MessageID, MediaType, FileName, IsDownloaded, ExpiryDate) Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SetMessagesAsRead(ChattingHistoryModel message)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                    string query = string.Format(@" Update ChattingHistory Set ReadingDate = {0}, IsRead = 1 Where SenderId ={1} AND ReceiverID ={2} AND IsRead = 0 ", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), message.SenderId,message.ReceiverId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SetAttachmentAsDownloaded(string messageId, string fileName,DateTime downloadDate, ChattingMediaTypes mediatype)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = $@"Update ChattingHistoryMedia set IsDownloaded = 1, DownloadDate = {LocalUtilities.ParseDateAndTimeToSQL(downloadDate)} where messageId = '{messageId}' and FileName = '{fileName}' and mediaType = {mediatype.GetHashCode()}";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetEmployeeMessagesAsReceived(int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"Update ChattingHistory set IsMessageReceived = 1, 
                ReceivingDate = CASE WHEN (ReadingDate IS NOT NULL AND ISNULL(IsRead,0) <> 0) THEN ReadingDate ELSE {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}  END
                where ReceiverID = {employeeId} and IsMessageReceived = 0 and messageDate <= {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }
        public GlobalErrors GetEmployeeUnreadMessages(int employeeId, int languageId,ref List<ChattingHistoryModel> unreadMessages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                string attachmentNotificationDesc =
                ResourcesManager.TranslateKey("Desc_Chat_Notification_Attachment", languageId);
                DBHelper<ChattingHistoryModel> dBHelper = new DBHelper<ChattingHistoryModel>();
                //string query = string.Format(@"Select  convert(nvarchar(max),ChattingHistory.MessageID) MessageId, SenderID, ReceiverID, MessageBody, IsRead, MessageDate,
                //ReadingDate , SenderName, ReceiverName, IsMessageReceived, CustomerID,OutletID  from ChattingHistory where IsRead = 0 and ReceiverID = {0} order by MessageDate Asc", employeeId);
                string query = string.Format(@"Select  convert(nvarchar(max),ChattingHistory.MessageID) MessageId, SenderID, ReceiverID, MessageBody, IsRead, MessageDate,
ReadingDate , SenderName, ReceiverName, IsMessageReceived, ChattingHistory.CustomerID,ChattingHistory.OutletID ,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then 1 Else 0 End As IsBOSender,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceToken, '') End As SenderDeviceToken ,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceSerial, '') End As SenderDeviceSerial ,
Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceName, '') End As DeviceName ,
--CASE When ChattingHistory.MessageBody != '' THEN MessageBody ELSE (select top 1 filename from ChattingHistoryMedia C where C.MessageID = ChattingHistory.MessageID) END AS MessageBody,
CASE When ChattingHistory.MessageBody != '' THEN MessageBody ELSE 
REPLACE('{2}', '{3}', SenderName)
END AS MessageBody
from ChattingHistory
inner join Employee on Employee.EmployeeID = ChattingHistory.SenderID
left Join(
Select RouteHistory.EmployeeID,Uploaded,DeviceToken.DeviceToken,RouteHistory.DeviceSerial,DeviceLanguage.Description DeviceName from RouteHistory
inner join (Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID)z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {0}            
)LastFOLogin On LastFOLogin.EmployeeID = Employee.EmployeeID
where IsRead = 0 and ReceiverID = {1} order by MessageDate Asc", languageId, employeeId, attachmentNotificationDesc, "{0}");
                result = dBHelper.GetQueryList(query, ref unreadMessages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckInactiveEmployeeChattingHistory(List<int> inactiveUsersIds, int employeeId, ref List<int> data)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ChattingHistoryModel> userMessages = new List<ChattingHistoryModel>();
            string query = string.Empty;
            try
            {
                DBHelper<ChattingHistoryModel> dBHelper = new DBHelper<ChattingHistoryModel>();

                string IdString = string.Join(',', inactiveUsersIds);
                if(IdString != null && IdString != string.Empty)
                {
                    query = string.Format(@"select SenderID,ReceiverID from ChattingHistory where
                            ReceiverID in  ({1})  and SenderID = {0}
                            or SenderID in ({1}) and ReceiverID = {0}", employeeId, IdString);
                    result = dBHelper.GetQueryList(query, ref userMessages);
                    if(result == GlobalErrors.Success && userMessages != null)
                    {
                        if ( userMessages.Count > 0)
                        {
                            foreach (int inactiveUserId in inactiveUsersIds)
                            {
                                var inactiveUserMessagesCount = 0;
                                inactiveUserMessagesCount = userMessages.Where(msg => msg.SenderId == inactiveUserId || msg.ReceiverId == inactiveUserId).ToList().Count;
                                if (inactiveUserMessagesCount == 0)
                                {
                                    data.Add(inactiveUserId);
                                }
                            }
                        } 
                        else
                        {
                            data = inactiveUsersIds;
                        }
                       
                    }
                }
               
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerOutletDescriptions(int customerId, int outletId,ref List<CustomerOutletDescriptions> descriptions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletDescriptions> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerOutletDescriptions>();
                string query = string.Format(@"select CustomerOutletLanguage.CustomerID,CustomerOutletLanguage.OutletID,ISNULL(CustomerOutletLanguage.Description,'') as OutletDescription, ISNULL(CustomerLanguage.Description,'')  as CustomerDescription,CustomerOutletLanguage.LanguageID, customer.CustomerCode, CustomerOutlet.CustomerCode as OutletCode
                from CustomerOutletLanguage
inner join CustomerOutlet on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                inner join customer on CustomerOutletLanguage.CustomerID = customer.CustomerID
                left join CustomerLanguage on CustomerLanguage.CustomerID = CustomerOutletLanguage.CustomerID and CustomerLanguage.LanguageID = CustomerOutletLanguage.LanguageID
                where CustomerLanguage.CustomerID = {0} and CustomerOutletLanguage.OutletID = {1}", customerId, outletId);
                result = dBHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteEmployeesFromChattingList(List<ChattingAssignmentModel> assignmentList)
        {
            string query = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var deletedUsers = assignmentList.Select(assignmentList => assignmentList.AddedUserId).ToArray();
                var deletedUserIds = string.Join(",", deletedUsers);
                DBHelper<int> dBHelper = new DBHelper<int>();

                if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
                {
                    query = string.Format(@"Delete From ChattingListAssignment 
                    Where (FirstUserID = {0} And SecondUserID in ({1})) OR (FirstUserID in ({1}) And SecondUserID =  {0})", assignmentList[0].SelectedUserId, deletedUserIds);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
                {
                    query = string.Format(@"Delete From ChattingListAssignment 
                    Where (FirstSecurityGroupID = {0} And FirstUserID in ({1}))", assignmentList[0].SelectedSecurityGroupId, deletedUserIds);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteSecurityGroupsFromChattingList(List<ChattingAssignmentModel> assignmentList)
        {
            string query = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var deletedSGs = assignmentList.Select(assignmentList => assignmentList.AddedSecurityGroupId).ToArray();
                var deletedSGIds = string.Join(",", deletedSGs);
                DBHelper<int> dBHelper = new DBHelper<int>();

                if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
                {
                    query = string.Format(@"Delete From ChattingListAssignment 
                    Where (FirstUserID = {0} And FirstSecurityGroupID in ({1}) ) ", assignmentList[0].SelectedUserId, deletedSGIds);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
                {
                    query = string.Format(@"Delete From ChattingListAssignment 
                    Where (FirstSecurityGroupID = {0} And SecondSecurityGroupID in ({1}) OR FirstSecurityGroupID in ({1})  And SecondSecurityGroupID = {0} )", assignmentList[0].SelectedSecurityGroupId, deletedSGIds);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool IsEmployeeHasDeviceTokenExists(int EmployeeId, ref string devToken)
        {
            Object field = null;
            bool isOperatorExists = false;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format("SELECT Token FROM  SupervisorDeviceToken WHERE EmployeeId = '{0}'", EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    devToken = field.ToString();
                if (!String.IsNullOrWhiteSpace(devToken))
                    isOperatorExists = true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isOperatorExists;
        }

        public GlobalErrors SaveAddedEmployeesToChattingList(List<ChattingAssignmentModel> assignmentList)
        {
            string sqlStatement = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                DBHelper<int> dBHelper = new DBHelper<int>();
                // Check whether assignment list is for an employee or security group.
                if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
                {
                    foreach (ChattingAssignmentModel assignment in assignmentList)
                    {
                        // Check if currenct user is already added [by another logged in user]
                        sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
                        Where (FirstUserID = {0} And SecondUserID =  {1}) OR (FirstUserID = {1} And SecondUserID =  {0})", assignment.SelectedUserId, assignment.AddedUserId);
                        result = dBHelper.ExecuteScalar(sqlStatement, ref field);
                        if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            if (Convert.ToInt32(field.ToString()) == 0)
                            {
                                sqlStatement = string.Format(@" Insert into ChattingListAssignment (FirstUserID, SecondUserID,FirstSecurityGroupID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedUserId, assignment.AddedUserId);
                                result = dBHelper.ExecuteNonQuery(sqlStatement);
                                if (result != GlobalErrors.Success)
                                    return GlobalErrors.Error;
                            }
                            else
                            {
                                // if inserted before , go to next user
                                continue;
                            }
                        }
                        else
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
                else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
                {
                    foreach (ChattingAssignmentModel assignment in assignmentList)
                    {
                        // Check if currenct user is already added [by another logged in user]
                        sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
                        Where (FirstSecurityGroupID = {0} And FirstUserID = {1})", assignment.SelectedSecurityGroupId, assignment.AddedUserId);
                        result = dBHelper.ExecuteScalar(sqlStatement, ref field);
                        if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            if (Convert.ToInt32(field.ToString()) == 0)
                            {
                                sqlStatement = string.Format(@" Insert into ChattingListAssignment (FirstSecurityGroupID, FirstUserID,SecondUserID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedSecurityGroupId, assignment.AddedUserId);
                                result = dBHelper.ExecuteNonQuery(sqlStatement);
                                if (result != GlobalErrors.Success)
                                    return GlobalErrors.Error;
                            }
                            else
                            {
                                // if inserted before , go to next user
                                continue;
                            }
                        }
                        else
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveAddedSecurityGroupsToChattingList(List<ChattingAssignmentModel> assignmentList)
        {
            string sqlStatement = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                DBHelper<int> dBHelper = new DBHelper<int>();

                if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
                {
                    foreach (ChattingAssignmentModel assignment in assignmentList)
                    {
                        // Check if currenct Security group is already added [by another logged in user]
                        sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
                        Where (FirstUserID =  {0} And FirstSecurityGroupID = {1} )", assignment.SelectedUserId, assignment.AddedSecurityGroupId);
                        result = dBHelper.ExecuteScalar(sqlStatement, ref field);
                        if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            if (Convert.ToInt32(field.ToString()) == 0)
                            {
                                sqlStatement = string.Format(@"  Insert into ChattingListAssignment (FirstUserID, FirstSecurityGroupID,SecondUserID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedUserId, assignment.AddedSecurityGroupId);
                                result = dBHelper.ExecuteNonQuery(sqlStatement);
                                if (result != GlobalErrors.Success)
                                    return GlobalErrors.Error;
                            }
                            else
                            {
                                // if inserted before , go to next user
                                continue;
                            }
                        }
                        else
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
                else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
                {
                    foreach (ChattingAssignmentModel assignment in assignmentList)
                    {
                        // Check if currenct Security group is already added [by another logged in user]
                        sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
                        Where (FirstSecurityGroupID = {0} And SecondSecurityGroupID =  {1}) OR (FirstSecurityGroupID = {1} And SecondSecurityGroupID =  {0})", assignment.SelectedSecurityGroupId, assignment.AddedSecurityGroupId);
                        result = dBHelper.ExecuteScalar(sqlStatement, ref field);
                        if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            if (Convert.ToInt32(field.ToString()) == 0)
                            {
                                sqlStatement = string.Format(@"  Insert into ChattingListAssignment (FirstSecurityGroupID, SecondSecurityGroupID, FirstUserID,SecondUserID ) Values ({0}, {1},-1,-1)", assignment.SelectedSecurityGroupId, assignment.AddedSecurityGroupId);
                                result = dBHelper.ExecuteNonQuery(sqlStatement);
                                if (result != GlobalErrors.Success)
                                    return GlobalErrors.Error;
                            }
                            else
                            {
                                // if inserted before , go to next user
                                continue;
                            }
                        }
                        else
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
       
//        public GlobalErrors CheckIfChattingIsAvailableForOperator(int employeeId, ref bool isAvailable)
//        {
//            GlobalErrors result = GlobalErrors.NotInitialized;
//            try
//            {
//                DBHelper<int> dBHelper= new DBHelper<int>();
//                object objField = 0;
//                string query = string.Format(@"select count(*) from WebSecurityGroupPrivilege 
//inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = WebSecurityGroupPrivilege.SecurityGroupID
//inner join EmployeeOperator on EmployeeOperator.OperatorID =  OperatorSecurityGroup.OperatorID
// where MenuID = '2100' and EmployeeOperator.EmployeeID = {0}", employeeId);
//                result = dBHelper.ExecuteScalar(query, ref objField);
//                if(result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString().Trim()) > 0)
//                {
//                    isAvailable = true;
//                }
//                else
//                {
//                    isAvailable = false;
//                }

//            }
//            catch (Exception ex)
//            {
//                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
//                return GlobalErrors.Error;
//            }
//            return result;
//        }
        public string GetEmployeeSecurityGroupAccessString(int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> employeeSecurityGroupsList = new List<int>();
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"select OperatorSecurityGroup.SecurityGroupID from Employee
                Inner Join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
                Inner Join OperatorSecurityGroup on OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
                where Employee.EmployeeID = {0}", employeeId);

                result = dBHelper.GetQueryList(query, ref employeeSecurityGroupsList);

                if (result == GlobalErrors.Success && employeeSecurityGroupsList != null && employeeSecurityGroupsList.Count > 0)
                {
                    return string.Join(", ", employeeSecurityGroupsList);
                }
                else
                {
                    return string.Empty;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }

        public GlobalErrors GetDeviceToken(string deviceSerial, ref string deviceToken)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<string> dBHelper = new DBHelper<string>();
                string query = string.Format(@"SELECT DeviceToken FROM DeviceToken WHERE DeviceSerial = '{0}'", deviceSerial);
                result = dBHelper.GetQuerySingle(query, ref deviceToken);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReceiversTokenList(ref List<BroadcastReceiverModel> receivers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string receiversIdsString = string.Empty;
            List<BroadcastReceiverModel> temp = new List<BroadcastReceiverModel>();

            try
            {
                if(receivers != null && receivers.Count > 0)
                {
                    receiversIdsString = string.Join(",", receivers.Select(r => r.ReceiverId).ToList());
                    DBHelper<BroadcastReceiverModel> dBHelper = new DBHelper<BroadcastReceiverModel>();
                    if(!string.IsNullOrEmpty(receiversIdsString))
                    {
                        string query = $@"Select RouteHistory.EmployeeID ReceiverId,DeviceToken.DeviceToken ReceiverDeviceToken,RouteHistory.DeviceSerial from RouteHistory
                        inner join (
                        Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID
                        )z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
                        inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
                        where RouteHistory.EmployeeID in ({receiversIdsString})";
                        result = dBHelper.GetQueryList(query, ref temp);
                        if(result == GlobalErrors.Success && temp != null && temp.Count > 0)
                        {
                            foreach(BroadcastReceiverModel receiver in receivers)
                            {
                                var token = temp.Where(t => t.ReceiverId == receiver.ReceiverId).ToList();
                                    
                                receiver.ReceiverDeviceToken = token != null && token.Count() > 0? token.FirstOrDefault().ReceiverDeviceToken: string.Empty;
                                if (string.IsNullOrEmpty(receiver.ReceiverDeviceToken))
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }

                            }
                        }
                        else
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
