﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.AutoService;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.Core
{
    public class ConfigurationManager
    {
        private readonly IRequestRepository _requestRepository;
        public ConfigurationManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors FillOperatorConfigurations()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ConfigurationModel> configurationsList = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configurationsList = new List<ConfigurationModel>();
                string query = string.Format(@"Select * from (
                Select Configuration.KeyName, (case when ConfigDefinition.Type = 2 then Lower(alllevels.KeyValue) else allLevels.KeyValue end) as KeyValue , alllevels.proirity ConfigurationLevelPriority,
                row_number() OVER (PARTITION BY Configuration.KeyName ORDER BY alllevels.proirity ASC) AS rowNumber
                from Configuration
                left outer join (
                select KeyName, KeyValue, 1 proirity from Configuration
                where EmployeeID = {0}
                union
                select KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
                where ConfigurationSecurityGroup.SecurityGroupID in
                (select SecurityGroupID from OperatorSecurityGroup where OperatorID = {1})
                union
                select KeyName, KeyValue, 4 proirity from ConfigurationOrganization
                where ConfigurationOrganization.OrganizationID = {2}
                union
                select KeyName, KeyValue, 5 proirity from Configuration
                where EmployeeID = -1

                ) allLevels on allLevels.KeyName = Configuration.KeyName
                inner join ConfigDefinition on ConfigDefinition.ConfigurationID = Configuration.ConfigurationID )tt
                where tt.rowNumber = 1 and tt.ConfigurationLevelPriority is not null",
                _requestRepository.CurrentOperator.EmployeeId,
                _requestRepository.CurrentOperator.OperatorId,
                _requestRepository.CurrentOperator.OrganizationId);
                result = dbHelper.GetQueryList(query, ref configurationsList);
                if (result == GlobalErrors.Success)
                {
                    _requestRepository.ConfigurationsList = configurationsList;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllConfigurations(ref List<ConfigurationModel> allConfigurations)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;

            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                allConfigurations = new List<ConfigurationModel>();

                string  query = string.Format(@"
                select  Configuration.KeyName,
                   Configuration.EmployeeID,
	               Configuration.ConfigurationID,
	               ConfigDefinition.*,
	               case when [type]=2 then case when LOWER (Configuration.KeyValue)='true' then 'ON' else 'OFF' end else Configuration.KeyValue end KeyValue,
	               Configuration.KeyValue OldValue,case when [Readonly]=1 then 0 else 1 end Enabled ,ConfigDefinitionLanguage.Description,
	               case when [Readonly]='true' then 0 else [Type] end ValueType , 
	               ConfigCategoryLanguage.Description ConfigCategoryName,
	               case when [type]=2 then case when LOWER (Configuration.KeyValue)='true' then 1 else 0 end end booleanValue,

                CASE WHEN emp.countemp > 0 THEN 1 ELSE 0 END AS HasEmployeeLevel,
	            CASE WHEN SG.countSG > 0 THEN 1 ELSE 0 END AS HasSecurityGroupLevel,
                CASE WHEN org.countorg > 0 THEN 1 ELSE 0 END AS HasOrganizationLevel,
                CASE WHEN div.countdiv > 0 THEN 1 ELSE 0 END AS HasDivisionLevel,	
                CASE WHEN cus.countcus > 0 THEN 1 ELSE 0 END AS HasCustOutLevel,
                CASE WHEN chn.countchn > 0 THEN 1 ELSE 0 END AS HasChannelLevel,
                CASE WHEN grp.countgrp > 0 THEN 1 ELSE 0 END AS HasCustomerGroupLevel 
                FROM Configuration

                LEFT JOIN (
                    SELECT COUNT(*) AS countemp, ConfigurationID
                    FROM Configuration where EmployeeID != -1
                    GROUP BY ConfigurationID
                ) emp ON emp.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countSG, ConfigurationID
                    FROM ConfigurationSecurityGroup
                    GROUP BY ConfigurationID
                ) SG ON SG.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countorg, ConfigurationID
                    FROM ConfigurationOrganization
                    GROUP BY ConfigurationID
                ) org ON org.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countdiv, ConfigurationID
                    FROM ConfigurationDivision
                    GROUP BY ConfigurationID
                ) div ON div.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countcus, ConfigurationID
                    FROM ConfigurationCustOut
                    GROUP BY ConfigurationID
                ) cus ON cus.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countchn, ConfigurationID
                    FROM ConfigurationChannel
                    GROUP BY ConfigurationID
                ) chn ON chn.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN (
                    SELECT COUNT(*) AS countgrp, ConfigurationID
                    FROM ConfigurationCustomerGroup
                    GROUP BY ConfigurationID
                ) grp ON grp.ConfigurationID = Configuration.ConfigurationID

                INNER JOIN ConfigDefinition ON ConfigDefinition.ConfigurationID = Configuration.ConfigurationID
                LEFT JOIN ConfigDefinitionLanguage ON ConfigDefinitionLanguage.ConfigurationID = Configuration.ConfigurationID AND ConfigDefinitionLanguage.LanguageID = {0}
                LEFT JOIN ConfigCategoryLanguage ON ConfigCategoryLanguage.ConfigCategoryID = ConfigDefinition.ConfigCategoryID AND ConfigCategoryLanguage.LanguageID = {0}

                where Configuration.EmployeeId=-1 and Configuration.KeyName <> 'ApplyGS1TrackAndTraceTemplate' ", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref allConfigurations);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetLevelConfigurations(int levelId, string configFilter, ref List<ConfigurationModel> allConfigurations)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;

            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                allConfigurations = new List<ConfigurationModel>();
                string configurationsQuery = string.Empty;

                switch ((ConfigurationLevels)levelId)
                {
                    case ConfigurationLevels.EmployeeLevel:
                        configurationsQuery = string.Format(@"SELECT C.ConfigurationID, C.KeyName, C.KeyValue, CD.ReadOnly , C.KeyValue OldValue,c.EmployeeID
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                           ,IsNull( Employee.EmployeeCode , '--') + ' - ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                        FROM Configuration C 
                        INNER JOIN ConfigDefinition CD ON C.ConfigurationID= CD.ConfigurationID
                        INNER JOIN Employee on Employee.EmployeeID=C.EmployeeID
                        INNER JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID=Employee.EmployeeID 
                        and EmployeeLanguage.LanguageID={1}
                        WHERE ( 1=1 {0} and C.KeyName <> 'ApplyGS1TrackAndTraceTemplate' ) ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.SecurityGroupLevel:
                        configurationsQuery = string.Format(@"
                    SELECT CSG.ConfigurationID, CSG.KeyName, CSG.KeyValue, CD.ReadOnly , CSG.KeyValue OldValue,CSG.SecurityGroupId
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                     , IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName
                    FROM ConfigurationSecurityGroup CSG
                    INNER JOIN ConfigDefinition CD ON CSG.ConfigurationID= CD.ConfigurationID
                    Inner Join SecurityGroup on SecurityGroup.SecurityGroupId=CSG.SecurityGroupId
                    Inner Join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID=SecurityGroup.SecurityGroupID
                    and SecurityGroupLanguage.LanguageID={1}
                     WHERE (1=1 {0} and CSG.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.Organization:
                        configurationsQuery = string.Format(@"SELECT CO.ConfigurationID, CO.KeyName, CO.KeyValue, CD.ReadOnly , CO.KeyValue OldValue,CO.OrganizationID
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                    ,IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                    FROM ConfigurationOrganization CO
                    INNER JOIN ConfigDefinition CD ON CO.ConfigurationID= CD.ConfigurationID
                    Inner join Organization on Organization.OrganizationID=CO.OrganizationID
                    inner join OrganizationLanguage on OrganizationLanguage.OrganizationID=Organization.OrganizationID and OrganizationLanguage.LanguageID={1}
                    WHERE (1=1 {0}  and CO.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.DivisionLevel:
                        configurationsQuery = string.Format(@"SELECT CO.ConfigurationID, CO.KeyName, CO.KeyValue, CD.ReadOnly , CO.KeyValue OldValue,CO.DivisionID
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                    ,IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName
                    FROM ConfigurationDivision CO
                    INNER JOIN ConfigDefinition CD ON CO.ConfigurationID= CD.ConfigurationID
                    inner join Division on Division.DivisionID=CO.DivisionID
                    inner join DivisionLanguage on DivisionLanguage.DivisionID=Division.DivisionID and DivisionLanguage.LanguageID={1}
                     WHERE (1=1  {0} and CO.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.CustomerLevel:
                        configurationsQuery = string.Format(@"SELECT CO.ConfigurationID, CO.KeyName, CO.KeyValue, CD.ReadOnly, CO.KeyValue OldValue ,CO.CustomerID ,CO.OutletID
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                    ,IsNull( Customer.CustomerCode , '--') + ' - ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                    ,IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                    FROM ConfigurationCustOut CO
                    INNER JOIN ConfigDefinition CD ON CO.ConfigurationID= CD.ConfigurationID
                    inner join Customer on Customer.CustomerID=CO.CustomerID
                    inner join CustomerOutlet on CustomerOutlet.CustomerID=CO.CustomerID and CustomerOutlet.OutletID=CO.OutletID
                    inner join CustomerLanguage on customerlanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                    inner join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID
                    and CustomerOutletLanguage.LanguageID={1}
                     WHERE (1=1 {0} and CO.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.ChannelLevel:
                        configurationsQuery = string.Format(@"SELECT CO.ConfigurationID, CO.KeyName, CO.KeyValue, CD.ReadOnly , CO.KeyValue OldValue,CO.ChannelID,CO.SubChannelID
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                    ,IsNull( Channel.ChannelCode , '--') + ' - ' + IsNull( ChannelLanguage.Description , '--') as ChannelCodeName
                    ,IsNull( SubChannel.SubChannelCode , '--') + ' - ' + IsNull( SubChannelLanguage.Description , '--') as SubChannelCodeName
                    FROM ConfigurationChannel CO
                    INNER JOIN ConfigDefinition CD ON CO.ConfigurationID= CD.ConfigurationID
                    inner join Channel on Channel.ChannelID=Co.ChannelID
                    inner join ChannelLanguage on ChannelLanguage.ChannelID=Channel.ChannelID and ChannelLanguage.LanguageID={1}
                    left outer join SubChannel on SubChannel.ChannelID=CO.ChannelID and  SubChannel.SubChannelID=CO.SubChannelID
                    left outer join SubChannelLanguage on  SubChannelLanguage.SubChannelID=SubChannel.SubChannelID and  SubChannelLanguage.LanguageID={1}
                                                    WHERE ( 1=1 {0} and CO.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                    case ConfigurationLevels.CustomerGroupLevel:
                        configurationsQuery = string.Format(@"SELECT CO.ConfigurationID, CO.KeyName, CO.KeyValue, CD.ReadOnly , CO.KeyValue OldValue,CO.GroupID CustomerGroupId
,case when [Readonly]='true' then 0 else [Type] end ValueType , case when [type]=2 then case when LOWER (KeyValue)='true' then 1 else 0 end end booleanValue
                        ,IsNull( CustomerGroup.GroupCode , '--') + ' - ' + IsNull( CustomerGroupLanguage.Description , '--') as CustomerGroupCodeName
                        FROM ConfigurationCustomerGroup CO
                        INNER JOIN ConfigDefinition CD ON CO.ConfigurationID= CD.ConfigurationID
                        inner join CustomerGroup on CustomerGroup.GroupID=CO.GroupID
                        inner join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                                    WHERE (1=1  {0} and CO.KeyName <> 'ApplyGS1TrackAndTraceTemplate') ORDER BY KeyName ", configFilter, _requestRepository.LanguageId);
                        break;
                }

                result = dbHelper.GetQueryList(configurationsQuery, ref allConfigurations);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveLevelConfigurations(List<ConfigurationModel> changedConfigurationsList, ConfigurationLevels configLevel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Empty;
                string queryHistory = string.Empty;
                int maxHistoryId = 0;
                AuditActions auditActions = AuditActions.Add;
                if (changedConfigurationsList != null && changedConfigurationsList.Count > 0)
                {

                    foreach (ConfigurationModel config in changedConfigurationsList)
                    {
                        query = string.Empty;
                        queryHistory = string.Empty;
                        maxHistoryId = 0;
                        switch (configLevel)
                        {
                            case ConfigurationLevels.EmployeeLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into Configuration (KeyName,KeyValue,EmployeeID,ConfigurationID)
                                values ('{0}','{1}',{2},{3})", config.KeyName, config.KeyValue, config.EmployeeId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update Configuration set KeyValue='{0}' where KeyName='{1}' and EmployeeID={2}", config.KeyValue, config.KeyName, config.EmployeeId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  Configuration  where KeyName='{0}' and EmployeeID={1}", config.KeyName, config.EmployeeId);
                                        auditActions = AuditActions.Delete;
                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationHistory (HistoryID,ConfigurationID,EmployeeID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                                        , maxHistoryId, config.ConfigurationId, config.EmployeeId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }

                                break;
                            case ConfigurationLevels.SecurityGroupLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationSecurityGroup (KeyName,KeyValue,SecurityGroupID,ConfigurationID)
                                values ('{0}','{1}',{2},{3})", config.KeyName, config.KeyValue, config.SecurityGroupId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationSecurityGroup set KeyValue='{0}' where KeyName='{1}' and SecurityGroupID={2}", config.KeyValue, config.KeyName, config.SecurityGroupId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationSecurityGroup  where KeyName='{0}' and SecurityGroupID={1}", config.KeyName, config.SecurityGroupId);
                                        auditActions = AuditActions.Delete;

                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationSecurityGroupHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationSecurityGroupHistory (HistoryID,ConfigurationID,SecurityGroupID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                                        , maxHistoryId, config.ConfigurationId, config.SecurityGroupId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                            case ConfigurationLevels.Organization:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationOrganization (KeyName,KeyValue,OrganizationId,ConfigurationID)
                                values ('{0}','{1}',{2},{3})", config.KeyName, config.KeyValue, config.OrganizationId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationOrganization set KeyValue='{0}' where KeyName='{1}' and OrganizationId={2}", config.KeyValue, config.KeyName, config.OrganizationId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationOrganization  where KeyName='{0}' and OrganizationId={1}", config.KeyName, config.OrganizationId);
                                        auditActions = AuditActions.Delete;

                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationOrganizationHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationOrganizationHistory (HistoryID,ConfigurationID,OrganizationId,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                                        , maxHistoryId, config.ConfigurationId, config.OrganizationId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                            case ConfigurationLevels.CustomerLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationCustOut (KeyName,KeyValue,CustomerID,OutletID,ConfigurationID)
                                values ('{0}','{1}',{2},{3},{4})", config.KeyName, config.KeyValue, config.CustomerId, config.OutletId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationCustOut set KeyValue='{0}' where KeyName='{1}' and CustomerID={2} and OutletID={3}", config.KeyValue, config.KeyName, config.CustomerId, config.OutletId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationCustOut  where KeyName='{0}' and CustomerID={1} and OutletId={2}", config.KeyName, config.CustomerId, config.OutletId);
                                        auditActions = AuditActions.Delete;
                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationCustOutHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationCustOutHistory (HistoryID,ConfigurationID,CustomerID,OutletID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},{6},'{7}','{8}','{9}')"
                                        , maxHistoryId, config.ConfigurationId, config.CustomerId, config.OutletId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                            case ConfigurationLevels.DivisionLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationDivision (KeyName,KeyValue,DivisionID,ConfigurationID)
                                values ('{0}','{1}',{2},{3})", config.KeyName, config.KeyValue, config.DivisionId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationDivision set KeyValue='{0}' where KeyName='{1}' and DivisionID={2}", config.KeyValue, config.KeyName, config.DivisionId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationDivision  where KeyName='{0}' and DivisionID={1}", config.KeyName, config.DivisionId);
                                        auditActions = AuditActions.Delete;
                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationDivisionHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationDivisionHistory (HistoryID,ConfigurationID,DivisionID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                                        , maxHistoryId, config.ConfigurationId, config.DivisionId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                            case ConfigurationLevels.ChannelLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationChannel (KeyName,KeyValue,ChannelID,SubChannelID,ConfigurationID)
                                values ('{0}','{1}',{2},{3},{4})", config.KeyName, config.KeyValue, config.ChannelId, config.SubChannelId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationChannel set KeyValue='{0}' where KeyName='{1}' and ChannelID={2} and SubChannelID={3} "
                                , config.KeyValue, config.KeyName, config.ChannelId, config.SubChannelId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationChannel  where KeyName='{0}' and ChannelID={1} and SubChannelID={2}"
                                , config.KeyName, config.ChannelId, config.SubChannelId);
                                        auditActions = AuditActions.Delete;
                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationChannelHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationChannelHistory (HistoryID,ConfigurationID,ChannelID,SubChannelID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},{6},'{7}','{8}','{9}')"
                                        , maxHistoryId, config.ConfigurationId, config.ChannelId, config.SubChannelId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                            case ConfigurationLevels.CustomerGroupLevel:
                                switch (config.DataAction)
                                {
                                    case DataActions.Add:
                                        query = string.Format(@" insert into ConfigurationCustomerGroup (KeyName,KeyValue,GroupID,ConfigurationID)
                                values ('{0}','{1}',{2},{3})", config.KeyName, config.KeyValue, config.CustomerGroupId, config.ConfigurationId);
                                        auditActions = AuditActions.Add;
                                        break;
                                    case DataActions.Edit:
                                        query = string.Format(@" update ConfigurationCustomerGroup set KeyValue='{0}' where KeyName='{1}' and GroupID={2}", config.KeyValue, config.KeyName, config.CustomerGroupId);
                                        auditActions = AuditActions.Edit;
                                        break;
                                    case DataActions.Delete:
                                        query = string.Format(@" delete from  ConfigurationCustomerGroup  where KeyName='{0}' and GroupID={1}", config.KeyName, config.CustomerGroupId);
                                        auditActions = AuditActions.Delete;
                                        break;
                                }
                                if (config.DataAction != DataActions.NoChange)
                                {
                                    maxHistoryId = GetMaxHistoryID("ConfigurationCustomerGroupHistory", dbHelper);
                                    queryHistory = string.Format(@"insert into ConfigurationCustomerGroupHistory (HistoryID,ConfigurationID,GroupID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                                        , maxHistoryId, config.ConfigurationId, config.CustomerGroupId, (int)auditActions, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                        config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                                }
                                else
                                {
                                    maxHistoryId = 0;
                                    queryHistory = string.Empty;
                                }
                                break;
                        }

                        if (query != string.Empty)
                            result = dbHelper.ExecuteNonQuery(query);
                        else
                            result = GlobalErrors.Success;

                        if (result == GlobalErrors.Success && queryHistory != string.Empty)
                        {
                            result = dbHelper.ExecuteNonQuery(queryHistory);
                        }
                        if (result != GlobalErrors.Success) break;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                    dbHelper = null;
                }
            }
            return result;
        }

        public static int GetMaxHistoryID(string tableName, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int maxId = 1;
            try
            {
                object Id = null;
                string query = string.Format(@" select isnull(max(HistoryId),0)+1 from {0}", tableName);
                result = dBHelper.ExecuteScalar(query, ref Id);
                if (result == GlobalErrors.Success && Id != null && !string.IsNullOrEmpty(Id.ToString()))
                {
                    maxId = int.Parse(Id.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                maxId = -1;
            }
            return maxId;
        }
        public GlobalErrors FillOperatorConfigurationsOnDivisionLevel()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ConfigurationModel> configurationsList = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configurationsList = new List<ConfigurationModel>();
                string query = string.Format(@"select Configuration.ConfigurationID, Configuration.KeyName, Configuration.KeyValue, ConfigurationDivision.DivisionID
                from ConfigurationDivision
                inner join Configuration on Configuration.ConfigurationID = ConfigurationDivision.ConfigurationID
                inner join EmployeeDivision on EmployeeDivision.DivisionID = ConfigurationDivision.DivisionID and EmployeeDivision.EmployeeID = {0}",
                _requestRepository.CurrentOperator.EmployeeId);
                result = dbHelper.GetQueryList(query, ref configurationsList);
                if (result == GlobalErrors.Success)
                {
                    // CoreSession.Instance.ConfigurationsListOnDivisionLevel = configurationsList;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillConfigurationsOnCustomerLevel()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ConfigurationModel> configurationsList = new List<ConfigurationModel>();
            DBHelper<ConfigurationModel> dbHelper = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                query = $@"select * 
                from ConfigurationCustOut CCO";
                result = dbHelper.GetQueryList(query, ref configurationsList);
                if (result == GlobalErrors.Success)
                {
                    _requestRepository.CustomerConfigurationsList = configurationsList;
                }
                if (result == GlobalErrors.Success)
                {
                    configurationsList = new List<ConfigurationModel>();
                    query = $@"select CCG.ConfigurationId, CCG.GroupId CustomerGroupId, CCG.KeyName, CCG.KeyValue from ConfigurationCustomerGroup CCG";
                    result = dbHelper.GetQueryList(query, ref configurationsList);
                    if (result == GlobalErrors.Success)
                    {
                        _requestRepository.GroupConfigurationsList = configurationsList;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    configurationsList = new List<ConfigurationModel>();
                    query = $@"select * from ConfigurationChannel";
                    result = dbHelper.GetQueryList(query, ref configurationsList);
                    if (result == GlobalErrors.Success)
                    {
                        _requestRepository.ChannelConfigurationsList = configurationsList;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateSystemConfigurations(List<ConfigurationModel> changedConfigurationsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = "Update Configuration set KeyValue='{0}' where KeyName='{1}' and EmployeeID=-1";
                string queryHistory = string.Empty;
                int maxHistoryId = 0;


                if (changedConfigurationsList != null && changedConfigurationsList.Count > 0)
                {
                    foreach (ConfigurationModel config in changedConfigurationsList)
                    {
                        result = dbHelper.ExecuteNonQuery(string.Format(query, config.KeyValue, config.KeyName));
                        if (result != GlobalErrors.Success) break;
                        maxHistoryId = GetMaxHistoryID("ConfigurationHistory", dbHelper);
                        queryHistory = string.Format(@"insert into ConfigurationHistory (HistoryID,ConfigurationID,EmployeeID,ActionID,ChangeBy,ChangeDate,OldValue,NewValue,MachineName) values
                                    ({0},{1},{2},{3},{4},{5},'{6}','{7}','{8}')"
                    , maxHistoryId, config.ConfigurationId, -1, (int)AuditActions.Edit, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    config.OldValue, config.KeyValue, System.Environment.MachineName.ToString());
                        result = dbHelper.ExecuteNonQuery(queryHistory);
                        if (result != GlobalErrors.Success) break;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                    dbHelper = null;
                }
            }
            return result;
        }
        public static List<ConfigurationModel> FillSpecificEmployeeConfigurations(int employeeId)
        {
            return FillSpecificEmployeeConfigurations(employeeId, string.Empty);
        }
        public static List<ConfigurationModel> FillSpecificEmployeeConfigurations(int employeeId, string storekeeperConfigurations)
        {
            List<ConfigurationModel> configurationsList = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configurationsList = new List<ConfigurationModel>();
                string query = storekeeperConfigurations != "" ? storekeeperConfigurations : "";
            
                query += string.Format(@"Select * from (
                Select Configuration.KeyName, alllevels.KeyValue, alllevels.proirity ConfigurationLevelPriority,
                row_number() OVER (PARTITION BY Configuration.KeyName ORDER BY alllevels.proirity ASC) AS rowNumber
                from Configuration
                {1}
                left outer join (
                select KeyName, KeyValue, 1 proirity from Configuration
                where EmployeeID = {0}
                union
                select KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
                where ConfigurationSecurityGroup.SecurityGroupID in
                (select SecurityGroupID from OperatorSecurityGroup where OperatorID = (select OperatorID from EmployeeOperator where EmployeeID = {0}))
                union
                select KeyName, KeyValue, 4 proirity from ConfigurationOrganization
                where ConfigurationOrganization.OrganizationID = (Select OrganizationID from Employee where EmployeeID = {0})
                union
                select KeyName, KeyValue, 5 proirity from Configuration
                where EmployeeID = -1
                ) allLevels on allLevels.KeyName = Configuration.KeyName)tt
                where tt.rowNumber = 1 and tt.ConfigurationLevelPriority is not null",
                employeeId, storekeeperConfigurations != "" ? " INNER JOIN @temp ON Configuration.KeyName = ConfigurationName " : "");
                var result = dbHelper.GetQueryList(query, ref configurationsList);

                return configurationsList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return new List<ConfigurationModel>();
            }
        }

        public static List<ConfigurationModel> FillCustomConfigurations(bool AllowTerritoryCustomerVisit, int routeId, int territoryId)
        {
            List<ConfigurationModel> configurationsList = null;
            DBHelper<ConfigurationModel> dbHelper = null;

            string customerRouteTerritoryFilter = string.Empty;
            string groupRouteTerritoryFilter = string.Empty;
            string channelRouteTerritoryFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configurationsList = new List<ConfigurationModel>();

                string query = string.Empty;
                if (!AllowTerritoryCustomerVisit)
                {
                    customerRouteTerritoryFilter = string.Format(@" INNER JOIN  RouteCustomer ON RouteCustomer.CustomerID = ConfigurationCustOut.CustomerID and RouteCustomer.OutletID = ConfigurationCustOut.OutletID
                            And RouteCustomer.RouteID = {0}", routeId);

                    groupRouteTerritoryFilter = string.Format(@" INNER JOIN  RouteCustomer ON RouteCustomer.CustomerID = CustomerOutletGroup.CustomerID and RouteCustomer.OutletID = CustomerOutletGroup.OutletID
                            And RouteCustomer.RouteID={0}", routeId);

                    channelRouteTerritoryFilter = string.Format(@" INNER JOIN  RouteCustomer ON RouteCustomer.CustomerID = CustomerOutletGroup.CustomerID and RouteCustomer.OutletID = CustomerOutletGroup.OutletID
                            And RouteCustomer.RouteID ={0}", routeId);
                }
                else
                {
                    customerRouteTerritoryFilter = string.Format(@" INNER JOIN  CustOutTerritory ON CustOutTerritory.CustomerID = ConfigurationCustOut.CustomerID and CustOutTerritory.OutletID = ConfigurationCustOut.OutletID
                           And CustOutTerritory.TerritoryID = {0}", territoryId);

                    groupRouteTerritoryFilter = string.Format(@" INNER JOIN  CustOutTerritory ON CustOutTerritory.CustomerID = CustomerOutletGroup.CustomerID and CustOutTerritory.OutletID = CustomerOutletGroup.OutletID
                           And CustOutTerritory.TerritoryID = {0}", territoryId);

                    channelRouteTerritoryFilter = string.Format(@"  INNER JOIN  CustOutTerritory ON CustOutTerritory.CustomerID = CustomerOutletGroup.CustomerID and CustOutTerritory.OutletID = CustomerOutletGroup.OutletID
                           And CustOutTerritory.TerritoryID = {0}", territoryId);
                }

                query = string.Format(@" select * from (
                  select KeyName, KeyValue ,1 levelSequence from ConfigurationCustOut
                  {0}
                  Where lower(ConfigurationCustOut.KeyValue) like '%true%'
                  Union 
                  
                  select Keyname,keyvalue,2 levelSequence from ConfigurationCustomerGroup
                  inner join CustomerOutletGroup on CustomerOutletGroup.GroupID=ConfigurationCustomerGroup.GroupID
                  {1}
                  Where lower(ConfigurationCustomerGroup.KeyValue) like '%true%'
                  Union 
                  

                  select Keyname,keyvalue,3 levelSequence from ConfigurationChannel
                  inner join CustomerGroup on CustomerGroup.ChannelID=ConfigurationChannel.ChannelID and 
                  CustomerGroup.SubChannelID = ConfigurationChannel.SubChannelID
                  inner join CustomerOutletGroup on CustomerOutletGroup.GroupID=CustomerGroup.GroupID
                  {2}
                  Where lower(ConfigurationChannel.KeyValue) like '%true%'
                  Union 
                  

                  select Keyname,keyvalue,4 levelSequence from ConfigurationChannel
                  inner join CustomerGroup on CustomerGroup.ChannelID=ConfigurationChannel.ChannelID and 
                  (ConfigurationChannel.SubChannelID = -1 or ConfigurationChannel.SubChannelID is null)
                  inner join CustomerOutletGroup on CustomerOutletGroup.GroupID=CustomerGroup.GroupID
                  {2}
                  Where lower(ConfigurationChannel.KeyValue) like '%true%'
                 ) as t1 
                 order by levelSequence", customerRouteTerritoryFilter, groupRouteTerritoryFilter, channelRouteTerritoryFilter);

                var result = dbHelper.GetQueryList(query, ref configurationsList);

                return configurationsList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return new List<ConfigurationModel>();
            }
        }

        public GlobalErrors GetConfigurationValue(string keyName)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ConfigurationModel> configurationsList = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configurationsList = new List<ConfigurationModel>();
                string query = string.Format(@"Select * from (
                Select Configuration.KeyName, alllevels.KeyValue, alllevels.proirity ConfigurationLevelPriority,
                row_number() OVER (PARTITION BY Configuration.KeyName ORDER BY alllevels.proirity ASC) AS rowNumber
                from Configuration
                left outer join (
                select KeyName, KeyValue, 1 proirity from Configuration
                where EmployeeID = {0}
                union
                select KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
                where ConfigurationSecurityGroup.SecurityGroupID in
                (select SecurityGroupID from OperatorSecurityGroup where OperatorID = {1})
                union
                select KeyName, KeyValue, 4 proirity from ConfigurationOrganization
                where ConfigurationOrganization.OrganizationID = {2}
                union
                select KeyName, KeyValue, 5 proirity from Configuration
                where EmployeeID = -1

                ) allLevels on allLevels.KeyName = Configuration.KeyName)tt
                where tt.rowNumber = 1 and tt.ConfigurationLevelPriority is not null",
                _requestRepository.CurrentOperator.EmployeeId,
                _requestRepository.CurrentOperator.OperatorId,
                _requestRepository.CurrentOperator.OrganizationId);
                result = dbHelper.GetQueryList(query, ref configurationsList);
                if (result == GlobalErrors.Success)
                {
                    _requestRepository.ConfigurationsList = configurationsList;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetConfigurationGeneralValue(string keyName, ref string value)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            value = string.Empty;
            try
            {
                dbHelper = new DBHelper<string>();
                string query = string.Format(@" SELECT KeyValue FROM Configuration WHERE KeyName = '{0}' AND EmployeeID = -1", keyName);
                object obj = new object();
                result = dbHelper.ExecuteScalar(query, ref obj);
                if (result == GlobalErrors.Success && obj != null)
                {
                    value = obj.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetConfigurationValueFromDB(string configurationName, ref dynamic keyvalue)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object field = null;
                string query = $"select KeyValue from Configuration where KeyName = '{configurationName}'";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null)
                {
                    keyvalue = field.ToString();
                }
                else
                {
                    return GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;

        }
        #region [STOREKEEPER APP]
        public static List<ConfigurationModel> GetStoreKeeperConfiguartionList(int employeeId )
        {
            List<ConfigurationModel> configurations = new List<ConfigurationModel>();
            try
            {
                string configurationValues = string.Format(@"DECLARE @temp Table (ConfigurationName Nvarchar(100))
                                INSERT INTO @temp 
                                SELECT keyname from Configuration where keyname in (
                                'DateFormat'
                                ,'DateTimeFormat'
                                ,'LinkItemsToWarehouse'
                                ,'AllowEditApprovedLoadOffloadRequest'
                                ,'AutoExecuteLoadRequestInBO'
                                ,'AutoExecuteOffloadRequestInBO'
                                ,'CheckMainWHStockForLoad'
                                ,'UseDefaultExpiryAndBatchForItems'
                                ,'NumberOfStockDigits'
                                ,'NumberOfDigits'
                                ,'ControlTransactionOnDivisionLevel'
                                ,'ApplyGS1TrackAndTraceTemplate'
                                ,'ShowDivisionSelectionOnWHTransaction'
                                ,'AllowBatchSelectionInWarehouseOperations'
                                ,'BatchNumberFormat'
                                ,'BlockManuallyBatchInsertion'
                                ,'ShowQuantityInLoadIn'
                                ,'AllowEditItemInTransfer'
                                ,'ForceLoadRequestForOrders'
                                ,'SerialTemplateDateFormat'
                                ,'ForceSingleSerials'
                                ,'SerialTrimEndLength'
                                ,'SerialTrimStartLength'
                                ,'EnableGeneratingSSCC'
                                ,'DefaultSerialScanningType'
                                ,'ExecuteLoadRequestMode'
                                ,'ExecuteOffLoadRequestMode'
                                ,'SerialsMode'
                                ,'ValidateExpiryDateOnYearAndMonthOnly'
                                )");
                configurations = FillSpecificEmployeeConfigurations(employeeId, configurationValues);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return configurations;
        }
        public static List<ConfigurationModel> GetReportScheduleConfiguartionList(int employeeId)
        {
            List<ConfigurationModel> configurations = new List<ConfigurationModel>();
            try
            {
                string configurationValues = string.Format(@"DECLARE @temp Table (ConfigurationName Nvarchar(100))
                                INSERT INTO @temp 
                                SELECT keyname from Configuration where keyname in (
                                'EmailPhrasesLanguage'
                                ,'NumberOfDigits'
                                ,'NumberOfStockDigits'
                                ,'PrintHeaderPerPage'
                                )");
                configurations = FillSpecificEmployeeConfigurations(employeeId, configurationValues);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return configurations;
        }
        public static ConfigurationModel GetConfigurationOnOrganization(string keyName, int organizationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            ConfigurationModel configModel = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configModel = new ConfigurationModel();
                string query = string.Format(@"
                        SELECT KeyName, KeyValue, ConfigurationID FROM ConfigurationOrganization  WHERE (KeyName ='{0}') AND (OrganizationID = ({1}))
	                      ", keyName, organizationId);
                result = dbHelper.GetQuerySingle(query, ref configModel);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                configModel = null;
            }
            return configModel;
        }
        public GlobalErrors GetCertianTimeRunning(ref DateTime CertianTimeRun)
        {
            DBHelper<AutoServiceModel> dBHelper = null;
            AutoServiceModel autoService = new AutoServiceModel();
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<AutoServiceModel>();
                string query = string.Format(@"select TimeToRun from WindowsServices where ServiceName = '{0}'", WebServiceActions.ReportScheduleService);
                result = dBHelper.GetQuerySingle(query, ref autoService);
                CertianTimeRun = autoService.TimeToRun;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}