﻿using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using Sonic.Web.DAL;
using Sonic.Web.Model;

namespace Sonic.Web.Core
{
    public class CurrencyManager
    {
        private readonly IRequestRepository _requestRepository;

        public CurrencyManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetAllCurrencies(int organizationId , ref List<CurrencyModel> currencyList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CurrencyModel> dbHelper = null;
            string orgFilter = "";
            try
            {
                dbHelper = new DBHelper<CurrencyModel>();
                if (_requestRepository.Configurations.ApplyCurrencyPerOrganization)
                {
                    if (organizationId != -1)
                    {
                        orgFilter = string.Format(@$" AND Currency.OrganizationID = {organizationId}");
                    }
                    else
                    {
                        orgFilter = string.Format(" AND Currency.OrganizationID in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                }

                string query = string.Format(@"select Currency.CurrencyID,Description CurrencyDescription, Currency.Base 
,IsNull( Currency.Code , '--') + ' - ' + IsNull( CurrencyLanguage.Description , '--') as CurrencyCodeName
from Currency 
Left outer join CurrencyLanguage on CurrencyLanguage.CurrencyID=Currency.CurrencyID and LanguageID={0} Where 1=1 {1}", _requestRepository.LanguageId, orgFilter);
                result = dbHelper.GetQueryList(query, ref currencyList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetBaseCurrency(ref string baseCurrency)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            try
            {
                baseCurrency = "$";
                dbHelper = new DBHelper<string>();
                string query = "select Code  from Currency WHERE Base = 1";
                object field = new object();
                result = dbHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    baseCurrency = field.ToString().Trim();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetBaseCurrencyId(ref int baseCurrencyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            try
            {
                baseCurrencyId = -1;
                dbHelper = new DBHelper<string>();
                string query = "select CurrencyID from Currency WHERE Base = 1";
                object field = new object();
                result = dbHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    baseCurrencyId = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public int GetBaseCurrencyId()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            int currencyId = -1;
            try
            {

                dbHelper = new DBHelper<int>();
                string query = "select CurrencyID  from Currency WHERE Base = 1";
                object field = new object();
                result = dbHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    currencyId = int.Parse(field.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return currencyId;
        }
        public int GetCustomerOuteltCurrency(int customerID, int outletID,DBHelper<int>dBHelper)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;
            int currencyId = -1;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"SELECT CurrencyID FROM CustomerOutlet WHERE CustomerID = {0} AND OutletID = {1}",customerID,outletID);
                object field = new object();
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    currencyId = int.Parse(field.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return currencyId;
        }
    }
}
