﻿using InCube.Security;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.Customer;
using Sonic.Web.Model.ProcedureResult;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Dynamic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Transactions;
using System.Threading;
using static EchoCustomerOutletModel;

namespace Sonic.Web.Core
{
    public class CustomerManager
    {

        private readonly IRequestRepository _requestRepository;
        private readonly AccountManager _accountManager;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly PaymentManager _paymentManager;
        private readonly TransactionManager _transactionManager;
        private readonly EmployeeManager _employeeManager;
        private readonly MasterDataManager _masterDataManager;
        private readonly PromotionManager _promotionManager;

        public CustomerManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _accountManager = new AccountManager(_requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(_requestRepository);
            _paymentManager = new PaymentManager(_requestRepository);
            _transactionManager = new TransactionManager(_requestRepository);
            _employeeManager = new EmployeeManager(_requestRepository);
            _masterDataManager = new MasterDataManager(_requestRepository);
            _promotionManager = new PromotionManager(_requestRepository);
        }
        public static GlobalErrors AddNewTest()
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            DBHelper<CustomerModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<CustomerModel>();
                dbHelper.BeginTransaction();
                string query = "INSERT INTO [dbo].[aaa] ([Id],[Name]) VALUES (1, 'Test1') ";
                err = dbHelper.ExecuteNonQuery(query);
                if (err == GlobalErrors.Success)
                {
                    query = "INSERT INTO [dbo].[aaa] ([Id],[Name]) VALUES (2, 'Test2') ";
                    err = dbHelper.ExecuteNonQuery(query);
                    if (err == GlobalErrors.Success)
                    {
                        query = "INSERT INTO [dbo].[aaa] ([Id],[Name]) VALUES (3, 'Test3') ";
                        err = dbHelper.ExecuteNonQuery(query);
                    }
                }
                if (err == GlobalErrors.Success)
                {
                    err = dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return err;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

  

        public GlobalErrors GetCustomerSubChannels(int customerId, int outletId, ref List<CustomerSubChannelModel> customerSubChannelList)
        {
            DBHelper<CustomerSubChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerSubChannelModel>();
                string sqlString = string.Format(@"select SubChannel.*,IsNull( SubChannel.SubChannelCode , '--') + ' - ' + IsNull( SubChannelLanguage.Description , '--') as SubChannelCodeName
                                                    FROM SubChannel
                                                    inner join CustomerGroup on CustomerGroup.ChannelID = SubChannel.ChannelID and CustomerGroup.SubChannelID = SubChannel.SubChannelID
                                                    inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID
                                                    Inner JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = SubChannel.SubChannelID and SubChannelLanguage.LanguageID = {0}
                                                    where CustomerOutletGroup.CustomerID = {1} and CustomerOutletGroup.OutletID = {2}",
                                                    _requestRepository.LanguageId, customerId, outletId);
                result = dbHelper.GetQueryList(sqlString, ref customerSubChannelList);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerSubChannelList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public bool CustomerViolatedTheTerms(CustomerOutletModel outlet, int divisionId)
        {
            bool violatedTerms = false;

            string divisionFilter = string.Empty;

            DBHelper<int> dBHelper = null;
            int term = 0;
            TimeSpan timeSpan;
            DateTime now = DateTime.Now.Date;
            DateTime oldest = DateTime.Now;
            bool soldToday = false;
            int latency = 0;
            string query2 = "";
            DateTime oldestDueDate = DateTime.Now;
            try
            {
                dBHelper = new DBHelper<int>();
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && divisionId != -1)
                {
                    divisionFilter = string.Format(@"and DivisionID = {0}", divisionId);
                }

                string query = string.Format(@"Select Min(TransactionDate) AS Oldest , MIN(DueDate) AS OldestDueDate
                From [Transaction]
                Where TransactionTypeID in (1,3,6) And CustomerID = {0} and  OutletID = {1}
                and RemainingAmount > 0 and IsNull(Voided,0) = 0 and CreationReason<> {3} {2} ", outlet.CustomerId, outlet.OutletId, divisionFilter, (int)TransactionCreationReason.OrderDeliveryBOInvoice);

                if (_requestRepository.Configurations.ExcludePDCFromPaymentViolation)
                {
                    query = query + string.Format(@"UNION SELECT Min(TransactionDate) AS Oldest , MIN(DueDate) AS OldestDueDate FROM [Transaction] 
                        INNER JOIN CustomerPayment ON CustomerPayment.CustomerID = [Transaction].CustomerID AND CustomerPayment.TransactionID = [Transaction].TransactionID
                        AND CustomerPayment.OutletID = [Transaction].OutletID AND CustomerPayment.DivisionID = [Transaction].DivisionID AND CustomerPayment.PaymentTypeID = {2}
                        AND CustomerPayment.PaymentStatusID <> {3} AND CustomerPayment.Posted<>1
                        WHERE [Transaction].TransactionTypeID IN (1,3,6) AND [Transaction].CustomerID = {0} And [Transaction].CustomerID = {5}
                        AND IsNull(Voided,0) = 0 and CreationReason <> {1}  {4}",
                            outlet.CustomerId,
                            TransactionCreationReason.OrderDeliveryBOInvoice.GetHashCode(),
                            PaymentTypes.PostedDatedCheque.GetHashCode(),
                            PaymentStatusTypes.Voided.GetHashCode(),
                            divisionFilter,
                            outlet.OutletId
                            );
                }
                object field = new object();
                query2 = string.Format("Select Min(OldestDueDate) from ({0}) AS Oldest", query);
                var result = dBHelper.ExecuteScalar(query2, ref field);
                if (field != null)
                {
                    oldestDueDate = DateTime.Parse(field.ToString()).Date;
                    if (now.CompareTo(oldestDueDate) > 0)
                        violatedTerms = true;
                }
                else if (field == null || field.ToString().Equals(""))
                {
                    query = string.Format("Select Min(Oldest) from ({0}) AS Oldest", query);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    PaymentTermModel paymentTerm = new PaymentTermModel();
                    paymentTerm = outlet.CustOutPaymentTerm;
                    if (field == null || field.ToString().Equals(""))
                    {
                        oldest = now;
                        soldToday = false;
                    }
                    else
                    {
                        oldest = DateTime.Parse(field.ToString()).Date;
                        if (oldest == now)
                        {
                            soldToday = true;
                        }
                    }
                    timeSpan = now.Subtract(oldest);
                    latency = timeSpan.Days;

                    paymentTerm.TrasnactionCreationDate = oldest;
                    term = paymentTerm.GetDays();

                    if (term > latency)
                    {
                        violatedTerms = false;
                    }
                    else if (term < latency)
                    {
                        violatedTerms = true;
                    }
                    else
                    {
                        if (soldToday && term == 0)
                            violatedTerms = true;
                        else
                            violatedTerms = false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return violatedTerms;
        }
        public bool CustomerViolatedTheTermsOnDivisions(CustomerOutletModel outlet, int divisionId)
        {
            bool violatedTerms = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string divisionFilter = string.Empty;

            DBHelper<DivisionsPaymentTerms> dBHelper = null;
            int term = 0;
            TimeSpan timeSpan;
            DateTime now = DateTime.Now.Date;
            DateTime oldest = DateTime.Now;
            DateTime oldestDueDate = DateTime.Now;
            bool soldToday = false;
            int latency = 0;
            try
            {
                dBHelper = new DBHelper<DivisionsPaymentTerms>();
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    if (!_requestRepository.Configurations.AllowPaymentTermCheckOverAllDivisions && divisionId != -1)
                        divisionFilter = string.Format(@"and DivisionID = {0}", divisionId);
                }
                else divisionFilter = "and DivisionID = -1";

                string query = string.Format(@"Select Min(TransactionDate) AS DivisionMinDate,Min(DueDate) AS OldestDueDate, DivisionID  as DivisionID 
                From [Transaction]
                Where TransactionTypeID in (1,3,6) And CustomerID = {0} and  OutletID = {1}
                and RemainingAmount > 0 and IsNull(Voided,0) = 0 and CreationReason<> {3} {2}  Group by [Transaction].DivisionID ", outlet.CustomerId, outlet.OutletId, divisionFilter, (int)TransactionCreationReason.OrderDeliveryBOInvoice);

                if (_requestRepository.Configurations.ExcludePDCFromPaymentViolation)
                {
                    query = query + string.Format(@"UNION SELECT Min(TransactionDate) AS DivisionMinDate,Min(DueDate) AS OldestDueDate, [Transaction].DivisionID as DivisionID  FROM [Transaction] 
                        INNER JOIN CustomerPayment ON CustomerPayment.CustomerID = [Transaction].CustomerID AND CustomerPayment.TransactionID = [Transaction].TransactionID
                        AND CustomerPayment.OutletID = [Transaction].OutletID AND CustomerPayment.DivisionID = [Transaction].DivisionID AND CustomerPayment.PaymentTypeID = {2}
                        AND CustomerPayment.PaymentStatusID <> {3} AND CustomerPayment.Posted <> 1
                        WHERE [Transaction].TransactionTypeID IN (1,3,6) AND [Transaction].CustomerID = {0} And [Transaction].CustomerID = {5}
                        AND IsNull(Voided,0) = 0 and CreationReason <> {1}  {4}  Group by [Transaction].DivisionID",
                            outlet.CustomerId,
                            TransactionCreationReason.OrderDeliveryBOInvoice.GetHashCode(),
                            PaymentTypes.PostedDatedCheque.GetHashCode(),
                            PaymentStatusTypes.Voided.GetHashCode(),
                            divisionFilter,
                            outlet.OutletId
                            );
                }
                List<DivisionsPaymentTerms> divisionsDates = new List<DivisionsPaymentTerms>();
                result = dBHelper.GetQueryList(query, ref divisionsDates);
                if (result == GlobalErrors.Success)
                    foreach (DivisionsPaymentTerms division in divisionsDates)
                    {
                        PaymentTermModel paymentTerm = new PaymentTermModel();
                        if (_requestRepository.Configurations.AllowPaymentTermCheckOverAllDivisions && division.DivisionID > -1 && outlet.DivisionsPaymentTerm.ContainsKey(division.DivisionID))
                        {
                            paymentTerm = outlet.DivisionsPaymentTerm[division.DivisionID];
                        }
                        else if (divisionId != -1 && outlet.DivisionsPaymentTerm.ContainsKey(divisionId))
                        {
                            paymentTerm = outlet.DivisionsPaymentTerm[divisionId];
                        }
                        else
                        {
                            violatedTerms = CustomerViolatedTheTerms(outlet, divisionId);
                            if (violatedTerms) break;

                        }

                        if (division.OldestDueDate != null && !division.OldestDueDate.Equals(""))
                        {
                            oldestDueDate = DateTime.Parse(division.OldestDueDate).Date;
                            if (now.CompareTo(oldestDueDate) > 0)
                                violatedTerms = true;
                            else
                                violatedTerms = false;
                        }
                        else
                        {
                            if (division.DivisionMinDate == null || division.DivisionMinDate.Equals(""))
                            {
                                oldest = now;
                                soldToday = false;
                            }
                            else
                            {
                                oldest = DateTime.Parse(division.DivisionMinDate).Date;
                                if (oldest == now)
                                {
                                    soldToday = true;
                                }
                            }
                            timeSpan = now.Subtract(oldest);
                            latency = timeSpan.Days;

                            if (paymentTerm != null)
                            {
                                paymentTerm.TrasnactionCreationDate = oldest;
                                term = paymentTerm.GetDays();
                            }
                            if (term > latency)
                            {
                                violatedTerms = false;
                            }
                            else if (term < latency)
                            {
                                violatedTerms = true;
                            }
                            else
                            {
                                if (soldToday && term == 0)
                                    violatedTerms = true;
                                else
                                    violatedTerms = false;
                            }
                            if (violatedTerms) break;
                        }
                    }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return violatedTerms;
        }
        public GlobalErrors DeleteCustomerOutlet(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                string sqlQuery = "";
                if (dbHelper == null) dbHelper = new DBHelper<int>();
                result = DeleteRelatedDataForCustomerOutlet(outletObj.CustomerId, outletObj.OutletId, dbHelper);

                if (result == GlobalErrors.Success)
                {
                    result = DeleteAllOutletAccounts(outletObj.CustomerId, outletObj.OutletId, dbHelper);
                }
                if (result == GlobalErrors.Success && outletObj.OperatorId != -1)
                {
                    result = DeleteOutletOperator(outletObj.OperatorId.ToString(), outletObj.CustomerId, outletObj.OutletId, dbHelper);
                }

                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@" Delete from CustomerOutletLanguage where
                                     CustomerID={0} and OutletID={1}", outletObj.CustomerId, outletObj.OutletId);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@" Delete from CustomerOutlet where
                                     CustomerID={0} and OutletID={1} ", outletObj.CustomerId, outletObj.OutletId);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }

                }

                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"delete from ContactLanguage where ContactID in (Select ContactID from Contact where CustomerID = {0} AND OutletID = {1})",
                    outletObj.CustomerId, outletObj.OutletId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;


                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@"delete from Contact where CustomerID={0} and OutletID={1}",
                        outletObj.CustomerId, outletObj.OutletId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }

                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
            }
            return result;
        }
        public GlobalErrors GetOutletAccountId(int customerId, int outletId, int parentAccountId, ref int outletObjAccountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = string.Format(@"Select Account.AccountId From Account 
                inner join AccountCustOut on Account.AccountId = AccountCustOut.AccountId 
                Where AccountCustOut.CustomerId = {0} and AccountCustOut.OutletId = {1} and Account.ParentAccountId = {2}",
                customerId,
                outletId,
                parentAccountId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    outletObjAccountId = Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAccountLanguage(int accountID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from AccountLanguage where accountID in ({0})", accountID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAccount(int accountID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from Account where accountID in ({0})", accountID);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDivisionAccount(int divisionAccountID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;

                // 1. delete from accoun div assignment
                query = string.Format(@"delete from AccountCustOutDiv where accountID in ({0})", divisionAccountID);
                result = dbHelper.ExecuteNonQuery(query);

                // 2. delete from account language for div
                if (result == GlobalErrors.Success)
                {
                    result = DeleteAccountLanguage(divisionAccountID, dbHelper);
                }
                // 3. delete from account header for div
                if (result == GlobalErrors.Success)
                {
                    result = DeleteAccount(divisionAccountID, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteOutletAccountWithChilds(int outletAccountID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;

                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    List<int> divisionAccountsLits = new List<int>();
                    query = string.Format(@"Select AccountID From Account Where ParentAccountID = {0}", outletAccountID); // get divisions account
                    result = dbHelper.GetQueryList(query, ref divisionAccountsLits);

                    if (result == GlobalErrors.Success && divisionAccountsLits != null && divisionAccountsLits.Count > 0)
                    {
                        foreach (int divisionAccountID in divisionAccountsLits)
                        {
                            result = DeleteDivisionAccount(divisionAccountID, dbHelper);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                    }
                }

                // 1. delete from accoun cust out assignment
                query = string.Format(@"delete from AccountCustOut where accountID in ({0})", outletAccountID);
                result = dbHelper.ExecuteNonQuery(query);

                // 2. delete from account language for cust out
                if (result == GlobalErrors.Success)
                {
                    result = DeleteAccountLanguage(outletAccountID, dbHelper);
                }
                // 3. delete from account header for cust out
                if (result == GlobalErrors.Success)
                {
                    result = DeleteAccount(outletAccountID, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCustomerAccountWithChilds(int customerAccountID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                List<int> outletAccountsList = new List<int>();

                query = string.Format(@"Select AccountID From Account Where ParentAccountID = {0}", customerAccountID); // get outlets account
                result = dBHelper.GetQueryList(query, ref outletAccountsList);

                if (result == GlobalErrors.Success && outletAccountsList != null && outletAccountsList.Count > 0)
                {
                    foreach (int outletAccountID in outletAccountsList)
                    {
                        result = DeleteOutletAccountWithChilds(outletAccountID, dBHelper);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    // 1. delete from account cust assignment
                    query = string.Format(@"delete from AccountCust where accountID in ({0})", customerAccountID);
                    result = dBHelper.ExecuteNonQuery(query);

                    // 2. delete from account language for cust
                    if (result == GlobalErrors.Success)
                    {
                        result = DeleteAccountLanguage(customerAccountID, dBHelper);
                    }
                    // 3. delete from account for cust
                    if (result == GlobalErrors.Success)
                    {
                        result = DeleteAccountLanguage(customerAccountID, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAllCustomerAccounts(int customerId, DBHelper<int> dBHelper) // when delete whole customer
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> customerAccounts = new List<int>();
                string query = string.Format(@"Select AccountID From AccountCust Where CustomerID = {0}", customerId);
                result = dBHelper.GetQueryList(query, ref customerAccounts);

                if (result == GlobalErrors.Success && customerAccounts != null && customerAccounts.Count > 0)
                {
                    foreach (int accountId in customerAccounts)
                    {
                        result = DeleteCustomerAccountWithChilds(accountId, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAllOutletAccounts(int customerId, int outletId, DBHelper<int> dBHelper) // when delete whole outlet
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> outletAccounts = new List<int>();
                string query = string.Format(@"Select AccountID From AccountCustOut Where CustomerID = {0} and OutletID = {1}", customerId, outletId);
                result = dBHelper.GetQueryList(query, ref outletAccounts);

                if (result == GlobalErrors.Success && outletAccounts != null && outletAccounts.Count > 0)
                {
                    foreach (int outletAccountId in outletAccounts)
                    {
                        result = DeleteOutletAccountWithChilds(outletAccountId, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors DeleteOutletContact(int customerId, int outletId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete from CustomerOutletContact where customerId = {0} AND outletId = {1}", customerId, outletId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteOutletContactLanguage(int customerId, int outletId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete from CustomerOutletContactLangauge where customerId = {0} AND outletId = {1}", customerId, outletId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteCustomerFromEmployeeRoutes(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" delete RouteCustomer from RouteCustomer
                Inner join Route on Route.RouteID = RouteCustomer.RouteID and RouteCustomer.CustomerID = {0} and RouteCustomer.OutletID = {1}
                INNER JOIN EmployeeTerritory on Route.TerritoryID = EmployeeTerritory.TerritoryID and EmployeeTerritory.EmployeeID = {3}
                INNER JOIN RouteAreas on RouteAreas.RouteID = Route.RouteID AND RouteAreas.AreaID = {2}", outletObj.CustomerId, outletObj.OutletId, outletObj.AreaId, outletObj.EmployeeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public CustomerOutletModel FillOutletData(int customerId, int outletId, int divisionId)
        {
            return FillOutletData(customerId, outletId, divisionId, null, false);
        }
        public CustomerOutletModel FillOutletData(int customerId, int outletId, int divisionId, DBHelper<int> dBHelper)
        {
            return FillOutletData(customerId, outletId, divisionId, dBHelper, false);

        }
        public CustomerOutletModel FillOutletData(int customerId, int outletId, int divisionId, DBHelper<int> dBHelper, bool isFromEcho)
        {
            CustomerOutletModel outlet = null;
            DBHelper<CustomerOutletModel> dbHelper2 = null;

            string CustomerChannelIDsString = string.Empty;
            string CustomerSubChannelIDsString = string.Empty;
            string paymentTermString = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper2 = new DBHelper<CustomerOutletModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper2 = new DBHelper<CustomerOutletModel>();
                }
                if (_requestRepository.Configurations.CheckPaymentTermOnCustomerLevel)
                {
                    paymentTermString = string.Format(@" Customer.PaymentTermID");
                }
                else
                {
                    paymentTermString = string.Format(@" CustomerOutlet.PaymentTermID");
                }
                outlet = new CustomerOutletModel();
                string query = string.Format(@"select Customer.CustomerCode , CustomerOutlet.CustomerCode OutletCode , CustomerOutlet.Taxeable , CustomerOutlet.TaxNumber , CustomerOutlet.OnHold ,CustomerOutlet.IsMain, Customer.OnHold as CustomerOnHold ,
                                CustomerLanguage.Description CustomerName , CustomerOutletLanguage.Description OutletName , CustomerOutlet.CustomerTypeID , {3} , CustomerOutlet.Taxeable Taxable,CustomerOutlet.Inactive, CustomerOutlet.OrganizationId
                                FROM CustomerOutlet
                                LEFT OUTER JOIN Customer ON CustomerOutlet.CustomerID = Customer.CustomerID
                                LEFT OUTER JOIN CustomerLanguage ON CustomerOutlet.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0} and CustomerLanguage.OrganizationId in ({4})
                                LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {0}
                                WHERE CustomerOutlet.CustomerID = {1}  AND CustomerOutlet.OutletID = {2}", _requestRepository.LanguageId, customerId, outletId, paymentTermString, _requestRepository.CurrentOperator.OrganizationAccess);
                var result = dbHelper2.GetQuerySingle(query, ref outlet);
                outlet.CustomerId = customerId;
                outlet.OutletId = outletId;
                outlet.CustomerGroupsIdsString = ReadCustomerGroups(outlet, dBHelper);
                if (outlet.CustomerTypeId == CustomerTypes.CashCustomer.GetHashCode())
                {
                    outlet.IsCredit = false;
                }
                else
                {
                    outlet.IsCredit = true;
                }
                ReadCustomerChannels(outlet, ref CustomerChannelIDsString, ref CustomerSubChannelIDsString, dBHelper);
                outlet.CustomerChannelIdsString = CustomerChannelIDsString;
                outlet.CustomerSubChannelIdsString = CustomerSubChannelIDsString;
                if (!isFromEcho)
                {
                    outlet.CustOutPaymentTerm = PaymentTermManager.GetPaymentTerm(outlet.PaymentTermId, dBHelper);
                    ReadCustomerAccount(ref outlet, divisionId, dBHelper);
                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                    {
                        outlet.OnHoldDivisions = ReadOnHoldDivisions(outlet, dBHelper);
                        outlet.DivisionsPaymentTerm = PaymentTermManager.ReadDivisionsPaymentTerms(customerId, outletId, dBHelper);
                    }
                    outlet.PaymentTermCreditRelease = GetCustomerCreditRelease(customerId, outletId, CreditReleaseTypes.PaymentTerm, dBHelper);
                    outlet.CreditLimitCreditRelease = GetCustomerCreditRelease(customerId, outletId, CreditReleaseTypes.CreditLimit, dBHelper);
                }
            }
            catch (Exception ex)
            {
                outlet = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return outlet;
        }

        public GlobalErrors DeleteCustomer(int customerId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                result = DeleteCustomerAttachmentFolders(customerId.ToString());
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                string query = "";
                result = DeleteRelatedDataForCustomerOutlet(customerId, -1, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = DeleteAllCustomerAccounts(customerId, dBHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    string operatorIds = string.Empty;
                    result = GetCustomerOperatorIds(customerId, ref operatorIds, dBHelper);
                    if (result == GlobalErrors.Success && !string.IsNullOrEmpty(operatorIds))
                    {
                        result = DeleteOutletOperator(operatorIds, customerId, -1, dBHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from customerOutletlanguage where customerid={0}", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from customerOutlet where customerid={0}", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from customerlanguage where customerid={0}", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@" Delete from CustomerPackBarcode where CustomerID = {0}", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from customerorganization where customerid={0}", customerId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from customer where customerid={0}", customerId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from PayerAssignment where CustomerID ={0} ", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"update Employee set CustomerID = -1 , OutletID = -1 where CustomerID = {0}", customerId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors DeleteICash(int icashListID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Format(@"DELETE FROM ICashAssignment WHERE iCashListID = {0}", icashListID);

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                if (result == GlobalErrors.Success)
                    deleteQuery = string.Format(@"DELETE FROM ICashDetails WHERE iCashListID = {0}", icashListID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                if (result == GlobalErrors.Success)
                    deleteQuery = string.Format(@"DELETE FROM ICash WHERE iCashListID = {0}", icashListID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);


            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors IsValidToDeleteCustomer(int customerID, int outletID, ref CustomerModel customerObj, ref CustomerOutletModel outletObj, ref List<string> tables)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            DBHelper<string> dBHelper_customerTables = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper_customerTables = new DBHelper<string>();
                int count = 0;
                string whereFilter = "";

                if (customerObj != null && outletID == -1)
                {
                    customerObj.CustomerValidations = new CustomerValidationsModel();
                    whereFilter = "  CustomerID= " + customerID;

                }
                else if (outletObj != null && outletID != -1)
                {
                    outletObj.CustomerValidations = new CustomerValidationsModel();
                    whereFilter = string.Format("  CustomerID={0} and OutletID={1} ", customerID, outletID);

                }
                else
                {
                    return GlobalErrors.Error;
                }

                string query = string.Format(@"select count(*) from [Route] where {0}", whereFilter);
                result = dBHelper.GetQuerySingle(query, ref count);
                if (result == GlobalErrors.Success && count > 0)
                {
                    if (customerObj != null && outletID == -1)
                    { customerObj.CustomerValidations.IsDefaultCustomer = true; }
                    else if (outletObj != null && outletID != -1)
                    {
                        outletObj.CustomerValidations.IsDefaultCustomer = true;
                    }
                }
                else
                {
                    query = string.Format(@"select t.TableName from (
select count(*) FoundCustomers,'CustomerPayment' TableName from CustomerPayment where {0}
union
select count(*) FoundCustomers,'RouteHistoryDetail' TableName from RouteHistoryDetail where {0}
union
select count(*) FoundCustomers,'SalesOrder' TableName from SalesOrder where {0}
union
select count(*) FoundCustomers,'Transaction' TableName from [Transaction] where {0}
)t
where t.FoundCustomers>0
", whereFilter);
                    result = dBHelper_customerTables.GetQueryList(query, ref tables);
                    if (result == GlobalErrors.Success && tables != null && tables.Count > 0)
                    {
                        if (customerObj != null && outletID == -1)
                        {
                            customerObj.CustomerValidations.IsIncludedInTables = true;
                        }
                        else if (outletObj != null && outletID != -1)
                        {
                            outletObj.CustomerValidations.IsIncludedInTables = true;
                        }

                        result = GlobalErrors.Error;

                        return result;

                    }
                }

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
                if (dBHelper_customerTables != null)
                {
                    dBHelper_customerTables.Dispose();
                    dBHelper_customerTables = null;
                }
            }
            return result;
        }
        public GlobalErrors DeleteRelatedDataForCustomerOutlet(int customerID, int outletID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string whereFilter = "";
                string query = "";
                if (outletID == -1)
                {
                    whereFilter = string.Format("  CustomerID={0} ", customerID);
                    query = string.Format(@"delete from TransCustAccessPoint where {0}",
                    whereFilter);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                else
                {
                    whereFilter = string.Format("  CustomerID ={0} and OutletID={1} ", customerID, outletID);

                }
                query = string.Format(@"
delete from Comment where {0};
delete from CustomerAccessPoint where {0};
delete from CustLocationInformation where {0};
delete from CustOutAreaDescription where {0};
delete from CustomerOutletGroup where {0};
delete from CustOutTerritory where {0};
delete from CustomerPrice where {0};
delete from CustomerPromotion where {0};
delete from CustomerRatingHistory where {0};
delete from CustomerStock where {0};
delete from CustomerStockDetail where {0};
delete from DiscountAssignment where {0};
delete from MessageCustomer where {0};
delete from RouteCustomer where {0};
delete from TerCustReturnLimit where {0};
delete from CustomerPromotionExclusion where {0};
Delete from CustOutDivPaymentTerm Where {0};
Delete from CustOutDivOnHoldStatus Where {0}
Delete from SDCCustomer where {0};
Delete from PayerAssignment where {0};
", whereFilter);
                if (result == GlobalErrors.Success)
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        //public static GlobalErrors getAddedFields(AddedFieldsFieldsObject fields)
        //{
        //    GlobalErrors err = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        string customerTypes = string.Empty;
        //        DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
        //        if (fields.IsEditMode)
        //            customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID,NewCustTempFieldLanguage.Description name ,NewCustTempFields.IsMandatory status from NewCustTempFields  inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID =NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID not in (22,23,24,25,26,27,28,29,30) and NewCustTempFieldLanguage.LanguageID={1} ", fields.TempletId, CoreSession.Instance.LanguageId);
        //        else
        //            customerTypes = string.Format(@"select NewCustTempFieldLanguage.NewCustTempFieldID ,NewCustTempFieldLanguage.Description name,staus =0 from NewCustTempFieldLanguage where NewCustTempFieldID not in (21,22,23,24,25,26,27,28,29,30) and  LanguageID = {0}", CoreSession.Instance.LanguageId);

        //       err= dbHelper.GetQueryList(customerTypes, ref generalAddedFields);
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //    }
        //    return err;
        //}

        public GlobalErrors GetAllCustomerGroups(int channelId, int subChannelId, string organizationIds, ref List<CustomerGroupModel> customerGroupObj, bool customersHierarchyMode = false)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string searchFilter = string.Empty;
                if (channelId != -1)
                {
                    searchFilter = string.Format(" And CustomerGroup.ChannelId = {0}", channelId);
                }
                if (subChannelId != -1)
                {
                    searchFilter = string.Format(" And CustomerGroup.SubChannelId = {0}", subChannelId);
                }
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    searchFilter += $" and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                    if (!string.IsNullOrEmpty(organizationIds))
                    {
                        searchFilter += $" And CustomerGroup.OrganizationID in ({organizationIds})";
                    }

                }

                dbHelper = new DBHelper<CustomerGroupModel>();
                string sqlString = string.Format(@"select CustomerGroup.*,CustomerGroupLanguage.Description GroupName,
                                                   IsNull( CustomerGroup.GroupCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerGroupLanguage.Description , '--') as GroupCodeName 
                                                   from CustomerGroup
                                                   left Outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={0}
                                                   Where 1=1 {1}
                                                   ", _requestRepository.LanguageId, searchFilter);

                result = dbHelper.GetQueryList(sqlString, ref customerGroupObj);
                if (result == GlobalErrors.Success && (customerGroupObj != null && customerGroupObj.Count > 0) && customersHierarchyMode)
                {
                    var dbHelperDescription = new DBHelper<TextLanguage>();
                    var descriptionsList = new List<TextLanguage>();
                    var groupIds = customerGroupObj.Select(c => c.SubChannelId).Distinct().ToList();
                    sqlString = $"select GroupID Id,LanguageID,Description from CustomerGroupLanguage --where GroupID in({string.Join(",", groupIds)}) ";
                    result = dbHelperDescription.GetQueryList(sqlString, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        customerGroupObj.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.GroupId).ToList(); return x; }).ToList();
                    }

                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerGroupObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCustomerOperatorList(string outletCode, ref List<CustomerOutletModel> customerOperators)
        {
            DBHelper<CustomerOutletModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerOutletModel>();
                customerOperators = new List<CustomerOutletModel>();
                string sqlString = string.Format(@"SELECT 
                                    Operator.OperatorID,
                                    Operator.OperatorName,
                                    Operator.OperatorPassword,
                                    COL.CustomerID,
                                    COL.OutletID,
                                    IsNull(CO.CustomerCode , '--') + ' - ' + IsNull( COL.Description , '--') as OutletCodeName
                                    FROM Operator 
                                    INNER JOIN CustomerOutletAccess COA ON COA.OperatorID = Operator.OperatorID
                                    INNER JOIN CustomerOutlet CO ON CO.CustomerID = COA.CustomerID AND CO.OutletID = COA.OutletID 
                                    INNER JOIN CustomerOutletLanguage COL ON COL.CustomerID = COA.CustomerID AND COL.OutletID = COA.OutletID AND COL.LanguageID = {0}
                                    INNER JOIN Customer C on C.CustomerID = CO.CustomerID AND C.New <> 1                                    
                                    WHERE LoginTypeID = 2 and CO.CustomerCode <> '{1}'", _requestRepository.LanguageId
                                    , outletCode);

                result = dbHelper.GetQueryList(sqlString, ref customerOperators);
                customerOperators.ForEach(outlet =>
                {
                    if (!string.IsNullOrEmpty(outlet.OperatorPassword))
                    {
                        outlet.OperatorPassword = EncryptionManager.Instance.DecryptPassword(outlet.OperatorPassword.TrimEnd());
                    }
                });
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public static GlobalErrors GetContactConfigurations(ref List<ContactConfiguration> contactConfigurations)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ContactConfiguration> dBHelper = null;
            var query = new StringBuilder();
            try
            {
                dBHelper = new DBHelper<ContactConfiguration>();

                query.AppendFormat(@"Select * from ContactConfiguration");

                result = dBHelper.GetQueryList(query.ToString(), ref contactConfigurations);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetCustomerDiscountsCRM(int customerId, int outletId, ref List<priceListModel> priceLists)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<priceListModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<priceListModel>(_requestRepository.CurrentOperator.EmployeeId);

                string query = string.Format(@"Select distinct CRMPrices.PriceListID  PriceListID ,  P.PriceListCode + ' - ' + PriceListLanguage.Description  PriceListName
                from CRMPrices
                INNER JOIN PriceList P ON P.PriceListID = CRMPrices.PriceListID 
                LEFT JOIN PriceListLanguage on PriceListLanguage.PriceListID = CRMPrices.PriceListID 
				AND PriceListLanguage.LanguageID = {0}
                Where P.IsDeleted = 0 AND CRMPrices.PriceListID IN 
				(Select PriceListID FROM  CustomerPrice Where CustomerID = {1} AND OutletID = {2})", _requestRepository.LanguageId, customerId, outletId);

                result = dBHelper.GetQueryList(query, ref priceLists);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerClasses(ref List<CustomerClassModel> customerClassObj)
        {
            DBHelper<CustomerClassModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerClassModel>();
                string sqlString = string.Format(@"    select CustomerClass.CustomerClassID CustomerClassID,CustomerClass.Code CustomerClassCode,isnull(CustomerClassLanguage.Description,'') CustomerClassName
  ,IsNull( CustomerClass.Code , '--') + ' ' + '-'+ ' ' + IsNull( CustomerClassLanguage.Description , '--') as CustomerClassCodeName
from CustomerClass
   left outer join  CustomerClassLanguage on CustomerClassLanguage.CustomerClassID=CustomerClass.CustomerClassID and CustomerClassLanguage.LanguageID={0}
", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref customerClassObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerClassObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors CheckIfContactDataExists(CustomerOutletContactModel customerOutletContact, ref string errorMessage)
        {
            DBHelper<string> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = new object();
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<string>();
                //Email Check
                if (!string.IsNullOrEmpty(customerOutletContact.Email))
                {
                    query = string.Format(@"Select CASE WHEN '{0}' = Email 
                    THEN (Select DescriptionValue from SonicDescription 
                    where DescriptionKey = 'Desc_Email_Already_Exists' 
                    AND LanguageID = {1}) ELSE '' END AS errorMessage from Contact 
                    where Email = '{0}' AND ContactID <> {2}",
                    customerOutletContact.Email, _requestRepository.LanguageId, customerOutletContact.ContactId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    {
                        errorMessage = field.ToString();
                        return GlobalErrors.Success;
                    }
                }
                //Mobile Check
                if (string.IsNullOrEmpty(errorMessage) && customerOutletContact.Mobile != 0)
                {
                    query = string.Format(@"select CASE WHEN '{0}' = Mobile 
                    THEN (Select DescriptionValue from SonicDescription 
                    where DescriptionKey = 'Desc_Mobile_Already_Exists' 
                    AND LanguageID = {1}) ELSE '' END AS errorMessage from Contact
                    where Mobile = '{0}' AND ContactID <> {2}",
                    customerOutletContact.Mobile, _requestRepository.LanguageId, customerOutletContact.ContactId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    {
                        errorMessage = field.ToString();
                        return GlobalErrors.Success;
                    }
                }
                //Phone Check
                if (string.IsNullOrEmpty(errorMessage) && customerOutletContact.Phone != 0)
                {
                    query = string.Format(@"select CASE WHEN '{0}' = Phone1 
                    THEN (Select DescriptionValue from SonicDescription 
                    where DescriptionKey = 'Desc_Phone_Already_Exists' 
                    AND LanguageID = {1}) ELSE '' END AS errorMessage from Contact
                    where Phone1 = '{0}' AND ContactID <> {2}",
                    customerOutletContact.Phone, _requestRepository.LanguageId, customerOutletContact.ContactId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    {
                        errorMessage = field.ToString();
                        return GlobalErrors.Success;
                    }
                }
                //Fax Check
                if (string.IsNullOrEmpty(errorMessage) && customerOutletContact.Fax != 0)
                {
                    query = string.Format(@"select CASE WHEN '{0}' = Fax 
                    THEN (Select DescriptionValue from SonicDescription 
                    where DescriptionKey = 'Desc_Fax_Already_Exists' 
                    AND LanguageID = {1}) ELSE '' END AS errorMessage from Contact
                    where Fax = '{0}' AND ContactID <> {2}",
                    customerOutletContact.Fax, _requestRepository.LanguageId, customerOutletContact.ContactId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    {
                        errorMessage = field.ToString();
                        return GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetCustomerData(int customerId, ref CustomerModel customerObj)
        {
            return GetCustomerData(customerId, false, ref customerObj);
        }
        public GlobalErrors GetCustomerData(int customerId, bool showInActive, ref CustomerModel customerObj)
        {
            DBHelper<CustomerModel> dbHelper = null;
            DBHelper<AccountModel> dbHelperAccount = null;
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<ItemPackModel> dBHelperCustomerPacks = null;

            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<CustomerModel>();
                dBHelper_Languages = new DBHelper<TextLanguage>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                string outletFilter = "";
                if (customerObj.OutletId > 0)
                {
                    outletFilter = String.Format(" and Co.OutletID = {0}", customerObj.OutletId);
                }
                string sqlString = string.Format(@"select customer.*,Customer.CustomerCollector AS CollectorId,isnull(CustomerLanguage.Description,'') CustomerName,isnull(CurrencyLanguage.Description,'') CurrencyDescription ,E.EmployeeId 
                                                   from customer
                                                   left outer join  CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1} and CustomerLanguage.OrganizationId in ({3})
                                                   left outer join CurrencyLanguage on CurrencyLanguage.CurrencyID=Customer.CurrencyID and CurrencyLanguage.LanguageID={1}
                                                   left join CustomerOutlet CO on Co.CustomerID = Customer.CustomerID
                                                   left join Employee E on E.CustomerID = Customer.CustomerID and Co.OutletID = E.OutletID
                                                   where Customer.CustomerID={0} {2}", customerId, _requestRepository.LanguageId, outletFilter, _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQuerySingle(sqlString, ref customerObj);
                if (result == GlobalErrors.Success)
                {
                    sqlString = string.Format(@"select * from CustomerLanguage where CustomerID={0} and CustomerLanguage.OrganizationId in ({1})", customerId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper_Languages.GetQueryList(sqlString, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        customerObj.DescriptionLanguages = descriptions;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelperAccount = new DBHelper<AccountModel>();
                    List<AccountModel> accountsList = new List<AccountModel>();
                    string orgAccFilter = string.Empty;
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccFilter = string.Format(" and Organization.OrganizationId in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                    sqlString = string.Format(@" select Account.*,
                    IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName,
                    IsNull( Currency.Code , '--') + ' ' + '-'+ ' ' + IsNull( CurrencyLanguage.Description , '--') as CurrencyCodeName
                    from Account
                    inner join AccountCust on AccountCust.AccountID = Account.AccountID and AccountCust.CustomerID = {0} 
                    inner join Organization on Organization.OrganizationID = Account.OrganizationID
                    inner join Currency ON Account.CurrencyId =  Currency.CurrencyId
                    Left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID And OrganizationLanguage.LanguageID = {1}
                    Left join CurrencyLanguage ON Account.CurrencyId = CurrencyLanguage.CurrencyId   And CurrencyLanguage.LanguageID = {1}                 
                    Where 1=1 {2}",
                    customerId, //0
                    _requestRepository.LanguageId, //1
                    orgAccFilter //2
                    );
                    result = dbHelperAccount.GetQueryList(sqlString, ref accountsList);
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                    if (accountsList != null)
                    {
                        customerObj.AccountsList = accountsList;
                        customerObj.AccountsList.ForEach(a =>
                        {
                            a.AccountLevel = CustomerAccountLevel.CustomerAccount;
                            a.DataAction = DataActions.Edit;
                            if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                            {
                                a.isCollapsed = true;
                            }
                        });
                    }
                    if (result == GlobalErrors.Success)
                    {
                        GeneralFilter filter = new GeneralFilter();
                        filter.CustomerId = customerId;
                        List<CustomerOutletModel> outlets = new List<CustomerOutletModel>();
                        CustomerOutletModel outletdummy = new CustomerOutletModel();
                        List<string> table = new List<string>();
                        result = GetSelectedCustomerOutlets(filter, showInActive, ref outlets);

                        if(result == GlobalErrors.Success)
                        {
                            foreach (CustomerOutletModel outlet in outlets)
                            {
                           var isValid = IsValidToDeleteCustomer(customerId, outlet.OutletId,ref customerObj, ref outletdummy, ref table);
                                if (isValid == GlobalErrors.Error)
                                    outlet.isValidDelete = false;
                            }
                        }

                        if (result == GlobalErrors.Success)
                        {
                            customerObj.Outlets = outlets;
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dBHelperCustomerPacks = new DBHelper<ItemPackModel>();

                    List<ItemPackModel> customerBarcodeList = new List<ItemPackModel>();
                    sqlString = string.Format(@"select CustomerPackBarcode.CustomerID,CustomerPackBarcode.PackID, CustomerPackBarcode.Barcode as CustomerPackBarcode,
                        pack.ItemID
                        from CustomerPackBarcode
                        Inner join pack on pack.PackID = CustomerPackBarcode.PackID where customerID = {0}", customerId);
                    result = dBHelperCustomerPacks.GetQueryList(sqlString, ref customerBarcodeList);
                    if (result == GlobalErrors.Success && customerBarcodeList != null && customerBarcodeList.Count > 0)
                    {
                        customerObj.CustomerPackBarcodeList = customerBarcodeList;
                    }

                }

                if (!String.IsNullOrEmpty(LocalUtilities.CustomerAttachments) && Directory.Exists(Path.Combine(LocalUtilities.CustomerAttachments, customerObj.CustomerId.ToString())) &&
                    !String.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy) && Directory.Exists(LocalUtilities.CustomerAttachmentsDummy))
                {
                    string customersDummyAttachmentFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId);
                    if (Directory.Exists(customersDummyAttachmentFolderPath))
                        Directory.Delete(customersDummyAttachmentFolderPath, true);
                    Directory.CreateDirectory(customersDummyAttachmentFolderPath);
                    foreach (CustomerOutletModel outlet in customerObj.Outlets)
                    {
                        outlet.OutletAttachments = GetOutletAttachments(ref customerObj, outlet.OutletId.ToString());
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (dbHelperAccount != null)
                {
                    dbHelperAccount.Dispose();
                    dbHelperAccount = null;
                }
            }
            return result;
        }

        public GlobalErrors GetCustomerInfoHistory(CustomerFilter filter, ref List<FieldHistory> custOutList)
        {
            DBHelper<FieldHistory> dbHelper = null;
            custOutList = new List<FieldHistory>();
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<FieldHistory>();
                var query = string.Format(@"Select CustomerOutletHistory.*  , EmployeeLanguage.Description EmployeeName
                from CustomerOutletHistory 
                LEFT JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID = CustomerOutletHistory.ChangedBy AND LanguageID = {0}
                where CustomerID = {1} AND OutletID = {2} Order by ChangeDate desc", _requestRepository.LanguageId, filter.CustomerId, filter.OutletId);
                result = dbHelper.GetQueryList(query, ref custOutList);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetAddressHistory(CustomerFilter filter, ref List<AddressHistory> addressHistories)
        {
            DBHelper<AddressHistory> dbHelper = null;
            addressHistories = new List<AddressHistory>();
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<AddressHistory>();
                var query = string.Format(@"Select CustOutAddressHistory.*  ,EmployeeLanguage.Description EmployeeName
                from CustOutAddressHistory
                LEFT JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID = CustOutAddressHistory.ChangedBy AND LanguageID = {0}
                where CustomerID = {1} AND OutletID = {2} order by CustOutAddressHistory.ChangeDate desc", _requestRepository.LanguageId, filter.CustomerId, filter.OutletId);
                result = dbHelper.GetQueryList(query, ref addressHistories);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerLanguages(int customerId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>(_requestRepository.CurrentOperator.EmployeeId);
                string query = string.Format(@"Select * from CustomerLanguage where CustomerId = {0}", customerId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerList(OrderListFilter filter, bool getAll, ref SharedTableResult<CustomerModel> custList)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            custList = new SharedTableResult<CustomerModel>();
            DBHelper<CustomerModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<CustomerModel>();
                //filter.Page = 1;
                //filter.PageSize = 100;
                dbHelper = new DBHelper<CustomerModel>();
                string searchFilter = string.Empty;
                string supervisionJoin = string.Empty;
                string vendingMachineCondition = string.Empty;
                string terrJoin = string.Empty;
                string RouteJoin = string.Empty;
                string CustomerStatusJoin = string.Empty;
                string orgCheck = string.Empty;
                string OuterApplyJoin = string.Empty;
                string orgJoinName = string.Empty;
                StringBuilder orgJoin = new StringBuilder();
                string orderByFilter = "Order By Customer.CustomerCode";

                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID =  Customer.CustomerID 
                                                           INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                                                       _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    if (filter.CustomListFilter.TerritoryId > 0)
                    {
                        supervisionJoin = string.Format(@"{0} and EmployeeTerritory.TerritoryID IN ({1}) ",
                                  supervisionJoin, filter.CustomListFilter.TerritoryId);
                    }
                }
                if (filter != null)
                {

                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and (
                                (Customer.CustomerCode LIKE '%{0}%')
                            OR ( CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1}))
                            OR ( Customer.Phone LIKE '%{0}%') 
                            OR ( Customer.Fax LIKE '%{0}%') 
                            OR ( Customer.Email LIKE '%{0}%')
                            OR (outlet.CustomerCode LIKE '%{0}%')
                            OR (outlet.Description LIKE '%{0}%'))"
                         , filter.CustomListFilter.SearchFilter.Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                    if (filter.CustomerId > 0)
                    {
                        searchFilter += string.Format(@" And customer.CustomerID = {0}", filter.CustomerId);
                    }
                   
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By CustomerCode");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }

                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgJoin.AppendFormat(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", _requestRepository.CurrentOperator.OrganizationAccess);

                //    if (filter.OrganizationId != -1)
                //    {
                //        if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                //        {
                //            orgCheck = string.Format(@" AND Customer.OrganizationID = {0}", filter.OrganizationId);                            
                //        }
                //        else
                //        {
                //            orgCheck = string.Format(@" AND Account.OrganizationID = {0}", filter.OrganizationId);    
                            
                //        }
                //    }
                //}
             
           
                if (filter.CustomerStatusId != -1)
                {
                    CustomerStatusJoin = string.Format(@" AND outlet.CustomerStatusID = {0}", filter.CustomerStatusId);
                }

                if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                {
                    orgJoinName = "Customer";
                }
                else
                {

                    orgJoinName = "Customer";

                    //     orgJoinName = "org";
                    //     OuterApplyJoin = @"OUTER APPLY (SELECT CASE WHEN count(*) > 1 then -1 else  max(OrganizationID)
                    //END as OrganizationID from (SELECT DISTINCT OrganizationID from Account 
                    //inner JOIN AccountCust ON AccountCust.AccountID = Account.AccountID 
                    //WHERE AccountCust.CustomerID = Customer.CustomerID)tt) org";
                }

                string mainQuery = string.Format(@"Select distinct Customer.CustomerID ,Customer.CustomerCode ,CustomerLanguage.Description as CustomerName , CustomerLanguage.Address Address, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName, Customer.Phone as Phone, Customer.PaymentTermID ,CASE WHEN vending.countCust > 0 THEN 1 ELSE 0 END ShowStockBtn,
                                                    IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                                                   from Customer
                                                   Inner join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and languageid = {0}
                                                   and CustomerLanguage.OrganizationId in ({13})
                                                   inner join CustomerOrganization ON CustomerOrganization.Customerid = Customer.CustomerID  
                                                   {1} {4} 
                                                   {10}
                                                   LEFT OUTER JOIN Organization ON Organization.OrganizationID = CustomerOrganization.OrganizationID   
                                                   LEFT OUTER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = Organization.OrganizationID 
												   AND OrganizationLanguage.LanguageID = {0}
                                                   {7}
                                                   {8}                                            
                                                   left join ( select CustomerID,count(*) countCust from CustomerOutlet  where IsVendingMachine = 1 group by CustomerID
								                   )vending on vending.CustomerID = Customer.CustomerID

                                                   left join (select CustomerOutlet.CustomerID,CustomerOutlet.CustomerCode,CustomerOutletLanguage.Description , CustomerOutlet.CustomerStatusID from CustomerOutlet 
                                                   left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {0}
                                                   )outlet on outlet.CustomerID = Customer.CustomerID
                                                                     
                                                   where Customer.Inactive<> 1 and New<> 1 {2} {3} and Customer.CustomerID <> {5} {12} {6}",
                                                   _requestRepository.LanguageId,
                                                   orgJoin, orgCheck, searchFilter,
                                                   supervisionJoin, LocalUtilities.GestCustomerId,
                                                   vendingMachineCondition, terrJoin, RouteJoin,
                                                    ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organizations, _requestRepository.LanguageId) , OuterApplyJoin ,
                                                    orgJoinName , CustomerStatusJoin, _requestRepository.CurrentOperator.OrganizationAccess);

                string customerQuery = string.Empty;
                Stopwatch st = new Stopwatch();
                if (!getAll)
                {
                    customerQuery = string.Format(@"{0} {1}
                                    OFFSET     {2} ROWS
                                    FETCH NEXT {3} ROWS ONLY", mainQuery, orderByFilter, (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, filter.CustomListFilter.PageSize);

                    var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery.ToString());
                    object objField = 0;
                    err = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                    if (err == GlobalErrors.Success && objField != null)
                    {
                        custList.TotalItems = int.Parse(objField.ToString().Trim());
                        if (custList.TotalItems <= 0)
                        {
                            return GlobalErrors.NoMoreRows;
                        }
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }
                }
                else
                {
                    customerQuery = string.Format(@"{0} {1}", mainQuery, orderByFilter);
                }
                st.Start();
                List<CustomerModel> customerModel = new List<CustomerModel>();
                err = dbHelper.GetQueryList(customerQuery, ref customerModel , true);
                custList.Data = customerModel;
                st.Stop();
                long i = st.ElapsedMilliseconds;
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors GetICashCustomersList(icashFilter filter, ref SharedTableResult<ICashModel> icashSharedList)
        {
            icashSharedList = new SharedTableResult<ICashModel>();
            List<ICashModel> icashList = new List<ICashModel>();
            DBHelper<ICashModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object Count = 0;
                dbHelper = new DBHelper<ICashModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;

                var icashQuery = new StringBuilder(@"SELECT DISTINCT 
                                    ROW_NUMBER() Over(Order By I.iCashListCode ) AS RowSeq ,      
                                    I.iCashListID,
                                    I.iCashListCode ICashCode,
                                    I.StartDate StartDate,
                                    I.EndDate EndDate ,
                                    (O.OrganizationCode + ' - ' + OL.Description) OrganizationCodeName
                                    FROM dbo.ICash  I
                                    INNER JOIN Organization O ON O.OrganizationID = I.OrganizationID and O.OrganizationID in ({2})
                                    LEFT JOIN OrganizationLanguage OL ON OL.OrganizationID = O.OrganizationID AND OL.LanguageID = {0}
                                    Where  1 = 1 ").Replace("{0}", Convert.ToString(_requestRepository.LanguageId)).Replace("{2}", _requestRepository.CurrentOperator.OrganizationAccess);

                if (filter.FromToDate != null && filter.FromToDate.Count > 0)
                {
                    icashQuery.Append(@" and  I.StartDate >= "
                        + LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)) +
                        " and  I.EndDate <= " + LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)));

                }
                if (!string.IsNullOrWhiteSpace(filter.CustomListFilter.SearchFilter))
                {
                    icashQuery.Append(@" AND ((I.iCashListCode LIKE '%" + filter.CustomListFilter.SearchFilter + "%')" +
                                        "OR (I.StartDate LIKE '%" + filter.CustomListFilter.SearchFilter + "%')" +
                                        "OR (I.EndDate LIKE '%" + filter.CustomListFilter.SearchFilter + "%')" +
                                        "OR (O.OrganizationCode LIKE '%" + filter.CustomListFilter.SearchFilter + "%')" +
                                        "OR (OL.Description LIKE '%" + filter.CustomListFilter.SearchFilter + "%'))");
                }
                if (!filter.IsInactive)
                {
                    icashQuery.Append(@"AND Inactive = 0 ");
                }
                if (!string.IsNullOrWhiteSpace(filter.CustomListFilter.SortBy))
                {
                    icashQuery.Append(@"Order By " + filter.CustomListFilter.SortBy);
                    icashQuery.Append(filter.CustomListFilter.IsSortAscending ? " ASC " : " DESC ");
                }
                else
                {
                    icashQuery.Append(@"Order By  I.iCashListID ");
                }
                icashQuery.AppendLine(@"OFFSET  {Rows} ROWS  
                                    FETCH NEXT {Count} ROWS ONLY")
                    .Replace("{Rows}", Convert.ToString((filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize))
                    .Replace("{Count}", Convert.ToString(filter.CustomListFilter.PageSize));

                string countQuery = string.Format(@"select IsNull(Count(*),0)  FROM dbo.ICash  I
                                    INNER JOIN Organization O ON O.OrganizationID = I.OrganizationID
                                    LEFT JOIN OrganizationLanguage OL ON OL.OrganizationID = O.OrganizationID AND OL.LanguageID = {0} ",
                                    _requestRepository.LanguageId);

                result = dbHelper.ExecuteScalar(countQuery, ref Count , true);

                result = dbHelper.GetQueryList(icashQuery.ToString(), ref icashList , true);
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(Count.ToString()))
                {
                    icashSharedList.TotalItems = int.Parse(Count.ToString().Trim());
                    if (icashSharedList.TotalItems >= 0)
                    {
                        icashSharedList.Data = icashList;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                icashSharedList.Data = icashList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                icashSharedList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetICashMasterData(int icashListID, ref ICashModel data)
        {
            DBHelper<ICashModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ICashModel>();
                string query = string.Format(@"SELECT I.iCashListID,I.iCashListCode ICashCode,I.OrganizationID  OrganizationID,I.StartDate,I.EndDate,I.Inactive IsInactive FROM ICash I WHERE iCashListID = {0}", icashListID);
                result = dBHelper.GetQuerySingle(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;

            }
            return result;

        }

        public GlobalErrors GetICashDetailsData(int icashListID, ref List<ICashDetailsModel> data)
        {
            DBHelper<ICashDetailsModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ICashDetailsModel>();
                string query = string.Format(@"SELECT ICD.iCashListID iCashListID ,ICD.InputDetail AmountToBuy,ICD.OutputDetail AmountToGet FROM ICashDetails ICD WHERE iCashListID  =  {0}", icashListID);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;

            }
            return result;

        }
        public GlobalErrors GetICashCustomerChannelData(int icashListID, ref List<CustomerChannelModel> data)
        {
            DBHelper<CustomerChannelModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"SELECT ICA.iCashListID,ICA.AssignmentID ,ICA.ChannelID ,ICA.SubChannelID,
               (CONVERT(varchar(10),ICA.ChannelID) + '-' + CONVERT(varchar(10),ICA.SubChannelID)) ChannelSubChannelIds ,
               (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
               FROM ICashAssignment ICA
               Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = ICA.ChannelID and ChannelLanguage.LanguageID = {1}
               left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = ICA.SubChannelID and SubChannelLanguage.LanguageID = {1}
               where ICA.iCashListID = {0}", icashListID, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;

            }
            return result;

        }
        public GlobalErrors GetICashCustomerGroupData(int icashListID, ref List<CustomerGroupModel> data)
        {
            DBHelper<CustomerGroupModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                dBHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"select ICA.iCashListID ,ICA.GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                               from ICashAssignment ICA
                                               inner join CustomerGroup on CustomerGroup.GroupID=ICA.GroupID {2}
                                               left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                               where ICA.iCashListID = {0}", icashListID, _requestRepository.LanguageId, orgAccess);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;

            }
            return result;

        }
        public GlobalErrors GetICashSimpleCustomerData(int icashListID, ref List<SimpleCustomerModel> data)
        {
            DBHelper<SimpleCustomerModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                string query = string.Format(@"select ICA.iCashListID ,ICA.CustomerID ,ICA.OutletID ,
                                               Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                                               ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                                               from ICashAssignment ICA
                                               inner join Customer on Customer.CustomerID=ICA.CustomerID
                                               inner join CustomerOutlet on CustomerOutlet.CustomerID=ICA.CustomerID and CustomerOutlet.OutletID=ICA.OutletID 
                                               left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                                               left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                                               and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                                               and CustomerOutletLanguage.LanguageID = {1}
                                               {2}
                                               where ICA.iCashListID = {0}", icashListID, _requestRepository.LanguageId, orgAccessJoin);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;

            }
            return result;

        }


        public GlobalErrors GetSelectedCustomerOutlets(GeneralFilter filter, bool showInActive, ref List<CustomerOutletModel> custOutList)
        {
            custOutList = new List<CustomerOutletModel>();

            DBHelper<CustomerOutletModel> dbHelper = null;
            DBHelper<AccountModel> dbHelperAccount = null;
            DBHelper<SalesDistributionChannelModel> dbHelperSDC = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                string filterInActive = "and CO.Inactive <> 1   ";
                dbHelper = new DBHelper<CustomerOutletModel>();
                var customerOutletQuery = string.Format(@"select CO.*,co.IsHiglighted IsHighlighted, CO.CustomerID , CO.OutletID ,CO.CustomerCode OutletCode ,CL.Description as OutletName
                                        , IsNull(CO.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CL.Description , '--') as OutletCodeName,
                                        IsNull(Operator.OperatorId, -1)OperatorId, Operator.OperatorName, Operator.OperatorPassword, IsNull(Operator.IsLocked, 0) IsLockedOperator
                                        ,CASE WHEN tt.accountCount > 1 THEN 1 ELSE 0 END MatchWithExistsOperator, CO.CurrencyID, ISNULL(Warehouse.OrganizationID,-1) WarehouseOrganizationID ,  CO.CustomerStatusID
                                        from CustomerOutlet  CO
                                        Inner join CustomerOutletLanguage CL on CO.CustomerID = CL.CustomerID and CO.OutletID = CL.OutletID and languageid = 1
                                        left join CustomerOutletAccess on CustomerOutletAccess.CustomerId = CO.CustomerID and CustomerOutletAccess.OutletID = CO.OutletID
                                        left join Operator on Operator.OperatorId = CustomerOutletAccess.OperatorId and Operator.LoginTypeId = {2}
                                        left outer join (select OperatorID, COUNT(*) accountCount from CustomerOutletAccess group by OperatorID ) tt on tt.OperatorID = Operator.OperatorID
                                        LEFT JOIN Warehouse ON Warehouse.WarehouseID = CO.WarehouseID
                                        where  CO.CustomerID in ({0}) {1}
                                        order by  CO.CustomerID , CO.OutletID", filter.CustomerId, showInActive ? "" : filterInActive, OperatorType.Customer.GetHashCode());

                result = dbHelper.GetQueryList(customerOutletQuery, ref custOutList);

                if (result == GlobalErrors.Success && custOutList != null && custOutList.Count > 0)
                {
                    #region[Decrypt Operator Password]
                    custOutList.ForEach(outlet =>
                    {
                        if (!string.IsNullOrEmpty(outlet.OperatorPassword))
                        {
                            outlet.OperatorPassword = EncryptionManager.Instance.DecryptPassword(outlet.OperatorPassword.TrimEnd());
                        }
                    });
                    #endregion

                    #region [Accounts]
                    dbHelperAccount = new DBHelper<AccountModel>();
                    foreach (CustomerOutletModel outlet in custOutList)
                    {
                        List<AccountModel> accountsListForOutlet = new List<AccountModel>();
                        outlet.AccountsList = new List<AccountModel>();
                        string orgAccFilter = string.Empty;
                        if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            orgAccFilter = string.Format(" and Organization.OrganizationId in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                        }
                        if (!_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                        {
                            customerOutletQuery = string.Format(@" Select Account.*, 
                            IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName 
                            from Account
                            inner join AccountCustOut on AccountCustOut.AccountID = Account.AccountID and AccountCustOut.CustomerID = {0} And AccountCustOut.OutletID = {1}
                            inner join Organization on Organization.OrganizationID = Account.OrganizationID
                            Left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID And OrganizationLanguage.LanguageID = {2}
                            Where 1=1 {3}",
                            outlet.CustomerId, //0
                            outlet.OutletId, //1
                            _requestRepository.LanguageId, //2
                            orgAccFilter //3
                            );
                            result = dbHelperAccount.GetQueryList(customerOutletQuery, ref accountsListForOutlet);
                        }
                        else
                        {
                            customerOutletQuery = string.Format(@" Select distinct Account.*, Division.DivisionId,
                            IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName,
                            IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName,
                            Case when Division.DivisionId not in ({4}) Then 1 else 0 End As IsHidden
                            From Account
                            inner join AccountCustOutDiv on AccountCustOutDiv.AccountID = Account.AccountID and AccountCustOutDiv.CustomerID = {0} And AccountCustOutDiv.OutletID = {1}
                            inner join Division on Division.DivisionID = AccountCustOutDiv.DivisionID                            
                            Left Outer join Divisionlanguage on  Division.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {2}
                            inner join Organization on Organization.OrganizationID = Account.OrganizationID
                            Left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID And OrganizationLanguage.LanguageID = {2}
                            Where 1=1 {3}",
                            outlet.CustomerId, //0
                            outlet.OutletId, //1
                            _requestRepository.LanguageId, //2
                            orgAccFilter, //3
                            _requestRepository.CurrentOperator.DivisionAccess //4
                            );
                            result = dbHelperAccount.GetQueryList(customerOutletQuery, ref accountsListForOutlet);
                        }
                        if (result == GlobalErrors.Success && accountsListForOutlet != null && accountsListForOutlet.Count > 0)
                        {
                            outlet.AccountsList = accountsListForOutlet;
                            outlet.AccountsList.ForEach(a =>
                            {
                                a.AccountLevel = _requestRepository.Configurations.ControlTransactionOnDivisionLevel ? CustomerAccountLevel.DivisionAccount : CustomerAccountLevel.OutletAccount;
                                a.DataAction = DataActions.Edit;
                            });
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    #endregion

            
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                return GlobalErrors.Error;
            }
            finally
            {
               
                if (dbHelperAccount != null)
                {
                    dbHelperAccount.Dispose();
                    dbHelperAccount = null;
                }
            }
        }

        public GlobalErrors updateCustomerOrg(int customerId, int outletId, int organizationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                string query = string.Format(@"update Account set OrganizationID = {0} from Account inner join AccountCust
                on AccountCust.AccountID = Account.AccountID where AccountCust.CustomerID = {1}", organizationId, customerId);
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"update Account set OrganizationID = {0}
                        from Account 
                        inner join AccountCustOut on AccountCustOut.AccountID = Account.AccountID  where AccountCustOut.CustomerID = {1} and  AccountCustOut .OutletID = {2}", organizationId, customerId, outletId);
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"update Account set OrganizationID = {0}
                        from Account 
                        inner join AccountCustOutDiv on AccountCustOutDiv.AccountID = Account.AccountID where AccountCustOutDiv.CustomerID ={1} and  AccountCustOutDiv .OutletID = {2}", organizationId, customerId, outletId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerOutlets(GeneralFilter filter, ref List<CustomerOutletModel> custOutList)
        {
            custOutList = new List<CustomerOutletModel>();

            DBHelper<CustomerOutletModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                string territoryFilterJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string supervisionJoin = string.Empty;
                string onHoldFilter = string.Empty;
                string collectionFilter = string.Empty;
                string collectionCondition = string.Empty;
                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                //}
                if (filter.TerritoryId > 0)
                {
                    if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        territoryFilterJoin += string.Format(@" INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = CO.CustomerID 
                    AND CustOutTerritory.OutletID = CO.OutletID AND CustOutTerritory.TerritoryID = {0}", filter.TerritoryId);
                    }
                    else
                    {
                        territoryFilterJoin += string.Format(@"
									inner join RouteCustomer on RouteCustomer.CustomerID=CO.CustomerID  and RouteCustomer.OutletID = CO.OutletID
									inner join Route routeCust  on routeCust.RouteID=RouteCustomer.RouteID and routeCust.TerritoryID={0} ", filter.TerritoryId);
                    }
                }
                if (filter.ExcludeOnHold)
                {
                    onHoldFilter = " and CO.OnHold <> 1";
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    if (filter.TerritoryId > 0 && _requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        supervisionJoin = string.Format(@"INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                       _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                    else
                    {
                        supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = CO.CustomerID AND CustOutTerritory.OutletID = CO.OutletID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                        _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                }
                if (filter.GetChattingCustomers && filter.EmployeeId != -1)
                {
                    territoryFilterJoin = string.Format(@" 
                    inner join CustOutTerritory on CustOutTerritory.CustomerID = customer.CustomerID
                    inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeID = {0} ", filter.EmployeeId);
                }
                if (filter.IsFromCollection)
                {
                    collectionFilter = string.Format(@" inner join [Transaction] T on T.CustomerID = CO.CustomerID and	T.OutletID = CO.OutletID 
                    left outer join RouteHistory on RouteHistory.RouteHistoryID = T.RouteHistoryID");
                    collectionCondition += string.Format(" And (RouteHistory.Uploaded is null OR RouteHistory.Uploaded = 0) And (T.Voided is null OR T.Voided = 0) And (T.RemainingAmount > 0) And (T.TransactionTypeID in (1, 3, 6))");
                }
                dbHelper = new DBHelper<CustomerOutletModel>();
                var customerOutletQuery = string.Format(@"select Distinct CO.*, CO.CustomerID , CO.OutletID ,CO.CustomerCode OutletCode ,CO.Taxeable Taxable, CL.Description as OutletName, IsNull(CO.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CL.Description , '--') as OutletCodeName
                from CustomerOutlet  CO
                Inner join CustomerOutletLanguage CL on CO.CustomerID = CL.CustomerID and CO.OutletID = CL.OutletID and languageid = {0}
                {1} {4} {2}  {6}
                where  CO.CustomerID in ({3}) and CO.Inactive <> 1 {5} {7}
                order by  CO.CustomerID , CO.OutletID",
                _requestRepository.LanguageId, //0
                territoryFilterJoin, //1
                orgAccessJoin.ToString(), //2
                filter.CustomerId, //3
                supervisionJoin, //4
                onHoldFilter, //5
                collectionFilter, //6
                collectionCondition //7
                );
                result = dbHelper.GetQueryList(customerOutletQuery, ref custOutList);
                if (result == GlobalErrors.Success && custOutList != null && custOutList.Count > 0 && filter.GenerateMoreInfoLink && filter.MoreInfoDashboardId > 0)
                {
                    DashboardManager dashboardManager = new DashboardManager(_requestRepository);
                    custOutList.ForEach(c =>
                    {
                        c.ExtraInfoLink = LocalUtilities.DashboardURL +
                        "?id="
                        + EncryptionManager.Instance.EncryptData(string.Format(dashboardManager.GenerateDashboardSignature(string.Empty, c.CustomerId.ToString(), c.OutletId.ToString()), filter.MoreInfoDashboardId)).Replace('+', '*');
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custOutList = null;
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;

        }

        public GlobalErrors GetCustomerCommnet(int CustomerID, ref List<CustomerComment> customerCommnets)
        {


            DBHelper<CustomerComment> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerComment>();
                var customerCommentQuery = string.Format(@"select * from comment where CustomerID = {0}  and Notes NOT LIKE  '' ", CustomerID);
                result = dbHelper.GetQueryList(customerCommentQuery, ref customerCommnets);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerCommnets = null;
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;

        }

        public GlobalErrors addCustomerCommnet(int CustomerID,String Comment)
        {


            DBHelper<CustomerComment> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerComment>();
                var customerCommentQuery = string.Format(@"Insert into Comment (CustomerID,EmployeeId,CommentDate,Notes,CommentTypeID) 
                values({0},{1}, GETDATE(),'{2}',-1 )", CustomerID,_requestRepository.CurrentOperator.EmployeeId,Comment);
                result = dbHelper.ExecuteNonQuery(customerCommentQuery);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;

        }

        public GlobalErrors GetCustomerSubClasses(ref List<CustomerSubClassModel> customerSubClassObj)
        {
            DBHelper<CustomerSubClassModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerSubClassModel>();
                string sqlString = string.Format(@"select CustomerSubClass.CustomerSubClassID CustomerSubClassID,CustomerSubClass.Code CustomerSubClassCode,isnull(CustomerSubClassLanguage.Description,'') CustomerSubClassName
  ,IsNull( CustomerSubClass.Code , '--') + ' ' + '-'+ ' ' + IsNull( CustomerSubClassLanguage.Description , '--') as CustomerSubClassCodeName
from CustomerSubClass
   left outer join  CustomerSubClassLanguage on CustomerSubClassLanguage.CustomerSubClassID=CustomerSubClass.CustomerSubClassID and CustomerSubClassLanguage.LanguageID={0}
", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref customerSubClassObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerSubClassObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetCustomerStatus(ref List<CustomerStatusModel> customerStatusObj, int languageID)
        {
            DBHelper<CustomerStatusModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerStatusModel>();
                string sqlString = string.Format(@"
				SELECT DISTINCT CustomerStatusDefinition.CustomerStatusID , CustomerStatusLanguage.Description as CustomerStatusName , tt.OrganizationID  FROM CustomerStatusDefinition
				INNER JOIN CustomerStatusLanguage ON CustomerStatusLanguage.CustomerStatusID =CustomerStatusDefinition.CustomerStatusID and CustomerStatusLanguage.LanguageID = {0}
				outer apply (  SELECT CASE WHEN count(org.OrganizationID) > 1 then STRING_AGG(CAST(org.OrganizationID AS NVARCHAR(MAX)), ',')  else  CAST(MAX(org.OrganizationID) AS NVARCHAR(MAX)) 
				end as OrganizationID  from (select distinct
				OrganizationID from CustomerStatusOrganizations  where CustomerStatusID = CustomerStatusDefinition.CustomerStatusID)org  )tt  
				WHERE 1=1", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref customerStatusObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerStatusObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCustomerTypes(ref List<CustomerTypeModel> customerTypesObj, int languageID)
        {
            DBHelper<CustomerTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerTypeModel>();
                string sqlString = string.Format(@"select CustomerType.CustomerTypeID , CustomerTypeLanguage.Description as CustomerTypeName
                                                    from CustomerType
                                                    left outer join  CustomerTypeLanguage on CustomerTypeLanguage.CustomerTypeID=CustomerType.CustomerTypeID and CustomerTypeLanguage.LanguageID={0} ",
                                                    languageID);
                result = dbHelper.GetQueryList(sqlString, ref customerTypesObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerTypesObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetOutletContacts(int customerId, int outletId, ref List<CustomerContact> contacts)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerContact> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerContact>(_requestRepository.CurrentOperator.EmployeeId);
                string query = string.Format(@"Select ContactCountry.PrefixCode, CustomerOutletContact.*, CustomerOutletContact.Email as ContactEmail, CustomerOutletContactLangauge.Description ContactName from CustomerOutletContact
                inner join ContactCountry on ContactCountry.CountryId = CustomerOutletContact.CountryId
                inner join CustomerOutletContactLangauge on  CustomerOutletContact.ContactId = CustomerOutletContactLangauge.ContactId 
                and CustomerOutletContact.CustomerId = CustomerOutletContactLangauge.CustomerId 
                and CustomerOutletContact.OutletId = CustomerOutletContactLangauge.OutletId and CustomerOutletContactLangauge.LanguageId = {2}
                where CustomerOutletContact.CustomerId = {0} And CustomerOutletContact.OutletId = {1}", customerId, outletId,_requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref contacts);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetOutletData(int customerId, int outletId, bool hasPrivilegeOnPaymentTermDivision, bool hasPrivilegeOnOnHoldDivision, ref CustomerOutletModel outletObj)
        {
            DBHelper<CustomerOutletModel> dbHelper = null;
            DBHelper<CustomerOutletContactModel> contactsDBHelper = null;
            DBHelper<TextLanguage> dbHelper_Language = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<CustomerOutletContactModel> contactsList = new List<CustomerOutletContactModel>();
                List<CustomerOutletContactModel> sortedContactsList = new List<CustomerOutletContactModel>();
                CustomerOutletContactModel customerOutletContact = new CustomerOutletContactModel();
                List<TextLanguage> contactAddressesDescriptions = new List<TextLanguage>();
                List<TextLanguage> contactNamesDescriptions = new List<TextLanguage>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                TextLanguage text = new TextLanguage();
                dbHelper = new DBHelper<CustomerOutletModel>();
                contactsDBHelper = new DBHelper<CustomerOutletContactModel>();
                dbHelper_Language = new DBHelper<TextLanguage>();
                string sqlString = string.Format(@"    select customerOutlet.BillsOpenNumber billsNumber, customerOutlet.*,customerOutlet.IsHiglighted IsHighlighted,customerOutlet.Taxeable  Taxable,customerOutlet.CustomerCode OutletCode,isnull(CustomerOutletLanguage.Description,'') OutletName,  CustomerOutletLanguage.Address Address,CustomerOutletLanguage.Address2 Address2, ISNULL(Warehouse.OrganizationID, -1) WarehouseOrganizationId from CustomerOutlet
   left outer join  CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID={2}
   LEFT JOIN Warehouse On Warehouse.WarehouseID = customerOutlet.WarehouseID
where customerOutlet.CustomerID={0} and customerOutlet.OutletID={1}", customerId, outletId, _requestRepository.LanguageId);

                result = dbHelper.GetQuerySingle(sqlString, ref outletObj);
                if (result == GlobalErrors.Success)
                {
                    outletObj.HasPrivilegeOnPaymentTermDivision = hasPrivilegeOnPaymentTermDivision;
                    outletObj.HasPrivilegeOnOnHoldDivision = hasPrivilegeOnOnHoldDivision;
                    sqlString = string.Format(@"Select * from CustomerOutletLanguage where CustomerID={0} and OutletID={1}", customerId, outletId);
                    result = dbHelper_Language.GetQueryList(sqlString, ref descriptions);
                    outletObj.DescriptionLanguages = descriptions;
                }
                #region[Addresses]
                if (result == GlobalErrors.Success)
                {
                    DBHelper<TextLanguage> addressDBHelper = new DBHelper<TextLanguage>();
                    List<TextLanguage> outletAddresses = new List<TextLanguage>();
                    sqlString = string.Format(@"Select Address Description, LanguageID from CustomerOutletLanguage where CustomerID={0} and OutletID={1}", customerId, outletId);
                    result = addressDBHelper.GetQueryList(sqlString, ref outletAddresses);
                    if (outletAddresses != null)
                    {
                        outletObj.AddressLanguages = outletAddresses;
                    }
                }
                #endregion
                #region[Addresses2]
                if (result == GlobalErrors.Success)
                {
                    DBHelper<TextLanguage> addressDBHelper = new DBHelper<TextLanguage>();
                    List<TextLanguage> outletAddresses2 = new List<TextLanguage>();
                    sqlString = string.Format(@"Select Address2 Description, LanguageID from CustomerOutletLanguage where CustomerID={0} and OutletID={1}", customerId, outletId);
                    result = addressDBHelper.GetQueryList(sqlString, ref outletAddresses2);
                    if (outletAddresses2 != null)
                    {
                        outletObj.Address2Languages = outletAddresses2;
                    }
                }
                #endregion
                if (result == GlobalErrors.Success)
                {
                    ReadCustomerGroups(outletObj);
                }
                if (result == GlobalErrors.Success && outletObj.HasPrivilegeOnPaymentTermDivision)
                {
                    List<OutletDivisionPaymentTermModel> divisionPaymentTermList = new List<OutletDivisionPaymentTermModel>();
                    result = GetOutletDivisionPaymentTerms(outletObj.CustomerId, outletObj.OutletId, ref divisionPaymentTermList);
                    if (result == GlobalErrors.Success && divisionPaymentTermList != null)
                    {
                        outletObj.OutletDivisionPaymentTermList = divisionPaymentTermList;
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                }
                if (result == GlobalErrors.Success && outletObj.HasPrivilegeOnOnHoldDivision)
                {
                    List<DivisionModel> onHoldDivisions = new List<DivisionModel>();
                    result = GetOutletOnHoldDivisions(outletObj.CustomerId, outletObj.OutletId, ref onHoldDivisions);
                    if (result == GlobalErrors.Success && onHoldDivisions != null)
                    {
                        outletObj.OnHoldDivisionsList = onHoldDivisions;
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    object iCashBalance = null;

                    sqlString = string.Format(@" Select Balance from ICashBalance Where CustomerID = {0} And OutletID = {1}",
                    outletObj.CustomerId,
                    outletObj.OutletId);
                    result = dbHelper.ExecuteScalar(sqlString, ref iCashBalance);
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                    if (result == GlobalErrors.Success && iCashBalance != null && !string.IsNullOrEmpty(iCashBalance.ToString()))
                    {
                        outletObj.ICashBalance = decimal.Parse(iCashBalance.ToString());
                        outletObj.HasICashBalance = true;
                    }
                }
  
                if (result == GlobalErrors.Success)
                {
                    sqlString = string.Format(@"select Contact.ContactID, NullIf(Mobile,'') Mobile, NullIf(Phone1,'') as Phone, NullIf(Fax,'') Fax, CustomerID, OutletID, Email, 
                    ContactLanguage.Description as ContactName, ContactLanguage.Address as Address, 
                    ContactLanguage.LanguageID, Contact.StreetID as Street, SL.Description as StreetName
                    from Contact
                    LEFT OUTER JOIN ContactLanguage on ContactLanguage.ContactID = Contact.ContactID
                    LEFT OUTER JOIN StreetLanguage SL on SL.StreetID = Contact.StreetID AND SL.LanguageID = {2}
                    where CustomerID = {0} AND OutletID = {1}
                    ORDER BY Contact.ContactID", outletObj.CustomerId, outletObj.OutletId, _requestRepository.LanguageId);
                    result = contactsDBHelper.GetQueryList(sqlString, ref contactsList);


                    if (result == GlobalErrors.Success && contactsList != null && contactsList.Count > 0)
                    {
                        for (int i = 0; i < contactsList.Count; i++)
                        {
                            text = new TextLanguage();
                            text.Description = contactsList[i].ContactName;
                            text.LanguageId = contactsList[i].LanguageId;
                            contactNamesDescriptions.Add(text);
                            text = new TextLanguage();
                            text.Description = contactsList[i].Address;
                            text.LanguageId = contactsList[i].LanguageId;
                            contactAddressesDescriptions.Add(text);
                            if (contactsList[i].LanguageId == _requestRepository.LanguageId)
                            {
                                customerOutletContact.Mobile = contactsList[i].Mobile;
                                customerOutletContact.Phone = contactsList[i].Phone;
                                customerOutletContact.Fax = contactsList[i].Fax;
                                customerOutletContact.Email = contactsList[i].Email;
                                customerOutletContact.ContactId = contactsList[i].ContactId;
                                customerOutletContact.ContactName = contactsList[i].ContactName;
                                customerOutletContact.Address = contactsList[i].Address;
                                customerOutletContact.Street = contactsList[i].Street;
                                customerOutletContact.StreetName = contactsList[i].StreetName;
                            }
                            if (i < contactsList.Count - 1 && customerOutletContact.ContactId != contactsList[i + 1].ContactId)
                            {
                                customerOutletContact.ContactDescriptionsLanguages = contactNamesDescriptions;
                                customerOutletContact.AddressDescriptionsLanguages = contactAddressesDescriptions;

                                sortedContactsList.Add(customerOutletContact);

                                customerOutletContact = new CustomerOutletContactModel();
                                contactAddressesDescriptions = new List<TextLanguage>();
                                contactNamesDescriptions = new List<TextLanguage>();
                            }
                        }
                        customerOutletContact.ContactDescriptionsLanguages = contactNamesDescriptions;
                        customerOutletContact.AddressDescriptionsLanguages = contactAddressesDescriptions;

                        sortedContactsList.Add(customerOutletContact);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        outletObj.CustomerOutletContacts = sortedContactsList;
                    }

                    

                    #region[Sales DistributionChannels]
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        List<SalesDistributionChannelModel> channels = new List<SalesDistributionChannelModel>();
                        GeneralFilter filter = new GeneralFilter();
                        filter.CustomerId = outletObj.CustomerId;
                        filter.OutletId = outletObj.OutletId;
                        filter.OrganizationIds = null;
                        result = GetSalesDistributionChannels(ref channels, filter);
                        if (result == GlobalErrors.Success && channels != null) outletObj.SalesDistributionChannels = channels;
                    }
                    #endregion
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetOutletDivisionPaymentTerms(int customerId, int outletId, ref List<OutletDivisionPaymentTermModel> divisionPaymentTermList)
        {
            DBHelper<OutletDivisionPaymentTermModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<OutletDivisionPaymentTermModel>();
                string sqlString = string.Format(@"select CustOutDivPaymentTerm.PaymentTermID, PaymentTermLanguage.Description as PaymentTermDescription,
                CustOutDivPaymentTerm.DivisionID, IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName 
                from CustOutDivPaymentTerm
                inner join Division on Division.DivisionID = CustOutDivPaymentTerm.DivisionID and Division.DivisionId in ({3})
                left outer join  PaymentTermLanguage on PaymentTermLanguage.PaymentTermID=CustOutDivPaymentTerm.PaymentTermID and PaymentTermLanguage.LanguageID={0}
                left join DivisionLanguage on DivisionLanguage.DivisionID = CustOutDivPaymentTerm.DivisionID and DivisionLanguage.LanguageID={0}
                Where CustomerID = {1} And OutletID = {2}",
                _requestRepository.LanguageId,
                customerId,
                outletId,
                _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.GetQueryList(sqlString, ref divisionPaymentTermList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionPaymentTermList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        private GlobalErrors DeleteOutletDivisionPaymentTerms(int customerId, int outletId, int customerType, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string deleteAll = string.Empty; // if type is cash then delete all old inserted records else delete divisions under access only
                if (customerType == CustomerTypes.CreditCustomer.GetHashCode())
                {
                    deleteAll = string.Format(" and DivisionId in ({0}) ", _requestRepository.CurrentOperator.DivisionAccess);
                }
                string query = string.Format(@"Delete From CustOutDivPaymentTerm Where CustomerID = {0} And OutletID = {1} {2} ", customerId, outletId, deleteAll);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveOutletDivisionPaymentTerms(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (OutletDivisionPaymentTermModel paymentTerm in outlet.OutletDivisionPaymentTermList)
                {
                    values.AppendFormat("( {0},{1},{2},{3} ),",
                    outlet.CustomerId, //0
                    outlet.OutletId, //1
                    paymentTerm.DivisionId, //2
                    paymentTerm.PaymentTermId //3
                    );
                }
                query = string.Format(@"Insert Into CustOutDivPaymentTerm (CustomerID, OutletID, DivisionID, PaymentTermID) Values {0}", values.ToString().TrimEnd(','));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region[On Hold Divisions]
        public GlobalErrors GetOutletOnHoldDivisions(int customerId, int outletId, ref List<DivisionModel> divisionsList)
        {
            DBHelper<DivisionModel> DBHelperForDivisions = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelperForDivisions = new DBHelper<DivisionModel>();
                string divisionAccess = string.Empty;
                if (_requestRepository.CurrentOperator.DivisionAccess != string.Empty)
                {
                    divisionAccess = string.Format(" and Division.DivisionID in ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                }
                string query = string.Format(@" Select distinct Division.DivisionID, Division.OrganizationID, Divisionlanguage.Description, Division.DivisionCode,
                IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName
                From CustOutDivOnHoldStatus
                Inner join Division on Division.DivisionID = CustOutDivOnHoldStatus.DivisionID
                Left Outer join Divisionlanguage on Division.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {0}
                Where CustomerId = {1} and OutletId = {2} {3}",

               _requestRepository.LanguageId, //0
                customerId, //1
                outletId, //2
                divisionAccess //3
                );

                result = DBHelperForDivisions.GetQueryList(query, ref divisionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionsList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (DBHelperForDivisions != null)
                {
                    DBHelperForDivisions.Dispose();
                    DBHelperForDivisions = null;
                }
            }
            return result;
        }
        private GlobalErrors DeleteOutletOnHoldDivisions(int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete From CustOutDivOnHoldStatus Where CustomerID = {0} And OutletID = {1} and DivisionId in ({2})", customerId, outletId, _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveOutletOnHoldDivisions(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (outlet.OnHoldDivisionsList != null && outlet.OnHoldDivisionsList.Count > 0)
                {
                    string query = string.Empty;
                    StringBuilder values = new StringBuilder();
                    foreach (DivisionModel paymentTerm in outlet.OnHoldDivisionsList)
                    {
                        values.AppendFormat("( {0},{1},{2} ),",
                        outlet.CustomerId, //0
                        outlet.OutletId, //1
                        paymentTerm.DivisionId //2
                        );
                    }
                    query = string.Format(@"Insert Into CustOutDivOnHoldStatus (CustomerID, OutletID, DivisionID) Values {0}", values.ToString().TrimEnd(','));
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        public GlobalErrors GetOutletInformationForCRM(int customerId, int outletId, ref CustomerOutletModel outlet)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dBHelper = null;
            var query = new StringBuilder();
            string paymentTermString = string.Empty;
            string paymentTermJoin = string.Empty;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>(_requestRepository.CurrentOperator.EmployeeId);
                if (_requestRepository.Configurations.CheckPaymentTermOnCustomerLevel)
                {
                    paymentTermString = string.Format(@" case when Customer.PaymentTermID != '' then Customer.PaymentTermID else -1 end PaymentTermID");
                    paymentTermJoin = string.Format(@" LEFT JOIN PaymentTermLanguage PTL on PTL.PaymentTermID = Customer.PaymentTermID AND PTL.LanguageID = {0}", _requestRepository.LanguageId);
                }
                else
                {
                    paymentTermString = string.Format(@" case when CustomerOutlet.PaymentTermID != '' then CustomerOutlet.PaymentTermID else -1 end PaymentTermID");
                    paymentTermJoin = string.Format(@" LEFT JOIN PaymentTermLanguage PTL on PTL.PaymentTermID = CustomerOutlet.PaymentTermID AND PTL.LanguageID = {0}", _requestRepository.LanguageId);
                }
                string homeOfficesJoin = " INNER ";
                bool removeHomeAndOfficesConceptFromCRM = _requestRepository.Configurations.RemoveHomeAndOfficesConceptFromCRM;
                if (removeHomeAndOfficesConceptFromCRM)
                {
                    homeOfficesJoin = " Left ";
                }
                query.AppendFormat(@"Select CustomerOutlet.CustomerID , CustomerOutlet.OutletID , Customer.CustomerCode ,  CustomerLanguage.Description CustomerName , COL.Description OutletName , CustomerOutlet.Email , CustomerOutlet.Inactive, {4} , CustomerOutlet.CustomerTypeID,IsNull(Customer.CustomerCode , '--') + ' ' + '--'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName  ,
                IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '--'+ ' ' + IsNull( COL.Description , '--') as OutletCodeName ,
                CustomerOutlet.CountryID , CityLanguage.StateID , CustomerOutlet.CityID , CustomerOutlet.AreaId , CountryLanguage.Description CountryName  , COL.Address  , COL.Address2 , CityLanguage.Description CityName , AreaLanguage.Description AreaName,
                EmployeeLanguage.Description CreatedByName , CustomerSource.Description CustomerSource , CustomerCreationSource.Description CustomerCreationSource , CustOutExtraInfo.NationalityId , CustOutExtraInfo.DateOfBirth , CustOutExtraInfo.Gender , CustOutExtraInfo.IdentificationNumber  , SubChannelLanguage.Description SubChannelName  ,  ChannelLanguage.Description ChannelName,
                CustomerGroupLanguage.Description HHGroupName , IsNull(HomeAndOfficeGroup.GroupID, -1)HHGroupId ,PriceListLanguage.Description PriceListName,
                ISNULL(CTL.Description, '--') CustomerType,
                ISNULL(PTL.Description, '--') PaymentTerm,
                CAST(ROUND(ISNULL(Icash.Balance,0) ,{3} )AS numeric(19, {3})) AS ICashBalance, 
                CAST(ROUND(ISNULL(Account.CreditLimit,0) ,{3} )AS numeric(19, {3})) AS CreditLimit, 
                CAST(ROUND(ISNULL(Account.Balance,0) , {3} )AS numeric(19, {3})) Balance ,
				CustomerOutlet.CreatedDate ,
				CASE 
				WHEN Customer.New  = 1  THEN 'Under Review'
                WHEN CustomerOutlet.Inactive = 1 Then 'InActive'
				ELSE 'Active' END Status , Customer.New IsNewCustomer,
                CustomerClassLanguage.Description as CustomerClass,
                CustomerOutlet.Taxeable,
                CustomerOutlet.WarehouseID, 
                CustomerOutlet.OrganizationID, Warehouse.OrganizationID WarehouseOrganizationId
                from CustomerOutlet
                INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID
                LEFT JOIN Warehouse ON Warehouse.WarehouseID = CustomerOutlet.WarehouseID
                LEFT JOIN CustomerPrice ON Customer.CustomerID = CustomerPrice.CustomerID AND CustomerPrice.OutletID = CustomerOutlet.OutletID
                LEFT JOIN CustomerClassLanguage ON CustomerClassLanguage.CustomerClassID = CustomerOutlet.CustomerClassID AND CustomerClassLanguage.LanguageID = {0}
				LEFT JOIN PriceListLanguage ON CustomerPrice.PriceListID = PriceListLanguage.PriceListID AND PriceListLanguage.LanguageID = {0}
                LEFT JOIN AccountCustOut on AccountCustOut.CustomerID = CustomerOutlet.CustomerID AND AccountCustOut.OutletID =  CustomerOutlet.OutletID
                LEFT JOIN Account on Account.AccountID = AccountCustOut.AccountID
                LEFT JOIN CustomerLanguage on CustomerLanguage.CustomerID = CustomerOutlet.CustomerID AND CustomerLanguage.LanguageID = {0}
                LEFT JOIN CustomerOutletLanguage COL On COL.CustomerID = CustomerOutlet.CustomerID and COL.OutletID = CustomerOutlet.OutletID AND  COL.LanguageID = {0}
                LEFT JOIN CustomerTypeLanguage CTL on CTL.CustomerTypeID = CustomerOutlet.CustomerTypeID and CTL.LanguageID = {0}
                {5}
                LEFT JOIN ICashBalance Icash on Icash.CustomerID = CustomerOutlet.CustomerID and Icash.OutletID = CustomerOutlet.OutletID                 
				LEFT JOIN CustOutExtraInfo on CustOutExtraInfo.CustomerId = CustomerOutlet.CustomerID AND CustOutExtraInfo.OutletId = CustomerOutlet.OutletID
				LEFT JOIN CountryLanguage on CountryLanguage.CountryID = CustomerOutlet.CountryID AND CountryLanguage.LanguageID = 1
				LEFT JOIN CityLanguage on CityLanguage.CountryId = CustomerOutlet.CountryID AND CityLanguage.CityID = CustomerOutlet.CityID AND CityLanguage.LanguageID = 1
				LEFT JOIN AreaLanguage on CustomerOutlet.AreaID = AreaLanguage.AreaID AND AreaLanguage.LanguageID = 1
				LEFT JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID = CustomerOutlet.CreatedBy AND EmployeeLanguage.LanguageID ={0}
				LEFT JOIN CustomerSource on CustomerSource.SourceId = CustOutExtraInfo.SourceId AND CustomerSource.LanguageId = {0}
				LEFT JOIN CustomerCreationSource on CustomerCreationSource.CreationSourceId = CustOutExtraInfo.CreationSourceId AND CustomerCreationSource.LanguageId = {0}
				LEFT JOIN 
				(Select Top 1 CustomerOutletGroup.*  , HomeAndOffice.ChannelId , HomeAndOffice.SubChannelId
				From  CustomerOutletGroup 
				{6} JOIN HomeAndOffice on HomeAndOffice.GroupId =  CustomerOutletGroup.GroupId 
				Where CustomerID = {1} AND OutletID = {2} )
				 AS HomeAndOfficeGroup on HomeAndOfficeGroup.CustomerID = CustomerOutlet.CustomerID AND HomeAndOfficeGroup.OutletID =  CustomerOutlet.OutletID 
				LEFT JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = HomeAndOfficeGroup.SubChannelId AND SubChannelLanguage.LanguageID = {0} 
				LEFT JOIN ChannelLanguage on ChannelLanguage.ChannelID = HomeAndOfficeGroup.ChannelID AND ChannelLanguage.LanguageID = {0}
				LEFT JOIN CustomerGroupLanguage on CustomerGroupLanguage.GroupID = HomeAndOfficeGroup.GroupID AND CustomerGroupLanguage.LanguageID = {0}
                WHERE  CustomerOutlet.CustomerID = {1} AND CustomerOutlet.OutletID = {2} "
                , _requestRepository.LanguageId, customerId, outletId, _requestRepository.Configurations.NumberOfDigits, paymentTermString, paymentTermJoin, homeOfficesJoin);

                result = dBHelper.GetQuerySingle(query.ToString(), ref outlet);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOutletLanguages(int customerId, int outletId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>(_requestRepository.CurrentOperator.EmployeeId);
                string query = string.Format(@"Select * from CustomerOutletLanguage where customerId = {0} And OutletId = {1}", customerId, outletId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOutletRelatedEmployee(int customerId, int outletId, int areaId, ref EmployeeModel employee)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<EmployeeModel>(_requestRepository.CurrentOperator.EmployeeId);
                string query = string.Format(@"Select top 1 EmployeeTerritory.EmployeeID  , Employee.Phone , EmployeeLanguage.Description EmployeeName , RouteCustomer.CustomerID , RouteCustomer.OutletID
				FROM EmployeeTerritory
				INNER JOIN Employee on Employee.EmployeeID = EmployeeTerritory.EmployeeID
				INNER JOIN Route on Route.TerritoryID = EmployeeTerritory.TerritoryID 
                INNER JOIN RouteAreas on RouteAreas.RouteID = Route.RouteID AND RouteAreas.AreaID = {2}
				INNER JOIN RouteCustomer on RouteCustomer.RouteID = Route.RouteID AND RouteCustomer.CustomerID = {0} AND RouteCustomer.OutletID = {1}
				LEFT JOIN EmployeeLanguage on Employee.EmployeeID = EmployeeLanguage.EmployeeID ANd EmployeeLanguage.LanguageID = {3}"
                , customerId, outletId, areaId, _requestRepository.LanguageId);

                result = dBHelper.GetQuerySingle(query, ref employee);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOutletsList(CustomerFilter filter, ref SharedTableResult<CustomerOutletModel> customerList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dbHelper = null;
            List<CustomerOutletModel> customers = new List<CustomerOutletModel>();
            string transactionsJoin = string.Empty;
            string contactJoin = string.Empty;
            string employeeRouteJoin = string.Empty;
            StringBuilder teleRepCustomersJoin = new StringBuilder();
            string sequenceSelection = string.Empty;
            string teleRepVisitStatusJoin = string.Empty;
            string teleRepVisitStatusSelection = string.Empty;
            try
            {
                dbHelper = new DBHelper<CustomerOutletModel>(_requestRepository.CurrentOperator.EmployeeId);
                string dataQuery = string.Empty;
                string checkCusOrg = _requestRepository.Configurations.RestrictDataToCustomerOrganization ? $" And CustomerOutlet.OrganizationId in ({_requestRepository.CurrentOperator.OrganizationAccess}) " : string.Empty;
                var mainQuery = new StringBuilder();
                if (!string.IsNullOrEmpty(filter.Phone) || !string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    contactJoin = string.Format(@"LEFT JOIN CustomerOutletContact on CustomerOutletContact.CustomerId = CustomerOutlet.CustomerID AND  CustomerOutletContact.OutletId = CustomerOutlet.OutletID");
                }
                if (!string.IsNullOrEmpty(filter.TransactionId))
                {

                    transactionsJoin = string.Format(@" inner join(
                    select CustomerID, OutletID
                    from [Transaction]  with (nolock)
                    where TransactionID LIKE '%{0}%'
                    union
                    select CustomerID, OutletID
                    from SalesOrder  with (nolock)
                    where OrderID LIKE '%{0}%'
                    )tt on tt.CustomerID = CustomerOutlet.CustomerID and tt.OutletID = CustomerOutlet.OutletID", filter.TransactionId.Replace("'", "''"));

                }
                if (filter.EmployeeId != -1)
                {
                    if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        employeeRouteJoin = string.Format(@"  inner join CustOutTerritory on CustOutTerritory.CustomerID=CustomerOutlet.CustomerID and CustOutTerritory.OutletID=CustomerOutlet.OutletID 
				                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID=CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeID={0} ", filter.EmployeeId);
                    }
                    else
                    {
                        employeeRouteJoin = string.Format(@"  inner join RouteCustomer on RouteCustomer.CustomerID=CustomerOutlet.CustomerID and RouteCustomer.OutletID=CustomerOutlet.OutletID 
				                inner Join Route on Route.RouteID=RouteCustomer.RouteID
				                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID=Route.TerritoryID and EmployeeTerritory.EmployeeID={0} ", filter.EmployeeId);
                    }
                }
                if (filter.EmployeeTypeId == EmployeeTypes.TeleRep && filter.TeleRepPlanDateModel != null)
                {
                    if (!_requestRepository.Configurations.SkipCRMVisit)
                    {
                        teleRepVisitStatusSelection = $@" ,case when visits.isSuccess is null then 'Pending' when visits.isSuccess > 0 then 'Success' when visits.isSuccess = 0 then 'Non-Productive' end as CallStatus ";
                        teleRepVisitStatusJoin = $@" outer apply   (
                        select SUM(tt.isSuccess) isSuccess {(filter.ReasonId > 0 ? " , sum(tt.sameReason)sameReason " : string.Empty)} from(
                        select case when VisitStatusId = {(int)TeleRepVisitStatus.Productive} then 1 else 0 end as isSuccess,
                        {(filter.ReasonId > 0 ? $" case when TeleRepVisitDetails.VisitStatusId = {(int)TeleRepVisitStatus.NonProductive} and TeleRepVisitDetails.NonProductiveReasonId = {filter.ReasonId} then 1 else 0 end as sameReason, " : string.Empty)} 
                        TeleRepVisitDetails.*
                        from TeleRepVisitDetails
                        cross apply (
                        select top(1) * from CallsHistory where CallsHistory.VisitId = TeleRepVisitDetails.VisitId
                        and CallsHistory.CustomerId = CustomerOutlet.CustomerID and CallsHistory.OutletId = CustomerOutlet.OutletID AND CallsHistory.EmployeeId = TeleRepVisitDetails.EmployeeId
                        ) calls 
                        where TeleRepVisitDetails.VisitDate = {(LocalUtilities.ParseDateToSQLString(filter.TeleRepPlanDateModel.Date))} AND TeleRepVisitDetails.EmployeeId = {_requestRepository.CurrentOperator.EmployeeId} 
                        )tt
                        ) visits";
                    }

                    teleRepCustomersJoin.Append($@"INNER JOIN TeleRepCustomers TRC on TRC.EmployeeId = {_requestRepository.CurrentOperator.EmployeeId} 
                                                AND TRC.CustomerID = Customer.CustomerID AND TRC.OutletID = CustomerOutlet.OutletID");
                    if (filter.ShowUnplannedCustomers)
                    {
                        teleRepCustomersJoin.Append($@"      
                    LEFT JOIN CallPlan_{_requestRepository.CurrentOperator.EmployeeId} CP ON CP.Date = {(LocalUtilities.ParseDateToSQLString(filter.TeleRepPlanDateModel.Date))}              
                    LEFT JOIN CallPlanDetail_{_requestRepository.CurrentOperator.EmployeeId} CPD on CPD.CallPlanID = CP.CallPlanID AND CPD.CustomerID = Customer.CustomerID AND CPD.OutletID = CustomerOutlet.OutletID");
                    }
                    else
                    {
                        sequenceSelection = ",CPD.Sequence,";

                        teleRepCustomersJoin.Append($@" 
                    INNER JOIN CallPlan_{_requestRepository.CurrentOperator.EmployeeId} CP ON CP.Date = {(LocalUtilities.ParseDateToSQLString(filter.TeleRepPlanDateModel.Date))}              
                    INNER JOIN CallPlanDetail_{_requestRepository.CurrentOperator.EmployeeId} CPD on CPD.CallPlanID = CP.CallPlanID AND CPD.CustomerID = Customer.CustomerID AND CPD.OutletID = CustomerOutlet.OutletID");
                    }
                }
                mainQuery.AppendFormat(@"FROM Customer   with (nolock)
                LEFT JOIN CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID ANd CustomerLanguage.LanguageID = {0} and CustomerLanguage.OrganizationId in ({7})
                INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = Customer.CustomerID
                LEFT JOIN CustomerOutletLanguage COL on COL.CustomerID = Customer.CustomerID AND COL.OutletID = CustomerOutlet.OutletID AND COL.LanguageID = {0}
				LEFT JOIN CustOutExtraInfo on CustOutExtraInfo.CustomerId = CustomerOutlet.CustomerID AND CustOutExtraInfo.OutletId = CustomerOutlet.OutletID
				LEFT JOIN Area on Area.AreaID = CustOutExtraInfo.AreaId
                left outer join AreaLanguage on AreaLanguage.AreaID=Area.AreaID and AreaLanguage.LanguageID={0}
                left outer join CityLanguage on CityLanguage.CityID=Area.CityID and CityLanguage.LanguageID={0}
                {1}
                {2}
                {3}
                {4}
                {5}
                Where 1=1 {6} ", _requestRepository.LanguageId, transactionsJoin, contactJoin, employeeRouteJoin, teleRepCustomersJoin, teleRepVisitStatusJoin, checkCusOrg, _requestRepository.CurrentOperator.OrganizationAccess);

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    //mainQuery.AppendFormat(@" AND ( 
                    //        (CustomerLanguage.Description LIKE '%{0}%')
                    //        OR ( Customer.CustomerCode LIKE '%{0}%')
                    //        OR ( CustomerOutlet.CustomerCode LIKE '%{0}%')
                    //        OR ( COL.Description LIKE '%{0}%')
                    //        OR(CustomerOutlet.Email LIKE '%{0}%')
                    //        OR (CustomerOutlet.Phone LIKE '%{0}%' OR CustomerOutletContact.Number LIKE '%{0}%' )
                    //        )", filter.SearchFilter.Trim());

                    mainQuery.AppendFormat(@" AND ( 
                    (CustomerLanguage.Description + '^' + Customer.CustomerCode + '^' + CustomerOutlet.CustomerCode + '^' + COL.Description + '^' + IsNull(CustomerOutlet.Email,'') + '^' + IsNull(CustomerOutlet.Phone,'') + '^' + + ISNULL(CustomerOutletContact.Number,''))
                    like '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());
                }
                if (!string.IsNullOrEmpty(filter.CustomerCode))
                {
                    mainQuery.AppendFormat(@" AND Customer.CustomerCode LIKE '%{0}%'", filter.CustomerCode.Replace("'", "''").Trim());
                }
                if (!string.IsNullOrEmpty(filter.OutletCode))
                {
                    mainQuery.AppendFormat(@" AND CustomerOutlet.CustomerCode LIKE '%{0}%'", filter.OutletCode.Replace("'", "''").Trim());
                }
                if (!string.IsNullOrEmpty(filter.CustomerName))
                {
                    mainQuery.AppendFormat(@" AND CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1})", filter.CustomerName.Replace("'", "''").Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (!string.IsNullOrEmpty(filter.Email))
                {
                    mainQuery.AppendFormat(@" AND CustomerOutlet.Email LIKE '%{0}%'", filter.Email.Replace("'", "''").Trim());
                }
                if (filter.RegionId != -1)
                {
                    mainQuery.AppendFormat(@" AND Area.CityID = {0}", filter.RegionId);
                }
                if (filter.LandmarkId != -1)
                {
                    mainQuery.AppendFormat(@" AND Area.AreaID = {0}", filter.LandmarkId);
                }
                //if (!string.IsNullOrEmpty(filter.TransactionId))
                //{
                //    mainQuery.AppendFormat(@" AND (SO.OrderID LIKE '%{0}%' OR T.TransactionID Like '%{0}%')", filter.TransactionId.Replace("'", "''").Trim());
                //}
                if (!string.IsNullOrEmpty(filter.Phone))
                {
                    mainQuery.AppendFormat(@" AND (CustomerOutlet.Phone LIKE '%{0}%' OR CustomerOutletContact.Number LIKE '%{0}%' )", filter.Phone.TrimStart('0').Replace("'", "''").Trim());
                }
                if (!string.IsNullOrEmpty(filter.IdentificationNumber))
                {
                    mainQuery.AppendFormat(@" AND (CustOutExtraInfo.IdentificationNumber LIKE '%{0}%')", filter.IdentificationNumber.Replace("'", "''").Trim());
                }
                if (filter.EmployeeTypeId == EmployeeTypes.TeleRep)
                {
                    if (filter.ShowUnplannedCustomers)
                        mainQuery.Append(" AND CPD.CallPlanID IS NULL ");

                    if (filter.VisitStatusId == (int)TeleRepVisitStatus.Pending)
                        mainQuery.Append(" AND visits.isSuccess IS NULL ");
                    else if (filter.VisitStatusId == (int)TeleRepVisitStatus.Productive)
                        mainQuery.Append(" AND visits.isSuccess > 0 ");
                    else if (filter.VisitStatusId == (int)TeleRepVisitStatus.NonProductive)
                        mainQuery.Append(" AND visits.isSuccess = 0 ");

                    if (filter.ReasonId > 0)
                        mainQuery.Append(" and IsNull(visits.isSuccess,-1) = 0 and visits.sameReason > 0 ");
                }
                dataQuery = string.Format(@"Select Distinct customer.customerId , CustomerOutlet.OutletId ,  customer.CustomerCode,
                                            ISNULL(CustomerLanguage.Description , '---')  CustomerName ,
                                            CustomerOutlet.CustomerCode OutletCode  ,
                                            ISNULL( COL.Description , '---') OutletName ,
                                            Customer.New,
											Customer.CreatedDate,
											CASE 
											WHEN Customer.New  = 1  THEN 'Under Review'
                                            WHEN CustomerOutlet.Inactive = 1 Then 'InActive'
											ELSE 'Active' END Status 
                                            {4}
                                            {5}
                                            {0}
                                            order by {3} Customer.new desc ,Customer.CreatedDate desc , Customer.CustomerCode
                                            OFFSET     {1} ROWS
                                            FETCH NEXT {2} ROWS ONLY", mainQuery.ToString(), //0
                                            filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //1
                                            filter.CustomListFilter.PageSize, //2
                                            sequenceSelection.TrimStart(','), //3 
                                            sequenceSelection.TrimEnd(','), //4
                                            teleRepVisitStatusSelection //5
                                            );

                var countQuery = string.Format(@"select Count(Distinct Customer.CustomerId) {0}", mainQuery.ToString());
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField, true);
                if (result == GlobalErrors.Success && objField != null)
                {
                    customerList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(dataQuery, ref customers, true);
                    customerList.Data = customers;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetPaymentTerms(ref List<PaymentTermModel> paymentTermObj)
        {
            DBHelper<PaymentTermModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PaymentTermModel>();
                string sqlString = string.Format(@"select PaymentTerm.PaymentTermID , PaymentTermLanguage.Description as PaymentTermDescription
from PaymentTerm
   left outer join  PaymentTermLanguage on PaymentTermLanguage.PaymentTermID=PaymentTerm.PaymentTermID and PaymentTermLanguage.LanguageID={0}
", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref paymentTermObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                paymentTermObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetPaymentTermTypes(ref List<PaymentTermTypeModel> paymentTermObj)
        {
            DBHelper<PaymentTermTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PaymentTermTypeModel>();
                string sqlString = string.Format(@"select PymntTermType.PaymentTermTypeID,PymntTermTypeLanguage.Description PaymentTermTypeDescription from PymntTermType
left outer join PymntTermTypeLanguage on PymntTermType.PaymentTermTypeID=PymntTermTypeLanguage.PaymentTermTypeID and PymntTermTypeLanguage.LanguageID={0}
", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref paymentTermObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                paymentTermObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetPeriodTypes(ref List<PeriodTypeModel> periodTypeObj)
        {
            DBHelper<PeriodTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PeriodTypeModel>();
                string sqlString = string.Format(@"select PeriodType.PeriodTypeID,PeriodTypeLanguage.Description PeriodTypeDescription from PeriodType
left outer join PeriodTypeLanguage on PeriodType.PeriodTypeID=PeriodTypeLanguage.PeriodTypeID and PeriodTypeLanguage.LanguageID={0}
", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref periodTypeObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                periodTypeObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }


        public GlobalErrors AssignOutletToGroup(int customerId, int outletId, int groupId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO CustomerOutletGroup (GroupID , CustomerID , OutletID) VALUES ({0} , {1} , {2})"
              , groupId
              , customerId
              , outletId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors AssignOutletToPriceList(int customerId, int outletId, int priceListID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                query = string.Format(@"Delete from CustomerPrice where CustomerID = {0} AND OutletID = {1} ", customerId
                    , outletId
                    );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"INSERT INTO CustomerPrice (CustomerID , OutletID , PriceListID) VALUES ({0} , {1} , {2})"
                    , customerId
                    , outletId
                    , priceListID);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors RemovePriceListAssignmentIfExist(int customerId, int outletId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                query = string.Format(@"Delete from CustomerPrice where CustomerID = {0} AND OutletID = {1} ", customerId
                    , outletId
                    );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertCustomerIntoEmployeeRoutes(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into RouteCustomer (RouteID , CustomerID , OutletID)
                Select RouteAreas.RouteID , {0} , {1}
                from EmployeeTerritory
                INNER JOIN Route on Route.TerritoryID = EmployeeTerritory.TerritoryID
                INNER JOIN RouteAreas on RouteAreas.RouteID = Route.RouteID AND RouteAreas.AreaID = {2}
                AND Route.RouteID not in (Select RouteID From RouteCustomer where CustomerID = {0} AND OutletID = {1})
                Where EmployeeID = {3}"
                , outletObj.CustomerId
                , outletObj.OutletId
                , outletObj.AreaId
                , outletObj.EmployeeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteCustomerFromEmployeeTerritory(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" delete CustOutTerritory from CustOutTerritory
                INNER JOIN EmployeeTerritory on CustOutTerritory.TerritoryID = EmployeeTerritory.TerritoryID 
                Where EmployeeTerritory.EmployeeID = {0} and CustOutTerritory.CustomerID = {1} and CustOutTerritory.OutletID = {2} ", outletObj.EmployeeId, outletObj.CustomerId, outletObj.OutletId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertCustomerIntoEmployeeTerritory(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO CustOutTerritory (CustomerID , OutletID , TerritoryID)
                Select  {0} ,  {1} , TerritoryID
                FROM EmployeeTerritory where EmployeeID = {2} AND TerritoryID not in (Select TerritoryID From CustOutTerritory where CustomerID = {0} AND OutletID = {1})"
                , outletObj.CustomerId
                , outletObj.OutletId
                , outletObj.EmployeeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertIntoOutletAddressHistory(int customerId, int outletId, string cityName, string areaName, string address, string address2, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                address = address.Replace("'", "''");
                address2 = address.Replace("'", "''");
                string query = string.Format(@"insert into CustOutAddressHistory values ({0},{1},{2},{3},'{4}','{5}','{6}','{7}')"
                , customerId
                , outletId
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                , _requestRepository.CurrentOperator.EmployeeId
                , cityName
                , areaName
                , address
                , address2);

                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertIntoOutletHistory(int customerId, int outletId, string FieldName, string oldValue, string newValue, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into CustomerOutletHistory values ({0},{1},'{2}',{3},{4},'{5}','{6}')"
                , customerId
                , outletId
                , FieldName
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                , _requestRepository.CurrentOperator.EmployeeId
                , oldValue == null ? null : oldValue.Replace("'", "''")
                , newValue == null ? null : newValue.Replace("'", "''"));
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #region[OutletAttachments]
        private GlobalErrors DeleteCustomerAttachmentFolders(string customerID)
        {
            try
            {
                if (!String.IsNullOrEmpty(LocalUtilities.CustomerAttachments) && !String.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy))
                {
                    if (Directory.Exists(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId))
                    {
                        Directory.Delete(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId, true);
                    }
                    if (Directory.Exists(LocalUtilities.CustomerAttachments + "\\" + customerID))
                    {
                        Directory.Delete(LocalUtilities.CustomerAttachments + "\\" + customerID, true);
                    }
                }

                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private List<string> GetOutletAttachments(ref CustomerModel customerObj, string outletID)
        {
            List<string> attachementNames = new List<string>();
            string dummyCustomerFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId + "\\" + customerObj.CustomerId.ToString());
            customerObj.CustomerAttachmentsBasePath = dummyCustomerFolderPath.Substring(dummyCustomerFolderPath.IndexOf("wwwroot"));// + "/" + customerObj.CustomerId.ToString();
            customerObj.CustomerAttachmentsBasePath = customerObj.CustomerAttachmentsBasePath.Replace('\\', '/');
            string CustomerFolderPath = Path.Combine(LocalUtilities.CustomerAttachments, customerObj.CustomerId.ToString());
            try
            {
                if (Directory.Exists(CustomerFolderPath))
                {
                    string outletAttachmentFolderPath = CustomerFolderPath + "\\" + outletID;
                    string dummyOutletAttachmentsFolderPath = Path.Combine(dummyCustomerFolderPath, outletID);
                    attachementNames = new List<string>();
                    if (Directory.Exists(outletAttachmentFolderPath))
                    {
                        Directory.CreateDirectory(dummyOutletAttachmentsFolderPath);
                        DirectoryInfo Attachementdir = new DirectoryInfo(outletAttachmentFolderPath);
                        FileInfo[] files = Attachementdir.GetFiles();
                        if (files != null && files.Length > 0)
                        {
                            foreach (FileInfo file in files)
                            {
                                if (!System.IO.File.Exists(Path.Combine(dummyOutletAttachmentsFolderPath, file.Name)))
                                    System.IO.File.Copy(file.FullName, Path.Combine(dummyOutletAttachmentsFolderPath, file.Name));//check if file is not exist else add its name
                                attachementNames.Add(file.Name);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

            }
            return attachementNames;

        }

        #endregion
        public GlobalErrors InsertMustSellItemsDetail(MustSellItem mustSellItems, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = String.Empty;
                if (mustSellItems.allCustomers)
                {
                    query += DeleteMustSellItemsQuery(-1, -1, -1);
                    foreach (ItemPackModel item in mustSellItems.items)
                        query += string.Format(" insert into CustOutMustSellItem(GroupID,CustomerID,OutletID,ItemID) values ({0},{1},{2}, {3})", -1, -1, -1, item.ItemId);
                }
                else
                {
                    if (mustSellItems.customers.Count > 0)
                        foreach (CustomerModel customer in mustSellItems.customers)
                        {
                            query += DeleteMustSellItemsQuery(customer.CustomerId, customer.OutletId, -1);
                            foreach (ItemPackModel item in mustSellItems.items)
                                query += string.Format(" insert into CustOutMustSellItem(GroupID,CustomerID,OutletID,ItemID) values ({0},{1},{2}, {3})", -1, customer.CustomerId, customer.OutletId, item.ItemId);
                        }

                    if (mustSellItems.customerGroup.Count > 0)
                        foreach (CustomerGroupModel customerGroup in mustSellItems.customerGroup)
                        {
                            query += DeleteMustSellItemsQuery(-1, -1, customerGroup.GroupId);
                            foreach (ItemPackModel item in mustSellItems.items)
                                query += string.Format(" insert into CustOutMustSellItem(GroupID,CustomerID,OutletID,ItemID) values ({0},{1},{2}, {3})", customerGroup.GroupId, -1, -1, item.ItemId);

                        }
                }

                result = dbHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {

            }
            return result;
        }
        public GlobalErrors InsertMustSellItemsExcludedOutlet(MustSellItem mustSellItems, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = String.Empty;
                int groupId = mustSellItems.customerGroup.Count > 0 ? mustSellItems.customerGroup.ElementAt(0).GroupId : -1;
                if (mustSellItems.excludeCustomers.Count > 0)
                {
                    query += DeleteMustSellItemsExcludedOutletQuery(groupId);
                    foreach (CustomerModel customer in mustSellItems.excludeCustomers)
                    {
                        query += string.Format(" insert into MustSellItemsExcludedOutlet(GroupID,CustomerID,OutletID) values ({0},{1},{2})", groupId, customer.CustomerId, customer.OutletId);
                    }
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {

            }
            return result;
        }
        public GlobalErrors GetMustSellItemsSharedTable(GeneralFilter filter, ref SharedTableResult<MustSellItemSharedTable> mustSellItemsList)
        {
            mustSellItemsList = new SharedTableResult<MustSellItemSharedTable>();
            List<MustSellItemSharedTable> newMustSellItemsList = new List<MustSellItemSharedTable>();
            DBHelper<MustSellItemSharedTable> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<MustSellItemSharedTable>();
                string searchFilter = "1=1 ";
                string orderByFilter = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                StringBuilder orgGroupAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustOutMustSellItem", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    orgGroupAccessJoin.Append($" and CG.OrganizationID in ({ _requestRepository.CurrentOperator.OrganizationAccess})");
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@" and 
                        ((Description  LIKE '%{0}%') 
                        OR (TypeDescription LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (CustOutMustSellItem.CustomerID = {0}) ", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (CustOutMustSellItem.OutletID = {0}) ", filter.OutletId);
                    }
                    if (filter.groupId != -1)
                    {
                        searchFilter += string.Format(" And (CustOutMustSellItem.CustomerGroupId = {0}) ", filter.groupId);
                    }
                    if (filter.AllCustomersOnly)
                    {
                        searchFilter += " And (CustOutMustSellItem.CustomerGroupId = -1 AND CustOutMustSellItem.OutletID = -1 AND CustOutMustSellItem.CustomerID = -1)";
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By 1 desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }


                string mainQuery = string.Format(@" select * from ( 
                    select distinct CustomerOutlet.CustomerCode+' - '+CustomerOutletLanguage.Description+' - '+ Customer.CustomerCode +' - '+CustomerLanguage.Description Description,
                    CustOutMustSellItem.CustomerID, CustOutMustSellItem.OutletID, -1 CustomerGroupId, 0 as AllCustomers, '{2}' TypeDescription
                    from CustOutMustSellItem 
                    inner join Customer on Customer.CustomerID = CustOutMustSellItem.CustomerID
                    inner join CustomerLanguage on CustomerLanguage.CustomerID = CustOutMustSellItem.CustomerID and LanguageID = {0}
                    inner join CustomerOutlet on CustomerOutlet.CustomerID = CustOutMustSellItem.CustomerID and CustomerOutlet.OutletID = CustOutMustSellItem.OutletID
                    inner join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustOutMustSellItem.CustomerID and CustomerOutletLanguage.OutletID = CustOutMustSellItem.OutletID
                    and CustomerOutletLanguage.LanguageID = {0}
                    {5}
                    inner join Item On Item.ItemID = CustOutMustSellItem.ItemID
                    inner join itemcategory On ItemCategory.ItemCategoryID = item.ItemCategoryID AND ItemCategory.DivisionID IN ({7})
                    union
                     select distinct CustomerGroupLanguage.Description Description,  -1 as CustomerID,  -1 as OutletID, CustOutMustSellItem.GroupID CustomerGroupId, 0 as AllCustomers , '{3}' TypeDescription
                    from CustOutMustSellItem
                    inner join CustomerGroup CG  on CG.GroupID = CustOutMustSellItem.GroupID {6} 
                    inner join CustomerGroupLanguage on CustomerGroupLanguage.GroupID = CustOutMustSellItem.GroupID 
                    inner join Item On Item.ItemID = CustOutMustSellItem.ItemID
                    inner join itemcategory On ItemCategory.ItemCategoryID = item.ItemCategoryID AND ItemCategory.DivisionID IN ({7})
                    union
                     select distinct '{4}' Description,  -1 as CustomerID,  -1 as OutletID, -1 as CustomerGroupId, 1 as AllCustomers , '{4}' TypeDescription
                    from CustOutMustSellItem 
                    inner join Item On Item.ItemID = CustOutMustSellItem.ItemID
                    inner join itemcategory On ItemCategory.ItemCategoryID = item.ItemCategoryID AND ItemCategory.DivisionID IN ({7})
                    where CustomerID = -1 and OutletID = -1 and GroupID = -1
                     )CustOutMustSellItem where {1}  ", _requestRepository.LanguageId, searchFilter, ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer, _requestRepository.LanguageId)
                     , ResourcesManager.TranslateKey(MessagesConstants.Desc_Customer_Group, _requestRepository.LanguageId), ResourcesManager.TranslateKey(MessagesConstants.Desc_All_Customers, _requestRepository.LanguageId)
                     , orgAccessJoin, orgGroupAccessJoin, _requestRepository.CurrentOperator.DivisionAccess);

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})d",
                mainQuery);

                string selectionQuery = mainQuery + @$"{orderByFilter}
                OFFSET  {(filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize}
                ROWS
                FETCH NEXT {filter.CustomListFilter.PageSize}
                ROWS ONLY";
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success)
                {
                    mustSellItemsList.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        result = dbHelper.GetQueryList(selectionQuery, ref newMustSellItemsList);
                        mustSellItemsList.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                    mustSellItemsList.Data = newMustSellItemsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                newMustSellItemsList = null;
                return GlobalErrors.Error;
            }
        }
        private string DeleteMustSellItemsQuery(int customerId, int outletId, int customerGroupId)
        {
            string result = "";
            try
            {
                result += @$" delete from CustOutMustSellItem From CustOutMustSellItem
                            inner join Item On Item.ItemID = CustOutMustSellItem.ItemID
                            inner join itemcategory On ItemCategory.ItemCategoryID = item.ItemCategoryID and ItemCategory.DivisionID IN ({_requestRepository.CurrentOperator.DivisionAccess})
                             where customerid = {customerId} and outletId = {outletId} and groupId = {customerGroupId}";
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = "";
            }
            return result;
        }
        private string DeleteMustSellItemsExcludedOutletQuery(int customerGroupId)
        {
            string result = "";
            try
            {
                StringBuilder orgAccessJoin = new StringBuilder();
                StringBuilder orgGroupAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "MustSellItemsExcludedOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    orgGroupAccessJoin.Append($" inner join CustomerGroup CG  on CG.GroupID = MustSellItemsExcludedOutlet.GroupID and CG.OrganizationID in ({ _requestRepository.CurrentOperator.OrganizationAccess})");
                }
                result += @$" delete MustSellItemsExcludedOutlet from MustSellItemsExcludedOutlet
                            {orgAccessJoin}
                            {orgGroupAccessJoin}
                             where MustSellItemsExcludedOutlet.groupId = {customerGroupId}";
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = "";
            }
            return result;
        }
        public GlobalErrors DeletetMustSellItems(List<MustSellItemSharedTable> mustSellItemSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Empty;
                foreach (MustSellItemSharedTable mustSellItem in mustSellItemSharedTable)
                {
                    query += DeleteMustSellItemsQuery(mustSellItem.CustomerId, mustSellItem.OutletId, mustSellItem.CustomerGroupId);
                    query += DeleteMustSellItemsExcludedOutletQuery(mustSellItem.CustomerGroupId);
                }
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GettMustSellItems(MustSellItemSharedTable mustSellItemSharedTable, ref MustSellItem mustSellItem)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            DBHelper<CustomerModel> customerDbHelper = null;
            DBHelper<CustomerGroupModel> customerGroupDbHelper = null;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                List<ItemPackModel> items = new List<ItemPackModel>();
                customerGroupDbHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"select Item.ItemID, IsNull(Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName from CustOutMustSellItem 
                    inner join Item on Item.ItemID = CustOutMustSellItem.ItemID
                    inner join itemcategory On ItemCategory.ItemCategoryID = item.ItemCategoryID And ItemCategory.DivisionID IN ({4})
                    inner join ItemLanguage on ItemLanguage.ItemID = item.ItemID and ItemLanguage.LanguageId = {0} 
                    where CustOutMustSellItem.CustomerID = {1} and CustOutMustSellItem.OutletId = {2} and CustOutMustSellItem.GroupID = {3}", _requestRepository.LanguageId, mustSellItemSharedTable.CustomerId, mustSellItemSharedTable.OutletId, mustSellItemSharedTable.CustomerGroupId, _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.GetQueryList(query, ref items);
                if (result == GlobalErrors.Success && items != null && items.Count > 0)
                {
                    mustSellItem.items = items;
                    CustomerModel customer = new CustomerModel();
                    customerDbHelper = new DBHelper<CustomerModel>();
                    mustSellItem.allCustomers = mustSellItemSharedTable.AllCustomers;
                    if (mustSellItemSharedTable.CustomerId > 0)
                    {
                        query = string.Format(@"select distinct Customer.CustomerId, CustomerOutlet.OutletId, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName ,
                        IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName from CustOutMustSellItem 
                        Inner JOIN Customer on CustOutMustSellItem.CustomerId = Customer.CustomerId
                        Inner JOIN CustomerLanguage on CustOutMustSellItem.CustomerId = CustomerLanguage.CustomerId and CustomerLanguage.LanguageId = {0}
                        Inner JOIN CustomerOutlet on CustomerOutlet.customerid = CustOutMustSellItem.CustomerId and CustomerOutlet.OutletId = CustOutMustSellItem.OutletId
                        Inner JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.outletId = CustOutMustSellItem.OutletId and CustomerOutletLanguage.LanguageId = {0}
                        where CustOutMustSellItem.CustomerId = {1} and CustOutMustSellItem.OutletId = {2}", _requestRepository.LanguageId, mustSellItemSharedTable.CustomerId, mustSellItemSharedTable.OutletId);
                        result = customerDbHelper.GetQuerySingle(query, ref customer);
                        if (result == GlobalErrors.Success && customer != null)
                            mustSellItem.customers.Add(customer);
                    }
                    else if (mustSellItemSharedTable.CustomerGroupId > -1)
                    {
                        CustomerGroupModel customerGroup = new CustomerGroupModel();
                        query = string.Format(@" select distinct CustomerGroup.GroupID ,CustomerGroupLanguage.Description groupName from CustOutMustSellItem
                        inner join CustomerGroup on CustomerGroup.GroupID = CustOutMustSellItem.GroupID
                        inner join CustomerGroupLanguage on CustomerGroupLanguage.GroupID = CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID = {0}
                        where CustOutMustSellItem.GroupID = {1} ", _requestRepository.LanguageId, mustSellItemSharedTable.CustomerGroupId);
                        result = customerGroupDbHelper.GetQuerySingle(query, ref customerGroup);
                        if (result == GlobalErrors.Success && customerGroup != null)
                            mustSellItem.customerGroup.Add(customerGroup);
                    }
                    if (mustSellItemSharedTable.AllCustomers || mustSellItemSharedTable.CustomerGroupId > -1)
                    {
                        List<CustomerModel> excludedCustomers = new List<CustomerModel>();
                        query = string.Format(@"select distinct Customer.CustomerId, CustomerOutlet.OutletId, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName ,
                        IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName from MustSellItemsExcludedOutlet 
                        Inner JOIN Customer on MustSellItemsExcludedOutlet.CustomerId = Customer.CustomerId
                        Inner JOIN CustomerLanguage on MustSellItemsExcludedOutlet.CustomerId = CustomerLanguage.CustomerId and CustomerLanguage.LanguageId = {0}
                        Inner JOIN CustomerOutlet on CustomerOutlet.customerid = MustSellItemsExcludedOutlet.CustomerId and CustomerOutlet.OutletId = MustSellItemsExcludedOutlet.OutletId
                        Inner JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.outletId = MustSellItemsExcludedOutlet.OutletId and CustomerOutletLanguage.LanguageId = {0}
                        where MustSellItemsExcludedOutlet.GroupID = {1} ", _requestRepository.LanguageId, mustSellItemSharedTable.AllCustomers ? -1 : mustSellItemSharedTable.CustomerGroupId);
                        result = customerDbHelper.GetQueryList(query, ref excludedCustomers);
                        if (result == GlobalErrors.Success)
                            mustSellItem.excludeCustomers = excludedCustomers;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (customerDbHelper != null)
                {
                    customerDbHelper.Dispose();
                    customerDbHelper = null;
                }
                if (customerGroupDbHelper != null)
                {
                    customerGroupDbHelper.Dispose();
                    customerGroupDbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertMustSellItems(MustSellItem mustSellItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                result = InsertMustSellItemsExcludedOutlet(mustSellItems, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertMustSellItemsDetail(mustSellItems, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertNewCustomer(CustomerModel customerObj, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                bool isCustomerCodeExists = false;
                result = CheckCustomerCodeIfExist(customerObj.CustomerCode, ref isCustomerCodeExists);
                if (!isCustomerCodeExists)
                {
                    int maxCustomerID = GetMaxID(CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.CustomerID);
                    if (maxCustomerID == -1) return GlobalErrors.Error;
                    customerObj.CustomerId = maxCustomerID;
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    string sqlQuery = string.Format(@" insert into Customer (CustomerID,Phone,Fax,Email,CustomerCode,StreetID,StreetAddress,New, ContractNumber,CustomerCollector, CurrencyID ,IsDirectSales,CreatedBy, CreatedDate, UpdatedBy, UpdatedDate,IsDefault, AllowPayAllOutlets,PaymentTermID,OrganizationId,ExportCustomer)
                    values ({0},'{1}','{2}','{3}','{4}',{5},{6},{7},{8},{9},{10},{11},{12},{13},{12},{13},{14},{15},{16},{17},{18})",
                        customerObj.CustomerId,
                        customerObj.Phone,
                        customerObj.Fax,
                        customerObj.Email,
                        customerObj.CustomerCode.ToString().Replace("'", "''"),
                        customerObj.StreetId,
                        customerObj.StreetNumber,
                        Convert.ToInt32(customerObj.IsNewCustomer),
                        (customerObj.ContractNumber == null || customerObj.ContractNumber == string.Empty ? "NULL" : "'" + customerObj.ContractNumber.ToString() + "'"),
                        customerObj.CollectorId,
                        customerObj.CurrencyId,
                        Convert.ToInt32(customerObj.IsDirectSales),
                        _requestRepository.CurrentOperator == null ? -1 : _requestRepository.CurrentOperator.EmployeeId,
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                        customerObj.IsDefault ? 1 : 0,
                        customerObj.AllowPayAllOutlets ? 1 : 0,
                        customerObj.PaymentTermId,
                        _requestRepository.Configurations.ForceOrganizationSelectionOnLogin ?
                        (_requestRepository.CurrentOperator == null ? "1" : _requestRepository.CurrentOperator.OrganizationAccess) :
                        (_requestRepository.CurrentOperator == null ? 1 : _requestRepository.CurrentOperator.OrganizationId).ToString(),
                        customerObj.ExportCustomer ? 1 : 0
                        );
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                    if (result == GlobalErrors.Success)
                    {
                        if (customerObj.DescriptionLanguages == null || customerObj.DescriptionLanguages.Count == 0)
                        {
                            customerObj.DescriptionLanguages = new List<TextLanguage>();
                            TextLanguage ar = new TextLanguage();
                            ar.LanguageId = 2;
                            ar.Description = customerObj.CustomerName;
                            customerObj.DescriptionLanguages.Add(ar);
                            TextLanguage en = new TextLanguage();
                            en.LanguageId = 1;
                            en.Description = customerObj.CustomerName;
                            customerObj.DescriptionLanguages.Add(en);
                        }
                        if (customerObj.DescriptionLanguages != null && customerObj.DescriptionLanguages.Count > 0)
                        {
                            foreach (TextLanguage lang in customerObj.DescriptionLanguages)
                            {
                                string description = string.IsNullOrEmpty(lang.Description) ? customerObj.CustomerName : lang.Description;
                                sqlQuery = string.Format(@" insert into CustomerLanguage (CustomerID,Description,LanguageID,organizationId)
                            values ({0},'{1}',{2},{3})",
                                customerObj.CustomerId,
                                description.Replace("'", "''"), lang.LanguageId,
                                _requestRepository.CurrentOperator == null ? 1 : _requestRepository.CurrentOperator.OrganizationId
                        );
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                            }
                        }

                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = InsertCustomerOrganization(customerObj.CustomerId, _requestRepository.CurrentOperator == null ? 1 : _requestRepository.CurrentOperator.OrganizationId, dbHelper);
                    }
                    #region [New Customer Code Sequence]
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.NewCustomerCodeSequence != "")
                    {
                        sqlQuery = string.Format(@" update NewCustomerCodeSequence  set  MaxCustomerCode='{0}'", customerObj.CustomerCode);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                    #endregion
                    if (result == GlobalErrors.Success)
                    {
                        if (customerObj.Outlets != null && customerObj.Outlets.Count > 0)
                        {
                            foreach (CustomerOutletModel outletObj in customerObj.Outlets)
                            {
                                outletObj.CustomerId = maxCustomerID;
                                outletObj.HasPrivilegeOnPaymentTermDivision = customerObj.HasPrivilegeOnPaymentTermDivision;
                                outletObj.HasPrivilegeOnOnHoldDivision = customerObj.HasPrivilegeOnOnHoldDivision;

                                int dummyId = outletObj.OutletId;
                                result = InsertNewCustomerOutlet(outletObj, dbHelper);
                                if (result == GlobalErrors.Success && customerObj.OutletPayersList != null && customerObj.OutletPayersList.Any(x => x.OutletId == dummyId))
                                {
                                    customerObj.OutletPayersList.Where(x => x.OutletId == dummyId).ToList().ForEach(x =>
                                    {
                                        x.OutletId = outletObj.OutletId;
                                    });
                                }
                            }
                        }
                        else
                        {
                            errorMessage = MessagesConstants.MsgDefinitionOutlet;
                            result = GlobalErrors.Error;
                        }
                    }

                    if (result == GlobalErrors.Success && customerObj.IsDefault)
                    {
                        if (customerObj.Outlets.Count == 1)
                        {
                            //updat default customer and outlet for employee
                            if (customerObj.EmployeeId != -1)
                                result = InsertUpdateDefaultCustomer(maxCustomerID, customerObj.Outlets[0].OutletId, customerObj.EmployeeId, dbHelper, ref errorMessage);

                        }
                        else
                        {
                            errorMessage = MessagesConstants.MsgDefinitionOneOutletForAssignDefaultEmployee;
                            result = GlobalErrors.Error;
                        }
                    }


                    #region [Accounts]
                    if (result == GlobalErrors.Success && customerObj.AccountsList != null && customerObj.AccountsList.Count > 0)
                    {
                        result = SaveCustomerAccounts(customerObj, dbHelper);
                    }
                    #endregion

                    if (result == GlobalErrors.Success)
                    {
                        if (!string.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy))
                        {
                            string dummyCustomerFolder = LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId + "\\" + "-1";
                            if (Directory.Exists(dummyCustomerFolder))
                            {
                                Directory.Move(dummyCustomerFolder, dummyCustomerFolder.Replace("\\-1", "\\" + customerObj.CustomerId.ToString()));//Rename the folder by replacing -1 which represent the id of the new customer with the real new customer id 
                                dummyCustomerFolder = dummyCustomerFolder.Replace("\\-1", "\\" + customerObj.CustomerId.ToString());
                                foreach (CustomerOutletModel outlet in customerObj.Outlets)
                                {
                                    result = RenameNewOutletDummyFolders(dummyCustomerFolder, outlet.OutletId.ToString(), outlet.DummyOutletID.ToString());
                                    if (result != GlobalErrors.Success)
                                    {
                                        break;
                                    }
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = MoveOutletAttachmentFoldersToDestinationFolder(customerObj.CustomerId.ToString());
                            }
                        }
                    }
                    #region[CustomerPackBarcode]
                    if (result == GlobalErrors.Success && customerObj.CustomerPackBarcodeList != null && customerObj.CustomerPackBarcodeList.Count > 0)
                    {
                        result = InsertCustomerPackBarcode(customerObj, dbHelper);
                    }
                    #endregion
                    #region [OutletPayerAccount]
                    if (result == GlobalErrors.Success && customerObj.OutletPayersList != null && customerObj.OutletPayersList.Count > 0)
                    {
                        result = SaveOutletPayerAccount(customerObj, dbHelper);
                    }
                    #endregion
                }
                else
                {
                    result = GlobalErrors.DataAlreadyExists;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertCustomerPackBarcode(CustomerModel customerObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                int start = 0;
                int end = 0;
                int i = 0;
                if (customerObj.CustomerPackBarcodeList.Count > 1000)
                {
                    end = 1000;
                }
                else
                {
                    end = customerObj.CustomerPackBarcodeList.Count;
                }
                while (end <= customerObj.CustomerPackBarcodeList.Count)
                {
                    StringBuilder values = new StringBuilder();
                    for (i = start; i < end; i++)
                    {
                        if (customerObj.CustomerPackBarcodeList[i].CustomerPackBarcode != null && customerObj.CustomerPackBarcodeList[i].CustomerPackBarcode != string.Empty && customerObj.CustomerPackBarcodeList[i].CustomerPackBarcode.Trim() != string.Empty)
                        {
                            values.AppendFormat("({0},{1},'{2}'),", customerObj.CustomerId, customerObj.CustomerPackBarcodeList[i].PackId, customerObj.CustomerPackBarcodeList[i].CustomerPackBarcode.ToString().Replace("'", "''"));
                        }
                    }
                    if (values.Length > 0)
                    {
                        query = string.Format(@"Insert Into CustomerPackBarcode ( CustomerID, PackID, Barcode) Values {0}", values.ToString().TrimEnd(','));
                        result = dBHelper.ExecuteNonQuery(query);
                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    start = i;
                    if (customerObj.CustomerPackBarcodeList.Count == end)
                    {
                        break;
                    }
                    if (customerObj.CustomerPackBarcodeList.Count - end > 1000)
                    {
                        end = end + 1000;
                    }
                    else
                    {
                        end = end + (customerObj.CustomerPackBarcodeList.Count - end);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCustomerPackBarcode(int customerId, string packIds, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete from CustomerPackBarcode where CustomerID = {0} and PackID in ({1})", customerId, packIds);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertICashCustomer(ICashEntryModel icashObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                int maxICashID = GetMaxID("ICash", "iCashListID");
                if (maxICashID == -1) return GlobalErrors.Error;
                icashObj.ICashListID = maxICashID;
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string sqlQuery = string.Empty;

                #region Insert ICash Master
                sqlQuery = string.Format(@"INSERT INTO ICash
                                                   (
                                                       iCashListID,
                                                       iCashListCode,
                                                       OrganizationID,
                                                       StartDate,
                                                       EndDate,
                                                       Inactive
                                                   )
                                                   VALUES({0}, '{1}', {2}, {3},{4},{5})",
                                                   icashObj.ICashListID,
                                                   icashObj.ICashCode,
                                                   icashObj.OrganizationID,
                                                   LocalUtilities.ParseDateAndTimeToSQL(icashObj.FromToDate[0].Date),
                                                   LocalUtilities.ParseDateAndTimeToSQL(icashObj.FromToDate[1].Date),
                                                   icashObj.IsInactive ? 1 : 0
                                                   );
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                #endregion

                #region Insert ICash Details
                if (result == GlobalErrors.Success)
                {
                    if (icashObj.ICashDetailsModel != null && icashObj.ICashDetailsModel.Count > 0)
                    {
                        foreach (var item in icashObj.ICashDetailsModel)
                        {
                            sqlQuery = string.Format(@"INSERT INTO ICashDetails
                                                       (
                                                           iCashListID,
                                                           InputDetail,
                                                           OutputDetail
                                                       )VALUES({0},{1},{2})",
                                                       icashObj.ICashListID,
                                                       item.AmountToBuy,
                                                       item.AmountToGet
                                                       );
                            result = dbHelper.ExecuteNonQuery(sqlQuery);
                            if (result != GlobalErrors.Success) break;
                        }

                    }
                }
                #endregion

                #region Insert ICash Assignment
                if (!icashObj.AllCustomers && icashObj.AppliedGroups.Count == 0 && icashObj.AppliedChannels.Count == 0 && icashObj.AppliedCustomers.Count == 0)
                {
                    return GlobalErrors.Error;
                }
                else
                {
                    if (icashObj.AllCustomers)
                    {
                        sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                    icashObj.ICashListID, 0, -1, -1, -1, -1, -1, 1);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);

                    }
                    else
                    {
                        int counter = 0;
                        #region Insert Groups

                        if (icashObj.AppliedGroups != null && icashObj.AppliedGroups.Count > 0)
                        {
                            foreach (var item in icashObj.AppliedGroups)
                            {
                                sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                    icashObj.ICashListID, counter, -1, -1, item.GroupId, -1, -1, 0);
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                                counter++;
                                if (result != GlobalErrors.Success) break;

                            }
                        }
                        #endregion

                        #region Insert Channels
                        if (icashObj.AppliedChannels != null && icashObj.AppliedChannels.Count > 0)
                        {
                            int ChannelId = 0;
                            int SubChannelId = 0;
                            foreach (var item in icashObj.AppliedChannels)
                            {
                                var ChannelSubChannelIds = item.ChannelSubChannelIds.Split("-");
                                if (ChannelSubChannelIds.Length > 0)
                                {
                                    ChannelId = Convert.ToInt32(ChannelSubChannelIds[0]);
                                    SubChannelId = Convert.ToInt32(ChannelSubChannelIds[1]);
                                }
                                else
                                {
                                    result = GlobalErrors.Error; break;
                                }

                                sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                    icashObj.ICashListID, counter, -1, -1, -1, ChannelId, SubChannelId, 0);
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                                counter++;
                                if (result != GlobalErrors.Success) break;

                            }
                        }
                        #endregion

                        #region Insert Customers
                        if (icashObj.AppliedCustomers != null && icashObj.AppliedCustomers.Count > 0)
                        {
                            foreach (var item in icashObj.AppliedCustomers)
                            {
                                sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                    icashObj.ICashListID, counter, item.CustomerId, item.OutletId, -1, -1, -1, 0);
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                                counter++;
                                if (result != GlobalErrors.Success) break;

                            }
                        }
                        #endregion

                    }
                }
                #endregion

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors UpdateICashCustomer(ICashEntryModel icashObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {


                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string sqlQuery = string.Empty;
                var StartDateModel = new DateTime();
                var EndDateModel = new DateTime();

                #region Update ICash Master

                if (icashObj.FromToDate.Count == 0)
                {
                    StartDateModel = icashObj.StartDate.Value;
                    EndDateModel = icashObj.EndDate.Value;
                }
                else
                {
                    StartDateModel = icashObj.FromToDate[0].Date;
                    EndDateModel = icashObj.FromToDate[1].Date;
                }
                sqlQuery = string.Format(@"UPDATE ICash 
                                           SET iCashListCode = '{0}' ,
                                               OrganizationID = {1} ,
                                               StartDate = {2} ,
                                               EndDate = {3} ,
                                               Inactive = {4}
                                               WHERE iCashListID = {5} ",
                                                   icashObj.ICashCode,
                                                   icashObj.OrganizationID,
                                                   LocalUtilities.ParseDateAndTimeToSQL(StartDateModel),
                                                   LocalUtilities.ParseDateAndTimeToSQL(EndDateModel),
                                                   icashObj.IsInactive ? 1 : 0,
                                                   icashObj.ICashListID
                                                   );
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                #endregion

                #region Update ICash Details
                if (result == GlobalErrors.Success)
                {
                    if (icashObj.ICashDetailsModel != null && icashObj.ICashDetailsModel.Count > 0)
                    {
                        string deleteQuery = string.Format(@"DELETE FROM ICashDetails WHERE iCashListID = {0}", icashObj.ICashListID);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in icashObj.ICashDetailsModel)
                            {
                                sqlQuery = string.Format(@"INSERT INTO ICashDetails
                                                       (
                                                           iCashListID,
                                                           InputDetail,
                                                           OutputDetail
                                                       )VALUES({0},{1},{2})",
                                                           icashObj.ICashListID,
                                                           item.AmountToBuy,
                                                           item.AmountToGet
                                                           );
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                                if (result != GlobalErrors.Success) break;
                            }
                        }

                    }
                }
                #endregion

                #region Insert ICash Assignment
                if (!icashObj.AllCustomers && icashObj.AppliedGroups.Count == 0 && icashObj.AppliedChannels.Count == 0 && icashObj.AppliedCustomers.Count == 0)
                {
                    return GlobalErrors.Error;
                }
                else
                {
                    string deleteQuery = string.Empty;
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {

                        StringBuilder orgAccessJoin = new StringBuilder();
                        if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                        }

                        string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (GroupID is not null or GroupID <> -1) " : string.Empty;
                        string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                        deleteQuery = $@"DELETE FROM ICashAssignment WHERE iCashListID = {icashObj.ICashListID} and ((ChannelID <> -1 or ChannelID is not null)
                                        or (SubChannelID <> -1 or SubChannelID is not null) or AllCustomers = 1 {deleteGroups} {deleteCustomers} )";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                        {
                            deleteQuery = $@" DELETE ICA FROM ICashAssignment ICA                               
                                           inner join CustomerGroup CG  on CG.GroupID = ICA.GroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE ICA.iCashListID = {icashObj.ICashListID} ";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                        }
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            deleteQuery = $@" DELETE ICA FROM ICashAssignment ICA 
                                           inner join CustomerOutlet CO on CO.CustomerID = ICA.CustomerID and CO.OutletID = ICA.OutletID
                                           { orgAccessJoin }
                                           WHERE ICA.iCashListID = {icashObj.ICashListID} ";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                        }
                    }
                    else
                    {
                        deleteQuery = string.Format(@"DELETE FROM ICashAssignment WHERE iCashListID = {0}", icashObj.ICashListID);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                    }
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;




                    if (result == GlobalErrors.Success)
                    {
                        if (icashObj.AllCustomers)
                        {

                            sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                   icashObj.ICashListID, 0, -1, -1, -1, -1, -1, 1);
                            result = dbHelper.ExecuteNonQuery(sqlQuery);

                        }
                        else
                        {
                            int counter = 0;
                            #region Update Groups

                            if (icashObj.AppliedGroups != null && icashObj.AppliedGroups.Count > 0)
                            {
                                foreach (var item in icashObj.AppliedGroups)
                                {

                                    sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                    icashObj.ICashListID, counter, -1, -1, item.GroupId, -1, -1, 0);
                                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                                    counter++;
                                    if (result != GlobalErrors.Success) break;

                                }
                            }
                            #endregion

                            #region Update Channels
                            if (icashObj.AppliedChannels != null && icashObj.AppliedChannels.Count > 0)
                            {
                                int ChannelId = 0;
                                int SubChannelId = 0;
                                foreach (var item in icashObj.AppliedChannels)
                                {
                                    var ChannelSubChannelIds = item.ChannelSubChannelIds.Split("-");
                                    if (ChannelSubChannelIds.Length > 0)
                                    {
                                        ChannelId = Convert.ToInt32(ChannelSubChannelIds[0]);
                                        SubChannelId = Convert.ToInt32(ChannelSubChannelIds[1]);
                                    }
                                    else
                                    {
                                        result = GlobalErrors.Error; break;
                                    }

                                    sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                        icashObj.ICashListID, counter, -1, -1, -1, ChannelId, SubChannelId, 0);

                                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                                    counter++;
                                    if (result != GlobalErrors.Success) break;

                                }
                            }
                            #endregion

                            #region Update Customers
                            if (icashObj.AppliedCustomers != null && icashObj.AppliedCustomers.Count > 0)
                            {
                                foreach (var item in icashObj.AppliedCustomers)
                                {

                                    sqlQuery = string.Format(@"INSERT INTO ICashAssignment
                                               (
                                                   iCashListID,
                                                   AssignmentID,
                                                   CustomerID,
                                                   OutletID,
                                                   GroupID,
                                                   ChannelID,
                                                   SubChannelID,
                                                   AllCustomers
                                               )
                                               VALUES
                                               ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7})",
                                                   icashObj.ICashListID, counter, item.CustomerId, item.OutletId, -1, -1, -1, 0);
                                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                                    counter++;
                                    if (result != GlobalErrors.Success) break;

                                }
                            }
                            #endregion

                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
                #endregion

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }


        public GlobalErrors InsertNewCustomerClass(CustomerClassModel customerClass)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                int maxCustomerID = GetMaxID(CoreDataBaseConstants.TableNames.CustomerClass, CoreDataBaseConstants.QueryColumnsNames.CustomerClassID);
                if (maxCustomerID == -1) return GlobalErrors.Error;
                customerClass.CustomerClassId = maxCustomerID;
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" insert into CustomerClass (CustomerClassID,Code)
                    values ({0},'{1}')"
                    , customerClass.CustomerClassId, customerClass.CustomerClassCode);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    if (customerClass.DescriptionLanguages != null && customerClass.DescriptionLanguages.Count > 0)
                    {
                       
                        foreach (TextLanguage lang in customerClass.DescriptionLanguages)
                        {
                        
                            string description = string.IsNullOrEmpty(lang.Description.Trim()) ? customerClass.CustomerClassName : lang.Description;

                            sqlQuery = string.Format(@" insert into CustomerClassLanguage (CustomerClassID,Description,LanguageID)
                    values ({0},'{1}',{2})"
                    , customerClass.CustomerClassId, description.Replace("'", "''"), lang.LanguageId);
                            result = dbHelper.ExecuteNonQuery(sqlQuery);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors InsertNewCustomerGroup(ref CustomerGroupModel groupObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                int maxGroupID = GetMaxID(CoreDataBaseConstants.TableNames.CustomerGroup, CoreDataBaseConstants.QueryColumnsNames.GroupID);
                if (maxGroupID == -1) return GlobalErrors.Error;
                groupObj.GroupId = maxGroupID;
                groupObj.GroupCodeName = groupObj.GroupCode + ' ' + '-' + ' ' + groupObj.GroupName;
                string channelSubChannelColumns = string.Empty;
                string channelSubChannelValues = string.Empty;
                if (groupObj.ChannelId > 0 && groupObj.SubChannelId > 0)
                {
                    channelSubChannelColumns = " , ChannelID, SubChannelID ";
                    channelSubChannelValues = $" , {groupObj.ChannelId} , {groupObj.SubChannelId}";
                }
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" insert into CustomerGroup (GroupID,GroupCode,OrganizationID {3})
                    values ({0},'{1}',{2} {4})"
                    , groupObj.GroupId, groupObj.GroupCode, groupObj.OrganizationId, channelSubChannelColumns, channelSubChannelValues);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@" insert into CustomerGroupLanguage (GroupID,Description,LanguageID)
                    values ({0},'{1}',{2})"
                    , groupObj.GroupId, groupObj.GroupName, _requestRepository.LanguageId);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors InsertUpdateDefaultCustomer(int customerID, int outletID, int employeeID, DBHelper<int> dBHelper, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null) dBHelper = new DBHelper<int>();
                if (employeeID != -1)
                {
                    string query = string.Format(@"
                            UPDATE Employee SET CustomerID = -1, OutletID = -1 WHERE CustomerID = {0};
                            UPDATE Employee SET CustomerID = {0}, OutletID = {1} WHERE EmployeeID = {2};", customerID, outletID, employeeID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                else
                {
                    string query = string.Format(@"
                            UPDATE Employee SET CustomerID = -1, OutletID = -1 WHERE CustomerID = {0};", customerID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertNewCustomerOutlet(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int maxOutletID = GetMaxOutletID(outletObj.CustomerId, dbHelper);
                if (maxOutletID == -1) return GlobalErrors.Error;
                outletObj.OutletId = maxOutletID;

                if (dbHelper == null) dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" insert into CustomerOutlet (CustomerID, OutletID, CustomerCode, Barcode, Phone, Fax, Email, Taxeable, CurrencyID,
                    OnHold, StreetID,Inactive, Notes, PaymentTermID, CustomerTypeID, CreatedBy, TradeLicenceNumber,BillsOpenNumber,
                    CustomerClassID,PreferredVisitTimeFrom,PreferredVisitTimeTo,CommissionerOfReceipt,CreatedDate,
                    OpenTime, CloseTime, TW1Start, TW1Stop, TW2Start, TW2Stop, FixedServiceTime, VariableServiceTime,
                    UpdatedDate,GPSLatitude,GPSLongitude,ShopNumber,RoadNumber,BlockNumber,PlateNumber,DriverName,DriverMobileNumber,Brand, 
                    IsMain, OutletCollectorID, CustomerSubClassID, TaxNumber,VendorNumber,CreditCardInfo,BlockName,Landmark,Compound,BldgName,
                    FlatNumber ,CreditCardName , CreditCardCVV ,CreditCardExpiryDate, IsHiglighted, UpdatedBy, GLN, ZipCode, 
                    CountryID,StateID,CityID,AreaID,BuildingNumber, WarehouseID,CompanyPrefix,IsBusinessCustomer,IsVendingMachine , OrganizationID,TradeLicenceExpiryDate , CustomerStatusID,TradeLicenceName) values 
                    ({0},{1},'{2}','{3}',{4},{5},{6},{7},{8},{9},'{10}',{11},'{12}',{13},{14},{15},'{16}',{17},{18},{19},{20},'{21}',{22},'{23}',
                    '{24}','{25}','{26}','{27}','{28}',{29},{30},{31},{32},{33},'{34}','{35}','{36}','{37}','{38}','{39}','{40}',{41},{42},{43},
                    '{44}','{45}','{46}','{47}','{48}','{49}','{50}','{51}' ,'{52}','{53}' ,{54}, {55}, {56}, {57}'{58}','{59}','{60}','{61}','{62}','{63}',{64},{65},{66},{67},{68},{69},{70},{71},'{72}')",

                        outletObj.CustomerId,//0
                    outletObj.OutletId,//1
                    outletObj.OutletCode.ToString().Replace("'", "''"),//2
                    outletObj.Barcode.ToString().Replace("'", "''"),//3
                    outletObj.Phone == null ? "" : "'" + outletObj.Phone + "'",//4
                    outletObj.Fax == null ? "" : "'" + outletObj.Fax + "'",//5
                    outletObj.Email == null ? "" : "'" + outletObj.Email.Replace("'", "''") + "'",//6
                    outletObj.Taxable ? "1" : "0",//7
                    outletObj.CurrencyId,//8
                    outletObj.OnHold ? "1" : "0",//9
                    outletObj.StreetId,//10
                    outletObj.Inactive ? "1" : "0",//11
                    outletObj.Notes.Replace("'", "''"),//12
                    outletObj.PaymentTermId,//13
                    outletObj.CustomerTypeId,//14
                    _requestRepository.CurrentOperator == null ? -1 : _requestRepository.CurrentOperator.EmployeeId,//15
                    outletObj.TradeLicenceNumber,//16
                    outletObj.BillsNumber,//17
                    outletObj.CustomerClassId,//18
                    "NULL",//LocalUtilities.ParseDateAndTimeToSQL(outletObj.PreferredVisitTimeFrom),//19
                    "NULL",//LocalUtilities.ParseDateAndTimeToSQL(outletObj.PreferredVisitTimeTo),//20
                    outletObj.CommissionerOfReceipt,//21
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//22 outletObj.CreatedDate
                    "",// outletObj.OpenTime,//23
                    "",//outletObj.CloseTime,//24
                    "",//outletObj.TW1Start,//25
                    "",//outletObj.TW1Stop,//26
                    "",// outletObj.TW2Start,//27
                    "",//outletObj.TW2Stop,//28
                    "0",//outletObj.FixedServiceTime,//29
                    "0",//outletObj.VariableServiceTime,//30
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//31//outletObj.CreatedDate
                    outletObj.GPSLatitude,//32
                    outletObj.GPSLongitude,//33
                    "",// outletObj.ShopNumber,//34
                    "",// outletObj.RoadNumber,//35
                    "",// outletObj.BlockNumber,//36
                    "",// outletObj.PlateNumber.Replace("'", "''"),//37
                    "",//outletObj.DriverName.Replace("'", "''"),//38
                    "",//outletObj.DriverMobileNumber.Replace("'", "''"),//39
                    "",// outletObj.Brand.Replace("'", "''"),//40
                    (outletObj.IsMain ? "1" : "0"),//41 
                    "null",// (outletObj.CollectorID == -1 ? "Null" : outletObj.CollectorID.ToString()),//42
                    outletObj.CustomerSubClassId,//43
                    outletObj.TaxNumber == null ? "" : outletObj.TaxNumber.Replace("'", "''"),//44
                    outletObj.VendorNumber == null ? "" : outletObj.VendorNumber.Replace("'", "''"),//45
                    (outletObj.CreditCardNumber != null ? outletObj.CreditCardNumber.Replace("'", "''") : ""),//46
                    "",//outletObj.BlockName.Replace("'", "''"),//47
                    outletObj.Landmark == null ? "":outletObj.Landmark.Replace("'", "''"),//48
                    "",//outletObj.Compound.Replace("'", "''"),//49
                    "",//outletObj.BldgName.Replace("'", "''"),//50
                    "",//outletObj.FlatNumber.Replace("'", "''"),//51
                    "",// outletObj.CreditCardName.Replace("'", "''"),//52
                    "",// outletObj.CreditCardCVV.Replace("'", "''"),//53
                    "null",// (outletObj.CreditCardExpiryDate == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateAndTimeToSQL(outletObj.CreditCardExpiryDate)),//54
                    outletObj.IsHighlighted ? "1" : "0",//55
                    _requestRepository.CurrentOperator == null ? -1 : _requestRepository.CurrentOperator.EmployeeId,//56
                    string.Empty,//outletObj.MachineTypeId == -1 ? "null" : outletObj.MachineTypeId.ToString(),//57
                    outletObj.GLN.Replace("'", "''"),//58
                    outletObj.ZipCode.Replace("'", "''"), //59
                    outletObj.CountryId, //60
                    outletObj.StateId, //61
                    outletObj.CityId, //62
                    outletObj.AreaId, //63
                    !string.IsNullOrEmpty(outletObj.BuildingNumber) ? "'" + outletObj.BuildingNumber.ToString().Replace("'", "''") + "'" : "NULL", //64
                    outletObj.WarehouseId == -1 ? "NULL" : outletObj.WarehouseId.ToString(), //65
                    outletObj.CompanyPrefix == -1 ? "NULL" : outletObj.CompanyPrefix.ToString(), //66
                    outletObj.IsBusinessCustomer ? "1" : "0", //67
                    outletObj.IsVendingMachine ? "1" : "0", //68
                    _requestRepository.Configurations.ForceOrganizationSelectionOnLogin ? 
                    (_requestRepository.CurrentOperator == null ? "1" : _requestRepository.CurrentOperator.OrganizationAccess) : 
                    (_requestRepository.CurrentOperator == null ? 1 : _requestRepository.CurrentOperator.OrganizationId).ToString(), // 69
                    outletObj.TradeLicenceExpiryDateModel.Date == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(outletObj.TradeLicenceExpiryDateModel.Date), //70
                    outletObj.CustomerStatusId, // 71
                    outletObj.TradeLicenceName //72
                    );
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    List<int> langIds = new List<int>();
                    if(outletObj.DescriptionLanguages == null || outletObj.DescriptionLanguages.Count == 0)
                    {
                        outletObj.DescriptionLanguages = new List<TextLanguage>();
                        TextLanguage ar = new TextLanguage();
                        outletObj.DescriptionLanguages.Add(ar);
                        ar.LanguageId = 2;
                        ar.Description = outletObj.OutletName;
                        TextLanguage en = new TextLanguage();
                        en.LanguageId = 1;
                        en.Description = outletObj.OutletName;
                        outletObj.DescriptionLanguages.Add(en);
                    }
                        if (outletObj.DescriptionLanguages != null && outletObj.DescriptionLanguages.Count > 0)
                    {
                        langIds.AddRange(outletObj.DescriptionLanguages.Select(a => a.LanguageId).ToList());
                    }
                    if (outletObj.AddressLanguages != null && outletObj.AddressLanguages.Count > 0)
                    {
                        langIds.AddRange(outletObj.AddressLanguages.Select(a => a.LanguageId).ToList());
                    }
                    if (outletObj.Address2Languages != null && outletObj.Address2Languages.Count > 0)
                    {
                        langIds.AddRange(outletObj.Address2Languages.Select(a => a.LanguageId).ToList());
                    }
                    langIds = langIds.Distinct().ToList();
                    int tempIndex = -1;
                    string tempDescription = string.Empty;
                    string tempAddress = string.Empty;
                    string tempAddress2 = string.Empty;
                    foreach (int langId in langIds)
                    {
                        tempDescription = string.Empty;
                        tempAddress = string.Empty;
                        tempAddress2 = string.Empty;
                        tempIndex = outletObj.DescriptionLanguages.FindIndex(a => a.LanguageId == langId);
                        if (tempIndex > -1)
                        {
                            tempDescription = string.IsNullOrEmpty(outletObj.DescriptionLanguages[tempIndex]?.Description) ? outletObj.OutletName : outletObj.DescriptionLanguages[tempIndex].Description;
                        }
                        if(outletObj.AddressLanguages != null)
                        {
                            tempIndex = outletObj.AddressLanguages.FindIndex(a => a.LanguageId == langId);
                            if (tempIndex > -1)
                            {
                                tempAddress = string.IsNullOrEmpty(outletObj.AddressLanguages[tempIndex]?.Description) ? outletObj.Address : outletObj.AddressLanguages[tempIndex].Description;
                            }
                        }
                        if(outletObj.Address2Languages != null)
                        {
                            tempIndex = outletObj.Address2Languages.FindIndex(a => a.LanguageId == langId);
                            if (tempIndex > -1)
                            {
                                tempAddress2 = string.IsNullOrEmpty(outletObj.Address2Languages[tempIndex]?.Description) ? outletObj.Address2 : outletObj.Address2Languages[tempIndex].Description;
                            }
                        }
                        sqlQuery = string.Format(@" INSERT INTO CustomerOutletLanguage (CustomerID,OutletID,Description,Address,Address2,LanguageID) VALUES ({0},{1},{2},{3},{5},{4})"
                                      , outletObj.CustomerId, outletObj.OutletId,
                                      string.IsNullOrEmpty(tempDescription) ? "NULL" : "'" + tempDescription.Replace("'", "''") + "'",
                                      string.IsNullOrEmpty(tempAddress) ? "NULL" : "'" + tempAddress.Replace("'", "''") + "'",
                                      langId,
                                      string.IsNullOrEmpty(tempAddress2) ? "NULL" : "'" + tempAddress2.Replace("'", "''") + "'");
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                if (result == GlobalErrors.Success && outletObj.IsFromSuperVisorApp)
                {
                    sqlQuery = string.Format(@"update C
                                                set C.CustomerCode = {0} , CL.Description = {1}
                                                from customer C
                                                    Inner join CustomerLanguage CL on
                                                    C.CustomerID = s.CustomerID", outletObj.OutletName, outletObj.CustomerCode);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
                if (result == GlobalErrors.Success && outletObj.IsThereAnyGroupAchievementPromotions)
                {
                    result = HandleOutletGroupAchievementPromotions(outletObj, false, dbHelper);
                }
                //Add assigned Customer Groups
                if (result == GlobalErrors.Success)
                {
                    result = AddAssignedGroupsToOutlet(outletObj, dbHelper);
                }
                //if (result == GlobalErrors.Success)
                //{
                //    result = _machineCustomerManager.SaveCustomerMachine(outletObj.MachineTypeId, outletObj.CustomerId, outletObj.OutletId, outletObj.MachineData, dbHelper);
                //}
                if (result == GlobalErrors.Success && outletObj.CustomerTypeId != CustomerTypes.CashCustomer.GetHashCode() && outletObj.HasPrivilegeOnPaymentTermDivision && outletObj.OutletDivisionPaymentTermList != null && outletObj.OutletDivisionPaymentTermList.Count > 0)
                {
                    result = SaveOutletDivisionPaymentTerms(outletObj, dbHelper);
                }
                if (result == GlobalErrors.Success && outletObj.HasPrivilegeOnOnHoldDivision)
                {
                    result = SaveOutletOnHoldDivisions(outletObj, dbHelper);
                }
                if (result == GlobalErrors.Success && outletObj.IsNeedToSaveOperator)
                {
                    result = SaveOutletOperator(outletObj, dbHelper);
                }
                if (result == GlobalErrors.Success && outletObj.CustomerOutletContacts != null && outletObj.CustomerOutletContacts.Count > 0)
                {
                    result = SaveCustomerOutletContacts(outletObj.CustomerOutletContacts, outletObj.CustomerId, outletObj.OutletId, dbHelper);
                }
                if (result == GlobalErrors.Success && outletObj.IsNewCustomer)
                {
                    sqlQuery = string.Format(@"update Customer set new = 0  where CustomerID={0} and OutletID={1}",
                           outletObj.CustomerId, outletObj.OutletId);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
                #region [New Outlet Code Sequence]
                if (result == GlobalErrors.Success && _requestRepository.Configurations.NewOutletCodeSequence != "")
                {
                    sqlQuery = string.Format(@" update NewOutletCodeSequence  set  MaxOutletCode='{0}'", outletObj.OutletCode);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
                #endregion

                #region[Sales Distribution Channels]
                if (result == GlobalErrors.Success && outletObj.SalesDistributionChannels != null && outletObj.SalesDistributionChannels.Count > 0 && _requestRepository.Configurations.EnableSalesDistributionChannel)
                {
                    result = InsertSalesDistributionChannelsForOutlet(outletObj, dbHelper);
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        #region[Groups Achievement Promotions Methods]
        public GlobalErrors HandleOutletGroupAchievementPromotions(CustomerOutletModel outletObj, bool isEditMode, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> customerGroupsIds = outletObj.Groups.Select(g => g.GroupId).ToList();
                List<int> groupsToBeAdded = new List<int>();
                List<int> groupsToBeDeleted = new List<int>();
                if (isEditMode)
                {
                    result = PrepareEditCustomerLists(customerGroupsIds, ref groupsToBeAdded, ref groupsToBeDeleted, outletObj.CustomerId, outletObj.OutletId, dBHelper);
                }
                else
                {
                    groupsToBeAdded = outletObj.Groups.Select(g => g.GroupId).ToList();
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    foreach (int groupId in groupsToBeAdded)
                    {
                        result = _promotionManager.AddCustomerPromotionDataRelatedToCustomerGroup(groupId, outletObj.CustomerId, outletObj.OutletId, outletObj.IncludedGroupAchievementPromotions, outletObj.ExcludedGroupAchievementPromotions, dBHelper);
                        if (result != GlobalErrors.Success) break;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        foreach (int deletedGroupId in groupsToBeDeleted)
                        {
                            result = _promotionManager.DeleteCustomerPromotionDataRelatedToCustomerGroup(deletedGroupId, outletObj.CustomerId, outletObj.OutletId, outletObj.IncludedGroupAchievementPromotions, outletObj.ExcludedGroupAchievementPromotions, dBHelper);
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareEditCustomerLists(List<int> customerGroupIds, ref List<int> groupsToBeAdded, ref List<int> groupsToBeDeleted, int customerId, int outletId, DBHelper<int> dBHelper)
        {

            GlobalErrors result = GlobalErrors.Success;
            List<int> originalGroupsInDB = null;
            try
            {
                originalGroupsInDB = new List<int>();
                groupsToBeAdded = new List<int>();
                groupsToBeDeleted = new List<int>();

                string query = $"Select GroupID from customeroutletGroup where CustomerID={customerId} and OutletId={outletId}";
                result = dBHelper.GetQueryList(query, ref originalGroupsInDB);
                if (originalGroupsInDB == null)
                    originalGroupsInDB = new List<int>();
                if (result == GlobalErrors.Success)
                {
                    // Fill newly added groups by looping through the edited group ids, if a group id does not exist in the originalGroupsInDB,
                    // add group id to groupsToBeAdded.
                    foreach (int groupId in customerGroupIds)
                    {
                        if (!originalGroupsInDB.Contains(groupId))
                        {
                            if (!groupsToBeAdded.Contains(groupId)) groupsToBeAdded.Add(groupId);
                        }
                    }
                    // Fill deleted groups by looping through the originalGroupsInDB, if a group id does not exist in the edited group ids
                    // add group id to groupsToBeAdded
                    foreach (int dbGroupId in originalGroupsInDB)
                    {
                        if (!customerGroupIds.Contains(dbGroupId))
                        {
                            if (!groupsToBeDeleted.Contains(dbGroupId)) groupsToBeDeleted.Add(dbGroupId);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        public GlobalErrors SaveCustomerOutletContacts(List<CustomerOutletContactModel> customerOutletContacts, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            int contactId = -1;
            try
            {
                contactId = GetMaxContactID(dbHelper);
                string sqlQuery = string.Format(@"delete from ContactLanguage where ContactID in (Select ContactID from Contact where CustomerID = {0} AND OutletID = {1})",
                    customerId, outletId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;


                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"delete from Contact where CustomerID={0} and OutletID={1}",
                    customerId, outletId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    foreach (CustomerOutletContactModel outletContacts in customerOutletContacts)
                    {
                        sqlQuery = string.Format(@"INSERT INTO Contact (ContactID, Mobile, Phone1, StreetID, Fax, CustomerID, OutletID, Email) 
                        VALUES ({0}, {1}, {2}, {3}, {4}, {5}, {6}, '{7}')",
                            contactId,
                            outletContacts.Mobile,
                            outletContacts.Phone,
                            outletContacts.Street,
                            outletContacts.Fax,
                            customerId,
                            outletId,
                            outletContacts.Email.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                        if (result != GlobalErrors.Success)
                        {
                            break;
                        }

                        foreach (TextLanguage text in outletContacts.ContactDescriptionsLanguages)
                        {
                            if (string.IsNullOrEmpty(text.Description) && _requestRepository.LanguageId != text.LanguageId)
                            {
                                text.Description = outletContacts.ContactDescriptionsLanguages.Find(x => x.LanguageId == _requestRepository.LanguageId).Description;
                            }
                            sqlQuery = string.Format(@"INSERT INTO ContactLanguage VALUES ({0}, {1}, '{2}', NULL, NULL)",
                                contactId,
                                text.LanguageId,
                                text.Description.Replace("'", "''"));
                            result = dbHelper.ExecuteNonQuery(sqlQuery);
                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }

                        foreach (TextLanguage address in outletContacts.AddressDescriptionsLanguages)
                        {
                            if (string.IsNullOrEmpty(address.Description) && _requestRepository.LanguageId != address.LanguageId)
                            {
                                var addressObj = outletContacts.AddressDescriptionsLanguages.Find(x => x.LanguageId == _requestRepository.LanguageId);
                                if (addressObj != null)
                                    address.Description = addressObj.Description;
                            }
                            if (!string.IsNullOrEmpty(address.Description))
                            {
                                sqlQuery = string.Format(@"Update ContactLanguage SET Address = '{2}' where LanguageID = {1} AND ContactID = {0}",
                                contactId,
                                address.LanguageId,
                                address.Description.Replace("'", "''"));
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                            }

                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }
                        contactId++;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
            }
            return result;
        }

        public static int GetMaxContactID(DBHelper<int> dbHelper)
        {
            int contactId = 0;
            bool disposeNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    disposeNow = true;
                }
                object contactIdObj = null;
                string query = string.Format("select Max(ContactID) from Contact");
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref contactIdObj);
                if (result == GlobalErrors.Success)
                {
                    if (contactIdObj != null && !string.IsNullOrEmpty(contactIdObj.ToString()))
                    {
                        contactId = int.Parse(contactIdObj.ToString()) + 1;
                    }
                    else
                    {
                        contactId = 1;
                    }
                }
                else
                {
                    contactId = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (disposeNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return contactId;
        }
        #region [Customer Operator]
        public GlobalErrors SaveOutletOperator(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!string.IsNullOrEmpty(outlet.OperatorPassword.TrimEnd()))
                {
                    outlet.OperatorPassword = EncryptionManager.Instance.EncryptPassword(outlet.OperatorPassword);
                }

                if (outlet.OperatorId == -1)
                {
                    if (!string.IsNullOrEmpty(outlet.OperatorName.TrimEnd()) && !string.IsNullOrEmpty(outlet.OperatorPassword.TrimEnd()))
                    {
                        result = InsertNewOutletOperator(outlet, dbHelper);
                    }
                }
                else
                {

                    if (string.IsNullOrEmpty(outlet.OperatorName) && string.IsNullOrEmpty(outlet.OperatorPassword))
                    {
                        result = DeleteOutletOperator(outlet.OperatorId.ToString(), outlet.CustomerId, outlet.OutletId, dbHelper);
                    }
                    else if (!string.IsNullOrEmpty(outlet.OperatorName) && !string.IsNullOrEmpty(outlet.OperatorPassword))
                    {
                        result = UpdateOutletOperator(outlet, dbHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors checkAndDeleteOutletOperator(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object count = 1;
                if (string.IsNullOrEmpty(outlet.OperatorName) && string.IsNullOrEmpty(outlet.OperatorPassword))
                {

                    string query = string.Empty;
                    query = string.Format(@"select isnull(Count(*),0) from CustomerOutletAccess COA
                                                inner join Operator O on COA.OperatorID = O.OperatorID
                                                where O.OperatorID = {0}", outlet.TempOperatorId);

                    result = dbHelper.ExecuteScalar(query, ref count);

                    string filter = string.Format(" And CustomerId = {0} ", outlet.CustomerId);
                    if (outlet.OutletId != -1)
                    {
                        filter += string.Format(" And OutletId = {0} ", outlet.OutletId);
                    }
                    query = string.Format(@" Delete From CustomerOutletAccess where OperatorId in ({0}) {1}",
                    outlet.TempOperatorId,
                    filter);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {

                        if (count != null && int.Parse(count.ToString()) <= 1)
                        {

                            query = string.Format(@" Delete From Operator where operatorID in ({0})", outlet.TempOperatorId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteOutletOperator(string operatorIds, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string filter = string.Format(" And CustomerId = {0} ", customerId);
                if (outletId != -1)
                {
                    filter += string.Format(" And OutletId = {0} ", outletId);
                }
                string query = string.Format(@" Delete From CustomerOutletAccess where OperatorId in ({0}) {1}",
                operatorIds,
                filter);
                result = dbHelper.ExecuteNonQuery(query);

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@" Delete From Operator where operatorID in ({0})", operatorIds);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertNewOutletOperator(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int operatorId = CustomerManager.GetMaxID(CoreDataBaseConstants.TableNames.Operator, CoreDataBaseConstants.QueryColumnsNames.OperatorId, dbHelper);
                if (operatorId == -1)
                    return GlobalErrors.Error;
                string query = string.Format(@" insert into Operator (OperatorID,OperatorName,OperatorPassword,FrontOffice,
                    LoginTypeID,IsLocked,ActiveDirectoryLogin,CreatedBy,UpdatedDate) values ({0},'{1}','{2}',{3},{4},{5},{6},{7},{8})",
                operatorId, //0
                outlet.OperatorName, //1
                outlet.OperatorPassword, //2
                1, // 3 -> FrontOffic
                OperatorType.Customer.GetHashCode(), //4
                outlet.IsLockedOperator ? 1 : 0, //5
                0, // 6 -> active directory login
                _requestRepository.CurrentOperator == null ? -1 : _requestRepository.CurrentOperator.EmployeeId, //7
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //8
                );
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@" insert into CustomerOutletAccess values ({0},{1},{2})",
                    outlet.CustomerId, //0
                    outlet.OutletId, //1
                    operatorId //2
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateOutletOperator(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" update Operator set operatorName = '{0}', operatorPassword = '{1}', IsLocked = {2}, UpdatedBy = {3}, UpdatedDate = {4} where operatorID = {5}",
                outlet.OperatorName, //0
                outlet.OperatorPassword, //1
                outlet.IsLockedOperator ? 1 : 0,//2
                _requestRepository.CurrentOperator.EmployeeId,//3
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//4
                outlet.OperatorId //5
                );
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success && outlet.MatchWithExistsOperator)
                {
                    query = string.Format(@" Delete From CustomerOutletAccess where customerID= {0} and OutletID = {1}", outlet.CustomerId, outlet.OutletId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format(@" insert into CustomerOutletAccess values ({0},{1},{2})",
                        outlet.CustomerId, //0
                        outlet.OutletId, //1
                        outlet.OperatorId //2
                        );
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerOperatorIds(int customerId, ref string operatorIds, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> operatorIdsList = new List<int>();
                string query = string.Format(@"select OperatorId from CustomerOutletAccess where customerId = {0}", customerId);
                result = dbHelper.GetQueryList(query, ref operatorIdsList);
                if (result == GlobalErrors.Success && operatorIdsList != null && operatorIdsList.Count > 0)
                {
                    operatorIds = string.Join(",", operatorIdsList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors CheckValidOutletOperator(string insertedValue, string excludedString, ref bool isUniqueValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isUniqueValue = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT Count(*) From Operator
                inner join CustomerOutletAccess on CustomerOutletAccess.OperatorId = Operator.OperatorId
                Where OperatorName = '{0}' COLLATE SQL_Latin1_General_CP1_CS_AS {1} ",
                insertedValue.Replace("'", "''"), //0
                excludedString //1
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isUniqueValue = false;
                    }
                    else
                    {
                        isUniqueValue = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #endregion
        public GlobalErrors InsertNewCustomerSubClass(CustomerSubClassModel customerSubClass)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                int maxCustomerID = GetMaxID(CoreDataBaseConstants.TableNames.CustomerSubClass, CoreDataBaseConstants.QueryColumnsNames.CustomerSubClassID);
                if (maxCustomerID == -1) return GlobalErrors.Error;
                customerSubClass.CustomerSubClassId = maxCustomerID;
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" insert into CustomerSubClass (CustomerSubClassID,Code)
                    values ({0},'{1}')"
                    , customerSubClass.CustomerSubClassId, customerSubClass.CustomerSubClassCode);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {

                    if (customerSubClass.DescriptionLanguages != null && customerSubClass.DescriptionLanguages.Count > 0)
                    {

                        foreach (TextLanguage lang in customerSubClass.DescriptionLanguages)
                        {

                            string description = string.IsNullOrEmpty(lang.Description.Trim()) ? customerSubClass.CustomerSubClassName: lang.Description;
                            sqlQuery = string.Format(@" insert into CustomerSubClassLanguage (CustomerSubClassID,Description,LanguageID)
                    values ({0},'{1}',{2})"
                    , customerSubClass.CustomerSubClassId, description.Replace("'", "''"), lang.LanguageId);
                            result = dbHelper.ExecuteNonQuery(sqlQuery);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors InsertNewPaymentTerm(PaymentTermModel paymentTermObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                int maxPaymentTermID = GetMaxID(CoreDataBaseConstants.TableNames.PaymentTerm, CoreDataBaseConstants.QueryColumnsNames.PaymentTermID);
                if (maxPaymentTermID == -1) return GlobalErrors.Error;
                paymentTermObj.PaymentTermId = maxPaymentTermID;
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@"insert into PaymentTerm (PaymentTermID,PaymentTermTypeID,SimplePeriodWidth,
                                SimplePeriodID,ComplexPeriodWidth,ComplexPeriodID,GracePeriod,GracePeriodTypeID)
                                values({0},{1},{2},{3},{4},{5},{6},{7})", paymentTermObj.PaymentTermId, paymentTermObj.PaymentTermTypeId, paymentTermObj.SimplePeriodWidth,
                                    paymentTermObj.SimplePeriodId, paymentTermObj.ComplexPeriodWidth, paymentTermObj.ComplexPeriodId, paymentTermObj.GracePeriod, paymentTermObj.GracePeriodTypeId);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"insert into PaymentTermLanguage (PaymentTermID,LanguageID,Description) values ({0},{1},'{2}')", paymentTermObj.PaymentTermId, _requestRepository.LanguageId, paymentTermObj.PaymentTermDescription);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        //public static void ReadCustomerAccount(ref CustomerOutletModel outlet, int divisionId)
        //{
        //    ReadCustomerAccount(ref outlet, divisionId, null);
        //}

        public void ReadCustomerAccount(ref CustomerOutletModel outlet, int divisionId, DBHelper<int> dBHelper)
        {
            DBHelper<AccountModel> dBHelper2 = null;

            AccountModel account = new AccountModel();
            string query = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper2 = new DBHelper<AccountModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction(), _requestRepository.CurrentOperator.EmployeeId);
                }
                else
                {
                    dBHelper2 = new DBHelper<AccountModel>(_requestRepository.CurrentOperator.EmployeeId);
                }
                string orgAcess = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAcess = string.Format(" And Account.OrganizationId in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (_requestRepository.Configurations.UsePayerAccount)
                {
                    query = string.Format(@"select Account.* ,1 as Priority 
                    from Account 
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    inner join CustomerOutlet on CustomerOutlet.CustomerID = PayerAssignment.CustomerID AND CustomerOutlet.OutletID = PayerAssignment.OutletID
                    where PayerAssignment.CustomerID = {0} and PayerAssignment.OutLetID = {1}
                    and PayerAssignment.DivisionID = {2}
                    UNION
                    select Account.* ,2 as Priority 
                    from Account 
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    where PayerAssignment.CustomerID = {0} AND PayerAssignment.OutletID = -1
                    UNION
                    select Account.* ,3 as Priority 
                    from Account
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = PayerAssignment.CustomerGroupID 
                    AND CustomerOutletGroup.CustomerID = {0}
                    AND CustomerOutletGroup.OutletID = {1}
                    where CustomerOutletGroup.CustomerID = {0}
                    UNION
                    select Account.* ,4 as Priority 
                    from Account
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    where PayerAssignment.AllCustomers = 1
                    order by Priority", outlet.CustomerId, outlet.OutletId, divisionId);

                }
                else
                {
                    if (_requestRepository.Configurations.UseCustomerLevelAccount)
                    {
                        query = string.Format(@"select Account.*
                    from Account
                    Inner join AccountCust on Account.AccountID = AccountCust.AccountID
                    where CustomerID = {0} {1}", outlet.CustomerId, orgAcess);
                    }
                    else
                    {
                        query = string.Format(@"select Account.* ,1 as Priority
                    from Account
                    inner join AccountCustOutDiv on Account.AccountID = AccountCustOutDiv.AccountID
                    where CustomerID = {0} and OutLetID = {1} and DivisionID = {2}
                    UNION
                    select Account.* ,2 as Priority
                    from  Account inner join AccountCustOut on Account.AccountID = AccountCustOut.AccountID
                    where CustomerID = {0} and OutLetID = {1} {3} order by Priority", outlet.CustomerId, outlet.OutletId, divisionId, orgAcess);
                    }
                }
                var result = dBHelper2.GetQuerySingle(query, ref account);

                outlet.Account = account;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
            }
        }
        public GlobalErrors ReadCustomerChannelsSubChannels(CustomerOutletModel outlet, ref string CustomerChannelIDsString, ref string CustomerSubChannelIDsString)
        {
            return ReadCustomerChannels(outlet, ref CustomerChannelIDsString, ref CustomerSubChannelIDsString);
        }
        public static GlobalErrors ReadCustomerChannels(CustomerOutletModel outlet, ref string CustomerChannelIDsString, ref string CustomerSubChannelIDsString)
        {
            return ReadCustomerChannels(outlet, ref CustomerChannelIDsString, ref CustomerSubChannelIDsString, null);
        }

        public static GlobalErrors ReadCustomerChannels(CustomerOutletModel outlet, ref string CustomerChannelIDsString, ref string CustomerSubChannelIDsString, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            List<int> customerChannelsIDs = null;
            List<int> customerSubChannelsIDs = null;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }

                DataTable dt = new DataTable();
                if (!string.IsNullOrEmpty(outlet.CustomerGroupsIdsString))
                {
                    string query = string.Format(@"Select ChannelID,SubChannelID FROM CustomerGroup where GroupID in ({0})", outlet.CustomerGroupsIdsString);

                    result = dbHelper.GetQueryDataTable(query, ref dt);

                    if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                    {
                        customerChannelsIDs = new List<int>();
                        customerSubChannelsIDs = new List<int>();
                        for (int i = 0; i < dt.Rows.Count; i++)
                        {
                            int channelID = -1;
                            int subChannelID = -1;

                            if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.ChannelID] != DBNull.Value)
                                channelID = Convert.ToInt32(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.ChannelID].ToString());

                            if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.SubChannelID] != DBNull.Value)
                                subChannelID = Convert.ToInt32(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.SubChannelID].ToString());

                            if (channelID != -1)
                                customerChannelsIDs.Add(channelID);

                            if (subChannelID != -1)
                                customerSubChannelsIDs.Add(subChannelID);
                        }
                        CustomerChannelIDsString = string.Join(",", customerChannelsIDs);
                        CustomerSubChannelIDsString = string.Join(",", customerSubChannelsIDs);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public string ReadCustomerGroups(CustomerOutletModel customerOutletModel)
        {
            return ReadCustomerGroups(customerOutletModel, null);
        }

        public string ReadCustomerGroups(CustomerOutletModel customerOutletModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<CustomerGroupModel> customerGroupIDs = null;
            string customerGroupIDsString = string.Empty;
            DBHelper<CustomerGroupModel> dbHelper = null;
            try
            {
                customerGroupIDs = new List<CustomerGroupModel>();
                if (dBHelper != null)
                {
                    dbHelper = new DBHelper<CustomerGroupModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction(), _requestRepository.CurrentOperator.EmployeeId);
                }
                else
                {
                    dbHelper = new DBHelper<CustomerGroupModel>(_requestRepository.CurrentOperator.EmployeeId);
                }
                string query = string.Format(@" SELECT *,CustomerGroupLanguage.Description GroupName,IsNull( CustomerGroup.GroupCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerGroupLanguage.Description , '--') as GroupCodeName FROM CustomerOutletGroup
 inner join CustomerGroup on CustomerGroup.GroupID=CustomerOutletGroup.GroupID
 left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID =CustomerGroup.GroupID
 and CustomerGroupLanguage.LanguageID={2}
WHERE  CustomerID = {0} AND OutletID = {1} ", customerOutletModel.CustomerId, customerOutletModel.OutletId, _requestRepository.LanguageId);

                result = dbHelper.GetQueryList(query, ref customerGroupIDs);

                if (result == GlobalErrors.Success && customerGroupIDs != null && customerGroupIDs.Count > 0)
                {
                    customerOutletModel.Groups = customerGroupIDs;
                    customerGroupIDsString = string.Join(",", customerGroupIDs.Select(m => m.GroupId).ToArray());
                    customerOutletModel.CustomerGroupsIdsString = customerGroupIDsString;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return customerGroupIDsString;
            }
            return customerGroupIDsString;
        }

        public static void ReadPaymentTerms(ref CustomerOutletModel outlet)
        {
            try
            {
                outlet.CustOutPaymentTerm = PaymentTermManager.GetPaymentTerm(outlet.PaymentTermId);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public static GlobalErrors InsertIntoCustomerLanguage(int customerId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO CustomerLanguage (CustomerId , LanguageId , Description) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(customerId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", (text.Replace("'", "''")).ToString());
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors SaveOutletContacts(CustomerContact customerContact, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into CustomerOutletContact  (CustomerId , OutletId , ContactId , CountryId , ContactTypeId , Number, Email) values ({0},{1},{2},{3},{4},'{5}',{6})"
                , customerContact.CustomerId
                , customerContact.OutletId
                , customerContact.ContactId
                , customerContact.CountryId
                , (int)customerContact.ContactTypeId
                , customerContact.Number.Trim()
                , string.IsNullOrEmpty(customerContact.ContactEmail) ? "Null" : "'" + customerContact.ContactEmail.Trim() + "'"
                );
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveOutletContactsLanguage(CustomerContact customerContact, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into CustomerOutletContactLangauge  (CustomerId , OutletId , ContactId  , LanguageId , Description) values ({0},{1},{2},{3},'{4}')"
                , customerContact.CustomerId
                , customerContact.OutletId
                , customerContact.ContactId
                , languageId
                , string.IsNullOrEmpty(text) ? "" : (text.Replace("'", "''")).ToString());
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertIntoOutletLanguage(CustomerOutletModel outlet, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO CustomerOutletLanguage (CustomerId , OutletId , LanguageId , Description , Address , Address2) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(outlet.CustomerId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.OutletId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", string.IsNullOrEmpty(text) ? "" : (text.Replace("'", "''")).ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", string.IsNullOrEmpty(outlet.Address) ? "" : outlet.Address.Replace("'", "''"));
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", string.IsNullOrEmpty(outlet.Address2) ? "" : outlet.Address2.Replace("'", "''"));
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateCustomer(CustomerModel customerObj, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string sqlQuery = string.Format(@" update customer set customer.Phone='{0}', customer.Fax='{1}', customer.Email='{2}',customer.CustomerCode='{3}',customer.StreetID={6} ,customer.StreetAddress={4}, customer.new={5}, customer.ContractNumber={8}, customer.CustomerCollector= {9}, Customer.CurrencyID = {10},Customer.IsDirectSales = {11}, Customer.UpdatedBy = {12}, Customer.UpdatedDate = {13} , IsDefault = {14}, AllowPayAllOutlets = {15}, PaymentTermID = {16} , ExportCustomer = {17}  where customerID={7}",
                    customerObj.Phone, customerObj.Fax, customerObj.Email, customerObj.CustomerCode.ToString().Replace("'", "''"), customerObj.StreetNumber, Convert.ToInt32(customerObj.IsNewCustomer), customerObj.StreetId, customerObj.CustomerId
                    , (customerObj.ContractNumber == null || customerObj.ContractNumber == string.Empty ? "NULL" : "'" + customerObj.ContractNumber.ToString() + "'")
                    , customerObj.CollectorId, customerObj.CurrencyId, Convert.ToInt32(customerObj.IsDirectSales)
                    , _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), customerObj.IsDefault ? 1 : 0, customerObj.AllowPayAllOutlets ? 1 : 0, customerObj.PaymentTermId, customerObj.ExportCustomer ? 1 : 0);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    if (customerObj.DescriptionLanguages != null && customerObj.DescriptionLanguages.Count > 0)
                    {
                        foreach (TextLanguage lang in customerObj.DescriptionLanguages)
                        { 
                            string description = string.IsNullOrEmpty(lang.Description) ? customerObj.CustomerName : lang.Description;
                            sqlQuery = string.Format(@"UPDATE CustomerLanguage SET Description='{1}'
                          WHERE CustomerID={0} AND LanguageID={2} and OrganizationId = {3}",
                                                      customerObj.CustomerId, description.Replace("'", "''"), lang.LanguageId,_requestRepository.CurrentOperator.OrganizationId);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                            if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                sqlQuery = string.Format(@" insert into CustomerLanguage (CustomerID,Description,LanguageID)
                    values ({0},'{1}',{2})"
                            , customerObj.CustomerId, description.Replace("'", "''"), lang.LanguageId);
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                            }
                        }

                    }

                }

                if (result == GlobalErrors.Success)
                {
                    if (customerObj.Outlets != null && customerObj.Outlets.Count > 0)
                    {
                        foreach (CustomerOutletModel outletObj in customerObj.Outlets)
                        {
                            outletObj.HasPrivilegeOnPaymentTermDivision = customerObj.HasPrivilegeOnPaymentTermDivision;
                            outletObj.HasPrivilegeOnOnHoldDivision = customerObj.HasPrivilegeOnOnHoldDivision;
                            outletObj.CustomerId = customerObj.CustomerId;
                            if (outletObj.DataAction == DataActions.Add)
                            {
                                int dummyId = outletObj.OutletId;
                                result = InsertNewCustomerOutlet(outletObj, dbHelper);
                                if (result == GlobalErrors.Success && customerObj.OutletPayersList.Any(x => x.OutletId == dummyId))
                                {
                                    customerObj.OutletPayersList.Where(x => x.OutletId == dummyId).ToList().ForEach(x =>
                                    {
                                        x.OutletId = outletObj.OutletId;
                                    });
                                }
                            }
                            else if (outletObj.DataAction == DataActions.Edit || outletObj.DataAction == DataActions.inActive)
                                result = UpdateCustomerOutlet(outletObj, dbHelper);
                            else if (outletObj.DataAction == DataActions.Delete)
                                result = DeleteCustomerOutlet(outletObj, dbHelper);
                            else if (outletObj.DataAction == DataActions.EditFromParent)
                                result = UpdateCustomerOutletFromParent(outletObj, dbHelper);

                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    if (customerObj.Outlets.Where(x => x.DataAction != DataActions.Delete).ToList().Count > 1 && customerObj.IsDefault)
                    {
                        errorMessage = MessagesConstants.MsgDefinitionOneOutletForAssignDefaultEmployee;
                        result = GlobalErrors.Error;
                    }
                    if (customerObj.Outlets != null && customerObj.Outlets.Count > 0)
                    {
                        //updat default customer and outlet for employee
                        result = InsertUpdateDefaultCustomer(customerObj.CustomerId, customerObj.Outlets[0].OutletId, customerObj.EmployeeId, dbHelper, ref errorMessage);
                    }
                }


                #region [Accounts]
                if (result == GlobalErrors.Success && customerObj.AccountsList != null && customerObj.AccountsList.Count > 0)
                {
                    result = SaveCustomerAccounts(customerObj, dbHelper);
                }
                #endregion

                if (result == GlobalErrors.Success)
                {
                    string dummyCustomerFolder = LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId + "\\" + customerObj.CustomerId.ToString();
                    if (!string.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy) && Directory.Exists(dummyCustomerFolder))
                    {
                        foreach (CustomerOutletModel outlet in customerObj.Outlets)
                        {
                            if (outlet.DataAction == DataActions.Delete)
                            {
                                //Delete folder
                                result = DeleteOutletAttachments(customerObj.CustomerId.ToString(), outlet.OutletId.ToString());
                                if (result != GlobalErrors.Success)
                                {
                                    break;
                                }
                            }
                            if (result == GlobalErrors.Success && outlet.DataAction == DataActions.Add)
                                result = RenameNewOutletDummyFolders(dummyCustomerFolder, outlet.OutletId.ToString(), outlet.DummyOutletID.ToString());
                            if (result != GlobalErrors.Success)
                            {
                                break;
                            }
                        }
                        if (result == GlobalErrors.Success)
                        {
                            result = MoveOutletAttachmentFoldersToDestinationFolder(customerObj.CustomerId.ToString());
                        }
                    }
                }
                #region[CustomerPackBarcode]
                if (result == GlobalErrors.Success && customerObj.CustomerPackBarcodeList != null && customerObj.CustomerPackBarcodeList.Count > 0)
                {
                    var packIds = string.Join(" , ", customerObj.CustomerPackBarcodeList.Where(i => i.DataAction == DataActions.Edit).Select(item => item.PackId));
                    if (packIds != null && packIds != string.Empty)
                    {
                        result = DeleteCustomerPackBarcode(customerObj.CustomerId, packIds, dbHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = InsertCustomerPackBarcode(customerObj, dbHelper);
                        }
                    }
                }
                #endregion
                #region [OutletPayerAccount]
                // always delete under div access and under -1
                string query = string.Format(@"DELETE FROM PayerAssignment WHERE CustomerID = {0}
                AND (PayerAssignment.DivisionID in ({1}) OR PayerAssignment.DivisionID = -1)",
                customerObj.CustomerId , _requestRepository.CurrentOperator.DivisionAccess);
                if (result == GlobalErrors.Success)
                {
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }                          
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success && customerObj.OutletPayersList != null && customerObj.OutletPayersList.Count > 0)
                {
                        result = SaveOutletPayerAccount(customerObj, dbHelper);
                }               
                #endregion

                #region[Update Customer's Main Outlet]
                if (result == GlobalErrors.Success)
                {
                    string mainOutletExclusion = string.Empty;
                    var mainOutlet = customerObj.Outlets.Find(outlet => outlet.IsMain);
                    if (mainOutlet != null)
                    {
                        mainOutletExclusion = $@" And OutletID <> {mainOutlet.OutletId}";
                        sqlQuery = $@"update CustomerOutlet set IsMain = 1 where CustomerID={mainOutlet.CustomerId} and OutletID={mainOutlet.OutletId}";
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = $@"update CustomerOutlet set IsMain = 0 where CustomerID={customerObj.CustomerId} {mainOutletExclusion}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                    }
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        private GlobalErrors RenameNewOutletDummyFolders(string dummyCustomerFolder, string outletID, string dummyOutletID)
        {
            try
            {
                string outletAttachmentFolderWithDummyId = Path.Combine(dummyCustomerFolder, dummyOutletID);
                string outletAttachmentFolderWithRealId = Path.Combine(dummyCustomerFolder, outletID);
                if (!String.IsNullOrEmpty(LocalUtilities.CustomerAttachments) && !String.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy))
                {
                    if (Directory.Exists(outletAttachmentFolderWithDummyId))
                    {
                        Directory.Move(outletAttachmentFolderWithDummyId, outletAttachmentFolderWithRealId);//rename outlet folder by  replacing the temporary ID which represent the id of the new outlet with the real new customer id
                    }
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private GlobalErrors DeleteOutletAttachments(string customerID, string outletID)
        {
            string customerFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId, customerID);
            try
            {
                if (Directory.Exists(customerFolderPath))
                {
                    string outletAttachmentFolder = Path.Combine(customerFolderPath, outletID);
                    if (Directory.Exists(outletAttachmentFolder))
                        Directory.Delete(outletAttachmentFolder, true);
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private GlobalErrors MoveCustomerTempAttachmentFoldersToDestinationFolder(CustomerOutletModel existOutlet, CustomerOutletModel newOutlet)
        {
            string newCustomerFolderPath = Path.Combine(LocalUtilities.FOImagesFolderPath, newOutlet.DeviceSerial + "_" + newOutlet.RouteHistoryId.ToString(), LocalUtilities.NewCustomerTemplateImages);
            string destinationDummyFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, _requestRepository.SessionId + "\\" + newOutlet.CustomerId);
            string destinationFolderPath = Path.Combine(LocalUtilities.CustomerAttachments, existOutlet.CustomerId.ToString(), existOutlet.OutletId.ToString());
            try
            {
                DirectoryInfo dir = new DirectoryInfo(newCustomerFolderPath);
                int count = 1;
                if (!dir.Exists)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "This path : " + newCustomerFolderPath + " Not exist", null, null, 0);
                    return GlobalErrors.Error;
                }
                if (dir.GetFiles().Any(f => f.Name.StartsWith(newOutlet.CustomerId + "_" + newOutlet.OutletId + "_" + newOutlet.NewCustomerTemplateId)))
                {
                    FileInfo[] files = dir.GetFiles().Where(f => f.Name.StartsWith(newOutlet.CustomerId + "_" + newOutlet.OutletId + "_" + newOutlet.NewCustomerTemplateId)).ToArray();
                    if (files != null && files.Length > 0)
                    {
                        if (!Directory.Exists(destinationFolderPath))
                        {
                            Directory.CreateDirectory(destinationFolderPath);
                        }
                        if (!Directory.Exists(destinationDummyFolderPath))
                        {
                            Directory.CreateDirectory(destinationDummyFolderPath);
                        }
                        foreach (FileInfo sourceFile in files)
                        {
                            string destinationFileName = $"{existOutlet.CustomerId}_{existOutlet.OutletId}_{newOutlet.CustomerId}_{count}.jpg";
                            string destinationFilePath = Path.Combine(destinationFolderPath, destinationFileName);
                            string destinationDummyFilePath = Path.Combine(destinationDummyFolderPath, destinationFileName);
                            if (File.Exists(destinationFilePath))
                            {
                                File.Delete(destinationFilePath);
                            }
                            if (File.Exists(destinationDummyFilePath))
                            {
                                File.Delete(destinationDummyFilePath);
                            }
                            File.Copy(sourceFile.FullName, destinationFilePath);
                            File.Copy(sourceFile.FullName, destinationDummyFilePath);
                            count++;
                        }
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }
                }
                else
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "This path : " + newCustomerFolderPath + " Not containes images for customer-outlet-template" + newOutlet.CustomerId + "_" + newOutlet.OutletId + "_" + newOutlet.NewCustomerTemplateId, null, null, 0);
                    return GlobalErrors.Error;
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private GlobalErrors MoveOutletAttachmentFoldersToDestinationFolder(string customerID)
        {
            string customerFolderPath = Path.Combine(LocalUtilities.CustomerAttachments, customerID);
            string dummyCustomerFolderPath = Path.Combine(LocalUtilities.CustomerAttachmentsDummy, DateTime.Now.ToString(), customerID);
            try
            {
                if (!String.IsNullOrEmpty(LocalUtilities.CustomerAttachments) && !String.IsNullOrEmpty(LocalUtilities.CustomerAttachmentsDummy))
                {
                    if (Directory.Exists(dummyCustomerFolderPath))
                    {
                        if (Directory.Exists(customerFolderPath))
                        {
                            Directory.Delete(customerFolderPath, true);
                        }
                        var outletsFolders = Directory.GetDirectories(dummyCustomerFolderPath);
                        foreach (string outletFolder in outletsFolders)
                        {
                            int outletID = Int32.Parse(outletFolder.Substring(outletFolder.LastIndexOf('\\') + 1));
                            if (outletID <= 0)
                                Directory.Delete(outletFolder, true);
                        }

                        Thread.Sleep(250);

                        Directory.Move(dummyCustomerFolderPath, customerFolderPath);
                        Directory.Delete(LocalUtilities.CustomerAttachmentsDummy + "\\" + _requestRepository.SessionId, true);
                    }
                }
                else
                {
                    return GlobalErrors.CustomerAppPath;
                }
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message + " --- " + dummyCustomerFolderPath + " --- " + customerFolderPath, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveCustomerAccounts(CustomerModel customerObject, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TextLanguage> DescriptionLanguages = null;

                #region [Customer Accounts]
                foreach (AccountModel customerAccount in customerObject.AccountsList)
                {
                    if (customerAccount.DataAction == DataActions.Add || customerAccount.DataAction == DataActions.Edit)
                    {
                        if (!_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            customerAccount.CurrencyId = customerObject.CurrencyId;
                        }

                        if (customerAccount.DataAction == DataActions.Add)
                        {
                            customerAccount.AccountId = _accountManager.GetMaxAccountID(dbHelper);
                            if (customerAccount.AccountId == -1)
                            {
                                return GlobalErrors.Error;
                            }
                            result = _accountManager.CreateNewAccount(customerAccount, dbHelper);
                            if (result == GlobalErrors.Success)
                            {
                                result = _accountManager.CreateCustomerAccount(customerAccount.AccountId, customerObject.CustomerId, dbHelper);
                            }
                        }
                        else if (customerAccount.DataAction == DataActions.Edit)
                        {
                            result = _accountManager.UpdateAccountWithoutUpdateBalance(customerAccount, dbHelper);

                        }
                        if (result == GlobalErrors.Success)
                        {
                            result = _accountManager.SaveAccountLanguage(customerAccount.AccountId, customerObject.CustomerName, customerObject.DescriptionLanguages, dbHelper);
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }

                        #region[Outlet Accounts]
                        if (result == GlobalErrors.Success)
                        {
                            foreach (CustomerOutletModel outletObj in customerObject.Outlets.FindAll(outlet => outlet.DataAction != DataActions.Delete))
                            {
                                if (outletObj.AccountsList != null && outletObj.AccountsList.Any(a => a.OrganizationId == customerAccount.OrganizationId))
                                {
                                    #region[Find outlet account for division accounts then add/update it]
                                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                    {
                                        AccountModel outletObjAccount = null;

                                        int outletObjAccountId = -1;
                                        result = GetOutletAccountId(customerObject.CustomerId, outletObj.OutletId, customerAccount.AccountId, ref outletObjAccountId, dbHelper);
                                        if (result == GlobalErrors.Success)
                                        {
                                            outletObjAccount = new AccountModel();
                                            outletObjAccount.AccountId = outletObjAccountId;
                                            if (outletObjAccount.AccountId == -1)
                                            {
                                                outletObjAccount.DataAction = DataActions.Add;
                                            }
                                            else
                                            {
                                                outletObjAccount.DataAction = DataActions.Edit;
                                            }
                                            outletObjAccount.ParentAccountId = customerAccount.AccountId;
                                            outletObjAccount.OrganizationId = customerAccount.OrganizationId;
                                            outletObjAccount.CurrencyId = customerAccount.CurrencyId;
                                            outletObjAccount.AccountTypeId = customerAccount.AccountTypeId;
                                            // find credit limit for all child accounts
                                            decimal sumOfCreditLimits = outletObj.AccountsList.Where(a => a.DataAction != DataActions.Delete && a.OrganizationId == customerAccount.OrganizationId).Sum(a => a.CreditLimit);
                                            outletObjAccount.CreditLimit = sumOfCreditLimits;

                                            if (outletObjAccount.DataAction == DataActions.Add && outletObj.AccountsList.Any(a => a.OrganizationId == customerAccount.OrganizationId && a.DataAction == DataActions.Add))
                                            {
                                                outletObjAccount.AccountId = _accountManager.GetMaxAccountID(dbHelper);
                                                if (outletObjAccount.AccountId == -1)
                                                {
                                                    return GlobalErrors.Error;
                                                }
                                                result = _accountManager.CreateNewAccount(outletObjAccount, dbHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    result = _accountManager.CreateCustomerOutletAccount(outletObjAccount.AccountId, customerObject.CustomerId, outletObj.OutletId, dbHelper);
                                                }
                                            }
                                            else if (outletObjAccount.DataAction == DataActions.Edit)
                                            {
                                                result = _accountManager.UpdateAccountWithoutUpdateBalance(outletObjAccount, dbHelper);
                                            }
                                            if (result == GlobalErrors.Success && outletObjAccount.AccountId != -1)
                                            {
                                                result = _accountManager.SaveAccountLanguage(outletObjAccount.AccountId, outletObj.OutletName, outletObj.DescriptionLanguages, dbHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    // update all division accounts to have outlet account as parent
                                                    outletObj.AccountsList.FindAll(a => a.OrganizationId == customerAccount.OrganizationId).ForEach(a =>
                                                    {
                                                        a.ParentAccountId = outletObjAccount.AccountId;
                                                    });
                                                }
                                            }
                                        }
                                        if (result != GlobalErrors.Success)
                                        {
                                            return result;
                                        }
                                    }
                                    #endregion

                                    #region[Insert, Update, Delete Outlet Accounts]
                                    foreach (AccountModel outletAccount in outletObj.AccountsList.FindAll(a => a.OrganizationId == customerAccount.OrganizationId))
                                    {
                                        if (outletAccount.DataAction == DataActions.Add || outletAccount.DataAction == DataActions.Edit)
                                        {
                                            if (!_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                            {
                                                outletAccount.ParentAccountId = customerAccount.AccountId;
                                            }
                                            if (outletAccount.DataAction == DataActions.Add)
                                            {
                                                outletAccount.AccountId = _accountManager.GetMaxAccountID(dbHelper);
                                                if (outletAccount.AccountId == -1)
                                                {
                                                    return GlobalErrors.Error;
                                                }
                                                result = _accountManager.CreateNewAccount(outletAccount, dbHelper);
                                                if (result == GlobalErrors.Success)
                                                {
                                                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                                    {
                                                        result = _accountManager.CreateCustomerOutletDivisionAccount(outletAccount.AccountId, customerObject.CustomerId, outletObj.OutletId, outletAccount.DivisionId, dbHelper);
                                                    }
                                                    else
                                                    {
                                                        result = _accountManager.CreateCustomerOutletAccount(outletAccount.AccountId, customerObject.CustomerId, outletObj.OutletId, dbHelper);
                                                    }
                                                }
                                            }
                                            else if (outletAccount.DataAction == DataActions.Edit)
                                            {
                                                result = _accountManager.UpdateAccountWithoutUpdateBalance(outletAccount, dbHelper);
                                            }
                                            if (result == GlobalErrors.Success)
                                            {
                                                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                                {
                                                    DescriptionLanguages = outletObj.DescriptionLanguages;
                                                    result = _accountManager.SaveAccountLanguage(outletAccount.AccountId, outletObj.OutletName + " - " + outletAccount.DivisionCodeName, DescriptionLanguages, dbHelper);
                                                }
                                                else
                                                {
                                                    result = _accountManager.SaveAccountLanguage(outletAccount.AccountId, outletObj.OutletName, outletObj.DescriptionLanguages, dbHelper);
                                                }
                                                if (result != GlobalErrors.Success)
                                                {
                                                    return result;
                                                }
                                            }
                                        }
                                        else if (outletAccount.DataAction == DataActions.Delete)
                                        {
                                            if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                            {
                                                result = DeleteDivisionAccount(outletAccount.AccountId, dbHelper);
                                            }
                                            else
                                            {
                                                result = DeleteOutletAccountWithChilds(outletAccount.AccountId, dbHelper);
                                            }
                                        }
                                    }
                                    #endregion
                                }
                                if (result != GlobalErrors.Success)
                                {
                                    return result;
                                }
                            }
                        }
                        #endregion
                    }
                    else if (customerAccount.DataAction == DataActions.Delete)
                    {
                        result = DeleteCustomerAccountWithChilds(customerAccount.AccountId, dbHelper);
                    }
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveOutletPayerAccount(CustomerModel customerObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (PayerAccountModel payer in customerObj.OutletPayersList)
                {
                    if (payer.PayerId > -1)
                    {
                        if (!IsPayerCustomerexists(customerObj.CustomerId, payer.OutletId, -1, payer.DivisionId, payer.PayerId, dbHelper))
                        {
                            result = InsertAppliedCustomersToPayerAccount(customerObj.CustomerId, payer.OutletId, payer.PayerId, payer.DivisionId, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors GetOrgBaseCurrency(int organizationId, ref int currencyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object field = null;
            try
            {
                string query = String.Format(@$"Select CurrencyID FROM Currency Where Base = 1 AND OrganizationID = {organizationId}");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && int.Parse(field.ToString()) > 0)
                    currencyId = int.Parse(field.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateCustomerGroup(CustomerGroupModel groupObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" update CustomerGroup set GroupCode='{1}',OrganizationID={2}
                    where GroupID={0}"
                    , groupObj.GroupId, groupObj.GroupCode, groupObj.OrganizationId);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@" update CustomerGroupLanguage set Description='{1}'
where GroupID={0} and LanguageID ={2} "
                    , groupObj.GroupId, groupObj.GroupName, _requestRepository.LanguageId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        sqlQuery = string.Format(@" insert into CustomerGroupLanguage (GroupID,Description,LanguageID)
                    values ({0},'{1}',{2})"
                    , groupObj.GroupId, groupObj.GroupName, _requestRepository.LanguageId);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors UpdateCustomerLanguage(int customerId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update CustomerLanguage set Description = '{0}' , OrganizationId = {3} Where customerId = {1} and LanguageId = {2}", text.Replace("'", "''"), customerId, languageId,_requestRepository.CurrentOperator.OrganizationId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertCustomerOrganization(int customerId,int organizationId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerModel> dbHelper2 = new DBHelper<CustomerModel>();
                List<CustomerModel> obj = new List<CustomerModel>();
                string query = string.Format(@"select * from  CustomerOrganization where customerid = {0} and organizationId = {1} ", customerId, organizationId);
                result = dbHelper2.GetQueryList(query,ref obj);

                if(obj != null && obj.Count == 0)
                {
                 query = string.Format(@"Insert into CustomerOrganization values ({0},{1})", customerId, organizationId);
                 result = dbHelper.ExecuteNonQuery(query);

                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateIsNewCustomer(int customerId, bool isNewCustomer)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Update Customer set New = {0} where CustomerID = {1}", isNewCustomer ? 1 : 0, customerId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateInactiveCustomer(int customerId, bool isActive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = string.Format(@" Update Customer set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where customerId = {3};
                   Update CustomerOutlet set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where customerId = {3} ",
                isActive ? 0 : 1, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                customerId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromCustOutTerritory(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Delete d From CustOutTerritory d
                    inner join Territory on Territory.TerritoryID = d.TerritoryID
                    where d.CustomerID = {outletObj.CustomerId} and d.OutletID = {outletObj.OutletId} 
                    AND Territory.organizationId in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromRouteCustomer(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete  w from  RouteCustomer w
                                    inner join Route R on R.RouteID = w.RouteID 
                                    inner join Territory on Territory.TerritoryID = R.TerritoryID
                                    where  w.CustomerID = {0} and w.OutletID = {1} AND Territory.organizationId in ({2})",
                                        outletObj.CustomerId, //0
                                        outletObj.OutletId, // 1
                                        _requestRepository.CurrentOperator.OrganizationAccess //2
                                        );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomerOutletFromParent(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;



                #region[Customer Groups]
                if (result == GlobalErrors.Success)
                {
                    result = AddAssignedGroupsToOutlet(outletObj, dbHelper);
                }
                #endregion

                #region[Sales Distribution Channel]
                if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                {
                    result = DeleteSalesDistributionChannelCustomers(-1, outletObj.CustomerId, outletObj.OutletId, true, dbHelper);
                    if (result == GlobalErrors.Success && outletObj.SalesDistributionChannels != null && outletObj.SalesDistributionChannels.Count > 0)
                    {
                        result = InsertSalesDistributionChannelsForOutlet(outletObj, dbHelper);
                    }
                }
                #endregion

                #region[Customer Outlet Warehouse]
                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowSelectAlternativeWarehouseInFO) 
                {
                    result = UpdateCustomerOutletWarehouse(outletObj.CustomerId, outletObj.OutletId, outletObj.WarehouseId, dbHelper);
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomerOutlet(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                if (dbHelper == null) dbHelper = new DBHelper<int>();
                string sqlQuery = string.Format(@" update CustomerOutlet  set  Barcode='{0}', Phone='{1}', Fax='{2}', Email='{3}', Taxeable={4}, CurrencyID={5}, OnHold={6}, StreetID='{7}',Inactive={8}, 
                    Notes='{9}', PaymentTermID={10}, CustomerTypeID={11}, UpdatedBy={12},TradeLicenceNumber='{13}',CustomerCode='{14}' ,BillsOpenNumber={17},CustomerClassID={18},
                    PreferredVisitTimeFrom = {19},PreferredVisitTimeTo = {20},CommissionerOfReceipt = '{21}', UpdatedDate={22},OpenTime = '{23}',CloseTime = '{24}',
                    TW1Start = '{25}',TW1Stop = '{26}',TW2Start = '{27}', TW2Stop='{28}',FixedServiceTime = {29},VariableServiceTime = {30},GPSLatitude = {31},GPSLongitude = {32},ShopNumber='{33}',BlockNumber='{34}'
                    , OutletCollectorID = {35}, CustomerSubClassID={36}, TaxNumber = '{37}' ,VendorNumber='{38}',CreditCardInfo='{39}' , CreditCardName = '{40}' , CreditCardCVV = '{41}' , CreditCardExpiryDate = {42}, IsHiglighted  = {43},  {44}
                    GLN ='{45}', ZipCode = '{46}', CountryID = '{47}', StateID = '{48}', CityID = '{49}', AreaID = '{50}', IsMain = {51}, Landmark = '{52}', BuildingNumber = {53}, WarehouseID = {54}, CompanyPrefix = {55}, IsBusinessCustomer = {56}, IsVendingMachine = {57}, TradeLicenceExpiryDate = {58} , CustomerStatusID = {59},TradeLicenceName = '{60}'
                    where CustomerID={15} and OutletID={16} ",
                    !string.IsNullOrEmpty(outletObj.Barcode) ? outletObj.Barcode.ToString().Replace("'", "''") : "",//0
                    string.IsNullOrEmpty(outletObj.Phone) ? "" : outletObj.Phone,//1
                    outletObj.Fax == null ? "" : outletObj.Fax,//2
                    string.IsNullOrEmpty(outletObj.Email) ? "" : outletObj.Email.Replace("'", "''"),//3
                    outletObj.Taxable ? "1" : "0",//4
                    outletObj.CurrencyId,//5
                    outletObj.OnHold ? "1" : "0",//6
                    outletObj.StreetId,//7
                    outletObj.Inactive ? "1" : "0",//8
                    outletObj.Notes == null ? "" : outletObj.Notes.Replace("'", "''"),//9
                    outletObj.PaymentTermId,//10
                    outletObj.CustomerTypeId,//11
                    _requestRepository.CurrentOperator.EmployeeId,//12
                    !string.IsNullOrEmpty(outletObj.TradeLicenceNumber) ? outletObj.TradeLicenceNumber.Replace("'", "''") : "",//13
                    outletObj.OutletCode.ToString().Replace("'", "''"),//14
                    outletObj.CustomerId,//15
                    outletObj.OutletId,//16
                    outletObj.BillsNumber,//17
                    outletObj.CustomerClassId,//18
                    "NULL",//DatabaseDateTimeManager.ParseDateAndTimeToSQL(outletObj.PreferredVisitTimeFrom),//19
                    "NULL",//DatabaseDateTimeManager.ParseDateAndTimeToSQL(outletObj.PreferredVisitTimeTo),//20
                    !string.IsNullOrEmpty(outletObj.CommissionerOfReceipt) ? outletObj.CommissionerOfReceipt.Replace("'", "''") : "" ,//21
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//(outletObj.UpdatedDate),//22
                    "",//outletObj.OpenTime,//23
                    "",// outletObj.CloseTime,//24
                    "",// outletObj.TW1Start,//25
                    "",//  outletObj.TW1Stop,//26
                    "",//  outletObj.TW2Start,//27
                    "",//  outletObj.TW2Stop,//28
                    "0",// outletObj.FixedServiceTime,//29
                    "0",//  outletObj.VariableServiceTime,//30
                    outletObj.GPSLatitude,//31
                    outletObj.GPSLongitude,//32
                    "",//  outletObj.ShopNumber,//33 
                    "",//  outletObj.BlockNumber,//34
                    "NULL",// (outletObj.CollectorID) == -1 ? "-1" : outletObj.CollectorID.ToString(),//35
                    outletObj.CustomerSubClassId,//36
                    (!string.IsNullOrEmpty(outletObj.TaxNumber) ? outletObj.TaxNumber.Replace("'", "''") : ""),//37
                    (!string.IsNullOrEmpty(outletObj.VendorNumber) ? outletObj.VendorNumber.Replace("'", "''") : ""),//38
                    (!string.IsNullOrEmpty(outletObj.CreditCardNumber) ? outletObj.CreditCardNumber.Replace("'", "''") : ""),//39
                    "",//  outletObj.CreditCardName.Replace("'", "''"),//40
                    "",//   outletObj.CreditCardCVV.Replace("'", "''"),//41
                    "null",//   (outletObj.CreditCardExpiryDate == DateTime.MinValue ? "NULL" : DatabaseDateTimeManager.ParseDateAndTimeToSQL(outletObj.CreditCardExpiryDate)),//42
                    outletObj.IsHighlighted ? "1" : "0",//43
                    string.Empty,//outletObj.MachineTypeId == -1 ? "null" : outletObj.MachineTypeId.ToString(),//44
                    outletObj.GLN.ToString().Replace("'", "''"), //45
                    !string.IsNullOrEmpty(outletObj.ZipCode) ? outletObj.ZipCode.Replace("'", "''") : "", //46
                    outletObj.CountryId, //47
                    outletObj.StateId, //48
                    outletObj.CityId, //49
                    outletObj.AreaId, //50
                    (outletObj.IsMain ? "1" : "0"), //51
                    !string.IsNullOrEmpty(outletObj.Landmark) ? outletObj.Landmark.ToString().Replace("'", "''"): "", //52
                    !string.IsNullOrEmpty(outletObj.BuildingNumber) ? "'" + outletObj.BuildingNumber.Replace("'", "''") + "'" : "NULL", // 53
                    outletObj.WarehouseId == -1 ? "NULL" : outletObj.WarehouseId.ToString(), //54
                    outletObj.CompanyPrefix == -1 ? "NULL" : outletObj.CompanyPrefix.ToString(), //55
                    outletObj.IsBusinessCustomer ? "1" : "0", //56
                    outletObj.IsVendingMachine ? "1" : "0", //57
                    outletObj.TradeLicenceExpiryDateModel.Date == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(outletObj.TradeLicenceExpiryDateModel.Date), //58
                    outletObj.CustomerStatusId, // 59
                    !string.IsNullOrEmpty(outletObj.TradeLicenceName) ? outletObj.TradeLicenceName.Replace("'", "''"): "" //60
                    );
                result = dbHelper.ExecuteNonQuery(sqlQuery);                              
                if (result == GlobalErrors.Success)
                {
                    //TerritoryManager territoryManager = new TerritoryManager(_requestRepository);


                    List<int> langIds = new List<int>();
                    if (outletObj.DescriptionLanguages != null && outletObj.DescriptionLanguages.Count > 0)
                    {
                        langIds.AddRange(outletObj.DescriptionLanguages.Select(a => a.LanguageId).ToList());
                    }
                    if (outletObj.AddressLanguages != null && outletObj.AddressLanguages.Count > 0)
                    {
                        langIds.AddRange(outletObj.AddressLanguages.Select(a => a.LanguageId).ToList());
                    }
                    if (outletObj.Address2Languages != null && outletObj.Address2Languages.Count > 0)
                    {
                        langIds.AddRange(outletObj.Address2Languages.Select(a => a.LanguageId).ToList());
                    }
                    langIds = langIds.Distinct().ToList();
                    int tempIndex = -1;
                    string tempDescription = string.Empty;
                    string tempAddress = string.Empty;
                    string tempAddress2 = string.Empty;
                    foreach (int langId in langIds)
                    {
                        tempDescription = string.Empty;
                        tempAddress = string.Empty;
                        tempAddress2 = string.Empty;
                        tempIndex = outletObj.DescriptionLanguages.FindIndex(a => a.LanguageId == langId);
                        if (tempIndex > -1)
                        {
                            tempDescription = outletObj.DescriptionLanguages[tempIndex]?.Description ?? outletObj.OutletName;
                        }
                        tempIndex = outletObj.AddressLanguages.FindIndex(a => a.LanguageId == langId);
                        if (tempIndex > -1)
                        {
                            tempAddress = outletObj.AddressLanguages[tempIndex]?.Description ?? outletObj.Address;
                        }
                        tempIndex = outletObj.Address2Languages.FindIndex(a => a.LanguageId == langId);
                        if (tempIndex > -1)
                        {
                            tempAddress2 = outletObj.Address2Languages[tempIndex]?.Description ?? outletObj.Address2;
                        }
                        sqlQuery = string.Format(@" 
                                IF NOT EXISTS (SELECT * FROM CustomerOutletLanguage WHERE CustomerID = {0} AND OutletID = {1} AND LanguageID = {4})
                                    BEGIN
                                        INSERT INTO CustomerOutletLanguage (CustomerID,OutletID,Description,Address,Address2,LanguageID) VALUES ({0},{1},{2},{3},{5},{4});
                                    END
                                ELSE
                                    BEGIN
                                        UPDATE CustomerOutletLanguage SET Description = {2}, Address = {3},Address2 = {5} WHERE CustomerID = {0} AND OutletID = {1} AND LanguageID = {4};
                                    END", outletObj.CustomerId, outletObj.OutletId,
                                      string.IsNullOrEmpty(tempDescription) ? "NULL" : "'" + tempDescription.Replace("'", "''") + "'",
                                      string.IsNullOrEmpty(tempAddress) ? "NULL" : "'" + tempAddress.Replace("'", "''") + "'",
                                      langId,
                                      string.IsNullOrEmpty(tempAddress2) ? "NULL" : "'" + tempAddress2.Replace("'", "''") + "'");
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                if (result == GlobalErrors.Success && outletObj.IsFromSuperVisorApp)
                {
                    sqlQuery = string.Format(@"update CL                                            
                                                set CL.Description = '{0}' 
                                                from customer C                                                       
                                                Inner join CustomerLanguage CL on                                                      
                                                C.CustomerID = CL.CustomerID and C.CustomerID = {1}", outletObj.OutletName, outletObj.CustomerId);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);

                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@"update customer                                            
                                                set CustomerCode = '{0}'                                                     
                                                where CustomerID = {1}", outletObj.CustomerCode, outletObj.CustomerId);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                }
                if (result == GlobalErrors.Success && outletObj.IsThereAnyGroupAchievementPromotions)
                {
                    result = HandleOutletGroupAchievementPromotions(outletObj, true, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = AddAssignedGroupsToOutlet(outletObj, dbHelper);
                }
                //if (result == GlobalErrors.Success)
                //{ 
                //    result = _machineCustomerManager.SaveCustomerMachine(outletObj.MachineTypeId, outletObj.CustomerId, outletObj.OutletId, outletObj.MachineData, dbHelper);
                //}
                // always delete saved payment terms for cash customer
                if (result == GlobalErrors.Success && outletObj.CustomerTypeId == CustomerTypes.CashCustomer.GetHashCode())
                {
                    result = DeleteOutletDivisionPaymentTerms(outletObj.CustomerId, outletObj.OutletId, outletObj.CustomerTypeId, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                }
                if (result == GlobalErrors.Success && outletObj.HasPrivilegeOnPaymentTermDivision && outletObj.CustomerTypeId != CustomerTypes.CashCustomer.GetHashCode())
                {
                    result = DeleteOutletDivisionPaymentTerms(outletObj.CustomerId, outletObj.OutletId, outletObj.CustomerTypeId, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (outletObj.OutletDivisionPaymentTermList != null && outletObj.OutletDivisionPaymentTermList.Count > 0)
                    {
                        result = SaveOutletDivisionPaymentTerms(outletObj, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success && outletObj.HasPrivilegeOnOnHoldDivision)
                {
                    result = DeleteOutletOnHoldDivisions(outletObj.CustomerId, outletObj.OutletId, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    result = SaveOutletOnHoldDivisions(outletObj, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    if (outletObj.IsNeedToSaveOperator)
                    {
                        result = SaveOutletOperator(outletObj, dbHelper);
                    }
                    else if (_requestRepository.Configurations.AllowSameOperatorForMultiCustomer)
                    {
                        result = checkAndDeleteOutletOperator(outletObj, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    if (outletObj.CustomerOutletContacts != null && outletObj.CustomerOutletContacts.Count > 0)
                        result = SaveCustomerOutletContacts(outletObj.CustomerOutletContacts, outletObj.CustomerId, outletObj.OutletId, dbHelper);
                    else
                    {
                        sqlQuery = string.Format(@"delete from ContactLanguage where ContactID in (Select ContactID from Contact where CustomerID = {0} AND OutletID = {1})",
                        outletObj.CustomerId, outletObj.OutletId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;


                        if (result == GlobalErrors.Success)
                        {
                            sqlQuery = string.Format(@"delete from Contact where CustomerID={0} and OutletID={1}",
                            outletObj.CustomerId, outletObj.OutletId);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                            if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                result = GlobalErrors.Success;
                        }
                    }
                }


                #region[Sales Distribution Channel]
                if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                {
                    result = DeleteSalesDistributionChannelCustomers(-1, outletObj.CustomerId, outletObj.OutletId, true, dbHelper);
                    if (result == GlobalErrors.Success && outletObj.SalesDistributionChannels != null && outletObj.SalesDistributionChannels.Count > 0)
                    {
                        result = InsertSalesDistributionChannelsForOutlet(outletObj, dbHelper);
                    }
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {

            }
            return result;
        }

        public GlobalErrors UpdateOutletActiveStatus(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(" Update CustomerOutlet set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where outletId = {3}",
                outlet.Inactive ? 1 : 0, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                outlet.OutletId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
           
            return result;
        }  
        public GlobalErrors UpdateCustomerOutletExtraInfo(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string q = string.Format(@"Select COUNT(*) From CustOutExtraInfo where CustomerId = {0} AND OutletId = {1}", outlet.CustomerId, outlet.OutletId);
                Object count = 0;

                result = dbHelper.ExecuteScalar(q, ref count);

                if (result == GlobalErrors.Success && count != null)
                {
                    if (int.Parse(count.ToString()) == 0)// Insert new 
                    {
                        StringBuilder sqlStatment = new StringBuilder();
                        sqlStatment.Append("INSERT INTO CustOutExtraInfo (CustomerId , OutletId , AreaId , Gender , DateOfBirth , CreationSourceId , SourceId , NationalityId , IdentificationNumber ) Values ");
                        sqlStatment.Append("(");
                        sqlStatment.Append(outlet.CustomerId);
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.OutletId);
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.AreaId == "" ? "NULL" : outlet.AreaId.ToString());
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.Gender == -1 ? "NULL" : outlet.Gender.ToString());
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.DateOfBirthModel.Date == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(outlet.DateOfBirthModel.Date));
                        sqlStatment.Append(",");
                        sqlStatment.Append((int)CustomerCreationSource.CRM);
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.CustomerSourceId == -1 ? "NULL" : outlet.CustomerSourceId.ToString());
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.NationalityId == -1 ? "NULL" : outlet.NationalityId.ToString());
                        sqlStatment.Append(",");
                        sqlStatment.Append(string.IsNullOrEmpty(outlet.IdentificationNumber) ? "NULL" : outlet.IdentificationNumber);
                        sqlStatment.Append(")");
                        result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                    }
                    else // Update exist
                    {
                        string query = string.Format(@"Update CustOutExtraInfo Set AreaId = {0} , Gender = {3} , DateOfBirth = {4} , NationalityId = {5} ,IdentificationNumber = '{6}' Where CustomerId= {1} AND outletId ={2}"
                        , outlet.AreaId
                        , outlet.CustomerId
                        , outlet.OutletId
                        , outlet.Gender == -1 ? "NULL" : outlet.Gender.ToString()
                        , outlet.DateOfBirthModel.Date == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(outlet.DateOfBirthModel.Date)
                        , outlet.NationalityId == -1 ? "NULL" : outlet.NationalityId.ToString()
                        , outlet.IdentificationNumber);

                        result = dbHelper.ExecuteNonQuery(query);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (outlet.IsDiscounted && outlet.DiscountPriceListId != -1)
                            result = AssignOutletToPriceList(outlet.CustomerId, outlet.OutletId, outlet.DiscountPriceListId, dbHelper);
                        else if (!outlet.IsDiscounted)
                            result = RemovePriceListAssignmentIfExist(outlet.CustomerId, outlet.OutletId, dbHelper);

                    }
                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertIntoExtraInfo(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO CustOutExtraInfo (CustomerId , OutletId , AreaId , Gender , DateOfBirth , CreationSourceId , SourceId , NationalityId , IdentificationNumber ) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(outlet.CustomerId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.OutletId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.AreaId == "" ? "NULL" : outlet.AreaId.ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.Gender == -1 ? "NULL" : outlet.Gender.ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.DateOfBirthModel.Date == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(outlet.DateOfBirthModel.Date));
                sqlStatment.Append(",");
                sqlStatment.Append((int)CustomerCreationSource.CRM);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.CustomerSourceId == -1 ? "NULL" : outlet.CustomerSourceId.ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.NationalityId == -1 ? "NULL" : outlet.NationalityId.ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(string.IsNullOrEmpty(outlet.IdentificationNumber) ? "NULL" : "'" + outlet.IdentificationNumber + "'");
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertNewCustomerForCRM(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO Customer (CustomerId ,Phone, Email, CustomerCode, New , CreatedBy, CreatedDate,CurrencyID) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(outlet.CustomerId);
                sqlStatment.Append(",'");
                sqlStatment.Append(outlet.Phone);
                sqlStatment.Append("','");
                sqlStatment.Append(outlet.Email);
                sqlStatment.Append("','");
                sqlStatment.Append(outlet.CustomerCode);
                sqlStatment.Append("',");
                sqlStatment.Append(0);
                sqlStatment.Append(",");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.CurrencyId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertNewOutletForCRM(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO CustomerOutlet (CustomerId ,OutletId ,CustomerCode ,Phone, Email,Taxeable , CreatedBy, CreatedDate , InActive , OnHold , PaymentTermID , CustomerTypeID,CurrencyID, CountryID, CityID, AreaID, OrganizationId ) Values ");
                sqlStatment.Append("(");
                sqlStatment.Append(outlet.CustomerId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.OutletId);
                sqlStatment.Append(",'");
                sqlStatment.Append(outlet.CustomerCode);
                sqlStatment.Append("','");
                sqlStatment.Append(outlet.OutletContacts != null && outlet.OutletContacts.Count > 0 ?
                   outlet.OutletContacts.Any(contact => (int)contact.ContactTypeId == (int)ContactType.mobile) ?
                   outlet.OutletContacts.Where(x => (int)x.ContactTypeId == (int)ContactType.mobile).Select(mobile => mobile.Number).LastOrDefault().Replace("'", "''") : outlet.Phone
                   : outlet.Phone);
                sqlStatment.Append("','");
                sqlStatment.Append(outlet.Email);
                sqlStatment.Append("',");
                sqlStatment.Append(_requestRepository.Configurations.AllowTax ? "1" : "0");
                sqlStatment.Append(",");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(",");
                sqlStatment.Append(0);
                sqlStatment.Append(",");
                sqlStatment.Append(0);
                sqlStatment.Append(",");
                sqlStatment.Append(0);
                sqlStatment.Append(",");
                sqlStatment.Append((int)CustomerTypes.CashCustomer);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.CurrencyId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.CountryId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.CityId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.AreaId);
                sqlStatment.Append(",");
                sqlStatment.Append(outlet.OrganizationId);
                sqlStatment.Append(")");

                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateOutletArea(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string q = string.Format(@"Select COUNT(*) From CustOutExtraInfo where CustomerId = {0} AND OutletId = {1}", outlet.CustomerId, outlet.OutletId);
                Object count = 0;

                result = dbHelper.ExecuteScalar(q, ref count);

                if (result == GlobalErrors.Success && count != null)
                {
                    if (int.Parse(count.ToString()) == 0)// Insert new 
                    {
                        StringBuilder sqlStatment = new StringBuilder();
                        sqlStatment.Append("INSERT INTO CustOutExtraInfo (CustomerId , OutletId , AreaId) Values ");
                        sqlStatment.Append("(");
                        sqlStatment.Append(outlet.CustomerId);
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.OutletId);
                        sqlStatment.Append(",");
                        sqlStatment.Append(outlet.AreaId == "" ? "NULL" : outlet.AreaId.ToString());
                        sqlStatment.Append(")");
                        result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                    }
                    else // Update exist
                    {
                        string query = string.Format(@"Update CustOutExtraInfo Set AreaId = {0}  Where CustomerId= {1} AND outletId ={2}"
                        , outlet.AreaId
                        , outlet.CustomerId
                        , outlet.OutletId);

                        result = dbHelper.ExecuteNonQuery(query);
                    }
                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateCustomerOutletFromCRM(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update CustomerOutlet Set UpdatedBy = {0} , UpdatedDate = {1} ,Email = {2}, Inactive = {3}, Phone = '{6}',CountryID = {7}, CityID = {8}, AreaID = {9} Where CustomerId= {4} AND outletId ={5}"
                , _requestRepository.CurrentOperator.EmployeeId
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                , string.IsNullOrEmpty(outlet.Email) ? "Null" : "'"+outlet.Email.Trim()+"'"
                , outlet.Inactive ? "1" : "0"
                , outlet.CustomerId
                , outlet.OutletId
                , outlet.OutletContacts != null && outlet.OutletContacts.Count > 0 ?
                   outlet.OutletContacts.Any(contact => (int)contact.ContactTypeId == (int)ContactType.mobile) ?
                   outlet.OutletContacts.Where(x => (int)x.ContactTypeId == (int)ContactType.mobile).Select(mobile => mobile.Number).LastOrDefault().Replace("'", "''") : outlet.Phone
                   : outlet.Phone
                   , outlet.CountryId
                  , outlet.CityId
                  , outlet.AreaId);

                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors UpdateOutletAddress(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update CustomerOutletLanguage set Address = {0}, Address2 = {1} Where customerId = {2} and outletId = {3}"
                , !string.IsNullOrEmpty(outletObj.Address) ? "'" + outletObj.Address.Trim().Replace("'", "''") + "'" : "NULL"
                , !string.IsNullOrEmpty(outletObj.Address2) ? "'" + outletObj.Address2.Trim().Replace("'", "''") + "'" : "NULL"
                , outletObj.CustomerId
                , outletObj.OutletId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateOutletLanguage(int customerId, int outletId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update CustomerOutletLanguage set Description = '{0}' Where customerId = {1} and outletId = {2} and LanguageId = {3}", text.Replace("'", "''"), customerId, outletId, languageId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private GlobalErrors AddAssignedGroupsToOutlet(CustomerOutletModel outletObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                string organizationFilter = string.Empty;
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    organizationFilter = $@" AND CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                }
                string sqlQuery = $@"Delete COG from CustomerOutletGroup COG
                            inner join CustomerGroup CG on CG.GroupID = COG.GroupID
                            Where COG.CustomerID = {outletObj.CustomerId} and COG.OutletID = {outletObj.OutletId} {organizationFilter}";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if(result != GlobalErrors.Success)
                {
                    return result;
                }
                if (outletObj.Groups != null && outletObj.Groups.Count > 0)
                {
                    foreach (CustomerGroupModel group in outletObj.Groups)
                    {
                        sqlQuery = string.Format(@" insert into CustomerOutletGroup (CustomerID,OutletID,GroupID)
                    values ({0},{1},{2})"
           , outletObj.CustomerId, outletObj.OutletId, group.GroupId);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                        if (result != GlobalErrors.Success) break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
            }
            return result;
        }
        public static int GetMaxID(string tableName, string columnName)
        {
            return GetMaxID(tableName, columnName, null);
        }
        public static int GetMaxID(string tableName, string columnName, DBHelper<int> dbHelper)
        {
            int customerID = 0;
            bool disposeNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    disposeNow = true;
                }
                object customerIDObj = null;
                string query = string.Format("select Max({1}) from {0} ", tableName, columnName);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref customerIDObj);
                if (result == GlobalErrors.Success)
                {
                    if (customerIDObj != null && !string.IsNullOrEmpty(customerIDObj.ToString()))
                    {
                        customerID = int.Parse(customerIDObj.ToString()) + 1;
                    }
                    else
                    {
                        customerID = 1;
                    }
                }
                else
                {
                    customerID = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (disposeNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return customerID;
        }
        public static int GetMaxIDWithFilter(string tableName, string columnName, string filter)
        {
            int customerID = 0;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object customerIDObj = null;
                string query = string.Format("select Max({1}) from {0} where {2} ", tableName, columnName, filter);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref customerIDObj);
                if (result == GlobalErrors.Success)
                {
                    if (customerIDObj != null && !string.IsNullOrEmpty(customerIDObj.ToString()))
                    {
                        customerID = int.Parse(customerIDObj.ToString()) + 1;
                    }
                    else
                    {
                        customerID = 1;
                    }
                }
                else
                {
                    customerID = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return customerID;
        }
        public static int GetMaxOutletID(int customerId, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Select IsNull(max(OutletID),0) + 1 OutletID from CustomerOutlet Where CustomerID = {0}", customerId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        private static List<int> ReadOnHoldDivisions(CustomerOutletModel outlet)
        {
            return ReadOnHoldDivisions(outlet, null);
        }

        private static List<int> ReadOnHoldDivisions(CustomerOutletModel outlet, DBHelper<int> dBHelper)
        {
            List<int> onHoldDivisions = null;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                onHoldDivisions = new List<int>();

                string query = string.Format(@"select * from CustOutDivOnHoldStatus where CustomerID = {0} and OutletID = {1}", outlet.CustomerId, outlet.OutletId);

                dBHelper.GetQueryList(query, ref onHoldDivisions);
            }
            catch (Exception ex)
            {
                onHoldDivisions = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return onHoldDivisions;
        }

        public GlobalErrors GetNationalities(ref List<Nationality> nationalities)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<Nationality> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<Nationality>();
                string query = string.Format(@"Select *  from Nationalities where LanguageId = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref nationalities);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetAllDiscounts(ref List<DiscountModel> discounts)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<DiscountModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<DiscountModel>();
                string query = string.Format(@"Select Discount.DiscountID ,  DiscountLanguage.Description DiscountName
                from Discount
                LEFT JOIN DiscountLanguage on Discount.DiscountID = DiscountLanguage.DiscountID AND LanguageID = {0}
                Where Discount.Inactive <> 1 and Discount.Organizationid in ({1})", _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.GetQueryList(query, ref discounts);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetHomeAndOfficeChannel(ref CustomerChannelModel customerChannel)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerChannelModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"Select Top 1 HomeAndOffice.Channelid , ChannelLanguage.Description ChannelName
                from HomeAndOffice
                LEFT JOIN ChannelLanguage on ChannelLanguage.ChannelID = HomeAndOffice.ChannelId AND ChannelLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQuerySingle(query, ref customerChannel);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetDiscountedGroupsCRM(ref List<CustomerGroupModel> groups)//?
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerGroupModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"Select Distinct GroupPrice.GroupID  GroupID ,  CustomerGroupLanguage.Description GroupName
                from GroupPrice
                INNER JOIN CRMPrices on CRMPrices.PriceListID = GroupPrice.PriceListID 
                LEFT JOIN CustomerGroupLanguage on CustomerGroupLanguage.GroupID = GroupPrice.GroupID
				 AND CustomerGroupLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref groups);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDiscountedPriceListsCRM(ref List<priceListModel> priceLists)//?
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<priceListModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<priceListModel>();
                string query = string.Format(@"Select distinct P.PriceListID  PriceListID ,  P.PriceListCode + ' - ' + PriceListLanguage.Description  PriceListName
                from CRMPrices
                INNER JOIN PriceList P ON P.PriceListID = CRMPrices.PriceListID
                LEFT JOIN PriceListLanguage on PriceListLanguage.PriceListID = CRMPrices.PriceListID 
				AND PriceListLanguage.LanguageID = {0} WHERE P.IsDeleted = 0 ", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref priceLists);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetHomeAndOfficeSubChannel(ref List<CustomerGroupModel> hhGroups)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerGroupModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"Select Distinct HomeAndOffice.GroupId , CustomerGroupLanguage.Description GroupName
                from HomeAndOffice
                LEFT JOIN CustomerGroupLanguage on CustomerGroupLanguage.GroupID = HomeAndOffice.GroupId AND CustomerGroupLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref hhGroups);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerSources(ref List<CustomerSource> sources)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerSource> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerSource>();
                string query = string.Format(@"Select * from CustomerSource where LanguageId = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref sources);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllCustomerChannels(ref List<CustomerChannelModel> customerChannelObj, string groupID)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string sqlString = string.Empty;
                if (!string.IsNullOrWhiteSpace(groupID) && groupID != "-1")
                {
                    var lengthString = groupID.Split("");// .ToArray();//.Length;

                    sqlString = string.Format(@"SELECT DISTINCT (CONVERT(varchar(10),Channel.ChannelID) + '-' + CONVERT(varchar(10),SubChannel.SubChannelID)) ChannelSubChannelIds,
                                                (SubChannel.SubChannelCode + '-' + Channel.ChannelCode + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions 
                                                    FROM Channel
                                                    INNER JOIN SubChannel on Channel.ChannelID = SubChannel.ChannelID
													INNER JOIN CustomerGroup CG ON CG.ChannelID = Channel.ChannelID 
                                                    LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = Channel.ChannelID and ChannelLanguage.LanguageID = {0}
                                                    LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = SubChannel.SubChannelID and SubChannelLanguage.LanguageID = {0}
													 WHERE  CG.GroupID IN ({1})",
                                                     _requestRepository.LanguageId, lengthString[0]);
                }
                else
                {
                    sqlString = string.Format(@"SELECT (CONVERT(varchar(10),Channel.ChannelID) + '-' + CONVERT(varchar(10),SubChannel.SubChannelID)) ChannelSubChannelIds , (SubChannel.SubChannelCode + '-' + Channel.ChannelCode + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                                    FROM Channel
                                                    INNER JOIN SubChannel on Channel.ChannelID = SubChannel.ChannelID
                                                    LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = Channel.ChannelID and ChannelLanguage.LanguageID = {0}
                                                    LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = SubChannel.SubChannelID and SubChannelLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                }
                result = dbHelper.GetQueryList(sqlString, ref customerChannelObj , true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerChannelObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetAllChannels(ref List<CustomerChannelModel> customerChannelList, bool customersHierarchyMode = false)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string sqlString = string.Format(@" select Channel.*,IsNull( Channel.ChannelCode , '--') + ' - ' + IsNull( ChannelLanguage.Description , '--') as ChannelCodeName
                                                    FROM Channel
                                                   
                                                    LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = Channel.ChannelID and ChannelLanguage.LanguageID = {0}
                                                   ", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref customerChannelList);


                if (result == GlobalErrors.Success && (customerChannelList != null && customerChannelList.Count > 0) && customersHierarchyMode)
                {
                    var dbHelperDescription = new DBHelper<TextLanguage>();
                    var descriptionsList = new List<TextLanguage>();
                    var ChannelIds = customerChannelList.Select(c => c.ChannelId).Distinct().ToList();
                    sqlString = $"select ChannelID Id,LanguageID,Description from ChannelLanguage where ChannelID in({string.Join(",", ChannelIds)}) ";
                    result = dbHelperDescription.GetQueryList(sqlString, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        customerChannelList.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.ChannelId).ToList(); return x; }).ToList();
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerChannelList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAllSubChannels(int channelId, ref List<CustomerSubChannelModel> customerSubChannelList, bool customersHierarchyMode = false)
        {
            DBHelper<CustomerSubChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string channelFilter = string.Empty;
                if (channelId != -1)
                {
                    channelFilter = string.Format(" And SubChannel.ChannelID = {0}", channelId);
                }
                dbHelper = new DBHelper<CustomerSubChannelModel>();
                string sqlString = string.Format(@"select SubChannel.*,IsNull( SubChannel.SubChannelCode , '--') + ' - ' + IsNull( SubChannelLanguage.Description , '--') as SubChannelCodeName
                                                    FROM SubChannel
                                                    LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = SubChannel.SubChannelID and SubChannelLanguage.LanguageID = {0}
                                                    where 1=1 {1}
                                                   ", _requestRepository.LanguageId, channelFilter);
                result = dbHelper.GetQueryList(sqlString, ref customerSubChannelList);

                if (result == GlobalErrors.Success && (customerSubChannelList != null && customerSubChannelList.Count > 0) && customersHierarchyMode)
                {
                    var dbHelperDescription = new DBHelper<TextLanguage>();
                    var descriptionsList = new List<TextLanguage>();
                    var subChannelIds = customerSubChannelList.Select(c => c.SubChannelId).Distinct().ToList();
                    sqlString = $"select SubChannelID Id,LanguageID,Description from SubChannelLanguage where SubChannelID in({string.Join(",", subChannelIds)}) ";
                    result = dbHelperDescription.GetQueryList(sqlString, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        customerSubChannelList.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.SubChannelId).ToList(); return x; }).ToList();
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerSubChannelList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCreditReleaseList(GeneralFilter filter, ref SharedTableResult<CreditReleaseModel> creditReleaseList)
        {
            DBHelper<CreditReleaseModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<CreditReleaseModel> creditReleases = new List<CreditReleaseModel>();

            try
            {
                dbHelper = new DBHelper<CreditReleaseModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;

                if (filter != null)
                {
                    string assignedToFilter = "";
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" and CreditRelease.CreditReleaseCode  like '%{0}%'  or Organization.OrganizationCode like '%{0}%' or OrganizationLanguage.Description like '%{0}%'", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (!string.IsNullOrEmpty(filter.Code))
                    {
                        searchFilter += string.Format(" and CreditRelease.CreditReleaseCode like '%{0}%'", filter.Code);
                    }
                    if (filter.CustomerId != -1)
                    {
                        assignedToFilter = string.Format(" (CRA.CustomerID = {0} AND CRA.OutletID = {1}) ", filter.CustomerId, filter.OutletId);
                    }
                    if (filter.groupId != -1)
                    {
                        if (assignedToFilter != "") assignedToFilter += " OR ";
                        assignedToFilter += string.Format(" (CRA.CustomerGroupID = {0}) ", filter.groupId);
                    }
                    if (!string.IsNullOrEmpty(filter.channelSubChannel))
                    {
                        if (assignedToFilter != "") assignedToFilter += " OR ";
                        string[] channelSubChannelFilter = filter.channelSubChannel.Split('-');
                        assignedToFilter += string.Format(" (CRA.ChannelID = {0} AND CRA.SubChannelID = {1}) ", channelSubChannelFilter[0], channelSubChannelFilter[1]);
                    }
                    if (assignedToFilter != "")
                    {
                        searchFilter += " AND ( " + assignedToFilter + ")";
                    }
                    if (filter.FromToDate != null && filter.FromToDate.Count == 2)
                    {
                        searchFilter += string.Format(" And CreditRelease.StartDate <= {1} and CreditRelease.EndDate >= {0} ", LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date), LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date));
                    }
                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" AND Organization.OrganizationID = {0}", filter.OrganizationId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By CreditRelease.CreatedDate Desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }


                string mainQuery = string.Format(@"FROM CreditRelease
                inner join CreditReleaseAssignment CRA on CRA.CreditReleaseID = CreditRelease.CreditReleaseID
                LEFT OUTER JOIN CreditReleaseTypeLanguage CRL ON CRL.TypeId = CreditRelease.Type AND LanguageID = {0}
                inner JOIN CreditReleaseOrganisation ON CreditReleaseOrganisation.CreditReleaseID=CreditRelease.CreditReleaseID and CreditReleaseOrganisation.OrganizationID in ({2})
                inner JOIN Organization on Organization.OrganizationID = CreditReleaseOrganisation.OrganizationID left join 
                OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                where inactive = 0  {1}",
                _requestRepository.LanguageId,
                searchFilter,
                _requestRepository.CurrentOperator.OrganizationAccess);

                string countQuery = string.Format(@"select IsNull(Count(Distinct CreditRelease.CreditReleaseID),0) {0}",
                mainQuery);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    creditReleaseList.TotalItems = int.Parse(objField.ToString().Trim());
                    string sqlString = string.Format(@"SELECT distinct CreditRelease.CreditReleaseID
                                    , CreditReleaseCode Code
                                    , CreditRelease.Notes
                                    , StartDate
                                    , EndDate
                                    , CreditRelease.CreatedDate
                                    , CRL.Description Type
                                    , Value
                                    , CRL.TypeId
                                    , Status
                                    , Case IsNull(CreditRelease.Status,-1) when -1 then 0 else 1 end as IsPending
                                    , Case CreditRelease.inactive when 1 then '{7}' else (Case IsNull(CreditRelease.Status,-1)  when -1 then '{5}' else CONCAT('{6}', CreditRelease.Status) end ) end as CreditReleaseStatusName
                                    , CASE Value WHEN -1 THEN '----' ELSE CONVERT(nvarchar(100),CAST(ROUND(ISNULL(Value,0) , {4} )AS numeric(19, {4}))) END ValueString
                                    , CASE (SELECT COUNT(OrganizationID) FROM CreditReleaseOrganisation WHERE CreditReleaseOrganisation.CreditReleaseID = CreditRelease.CreditReleaseID   and CreditReleaseOrganisation.OrganizationID in ({9}) ) 
									   WHEN 0 THEN '---' WHEN 1 THEN (select  top 1  Organization.OrganizationCode + ' - ' +  OrganizationLanguage.Description  as OrganizationCodeName from Organization inner join CreditReleaseOrganisation on Organization.OrganizationID = CreditReleaseOrganisation.OrganizationID inner join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = 1 where CreditReleaseID = CreditRelease.CreditReleaseID)
									   ELSE '{8}' END OrganizationCodeName
                                    {0} {1}
                                    OFFSET  {2} ROWS       
                                    FETCH NEXT {3} ROWS ONLY"
                                    , mainQuery//0
                                    , orderByFilter//1
                                    , (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize//2
                                    , filter.CustomListFilter.PageSize//3
                                    , _requestRepository.Configurations.NumberOfDigits//4
                                    , Resources.ResourcesManager.TranslateKey("Desc_Active", _requestRepository.LanguageId)//5
                                    , Resources.ResourcesManager.TranslateKey("Desc_Waiting_For_Approval", _requestRepository.LanguageId)//6
                                    , Resources.ResourcesManager.TranslateKey("Desc_Inactive", _requestRepository.LanguageId)//7
                                    , ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organization, _requestRepository.LanguageId) //8
                                    , _requestRepository.CurrentOperator.OrganizationAccess //9 
                                    );

                    result = dbHelper.GetQueryList(sqlString, ref creditReleases);
                    if (result == GlobalErrors.Success)
                    {
                        creditReleaseList.Data = creditReleases;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                creditReleaseList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetCreditReleaseData(string id, ref CreditReleaseModel creditReleaseObj)
        {
            DBHelper<CreditReleaseModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                dbHelper = new DBHelper<CreditReleaseModel>();
                string sqlString = string.Format(@"SELECT CreditRelease.CreditReleaseID, CreditRelease.Type TypeId, CreditReleaseCode Code, StartDate StartDate, EndDate EndDate, CRL.Description Type, Value, Notes, CRO.OrganizationID
                                    FROM CreditRelease
                                    LEFT OUTER JOIN CreditReleaseTypeLanguage CRL ON CRL.TypeId = CreditRelease.Type AND LanguageID = {0} 
                                    LEFT OUTER JOIN CreditReleaseOrganisation CRO ON CRO.CreditReleaseID=CreditRelease.CreditReleaseID
                                    WHERE CreditRelease.CreditReleaseID = '{1}' ", _requestRepository.LanguageId, id);
                result = dbHelper.GetQuerySingle(sqlString, ref creditReleaseObj);

                if (result == GlobalErrors.Success)
                {
                    List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                    List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                    List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                    List<OrganizationModel> appliedOrganizations = new List<OrganizationModel>();

                    if (result == GlobalErrors.Success)
                        result = GetCreditReleaseAppliedChannels(creditReleaseObj.CreditReleaseId, ref appliedChannels);
                    if (result == GlobalErrors.Success)
                        result = GetCreditReleaseAppliedGroups(creditReleaseObj.CreditReleaseId, ref appliedGroups);
                    if (result == GlobalErrors.Success)
                        result = GetCreditReleaseAppliedCustomers(creditReleaseObj.CreditReleaseId, ref appliedCustomers);
                    if (result == GlobalErrors.Success)
                        result = GetCreditReleaseOrganisations(creditReleaseObj.CreditReleaseId, ref appliedOrganizations);
                    creditReleaseObj.AppliedChannels = appliedChannels;
                    creditReleaseObj.AppliedGroups = appliedGroups;
                    creditReleaseObj.AppliedCustomers = appliedCustomers;
                    creditReleaseObj.AppliedOrganizations = appliedOrganizations;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                creditReleaseObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        private GlobalErrors GetCreditReleaseOrganisations(int creditReleaseId, ref List<OrganizationModel> organizationList)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<OrganizationModel>();

                string query = string.Format(@"SELECT Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM Organization
                left outer join OrganizationLanguage		ON OrganizationLanguage.OrganizationID =Organization.OrganizationID and OrganizationLanguage.LanguageID = {0}
				inner join		CreditReleaseOrganisation	ON CreditReleaseOrganisation.OrganizationID=Organization.OrganizationID
				inner join		CreditRelease				On CreditRelease.CreditReleaseID=CreditReleaseOrganisation.CreditReleaseID and CreditRelease.CreditReleaseID={1}
				WHERE Organization.OrganizationID in ({2})",
                _requestRepository.LanguageId,
                creditReleaseId,
                _requestRepository.CurrentOperator.OrganizationAccess
                );

                result = dbHelper.GetQueryList(query, ref organizationList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizationList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCreditReleaseAppliedChannels(int creditReleaseId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"select CreditReleaseAssignment.CreditReleaseID, CreditReleaseAssignment.ChannelID, CreditReleaseAssignment.SubChannelID,
                                (CONVERT(varchar(10), CreditReleaseAssignment.ChannelID) + '-' + CONVERT(varchar(10), CreditReleaseAssignment.SubChannelID)) ChannelSubChannelIds,
                                (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                from CreditReleaseAssignment
                                Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = CreditReleaseAssignment.ChannelID and ChannelLanguage.LanguageID = {1}
                                left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = CreditReleaseAssignment.SubChannelID and SubChannelLanguage.LanguageID = {1}
                                where CreditReleaseAssignment.CreditReleaseID = {0} ", creditReleaseId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCreditReleaseAppliedCustomers(int creditReleaseId, ref List<SimpleCustomerModel> appliedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();

                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = string.Format(@"
                select CreditReleaseAssignment.CreditReleaseID ,CreditReleaseAssignment.CustomerID ,CreditReleaseAssignment.OutletID ,
                Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                ,CustomerOutletLanguage.Description as OutletName ,Case when CreditReleaseAssignment.OutletID = -1 then 'All Outlets' else IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--')end as OutletCodeName
                from CreditReleaseAssignment
                inner join Customer on Customer.CustomerID=CreditReleaseAssignment.CustomerID
                left outer join CustomerOutlet on CustomerOutlet.CustomerID=CreditReleaseAssignment.CustomerID and CustomerOutlet.OutletID = CreditReleaseAssignment.OutletID 
                left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID= {1}
                left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                and CustomerOutletLanguage.LanguageID={1}
                {2}
                where CreditReleaseAssignment.CreditReleaseID={0}", creditReleaseId, _requestRepository.LanguageId, orgAccessJoin);
                result = dbHelper.GetQueryList(query, ref appliedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCreditReleaseAppliedGroups(int creditReleaseId, ref List<CustomerGroupModel> appliedGroups)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerGroupModel>();
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                string query = string.Format(@"select CreditReleaseAssignment.CreditReleaseID ,CreditReleaseAssignment.CustomerGroupID GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                from CreditReleaseAssignment
                                inner join CustomerGroup on CustomerGroup.GroupID=CreditReleaseAssignment.CustomerGroupID {2}
                                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID= {1}
                                where CreditReleaseAssignment.CreditReleaseID= {0}", creditReleaseId, _requestRepository.LanguageId, orgAccess);
                result = dbHelper.GetQueryList(query, ref appliedGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveCustomerCreditRelease(CreditReleaseModel creditReleaseObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                DateTime date = DateTime.Now;
                int creditReleaseId = GetMaxID(CoreDataBaseConstants.TableNames.CreditRelease, CoreDataBaseConstants.QueryColumnsNames.CreditReleaseID);
                if (creditReleaseId == -1) return GlobalErrors.Error;
                string whereFilter = string.Format(" CreditReleaseID = {0} ", creditReleaseObj.CreditReleaseId);
                int historyId = GetMaxIDWithFilter(CoreDataBaseConstants.TableNames.CreditReleaseHistory, CoreDataBaseConstants.QueryColumnsNames.ChangeHistoryID, whereFilter);
                if (historyId == -1) return GlobalErrors.Error;

                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                #region[Get CreditRelease Status]
                int status = 0;
                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("3"))
                {
                    SettingManager settingManager = new SettingManager(_requestRepository);
                    result = settingManager.GetCurrentOperationStatus(ApprovalCycleOperations.CreditRelease.GetHashCode(), ref status, dbHelper);
                }
                else
                {
                    status = -1;
                }
                #endregion
                string sqlQuery = string.Format(@"INSERT INTO CreditRelease 
                                    (CreditReleaseID, CreditReleaseCode, StartDate, EndDate,Type, Value, Inactive, CreatedBy, CreatedDate, Notes,Status)
                                    VALUES ({0},'{1}',{2},{3},{4},{5},{6},{7},{8},'{9}',{10})"
                                    , creditReleaseId, creditReleaseObj.Code, LocalUtilities.ParseDateToSQLString(creditReleaseObj.StartDate.Value),
                                    LocalUtilities.ParseDateToSQLString(creditReleaseObj.EndDate.Value), creditReleaseObj.TypeId, creditReleaseObj.TypeId == 2 ? -1 : creditReleaseObj.Value, 0
                                    , _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(date), creditReleaseObj.Notes, status);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Code, "", creditReleaseObj.Code, dbHelper);
                    if (result == GlobalErrors.Success)
                        result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.StartDate, "", LocalUtilities.ParseDateToSQLString(creditReleaseObj.StartDate.Value), dbHelper);
                    if (result == GlobalErrors.Success)
                        result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.EndDate, "", LocalUtilities.ParseDateToSQLString(creditReleaseObj.EndDate.Value), dbHelper);
                    if (result == GlobalErrors.Success)
                        result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Type, "", creditReleaseObj.TypeId.ToString(), dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        decimal newValue = creditReleaseObj.TypeId == 2 ? -1 : creditReleaseObj.Value;
                        result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Value, "", newValue.ToString(), dbHelper);
                    }
                    if (result == GlobalErrors.Success)
                        result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Inactive, "", false.ToString(), dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        creditReleaseObj.CreditReleaseId = creditReleaseId;
                        result = InsertCreditReleaseAssignmentAndHistory(creditReleaseObj, historyId, date, dbHelper);
                    }

                    if (result == GlobalErrors.Success)
                    {
                        result = InsertCreditReleaseOrganization(creditReleaseObj, dbHelper);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        private GlobalErrors InsertCreditReleaseOrganization(CreditReleaseModel creditReleaseObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (OrganizationModel organization in creditReleaseObj.AppliedOrganizations)
                {
                    string query = string.Format("INSERT INTO CreditReleaseOrganisation VALUES ({0},{1})", creditReleaseObj.CreditReleaseId, organization.OrganizationId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomerCreditRelease(CreditReleaseModel creditReleaseObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                DateTime date = DateTime.Now;
                CreditReleaseModel orginalCreditRelease = new CreditReleaseModel();
                result = GetCreditReleaseData(creditReleaseObj.CreditReleaseId.ToString(), ref orginalCreditRelease);
                if (result == GlobalErrors.Success)
                {
                    string whereFilter = string.Format(" CreditReleaseID = {0} ", creditReleaseObj.CreditReleaseId);
                    int historyId = GetMaxIDWithFilter(CoreDataBaseConstants.TableNames.CreditReleaseHistory, CoreDataBaseConstants.QueryColumnsNames.ChangeHistoryID, whereFilter);
                    if (historyId == -1) return GlobalErrors.Error;

                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();

                    string sqlQuery = string.Format(@"UPDATE CreditRelease SET CreditReleaseCode = '{0}',
                                                  StartDate ={1}, EndDate = {2}, Type = {3}, Value = {4}, Notes = '{6}' WHERE CreditReleaseID = {5}"
                                        , creditReleaseObj.Code, LocalUtilities.ParseDateToSQLString(creditReleaseObj.StartDate.Value),
                                        LocalUtilities.ParseDateToSQLString(creditReleaseObj.EndDate.Value), creditReleaseObj.TypeId, creditReleaseObj.TypeId == 2 ? -1 : creditReleaseObj.Value
                                        , creditReleaseObj.CreditReleaseId, creditReleaseObj.Notes);
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                    if (result == GlobalErrors.Success)
                    {
                        if (orginalCreditRelease.Code != creditReleaseObj.Code)
                        {
                            result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Code, orginalCreditRelease.Code, creditReleaseObj.Code, dbHelper);
                        }
                        if (result == GlobalErrors.Success && orginalCreditRelease.StartDate.Value != creditReleaseObj.StartDate.Value)
                        {
                            result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.StartDate, orginalCreditRelease.StartDate.Value.ToString(), creditReleaseObj.StartDate.Value.ToString(), dbHelper);
                        }
                        if (result == GlobalErrors.Success && orginalCreditRelease.EndDate.Value != creditReleaseObj.EndDate.Value)
                        {
                            result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.EndDate, orginalCreditRelease.EndDate.Value.ToString(), creditReleaseObj.EndDate.Value.ToString(), dbHelper);
                        }
                        if (result == GlobalErrors.Success && orginalCreditRelease.TypeId != creditReleaseObj.TypeId)
                        {
                            result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Type, orginalCreditRelease.TypeId.ToString(), creditReleaseObj.TypeId.ToString(), dbHelper);
                        }
                        if (result == GlobalErrors.Success && orginalCreditRelease.Value != creditReleaseObj.Value)
                        {
                            decimal newValue = creditReleaseObj.TypeId == 2 ? -1 : creditReleaseObj.Value;
                            decimal oldValue = orginalCreditRelease.TypeId == 2 ? -1 : orginalCreditRelease.Value;
                            result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Value, oldValue.ToString(), newValue.ToString(), dbHelper);
                        }
                        if (result == GlobalErrors.Success)
                        {
                            result = UpdateCreditReleaseAssignmentAndHistory(creditReleaseObj, orginalCreditRelease, historyId, date, dbHelper);
                        }
                        if (result == GlobalErrors.Success)
                        {
                            string deleteQuery = string.Format(@"DELETE FROM CreditReleaseOrganisation WHERE CreditReleaseID = {0} AND OrganizationID in ({1}) ", creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.OrganizationAccess);

                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                            if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;

                            if (result == GlobalErrors.Success)
                            {
                                result = InsertCreditReleaseOrganization(creditReleaseObj, dbHelper);
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        private GlobalErrors InsertCreditReleaseAssignmentAndHistory(CreditReleaseModel creditReleaseObj, int historyId, DateTime date, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int assignmentId = 1;
                if (creditReleaseObj.AppliedCustomers != null && creditReleaseObj.AppliedCustomers.Count > 0)
                {
                    foreach (SimpleCustomerModel customer in creditReleaseObj.AppliedCustomers)
                    {
                        result = InsertAppliedCustomerToCreditRelease(customer, creditReleaseObj.CreditReleaseId, assignmentId, dBHelper);
                        if (result != GlobalErrors.Success) return result;

                        result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.CustomerID, "", customer.CustomerId.ToString(), dBHelper);
                        if (result == GlobalErrors.Success) result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.OutletID, "", customer.OutletId.ToString(), dBHelper);
                        assignmentId++;
                    }
                }
                if (creditReleaseObj.AppliedGroups != null && creditReleaseObj.AppliedGroups.Count > 0)
                {
                    foreach (CustomerGroupModel group in creditReleaseObj.AppliedGroups)
                    {
                        result = InsertAppliedGroupsToCreditRelease(group, assignmentId, creditReleaseObj.CreditReleaseId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                        result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.GroupID, "", group.GroupId.ToString(), dBHelper);
                        assignmentId++;
                    }
                }
                if (creditReleaseObj.AppliedChannels != null && creditReleaseObj.AppliedChannels.Count > 0)
                {
                    string filedName = CoreDataBaseConstants.QueryColumnsNames.ChannelID + " -" + CoreDataBaseConstants.QueryColumnsNames.SubChannelID;
                    foreach (CustomerChannelModel channel in creditReleaseObj.AppliedChannels)
                    {
                        result = InsertAppliedChannelsToCreditRelease(channel, assignmentId, creditReleaseObj.CreditReleaseId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                        result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, filedName, "", channel.ChannelSubChannelIds.ToString(), dBHelper);
                        assignmentId++;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors UpdateCreditReleaseAssignmentAndHistory(CreditReleaseModel creditReleaseObj, CreditReleaseModel orginalCreditRelese, int historyId, DateTime date, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int assignmentId = 1;
                string sqlQuery = string.Empty;


                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                    string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (CustomerGroupID is not null or CustomerGroupID <> -1)" : string.Empty;
                    string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                    sqlQuery = $@"DELETE FROM CreditReleaseAssignment WHERE CreditReleaseID = {creditReleaseObj.CreditReleaseId} 
                                  and ((SubChannelID <> -1 or SubChannelID is not null) or 
                                  (ChannelID <> -1 or ChannelID is not null)  {deleteGroups} {deleteCustomers})";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        sqlQuery = $@" DELETE CRA FROM CreditReleaseAssignment CRA 
                                       inner join CustomerGroup CG  on CG.GroupID = CRA.CustomerGroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                       WHERE CRA.CreditReleaseID = {creditReleaseObj.CreditReleaseId} ";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    }
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        sqlQuery = $@" DELETE CRA FROM CreditReleaseAssignment CRA 
                                       inner join CustomerOutlet CO on CO.CustomerID = CRA.CustomerID and CO.OutletID = CRA.OutletID
                                       {orgAccessJoin}
                                       WHERE CRA.CreditReleaseID = {creditReleaseObj.CreditReleaseId} ";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    }

                }
                else
                {
                    sqlQuery = string.Format("DELETE FROM CreditReleaseAssignment WHERE CreditReleaseID = {0} ", creditReleaseObj.CreditReleaseId);
                    result = dBHelper.ExecuteNonQuery(sqlQuery);
                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;


                if (result == GlobalErrors.Success)
                {
                    if (creditReleaseObj.AppliedCustomers != null && creditReleaseObj.AppliedCustomers.Count > 0
                        || orginalCreditRelese != null && orginalCreditRelese.AppliedCustomers.Count > 0)
                    {
                        result = UpdateAppliedCustomerCreditRelease(creditReleaseObj, orginalCreditRelese, historyId, date, ref assignmentId, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (creditReleaseObj.AppliedGroups != null && creditReleaseObj.AppliedGroups.Count > 0
                        || orginalCreditRelese.AppliedGroups != null && orginalCreditRelese.AppliedGroups.Count > 0)
                        {
                            result = UpdateAppliedGroupsToCreditRelease(creditReleaseObj, orginalCreditRelese, historyId, date, ref assignmentId, dBHelper);
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (creditReleaseObj.AppliedChannels != null && creditReleaseObj.AppliedChannels.Count > 0
                            || orginalCreditRelese.AppliedChannels != null && orginalCreditRelese.AppliedChannels.Count > 0)
                        {
                            result = UpdateAppliedChannelsToCreditRelease(creditReleaseObj, orginalCreditRelese, historyId, date, ref assignmentId, dBHelper);
                        }
                    }
                    //if (result == GlobalErrors.Success)
                    //{
                    //    if (creditReleaseObj.AppliedOrganizations != null && creditReleaseObj.AppliedOrganizations.Count > 0
                    //        || orginalCreditRelese.AppliedOrganizations != null && orginalCreditRelese.AppliedOrganizations.Count > 0)
                    //    {
                    //        result = UpdateAppliedOrganizationsToCreditRelease(creditReleaseObj, orginalCreditRelese, historyId, date, ref assignmentId, dBHelper);
                    //    }
                    //}
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateAppliedCustomerCreditRelease(CreditReleaseModel creditReleaseObj, CreditReleaseModel orginalCreditRelese, int historyId, DateTime date, ref int assignmentId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SimpleCustomerModel> deletedOutlets = new List<SimpleCustomerModel>();
                List<SimpleCustomerModel> addedOutlets = new List<SimpleCustomerModel>();

                if (orginalCreditRelese.AppliedCustomers != null && orginalCreditRelese.AppliedCustomers.Count > 0)
                {
                    orginalCreditRelese.AppliedCustomers.ForEach(oldCustomer =>
                    {
                        if (!creditReleaseObj.AppliedCustomers.Any(x => x.CustomerId == oldCustomer.CustomerId && x.OutletId == oldCustomer.OutletId))
                        {
                            deletedOutlets.Add(oldCustomer);
                        }
                    });
                }
                if (creditReleaseObj.AppliedCustomers != null && creditReleaseObj.AppliedCustomers.Count > 0)
                {
                    creditReleaseObj.AppliedCustomers.ForEach(newCustomer =>
                    {
                        if (!orginalCreditRelese.AppliedCustomers.Any(x => x.CustomerId == newCustomer.CustomerId && x.OutletId == newCustomer.OutletId))
                        {
                            addedOutlets.Add(newCustomer);
                        }
                    });
                    foreach (SimpleCustomerModel customer in creditReleaseObj.AppliedCustomers)
                    {
                        result = InsertAppliedCustomerToCreditRelease(customer, creditReleaseObj.CreditReleaseId, assignmentId, dBHelper);
                        if (result != GlobalErrors.Success) break;
                        assignmentId++;
                    }
                }
                foreach (SimpleCustomerModel customer in deletedOutlets)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.CustomerID, customer.CustomerId.ToString(), "", dBHelper);
                    if (result == GlobalErrors.Success) result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.OutletID, customer.OutletId.ToString(), "", dBHelper);
                }
                foreach (SimpleCustomerModel customer in addedOutlets)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.CustomerID, "", customer.CustomerId.ToString(), dBHelper);
                    if (result == GlobalErrors.Success) result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.OutletID, "", customer.OutletId.ToString(), dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateAppliedChannelsToCreditRelease(CreditReleaseModel creditReleaseObj, CreditReleaseModel orginalCreditRelese, int historyId, DateTime date, ref int assignmentId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<CustomerChannelModel> deletedChannels = new List<CustomerChannelModel>();
                List<CustomerChannelModel> addedChannels = new List<CustomerChannelModel>();

                if (orginalCreditRelese.AppliedChannels != null && orginalCreditRelese.AppliedChannels.Count > 0)
                {
                    orginalCreditRelese.AppliedChannels.ForEach(oldChannel =>
                    {
                        if (!creditReleaseObj.AppliedChannels.Any(x => x.ChannelSubChannelIds == oldChannel.ChannelSubChannelIds))
                        {
                            deletedChannels.Add(oldChannel);
                        }
                    });
                }
                if (creditReleaseObj.AppliedChannels != null && creditReleaseObj.AppliedChannels.Count > 0)
                {
                    creditReleaseObj.AppliedChannels.ForEach(newChannel =>
                    {
                        if (!orginalCreditRelese.AppliedChannels.Any(x => x.ChannelSubChannelIds == newChannel.ChannelSubChannelIds))
                        {
                            addedChannels.Add(newChannel);
                        }
                    });

                    foreach (CustomerChannelModel channel in creditReleaseObj.AppliedChannels)
                    {
                        result = InsertAppliedChannelsToCreditRelease(channel, assignmentId, creditReleaseObj.CreditReleaseId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                        assignmentId++;
                    }
                }
                string filedName = CoreDataBaseConstants.QueryColumnsNames.ChannelID + " -" + CoreDataBaseConstants.QueryColumnsNames.SubChannelID;
                foreach (CustomerChannelModel channel in deletedChannels)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, filedName, channel.ChannelSubChannelIds.ToString(), "", dBHelper);
                    if (result != GlobalErrors.Success) return result;
                }
                foreach (CustomerChannelModel channel in addedChannels)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, filedName, "", channel.ChannelSubChannelIds.ToString(), dBHelper);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateAppliedGroupsToCreditRelease(CreditReleaseModel creditReleaseObj, CreditReleaseModel orginalCreditRelese, int historyId, DateTime date, ref int assignmentId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<CustomerGroupModel> deletedGroups = new List<CustomerGroupModel>();
                List<CustomerGroupModel> addedGroups = new List<CustomerGroupModel>();

                if (orginalCreditRelese.AppliedGroups != null && orginalCreditRelese.AppliedGroups.Count > 0)
                {
                    orginalCreditRelese.AppliedGroups.ForEach(oldGroup =>
                    {
                        if (!creditReleaseObj.AppliedGroups.Any(x => x.GroupId == oldGroup.GroupId))
                        {
                            deletedGroups.Add(oldGroup);
                        }
                    });
                }
                if (creditReleaseObj.AppliedGroups != null && creditReleaseObj.AppliedGroups.Count > 0)
                {
                    creditReleaseObj.AppliedGroups.ForEach(newGroup =>
                    {
                        if (!orginalCreditRelese.AppliedGroups.Any(x => x.GroupId == newGroup.GroupId))
                        {
                            addedGroups.Add(newGroup);
                        }
                    });

                    foreach (CustomerGroupModel group in creditReleaseObj.AppliedGroups)
                    {
                        result = InsertAppliedGroupsToCreditRelease(group, assignmentId, creditReleaseObj.CreditReleaseId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                        assignmentId++;
                    }
                }
                foreach (CustomerGroupModel group in deletedGroups)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.GroupID, group.GroupId.ToString(), "", dBHelper);
                    if (result == GlobalErrors.Error) break;
                }
                foreach (CustomerGroupModel group in addedGroups)
                {
                    result = SaveCreditReleaseHistory(historyId, creditReleaseObj.CreditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.GroupID, "", group.GroupId.ToString(), dBHelper);
                    if (result == GlobalErrors.Error) break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedCustomerToCreditRelease(SimpleCustomerModel customer, int creditReleaseId, int assignmentId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into CreditReleaseAssignment (CreditReleaseID,AssignmentID,CustomerID,OutletID) values ({0},{1},{2},{3})"
                , creditReleaseId, assignmentId, customer.CustomerId, customer.OutletId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedChannelsToCreditRelease(CustomerChannelModel channel, int assignmentId, int creditReleaseId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into CreditReleaseAssignment (CreditReleaseID,AssignmentID,ChannelID,SubChannelID) values ({0},{1},{2},{3})",
                     creditReleaseId, assignmentId, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToCreditRelease(CustomerGroupModel group, int assignmentId, int creditReleaseId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into CreditReleaseAssignment (CreditReleaseID,AssignmentID,CustomerGroupID) values ({0},{1},{2})",
                creditReleaseId, assignmentId, group.GroupId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteCustomerCreditRelease(int creditReleaseId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                DateTime date = DateTime.Now;

                int historyId = GetMaxID(CoreDataBaseConstants.TableNames.CreditReleaseHistory, CoreDataBaseConstants.QueryColumnsNames.ChangeHistoryID);
                if (historyId == -1) return GlobalErrors.Error;

                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string sqlQuery = string.Format(@"UPDATE CreditRelease SET inactive = 1 WHERE CreditReleaseID = {0}", creditReleaseId);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                    result = SaveCreditReleaseHistory(historyId, creditReleaseId, _requestRepository.CurrentOperator.EmployeeId, date, CoreDataBaseConstants.QueryColumnsNames.Inactive, "", true.ToString(), dbHelper);

                if (result == GlobalErrors.Success)
                {
                    result = dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        private GlobalErrors SaveCreditReleaseHistory(int historyId, int releaseId, int employeeId, DateTime date, string changedField, string oldValue, string newValue, DBHelper<int> dbHelper)
        {
            try
            {
                GlobalErrors result = new GlobalErrors();
                string query = string.Format(@"Insert into CreditReleaseHistory (ChangeHistoryID, CreditReleaseID, ChangedBy, ChangedDate, FieldName, OldValue, NewValue)
                    Values ({0},{1},{2},{3},'{4}','{5}','{6}')"
                    , historyId
                    , releaseId
                    , employeeId
                    , LocalUtilities.ParseDateToSQLString(date)
                    , changedField
                    , oldValue == "" ? null : oldValue
                    , newValue.Replace("'", "''")
                    );
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerOutletPrices(int customerId, int outletId, ref string pricesCode)
        {
            pricesCode = "--";
            DBHelper<string> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<string> priceCodes = new List<string>();
                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";
                dbHelper = new DBHelper<string>();
                string itemQuery = string.Format(@"SELECT PriceListCode FROM PriceList 
                    LEFT JOIN (
                    SELECT PriceListID From CustomerPrice WHERE CustomerID = {0} AND OutletID = {1}
                    UNION
                    SELECT PriceListID From ChannelPrice
                    INNER JOIN CustomerGroup CG ON CG.ChannelID = ChannelPrice.ChannelID AND CG.SubChannelID = ChannelPrice.SubChannelID
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID WHERE COG.CustomerID = {0} AND COG.OutletID = {1}
                    UNION
                    SELECT PriceListID From GroupPrice
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = GroupPrice.GroupID WHERE COG.CustomerID = {0} AND COG.OutletID = {1}
                    ) as prices ON prices.PriceListID = PriceList.PriceListID
                    WHERE PriceList.IsDeleted = 0  {2} AND (prices.PriceListID IS NOT NULL OR (PriceList.PriceListID = {3} AND prices.PriceListID IS NULL))
                    ORDER BY PriceList.Priority", customerId, outletId, priceDateFilter, _requestRepository.Configurations.DefaultPriceListID);
                result = dbHelper.GetQueryList(itemQuery, ref priceCodes);
                if (result == GlobalErrors.Success && priceCodes != null && priceCodes.Count > 0)
                {
                    pricesCode = string.Join(",", priceCodes);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetCustomerLazyLoading(GeneralFilter filter, ref SharedTableResult<CustomerModel> custList)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerModel> dbHelper = null;
            var customerList = new List<CustomerModel>();
            try
            {
                dbHelper = new DBHelper<CustomerModel>();

                string searchFilter = string.Empty;
                string orderByFilter = "Order By CustomerCode";
                string searchClm = string.Empty;
                string territoryJoinFilter = string.Empty;
                string routeJoinFilter = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string supervisionJoin = string.Empty;
                string isDefaultCustomer = string.Empty;
                string extraJoin = string.Empty;
                string extraFields = string.Empty;
                string groupFilter = string.Empty;
                string chattingCustomerTerritoryJoin = string.Empty;
                string employeeSecutiryGroupdJoinFilter = string.Empty;
                string employeeFilter = string.Empty;
                string securityGroupsFilter = string.Empty;
                string collectionFilter = string.Empty;

                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendFormat(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", _requestRepository.CurrentOperator.OrganizationAccess);
                //}
                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection && filter.OrganizationId != -1)
                //{
                //    orgAccessJoin = new StringBuilder();
                //    orgAccessJoin.AppendFormat(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", filter.OrganizationId);
                //}
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    //filter.Page = 0;
                    orderByFilter = "Order By ExactSearch";
                    searchClm = string.Format(@" ,Case when Customer.CustomerCode = '{0}' then 0
                    when CustomerLanguage.Description = '{0}' then 1 else 2 end as ExactSearch  ", filter.CustomListFilter.SearchFilter.Trim());

                    searchFilter = string.Format(@"and ((Customer.CustomerCode LIKE '%{0}%')
                    OR ( CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1}))
                    OR(Customer.CustomerCode+' - ' + CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1})) )", filter.CustomListFilter.SearchFilter.Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                }

                if (filter.CustomerId != -1)
                {
                    orderByFilter = "Order By ExactSearch";
                    searchClm = string.Format(@" ,Case when Customer.CustomerId = '{0}' then 0
                    when CustomerLanguage.Description = '{0}' then 1 else 2 end as ExactSearch  ", filter.CustomerId);
                }

                if (!filter.IsDefaultCustomer)
                {
                    if (filter.TerritoryId > 0 || filter.EmployeeId >= 0)
                    {
                        string employeeTerritoryJoin = string.Empty;
                        string territoryFilter = string.Empty;
                        if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                        {
                            if (filter.TerritoryId > 0)
                            {
                                territoryFilter = $@" and CustOutTerritory.TerritoryID = {filter.TerritoryId}";
                            }
                            if (filter.EmployeeId >= 0)
                            {
                                employeeTerritoryJoin = $@" INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID AND EmployeeTerritory.EmployeeID = {filter.EmployeeId}";
                            }
                            territoryJoinFilter += string.Format(@" inner join CustOutTerritory on CustOutTerritory.CustomerID=Customer.CustomerID {0} {1}", territoryFilter, employeeTerritoryJoin);
                        }
                        else
                        {
                            if (filter.TerritoryId > 0)
                            {
                                territoryFilter = $@" and routeCust.TerritoryID = {filter.TerritoryId}";
                            }
                            if (filter.EmployeeId > 0)
                            {
                                employeeTerritoryJoin = $@" INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = routeCust.TerritoryID And EmployeeTerritory.EmployeeID = {filter.EmployeeId} ";
                            }
                            territoryJoinFilter += string.Format(@"
									inner join RouteCustomer on RouteCustomer.CustomerID=customer.CustomerID 
									inner join Route routeCust  on routeCust.RouteID=RouteCustomer.RouteID {0} {1}", territoryFilter, employeeTerritoryJoin);
                        }

                    }
                }
                if (filter.FilterOnRoute || filter.RouteId > 0)
                {
                    routeJoinFilter = string.Format(@" inner join RouteCustomer routeCustFilter on routeCustFilter.CustomerID=customer.CustomerID and routeCustFilter.RouteID={0} ", filter.RouteId);
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    if (filter.TerritoryId > 0 && _requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        supervisionJoin = string.Format(@"INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                       _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                    else
                    {
                        supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on Customer.CustomerID = CustOutTerritory.CustomerID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                        _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                }
                if (!filter.IsDefaultCustomer)
                {
                    isDefaultCustomer = string.Format(@"and (Customer.IsDefault = 0 or Customer.IsDefault is null)");
                }
                else
                {
                    isDefaultCustomer = string.Format(@"and (Customer.IsDefault = 1) AND Customer.CustomerID NOT IN (SELECT ISNULL(CustomerID, 0) FROM Employee WHERE EmployeeID <> {0})", filter.EmployeeId);
                    extraFields = string.Format(@"cast(Customer.CustomerID as nvarchar(200)) +'_'+ cast(COL.OutletID as nvarchar(200)) CustomerID_OutletID,CO.OutletID, COL.Description   +' - '+CustomerLanguage.Description as OutletCustomerName,");
                    extraJoin = string.Format(@"inner join CustomerOutlet CO on CO.CustomerID = Customer.CustomerID
                                               left outer join CustomerOutletLanguage COL on COL.CustomerID = CO.CustomerID and CO.OutletID = COL.OutletID and COL.LanguageID = {0}", _requestRepository.LanguageId);
                }
                if (filter.groupId != -1)
                {
                    groupFilter = string.Format(@" INNER JOIN CustomerOutletGroup on CustomerOutletGroup.CustomerID=Customer.CustomerID  AND CustomerOutletGroup.groupID = {0} ", filter.groupId);
                }
                if (filter.NewCustomerOnly)
                {
                    searchFilter += string.Format(" And Customer.New = 1 ");
                }
                else
                {
                    searchFilter += string.Format(" And Customer.New <> 1 ");
                }
                if (filter.IsFromCollection)
                {
                    collectionFilter = string.Format(@" inner join CustomerOutlet on CustomerOutlet.CustomerID = Customer.CustomerID 
                    inner join [Transaction] T on T.CustomerID = CustomerOutlet.CustomerID and	T.OutletID = CustomerOutlet.OutletID 
                    left outer join RouteHistory on RouteHistory.RouteHistoryID = T.RouteHistoryID");
                    searchFilter += string.Format(" And (RouteHistory.Uploaded is null OR RouteHistory.Uploaded = 0) And (T.Voided is null OR T.Voided = 0) And (T.RemainingAmount > 0) And (T.TransactionTypeID in (1, 3, 6))");
                }
                string baseQuery = string.Format(@" Select distinct {7} Customer.CustomerID ,Customer.CustomerCode ,CustomerLanguage.Description as CustomerName , IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName, Customer.CurrencyID ,
                                                   Customer.AllowPayAllOutlets
                                                   {4}
                                                   from Customer
                                                   Inner join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and languageid = {0}
                                                   and CustomerLanguage.OrganizationId in ({11})
                                                   {10}
                                                   {1}
                                                   {2}
                                                   {5}
                                                   {9}
                                                   {3}
                                                   {8}
                                                   {6} ",
                                                   _requestRepository.LanguageId, //0
                                                   territoryJoinFilter, //1
                                                   routeJoinFilter, //2
                                                   orgAccessJoin.ToString(), //3
                                                   searchClm, //4
                                                   supervisionJoin, //5
                                                   extraJoin, //6
                                                   extraFields, //7
                                                   groupFilter, //8
                                                   chattingCustomerTerritoryJoin, //9
                                                   collectionFilter, //10
                                                   _requestRepository.CurrentOperator.OrganizationAccess //11
                                                  );
                    string conditionFilter = string.Format(" where 1=1 {0} and Customer.Inactive<> 1 {1} and Customer.CustomerID <> {2}   ",
                    searchFilter, //0
                    isDefaultCustomer, //1
                    LocalUtilities.GestCustomerId //2
                    );

                if (filter.EmployeeIdsString != "" && filter.SecurityGroupIdsString != "")
                {
                    employeeFilter = string.Format(@" INNER Join CustOutTerritory ON CustOutTerritory.CustomerID = Customer.CustomerID
                    INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID AND EmployeeTerritory.EmployeeID IN ({0}) ", filter.EmployeeIdsString);
                    employeeSecutiryGroupdJoinFilter = string.Format(@" union 
                                                   {0}
                                                   inner join CustOutTerritory on CustOutTerritory.CustomerID =  Customer.CustomerID
                                                   INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID 
                                                   INNER JOIN EmployeeOperator on EmployeeOperator.EmployeeID = EmployeeTerritory.EmployeeID
                                                   INNER JOIN OperatorSecurityGroup on OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID and OperatorSecurityGroup.SecurityGroupID in ({1})
                                                   {2}
                                                   ",
                                                   baseQuery, //0
                                                   filter.SecurityGroupIdsString, //1
                                                   conditionFilter //2
                                                   );
                }
                else if (filter.EmployeeIdsString != "" || filter.SecurityGroupIdsString != "")
                {
                    if (filter.EmployeeIdsString != "")
                    {
                        employeeFilter = string.Format(@" INNER Join CustOutTerritory ON CustOutTerritory.CustomerID = Customer.CustomerID
                        INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID AND EmployeeTerritory.EmployeeID IN ({0}) ", filter.EmployeeIdsString);
                    }
                    if (filter.SecurityGroupIdsString != "")
                    {
                        securityGroupsFilter = string.Format(@" inner join CustOutTerritory on CustOutTerritory.CustomerID =  Customer.CustomerID
                        INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID 
                        INNER JOIN EmployeeOperator on EmployeeOperator.EmployeeID = EmployeeTerritory.EmployeeID
                        INNER JOIN OperatorSecurityGroup on OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID and OperatorSecurityGroup.SecurityGroupID in ({0}) ", filter.SecurityGroupIdsString);
                    }
                }
                string mainQuery = string.Format(@" {0}
                                                    {1}
                                                    {2}
                                                    {3}
                                                    {4}",
                                                   baseQuery, //0
                                                   employeeFilter, //1
                                                   securityGroupsFilter, //2
                                                   conditionFilter, //3
                                                   employeeSecutiryGroupdJoinFilter //4
                                                   );
                string customerQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1 
                filter.CustomListFilter.Page, //2
                filter.CustomListFilter.PageSize //3
                );

                var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);

                if (result == GlobalErrors.Success && objField != null)
                {
                    custList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(customerQuery, ref customerList , true);
                    custList.Data = customerList;
                }
                else
                {
                    return GlobalErrors.Error;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                custList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors GetOutletsLazyLoading(CustomListFilters filter, ref SharedTableResult<CustomerOutletModel> outList, int groupId, int territoryId, int classId, bool IsWitGetTerritories)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dbHelper = null;
            var customerList = new List<CustomerOutletModel>();
            try
            {
                dbHelper = new DBHelper<CustomerOutletModel>();

                string searchFilter = string.Empty;
                string groupJoinFilter = string.Empty;
                string territoryJoinFilter = string.Empty;
                string classJoinFilter = string.Empty;

                string orderByFilter = "Order By Customer.CustomerCode, CustomerOutlet.CustomerCode";
                string searchClm = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string supervisionJoin = string.Empty;

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (groupId > 0)
                {
                    groupJoinFilter = string.Format(@"INNER JOIN CustomerOutletGroup on CustomerOutlet.CustomerID = CustomerOutletGroup.CustomerID 
                    AND CustomerOutlet.OutletID = CustomerOutletGroup.OutletID AND CustomerOutletGroup.GroupID = {0}",
                    groupId);
                }
                if (territoryId > 0)
                {
                    territoryJoinFilter = string.Format(@"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = CustomerOutlet.CustomerID 
                    AND CustOutTerritory.OutletID = CustomerOutlet.OutletID AND CustOutTerritory.TerritoryID = {0} ",
                    territoryId);
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    if (territoryId > 0)
                    {
                        supervisionJoin = string.Format(@"INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                       _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                    else
                    {
                        supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = CustomerOutlet.CustomerID AND CustOutTerritory.OutletID = CustomerOutlet.OutletID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                         filter.EmployeeId > 0 ? filter.EmployeeId.ToString() : _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                    }
                }
                if (classId > 0)
                {
                    classJoinFilter = string.Format("INNER JOIN CustomerClass on CustomerOutlet.CustomerClassID = CustomerClass.CustomerClassID AND CustomerClass.CustomerClassID = {0}", classId);
                }
                if (!string.IsNullOrEmpty(filter.SearchFilter))
                {
                    orderByFilter = "Order By ExactSearch";
                    searchClm = string.Format(@" ,Case when CustomerOutlet.CustomerCode = '{0}' then 0
                    when CustomerOutletLanguage.Description = '{0}' then 1 else 2 end as ExactSearch  ", filter.SearchFilter.Trim());
                    //filter.Page = 0;
                    searchFilter = string.Format(@" and (CustomerOutlet.CustomerCode LIKE '%{0}%')
                            OR ( CustomerOutletLanguage.Description LIKE '%{0}%') ", filter.SearchFilter.Trim());
                }
                string mainQuery = string.Format(@"select Distinct CustomerOutlet.OutletID , Customer.CustomerID, Customer.CustomerCode, CustomerOutlet.CustomerCode OutletCode ,CustomerOutletLanguage.Description as OutletName , 
                IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, 
                IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName, 
                IsNull(CustomerLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as CustomerOutletName,
                IsNull(CONVERT(nvarchar(100),Customer.CustomerID) , '--') + ' ' + '-'+ ' ' + IsNull(CONVERT(nvarchar(100), CustomerOutlet.OutletID) , '--') as CustomerOutletIds
                {6}
                from CustomerOutlet
                Inner join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID and languageid = {0}
                INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID    
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                INNER JOIN CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}     
                and CustomerLanguage.OrganizationId in ({9})
                {1}
                {2}
                {3}
                {7}
                {4}
                where 1=1 {5} and Customer.Inactive <> 1 and Customer.New <> 1 and CustomerOutlet.Inactive <> 1 and (Customer.IsDefault = 0  or Customer.IsDefault is null) and Customer.CustomerID <> {8}  ",
                _requestRepository.LanguageId, //0
                groupJoinFilter, //1
                territoryJoinFilter, //2 
                classJoinFilter, //3
                orgAccessJoin.ToString(), //4
                searchFilter, //5
                searchClm, //6
                supervisionJoin, //7
                LocalUtilities.GestCustomerId, //8
                _requestRepository.CurrentOperator.OrganizationAccess //9
                );
                string customerQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.Page, //2
                filter.PageSize //3 
                );

                var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery.ToString());
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null)
                {
                    outList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(customerQuery, ref customerList);
                    if (result == GlobalErrors.Success && IsWitGetTerritories)
                    {
                        GetOutletsTerritory(ref customerList);
                    }
                    outList.Data = customerList;
                }
                else
                {
                    return GlobalErrors.Error;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public static GlobalErrors GetOutletsTerritory(ref List<CustomerOutletModel> outletsList)
        {
            DBHelper<int> dBHelper = null;
            string query = string.Empty;
            List<int> outletTerritoryIDs = new List<int>();
            try
            {
                dBHelper = new DBHelper<int>();
                GlobalErrors result = GlobalErrors.NotInitialized;
                for (int i = 0; i < outletsList.Count; i++)
                {
                    query = string.Format(@"select TerritoryID from CustOutTerritory where CustomerID = {0} AND OutletID = {1}",
                        outletsList[i].CustomerId,
                        outletsList[i].OutletId);
                    result = dBHelper.GetQueryList(query, ref outletTerritoryIDs);

                    if (outletTerritoryIDs != null && outletTerritoryIDs.Count > 0)
                    {
                        outletsList[i].outletTerritories = outletTerritoryIDs;
                    }
                    else
                    {
                        outletsList[i].outletTerritories = new List<int>();
                    }
                    if (result != GlobalErrors.Success)
                    {
                        break;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckContactNumberIsExist(string number, int customerId, int outletId, int countryId, ref bool isExist)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dBHelper = null;
            try
            {
                object field = 0;
                isExist = false;
                dBHelper = new DBHelper<CustomerOutletModel>();
                string query = string.Format(@"select Count(*) from CustomerOutletContact where Number = '{0}' and CountryId = {3} and (CustomerID !={1} or OutletID!={2})", number, customerId, outletId, countryId);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isExist = true;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckCustomerCodeIfExist(string code, ref bool isExist)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dBHelper = null;
            try
            {
                object field = 0;
                isExist = false;
                dBHelper = new DBHelper<CustomerOutletModel>();
                string query = string.Format(@"select Count(*) from CustomerCode where CustomerCode = '{0}' ", code);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isExist = true;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckCustomerEmailIsExist(string email, int customerId, int outletId, ref bool isExist)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dBHelper = null;
            try
            {
                object field = 0;
                isExist = false;
                dBHelper = new DBHelper<CustomerOutletModel>();
                string query = string.Format(@"select Count(*) from CustomerOutlet where Email = '{0}' and CustomerID !={1} and OutletID!={2}", email, customerId, outletId);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isExist = true;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #region [Price Protection]
        public GlobalErrors GetPriceProtection(PriceProtectionFilterModel filter, ref SharedTableResult<PriceProtectionModel> PriceProtection)
        {
            DBHelper<PriceProtectionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceProtectionModel> PriceProtectionList = new List<PriceProtectionModel>();
                dbHelper = new DBHelper<PriceProtectionModel>();
                List<PriceProtectionDetailModel> PriceProtectionDetailList = new List<PriceProtectionDetailModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                StringBuilder customerOrgAccess = new StringBuilder();
                string selectQuery = string.Empty;
                string supervisionJoin = string.Empty;
                if (filter != null)
                {
                    if (filter.StatusId > 0)
                    {
                        searchFilter += string.Format(@" and PPR.StatusID = {0}", filter.StatusId);
                    }
                    if (filter.EmployeeId > 0)
                    {
                        searchFilter += string.Format(@" and E.EmployeeID = {0}", filter.EmployeeId);
                    }
                    if (filter.CustomerId > 0)
                    {
                        searchFilter += string.Format(@" and CL.CustomerID = {0}", filter.CustomerId);
                    }
                    if (filter.OutletId > 0)
                    {
                        searchFilter += string.Format(@" and COL.OutletID = {0}", filter.OutletId);
                    }
                    if (filter.FromToDate != null && filter.FromToDate.Count() > 1)
                    {
                        searchFilter += string.Format(@" and  PPR.CreationDate >= "
                        + LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)) +
                        " and  PPR.UpdateDate <= " + LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)));
                    }
                    if (!string.IsNullOrWhiteSpace(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@" and(CL.Description like '%{0}%' 
                                                         or COL.Description like '%{0}%' 
                                                         or EL.Description like '%{0}%')", filter.CustomListFilter.SearchFilter);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By PPR.CreationDate DESC");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                { 
                    customerOrgAccess.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" INNER JOIN CustOutTerritory on CO.CustomerID = CustOutTerritory.CustomerID and CO.OutletID = CustOutTerritory.OutletID
                    INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId {0}",
                    _employeeManager.GetSupervisorAccess());
                }


                string mainQuery = string.Format(@"left join CustomerLanguage CL on Cl.CustomerID = PPR.CustomerID and CL.LanguageID = {1}
                                                   left join CustomerOutletLanguage COL on COL.OutletID = PPR.OutletID and COL.CustomerID = PPR.CustomerID and COL.LanguageID = {1}
                                                   left join EmployeeLanguage EL on EL.EmployeeID = PPR.EmployeeID and EL.LanguageID = {1}
                                                   inner join Customer C on PPR.CustomerID = C.CustomerID and C.CustomerID <> {4}
                                                   inner join CustomerOutlet CO on PPR.OutletID = CO.OutletID and PPR.CustomerID = CO.CustomerID
                                                   inner join Employee E on E.EmployeeID = PPR.EmployeeID and E.OrganizationID in ({0})
                                                   {2} {3}",
                                                   _requestRepository.CurrentOperator.OrganizationAccess, //0
                                                   _requestRepository.LanguageId, //1
                                                   customerOrgAccess, // 2
                                                   supervisionJoin, //3
                                                   LocalUtilities.GestCustomerId //4
                                                   );

                selectQuery = string.Format(@"select  ROW_NUMBER() Over(Order By PPR.CreationDate DESC) AS RowSeq, PPR.RequestID,PPR.CustomerID,PPR.OutletID,
                                                   PPR.RouteHistoryID,PPR.CreationDate,PPR.UpdateDate,PPR.StatusID,E.EmployeeID,
                                                    C.CustomerCode+' - '+CL.Description CustomerCodeName,CO.CustomerCode +' - '+ COL.Description OutletCodeName,E.EmployeeCode+' - '+ EL.Description EmployeeCodeName,
                                                   CASE WHEN PPR.StatusID = 1 THEN 1 ELSE 0 END ShowEditBtn ,
                                                   CASE WHEN PPR.StatusID = 1 THEN 1 ELSE 0 END ShowApproveBtn ,
                                                   CASE WHEN PPR.StatusID = 1 THEN 1 ELSE 0 END ShowRejectBtn ,
                                                   CASE WHEN PPR.StatusID = 1 THEN   'Desc_Pending'  ELSE 
                                                   CASE WHEN PPR.StatusID = 2 THEN   'Desc_Approved' ELSE 'Desc_Rejected' END
                                                   END RequestStatusDescription 
                                                   from PriceProtectionRequest PPR 
                                                   {0} where 1 = 1 {5} {1}
                                                   OFFSET  {2} ROWS    
								                   FETCH NEXT {3} ROWS ONLY",
                                                   mainQuery,//0
                                                   orderByFilter,//1
                                                   (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//2
                                                    filter.CustomListFilter.PageSize, //3
                                                    _requestRepository.LanguageId, //4
                                                     searchFilter //5
                                                      );
                string countQuery = string.Format(@"select IsNull(Count(*),0) from (select distinct PPR.*  From PriceProtectionRequest PPR {0})tt ", mainQuery);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);


                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    PriceProtection.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(selectQuery, ref PriceProtectionList , true);
                    PriceProtection.Data = PriceProtectionList;

                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                PriceProtection = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceProtectionData(string RequestID, ref List<PriceProtectionDetailModel> priceProtectionDetail)
        {
            DBHelper<PriceProtectionDetailModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<PriceProtectionDetailModel>();
                string detailQuery = string.Format(@"select PPRD.RequestID,PPRD.FromSerial,PPRD.ToSerial,PPRD.PackID,PPRD.Price,PPRD.Price NewPrice,Item.ItemCode +' - '+ ItemLanguage.Description as ItemName
                                                            ,ISNULL(SCS.SalesTransactionTypeID, SCSA.SalesTransactionTypeID) SalesTransactionTypeID
                                                            ,ISNULL(SPPH.Price,(TD.Price + (isnull(TD.Tax,0)/TD.Quantity)) - (isnull(TD.Discount,0)/TD.Quantity)) OldPrice
                                                            , ( ISNULL(SPPH.Price,(TD.Price + (isnull(TD.Tax,0)/TD.Quantity)) - (isnull(TD.Discount,0)/TD.Quantity)) - PPRD.Price ) PriceDifference
                                                            from PriceProtectionRequestDetail PPRD
                                                            inner join Pack on Pack.PackID = PPRD.PackID
                                                            left join ItemLanguage on ItemLanguage.ItemID = Pack.ItemID and ItemLanguage.LanguageID = {0}
                                                            inner join Item on Item.ItemID = Pack.ItemID
                                                            left join SerialCurrentStatus SCS on SCS.FromSerial = PPRD.FromSerial  
                                                            left join SerialCurrentStatusArchive SCSA on SCSA.FromSerial = PPRD.FromSerial  
                                                            left join SerialPriceProtectionHist SPPH on PPRD.FromSerial = SPPH.SerialNumber
                                                            inner join TransactionDetail TD on (TD.TransactionID = SCS.TransactionID and SCS.PackID = TD.PackID And TD.SalesTransactionTypeID = SCS.SalesTransactionTypeID And TD.SalesTransactionTypeID = {2} ) or (TD.TransactionID = SCSA.TransactionID and SCSA.PackID = TD.PackID And TD.SalesTransactionTypeID = SCSA.SalesTransactionTypeID And TD.SalesTransactionTypeID = {2}  )
                                                            where PPRD.RequestID = '{1}'
                                                            order by ItemName ,PPRD.FromSerial ", _requestRepository.LanguageId, RequestID, SalesTransactionTypes.Sales.GetHashCode());
                result = dbHelper.GetQueryList(detailQuery, ref priceProtectionDetail);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePriceProtection(List<PriceProtectionDetailModel> PricesProtectionList)
        {
            DBHelper<PriceProtectionDetailModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PriceProtectionDetailModel>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Empty;
                var numberOfDigits = _requestRepository.Configurations.NumberOfDigits;
                deleteQuery = string.Format(@"DELETE FROM PriceProtectionRequestDetail WHERE RequestID = '{0}' ",
                                              PricesProtectionList.Select(x => x.RequestID)?.FirstOrDefault());
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    foreach (var price in PricesProtectionList)
                    {
                        string insertQuery = string.Format(@"Insert into PriceProtectionRequestDetail (RequestID, FromSerial, ToSerial, PackID, OldPrice, Price) 
                                                             Values ('{0}','{1}','{2}',{3},{4},{5})",
                               price.RequestID, price.FromSerial, price.ToSerial, price.PackID, LocalUtilities.GetRoundedDecimal(price.OldPrice, numberOfDigits), LocalUtilities.GetRoundedDecimal(price.NewPrice, numberOfDigits));
                        result = dbHelper.ExecuteNonQuery(insertQuery);
                        if (result != GlobalErrors.Success)
                            break;

                    }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }

            return result;
        }

        public GlobalErrors UpdateStatus(int statusID, string requestID, DBHelper<PriceProtectionDetailModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update PriceProtectionRequest Set StatusId = {0} ,UpdateDate = {1} , UpdatedBy = {2} where RequestID = '{3}'",
                    statusID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), _requestRepository.CurrentOperator.EmployeeId, requestID);
                result = dBHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private int GetCustomerCurrencyID(int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int currencyId = -1;
            try
            {
                string query = string.Format(@"select CASE WHEN CurrencyID IS NULL OR CurrencyID <= 0 THEN (select TOP 1 CurrencyID from Currency where Base = 1) ELSE CurrencyID END as CurrencyID 
                from Account A
                INNER JOIN AccountCustOut ACO on ACO.AccountID = A.AccountID AND ACO.CustomerID = {0}
                AND ACO.OutletID = {1}", customerId, outletId);
                result = dbHelper.GetQuerySingle(query, ref currencyId);

                if (result == GlobalErrors.Success)
                {
                    return currencyId;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return currencyId;
        }
        public GlobalErrors UpdateStatusForPriceProtection(PriceProtectionModel request, int statusId, ref string message)
        {
            var dbHelper = new DBHelper<PriceProtectionDetailModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            var PriceProtectionData = new List<PriceProtectionDetailModel>();
            string _transactionNo = string.Empty;
            decimal totalPrice = 0;
            try
            {
                dbHelper.BeginTransaction();
                if (statusId == PriceProtectionStatus.Reject.GetHashCode())
                {
                    result = UpdateStatus(statusId, request.RequestID, dbHelper);
                    if (result == GlobalErrors.Success)
                        message = MessagesConstants.Desc_Rejected;

                }
                else if (statusId == PriceProtectionStatus.Approve.GetHashCode())
                {

                    Dictionary<int, decimal> divisions = new Dictionary<int, decimal>();
                    Dictionary<int, string> divisionsDocumentSeq = new Dictionary<int, string>();
                    string queryDetail = string.Format(@"select PPRD.RequestID,PPRD.FromSerial,PPRD.ToSerial,PPRD.PackID,PPRD.Price, isnull(t.Voided,tt.Voided) Voided, ISNULL(SCS.SalesTransactionTypeID ,
                                                      SCSA.SalesTransactionTypeID) SalesTransactionTypeID,IC.DivisionID,
                                                      ISNULL(SCS.SerialStatusID,SCSA.SerialStatusID) SerialSold,
                                                      case when  SPPH.SerialNumber is null then 0 else 1 end SerialExist,
                                                      ISNULL(SPPH.Price,(TD.Price + (isnull(TD.Tax,0)/TD.Quantity)) - (isnull(TD.Discount,0)/TD.Quantity)) OldPrice
                                                      from PriceProtectionRequestDetail PPRD
                                                      inner join Pack P on P.PackID = PPRD.PackID
                                                      inner join Item I on I.ItemID = P.ItemID
                                                      inner join ItemCategory IC on IC.ItemCategoryID = I.ItemCategoryID
                                                      left join SerialCurrentStatusArchive SCSA on SCSA.FromSerial =  PPRD.FromSerial  
                                                      left join SerialCurrentStatus SCS on SCS.FromSerial = PPRD.FromSerial
                                                      left join [Transaction] t on t.TransactionID = SCSA.TransactionID
                                                      left join [Transaction] tt on  tt.TransactionID = SCS.TransactionID 
                                                      left join [SerialPriceProtectionHist] SPPH on SPPH.SerialNumber = PPRD.FromSerial
                                                      left join TransactionDetail TD on (TD.TransactionID = SCS.TransactionID and SCS.PackID = TD.PackID And TD.SalesTransactionTypeID = SCS.SalesTransactionTypeID and TD.SalesTransactionTypeID = {1} ) 
                                                      or (TD.TransactionID = SCSA.TransactionID and SCSA.PackID = TD.PackID And TD.SalesTransactionTypeID = SCSA.SalesTransactionTypeID and  TD.SalesTransactionTypeID = {1}  )
                                                      where PPRD.RequestId = '{0}'", request.RequestID, SalesTransactionTypes.Sales.GetHashCode());

                    result = dbHelper.GetQueryList(queryDetail, ref PriceProtectionData);
                    if (result == GlobalErrors.Success)
                    {
                        foreach (var item in PriceProtectionData)
                        {
                            if (!item.Voided)
                            {
                                if (item.OldPrice <= item.Price || item.OldPrice == 0 || item.SalesTransactionTypeID == TransactionType.ReturnExchange.GetHashCode())
                                {
                                    message = MessagesConstants.Desc_New_Price_Should_Be_Less_Than_Old_Price;
                                    result = GlobalErrors.Error;
                                    break;
                                }
                                if (item.SerialSold != SerialStatus.SoldToCustomer.GetHashCode())
                                {
                                    message = MessagesConstants.Desc_Entered_Serials_Not_Solid_To_Any_Customer;
                                    result = GlobalErrors.Error;
                                    break;
                                }
                                //if (item.SerialExist)
                                //{
                                //    string deleteSerial = string.Format(@"DELETE FROM  SerialPriceProtectionHist where SerialNumber = '{0}' ", item.FromSerial);
                                //    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteSerial);
                                //    if (result != GlobalErrors.Success)
                                //        break;
                                //}

                                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                                {
                                    if (item.DivisionID > 0)
                                    {
                                        if (divisions.ContainsKey(item.DivisionID))
                                        {
                                            divisions[item.DivisionID] = divisions[item.DivisionID] + (item.OldPrice - item.Price);
                                            _transactionNo = divisionsDocumentSeq[item.DivisionID];
                                        }
                                        else
                                        {
                                            divisions.Add(item.DivisionID, (item.OldPrice - item.Price));
                                            _transactionNo = _documentSequenceManager.GetMaxDocumentSequence(_requestRepository.CurrentOperator.EmployeeId, DocumentTypes.CreditNote, item.DivisionID);
                                            divisionsDocumentSeq.Add(item.DivisionID, _transactionNo);
                                            if (string.IsNullOrEmpty(_transactionNo))
                                            {
                                                message = MessagesConstants.Desc_No_Document_Sequence;
                                                result = GlobalErrors.Error;
                                                break;
                                            }
                                        }
                                    }
                                }
                                else
                                {
                                    if (string.IsNullOrEmpty(_transactionNo))
                                        _transactionNo = _documentSequenceManager.GetMaxDocumentSequence(_requestRepository.CurrentOperator.EmployeeId, DocumentTypes.CreditNote, -1);
                                    if (string.IsNullOrEmpty(_transactionNo))
                                    {
                                        message = MessagesConstants.Desc_No_Document_Sequence;
                                        result = GlobalErrors.Error;
                                        break;
                                    }
                                }
                                totalPrice = item.OldPrice - item.Price;
                                if (result == GlobalErrors.Success)
                                {
                                    string queryPriceHist = string.Format(@"INSERT INTO SerialPriceProtectionHist (RouteHistoryID,CreditNoteID,CustomerID,OutletID,EmployeeID,OldPrice,Price,PackID,Date,SerialNumber) 
                                                          values ({0},'{1}',{2},{3},{4},{5},{6},{7},{8},'{9}')", request.RouteHistoryID, _transactionNo, request.CustomerID,
                                                          request.OutletID, _requestRepository.CurrentOperator.EmployeeId,
                                                          LocalUtilities.GetRoundedDecimal(item.OldPrice, _requestRepository.Configurations.NumberOfDigits), item.Price, item.PackID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), item.FromSerial);
                                    result = dbHelper.ExecuteNonQuery(queryPriceHist);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                            else
                            {
                                message = MessagesConstants.Desc_The_Request_Cannot_Be_Accepted_Some_Serials_Sales_Transactions_Were_Voided;
                                result = GlobalErrors.Error;
                                break;
                            }


                        }
                        if (result == GlobalErrors.Success)
                        {
                            if (divisions.Count > 0)
                            {
                                foreach (int divisionId in divisions.Keys)
                                {
                                    result = CreateCreditNote(request.CustomerID.ToString(), request.OutletID.ToString(), divisionId,
                                        request.RequestID, divisions[divisionId], divisionsDocumentSeq[divisionId], dbHelper);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                            else if (!string.IsNullOrEmpty(_transactionNo))
                            {
                                result = CreateCreditNote(request.CustomerID.ToString(), request.OutletID.ToString(), -1, request.RequestID, totalPrice, _transactionNo, dbHelper);
                            }
                        }
                        //Update Status
                        if (result == GlobalErrors.Success)
                        {
                            result = UpdateStatus(statusId, request.RequestID, dbHelper);
                            if (result == GlobalErrors.Success)
                                message = MessagesConstants.Desc_Approved;
                        }

                        if (result == GlobalErrors.Success && PriceProtectionData.Count > 0)
                        {
                            string updateQuery = string.Empty;
                            foreach (var item in PriceProtectionData)
                            {
                                updateQuery = string.Format(@"update PriceProtectionRequestDetail set oldPrice = {1} where FromSerial = '{0}' AND RequestID = '{2}'"
                                                                     , item.FromSerial, LocalUtilities.GetRoundedDecimal(item.OldPrice, _requestRepository.Configurations.NumberOfDigits)
                                                                     , request.RequestID);
                                result = dbHelper.ExecuteNonQuery(updateQuery);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors CreateCreditNote(string customerID, string outletID, int divisionId, string requestID, decimal totalPrice, string transactionNo, DBHelper<PriceProtectionDetailModel> dBHelper,string notes = "", int accountId = -1, DBHelper<int> dbHelperTransaction = null)
        {

            if (dBHelper != null && dbHelperTransaction == null)
            {
                dbHelperTransaction = new DBHelper<int>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
            }
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                TransactionModel transManager = new TransactionModel();
                transManager.TransactionDate = DateTime.Now;
                transManager.UpdatedDate = DateTime.Now;
                transManager.AccountId = accountId;
                transManager.TransactionId = transactionNo;
                transManager.SourceTransactionId = requestID;
                transManager.NetTotal = LocalUtilities.GetRoundedDecimal(totalPrice, _requestRepository.Configurations.NumberOfDigits);
                transManager.GrossTotal = LocalUtilities.GetRoundedDecimal(totalPrice, _requestRepository.Configurations.NumberOfDigits);
                transManager.RemainingAmount = LocalUtilities.GetRoundedDecimal(totalPrice, _requestRepository.Configurations.NumberOfDigits);
                transManager.TransactionType = TransactionType.CreditNote;
                transManager.TransactionTypeId = TransactionType.CreditNote.GetHashCode();
                transManager.CustomerId = int.Parse(customerID);
                transManager.OutletId = int.Parse(outletID);
                transManager.SalesMode = (SalesModes)int.Parse(GetCustomerType(Convert.ToInt32(customerID), Convert.ToInt32(outletID), dbHelperTransaction).ToString());
                transManager.EmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                transManager.TransactionStatusId = TransactionStatues.Approved.GetHashCode();
                transManager.CreatedBy = _requestRepository.CurrentOperator.EmployeeId;
                transManager.UpdatedBy = _requestRepository.CurrentOperator.EmployeeId;
                transManager.CreatedDate = DateTime.Now;
                transManager.CurrencyId = GetCustomerCurrencyID(int.Parse(customerID), int.Parse(outletID), dbHelperTransaction);//Accont for cust
                if (notes != "")
                {
                    transManager.Notes = notes;
                }
                else
                {
                    transManager.Notes = "";
                }
                transManager.SupervisorId = _requestRepository.CurrentOperator.SupervisorId;
                transManager.HelperId = _requestRepository.CurrentOperator.HelperId;
                transManager.DriverId = _requestRepository.CurrentOperator.DriverId;
                transManager.SalesRepId = _requestRepository.CurrentOperator.OperatorId;
                transManager.SalesManagerId = _requestRepository.CurrentOperator.SalesManagerId;
                transManager.OrganizationId = _requestRepository.CurrentOperator.OrganizationId;
                transManager.DivisionId = divisionId;
                transManager.Posted = true;
                transManager.RouteHistoryId = -1;
                transManager.RouteId = -1;
                transManager.Tax = 0;
                transManager.Discount = 0;
                transManager.Outlet = FillOutletData(transManager.CustomerId, transManager.OutletId, transManager.DivisionId, dbHelperTransaction);
                //if (transManager.Outlet != null && transManager.Outlet.CustOutPaymentTerm != null)
                //{
                //    PaymentTermModel paymentTerm = new PaymentTermModel();
                //    paymentTerm = transManager.Outlet.CustOutPaymentTerm;
                //    transManager.DueDate = DateTime.Now.AddDays(paymentTerm.GetDays());
                //}
                result = _transactionManager.SaveTransactionHeader(transManager, dbHelperTransaction);
                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelperTransaction, DocumentTypes.CreditNote, transManager.TransactionId, transManager.EmployeeId, transManager.DivisionId);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion

        #region (New Customer Templates)
        public GlobalErrors GetNewCustomerTemplates(ref List<CustomerTemplateModel> templateModels, int LanguageID)
        {
            CustomerTemplateModel customerTemplateModel = null;
            DBHelper<CustomerTemplateModel> dbHelper = null;
            GlobalErrors globalErrors = GlobalErrors.NotInitialized;
            try
            {
                customerTemplateModel = new CustomerTemplateModel();
                dbHelper = new DBHelper<CustomerTemplateModel>();
                templateModels = new List<CustomerTemplateModel>();
                string customerTypes = string.Format(@"select NewCustomerTemplate.NewCustomerTemplateID,NewCustomerTemplateLanguage.Description TemplateName , NewCustomerTemplate.DefaultCustomerTypeID,NewCustomerTemplate.CreditLimit,NewCustomerTemplate.PriceListID,NewCustomerTemplate.SurveyID,NewCustomerTemplate.PromotionGroupID,PriceListLanguage.Description PriceList,PromotionGroupLanguage.Description PromotionGroup ,DiscountGroupLanguage.Description DiscountGroup,NewCustomerTemplate.DiscountGroupID,CustomerTypeLanguage.Description DefaultCustomerType
                                                    , CustomerGroupLanguage.Description DefaultGroup,CustomerGroupLanguage.GroupID DefaultGroupID,NewCustomerTemplate.PaymentTermId,NewCustomerTemplate.IsVisitPatternChecked from NewCustomerTemplate
                                                    inner join NewCustomerTemplateLanguage on NewCustomerTemplate.NewCustomerTemplateID = NewCustomerTemplateLanguage.NewCustomerTemplateID 
                                                    LEFT Outer  join PriceListLanguage on NewCustomerTemplate.PriceListID = PriceListLanguage.PriceListID and PriceListLanguage.LanguageID={0}
                                                    LEFT Outer join PromotionGroupLanguage on NewCustomerTemplate.PromotionGroupID = PromotionGroupLanguage.PromotionGroupID and PromotionGroupLanguage.LanguageID={0}
                                                    LEFT Outer join DiscountGroupLanguage on NewCustomerTemplate.DiscountGroupID = DiscountGroupLanguage.DiscountGroupID and DiscountGroupLanguage.LanguageID={0}
                                                    LEFT Outer join CustomerTypeLanguage on NewCustomerTemplate.DefaultCustomerTypeID = CustomerTypeLanguage.CustomerTypeID and CustomerTypeLanguage.LanguageID={0}
                                                    LEFT Outer join CustomerGroupLanguage on NewCustomerTemplate.GroupID = CustomerGroupLanguage.GroupID and CustomerGroupLanguage.LanguageID={0}
                                                    where NewCustomerTemplateLanguage.LanguageID={0} and ISNULL(NewCustomerTemplate.IsDeleted,0) = 0
                                                    order By NewCustomerTemplate.NewCustomerTemplateID", LanguageID);
                globalErrors = dbHelper.GetQueryList(customerTypes, ref templateModels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return globalErrors;
        }

        public GlobalErrors GetDivisionsCredits(ref List<DivisionsCredits> divisionsCredits, int customerTemplateId)
        {
            DBHelper<DivisionsCredits> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<DivisionsCredits>();
                divisionsCredits = new List<DivisionsCredits>();
                string divisionsCreditsQuery = string.Format(@"select NCTD.DivisionID, NCTD.CreditLimit,NCTD.CustomerTypeID
                                                             ,D.DivisionCode +' - '+ Dl.Description divisionCodeName
                                                             from NewCustomerTemplate NCT
                                                             inner join NewCustTempDiv NCTD on NCTD.NewCustomerTemplateID = NCT.NewCustomerTemplateID
                                                             left join Division D on D.DivisionID = NCTD.DivisionID 
                                                             left join DivisionLanguage Dl on DL.DivisionID = D.DivisionID and Dl.LanguageID = {0}
                                                             where NCT.NewCustomerTemplateID = {1}", _requestRepository.LanguageId, customerTemplateId);

                result = dbHelper.GetQueryList(divisionsCreditsQuery, ref divisionsCredits);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public static DataTable GetNewTemplateCustomerTypes()
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string customerTypes = string.Format(@"select CustomerType.CustomerTypeID,Description From CustomerType 
                                                     Inner Join CustomerTypeLanguage On CustomerType.CustomerTypeID=CustomerTypeLanguage.CustomerTypeID  
                                                     where LanguageID={0} 
                                                     order By CustomerType.CustomerTypeID", 1);
                err = dbHelper.GetQueryDataTable(customerTypes, ref dt);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return dt;
        }
        public GlobalErrors GetNewTemplatePriceList(ref List<ComboBoxModel> priceList)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string customerTypes = string.Format(@"select PriceList.PriceListID Id,Description From PriceList 
                                                     Inner Join PriceListLanguage On PriceList.PriceListID=PriceListLanguage.PriceListID  
                                                     where LanguageID={0} And  PriceList.IsDeleted = 0  and PriceList.OrganizationId in ({1})
                                                     order By PriceList.PriceListID", _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);

                err = dbHelper.GetQueryList(customerTypes, ref priceList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors GetNewTemplatePromotionGroups(ref List<ComboBoxModel> promotionGroup)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string customerTypes = string.Format(@"select PromotionGroup.PromotionGroupID Id,Description From PromotionGroup 
                                                     Inner Join PromotionGroupLanguage On PromotionGroup.PromotionGroupID=PromotionGroupLanguage.PromotionGroupID  
                                                     where LanguageID={0} 
                                                     order By PromotionGroup.PromotionGroupID", _requestRepository.LanguageId);

                err = dbHelper.GetQueryList(customerTypes, ref promotionGroup);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors GetNewTemplateDiscountGroups(ref List<ComboBoxModel> discountGroup)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string customerTypes = string.Format(@"select DiscountGroup.DiscountGroupID Id,Description From DiscountGroup 
                                                     Inner Join DiscountGroupLanguage On DiscountGroup.DiscountGroupID=DiscountGroupLanguage.DiscountGroupID  
                                                     where LanguageID={0} 
                                                     order By DiscountGroup.DiscountGroupID", _requestRepository.LanguageId);
                err = dbHelper.GetQueryList(customerTypes, ref discountGroup);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public static int GetMaxNewCustomerTemplateID(DBHelper<int> dbHelper)
        {
            int NewCustomerTemplateID = -1;
            try
            {
                int field = -1;
                GlobalErrors result = dbHelper.GetQuerySingle("SELECT count (*) NewCustomerTemplateID FROM NewCustomerTemplate", ref field);
                if (!field.ToString().Equals(string.Empty) && Int32.Parse(field.ToString()) > 0)
                {
                    result = dbHelper.GetQuerySingle("SELECT MAX(NewCustomerTemplateID)+1 NewCustomerTemplateID FROM NewCustomerTemplate", ref field);
                    if (result == GlobalErrors.Success)
                    {
                        if (!field.ToString().Equals(string.Empty) || Int32.Parse(field.ToString()) != -1)
                        {
                            NewCustomerTemplateID = field;
                        }
                        else
                        {
                            NewCustomerTemplateID = 1;
                        }
                    }
                }
                else
                {
                    NewCustomerTemplateID = 1;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return NewCustomerTemplateID;
        }
        public GlobalErrors AddNewCustomerTemplate(CustomerTemplateModel objNewCustomertemplatesStruct, int TemplateID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string sqlStatment;
                sqlStatment = string.Format(@"insert into NewCustomerTemplate (NewCustomerTemplateID, DefaultCustomerTypeID, CreditLimit, PriceListID, PromotionGroupID,DiscountGroupID,GroupID,PaymentTermId,IsVisitPatternChecked,OldCustomerTemplateID) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})",
                TemplateID,//0
                objNewCustomertemplatesStruct.DefaultCustomerTypeId > 0 ? objNewCustomertemplatesStruct.DefaultCustomerTypeId.ToString() : "Null",//1
                objNewCustomertemplatesStruct.CreditLimit,//2
                objNewCustomertemplatesStruct.PriceListId > 0 ? objNewCustomertemplatesStruct.PriceListId.ToString() : "Null",//3
                objNewCustomertemplatesStruct.PromotionGroupId > 0 ? objNewCustomertemplatesStruct.PromotionGroupId.ToString() : "Null",//4
                objNewCustomertemplatesStruct.DiscountGroupId > 0 ? objNewCustomertemplatesStruct.DiscountGroupId.ToString() : "Null",//5
                objNewCustomertemplatesStruct.DefaultGroupId > 0 ? objNewCustomertemplatesStruct.DefaultGroupId.ToString() : "Null",//6
                objNewCustomertemplatesStruct.PaymentTermId > 0 ? objNewCustomertemplatesStruct.PaymentTermId.ToString() : "Null",//7
                objNewCustomertemplatesStruct.IsVisitPatternChecked ? "1" : "0",//8
                objNewCustomertemplatesStruct.OldCustomerTemplateID > 0 ? objNewCustomertemplatesStruct.OldCustomerTemplateID.ToString() : "Null"  //9
                );


                result = dbHelper.ExecuteNonQuery(sqlStatment);
                if (result == GlobalErrors.Success)
                {
                    string sqlQuery = string.Format(@" insert into NewCustomerTemplateLanguage select  {0},LanguageID,'{1}' from Languages",
                                                    TemplateID,
                                                    objNewCustomertemplatesStruct.TemplateName.Replace("'", "''").Trim());
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }

                if (result == GlobalErrors.Success && (_requestRepository.Configurations.ControlTransactionOnDivisionLevel
                    && objNewCustomertemplatesStruct.DivisionsCredits != null && objNewCustomertemplatesStruct.DivisionsCredits.Count > 0))
                    result = addEditDivisionCreditCustomerTemplate(dbHelper, objNewCustomertemplatesStruct.DivisionsCredits, TemplateID);

            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors addEditDivisionCreditCustomerTemplate(DBHelper<int> dbHelper, List<DivisionsCredits> divisionsCredits, int templateID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (divisionsCredits != null && divisionsCredits.Count > 0)
                {
                    result = DeleteCustomerTemplateData(templateID, "NewCustTempDiv");
                    if (result != GlobalErrors.Success || result != GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        foreach (var item in divisionsCredits)
                        {
                            string query = string.Format(@"insert into NewCustTempDiv (NewCustomerTemplateID, DivisionID, CreditLimit, CustomerTypeID)
                                        values ({0},{1},{2},{3})", templateID, item.DivisionID, item.CreditLimit, item.CustomerTypeId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                                break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

            return result;
        }
        public GlobalErrors AddNewCustomerTemplateFields(int nTemplateID, int nFieldID, bool bisMandatory, bool isVisable, DBHelper<int> dbHelper, int type = -1)
        {
            GlobalErrors result;
            try
            {
                string sqlQuerysqlQuery = string.Empty;
                if (type == 5)
                {
                    sqlQuerysqlQuery = string.Format(@"
                    insert into NewCustTempImgFields (NewCustomerTemplateID, NewCustTempImgID, IsMandatory,IsVisible)
                    values ({0},{1},'{2}','{3}')", nTemplateID, nFieldID, Convert.ToInt32(bisMandatory), Convert.ToInt32(isVisable));
                }
                else
                {
                    sqlQuerysqlQuery = string.Format(@"
                    insert into NewCustTempFields (NewCustomerTemplateID, NewCustTempFieldID, IsMandatory,isVisable)
                    values ({0},{1},'{2}','{3}')", nTemplateID, nFieldID, Convert.ToInt32(bisMandatory), Convert.ToInt32(isVisable));
                }
                result = dbHelper.ExecuteNonQuery(sqlQuerysqlQuery);
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateNewCustomerTemplate(CustomerTemplateModel customerTemplateModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlQuerysqlQuery = null;
                sqlQuerysqlQuery = string.Format(@"
                Update NewCustomerTemplate set DefaultCustomerTypeID={1}, CreditLimit = {2}, PriceListID = {3}, PromotionGroupID = {4},DiscountGroupID = {5},GroupID= {6},PaymentTermId={7},IsVisitPatternChecked={8}
                where NewCustomerTemplateID = {0}",
                    customerTemplateModel.NewCustomerTemplateId,//0
                    customerTemplateModel.DefaultCustomerTypeId > 0 ? customerTemplateModel.DefaultCustomerTypeId.ToString() : "Null",//1
                    customerTemplateModel.CreditLimit,//2
                    customerTemplateModel.PriceListId > 0 ? customerTemplateModel.PriceListId.ToString() : "Null",//3
                    customerTemplateModel.PromotionGroupId > 0 ? customerTemplateModel.PromotionGroupId.ToString() : "Null",//4
                    customerTemplateModel.DiscountGroupId > 0 ? customerTemplateModel.DiscountGroupId.ToString() : "Null",//5
                    customerTemplateModel.DefaultGroupId > 0 ? customerTemplateModel.DefaultGroupId.ToString() : "Null",//6
                    customerTemplateModel.PaymentTermId > 0 ? customerTemplateModel.PaymentTermId.ToString() : "Null",//7
                    customerTemplateModel.IsVisitPatternChecked ? "1" : "0"//8
                    );
                result = dBHelper.ExecuteNonQuery(sqlQuerysqlQuery);
                if (result == GlobalErrors.Success)
                {
                    string sqlQuery = string.Format(@"Update NewCustomerTemplateLanguage set Description = '{2}' where NewCustomerTemplateID = {0} and LanguageID = {1}",
                                                    customerTemplateModel.NewCustomerTemplateId, 1, customerTemplateModel.TemplateName.Replace("'", "''").Trim());
                    result = dBHelper.ExecuteNonQuery(sqlQuery);
                }
                if (result == GlobalErrors.Success && (_requestRepository.Configurations.ControlTransactionOnDivisionLevel
                    && customerTemplateModel.DivisionsCredits != null && customerTemplateModel.DivisionsCredits.Count > 0))
                    result = addEditDivisionCreditCustomerTemplate(dBHelper, customerTemplateModel.DivisionsCredits, customerTemplateModel.NewCustomerTemplateId);
                if (result == GlobalErrors.Success)
                {
                    result = DeleteNewCustomerTemplateAssignedRoutes(customerTemplateModel.NewCustomerTemplateId, dBHelper);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteNewCustomerTemplateAssignedRoutes(int newCustomerTemplateId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"  Delete rta from RouteTemplateAssignment rta
inner join Route r on r.RouteID = rta.RouteID
inner join territory on territory.TerritoryID = r.TerritoryID
                where territory.OrganizationID in ({1}) and rta.NewCustomerTemplateID = {0} ", newCustomerTemplateId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCustomerTemplateData(int nTemplateID, string TableName)
        {
            GlobalErrors result;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();

                string sqlDeleteQuerysqlQuery = string.Format(@"Delete from " + TableName + " where NewCustomerTemplateID = {0}", nTemplateID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlDeleteQuerysqlQuery);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteNewCustomerTemplate(int TemplateID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (TemplateID > 0)
                {
                    if (checkIfConnectedToRoute(TemplateID))
                    {
                        return GlobalErrors.NoMoreRows;
                    }
                    result = DeleteCustomerTemplateData(TemplateID, "NewCustomerTemplateLanguage");
                    if (result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.Success)
                    {
                        result = DeleteCustomerTemplateData(TemplateID, "NewCustTempFields");
                    }
                    if (result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.Success)
                    {
                        result = DeleteCustomerTemplateData(TemplateID, "NewCustTempDiv");
                    }
                    if (result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.Success)
                    {
                        result = DeleteCustomerTemplateData(TemplateID, "NewCustomerTemplate");
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private static GlobalErrors UpdateNewCustomerTemplateRoute(int nTemplateID)
        {
            GlobalErrors result;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                string sqlDeleteQuerysqlQuery = string.Format(@"
                Update Route set NewCustomerTemplateID = NULL
                where NewCustomerTemplateID = {0} ", nTemplateID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlDeleteQuerysqlQuery);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        private bool checkIfConnectedToRoute(int newCustomerTemplateID)
        {
            DBHelper<int> dbHelper = null;
            bool exist = false;
            try
            {
                object isExist = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format("select count(*) from RouteTemplateAssignment where NewCustomerTemplateID = {0} ", newCustomerTemplateID);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref isExist);
                if (result == GlobalErrors.Success)
                {
                    if (isExist != null && !string.IsNullOrEmpty(isExist.ToString()))
                    {
                        if (Int32.Parse(isExist.ToString()) > 0)
                            exist = true;
                        else
                            exist = false;
                    }
                    else
                    {
                        exist = false;
                    }
                }
                else
                {
                    exist = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return exist;
        }

        public GlobalErrors UpdateNewCustomerTemplateFields(int nTemplateID, int nFieldID, bool bisMandatory, bool isVisable, DBHelper<int> dBHelper,int type = -1)
        {
            GlobalErrors result;
            try
            {
                string sqlQuerysqlQuery = string.Empty;
                if(type == 5)
                {
                    sqlQuerysqlQuery = string.Format(@"
                    Update NewCustTempImgFields set IsMandatory = '{2}',IsVisible = '{3}'
                    where NewCustomerTemplateID = {0} and NewCustTempImgID = {1}", nTemplateID, nFieldID, Convert.ToInt32(bisMandatory), Convert.ToInt32(isVisable));
                }
                else
                {
                    sqlQuerysqlQuery = string.Format(@"
                    Update NewCustTempFields set IsMandatory = '{2}',IsVisable = '{3}'
                    where NewCustomerTemplateID = {0} and NewCustTempFieldID = {1}", nTemplateID, nFieldID, Convert.ToInt32(bisMandatory), Convert.ToInt32(isVisable));
                }
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuerysqlQuery);
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getGeneralFields(ref List<ComboBoxModel> generalFields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string divitionField = string.Empty;
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                    divitionField = " ,11";

                string customerTypes = string.Format(@"select NewCustTempFieldLanguage.NewCustTempFieldID Id ,NewCustTempFieldLanguage.Description  
                                                        from NewCustTempFieldLanguage 
                                                        where NewCustTempFieldID  in (1, 9, 13, 15, 16, 17, 18, 19, 20, 40, 41, 42, 48  {1} ) and  LanguageID = {0}"
                , _requestRepository.LanguageId, divitionField);
                err = dbHelper.GetQueryList(customerTypes, ref generalFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getAddedFields(ref List<ComboBoxModel> AddedFields, int type, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string inValues = string.Empty;
                switch (type)
                {
                    case 1://General
                        inValues = "(1, 9, 11, 13, 15, 16, 17, 18, 19, 20, 40, 41, 42, 48 )";
                        break;
                    case 2://Details
                        inValues = "(3, 4, 5, 6, 7, 8, 14,49)";
                        break;
                    case 3://Address
                        if (_requestRepository.Configurations.CustomerInformationMode == 2)
                            inValues = "(35,32,31,10, 47)";
                        else
                            inValues = "( 31, 32, 33, 34, 35, 36, 37, 38, 39, 10, 47,50)";
                        break;
                    case 4://Display
                        inValues = "( 22, 23, 24, 25, 26, 27, 28, 29, 30)";
                        break;
                }
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                if (type != 5)
                {
                    customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description   from NewCustTempFields  inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID =NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID in {1} and NewCustTempFieldLanguage.LanguageID={2} and NewCustTempFields.IsVisable = 1", fields.TempletId, inValues, fields.languageId);
                }
                else
                {
                    customerTypes = string.Format(@"select NewCustTempImgFields.NewCustTempImgID Id,NewCustTempImgFieldLanguage.Description   from NewCustTempImgFields  
                    inner join NewCustTempImgFieldLanguage on NewCustTempImgFields.NewCustTempImgID =NewCustTempImgFieldLanguage.NewCustTempImgID 
                    inner join NewCustTempImgField on NewCustTempImgField.NewCustTempImgID = NewCustTempImgFields.NewCustTempImgID
                    where NewCustTempImgFields.NewCustomerTemplateID = {0} and NewCustTempImgFieldLanguage.LanguageID={1} and NewCustTempImgFields.IsVisible = 1 and NewCustTempImgField.Inactive = 0", fields.TempletId, fields.languageId);
                }
                dbHelper.GetQueryList(customerTypes, ref AddedFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getAddedMandatoryFields(ref List<ComboBoxModel> AddedMandatoryFields, int type, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string inValues = string.Empty;
                switch (type)
                {
                    case 1://General
                        inValues = "(1, 9, 11, 13, 15, 16, 17, 18, 19, 20, 40, 41, 42, 48 )";
                        break;
                    case 2://Details
                        inValues = "(3, 4, 5, 6, 7, 8, 14, 49)";
                        break;
                    case 3://Address
                        if (_requestRepository.Configurations.CustomerInformationMode == 2)
                            inValues = "(35,32,31,10, 47)";
                        else
                            inValues = "( 31, 32, 33, 34, 35, 36, 37, 38, 39, 10, 47,50)";
                        break;
                    case 4://Display
                        inValues = "( 22, 23, 24, 25, 26, 27, 28, 29, 30)";
                        break;
                }
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                if (type != 5)
                {
                    customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description  from NewCustTempFields  inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID =NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID in {1} and NewCustTempFieldLanguage.LanguageID={2}  and NewCustTempFields.IsVisable = 1 and  NewCustTempFields.IsMandatory = 1", fields.TempletId, inValues, fields.languageId);

                }
                else
                {
                    customerTypes = string.Format(@"select NewCustTempImgFields.NewCustTempImgID Id,NewCustTempImgFieldLanguage.Description  from NewCustTempImgFields  
                    inner join NewCustTempImgFieldLanguage on NewCustTempImgFields.NewCustTempImgID =NewCustTempImgFieldLanguage.NewCustTempImgID
                    inner join NewCustTempImgField on NewCustTempImgField.NewCustTempImgID = NewCustTempImgFields.NewCustTempImgID 
                    where NewCustTempImgFields.NewCustomerTemplateID = {0}  and NewCustTempImgFieldLanguage.LanguageID={1}  and NewCustTempImgFields.IsVisible = 1 and  NewCustTempImgFields.IsMandatory = 1 and NewCustTempImgField.Inactive = 0", fields.TempletId, fields.languageId);
                }
                err = dbHelper.GetQueryList(customerTypes, ref AddedMandatoryFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getDetailsFields(ref List<ComboBoxModel> detailsFields, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                if (fields.IsEditMode)
                    customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description ,NewCustTempFields.IsMandatory ,NewCustTempFields.IsVisable 
                                                    from NewCustTempFields
                                                    inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID = NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID in (3,4,5,6,7,8,14,49) and NewCustTempFieldLanguage.LanguageID={1} ", fields.TempletId, _requestRepository.LanguageId);
                else
                    customerTypes = string.Format(@"select NewCustTempFieldLanguage.NewCustTempFieldID Id ,NewCustTempFieldLanguage.Description  from NewCustTempFieldLanguage where NewCustTempFieldID  in (3,4,5,6,7,8,14,49) and  LanguageID = {0}", _requestRepository.LanguageId);

                dbHelper.GetQueryList(customerTypes, ref detailsFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors GetGroups(ref List<ComboBoxModel> defaultGroup)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string customerGroups = string.Format(@"Select CustomerGroupLanguage.GroupID Id , Description from CustomerGroupLanguage  where languageID =  {0}", _requestRepository.LanguageId);
                err = dbHelper.GetQueryList(customerGroups, ref defaultGroup);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getAddressFields(ref List<ComboBoxModel> addressFields, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                string inValues = "";
                if (_requestRepository.Configurations.CustomerInformationMode == 2)
                    inValues = "(35,32,31,10,47)";
                else
                    inValues = "(31,32,33,34,35,36,37,38,39,47,10,50)";

                if (fields.IsEditMode)
                    customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description  ,NewCustTempFields.IsMandatory  ,NewCustTempFields.IsVisable from NewCustTempFields  inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID =NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID  in {2} and NewCustTempFieldLanguage.LanguageID= {1} ", fields.TempletId, _requestRepository.LanguageId, inValues);
                else
                    customerTypes = string.Format(@"select NewCustTempFieldLanguage.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description  from NewCustTempFieldLanguage where NewCustTempFieldID  in {1} and  LanguageID = {0}", _requestRepository.LanguageId, inValues);

                err = dbHelper.GetQueryList(customerTypes, ref addressFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getImagesFields(ref List<ComboBoxModel> imagesFields, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                    customerTypes = string.Format(@"select NewCustTempImgFieldLanguage.NewCustTempImgID Id,NewCustTempImgFieldLanguage.Description  from NewCustTempImgFieldLanguage 
                    inner join NewCustTempImgField on NewCustTempImgField.NewCustTempImgID = NewCustTempImgFieldLanguage.NewCustTempImgID
                    where LanguageID = {0} and NewCustTempImgField.Inactive = 0", _requestRepository.LanguageId);

                err = dbHelper.GetQueryList(customerTypes, ref imagesFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public GlobalErrors getAddedDisplayFields(ref List<ComboBoxModel> addedDisplayFields, FieldsObject fields)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            try
            {
                string customerTypes = string.Empty;
                DBHelper<ComboBoxModel> dbHelper = new DBHelper<ComboBoxModel>();
                if (fields.IsEditMode)
                    customerTypes = string.Format(@"select NewCustTempFields.NewCustTempFieldID Id,NewCustTempFieldLanguage.Description ,NewCustTempFields.IsMandatory  ,NewCustTempFields.IsVisable from NewCustTempFields  inner join NewCustTempFieldLanguage on NewCustTempFields.NewCustTempFieldID =NewCustTempFieldLanguage.NewCustTempFieldID where NewCustTempFields.NewCustomerTemplateID ={0} and NewCustTempFields.NewCustTempFieldID  in (22,23,24,25,26,27,28,29,30) and NewCustTempFieldLanguage.LanguageID={1} ", fields.TempletId, _requestRepository.LanguageId);
                else
                    customerTypes = string.Format(@"select NewCustTempFieldLanguage.NewCustTempFieldID Id ,NewCustTempFieldLanguage.Description,staus =0 from NewCustTempFieldLanguage where NewCustTempFieldID in (22,23,24,25,26,27,28,29,30) and LanguageID = {0}", _requestRepository.LanguageId);

                err = dbHelper.GetQueryList(customerTypes, ref addedDisplayFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return err;
        }
        public static bool getFieldVisablity(int fieldID, int templateID)
        {
            DBHelper<int> dbHelper = null;
            bool visablity = false;
            try
            {
                object isVisable = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format("select IsVisable from NewCustTempFields where NewCustomerTemplateID={0} and NewCustTempFieldID={1} ", templateID, fieldID);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref isVisable);
                if (result == GlobalErrors.Success)
                {
                    if (isVisable != null && !string.IsNullOrEmpty(isVisable.ToString()))
                    {
                        visablity = bool.Parse(isVisable.ToString());
                    }
                    else
                    {
                        visablity = false;
                    }
                }
                else
                {
                    visablity = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return visablity;
        }

        #endregion

        public static bool IsTaxableOutlet(int customerId, int outletId)
        {
            DBHelper<int> dbHelper = null;
            bool istaxable = false;
            try
            {
                object field = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format("select Taxeable from CustomerOutlet where CustomerId = {0} and OutletId = {1} ", customerId, outletId);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && bool.Parse(field.ToString()) == true)
                    {
                        istaxable = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return istaxable;
        }
        public static int GetMainOutletID(int customerId)
        {
            DBHelper<int> dbHelper = null;
            int outletID = -1;
            try
            {
                object field = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format("select OutletID from CustomerOutlet where CustomerId = {0}  and IsMain = 1", customerId);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        outletID = int.Parse(field.ToString());
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return outletID;
        }
        public GlobalErrors IsCustomerHasUnpaidTransactions(int customerId, int outletId, ref bool isHasUnpaidTransactions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object objSource = null;
                string query = string.Empty;

                query = String.Format(@"SELECT Count(*) FROM [Transaction]
                WHERE (CustomerID = {0}) And (OutletID = {1}) AND (RemainingAmount > 0) AND ( Voided <> 1 OR Voided IS NULL) AND (TransactionTypeID in ({2},{3},{4})) And (CreationReason <> {5})  ",
                customerId, //0
                outletId, //1
                TransactionType.Sales.GetHashCode(), //2
                TransactionType.DebitNote.GetHashCode(), //3
                TransactionType.SalesExchange.GetHashCode(), //4 
                TransactionCreationReason.OrderDeliveryBOInvoice.GetHashCode()
                );

                result = dbHelper.ExecuteScalar(query, ref objSource);
                if (result == GlobalErrors.Success)
                {
                    if (objSource != null && !string.IsNullOrEmpty(objSource.ToString()) && Int32.Parse(objSource.ToString()) > 0)
                    {
                        isHasUnpaidTransactions = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors CallInvoiceLocationProcedure(List<CustomerModel> customers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = new DBHelper<string>();
            string query = string.Empty;
            var procedureResult = new ProcedureResult();
            try
            {
                foreach (CustomerModel customer in customers)
                {
                    query = string.Format(@"EXEC [{0}]
                                          @CustomerID = {1}",
                                          CoreDataBaseConstants.ProceduresConstants.InvoiceLocation,//0
                                          customer.CustomerId //1
                                          );
                    var dbHelperProcedure = new DBHelper<ProcedureResult>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                    result = dbHelperProcedure.GetQuerySingle(query, ref procedureResult);
                    if (result != GlobalErrors.Success || procedureResult.Result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static CustomerCreditReleaseModel GetCustomerCreditRelease(int customerId, int outletId, CreditReleaseTypes releaseTypes, DBHelper<int> dBHelper)
        {
            var customerCreditRelease = new CustomerCreditReleaseModel();
            DBHelper<CustomerCreditReleaseModel> dBHelper2 = null;
            string query = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper2 = new DBHelper<CustomerCreditReleaseModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper2 = new DBHelper<CustomerCreditReleaseModel>();
                }

                query = string.Format(@"SELECT TOP 1 qq.Priority AS Priority ,qq.CreditReleaseID AS CreditReleaseID ,tt.CreditReleaseCode AS CreditReleaseCode ,
                tt.StartDate AS StartDate  ,tt.EndDate AS EndDate ,tt.Type AS Type ,tt.Value AS Value, tt.Inactive AS Inactive,tt.CreatedBy AS CreatedBy ,
                tt.CreatedDate AS CreatedDate ,tt.AssignmentID AS AssignmentID ,
                tt.CustomerID AS CustomerID ,tt.OutletID AS OutletID ,tt.CustomerGroupID AS CustomerGroupID, tt.ChannelID AS ChannelID ,
                tt.SubChannelID AS SubChannelID 
                FROM  
                ( SELECT 1 AS Priority , CreditReleaseAssignment.CreditReleaseID 
                FROM CreditReleaseAssignment 
                WHERE CreditReleaseAssignment.CustomerID = {0} AND CreditReleaseAssignment.OutletID = {1}
                UNION 
                SELECT 2 AS Priority ,CreditReleaseAssignment.CreditReleaseID 
                FROM CreditReleaseAssignment 
                WHERE CreditReleaseAssignment.CustomerID = {0} AND CreditReleaseAssignment.OutletID = -1
                UNION 
                SELECT 3 AS Priority ,CreditReleaseAssignment.CreditReleaseID 
                FROM CreditReleaseAssignment 
                INNER JOIN CustomerOutletGroup ON CustomerOutletGroup.GroupID = CreditReleaseAssignment.CustomerGroupID 
                WHERE CustomerOutletGroup.CustomerID = {0} AND CustomerOutletGroup.OutletID = {1}
                UNION 
                SELECT 4 AS PRIORITY ,CreditReleaseAssignment.CreditReleaseID 
                FROM CreditReleaseAssignment 
                INNER JOIN CustomerGroup ON CustomerGroup.ChannelID = CreditReleaseAssignment.ChannelID And CustomerGroup.SubChannelID = CreditReleaseAssignment.SubChannelID 
                INNER JOIN CustomerOutletGroup ON CustomerOutletGroup.GroupID = CustomerGroup.GroupID 
                WHERE CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                ) qq 
                INNER JOIN ( 
                SELECT CreditRelease.* 
                , CreditReleaseAssignment.CustomerID ,  CreditReleaseAssignment.OutletID , CreditReleaseAssignment.CustomerGroupID , CreditReleaseAssignment.ChannelID , CreditReleaseAssignment.SubChannelID , CreditReleaseAssignment.AssignmentID
                FROM CreditReleaseAssignment 
                INNER JOIN CreditRelease ON CreditReleaseAssignment.CreditReleaseID = CreditRelease.CreditReleaseID  )  tt 
                ON tt.CreditReleaseID = qq.CreditReleaseID
                WHERE (tt.Inactive <> 1 AND tt.Status = -1 ) AND tt.StartDate <= {2} AND tt.EndDate >= {2} AND tt.Type = {3} 
                ORDER BY qq.Priority"
                , customerId
                , outletId
                , LocalUtilities.ParseDateToSQLString(DateTime.Now)
                , (int)releaseTypes);


                var result = dBHelper2.GetQuerySingle(query, ref customerCreditRelease);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return customerCreditRelease;
        }
        public List<SimpleCustomerModel> FillCustomerOrganizationIdsAsList(List<SimpleCustomerModel> customersList, bool isOutletLevel, bool fillOrganizationIdsList, bool fillSDCIdsList)
        {
            List<SimpleCustomerModel> customersWithOrgIdsString = new List<SimpleCustomerModel>();
            try
            {
                if (isOutletLevel)
                {
                    customersWithOrgIdsString = customersList.GroupBy(c => new { c.CustomerId, c.OutletId }
                                 ).Select(grp => new SimpleCustomerModel
                                 {
                                     CustomerId = grp.Key.CustomerId,
                                     OutletId = grp.Key.OutletId,
                                     CustomerCode = grp.FirstOrDefault().CustomerCode,
                                     OutletCode = grp.FirstOrDefault().OutletCode,
                                     OutletName = grp.FirstOrDefault().OutletName,
                                     CustomerCodeName = grp.FirstOrDefault().CustomerCodeName,
                                     OutletCodeName = grp.FirstOrDefault().OutletCodeName,
                                     Address = grp.FirstOrDefault().Address,
                                     Phone = grp.FirstOrDefault().Phone,
                                     TradeLicenceNumber = grp.FirstOrDefault().TradeLicenceNumber,
                                     OrganizationIdsList = fillOrganizationIdsList ? grp.Select(co => co.OrganizationId).ToList() : new List<int>(),
                                     SDCIdsList = fillSDCIdsList ? grp.Select(co => co.SDCId).ToList().ToList() : new List<int>()
                                 }).ToList();
                }
                else
                {
                    customersWithOrgIdsString = customersList.GroupBy(c => new { c.CustomerId }
                               ).Select(grp => new SimpleCustomerModel
                               {
                                   CustomerId = grp.Key.CustomerId,
                                   OutletId = grp.FirstOrDefault().OutletId,
                                   CustomerCode = grp.FirstOrDefault().CustomerCode,
                                   CustomerCodeName = grp.FirstOrDefault().CustomerCodeName,
                                   CustomerName = grp.FirstOrDefault().CustomerName,
                                   Address = grp.FirstOrDefault().Address,
                                   Phone = grp.FirstOrDefault().Phone,
                                   OrganizationIdsList = grp.Select(co => co.OrganizationId).ToList()
                               }).ToList();
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return customersWithOrgIdsString;
        }
        public GlobalErrors GetOutletsListSharedTable(CustomerOutletFilter filter, ref SharedTableResult<SimpleCustomerModel> outletsListSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SimpleCustomerModel> dbHelper = null;
            List<SimpleCustomerModel> outletsList = new List<SimpleCustomerModel>();
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();

                string searchFilter = string.Empty;
                string orderByFilter = "Order By Customer.CustomerCode, CustomerOutlet.CustomerCode";
                string groupChannelSubChannelJoin = string.Empty;
                string territoryJoin = string.Empty;
                string routeJoin = string.Empty;
                string classJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                StringBuilder orgChildAccess = new StringBuilder();
                string orgChildAccessJoin = string.Empty;
                string supervisionJoin = string.Empty;
                string excludeDefaultCustomerQuery = string.Empty;
                string divisionJoin = string.Empty;
                string teleRepCustomersJoin = string.Empty;
                string organizationIdSelection = string.Empty;
                string salesDistributionChannelJoin = string.Empty;
                string salesDistributionChannelSelection = string.Empty;
                string salesDistributionChannelFilter = string.Empty;

                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{   //  this is payer screen [applied to] cust and their childs under orginal org Access
                //    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin && filter.IsFromPayerAccountScreen)
                //    {
                //        orgChildAccess.AppendLine(string.Format(CoreDataBaseConstants.OrgChildQuery, _requestRepository.CurrentOperator.OrganizationAccess));

                //        orgAccessJoin.AppendLine(string.Format(" INNER JOIN @ChildOrganizations Org ON CustomerOutlet.OrganizationID = Org.OrganizationID AND Org.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OriginalOrganizationAccess));
                //        if (filter.FillCustomerOrganizationIds)
                //        {
                //            organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                //        }
                //    }
                //    else
                //    {
                //        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", !string.IsNullOrEmpty(filter.SelectedOraganizationIds) ? filter.SelectedOraganizationIds : _requestRepository.CurrentOperator.OrganizationAccess));
                //        if (filter.FillCustomerOrganizationIds)
                //        {
                //            if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                //            {
                //                organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                //            }
                //            else
                //            {
                //                organizationIdSelection = " ,Account.OrganizationId ";
                //            }
                //        }
                //    }
                //}
                if (filter.CustomerGroupId != -1 || filter.ChannelId != -1 || filter.SubChannelId != -1) // join on customer group table
                {
                    groupChannelSubChannelJoin = @"INNER JOIN CustomerOutletGroup on CustomerOutlet.CustomerID = CustomerOutletGroup.CustomerID AND CustomerOutlet.OutletID = CustomerOutletGroup.OutletID 
                    INNER JOIN CustomerGroup on CustomerGroup.GroupID = CustomerOutletGroup.GroupID";
                }
                if (filter.TerritoryId != -1 || (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode()))
                {
                    territoryJoin = @"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = CustomerOutlet.CustomerID 
                    AND CustOutTerritory.OutletID = CustomerOutlet.OutletID ";
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                   _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                }
                if (filter.RouteId != -1)
                {
                    routeJoin = string.Format(@"INNER JOIN RouteCustomer on RouteCustomer.CustomerID = CustomerOutlet.CustomerID 
                    AND RouteCustomer.OutletID = CustomerOutlet.OutletID AND RouteCustomer.RouteId = {0} ",
                    filter.RouteId);
                }
                if (filter.CustomerClassId != -1)
                {
                    classJoin = string.Format("INNER JOIN CustomerClass on CustomerOutlet.CustomerClassID = CustomerClass.CustomerClassID AND CustomerClass.CustomerClassID = {0}",
                    filter.CustomerClassId);
                }
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@" and (
				       (CustomerOutlet.CustomerCode LIKE '%{0}%') OR ( CustomerOutletLanguage.Description LIKE '%{0}%')
                    OR (ISNULL(CustomerOutlet.CustomerCode, '--') + ' - ' + ISNULL(CustomerOutletLanguage.Description, '--') LIKE '%{0}%')
					OR (IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1}) )
                    OR (Customer.CustomerCode LIKE '%{0}%') OR ( CustomerLanguage.Description LIKE '%{0}%')
					OR (CustomerOutlet.Phone LIKE '%{0}%') OR (CustomerOutlet.TradeLicenceNumber LIKE '%{0}%')
					OR (CustomerOutletLanguage.Address LIKE '%{0}%')
					) ",
                    filter.CustomListFilter.SearchFilter.Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (filter.CustomerGroupId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.GroupId = {0}", filter.CustomerGroupId);
                }
                if (filter.ChannelId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.ChannelId = {0}", filter.ChannelId);
                }
                if (filter.SubChannelId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.SubChannelId = {0}", filter.SubChannelId);
                }
                if (filter.TerritoryId != -1)
                {
                    searchFilter += string.Format(" AND CustOutTerritory.TerritoryID = {0}", filter.TerritoryId);
                }
                if (filter.CustomerTypeId != -1)
                {
                    searchFilter += string.Format(" And CustomerOutlet.CustomerTypeId = {0} ", filter.CustomerTypeId);
                }
                if (filter.CountryId != "")
                {
                    searchFilter += string.Format(@" and CustomerOutlet.CountryID = {0}", filter.CountryId);
                }
                if (filter.StateID != "")
                {
                    searchFilter += string.Format(@" and CustomerOutlet.StateID = {0}", filter.StateID);
                }
                if (filter.CityId != "")
                {
                    searchFilter += string.Format(@" and CustomerOutlet.CityID = {0}", filter.CityId);
                }
                if (filter.AreaId != "")
                {
                    searchFilter += string.Format(@" and CustomerOutlet.AreaID = {0}", filter.AreaId);
                }
                if (filter.StreetId != "")
                {
                    searchFilter += string.Format(@" and CustomerOutlet.StreetID = {0}", filter.StreetId);
                }
                if (filter.DivisionId != -1)
                {
                    if (filter.isCustomerOutletDivisionHasRecords)
                    {
                        divisionJoin = string.Format(@" INNER JOIN CustomerOutletDivision on CustomerOutletDivision.CustomerID = CustomerOutlet.CustomerID and CustomerOutletDivision.OutletID = CustomerOutlet.OutletID  and CustomerOutletDivision.DivisionID = {0}", filter.DivisionId);
                    }
                    else
                    {
                        divisionJoin = string.Format(@" INNER JOIN AccountCustOutDiv on AccountCustOutDiv.CustomerID = CustomerOutlet.CustomerID and AccountCustOutDiv.OutletID = CustomerOutlet.OutletID  and AccountCustOutDiv.DivisionID = {0}", filter.DivisionId);
                    }
                }
                if (!filter.ShowDefault)
                {
                    excludeDefaultCustomerQuery = string.Format(@" and (Customer.IsDefault = 0  or Customer.IsDefault is null)");
                }
                if (filter.ExcludedCustomers != null && filter.ExcludedCustomers.Count > 0)
                {
                    searchFilter += string.Join(' ', filter.ExcludedCustomers.Select(customer => $" AND (CustomerOutlet.CustomerID <> {customer.CustomerId} OR CustomerOutlet.OutletID <> {customer.OutletId})").ToList());
                }
                if (filter.TeleRepId > -1)
                {
                    teleRepCustomersJoin = $@" INNER JOIN TeleRepCustomers TRC on TRC.CustomerID = CustomerOutlet.CustomerID AND TRC.OutletID = CustomerOutlet.OutletID AND TRC.EmployeeID = {filter.TeleRepId} ";
                }
                if (_requestRepository.Configurations.EnableSalesDistributionChannel)
                {
                    if (filter.FillCustomerSDCIds)
                    {
                        salesDistributionChannelSelection = " , SDCCustomer.SDCID ";
                        salesDistributionChannelJoin = $@" INNER JOIN SDCCustomer on SDCCustomer.CustomerID = Customer.CustomerID AND SDCCustomer.OutletID = CustomerOutlet.OutletID ";
                    }
                    if ((filter.SDCIdsList != null && filter.SDCIdsList.Count > 0) || filter.SDCId != -1)
                    {
                        salesDistributionChannelFilter =
                          $@" INNER JOIN ( select CustomerID, OutletID from SDCCustomer 
                                where 1=1 {(filter.SDCIdsList != null && filter.SDCIdsList.Count > 0 ? $" AND SDCID in ({string.Join(',', filter.SDCIdsList)}) " : string.Empty )}
                                {(filter.SDCId != -1 ? $" AND SDCID = {filter.SDCId} " : string.Empty )}
                                group by CustomerID, OutletID 
                                ) SDC on SDC.CustomerID = customer.CustomerID and SDC.OutletID = CustomerOutlet.OutletID";
                    }
                }

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By {0} {1} ",
                    filter.CustomListFilter.SortBy,
                    filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                string mainQuery = string.Format(@"
                select Distinct CustomerOutlet.OutletID , Customer.CustomerID, Customer.CustomerCode, CustomerOutlet.CustomerCode OutletCode ,CustomerOutletLanguage.Description as OutletName , IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                , CustomerOutletLanguage.Address, CustomerOutlet.Phone, CustomerOutlet.TradeLicenceNumber {11} {14}
                from CustomerOutlet
                Inner join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID and CustomerOutletLanguage.LanguageID = {0}
                INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID                                    
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                INNER JOIN CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}   
                and CustomerLanguage.OrganizationId in ({16})
                left outer join Route on Route.CustomerID = Customer.CustomerID
                {1}
                {2}
                {3}
                {4}
                {5}
                {6}
                {9}
                {12}
                {15}
                {13}
                where 1=1 {7} and Customer.Inactive <> 1 and Customer.New <> 1 and CustomerOutlet.Inactive <> 1 {8} and Customer.CustomerID <> {10}",
                _requestRepository.LanguageId, //0
                orgAccessJoin.ToString(), //1
                groupChannelSubChannelJoin,  //2
                territoryJoin,  //3
                supervisionJoin, //4
                routeJoin, //5
                classJoin, //6
                searchFilter, //7
                excludeDefaultCustomerQuery, //8
                divisionJoin, //9
                LocalUtilities.GestCustomerId,//10
                organizationIdSelection, // 11
                teleRepCustomersJoin, //12
                salesDistributionChannelJoin, // 13
                salesDistributionChannelSelection, // 14
                salesDistributionChannelFilter, // 15
                _requestRepository.CurrentOperator.OrganizationAccess//16
                );

                string countRows = !filter.GetAllData ? $"OFFSET  {filter.CustomListFilter.Page * filter.CustomListFilter.PageSize} ROWS FETCH NEXT {filter.CustomListFilter.PageSize} ROWS ONLY" : "";

                string customerQuery = string.Format(@"{3} {0} {1} {2}",
                mainQuery, //0
                orderByFilter, //1
                filter.IsFromTerritoryScreen ? "" : countRows, //2
                orgChildAccess // 3
                );

                object objField = 0;
                if (!filter.IsFromTerritoryScreen)
                {
                    string countQuery = string.Format(@" 
                    {1}
                    Select IsNull(Count(*),0) From ({0}) tt", mainQuery, orgChildAccess);
                    
                    result = dbHelper.ExecuteScalar(countQuery, ref objField);
                }
                if (result != GlobalErrors.Error)
                {
                    outletsListSharedTable.TotalItems = 0;
                    if (filter.IsFromTerritoryScreen || (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0))
                    {
                        outletsListSharedTable.TotalItems = Int32.Parse(objField.ToString().Trim());
                        result = dbHelper.GetQueryList(customerQuery, ref outletsList);
                    }
                    if ((_requestRepository.Configurations.ForceCustomerOrganizationSelection && filter.FillCustomerOrganizationIds) ||
                        (_requestRepository.Configurations.EnableSalesDistributionChannel && filter.FillCustomerSDCIds))
                    {
                        bool fillOrganizationIds = (_requestRepository.Configurations.ForceCustomerOrganizationSelection && filter.FillCustomerOrganizationIds);
                        bool fillSDCIds = (_requestRepository.Configurations.EnableSalesDistributionChannel && filter.FillCustomerSDCIds);
                        outletsList = FillCustomerOrganizationIdsAsList(outletsList, true, fillOrganizationIds, fillSDCIds);
                    }
                    outletsListSharedTable.Data = outletsList;
                    if (filter.IsFromTerritoryScreen)
                        outletsListSharedTable.TotalItems = outletsList.Count;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletsList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public GlobalErrors GetCustomersListSharedTable(CustomerOutletFilter filter, ref SharedTableResult<SimpleCustomerModel> outletsListSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SimpleCustomerModel> dbHelper = null;
            List<SimpleCustomerModel> outletsList = new List<SimpleCustomerModel>();
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();

                string searchFilter = string.Empty;
                string orderByFilter = "Order By Customer.CustomerCode";
                string groupChannelSubChannelJoin = string.Empty;
                string territoryJoin = string.Empty;
                string routeJoin = string.Empty;
                string classJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string supervisionJoin = string.Empty;
                string organizationIdSelection = string.Empty;

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", !string.IsNullOrEmpty(filter.SelectedOraganizationIds) ? filter.SelectedOraganizationIds : _requestRepository.CurrentOperator.OrganizationAccess));
                    if (filter.FillCustomerOrganizationIds)
                    {
                        if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                        {
                            organizationIdSelection = " ,Customer.OrganizationId ";
                        }
                        else
                        {
                            organizationIdSelection = " ,Account.OrganizationId ";
                        }
                    }
                }
                if (filter.CustomerGroupId != -1 || filter.ChannelId != -1 || filter.SubChannelId != -1) // join on customer group table
                {
                    groupChannelSubChannelJoin = @"INNER JOIN CustomerOutletGroup on Customer.CustomerID = CustomerOutletGroup.CustomerID 
                    INNER JOIN CustomerGroup on CustomerGroup.GroupID = CustomerOutletGroup.GroupID";
                }
                if (filter.TerritoryId != -1 || (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode()))
                {
                    territoryJoin = @"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = Customer.CustomerID";
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                   _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                }
                if (filter.RouteId != -1)
                {
                    routeJoin = string.Format(@"INNER JOIN RouteCustomer on RouteCustomer.CustomerID = Customer.CustomerID And RouteCustomer.RouteId = {0} ",
                    filter.RouteId);
                }
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@" and (
				    (Customer.CustomerCode LIKE '%{0}%') OR ( CustomerLanguage.Description LIKE '%{0}%')
					OR (Customer.Phone LIKE '%{0}%') OR (CustomerLanguage.Address LIKE '%{0}%')
					) ",
                    filter.CustomListFilter.SearchFilter.Trim());
                }
                if (filter.CustomerGroupId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.GroupId = {0}", filter.CustomerGroupId);
                }
                if (filter.ChannelId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.ChannelId = {0}", filter.ChannelId);
                }
                if (filter.SubChannelId != -1)
                {
                    searchFilter += string.Format(" And CustomerGroup.SubChannelId = {0}", filter.SubChannelId);
                }
                if (filter.TerritoryId != -1)
                {
                    searchFilter += string.Format(" AND CustOutTerritory.TerritoryID = {0}", filter.TerritoryId);
                }
                if (filter.ExcludedCustomers != null && filter.ExcludedCustomers.Count > 0)
                {

                    string customerIds = string.Join(',', filter.ExcludedCustomers.Select(customer => customer.CustomerId));
                    searchFilter += $" AND Customer.CustomerID NOT IN ({customerIds})";
                }

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By {0} {1} ",
                    filter.CustomListFilter.SortBy,
                    filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }
                string mainQuery = string.Format(@"select Distinct Customer.CustomerID, -1 as OutletID, Customer.CustomerCode, CustomerLanguage.Description CustomerName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                CustomerLanguage.Address, Customer.Phone {9}
                from Customer
                INNER JOIN CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
                and CustomerLanguage.OrganizationId in ({10})
                {1}
                {2}
                {3}
                {4}
                {5}
                {6}
                where 1=1 {7} and Customer.Inactive <> 1 and (Customer.IsDefault = 0  or Customer.IsDefault is null) and Customer.CustomerID <> {8}",
                _requestRepository.LanguageId, //0
                orgAccessJoin.ToString(), //1
                groupChannelSubChannelJoin,  //2
                territoryJoin,  //3
                supervisionJoin, //4
                routeJoin, //5
                classJoin, //6
                searchFilter, //7
                LocalUtilities.GestCustomerId, //8
                organizationIdSelection, //9
                _requestRepository.CurrentOperator.OrganizationAccess //10
                );

                string countRow = string.Format(@" OFFSET  {0} ROWS FETCH NEXT {1} ROWS ONLY ", filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, filter.CustomListFilter.PageSize);

                string customerQuery = string.Format(@" {0} {1} {2}",
                mainQuery, //0
                orderByFilter, //1
                filter.IsFromTerritoryScreen ? "" : countRow //2 
                );

                object objField = 0;
                if (!filter.IsFromTerritoryScreen)
                {
                    string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);
                    
                    result = dbHelper.ExecuteScalar(countQuery, ref objField);
                }
                if (result != GlobalErrors.Error)
                {
                    outletsListSharedTable.TotalItems = 0;
                    if (filter.IsFromTerritoryScreen || (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0))
                    {
                        outletsListSharedTable.TotalItems = Int32.Parse(objField.ToString().Trim());
                        result = dbHelper.GetQueryList(customerQuery, ref outletsList);
                    }
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection && filter.FillCustomerOrganizationIds)
                    {
                        outletsList = FillCustomerOrganizationIdsAsList(outletsList, false, true, false);
                    }
                    outletsListSharedTable.Data = outletsList;
                    if(filter.IsFromTerritoryScreen)
                      outletsListSharedTable.TotalItems = outletsList.Count;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletsList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public GlobalErrors GetCustomerGroupsListSharedTable(GeneralFilter filter, ref SharedTableResult<CustomerGroupModel> groupsListSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerGroupModel> dbHelper = null;
            List<CustomerGroupModel> groupsList = new List<CustomerGroupModel>();
            try
            {
                dbHelper = new DBHelper<CustomerGroupModel>();

                string searchFilter = string.Empty;
                string orderByFilter = "Order By CustomerGroup.GroupCode";
                if (filter.ChannelId != -1)
                {
                    searchFilter = string.Format(" And CustomerGroup.ChannelId = {0}", filter.ChannelId);
                }
                if (filter.SubChannelId != -1)
                {
                    searchFilter = string.Format(" And CustomerGroup.SubChannelId = {0}", filter.SubChannelId);
                }
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@" and (
				       (CustomerGroup.GroupCode LIKE '%{0}%') OR ( CustomerGroupLanguage.Description LIKE '%{0}%')
					) ",
                    filter.CustomListFilter.SearchFilter.Trim());
                }
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    if (!string.IsNullOrEmpty(filter.OrganizationIds))
                    {
                        searchFilter += $" And CustomerGroup.OrganizationID in ({filter.OrganizationIds})";
                    }
                    else
                    {
                        searchFilter += $" and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                    }
                }

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By {0} {1} ",
                    filter.CustomListFilter.SortBy,
                    filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                string mainQuery = string.Format(@"select CustomerGroup.*,CustomerGroupLanguage.Description GroupName,
                                                   IsNull( CustomerGroup.GroupCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerGroupLanguage.Description , '--') as GroupCodeName 
                                                   from CustomerGroup
                                                   left Outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={0}
                                                   Where 1=1 {1}
                                                   ", _requestRepository.LanguageId, searchFilter
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})d",
                 mainQuery);

                string selectionQuery = mainQuery + @$"{orderByFilter}
                OFFSET  {(filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize}
                ROWS
                FETCH NEXT {filter.CustomListFilter.PageSize}
                ROWS ONLY";
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success)
                {
                    groupsListSharedTable.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        result = dbHelper.GetQueryList(selectionQuery, ref groupsList);
                        groupsListSharedTable.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                    groupsListSharedTable.Data = groupsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                groupsList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public bool IsExceedsCustomerBillToBillLimit(int customerId, int outletId, int divisionId)
        {
            bool checkBilltoBill = false;

            string divisionFilter = string.Empty;

            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && divisionId != -1)
                {
                    divisionFilter = string.Format(@"AND DivisionID = {0}", divisionId);
                }

                string query = string.Format(@"SELECT BillsOpenNumber - ISNULL (TT.RemainingInvoice ,0)
	                                                FROM CustomerOutlet 
			                                                LEFT JOIN (
			                                                SELECT CustomerID,OutletID , COUNT (*) AS RemainingInvoice
				                                                FROM [Transaction] 
				                                                WHERE TransactionTypeID in (1,3,6) 
					                                                  AND CustomerID = {0} AND RemainingAmount > 0 
					                                                  AND Voided <> 1 AND  OutletID = {1}  {2}
				                                                 GROUP BY CustomerID, OutletID) AS TT ON 
			                                                TT.CustomerID = CustomerOutlet.CustomerID AND TT.OutletID = CustomerOutlet.OutletID
	                                                WHERE CustomerOutlet.CustomerID = {0} AND CustomerOutlet.CustomerTypeID = 3 AND CustomerOutlet.OutletID = {1}",
                                                    customerId, outletId, divisionFilter);

                object field = new object();

                var result = dBHelper.ExecuteScalar(query, ref field);


                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    if ((int)field <= 0)
                    {
                        checkBilltoBill = true;
                    }
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return checkBilltoBill;
        }
        public GlobalErrors IsValidToDeleteAccount(int accountId, ref bool isUsed)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = null;
                string query = string.Format(@"Select AccountID from Account Where 
                AccountID in (select AccountID from [Transaction] Where AccountID = {0})
                or
                AccountID in (select AccountID from CustomerPayment Where AccountID = {0})",
                accountId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public int GetCustomerType(int customer, int outlet)
        {
            return GetCustomerType(customer, outlet, null);
        }
        public int GetCustomerType(int customer, int outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int customerType = -1;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();

                string customerTypeQuery = string.Format("SELECT CustomerTypeID FROM CustomerOutlet where CustomerID = {0} AND OutletID = {1}", customer, outlet);
                result = dbHelper.GetQuerySingle(customerTypeQuery, ref customerType);
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(customerType.ToString()))
                    return int.Parse(customerType.ToString());
                else
                    return -1;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }

        }
        #region BlackListItem
        public GlobalErrors InsertNewItemBlackList(BlackListItemModel itemBlackList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;


                query = string.Format(@"insert into ItemBlackList (ItemBlackListID) Values({0})",
                           itemBlackList.ItemBlackListId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateItemBlackList(BlackListItemModel itemBlackList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {



                query = string.Format(@"update ItemBlackListOrganization set OrganizationId='{1}' where ItemBlackListId={0}", itemBlackList.ItemBlackListId, itemBlackList.OrganizationId);

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteItemBlackListLanguage(int itemBlackListId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;


                query = string.Format(@"delete from ItemBlackListLanguage where ItemBlackListId = {0}", itemBlackListId);

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors DeleteItemBlackList(int itemBlackListId)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();

                string query = string.Format(@"delete from ItemBlackListLanguage where ItemBlackListID ={0}", itemBlackListId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from ItemBlackListDetails where ItemBlackListID ={0}", itemBlackListId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {

                        query = string.Format(@"delete from ItemBlackListCustomers where ItemBlackListID ={0}", itemBlackListId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {

                            query = string.Format(@"delete from ItemBlackListOrganization where ItemBlackListID ={0}", itemBlackListId);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                            query = string.Format(@"delete from ItemBlackList where ItemBlackListID ={0}", itemBlackListId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
        }

        public GlobalErrors DeleteItemBlackListDetails(int itemBlackListId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {

                query = $@"delete IBL from ItemBlackListDetails IBL
                                 inner join Item I on I.ItemID = IBL.ItemID
                                 inner join ItemCategory IC on IC.ItemCategoryID = I.ItemCategoryID
                                 inner join Division D on D.DivisionID = IC.DivisionID and D.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                 where IBL.ItemBlackListId = {itemBlackListId}";

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteCustomerItemBlackListOrganization(int itemBlackListId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {//accsess
                query = string.Format(@"delete from ItemBlackListOrganization where ItemBlackListID ={0} AND OrganizationID in ({1})", itemBlackListId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors DeleteCustomerItemBlackListAssignment(int itemBlackListId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {//accsess


                string deleteQuery = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {

                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                    }

                    string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (CustomerGroupID is not null or CustomerGroupID <> -1) " : string.Empty;
                    string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                    deleteQuery = $@"DELETE FROM ItemBlackListCustomers WHERE ItemBlackListID = {itemBlackListId} and ((ChannelID <> -1 or ChannelID is not null)
                                        or (SubChannelID <> -1 or SubChannelID is not null)   {deleteGroups} {deleteCustomers})";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        deleteQuery = $@" DELETE IBL FROM ItemBlackListCustomers IBL                               
                                           inner join CustomerGroup CG  on CG.GroupID = IBL.CustomerGroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE IBL.ItemBlackListID = {itemBlackListId} ";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                    }
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        deleteQuery = $@" DELETE IBL FROM ItemBlackListCustomers IBL 
                                           inner join CustomerOutlet CO on CO.CustomerID = IBL.CustomerID and CO.OutletID = IBL.OutletID
                                           { orgAccessJoin }
                                           WHERE IBL.ItemBlackListID = {itemBlackListId} ";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                    }
                }
                else
                {
                    deleteQuery = string.Format(@"delete from ItemBlackListCustomers where ItemBlackListID = {0}", itemBlackListId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveItemBlackListLanguage(BlackListItemModel itemBlackList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlStatment = string.Empty;
                foreach (TextLanguage textLanguage in itemBlackList.DescriptionLanguages)
                {
                    if (textLanguage.Description == null || string.IsNullOrEmpty(textLanguage.Description.Trim()))
                    {
                        textLanguage.Description = itemBlackList.itemBlackListName;
                    }


                    sqlStatment = string.Format("INSERT INTO ItemBlackListLanguage (ItemBlackListID,LanguageID,Description) Values ({0},{1},'{2}')",

                    itemBlackList.ItemBlackListId,
                     textLanguage.LanguageId,
                    textLanguage.Description.Replace("'", "''"));

                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemBlackListDetails(BlackListItemModel itemBlackList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            /* addedItems.BlockTypeList.FindIndex(x => x.blockTypeId == 1) >= 0*/
            try
            {

                int isSalesBlock = 0;
                int isReturnBlock = 0;

                if (itemBlackList.ItemsId != null && itemBlackList.ItemsId.Count > 0)
                {
                    foreach (ItemBlackListModel addedItem in itemBlackList.AddedItemsList)
                    {

                        //if (addedItem.BlockTypeList.FindIndex(x => x.blockTypeId == 1) >= 0)
                        //{
                        //    isSalesBlock = 1;

                        //}
                        //if(addedItem.BlockTypeList.FindIndex(x => x.blockTypeId == 2) >= 0)
                        //{
                        //     isReturnBlock = 1;

                        //}


                        query = string.Format(@"insert into ItemBlackListDetails (ItemID , ItemBlackListID, IsSalesBlocked, IsReturnBlocked) values({0},{1}, {2}, {3}) ", addedItem.ItemId, itemBlackList.ItemBlackListId, addedItem.IsSalesBlock, addedItem.IsReturnsBlock);

                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveCustomerItemBlackListOrganization(BlackListItemModel itemBlackList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (itemBlackList.AppliedOrganizations != null && itemBlackList.AppliedOrganizations.Count != 0)
                {
                    foreach (var org in itemBlackList.AppliedOrganizations)
                    {
                        query = string.Format(@"INSERT INTO ItemBlackListOrganization VALUES ({0}, {1})", itemBlackList.ItemBlackListId, org.OrganizationId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertItemBlackListCustomer(int itemBlackListCustomerId, BlackListItemModel itemBlackList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {

                if (itemBlackList.AppliedCustomers != null && itemBlackList.AppliedCustomers.Count > 0)
                {
                    foreach (SimpleCustomerModel customer in itemBlackList.AppliedCustomers)
                    {
                        result = InsertAppliedCustomersToItemBlackList(customer, itemBlackListCustomerId, itemBlackList.ItemBlackListId, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                        itemBlackListCustomerId++;
                    }
                }
                //Save applied groups
                if (itemBlackList.AppliedGroups != null && itemBlackList.AppliedGroups.Count > 0)
                {
                    foreach (CustomerGroupModel group in itemBlackList.AppliedGroups)
                    {
                        result = InsertAppliedGroupsToItemBlackList(group, itemBlackListCustomerId, itemBlackList.ItemBlackListId, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                        itemBlackListCustomerId++;
                    }
                }
                //Save applied channels
                if (itemBlackList.AppliedChannels != null && itemBlackList.AppliedChannels.Count > 0)
                {
                    foreach (CustomerChannelModel channel in itemBlackList.AppliedChannels)
                    {
                        result = InsertAppliedChannelsToItemBlackList(channel, itemBlackListCustomerId, itemBlackList.ItemBlackListId, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                        itemBlackListCustomerId++;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedCustomersToItemBlackList(SimpleCustomerModel customerOutlet, int itemBlackListCustomerId, int itemBlackListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;


                query = string.Format(@"insert into ItemBlackListCustomers(CustomerItemBlackListId, ItemBlackListID, CustomerID, OutletID)
                            values({0},{1},{2},{3})"
               , itemBlackListCustomerId, itemBlackListId, customerOutlet.CustomerId, customerOutlet.OutletId);//, -1, -1, -1);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedGroupsToItemBlackList(CustomerGroupModel group, int itemBlackListCustomerId, int itemBlackListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;


                query = string.Format(@"Insert into ItemBlackListCustomers (itemBlackListID, CustomerItemBlackListId, CustomerGroupID) values ({0},{1},{2})",
               itemBlackListId, itemBlackListCustomerId, group.GroupId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors InsertAppliedChannelsToItemBlackList(CustomerChannelModel channel, int itemBlackListCustomerId, int itemBlackListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Empty;



                query = string.Format(@"Insert into ItemBlackListCustomers (ItemBlackListID, CustomerItemBlackListId, ChannelID, SubChannelID) values ({0},{1},{2},{3})",
                itemBlackListId, itemBlackListCustomerId, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);



                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetItemBlackListDescriptions(int itemBlackListId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select ItemBlackListLanguage.ItemBlackListID as Id, ItemBlackListLanguage.Description, ItemBlackListLanguage.LanguageID from ItemBlackListLanguage where ItemBlackListLanguage.ItemBlackListID = {0}", itemBlackListId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCustomerItemBlackListOrganizations(int itemBlackListId, ref List<OrganizationModel> orginazations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {//accsess
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT Organization.OrganizationID,(Organization.OrganizationCode + ' - ' +OrganizationLanguage.Description) OrganizationCodeName
                FROM ItemBlackListOrganization INNER JOIN
		                Organization ON ItemBlackListOrganization.OrganizationID = Organization.OrganizationID and Organization.OrganizationID in ({2}) INNER JOIN 
		                OrganizationLanguage ON Organization.OrganizationID = OrganizationLanguage.OrganizationID 
		                AND OrganizationLanguage.LanguageID = {0}
                WHERE ItemBlackListOrganization.ItemBlackListID = {1}", _requestRepository.LanguageId, itemBlackListId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref orginazations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemBlackListAppliedChannels(int itemBlackListId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;


                query = string.Format(@"select ItemBlackListCustomers.ItemBlackListID ,ItemBlackListCustomers.ChannelID, ItemBlackListCustomers.SubChannelID,
                               (CONVERT(varchar(10),ItemBlackListCustomers.ChannelID) + '-' + CONVERT(varchar(10),ItemBlackListCustomers.SubChannelID)) ChannelSubChannelIds ,
                               (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                from ItemBlackListCustomers
                                Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = ItemBlackListCustomers.ChannelID and ChannelLanguage.LanguageID = {1}
                                left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = ItemBlackListCustomers.SubChannelID and SubChannelLanguage.LanguageID = {1}
                                where ItemBlackListCustomers.ItemBlackListID={0}", itemBlackListId, _requestRepository.LanguageId);


                dbHelper = new DBHelper<CustomerChannelModel>();

                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemBlackListAppliedGroups(int itemBlackListId, ref List<CustomerGroupModel> appliedGroups)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccessGroups = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                string query = string.Empty;
                query = string.Format(@"select ItemBlackListCustomers.ItemBlackListID ,ItemBlackListCustomers.CustomerGroupID GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                from ItemBlackListCustomers
                                inner join CustomerGroup on CustomerGroup.GroupID=ItemBlackListCustomers.CustomerGroupID {2}
                                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                where ItemBlackListCustomers.ItemBlackListID={0}", itemBlackListId, _requestRepository.LanguageId, orgAccessGroups);

                dbHelper = new DBHelper<CustomerGroupModel>();
                result = dbHelper.GetQueryList(query, ref appliedGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemBlackListAppliedCustomers(int itemBlackListId, ref List<SimpleCustomerModel> appliedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Empty;

                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                query = string.Format(@"
                select ItemBlackListCustomers.ItemBlackListID ,ItemBlackListCustomers.CustomerID ,ItemBlackListCustomers.OutletID ,
                Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                from ItemBlackListCustomers
                inner join Customer on Customer.CustomerID=ItemBlackListCustomers.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID=ItemBlackListCustomers.CustomerID and CustomerOutlet.OutletID=ItemBlackListCustomers.OutletID
                left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                and CustomerOutletLanguage.LanguageID={1}
                {2}
                where ItemBlackListCustomers.ItemBlackListID={0}", itemBlackListId, _requestRepository.LanguageId, orgAccessJoin);

                result = dbHelper.GetQueryList(query, ref appliedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemsBlackLists(GeneralFilter filter, ref List<BlackListItemModel> itemBlackLists)
        {
            DBHelper<BlackListItemModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string searchFilter = string.Empty;
            string itemBlackListJoin = "";
            string organizationSelection = string.Empty;
            string organizationJoin = string.Empty;
            string organizationAccess = string.Empty;
            string assignmentJoin = string.Empty;
            string query = string.Empty;
            try
            {
                dBHelper = new DBHelper<BlackListItemModel>();
                if (filter != null)
                {

                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( (ItemsBlackListLanguage.Description LIKE '%{0}%')
                    OR ( ItemBlackListID LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (!string.IsNullOrEmpty(filter.groupId.ToString()) && filter.groupId > -1 && filter.CustomerId == -1 && filter.OutletId == -1)
                    {
                        searchFilter += string.Format(@" And  ItemBlackListCustomers.CustomerGroupID ={0}", filter.groupId);
                    }
                    if (!string.IsNullOrEmpty(filter.CustomerId.ToString()) && filter.CustomerId > -1 && filter.groupId == -1)
                    {
                        searchFilter += string.Format(@" And  ItemBlackListCustomers.CustomerID ={0}", filter.CustomerId);
                    }
                    if (!string.IsNullOrEmpty(filter.OutletId.ToString()) && filter.OutletId > -1 && filter.groupId == -1)
                    {
                        searchFilter += string.Format(@" And  ItemBlackListCustomers.OutletID ={0}", filter.OutletId);
                    }
                    if (!string.IsNullOrEmpty(filter.OrganizationId.ToString()) && filter.OrganizationId > -1)
                    {
                        searchFilter += string.Format(@" And  Organization.OrganizationId ={0}", filter.OrganizationId);
                    }
                    if (filter.groupId > -1 && filter.CustomerId > -1 && filter.OutletId > -1)
                    {
                        assignmentJoin = string.Format(@"Left Join ItemBlackListCustomers cust ON ItemBlackList.ItemBlackListID =cust.ItemBlackListID and cust.CustomerID <> -1 
                                    Left Join ItemBlackListCustomers groups ON ItemBlackList.ItemBlackListID =groups.ItemBlackListID and groups.CustomerGroupID <> -1 ");
                        searchFilter += string.Format(@" and (cust.CustomerID = {0} and cust.OutletID = {1}) and (groups.CustomerGroupID = {2})", filter.CustomerId, filter.OutletId, filter.groupId);
                    }

                    //if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    //{
                    //    orderByFilter = string.Format(@"Order By tt.StartDate desc");
                    //}
                    //else
                    //{
                    //    if (filter.CustomListFilter.SortBy == "amountString")
                    //        filter.CustomListFilter.SortBy = "amount";
                    //    orderByFilter = string.Format(@"Order By {0} {1} "
                    //    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    //}



                    itemBlackListJoin = string.Format("Left Join ItemBlackListCustomers ON ItemBlackList.ItemBlackListID =ItemBlackListCustomers.ItemBlackListID ");

                    organizationSelection = string.Format(@", CASE (SELECT COUNT(OrganizationID) AS ItemBlackListID FROM ItemBlackListOrganization WHERE ItemBlackListOrganization.ItemBlackListID = ItemBlackList.ItemBlackListID) 
                                WHEN 0 THEN '---'
                                WHEN 1 THEN (select  Organization.OrganizationCode + ' - ' +  OrganizationLanguage.Description  as OrganizationCodeName from Organization inner join ItemBlackListOrganization on Organization.OrganizationID = ItemBlackListOrganization.OrganizationID inner join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0} where ItemBlackListID = ItemBlackList.ItemBlackListID)
                                ELSE '{1}'
                                END OrganizationCodeName", _requestRepository.LanguageId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organization, _requestRepository.LanguageId));
                    organizationJoin = string.Format(" INNER join ItemBlackListOrganization on ItemBlackList.ItemBlackListID = ItemBlackListOrganization.ItemBlackListID  INNER join Organization on Organization.OrganizationID = ItemBlackListOrganization.OrganizationID left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                    organizationAccess = string.Format("and ItemBlackListOrganization.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);



                    query = string.Format(@"select distinct ItemBlackList.ItemBlackListID, ItemBlackListLanguage.Description as ItemBlackListName  {3} 
                        from ItemBlackListLanguage inner join ItemBlackList on ItemBlackListLanguage.ItemBlackListID = ItemBlackList.ItemBlackListID and LanguageID= {0}
                        {6}
                        {1} {4} where 1=1  {2} {5}",
                    _requestRepository.LanguageId, //0
                    itemBlackListJoin,//1
                    searchFilter,//2
                    organizationSelection,//3
                    organizationJoin,//4
                    organizationAccess,//5
                    assignmentJoin //6
                    );

                }
                result = dBHelper.GetQueryList(query, ref itemBlackLists , true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                itemBlackLists = null;
            }
            return result;
        }
        public GlobalErrors GetItemsForItemList(int itemBlackListId, ref List<ItemBlackListModel> addedItemsList)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemBlackListModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<ItemBlackListModel>();

                query = string.Format(@" 
                                            select I.ItemID,IBD.IsSalesBlocked as IsSalesBlock,IBD.IsReturnBlocked as IsReturnsBlock,IBH.ItemBlackListID
                                            ,ISNULL( I.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( IL.Description , '--') as ItemCodeName , 2 as ValueType
                                            from ItemBlackListDetails IBD
                                            inner join Item I on I.ItemID = IBD.ItemID
                                            inner join ItemCategory on ItemCategory.ItemCategoryID = I.ItemCategoryID AND ItemCategory.DivisionID IN ({2})
                                            left join ItemLanguage IL on IL.ItemID = I.ItemID and IL.LanguageID = {0}
                                            inner join ItemBlackList IBH on IBH.ItemBlackListID = IBD.ItemBlackListID
                                            where IBH.ItemBlackListID = {1}", _requestRepository.LanguageId, itemBlackListId, _requestRepository.CurrentOperator.DivisionAccess);

                result = dbHelper.GetQueryList(query, ref addedItemsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion


        #region [CustomerMapping]
        public GlobalErrors GetCustomerMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customersList = new List<CustomerOutletModel>();
            string orgFilter = string.Empty;
            string organizationFilter = string.Empty;
            string RouteId = "1";
            string outletsFilter = string.Empty;
            string creditLimitSelection = string.Empty;
            StringBuilder OrgAcessJoin = new StringBuilder();
            try
            {
                DBHelper<CustomerOutletModel> dBHelper = new DBHelper<CustomerOutletModel>();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgFilter = string.Format(@" inner join AccountCustOut ACO on ACO.CustomerID = CustomerOutlet.CustomerID And ACO.OutletID = CustomerOutlet.OutletID Inner Join Account AC on AC.AccountID = ACO.AccountID And AC.OrganizationID in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (_requestRepository.Configurations.ForceCustomerOrganizationAccess)
                {                    
                    OrgAcessJoin.AppendFormat(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", _requestRepository.CurrentOperator.OrganizationAccess);                 
                }

                outletsFilter = GetCOSAndDisplayUnitFilter(filter);

                string Query = string.Format(@"SELECT 
                                              IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                               IsNull( CustomerOutletLanguage.Description , '--') as OutletName,
                                              CustomerOutlet.GPSLatitude, CustomerOutlet.GPSLongitude," + RouteId + @" ,CustomerOutletLanguage.CustomerID  ,CustomerOutlet.OutletID
                                              ,case when CustomerOutletImage.Photo is null then 0 else 1 end hasImage
                                              FROM CustomerOutlet 
                                              Inner Join Customer On Customer.CustomerID = CustomerOutlet.CustomerID
                                              inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                              left outer join CustomerOutletImage on CustomerOutletImage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletImage.OutletID = CustomerOutlet.OutletID
                                              {1} {2}
                                              {3}
                                              INNER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND 
                                              CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                                              LEFT OUTER JOIN CustomerOutletGroup Groups on Groups.CustomerID = CustomerOutlet.CustomerID and Groups.OutletID = CustomerOutlet.OutletID 
                                              WHERE (CustomerOutletLanguage.LanguageID = {0}) ",
                                             _requestRepository.LanguageId,
                                              OrgAcessJoin,
                                              orgFilter,
                                              outletsFilter

                                              );
                if (filter.GroupId != -1)
                {
                    Query += string.Format(" AND Groups.GroupId = {0} ", filter.GroupId);
                }
                if (!filter.AllCustomers)
                {
                    Query += string.Format(" AND (CustomerOutlet.CustomerID = {0}) ", filter.CustomerId);
                    Query += string.Format(" AND (CustomerOutlet.OutletID = {0})", filter.OutletId);
                }
                Query += " AND CustomerOutlet.GPSLatitude <> 0 AND CustomerOutlet.GPSLongitude <> 0";
                Query += FillCustomerFilter(filter);

                result = dBHelper.GetQueryList(Query, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRouteCustomerMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customersList = new List<CustomerOutletModel>();
            DBHelper<CustomerOutletModel> dBHelper = null;
            StringBuilder orgFilter = new StringBuilder();
            string creditLimitSelection = string.Empty;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                { 
                    orgFilter.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess); 
                }
                string outletsFilter = GetCOSAndDisplayUnitFilter(filter);

                string Query = string.Format(@"SELECT distinct  
                                                 IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                                 IsNull( CustomerOutletLanguage.Description , '--') as OutletName,
                                                 CustomerOutlet.GPSLatitude, CustomerOutlet.GPSLongitude,CustomerOutletLanguage.CustomerID,RouteCustomer.OutletID
                                                 ,case when CustomerOutletImage.Photo is null then 0 else 1 end hasImage
                                                 FROM CustomerOutlet 
                                                 Inner Join Customer On Customer.CustomerID = CustomerOutlet.CustomerID 
                                                 left outer join CustomerOutletImage on CustomerOutletImage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletImage.OutletID = CustomerOutlet.OutletID
                                                 {2}
                                                 INNER JOIN
                                                 CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND 
                                                 CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID INNER JOIN
                                                 RouteCustomer ON CustomerOutletLanguage.CustomerID = RouteCustomer.CustomerID AND 
                                                 CustomerOutletLanguage.OutletID = RouteCustomer.OutletID
                                                 inner join route on RouteCustomer.routeid = route.routeid
                                                 inner join Territory on Territory.TerritoryID = Route.TerritoryID
                                                 {3}
                                                 WHERE (CustomerOutletLanguage.LanguageID = {0})  and Territory.OrganizationID in ({1})",
                                                 _requestRepository.LanguageId,
                                                 _requestRepository.CurrentOperator.OrganizationAccess,
                                                 orgFilter,
                                                 outletsFilter
                                                 );
                if (!filter.AllRoutes)
                {
                    Query += string.Format(" AND (RouteCustomer.RouteID = {0}) ", filter.RouteId);
                }
                Query += " AND CustomerOutlet.GPSLatitude <> 0 AND CustomerOutlet.GPSLongitude <> 0 ";
                Query += FillCustomerFilter(filter);
                result = dBHelper.GetQueryList(Query, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRouteHistoryMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customersList = new List<CustomerOutletModel>();
            DBHelper<CustomerOutletModel> dBHelper = null;
            StringBuilder orgFilter = new StringBuilder();
            string creditLimitSelection = string.Empty;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                { 
                    orgFilter.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                string outletsFilter = GetCOSAndDisplayUnitFilter(filter);
                string Query = string.Format(@"SELECT DISTINCT 
                                                 IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                                 IsNull( CustomerOutletLanguage.Description , '--') as OutletName,
                                                 ISNULL(Case RouteHistoryDetail.GPSLatitude when 0 then CustomerOutlet.GPSLatitude else RouteHistoryDetail.GPSLatitude end ,0)GPSLatitude
                                                 ,ISNULL(Case RouteHistoryDetail.GPSLongitude when 0 then CustomerOutlet.GPSLongitude else RouteHistoryDetail.GPSLongitude end ,0)GPSLongitude
                                                ,RouteHistory.RouteID
                                                --,RouteHistory.ActualStart,RouteHistory.ActualEnd  
                                                ,RouteHistoryDetail.ActualStart,RouteHistoryDetail.ActualEnd  
                                                ,CustomerOutlet.CustomerID,RouteHistoryDetail.OutletID
                                                ,case when CustomerOutletImage.Photo is null then 0 else 1 end hasImage
                                                From CustomerOutlet 
                                                Inner Join Customer On Customer.CustomerID = CustomerOutlet.CustomerID 
                                                left outer join CustomerOutletImage on CustomerOutletImage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletImage.OutletID = CustomerOutlet.OutletID
                                                {3}
                                                INNER JOIN
                                                CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                                                inner join RouteHistoryDetail on CustomerOutlet.CustomerID=RouteHistoryDetail.CustomerID  and CustomerOutlet.OutletID=RouteHistoryDetail.OutletID
                                                INNER JOIN RouteHistory ON RouteHistoryDetail.routeHistoryID = RouteHistory.routeHistoryID
                                                inner join Territory on Territory.TerritoryID = RouteHistory.TerritoryID
                                                {4}
                                                WHERE (CustomerOutletLanguage.LanguageID = {0}) and Territory.OrganizationID in ({1})  AND (RouteHistory.RouteDate >= {2} and RouteHistory.RouteDate < {5} ) ",
                                                _requestRepository.LanguageId, //0
                                                _requestRepository.CurrentOperator.OrganizationAccess, //1
                                                LocalUtilities.ParseDateToSQLString(filter.RouteDateModel.Date), //2  
                                                orgFilter, // 3
                                                outletsFilter, //4 
                                                LocalUtilities.ParseDateToSQLString(filter.RouteDateModel.Date.AddDays(1)) //5 
                                                );

                if (filter.RouteHistoryId != -1 && !filter.AllRoutes)
                    Query += string.Format(@"and RouteHistory.routeHistoryID={0}", filter.RouteHistoryId);
                if (!filter.AllRoutes)
                {
                    Query += string.Format(" AND (RouteHistory.RouteID = {0}) and (RouteHistoryDetail.VisitStatusID=1 or( RouteHistoryDetail.VisitStatusID=3 and RouteHistoryDetail.NoSalesReasonID <>-1))", filter.RouteId);
                }
                Query += "  AND((RouteHistoryDetail.GPSLatitude <>0 AND RouteHistoryDetail.GPSLongitude <>0)"
               + "or(CustomerOutlet.GPSLatitude <>0 AND CustomerOutlet.GPSLongitude <>0))"
               + "order by RouteHistoryDetail.ActualStart";
                Query += FillCustomerFilter(filter);
                result = dBHelper.GetQueryList(Query, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTerritoryCustomersMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customersList = new List<CustomerOutletModel>();
            DBHelper<CustomerOutletModel> dBHelper = null;
            StringBuilder orgFilter = new StringBuilder();
            string creditLimitSelection = string.Empty;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                { 
                    orgFilter.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);
                }

                string outletsFilter = GetCOSAndDisplayUnitFilter(filter);

                string Query = string.Format(@"SELECT distinct 
                                                 IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                                IsNull( CustomerOutletLanguage.Description , '--') as OutletName,
                                                CustomerOutlet.GPSLatitude, CustomerOutlet.GPSLongitude,CustomerOutletLanguage.CustomerID ,RouteCustomer.OutletID 
                                                ,case when CustomerOutletImage.Photo is null then 0 else 1 end hasImage
                                                FROM CustomerOutlet
                                                Inner Join Customer On Customer.CustomerID = CustomerOutlet.CustomerID 
                                                left outer join CustomerOutletImage on CustomerOutletImage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletImage.OutletID = CustomerOutlet.OutletID
                                                {2}
                                                INNER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID =CustomerOutletLanguage.CustomerID AND 
                                                CustomerOutlet.OutletID =CustomerOutletLanguage.OutletID INNER JOIN
                                                RouteCustomer ON CustomerOutletLanguage.CustomerID =RouteCustomer.CustomerID AND 
                                                CustomerOutletLanguage.OutletID =RouteCustomer.OutletID INNER JOIN
                                                Route ON RouteCustomer.RouteID =Route.RouteID
                                                inner join Territory on Territory.TerritoryID = Route.TerritoryID
                                                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = Territory.TerritoryID  AND EmployeeTerritory.EmployeeID  {4}                                                    
                                                {3}
                                                WHERE (CustomerOutletLanguage.LanguageID = {0}) and Territory.OrganizationID in ({1})  ",
                                                     _requestRepository.LanguageId, //0
                                                    _requestRepository.CurrentOperator.OrganizationAccess, //1
                                                    orgFilter,//2
                                                    outletsFilter, //3
                                                    _employeeManager.GetSupervisorAccess() //4
                                                   );
                if (filter.MasterTerritoryId != -1)
                {
                    Query += string.Format(" AND (Territory.MasterTerritoryID = {0}) ", filter.MasterTerritoryId);
                }
                if (!filter.AllTerritories)
                {
                    Query += string.Format(" AND (Route.TerritoryID = {0}) ", filter.TerritoryId);
                }
                Query += " AND CustomerOutlet.GPSLatitude <> 0 AND CustomerOutlet.GPSLongitude <> 0";
                Query += FillCustomerFilter(filter);
                result = dBHelper.GetQueryList(Query, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEmployeeCustomersMappingList(CustomerMappingFilter filter, ref List<CustomerOutletModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customersList = new List<CustomerOutletModel>();
            DBHelper<CustomerOutletModel> dBHelper = null;
            StringBuilder orgFilter = new StringBuilder();
            string employeefilter = string.Empty;
            string creditLimitSelection = string.Empty;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgFilter.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (filter.SalespersonId != -1)
                {
                    employeefilter = string.Format(" and EmployeeTerritory.EmployeeID = {0} ", filter.SalespersonId);
                }
                if (filter.SupervisorId != -1)
                {
                    employeefilter += string.Format(" and EmployeeSupervisor.SupervisorID = {0} ", filter.SupervisorId);
                }
                if (filter.SalesManagerId != -1)
                {
                    employeefilter += string.Format(" and SupervisorSalesMngr.SalesManagerID = {0} ", filter.SalesManagerId);
                }
                string outletsFilter = GetCOSAndDisplayUnitFilter(filter);
                string Query = string.Format(@"SELECT distinct 
                                                 IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                                 IsNull( CustomerOutletLanguage.Description , '--') as OutletName,
                                                CustomerOutlet.GPSLatitude,
                                                CustomerOutlet.GPSLongitude,
                                                CustomerOutletLanguage.CustomerID ,
                                                RouteCustomer.OutletID ,
                                                case when CustomerOutletImage.Photo is null then 0 else 1 end hasImage
                                                FROM CustomerOutlet 
                                                Inner Join Customer On Customer.CustomerID = CustomerOutlet.CustomerID 
                                                left outer join CustomerOutletImage on CustomerOutletImage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletImage.OutletID = CustomerOutlet.OutletID
                                                {2}
                                                {4}
                                                LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {0}
                                                INNER JOIN RouteCustomer ON CustomerOutletLanguage.CustomerID = RouteCustomer.CustomerID AND CustomerOutletLanguage.OutletID = RouteCustomer.OutletID
                                                INNER JOIN Route ON RouteCustomer.RouteID = Route.RouteID
                                                INNER JOIN Territory on Territory.TerritoryID = Route.TerritoryID
                                                INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = Territory.TerritoryID
                                                INNER JOIN EmployeeSupervisor ON EmployeeSupervisor.EmployeeID = EmployeeTerritory.EmployeeID
                                                INNER JOIN SupervisorSalesMngr ON SupervisorSalesMngr.SupervisorID = EmployeeSupervisor.SupervisorID
                                                WHERE Territory.OrganizationID in ({1}) AND CustomerOutlet.GPSLatitude <> 0 AND CustomerOutlet.GPSLongitude <> 0 {3}",
                                                _requestRepository.LanguageId,
                                                _requestRepository.CurrentOperator.OrganizationAccess,
                                                orgFilter,
                                                employeefilter,
                                                outletsFilter);
                Query += FillCustomerFilter(filter);
                result = dBHelper.GetQueryList(Query, ref customersList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRouteHistoryDetailsForCustomerOutlet(CustomerMappingFilter filter, ref List<RouteHistoryDetailsModel> customerOutletRouteDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            customerOutletRouteDetails = new List<RouteHistoryDetailsModel>();
            DBHelper<RouteHistoryDetailsModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<RouteHistoryDetailsModel>();
                string Query = string.Format(@"SELECT DISTINCT                                                 
                    RouteHistory.RouteID
                    ,RouteHistoryDetail.ActualStart,RouteHistoryDetail.ActualEnd  
                    ,CustomerOutlet.CustomerID,RouteHistoryDetail.OutletID
                    From RouteHistoryDetail 
                    Inner Join Customer On Customer.CustomerID = RouteHistoryDetail.CustomerID 
                    inner join CustomerOutlet on CustomerOutlet.CustomerID=RouteHistoryDetail.CustomerID  and CustomerOutlet.OutletID=RouteHistoryDetail.OutletID
                    INNER JOIN RouteHistory ON RouteHistoryDetail.routeHistoryID = RouteHistory.routeHistoryID
                    inner join Territory on Territory.TerritoryID = RouteHistory.TerritoryID                                            
                    WHERE
                    Territory.OrganizationID in ({0}) 
                    AND (RouteHistory.RouteDate >=   {1} ) 
                    and (RouteHistory.RouteDate <   {2} )
                    AND((RouteHistoryDetail.GPSLatitude <>0 AND RouteHistoryDetail.GPSLongitude <>0)
                    or(CustomerOutlet.GPSLatitude <>0 AND CustomerOutlet.GPSLongitude <>0))
                    and Customer.CustomerID = {3} and  CustomerOutlet.OutletID = {4}",
                    _requestRepository.CurrentOperator.OrganizationAccess, //0
                    LocalUtilities.ParseDateToSQLString(filter.RouteDateModel.Date), //1
                    LocalUtilities.ParseDateToSQLString(filter.RouteDateModel.Date.AddDays(1)), //2
                    filter.CustomerId, //3
                    filter.OutletId //4
                    );
                if (filter.RouteHistoryId != -1 && !filter.AllRoutes)
                    Query += string.Format(@" and RouteHistory.routeHistoryID={0}", filter.RouteHistoryId);
                result = dBHelper.GetQueryList(Query, ref customerOutletRouteDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        private string FillCustomerFilter(CustomerMappingFilter filter)
        {
            try
            {
                string customerFilter = string.Empty;
                if (filter.IsClassification)
                {
                    if (filter.CustomerClassId != -1)
                    {
                        customerFilter = string.Format(" AND CustomerOutlet.CustomerClassID = {0}", filter.CustomerClassId);
                    }
                    if (filter.CustomerSubClassId != -1)
                    {
                        customerFilter += string.Format(" AND Customeroutlet.CustomerSubClassID = {0}", filter.CustomerSubClassId);
                    }

                    bool CheckDirectNonSalesCustomers = (filter.IsDirectSales && !filter.IsNonDirectSales) || (!filter.IsDirectSales && filter.IsNonDirectSales);
                    int CustomerTypesId = !filter.AllCustomerTypes && filter.CustomerTypeId > 0 ? filter.CustomerTypeId : -1;

                    if (CheckDirectNonSalesCustomers) customerFilter += string.Format(" AND Customer.IsDirectSales = {0} ", filter.IsDirectSales ? 1 : 0);
                    if (CustomerTypesId != -1) customerFilter += string.Format(" AND CustomerOutlet.CustomerTypeID = {0} ", CustomerTypesId);
                    if (filter.OnHoldOutlets) customerFilter += " AND CustomerOutlet.OnHold = 1 ";
                }
                return customerFilter;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        private string GetCOSAndDisplayUnitFilter(CustomerMappingFilter filter)
        {
            string COSAndDisplayUnitFilter = string.Empty;
            try
            {
                if (filter.OutletsWithCOS)
                {
                    string plan = string.Empty;
                    if (_requestRepository.Configurations.ManageContractedFOCPlan)
                    {
                        plan = string.Format(@" INNER JOIN ContractedFOCPlanDetails details on details.ContractID = ContractedFOC.ContractID
                                                INNER JOIN ContractedFOCPlan on ContractedFOCPlan.ContractedFOCPlanID = details.ContractedFOCPlanID and ContractedFOCPlan.PlanStatusID = {0}
                                                ", PlanStatus.Approved.GetHashCode());
                    }
                    COSAndDisplayUnitFilter = string.Format(@" INNER JOIN (
                                    SELECT CustomerID, OutletID from ContractedFOC
                                    {0}
                                    WHERE ContractedFOC.ValidTo >= {1} ) CFOC on CustomerOutlet.CustomerID = CFOC.CustomerID and CustomerOutlet.OutletID = CFOC.OutletID  "
                                        , plan
                                        , LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                }
                if (filter.IsOutletWithDisplayUnit)
                {
                    string displayUnitFilter = string.Empty;
                    if (filter.DisplayUnitMasterGroupId != -1)
                    {
                        displayUnitFilter = string.Format(" AND POS.POSMasterGroupID = {0}", filter.DisplayUnitMasterGroupId);
                    }
                    if (filter.DisplayUnitTypeId != -1)
                    {
                        displayUnitFilter += string.Format(" AND POS.POSTypeID = {0}", filter.DisplayUnitTypeId);
                    }
                    COSAndDisplayUnitFilter += string.Format(@" 
                                            INNER JOIN (
                                            SELECT Outlets.CustomerID, Outlets.OutletID FROM POSCustomerOutlet Outlets
                                            INNER JOIN POS ON POS.POSID = Outlets.POSID
                                            WHERE 1=1  {0} ) CPOS on CustomerOutlet.CustomerID = CPOS.CustomerID and CustomerOutlet.OutletID = CPOS.OutletID  "
                                                , displayUnitFilter);

                }
                return COSAndDisplayUnitFilter;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }

        public GlobalErrors GetMappingCustomersData(CustomerMappingFilter filter, ref CustomerOutletModel customerOutlet)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerOutletModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CustomerOutletModel>();
                string query = string.Format(@"SELECT Customer.CustomerCode, CustomerOutlet.CustomerCode OutletCode
                                            ,CustomerOutletlanguage.DESCRIPTION OutletName
                                            ,Account.CreditLimit, SubChannelLanguage.Description SubChannelName ,customerlanguage.DESCRIPTION CustomerName
                                             FROM Customer 
                                            INNER JOIN CustomerOutlet on Customer.CustomerID=CustomerOutlet.CustomerID
                                            LEFT JOIN CustomerOutletlanguage ON CustomerOutlet.CustomerID  =CustomerOutletlanguage.CustomerID
                                            AND CustomerOutlet.OutletID= CustomerOutletlanguage.OutletID
                                            AND CustomerOutletlanguage.LANGUAGEID= {0}
                                            LEFT JOIN CustomerOutletGroup ON CustomerOutlet.CustomerID = CustomerOutletGroup.CustomerID AND 
                                            CustomerOutlet.OutletID = CustomerOutletGroup.OutletID 
                                            left outer join customerlanguage on customerlanguage.CustomerID  =  Customer.CustomerID and customerlanguage.LANGUAGEID= {0}
                                            LEFT JOIN CustomerGroup ON CustomerOutletGroup.GroupID = CustomerGroup.GroupID 
                                            LEFT JOIN SubChannel ON CustomerGroup.SubChannelID = SubChannel.SubChannelID 
                                            LEFT JOIN AccountCustOut ON CustomerOutlet.CustomerID = AccountCustOut.CustomerID AND 
                                            CustomerOutlet.OutletID = AccountCustOut.OutletID 
                                            LEFT JOIN Account ON AccountCustOut.AccountID = Account.AccountID
                                            LEFT JOIN SubChannelLanguage ON SubChannel.SubChannelID = SubChannelLanguage.SubChannelID
                                            where 
                                            CustomerOutlet.CustomerID={1} and CustomerOutlet.OutletID={2}",
                                            _requestRepository.LanguageId,
                                            filter.CustomerId,
                                            filter.OutletId
                                            );
                result = dBHelper.GetQuerySingle(query, ref customerOutlet);

                if (result == GlobalErrors.Success && filter.IsRouteHistory)
                {
                    List<RouteHistoryDetailsModel> custOutRouteHistoryDetails = new List<RouteHistoryDetailsModel>();
                    result = GetRouteHistoryDetailsForCustomerOutlet(filter, ref custOutRouteHistoryDetails);
                    if (result == GlobalErrors.Success && custOutRouteHistoryDetails != null && custOutRouteHistoryDetails.Count > 0)
                    {
                        customerOutlet.RouteHistoryDetailsList = custOutRouteHistoryDetails;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region NewCustomer 
        public GlobalErrors GetNewCustomerList(GeneralFilter filter, ref SharedTableResult<CustomerOutletModel> newCustomerListSharedTable)
        {
            newCustomerListSharedTable = new SharedTableResult<CustomerOutletModel>();
            List<CustomerOutletModel> newCustomerList = new List<CustomerOutletModel>();
            DBHelper<CustomerOutletModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerOutletModel>();
                string searchFilter = string.Empty;
                string echoCustomer = string.Empty;
                string orderByFilter = string.Empty;
                string organizationSelection = string.Empty;
                string supervisorSelection = string.Empty;

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        (CustomerLanguage.Description  LIKE '%{0}%')
                        OR (Customer.CustomerCode LIKE '%{0}%')
                        OR (CustomerOutlet.Phone LIKE '%{0}%')
                        OR (OutletLanguage.Description LIKE '%{0}%')
                        OR (CustomerLanguage.Address LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += string.Format(" And (Customer.CreatedBy = {0})", filter.EmployeeId);
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (Customer.CustomerID = {0}) ", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (CustomerOutlet.OutletID = {0}) ", filter.OutletId);
                    }
                    if (filter.FromToDate != null && filter.FromToDate.Count == 2)
                    {
                        searchFilter += string.Format(" And Customer.CreatedDate <= {1} and Customer.CreatedDate >= {0} ", LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date), LocalUtilities.ParseEndDateToSQLString(filter.FromToDate[1].Date));
                    }
                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " and (Customer.Inactive = 0 OR Customer.Inactive is null)";
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By Customer.CreatedDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                StringBuilder orgFilter = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgFilter.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);
                    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        organizationSelection = string.Format(@", CustomerOutlet.OrganizationID");
                    }
                    else
                    {
                        organizationSelection = string.Format(@", Account.OrganizationID");
                    }
                }
                string supervisionJoin = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode())
                {
                    supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on CustomerOutlet.CustomerID = CustOutTerritory.CustomerID and CustomerOutlet.OutletID = CustOutTerritory.OutletID
                    INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId {0} 
                    Inner join TerritoryLanguage on TerritoryLanguage.TerritoryID = CustOutTerritory.TerritoryID and TerritoryLanguage.LanguageID = {1} ",
                    _employeeManager.GetSupervisorAccess(), _requestRepository.LanguageId);

                    supervisorSelection = string.Format(@",TerritoryLanguage.Description territoryDesc ,CustOutTerritory.TerritoryID");
                }
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    echoCustomer = string.Format(@"INNER JOIN CustOutExtraInfo ON CustomerOutlet.CustomerID = CustOutExtraInfo.CustomerID AND CustomerOutlet.OutletID = CustOutExtraInfo.OutletID AND CustOutExtraInfo.CreationSourceId = {0} ", CustomerCreationSource.Echo.GetHashCode());
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on CustomerOutlet.CustomerID = CustOutTerritory.CustomerID and CustomerOutlet.OutletID = CustOutTerritory.OutletID
                    INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId {0}",
                    _employeeManager.GetSupervisorAccess());
                }

                string mainQuery = string.Format(@"
                FROM Customer
                INNER JOIN CustomerOutlet ON CustomerOutlet.CustomerID = Customer.CustomerID
				INNER JOIN Employee ON Employee.EmployeeID = Customer.CreatedBy
                LEFT OUTER JOIN CustomerLanguage ON CustomerLanguage.CustomerID = Customer.CustomerID AND CustomerLanguage.LanguageID =  {0}
				LEFT OUTER JOIN (select CustomerID , OutletID,  STRING_AGG (GroupID, ',') groupIds from CustomerOutletGroup group by CustomerID , OutletID )  CG on CG.CustomerID = CustomerOutlet.CustomerID and CG.OutletID = CustomerOutlet.OutletID
                LEFT OUTER JOIN CustomerOutletLanguage OutletLanguage ON OutletLanguage.CustomerID = Customer.CustomerID AND OutletLanguage.OutletID = CustomerOutlet.OutletID AND OutletLanguage.LanguageID =  {0}
                LEFT OUTER JOIN EmployeeLanguage ON EmployeeLanguage.EmployeeID = Customer.CreatedBy And EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN CustomerStatus ON Customer.CustomerID = CustomerStatus.CustomerID 
                {1}
                {4}
                {5}
                WHERE  (Customer.New = 1 OR CustomerStatus.NewCustomerStatusID = {3}) {2}  and Customer.CustomerID <> {6} ", _requestRepository.LanguageId, orgFilter, searchFilter, NewCustomerStatus.New.GetHashCode(), echoCustomer, supervisionJoin, LocalUtilities.GestCustomerId);



                string selectionQuery = string.Format(@"Select ROW_NUMBER() Over(Order By Customer.CustomerID ) AS RowSeq,
                CustomerOutlet.CustomerID,
                CustomerOutlet.OutletID,
                Customer.CreatedBy,
                CustomerLanguage.Description CustomerName,
                IsNull(Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
                IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( OutletLanguage.Description , '--') as OutletCodeName,
                CustomerOutlet.Phone,
				CustomerOutlet.CustomerCode,
                OutletLanguage.Address,
                CustomerOutlet.GPSLongitude Longitude,
                CustomerOutlet.GPSLatitude Latitude,
                Customer.CreatedDate,
                CustomerOutlet.TradeLicenceNumber,
                CustomerOutlet.TradeLicenceName,
                Customer.NewCustomerTemplateID,
				CustomerOutlet.CustomerClassID,
				CG.groupIds
                {4} {5}
                {0} {1} 
                OFFSET  {2} ROWS       
                FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize, //3
                organizationSelection, //4
                supervisorSelection // 5
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) {0}",
                mainQuery);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success)
                {
                    newCustomerListSharedTable.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        newCustomerListSharedTable.TotalItems = Int32.Parse(objField.ToString().Trim());
                        result = dbHelper.GetQueryList(selectionQuery, ref newCustomerList , true);
                    }
                    newCustomerListSharedTable.Data = newCustomerList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                newCustomerList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SetNewCustomerAsCustomer(CustomerOutletModel newOutletObj)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<int> dbHelper = null;
            string errorMessage = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"Update Customer Set New = 0, UpdatedBy = {1},UpdatedDate = {2} WHERE CustomerID = {0}", newOutletObj.CustomerId, _requestRepository.CurrentOperator.EmployeeId
                    , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM CustomerStatus WHERE CustomerID = {0}", newOutletObj.CustomerId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                        result = _paymentManager.PostCustomerPayments(_requestRepository.CurrentOperator.EmployeeId, "", newOutletObj.CustomerId, newOutletObj.OutletId, false, dbHelper, ref errorMessage);
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetMaxVistitNumber(int customerId, int outletId, ref int maxVisitNo, ref int routeHistroyId)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                DataTable dt = new DataTable();

                string query = string.Format(@"SELECT MAX(VisitNo) MaxVisitNo, RouteHistoryID from RouteHistoryDetail 
                                               WHERE CustomerID = {0} and OutletID = {1}
                                               GROUP BY RouteHistoryID order by RouteHistoryID desc ", customerId, outletId);
                result = dbHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    routeHistroyId = int.Parse(dt.Rows[0]["RouteHistoryID"].ToString());
                    maxVisitNo = int.Parse(dt.Rows[0]["MaxVisitNo"].ToString()) + 1;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        private GlobalErrors UpdateCustomerTransactionAccount(string transactionID, long customerID, int outletID, int divisionID, int accountID, int visitNo, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@" UPDATE [Transaction] SET AccountID = {0}, UpdatedBy = {1},UpdatedDate = {2},VisitNo = {7} WHERE TransactionID= '{3}' AND  CustomerID = {4} AND  OutletID  = {5} AND DivisionID = {6}"
                , accountID, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), transactionID, customerID, outletID, divisionID, visitNo);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors UpdateCustomerPaymentsAccount(string transactionID, long customerID, int outletID, int divisionID, int accountID, int visitNo, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {

                string query = string.Format(@" UPDATE CustomerPayment SET AccountID = {0}, UpdatedBy = {5}, UpdatedDate = {6},VisitNo = {7}   WHERE TransactionID= '{1}' AND  CustomerID = {2} AND  OutletID  = {3} AND DivisionID = {4}",
                accountID, transactionID, customerID, outletID, divisionID, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                visitNo);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors MatchNewCustomerWithExistingOne(CustomerOutletModel newOutlet)
        {
            DataTable dt = new DataTable();
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                List<TransactionModel> transactionList = new List<TransactionModel>();
                CustomerOutletModel existOutlet = new CustomerOutletModel();
                int maxVisitNo = -1;
                int routeHistoryId = -1;
                bool OffRouteVisit = false;
                existOutlet.CustomerId = newOutlet.MatchCustomerId;
                existOutlet.OutletId = newOutlet.MatchOutletId;
                if (_requestRepository.Configurations.MatchNewGPSInformation)
                {
                    existOutlet.GPSLatitude = newOutlet.Latitude;
                    existOutlet.GPSLongitude = newOutlet.Longitude;
                }
                result = GetCustomerAccountInfo(ref newOutlet);
                if (result == GlobalErrors.Success)
                {
                    result = GetCustomerAccountInfo(ref existOutlet);
                    if (result == GlobalErrors.Success)
                    {
                        result = GetNewCustomerTransaction(newOutlet.CustomerId, newOutlet.OutletId, ref transactionList);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = GetMaxVistitNumber(existOutlet.CustomerId, existOutlet.OutletId, ref maxVisitNo, ref routeHistoryId);
                        if (result == GlobalErrors.Success)
                        {
                            dBHelper = new DBHelper<int>();
                            dBHelper.BeginTransaction();
                            if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                            {
                                foreach (AccountModel newCustomerDivAccount in newOutlet.AccountsList)
                                {
                                    AccountModel existCustDivAccount = null;
                                    if (existOutlet.AccountsList != null)
                                        existCustDivAccount = existOutlet.AccountsList.Find(account => account.DivisionId == newCustomerDivAccount.DivisionId);
                                    if (existCustDivAccount != null)
                                    {
                                        result = _accountManager.UpdateAccountBalance(existCustDivAccount.AccountId, newCustomerDivAccount.Balance, dBHelper, 5);
                                        if (result == GlobalErrors.Success)
                                        {
                                            foreach (TransactionModel transaction in transactionList)
                                            {
                                                result = UpdateCustomerTransactionAccount(transaction.TransactionId, newOutlet.CustomerId, newOutlet.OutletId, transaction.DivisionId, existCustDivAccount.AccountId, maxVisitNo, dBHelper);
                                                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                                                {
                                                    result = UpdateCustomerPaymentsAccount(transaction.TransactionId, newOutlet.CustomerId, newOutlet.OutletId, transaction.DivisionId, existCustDivAccount.AccountId, maxVisitNo, dBHelper);
                                                }

                                                if (!(result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                                                {
                                                    result = GlobalErrors.Error;
                                                    break;
                                                }
                                                maxVisitNo++;
                                            }
                                        }
                                    }
                                }
                            }
                            else
                            {
                                result = _accountManager.UpdateAccountBalance(existOutlet.Account.AccountId, newOutlet.Account.Balance, dBHelper, 5);
                                if (result == GlobalErrors.Success)
                                {
                                    if (transactionList != null && transactionList.Count > 0)
                                    {
                                        foreach (TransactionModel transaction in transactionList)
                                        {
                                            result = UpdateCustomerTransactionAccount(transaction.TransactionId, newOutlet.CustomerId, newOutlet.OutletId, transaction.DivisionId, existOutlet.Account.AccountId, maxVisitNo, dBHelper);
                                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                                            {
                                                result = UpdateCustomerPaymentsAccount(transaction.TransactionId, newOutlet.CustomerId, newOutlet.OutletId, transaction.DivisionId, existOutlet.Account.AccountId, maxVisitNo, dBHelper);
                                            }

                                            if (!(result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                                            {
                                                result = GlobalErrors.Error;
                                                break;
                                            }
                                            maxVisitNo++;
                                        }
                                    }
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = DeleteAllCustomerAccounts(newOutlet.CustomerId, dBHelper);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = UpdateNewCustomerRelatedData(existOutlet, newOutlet, maxVisitNo, routeHistoryId, OffRouteVisit, dBHelper);
                                if (result == GlobalErrors.Success && newOutlet.TemplateImages != null && newOutlet.TemplateImages.Count > 0)
                                {
                                    result = MoveCustomerTempAttachmentFoldersToDestinationFolder(existOutlet, newOutlet);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    result = DeleteNewCustomerRelatedData(newOutlet, dBHelper);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    result = SaveCustomerMatchingHistory(newOutlet.CustomerId, existOutlet.CustomerId, existOutlet.OutletId, dBHelper);
                                }
                            }

                        }
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                        dBHelper.CommitTransaction();
                    else
                        dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        private GlobalErrors SaveCustomerMatchingHistory(int newCustomerID, int matchedCustomerID, int matchedOutletID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string sqlQuery = string.Format(@" insert into CustomerMatchingHistory (NewCustomerID,ExistingCustomerID,ExistingOutletID,MatchedBy,MatchedDate,MachineName)
                values ({0},{1},{2},{3},{4},'{5}')",
                newCustomerID,
                matchedCustomerID,
                matchedOutletID,
                _requestRepository.CurrentOperator.EmployeeId,
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                System.Environment.MachineName.ToString());
                result = dBHelper.ExecuteNonQuery(sqlQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors DeleteNewCustomerRelatedData(CustomerOutletModel newAddedOutlet, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string customerOuteltFilter = string.Format(" CustomerID = {0} AND OutletID= {1}", newAddedOutlet.CustomerId, newAddedOutlet.OutletId);
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.RouteCustomer, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustOutTerritory, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutletLanguage, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutletDivision, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerPromotion, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerPrice, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerStatus, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutlet, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                customerOuteltFilter = string.Format(" CustomerID = {0} ", newAddedOutlet.CustomerId);
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerLanguage, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.Customer, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutletContact, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutletAccess, customerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustOutExtraInfo, customerOuteltFilter, dBHelper);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors UpdateNewCustomerRelatedData(CustomerOutletModel existingOutlet, CustomerOutletModel newAddedOutlet, int visitNo, int routehistoryId, bool OffRouteVisit, DBHelper<int> dBHelper)
        {
            GlobalErrors result;
            try
            {
                string newCustomerOuteltFilter = string.Format(" CustomerID = {0} AND OutletID= {1}", newAddedOutlet.CustomerId, newAddedOutlet.OutletId);
                string existingCustomerOuteltData = string.Format(" CustomerID = {0} ,  OutletID= {1}", existingOutlet.CustomerId, existingOutlet.OutletId);
                string newGPSInformation = string.Empty;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.Transaction, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.TransactionDetail, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerPayment, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.WarehouseStockHistoryArc, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.SalesOrder, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.SalesOrderDetail, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.SalesOrderNote, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.Contact, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerUnallocatedPayment, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.WarehouseStockHistory, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.POSCustomerOutlet, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.POSCustomerOutletCapacity, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.SDPreviousVisit, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.ICashHistory, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.ICashTransactionDetails, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateCustomerICashBalance(newAddedOutlet, existingOutlet, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.AccumulativePromotionsHistory, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.PromotionBenefitHistory, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerPromotionsAccumulation, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                if (_requestRepository.Configurations.MatchNewGPSInformation)
                {
                    newGPSInformation = string.Format(" GPSLongitude = {0} ,  GPSLatitude= {1}", existingOutlet.GPSLongitude, existingOutlet.GPSLatitude);

                    result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerOutlet, newGPSInformation, string.Format(" CustomerID = {0} and  OutletID= {1}", existingOutlet.CustomerId, existingOutlet.OutletId), dBHelper);
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;
                }

                if (visitNo > 0)
                {
                    string filter = string.Format(" CustomerID = {0} And OutletID = {1} AND RouteHistoryID = {2}", existingOutlet.CustomerId, existingOutlet.OutletId, routehistoryId);
                    result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.RouteHistoryDetail, filter, dBHelper);
                }
                List<RouteHistoryDetailsModel> newCustomerVisits = new List<RouteHistoryDetailsModel>();
                result = GetNewCustomerVisits(newAddedOutlet.CustomerId, newAddedOutlet.OutletId, routehistoryId, ref newCustomerVisits, dBHelper);
                if (newCustomerVisits != null)
                {
                    string newCustomerData, existsCustomerData;
                    foreach (RouteHistoryDetailsModel details in newCustomerVisits)
                    {
                        newCustomerData = string.Format(" CustomerID = {0} AND OutletID= {1} AND VisitNo = {2}", newAddedOutlet.CustomerId, newAddedOutlet.OutletId, details.VisitNo);
                        existsCustomerData = string.Format(" CustomerID = {0} ,  OutletID= {1},VisitNo = {2},OffRouteVisit = {3}", existingOutlet.CustomerId, existingOutlet.OutletId, visitNo + 1, Convert.ToInt32(details.OffRouteVisit));
                        result = UpdateDataTable(CoreDataBaseConstants.TableNames.RouteHistoryDetail, existsCustomerData, newCustomerData, dBHelper);
                        if (result != GlobalErrors.Success) break;
                        visitNo++;
                    }
                }
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                string routeNewCustomerFilter = string.Format(" NewCustomerID = {0} AND RouteHistoryID= {1}", newAddedOutlet.CustomerId, routehistoryId);
                string matchCustomerID = string.Format(" MatchedCustomerID = {0}", newAddedOutlet.MatchCustomerId);
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.RouteNewCustomer, matchCustomerID, routeNewCustomerFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                newCustomerOuteltFilter = string.Format(" UsedForCustomerID = {0} AND UsedForOutletID= {1}", newAddedOutlet.CustomerId, newAddedOutlet.OutletId);
                existingCustomerOuteltData = string.Format(" UsedForCustomerID = {0} ,  UsedForOutletID= {1}", existingOutlet.CustomerId, existingOutlet.OutletId);
                result = UpdateDataTable(CoreDataBaseConstants.TableNames.EmployeeKeyHistory, existingCustomerOuteltData, newCustomerOuteltFilter, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateCustomerGroup(newAddedOutlet, existingOutlet, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;
                result = UpdateCustomerOperator(newAddedOutlet, existingOutlet, dBHelper);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;

            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

            }
            return result;
        }
        private GlobalErrors UpdateCustomerICashBalance(CustomerOutletModel newAddedOutlet, CustomerOutletModel existingOutlet, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"
                IF EXISTS(Select * From ICashBalance Where CustomerID = {existingOutlet.CustomerId} And OutletID = {existingOutlet.OutletId})
                BEGIN
                    Update ICashBalance Set Balance = ICashBalance.Balance + NewBalance.Balance From ICashBalance
                    Inner Join ICashBalance NewBalance on NewBalance.CustomerID = {newAddedOutlet.CustomerId} And NewBalance.OutletID = {newAddedOutlet.OutletId}
                    Where ICashBalance.CustomerID = {existingOutlet.CustomerId} And ICashBalance.OutletID = {existingOutlet.OutletId}
                    Delete From ICashBalance Where CustomerID = {newAddedOutlet.CustomerId} And OutletID = {newAddedOutlet.OutletId}
                END
                ELSE
                BEGIN
                    Update ICashBalance set CustomerID = {existingOutlet.CustomerId} , OutletID = {existingOutlet.OutletId} where CustomerID = {newAddedOutlet.CustomerId} and OutletID = {newAddedOutlet.OutletId}
                END";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;

        }
        private GlobalErrors UpdateCustomerOperator(CustomerOutletModel newAddedOutlet, CustomerOutletModel existingOutlet, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(" DELETE FROM Operator WHERE OperatorID IN (SELECT  OperatorID FROM CustomerOutletAccess WHERE CustomerID={0} and OutletID={1}) ", existingOutlet.CustomerId, existingOutlet.OutletId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(" DELETE FROM CustomerOutletAccess WHERE CustomerID={0} and OutletID={1} ", existingOutlet.CustomerId, existingOutlet.OutletId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerOutletAccess
                            , string.Format(" CustomerID={0} , OutletID={1} ", existingOutlet.CustomerId, existingOutlet.OutletId)
                            , string.Format(" CustomerID={0} and OutletID={1} ", newAddedOutlet.CustomerId, newAddedOutlet.OutletId), dBHelper);
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors UpdateCustomerGroup(CustomerOutletModel newAddedOutlet, CustomerOutletModel existingOutlet, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                DataTable dt = new DataTable();
                string existingFilter = string.Format(" CustomerID={0} And OutletID={1}", existingOutlet.CustomerId, existingOutlet.OutletId);
                string newFilter = string.Format(" CustomerID={0} And OutletID={1}", newAddedOutlet.CustomerId, newAddedOutlet.OutletId);
                string query = string.Format("   select GroupID from CustomerOutletGroup where customerid={0} and OutletID={1} ", newAddedOutlet.CustomerId, newAddedOutlet.OutletId);
                result = dBHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        result = DeleteDataFromTable(CoreDataBaseConstants.TableNames.CustomerOutletGroup, existingFilter + string.Format(" And GroupID = {0}", dt.Rows[i][0].ToString()), dBHelper);
                        if (result != GlobalErrors.Success) break;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = UpdateDataTable(CoreDataBaseConstants.TableNames.CustomerOutletGroup, string.Format(" CustomerID={0} , OutletID={1} ", existingOutlet.CustomerId, existingOutlet.OutletId), newFilter, dBHelper);
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors UpdateDataTable(string tableName, string newData, string filter, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized; ;
            try
            {
                string query = string.Format(" UPDATE {0} SET {1} Where {2}", tableName, newData, filter);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors DeleteDataFromTable(string tableName, string filter, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(" DELETE FROM {0}  Where {1}", tableName, filter);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors GetNewCustomerVisits(long CustomerID, int outletID, int RouteHistoryID, ref List<RouteHistoryDetailsModel> details, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<RouteHistoryDetailsModel> dBHelperRouteHistory;
                if (dBHelper != null)
                {
                    dBHelperRouteHistory = new DBHelper<RouteHistoryDetailsModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelperRouteHistory = new DBHelper<RouteHistoryDetailsModel>();
                }
                string query = string.Format(@"SELECT RouteHistoryID,CustomerID,OutletID,VisitNo,ActualStart,ActualEnd,VisitStatusID From RouteHistoryDetail
                Where  RouteHistoryID = {0} AND CustomerID = {1} AND OutletID = {2}", RouteHistoryID, CustomerID, outletID);
                result = dBHelperRouteHistory.GetQueryList(query, ref details);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors GetCustomerAccountInfo(ref CustomerOutletModel outlet)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<AccountModel> dBHelper = new DBHelper<AccountModel>();
                AccountModel outletAccount = new AccountModel();
                string query = string.Format(@" Select * from Account
                        inner join AccountCustOut on AccountCustOut.AccountID = Account.AccountID and AccountCustOut.CustomerID = {0} And AccountCustOut.OutletID = {1}",
                outlet.CustomerId,
                outlet.OutletId);
                result = dBHelper.GetQuerySingle(query, ref outletAccount);
                if (result != GlobalErrors.Success)
                {
                    return GlobalErrors.Error;
                }
                if (outletAccount != null && outletAccount.AccountId != -1)
                {
                    outlet.Account = outletAccount;
                    outlet.AccountsList = new List<AccountModel>();
                    if (!_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                    {
                        outlet.AccountsList.Add(outlet.Account);
                    }
                    else
                    {
                        List<AccountModel> accountsListOnDivisionsLevel = new List<AccountModel>();

                        query = string.Format(@" Select distinct Account.*, 
                                IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName 
                                from Account
                                inner join AccountCustOutDiv on AccountCustOutDiv.AccountID = Account.AccountID and AccountCustOutDiv.CustomerID = {0} And AccountCustOutDiv.OutletID = {1}
                                inner join Division on Division.DivisionID = AccountCustOutDiv.DivisionID                            
                                Left Outer join Divisionlanguage on  Division.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {2}",
                        outlet.CustomerId,
                        outlet.OutletId,
                        _requestRepository.LanguageId);

                        result = dBHelper.GetQueryList(query, ref accountsListOnDivisionsLevel);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        if (result == GlobalErrors.Success && accountsListOnDivisionsLevel != null && accountsListOnDivisionsLevel.Count > 0)
                        {
                            outlet.AccountsList = accountsListOnDivisionsLevel;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors GetNewCustomerTransaction(int customerId, int outletId, ref List<TransactionModel> transactions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                transactions = new List<TransactionModel>();
                DBHelper<TransactionModel> dBHelper = new DBHelper<TransactionModel>();
                string query = string.Format(@"select * from [Transaction] where CustomerID = {0} and OutletID = {1}", customerId, outletId);
                result = dBHelper.GetQueryList(query, ref transactions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllEchoCustomers(ref SharedTableResult<EchoCustomersModel> allEchoCustomers)
        {
            allEchoCustomers = new SharedTableResult<EchoCustomersModel>();
            DBHelper<EchoCustomersModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<EchoCustomersModel> allEchoCustomersList = new List<EchoCustomersModel>();
            try
            {
                dbHelper = new DBHelper<EchoCustomersModel>();

                string query = string.Format(@"SELECT distinct CO.CustomerID, CO.OutletID, IsNull(Customer.CustomerCode,'---') as CustomerCode, IsNull(CO.CustomerCode,'---') as OutletCode, 
                IsNull(CustomerLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( COL.Description , '--') as CustomerOutletName,
                IsNull(CONVERT(nvarchar(100),Customer.CustomerID) , '--') + ' ' + '-'+ ' ' + IsNull(CONVERT(nvarchar(100), CO.OutletID) , '--') as CustomerOutletIds 
                FROM CustomerDeviceToken
                INNER JOIN Customer ON Customer.CustomerID = CustomerDeviceToken.CustomerID
                LEFT OUTER JOIN CustomerLanguage on CustomerLanguage.CustomerID = CustomerDeviceToken.CustomerID 
                AND LanguageID = {0}
                INNER JOIN CustomerOutlet CO on CO.CustomerID = CustomerDeviceToken.CustomerID 
                AND CO.OutletID = CustomerDeviceToken.OutletID
                LEFT OUTER JOIN CustomerOutletLanguage COL on COL.CustomerID = CO.CustomerID 
                AND COL.OutletID = CO.OutletID AND COL.LanguageID = {0}
                INNER JOIN AccountCustOut ACO on ACO.CustomerID = CO.CustomerID AND ACO.OutletID = CO.OutletID
                INNER JOIN Account AC on AC.AccountID = ACO.AccountID And AC.OrganizationID in ({1})                                 
                INNER JOIN CustomerOutletAccess COA on COA.CustomerID = CO.CustomerID AND COA.OutletID = CO.OutletID
                INNER JOIN Operator on Operator.OperatorID = COA.OperatorID 
                AND (Operator.IsLocked = 0 OR Operator.IsLocked is null)
                Where Customer.CustomerID <> {2}
                ORDER BY  CO.CustomerID", _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess, LocalUtilities.GestCustomerId);

                result = dbHelper.GetQueryList(query, ref allEchoCustomersList);
                if (result == GlobalErrors.Success
                    && allEchoCustomersList != null)
                {
                    allEchoCustomers.TotalItems = allEchoCustomersList.Count;
                    allEchoCustomers.Data = allEchoCustomersList;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allEchoCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllEchoCustomerChannels(ref List<CustomerChannelModel> customerChannelObj)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string sqlString = string.Format(@"SELECT (CONVERT(varchar(10),Channel.ChannelID) + '-' + CONVERT(varchar(10),SubChannel.SubChannelID)) ChannelSubChannelIds , (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                FROM Channel
                INNER JOIN SubChannel on Channel.ChannelID = SubChannel.ChannelID
                INNER JOIN CustomerGroup on CustomerGroup.ChannelID = Channel.ChannelID AND CustomerGroup.SubChannelID = SubChannel.SubChannelID
                INNER JOIN CustomerOutletGroup on CustomerGroup.GroupID = CustomerOutletGroup.GroupID
                INNER JOIN CustomerDeviceToken on CustomerDeviceToken.CustomerID = CustomerOutletGroup.CustomerID 
                AND CustomerDeviceToken.OutletID = CustomerOutletGroup.OutletID
                INNER JOIN CustomerOutlet CO on CustomerDeviceToken.CustomerID = CO.CustomerID 
                AND CustomerDeviceToken.OutletID = CO.OutletID
                INNER JOIN AccountCustOut ACO on ACO.CustomerID =  CO.CustomerID AND ACO.OutletID = CO.OutletID
                INNER JOIN Account AC on AC.AccountID = ACO.AccountID AND AC.OrganizationID in ({1})
                LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = Channel.ChannelID and ChannelLanguage.LanguageID = {0}
                LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = SubChannel.SubChannelID and SubChannelLanguage.LanguageID = {0}",
                _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(sqlString, ref customerChannelObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerChannelObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAllEchoCustomerGroups(ref List<CustomerGroupModel> customerGroupObj)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerGroupModel>();
                string sqlString = string.Format(@"select distinct CustomerGroup.*,CustomerGroupLanguage.Description GroupName,
                IsNull( CustomerGroup.GroupCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerGroupLanguage.Description , '--') as GroupCodeName  
                from CustomerGroup
                left Outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID 
                and CustomerGroupLanguage.LanguageID = {0}
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CustomerGroup.GroupID
                INNER JOIN CustomerDeviceToken CDT on CDT.CustomerID = COG.CustomerID 
                AND CDT.OutletID = COG.OutletID
                INNER JOIN CustomerOutlet CO on CDT.CustomerID = CO.CustomerID AND CDT.OutletID = CO.OutletID
                INNER JOIN AccountCustOut ACO on ACO.CustomerID =  CO.CustomerID AND ACO.OutletID = CO.OutletID
                INNER JOIN Account AC on AC.AccountID = ACO.AccountID AND AC.OrganizationID in ({1})
                --where CustomerGroup.OrganizationID in ({1})
                ", _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(sqlString, ref customerGroupObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerGroupObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveCustomerNotifications(ref NotificaitonsModel CustomerNotifications)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                if (CustomerNotifications != null)
                {
                    dbHelper.BeginTransaction();

                    if (CustomerNotifications.NotificationId <= 0)
                    {
                        CustomerNotifications.NotificationId = GetMaxID(CoreDataBaseConstants.TableNames.EchoNotifications, CoreDataBaseConstants.QueryColumnsNames.NotificationId, dbHelper);
                        if (CustomerNotifications.NotificationId <= 0)
                        {
                            return GlobalErrors.Error;
                        }
                    }
                    int customerId = -1, outletId = -1, groupId = -1, channelId = -1, subChannelId = -1;
                    if (CustomerNotifications.VideoName != null)
                        CustomerNotifications.TypeId = CustomerAppNotificationTypes.Video.GetHashCode();
                    else if (CustomerNotifications.ImageName != null)
                        CustomerNotifications.TypeId = CustomerAppNotificationTypes.Image.GetHashCode();
                    else if (CustomerNotifications.promotionNotification == true)
                        CustomerNotifications.TypeId = CustomerAppNotificationTypes.promotion.GetHashCode();
                    else
                        CustomerNotifications.TypeId = CustomerAppNotificationTypes.Text.GetHashCode();


                    if (CustomerNotifications.Customers != null && CustomerNotifications.Customers.Count > 0)
                    {
                        customerId = -1;
                        outletId = -1;
                        channelId = -1;
                        subChannelId = -1;
                        groupId = -1;
                        foreach (EchoCustomers customerOutlet in CustomerNotifications.Customers)
                        {
                            customerId = int.Parse(customerOutlet.CustomerOutletIds.Split('-')[0]);
                            outletId = int.Parse(customerOutlet.CustomerOutletIds.Split('-')[1]);

                            if (customerId <= 0 || outletId <= 0)
                            {
                                return GlobalErrors.Error;
                            }
                            query = string.Format(@"INSERT INTO EchoNotifications 
                                (EmployeeID, CustomerID, OutletID, CreatedDate, Title, Body, ChannelID, SubChannelID, GroupID, VideoName, ImageName, TypeID, ArabicTitle, ArabicBody)
                                VALUES ({1},{2},{3},{4},'{5}','{6}',{7},{8},{9},'{10}','{11}', {12}, '{13}', '{14}')",
                                CustomerNotifications.NotificationId,
                                _requestRepository.CurrentOperator.EmployeeId,
                                customerId,
                                outletId,
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                CustomerNotifications.Subject.Replace("'", "''"),
                                CustomerNotifications.Body.Replace("'", "''"),
                                channelId,
                                subChannelId,
                                groupId,
                                CustomerNotifications.VideoName != null ? CustomerNotifications.VideoName.Replace("'", "''") : "NULL",
                                CustomerNotifications.ImageName != null ? CustomerNotifications.ImageName.Replace("'", "''") : "NULL",
                                CustomerNotifications.TypeId,
                                CustomerNotifications.ArabicSubject != null ? CustomerNotifications.ArabicSubject.Replace("'", "''") : "NULL",
                                CustomerNotifications.ArabicBody != null ? CustomerNotifications.ArabicBody.Replace("'", "''") : "NULL");
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                    }
                    if (CustomerNotifications.Groups != null && CustomerNotifications.Groups.Count > 0)
                    {
                        customerId = -1;
                        outletId = -1;
                        channelId = -1;
                        subChannelId = -1;
                        groupId = -1;
                        foreach (EchoGroups groups in CustomerNotifications.Groups)
                        {
                            groupId = groups.GroupId;

                            if (groupId <= 0)
                            {
                                return GlobalErrors.Error;
                            }
                            query = string.Format(@"INSERT INTO EchoNotifications 
                                (EmployeeID, CustomerID, OutletID, CreatedDate, Title, Body, ChannelID, SubChannelID, GroupID, VideoName, ImageName, TypeID, ArabicTitle, ArabicBody)
                                VALUES ({1},{2},{3},{4},'{5}','{6}',{7},{8},{9},'{10}','{11}',{12}, '{13}', '{14}')",
                                CustomerNotifications.NotificationId,
                                _requestRepository.CurrentOperator.EmployeeId,
                                customerId,
                                outletId,
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                CustomerNotifications.Subject.Replace("'", "''"),
                                CustomerNotifications.Body.Replace("'", "''"),
                                channelId,
                                subChannelId,
                                groupId,
                                CustomerNotifications.VideoName != null ? CustomerNotifications.VideoName.Replace("'", "''") : "NULL",
                                CustomerNotifications.ImageName != null ? CustomerNotifications.ImageName.Replace("'", "''") : "NULL",
                                CustomerNotifications.TypeId,
                                CustomerNotifications.ArabicSubject.Replace("'", "''"),
                                CustomerNotifications.ArabicBody.Replace("'", "''"));
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                    }
                    if (CustomerNotifications.Channels != null && CustomerNotifications.Channels.Count > 0)
                    {
                        customerId = -1;
                        outletId = -1;
                        channelId = -1;
                        subChannelId = -1;
                        groupId = -1;
                        foreach (EchoChannels channels in CustomerNotifications.Channels)
                        {
                            channelId = int.Parse(channels.ChannelSubChannelIds.Split('-')[0]);
                            subChannelId = int.Parse(channels.ChannelSubChannelIds.Split('-')[1]);

                            if (channelId <= 0 || subChannelId <= 0)
                            {
                                return GlobalErrors.Error;
                            }
                            query = string.Format(@"INSERT INTO EchoNotifications 
                                (EmployeeID, CustomerID, OutletID, CreatedDate, Title, Body, ChannelID, SubChannelID, GroupID, VideoName, ImageName,TypeID, ArabicTitle, ArabicBody)
                                VALUES ({1},{2},{3},{4},'{5}','{6}',{7},{8},{9},'{10}','{11}',{12}, '{13}', '{14}')",
                                CustomerNotifications.NotificationId,
                                _requestRepository.CurrentOperator.EmployeeId,
                                customerId,
                                outletId,
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                CustomerNotifications.Subject.Replace("'", "''"),
                                CustomerNotifications.Body.Replace("'", "''"),
                                channelId,
                                subChannelId,
                                groupId,
                                CustomerNotifications.VideoName != null ? CustomerNotifications.VideoName.Replace("'", "''") : "NULL",
                                CustomerNotifications.ImageName != null ? CustomerNotifications.ImageName.Replace("'", "''") : "NULL",
                                CustomerNotifications.TypeId,
                                CustomerNotifications.ArabicSubject.Replace("'", "''"),
                                CustomerNotifications.ArabicBody.Replace("'", "''"));
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            return result;
        }

        #endregion
        #region APIs

        public bool CheckIfValueIsUsed(DBHelper<int> dbHelper, string tableName, string columnName, string value, string extraFilter)
        {
            bool used = false;
            string query = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = new object();
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                query = string.Format(@"Select count(*) from {0} where {1} = '{2}' {3}",
                    tableName, columnName,
                    columnName.Equals(CoreDataBaseConstants.QueryColumnsNames.Phone)
                    || columnName.Equals(CoreDataBaseConstants.QueryColumnsNames.Number) ? value.TrimStart('0') : value,
                    extraFilter);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null
                    && !string.IsNullOrEmpty(field.ToString())
                    && int.Parse(field.ToString()) > 0)
                {
                    used = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return used;
        }

        public GlobalErrors InsertCustomerFromAPI(CustomersModel CustomerDetails, ref bool isEmailUsed, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            if (dbHelper == null)
                dbHelper = new DBHelper<int>();
            dbHelper.BeginTransaction();
            try
            {
                string CustomerCode = string.Empty, Address1 = string.Empty, Address2 = string.Empty;
                int EmployeeId = -1, RouteId = -1;
                int CustomerID = GetMaxID(CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.CustomerID);
                int OutletID = 1;
                if (CustomerID == -1)
                    return GlobalErrors.Error;

                if (_requestRepository.LoginData != null)
                {
                    EmployeeId = int.Parse(_requestRepository.LoginData.UserId);
                    if (EmployeeId < 0)
                    {
                        return GlobalErrors.Error;
                    }
                }
                if (CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.Email, CustomerDetails.Email, string.Empty))
                {
                    isEmailUsed = true;
                    return GlobalErrors.DataAlreadyExists;
                }
                CustomerDetails.SiteCode = _documentSequenceManager.GetMaxDocumentSequence(EmployeeId, DocumentTypes.NewCustomerCode, -1);

                //Customer
                string Query = string.Empty;
                Query = string.Format(@"INSERT INTO Customer (CustomerId ,Phone, Email, CustomerCode, New , CreatedBy, CreatedDate) 
                Values ({0}, {1}, '{2}', '{3}', {4}, {5}, {6})",
                CustomerID,
                "NULL",
                CustomerDetails.Email,
                CustomerDetails.SiteCode,
                1,
                EmployeeId,//Check
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(Query);

                //CustomerLanguage
                if (result == GlobalErrors.Success)
                {
                    for (int i = 1; i <= 2; i++)
                    {
                        Query = string.Format(@"INSERT INTO CustomerLanguage (CustomerId , LanguageId , Description) 
                        Values ({0}, {1}, '{2}')", CustomerID, i, CustomerDetails.Name.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(Query);

                        if (result != GlobalErrors.Success)
                            return GlobalErrors.Error;
                    }
                }

                //CustomerOutlet
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"INSERT INTO CustomerOutlet 
                    (CustomerId, OutletId, CustomerCode, Phone, Email, Taxeable, CreatedBy, CreatedDate, InActive, OnHold, PaymentTermID, CustomerTypeID, PoBox) 
                    Values ({0},{1},'{2}',{3},'{4}',{5},{6},{7},{8},{9},{10},{11},'{12}')",
                    CustomerID,
                    OutletID,
                    CustomerDetails.SiteCode,
                    "NULL",
                    CustomerDetails.Email,
                    1,
                    EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    0,
                    0,
                    0,
                    1,
                    CustomerDetails.PostCode);

                    result = dbHelper.ExecuteNonQuery(Query);
                }

                if (result == GlobalErrors.Success)
                {
                    int ContactsCount = 0;
                    foreach (CustomersModel.CustomerContacts contacts in CustomerDetails.Numbers)
                    {
                        if (result == GlobalErrors.Success)
                        {
                            if (contacts.Is_Default)
                            {
                                if (CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Phone, contacts.Number, string.Empty))
                                {
                                    return GlobalErrors.DataAlreadyExists;
                                }
                                Query = string.Format(@" Update CustomerOutlet set Phone = {0} where CustomerID = {1} AND OutletID = {2} ",
                                        contacts.Number, CustomerID, OutletID);
                                result = dbHelper.ExecuteNonQuery(Query);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                if (CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.CustomerOutletContact, CoreDataBaseConstants.QueryColumnsNames.Number, contacts.Number, string.Empty))
                                {
                                    return GlobalErrors.DataAlreadyExists;
                                }
                                ContactsCount += 1;
                                Query = string.Format(@"Insert into CustomerOutletContact VALUES ({0},{1},{2},{3},1,{4})",
                                                        CustomerID, OutletID, ContactsCount, contacts.CountryId, contacts.Number);
                                result = dbHelper.ExecuteNonQuery(Query);
                            }

                        }
                        else
                        {
                            break;
                        }
                    }
                }

                //CustomerOutletLanguage
                if (result == GlobalErrors.Success)
                {
                    foreach (CustomersModel.AddressModel address in CustomerDetails.Addresses)
                    {
                        if (address.Is_Default && string.IsNullOrEmpty(Address2))
                        {
                            Address1 = address.Address;
                        }
                        else
                        {
                            Address2 = address.Address;
                        }
                    }
                    for (int i = 1; i <= 2; i++)
                    {
                        Query = string.Format(@"INSERT INTO CustomerOutletLanguage (CustomerId , OutletId , LanguageId , Description , Address, Address2) 
                        Values ({0}, {1}, {2}, '{3}', '{4}', '{5}')",
                        CustomerID,
                        OutletID,
                        i,
                        CustomerDetails.Name.Replace("'", "''"),
                        Address1,
                        Address2);
                        result = dbHelper.ExecuteNonQuery(Query);

                        if (result != GlobalErrors.Success)
                        {
                            return GlobalErrors.Error;
                        }
                    }

                }

                //CustOutExtraInfo
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"INSERT INTO CustOutExtraInfo (CustomerId , OutletId , AreaId , Gender , DateOfBirth , CreationSourceId ) 
                    Values ({0}, {1}, {2}, {3}, {4}, {5})",
                    CustomerID,
                    OutletID,
                    CustomerDetails.LandmarkId,
                    -1,
                    LocalUtilities.ParseDateToSQLString(DateTime.Parse(CustomerDetails.Dob)),
                    CustomerCreationSource.App.GetHashCode());//Check

                    result = dbHelper.ExecuteNonQuery(Query);
                }

                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"EXEC sp_InsertCustomerOutletArea @CustomerId = {0}, @OutletId = {1}, @AreaId = {2}",
                    CustomerID,
                    OutletID,
                    CustomerDetails.LandmarkId);

                    result = dbHelper.ExecuteNonQuery(Query);
                }

                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, DocumentTypes.NewCustomerCode, CustomerDetails.SiteCode, EmployeeId, -1);
                }

                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"INSERT into ICashBalance (CustomerID, OutletID, AccountNumber, Balance, CreatedDate, CreatedBy) 
                            VALUES ({0}, {1}, '{2}', {3}, {4}, {5})",
                           CustomerID,
                           OutletID,
                           Guid.NewGuid().ToString("N").Substring(0, 16),
                           0,
                           LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                           EmployeeId);

                    result = dbHelper.ExecuteNonQuery(Query);
                }

                int AccountID = -1;
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format("Select ISNULL(Max(AccountID),0) from Account");
                    result = dbHelper.GetQuerySingle(Query, ref AccountID);
                }

                //Account
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"INSERT INTO Account (AccountID , AccountTypeID , CreditLimit , Balance  , OrganizationID , CurrencyID) 
                    Values ({0}, {1}, {2}, {3}, {4}, {5})",
                    AccountID + 1,
                    1,
                    0,
                    0,
                    1,
                    1);//Check if this values will always be 0 and 1s

                    result = dbHelper.ExecuteNonQuery(Query);
                }

                //AccountCust
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format("INSERT INTO AccountCust (CustomerID,AccountID) Values ({0}, {1})",
                    CustomerID,
                    AccountID + 1);

                    result = dbHelper.ExecuteNonQuery(Query);
                }


                // AccountCustOut
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format("INSERT INTO AccountCustOut (CustomerID, OutletID ,AccountID) Values ({0}, {1}, {2})",
                    CustomerID,
                    OutletID,
                    AccountID + 1);

                    result = dbHelper.ExecuteNonQuery(Query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetIDsByCustomerCode(string CustomerCode, ref int CustomerId, ref int OutletId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            int Id = -1;
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                string Query = string.Format(@"Select CustomerID, OutletID from CustomerOutlet where CustomerCode = '{0}'", CustomerCode);
                result = dbHelper.GetQueryDataTable(Query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    CustomerId = int.Parse(dt.Rows[0][0].ToString());
                    OutletId = int.Parse(dt.Rows[0][1].ToString());
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateCustomerDetailsFromAPI(CustomersModel CustomerDetails, ref bool isEmailUsed)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int CustomerId = -1, OutletId = -1, EmployeeId = -1, RouteId = -1;
            string Address1 = string.Empty, Address2 = string.Empty;
            DBHelper<int> dbHelper = null;
            object field = null;
            bool IsAvailable = false;
            try
            {
                if (_requestRepository.LoginData != null)
                {
                    EmployeeId = int.Parse(_requestRepository.LoginData.UserId);
                    if (EmployeeId < 0)
                    {
                        return GlobalErrors.Error;
                    }
                }
                result = GetIDsByCustomerCode(CustomerDetails.SiteCode.Trim(), ref CustomerId, ref OutletId);
                dbHelper = new DBHelper<int>();

                if (result == GlobalErrors.Success && CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.Customer, CoreDataBaseConstants.QueryColumnsNames.Email, CustomerDetails.Email, string.Format("AND CustomerID <> {0} ", CustomerId)))
                {
                    isEmailUsed = true;
                    return GlobalErrors.DataAlreadyExists;
                }

                if (result == GlobalErrors.Success && CustomerId > -1 && OutletId > -1)
                {
                    dbHelper.BeginTransaction();
                    foreach (CustomersModel.AddressModel address in CustomerDetails.Addresses)
                    {
                        if (address.Is_Default || CustomerDetails.Addresses.Count == 1)
                        {
                            Address1 = address.Address;
                        }
                        else
                        {
                            Address2 = address.Address;
                        }
                    }
                    string Query = string.Format(@"Update CustomerOutletLanguage set Description='{2}', Address = '{3}', Address2 = '{4}'
                    where CustomerID = {0} AND OutletID = {1}", CustomerId, OutletId, CustomerDetails.Name, Address1, Address2);
                    result = dbHelper.ExecuteNonQuery(Query);
                    if (result == GlobalErrors.Success)
                    {
                        Query = string.Format(@"Select * from CustOutExtraInfo where CustomerID = {0} AND OutletID = {1}", CustomerId, OutletId);
                        result = dbHelper.ExecuteScalar(Query, ref field);
                        if (result == GlobalErrors.Success)
                        {
                            if (field == null)
                            {
                                Query = string.Format(@"INSERT INTO CustOutExtraInfo 
                                (CustomerId, OutletId, AreaId, Gender, DateOfBirth, CreationSourceId, SourceId, NationalityId, IdentificationNumber) 
                                VALUES ({0}, {1}, null, null, {3}, {4}, null, null, null)",
                                CustomerId,
                                OutletId,
                                CustomerDetails.LandmarkId,
                                LocalUtilities.ParseDateToSQLString(DateTime.Parse(CustomerDetails.Dob)),
                                CreationSource.SonicAPI.GetHashCode());
                            }
                            else
                            {
                                Query = string.Format(@"Update CustOutExtraInfo set DateOfBirth = {2},AreaId = {3}
                                where CustomerID = {0} AND OutletID = {1}",
                                CustomerId,
                                OutletId,
                                LocalUtilities.ParseDateToSQLString(DateTime.Parse(CustomerDetails.Dob)),
                                CustomerDetails.LandmarkId);
                            }
                            result = dbHelper.ExecuteNonQuery(Query);
                        }
                    }

                    if (result == GlobalErrors.Success)
                    {
                        Query = string.Format(@" Update CustomerOutlet set Email = '{0}', Fax = '{1}', PoBox = '{2}', UpdatedBy = {3}, UpdatedDate = {4}
                                                 where CustomerID = {5} AND OutletID = {6} ",
                                                 CustomerDetails.Email == null ? "Null" : CustomerDetails.Email.Replace("'", "''"),
                                                 CustomerDetails.Fax == null ? "Null" : CustomerDetails.Fax.Replace("'", "''"),
                                                 CustomerDetails.PostCode == null ? "Null" : CustomerDetails.PostCode.Replace("'", "''"),
                                                 EmployeeId,
                                                 LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                                 CustomerId, OutletId);
                        result = dbHelper.ExecuteNonQuery(Query);
                    }

                    if (result == GlobalErrors.Success)
                    {
                        Query = string.Format(@" Update Customer set Email = '{0}', Fax = '{1}', UpdatedBy = {2}, UpdatedDate = {3}
                                                 where CustomerID = {4}",
                                                 CustomerDetails.Email == null ? "Null" : CustomerDetails.Email.Replace("'", "''"),
                                                 CustomerDetails.Fax == null ? "Null" : CustomerDetails.Fax.Replace("'", "''"),
                                                 EmployeeId,
                                                 LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                                 CustomerId);
                        result = dbHelper.ExecuteNonQuery(Query);
                    }

                    if (result == GlobalErrors.Success)
                    {
                        int ContactsCount = 0;
                        bool isDeleted = false;
                        foreach (CustomersModel.CustomerContacts contacts in CustomerDetails.Numbers)
                        {
                            if (result == GlobalErrors.Success)
                            {
                                if (!isDeleted)
                                {
                                    Query = string.Format(@"Delete from CustomerOutletContact where CustomerID = {0} AND OutletID = {1}", CustomerId, OutletId);
                                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(Query);
                                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                    {
                                        result = GlobalErrors.Success;
                                    }
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    isDeleted = true;
                                    if (contacts.Is_Default)
                                    {
                                        if (CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.CustomerOutlet, CoreDataBaseConstants.QueryColumnsNames.Phone, contacts.Number, string.Format("AND CustomerID <> {0} AND OutletID <> {1}", CustomerId, OutletId)))
                                        {
                                            result = GlobalErrors.DataAlreadyExists;
                                        }
                                        if (result == GlobalErrors.Success)
                                        {
                                            Query = string.Format(@" Update CustomerOutlet set Phone = {0} where CustomerID = {1} AND OutletID = {2} ",
                                            contacts.Number, CustomerId, OutletId);
                                            result = dbHelper.ExecuteNonQuery(Query);
                                        }
                                    }
                                    if (result == GlobalErrors.Success)
                                    {
                                        if (CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.CustomerOutletContact, CoreDataBaseConstants.QueryColumnsNames.Number, contacts.Number, string.Format("AND CustomerID <> {0}", CustomerId)))
                                        {
                                            result = GlobalErrors.DataAlreadyExists;
                                        }
                                        if (result == GlobalErrors.Success)
                                        {
                                            ContactsCount += 1;
                                            Query = string.Format(@"Insert into CustomerOutletContact VALUES ({0},{1},{2},{3},1,{4})",
                                                                    CustomerId, OutletId, ContactsCount, contacts.CountryId, contacts.Number);
                                            result = dbHelper.ExecuteNonQuery(Query);
                                        }
                                    }
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                //result = dbHelper.ExecuteNonQuery(Query);
                            }
                            else
                            {
                                break;
                            }
                        }
                    }

                    if (result == GlobalErrors.Success)
                    {
                        Query = string.Format(@"EXEC sp_UpdateCustomerOutletArea @CustomerId = {0}, @OutletId = {1}, @AreaId = {2}",
                        CustomerId, OutletId, CustomerDetails.LandmarkId);
                        result = dbHelper.ExecuteNonQuery(Query);
                    }
                }
                else
                {
                    result = GlobalErrors.NoMoreRows;
                }
                return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
        }

        public GlobalErrors GetCustomerDetailsFromAPI(string SiteCode, ref CustomersModel CustomersDetailsList)
        {
            DBHelper<CustomersModel> dbHelper = null;
            CustomersDetailsList = new CustomersModel();
            DataTable dt = new DataTable();
            CustomersModel.AddressModel Addresses = new CustomersModel.AddressModel();
            List<CustomersModel.AddressModel> AddressesList = new List<CustomersModel.AddressModel>();
            List<CustomersModel.CustomerContacts> ContactsList = new List<CustomersModel.CustomerContacts>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            int CustomerId = -1, OutletId = -1;
            try
            {
                GetIDsByCustomerCode(SiteCode.Trim(), ref CustomerId, ref OutletId);
                dbHelper = new DBHelper<CustomersModel>();
                string Query = string.Format(@"select CO.CustomerCode as SiteCode, COL.Description as Name, COEI.DateOfBirth as dob, 
                CO.Email, CO.Fax, CO.PoBox as PostCode, ISNULL(COEI.AreaId, -1) as LandmarkId
                from CustomerOutlet CO
                LEFT OUTER JOIN CustomerOutletLanguage COL on COL.CustomerID = CO.CustomerID AND COL.OutletID = CO.OutletID 
                AND COL.LanguageID = {0}
                LEFT OUTER JOIN CustOutExtraInfo COEI on COEI.CustomerId = CO.CustomerID AND COEI.OutletId = CO.OutletID
                where CO.CustomerId = {1} AND CO.OutletId = {2}", _requestRepository.LanguageId, CustomerId, OutletId);
                result = dbHelper.GetQuerySingle(Query, ref CustomersDetailsList);
                // CustomersDetailsList.Dob = LocalUtilities.ParseDateToSQLString(LocalUtilities.ParseStringToDate(CustomersDetailsList.Dob));
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"select COL.Address, COL.Address2
                    from CustomerOutlet CO  
                    left outer join  CustomerOutletLanguage COL on COL.CustomerID = CO.CustomerID AND COL.OutletID = CO.OutletID 
                    AND COL.LanguageID = {0}
                    where CO.CustomerId = {1} AND CO.OutletId = {2}", _requestRepository.LanguageId, CustomerId, OutletId);
                    DBHelper<int> addressesDbHelper = new DBHelper<int>();
                    result = addressesDbHelper.GetQueryDataTable(Query, ref dt);
                    if (result == GlobalErrors.Success && dt.Rows != null && dt.Rows.Count > 0)
                    {
                        AddressesList = new List<CustomersModel.AddressModel>();
                        if (!string.IsNullOrEmpty(dt.Rows[0][0].ToString()))
                        {
                            Addresses = new CustomersModel.AddressModel();
                            Addresses.Address = dt.Rows[0][0].ToString();
                            Addresses.Is_Default = true;
                            AddressesList.Add(Addresses);
                        }
                        if (!string.IsNullOrEmpty(dt.Rows[0][1].ToString()))
                        {
                            Addresses = new CustomersModel.AddressModel();
                            Addresses.Address = dt.Rows[0][1].ToString();
                            Addresses.Is_Default = AddressesList.Count <= 0;
                            AddressesList.Add(Addresses);
                        }
                        CustomersDetailsList.Addresses = AddressesList;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"select distinct Phone as Number, 1 as Is_Default from CustomerOutlet
                                            where CustomerId = {0} AND OutletId = {1}
                                            UNION
                                            Select distinct Number, 0 as IsDefault from CustomerOutletContact
                                            where CustomerId = {0} AND OutletId = {1}
                                            AND Number NOT IN (select Phone from CustomerOutlet where CustomerId = {0} AND OutletId = {1})", CustomerId, OutletId);
                    DBHelper<CustomersModel.CustomerContacts> ContactsDbHelper = new DBHelper<CustomersModel.CustomerContacts>();
                    result = ContactsDbHelper.GetQueryList(Query, ref ContactsList);
                    if (result == GlobalErrors.Success)
                    {
                        CustomersDetailsList.Numbers = ContactsList;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                CustomersDetailsList = null;
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetCustomerOutletIds(string customercode, ref CustomerOutletModel outletObj)
        {
            DBHelper<CustomerOutletModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CustomerOutletModel>();
                string sqlString = string.Format(@"select customerid, outletid from CustomerOutlet where customerOutlet.CustomerCode = '{0}'", customercode);

                result = dbHelper.GetQuerySingle(sqlString, ref outletObj);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                outletObj = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }



        #endregion

        #region Customer Points Balances

        public GlobalErrors GetAllCustomersPoints(GeneralFilter filter, ref SharedTableResult<CustomerPointsBalanceModel> allCustomerPoints)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerPointsBalanceModel> dbHelper = null;
            List<CustomerPointsBalanceModel> customerPointsList = new List<CustomerPointsBalanceModel>();
            try
            {
                dbHelper = new DBHelper<CustomerPointsBalanceModel>();
                string searchFilter = string.Empty;
                string supervisionJoin = string.Empty;
                string orderByFilter = "Order By Customer.CustomerCode, CustomerOutlet.CustomerCode";
                StringBuilder orgAccessJoin = new StringBuilder();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID = Customer.CustomerID INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeId IN ({0})",
                   _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                }
                if (filter.CustomListFilter != null && filter.CustomListFilter.SearchFilter != null && !string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@" and (
				 (CustomerOutlet.CustomerCode LIKE '%{0}%') OR ( CustomerOutletLanguage.Description LIKE '%{0}%')
                    OR (Customer.CustomerCode LIKE '%{0}%') OR ( CustomerLanguage.Description LIKE '%{0}%')
					) ",
                    filter.CustomListFilter.SearchFilter.Trim());
                }
                if (filter.CustomListFilter != null && !string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By {0} {1} ",
                    filter.CustomListFilter.SortBy,
                    filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                string mainQuery = string.Format(@"select Distinct CustomerOutlet.OutletID , Customer.CustomerID, Customer.CustomerCode, CustomerOutlet.CustomerCode OutletCode ,CustomerOutletLanguage.Description as OutletName , IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                , isnull(CustomerAppPoints.PointsBalance,0) as PointsBalance
                from CustomerOutlet
                Inner join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID and CustomerOutletLanguage.LanguageID = {0}
                INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID                                    
                INNER JOIN CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}   
                Left JOIN CustomerAppPoints on CustomerAppPoints.CustomerID = CustomerOutlet.CustomerID and CustomerAppPoints.OutletID = CustomerOutlet.OutletID
                {1} {3}
                where 1=1 {2} and Customer.Inactive <> 1 and Customer.New <> 1 and CustomerOutlet.Inactive <> 1 and Customer.CustomerID <> {4}",
                _requestRepository.LanguageId, //0
                orgAccessJoin.ToString(), //1
                searchFilter, //2
                supervisionJoin,//3
                LocalUtilities.GestCustomerId//4
                );

                string customerQuery = string.Format(@" {0} {1} OFFSET  {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success)
                {
                    allCustomerPoints.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        allCustomerPoints.TotalItems = Int32.Parse(objField.ToString().Trim());
                        result = dbHelper.GetQueryList(customerQuery, ref customerPointsList , true);
                    }
                    allCustomerPoints.Data = customerPointsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customerPointsList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors UpdateCustomersPoints(CustomerPointsBalanceModel customerPointsObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerPointsBalanceModel> dbHelper = null;
            string sqlQuery = string.Empty;
            try
            {
                dbHelper = new DBHelper<CustomerPointsBalanceModel>();
                sqlQuery = string.Format(@"IF not EXISTS 
                            (SELECT * FROM CustomerAppPoints WHERE CustomerID ={0} and OutletID = {1})
                            Insert Into CustomerAppPoints (CustomerID,OutletID,PointsBalance,CreatedDate,CreatedBy,UpdatedDate,Updatedby) Values ({0},{1},{2},{3},{4},
                            {3},{4})
                            else Update CustomerAppPoints set PointsBalance = {2}, UpdatedDate ={3}, Updatedby = {4} WHERE CustomerID ={0} and OutletID = {1}",
                            customerPointsObj.CustomerId, // 0
                            customerPointsObj.OutletId, // 1
                            customerPointsObj.ActionId == CustomerPointsAction.Adjust.GetHashCode() ? LocalUtilities.GetRoundedDecimal(customerPointsObj.NewPointsBalance, _requestRepository.Configurations.NumberOfDigits) : LocalUtilities.GetRoundedDecimal((customerPointsObj.PointsBalance - customerPointsObj.NewPointsBalance), _requestRepository.Configurations.NumberOfDigits), //2
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //3
                            _requestRepository.CurrentOperator.EmployeeId //4
                            );
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"Insert Into CustomerAppPointsHistory (CustomerID,OutletID,TransactionID,ActionID,OldPointsBalance,NewPointsBalance,
                               UpdatedDate,Updatedby,Note) Values ({0},{1},'{2}',{3},{4},{5},{6},{7},'{8}')",
                               customerPointsObj.CustomerId, // 0
                               customerPointsObj.OutletId, // 1
                               customerPointsObj.TransactionId, //2
                               customerPointsObj.ActionId,//3
                               customerPointsObj.PointsBalance,//4
                               customerPointsObj.ActionId == CustomerPointsAction.Adjust.GetHashCode() ? LocalUtilities.GetRoundedDecimal(customerPointsObj.NewPointsBalance, _requestRepository.Configurations.NumberOfDigits) : LocalUtilities.GetRoundedDecimal((customerPointsObj.PointsBalance - customerPointsObj.NewPointsBalance), _requestRepository.Configurations.NumberOfDigits),//5
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //6
                               _requestRepository.CurrentOperator.EmployeeId, //7
                              customerPointsObj.Note.Replace("'", "''")//8
                              );
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        #endregion

        #region [ECHO]

        public GlobalErrors InsertNewOutletForEcho(CustomerOutletModel outlet, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlQuery = string.Format(@" INSERT INTO Customer 
                                (CustomerID,Phone,InActive,OnHold,New,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,CustomerCode,Email,CurrencyId) 
                                VALUES ({0},'{1}',{2},{3},{4},{5},{6},{7},{8},'{9}','{10}', {11})", outlet.CustomerId, outlet.Phone,
                                Convert.ToInt32(outlet.Inactive), 0, Convert.ToInt32(outlet.IsNewCustomer),
                                0, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), 0, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                outlet.CustomerCode, outlet.Email, outlet.CurrencyId);
                result = dbHelper.ExecuteNonQuery(sqlQuery);
                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@" INSERT INTO CustomerOutlet 
                            (CustomerID, OutletID, CustomerCode, Barcode, Phone, Email, Taxeable, CurrencyID, OnHold, Inactive, 
                            Notes, PaymentTermID, CustomerTypeID, CreatedBy, TradeLicenceNumber, BillsOpenNumber, CreatedDate, UpdatedDate, 
                            GPSLatitude,GPSLongitude,UpdatedBy,CountryId,StateId,CityId,AreaId,StreetId) 
                            VALUES ({0},{1},'{2}','{2}', {3}, {4}, 1, {5}, 0, 0, 'Created By Customer App User', -1, {6}, {7}, {8}, 0, {9}, {9}, {10}, {11}, {7},
                            {12},{13},{14},{15},{16})",
                            outlet.CustomerId,//0
                            outlet.OutletId,//1
                            outlet.CustomerCode.ToString().Replace("'", "''"),//2
                            string.IsNullOrEmpty(outlet.Phone) ? "Null" : "'" + outlet.Phone + "'",//3
                            string.IsNullOrEmpty(outlet.Email) ? "Null" : "'" + outlet.Email.Replace("'", "''") + "'",//4
                            outlet.CurrencyId,//5
                            outlet.CustomerTypeId,//6
                            0,//7
                            string.IsNullOrEmpty(outlet.TradeLicenceNumber) ? "Null" : "'" + outlet.TradeLicenceNumber.Replace("'", "''") + "'",//8
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//9
                            outlet.GPSLatitude,//10
                            outlet.GPSLongitude,//11
                            outlet.CountryId == "" ? "Null" : outlet.CountryId.ToString(),//12
                            outlet.StateId == "" ? "Null" : outlet.StateId.ToString(),//13
                            outlet.CityId == "" ? "Null" : outlet.CityId.ToString(),//14
                            outlet.AreaId == "" ? "Null" : outlet.AreaId.ToString(),//15
                            outlet.StreetId == "" ? "Null" : outlet.StreetId.ToString()//16
                            );
                    result = dbHelper.ExecuteNonQuery(sqlQuery);
                    if (outlet.Phone != null && !outlet.Phone.Equals("") && result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@"INSERT INTO CustomerOutletContact (CustomerID,OutletID,ContactId,CountryId,ContactTypeId,Number) Values({0},{1},{2},{3},{4},'{5}')", outlet.CustomerId, outlet.OutletId, "1", "-1", "1", outlet.Phone);
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                    //CustOutExtraInfo
                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@"INSERT INTO CustOutExtraInfo (CustomerId , OutletId , AreaId , Gender , DateOfBirth , CreationSourceId) Values ({0}, {1}, NULL, NULL, NULL, {2})",
                        outlet.CustomerId,//0
                        outlet.OutletId,//1
                        CustomerCreationSource.Echo.GetHashCode());

                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerSOA(ref List<SOATransactionModel> list)
        {
            return GetCustomerSOA(ref list, false);
        }
        public GlobalErrors GetCustomerSOA(ref List<SOATransactionModel> list, bool orderByDesc)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orderBy = orderByDesc ? " [Transaction].TransactionDate desc " : " ISNULL(DueDate , TransactionDate) asc";
                list = new List<SOATransactionModel>();
                DBHelper<SOATransactionModel> dbHelper = new DBHelper<SOATransactionModel>();
                string sqlQuery = string.Format(@" SELECT TransactionID,RemainingAmount,NetTotal , CustomerID, OutletID, 
                CONVERT(varchar(10), TransactionDate, 103) TransactionDate,
                CASE WHEN TransactionTypeID IN (1,3,6) THEN 1 ELSE 2 END as TypeId,
                CASE WHEN TransactionTypeID IN (1,3,6) THEN '{1}' ELSE '{2}' END as Type
                FROM [Transaction] 
                WHERE 
                concat(CustomerID, '-', OutletID) in ({0}) 
                AND 
                (RemainingAmount > 0 ) 
                AND (Voided <> 1 OR Voided IS NULL) 
                AND (TransactionTypeID IN (1,3,6,5)) And CreationReason <> 6    
                AND [Transaction].OrganizationID in ({3})
                ORDER BY {4}",
                _requestRepository.CurrentEchoOperator.CustomerOutletIds,//0
                Resources.ResourcesManager.TranslateKey(Resources.CaptionsConstants.Desc_Debit, _requestRepository.LanguageId),//1
                Resources.ResourcesManager.TranslateKey(Resources.CaptionsConstants.Desc_Credit, _requestRepository.LanguageId),//2
                _requestRepository.CurrentOperator.OrganizationId,//3
                orderBy // 4
                );
                result = dbHelper.GetQueryList(sqlQuery, ref list);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion  [ECHO]
        

        #region Customer Hierarchy

        public GlobalErrors DeleteCustomerGroup(string condition, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = $"delete CL from CustomerGroupLanguage  CL inner join CustomerGroup C on C.GroupID = CL.GroupID where {condition}";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = $"delete  from CustomerGroup where {condition.Substring(2)}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeletCustomersHierarchyData(CustomerHierarchyModel customerHierarchyData, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Empty;
                object objField = 0;


                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {

                    string condition = string.Empty;
                    switch (customerHierarchyData.CustomersHierarchyLevel)
                    {
                        case CustomersHierarchyLevel.Channel:
                            condition = $"ChannelID = {customerHierarchyData.ChannelId}";
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Channel_has_Group_From_Another_Org;
                            break;
                        case CustomersHierarchyLevel.SubChannel:
                            condition = $"SubChannelID = {customerHierarchyData.SubChannelId}";
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Sub_Channel_has_Group_From_Another_Org;
                            break;
                        case CustomersHierarchyLevel.Group:
                            condition = $"GroupID = {customerHierarchyData.GroupId}";
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Group_From_Another_Org;
                            break;
                    }
                    query = $"select isnull(Count(*),0) from CustomerGroup where {condition} and OrganizationID not in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                    result = dbHelper.ExecuteScalar(query, ref objField);
                    if (result != GlobalErrors.Success)
                    {
                        return result = GlobalErrors.Error;
                    }
                    else if (objField != null && int.Parse(objField.ToString()) > 0)
                    {
                        return result = GlobalErrors.Error;
                    }

                }



                string channelCondition = customerHierarchyData.CustomersHierarchyLevel == CustomersHierarchyLevel.Channel ? $" CG.ChannelID =  {customerHierarchyData.ChannelId}" : string.Empty;
                string subChannelCondition = customerHierarchyData.CustomersHierarchyLevel == CustomersHierarchyLevel.SubChannel ? $" CG.SubChannelID = {customerHierarchyData.SubChannelId}" : string.Empty;
                string groupCondition = customerHierarchyData.CustomersHierarchyLevel == CustomersHierarchyLevel.Group ? $" CG.GroupID  =  {customerHierarchyData.GroupId}" : string.Empty;

                query = $@"select count(tt.GroupID) from (
                           select GroupID GroupID  from CustomerOutletGroup where GroupID is not null union
                           select CustomerGroupID GroupID  from CollectionDiscAssignment where CustomerGroupID is not null union
                           select GroupID GroupID  from MessageCustomerGroup where GroupID is not null union
                           select GroupID GroupID  from EmployeeCustomerGroup where GroupID is not null union
                           select GroupID GroupID  from BlackListCustomerGroup where GroupID is not null union
                           select CustomerGroupID GroupID  from ItemBlackListCustomers where CustomerGroupID is not null union
                           select CustomerGroupID GroupID  from DiscountAssignment where CustomerGroupID is not null union
                           select CustomerGroupID GroupID  from AutoCreditNoteAssigment where CustomerGroupID is not null union
                           select GroupID GroupID  from CustomerHeaderDiscount where GroupID is not null union
                           select CustomerGroupID GroupID  from CustomerPromotion where CustomerGroupID is not null union
                           select GroupID GroupID  from OrderLimitAssignment where GroupID is not null union
                           select GroupID GroupID  from PromotionLimitAssignment where GroupID is not null union
                           select GroupID GroupID  from GroupCollectionDiscount where GroupID is not null union
                           select CustomerGroupID GroupID  from ItemsListAssignment where CustomerGroupID is not null union
                           select GroupID GroupID  from DropSizeAssignment where GroupID is not null union
                           select GroupID GroupID  from GroupPrice where GroupID is not null union
                           select GroupID GroupID  from SurveyGroup where GroupID is not null union
                           select CustomerGroupID GroupID  from CustomerIncentivePlan where CustomerGroupID is not null 
                           )tt
                           inner join CustomerGroup CG on CG.GroupID = tt.GroupID and  {channelCondition} {subChannelCondition} {groupCondition} ";
                result = dbHelper.ExecuteScalar(query, ref objField);

                if (result == GlobalErrors.Success && objField != null && int.Parse(objField.ToString()) > 0)
                {
                    switch (customerHierarchyData.CustomersHierarchyLevel)
                    {
                        case CustomersHierarchyLevel.Channel:
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Channel_has_Used_Group;
                            break;
                        case CustomersHierarchyLevel.SubChannel:
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Sub_Channel_has_Used_Group;
                            break;
                        case CustomersHierarchyLevel.Group:
                            errorMessage = MessagesConstants.Desc_Cannot_Delete_Used_Group;
                            break;

                    }

                    return result = GlobalErrors.Error;
                }

                dbHelper.BeginTransaction();
                switch (customerHierarchyData.CustomersHierarchyLevel)
                {
                    case CustomersHierarchyLevel.Channel:

                        result = DeleteCustomerGroup($"C.ChannelID =  {customerHierarchyData.ChannelId}", dbHelper);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            query = $"delete SL from SubChannelLanguage  SL inner join SubChannel S on S.SubChannelID = SL.SubChannelID where S.ChannelID =  {customerHierarchyData.ChannelId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                query = $"delete  from SubChannel where ChannelID = {customerHierarchyData.ChannelId}";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                        }

                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            query = $"delete from ChannelLanguage where ChannelID = {customerHierarchyData.ChannelId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                query = $"delete from Channel where ChannelID = {customerHierarchyData.ChannelId}";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                        }
                        break;
                    case CustomersHierarchyLevel.SubChannel:

                        result = DeleteCustomerGroup($"C.SubChannelID =  { customerHierarchyData.SubChannelId}", dbHelper);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            query = $"delete from SubChannelLanguage where SubChannelID = {customerHierarchyData.SubChannelId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                query = $"delete from SubChannel where SubChannelID =  {customerHierarchyData.SubChannelId}";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                        }
                        break;
                    case CustomersHierarchyLevel.Group:
                        result = DeleteCustomerGroup($"C.GroupID = {customerHierarchyData.GroupId}", dbHelper);
                        break;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveCustomersGroup(CustomersGroup customersGroup, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            bool commitNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    commitNow = true;
                }
                string query = string.Empty;
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    query = $"delete COG from CustomerOutletGroup COG inner join CustomerGroup CG on COG.GroupID = CG.GroupID and  COG.GroupID = {customersGroup.GroupId} and CG.OrganizationID in({_requestRepository.CurrentOperator.OrganizationAccess})";
                }
                else
                {
                    query = $"delete from CustomerOutletGroup where GroupID =  {customersGroup.GroupId}";
                }

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    if (customersGroup.Customers != null && customersGroup.Customers.Count > 0)
                    {
                        int start = 0;
                        int end = 0;
                        int i = 0;
                        if (customersGroup.Customers.Count > 1000)//   territory.CustomersList.Count > 1000)
                        {
                            end = 1000;
                        }
                        else
                        {
                            end = customersGroup.Customers.Count;
                        }
                        while (end <= customersGroup.Customers.Count)
                        {
                            StringBuilder values = new StringBuilder();
                            for (i = start; i < end; i++)
                            {
                                values.AppendFormat("( {0},{1},{2} ),",
                                customersGroup.Customers[i].CustomerId, //0
                                customersGroup.Customers[i].OutletId, //1
                                 customersGroup.GroupId//2
                                );
                            }
                            query = string.Format(@"Insert Into {0} (CustomerID, OutletID, GroupID) Values {1}",
                                                                  "CustomerOutletGroup", values.ToString().TrimEnd(','));
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                            start = i;
                            if (customersGroup.Customers.Count == end)
                            {
                                break;
                            }
                            if (customersGroup.Customers.Count - end > 1000)
                            {
                                end = end + 1000;
                            }
                            else
                            {
                                end = end + (customersGroup.Customers.Count - end);
                            }
                        }
                    }
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null && commitNow)
                {
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertUpdateChannel(bool isEditMode, int channelId, string channelCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("Channel", "ChannelCode", channelCode, $"And(ChannelID != {channelId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update Channel set ChannelCode = '{channelCode}' where ChannelID = {channelId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from ChannelLanguage where ChannelID = {channelId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into ChannelLanguage(ChannelID,LanguageID,Description)values({channelId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("Channel", "ChannelCode", channelCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxChannelId = GetMaxID("Channel", "ChannelID", dbHelper);
                        if (maxChannelId == -1) return GlobalErrors.Error;
                        query = $"insert into Channel(ChannelID,ChannelCode)values({maxChannelId},'{channelCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into ChannelLanguage(ChannelID,LanguageID,Description)values({maxChannelId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateSubChannel(bool isEditMode, int subChannelId, int channelId, string subChannelCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("SubChannel", "SubChannelCode", subChannelCode, $"And(SubChannelID != {subChannelId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update SubChannel set SubChannelCode = '{subChannelCode}',ChannelID = {channelId} where SubChannelID = {subChannelId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from SubChannelLanguage where SubChannelID = {subChannelId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into SubChannelLanguage(SubChannelID,LanguageID,Description)values({subChannelId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("SubChannel", "SubChannelCode", subChannelCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxSubChannelId = GetMaxID("SubChannel", "SubChannelID", dbHelper);
                        if (maxSubChannelId == -1) return GlobalErrors.Error;
                        query = $"insert into SubChannel(ChannelID,SubChannelID,SubChannelCode)values({channelId},{maxSubChannelId},'{subChannelCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into SubChannelLanguage(SubChannelID,LanguageID,Description)values({maxSubChannelId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateCustomerGroup(bool isEditMode, int subChannelId, int channelId, int groupId, int organizationId, string groupCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("CustomerGroup", "GroupCode", groupCode, $"And(GroupID != {groupId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update CustomerGroup set ChannelID = {channelId} ,SubChannelID = {subChannelId},OrganizationID = {organizationId},GroupCode = N'{groupCode}' where GroupID = {groupId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from CustomerGroupLanguage where GroupID = {groupId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into CustomerGroupLanguage(GroupID,LanguageID,Description)values({groupId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("CustomerGroup", "GroupCode", groupCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxGroupId = GetMaxID("CustomerGroup", "GroupID", dbHelper);
                        if (maxGroupId == -1) return GlobalErrors.Error;
                        query = $"insert into CustomerGroup(GroupID,GroupCode,ChannelID,SubChannelID,OrganizationID)values({maxGroupId},'{groupCode}',{channelId},{subChannelId},{organizationId})";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into CustomerGroupLanguage(GroupID,LanguageID,Description)values({maxGroupId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        /// <summary>
        /// delete customers when change organization from group
        /// </summary>
        /// <param name="groupId"></param>
        /// <param name="dBHelper"></param>
        /// <returns></returns>
        public GlobalErrors DeleteCustomerFromGroup(int groupId, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                string query = $"delete from CustomerOutletGroup where GroupID = {groupId} ";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors CheckCustomerGroupAchievementPromotions(string groupIds, ref List<Promotion> groupPromotions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<Promotion> dBHelper = new DBHelper<Promotion>();
                string query = $@"Select distinct CustomerPromotion.promotionID, PromotionLanguage.Description PromotionName, Promotion.PromotionLevel, promotion.StartDate, promotion.EndDate 
                from CustomerPromotion
                Inner Join Promotion on Promotion.PromotionID = CustomerPromotion.PromotionID
                Left Outer Join PromotionLanguage on PromotionLanguage.PromotionID = Promotion.PromotionID and PromotionLanguage.LanguageID = {_requestRepository.LanguageId}
                where (CustomerGroupID in ({groupIds}) OR SubchannelID in (select SubChannelID from CustomerGroup where GroupID in ({groupIds})))
                And Promotion.PromotionType in ({PromotionTypes.TargetPromotion.GetHashCode()},{PromotionTypes.SimpleTargetPromotion.GetHashCode()},{PromotionTypes.DynamicTargetPromotion.GetHashCode()}) 
                and Promotion.Inactive <> 1 
                and promotion.IsDeleted <> 1 
                and Promotion.EndDate >=  {LocalUtilities.ParseDateToSQLString(DateTime.Now)}";
                result = dBHelper.GetQueryList(query, ref groupPromotions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region [Must Sell Item]
        public GlobalErrors GetMustSellItemsList(GeneralFilter filter, ref SharedTableResult<MustSellItems> mustSellItemsList)
        {
            mustSellItemsList = new SharedTableResult<MustSellItems>();
            List<MustSellItems> newMustSellItemsList = new List<MustSellItems>();
            DBHelper<MustSellItems> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<MustSellItems>();
                string searchFilter = "1=1 ";
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@" and 
                        ((MustSellItemLanguage.Description  LIKE '%{0}%') 
                        OR (MustSellItemCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (MustSellItemAssignment.CustomerID = {0}) ", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (MustSellItemAssignment.OutletID = {0}) ", filter.OutletId);
                    }
                    if (filter.groupId != -1)
                    {
                        searchFilter += string.Format(" And (MustSellItemAssignment.GroupID = {0}) ", filter.groupId);
                    }
                    if (filter.MandatoryId != -1)
                    {
                        if (filter.MandatoryId == 1)
                        {
                            searchFilter += " And ISNULL (MustSellItem.Mandatory, 0) = 1 ";
                        }
                        else
                        {
                            searchFilter += " And ISNULL (MustSellItem.Mandatory, 0) = 0 ";
                        }
                    }
                    if (filter.FromDate != null)
                    {
                        searchFilter += string.Format(" AND MustSellItem.StartDate <= {0}  ",
                        LocalUtilities.ParseDateToSQLString(filter.FromDate.Date));
                    }
                    if (filter.ToDate != null)
                    {
                        searchFilter += string.Format(" AND MustSellItem.EndDate >= {0} ",
                        LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                    }
                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " And ISNULL (MustSellItem.Inactive, 0) = 0 ";
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By MustSellItem.MustSellItemID");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }


                string mainQuery = string.Format(@" select distinct 
                MustSellItem.MustSellItemID,IsNull( MustSellItemLanguage.Description, '--') MustSellItemName,MustSellItem.MustSellItemCode,MustSellItem.StartDate,MustSellItem.EndDate,
                MustSellItem.Inactive,MustSellItem.Mandatory,MustSellItem.ViewInSuggestedOrder,CASE WHEN MustSellItem.Mandatory = 1 THEN '{2}' ELSE '{3}' end IsMandatory,
                CASE WHEN MustSellItem.ViewInSuggestedOrder = 1 THEN '{2}' ELSE '{3}' end IsViewInSuggestedOrder
                from MustSellItem 
                left join MustSellItemLanguage on MustSellItem.MustSellItemID = MustSellItemLanguage.MustSellItemID and MustSellItemLanguage.LanguageID = {0}
                inner join MustSellItemOrganization on MustSellItem.MustSellItemID = MustSellItemOrganization.MustSellItemID
                inner join MustSellItemDetails on MustSellItem.MustSellItemID = MustSellItemDetails.MustSellItemID
                left join MustSellItemAssignment on MustSellItem.MustSellItemID = MustSellItemDetails.MustSellItemID
                left join MustSellItemEmployee on MustSellItem.MustSellItemID = MustSellItemEmployee.MustSellItemID
                left join MustSellItemsExcludedOutlet on MustSellItem.MustSellItemID = MustSellItemsExcludedOutlet.MustSellItemID
                where {1} and MustSellItemOrganization.OrganizationId in ({4}) ",
                _requestRepository.LanguageId,
                searchFilter,
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId),
                ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId),
                _requestRepository.CurrentOperator.OrganizationAccess
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})d",
                mainQuery);

                string selectionQuery = mainQuery + @$"{orderByFilter}
                OFFSET  {(filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize}
                ROWS
                FETCH NEXT {filter.CustomListFilter.PageSize}
                ROWS ONLY";
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success)
                {
                    mustSellItemsList.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        result = dbHelper.GetQueryList(selectionQuery, ref newMustSellItemsList , true);
                        mustSellItemsList.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                    mustSellItemsList.Data = newMustSellItemsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                newMustSellItemsList = null;
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertMustSellItem(MustSellItems mustSellItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                mustSellItems.MustSellItemId = GetMaxID("MustSellItem", "MustSellItemID", dbHelper);
                dbHelper.BeginTransaction();
                string query = string.Format(@"Insert into MustSellItem (MustSellItemID,MustSellItemCode,StartDate,EndDate,Inactive,Mandatory,ViewInSuggestedOrder)
                values({0},'{1}',{2},{3},{4},{5},{6})",
                mustSellItems.MustSellItemId, //0
                mustSellItems.MustSellItemCode.Replace("'", "''"), //1
                LocalUtilities.ParseDateToSQLString(mustSellItems.StartDate.Value),//2
                LocalUtilities.ParseDateToSQLString(mustSellItems.EndDate.Value),//3
                mustSellItems.Inactive ? "1" : "0", //4
                mustSellItems.Mandatory ? "1" : "0", //5
                mustSellItems.ViewInSuggestedOrder ? "1" : "0" //6
                );
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    foreach (TextLanguage language in mustSellItems.LanguageDescriptions)
                    {
                        query = string.Format(@"insert into MustSellItemLanguage (MustSellItemID,LanguageId,Description) values ({0},{1},'{2}')", mustSellItems.MustSellItemId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //Save Organizations

                    if (mustSellItems.OrganizationList != null && mustSellItems.OrganizationList.Count > 0)
                    {
                        foreach (OrganizationModel organization in mustSellItems.OrganizationList)
                        {
                            query = string.Format(@"insert into MustSellItemOrganization (MustSellItemID,OrganizationId) values ({0},{1})", mustSellItems.MustSellItemId, organization.OrganizationId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    // Save Details
                    if (mustSellItems.Items != null && mustSellItems.Items.Count > 0)
                    {
                        foreach (ItemPackModel item in mustSellItems.Items)
                        {
                            query = string.Format(@"insert into MustSellItemDetails (MustSellItemID,ItemGroupID,ItemID,QuantityLimit) values ({0},{1},{2},{3})", mustSellItems.MustSellItemId, -1, item.ItemId, mustSellItems.QuantityLimit);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.ItemGroups != null && mustSellItems.ItemGroups.Count > 0)
                    {
                        foreach (ItemGroupModel itemGroup in mustSellItems.ItemGroups)
                        {
                            query = string.Format(@"insert into MustSellItemDetails (MustSellItemID,ItemGroupID,ItemID,QuantityLimit) values ({0},{1},{2},{3})", mustSellItems.MustSellItemId, itemGroup.ItemGroupId, -1, mustSellItems.QuantityLimit);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    if (mustSellItems.AllCustomers)
                    {
                        SimpleCustomerModel customer = new SimpleCustomerModel();
                        result = InsertAppliedCustomersToMustSellItems(customer, mustSellItems.MustSellItemId, true, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else
                    {
                        if (mustSellItems.AppliedCustomers != null && mustSellItems.AppliedCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel customer in mustSellItems.AppliedCustomers)
                            {
                                result = InsertAppliedCustomersToMustSellItems(customer, mustSellItems.MustSellItemId, mustSellItems.AllCustomers, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        //Save applied groups
                        if (mustSellItems.AppliedGroups != null && mustSellItems.AppliedGroups.Count > 0)
                        {
                            foreach (CustomerGroupModel group in mustSellItems.AppliedGroups)
                            {
                                result = InsertAppliedGroupsToMustSellItems(group, mustSellItems.MustSellItemId, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                    //Save applied employees
                    if (mustSellItems.Employees != null && mustSellItems.Employees.Count > 0)
                    {
                        foreach (EmployeeModel employee in mustSellItems.Employees)
                        {
                            SecurityGroupModel securityGroup = new SecurityGroupModel();
                            result = InsertAppliedEmployeeAndSecurityGroupToMustSellItems(employee, securityGroup, mustSellItems.MustSellItemId, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.SecurityGroups != null && mustSellItems.SecurityGroups.Count > 0)
                    {
                        foreach (SecurityGroupModel securityGroup in mustSellItems.SecurityGroups)
                        {
                            EmployeeModel employee = new EmployeeModel();
                            result = InsertAppliedEmployeeAndSecurityGroupToMustSellItems(employee, securityGroup, mustSellItems.MustSellItemId, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.ExcludeCustomers != null && mustSellItems.ExcludeCustomers.Count > 0)
                    {
                        result = InsertAppliedExcludedOutletToMustSellItems(mustSellItems, dbHelper);
                        if (result != GlobalErrors.Success)
                            return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertAppliedCustomersToMustSellItems(SimpleCustomerModel customerOutlet, int mustSellItemId, bool allCustomers, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into MustSellItemAssignment (MustSellItemID,GroupID,CustomerID,OutletID,AllCustomer) values ({0},{1},{2},{3},{4})"
                , mustSellItemId, -1, customerOutlet.CustomerId, customerOutlet.OutletId, allCustomers ? "1" : "0");
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToMustSellItems(CustomerGroupModel group, int mustSellItemId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into MustSellItemAssignment (MustSellItemID,GroupID,CustomerID,OutletID,AllCustomer) values ({0},{1},{2},{3},{4})",
                mustSellItemId, group.GroupId, -1, -1, 0);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedEmployeeAndSecurityGroupToMustSellItems(EmployeeModel employee, SecurityGroupModel securityGroup, int mustSellItemId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into MustSellItemEmployee (MustSellItemID,SecurityGroupID,EmployeeID) values ({0},{1},{2})",
                mustSellItemId, securityGroup.SecurityGroupId, employee.EmployeeId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedExcludedOutletToMustSellItems(MustSellItems mustSellItems, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = String.Empty;
                int groupId = mustSellItems.AppliedGroups.Count > 0 ? mustSellItems.AppliedGroups.ElementAt(0).GroupId : -1;
                if (mustSellItems.ExcludeCustomers.Count > 0)
                {
                    query += DeleteMustSellItemsExcludedOutletQuery(groupId);
                    foreach (CustomerModel customer in mustSellItems.ExcludeCustomers)
                    {
                        query += string.Format(" insert into MustSellItemsExcludedOutlet(MustSellItemID,GroupID,CustomerID,OutletID) values ({0},{1},{2},{3})", mustSellItems.MustSellItemId, groupId, customer.CustomerId, customer.OutletId);
                    }
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemDetails(MustSellItems mustSellItemObject, ref List<MustSellItems> mustSellItem)
        {
            DBHelper<MustSellItems> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<MustSellItems> lists = new List<MustSellItems>();
                dbHelper = new DBHelper<MustSellItems>();
                string query = string.Format(@" select distinct MustSellItemDetails.* ,Item.ItemId,ItemGroup.ItemGroupID, 
                IsNull( item.ItemCode , '--') + ' - ' + IsNull( ItemLanguage.Description , '--') ItemCodeName,
                IsNull(ItemGroupLanguage.Description,'---')   ItemGroupName
                from MustSellItemDetails
                Left join Item on Item.ItemID = MustSellItemDetails.ItemID
                left join ItemGroup on ItemGroup.ItemGroupID = MustSellItemDetails.ItemGroupID
                left outer join ItemLanguage on ItemLanguage.ItemID=Item.ItemID and ItemLanguage.LanguageID = {0}
                left outer join ItemGroupLanguage on ItemGroupLanguage.ItemGroupID=ItemGroup.ItemGroupID and ItemGroupLanguage.LanguageID = {0}
                where MustSellItemDetails.MustSellItemID = {1} ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId);
                result = dbHelper.GetQueryList(query, ref mustSellItem);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItem = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemCustomerGroups(MustSellItems mustSellItemObject, ref List<CustomerGroupModel> groupsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerGroupModel> dbHelper = new DBHelper<CustomerGroupModel>(); ;
            string OrgAccessSelection = string.Empty;
            string OrgAccessGroupJoin = string.Empty;
            try
            {
                dbHelper = new DBHelper<CustomerGroupModel>();
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    OrgAccessSelection = ",CustomerGroup.OrganizationID ";
                    OrgAccessGroupJoin = string.Format(@" and CustomerGroup.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                else
                {
                    OrgAccessSelection = " ,-1 OrganizationId ";
                }
                string query = string.Format(@"SELECT MustSellItemAssignment.GroupID, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName {2} 
                FROM MustSellItemAssignment
                INNER JOIN CustomerGroup ON MustSellItemAssignment.GroupID = CustomerGroup.GroupID {3}
                LEFT JOIN CustomerGroupLanguage ON MustSellItemAssignment.GroupID = CustomerGroupLanguage.GroupID AND CustomerGroupLanguage.LanguageID = {0}
                Where MustSellItemAssignment.MustSellItemID = {1}",
                _requestRepository.LanguageId,
                mustSellItemObject.MustSellItemId,
                OrgAccessSelection,
                OrgAccessGroupJoin);

                result = dbHelper.GetQueryList(query, ref groupsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors  GetAppliedMustSellItemAllCustomers(MustSellItems mustSellItemObject, ref bool allCustomers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<MustSellItems> dbHelper = null;
            object feild = null;
            try
            {
                dbHelper = new DBHelper<MustSellItems>();
                string query = string.Format(@"select IsNull(Count(*),0)countt from MustSellItemAssignment where MustSellItemAssignment.MustSellItemID = {0} and AllCustomer = 1", mustSellItemObject.MustSellItemId);
                result = dbHelper.ExecuteScalar(query, ref feild);
                if (result == GlobalErrors.Success && feild != null && !string.IsNullOrEmpty(feild.ToString()) && Int32.Parse(feild.ToString()) > 0)
                {
                    allCustomers = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemCustomers(MustSellItems mustSellItemObject, ref List<SimpleCustomerModel> customersList)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SimpleCustomerModel> lists = new List<SimpleCustomerModel>();
                dbHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                string organizationIdSelection = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));

                    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                    }
                    else
                    {
                        organizationIdSelection = " ,Account.OrganizationId ";
                    }
                }
                else
                {
                    organizationIdSelection = " ,-1 OrganizationId ";
                }
                string query = string.Format(@" 
                select MustSellItemAssignment.CustomerID AS CustomerID, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                MustSellItemAssignment.OutletID AS OutletID, IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, -1 GroupID,'--' GroupCodeName {3},
                MustSellItemAssignment.AllCustomer AllCustomers
                FROM MustSellItemAssignment
                inner Join Customer on Customer.CustomerID = MustSellItemAssignment.CustomerID
                inner Join CustomerOutlet on CustomerOutlet.OutletID = MustSellItemAssignment.OutletID and CustomerOutlet.CustomerID=MustSellItemAssignment.CustomerID
                left Join CustomerOutletLanguage on CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID AND CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID
                and CustomerOutletLanguage.LanguageID = {0}
                left Join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID and CustomerLanguage.LanguageID = {0}
                {2}
                Where MustSellItemAssignment.MustSellItemID = {1}
                ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId, orgAccessJoin,
                organizationIdSelection);
                result = dbHelper.GetQueryList(query, ref lists);
                if (result == GlobalErrors.Success && lists != null && lists.Count > 0)
                {
                    customersList = FillCustomerOrganizationIdsAsList(lists, true, true, false);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                customersList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAppliedMustSellItemExcludedCustomers(MustSellItems mustSellItemObject, ref List<SimpleCustomerModel> excludedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SimpleCustomerModel> lists = new List<SimpleCustomerModel>();
                dbHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                string organizationIdSelection = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));

                    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                    }
                    else
                    {
                        organizationIdSelection = " ,Account.OrganizationId ";
                    }
                }
                string query = string.Format(@" select distinct Customer.CustomerId, CustomerOutlet.OutletId, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName ,
                IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName {3} from MustSellItemsExcludedOutlet 
                Inner JOIN Customer on MustSellItemsExcludedOutlet.CustomerId = Customer.CustomerId
                Inner JOIN CustomerLanguage on MustSellItemsExcludedOutlet.CustomerId = CustomerLanguage.CustomerId and CustomerLanguage.LanguageId = {0}
                Inner JOIN CustomerOutlet on CustomerOutlet.customerid = MustSellItemsExcludedOutlet.CustomerId and CustomerOutlet.OutletId = MustSellItemsExcludedOutlet.OutletId
                Inner JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.outletId = MustSellItemsExcludedOutlet.OutletId and CustomerOutletLanguage.LanguageId = {0}
                {2}
                where MustSellItemsExcludedOutlet.MustSellItemID = {1} ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId, orgAccessJoin,
                organizationIdSelection);
                result = dbHelper.GetQueryList(query, ref lists);
                if (result == GlobalErrors.Success && lists != null && lists.Count > 0)
                {
                    excludedCustomers = FillCustomerOrganizationIdsAsList(lists, true, true, false);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                excludedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemOrganizations(MustSellItems mustSellItemObject, ref List<MustSellItems> mustSellItem)
        {
            DBHelper<MustSellItems> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<MustSellItems> lists = new List<MustSellItems>();
                dbHelper = new DBHelper<MustSellItems>();
                string query = string.Format(@" select distinct MustSellItemOrganization.*, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName  
                from MustSellItemOrganization 
                Inner JOIN Organization on MustSellItemOrganization.OrganizationId = Organization.OrganizationID
                Left JOIN OrganizationLanguage on MustSellItemOrganization.OrganizationId = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageId = {0}
                where MustSellItemOrganization.MustSellItemID = {1} and Organization.OrganizationID in ({2}) ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref mustSellItem);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                mustSellItem = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemEmployee(MustSellItems mustSellItemObject, ref List<EmployeeModel> employeeList)
        {
            DBHelper<EmployeeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<EmployeeModel> lists = new List<EmployeeModel>();
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Format(@" select distinct MustSellItemEmployee.*,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,Employee.OrganizationID 
                from MustSellItemEmployee
                left join Employee on Employee.EmployeeID = MustSellItemEmployee.EmployeeID
                inner join EmployeeOrganization on EmployeeOrganization.EmployeeID = Employee.EmployeeID
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
                Where MustSellItemEmployee.MustSellItemID = {1} and EmployeeOrganization.OrganizationID in ({2}) ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref employeeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                employeeList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedMustSellItemSecurityGroup(MustSellItems mustSellItemObject, ref List<SecurityGroupModel> securityGroups)
        {
            DBHelper<SecurityGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<SecurityGroupModel> lists = new List<SecurityGroupModel>();
                dbHelper = new DBHelper<SecurityGroupModel>();
                string query = string.Format(@" select distinct MustSellItemEmployee.*,
                SecurityGroupLanguage.Description SecurityGroupName,SecurityGroup.OrganizationID OrganizationIds
                from MustSellItemEmployee
                left join SecurityGroup on SecurityGroup.SecurityGroupID = MustSellItemEmployee.SecurityGroupID
                left join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID = SecurityGroup.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0}
                Where MustSellItemEmployee.MustSellItemID = {1} and SecurityGroup.OrganizationID in ({2}) ", _requestRepository.LanguageId, mustSellItemObject.MustSellItemId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref securityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                securityGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteMustSellItem(int mustSellItemId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                //delete MustSellItemLanguage
                string query = string.Format(@"Delete From MustSellItemLanguage Where MustSellItemID = {0}", mustSellItemId);
                result = dbHelper.ExecuteNonQuery(query);
                // delete MustSellItemDetails
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From MustSellItemDetails Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    //delete MustSellItem
                    query = string.Format(@"Delete From MustSellItem Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From MustSellItemOrganization Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                // delete MustSellItemAssignment
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From MustSellItemAssignment Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                // delete MustSellItemsExcludedOutlet
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"Delete From MustSellItemsExcludedOutlet Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                // delete MustSellItemSecurityGroupEmployee
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"Delete From MustSellItemEmployee Where MustSellItemID = {0}", mustSellItemId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateMustSellItem(MustSellItems mustSellItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"Update MustSellItem set MustSellItemCode='{1}',StartDate = {2}, EndDate = {3} , Inactive = {4}, Mandatory={5}, ViewInSuggestedOrder = {6}
                where MustSellItemID = {0}",
                mustSellItems.MustSellItemId, //0
                mustSellItems.MustSellItemCode.Replace("'", "''"), //1
                LocalUtilities.ParseDateToSQLString(mustSellItems.StartDate.Value),//2
                LocalUtilities.ParseDateToSQLString(mustSellItems.EndDate.Value),//3
                mustSellItems.Inactive ? "1" : "0", //4
                mustSellItems.Mandatory ? "1" : "0", //5
                mustSellItems.ViewInSuggestedOrder ? "1" : "0" //6
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                //Save language
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"Delete From MustSellItemLanguage Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                    result = dbHelper.ExecuteNonQuery(query);
                    // delete MustSellItemDetails
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Delete From MustSellItemDetails Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                    #region[Delete Must Sell Item Related Data]
                    if (result == GlobalErrors.Success)
                    {
                        // Delete saved  data 
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeleteMustSellItemFromRelatedTable("MustSellItemAssignment", mustSellItems, dbHelper);
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeleteMustSellItemFromRelatedTable("MustSellItemsExcludedOutlet", mustSellItems, dbHelper);
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeleteMustSellItemFromRelatedTable("MustSellItemOrganization", mustSellItems, dbHelper);
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeleteMustSellItemFromRelatedTable("MustSellItemEmployee", mustSellItems, dbHelper);
                        }
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = GlobalErrors.Success;
                        }
                    }
                    #endregion
                    // delete MustSellItemAssignment
                    //if (result == GlobalErrors.Success)
                    //{
                    //    query = string.Format(@"Delete From MustSellItemAssignment Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                    //    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    //}
                    //// delete MustSellItemsExcludedOutlet
                    //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    //{
                    //    query = string.Format(@"Delete From MustSellItemsExcludedOutlet Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                    //    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    //}
                    //// delete MustSellItemSecurityGroupEmployee
                    //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    //{
                    //    query = string.Format(@"Delete From MustSellItemEmployee Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                    //    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    //}
                    //// delete MustSellItemOrganization
                    //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    //{
                    //    query = string.Format(@"Delete From MustSellItemOrganization Where MustSellItemID = {0}", mustSellItems.MustSellItemId);
                    //    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    //}
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    foreach (TextLanguage language in mustSellItems.LanguageDescriptions)
                    {
                        query = string.Format(@"insert into MustSellItemLanguage (MustSellItemID,LanguageId,Description) values ({0},{1},'{2}')", mustSellItems.MustSellItemId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    // Save Organization
                    if (mustSellItems.OrganizationList != null && mustSellItems.OrganizationList.Count > 0)
                    {
                        foreach (OrganizationModel organization in mustSellItems.OrganizationList)
                        {
                            query = string.Format(@"insert into MustSellItemOrganization (MustSellItemID,OrganizationId) values ({0},{1})", mustSellItems.MustSellItemId, organization.OrganizationId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    // Save Details
                    if (mustSellItems.Items != null && mustSellItems.Items.Count > 0)
                    {
                        foreach (ItemPackModel item in mustSellItems.Items)
                        {
                            query = string.Format(@"insert into MustSellItemDetails (MustSellItemID,ItemGroupID,ItemID,QuantityLimit) values ({0},{1},{2},{3})", mustSellItems.MustSellItemId, -1, item.ItemId, mustSellItems.QuantityLimit);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.ItemGroups != null && mustSellItems.ItemGroups.Count > 0)
                    {
                        foreach (ItemGroupModel itemGroup in mustSellItems.ItemGroups)
                        {
                            query = string.Format(@"insert into MustSellItemDetails (MustSellItemID,ItemGroupID,ItemID,QuantityLimit) values ({0},{1},{2},{3})", mustSellItems.MustSellItemId, itemGroup.ItemGroupId, -1, mustSellItems.QuantityLimit);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    //Save applied employees
                    if (mustSellItems.Employees != null && mustSellItems.Employees.Count > 0)
                    {
                        foreach (EmployeeModel employee in mustSellItems.Employees)
                        {
                            SecurityGroupModel securityGroup = new SecurityGroupModel();
                            result = InsertAppliedEmployeeAndSecurityGroupToMustSellItems(employee, securityGroup, mustSellItems.MustSellItemId, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.SecurityGroups != null && mustSellItems.SecurityGroups.Count > 0)
                    {
                        foreach (SecurityGroupModel securityGroup in mustSellItems.SecurityGroups)
                        {
                            EmployeeModel employee = new EmployeeModel();
                            result = InsertAppliedEmployeeAndSecurityGroupToMustSellItems(employee, securityGroup, mustSellItems.MustSellItemId, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (mustSellItems.ExcludeCustomers != null && mustSellItems.ExcludeCustomers.Count > 0)
                    {
                        result = InsertAppliedExcludedOutletToMustSellItems(mustSellItems, dbHelper);
                        if (result != GlobalErrors.Success)
                            return result;
                    }
                    if (mustSellItems.AllCustomers)
                    {
                        SimpleCustomerModel customer = new SimpleCustomerModel();
                        result = InsertAppliedCustomersToMustSellItems(customer, mustSellItems.MustSellItemId, true, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else
                    {
                        if (mustSellItems.AppliedCustomers != null && mustSellItems.AppliedCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel customer in mustSellItems.AppliedCustomers)
                            {
                                result = InsertAppliedCustomersToMustSellItems(customer, mustSellItems.MustSellItemId, mustSellItems.AllCustomers, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        //Save applied groups
                        if (mustSellItems.AppliedGroups != null && mustSellItems.AppliedGroups.Count > 0)
                        {
                            foreach (CustomerGroupModel group in mustSellItems.AppliedGroups)
                            {
                                result = InsertAppliedGroupsToMustSellItems(group, mustSellItems.MustSellItemId, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors ActivateDeactivatMustSellItem(int mustSellItemId, bool isActivate)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Empty;
                object field = 0;

                sqlQuery = string.Format(@"update MustSellItem set Inactive = {1} where MustSellItemID = {0}", mustSellItemId, isActivate ? "0" : "1");
                result = dbHelper.ExecuteNonQuery(sqlQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors DeleteMustSellItemFromRelatedTable(string tableName, MustSellItems mustSellItemObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Empty;
                string CustJoin = string.Empty;

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection && tableName.Equals("MustSellItemAssignment"))
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "P", _requestRepository.CurrentOperator.OrganizationAccess));

                        if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                        {
                            CustJoin = @" INNER JOIN Customer ON P.CustomerID = Customer.CustomerID ";
                        }
                    }             
                    if (tableName.Equals("MustSellItemAssignment"))
                    {
                        string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (GroupID is not null or GroupID <> -1) " : string.Empty;
                        string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                        query = $@"DELETE FROM {tableName} WHERE MustSellItemID = {mustSellItemObj.MustSellItemId} and AllCustomer = 1  {deleteGroups} {deleteCustomers}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                        {
                            query = $@" DELETE P FROM {tableName} P                               
                                           inner join CustomerGroup CG  on CG.GroupID = P.GroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE P.MustSellItemID = {mustSellItemObj.MustSellItemId} ";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }

                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {

                            query = $@" DELETE P FROM { tableName } P
                                           {CustJoin}
                                           {orgAccessJoin}
                                           WHERE P.MustSellItemID = {mustSellItemObj.MustSellItemId} ";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                    }
                    if (tableName.Equals("MustSellItemsExcludedOutlet"))
                    {
                        query = $@" DELETE P FROM {tableName} P 
                                           { orgAccessJoin }
                                           WHERE P.MustSellItemID = {mustSellItemObj.MustSellItemId} ";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    query = string.Format(@"Delete From MustSellItemAssignment Where MustSellItemID = {0}", mustSellItemObj.MustSellItemId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (tableName.Equals("MustSellItemOrganization"))
                {
                    query = $"DELETE FROM {tableName} WHERE MustSellItemID = {mustSellItemObj.MustSellItemId} and OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (tableName.Equals("MustSellItemEmployee"))
                {
                    query = $@"DELETE P FROM {tableName} P
                    inner join EmployeeOrganization CG  on CG.EmployeeID = P.EmployeeID
                    and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                    WHERE MustSellItemID = {mustSellItemObj.MustSellItemId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (tableName.Equals("MustSellItemEmployee"))
                {
                    query = $@" DELETE P FROM {tableName} P                               
                                inner join SecurityGroup CG  on CG.SecurityGroupID = P.SecurityGroupID
                                and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                WHERE P.MustSellItemID = {mustSellItemObj.MustSellItemId} ";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #endregion

        #region [Payer Account]
        public GlobalErrors GetPayerAccountSharedTable(GeneralFilter filter, ref SharedTableResult<PayerAccountModel> payerAccountList)
        {
            payerAccountList = new SharedTableResult<PayerAccountModel>();
            List<PayerAccountModel> newPayerAccountList = new List<PayerAccountModel>();
            DBHelper<PayerAccountModel> dbHelper = null;           
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PayerAccountModel>();
                string searchFilter = "1=1 ";
                string orderByFilter = string.Empty;
                string PayerAssigment = string.Empty;
                if (filter != null)
                {
                    if(filter.CustomerId != -1 || filter.OutletId != -1 || filter.groupId != -1)
                    {
                        // for filtering to filter on cust and out and group bug
                        PayerAssigment = "INNER JOIN PayerAssignment on PayerAssignment.PayerID = Payer.PayerID";
                    }
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@" and 
                        ((AccountLanguage.Description  LIKE '%{0}%') 
                        OR (PayerCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (PayerAssignment.CustomerID = {0} OR PayerAssignment.CustomerGroupID IN (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0})) ", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (PayerAssignment.OutletID = {0}) ", filter.OutletId);
                    }
                    if (filter.groupId != -1)
                    {
                        if (filter.CustomerId != -1 && filter.OutletId != -1)
                        {
                            searchFilter += string.Format(" Or (PayerAssignment.CustomerGroupID = {0}) ", filter.groupId);
                        }
                        else
                        {
                            searchFilter += string.Format(" And (PayerAssignment.CustomerGroupID = {0}) ", filter.groupId);
                        }
                    }
                    if (filter.DivisionId != -1)
                    {
                        searchFilter += string.Format(" And (PayerAssignment.DivisionID = {0}) ", filter.DivisionId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By Payer.PayerID");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }

                //  the changes made here to bring the orgIds from the list and not on the edit query which created the bug 
                string mainQuery = string.Format(@" SELECT distinct Payer.PayerID, AccountPayer.AccountID, AccountLanguage.Description as PayerName,
                Account.OrganizationID,IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') OrganizationCodeName ,
                PayerCode, cast ( Account.CreditLimit as numeric(19,{1})) CreditLimit, cast ( Account.Balance as numeric(19,{1}) ) Balance
                FROM Payer
                INNER JOIN AccountPayer ON AccountPayer.PayerID = Payer.PayerID
                INNER JOIN Account ON Account.AccountID = AccountPayer.AccountID
                {4}
                INNER JOIN Organization ON Organization.OrganizationID = Account.OrganizationID
				INNER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = Organization.OrganizationID AND OrganizationLanguage.LanguageID = {0}
                LEFT OUTER JOIN AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID
                AND AccountLanguage.LanguageID = {0} 
                WHERE {2} and Account.OrganizationId in ({3}) ",
                _requestRepository.LanguageId,
                _requestRepository.Configurations.NumberOfDigits,
                searchFilter,
                _requestRepository.CurrentOperator.OrganizationAccess,
                PayerAssigment
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})d",
               mainQuery);

                string selectionQuery = mainQuery + @$"{orderByFilter}
                OFFSET  {(filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize}
                ROWS
                FETCH NEXT {filter.CustomListFilter.PageSize}
                ROWS ONLY";
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success)
                {
                    payerAccountList.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        result = dbHelper.GetQueryList(selectionQuery, ref newPayerAccountList , true);
                        payerAccountList.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                    payerAccountList.Data = newPayerAccountList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                newPayerAccountList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertPayerAccount(PayerAccountModel payerAccounts)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                int newAccountID = GetNewAccountID();
                if (newAccountID != -1)
                {
                    int newPayerID = GetNewPayerID();
                    if (newPayerID != -1)
                    {
                        //Account parentAccount = ReadParentAccountInfo(parentAccountID);
                        if (payerAccounts != null)
                        {
                            dbHelper = new DBHelper<int>();
                            dbHelper.BeginTransaction();
                            string query = string.Format(@"INSERT INTO Account (AccountID,AccountTypeID,CreditLimit,Balance,GL,OrganizationID,CurrencyID,ParentAccountID,SalesOrderBalance,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate)
                                    VALUES ({0},{1},{2},0,0,{3},{4},NULL,NULL,{5},{6},{5},{6})", newAccountID, AccountTypes.ClientAccount.GetHashCode(), payerAccounts.CreditLimit, payerAccounts.OrganizationId, payerAccounts.CurrencyId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result == GlobalErrors.Success)
                            {
                                query = string.Format(@"INSERT INTO Payer (PayerID ,PayerCode) VALUES ({0},'{1}')", newPayerID, payerAccounts.PayerCode.Replace("'", "''").ToString());
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result == GlobalErrors.Success)
                                {
                                    query = string.Format(@"INSERT INTO AccountPayer (PayerID ,AccountID) VALUES ({0},{1})", newPayerID, newAccountID);
                                    result = dbHelper.ExecuteNonQuery(query);
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    foreach (TextLanguage language in payerAccounts.LanguageDescriptions)
                                    {
                                        query = string.Format(@"INSERT INTO AccountLanguage (AccountID ,LanguageID, Description) 
                                            VALUES ({0},{1},'{2}')",
                                        newAccountID, language.LanguageId, language.Description.Replace("'", "''"));
                                        result = dbHelper.ExecuteNonQuery(query);
                                        if (result != GlobalErrors.Success) return result;
                                    }
                                }
                                if (result == GlobalErrors.Success)
                                {
                                    if (payerAccounts.AppliedCustomers != null && payerAccounts.AppliedCustomers.Count > 0)
                                    {
                                        foreach (SimpleCustomerModel customer in payerAccounts.AppliedCustomers)
                                        {
                                            if (!IsPayerexists(customer.CustomerId, customer.OutletId, -1, customer.DivisionId, dbHelper))
                                            {
                                                result = InsertAppliedCustomersToPayerAccount(customer.CustomerId, customer.OutletId ,newPayerID, customer.DivisionId, dbHelper);
                                                if (result != GlobalErrors.Success) return result;
                                            }
                                            else
                                            {
                                                result = GlobalErrors.SuccessWithZeroRowAffected;
                                                return result;
                                            }
                                        }
                                    }
                                    //Save applied groups
                                    if (payerAccounts.AppliedGroups != null && payerAccounts.AppliedGroups.Count > 0)
                                    {
                                        foreach (CustomerGroupModel group in payerAccounts.AppliedGroups)
                                        {
                                            if (!IsPayerexists(-1, -1, group.GroupId, group.DivisionId, dbHelper))
                                            {
                                                result = InsertAppliedGroupsToPayerAccount(group, newPayerID, group.DivisionId, dbHelper);
                                                if (result != GlobalErrors.Success) return result;
                                            }
                                            else
                                            {
                                                result = GlobalErrors.SuccessWithZeroRowAffected;
                                                return result;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        private int GetNewAccountID()
        {
            int newAccountID = -1;
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                object objValue = null;
                string sqlStatement = "SELECT MAX(AccountID) + 1 ID FROM Account";
                result = dBHelper.ExecuteScalar(sqlStatement, ref objValue);
                if (result == GlobalErrors.Success && objValue != null && !string.IsNullOrEmpty(objValue.ToString()))
                {
                    newAccountID = int.Parse(objValue.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return newAccountID;
        }
        private int GetNewPayerID()
        {
            int newPayerID = -1;
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                object objValue = null;
                string sqlStatement = "SELECT MAX(PayerID) + 1 ID FROM Payer";
                result = dBHelper.ExecuteScalar(sqlStatement, ref objValue);
                if (result == GlobalErrors.Success)
                {
                    if (objValue != null && !string.IsNullOrEmpty(objValue.ToString()))
                        newPayerID = int.Parse(objValue.ToString());
                    else newPayerID = 1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return newPayerID;
        }
        public bool IsPayerexists(int CustomerID, int OutletID, int CustomerGroupID, int DivisionID, DBHelper<int> dBHelper)
        {
            try
            {
                bool exist = false;
                object feild = null;
                string sqlQuery = string.Format(@"SELECT COUNT(*) FROM PayerAssignment WHERE 
                        CustomerID = {0} AND OutletID = {1} AND CustomerGroupID = {2} AND DivisionID = {3}",
                CustomerID, OutletID, CustomerGroupID, DivisionID);
                GlobalErrors result = dBHelper.ExecuteScalar(sqlQuery, ref feild);
                if (result == GlobalErrors.Success)
                {
                    if (feild != null && int.Parse(feild.ToString()) == 1 && !feild.ToString().Equals(string.Empty))
                        exist = true;
                    else
                        exist = false;
                }
                return exist;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors InsertAppliedCustomersToPayerAccount(int customerId, int OutletId , int payerId, int divisionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO PayerAssignment (PayerID ,CustomerID, OutletID, CustomerGroupID, DivisionID, AllCustomers) 
                                                            VALUES ({0},{1},{2},{3},{4},'{5}')",
                                                             payerId, customerId, OutletId , -1, divisionId, 0);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToPayerAccount(CustomerGroupModel group, int payerId, int divisionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO PayerAssignment (PayerID ,CustomerID, OutletID, CustomerGroupID, DivisionID, AllCustomers) 
                                                            VALUES ({0},{1},{2},{3},{4},'{5}')",
                                                            payerId, -1, -1, group.GroupId, divisionId, 0);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPayerAccountData(PayerAccountModel payerAccount, ref List<PayerAccountModel> payer)
        {
            DBHelper<PayerAccountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string divisionJoin = string.Empty;
            string divisionSelection = string.Empty;
            string orgChildAcessJoin = string.Empty;
            StringBuilder orgChildAccess = new StringBuilder();
            try
            {
                List<PayerAccountModel> lists = new List<PayerAccountModel>();
                dbHelper = new DBHelper<PayerAccountModel>();
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionJoin = string.Format(@" INNER JOIN Division ON Division.DivisionID = PayerAssignment.DivisionID
                    LEFT JOIN DivisionLanguage ON PayerAssignment.DivisionID = DivisionLanguage.DivisionID AND DivisionLanguage.LanguageID = {0} ", _requestRepository.LanguageId);
                    divisionSelection = string.Format(@" , IsNull(Division.DivisionCode, '--') + ' ' + '-' + ' ' + IsNull(Divisionlanguage.Description, '--') as DivisionCodeName,PayerAssignment.DivisionID ");
                }
                if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                { // note : this is when i get the customer in [payer entry] so i can get their childs and under access
                    orgChildAccess.AppendLine(string.Format(CoreDataBaseConstants.OrgChildQuery, _requestRepository.CurrentOperator.OrganizationAccess));
                    orgChildAcessJoin = string.Format(@" INNER JOIN @ChildOrganizations Org ON Org.OrganizationID = CustomerOutlet.OrganizationID AND Org.OrganizationID IN ({0})",_requestRepository.CurrentOperator.OriginalOrganizationAccess);
                }
                string query = string.Format(@" 
                {4}
                SELECT distinct PayerAssignment.PayerID,PayerAssignment.CustomerID,PayerAssignment.OutletID,PayerAssignment.CustomerGroupID, Account.AccountID, AccountLanguage.Description PayerName,PayerAssignment.CustomerID AS CustomerID, CASE WHEN PayerAssignment.CustomerID != - 1 then IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') ELSE '---' END as CustomerCodeName,
                PayerAssignment.OutletID AS OutletID, CASE WHEN PayerAssignment.OutletID != - 1 then IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') ELSE '---' END as OutletCodeName,PayerAssignment.CustomerGroupID GroupId,CASE WHEN PayerAssignment.CustomerGroupID != - 1 THEN CONCAT(CustomerGroup.GroupCode,
                ' - ', CustomerGroupLanguage.Description) ELSE '---' END AS GroupCodeName,Account.OrganizationID,IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') OrganizationCodeName {2}
                FROM PayerAssignment
                INNER JOIN Payer on Payer.PayerID = PayerAssignment.PayerID 
                INNER JOIN AccountPayer on AccountPayer.PayerID = Payer.PayerID
                INNER JOIN Account on Account.AccountID = AccountPayer.AccountID
                LEFT OUTER JOIN AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID AND AccountLanguage.LanguageID = {1}
                Inner join Organization on Organization.OrganizationID = Account.OrganizationID
				Left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {1}
				left Join Customer on Customer.CustomerID = PayerAssignment.CustomerID
                left Join CustomerOutlet on CustomerOutlet.OutletID = PayerAssignment.OutletID and CustomerOutlet.CustomerID=PayerAssignment.CustomerID
                left Join CustomerOutletLanguage on CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID AND CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID
                and CustomerOutletLanguage.LanguageID = {1}
                left Join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID and CustomerLanguage.LanguageID = {1}
                left JOIN CustomerGroup ON PayerAssignment.CustomerGroupID = CustomerGroup.GroupID 
                LEFT JOIN CustomerGroupLanguage ON PayerAssignment.CustomerGroupID = CustomerGroupLanguage.GroupID AND CustomerGroupLanguage.LanguageID = {1}
                {3}
                {5}
                WHERE PayerAssignment.PayerID = {0} ", payerAccount.PayerId, _requestRepository.LanguageId, divisionSelection, divisionJoin , orgChildAccess , orgChildAcessJoin);
                result = dbHelper.GetQueryList(query, ref payer);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payer = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeletePayerAccount(int payerId, int accountId, ref string deleteMsg)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            deleteMsg = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                if (PayerLinkedToTransactionsOrPayment(accountId))
                {
                    deleteMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Account_Is_Linked_To_Transaction_Or_Payment, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
                string query = string.Format(@"DELETE FROM PayerAssignment WHERE PayerID = {0}", payerId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM AccountPayer WHERE PayerID = {0}", payerId);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"DELETE FROM Payer WHERE PayerID = {0}", payerId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = string.Format(@"DELETE FROM AccountLanguage WHERE AccountID = {0}", accountId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result == GlobalErrors.Success)
                            {
                                query = string.Format(@"DELETE FROM Account WHERE AccountID = {0}", accountId);
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                    }
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool PayerLinkedToTransactionsOrPayment(int AccountID)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"SELECT COUNT(*) FROM AccountPayer 
                LEFT OUTER JOIN [Transaction] t on AccountPayer.AccountID = t.AccountID
                LEFT OUTER JOIN CustomerPayment on CustomerPayment.AccountID = AccountPayer.AccountID
                WHERE AccountPayer.AccountID = {0} AND (t.AccountID IS NOT NULL OR CustomerPayment.AccountID IS NOT NULL)", AccountID);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && field.ToString() == "0")
                    return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return true;
        }
        public GlobalErrors UpdatePayerAccount(PayerAccountModel payers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                StringBuilder orgChildAccess = new StringBuilder();
                dbHelper.BeginTransaction();
                string query = string.Format(@"UPDATE Payer SET PayerCode = '{0}' WHERE PayerID = {1}", payers.PayerCode, payers.PayerId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"UPDATE Account SET CreditLimit = {0} 
                        WHERE AccountID IN (SELECT AccountID FROM AccountPayer WHERE PayerID = {1})",
                        payers.CreditLimit, payers.PayerId);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"DELETE FROM AccountLanguage WHERE AccountID = {0}", payers.AccountId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (TextLanguage language in payers.LanguageDescriptions)
                            {
                                query = string.Format(@"INSERT INTO AccountLanguage (AccountID ,LanguageID, Description) 
                                            VALUES ({0},{1},'{2}')",
                                payers.AccountId, language.LanguageId, language.Description.Replace("'", "''"));
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        if (result == GlobalErrors.Success)
                        {
                            if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                            { // on updating the payer customers 
                                orgChildAccess.AppendLine(string.Format(CoreDataBaseConstants.OrgChildQuery, _requestRepository.CurrentOperator.OrganizationAccess));
                                query = string.Format(@"
                                 {2}
                                 DELETE payerAssig
							     FROM PayerAssignment payerAssig
							     INNER JOIN CustomerOutlet ON CustomerOutlet.CustomerID = payerAssig.CustomerID
							     INNER JOIN @ChildOrganizations org ON org.OrganizationID = CustomerOutlet.OrganizationID 
                                 AND org.OrganizationID IN ({1})
							     where PayerID = {0}", payers.PayerId, _requestRepository.CurrentOperator.OriginalOrganizationAccess, orgChildAccess);
                            } 
                            else
                            {
                                query = string.Format(@"DELETE FROM PayerAssignment WHERE PayerID = {0}", payers.PayerId);
                            }
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                result = GlobalErrors.Success;
                            }
                        }
                        if (result == GlobalErrors.Success)
                        {
                            if (payers.AppliedCustomers != null && payers.AppliedCustomers.Count > 0)
                            {
                                foreach (SimpleCustomerModel customer in payers.AppliedCustomers)
                                {
                                    if (!IsPayerexists(customer.CustomerId, customer.OutletId, -1, customer.DivisionId, dbHelper))
                                    {
                                        result = InsertAppliedCustomersToPayerAccount(customer.CustomerId, customer.OutletId, payers.PayerId, customer.DivisionId, dbHelper);
                                        if (result != GlobalErrors.Success) return result;
                                    }
                                    else
                                    {
                                        result = GlobalErrors.SuccessWithZeroRowAffected;
                                        return result;
                                    }
                                }
                            }
                            //Save applied groups
                            if (payers.AppliedGroups != null && payers.AppliedGroups.Count > 0)
                            {
                                foreach (CustomerGroupModel group in payers.AppliedGroups)
                                {
                                    if (!IsPayerexists(-1, -1, group.GroupId, group.DivisionId, dbHelper))
                                    {
                                        result = InsertAppliedGroupsToPayerAccount(group, payers.PayerId, group.DivisionId, dbHelper);
                                        if (result != GlobalErrors.Success) return result;
                                    }
                                    else
                                    {
                                        result = GlobalErrors.SuccessWithZeroRowAffected;
                                        return result;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetPayerAccount(int currencyId, ref List<PayerAccountModel> payers)
        {
            DBHelper<PayerAccountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PayerAccountModel>();
                StringBuilder OrgParentsQuery = new StringBuilder();
                string OrgJoin = string.Empty;
                string OrgAcc = string.Empty;

                if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                { // this is for [Payer Account] in Customer Entry and its under Orginal org Access
                    OrgParentsQuery.AppendFormat(string.Format(CoreDataBaseConstants.OrgParentsQuery, _requestRepository.CurrentOperator.OrganizationAccess));

                    OrgJoin = string.Format(@"INNER JOIN @OrganizationTemp Org ON Account.OrganizationID = Org.OrganizationID AND Org.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OriginalOrganizationAccess);
                }
                else
                {
                    OrgAcc = string.Format(@" AND Account.OrganizationId in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                }

                string query = string.Format(@"
                {4}
                SELECT distinct Payer.PayerID, IsNull(Payer.PayerCode , '--') + ' - ' + IsNull( AccountLanguage.Description, '--') PayerCodeName,cast ( Account.CreditLimit as numeric(19,{1})) CreditLimit, cast ( Account.Balance as numeric(19,{1}) ) Balance
                FROM Payer
                INNER JOIN AccountPayer ON AccountPayer.PayerID = Payer.PayerID
                INNER JOIN Account ON Account.AccountID = AccountPayer.AccountID
				Inner join Customer on Customer.CurrencyID = Account.CurrencyID
                LEFT OUTER JOIN AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID
                AND AccountLanguage.LanguageID = {0} 
                {5}
                where 1=1 {2} AND Account.CurrencyID = {3} order by PayerID", _requestRepository.LanguageId, _requestRepository.Configurations.NumberOfDigits, OrgAcc, currencyId , OrgParentsQuery , OrgJoin);
                result = dbHelper.GetQueryList(query, ref payers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomersPayerOutlets(GeneralFilter filter, ref List<PayerAccountModel> payers)
        {
            DBHelper<PayerAccountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string divisionJoin = string.Empty;
            string divisionSelection = string.Empty;
            string divisionCondition = string.Empty;
            try
            {
                dbHelper = new DBHelper<PayerAccountModel>();
                if (filter.IsFromPayerAccount && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionJoin = string.Format(@" 
                     inner join Division D on DivisionId in ({0})                                            
                     Left Outer join Divisionlanguage on  D.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {1} ", _requestRepository.CurrentOperator.DivisionAccess, _requestRepository.LanguageId);
                    divisionSelection = string.Format(@"
                     ,D.DivisionId,
                     IsNull(D.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName ");
                    divisionCondition = string.Format(@" and PayerAssignment.DivisionID = D.DivisionID ");
                }
            
                string query = string.Format(@" select Distinct CO.CustomerID , CO.OutletID ,CO.CustomerCode OutletCode, IsNull(CO.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CL.Description , '--') as OutletCodeName,
                IsNull(Payer.PayerID, -1)PayerID, IsNull(Payer.PayerCode , '--') + ' - ' + IsNull( AccountLanguage.Description, '--')as  PayerCodeName,
                cast ( Account.CreditLimit as numeric(19,{4})) CreditLimit, Account.OrganizationID , cast ( Account.Balance as numeric(19,{4}) ) Balance,Account.AccountID  {2}
                from CustomerOutlet  CO
                Inner join CustomerOutletLanguage CL on CO.CustomerID = CL.CustomerID and CO.OutletID = CL.OutletID and languageid = {0}
                {3}
                left join PayerAssignment on (PayerAssignment.CustomerID = CO.CustomerID {5} and PayerAssignment.OutletID = CO.OutletID or PayerAssignment.CustomerGroupID IN (select GroupID from CustomerGroup where groupid in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {1}))) 
                left JOIN Payer on Payer.PayerID = PayerAssignment.PayerID 
                left JOIN AccountPayer on AccountPayer.PayerID = Payer.PayerID
                left JOIN Account on Account.AccountID = AccountPayer.AccountID
                LEFT OUTER JOIN AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID AND AccountLanguage.LanguageID = {0}
                where  CO.CustomerID in ({1}) and CO.Inactive <> 1", _requestRepository.LanguageId, filter.CustomerId, divisionSelection, divisionJoin, _requestRepository.Configurations.NumberOfDigits , divisionCondition);
                
                result = dbHelper.GetQueryList(query, ref payers);
                string originalOrganizationAccess = _requestRepository.CurrentOperator.OriginalOrganizationAccess;
                string[] orgIds = originalOrganizationAccess.Split(',');

                if (result == GlobalErrors.Success)
                {
                    payers.ForEach(x =>
                    {
                        if (PayerLinkedToTransactionsOrPayment(x.AccountId))
                        {
                            x.IsLinkedToTransaction = true;
                        }
                        if (!orgIds.Contains(x.OrganizationId.ToString()) && x.OrganizationId.ToString() != "-1")
                        {
                            x.IsPayerOutOfAcess = true;
                        }
                        if (x.IsPayerOutOfAcess || x.IsLinkedToTransaction)
                        {
                            x.IsDisabledInput = true;
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                payers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool IsPayerCustomerexists(int CustomerID, int OutletID, int CustomerGroupID, int DivisionID, int payerId, DBHelper<int> dBHelper)
        {
            try
            {
                bool exist = false;
                object feild = null;
                string sqlQuery = string.Format(@"SELECT COUNT(*) FROM PayerAssignment WHERE 
                        CustomerID = {0} AND OutletID = {1} AND CustomerGroupID = {2} AND DivisionID = {3} AND PayerID = {4} ",
                CustomerID, OutletID, CustomerGroupID, DivisionID, payerId);
                GlobalErrors result = dBHelper.ExecuteScalar(sqlQuery, ref feild);
                if (result == GlobalErrors.Success)
                {
                    if (feild != null && int.Parse(feild.ToString()) == 1 && !feild.ToString().Equals(string.Empty))
                        exist = true;
                    else
                        exist = false;
                }
                return exist;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors GetAppliedPayerAccountDivisions(PayerAccountModel payerObj, ref List<DivisionModel> divisionList)
        {
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<DivisionModel> lists = new List<DivisionModel>();
                dbHelper = new DBHelper<DivisionModel>();
                string query = string.Format(@" SELECT distinct PayerAssignment.PayerID, IsNull(Division.DivisionCode, '--') + ' ' + '-' + ' ' + IsNull(Divisionlanguage.Description, '--') as DivisionCodeName,PayerAssignment.DivisionID
                FROM PayerAssignment
                INNER JOIN Payer on Payer.PayerID = PayerAssignment.PayerID 
                INNER JOIN Division ON Division.DivisionID = PayerAssignment.DivisionID
                LEFT JOIN DivisionLanguage ON PayerAssignment.DivisionID = DivisionLanguage.DivisionID AND DivisionLanguage.LanguageID = {0}
                WHERE PayerAssignment.PayerID = {1} ", _requestRepository.LanguageId, payerObj.PayerId);
                result = dbHelper.GetQueryList(query, ref divisionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[Customer Containers Limit]
        public GlobalErrors CheckIfContainerLimitExists(CustomerContainerLimitModel containerLimit, ref bool exists)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"select count(*) from ContainerLimit where CustomerID = {containerLimit.CustomerId} 
                and OutletID = {containerLimit.OutletId} and PackID = {containerLimit.PackId} and EmployeeId = -1 ";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    exists = int.Parse(field.ToString()) > 0;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateContainerLimit(CustomerContainerLimitModel containerLimit, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null) dBHelper = new DBHelper<int>();
                string query = $@"update ContainerLimit set Limit={containerLimit.Limit} where CustomerID={containerLimit.CustomerId} 
                and OutletID={containerLimit.OutletId} and PackID={containerLimit.PackId} and EmployeeID = -1";
                // all container limits defined in web have employeeId = -1
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteContainerLimit(CustomerContainerLimitModel containerLimit)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"Delete from ContainerLimit where CustomerId = {containerLimit.CustomerId} and OutletId = {containerLimit.OutletId}
                and PackId = {containerLimit.PackId} and EmployeeId = -1";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertContainerLimit(CustomerContainerLimitModel containerLimit)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"insert into ContainerLimit (CustomerID,OutletID,PackID,EmployeeID,Limit,DepositBalance,NoneDepositBalance) values 
                ({containerLimit.CustomerId},{containerLimit.OutletId},{containerLimit.PackId},-1,{containerLimit.Limit},{containerLimit.DepositBalance},{containerLimit.NoneDepositBalance})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCustomersContainersLimit(GeneralFilter filter, ref List<CustomerContainerLimitModel> containerLimitList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerContainerLimitModel> dBHelper = new DBHelper<CustomerContainerLimitModel>();
                string query = $@"select item.ItemID,ItemCode ItemCode, ItemLanguage.Description ItemDescription, PackTypeLanguage.Description UOM ,ContainerLimit.Limit,ContainerLimit.DepositBalance,ContainerLimit.NoneDepositBalance,ContainerLimit.CustomerID,ContainerLimit.OutletID,ContainerLimit.EmployeeID,ContainerLimit.PackID ,
                IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName , IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( col.Description , '--') as OutletCodeName,
                IsNull(Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName, {(filter.SetAsDisabled ? 1 : 0)} as Disabled
                from ContainerLimit
                inner join Pack on Pack.PackID=ContainerLimit.PackID
                inner join Item on Item.ItemID=Pack.ItemID and Item.ItemType= {(int)ItemTypes.Container}
                inner join customer on customer.CustomerID = ContainerLimit.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = ContainerLimit.CustomerID and CustomerOutlet.OutletID = ContainerLimit.OutletID
                Left outer join CustomerLanguage on CustomerLanguage.CustomerID = customer.CustomerID and CustomerLanguage.LanguageID = {_requestRepository.LanguageId}
                Left outer join CustomerOutletLanguage col on col.CustomerID = ContainerLimit.CustomerID  and col.OutletID = ContainerLimit.OutletID  and col.LanguageID = {_requestRepository.LanguageId}
                left outer join ItemLanguage on ItemLanguage.ItemID=Pack.ItemID and ItemLanguage.LanguageID= {_requestRepository.LanguageId}
                left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.PackTypeID and PackTypeLanguage.LanguageID = {_requestRepository.LanguageId} where item.Inactive = 0 and ContainerLimit.employeeId = -1
				ORDER BY Customer.CustomerCode";
                //if (filter.CustomerId > -1)
                //{
                //    query += $@" and ContainerLimit.CustomerId = {filter.CustomerId} ";
                //}
                //if (filter.OutletId > -1)
                //{
                //    query += $@" and ContainerLimit.OutletId = {filter.OutletId} ";
                //}
                result = dBHelper.GetQueryList(query, ref containerLimitList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[Sales Distribution Channel]
        public GlobalErrors InsertSalesDistributionChannel(SalesDistributionChannelModel channel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"INSERT INTO SDC (SDCId, SDCCode) VALUES ({channel.SDCId}, '{channel.SDCCode.Replace("'", "''").ToString()}')";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertSalesDistributionChannelOrganization(SalesDistributionChannelModel channel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var values = new StringBuilder();
                foreach (OrganizationModel organization in channel.OrganizationsList)
                {
                    values.AppendFormat(" ({0},{1}),", channel.SDCId, organization.OrganizationId);
                }
                string query = string.Format(@"Insert Into SDCOrganization (SDCID, OrganizationID) Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertSalesDistributionChannelLanguage(SalesDistributionChannelModel channel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TextLanguage> otherLanguages = channel.DescriptionLanguages.Where(desc => desc.LanguageId != _requestRepository.LanguageId).ToList();
                if (otherLanguages != null && otherLanguages.Count > 0)
                {
                    foreach (TextLanguage txtLang in otherLanguages)
                    {
                        string query = $@" Insert into SDCLanguage (SDCID,LanguageID, Description) Values
                            ({channel.SDCId},
                            {txtLang.LanguageId},
                            '{(!string.IsNullOrEmpty(txtLang.Description) ? txtLang.Description.Replace("'", "''").ToString() : channel.SDCDescription.Replace("'", "''").ToString())}')";
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    string query = $@" Insert into SDCLanguage (SDCID,LanguageID, Description) Values
                            ({channel.SDCId},
                            {_requestRepository.LanguageId},
                            '{(!string.IsNullOrEmpty(channel.SDCDescription) ? channel.SDCDescription.Replace("'", "''").ToString() : null)}')";
                    result = dBHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertSalesDistributionChannelCustomers(SalesDistributionChannelModel channel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var values = new StringBuilder();
                foreach (SimpleCustomerModel custOut in channel.CustomersList)
                {
                    values.Append($" ({channel.SDCId},{custOut.CustomerId},{custOut.OutletId}),");

                }
                string query = string.Format(@"Insert Into SDCCustomer
                    (SDCID,  CustomerID , OutletID)   Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateSalesDistributionChannel(SalesDistributionChannelModel channel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Update SDC set SDCCode = '{channel.SDCCode.Replace("'", "''")}' WHERE SDCID = {channel.SDCId}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteSalesDistributionChannel(int channelId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Delete from SDC where SDCID = {channelId}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteSalesDistributionChannelLanguage(int channelId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Delete from SDCLanguage where SDCID = {channelId}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteSalesDistributionChannelOrganization(int channelId, bool isEdit, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgFilter = string.Empty;
                if (isEdit)
                {
                    orgFilter = $@" AND organizationId in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                }
                string query = $@"Delete from SDCOrganization where SDCID = {channelId} {orgFilter}";

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected && isEdit)
                    result = GlobalErrors.Success;


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteSalesDistributionChannelCustomers(int channelId, int customerId, int outletId, bool isEdit, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder orgAccessJoin = new StringBuilder();
                string whereCondition = String.Empty;
                if (channelId > -1)
                {
                    whereCondition = $" AND t.SDCID = {channelId}";
                }
                if (customerId > -1 && outletId > -1)
                {
                    whereCondition += $" AND t.CustomerId = {customerId} AND t.OutletId = {outletId}";
                }
                if (isEdit)
                {
                    if (channelId > -1 && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                    else if (customerId > -1 && outletId > -1)
                    {
                        orgAccessJoin.AppendLine($" INNER JOIN SDCOrganization O on O.SDCID = t.SDCID AND O.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})");
                    }
                }
                string query = $@" DELETE t FROM SDCCustomer t 
                                           inner join CustomerOutlet CO on CO.CustomerID = t.CustomerID and CO.OutletID = t.OutletID
                                           {orgAccessJoin.ToString()}
                                           WHERE 1=1 {whereCondition}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetSalesDistributionChannelMainData(ref SalesDistributionChannelModel channel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SalesDistributionChannelModel> dBHelper = new DBHelper<SalesDistributionChannelModel>();
                string query = $@"Select * FROM SDC Where SDCID = {channel.SDCId}";
                result = dBHelper.GetQuerySingle(query, ref channel);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSalesDistributionChannelLanguages(int channelId, ref List<TextLanguage> languages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<TextLanguage> dBHelper = new DBHelper<TextLanguage>();
                string query = $@"Select SDCLanguage.description, SDCLanguage.LanguageID, SDCLanguage.SDCID ID FROM SDCLanguage Where SDCID = {channelId}";
                result = dBHelper.GetQueryList(query, ref languages);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSalesDistributionChannelOrganizations(int channelId, ref List<OrganizationModel> organizations)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<OrganizationModel> dBHelper = new DBHelper<OrganizationModel>();
                string query = $@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                    IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                    FROM SDCOrganization
                    inner join Organization on Organization.OrganizationID = SDCOrganization.OrganizationID
                    left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {_requestRepository.LanguageId}
                    where SDCOrganization.SDCID = {channelId} and Organization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                result = dBHelper.GetQueryList(query, ref organizations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetSalesDistributionChannelCustomers(int channelId, ref List<SimpleCustomerModel> customers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder orgAccess = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccess.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess); 
                }
                DBHelper<SimpleCustomerModel> dBHelper = new DBHelper<SimpleCustomerModel>();
                string query = $@"select distinct SDCCustomer.CustomerID, SDCCustomer.OutletID,
                IsNull( Customer.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description  , '--') as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description  , '--') as OutletCodeName
                from SDCCustomer
                inner join Customer on Customer.CustomerID = SDCCustomer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = SDCCustomer.CustomerID and CustomerOutlet.OutletID = SDCCustomer.OutletID
                {orgAccess}
                left join CustomerLanguage on CustomerLanguage.CustomerID =  SDCCustomer.CustomerID and CustomerLanguage.LanguageID = {_requestRepository.LanguageId}
                left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = SDCCustomer.CustomerID and 
                CustomerOutletLanguage.OutletID = SDCCustomer.OutletID and CustomerOutletLanguage.LanguageID = {_requestRepository.LanguageId}
                where SDCCustomer.SDCID = {channelId}";
                result = dBHelper.GetQueryList(query, ref customers);
            }
            catch (Exception ex)
            {
           