﻿using Org.BouncyCastle.Crypto;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Runtime.Intrinsics.X86;
using System.Text;

namespace Sonic.Web.Core
{ 
    public class FQAsManager
    {
        private readonly IRequestRepository _requestRepository;
        public FQAsManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public GlobalErrors GetFQASList(ref SharedTableResult<FQAsModel> fQAsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<FQAsModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<FQAsModel>();
                List<FQAsModel> fQAs = new List<FQAsModel>();
                List<FQAsModel> allFQAs = new List<FQAsModel>();
                List<FQAsTextLanguage> descriptions = new List<FQAsTextLanguage>();

                dbHelper.BeginTransaction();

                string mainQuery = string.Format(@" FROM CustomerAppFAQs");

                string itemsQuery = string.Format(@"select IsNull(QuestionDesc,'---') Question, IsNull(AnswerDesc,'--') Answer, IsNull(FqaId,0) ID, LanguageId {0} where LanguageId = {1}",
                       mainQuery, _requestRepository.LanguageId);

                string allItemsQuery = string.Format(@"select IsNull(QuestionDesc,'---') Question, IsNull(AnswerDesc,'--') Answer, IsNull(FqaId,0) ID, LanguageId {0}",
                       mainQuery, _requestRepository.LanguageId);

                string countQuery = string.Format(@"select IsNull(Count(*),0) {0} where LanguageId = {1}",
                       mainQuery, _requestRepository.LanguageId);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);

                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    fQAsList.TotalItems = int.Parse(objField.ToString().Trim());

                    if (fQAsList.TotalItems <= 0)
                    {
                        fQAsList.Data = fQAs;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                result = dbHelper.GetQueryList(itemsQuery, ref fQAs);
                var allItems = dbHelper.GetQueryList(allItemsQuery, ref allFQAs);

                var queList = new List<FQAsTextLanguage>();
                var ansList = new List<FQAsTextLanguage>();

                foreach (FQAsModel fqaLan in fQAs)
                {
                    foreach (FQAsModel fqa in allFQAs)
                    {
                        if (fqaLan.Id == fqa.Id)
                        {
                            var questionDescription = new FQAsTextLanguage { Description = fqa.Question, LanguageId = fqa.LanguageId };
                            var answerDescription = new FQAsTextLanguage { Description = fqa.Answer, LanguageId = fqa.LanguageId };

                            if (fqaLan.QuestionDescriptionLanguages == null)
                            {
                                fqaLan.QuestionDescriptionLanguages = new List<FQAsTextLanguage>();
                            }
                            if (fqaLan.AnswerDescriptionLanguages == null)
                            {
                                fqaLan.AnswerDescriptionLanguages = new List<FQAsTextLanguage>();
                            }
                            fqaLan.QuestionDescriptionLanguages.Add(questionDescription);
                            fqaLan.AnswerDescriptionLanguages.Add(answerDescription);
                        }
                    }

                }

                fQAsList.Data = fQAs;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertFQA(List<FQAsModel> fQAs, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            DBHelper<FQAsModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<FQAsModel>();
                query = string.Format(@"Delete From CustomerAppFAQs;");
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = "";

                    if (fQAs != null)
                    {
                        foreach (var fQA in fQAs)
                        {
                            if (fQA.QuestionDescriptionLanguages != null)
                            {
                                        foreach (var Question in fQA.QuestionDescriptionLanguages)
                                        {
                                            foreach (var Answer in fQA.AnswerDescriptionLanguages)
                                            {
                                                if (Question.LanguageId == Answer.LanguageId)
                                                {
                                                   if (!(Question.Description == null || Question.Description == "") && !(Answer.Description == null || Answer.Description == ""))
                                                    {
                                                        query = string.Format(@"Insert Into CustomerAppFAQs values ({0},{1},'{2}','{3}')",
                                                                              fQA.Id, Question.LanguageId, Question.Description, Answer.Description);

                                                        result = dbHelper.ExecuteNonQuery(query);
                                                        if (result == GlobalErrors.Success)
                                                        {
                                                            continue;
                                                        }
                                                        else
                                                        {
                                                            return GlobalErrors.Error;
                                                        }
                                                    }
                                                }

                                            }
                                        }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
    }
}
