﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class DashboardManager
    {
        private readonly IRequestRepository _requestRepository;

        public DashboardManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetEndOfDayReoports(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select Report.ReportID ID,  Report.CategoryID , ReportLanguage.Description Name  , ATCategoryLanguage.Description CategoryName  
                FROM Report
                INNER JOIN ATCategory on ATCategory.CategoryID  = Report.CategoryID AND ATCategory.CategoryTypeID = {2}
                INNER JOIN ReportLanguage ON ReportLanguage.ReportID = Report.ReportID AND  ReportLanguage.LanguageID = 1 --{0}
                INNER JOIN ATSecurityPrivileges ON ATSecurityPrivileges.CategoryID = Report.CategoryID AND ATSecurityPrivileges.UserID = {1}
                INNER JOIN ATCategoryLanguage ON  ATCategoryLanguage.CategoryID = Report.CategoryID AND ATCategoryLanguage.LanguageID = 1 --{0}", _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId , (int) ATCategoryModeType.EndOfDay);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }
        public int GetOperationDashboardId(DashboardOperations operation)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            int id = -1;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"Select DashboardID FROM DashboardWebOperation WHERE OperationID = {0}", operation.GetHashCode());
                object field = new object();
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    id = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return id;
        }
        public GlobalErrors GetEndOfDayDashboards(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select Dashboard.DashboardID ID,  Dashboard.CategoryID , DashboardLanguage.Description Name  , ATCategoryLanguage.Description CategoryName  
                FROM Dashboard
                INNER JOIN ATCategory on ATCategory.CategoryID  = Dashboard.CategoryID AND ATCategory.CategoryTypeID = {2}
                INNER JOIN DashboardLanguage ON DashboardLanguage.DashboardID = Dashboard.DashboardID AND  DashboardLanguage.LanguageID = 1 --{0}
                INNER JOIN ATSecurityPrivileges ON ATSecurityPrivileges.CategoryID = Dashboard.CategoryID AND ATSecurityPrivileges.UserID = {1}
                INNER JOIN ATCategoryLanguage ON  ATCategoryLanguage.CategoryID = Dashboard.CategoryID AND ATCategoryLanguage.LanguageID = 1 --{0}", _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId, (int)ATCategoryModeType.EndOfDay);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }
        public GlobalErrors GetEndorsementDashboards(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select Dashboard.DashboardID ID,  Dashboard.CategoryID ,  Dashboard.CategorySubTypeID, DashboardLanguage.Description Name  , ATCategoryLanguage.Description CategoryName  
                FROM Dashboard
                INNER JOIN ATCategory on ATCategory.CategoryID  = Dashboard.CategoryID AND ATCategory.CategoryTypeID = {2}
                INNER JOIN DashboardLanguage ON DashboardLanguage.DashboardID = Dashboard.DashboardID AND  DashboardLanguage.LanguageID = 1 --{0}
                INNER JOIN ATSecurityPrivileges ON ATSecurityPrivileges.CategoryID = Dashboard.CategoryID AND ATSecurityPrivileges.UserID = {1}
                INNER JOIN ATCategoryLanguage ON  ATCategoryLanguage.CategoryID = Dashboard.CategoryID AND ATCategoryLanguage.LanguageID = 1 --{0}", _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId, (int)ATCategoryModeType.RouteEndorsement);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }

        public GlobalErrors GetAvailableReport(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select DISTINCT Report.ReportID ID,  Report.CategoryID , ReportLanguage.Description Name  , ATCategoryLanguage.Description CategoryName  
                FROM Report
                INNER JOIN ATCategory on ATCategory.CategoryID  = Report.CategoryID AND (ATCategory.CategoryTypeID = {2} OR ATCategory.CategoryTypeID is NULL)
                left JOIN ReportLanguage ON ReportLanguage.ReportID = Report.ReportID AND  ReportLanguage.LanguageID = {0}
                INNER join (	
                select CategoryID from  ATSecurityPrivileges where ATSecurityPrivileges.UserID = {1} union 
                select CategoryID from ATSecurityGroupPrivileges 
                INNER JOIN OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = ATSecurityGroupPrivileges.SecurityGroupID AND OperatorSecurityGroup.OperatorID = {3}) 
                privilage on privilage.CategoryID = ATCategory.CategoryID
                left JOIN ATCategoryLanguage ON  ATCategoryLanguage.CategoryID = Report.CategoryID AND ATCategoryLanguage.LanguageID = {0}
                ORDER BY ATCategoryLanguage.Description, ReportLanguage.Description ", _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId , (int)ATCategoryModeType.General, _requestRepository.CurrentOperator.OperatorId);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }
        public GlobalErrors GetNotAdvancedReportsAvailable(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select distinct Report.*,Report.ReportID ID,Menu.MenuID,  Report.CategoryID , ReportLanguage.Description Name  
,OperatorPrivilege.MenuID,SecurityGroupPrivilege.MenuID,ParentMenu.MenuID  CategoryID ,ParentMenuLanguage.Description  CategoryName
                FROM Report
				inner join Menu on Report.FormName = Menu.FormName
	left outer join menu ParentMenu on ParentMenu.MenuID=menu.ParentMenuID 
				left outer join MenuLanguage ParentMenuLanguage on ParentMenu.MenuID=ParentMenuLanguage.MenuID and ParentMenuLanguage.LanguageID=1
				left outer join SecurityGroupPrivilege on SecurityGroupPrivilege.MenuID=Menu.MenuID and SecurityGroupPrivilege.SecurityGroupID in (select SecurityGroupID from OperatorSecurityGroup where OperatorID={0})
				left outer join OperatorPrivilege on OperatorPrivilege.MenuID=menu.MenuID 
				and OperatorPrivilege.OperatorID in ({0})
                INNER JOIN ReportLanguage ON ReportLanguage.ReportID = Report.ReportID AND  ReportLanguage.LanguageID = 1 
				where IsAdvanceReport=0 
				and (OperatorPrivilege.MenuID is not null or SecurityGroupPrivilege.MenuID is not null) 
                ORDER BY ParentMenuLanguage.Description, ReportLanguage.Description", _requestRepository.CurrentOperator.OperatorId);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }
        public GlobalErrors GetAvailableDashboard(ref List<Dashboard> data)
        {
            DBHelper<Dashboard> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select Dashboard.DashboardID ID,  Dashboard.CategoryID , DashboardLanguage.Description Name  , ATCategoryLanguage.Description CategoryName  ,Dashboard.ImageName ImageName
                FROM Dashboard
                INNER JOIN ATCategory on ATCategory.CategoryID  = Dashboard.CategoryID AND (ATCategory.CategoryTypeID = {2} OR ATCategory.CategoryTypeID is NULL)
                INNER JOIN DashboardLanguage ON DashboardLanguage.DashboardID = Dashboard.DashboardID AND  DashboardLanguage.LanguageID = {0}
                INNER JOIN ATSecurityPrivileges ON ATSecurityPrivileges.CategoryID = Dashboard.CategoryID AND ATSecurityPrivileges.UserID = {1}
                INNER JOIN ATCategoryLanguage ON  ATCategoryLanguage.CategoryID = Dashboard.CategoryID AND ATCategoryLanguage.LanguageID = {0}
                ORDER BY ATCategoryLanguage.Description, DashboardLanguage.Description", _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId, (int)ATCategoryModeType.General);
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }

        public string GenerateDashboardSignature(string rhId, string custId, string outId)
        {
            try
            {
                if (_requestRepository == null || _requestRepository.CurrentOperator == null)
                {
                    return string.Empty;
                }
                StringBuilder str = new StringBuilder();
                //Index 0 ID
                str.Append("{0}");
                str.Append(LocalUtilities.SplitCharacterDashboardQueryString.ToString());
                //Index 1 EmpID
                str.AppendFormat("{0}", _requestRepository.CurrentOperator.EmployeeId.ToString());
                str.Append(LocalUtilities.SplitCharacterDashboardQueryString.ToString());
                //Index 2 RHID
                str.AppendFormat("{0}", rhId);
                str.Append(LocalUtilities.SplitCharacterDashboardQueryString.ToString());
                //Index 3 CustID
                str.AppendFormat("{0}", custId);
                str.Append(LocalUtilities.SplitCharacterDashboardQueryString.ToString());
                //Index 4 OutID
                str.AppendFormat("{0}", outId);
                str.Append(LocalUtilities.SplitCharacterDashboardQueryString.ToString());
                //Index 5 LangID
                str.AppendFormat("{0}", _requestRepository.LanguageId.ToString());
                return str.ToString();
            }
            catch (Exception ex)
            {
                return string.Empty;
            }
        }
    }
}
