﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class DocumentSequenceManager
    {
        private readonly IRequestRepository _requestRepository;
        public DocumentSequenceManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public string GetMaxDocumentSequence(int employeeID, DocumentTypes documentType, int divisionID,int sdcId =-1)
        {
            return GetMaxDocumentSequence(null, employeeID, documentType, divisionID, sdcId);
        }

        public string GetMaxDocumentSequence(DBHelper<int> dbHelper, int employeeID, DocumentTypes documentType, int selectedDivisionId,int sdcId = -1)
        {
            return GetMaxDocumentSequence(dbHelper, employeeID, documentType, selectedDivisionId, 1, sdcId);
        }
        public string GetMaxDocumentSequence(DBHelper<int> dbHelper, int employeeID, DocumentTypes documentType, int selectedDivisionId,int numberOfTrials,int sdcId = -1)
        {
            bool commitNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    commitNow = true;
                }
                string maxTransactionID = string.Empty;
                string fieldName = string.Empty;
                string query = string.Empty;
                string salesChannelCondition = string.Empty;
                switch (documentType)
                {
                    case DocumentTypes.Invoice:
                        fieldName = "MaxTransactionInvoiceID";
                        break;

                    case DocumentTypes.Return:
                        fieldName = "MaxTransactionReturnID";
                        break;

                    case DocumentTypes.Collection:
                        fieldName = "MaxTransactionPaymentID";
                        break;

                    case DocumentTypes.Order:
                        fieldName = "MaxTransactionOrderID";
                        break;

                    case DocumentTypes.WarhouseTransaction:
                        fieldName = "MaxWarehouseTransactionID";
                        break;

                    case DocumentTypes.CreditNote:
                        fieldName = "MaxTransactionCreditNote";
                        break;

                    case DocumentTypes.DebitNote:
                        fieldName = "MaxTransactionDebitNote";
                        break;

                    case DocumentTypes.Sample:
                        fieldName = "MaxTransactionSampleID";
                        break;

                    case DocumentTypes.AppliedPayment:
                        fieldName = "MaxAppliedPaymentID";
                        break;

                    case DocumentTypes.Settelment:
                        fieldName = "MaxSettelmentID";
                        break;

                    case DocumentTypes.OrderInvoice:
                        fieldName = "MaxOrderInvoiceID";
                        break;

                    case DocumentTypes.OrgCreditNote:
                        fieldName = "MaxOrgCreditNote";
                        break;

                    case DocumentTypes.OrgDebitNote:
                        fieldName = "MaxOrgDebitNote";
                        break;

                    case DocumentTypes.ReturnOrder:
                        fieldName = "MaxReturnOrderID";
                        break;

                    case DocumentTypes.PurchaseOrder:
                        fieldName = "MaxPurchaseOrderID";
                        break;
                    case DocumentTypes.NewCustomerCode:
                        fieldName = "MaxNewCustomerCodeID";
                        break;
                    case DocumentTypes.ICashReversal:
                        fieldName = "MaxICashReversalTransactionID";
                        break;
                    default:
                        break;
                }
                object scalerResult = null;
                string numericPart = string.Empty;
                string charactersPart = string.Empty;
                long newSequence;
                int numLength;
                int divisionID = -1;
                if (_requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                {
                    divisionID = selectedDivisionId;
                }
                if(_requestRepository.Configurations.EnableSalesDistributionChannel && _requestRepository.Configurations.ApplyDocumentSequencePerSalesChannel && documentType == DocumentTypes.Invoice)
                {
                    if(sdcId != -1)
                    {
                        salesChannelCondition = string.Format(@" and SalesChannelID= {0} ", sdcId);
                    }
                    query = string.Format(@"select {0} from SalesChannelDocumentSequence (nolock) where EmployeeID= {1} AND DivisionID = {2} {3}", fieldName, employeeID, divisionID, salesChannelCondition);
                }
                else
                {
                    query = string.Format(@"select {0} from DocumentSequence (nolock) where EmployeeID= {1} AND DivisionID = {2}", fieldName, employeeID, divisionID);
                }
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref scalerResult);
                //result = GlobalErrors.Error;
                if (result == GlobalErrors.Success)
                {
                    if (scalerResult != null && !string.IsNullOrEmpty(scalerResult.ToString()))
                    {
                        GetSequenceNumberFormat(scalerResult.ToString(), ref charactersPart, ref numericPart);
                        numLength = numericPart.Length;
                        if ((documentType == DocumentTypes.CreditNote) || (documentType == DocumentTypes.DebitNote) || (documentType == DocumentTypes.WarhouseTransaction))//&& !Configuration.LoadAffectStock))
                        {
                            newSequence = (Convert.ToInt64(numericPart) + 1) % 2 == 0 ? (Convert.ToInt64(numericPart) + 2) : (Convert.ToInt64(numericPart) + 1);
                        }
                        else
                        {
                            newSequence = long.Parse(numericPart) + 1;
                        }
                        numericPart = newSequence.ToString().PadLeft(numLength, '0');
                        maxTransactionID = charactersPart + numericPart;
                    }
                }
                else
                {
                    numberOfTrials--;
                    if (numberOfTrials > 0)
                    {
                        System.Threading.Thread.Sleep(1000);
                        GetMaxDocumentSequence(dbHelper, employeeID, documentType, selectedDivisionId, numberOfTrials);
                    }
                }
                return maxTransactionID;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return string.Empty;
            }
            finally
            {
                if (dbHelper != null && commitNow)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public GlobalErrors GetCurrentDocumentSequenceOverDivisions(DBHelper<TransactionDivisionModel> dbHelper, int employeeID, DocumentTypes documentType, string selectedDivisionIds, ref List<TransactionDivisionModel> maxIdsPerDivision)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool commitNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<TransactionDivisionModel>();
                    commitNow = true;
                }

                string maxTransactionID = string.Empty;
                string fieldName = string.Empty;
                switch (documentType)
                {
                    case DocumentTypes.Invoice:
                        fieldName = "MaxTransactionInvoiceID";
                        break;

                    case DocumentTypes.Return:
                        fieldName = "MaxTransactionReturnID";
                        break;

                    case DocumentTypes.Collection:
                        fieldName = "MaxTransactionPaymentID";
                        break;

                    case DocumentTypes.Order:
                        fieldName = "MaxTransactionOrderID";
                        break;

                    case DocumentTypes.WarhouseTransaction:
                        fieldName = "MaxWarehouseTransactionID";
                        break;

                    case DocumentTypes.CreditNote:
                        fieldName = "MaxTransactionCreditNote";
                        break;

                    case DocumentTypes.DebitNote:
                        fieldName = "MaxTransactionDebitNote";
                        break;

                    case DocumentTypes.Sample:
                        fieldName = "MaxTransactionSampleID";
                        break;

                    case DocumentTypes.AppliedPayment:
                        fieldName = "MaxAppliedPaymentID";
                        break;

                    case DocumentTypes.Settelment:
                        fieldName = "MaxSettelmentID";
                        break;

                    case DocumentTypes.OrderInvoice:
                        fieldName = "MaxOrderInvoiceID";
                        break;

                    case DocumentTypes.OrgCreditNote:
                        fieldName = "MaxOrgCreditNote";
                        break;

                    case DocumentTypes.OrgDebitNote:
                        fieldName = "MaxOrgDebitNote";
                        break;

                    case DocumentTypes.ReturnOrder:
                        fieldName = "MaxReturnOrderID";
                        break;

                    case DocumentTypes.PurchaseOrder:
                        fieldName = "MaxPurchaseOrderID";
                        break;
                    case DocumentTypes.NewCustomerCode:
                        fieldName = "MaxNewCustomerCodeID";
                        break;
                    default:
                        break;
                }
                string divisionIds = "-1";
                if (_requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                {
                    divisionIds = selectedDivisionIds;
                }
                string query = string.Format(@"select {0} as TransactionId from DocumentSequence where EmployeeID= {1} AND DivisionID in ({2})",
                fieldName, employeeID, divisionIds);
                result = dbHelper.GetQueryList(query, ref maxIdsPerDivision);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null && commitNow)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public string GetNextDocumentSequence(DocumentTypes transactionType, string oldDocumentSequence)
        {
            string newDocumentSequence = string.Empty;
            try
            {
                string numericPart = string.Empty;
                string charsPart = string.Empty;
                GetSequenceNumberFormat(oldDocumentSequence, ref charsPart, ref numericPart);
                long number = Convert.ToInt64(numericPart);
                if ((transactionType == DocumentTypes.CreditNote) || (transactionType == DocumentTypes.DebitNote) || (transactionType == DocumentTypes.WarhouseTransaction))
                {
                    number = (number + 1) % 2 == 0 ? (number + 2) : (number + 1);
                }
                else
                {
                    number = number + 1;
                }
                newDocumentSequence = string.Format("{0}{1}", charsPart, number.ToString().PadLeft(numericPart.Length, '0'));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return newDocumentSequence;
        }
        public string GetNextDocumentSequence(string oldDocumentSequence, int increamentBY)
        {
            string newDocumentSequence = string.Empty;
            try
            {
                string numericPart = string.Empty;
                string charsPart = string.Empty;
                GetSequenceNumberFormat(oldDocumentSequence, ref charsPart, ref numericPart);
                decimal number = decimal.Parse(numericPart);
                number = number + increamentBY;
                newDocumentSequence = string.Format("{0}{1}", charsPart, number.ToString().PadLeft(numericPart.Length, '0'));
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return newDocumentSequence;
        }

        public static void GetSequenceNumberFormat(string maxTransactionID, ref string charactersPart, ref string numericPart)
        {
            try
            {
                char[] valueChars = new char[maxTransactionID.Length];
                valueChars = maxTransactionID.ToCharArray();
                for (int i = valueChars.Length - 1; i >= 0; i--)
                {
                    if (!char.IsNumber(valueChars[i]))
                    {
                        charactersPart = maxTransactionID.Substring(0, i + 1);
                        numericPart = maxTransactionID.Substring(i + 1);
                        return;
                    }
                }
                numericPart = maxTransactionID;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public GlobalErrors UpdateMaxTransactionID(DocumentTypes transactionType, string MaxDocumentID, long employeeID, int selectedDivisionId,int sdcId = -1)
        {
            return UpdateMaxTransactionID(null, transactionType, MaxDocumentID, employeeID, selectedDivisionId, sdcId);
        }

        public GlobalErrors UpdateMaxTransactionID(DBHelper<int> dbHelper, DocumentTypes transactionType, string MaxDocumentID, long employeeID, int selectedDivisionId, int sdcId = -1)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                string fieldName = string.Empty;
                string salesChannelCondition = string.Empty;
                switch (transactionType)
                {
                    case DocumentTypes.Invoice:
                        fieldName = "MaxTransactionInvoiceID";
                        break;

                    case DocumentTypes.Return:
                        fieldName = "MaxTransactionReturnID";
                        break;

                    case DocumentTypes.Collection:
                        fieldName = "MaxTransactionPaymentID";
                        break;

                    case DocumentTypes.Order:
                        fieldName = "MaxTransactionOrderID";
                        break;

                    case DocumentTypes.WarhouseTransaction:
                        fieldName = "MaxWarehouseTransactionID";
                        break;

                    case DocumentTypes.CreditNote:
                        fieldName = "MaxTransactionCreditNote";
                        break;

                    case DocumentTypes.DebitNote:
                        fieldName = "MaxTransactionDebitNote";
                        break;

                    case DocumentTypes.Sample:
                        fieldName = "MaxTransactionSampleID";
                        break;

                    case DocumentTypes.AppliedPayment:
                        fieldName = "MaxAppliedPaymentID";
                        break;

                    case DocumentTypes.Settelment:
                        fieldName = "MaxSettelmentID";
                        break;

                    case DocumentTypes.OrderInvoice:
                        fieldName = "MaxOrderInvoiceID";
                        break;

                    case DocumentTypes.ReturnOrder:
                        fieldName = "MAXReturnOrderID";
                        break;

                    case DocumentTypes.PurchaseOrder:
                        fieldName = "MAXPurchaseOrderID";
                        break;
                    case DocumentTypes.NewCustomerCode:
                        fieldName = "MaxNewCustomerCodeID";
                        break;
                    case DocumentTypes.ICashReversal:
                        fieldName = "MaxICashReversalTransactionID";
                        break;
                    default:
                        break;
                }
                string sqlStatement;
                int divisionID = -1;
                if (_requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                {
                    divisionID = selectedDivisionId;
                }
                if (_requestRepository.Configurations.EnableSalesDistributionChannel && _requestRepository.Configurations.ApplyDocumentSequencePerSalesChannel && transactionType == DocumentTypes.Invoice)
                {
                    if (sdcId != -1)
                    {
                        salesChannelCondition = string.Format(@" and SalesChannelID= {0}", sdcId);
                    }
                    sqlStatement = string.Format(@" UPDATE SalesChannelDocumentSequence SET {0}= '{1}' where EmployeeID= {2} AND DivisionID = {3} {4}", fieldName, MaxDocumentID, employeeID, divisionID, salesChannelCondition);
                }
                else
                {
                    sqlStatement = string.Format(" UPDATE DocumentSequence SET {0}= '{1}' WHERE (EmployeeID= {2} AND DivisionID = {3})", fieldName, MaxDocumentID, employeeID, divisionID);
                }
                result = dbHelper.ExecuteNonQuery(sqlStatement.ToString());
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetDocumentSequence(int employeeID, int routeHistoryID, ref StringBuilder sqlStatment)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string SalesID = string.Empty;
                string ReturnID = string.Empty;
                string CreditNoteID = string.Empty;
                string DebitNoteID = string.Empty;
                string SalesOrderID = string.Empty, ReturnOrderID = string.Empty;
                string CustomerPaymentID = string.Empty, AppliedPaymentID = string.Empty;
                string WarehouseTransactionID = string.Empty;
                DocumentTransaction transaction = new DocumentTransaction();
                DocumentOrder order = new DocumentOrder();
                PaymentModel payment = new PaymentModel();
                // Get Selected route max transaction ID's
                result = GetMaxTransactionDocumentSequence(routeHistoryID, ref transaction);
                if (result == GlobalErrors.Success)
                {
                    if (transaction != null)
                    {
                        SalesID = transaction.SalesID;
                        ReturnID = transaction.ReturnID;
                        CreditNoteID = transaction.CreditNoteID;
                        DebitNoteID = transaction.DebitNoteID;
                    }
                    //Get Selected route max order ID's
                    result = GetMaxOrderDocumentSequence(routeHistoryID, ref order);
                    if (result == GlobalErrors.Success)
                    {
                        if (order != null)
                        {
                            SalesOrderID = order.SalesOrderID;
                            ReturnOrderID = order.ReturnOrderID;
                        }
                        // Get Selected route max payment ID's
                        result = GetMaxPaymentDocumentSequence(routeHistoryID, ref payment);
                        if (result == GlobalErrors.Success)
                        {
                            if (payment != null)
                            {
                                CustomerPaymentID = payment.CustomerPaymentId;
                                AppliedPaymentID = payment.AppliedPaymentId;
                            }
                        }
                    }
                }
                // Get Selected route Warehouse Transaction max order ID's
                if (result == GlobalErrors.Success)
                {
                    object field = null;
                    result = GetMaxWarehouseTransactionDocumentSequence(routeHistoryID, ref field);
                    if (field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        WarehouseTransactionID = field.ToString();
                    }
                }
                // Get current employee document sequence and compare it with selected route sequence to update DocumentSequence table with max IDs
                if (result == GlobalErrors.Success)
                {
                    DocumentSequence document = new DocumentSequence();
                    result = GetEmployeeMaxDocumentSequenceData(employeeID, -1, ref document);
                    if (result == GlobalErrors.Success)
                    {
                        if (document != null)
                        {
                            sqlStatment = new StringBuilder();
                            sqlStatment.Append(@" UPDATE DocumentSequence SET");
                            if (!string.IsNullOrEmpty(SalesID))
                                sqlStatment.AppendFormat(@" MaxTransactionInvoiceID = '{0}',", SalesID);
                            if (!string.IsNullOrEmpty(ReturnID))
                                sqlStatment.AppendFormat(@" MaxTransactionReturnID = '{0}',", ReturnID);
                            if (!string.IsNullOrEmpty(CreditNoteID))
                                sqlStatment.AppendFormat(@" MaxTransactionCreditNote = '{0}',", CreditNoteID);
                            if (!string.IsNullOrEmpty(DebitNoteID))
                                sqlStatment.AppendFormat(@" MaxTransactionDebitNote = '{0}',", DebitNoteID);
                            if (!string.IsNullOrEmpty(SalesOrderID))
                                sqlStatment.AppendFormat(@" MaxTransactionOrderID = '{0}',", SalesOrderID);
                            if (!string.IsNullOrEmpty(ReturnOrderID))
                                sqlStatment.AppendFormat(@" MaxReturnOrderID = '{0}',", ReturnOrderID);
                            if (!string.IsNullOrEmpty(CustomerPaymentID))
                                sqlStatment.AppendFormat(@" MaxTransactionPaymentID = '{0}',", CustomerPaymentID);
                            if (!string.IsNullOrEmpty(AppliedPaymentID))
                                sqlStatment.AppendFormat(@" MaxAppliedPaymentID = '{0}',", AppliedPaymentID);
                            if (!string.IsNullOrEmpty(WarehouseTransactionID))
                                sqlStatment.AppendFormat(@" MaxWarehouseTransactionID = '{0}'", WarehouseTransactionID);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors UpdateDocumentSequenceAfterCancelUploadedRoute(StringBuilder sqlStatment,int employeeID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (!sqlStatment.ToString().EndsWith("SET"))
                {
                    string query = sqlStatment.ToString().TrimEnd(',');
                    query += string.Format(@" Where DocumentSequence.EmployeeID = {0} And DocumentSequence.DivisionID = {1}", employeeID, -1);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                else
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetMaxTransactionDocumentSequence(int routeHistoryID, ref DocumentTransaction transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DocumentTransaction> dBHelper = new DBHelper<DocumentTransaction>();
            try
            {
                string documentSeq = string.Format(@"Select max(SalesTran.TransactionID) SalesID, max(ReturnTran.TransactionID) ReturnID, max(CreditNoteTran.TransactionID) CreditNoteID, max(DebitNoteTran.TransactionID) DebitNoteID
                From [Transaction]
                left join [Transaction] SalesTran on SalesTran.TransactionID = [Transaction].TransactionID and SalesTran.TransactionTypeID in (1,3)
                left join [Transaction] ReturnTran on ReturnTran.TransactionID = [Transaction].TransactionID and ReturnTran.TransactionTypeID in (2,4)
                left join [Transaction] CreditNoteTran on CreditNoteTran.TransactionID = [Transaction].TransactionID and CreditNoteTran.TransactionTypeID = 5
                left join [Transaction] DebitNoteTran on DebitNoteTran.TransactionID = [Transaction].TransactionID and DebitNoteTran.TransactionTypeID = 6
                where [Transaction].RouteHistoryID = {0}", routeHistoryID);
                result = dBHelper.GetQuerySingle(documentSeq, ref transaction);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetMaxOrderDocumentSequence(int routeHistoryID, ref DocumentOrder order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DocumentOrder> dBHelper = new DBHelper<DocumentOrder>();
            try
            {
                string documentSeq = string.Format(@"select  max(sales.OrderID) SalesOrderID, max(ReturnOrder.OrderID) ReturnOrderID 
                from SalesOrder
                left join SalesOrder sales on sales.OrderID = SalesOrder.OrderID and sales.OrderTypeID in (1,3)
                left join SalesOrder ReturnOrder on ReturnOrder.OrderID = SalesOrder.OrderID and ReturnOrder.OrderTypeID in (2,4)
                where SalesOrder.RouteHistoryID = {0}", routeHistoryID);
                result = dBHelper.GetQuerySingle(documentSeq, ref order);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetMaxPaymentDocumentSequence(int routeHistoryID, ref PaymentModel payment)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<PaymentModel> dBHelper = new DBHelper<PaymentModel>();

            try
            {
                string documentSeq = string.Format(@"select Max(payments.CustomerPaymentID) CustomerPaymentID, MAX(payments.AppliedPaymentID)AppliedPaymentID 
                from 
                (select Max(CustomerPaymentID) CustomerPaymentID, Max(AppliedPaymentID)AppliedPaymentID from CustomerPayment
                where CustomerPayment.RouteHistoryID = {0}
                union 
                select Max(CustomerPaymentID), null AppliedPaymentID  from CustomerUnallocatedPayment
                where CustomerUnallocatedPayment.RouteHistoryID = {0})payments", routeHistoryID);
                result = dBHelper.GetQuerySingle( documentSeq, ref payment);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetMaxWarehouseTransactionDocumentSequence(int routeHistoryID, ref object field)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                string documentSeq = string.Format(@"select Max(WarehouseTransaction.TransactionID) WarehouseTransactionID
                from WarehouseTransaction
                Where WarehouseTransaction.RouteHistoryID = {0}", routeHistoryID);
                result = dBHelper.ExecuteScalar(documentSeq, ref field);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetEmployeeMaxDocumentSequenceData(int employeeID, int divisionID, ref DocumentSequence document)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DocumentSequence> dBHelper = new DBHelper<DocumentSequence>();
            try
            {
                string sqlStatement = string.Format("SELECT * FROM DocumentSequence WHERE (EmployeeID = {0} AND DivisionID = {1})", employeeID, divisionID);
                result = dBHelper.GetQuerySingle(sqlStatement, ref document);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
    }
}