﻿using Newtonsoft.Json;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;
using System.Text;
using ZXing;

namespace Sonic.Web.Core
{
    public class DynamicReportManager
    {
        private readonly IRequestRepository _requestRepository;
        public DynamicReportManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetReportFilters(int reportId, ref List<ReportFilterModel> data)
        {
            DBHelper<ReportFilterModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ReportFilterModel>();
                string query = string.Format(@"Select ReportFilterParameter.ReportID, 
                Case When ReportFilter.ReportFilterTypeID in ({2},{3},{4},{7},{8},{9}) Then 1 else 0 end as IsDateFilter,
                Case When ReportFilter.ReportFilterTypeID in ({5},{6}) Then 1 else 0 end as IsDateTimeFilter,
                Case When ReportFilter.ReportFilterTypeID in ({3},{4},{5},{6},{8},{9}) Then 1 else 0 end as AllowDisableDateFilter,
                ReportFilter.ReportFilterID, 
                ReportFilter.ReportFilterTypeID, 
                ReportFilter.QueryString, 
                ReportFilter.DisplayMember1, 
                ReportFilter.DisplayMember2, 
                ReportFilter.ValueMember, 
                ReportFilterLanguage.Description, 
                Parameter.ParameterName, 
                Parameter.ReportParameterID, 
                ParameterLanguage.ReportValue1, 
                ParameterLanguage.ReportValue2, 
                ParameterLanguage.Description As ParameterDescription,
				Report.FileName,
                ReportFilterParameter.SequenceID 
                From ReportFilter 
                Inner Join ReportFilterParameter On ReportFilter.ReportFilterID = ReportFilterParameter.ReportFilterID 
                Inner Join ReportFilterLanguage On ReportFilter.ReportFilterID = ReportFilterLanguage.ReportFilterID 
                Inner Join Parameter On ReportFilterParameter.ReportParameterID = Parameter.ReportParameterID 
                Inner Join ParameterLanguage On ReportFilterParameter.ReportParameterID = ParameterLanguage.ReportParameterID 
				Inner Join Report On Report.ReportID = ReportFilterParameter.ReportID
                where ReportFilterParameter.ReportID = {0} and ReportFilterLanguage.LanguageID = {1} and ParameterLanguage.LanguageID = {1}
                Order By SequenceID, ReportFilterParameter.ReportFilterID",
                reportId, //0
                _requestRepository.LanguageId, //1
                ReportFilterTypes.Date.GetHashCode(), //2
                ReportFilterTypes.Date_Min.GetHashCode(), //3
                ReportFilterTypes.Date_Max.GetHashCode(), //4
                ReportFilterTypes.DateTime_Min.GetHashCode(), //5
                ReportFilterTypes.DateTime_Max.GetHashCode(), //6
                ReportFilterTypes.NumericDate.GetHashCode(), //7
                ReportFilterTypes.NumericDate_Min.GetHashCode(), //8
                ReportFilterTypes.NumericDate_Max.GetHashCode() //9
                );
                result = dBHelper.GetQueryList(query, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            return result;
        }
        public GlobalErrors FillFilterDataSource(string controlQuery, ref DataTable dt)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<dynamic> dbHelper = new DBHelper<dynamic>();
                result = dbHelper.GetQueryDataTable(controlQuery, ref dt);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReportFilterQuery(ReportFilterModel filter, ref string queryString)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"Select ReportFilter.QueryString From ReportFilter Where ReportFilterID = {0}",
                filter.ReportFilterId
                );
                result = dBHelper.GetQuerySingle(query, ref queryString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOriginalReportQuery(int reportId, ref string queryString , int languageId)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"Select ReportLanguage.QueryString From ReportLanguage Where ReportId = {0} And LanguageId = {1}",
                reportId,
                languageId 
                );
                result = dBHelper.GetQuerySingle(query, ref queryString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveTempReportQuery(ref string uniqueIdentifier, DynamicReportModel report)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<string> selectedValues = new List<string>();
                report.ReportFilters.ForEach(x => {
                    if(!(x.Disabled && (x.IsDateFilter || x.IsDateTimeFilter)))
                    {
                        selectedValues.Add(x.ParameterDescription + "~*~" + x.SelectedText);
                    }
                });

                string filtersData = string.Join("~@~", selectedValues);
                result = SaveTempReport(ref uniqueIdentifier, report, filtersData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveTempReport(ref string uniqueIdentifier, DynamicReportModel report, string filtersData)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<string>();
                var value = Guid.NewGuid();
                uniqueIdentifier = value.ToString();

                string query = string.Format("Insert into TempReportQuery (ID, ReportQuery, CreatedDate, ReportName, ReportId, ReportFilters, LanguageId) Values ('{0}','{1}',{2},'{3}',{4},'{5}',{6})",
                uniqueIdentifier, report.QueryString.Replace("'", "''"), LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), report.ReportName, report.ReportId, filtersData, _requestRepository.LanguageId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region [Report Schedule]
        public GlobalErrors GetReportScheduledToday(ref List<ReportScheduleModel> reportSchedule)
        {
            DBHelper<ReportScheduleModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ReportScheduleModel>();
                string query = string.Format(@"SELECT TimeToRun, ScheduleID, PeriodTypeID, SendAtFirstDayOfNextPeriod FROM ReportSchedule
		                                       WHERE CAST(TimeToRun AS DATE) = {0};", LocalUtilities.ParseDateToSQLString(DateTime.Now));
                result = dBHelper.GetQueryList(query, ref reportSchedule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                reportSchedule = null;
            }
            return result;
        }
        public GlobalErrors UpdateNewTimeToRun(ref ReportScheduleModel reportSchedule , DBHelper<int> dBHelper , bool ServiceRunned , string filledPrimaryKeyCondition = "")
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                bool disposeNow = false;
                string LastRunTime = string.Empty;
                string Condition = string.Empty;

                if (dBHelper == null) 
                {
                    dBHelper = new DBHelper<int>();
                    disposeNow = true;
                }
                if (ServiceRunned)
                {
                    LastRunTime = $@", LastRunTime = {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}";
                    Condition = $@"ScheduleID = {reportSchedule.ScheduleId}";
                }
                else
                {
                    Condition = $@"{filledPrimaryKeyCondition}";
                }
                string query = string.Format(@"Update ReportSchedule Set TimeToRun = {0} {2} WHERE {1}", LocalUtilities.ParseDateAndTimeToSQL(reportSchedule.TimeToRun) , Condition, LastRunTime);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PopulateScheduledReportsFilter(ref List<ReportFilterModel> reportFilters, int reportId)
        {
            DBHelper<ReportFilterModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ReportFilterModel>();
                string query = string.Format(@"SELECT ScheduleID , ReportID , ReportFilterID , ReportParameterID , FilterSelectedValue SelectedValue , ReportScheduleAssignmentID
				from ReportScheduleAssignmentDetails where ReportID = {0}", reportId);
                result = dBHelper.GetQueryList(query, ref reportFilters);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                reportFilters = null;
            }
            return result;
        }
        public GlobalErrors PopulateScheduledReports(ref List<ReportScheduleModel> reportSchedule , int reportId)
        {
            DBHelper<ReportScheduleModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ReportScheduleModel>();
                string query = string.Format(@"	Select ReportSchedule.ScheduleID , ReportScheduleAssignment.ReportScheduleAssignmentID , ReportSchedulePeriodTypeLanguage.Description PeriodTypeDescription , ReportScheduleLanguage.Description ReportScheduleDescription from ReportScheduleLanguage 
				INNER JOIN ReportScheduleAssignment ON ReportScheduleLanguage.ScheduleID = ReportScheduleAssignment.ScheduleID
				INNER JOIN ReportSchedule ON ReportSchedule.ScheduleID = ReportScheduleLanguage.ScheduleID
				LEFT OUTER JOIN ReportSchedulePeriodTypeLanguage ON ReportSchedule.PeriodTypeID = ReportSchedulePeriodTypeLanguage.PeriodTypeID AND ReportSchedulePeriodTypeLanguage.LanguageID = {0}
				WHERE ReportScheduleLanguage.LanguageID = {0} AND ReportScheduleAssignment.ReportID = {1}", _requestRepository.LanguageId , reportId);
                result = dBHelper.GetQueryList(query, ref reportSchedule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                reportSchedule = null;
            }
            return result;
        }
        public GlobalErrors GetReportScheduleFilter(ref string HeaderFilter , int scheduleId , int ReportScheduleAssignmentId)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"	select HeaderFilterString HeaderFilter from ReportScheduleAssignment where ScheduleID = {0} AND ReportScheduleAssignmentId = {1}", scheduleId , ReportScheduleAssignmentId);
                result = dBHelper.GetQuerySingle(query, ref HeaderFilter);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                HeaderFilter = null;
            }
            return result;
        }
        public GlobalErrors DeleteReportScheduleAssignment(int scheduleId, int ReportScheduleAssignmentId , DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM ReportScheduleAssignment where ScheduleID = {0} AND ReportScheduleAssignmentID = {1}", scheduleId, ReportScheduleAssignmentId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteReportScheduleAssignmentDetails(int ReportScheduleAssignmentId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE from ReportScheduleAssignmentDetails WHERE ReportScheduleAssignmentID = {0}", ReportScheduleAssignmentId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReportSchedule(ref List<ReportScheduleModel> reportSchedule)
        {
            DBHelper<ReportScheduleModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ReportScheduleModel>();
                string query = string.Format(@"select ReportSchedule.ScheduleID , RSL.Description ReportScheduleDescription from ReportSchedule
                INNER JOIN ReportScheduleLanguage RSL ON RSL.ScheduleID = ReportSchedule.ScheduleID AND LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref reportSchedule);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                reportSchedule = null;
            }
            return result;
        }
        public GlobalErrors SaveReportScheduleAssignment(DynamicReportModel reportModel, string headerFilterJson)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DynamicReportModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<DynamicReportModel>();
                string query = string.Format(@"INSERT INTO ReportScheduleAssignment (ScheduleID , ReportID , HeaderFilterString) VALUES ({0},{1},'{2}')",
                reportModel.ScheduleId, reportModel.ReportId ,headerFilterJson);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareHeaderString(DynamicReportModel reportModel , ref string headerFilterJson)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var filteredFilters = new List<ReportFilterModel>(reportModel.ReportFilters);
                filteredFilters.RemoveAll(x => x.IsDateFilter || x.IsDateTimeFilter);
                if (filteredFilters != null && filteredFilters.Count > 0)
                {
                    for (int index = 0; index < filteredFilters.Count; index++)
                    {
                        var filter = filteredFilters[index];
                        bool isEven = index % 2 == 0;
                        reportModel.FiltersData.Add(new KeyValueModel(isEven, filter.ParameterDescription, filter.SelectedText));
                    }
                    result = GlobalErrors.Success;
                    headerFilterJson = JsonConvert.SerializeObject(reportModel.FiltersData);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveReportScheduleAssignmentDetails(DynamicReportModel reportModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DynamicReportModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<DynamicReportModel>();
                foreach (ReportFilterModel filterData in reportModel.ReportFilters)
                {
                    string query = string.Format(@"INSERT INTO ReportScheduleAssignmentDetails 
                       (ReportScheduleAssignmentID ,ReportID ,ScheduleID, ParameterName, ReportFilterID, ReportParameterID , FilterSelectedValue) VALUES 
                      ((SELECT MAX(ReportScheduleAssignmentID) FROM ReportScheduleAssignment WHERE ReportID = {0} AND ScheduleID = {1}),{0},{1},'{3}',
                      (SELECT ReportFilterID from ReportFilterParameter WHERE ReportID = {0} AND ReportParameterID = {2}),{2},'{4}')",
                    reportModel.ReportId, //0
                    reportModel.ScheduleId, //1
                    filterData.ReportParameterId, //2
                    filterData.ParameterName, //3
                    filterData.SelectedValue == null ? "" : filterData.SelectedValue // 4
                    );
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                    {
                        break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }              
        public GlobalErrors GetScheudleIdForEmployee(ref EODModel EODModel)
        {
            DBHelper<EODModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<EODModel>();
                string query = string.Format(@"
                SELECT ScheduleEmployee.ScheduleID, employee.EmployeeID , RouteHistory.ActualStart , RouteHistory.ActualEnd FROM employee
				INNER JOIN RouteHistory ON RouteHistory.EmployeeID = Employee.EmployeeID
				INNER JOIN ( 
				SELECT ScheduleID ,EmployeeId FROM ReportScheduleEmployeeEOD 
				UNION 
				SELECT ScheduleID , EmployeeOperator.EmployeeId
				FROM ReportScheduleSecurityGroupEOD 
				INNER JOIN OperatorSecurityGroup ON OperatorSecurityGroup.SecurityGroupID = ReportScheduleSecurityGroupEOD.SecurityGroupID 
				INNER JOIN EmployeeOperator ON EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID    
				) ScheduleEmployee ON ScheduleEmployee.EmployeeID = employee.EmployeeID
				WHERE ScheduleEmployee.EmployeeID = {0} AND RouteHistoryID = {1}", EODModel.EmployeeId , EODModel.RouteHistoryId);
                result = dBHelper.GetQuerySingle(query , ref EODModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public string GetEndOfDayEmployeeName(int EndOfDayEmployeeId , int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dBHelper = null;
            EmployeeModel employee = new EmployeeModel();
            try
            {
                dBHelper = new DBHelper<EmployeeModel>();
                string query = string.Format(@"select Description EmployeeName from EmployeeLanguage where EmployeeID = {0} AND LanguageID = {1}", EndOfDayEmployeeId , languageId);
                result = dBHelper.GetQuerySingle(query, ref employee);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return employee.EmployeeName;
        }
        public GlobalErrors GetInsertedScheduleProperties(ref ReportScheduleModel reportSchedule, DBHelper<int> dBHelper , string filledPrimaryKeyCondition)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool disposeNow = false;
            int PeriodTypeID = -1;
            int SendAtFirstDayOfNextPeriod = 0;
            int IsEndOfDaySubmission = 0;
            string query = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    disposeNow = true;
                }

                query = string.Format(@"SELECT IsEndOfDaySubmission FROM ReportSchedule WHERE {0}", filledPrimaryKeyCondition);
                result = dBHelper.GetQuerySingle(query, ref IsEndOfDaySubmission);
                reportSchedule.IsEndOfDaySubmission = (IsEndOfDaySubmission == 1);

                if (!reportSchedule.IsEndOfDaySubmission)
                {
                    query = string.Format(@"SELECT PeriodTypeID FROM ReportSchedule WHERE {0}", filledPrimaryKeyCondition);
                    result = dBHelper.GetQuerySingle(query, ref PeriodTypeID);

                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"SELECT SendAtFirstDayOfNextPeriod FROM ReportSchedule WHERE {0}", filledPrimaryKeyCondition);
                        result = dBHelper.GetQuerySingle(query, ref SendAtFirstDayOfNextPeriod);
                    }
                    reportSchedule.PeriodTypeId = PeriodTypeID;
                    reportSchedule.SendAtFirstDayOfNextPeriod = (SendAtFirstDayOfNextPeriod == 1);
                }                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                reportSchedule = null;
            }
            return result;
        }
        #endregion

        // Grid
        public static GlobalErrors GetTempReportQuery(string uniqueIdentifier, ref string queryString)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DateTime validDate = DateTime.Now.AddSeconds(-30);
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"Select TempReportQuery.ReportQuery From TempReportQuery Where ID = '{0}' and CreatedDate >= {1} ",
                uniqueIdentifier,
                LocalUtilities.ParseDateAndTimeToSQL(validDate)
                );
                result = dBHelper.GetQuerySingle(query, ref queryString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors FillGridDataSource(string reportQuery, ref List<dynamic> data)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<dynamic> dbHelper = new DBHelper<dynamic>();
                result = dbHelper.GetQueryList(reportQuery, ref data);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors DeleteUsedTempRecords(string id)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                result = dbHelper.ExecuteNonQuery($@"Delete From TempReportQuery Where (ID = '{id}' OR TempReportQuery.CreatedDate < {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now.AddSeconds(-40))}) ");
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors DeleteTempQuery(string uniqueIdentifier, ref string queryString)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DateTime validDate = DateTime.Now.AddSeconds(-30);
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"Select TempReportQuery.ReportQuery From TempReportQuery Where ID = '{0}' and CreatedDate >= {1} ",
                uniqueIdentifier,
                LocalUtilities.ParseDateAndTimeToSQL(validDate)
                );
                result = dBHelper.GetQuerySingle(query, ref queryString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors MarkReportAsFavorite(int reportId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@" Insert into EmployeeFavoriteReport (EmployeeID, ReportID) VALUES ({_requestRepository.CurrentOperator.EmployeeId}, {reportId})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UnMarkReportAsFavorite(int reportId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@" DELETE FROM EmployeeFavoriteReport WHERE EmployeeID = {_requestRepository.CurrentOperator.EmployeeId} AND ReportID = {reportId}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
