﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Data;
using System.Linq;
using System.Collections.Generic;
using System.Reflection;
using MailKit.Net.Smtp;
using MimeKit;
using System.Text;
using InCube.Security;

namespace Sonic.Web.Core
{
    public class EchoManager
    {
        private readonly IRequestRepository _requestRepository;

        public EchoManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetCustomerProperties(ref CustAppPropertiesModel custAppProperties)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dbHelper = null;
            List<TextLanguage> data;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                custAppProperties = new CustAppPropertiesModel();
                data = new List<TextLanguage>();
                string query = string.Format(@"SELECT * FROM CustomerAppProperties");
                result = dbHelper.GetQueryList(query, ref data);
                if (result == GlobalErrors.Success && data != null)
                {
                    custAppProperties.AboutUsLanguages = data.Where(a => a.Id == CustomerAppProperty.AboutUs.GetHashCode()).ToList();
                    if (custAppProperties.AboutUsLanguages.Count == 0)
                    {
                        TextLanguage defaultAboutUs = new TextLanguage();
                        defaultAboutUs.LanguageId = 1;
                        defaultAboutUs.Description = string.Empty;
                        custAppProperties.AboutUsLanguages.Add(defaultAboutUs);

                        defaultAboutUs = new TextLanguage();
                        defaultAboutUs.LanguageId = 2;
                        defaultAboutUs.Description = string.Empty;
                        custAppProperties.AboutUsLanguages.Add(defaultAboutUs);
                    }
                    custAppProperties.PrivacyPolicyLanguages = data.Where(a => a.Id == CustomerAppProperty.Policy.GetHashCode()).ToList();
                    if (custAppProperties.PrivacyPolicyLanguages.Count == 0)
                    {
                        TextLanguage defaultPrivacyPolicy = new TextLanguage();
                        defaultPrivacyPolicy.LanguageId = 1;
                        defaultPrivacyPolicy.Description = string.Empty;
                        custAppProperties.PrivacyPolicyLanguages.Add(defaultPrivacyPolicy);

                        defaultPrivacyPolicy = new TextLanguage();
                        defaultPrivacyPolicy.LanguageId = 2;
                        defaultPrivacyPolicy.Description = string.Empty;
                        custAppProperties.PrivacyPolicyLanguages.Add(defaultPrivacyPolicy);
                    }
                }
                custAppProperties.ComplaintURL = GetCustomerAppComplaintURL();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private string GetCustomerAppComplaintURL()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string complaintURL = string.Empty;
                DBHelper<string> dbHelper = new DBHelper<string>();
                string query = string.Format(@"Select keyValue From Configuration where keyname = 'CustomerAppComplaintURL' and employeeid = -1");
                result = dbHelper.GetQuerySingle(query, ref complaintURL);
                return complaintURL;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        public GlobalErrors SaveCustomerProperties(CustAppPropertiesModel custAppProperties)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<int>();
                string filterDate = string.Empty;
                query = "Delete from CustomerAppProperties ";
                dbHelper.BeginTransaction();
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    if (custAppProperties.AboutUsLanguages != null)
                    {
                        foreach (var aboutUs in custAppProperties.AboutUsLanguages)
                        {
                            if (aboutUs.Description != null)
                            {
                                query = string.Format(@"Insert into CustomerAppProperties (ID, Description, LanguageID) values ({0},'{1}',{2}) ",
                                1,
                                aboutUs.Description.Replace("'", "''"),
                                 aboutUs.LanguageId
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                {
                                    return result;
                                }
                            }
                        }
                    }
                    if (custAppProperties.PrivacyPolicyLanguages != null)
                    {
                        foreach (var privacyPolicy in custAppProperties.PrivacyPolicyLanguages)
                        {
                            if (privacyPolicy.Description != null)
                            {
                                query = string.Format(@"Insert into CustomerAppProperties (ID, Description, LanguageID) values ({0},'{1}',{2}) ",
                                2,
                                privacyPolicy.Description.Replace("'", "''"),
                                privacyPolicy.LanguageId
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                {
                                    return result;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveBanner(BannerModel banner)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;

            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format("INSERT INTO Banner (BannerID, BannerType, ValueID, Link, BannerName) " +
                        "VALUES ({0}, {1}, {2}, '{3}','{4}')", banner.BannerId,
                         banner.BannerType.GetHashCode(), banner.ValueId, banner.Link == "" ? "NULL" : banner.Link.Replace("'", "''"),
                         banner.BannerName.Replace("'", "''"));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveFeedbackReply(FeedbackModel feedBackReply)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                query = string.Format("INSERT INTO FeedbackReplies (MessageId, ReplyBy, ReplyDate, ReplyBody) " +
                    "VALUES ({0}, {1}, {2}, '{3}')", feedBackReply.MessageID,
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    feedBackReply.ReplyBody.Replace("'","''"));
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"UPDATE CustomerAppContactUs set StatusId = 2 
                    where MessageID = {0}", feedBackReply.MessageID);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveContactUsMessage(ContactUsModel mail)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                int messageId = -1;
                result = GetMaxMessageId(ref messageId, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    string query = string.Format(@"INSERT INTO CustomerAppContactUs(MessageID, CustomerID, OutletID, CreatedDate, Subject, Body, StatusID)
                                                VALUES ({0}, {1},{2},{3},'{4}','{5}', 1)"
                                                , messageId
                                                , _requestRepository.CurrentEchoOperator.CustomerId
                                                , _requestRepository.CurrentEchoOperator.OutletId
                                                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                                                , mail.Subject.Replace("'", "''")
                                                , mail.Message.Replace("'", "''"));
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private static GlobalErrors GetMaxMessageId(ref int messageId, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select isnull(max(MessageID)+1, 1) from CustomerAppContactUs");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    messageId = Int32.Parse(field.ToString());
                }
                else
                    messageId = -1;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SendEmail(ContactUsModel mail)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<EmailTemplateModel> dBHelper = new DBHelper<EmailTemplateModel>();
                EmailTemplateModel senderMail = new EmailTemplateModel();

                string query = string.Format(@"SELECT Top 1 ServerAddress, serverPort EmailPort, Email, Password, EnableSsl EnableSSL, DestinationEmail EmailDestination
                                ,EmailTemplateLanguage.Subject 
                                FROM EmailTemplate
                                inner join EmailTemplateLanguage on EmailTemplate.EmailTemplateId = EmailTemplateLanguage.EmailTemplateId and EmailTemplateLanguage.LanguageId = {0}
                                where EmailTypeID = 10 ", _requestRepository.LanguageId);
                result = dBHelper.GetQuerySingle(query, ref senderMail);
                if (result == GlobalErrors.Success && senderMail != null && senderMail.EmailDestination != string.Empty)
                {
                    MimeMessage message = new MimeMessage();
                    MailboxAddress from = new MailboxAddress(senderMail.Subject + " : " + _requestRepository.CurrentEchoOperator.Name, senderMail.Email);
                    message.From.Add(from);

                    MailboxAddress to = new MailboxAddress("User", senderMail.EmailDestination);
                    message.To.Add(to);

                    message.Subject = mail.Subject;

                    BodyBuilder bodyBuilder = new BodyBuilder();
                    bodyBuilder.HtmlBody = mail.Message;
                    bodyBuilder.TextBody = mail.Message;
                    message.Body = bodyBuilder.ToMessageBody();
                    SmtpClient client = new SmtpClient();
                    client.Connect(senderMail.ServerAddress, senderMail.EmailPort, senderMail.EnableSSL);
                    string password = EncryptionManager.Instance.DecryptPassword(senderMail.Password);
                    client.Authenticate(senderMail.Email, password);
                    client.Send(message);
                    client.Disconnect(true);
                    client.Dispose();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors GetContactUsList(FeedbackFilterModel filter, ref SharedTableResult<FeedbackModel> sharedList)
        {
            sharedList = new SharedTableResult<FeedbackModel>();
            List<FeedbackModel> list = new List<FeedbackModel>();
            DBHelper<FeedbackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<FeedbackModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string excludeAdminFilter = string.Empty;
                if (filter != null)
                {
                    if (filter.CustomerId > 0)
                    {
                        searchFilter += string.Format(" AND (co.CustomerID = {0})", filter.CustomerId);
                    }
                    if (filter.OutletId > 0)
                    {
                        searchFilter += string.Format(" And (co.OutletId = {0})", filter.OutletId);
                    }
                    if (filter.DateRange != null && filter.DateRange.Count == 2)
                    {
                        searchFilter += string.Format(" AND  c.CreatedDate >= {0} AND  c.CreatedDate <= {1} "
                          , LocalUtilities.ParseDateToSQLString(filter.DateRange[0].Date)
                          , LocalUtilities.ParseDateToSQLString(filter.DateRange[1].Date));
                    }
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(" AND  (c.Subject LIKE '%{0}%' OR c.Body LIKE '%{0}%') ", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By c.CreatedDate");
                    }
                    else
                    {
                        if (filter.CustomListFilter.SortBy.ToLower() == "customername")
                        {
                            filter.CustomListFilter.SortBy = "col.Description";
                        }
                        else if (filter.CustomListFilter.SortBy.ToLower() == "createddate")
                        {
                            filter.CustomListFilter.SortBy = "c.CreatedDate";
                        }
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }

                string mainQuery = string.Format(@" FROM CustomerAppContactUs c
                        INNER JOIN CustomerOutlet co ON co.CustomerID = c.CustomerID AND co.OutletID = c.OutletID
                        INNER JOIN CustomerOutletLanguage col ON col.CustomerID = co.CustomerID AND col.OutletID = co.OutletID AND col.LanguageID = {0}
                        INNER JOIN FeedbackStatus FS on FS.FeedbackStatusId = c.StatusId
                        LEFT OUTER JOIN FeedbackStatusLanguage FSL on FSL.FeedbackStatusId = FS.FeedbackStatusId AND FSL.LanguageId = {0}
                        LEFT OUTER JOIN FeedbackReplies FR on FR.MessageId = c.MessageID",
                _requestRepository.LanguageId);

                string employeesQuery = string.Format(@"Select ROW_NUMBER() Over({2}) AS RowSeq,
                c.MessageID,c.Subject,c.CustomerId,c.OutletId ,c.Body Message, co.CustomerCode, col.Description CustomerName, c.CreatedDate, FS.FeedbackStatusId as StatusId, FSL.Description as Status, FR.ReplyBy, FR.ReplyDate, FR.ReplyBody
                {0} {1} {2} 
                OFFSET  {3} ROWS       
                FETCH NEXT {4} ROWS ONLY",
                mainQuery,
                searchFilter,
                orderByFilter,
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
                filter.CustomListFilter.PageSize,
                ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive, _requestRepository.LanguageId),
                ResourcesManager.TranslateKey(MessagesConstants.Desc_OnHold, _requestRepository.LanguageId)
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) {0} {1}",
                mainQuery,
                searchFilter);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    sharedList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (sharedList.TotalItems <= 0)
                    {
                        sharedList.Data = list;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                result = dbHelper.GetQueryList(employeesQuery, ref list);
                sharedList.Data = list;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                sharedList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerAppProfileData(ref List<OperatorCustomerModel> userListData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                userListData = new List<OperatorCustomerModel>();
                OperatorCustomerModel user = new OperatorCustomerModel();
                DBHelper<OperatorCustomerModel> dBHelper = new DBHelper<OperatorCustomerModel>();
                string mainQuery = @"select CO.CustomerId, CO.OutletId
                                            --, COL.Description + ' - ' + CO.CustomerCode as CustomerNameCode
                                            , COL.Description CustomerName 
                                            , CO.phone, COL.Address, Account.Balance, Account.CreditLimit
                                            , EL.Description  EmployeeName
                                            , SupervisorLanguage.Description SupervisorName
                                            , Employee.Phone EmployeePhone
                                            , Supervisor.Phone SupervisorPhone
                                            , ChannelLanguage.Description ChannelName
                                            , ClassLanguage.Description ClassName
                                            ,CO.GPSLongitude Longitude
											,CO.GPSLatitude Latitude
                                            , Cast(CO.GPSLatitude as nvarchar(100)) + ','+ Cast(Co.GPSLongitude as nvarchar(100)) as location
                                            from CustomerOutlet CO
                                            LEFT JOIN CustomerOutletLanguage COL ON CO.CustomerID = COL.CustomerID AND CO.OutletID = COL.OutletID AND COL.LanguageID = {2}
                                            LEFT OUTER JOIN AccountCustOut ACO ON ACO.CustomerID = CO.CustomerID AND ACO.OutletID = CO.OutletID 
                                            LEFT OUTER JOIN Account ON ACO.AccountID = Account.AccountID
                                            INNER JOIN Employee on Employee.EmployeeId = {3}
                                            LEFT OUTER JOIN EmployeeLanguage EL on Employee.EmployeeId = EL.EmployeeId and EL.LanguageId = {2}
                                            LEFT OUTER JOIN EmployeeSupervisor ES ON ES.EmployeeID = Employee.EmployeeID
                                            LEFT OUTER JOIN Employee Supervisor ON Supervisor.EmployeeID = ES.SupervisorID 
                                            LEFT OUTER JOIN EmployeeLanguage SupervisorLanguage ON SupervisorLanguage.EmployeeID = Supervisor.EmployeeID AND SupervisorLanguage.LanguageID = {2}
                                            LEFT OUTER JOIN CustomerOutletGroup CusGroup on CusGroup.CustomerID = CO.CustomerID and CusGroup.OutletID = CO.OutletID
                                            LEFT OUTER JOIN CustomerGroup G ON CusGroup.GroupID = G.GroupID
                                            LEFT OUTER JOIN ChannelLanguage ChannelLanguage on G.ChannelID = ChannelLanguage.ChannelID and ChannelLanguage.LanguageID = 1
                                            LEFT OUTER JOIN CustomerClassLanguage ClassLanguage on ClassLanguage.CustomerClassID = CO.CustomerClassID and ClassLanguage.LanguageID = {2}
                                            WHERE CO.CustomerID = {0} and CO.OutletID = {1} ";
                string query = string.Empty;
                foreach (OperatorCustomerModel co in _requestRepository.CurrentEchoOperator.OperatorCustomers)
                {
                    query = string.Format(mainQuery, co.CustomerId, co.OutletId, _requestRepository.LanguageId, co.RouteEmployeeId);
                    result = dBHelper.GetQuerySingle(query, ref user);
                    if (result == GlobalErrors.Success)
                        userListData.Add(user);
                    else break;
                };
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetCustomerAppFAQs(ref List<CustomerAppFAQs> customerAppFAQs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                customerAppFAQs = new List<CustomerAppFAQs>();
                DBHelper<CustomerAppFAQs> dBHelper = new DBHelper<CustomerAppFAQs>();
                string query = string.Format(@"select QuestionDesc Question, AnswerDesc Answer, LanguageId from CustomerAppFAQs where languageId = {0} ", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref customerAppFAQs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors ChangeCustomerPassword(OperatorModel operatorModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"UPDATE Operator set OperatorPassword = '{0}', PasswordChangeDate = {1}
                                               WHERE OperatorName = '{2}' 
                                               AND OperatorID in (select OperatorID from CustomerOutletAccess where CustomerID ={3} and OutletID ={4} )"
                                               , EncryptionManager.Instance.EncryptPassword(operatorModel.password), LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), operatorModel.username
                                               , _requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        } 
        public GlobalErrors UpdateCustomerProfileData(OperatorCustomerModel customerModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"UPDATE CustomerOutletLanguage set Address = '{0}' where concat(CustomerID, '-', OutletID) in ({1})
                                     UPDATE CustomerOutlet SET Phone = {2}, GPSLongitude = {3}, GPSLatitude ={4}  
                                    where concat(CustomerID, '-', OutletID) in ({1}) ", customerModel.Address.Replace("'", "''"), _requestRepository.CurrentEchoOperator.CustomerOutletIds
                                    , customerModel.Phone, customerModel.Longitude, customerModel.Latitude);
                result = dBHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerAppDashboards(ref List<CustomerDashboardModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<Dashboard> dBHelper = new DBHelper<Dashboard>();
                string query = string.Format(@"Select Dashboard.DashboardID ID, DashboardLanguage.Description Name  
                FROM Dashboard
                INNER JOIN DashboardLanguage ON DashboardLanguage.DashboardID = Dashboard.DashboardID AND DashboardLanguage.LanguageID = {0}
                WHERE TypeId = 4 ", _requestRepository.LanguageId);
                List<Dashboard> dashboards = new List<Dashboard>();
                result = dBHelper.GetQueryList(query, ref dashboards);
                if (result == GlobalErrors.Success && dashboards != null && dashboards.Count > 0)
                {
                    CustomerDashboardModel custOperator;
                    Dashboard dash; 
                    string dashboardUrl = LocalUtilities.DashboardURL + "?id=";
                    string signature = string.Empty;
                    DashboardManager dashboardManager = new DashboardManager(_requestRepository);
                    for (int index = 0; index < _requestRepository.CurrentEchoOperator.OperatorCustomers.Count; index++)
                    {
                        custOperator = new CustomerDashboardModel();
                        custOperator.CustomerId = _requestRepository.CurrentEchoOperator.OperatorCustomers[index].CustomerId;
                        custOperator.OutletId = _requestRepository.CurrentEchoOperator.OperatorCustomers[index].OutletId;
                        signature = dashboardManager.GenerateDashboardSignature(string.Empty, custOperator.CustomerId.ToString(), custOperator.OutletId.ToString());

                        dashboards.ForEach(i =>
                        {
                            dash = new Dashboard();
                            dash.ID = i.ID;
                            dash.Name = i.Name;
                            dash.URL = dashboardUrl +
                            EncryptionManager.Instance.EncryptData(string.Format(signature, i.ID)).Replace('+', '*');
                            custOperator.Dashboards.Add(dash);
                        });
                        list.Add(custOperator);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEchoItems(ref SharedTableResult<ItemPackModel> itemPacklistSharedTable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                List<ItemPackModel> itemPacklist = new List<ItemPackModel>();
                string categoryQuery = string.Empty;
                string brandQuery = string.Empty;
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("1"))
                {
                    categoryQuery = " INNER JOIN ItemCategoryCustomerApp ON Item.ItemCategoryID = ItemCategoryCustomerApp.ItemCategoryID";
                }
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("2"))
                {
                    brandQuery = " INNER JOIN BrandCustomerApp on Item.BrandID = BrandCustomerApp.BrandId";
                }
                string mainQuery = string.Format(@" FROM Pack INNER JOIN
		                Item ON Pack.ItemID = Item.ItemID INNER JOIN
		                ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND ItemLanguage.LanguageID = {0}  INNER JOIN
		                ItemCategory on Item.ItemCategoryID = ItemCategory.ItemCategoryID INNER JOIN
		                ItemCategoryLanguage on Item.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID and ItemCategoryLanguage.LanguageID = {0}  left join
		                BrandLanguage on Item.BrandID = BrandLanguage.BrandID and BrandLanguage.LanguageID = {0} left join 
						PackCustomerApp  on PackCustomerApp.PackID = Pack.PackID
                        Left join ItemImage ON Item.ItemID = ItemImage.ItemID 
                        INNER JOIN
						Division on ItemCategory.DivisionID = Division.DivisionID LEFT JOIN
						DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.LanguageID = {0} left join 
						PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.PackTypeID and PackTypeLanguage.LanguageID = {0}
                        {2} {3}  where Division.DivisionID in ({1}) and (Item.Inactive = 0 OR Item.Inactive IS NULL)", _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess, categoryQuery, brandQuery);

                string itemsQuery = string.Format(@"select ROW_NUMBER() Over(order by Pack.PackId) AS RowSeq,Pack.PackId, Item.ItemCode ItemCode,Pack.Barcode ItemDefinition, 
                        Item.ItemId ,Item.ItemCategoryId, ItemLanguage.LanguageID, ItemLanguage.Description ItemName,
		                ItemCategoryLanguage.Description Category, Item.BrandID, BrandLanguage.Description Brand,
			            CASE ISNULL(PackCustomerApp.PackID, 0) WHEN 0 THEN 0 ELSE 1 END As IsChecked,
						CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END AS HasImage,
						Division.DivisionID, DivisionLanguage.Description DivisionName, PackTypeLanguage.Description UOM   {0}",
                    mainQuery);

                string countQuery = string.Format(@"select IsNull(Count(*),0) {0}",
                mainQuery);
                object objField = 0;

                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    itemPacklistSharedTable.TotalItems = int.Parse(objField.ToString().Trim());
                    if (itemPacklistSharedTable.TotalItems <= 0)
                    {
                        itemPacklistSharedTable.Data = itemPacklist;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                result = dbHelper.GetQueryList(itemsQuery, ref itemPacklist);
                itemPacklistSharedTable.Data = itemPacklist;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveEchoItems(List<ItemPackModel> PacksList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = String.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format(@"DELETE FROM PackCustomerApp WHERE (DivisionID IN ({0}))", _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if(result == GlobalErrors.Success && PacksList.Count > 0)
                {
                    foreach(ItemPackModel pack in PacksList)
                    {
                        query = string.Format(@"INSERT INTO PackCustomerApp (PackID, ItemID, ItemCategoryID, DivisionID ) VALUES ({0}, {1}, {2}, {3})", pack.PackId, pack.ItemId, pack.ItemCategoryId, pack.DivisionId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if(result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from EchoFirstOrderFreeItems where EchoFirstOrderFreeItems.PackID not in ( select PackCustomerApp.PackId from PackCustomerApp )");
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEchoDivisions(ref List<DivisionModel> divisionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DivisionModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<DivisionModel>();
                divisionsList = new List<DivisionModel>();
                string query = string.Format(@" 
                    SELECT DISTINCT Division.DivisionID AS DivisionId, DivisionLanguage.Description, Division.DivisionCode, ISNULL(Division.DivisionCode, '--') + ' ' + '-' + ' ' + ISNULL(DivisionLanguage.Description, '--') AS DivisionCodeName
                                        FROM Division 
                    Left Join PackCustomerApp on PackCustomerApp.divisionID = Division.DivisionID
                    left join ItemCategoryCustomerApp on ItemCategoryCustomerApp.DivisionID =Division.DivisionID
                    INNER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = Division.DivisionID AND DivisionLanguage.LanguageID = {0}
                    WHERE Division.DivisionID IN ({1})", _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess);

                result = dbHelper.GetQueryList(query, ref divisionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEchoCategories(int divisionId, ref List<CategoryModel> categoriesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CategoryModel> dbHelper = null;
            string categoryFilter = string.Empty;
            try
            {
                if(divisionId > -1)
                {
                     categoryFilter = $@" And (ItemCategory.DivisionID  = {divisionId})";
                }
                dbHelper = new DBHelper<CategoryModel>();
                categoriesList = new List<CategoryModel>();
                string query = string.Format(@"   
                    SELECT DISTINCT ItemCategory.ItemCategoryID, ItemCategory.ItemCategoryCode, ItemCategory.DivisionID, 
                        ItemCategoryLanguage.Description AS ItemCategoryName
                    FROM ItemCategory LEFT OUTER JOIN
                        ItemCategoryLanguage ON ItemCategoryLanguage.ItemCategoryID = ItemCategory.ItemCategoryID 
                            AND ItemCategoryLanguage.LanguageID = {0}
							Left Join PackCustomerApp on PackCustomerApp.divisionID = ItemCategory.DivisionID
							left join ItemCategoryCustomerApp on ItemCategoryCustomerApp.DivisionID =ItemCategory.DivisionID
                            WHERE ItemCategory.DivisionID IN ({1})
                            {2}", _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess, categoryFilter);

                result = dbHelper.GetQueryList(query, ref categoriesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEchoBrands(int divisionID, int itemCategoryId, ref List<BrandModel> brandsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BrandModel> dbHelper = null;
            string brandCatFilter = string.Empty;
            string brandDivFilter = string.Empty;
            string join = string.Empty;
            try
            {
                dbHelper = new DBHelper<BrandModel>();
                brandsList = new List<BrandModel>();
                if(itemCategoryId > 0 || divisionID > 0)
                {
                    join = $@" Inner join Item on item.BrandID = brand.BrandID
                    Inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID Where 1=1 ";
                    if (itemCategoryId > 0)
                    {
                        brandCatFilter = $@" and ItemCategory.ItemCategoryID = {itemCategoryId} ";
                    }
                    if (divisionID > 0)
                    {
                        brandDivFilter = $@" and ItemCategory.DivisionID = {divisionID} ";
                    }
                }


                string query = $@"
            SELECT Distinct Brand.BrandID BrandID, ISNULL(BrandLanguage.Description, '---') BrandName FROM Brand 
            LEFT JOIN BrandLanguage  ON BrandLanguage.BrandID = Brand.BrandID AND BrandLanguage.LanguageID = {_requestRepository.LanguageId} 
            INNER JOIN BrandCustomerApp ON BrandCustomerApp.BrandId = Brand.BrandID 
            {join} {brandCatFilter} {brandDivFilter} ";
                result = dbHelper.GetQueryList(query, ref brandsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEchoFirstOrderItems(GeneralFilter filter,bool getAddedItems, ref List<ItemPackModel> firstOrderFreeItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string categoryQuery = string.Empty;
            string brandQuery = string.Empty;
            string divisionFilter = string.Empty;
            string itemCategoryFilter = string.Empty;
            string brandFilter = string.Empty;
            string searchFilter = string.Empty;
            string join = string.Empty;
            string echoFirstOrderFreeItemsJoin = string.Empty;
            string quantitySelection = string.Empty;
            string orgAccess = string.Empty;
            DBHelper<ItemPackModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("1"))
                {
                    categoryQuery = " INNER JOIN ItemCategoryCustomerApp ON Item.ItemCategoryID = ItemCategoryCustomerApp.ItemCategoryID";
                }
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("2"))
                {
                    brandQuery = " INNER JOIN BrandCustomerApp on Item.BrandID = BrandCustomerApp.BrandId";
                }
                if (filter.DivisionId > -1)
                {
                    divisionFilter = string.Format(@" and Division.DivisionID = {0}", filter.DivisionId);
                }
                if (filter.BrandId > -1)
                {
                    brandFilter = string.Format(@" and Item.BrandID= {0}", filter.BrandId);
                }
                if (filter.ItemCategoryId > -1)
                {
                    itemCategoryFilter = string.Format(@" and item.ItemCategoryID = {0}", filter.ItemCategoryId);
                }
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@"and (
                    (Item.ItemCode LIKE '%{0}%')
                    or ( ItemLanguage.Description LIKE '%{0}%')
                    or ( PackTypeLanguage.Description LIKE '%{0}%')
                    or ( Pack.Barcode LIKE '%{0}%')
                    or ( BrandLanguage.Description LIKE '%{0}%')
                    )", filter.CustomListFilter.SearchFilter.Trim());
                }
                string countQuery = " select Count(*) from PackCustomerApp";

                object objField = 0;
                result = dBHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success )
                {
                    if(objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        join = " INNER JOIN";
                    }
                    else
                    {
                        join = " LEFT JOIN ";
                    }
                    if(getAddedItems)
                    {
                        echoFirstOrderFreeItemsJoin = $@" Inner Join EchoFirstOrderFreeItems on EchoFirstOrderFreeItems.PackID = Pack.PackID 
                        inner join Organization on EchoFirstOrderFreeItems.OrganizationID = Organization.OrganizationID 
                        left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {_requestRepository.LanguageId}";
                        quantitySelection = @" ISNULL(EchoFirstOrderFreeItems.Quantity,0) as CustomerAppQuantity ,
                        IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName, Organization.organizationId,";
                        orgAccess = $" and EchoFirstOrderFreeItems.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";
                    }

                    string query = string.Format(@"select ROW_NUMBER() Over(order by Pack.PackId) AS RowSeq,Pack.PackId, Item.ItemCode ItemCode,Pack.Barcode ItemDefinition, 
                        Item.ItemId ,Item.ItemCategoryId, ItemLanguage.LanguageID, ItemLanguage.Description ItemName,
		                ItemCategoryLanguage.Description Category, Item.BrandID, BrandLanguage.Description Brand,
			            CASE ISNULL(PackCustomerApp.PackID, 0) WHEN 0 THEN 0 ELSE 1 END As IsChecked,
						Division.DivisionID, DivisionLanguage.Description DivisionName, PackTypeLanguage.Description UOM ,
                        {12} 
                        IsNull(ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( '+ PackTypeLanguage.Description +' ) ' as ItemCodeName
                        FROM Pack INNER JOIN
		                Item ON Pack.ItemID = Item.ItemID INNER JOIN
		                ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND ItemLanguage.LanguageID = {0}  INNER JOIN
		                ItemCategory on Item.ItemCategoryID = ItemCategory.ItemCategoryID INNER JOIN
		                ItemCategoryLanguage on Item.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID and ItemCategoryLanguage.LanguageID = {0}  left join 
		                BrandLanguage on Item.BrandID = BrandLanguage.BrandID and BrandLanguage.LanguageID = {0} {10} 
						PackCustomerApp  on PackCustomerApp.PackID = Pack.PackID INNER JOIN
						Division on ItemCategory.DivisionID = Division.DivisionID LEFT JOIN
						DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.LanguageID = {0} left join 
						PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.PackTypeID and PackTypeLanguage.LanguageID = {0}
                        {11}
                        {2} {3}  where Division.DivisionID in ({1}) and (Item.Inactive = 0 OR Item.Inactive IS NULL)  {5} {6} {7} {13} {9}",
                  _requestRepository.LanguageId, //0
                  _requestRepository.CurrentOperator.DivisionAccess, //1
                  categoryQuery, //2
                  brandQuery, //3
                  _requestRepository.CurrentOperator.OrganizationAccess, //4
                  divisionFilter, //5
                  brandFilter, //6
                  itemCategoryFilter, //7
                  filter.OrganizationId, //8
                  searchFilter, //9
                  join, // 10
                  echoFirstOrderFreeItemsJoin, //11
                  quantitySelection, //12
                  orgAccess //13
                  );
                  result = dBHelper.GetQueryList(query, ref firstOrderFreeItems);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveEchoFirstOrderItems(List<ItemPackModel> addedFirstOrderFreeItems, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                int start = 0;
                int end = 0;
                int i = 0;
                StringBuilder values = new StringBuilder();
                if (addedFirstOrderFreeItems.Count > 1000)
                {
                    end = 1000;
                }
                else
                {
                    end = addedFirstOrderFreeItems.Count;
                }
                while (end <= addedFirstOrderFreeItems.Count)
                {
                    values = new StringBuilder();
                    for (i = start; i < end; i++)
                    {
                        values.AppendFormat("({0},{1},{2}),",
                        addedFirstOrderFreeItems[i].PackId, //0
                        addedFirstOrderFreeItems[i].CustomerAppQuantity, //1
                        addedFirstOrderFreeItems[i].OrganizationId //2 
                         );
                    }
                    query = string.Format(@"Insert Into EchoFirstOrderFreeItems (PackID, Quantity,OrganizationID) Values {0}", values.ToString().TrimEnd(','));
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    start = i;
                    if (addedFirstOrderFreeItems.Count == end)
                    {
                        break;
                    }
                    if (addedFirstOrderFreeItems.Count - end > 1000)
                    {
                        end = end + 1000;
                    }
                    else
                    {
                        end = end + (addedFirstOrderFreeItems.Count - end);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteEchoFirstOrderItems(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                   string query = $@"Delete EFOFI 
from EchoFirstOrderFreeItems EFOFI 
inner join Organization on Organization.OrganizationID = EFOFI.OrganizationID
Inner join Pack on Pack.PackID= EFOFI.PackID
Inner join Item on Item.ItemID=Pack.ItemID
Inner join ItemCategory on ItemCategory.ItemCategoryID= Item.ItemCategoryID
where EFOFI.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) and ItemCategory.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess}) ";
                   result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerAppSignUpFields(ref List<CustomerAppSignUpFields> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerAppSignUpFields> dBHelper = new DBHelper<CustomerAppSignUpFields>();

                string query = "Select * From CustomerAppSignUpFields";
                result = dBHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetLocationHierarchyConfigurationLevel(ref int levelId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object field = null;
                string query = "select KeyValue from Configuration where KeyName = 'GeographicalLocationHierarchyLevel'";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    levelId = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerAppSettings(ref List<CustomerAppSettingsModel> customerAppSettings)// for web by bana
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerAppSettingsModel> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<CustomerAppSettingsModel>();
                customerAppSettings = new List<CustomerAppSettingsModel>();
                string query = string.Format(@"select case when x.ValueType=2 then CAST(x.booleanValue AS bit) end booleanValue, ROW_NUMBER() OVER(ORDER BY x.valueType desc) AS ActionId, x.ValueType,x.ViewName,x.ActionName,
               case when x.ValueType=2 then CAST(x.booleanValue AS bit) else x.booleanValue end KeyValue
                from 
                (SELECT Value as booleanValue,case when tt.ActionName = 'ShowAchievements' then '{0}'  when tt.ActionName = 'ShowApplied' then '{1}'  when tt.ActionName = 'ShowCategoriesInHomePage' then '{2}'  when tt.ActionName = 'ShowCategoryInItemScreen' then '{3}' when tt.ActionName = 'showDiscountDetailsInSummary' then '{4}'
                when tt.ActionName = 'ShowGroupInItemScreen' then '{5}' when tt.ActionName = 'ShowOffers' then '{6}' when tt.ActionName = 'ShowSummaryAfterSave' then '{7}' when tt.ActionName = 'AllowGuestLogin'  then '{8}' when tt.ActionName = 'ItemsMostSellingDays' then  '{9}' when tt.ActionName = 'ShowItemsDocument' then  '{10}'
                else tt.ActionName end ViewName, tt.ActionName,case when tt.ActionName='ItemsMostSellingDays' then 1 else 2 end ValueType
                FROM 
                (SELECT 
                CAST(ShowAchievements AS int) ShowAchievements,
                CAST(ShowApplied AS int) ShowApplied,        
                CAST(ShowCategoriesInHomePage AS int) ShowCategoriesInHomePage,
                CAST(ShowCategoryInItemScreen AS int) ShowCategoryInItemScreen,
		        CAST(showDiscountDetailsInSummary AS int) showDiscountDetailsInSummary,
		        CAST(ShowGroupInItemScreen AS int) ShowGroupInItemScreen,
		        CAST(ShowOffers AS int) ShowOffers,
		        CAST(ShowSummaryAfterSave AS int) ShowSummaryAfterSave,
		        CAST(AllowGuestLogin AS int) AllowGuestLogin,
		        CAST(ItemsMostSellingDays AS int) ItemsMostSellingDays,
                CAST(ShowItemsDocument AS int) ShowItemsDocument
                FROM CustomerAppSettings
                ) AS S
                UNPIVOT
                (
                Value FOR ActionName IN (ShowAchievements, ShowApplied, ShowCategoriesInHomePage, ShowCategoryInItemScreen,showDiscountDetailsInSummary,ShowGroupInItemScreen,ShowOffers ,ShowSummaryAfterSave,AllowGuestLogin,ItemsMostSellingDays,ShowItemsDocument)
                ) AS tt
				)as x",

                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Achievements, _requestRepository.LanguageId),//0
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Applied_Promotions, _requestRepository.LanguageId),//1
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Categories_In_Home_Page, _requestRepository.LanguageId),//2
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Category_In_Item_Screen, _requestRepository.LanguageId),//3
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_show_Discount_Details_In_Summary, _requestRepository.LanguageId),//4
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Group_In_Item_Screen, _requestRepository.LanguageId),//5);
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Offers, _requestRepository.LanguageId),//6);
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Summary_After_Save, _requestRepository.LanguageId),//7);
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Allow_Guest_Login, _requestRepository.LanguageId), //8);
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Most_Selling_Period_In_Days, _requestRepository.LanguageId), //9
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Show_Items_Document, _requestRepository.LanguageId) //10
                  );

                result = dbHelper.GetQueryList(query, ref customerAppSettings);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomerAppSettings(List<CustomerAppSettingsModel> customerAppSettings, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (customerAppSettings != null && customerAppSettings.Count > 0)
                {
                    for (int i = 0; i < customerAppSettings.Count; i++)
                    {
                        string query = string.Format(@"update CustomerAppSettings SET {1} = case when '{1}'= '{1}'   then {2} else '{0}' end from
                       (select case when x.ValueType=2 then CAST(x.booleanValue AS bit) end booleanValue, ROW_NUMBER() OVER(ORDER BY x.ValueType Desc) AS ActionId, x.ValueType,x.ViewName,x.ActionName,
                       case when x.ValueType=2 then CAST(x.booleanValue AS bit) else x.booleanValue end KeyValue
                       from 
                       (SELECT Value as booleanValue,case when tt.ActionName = 'ShowAchievements' then 'Show Achievements'  when tt.ActionName = 'ShowApplied' then 'Show Applied Promotions'  when tt.ActionName = 'ShowCategoriesInHomePage' then 'Show Categories In Home Page'  when tt.ActionName = 'ShowCategoryInItemScreen' then 'Show Category In Item Screen' when tt.ActionName = 'showDiscountDetailsInSummary' then 'Show Discount Details In Summary'
                       when tt.ActionName = 'ShowGroupInItemScreen' then 'Show Group In Item Screen' when tt.ActionName = 'ShowOffers' then 'Show Offers' when tt.ActionName = 'ShowSummaryAfterSave' then 'Show Summary After Save' when tt.ActionName = 'AllowGuestLogin'  then 'Allow Guest Login' when tt.ActionName = 'ItemsMostSellingDays' then  'Items Most Selling Days'
                       else tt.ActionName end ViewName, tt.ActionName,case when tt.ActionName='ItemsMostSellingDays' then 1 else 2 end ValueType
                       FROM 
                       ( SELECT 
                       CAST(ShowAchievements AS int) ShowAchievements,
                       CAST(ShowApplied AS int) ShowApplied,        
                       CAST(ShowCategoriesInHomePage AS int) ShowCategoriesInHomePage,
                       CAST(ShowCategoryInItemScreen AS int) ShowCategoryInItemScreen,
		               CAST(showDiscountDetailsInSummary AS int) showDiscountDetailsInSummary,
		               CAST(ShowGroupInItemScreen AS int) ShowGroupInItemScreen,
		               CAST(ShowOffers AS int) ShowOffers,
		               CAST(ShowSummaryAfterSave AS int) ShowSummaryAfterSave,
		               CAST(AllowGuestLogin AS int) AllowGuestLogin,
		               CAST(ItemsMostSellingDays AS int) ItemsMostSellingDays
                       FROM CustomerAppSettings
                        ) AS S
                       UNPIVOT
                        (
                        Value FOR ActionName IN (ShowAchievements, ShowApplied, ShowCategoriesInHomePage, ShowCategoryInItemScreen,showDiscountDetailsInSummary,ShowGroupInItemScreen,ShowOffers ,ShowSummaryAfterSave,AllowGuestLogin,ItemsMostSellingDays)
                        ) AS tt
				        )as x
				        )as b"
                            , Convert.ToInt32(customerAppSettings[i].BooleanValue), customerAppSettings[i].ActionName,customerAppSettings[i].KeyValue);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomizeHomePage(ref List<EchoCustomeHomePageModel> customizeHomePageList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EchoCustomeHomePageModel> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<EchoCustomeHomePageModel>();
                customizeHomePageList = new List<EchoCustomeHomePageModel>();
                string query = string.Format(@"select Enabled as booleanValue,2 ValueType,Sequence,SectionTypeId,
				   case when SectionTypeId = 1 then '{0}'  when SectionTypeId = 2 then '{1}' when SectionTypeId = 3 then '{2}' when SectionTypeId = 4 then '{3}'
				   else SectionName end SectionName from EchoCustomeHomePage",
                   ResourcesManager.TranslateKey(CaptionsConstants.Desc_Brands, _requestRepository.LanguageId),//0
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Categories, _requestRepository.LanguageId),//1
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Master_Groups, _requestRepository.LanguageId),//2
                  ResourcesManager.TranslateKey(CaptionsConstants.Desc_Special, _requestRepository.LanguageId)//3);
                  );

                result = dbHelper.GetQueryList(query, ref customizeHomePageList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomizeHomePage(List<EchoCustomeHomePageModel> customizeHomePage, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (customizeHomePage != null && customizeHomePage.Count > 0)
                {
                    for (int i = 0; i < customizeHomePage.Count; i++)
                    {
                        string query = string.Format(@"update EchoCustomeHomePage set Enabled = {0}, Sequence = {1} Where SectionTypeId = {2}"
                           , Convert.ToInt32(customizeHomePage[i].BooleanValue), Convert.ToInt32(customizeHomePage[i].Sequence), customizeHomePage[i].SectionTypeId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCompany(ref List<CompanyDetails> companyDetailsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CompanyDetails> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<CompanyDetails>();
                companyDetailsList = new List<CompanyDetails>();
                string query = string.Format(@"select CompanyDetails.OrganizationID OrganizationID, IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCode  from CompanyDetails 
                inner join OrganizationLanguage on CompanyDetails.OrganizationID= OrganizationLanguage.OrganizationId and OrganizationLanguage.languageId = {0}
                inner join Organization on CompanyDetails.OrganizationID= Organization.OrganizationID"
                 , _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref companyDetailsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrganizationListCompanyDetails(bool IsEditMode, ref List<OrganizationModel> organizationList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrganizationModel> dbHelper = null;
            string editQuery = string.Empty;
            string conditionFilter = string.Empty;
            try
            {
                if (!IsEditMode)
                {
                    editQuery = string.Format(@" left join CompanyDetails on CompanyDetails.OrganizationID = Organization.OrganizationID");
                    conditionFilter = " and CompanyDetails.OrganizationID is null";
                }
                dbHelper = new DBHelper<OrganizationModel>();
                organizationList = new List<OrganizationModel>();
                string query = string.Format(@"SELECT DISTINCT Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCode
                FROM Organization
                left outer join OrganizationLanguage  on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
				inner join account on Organization.OrganizationID = Account.OrganizationID 
				inner join AccountCust on account.AccountID= AccountCust.AccountID --and AccountCust.CustomerID= {2}
                {3}
                WHERE Organization.OrganizationID in ({1}) {4}"
                 , _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess, LocalUtilities.GestCustomerId,editQuery, conditionFilter);
                result = dbHelper.GetQueryList(query, ref organizationList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCompanyDetails(int organizationId,ref CompanyDetails companyDetails)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CompanyDetails> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CompanyDetails>();
                string query = string.Format(@"select * from  CompanyDetails Where OrganizationID = {0}", organizationId);
                result = dBHelper.GetQuerySingle(query, ref companyDetails);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertCompanyDetails(CompanyDetails companyDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"INSERT INTO CompanyDetails(MobileNo,Fax,Email,Latitude,Longitude,Facebook,Instagram,Twitter,Youtube,Linkedin,Whatsapp,OrganizationID,LocationString)
                VALUES ('{0}','{1}','{2}',{3},{4},'{5}','{6}','{7}','{8}','{9}','{10}',{11},'{12}')",
                companyDetails.MobileNo.Replace("'", "''"), //0
                companyDetails.Fax.Replace("'", "''"), //1
                companyDetails.Email.Replace("'", "''"), //2
                companyDetails.Longitude, //3
                companyDetails.Latitude,
                companyDetails.Facebook.Replace("'", "''"), //4
                companyDetails.Instagram.Replace("'", "''"), //5
                companyDetails.Twitter.Replace("'", "''"),  //6
                companyDetails.Youtube.Replace("'", "''"), //7
                companyDetails.Linkedin.Replace("'", "''"), //8
                companyDetails.Whatsapp.Replace("'", "''"), //9
                companyDetails.OrganizationID, //10
                companyDetails.LocationString.Replace("'", "''") //11
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCompanyDetails(CompanyDetails companyDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Update CompanyDetails Set MobileNo = '{0}',Fax = '{1}', Email='{2}', Longitude={3}, Latitude={4}, Facebook='{5}', Instagram='{6}', Twitter='{7}', Youtube='{8}', Linkedin='{9}', Whatsapp='{10}', LocationString='{11}'  Where OrganizationID = {12}",
                        companyDetails.MobileNo.Replace("'", "''"), companyDetails.Fax.Replace("'", "''"), companyDetails.Email.Replace("'", "''"), companyDetails.Longitude, companyDetails.Latitude, companyDetails.Facebook.Replace("'", "''"), companyDetails.Instagram.Replace("'", "''"), companyDetails.Twitter.Replace("'", "''"), companyDetails.Youtube.Replace("'", "''"), companyDetails.Linkedin.Replace("'", "''"), companyDetails.Whatsapp.Replace("'", "''"), companyDetails.LocationString.Replace("'", "''"), companyDetails.OrganizationID);
                 result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            
            return result;
        }
        public GlobalErrors DeleteCompanyDetails(int organizationId, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Delete From CompanyDetails Where OrganizationID = {0}", organizationId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrganizationListOrganizationDetails(bool IsEditMode, ref List<OrganizationModel> organizationList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrganizationModel> dbHelper = null;
            string editQuery = string.Empty;
            string conditionFilter = string.Empty;
            try
            {
                if (!IsEditMode)
                {
                    editQuery = string.Format(@" left join OrganizationDetails on OrganizationDetails.OrganizationID = Organization.OrganizationID");
                    conditionFilter = " and OrganizationDetails.OrganizationID is null";
                }
                dbHelper = new DBHelper<OrganizationModel>();
                organizationList = new List<OrganizationModel>();
                string query = string.Format(@"SELECT Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCode
                FROM Organization
                left outer join OrganizationLanguage  on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
			    {2}
                WHERE Organization.OrganizationID in ({1}) {3}"
                 , _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess, editQuery, conditionFilter);
                result = dbHelper.GetQueryList(query, ref organizationList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrganization(ref List<OrganizationDetails> organizationDetailsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrganizationDetails> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<OrganizationDetails>();
                organizationDetailsList = new List<OrganizationDetails>();
                string query = string.Format(@"select OrganizationDetails.OrganizationID OrganizationID, IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCode,Email  from OrganizationDetails 
                inner join OrganizationLanguage on OrganizationDetails.OrganizationID= OrganizationLanguage.OrganizationId and OrganizationLanguage.languageId = {0}
                inner join Organization on OrganizationDetails.OrganizationID= Organization.OrganizationID"
                 , _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref organizationDetailsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrganizationDetails(int organizationId, ref OrganizationDetails organizationDetails)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<OrganizationDetails> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<OrganizationDetails>();
                string query = string.Format(@"select * from  OrganizationDetails Where OrganizationID = {0}", organizationId);
                result = dBHelper.GetQuerySingle(query, ref organizationDetails);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertOrganizationDetails(OrganizationDetails organizationDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"INSERT INTO OrganizationDetails(OrganizationID,Email) VALUES ({0},'{1}')",
                organizationDetails.OrganizationID,
                organizationDetails.Email.Replace("'", "''")
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateOrganizationDetails(OrganizationDetails organizationDetails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Update OrganizationDetails Set Email='{0}' Where OrganizationID = {1}",
                         organizationDetails.Email.Replace("'", "''"), organizationDetails.OrganizationID);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteOrganizationDetails(int organizationId, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Delete From OrganizationDetails Where OrganizationID = {0}", organizationId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public static GlobalErrors GetGestUsers(ref List<CustomerAppGestUserOperatorModel> GestUsers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerAppGestUserOperatorModel> dbHelper = null;
            List<CustomerAppOrganizations> customerAppOrganizationslist = new List<CustomerAppOrganizations>();
            DBHelper<CustomerAppOrganizations> dbHelper2 = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<CustomerAppGestUserOperatorModel>();
                dbHelper2 = new DBHelper<CustomerAppOrganizations>();
                query = string.Format(@"SELECT DISTINCT A.OrganizationID, O.OperatorID, O.OperatorName, O.OperatorPassword, ACO.CustomerID, ACO.OutletID
                    FROM CustomerOutlet AS CO INNER JOIN
                    AccountCustOut AS ACO ON CO.CustomerID = ACO.CustomerID AND CO.OutletID = ACO.OutletID INNER JOIN
                    CustomerOutletAccess AS COA ON COA.CustomerID = CO.CustomerID AND COA.OutletID = CO.OutletID INNER JOIN
                    Account AS A ON A.AccountID = ACO.AccountID INNER JOIN
                    Operator AS O ON O.OperatorID = COA.OperatorID
                    WHERE (CO.CustomerID = {0})", LocalUtilities.GestCustomerId);
                result = dbHelper.GetQueryList(query, ref GestUsers);
                if (result == GlobalErrors.Success && GestUsers != null && GestUsers.Count() > 0)
                {
                    string ids = string.Join(", ", GestUsers.Select(p => p.OrganizationId));
                    GestUsers.Select(c => { c.OperatorPassword = EncryptionManager.Instance.DecryptPassword(c.OperatorPassword); return c; }).ToList();
                    query = string.Format(@"SELECT CAO.OrganizationID, CAO.ImageName, SG.LanguageId, SG.DefaultDescription Description
                            FROM CustomerAppOrganizations AS CAO INNER JOIN
                            SonicDescription AS SG ON CAO.Description = SG.DescriptionKey
                            WHERE (CAO.OrganizationID IN ({0}))", ids);

                    result = dbHelper2.GetQueryList(query, ref customerAppOrganizationslist);
                    GestUsers.Select(user => { user.Languages = customerAppOrganizationslist.Where(x => x.OrganizationId == user.OrganizationId).ToList(); return user; }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors GetCustomerAppSettings(ref CustomerAppSettingsModel customerAppSettingsModel) // for echo by reema
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<CustomerAppSettingsModel> customerAppSettingsModels = new List<CustomerAppSettingsModel>();
            DBHelper<CustomerAppSettingsModel> dBHelper = null;
            try
            {
                object obj = new object();
                dBHelper = new DBHelper<CustomerAppSettingsModel>();
                string query = string.Format(@"
                    SELECT ShowAchievements, ShowApplied, ShowOffers, ShowSummaryAfterSave, ShowCategoriesInHomePage, ShowCategoryInItemScreen, showDiscountDetailsInSummary, ShowGroupInItemScreen, AllowGuestLogin, ItemsMostSellingDays, ShowItemsDocument
                    FROM CustomerAppSettings");
                result = dBHelper.GetQueryList(query, ref customerAppSettingsModels);
                if (result == GlobalErrors.Success && customerAppSettingsModels.Count > 0)
                {
                    customerAppSettingsModel = customerAppSettingsModels[0];
                }
                else
                {
                    customerAppSettingsModel = new CustomerAppSettingsModel();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors GetCustomerSelectAppGuestUserCaption(ref List<TextLanguage> texts)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            texts = new List<TextLanguage>();
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                object obj = new object();
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"SELECT DescriptionValue Description , LanguageId FROM SonicDescription WHERE DescriptionKey = '{0}'", MessagesConstants.Desc_Customer_App_Select_Guest_User_Caption);
                result = dBHelper.GetQueryList(query, ref texts);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteBanner(string fileName, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Delete From Banner Where BannerName = '{0}'", fileName);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBanners(ref List<BannerModel> banner)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<BannerModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<BannerModel>();
                string query = string.Format(@"select Banner.*, case when banner.BannerType = {1} then PromotionLanguage.Description when banner.BannerType={2} then SurveyLanguage.Description end as ValueName
                from Banner 
                left join Promotion on Banner.ValueID= Promotion.PromotionID and banner.BannerType = {1}
                left join PromotionLanguage on Promotion.PromotionID  = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {0}
                left join Survey on Banner.ValueID = Survey.SurveyID  and banner.BannerType = {2}
                left join SurveyLanguage on Survey.SurveyID= SurveyLanguage.SurveyID and SurveyLanguage.LanguageID = {0}", _requestRepository.LanguageId,BannerTypes.Promotion.GetHashCode(), BannerTypes.Survey.GetHashCode());
                result = dBHelper.GetQueryList(query, ref banner);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

    }
}