﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Dynamic;
using System.Linq;
using System.Reflection;
using System.Text;
using InCube.Security;
using Sonic.Web.Models;

namespace Sonic.Web.Core
{
    public class EmailManager
    {
        private readonly IRequestRepository _requestRepository;
        public EmailManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors DeleteEmailTemplateLanguages(int emailTempId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "DELETE FROM EmailTemplateLanguage WHERE EmailTemplateId = " + emailTempId;
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEmailTemplateDetail(int emailTempId, ref EmailTemplateModel emailTemp)
        {
            emailTemp = new EmailTemplateModel();
            DBHelper<EmailTemplateModel> dbHelper = null;
            DBHelper<EmailTemplateLanguageModel> dbHelperLanguage = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string query = string.Format(@"SELECT EmailTemplate.EmailTemplateId EmailTempId, EmailTemplate.EmailTypeId EmailTypeId, EmailTemplate.ServerAddress, EmailTemplate.Password, EmailTemplate.ServerPort EmailPort, EmailTemplate.Email,
                                EmailTemplateLanguage.Description Name, EmailTemplateLanguage.Body, EmailTemplateLanguage.Subject, EmailTemplate.HasAttachment as MandatoryAttachement, EmailTemplate.EnableSSL, EmailTemplate.InActive as IsActive,
                                EmailTemplate.DestinationEmail EmailDestination, EmailTemplate.DocumentTypeId
                                FROM EmailTemplate
                                LEFT JOIN EmailTemplateLanguage ON EmailTemplateLanguage.EmailTemplateId = EmailTemplate.EmailTemplateId AND EmailTemplateLanguage.LanguageId = {0}
                                WHERE EmailTemplate.EmailTemplateId = {1} ORDER BY EmailTemplateLanguage.Description", (_requestRepository == null ? 1 : _requestRepository.LanguageId.GetHashCode()), emailTempId);
                result = dbHelper.GetQuerySingle(query, ref emailTemp);
                if (result == GlobalErrors.Success && emailTemp != null)
                {
                    emailTemp.Password = EncryptionManager.Instance.DecryptPassword(emailTemp.Password);
                    emailTemp.IsActive = !emailTemp.IsActive;
                    dbHelperLanguage = new DBHelper<EmailTemplateLanguageModel>();
                    query = string.Format(@"SELECT EmailTemplateLanguage.*
                                FROM EmailTemplateLanguage WHERE EmailTemplateLanguage.EmailTemplateId = {0}", emailTempId);
                    List<EmailTemplateLanguageModel> empLangList = new List<EmailTemplateLanguageModel>();
                    result = dbHelperLanguage.GetQueryList(query, ref empLangList);
                    if (result == GlobalErrors.Success && empLangList != null && empLangList.Count > 0)
                    {
                        emailTemp.DescriptionLanguages = empLangList.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Description
                        }).ToList();
                        emailTemp.BodyLanguages = empLangList.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Body
                        }).ToList();
                        emailTemp.SubjectLanguages = empLangList.Select(a => new TextLanguage()
                        {
                            LanguageId = a.LanguageId,
                            Description = a.Subject
                        }).ToList();
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTemp = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (dbHelperLanguage != null)
                {
                    dbHelperLanguage.Dispose();
                    dbHelperLanguage = null;
                }
            }
        }

        public GlobalErrors GetEmailTemplatesDetails(string emailTypeIDs, ref List<EmailTemplateModel> emailTempList)
        {
            emailTempList = new List<EmailTemplateModel>();
            List<EmailTemplateLanguageModel> empLangList = new List<EmailTemplateLanguageModel>();
            DBHelper<EmailTemplateModel> dbHelper = null;
            DBHelper<EmailTemplateLanguageModel> dbHelperLanguage = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string query = string.Format(@"SELECT EmailTemplate.EmailTemplateId EmailTempId, EmailTemplate.EmailTypeId EmailTypeId, EmailTemplate.ServerAddress, EmailTemplate.Password, EmailTemplate.ServerPort EmailPort, EmailTemplate.Email,
                                EmailTemplateLanguage.Description Name, EmailTemplateLanguage.Body, EmailTemplateLanguage.Subject, EmailTemplate.HasAttachment as MandatoryAttachement, EmailTemplate.EnableSSL, EmailTemplate.InActive as IsActive,
                                EmailTemplate.DestinationEmail EmailDestination, EmailTemplate.DocumentTypeId
                                FROM EmailTemplate
                                LEFT JOIN EmailTemplateLanguage ON EmailTemplateLanguage.EmailTemplateId = EmailTemplate.EmailTemplateId AND EmailTemplateLanguage.LanguageId = {0}
                                WHERE EmailTemplate.EmailTypeID in ({1}) ORDER BY EmailTemplate.EmailTemplateId", _requestRepository.LanguageId, emailTypeIDs);
                result = dbHelper.GetQueryList(query, ref emailTempList);
                if (result == GlobalErrors.Success && emailTempList != null)
                {
                    foreach (EmailTemplateModel emailTemp in emailTempList)
                    {
                        emailTemp.Password = EncryptionManager.Instance.DecryptPassword(emailTemp.Password);
                        emailTemp.IsActive = !emailTemp.IsActive;
                        dbHelperLanguage = new DBHelper<EmailTemplateLanguageModel>();
                        query = string.Format(@"SELECT EmailTemplateLanguage.*
                                FROM EmailTemplateLanguage WHERE EmailTemplateLanguage.EmailTemplateId = {0}", emailTemp.EmailTempId);
                        empLangList = new List<EmailTemplateLanguageModel>();
                        result = dbHelperLanguage.GetQueryList(query, ref empLangList);
                        if (result == GlobalErrors.Success && empLangList != null && empLangList.Count > 0)
                        {
                            emailTemp.DescriptionLanguages = empLangList.Select(a => new TextLanguage()
                            {
                                LanguageId = a.LanguageId,
                                Description = a.Description
                            }).ToList();
                            emailTemp.BodyLanguages = empLangList.Select(a => new TextLanguage()
                            {
                                LanguageId = a.LanguageId,
                                Description = a.Body
                            }).ToList();
                            emailTemp.SubjectLanguages = empLangList.Select(a => new TextLanguage()
                            {
                                LanguageId = a.LanguageId,
                                Description = a.Subject
                            }).ToList();
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTempList = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (dbHelperLanguage != null)
                {
                    dbHelperLanguage.Dispose();
                    dbHelperLanguage = null;
                }
            }
        }

        public GlobalErrors GetEmailTypes(bool isExcludedTypeCRM,ref List<EmailTypeModel> emailTypes)
        {
            emailTypes = new List<EmailTypeModel>();
            DBHelper<EmailTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string emailTypeFilter = string.Empty;
            try
            {
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    emailTypeFilter = string.Format(@"AND EmailTypeID = 10");
                }
                else if (!_requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    emailTypeFilter = string.Format(@"AND EmailTypeID <> 10");
                }
                if (isExcludedTypeCRM)
                {
                    emailTypeFilter = string.Format(@"AND EmailTypeID in ({0},{1},{2})",EmailTypes.CRMOrder.GetHashCode(),EmailTypes.CRMCollection.GetHashCode(),EmailTypes.CRMOther.GetHashCode());
                }
                else
                {
                    emailTypeFilter = string.Format(@"AND EmailTypeID not in ({0},{1},{2})", EmailTypes.CRMOrder.GetHashCode(), EmailTypes.CRMCollection.GetHashCode(), EmailTypes.CRMOther.GetHashCode());
                }
                dbHelper = new DBHelper<EmailTypeModel>();
                string query = string.Format(@"Select * FROM EmailTypeLanguage where LanguageID = {0} {1}", _requestRepository.LanguageId.GetHashCode(), emailTypeFilter);
                result = dbHelper.GetQueryList(query, ref emailTypes);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTypes = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors GetEmailTemplatesList(bool showActiveOnly, ref SharedTableResult<EmailTemplateModel> emailTempList)
        {
            emailTempList = new SharedTableResult<EmailTemplateModel>();
            DBHelper<EmailTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string where = string.Empty;
                //if (!string.IsNullOrEmpty(searchFilter))
                //{
                //    searchFilter = string.Format(@"WHERE EmailTemplateLanguage.Description LIKE '%{0}%' OR EmailTemplateLanguage.Subject LIKE '%{0}%'
                //                OR EmailTemplate.Email LIKE '%{0}%' ", searchFilter);
                //}
                if (showActiveOnly)
                {
                    where = "WHERE 1=1 AND EmailTemplate.InActive = 0 OR EmailTemplate.InActive IS NULL";
                }
                string query = string.Format(@"SELECT EmailTypeLanguage.EmailTypeID,EmailTypeLanguage.LanguageID, 
                                CASE WHEN EmailTypeLanguage.EmailTypeID = 9 THEN EmailTypeLanguage.Description + ' \ ' +  ProofDocumentTypeLanguage.Description ELSE EmailTypeLanguage.Description END AS Description,
                                EmailTemplate.EmailTemplateId EmailTempId,EmailTemplate.EmailTypeId EmailTypeId, EmailTemplate.ServerAddress, EmailTemplate.Email, EmailTemplateLanguage.Description Name, 
                                EmailTemplateLanguage.Subject, EmailTemplateLanguage.Body,
                                CASE WHEN EmailTemplate.InActive = 1 THEN 'Desc_Inactive' ELSE 'Desc_Active' END Status, 
                                CASE WHEN EmailTemplate.InActive = 1 THEN 0 ELSE 1 END IsActive,  EmailTemplate.HasAttachment as MandatoryAttachement
                                FROM EmailTemplate 
                                LEFT JOIN EmailTemplateLanguage ON EmailTemplateLanguage.EmailTemplateId = EmailTemplate.EmailTemplateId AND EmailTemplateLanguage.LanguageId = {0}
                                LEFT JOIN EmailTypeLanguage ON EmailTypeLanguage.EmailTypeID = EmailTemplate.EmailTypeID AND EmailTypeLanguage.LanguageId = {0}
                                LEFT JOIN ProofDocumentTypeLanguage on ProofDocumentTypeLanguage.DocumentTypeID = EmailTemplate.DocumentTypeId AND ProofDocumentTypeLanguage.LanguageID = {0}                    
                                {1} ORDER BY EmailTemplateLanguage.Description", _requestRepository.LanguageId.GetHashCode(), where);
                List<EmailTemplateModel> data = new List<EmailTemplateModel>();
                result = dbHelper.GetQueryList(query, ref data);
                if (result == GlobalErrors.Success)
                {
                    emailTempList.Data = data;
                    emailTempList.TotalItems = data.Count;
                }
                else
                {
                    emailTempList = null;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTempList = null;
                return GlobalErrors.Error;
            }
        }

        public int GetMaxId(string columnName, string TableName, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format("select ISNULL( MAX({0}) , 0)  + 1 From {1}", columnName, TableName);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    return (int)field;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        public bool checkIfEmailTemplateTypeIsAvailable(EmailTemplateModel model)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            string documentTypeWhere = string.Empty;
            try
            {
                if (model.DocumentTypeId > 0)
                {
                    documentTypeWhere = string.Format(@" AND DocumentTypeId = {0}", model.DocumentTypeId);
                }
                dBHelper = new DBHelper<int>();
                string query = string.Format("select count(*) From EmailTemplate " +
                    "where EmailTemplateId <> {0} and EmailTypeID = {1} and InActive = 0 {2}",
                    model.EmailTempId,
                    model.EmailTypeId,
                    documentTypeWhere);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    return true;
                }
                else
                    return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public GlobalErrors SaveNewEmailTemplate(EmailTemplateModel model, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO EmailTemplate(EmailTemplateId, Email, ServerPort, 
                            Password, ServerAddress, EnableSSL, HasAttachment, InActive, CreatedDate, 
                            CreatedBy, EmailTypeID, DestinationEmail, UpdatedDate, UpdatedBy, DocumentTypeId) 
                            VALUES ({0}, '{1}', {2}, '{3}', '{4}', {5}, {6}, {7}, {8}, {9}, {10}, {11}, 
                            NULL, NULL, {12})",
                model.EmailTempId,//0
                model.Email.Replace("'", "''").ToString(),//1
                model.EmailPort,//2
                EncryptionManager.Instance.EncryptPassword(model.Password).ToString(),//3
                model.ServerAddress.Replace("'", "''").ToString(),//4
                model.EnableSSL ? 1 : 0,//5
                model.MandatoryAttachement ? 1 : 0,//6
                model.IsActive ? 0 : 1,//7
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//8
                _requestRepository.CurrentOperator.EmployeeId,//9
                model.EmailTypeId,//10
                !string.IsNullOrEmpty(model.EmailDestination) ? "'" + model.EmailDestination.Replace("'", "''") + "'" : "NULL",//11
                model.DocumentTypeId);//12
                result = dBHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveDynamicTemplateLanguages(int templateId, List<TextLanguage> descriptionLangs, List<TextLanguage> displayNameLangs, List<TextLanguage> subjectLangs, List<TextLanguage> bodyLangs, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                //var values = new StringBuilder();
                foreach (TextLanguage txtLang in descriptionLangs)
                {
                    var bodyString = string.Empty;
                    var subjectString = string.Empty;
                    var displayNameString = string.Empty;
                    var tempDescString = string.Empty;

                    tempDescString = txtLang.Description;

                    if (displayNameLangs != null && displayNameLangs.Count > 0)
                    {
                        displayNameString = displayNameLangs.Where(name => name.LanguageId == txtLang.LanguageId).FirstOrDefault().Description;
                    }
                    if (subjectLangs != null && subjectLangs.Count > 0)
                    {
                        subjectString = subjectLangs.Where(name => name.LanguageId == txtLang.LanguageId).FirstOrDefault().Description;
                    }
                    if (bodyLangs != null && bodyLangs.Count > 0)
                    {
                        bodyString = bodyLangs.Where(name => name.LanguageId == txtLang.LanguageId).FirstOrDefault().Description;
                    }

                    query = string.Format(@" Insert into DTLanguage(TemplateID,LanguageID,Description,Subject,Body,DisplayName) values ({0},{1},'{2}','{3}','{4}','{5}') ",
                     templateId, //0
                     txtLang.LanguageId, //1
                     !string.IsNullOrEmpty(tempDescString) ? tempDescString.Replace("'", "''").ToString() : null, //2
                     !string.IsNullOrEmpty(subjectString) ? subjectString.Replace("'", "''").ToString() : null, //3
                     !string.IsNullOrEmpty(bodyString) ? bodyString.Replace("'", "''").ToString() : null, //4
                     !string.IsNullOrEmpty(displayNameString) ? displayNameString.Replace("'", "''").ToString() : null//5
                     );
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDynamicTemplateLanguages(int templateId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = $@" Delete from DTLanguage where TemplateID = {templateId}";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNewEmailTemplateLanguage(EmailTemplateModel model, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string subject = string.Empty;
                string body = string.Empty;
                foreach (TextLanguage textLanguage in model.DescriptionLanguages)
                {
                    subject = string.Empty;
                    body = string.Empty;
                    if (string.IsNullOrEmpty(textLanguage.Description))
                    {
                        textLanguage.Description = model.Name;
                    }
                    if (model.SubjectLanguages != null)
                    {
                        subject = model.SubjectLanguages.Where(a => a.LanguageId == textLanguage.LanguageId).FirstOrDefault().Description;
                    }
                    if (string.IsNullOrEmpty(subject))
                    {
                        subject = model.Subject;
                    }
                    if (model.EmailTypeId != EmailTypes.CustomersApp.GetHashCode())
                    {
                        if (model.BodyLanguages != null)
                        {
                            body = model.BodyLanguages.Where(a => a.LanguageId == textLanguage.LanguageId).FirstOrDefault().Description;
                        }
                        if (string.IsNullOrEmpty(body))
                        {
                            body = model.Body;
                        }
                    }
                    else
                    {
                        body = "";
                    }

                    result = SaveNewEmailTemplateLanguage(model.EmailTempId, textLanguage.LanguageId, textLanguage.Description, subject, body, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        break;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateReportScheduleTemplate(EmailTemplateModel model, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.AppendFormat(@"UPDATE ScheduleReportConfiguration SET
                           Email = '{0}',
                           ServerPort = {1},
                           Password = '{2}',
                           ServerAddress = '{3}',
                           EnableSSL = {4},
                           UpdatedDate = {5},
                           UpdatedBy = {6}",
                model.Email.Replace("'", "''").ToString(), //0
                model.EmailPort, // 1
                EncryptionManager.Instance.EncryptPassword(model.Password).ToString(), //2
                model.ServerAddress.Replace("'", "''").ToString(), //3
                model.EnableSSL ? 1 : 0, //4
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //5
                _requestRepository.CurrentOperator.EmployeeId //6
                );
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveReportScheduleTemplate(EmailTemplateModel model, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO ScheduleReportConfiguration(Email, ServerPort, 
                            Password ,ServerAddress ,EnableSSL ,CreatedDate ,CreatedBy ) 
                            VALUES ('{0}', '{1}', '{2}', '{3}', {4}, {5}, {6})",
                model.Email.Replace("'", "''").ToString(),//0
                model.EmailPort,//1
                EncryptionManager.Instance.EncryptPassword(model.Password).ToString(),//2
                model.ServerAddress.Replace("'", "''").ToString(),//3
                model.EnableSSL ? 1 : 0,//4
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//5
                _requestRepository.CurrentOperator.EmployeeId); //6
                result = dBHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetReportScheduleTemplateDetail(ref EmailTemplateModel emailTemp)
        {
            emailTemp = new EmailTemplateModel();
            DBHelper<EmailTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string query = string.Format(@"Select ServerAddress , ServerPort EmailPort, Email , Password , EnableSsl from ScheduleReportConfiguration");
                result = dbHelper.GetQuerySingle(query, ref emailTemp);
                if (result == GlobalErrors.Success && emailTemp != null)
                {
                    emailTemp.Password = EncryptionManager.Instance.DecryptPassword(emailTemp.Password);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailTemp = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public GlobalErrors UpdateEmailTemplate(EmailTemplateModel model, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.AppendFormat(@"UPDATE EmailTemplate SET
                           Email = '{0}',
                           ServerPort = {1},
                           Password = '{2}',
                           ServerAddress = '{3}',
                           EnableSSL = {4},
                           HasAttachment = {5},
                           InActive = {6},
                           UpdatedDate = {7},
                           UpdatedBy = {8},
                           EmailTypeID ={10},
                           DestinationEmail = {11},
                           DocumentTypeId = {12}
                           WHERE EmailTemplateId = {9}",
                model.Email.Replace("'", "''").ToString(),
                model.EmailPort,
                EncryptionManager.Instance.EncryptPassword(model.Password).ToString(),
                model.ServerAddress.Replace("'", "''").ToString(),
                model.EnableSSL ? 1 : 0,
                model.MandatoryAttachement ? 1 : 0,
                model.IsActive ? 0 : 1,
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                _requestRepository.CurrentOperator.EmployeeId,
                model.EmailTempId,
                model.EmailTypeId,
                !string.IsNullOrEmpty(model.EmailDestination) ? "'" + model.EmailDestination.Replace("'", "''") + "'" : "NULL",
                model.DocumentTypeId);
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        private GlobalErrors SaveNewEmailTemplateLanguage(int emailTempId, int languageId, string text, string subject, string body, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append(@"INSERT INTO EmailTemplateLanguage ([EmailTemplateId],[LanguageId],[Subject],[Body],[Description]) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(emailTempId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", subject.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", body.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", text.Replace("'", "''").ToString());
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveEmployeeEmailHistory(EmailFilter filter, EmailTemplateModel emailTemp, EmailModel email, EmailStatus status, string note)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append(@" 
                            INSERT INTO EmployeeEmailHistory
                            (SendDate,
                            RouteHistoryID,
                            EmployeeID,
                            EmailTemplateId,
                            SenderEmail,
                            ToEmail,
                            ReceiverEmployeeID 
                            ,Subject
                            ,Body
                            ,Status
                            ,FailureReason)
                            VALUES ("); 
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("{0}", filter.RouteHistoryID);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("{0}", filter.EmployeeID);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("{0}", emailTemp.TemplateId);
                sqlStatment.Append(","); 
                sqlStatment.AppendFormat("'{0}'", email.SenderEmail?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.ToEmail?.Replace("'", "''").ToString()); 
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("{0}", emailTemp.ReceiverEmployeeID);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.Subject?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.Body?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(status.GetHashCode());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", note?.Replace("'", "''").ToString()); 
                sqlStatment.Append(")");
                dBHelper = new DBHelper<int>();
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                }
            }
        }
        public GlobalErrors SaveEmailHistory(EmailModel email, EmailStatus status, string note)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append(@"INSERT INTO EmailSendHistory
                            (EmailTemplateId
                            ,Sender
                            ,ToEmail
                            ,SendDate
                            ,Subject
                            ,Body
                            ,Status
                            ,Note
                            ,CreatedBy) VALUES (");
                sqlStatment.Append(email.EmailTempId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.SenderEmail?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.ToEmail?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.Subject?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", email.Body?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.Append(status.GetHashCode());
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", note?.Replace("'", "''").ToString());
                sqlStatment.Append(",");
                sqlStatment.Append((_requestRepository == null || _requestRepository.CurrentOperator == null ? 0 : _requestRepository.CurrentOperator.EmployeeId));
                sqlStatment.Append(")");
                dBHelper = new DBHelper<int>();
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                }
            }
        }
        public GlobalErrors GetActiveEmailTemplatesList(int emailTypeId, ref List<EmailTemplateModel> templatesList)
        {
            DBHelper<EmailTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string query = string.Format(@"select EmailTemplate.EmailTemplateId as TemplateId, EmailTemplateLanguage.Description
                from EmailTemplate
                inner join EmailTemplateLanguage on EmailTemplateLanguage.EmailTemplateID = EmailTemplate.EmailTemplateID and EmailTemplateLanguage.LanguageID = {0}
                Where Inactive = 0 and EmailTemplate.EmailTypeId = {1} ",
                _requestRepository.LanguageId, //0
                emailTypeId //1
                );

                result = dbHelper.GetQueryList(query, ref templatesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templatesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveNewDynamicTemplate(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int reportId = -1;
                if (dynamicTemplate.EmployeeReports != null && dynamicTemplate.EmployeeReports.Count == 1)
                {
                    reportId = dynamicTemplate.EmployeeReports[0].ReportId;
                }
                else
                {
                    reportId = dynamicTemplate.ReportID;
                }
                string query = string.Format(@" INSERT INTO DT
                (TemplateID,Email,Password,ServerPort,ServerAddress,CreatedBy,CreatedDate,HasAttachment,Inactive,EnableSSL,EmailTypeID,ReportID)
                Values ({0},'{1}','{2}',{3},'{4}',{5},{6},{7},{8},{9},{10},{11})",
                dynamicTemplate.TemplateId, //0,
                dynamicTemplate.Email.Replace("'", "''").ToString(), //1
                EncryptionManager.Instance.EncryptPassword(dynamicTemplate.Password).ToString(), //2
                dynamicTemplate.ServerPort, //3
                dynamicTemplate.ServerAddress.Replace("'", "''").ToString(),//4
                _requestRepository.CurrentOperator.EmployeeId, //5
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//6
                dynamicTemplate.HasAttachment ? 1 : 0, //7
                dynamicTemplate.InActive ? 1 : 0, //8
                dynamicTemplate.EnableSSL ? 1 : 0, //9
                dynamicTemplate.DTEmailType.GetHashCode(), //10
                reportId //11
                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateDynamicTemplate(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int reportId = -1;
                if (dynamicTemplate.EmployeeReports != null && dynamicTemplate.EmployeeReports.Count == 1)
                {
                    reportId = dynamicTemplate.EmployeeReports[0].ReportId;
                }
                else
                {
                    reportId = dynamicTemplate.ReportID;
                }

                string query = string.Format(@" UPDATE DT set 
                Email = '{0}', Password = '{1}', ServerPort = {2}, ServerAddress = '{3}', UpdatedBy = {4}, UpdatedDate = {5}, HasAttachment = {6}, Inactive = {7}, EnableSSL = {9}, EmailTypeID = {10}, ReportID = {11} where TemplateID = {8}",
                dynamicTemplate.Email.Replace("'", "''").ToString(), //0
                EncryptionManager.Instance.EncryptPassword(dynamicTemplate.Password).ToString(), //1
                dynamicTemplate.ServerPort, //2
                dynamicTemplate.ServerAddress.Replace("'", "''").ToString(),//3
                _requestRepository.CurrentOperator.EmployeeId, //4
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//5
                dynamicTemplate.HasAttachment ? 1 : 0, //6
                dynamicTemplate.InActive ? 1 : 0, //7
                dynamicTemplate.TemplateId, //8
                dynamicTemplate.EnableSSL ? 1 : 0, //9
                dynamicTemplate.DTEmailType.GetHashCode(), //10
                reportId //11
                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveDynamicTemplateEmailTypes(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var values = new StringBuilder();
                if (dynamicTemplate.DTEmailType != DynamicTemplateEmailTypes.Employee)
                    foreach (DynamicTemplateReportTypeModel type in dynamicTemplate.EmailTypes)
                    {
                        values.AppendFormat(" ({0},{1},{2}),", dynamicTemplate.TemplateId, type.ReportTypeId, -1);
                    }
                else
                {
                    foreach (DynamicTemplateEmployeeReportTypes type in dynamicTemplate.EmployeeReports)
                    {
                        values.AppendFormat(" ({0},{1},{2}),", dynamicTemplate.TemplateId, type.ReportTypeId, type.ReportId);
                    }
                }
                string query = string.Format(@"Insert Into DTEmailReportType (TemplateID, ReportTypeID, ReportID) Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDynamicTemplateEmailTypes(int templateId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Delete From DTEmailReportType where TemplateID = {templateId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveDynamicTemplateEmailReceiver(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            try
            {
                //Employees
                if (dynamicTemplate.DynamicTemplateReceiverEmployees != null && dynamicTemplate.DynamicTemplateReceiverEmployees.Count > 0)
                {
                    foreach (EmployeeModel employee in dynamicTemplate.DynamicTemplateReceiverEmployees)
                    {
                        query = $@"INSERT INTO DynamicTemplateEmailReceiver(TemplateID, EmployeeID, SecurityGroupID) values ({dynamicTemplate.TemplateId},{employee.EmployeeId}, -1)";
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            result = GlobalErrors.Error;
                            break;
                        }
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
                //Security group
                if (dynamicTemplate.DynamicTemplateReceiverSGs != null && dynamicTemplate.DynamicTemplateReceiverSGs.Count > 0)
                {
                    foreach (SecurityGroupModel securityGroup in dynamicTemplate.DynamicTemplateReceiverSGs)
                    {
                        query = $@"INSERT INTO DynamicTemplateEmailReceiver(TemplateID, EmployeeID, SecurityGroupID) values ({dynamicTemplate.TemplateId},-1,{securityGroup.SecurityGroupId})";
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            result = GlobalErrors.Error;
                            break;
                        }
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveDynamicTemplateAssignment(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            int maxAssignmentId = -1;
            try
            {
                maxAssignmentId = GetMaxId("TemplateAssignmentID", "DTAssignment", dBHelper);
                if (dynamicTemplate.DTEmailType == DynamicTemplateEmailTypes.Customer)
                {
                    if (dynamicTemplate.AllCustomers)
                    {
                        if (maxAssignmentId > 0)
                        {
                            query = $@"INSERT INTO DTAssignment (TemplateAssignmentID,TemplateID,AllCustomers) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{(dynamicTemplate.AllCustomers ? 1 : 0)})";
                            result = dBHelper.ExecuteNonQuery(query);
                        }
                    }
                    else
                    {
                        // customers
                        if (dynamicTemplate.DynamicTemplateCustomers != null && dynamicTemplate.DynamicTemplateCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel custOut in dynamicTemplate.DynamicTemplateCustomers)
                            {
                                query = $@"INSERT INTO DTAssignment(TemplateAssignmentID,TemplateID,CustomerID,OutletID) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{custOut.CustomerId},{custOut.OutletId})";
                                result = dBHelper.ExecuteNonQuery(query);
                                maxAssignmentId++;
                                if (result != GlobalErrors.Success)
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        // groups
                        if (dynamicTemplate.DynamicTemplateGroups != null && dynamicTemplate.DynamicTemplateGroups.Count > 0)
                        {
                            foreach (CustomerGroupModel group in dynamicTemplate.DynamicTemplateGroups)
                            {
                                query = $@"INSERT INTO DTAssignment(TemplateAssignmentID,TemplateID,GroupID) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{group.GroupId})";
                                result = dBHelper.ExecuteNonQuery(query);
                                maxAssignmentId++;
                                if (result != GlobalErrors.Success)
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        // channels
                        if (dynamicTemplate.DynamicTemplateChannels != null && dynamicTemplate.DynamicTemplateChannels.Count > 0)
                        {
                            foreach (CustomerChannelModel channel in dynamicTemplate.DynamicTemplateChannels)
                            {

                                query = $@"INSERT INTO DTAssignment(TemplateAssignmentID,TemplateID,ChannelID,SubChannelID) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{channel.ChannelSubChannelIds.Split('-')[0]},{channel.ChannelSubChannelIds.Split('-')[1]})";
                                result = dBHelper.ExecuteNonQuery(query);
                                maxAssignmentId++;
                                if (result != GlobalErrors.Success)
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        // employees
                        // ..
                        // securityGroups
                        // ..
                    }
                }
                else if (dynamicTemplate.DTEmailType == DynamicTemplateEmailTypes.Employee)
                {
                    if (dynamicTemplate.AllEmployees)
                    {
                        if (maxAssignmentId > 0)
                        {
                            query = $@"INSERT INTO DTAssignment (TemplateAssignmentID,TemplateID,AllEmployees) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{(dynamicTemplate.AllEmployees ? 1 : 0)})";
                            result = dBHelper.ExecuteNonQuery(query);
                        }
                    }
                    else
                    {
                        //Employees
                        if (dynamicTemplate.DynamicTemplateEmployees != null && dynamicTemplate.DynamicTemplateEmployees.Count > 0)
                        {
                            foreach (EmployeeModel employee in dynamicTemplate.DynamicTemplateEmployees)
                            {
                                query = $@"INSERT INTO DTAssignment(TemplateAssignmentID,TemplateID,EmployeeID) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{employee.EmployeeId})";
                                result = dBHelper.ExecuteNonQuery(query);
                                maxAssignmentId++;
                                if (result != GlobalErrors.Success)
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        //Security group
                        if (dynamicTemplate.DynamicTemplateSGs != null && dynamicTemplate.DynamicTemplateSGs.Count > 0)
                        {
                            foreach (SecurityGroupModel securityGroup in dynamicTemplate.DynamicTemplateSGs)
                            {
                                query = $@"INSERT INTO DTAssignment(TemplateAssignmentID,TemplateID,SecurityGroupID) values ({maxAssignmentId},{dynamicTemplate.TemplateId},{securityGroup.SecurityGroupId})";
                                result = dBHelper.ExecuteNonQuery(query);
                                maxAssignmentId++;
                                if (result != GlobalErrors.Success)
                                {
                                    result = GlobalErrors.Error;
                                    break;
                                }
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveDynamicTemplateOrganizations(DynamicTemplateModel dynamicTemplate, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                var values = new StringBuilder();
                foreach (OrganizationModel org in dynamicTemplate.OrganizationsList)
                {
                    values.AppendFormat(" ({0},{1}),", dynamicTemplate.TemplateId, org.OrganizationId);
                }
                string query = string.Format(@"Insert Into DTOrganization (TemplateID, OrganizationID) Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDynamicTemplateEmailReceiver(int templateId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string custGroupFilter = string.Empty;
            try
            {
                string query = $@"DELETE FROM DynamicTemplateEmailReceiver Where DynamicTemplateEmailReceiver.TemplateID = {templateId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDynamicTemplateAssignment(int templateId, bool isAppliedOnAllCustomers, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string custGroupFilter = string.Empty;
            StringBuilder OrgJoin = new StringBuilder();

            OrgJoin.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "DTA", _requestRepository.CurrentOperator.OrganizationAccess);

            try
            {
                if (!isAppliedOnAllCustomers)
                {
                    string query = $@"Delete DTA from DTAssignment DTA
                    {OrgJoin}
                    where DTA.templateId = {templateId} ";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                    if (result == GlobalErrors.Success)
                    {
                        if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                        {
                            custGroupFilter = $@"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";
                        }
                        query = $@"Delete DTA from DTAssignment DTA
                        INNER JOIN CustomerGroup on CustomerGroup.GroupID = DTA.GroupID {custGroupFilter}
                        where DTA.templateId = {templateId} ";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;

                        if (result == GlobalErrors.Success)
                        {
                            query = $@"Delete DTA from DTAssignment DTA
                            where ISNULL(DTA.CustomerID,-1 ) = -1 and ISNULL(DTA.OutletID,-1 ) = -1 and ISNULL(DTA.GroupID, -1) = -1 and DTA.templateId = {templateId} ";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                result = GlobalErrors.Success;
                        }
                    }
                }
                else
                {
                    string query = $@"DELETE FROM DTAssignment Where DTAssignment.TemplateID = {templateId}";
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDynamicTemplateOrganizations(int templateId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" Delete from DTOrganization where TemplateID = {templateId} and DTOrganization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplates(ref List<DynamicTemplateModel> dynamicTemplates, int dynamicTemplateEmailType)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DynamicTemplateModel> dBHelper = new DBHelper<DynamicTemplateModel>();

                string query = $@" select distinct DT.TemplateID, DT.Email, DT.ServerPort, DT.ServerAddress, DT.HasAttachment, DT.Inactive,
                DTLanguage.Description as TemplateName ,
CASE WHEN DT.EmailTypeID = 1 THEN 'Desc_Customer' WHEN DT.EmailTypeID = 2 THEN 'Desc_Employee' WHEN DT.EmailTypeID = 3 THEN 'Desc_Custom_Report' END EmailTypeDescription, 
CASE WHEN Inactive = 1 THEN 'Desc_Inactive'  ELSE 'Desc_Active' END Status
                from DT
				INNER JOIN DTOrganization on DTOrganization.TemplateID = DT.TemplateID 
                LEFT JOIN  DTLanguage on DTLanguage.TemplateID = DT.TemplateID and DTLanguage.LanguageID = {_requestRepository.LanguageId} 
                where DTOrganization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) and DT.EmailTypeID = {dynamicTemplateEmailType}";
                result = dBHelper.GetQueryList(query, ref dynamicTemplates);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateMainData(int templateId, ref DynamicTemplateModel dynamicTemplateObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DynamicTemplateModel> dBHelper = new DBHelper<DynamicTemplateModel>();
                string query = string.Format(@" select DT.templateId, DT.Email, DT.Password,DT.ServerPort,DT.ServerAddress,DT.HasAttachment,DT.Inactive,DTLanguage.Description as TemplateName, DT.EnableSSL, DT.ReportID, DT.EmailTypeID  as DTEmailType
                from DT 
                left join DTLanguage on DTLanguage.templateId = DT.templateId and DTLanguage.LanguageID = {1}
                where  DT.templateId = {0}", templateId, _requestRepository.LanguageId);
                result = dBHelper.GetQuerySingle(query, ref dynamicTemplateObj);
                if (result == GlobalErrors.Success && dynamicTemplateObj != null && dynamicTemplateObj.Password != null)
                {
                    dynamicTemplateObj.Password = EncryptionManager.Instance.DecryptPassword(dynamicTemplateObj.Password);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateLanguages(int templateId, ref List<DynamicTemplateLanguageModel> tempLanguages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DynamicTemplateLanguageModel> dBHelper = new DBHelper<DynamicTemplateLanguageModel>();
                string query = $@"select * from DTLanguage where TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref tempLanguages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeDynamicTemplate(int templateId, ref List<DynamicTemplateEmployeeReportTypes> tempTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DynamicTemplateEmployeeReportTypes> dBHelper = new DBHelper<DynamicTemplateEmployeeReportTypes>();
                string query = $@"
select DTEmailReportType.ReportTypeID as ReportTypeID , DTReportTypeLanguage.Description as ReportTypeDescription, DTEmailReportType.ReportID, DynamicReportFile.FileName as ReportDescription
                from DTEmailReportType 
                Left join  DTReportTypeLanguage on DTReportTypeLanguage.ReportTypeID = DTEmailReportType.ReportTypeID and DTReportTypeLanguage.LanguageID =  {_requestRepository.LanguageId}
				inner join DynamicReportFile on DynamicReportFile.ReportId = DTEmailReportType.ReportID
                where DTEmailReportType.TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref tempTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateTypes(int templateId, ref List<DynamicTemplateReportTypeModel> tempTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DynamicTemplateReportTypeModel> dBHelper = new DBHelper<DynamicTemplateReportTypeModel>();
                string query = $@"select DTEmailReportType.ReportTypeID as ReportTypeID , DTReportTypeLanguage.Description as ReportTypeDescription
                from DTEmailReportType 
                Left join  DTReportTypeLanguage on DTReportTypeLanguage.ReportTypeID = DTEmailReportType.ReportTypeID and DTReportTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                where DTEmailReportType.TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref tempTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsDynamicTemplateAssignedToAllCustomers(int templateId, ref bool boolValue, string boolType)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object isBoolValue = false;
                string query = $@"select ISNULL(DTAssignment.{boolType},0) as {boolType} from DTAssignment where DTAssignment.TemplateId = {templateId}";
                result = dBHelper.ExecuteScalar(query, ref isBoolValue);
                if (result == GlobalErrors.Success && isBoolValue != null)
                {
                    boolValue = Convert.ToBoolean(isBoolValue);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateReceiverEmployees(int templateId, ref List<EmployeeModel> tempEmployees)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();
                string query = $@"select DynamicTemplateEmailReceiver.EmployeeID as EmployeeID, IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from DynamicTemplateEmailReceiver
                Inner join Employee on Employee.EmployeeID = DynamicTemplateEmailReceiver.EmployeeID
                inner join EmployeeLanguage on DynamicTemplateEmailReceiver.EmployeeID=EmployeeLanguage.EmployeeID 
                where EmployeeLanguage.LanguageID = {_requestRepository.LanguageId} and DynamicTemplateEmailReceiver.EmployeeID > -1 and DynamicTemplateEmailReceiver.TemplateID={templateId} and Employee.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                result = dBHelper.GetQueryList(query, ref tempEmployees);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateEmployees(int templateId, ref List<EmployeeModel> tempEmployees)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();
                string query = $@"select DTAssignment.EmployeeID as EmployeeID, IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from DTAssignment
                Inner join Employee on Employee.EmployeeID = DTAssignment.EmployeeID
                inner join EmployeeLanguage on DTAssignment.EmployeeID=EmployeeLanguage.EmployeeID 
                where EmployeeLanguage.LanguageID = {_requestRepository.LanguageId} and DTAssignment.TemplateID={templateId} and Employee.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                result = dBHelper.GetQueryList(query, ref tempEmployees);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateReceiverSecurityGroups(int templateId, ref List<SecurityGroupModel> tempSecurityGroups)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SecurityGroupModel> dBHelper = new DBHelper<SecurityGroupModel>();
                string query = $@"select SecurityGroupLanguage.SecurityGroupId,SecurityGroupLanguage.Description SecurityGroupName from DynamicTemplateEmailReceiver 
                                                Inner Join SecurityGroup on SecurityGroup.SecurityGroupId = DynamicTemplateEmailReceiver.SecurityGroupId
                                                Left join SecurityGroupLanguage on DynamicTemplateEmailReceiver.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID and SecurityGroupLanguage.LanguageID = {_requestRepository.LanguageId}
                                                where DynamicTemplateEmailReceiver.SecurityGroupID > -1 and DynamicTemplateEmailReceiver.TemplateID = {templateId} and SecurityGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";
                result = dBHelper.GetQueryList(query, ref tempSecurityGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateSecurityGroups(int templateId, ref List<SecurityGroupModel> tempSecurityGroups)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SecurityGroupModel> dBHelper = new DBHelper<SecurityGroupModel>();
                string query = $@"select SecurityGroupLanguage.SecurityGroupId,SecurityGroupLanguage.Description SecurityGroupName from DTAssignment 
                                                Inner Join SecurityGroup on SecurityGroup.SecurityGroupId = DTAssignment.SecurityGroupId
                                                Left join SecurityGroupLanguage on DTAssignment.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID and SecurityGroupLanguage.LanguageID = {_requestRepository.LanguageId}
                                                where DTAssignment.TemplateID = {templateId} and SecurityGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";
                result = dBHelper.GetQueryList(query, ref tempSecurityGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateCustomers(int templateId, ref List<SimpleCustomerModel> tempCustomers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            StringBuilder orgAccess = new StringBuilder();
            try
            {
                DBHelper<SimpleCustomerModel> dBHelper = new DBHelper<SimpleCustomerModel>();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                { 
                    orgAccess.AppendFormat(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);                    
                }
                string query = $@"select distinct DTAssignment.CustomerID, DTAssignment.OutletID,
                IsNull( Customer.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description  , '--') as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description  , '--') as OutletCodeName
                from DTAssignment
                inner join Customer on Customer.CustomerID = DTAssignment.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = DTAssignment.CustomerID and CustomerOutlet.OutletID = DTAssignment.OutletID
                {orgAccess}
                left join CustomerLanguage on CustomerLanguage.CustomerID =  DTAssignment.CustomerID and CustomerLanguage.LanguageID = {_requestRepository.LanguageId}
                left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = DTAssignment.CustomerID and 
                CustomerOutletLanguage.OutletID = DTAssignment.OutletID and CustomerOutletLanguage.LanguageID = {_requestRepository.LanguageId}
                where DTAssignment.TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref tempCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateGroups(int templateId, ref List<CustomerGroupModel> tempGroups)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string orgAccess = string.Empty;

            try
            {
                DBHelper<CustomerGroupModel> dBHelper = new DBHelper<CustomerGroupModel>();
                if (_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    orgAccess = @$" and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                }
                string query = @$" select distinct DTAssignment.GroupID, 
                IsNull(CustomerGroup.GroupCode, '--') + ' - ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName
                from DTAssignment
                inner join CustomerGroup on CustomerGroup.GroupID = DTAssignment.GroupID
                left join CustomerGroupLanguage on CustomerGroupLanguage.GroupID = DTAssignment.GroupID and CustomerGroupLanguage.LanguageID = {_requestRepository.LanguageId}
                where DTAssignment.TemplateID = {templateId} {orgAccess} ";
                result = dBHelper.GetQueryList(query, ref tempGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateChannels(int templateId, ref List<CustomerChannelModel> tempChannels)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerChannelModel> dBHelper = new DBHelper<CustomerChannelModel>();

                string query = $@"select DTAssignment.GroupID, 
                (CONVERT(varchar(10),DTAssignment.ChannelID) + '-' + CONVERT(varchar(10),DTAssignment.SubChannelID)) ChannelSubChannelIds,
                (CH.Description + '-' + SCH.Description) ChannelSubChannelDescriptions
                from DTAssignment
                Inner JOIN ChannelLanguage CH on CH.ChannelID = DTAssignment.ChannelID and CH.LanguageID = {_requestRepository.LanguageId}
                left JOIN SubChannelLanguage SCH on SCH.SubChannelID = DTAssignment.SubChannelID and SCH.LanguageID = {_requestRepository.LanguageId}
                where DTAssignment.TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref tempChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateEmailTypes(int emailTypeId, ref List<DynamicTemplateReportTypeModel> emailTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string templateTypeFilter = string.Empty;

            try
            {
                if (emailTypeId > 0)
                {
                    DBHelper<DynamicTemplateReportTypeModel> dBHelper = new DBHelper<DynamicTemplateReportTypeModel>();
                    string query = $@"Select DTReportType.ReportTypeID, DTReportTypeLanguage.Description as ReportTypeDescription from DTReportType
                    Inner Join DTReportTypeLanguage on DTReportTypeLanguage.ReportTypeID = DTReportType.ReportTypeID and DTReportTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                    where DTReportType.ReportTypeID <> {EmailReportTypes.Delivery.GetHashCode()} and DTReportType.EmailTypeID = {emailTypeId}";
                    result = dBHelper.GetQueryList(query, ref emailTypes);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicTemplateReportFiles(int transactionTypeId, ref List<DynamicTemplateReportFileModel> reportFiles)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                DBHelper<DynamicTemplateReportFileModel> dBHelper = new DBHelper<DynamicTemplateReportFileModel>();
                string query = $@" select reportId, ReportTypeId, FileName,FileName as reportDescription from DynamicReportFile  where ReportTypeId like '%{transactionTypeId}%'";
                result = dBHelper.GetQueryList(query, ref reportFiles);
                if (result == GlobalErrors.Success && reportFiles != null && reportFiles.Count > 0)
                {
                    var res = new List<DynamicTemplateReportFileModel>();
                    foreach (DynamicTemplateReportFileModel file in reportFiles)
                    {
                        var reportTypesList = file.ReportTypeId.Split(",").ToList();
                        int i = reportTypesList.FindIndex(f => int.Parse(f) == transactionTypeId);
                        if (i > -1)
                        {
                            res.Add(file);
                        }
                    }
                    reportFiles = res;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateOrganizations(int templateId, ref List<OrganizationModel> organizationsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<OrganizationModel> dBHelper = new DBHelper<OrganizationModel>();

                string query = $@" SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName,
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM DTOrganization
                INNER JOIN Organization on DTOrganization.OrganizationID = Organization.OrganizationID
                left outer join OrganizationLanguage  on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {_requestRepository.LanguageId}
                WHERE Organization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) and DTOrganization.TemplateID = {templateId}";
                result = dBHelper.GetQueryList(query, ref organizationsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateDynamicTemplateActiveStatus(DynamicTemplateModel dynamicTemplate)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                string query = $@"
                Update DT set Inactive ={(dynamicTemplate.InActive ? 1 : 0)} ,
                UpdatedBy = {_requestRepository.CurrentOperator.EmployeeId} ,
                UpdatedDate = {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}
                where TemplateId = {dynamicTemplate.TemplateId}";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareReportModelQuery(int languageId, EmailFilter filter, ref ReportModel reportModel, int templateId, DynamicTemplateEmployeeReportTypes reportType)
        {
            var result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<dynamic>();
            List<dynamic> rawData = new List<dynamic>();
            try
            {
                reportType.Query = reportType.Query.Replace("@LanguageID", languageId.ToString());
                reportType.Query = reportType.Query.Replace("@RouteHistoryID", filter.RouteHistoryID.ToString());
                reportType.Query = reportType.Query.Replace("@EmployeeID", filter.EmployeeID.ToString());
                if (filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode())
                    reportType.Query = reportType.Query.Replace("@TransactionID", filter.TransactionId.ToString());

                result = dBHelper.GetQueryList(reportType.Query, ref rawData);

                if (result == GlobalErrors.Success && rawData != null)
                {
                    reportModel.Customers = new List<dynamic>();
                    if (reportType.ReportTypeId == EmailReportTypes.DepositReport.GetHashCode())
                    {
                        if (result == GlobalErrors.Success && !String.IsNullOrEmpty(rawData[0].SettlementData.ToString()))
                        {
                            dynamic depositReport = new System.Dynamic.ExpandoObject();
                            string[] data = rawData[0].SettlementData.ToString().Split('|');
                            depositReport.VarianceAmount = Decimal.Parse(data[0]);
                            depositReport.SalesCash = Decimal.Parse(data[1]);
                            depositReport.SalesCashCheck = Decimal.Parse(data[2]);
                            depositReport.SalesTotal = depositReport.SalesCash + depositReport.SalesCashCheck;
                            depositReport.CollectionCash = Decimal.Parse(data[3]);
                            depositReport.CollectionCashCheck = Decimal.Parse(data[4]);
                            depositReport.CollectionTotal = depositReport.CollectionCash + depositReport.CollectionCashCheck;
                            depositReport.TotalCash = depositReport.CollectionCash + depositReport.SalesCash;
                            depositReport.TotalCashCheck = depositReport.CollectionCashCheck + depositReport.SalesCashCheck;
                            depositReport.TotalSalesDeposit = depositReport.TotalCash + depositReport.TotalCashCheck;
                            depositReport.TotalCashDue = depositReport.CollectionCash + depositReport.SalesCash + depositReport.VarianceAmount;
                            depositReport.TotalDenomination = new decimal(0);
                            for (int i = 0; i < data.Length; i++)
                            {

                                if (data[i] != null)
                                {
                                    if (data[i].Contains("*"))
                                    {
                                        if (!data[i].Contains("Coins"))
                                        {
                                            depositReport.TotalDenomination = depositReport.TotalDenomination + decimal.Parse(data[i + 1]) * decimal.Parse(data[i].Replace("*", String.Empty));
                                        }
                                        else
                                        {
                                            depositReport.TotalDenomination = depositReport.TotalDenomination + decimal.Parse(data[i + 1]);
                                        }

                                    }
                                }

                            }
                            reportModel.Customers.Add(depositReport);
                            string[] denominations = rawData[0].SettlementData.ToString().Split('*');
                            dynamic denomination = new System.Dynamic.ExpandoObject();
                            decimal totalAmount = 0;
                            for (int i = 1; i < denominations.Count(); i++)
                            {
                                denomination = new System.Dynamic.ExpandoObject();
                                string[] denominationData = denominations[i].Split('|');
                                denomination.No = denominationData[0];
                                denomination.Qty = Decimal.Parse(denominationData[1]);
                                if (i != denominations.Count() - 1)
                                    denomination.Amount = Decimal.Parse(denominationData[0]) * Decimal.Parse(denominationData[1]);
                                else
                                    denomination.Amount = Decimal.Parse(denominationData[1]);
                                reportModel.TransactionDetails.Add(denomination);
                                totalAmount = totalAmount + Decimal.Parse(((decimal)denomination.Amount).ToString());
                            }
                            denomination = new System.Dynamic.ExpandoObject();
                            denomination.No = "Total";
                            denomination.Qty = 0;
                            denomination.Amount = totalAmount;
                            reportModel.TransactionDetails.Add(denomination);
                        }
                    }
                    else if (reportType.ReportTypeId == EmailReportTypes.RouteSummaryReport.GetHashCode())
                    {
                        var routeSummary = new ExpandoObject() as IDictionary<string, Object>;
                        for (int i = 0; i < rawData.Count; i++)
                        {
                            try
                            {
                                routeSummary.Add(rawData[i].SummaryType.Trim().Replace(" ", ""), decimal.Parse(rawData[i].SummaryTypeValue));
                            }
                            catch
                            {
                                routeSummary.Add(rawData[i].SummaryType.Trim().Replace(" ", ""), rawData[i].SummaryTypeValue);
                            }
                        }
                        reportModel.Customers.Add(routeSummary);
                    }
                    else if (reportType.ReportTypeId == EmailReportTypes.LoadRequest.GetHashCode() || reportType.ReportTypeId == EmailReportTypes.OffloadRequest.GetHashCode())
                    {
                        //reportModel.Customers = rawData;
                        reportModel.TransactionDetails = rawData;
                    }
                    else
                    {
                        reportModel.Customers = rawData;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CacheEmailData(string templatesId, ref EmployeeModel sender, ref List<dynamic> receivers, int routeHistoryID, ref string endOfDayDate, int languageId, ref string routeName, ref string routeCode)
        {
            var result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<dynamic>();
            dynamic rawData = new System.Dynamic.ExpandoObject();
            try
            {
                string query = $@" select distinct Employee.EmployeeCode,EmployeeLanguage.Description as EmployeeName, RouteHistory.ActualEnd, routelanguage.Description as RouteName, Route.RouteCode as RouteCode from Employee
                inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = employee.EmployeeID
                inner join RouteHistory on RouteHistory.EmployeeID = Employee.EmployeeID
				inner join Route on route.RouteID =routehistory.RouteID
				inner join Routelanguage on routelanguage.RouteID =route.RouteID
                where EmployeeLanguage.EmployeeID = {sender.EmployeeId} and RouteHistory.RouteHistoryID = {routeHistoryID} and EmployeeLanguage.LanguageID = {languageId} ";
                result = dBHelper.GetQuerySingle(query, ref rawData);
                // this query get distinct recivers assigned in template, and will add supervisor for route employee to the recivers list
                if (result == GlobalErrors.Success && rawData != null)
                {
                    sender.EmployeeCode = rawData.EmployeeCode;
                    sender.EmployeeName = rawData.EmployeeName;
                    endOfDayDate = rawData.ActualEnd == null ? "" : rawData.ActualEnd.ToString();
                    routeName = rawData.RouteName;
                    routeCode = rawData.RouteCode;
                    query = $@"select distinct t.* from (  select Employee.EmployeeId, DynamicTemplateEmailReceiver.TemplateId,  Employee.EmployeeCode,EmployeeLanguage.Description as EmployeeName, isnull(Employee.Email,'') Email from DynamicTemplateEmailReceiver
                     inner join Employee on Employee.EmployeeID = DynamicTemplateEmailReceiver.EmployeeID
                     inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = employee.EmployeeID
                     where DynamicTemplateEmailReceiver.EmployeeID >= 0 and EmployeeLanguage.LanguageID = {languageId} and Employee.Email <> '' and DynamicTemplateEmailReceiver.TemplateId in({templatesId})
                     union 
                     select Employee.EmployeeId, DynamicTemplateEmailReceiver.TemplateId, Employee.EmployeeCode,EmployeeLanguage.Description as EmployeeName, isnull(Employee.Email,'') Email from DynamicTemplateEmailReceiver
                     inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = DynamicTemplateEmailReceiver.SecurityGroupID
                     inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
                     inner join Employee on Employee.EmployeeID =  EmployeeOperator.EmployeeID
                     inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = employee.EmployeeID
                     where DynamicTemplateEmailReceiver.SecurityGroupID> 0 and EmployeeLanguage.LanguageID = {languageId}  and Employee.Email <> '' and DynamicTemplateEmailReceiver.TemplateId in({templatesId})
                     union 
                     select Employee.EmployeeId, DTA.TemplateID as TemplateId,Employee.EmployeeCode,EmployeeLanguage.Description as EmployeeName, isnull(Employee.Email,'') Email from EmployeeSupervisor 
                     inner join Employee on Employee.EmployeeID = EmployeeSupervisor.SupervisorID
                     inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = EmployeeSupervisor.SupervisorID
                     inner join DTAssignment DTA on DTA.employeeID = EmployeeSupervisor.EmployeeID
                     where EmployeeSupervisor.EmployeeID = {sender.EmployeeId} and EmployeeLanguage.LanguageID = {languageId}  and Employee.Email <> ''
					 UNION 
					 select Employee.EmployeeId, DTA.TemplateID as TemplateId,Employee.EmployeeCode,EmployeeLanguage.Description as EmployeeName, isnull(Employee.Email,'') Email from EmployeeSupervisor 
                     inner join Employee on Employee.EmployeeID = EmployeeSupervisor.SupervisorID
                     inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = EmployeeSupervisor.SupervisorID
					 inner join DTAssignment DTA on DTA.TemplateID in ({templatesId})
					  inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = DTA.SecurityGroupID
                     inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
					  where EmployeeSupervisor.EmployeeID = {sender.EmployeeId} and EmployeeLanguage.LanguageID = {languageId}  and Employee.Email <> '' 
)t";
                    result = dBHelper.GetQueryList(query, ref receivers);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetOperationData(EmailFilter filter, int languageId, ref List<dynamic> detailsList)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            var dBHelper = new DBHelper<dynamic>();
            try
            {
                if (filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || filter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode())
                {
                    int TransactionOperationID = -1;
                    if (filter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode())
                        TransactionOperationID = WarehouseTransactionOperation.LoadRequest.GetHashCode();
                    else
                        TransactionOperationID = WarehouseTransactionOperation.Offload.GetHashCode();
                    //warehouse.. ref 
                    query = string.Format(@" SELECT WarehouseTransaction.TransactionID, WarehouseTransaction.TransactionDate, WarehouseLanguage.Description AS VehicleName, Warehouse.WarehouseCode AS VehicleCode, 
                        RefWarehouseLanguage.Description AS RefWarehouseName, RefWarehouse.WarehouseCode AS RefWarehouseCode, EmployeeLanguage.Description AS RequestedBy
                        FROM     WarehouseTransaction INNER JOIN
                                        Warehouse ON WarehouseTransaction.WarehouseID = Warehouse.WarehouseID INNER JOIN
                                        WarehouseLanguage ON WarehouseLanguage.WarehouseID = Warehouse.WarehouseID AND WarehouseLanguage.LanguageID = {0} INNER JOIN
                                        Employee ON Employee.EmployeeID = WarehouseTransaction.RequestedBy INNER JOIN
                                        EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0} LEFT OUTER JOIN
                                        Warehouse AS RefWarehouse ON WarehouseTransaction.RefWarehouseID = RefWarehouse.WarehouseID LEFT OUTER JOIN
                                        WarehouseLanguage AS RefWarehouseLanguage ON RefWarehouse.WarehouseID = RefWarehouseLanguage.WarehouseID AND RefWarehouseLanguage.LanguageID = {0}
                        WHERE  (WarehouseTransaction.TransactionID = '{1}') AND (WarehouseTransaction.DivisionID = {2}) AND ( WarehouseTransaction.TransactionOperationID = {3})", languageId, filter.TransactionId, filter.DivisionId, TransactionOperationID);
                }
                else if (filter.ReportTypeID == EmailReportTypes.NewCustomer.GetHashCode())
                {
                    query = string.Format(@" SELECT Customer.CustomerID, CustomerLanguage.Description CustomerName,Customer.CustomerCode, Customer.Phone CustomerPhone, Customer.Email CustomerEmail, CustomerLanguage.Address CustomerAddress, 
                        CustomerOutlet.OutletID, CustomerOutlet.CustomerCode OutletCode, CustomerOutlet.Phone OutletPhone, CustomerOutlet.Email AS OutletEmail, CustomerOutletLanguage.Address OutletAddress, EmployeeLanguage.Description CreatedBy
                        FROM     Customer INNER JOIN
                                          NewCustomerHistory ON Customer.CustomerID = NewCustomerHistory.NewCustomerID LEFT OUTER JOIN
                                          CustomerLanguage ON Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0} INNER JOIN
                                          CustomerOutlet ON CustomerOutlet.CustomerID = NewCustomerHistory.NewCustomerID AND NewCustomerHistory.NewOutletID = CustomerOutlet.OutletID LEFT OUTER JOIN
                                          CustomerOutletLanguage ON CustomerOutletLanguage.CustomerID = Customer.CustomerID AND CustomerOutletLanguage.LanguageID = {0} LEFT OUTER JOIN
                                          EmployeeLanguage ON EmployeeLanguage.EmployeeID = NewCustomerHistory.CreatedBy AND EmployeeLanguage.LanguageID = {0}
                        WHERE  (NewCustomerHistory.RouteHistoryID = {1})", languageId, filter.RouteHistoryID);
                }
                result = dBHelper.GetQueryList(query, ref detailsList);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTemplateReports(int languageId, int tempID, ref List<DynamicTemplateEmployeeReportTypes> reportIds)
        {
            var result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<DynamicTemplateEmployeeReportTypes>();
            try
            {
                string query = "";
                query = $@"
select DTEmailReportType.ReportTypeID as ReportTypeID , DTReportTypeLanguage.Description as ReportTypeDescription, DTEmailReportType.ReportID, DynamicReportFile.FileName as ReportDescription, DynamicReportFile.Query
                from DTEmailReportType 
                Left join  DTReportTypeLanguage on DTReportTypeLanguage.ReportTypeID = DTEmailReportType.ReportTypeID and DTReportTypeLanguage.LanguageID = {languageId}
				left join DynamicReportFile on DynamicReportFile.ReportId = DTEmailReportType.ReportID
                where DTEmailReportType.TemplateID = {tempID}";
                result = dBHelper.GetQueryList(query, ref reportIds);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeDynamicTemplateForMail(EmailFilter emailFilter, int languageId, ref List<DynamicTemplateModel> dynamicTemplate)
        {
            var result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<DynamicTemplateModel>();
            string filter = string.Empty;
            try
            {
                if (emailFilter.ReportTypeID == EmailReportTypes.LoadRequest.GetHashCode() || emailFilter.ReportTypeID == EmailReportTypes.OffloadRequest.GetHashCode() || emailFilter.ReportTypeID == EmailReportTypes.NewCustomer.GetHashCode())
                {
                    filter = string.Format(@" and DTEmailReportType.ReportTypeId = {0}", emailFilter.ReportTypeID);
                }
                else
                {
                    filter = string.Format(@" and DTEmailReportType.ReportTypeId not in (13, 14, 15)");
                }
                string query = "";
                query = string.Format(@"select  * 
                                  from DT
                                  inner join (     
                                  select DTA.TemplateID from DTAssignment DTA                          
                                  where DTA.EmployeeID = {1}                   
                                  union                      
                                  select DTA.TemplateID from DTAssignment DTA                      
                                  inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = DTA.SecurityGroupID
								  inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
								  inner join Employee on Employee.EmployeeID =  EmployeeOperator.EmployeeID
								  inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = employee.EmployeeID
								  where Employee.EmployeeID = {1}                       
                                  union
                                  select DTA.TemplateID from DTAssignment DTA  
                                  where  DTA.AllEmployees = 1
                                  ) DTA on DTA.TemplateID = DT.TemplateID and DTA.TemplateID is not null
                                  inner JOIN DTEmailReportType on DTEmailReportType.TemplateID = DT.TemplateID
                                  left join DTLanguage DTL on DTL.TemplateID = DT.TemplateID and LanguageID = {2}
                                  where DT.Inactive <> 1  
                                  {0}", filter, emailFilter.EmployeeID, languageId, emailFilter.ReportTypeID + "");
                /*    query = $@"select top 1 * 
                                      from DT
                                      inner join (     
                                      select DTA.TemplateID, 1 as priority from DTAssignment DTA                          
                                      where DTA.EmployeeID = {emailFilter.EmployeeID}                   
                                      union                      
                                      select DTA.TemplateID, 2 as priority from DTAssignment DTA                      
                                      where DTA.SecurityGroupID  in ({GetEmployeeSecurityGroups(emailFilter.EmployeeID)})                      
                                      union
                                      select DTA.TemplateID, 3 as priority from DTAssignment DTA  
                                      where  DTA.AllEmployees = 1
                                      ) DTA on DTA.TemplateID = DT.TemplateID and DTA.TemplateID is not null
                                      left join DTLanguage DTL on DTL.TemplateID = DT.TemplateID and LanguageID = { languageId}
                                      inner join DTEmailReportType DTE on DTE.TemplateID = DT.TemplateID 
                                      where DT.Inactive <> 1 order by DTA.priority";*/

                result = dBHelper.GetQueryList(query, ref dynamicTemplate);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDynamicTemplateForMail(EmailFilter transaction, int languageId, ref DynamicTemplateModel dynamicTemplate, TransactionEmailHistory oldEmail = null)
        {
            var result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<DynamicTemplateModel>();
            try
            {
                string query = "";
                query = $@"select top 1 DT.* ,DTL.* 
                                  from DT
                                  inner join (     
                                  select DTA.TemplateID, 1 as priority, DT.CreatedDate from DTAssignment DTA                          
                                  inner join DT on DT.TemplateID = DTA.TemplateID                                   
                                  where DTA.CustomerID = {transaction.CustomerId} and DTA.OutletID = {transaction.OutletId}                      
                                  union                      
                                  select DTA.TemplateID, 2 as priority, DT.CreatedDate from DTAssignment DTA                      
                                  inner join DT on DT.TemplateID = DTA.TemplateID                                   
                                  where DTA.GroupID  in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {transaction.CustomerId} and OutletID = {transaction.OutletId})                      
                                  union
                                  select DTA.TemplateID, 4 as priority, DT.CreatedDate from DTAssignment DTA                   
                                  inner join DT on DT.TemplateID = DTA.TemplateID                                   
                                  where  DTA.ChannelID in (SELECT ChannelID FROM CustomerGroup 
                                  Where GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {transaction.CustomerId} and OutletID = {transaction.OutletId}))                     
                                  union                      
                                  select DTA.TemplateID, 3 as priority, DT.CreatedDate from DTAssignment DTA                      
                                  inner join DT on DT.TemplateID = DTA.TemplateID                                   
                                  where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                  (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {transaction.CustomerId} and OutletID = {transaction.OutletId}))                      
                                  union
                                  select DTA.TemplateID, 5 as priority, DT.CreatedDate from DTAssignment DTA  
                                  inner join DT on DT.TemplateID = DTA.TemplateID                                   
                                  where  DTA.AllCustomers = 1
                                  ) DTA on DTA.TemplateID = DT.TemplateID and DTA.TemplateID is not null
                                  left join DTLanguage DTL on DTL.TemplateID = DT.TemplateID and LanguageID = {(_requestRepository != null ? _requestRepository.LanguageId : languageId)}
                                  inner join DTEmailReportType DTE on DTE.TemplateID = DT.TemplateID and DTE.ReportTypeID = {transaction.ReportTypeID}
                                  where DT.Inactive <> 1 order by DTA.priority, DTA.CreatedDate desc";

                result = dBHelper.GetQuerySingle(query, ref dynamicTemplate);
                //if (dynamicTemplate != null && result == GlobalErrors.Success && oldEmail != null && !String.IsNullOrEmpty(oldEmail.EmailSubject) && !String.IsNullOrEmpty(oldEmail.EmailBody) && !String.IsNullOrEmpty(oldEmail.SenderEmail))
                //{
                //    dynamicTemplate.Body = oldEmail.EmailBody;
                //    dynamicTemplate.Subject = oldEmail.EmailSubject;
                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDynamicReportFileData(int reportId, ref DynamicTemplateReportFileModel dynamicTemplateReportFile)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                var dBHelper = new DBHelper<DynamicTemplateReportFileModel>();
                string query = $@"select * from DynamicReportFile D where D.ReportId = {reportId} ";
                result = dBHelper.GetQuerySingle(query, ref dynamicTemplateReportFile);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static int GetTransactionTypeIdByReportTypeId(int reportTypeID)
        {
            //Filter doesn't applied on collection!
            if (reportTypeID == EmailReportTypes.ICashTopUp.GetHashCode() || reportTypeID == EmailReportTypes.SalesInvoice.GetHashCode())
                return TransactionType.Sales.GetHashCode();
            if (reportTypeID == EmailReportTypes.Return.GetHashCode())
                return TransactionType.Return.GetHashCode();
            if (reportTypeID == EmailReportTypes.Exchange.GetHashCode())
                return TransactionType.SalesExchange.GetHashCode();
            return -1;
        }

        public GlobalErrors GetTransactionsEmailsForSharedTable(ref SharedTableResult<TransactionEmailHistory> emailsList, GeneralFilter filterModel)
        {
            List<TransactionEmailHistory> transactionEmails = new List<TransactionEmailHistory>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            String filter = "where ((CO.Email is Not null and CO.Email <> '') or (Customer.Email is Not null and Customer.Email <> ''))   ";
            try
            {
                if (filterModel.CustomListFilter.Page < 0)
                    filterModel.CustomListFilter.Page = 0;
                if (filterModel.CustomListFilter.PageSize <= 0)
                    filterModel.CustomListFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(filterModel.CustomListFilter.SearchFilter))
                {
                    filter = filter + string.Format(@"and ( (data.TransactionID LIKE '%{0}%')
                    OR ( data.TransactionDate LIKE '%{0}%')
                    OR ( CustomerLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                   )", filterModel.CustomListFilter.SearchFilter.Trim());
                }
                if (!string.IsNullOrEmpty(filterModel.CustomListFilter.SearchFilter))
                {
                    filterModel.CustomListFilter.SearchFilter = filterModel.CustomListFilter.SearchFilter.Replace("'", "''");
                }
                DBHelper<TransactionEmailHistory> dBHelper = new DBHelper<TransactionEmailHistory>();
                string orderByFilter = string.Empty;
                string divisionAccess = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "data", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    filter += $@" And data.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess })";
                }

                if (filter != null)
                {
                    if (filterModel.TypeValue > 0)
                    {
                        int transactionTypeId = GetTransactionTypeIdByReportTypeId(filterModel.TypeValue);
                        if (transactionTypeId > 0)
                        {
                            if (transactionTypeId == TransactionType.Sales.GetHashCode())
                            {
                                if (filterModel.TypeValue == EmailReportTypes.SalesInvoice.GetHashCode())
                                {
                                    filter = filter + $@" and data.TransactionTypeID = {transactionTypeId} and data.CreationReason <> {TransactionCreationReason.iCashTopUp.GetHashCode()}";
                                }
                                else if (filterModel.TypeValue == EmailReportTypes.ICashTopUp.GetHashCode())
                                {
                                    filter = filter + $@" and data.TransactionTypeID = {transactionTypeId} and data.CreationReason = {TransactionCreationReason.iCashTopUp.GetHashCode()}";
                                }
                            }
                            else
                                filter = filter + $@" and data.TransactionTypeID = {transactionTypeId} ";
                        }
                    }
                    //else
                    //{
                    //    filter = filter + $@" and data.TransactionTypeID <> {TransactionType.ReturnExchange.GetHashCode()} ";
                    //}
                    if (filterModel.TypeValue > 0)
                        filter = filter + $@" and data.TransactionReportTypeID = {filterModel.TypeValue} ";
                    if (!String.IsNullOrEmpty(filterModel.TransactionId))
                        filter = filter + $@" and data.TransactionId like '%{filterModel.TransactionId}%'";
                    if (filterModel.DivisionId != -1)
                    {
                        filter += string.Format(@" And data.DivisionID = {0}", filterModel.DivisionId);
                    }

                    if (filterModel.CustomerId > -1)
                        filter = filter + $@" and data.CustomerId = '{filterModel.CustomerId}'";
                    if (filterModel.EmployeeId > -1)
                        filter = filter + $@" and data.EmployeeId = '{filterModel.EmployeeId}'";
                    if (filterModel.OutletId > -1)
                        filter = filter + $@" and data.OutletId = '{filterModel.OutletId}'";

                    if (filterModel.FromToDate != null)
                    {
                        filter += string.Format(" And  data.TransactionDate>={0} and  data.TransactionDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filterModel.FromToDate.ElementAt(0).Year, filterModel.FromToDate.ElementAt(0).Month, filterModel.FromToDate.ElementAt(0).Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filterModel.FromToDate.ElementAt(1).Year, filterModel.FromToDate.ElementAt(1).Month, filterModel.FromToDate.ElementAt(1).Day)));
                    }
                    if (string.IsNullOrEmpty(filterModel.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By data.TransactionId");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filterModel.CustomListFilter.SortBy, filterModel.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (!filterModel.CheckBoxValue)
                        filter = filter + $@" and data.Status <> '1'";
                    if (!filterModel.IncludeVoided)
                        filter = filter + $@" and data.Voided = '0'";

                }
                else
                {
                    filter = filter + $@" and data.TransactionTypeID <> {TransactionType.ReturnExchange.GetHashCode()} ";
                }
                string AssignmentJoin = $@"select distinct DTA.CustomerID, DTA.OutletID, DTEmailReportType.ReportTypeID, DTA.TemplateID
from DT
inner join (
select DTA.TemplateID,DTA.CustomerID, DTA.OutletID from DTAssignment DTA
union
select DTA.TemplateID,CustomerOutletGroup.CustomerID, CustomerOutletGroup.OutletID from DTAssignment DTA
inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = DTA.GroupID
union
select DTA.TemplateID,CustomerOutletGroup.CustomerID, CustomerOutletGroup.OutletID from DTAssignment DTA
inner join CustomerGroup on CustomerGroup.ChannelID = DTA.ChannelID
inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID
union
select DTA.TemplateID,CustomerOutletGroup.CustomerID, CustomerOutletGroup.OutletID from DTAssignment DTA
inner join CustomerGroup on CustomerGroup.SubChannelID = DTA.SubChannelID
inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID
union
select DTA.TemplateID,CustomerOutlet.CustomerID, CustomerOutlet.OutletID from DTAssignment DTA
inner join CustomerOutlet on 1=1
where  DTA.AllCustomers = 1
) DTA on DT.TemplateID = DTA.TemplateID
inner join DTEmailReportType on DTEmailReportType.TemplateID = DT.TemplateID
where DT.Inactive =0
";
                string mainQuery = $@"
                                        
from
(

select distinct  '' as FailureReason,  -1 as EmailTemplateId,notSendTransactions.* from (
select [Transaction].CreationReason,[Transaction].TransactionID, [Transaction].CustomerID, [Transaction].OutletID, [Transaction].DivisionID, [Transaction].TransactionTypeID, [Transaction].Voided, 0 as AllowView, '' as Body, -1 as EmailId, null as SendDate, '' as Sender, 0 as Status, '' as Subject, '' as ToEmail , [Transaction].OrganizationID , [Transaction].EmployeeID, [Transaction].TransactionDate,
case when [Transaction].TransactionTypeID = 1 and [Transaction].CreationReason = 25 then 4 
when [Transaction].TransactionTypeID = 1 then 1 
when [Transaction].TransactionTypeID = 2 then 2
when [Transaction].TransactionTypeID = 3 then 3
when [Transaction].TransactionTypeID = 17 or [Transaction].CreationReason = 14 or [Transaction].CreationReason = 17 or [Transaction].CreationReason = 5 or [Transaction].CreationReason = 13 then 5 
else -1 end as TransactionReportTypeID
from [Transaction]
left join TransactionEmailHistory on TransactionEmailHistory.TransactionId = [Transaction].TransactionID
where TransactionEmailHistory.TransactionId is null and IsNull([Transaction].Voided,0) = 0  and [Transaction].TransactionTypeID not in(4,5)
) notSendTransactions
inner join(
{AssignmentJoin})Assignment on Assignment.CustomerID = notSendTransactions.CustomerID And Assignment.OutletID = notSendTransactions.OutletID and Assignment.ReportTypeID = notSendTransactions.TransactionReportTypeID

union

select distinct  '' as FailureReason,  -1 as EmailTemplateId,notSendCollection.* from (
select distinct  -1 as CreationReason,CustomerPayment.CustomerPaymentID, CustomerPayment.CustomerID, CustomerPayment.OutletID, CustomerPayment.DivisionID, -1 as TransactionTypeID, 0 as Voided, 0 as AllowView, '' as Body, -1 as EmailId, null as SendDate, '' as Sender, 0 as Status, '' as Subject, '' as ToEmail , CustomerPayment.OrganizationID , CustomerPayment.EmployeeID, CustomerPayment.PaymentDate, 6 as TransactionReportTypeID
from CustomerPayment
inner join CustomerOutlet CO on CO.CustomerID = CustomerPayment.CustomerID and CO.OutletID = CustomerPayment.OutletID and CO.CustomerTypeID = 2
left join TransactionEmailHistory on TransactionEmailHistory.TransactionId = CustomerPayment.CustomerPaymentID
where  TransactionEmailHistory.TransactionId is null and CustomerPayment.PaymentStatusID <> 5  and CustomerPayment.AutoGeneratedByExchange <>1
) notSendCollection
inner join(
{AssignmentJoin})Assignment on Assignment.CustomerID = notSendCollection.CustomerID And Assignment.OutletID = notSendCollection.OutletID and Assignment.ReportTypeID = notSendCollection.TransactionReportTypeID

union

select distinct t.FailureReason, t.EmailTemplateId,[Transaction].CreationReason,[Transaction].TransactionID, [Transaction].CustomerID, [Transaction].OutletID, [Transaction].DivisionID, [Transaction].TransactionTypeID, [Transaction].Voided, 1 as AllowView, t.Body, t.EmailId, t.SendDate, t.Sender, t.Status, t.Subject, t.ToEmail , [Transaction].OrganizationID, [Transaction].EmployeeID, [Transaction].TransactionDate, case when [Transaction].TransactionTypeID = 1 and [Transaction].CreationReason = 25 then 4 
when [Transaction].TransactionTypeID = 1 then 1 
when [Transaction].TransactionTypeID = 2 then 2
when [Transaction].TransactionTypeID = 3 then 3
when [Transaction].TransactionTypeID = 17 or [Transaction].CreationReason = 14 or [Transaction].CreationReason = 17 or [Transaction].CreationReason = 5 or [Transaction].CreationReason = 13 then 5 
else -1 end as TransactionReportTypeID
from [Transaction]
cross apply (select top 1 * from TransactionEmailHistory
inner join DT on DT.TemplateId = TransactionEmailHistory.EmailTemplateId
where TransactionEmailHistory.TransactionId = [Transaction].TransactionID and
TransactionEmailHistory.CustomerId = [Transaction].CustomerID and
TransactionEmailHistory.OutletId = [Transaction].OutletID and
TransactionEmailHistory.DivisionId = [Transaction].DivisionID
order by TransactionEmailHistory.SendDate desc)t 
where [Transaction].TransactionTypeID not in(4,5)

union 

select distinct t.FailureReason, t.EmailTemplateId,-1 as CreationReason,CustomerPayment.CustomerPaymentID, CustomerPayment.CustomerID, CustomerPayment.OutletID, CustomerPayment.DivisionID, -1 as TransactionTypeID, Case when CustomerPayment.PaymentStatusID in (5) then 1 else 0 end as Voided, 1 as AllowView, t.Body, t.EmailId, t.SendDate, t.Sender, t.Status, t.Subject, t.ToEmail , CustomerPayment.OrganizationID, CustomerPayment.EmployeeID, CustomerPayment.PaymentDate,
6 as TransactionReportTypeID
from CustomerPayment
cross apply (select top 1 * from TransactionEmailHistory
inner join DT on DT.TemplateId = TransactionEmailHistory.EmailTemplateId
where TransactionEmailHistory.TransactionId = CustomerPayment.CustomerPaymentID and
TransactionEmailHistory.CustomerId = CustomerPayment.CustomerID and
TransactionEmailHistory.OutletId = CustomerPayment.OutletID and
TransactionEmailHistory.DivisionId = CustomerPayment.DivisionID
order by TransactionEmailHistory.SendDate desc)t 
  
)data
inner join  Customer on customer.CustomerID = data.CustomerID
inner join  CustomerOutlet CO on CO.CustomerID = data.CustomerId and CO.OutletID = data.OutletID
inner join CustomerLanguage on CustomerLanguage.CustomerID = data.CustomerId and CustomerLanguage.LanguageID =  1
inner join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = data.CustomerId and CustomerOutletLanguage.OutletID = data.OutletId and CustomerOutletLanguage.LanguageID =  1
left join DT on DT.TemplateId = data.EmailTemplateId
Inner join Employee on Employee.EmployeeID = data.EmployeeID and Employee.EmployeeTypeID in (2,10,3,4)
                                        
                                        {orgAccessJoin}
                                        {filter}";
                string countQuery = $@" SELECT IsNull(Count(*),0) {mainQuery}";
                // get count
                object objField = 0;
                result = dBHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    emailsList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (emailsList.TotalItems <= 0)
                    {
                        emailsList.Data = transactionEmails;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }


                string query = $@"select  IsNull(data.FailureReason,'') FailureReason,  data.TransactionReportTypeID as ReportTypeID, data.EmailTemplateId  as TemplateID, IsNull(DT.ReportID, -1) as ReportID , IsNull(DT.EnableSSL,0) as EnableSSL ,IsNull(DT.HasAttachment,0) as HasAttachment,data.CustomerID,data.OutletID,data.TransactionID,data.SendDate,data.Status,CASE WHEN data.Status = 0  or data.Status is null  THEN 'Not Sent'  WHEN data.Status = 1 THEN 'Sent'	ELSE 'Failed' END as statusDescription,
data.EmailId,data.DivisionID,data.TransactionTypeID,data.Voided
,CASE WHEN data.voided = 0  or data.voided is null  THEN 'NO'  ELSE 'Yes' END as VoidedDescription,
CustomerLanguage.Description+'-'+Customer.CustomerCode as CustomerDescription,
CustomerOutletLanguage.Description+'-'+CO.CustomerCode as OutletDescription ,
Customer.Email as CustomerEmail,
CASE WHEN data.Status = 0  or data.Status is null  THEN 'false' else 'true' end as AllowView
,data.Body as EmailBody,data.Subject as EmailSubject,data.Sender as SenderEmail,
DT.Password as EmailPassword, IsNull(DT.ServerPort,-1) as ServerPort, DT.ServerAddress,
data.TransactionDate
                                        {mainQuery}
                                        {orderByFilter} OFFSET {filterModel.CustomListFilter.Page} ROWS FETCH NEXT {filterModel.CustomListFilter.PageSize} ROWS ONLY";
                result = dBHelper.GetQueryList(query, ref transactionEmails , true);
                emailsList.Data = transactionEmails;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTransactionsEmails(ref List<TransactionEmailHistory> transactionEmails, TransactionEmailHistory filterModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            String filter = "where 1=1 ";
            String noOfRows = "1000";
            try
            {
                if (filterModel != null)
                {
                    if (!String.IsNullOrEmpty(filterModel.TransactionId))
                        filter = filter + $@" and data.TransactionId like '%{filterModel.TransactionId}%'";
                    if (filterModel.EmailID == -1)
                    {
                        if (filterModel.CustomerId > -1)
                            filter = filter + $@" and data.CustomerId = '{filterModel.CustomerId}'";
                        if (filterModel.OutletId > -1)
                            filter = filter + $@" and data.OutletId = '{filterModel.OutletId}'";
                        if (filterModel.SendDate != null)
                            filter = filter + $@" and data.SendDate = '{filterModel.SendDate}'";
                        noOfRows = "1";
                    }

                }
                else noOfRows = "1";
                DBHelper<TransactionEmailHistory> dBHelper = new DBHelper<TransactionEmailHistory>();
                string query = $@"select  IsNull(data.FailureReason,'') FailureReason, data.EmailTemplateId  as TemplateID,   data.CustomerID,data.OutletID,data.TransactionID,data.SendDate,data.Status,CASE WHEN data.Status = 0  or data.Status is null  THEN '{ResourcesManager.TranslateKey(MessagesConstants.Desc_Not_Sent, _requestRepository.LanguageId)}'  WHEN data.Status = 1 THEN '{ResourcesManager.TranslateKey(MessagesConstants.Desc_Sent, _requestRepository.LanguageId)}'	ELSE '{ResourcesManager.TranslateKey(MessagesConstants.Desc_Failed, _requestRepository.LanguageId)}' END as statusDescription,
                                        data.EmailId,data.DivisionID,data.TransactionTypeID,data.Voided
                                        ,CASE WHEN data.voided = 0  or data.voided is null  THEN '{ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId)}'  ELSE '{ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId)}' END as VoidedDescription,
                                        CustomerLanguage.Description as CustomerDescription, 
                                        CustomerOutletLanguage.Description as OutletDescription , 
                                        Customer.Email as CustomerEmail, 
                                        CASE WHEN data.Status = 0  or data.Status is null  THEN 'false' else 'true' end as AllowView
                                        ,data.Body as EmailBody,data.Subject as EmailSubject,data.Sender as SenderEmail 
                                        from 
                                        ( 
                                        select t.FailureReason,[Transaction].TransactionID, [Transaction].CustomerID, [Transaction].OutletID, [Transaction].DivisionID, [Transaction].TransactionTypeID, t.Voided, 1 as AllowView, t.Body, t.EmailId, t.EmailTemplateId, t.SendDate, t.Sender, t.Status, t.Subject, t.ToEmail , [Transaction].OrganizationID
                                        from [Transaction]
                                        cross apply (select * from TransactionEmailHistory 
                                        where TransactionEmailHistory.TransactionId = [Transaction].TransactionID and 
                                        TransactionEmailHistory.CustomerId = [Transaction].CustomerID and 
                                        TransactionEmailHistory.OutletId = [Transaction].OutletID and 
                                        TransactionEmailHistory.DivisionId = [Transaction].DivisionID )t 

union
         
select distinct t.FailureReason, CustomerPayment.CustomerPaymentID TransactionID,
CustomerPayment.CustomerID,
CustomerPayment.OutletID,
CustomerPayment.DivisionID,
-1 as TransactionTypeID,
t.Voided,
1 as AllowView, t.Body, t.EmailId,t.EmailTemplateId,
t.SendDate,
  t.Sender, t.Status, t.Subject, t.ToEmail , CustomerPayment.OrganizationID from CustomerPayment
cross apply (select    * from TransactionEmailHistory
inner join DT on DT.TemplateId = TransactionEmailHistory.EmailTemplateId
where TransactionEmailHistory.TransactionId = CustomerPayment.CustomerPaymentID and
TransactionEmailHistory.CustomerId = CustomerPayment.CustomerID and
TransactionEmailHistory.OutletId = CustomerPayment.OutletID and
TransactionEmailHistory.DivisionId = CustomerPayment.DivisionID
	
)t 
  
)data 
                                        inner join  Customer on customer.CustomerID = data.CustomerID
                                        inner join  CustomerOutlet CO on CO.CustomerID = data.CustomerId and CO.OutletID = data.OutletID
                                        inner join CustomerLanguage on CustomerLanguage.CustomerID = data.CustomerId and CustomerLanguage.LanguageID =  { _requestRepository.LanguageId}
                                        inner join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = data.CustomerId and CustomerOutletLanguage.OutletID = data.OutletId and CustomerOutletLanguage.LanguageID =  { _requestRepository.LanguageId}
                                         {filter}";
                result = dBHelper.GetQueryList(query, ref transactionEmails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillEmailData(DBHelper<Object> dBHelper, TransactionEmailHistory transactionEmail)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dynamic o = new ExpandoObject();
                o.EmailSubject = "";
                o.EmailBody = "";
                o.SenderEmail = "";
                string query = $@" select Sender as SenderEmail, Subject, Body from TransactionEmailHistory where TransactionId = '{transactionEmail.TransactionId}' and EmailId = {transactionEmail.EmailID} and SendDate = '{transactionEmail.SendDate}' and CustomerId = {transactionEmail.CustomerId} and OutletId = {transactionEmail.OutletId} and DivisionId = {transactionEmail.DivisionId} 
                 ";
                result = dBHelper.GetQuerySingle(query, ref o);

                var mappedObject = new Dictionary<string, object>(o);
                transactionEmail.EmailSubject = (string)mappedObject["Subject"];
                transactionEmail.EmailBody = (string)mappedObject["Body"];
                transactionEmail.SenderEmail = (string)mappedObject["SenderEmail"];
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmailTemplateTypes(int EmailTypeId, ref EmailTemplateModel emailModel)
        {
            emailModel = new EmailTemplateModel();
            DBHelper<EmailTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string emailTypeFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmailTemplateModel>();
                string query = string.Format(@"SELECT top(1) EmailTypeLanguage.EmailTypeID,EmailTypeLanguage.LanguageID, 
                CASE WHEN EmailTypeLanguage.EmailTypeID = 9 THEN EmailTypeLanguage.Description + ' \ ' +  ProofDocumentTypeLanguage.Description ELSE EmailTypeLanguage.Description END AS Description,
                EmailTemplate.EmailTemplateId EmailTempId,EmailTemplate.EmailTypeId EmailTypeId, EmailTemplate.ServerAddress, EmailTemplate.Email, EmailTemplateLanguage.Description Name, 
                EmailTemplateLanguage.Subject, EmailTemplateLanguage.Body,
                CASE WHEN EmailTemplate.InActive = 1 THEN 'Desc_Inactive' ELSE 'Desc_Active' END Status, 
                CASE WHEN EmailTemplate.InActive = 1 THEN 0 ELSE 1 END IsActive,  EmailTemplate.HasAttachment as MandatoryAttachement
                FROM EmailTemplate 
                LEFT JOIN EmailTemplateLanguage ON EmailTemplateLanguage.EmailTemplateId = EmailTemplate.EmailTemplateId AND EmailTemplateLanguage.LanguageId = {0}
                LEFT JOIN EmailTypeLanguage ON EmailTypeLanguage.EmailTypeID = EmailTemplate.EmailTypeID AND EmailTypeLanguage.LanguageId = {0}
                LEFT JOIN ProofDocumentTypeLanguage on ProofDocumentTypeLanguage.DocumentTypeID = EmailTemplate.DocumentTypeId AND ProofDocumentTypeLanguage.LanguageID = {0}                    
                WHERE 1=1 
                and EmailTemplate.EmailTypeId = {1}
                AND EmailTemplate.InActive = 0 OR EmailTemplate.InActive IS NULL ORDER BY CreatedDate DESC", _requestRepository.LanguageId.GetHashCode(), EmailTypeId);
                result = dbHelper.GetQuerySingle(query, ref emailModel);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                emailModel = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        #region [Report Schedule]
        public GlobalErrors GetReportScheduleEmployees(ref List<EmployeeModel> employeeModel , int scheduleId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<EmployeeModel>();
            string query = string.Empty;
            try
            {
                query = string.Format(@"
              		SELECT employee.EmployeeID, Employee.Email, Employee.EmployeeTypeID, Org.OrganizationAccess, Div.DivisionAccess 
					from employee
					INNER JOIN ( SELECT EmployeeId from ReportScheduleEmployee WHERE ScheduleID = {0}
					UNION 
					Select EmployeeOperator.EmployeeId From ReportScheduleSecurityGroup 
					INNER JOIN OperatorSecurityGroup ON OperatorSecurityGroup.SecurityGroupID = ReportScheduleSecurityGroup.SecurityGroupID 
					INNER JOIN EmployeeOperator ON EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID WHERE ScheduleID = {0}
					) ScheduleEmployee ON ScheduleEmployee.EmployeeID = employee.EmployeeID
					cross apply ( SELECT STRING_AGG(EmployeeOrganization.OrganizationID,',')OrganizationAccess
					FROM EmployeeOrganization WHERE EmployeeOrganization.EmployeeID = employee.EmployeeID
					)Org
					cross apply (SELECT STRING_AGG(EmployeeDivision.DivisionID,',')DivisionAccess
					FROM EmployeeDivision WHERE EmployeeDivision.EmployeeID = employee.EmployeeID
					)Div
					WHERE Employee.Email IS NOT NULL AND Employee.Email != ''", scheduleId);
                result = dBHelper.GetQueryList(query , ref employeeModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReportScheduleAssignment(ref List<DynamicReportModel> reportModel, int scheduleId , int languageId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<DynamicReportModel>();
            string query = string.Empty;
            try
            {
                query = string.Format(@"
				SELECT RA.* , ReportLanguage.Description ReportName, report.FileName 
				FROM ReportScheduleAssignment RA
				INNER JOIN ReportLanguage ON ReportLanguage.ReportID = RA.ReportID AND ReportLanguage.LanguageID = {1}
				INNER JOIN report ON Report.ReportID = RA.ReportID
				WHERE RA.ScheduleID = {0}", scheduleId , languageId);
                result = dBHelper.GetQueryList(query, ref reportModel);  
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetReportScheduleAssignmentDetails(ref List<ReportFilterModel> reportFilters, int scheduleId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var filterdBHelper = new DBHelper<ReportFilterModel>();
            string query = string.Empty;
            try
            {
                 query = string.Format(@"SELECT RA.ReportScheduleAssignmentID ,RA .ParameterName , RA.ReportFilterID ,ReportFilter.ReportFilterTypeID,
                 RA .ReportParameterID , RA .FilterSelectedValue SelectedValue ,
				 Case When ReportFilter.ReportFilterTypeID in (1,4,5,7,8,9) Then 1 else 0 end as IsDateFilter,
				 Case When ReportFilter.ReportFilterTypeID in (10,11) Then 1 else 0 end as IsDateTimeFilter
				 FROM ReportScheduleAssignmentDetails RA 
                 INNER JOIN ReportScheduleAssignment ON ReportScheduleAssignment.ReportScheduleAssignmentID = RA.ReportScheduleAssignmentID 
				 INNER JOIN ReportFilter ON ReportFilter.ReportFilterID = RA.ReportFilterID
                 AND ReportScheduleAssignment.ScheduleID = {0}", scheduleId);
                 result = filterdBHelper.GetQueryList(query, ref reportFilters);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetScheduleReportConfiguration(ref EmailTemplateModel emailTemplate , int scheduleId , int languageId , int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var dBHelper = new DBHelper<EmailTemplateModel>();
            string query = string.Empty;
            try
            {
                query = string.Format(@"SELECT ScheduleReportConfiguration.ServerAddress , ScheduleReportConfiguration.ServerPort EmailPort, RL.Subject , RL.Body, EmployeeLanguage.Description,
                ScheduleReportConfiguration.Email , ScheduleReportConfiguration.Password , ScheduleReportConfiguration.EnableSsl 				
                FROM ScheduleReportConfiguration
				LEFT JOIN ReportScheduleLanguage RL ON RL.ScheduleID = {0} AND LanguageID = {1}
				INNER JOIN EmployeeLanguage ON EmployeeLanguage.EmployeeID = {2} AND EmployeeLanguage.LanguageID = {1}", scheduleId , languageId , employeeId);
                result = dBHelper.GetQuerySingle(query , ref emailTemplate);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}