﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Web;
using System.Threading.Tasks;
using Newtonsoft.Json;
using System.Net.Http;
using System.Net;
using System.IO;
using InCube.Security;

namespace Sonic.Web.Core
{
    public class EmployeeManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly AccountManager _accountManager;
        private readonly ConfigurationManager _configurationManager;
        private readonly PasswordManager _passwordManager;
        private readonly MasterDataManager _masterDataManager;
        public EmployeeManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _accountManager = new AccountManager(requestRepository);
            _configurationManager = new ConfigurationManager(requestRepository);
            _passwordManager = new PasswordManager(requestRepository);
            _masterDataManager = new MasterDataManager(requestRepository);
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
        public GlobalErrors GetOrganizationEmployees(string organizationIds, ref List<EmployeeModel> employeeList, ref List<EmployeeModel> routeEmployeeList, ref List<EmployeeModel> foEmployeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            string orgFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                if (!string.IsNullOrEmpty(organizationIds))
                {
                    orgFilter = string.Format(" And Employee.OrganizationID in ({0})", organizationIds);
                }
                var employeeQuery = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName,Employee.OrganizationID,
                Employee.EmployeeCode,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName ,
                Employee.EmployeeTypeID
                FROM Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                Where Employee.OrganizationID in ({1}) and Employee.Inactive <> 1   {2}
				ORDER BY EmployeeName ",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess, orgFilter);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                if (result == GlobalErrors.Success && employeeList.Count > 0)
                {
                    routeEmployeeList = employeeList.Where(employee => employee.EmployeeTypeId != 1 && employee.EmployeeTypeId != 5 && employee.EmployeeTypeId != 7 && employee.EmployeeTypeId != 9
                && employee.EmployeeTypeId != 12 && employee.EmployeeTypeId != 19 && employee.EmployeeTypeId != 15 && employee.EmployeeTypeId != 16).ToList();
                }
                if(result == GlobalErrors.Success && employeeList.Count > 0)
                {
                    foEmployeeList = employeeList.Where(employee => employee.EmployeeTypeId != (int)EmployeeTypes.Employee && employee.EmployeeTypeId != (int)EmployeeTypes.StoreKeeper
                    && employee.EmployeeTypeId != (int)EmployeeTypes.Helper && employee.EmployeeTypeId != (int)EmployeeTypes.SalesManager && employee.EmployeeTypeId != (int)EmployeeTypes.ForeMan
                    && employee.EmployeeTypeId != (int)EmployeeTypes.Picker && employee.EmployeeTypeId != (int)EmployeeTypes.Inspector && employee.EmployeeTypeId != (int)EmployeeTypes.Director).ToList();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerEmployees(int customerId, int outletId, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            string orgFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                var employeeQuery = string.Format(@"select distinct top (1) EmployeeTerritory.EmployeeID , IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from CustOutTerritory
                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
				inner join Employee on Employee.EmployeeID = EmployeeTerritory.EmployeeID
				left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
                where CustOutTerritory.CustomerID = {2} and CustOutTerritory.OutletID = {3} and Employee.OrganizationID in ({1}) and Employee.Inactive <> 1 ",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess, customerId, outletId);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckEmployeeAccount(int employeeID, ref bool isAccountExist)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isAccountExist = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT AccountEmp.AccountID FROM AccountEmp
                inner join Account on Account.AccountID = AccountEmp.AccountID
                WHERE AccountEmp.EmployeeID = {0}", employeeID);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                {
                    isAccountExist = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool EmployeeHasAccessToDivision(int employeeID, int divisionID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@" SELECT 'True' FROM EmployeeDivision WHERE EmployeeID = {0} AND DivisionID = {1}", employeeID, divisionID);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && int.Parse(objField.ToString()) > 0)
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }

        public GlobalErrors FillEmployeeConfigurations()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region [Configurations]

                result = _configurationManager.FillOperatorConfigurations();
                if (result == GlobalErrors.Success)
                {
                    result = _configurationManager.FillOperatorConfigurationsOnDivisionLevel();
                }

                #endregion [Configurations]
                #region[Customer Configurations]
                if (result == GlobalErrors.Success)
                {
                    result = _configurationManager.FillConfigurationsOnCustomerLevel();
                }

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllEmployees(ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();

                var employeeQuery = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName, Employee.Phone,Employee.Mobile,Employee.Email,
                Employee.EmployeeCode,EmployeeTypeLanguage.Description EmployeeType
                ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                FROM Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID AND EmployeeTypeLanguage.LanguageID = {0}
                Where Employee.OrganizationID in ({1})
				ORDER BY EmployeeName ",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetWarehousePickers(int warehouseId, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();

                var employeeQuery = string.Format(@"Select DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName , Employee.EmployeeCode,EmployeeTypeLanguage.Description EmployeeType,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID AND EmployeeTypeLanguage.LanguageID = {0}
                INNER JOIN WarehouseEmployees on WarehouseEmployees.EmployeeId = Employee.EmployeeID AND WarehouseEmployees.WarehouseId = {1}
                Where Employee.EmployeeTypeID ={2} And Employee.Inactive = 0
                ORDER BY EmployeeName"
                , _requestRepository.LanguageId
                , warehouseId
                , (int)EmployeeTypes.Picker);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetWarehouseHelpers(int warehouseId, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();

                var employeeQuery = string.Format(@"Select DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName , Employee.EmployeeCode,EmployeeTypeLanguage.Description EmployeeType,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID AND EmployeeTypeLanguage.LanguageID = {0}
                INNER JOIN WarehouseEmployees on WarehouseEmployees.EmployeeId = Employee.EmployeeID AND WarehouseEmployees.WarehouseId = {1}
                Where Employee.EmployeeTypeID ={2} 
                ORDER BY EmployeeName"
               , _requestRepository.LanguageId
               , warehouseId
               , (int)EmployeeTypes.Helper);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetEmployeeProfileData(ref EmployeeModel employee,string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();

                var employeeQuery = string.Format(@"select EmployeeLanguage.Description  EmployeeName, * 
                                                    from Employee 
                                                    inner join EmployeeLanguage on EmployeeLanguage.EmployeeID=Employee.EmployeeID and EmployeeLanguage.LanguageID={0}
                                                    where employee.EmployeeId={1} ", _requestRepository.LanguageId,
                                                    _requestRepository.CurrentOperator.EmployeeId);

                result = dbHelper.GetQuerySingle(employeeQuery, ref employee);
                if(result == GlobalErrors.Success && employee != null)
                {
                    string fileName = _requestRepository.CurrentOperator.EmployeeId + ".jpg";
                    string imageUserPath = rootPath + "\\Users-Img\\";
                    if (!System.IO.File.Exists(imageUserPath))
                    {
                        System.IO.Directory.CreateDirectory(imageUserPath);
                    }
                    List<string> filePaths = Directory.GetFiles(imageUserPath, fileName + "*.*").ToList(); 
                    if (filePaths.Count > 0)
                    {
                        employee.ImageUserProfilePath = $"wwwroot/Users-Img/{ _requestRepository.CurrentOperator.EmployeeId}.jpg";
                    }
                    else
                    {
                        employee.ImageUserProfilePath = $"wwwroot/Users-Img/user.jpg";
                    }
                    employee.IsInternetConnected = CheckForInternetConnection();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetEmployeeIdFromOperatorId(int operatorId, ref int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"select employeeId from employeeOperator where operatorId = {operatorId}";
                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        employeeId = int.Parse(field.ToString());
                    }
                    else
                    {
                        employeeId = -1;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfChattingIsAvailableForOperator(int operatorId, ref bool isAvailable)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object objField = 0;
                string query = string.Format(@"select count(*) from WebSecurityGroupPrivilege 
                inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = WebSecurityGroupPrivilege.SecurityGroupID
                inner join EmployeeOperator on EmployeeOperator.OperatorID =  OperatorSecurityGroup.OperatorID
                 where MenuID = '2100' and EmployeeOperator.OperatorId = {0}", operatorId);
                result = dBHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString().Trim()) > 0)
                {
                    isAvailable = true;
                }
                else
                {
                    isAvailable = false;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public  bool CheckForInternetConnection()
        {
            try
            {
                using (var client = new WebClient())
                using (client.OpenRead("https://google.com/generate_204"))
                    return true;
            }
            catch
            {
                return false;
            }
        }

        public GlobalErrors GetLandmarkEmployees(int areaId, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();

                var employeeQuery = string.Format(@"Select Distinct route.TerritoryID , EmployeeTerritory.EmployeeID , EmployeeCode , EmployeeLanguage.Description EmployeeName , Employee.Phone
                From route 
                Inner join RouteAreas on route.RouteID = RouteAreas.RouteID 
                INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = Route.TerritoryID
                INNER JOIN Employee on Employee.EmployeeID = EmployeeTerritory.EmployeeID 
                LEFT JOIN EmployeeLanguage on Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                where RouteAreas.AreaID = {1}", _requestRepository.LanguageId, areaId);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public static int GetEmployeeDriver(int EmployeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = new object();

                string query = string.Format(@"SELECT DriverID
                FROM EmployeeDriver
                WHERE EmployeeID ={0}", EmployeeID);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
        }

        public int GetEmployeeHelper(int EmployeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = new object();
                string query = string.Format(@"SELECT helperID
                FROM employeeHelper
                WHERE EmployeeID ={0}", EmployeeID);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
        }

        public List<EmployeeModel> GetEmployeeLoadingVehicle(int vehicleID, int organizationId)
        {
            List<EmployeeModel> result = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;
                //Until get access to employee loggedin data
                string storeKeeperFilter = string.Empty;
                string selectedOrgFilter = string.Empty;
                if (organizationId != -1)
                {
                    selectedOrgFilter = string.Format(" And Employee.OrganizationID IN ({0}) ", organizationId);
                }

                query = string.Format(@"SELECT distinct EmployeeLanguage.Description EmployeeName,Employee.EmployeeCode,EmployeeVehicle.EmployeeID,EmployeeVehicle.VehicleID
                             ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--')  as    EmployeeCodeName,Employee.EmployeeTypeId
                             FROM  EmployeeVehicle
                            --INNER JOIN VehicleLoadingWh ON EmployeeVehicle.VehicleID = VehicleLoadingWh.VehicleID
                            INNER JOIN EmployeeLanguage ON EmployeeVehicle.EmployeeID = EmployeeLanguage.EmployeeID   AND EmployeeLanguage.LanguageID = {0}
                            INNER JOIN Employee ON EmployeeVehicle.EmployeeID = Employee.EmployeeID AND Employee.Inactive = 0
                            WHERE EmployeeVehicle.VehicleID={1} AND Employee.OrganizationID IN({2}) {3}
                            ORDER BY EmployeeLanguage.Description", _requestRepository.LanguageId, vehicleID, _requestRepository.CurrentOperator.OrganizationAccess, selectedOrgFilter);

                dbHelper.GetQueryList(query, ref result);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        public List<EmployeeModel> GetWarehouseStoreKeeper(int warehouseId, int organizationId)
        {
            List<EmployeeModel> result = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;
                //Until get access to employee loggedin data
                string storeKeeperFilter = string.Empty;
                string selectedOrgFilter = string.Empty;
                if (organizationId != -1)
                {
                    selectedOrgFilter = string.Format(" And Employee.OrganizationID IN ({0}) ", organizationId);
                }

                query = string.Format(@"SELECT distinct EmployeeLanguage.Description EmployeeName,Employee.EmployeeCode,WarehouseStoreKeeper.EmployeeID,WarehouseStoreKeeper.WarehouseID
                             ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--')  as    EmployeeCodeName,Employee.EmployeeTypeId
                             FROM  WarehouseStoreKeeper
                            INNER JOIN EmployeeLanguage ON WarehouseStoreKeeper.EmployeeID = EmployeeLanguage.EmployeeID   AND EmployeeLanguage.LanguageID = {0}
                            INNER JOIN Employee ON WarehouseStoreKeeper.EmployeeID = Employee.EmployeeID AND Employee.Inactive = 0
                            WHERE WarehouseStoreKeeper.WarehouseID={1} AND Employee.OrganizationID IN({2}) {3}
                            ORDER BY EmployeeLanguage.Description", _requestRepository.LanguageId, warehouseId, _requestRepository.CurrentOperator.OrganizationAccess, selectedOrgFilter);

                dbHelper.GetQueryList(query, ref result);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        public List<EmployeeModel> GetDriverLinkedToTruck(int truckId)
        {
            List<EmployeeModel> result = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;
                //Until get access to employee loggedin data
                string storeKeeperFilter = string.Empty;

                query = string.Format(@"SELECT distinct EmployeeLanguage.Description EmployeeName,Employee.EmployeeCode,Employee.EmployeeID,DriverTruck.TruckID 
                             ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--')  as    EmployeeCodeName
                             FROM  DriverTruck
                            INNER JOIN EmployeeLanguage ON DriverTruck.DriverID = EmployeeLanguage.EmployeeID   AND EmployeeLanguage.LanguageID = {0}
                            INNER JOIN Employee ON DriverTruck.DriverID = Employee.EmployeeID AND Employee.Inactive = 0

                            WHERE DriverTruck.TruckID={1} AND Employee.OrganizationID IN({2})
                            ORDER BY EmployeeLanguage.Description", _requestRepository.LanguageId, truckId, _requestRepository.CurrentOperator.OrganizationAccess);

                dbHelper.GetQueryList(query, ref result);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
        public int GetEmployeeOrganization(int employeeID)
        {
            return GetEmployeeOrganization(employeeID, null);
        }

        public int GetEmployeeOrganization(int employeeID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool useSameDBHelper = true;
            try
            {
                // get from cashed data
                if (_requestRepository.CurrentOperator.EmployeeId == employeeID)
                {
                    return _requestRepository.CurrentOperator.OrganizationId;
                }
                if (dBHelper == null)
                {
                    useSameDBHelper = false;
                    dBHelper = new DBHelper<int>();
                }

                object field = new object();

                string query = string.Format("Select OrganizationID from Employee where employeeID={0}", employeeID);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (!useSameDBHelper && dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
        }
        public GlobalErrors GetEmployeeContactCountry(int EmployeeId,ref int contactCountryId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = new object();

                string query = string.Format(@"SELECT ContactCountryId FROM Employee WHERE EmployeeID = {0}", EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    contactCountryId = int.Parse(field.ToString());
                }
                else
                {
                    contactCountryId = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }


        public static int GetEmployeeSalesRepresentitive(int EmployeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = new object();

                string query = string.Format(@"SELECT SalesRepID
                FROM EmployeeSalesRep
                WHERE EmployeeID = {0}", EmployeeId);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
        }

        public static int GetEmployeeSupervisor(int EmployeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = new object();
                string query = string.Format(@"SELECT SupervisorID
                FROM employeesupervisor
                WHERE EmployeeID = {0}
                or EmployeeID in(select SalesRepID from EmployeeSalesRep where EmployeeID={0})", EmployeeID);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
        }

        public GlobalErrors GetLandingMenu(ref MenuModel menuModel, int operatorId)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<MenuModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<MenuModel>();
                string query = string.Format(@"select * from WebOperatorPrivilege
inner join WebMenu on WebMenu.MenuID=WebOperatorPrivilege.FavoriteMenuID
 where OperatorID={0} ", operatorId);
                result = dbHelper.GetQuerySingle(query, ref menuModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors GetLandingMenuOld(ref MenuModel menuModel, int operatorId)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<MenuModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<MenuModel>();
                string query = string.Format(@"select * from WebOperatorPrivilege
inner join WebMenu on WebMenu.MenuID=WebOperatorPrivilege.FavoriteMenuID
 where OperatorID={0} ", operatorId);
                result = dbHelper.GetQuerySingle(query, ref menuModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetParentMenus(ref List<MenuModel> parentMenus)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<MenuModel> dbHelper = null;
            try
            {
                // get Parent Menu
                parentMenus = new List<MenuModel>();
                dbHelper = new DBHelper<MenuModel>();
                string parentFilter = "webmenu.IsParentMenu = 1";

                string menuString = @"select distinct webmenu.*, webmenulanguage.Description MenuName from webmenu
                inner join webmenulanguage on webmenulanguage.MenuID = webmenu.MenuID and webmenulanguage.LanguageID = {1}
                INNER JOIN WebSecurityGroupPrivilege wsgp on wsgp.MenuID = WebMenu.MenuID 
                AND wsgp.SecurityGroupID in (select SecurityGroupID from OperatorSecurityGroup where OperatorID in ({2}))                     
                where  ({0}) AND WebMenu.MenuID NOT LIKE ('%-%')";

                string menuQuery = string.Format(menuString, parentFilter, _requestRepository.LanguageId, _requestRepository.CurrentOperator.OperatorId);

                result = dbHelper.GetQueryList(menuQuery, ref parentMenus);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        public int GetSupervisorSalesManager(int employeeId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();

                string query = string.Format(@"SELECT SupervisorSalesMngr.SalesManagerID
                FROM SupervisorSalesMngr
                WHERE SupervisorID={0} Or  SupervisorID in (Select SupervisorID from EmployeeSupervisor where EmployeeID={0}
                or EmployeeID in(select SalesRepID from EmployeeSalesRep where EmployeeID={0}))", employeeId);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return int.Parse(field.ToString());
                }
                else
                {
                    return -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
        }

        public static bool IsEmployeeOnHold(int employeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@" SELECT Count(*) FROM Employee WHERE EmployeeID = {0} AND OnHold = 1", employeeID);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && int.Parse(objField.ToString()) > 0)
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }

        public GlobalErrors UpdateOperatorDataFromProfile(OperatorProfileModel operatorModel, ref List<string> errors)
        {
            GlobalErrors result = GlobalErrors.Success;
            string errorMessage = string.Empty;
            try
            {
                if (!string.IsNullOrEmpty(operatorModel.LandingMenuId))
                {
                    result = UpdateOperatorLandingMenu(operatorModel.LandingMenuId);
                }

                if (result != GlobalErrors.Success)
                {
                    errors.Add(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_While_Saving_Landing_page, _requestRepository.LanguageId));
                }
                if (operatorModel.AllowToChangePassword && !string.IsNullOrEmpty(operatorModel.OldPassword) && !string.IsNullOrEmpty(operatorModel.NewPassword))
                {
                    if (result == GlobalErrors.Success)
                    {
                        result = ChangePassword(_requestRepository.CurrentOperator.OperatorId, operatorModel, _requestRepository.LanguageId, ref errorMessage);
                        if (!string.IsNullOrEmpty(errorMessage))
                            errors.Add(errorMessage);
                    }
                }
                if (result == GlobalErrors.PasswordNotMatch)
                {
                    errors.Add(ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Incorrect, _requestRepository.LanguageId));
                }
                if (result == GlobalErrors.Error)
                {
                    if (string.IsNullOrEmpty(errorMessage))
                        errors.Add(ResourcesManager.TranslateKey(MessagesConstants.Desc_Error_Updating_Password, _requestRepository.LanguageId));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors CheckOldPasswordIfMatch(string oldPassword, int operatorID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                object foundedOperator = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select count(*) from Operator where OperatorID={0} and OperatorPassword='{1}' "
            , operatorID, EncryptionManager.Instance.EncryptPassword(oldPassword));
                result = dbHelper.ExecuteScalar(query, ref foundedOperator);
                if (result == GlobalErrors.Success && foundedOperator != null && !string.IsNullOrEmpty(foundedOperator.ToString()) && int.Parse(foundedOperator.ToString()) > 0)
                {
                    result = GlobalErrors.Success;
                }
                else
                {
                    result = GlobalErrors.PasswordNotMatch;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        private GlobalErrors UpdateOperatorLandingMenu(string menuId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                object found = null;

                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select count(*) from  WebOperatorPrivilege  where OperatorID={0}  "
 , _requestRepository.CurrentOperator.OperatorId, menuId);
                result = dbHelper.ExecuteScalar(query, ref found);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Update WebOperatorPrivilege set FavoriteMenuID='{1}' where OperatorID={0} "
         , _requestRepository.CurrentOperator.OperatorId, menuId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    if (found != null && !string.IsNullOrEmpty(found.ToString()) && int.Parse(found.ToString()) > 0)
                    {
                        query = string.Format(@"Update WebOperatorPrivilege set FavoriteMenuID='{1}' where OperatorID={0} "
          , _requestRepository.CurrentOperator.OperatorId, menuId);
                    }
                    else
                    {
                        query = string.Format(@"insert into WebOperatorPrivilege (OperatorID,FavoriteMenuID) values( {0},'{1}') "
, _requestRepository.CurrentOperator.OperatorId, menuId);
                    }
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        private static GlobalErrors UpdateOperatorPassword(string oldPassword, string newPassword, int operatorID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Update Operator set OperatorPassword='{1}' where OperatorID={0} "
            , operatorID, EncryptionManager.Instance.EncryptPassword(newPassword));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public string GetEmployeeOrganizationAccess(long employeeID)
        {
            return GetEmployeeOrganizationAccess(employeeID, null);
        }
        public string GetEmployeeOrganizationAccess(long employeeID, DBHelper<int> dbHelper)
        {
            string organizations = string.Empty;
            try
            {
                DataTable dt = GetEmployeeOrganizations((int)employeeID, dbHelper);
                for (int i = 0; i < dt.Rows.Count; i++)
                {
                    if (!string.IsNullOrEmpty(dt.Rows[i]["OrganizationID"].ToString()))
                        organizations += dt.Rows[i]["OrganizationID"].ToString() + ',';
                }
                if (!string.IsNullOrEmpty(organizations))
                    organizations = organizations.TrimEnd(',');
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return organizations;
        }
        public DataTable GetEmployeeOrganizations(int employeeid, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            bool usingSeparateDBHelper = true;
            try
            {
                string query = string.Format(@" Select Distinct EmployeeOrganization.OrganizationID 
                from EmployeeOrganization 
                where EmployeeOrganization.EmployeeID = {0}", employeeid);
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                else
                {
                    usingSeparateDBHelper = false;
                }
                result = dbHelper.GetQueryDataTable(query, ref dt);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (usingSeparateDBHelper && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return dt;

        }

        public GlobalErrors CashOperatorMenus(DBHelper<MenuModel> menu_dbHelper, ref List<MenuModel> allAvailableMenus, OperatorModel operatorModel, ref List<MenuModel> addedMenus, int securityGroupID, int langId, FormMode mode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string securityGroupIdFilter = string.Empty, adminWebMenusFilter = string.Empty,
                adminAndroidMenusFilter = string.Empty, adminAndroidMainMenuFilter = string.Empty,
                mainSecurityGroupFilter = string.Empty;
            List<MenuModel> availableMenus = null;
            List<MenuModel> allMenus = null;
            List<MenuModel> allAddedMenus = null;

            List<ActionTypesModel> actionTypes = null;
            List<ActionTypesModel> addedActionTypes = null;
            int languageId = -1;

            try
            {

                if (langId > 0)
                {
                    languageId = langId;
                }
                else
                {
                    languageId = _requestRepository.LanguageId;
                }
                if (menu_dbHelper == null)
                {
                    menu_dbHelper = new DBHelper<MenuModel>();
                }
                if (securityGroupID == -1 && mode == FormMode.None)
                {
                    securityGroupIdFilter = string.Format(@"select securityGroupID 
                    from OperatorSecurityGroup where OperatorID in ({0})", operatorModel.OperatorId);
                    mainSecurityGroupFilter = securityGroupIdFilter;
                }
                else
                {
                    securityGroupIdFilter = securityGroupID.ToString();
                    mainSecurityGroupFilter = "select securityGroupID from OperatorSecurityGroup where OperatorID = " + operatorModel.OperatorId;
                }
                if (operatorModel.EmployeeId != 0)
                {
                    adminAndroidMainMenuFilter = string.Format(@"AND(Select Count(*) 
                    from SecurityGroupPrivilege where SecurityGroupID in ({0}) 
                    AND MenuID >= 5000 AND MenuID < 6000) > 0", mainSecurityGroupFilter);
                    adminAndroidMenusFilter = "AND SGP.MenuID is not null";
                    adminWebMenusFilter = "AND WSGP.MenuID is not null or WebMenu.IsHidden = 1";
                }
                allMenus = new List<MenuModel>();
                availableMenus = new List<MenuModel>();

                string supervisorMenuAccess = string.Empty, preventAndroidFilter = string.Empty;
                if (operatorModel.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode())
                {
                    // This line is commited to remove the restriction over the menus when login as supervisor.

                    //supervisorMenuAccess = @"AND webmenu.MenuID in (
                    //'600', '600-001','600-002','600-003',
                    //'500','500-002',
                    //'400', '400-001',
                    //'700', '700-001',
                    //'300','300-001',
                    //'1000', '1000-002','1000-003', '1000-004','700-002')";

                    preventAndroidFilter = "AND 2=1";
                }
                /*wsgpAvailable and sgpAvailable is used to get available menus that is available for the currently selected security group
                 while the wsgp and sgp is used to get all the menus that is available for the logged in used and which is defined by sonic admin
                 if the logged in used is sonic admin then the system will show all the menus available regardless it is available or not in any
                 of the security groups while any other employee will have access to see only the available menus that is assigned by sonic admin*/

                string androidMenusQuery = string.Empty;
                if (LocalUtilities.WebApplication == WebApplication.Sonic)
                {
                    androidMenusQuery = string.Format(@"UNION
                    select CONVERT(NVARCHAR(20),Menu.MenuID),CONVERT(NVARCHAR(20), Menu.ParentMenuID), Menu.IsParentMenu, '' as URL, '' as Icon, 0 as IsHidden, 
                    null as Sequence, MenuLanguage.Description MenuName, 
                    case when sgpAvailable.MenuID is not null AND sgpAvailable.SecurityGroupID in ({0}) then 1 else 0 end as isAvailable, 0 as isWebMenu, 0 IsWithInReportHierarchy, -1 ReportId, '' GridReportURL, 0 IsReportFavorite
                    from Menu
                    INNER JOIN MenuLanguage on MenuLanguage.MenuID = Menu.MenuID and MenuLanguage.LanguageID = {1}
                    LEFT JOIN SecurityGroupPrivilege sgp on sgp.MenuID = Menu.MenuID  AND sgp.SecurityGroupID in ({4})
                    LEFT JOIN SecurityGroupPrivilege sgpAvailable on sgpAvailable.MenuID = Menu.MenuID  AND sgpAvailable.SecurityGroupID in ({0})
                    where ((Menu.MenuID = 5 {3}) OR (Menu.MenuID >= 5000 AND Menu.MenuID < 6000)) OR (Menu.ParentMenuID = 5) {2} {5}
                    ORDER BY isWebMenu,IsParentMenu,Sequence,MenuID ",
                    securityGroupIdFilter, //0
                    languageId, //1
                    adminAndroidMenusFilter, //2
                    adminAndroidMainMenuFilter, //3
                    mainSecurityGroupFilter, //4
                    preventAndroidFilter//5
                    );
                }

                string allMenusQuery = string.Format(@"select distinct webmenu.*, webmenulanguage.Description MenuName,
                case when wsgpAvailable.MenuID is not null AND wsgpAvailable.SecurityGroupID in ({0}) then 1 else 0 end as isAvailable, 
                case when WebMenu.MenuID = '1400' or ParentMenuID = '1400' then 0 else 1 end as isWebMenu, 
                CASE WHEN MappingReports.WebMenuId IS NULL THEN 0 ELSE 1 END IsWithInReportHierarchy, 
                MappingReports.ReportId ReportId, '{7}' GridReportURL, CASE WHEN EFR.ReportID IS NOT NULL THEN 1 ELSE 0 END AS IsReportFavorite
                from webmenu
                INNER JOIN webmenulanguage on webmenulanguage.MenuID = webmenu.MenuID and webmenulanguage.LanguageID = {1}
                LEFT JOIN WebSecurityGroupPrivilege wsgp on wsgp.MenuID = WebMenu.MenuID  AND wsgp.SecurityGroupID in ({3})
                LEFT JOIN WebSecurityGroupPrivilege wsgpAvailable on wsgpAvailable.MenuID = WebMenu.MenuID  AND wsgpAvailable.SecurityGroupID in ({0})
                LEFT OUTER JOIN MenuActions on wsgp.ActionTypeId = MenuActions.ActionTypeId AND wsgp.MenuID = MenuActions.MenuId
                INNER JOIN WebMenuApplication on WebMenuApplication.MenuId = WebMenu.MenuId and WebMenuApplication.ApplicationId = {5}
                LEFT JOIN MappingReports on MappingReports.WebMenuId = WebMenu.MenuID 
				LEFT JOIN EmployeeFavoriteReport EFR on EFR.EmployeeID = {8} and EFR.ReportID = MappingReports.ReportId
                WHERE 1=1 AND webmenu.IsHidden != 1 {4} {2} 
                {6}",
                securityGroupIdFilter, //0
                languageId, //1
                adminWebMenusFilter, //2
                mainSecurityGroupFilter, //3
                supervisorMenuAccess, //4
                LocalUtilities.WebApplication.GetHashCode(), //5
                androidMenusQuery, //6
                LocalUtilities.GridReportURL, //7
                _requestRepository.CurrentOperator.EmployeeId //8
                );
                result = menu_dbHelper.GetQueryList(allMenusQuery, ref allMenus);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }

                //  Get Child menus
                if (result == GlobalErrors.Success && allMenus != null && allMenus.Count > 0)
                {
                    string menuIDs = string.Empty;
                    for (int i = 0; i < allMenus.Count; i++)
                    {
                        menuIDs += "'" + allMenus[i].MenuId + "'" + ',';
                    }
                    if (!string.IsNullOrEmpty(menuIDs))
                        menuIDs = menuIDs.TrimEnd(',');
                    List<ActionTypesModel> menuActionsList;
                    List<ActionTypesModel> addedMenuActionsList;
                    result = GetActionsAvailable(securityGroupIdFilter, languageId, menuIDs, ref actionTypes, ref addedActionTypes);
                    for (int i = 0; i < allMenus.Count; i++)
                    {
                        menuActionsList = new List<ActionTypesModel>();
                        addedMenuActionsList = new List<ActionTypesModel>();

                        // for customers menu, never (add Divisions Payment Term & Divisions On Hold Status) actions if ControlTransactionOnDivisionLevel is false 
                        if (allMenus[i].MenuId == "100-003-01" && !_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                        {
                            allMenus[i].ActionTypes = actionTypes.FindAll(actions => actions.MenuId == allMenus[i].MenuId && actions.ActionTypeId != 32 && actions.ActionTypeId != 33);
                            allMenus[i].AddedActionTypes = addedActionTypes.FindAll(actions => actions.MenuId == allMenus[i].MenuId && actions.ActionTypeId != 32 && actions.ActionTypeId != 33);
                        }
                        else
                        {
                            allMenus[i].ActionTypes = actionTypes.FindAll(actions => actions.MenuId == allMenus[i].MenuId);
                            allMenus[i].AddedActionTypes = addedActionTypes.FindAll(actions => actions.MenuId == allMenus[i].MenuId);
                        }
                    }
                    availableMenus = allMenus.FindAll(menu => menu.IsAvailable);
                    allAddedMenus = allMenus.FindAll(firstLevel => firstLevel.IsParentMenu && (firstLevel.ParentMenuId == "-1" || firstLevel.MenuId == "5"));

                    allAddedMenus.ForEach(firstLevel =>
                    {
                        firstLevel.ChildMenus = allMenus.FindAll(secondLevel => secondLevel.ParentMenuId == firstLevel.MenuId);
                        firstLevel.ParentMenus = "9";
                    });
                    allAddedMenus.ForEach(firstLevel => firstLevel.ChildMenus.ForEach(secondLevel =>
                    {
                        secondLevel.ChildMenus = allMenus.FindAll(thiredLevel => thiredLevel.ParentMenuId == secondLevel.MenuId);
                        secondLevel.ParentMenus = secondLevel.ParentMenuId + "-" + secondLevel.MenuId;
                        secondLevel.ParentMenuIdsList.Add(secondLevel.ParentMenuId);
                    }));
                    allAddedMenus.ForEach(firstLevel => firstLevel.ChildMenus.ForEach(secondLevel => secondLevel.ChildMenus.ForEach(thirdLevel =>
                    {
                        thirdLevel.ChildMenus = allMenus.FindAll(forthLevel => forthLevel.ParentMenuId == thirdLevel.MenuId);
                        thirdLevel.ParentMenus = secondLevel.ParentMenuId + "-" + thirdLevel.ParentMenuId + "-" + thirdLevel.MenuId;
                        thirdLevel.ParentMenuIdsList.Add(secondLevel.ParentMenuId);
                        thirdLevel.ParentMenuIdsList.Add(thirdLevel.ParentMenuId);
                    })));
                    allAddedMenus.ForEach(firstLevel => firstLevel.ChildMenus.ForEach(secondLevel => secondLevel.ChildMenus.ForEach(thirdLevel => thirdLevel.ChildMenus.ForEach(forthLevel =>
                    {
                        forthLevel.ChildMenus = allMenus.FindAll(fivthLevel => fivthLevel.ParentMenuId == forthLevel.MenuId);
                        forthLevel.ParentMenus = secondLevel.ParentMenuId + "-" + thirdLevel.ParentMenuId + "-" + forthLevel.ParentMenuId + "-" + forthLevel.MenuId;
                        forthLevel.ParentMenuIdsList.Add(secondLevel.ParentMenuId);
                        forthLevel.ParentMenuIdsList.Add(thirdLevel.ParentMenuId);
                        forthLevel.ParentMenuIdsList.Add(forthLevel.ParentMenuId);
                    }))));
                    allAddedMenus.ForEach(firstLevel => firstLevel.ChildMenus.ForEach(secondLevel => secondLevel.ChildMenus.ForEach(thirdLevel => thirdLevel.ChildMenus.ForEach(forthLevel => forthLevel.ChildMenus.ForEach(fivthLevel =>
                    {
                        fivthLevel.ChildMenus = allMenus.FindAll(sixthLevel => sixthLevel.ParentMenuId == fivthLevel.MenuId);
                        fivthLevel.ParentMenus = secondLevel.ParentMenuId + "-" + thirdLevel.ParentMenuId + "-" + forthLevel.ParentMenuId + "-" + fivthLevel.ParentMenuId + "-" + fivthLevel.MenuId;
                        fivthLevel.ParentMenuIdsList.Add(secondLevel.ParentMenuId);
                        fivthLevel.ParentMenuIdsList.Add(thirdLevel.ParentMenuId);
                        fivthLevel.ParentMenuIdsList.Add(forthLevel.ParentMenuId);
                        fivthLevel.ParentMenuIdsList.Add(fivthLevel.ParentMenuId);
                    })))));
                    allAddedMenus.ForEach(firstLevel => firstLevel.ChildMenus.ForEach(secondLevel => secondLevel.ChildMenus.ForEach(thirdLevel => thirdLevel.ChildMenus.ForEach(forthLevel => forthLevel.ChildMenus.ForEach(fivthLevel => fivthLevel.ChildMenus.ForEach(sixthLevel =>
                    {
                        sixthLevel.ChildMenus = allMenus.FindAll(seventhLevel => seventhLevel.ParentMenuId == sixthLevel.MenuId);
                        sixthLevel.ParentMenus = secondLevel.ParentMenuId + "-" + thirdLevel.ParentMenuId + "-" + forthLevel.ParentMenuId + "-" + fivthLevel.ParentMenuId + "-" + sixthLevel.ParentMenuId + "-" + sixthLevel.MenuId;
                        sixthLevel.ParentMenuIdsList.Add(secondLevel.ParentMenuId);
                        sixthLevel.ParentMenuIdsList.Add(thirdLevel.ParentMenuId);
                        sixthLevel.ParentMenuIdsList.Add(forthLevel.ParentMenuId);
                        sixthLevel.ParentMenuIdsList.Add(fivthLevel.ParentMenuId);
                        sixthLevel.ParentMenuIdsList.Add(sixthLevel.ParentMenuId);
                    }))))));


                    if (result == GlobalErrors.Success)
                    {
                        addedMenus = allAddedMenus;
                        allAvailableMenus = availableMenus;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        public List<MenuModel> SetMenuLevels(List<MenuModel> AllMenus, List<MenuModel> FilteredAllMenus, string parentMenus)
        {
            List<MenuModel> SortedMenus = FilteredAllMenus;
            try
            {
                SortedMenus.ForEach(menu =>
                {
                    menu.ChildMenus = AllMenus.FindAll(secondLevel => secondLevel.ParentMenuId == menu.MenuId);
                    menu.ParentMenus += parentMenus + "-" + menu.ParentMenuId;
                    if (menu.ChildMenus != null && menu.ChildMenus.Count > 0)
                    {
                        SetMenuLevels(AllMenus, menu.ChildMenus, menu.ParentMenuId);
                    }
                });

            }
            catch (Exception ex)
            {

            }
            return SortedMenus;
        }

        public static GlobalErrors GetActionsAvailable(string SecurityGroupFilter, int LanguageId, string menusIds, ref List<ActionTypesModel> ActionsList, ref List<ActionTypesModel> AddedActionsList)
        {
            DBHelper<ActionTypesModel> menu_dbHelper = new DBHelper<ActionTypesModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            ActionsList = new List<ActionTypesModel>();
            AddedActionsList = new List<ActionTypesModel>();
            try
            {
                string allMenusQuery = string.Format(@"select distinct MenuActionTypes.ActionTypeId, MenuActionTypesLanguage.Description as ActionTypeName, MenuActions.MenuId, 
                case when WebSecurityGroupPrivilege.SecurityGroupID IS NOT NULL then 1 else 0 end as IsAdded, MenuActions.URL
                from MenuActionTypes
                LEFT OUTER JOIN MenuActionTypesLanguage on MenuActionTypesLanguage.ActionTypeId = MenuActionTypes.ActionTypeId 
                AND MenuActionTypesLanguage.LanguageId = {2}
                INNER JOIN MenuActions on MenuActions.ActionTypeId = MenuActionTypes.ActionTypeId AND MenuActions.MenuId in ({0})
                LEFT OUTER JOIN WebSecurityGroupPrivilege on WebSecurityGroupPrivilege.MenuID = MenuActions.MenuId 
                AND WebSecurityGroupPrivilege.ActionTypeId = MenuActions.ActionTypeId AND WebSecurityGroupPrivilege.SecurityGroupID in ({1}) ",
                menusIds, SecurityGroupFilter, LanguageId);
                result = menu_dbHelper.GetQueryList(allMenusQuery, ref ActionsList);

                if (result == GlobalErrors.Success)
                {
                    //allMenusQuery = string.Format(@"select MenuActionTypes.ActionTypeId, MenuActionTypesLanguage.Description as ActionTypeName, MenuActions.MenuId, 
                    //1 as IsAdded, MenuActions.URL
                    //from MenuActionTypes
                    //LEFT OUTER JOIN MenuActionTypesLanguage on MenuActionTypesLanguage.ActionTypeId = MenuActionTypes.ActionTypeId 
                    //AND MenuActionTypesLanguage.LanguageId = {2}
                    //INNER JOIN MenuActions on MenuActions.ActionTypeId = MenuActionTypes.ActionTypeId AND MenuActions.MenuId = '{0}'
                    //INNER JOIN WebSecurityGroupPrivilege on WebSecurityGroupPrivilege.MenuID = MenuActions.MenuId 
                    //AND WebSecurityGroupPrivilege.ActionTypeId = MenuActions.ActionTypeId AND WebSecurityGroupPrivilege.SecurityGroupID in ({1})",
                    //MenuId, SecurityGroupFilter, LanguageId);
                    //result = menu_dbHelper.GetQueryList(allMenusQuery, ref AddedActionsList);
                    AddedActionsList = ActionsList.FindAll(actions => actions.IsAdded);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors GetEmployeesFilterData(EmployeeFilter filter, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            if (filter == null)
                filter = new EmployeeFilter();
            string territoryFilter = string.Empty;
            string vehicleFilter = string.Empty;
            string unionFilter = string.Empty;
            string routeFilter = string.Empty;
            string regionFilter = string.Empty;
            string channelFilter = string.Empty;
            string employeeFilter = string.Empty;
            string isExceptSelectedEmployeesFilter = string.Empty;
            string salesManagerSupervisorFilter = string.Empty;
            string salesManagerSupervisorSalesPersonFilter = string.Empty;
            string supervisorFilter = string.Empty;
            string securityGroupJoin = string.Empty;
            string securityGroupFilter = string.Empty;
            string viewEmployeeHaveOrders = string.Empty;

            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                StringBuilder employeeQuery = new StringBuilder();
                string selectedOrgFilter = string.Empty;
                if (!string.IsNullOrEmpty(filter.MultiOrganizationId))
                {
                    selectedOrgFilter = string.Format(" And Employee.OrganizationID IN ({0}) ", filter.MultiOrganizationId);
                }
                if (filter.OrganizationId != -1)
                {
                    selectedOrgFilter = string.Format(" And Employee.OrganizationID IN ({0}) ", filter.OrganizationId);
                }
                if (filter.HasTerritories)
                {
                    string territories = string.Empty;
                    if (!string.IsNullOrEmpty(filter.TerritoryIds))
                        territories = $" AND EmployeeTerritory.TerritoryID IN ({filter.TerritoryIds}) ";
                   
                    territoryFilter = string.Format(@"INNER JOIN EmployeeTerritory ON EmployeeTerritory.EmployeeID = Employee.EmployeeID {0}", territories);
                }
                else
                {
                    territoryFilter = string.Format(@"LEFT OUTER JOIN EmployeeTerritory ON EmployeeTerritory.EmployeeID = Employee.EmployeeID");
                }
                if (filter.IsFOEmployee)
                {
                    var str = string.Format(@"{0}, {1}, {2},{3},{4},{5},{6},{7}", EmployeeTypes.Salesperson.GetHashCode(), EmployeeTypes.Deliveryperson.GetHashCode(), EmployeeTypes.Collector.GetHashCode(),EmployeeTypes.Presales.GetHashCode(),EmployeeTypes.Driver.GetHashCode(),EmployeeTypes.SalesRepresentative.GetHashCode(),EmployeeTypes.VanInCharge.GetHashCode(),EmployeeTypes.Merchandiser.GetHashCode());
                    employeeFilter = string.Format(@" And Employee.EmployeeTypeID IN ({0})", str);
                }
                if (filter.ExcludeOnholdEmployee)
                {
                    employeeFilter = string.Format(@" AND Employee.OnHold = 0 ");
                }

                if (filter.HasVehicles)
                {
                    vehicleFilter = string.Format(@"INNER JOIN EmployeeVehicle on EmployeeVehicle.EmployeeID = Employee.EmployeeID");
                }
                else
                {
                    vehicleFilter = string.Format(@"LEFT OUTER JOIN EmployeeVehicle on EmployeeVehicle.EmployeeID = Employee.EmployeeID");
                }
                if (filter.FilterOnRoute || filter.RouteId > 0)
                {
                    routeFilter = string.Format(@"inner join EmployeeTerritory territoryFilter on territoryFilter.EmployeeID=Employee.EmployeeID
                    inner join [Route] on [Route].TerritoryID=territoryFilter.TerritoryID and [Route].RouteID={0}", filter.RouteId);
                }
                if (filter.IsAllEmployeesFieldAvailable)
                {
                    unionFilter = string.Format(@"UNION Select -1 as EmployeeID, null as VehichleID, null as TerritoryID, 
                    case when 1 = {0} then 'All Employees' else 'جميع الموظفين' end as Description, 
                    'All Employees' as EmployeeCode,
                    case when 1 = {0} then 'All Employees' else 'جميع الموظفين' end as EmployeeCodeName, -1 as CustomerID
                    Order by EmployeeID", _requestRepository.LanguageId);
                }
                if (filter.RegionId != -1)
                {
                    regionFilter = string.Format(@" and Employee.RegionID = {0}", filter.RegionId);
                }
                if (filter.ChannelId != -1)
                {
                    channelFilter = string.Format(@" and Employee.ChannelID = {0}", filter.ChannelId);
                }
                if (filter.isExceptSelectedEmployees && filter.CustomerId > 0)
                {
                    isExceptSelectedEmployeesFilter = string.Format(@" AND (Employee.CustomerID IS NULL OR Employee.CustomerID IN (-1, 0, {0}))", filter.CustomerId);
                }
                // if employee is supervisor , and sales manager id != -1 :
                if (filter.EmployeeTypes != null && filter.EmployeeTypes.Count == 1 && filter.EmployeeTypes[0] == EmployeeTypes.Supervisor && filter.salesManagerId != -1)
                {
                    salesManagerSupervisorFilter = string.Format(@" LEFT OUTER JOIN SupervisorSalesMngr ON Employee.EmployeeID = SupervisorSalesMngr.SupervisorID");
                }
                if (filter.SecurityGroupId != -1)
                {
                    securityGroupJoin = string.Format(@"LEFT OUTER JOIN EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
				        LEFT OUTER JOIN OperatorSecurityGroup on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID");
                    securityGroupFilter = string.Format(@"and OperatorSecurityGroup.SecurityGroupID = {0}", filter.SecurityGroupId);
                }
                // if employee is salesperson , and and sales manager id != -1
                if (filter.EmployeeTypes != null && filter.EmployeeTypes.Count == 3 &&
                    filter.EmployeeTypes.Contains(EmployeeTypes.Salesperson) &&
                    filter.EmployeeTypes.Contains(EmployeeTypes.Deliveryperson) &&
                    filter.EmployeeTypes.Contains(EmployeeTypes.Presales) &&
                    (filter.salesManagerId != -1 || filter.supervisorId != -1))
                {
                    salesManagerSupervisorSalesPersonFilter = string.Format(@"LEFT OUTER JOIN EmployeeSupervisor ON EmployeeSupervisor.EmployeeID = Employee.EmployeeID 
                    LEFT OUTER JOIN SupervisorSalesMngr ON EmployeeSupervisor.SupervisorID = SupervisorSalesMngr.SupervisorID");
                }
                if ((filter.GetEmployeesHavingOrdersFromInvoiced || filter.GetEmployeesHavingOrdersFromApproved || filter.GetEmployeesHavingOrdersFromReschedule) && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    viewEmployeeHaveOrders = string.Format(@" inner join CustOutTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
                    inner join SalesOrder on SalesOrder.CustomerID = CustOutTerritory.CustomerID and SalesOrder.OutletID = CustOutTerritory.OutletID");
                }

                employeeQuery.AppendFormat(@"SELECT DISTINCT Employee.EmployeeID, EmployeeVehicle.VehicleID , EmployeeTerritory.TerritoryID, EmployeeLanguage.Description ,Employee.EmployeeCode  ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName, Employee.CustomerID
                FROM Employee    
                INNER JOIN EmployeeOrganization ON EmployeeOrganization.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND  EmployeeLanguage.LanguageID = {0}
                {2}
                {3}
                {6}
                {8}
                {11}
                {12}
                {14}
                {16}
                WHERE Employee.EmployeeID {1} And Employee.Inactive = 0 and Employee.OrganizationID in ({4}) {10} {9}  {5} {6}
                {7} {13} {15}",
                _requestRepository.LanguageId, //0
                GetSupervisorAccess(),//1
                territoryFilter,//2
                vehicleFilter,//3
                _requestRepository.CurrentOperator.OrganizationAccess,//4
                regionFilter, //5
                channelFilter,//6 
                unionFilter,//7
                routeFilter,//8
                isExceptSelectedEmployeesFilter,//9
                selectedOrgFilter, //10
                salesManagerSupervisorFilter, //11
                salesManagerSupervisorSalesPersonFilter, //12
                employeeFilter, //13
                securityGroupJoin, //14
                securityGroupFilter, //15
                viewEmployeeHaveOrders //16
                );

                if (filter.EmployeeTypes.Count > 0)
                {
                    employeeQuery.AppendFormat(@"AND Employee.EmployeeTypeID in ({0}) ", string.Join(",", filter.EmployeeTypes.Select(x => (int)x)));
                }
                if (salesManagerSupervisorFilter != string.Empty && filter.salesManagerId != -1 || salesManagerSupervisorSalesPersonFilter != string.Empty && filter.salesManagerId != -1 && filter.supervisorId == -1)
                {
                    employeeQuery.AppendFormat(@" AND SupervisorSalesMngr.SalesManagerID = {0} ", filter.salesManagerId);
                }
                if (salesManagerSupervisorSalesPersonFilter != string.Empty && filter.supervisorId != -1)
                {
                    employeeQuery.AppendFormat(@" AND EmployeeSupervisor.SupervisorID  = {0} ", filter.supervisorId);
                }
                if (_requestRepository.CurrentOperator.EmployeeId != 0)
                {
                    employeeQuery.AppendFormat(@" AND Employee.EmployeeID <> 0");
                }
                if (filter.GetEmployeesHavingOrdersFromInvoiced && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    employeeQuery.AppendFormat(@" And isnull(SalesOrder.RecallId,-1) = -1 AND SalesOrder.OrderTypeID <> 4  AND  SalesOrder.OrderStatusID in ({0},{1},{2}) and SalesOrder.OrderTypeID in ({3})", OrderStatus.Invoiced.GetHashCode(), OrderStatus.Rescheduled.GetHashCode(), OrderStatus.Delivered.GetHashCode(), OrderTypes.Sales.GetHashCode());
                }
                if (filter.GetEmployeesHavingOrdersFromApproved && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    employeeQuery.AppendFormat(@" And (SalesOrder.RecallId Is null or SalesOrder.RecallId = -1) And SalesOrder.orderTypeID <> 4 AND SalesOrder.OrderStatusID in  ({0},{1}) And SalesOrder.OrganizationID in ({2}) and SalesOrder.OrderTypeID in ({3},{4})", OrderStatus.Approved.GetHashCode(), OrderStatus.Rescheduled.GetHashCode(),_requestRepository.CurrentOperator.OrganizationAccess,OrderTypes.Sales.GetHashCode(), OrderTypes.Return.GetHashCode());
                }
                if (filter.GetEmployeesHavingOrdersFromReschedule && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    employeeQuery.AppendFormat(@" And isnull(SalesOrder.RecallId,-1) = -1 And SalesOrder.OrderTypeID <> 4 AND  SalesOrder.OrderStatusID in ({0},{1},{2}) and SalesOrder.OrderTypeID in ({3},{4})  ", OrderStatus.Assigned.GetHashCode(), OrderStatus.WaitForLoad.GetHashCode(), OrderStatus.LoadRequestAccepted.GetHashCode(), OrderTypes.Sales.GetHashCode(), OrderTypes.Return.GetHashCode());
                }

                result = dbHelper.GetQueryList(employeeQuery.ToString(), ref employeeList);
                if (filter.IsAllEmployeesFieldAvailable && employeeList != null && employeeList.Count == 1 && employeeList[0].EmployeeId == -1)
                    employeeList = new List<EmployeeModel>();
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCustomerRouteEmployees(EmployeeFilter filter, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            string routeTerritoryFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                StringBuilder employeeQuery = new StringBuilder();
                string selectedOrgFilter = string.Empty;
                if (filter.OrganizationId != -1)
                {
                    selectedOrgFilter = string.Format(" And Employee.OrganizationID IN ({0}) ", filter.OrganizationId);
                }
                if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                {
                    routeTerritoryFilter = string.Format(@"INNER JOIN CustOutTerritory on CustOutTerritory.TerritoryID = EmployeeTerritory.TerritoryID 
                    AND CustOutTerritory.CustomerID = {0} AND CustOutTerritory.OutletID = {1}", filter.CustomerId, filter.OutletId);
                }
                else
                {
                    routeTerritoryFilter = string.Format(@"INNER JOIN Route on Route.TerritoryID = EmployeeTerritory.TerritoryID
                    INNER JOIN RouteCustomer on RouteCustomer.RouteID = RouteCustomer.RouteID AND RouteCustomer.CustomerID = {0} AND RouteCustomer.OutletID = {1}", filter.CustomerId, filter.OutletId);
                }

                employeeQuery.AppendFormat(@"Select  DISTINCT Employee.EmployeeID, EmployeeTerritory.TerritoryID, EmployeeLanguage.Description ,Employee.EmployeeCode  ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName, EmployeeVehicle.VehicleID
                From Employee
                LEFT JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                INNER JOIN EmployeeTerritory on EmployeeTerritory.EmployeeID = Employee.EmployeeID
                {2}
                LEFT OUTER JOIN EmployeeVehicle on EmployeeVehicle.EmployeeID = Employee.EmployeeID
                Where Employee.EmployeeID {1} And Employee.Inactive = 0 And Employee.OrganizationID in ({3}) {4}",
                _requestRepository.LanguageId, //0
                GetSupervisorAccess(), //1
                routeTerritoryFilter, //2
                _requestRepository.CurrentOperator.OrganizationAccess, //3
                selectedOrgFilter //4
                );

                if (filter.EmployeeTypes.Count > 0)
                {
                    employeeQuery.AppendFormat(@"AND Employee.EmployeeTypeID in ({0}) ", string.Join(",", filter.EmployeeTypes.Select(x => (int)x)));
                }

                result = dbHelper.GetQueryList(employeeQuery.ToString(), ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerEmployees(int customerId, int outletId, ref List<int> employeesList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sql = string.Format(@" select distinct EmployeeTerritory.EmployeeID 
                from CustOutTerritory
                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
                where CustOutTerritory.CustomerID = {0} and CustOutTerritory.OutletID = {1} ",
                customerId, outletId);
                result = dBHelper.GetQueryList(sql, ref employeesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region [Employee Entry Data]
        public GlobalErrors GetNotConnectedHelpersOrDrivers(int employeeID, int organizationID, EmployeeTypes employeeType, ref List<EmployeeModel> freeEmployeesList)
        {
            DBHelper<EmployeeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                freeEmployeesList = new List<EmployeeModel>();
                dbHelper = new DBHelper<EmployeeModel>();
                string tableName = string.Empty;
                string columnName = string.Empty;

                if (employeeType == EmployeeTypes.Driver)
                {
                    tableName = CoreDataBaseConstants.TableNames.EmployeeDriver;
                    columnName = CoreDataBaseConstants.QueryColumnsNames.DriverID;
                }
                else if (employeeType == EmployeeTypes.Helper)
                {
                    tableName = CoreDataBaseConstants.TableNames.EmployeeHelper;
                    columnName = CoreDataBaseConstants.QueryColumnsNames.HelperID;
                }

                string query = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName, Employee.EmployeeCode,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                FROM Employee      
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID AND EmployeeTypeLanguage.LanguageID = 1
                LEFT OUTER JOIN EmployeePaymentTerm ON EmployeePaymentTerm.EmployeeID = Employee.EmployeeID
                left outer join {4} on {4}.{5} = Employee.EmployeeID
                WHERE Employee.EmployeeTypeID ={1} AND Employee.OrganizationID = {2}
                and ({4}.EmployeeID is null or {4}.EmployeeID = -1 or {4}.EmployeeID = {3})",
                _requestRepository.LanguageId, //0
                employeeType.GetHashCode(), //1
                organizationID, //2
                employeeID, //3
                tableName, //4
                columnName //5
                );

                result = dbHelper.GetQueryList(query, ref freeEmployeesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                freeEmployeesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContactCountrys(ref List<ContactCountryModel> ContactCountrysList)
        {
            DBHelper<ContactCountryModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ContactCountrysList = new List<ContactCountryModel>();
                dbHelper = new DBHelper<ContactCountryModel>();
                
                string query = string.Format(@"
                          SELECT  IsNull(ContactCountry.PrefixCode , '--') + ' ' + '-'+ ' ' + IsNull( ContactCountry.CountryCode , '--') ContactCountryPrefixCode ,
                          ContactCountry.CountryID ContactCountryId from ContactCountry
                          INNER JOIN ContactCountryLanguage ON ContactCountry.CountryID = ContactCountryLanguage.CountryID AND LanguageID = {0}",
                _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref ContactCountrysList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ContactCountrysList = null;
                return GlobalErrors.Error;
            }
            return result;
        } 
        public GlobalErrors GetChannels(int organizationID, ref List<ChannelModel> channelsList)
        {
            DBHelper<ChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string organization = string.Empty;
            try
            {
                channelsList = new List<ChannelModel>();
                dbHelper = new DBHelper<ChannelModel>();
                if (organizationID == -1)
                {
                    organization = string.Format(@" EmployeeChannelOrganization.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                else
                {
                    organization = string.Format(@" EmployeeChannelOrganization.OrganizationID in ({0})", organizationID);
                }
                string query = string.Format(@"SELECT DISTINCT EmployeeChannelDefinition.ChannelId, EmployeeChannelDefinitionlanguage.Description ChannelName, EmployeeChannelDefinition.ChannelCode,
                IsNull( EmployeeChannelDefinition.ChannelCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeChannelDefinitionlanguage.Description , '--') as ChannelCodeName
                FROM EmployeeChannelDefinition
                Inner JOIN EmployeeChannelOrganization ON EmployeeChannelDefinition.ChannelId = EmployeeChannelOrganization.ChannelID
                Inner JOIN EmployeeChannelDefinitionlanguage ON EmployeeChannelDefinition.ChannelId = EmployeeChannelDefinitionlanguage.ChannelId  AND EmployeeChannelDefinitionlanguage.LanguageID = {0}
                 WHERE {1}",
                _requestRepository.LanguageId, //0
                organization //1
                );
                result = dbHelper.GetQueryList(query, ref channelsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                channelsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeBranches(int organizationID, ref List<EmployeeBranchModel> EmployeeBranchesList)
        {
            DBHelper<EmployeeBranchModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string OrgAccess = string.Empty;
            try
            {
                if(organizationID != -1)
                {
                    OrgAccess = string.Format(" AND EmployeeBranch.OrganizationID in ({0})", organizationID);
                }
                EmployeeBranchesList = new List<EmployeeBranchModel>();
                dbHelper = new DBHelper<EmployeeBranchModel>();
                string query = string.Format(@"SELECT DISTINCT EmployeeBranch.EmployeeBranchID , EmployeeBranchLanguage.Description EmployeeBranchName, EmployeeBranch.BranchCode,
                IsNull( EmployeeBranch.BranchCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeBranchLanguage.Description , '--') as EmployeeBranchCodeName
                FROM EmployeeBranch
                Inner JOIN EmployeeBranchLanguage ON EmployeeBranchLanguage.EmployeeBranchID = EmployeeBranch.EmployeeBranchID  AND EmployeeBranchLanguage.LanguageID = {0}
                 WHERE 1=1 {1}",
                _requestRepository.LanguageId, //0
                OrgAccess //1
                );
                result = dbHelper.GetQueryList(query, ref EmployeeBranchesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                EmployeeBranchesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRegions(ref List<RegionModel> freeRegionsList)
        {
            DBHelper<RegionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                freeRegionsList = new List<RegionModel>();
                dbHelper = new DBHelper<RegionModel>();
                string query = string.Format(@"SELECT DISTINCT State.StateId RegionId, StateLanguage.Description RegionName, State.StateCode RegionCode,
                IsNull( State.StateCode , '--') + ' ' + '-'+ ' ' + IsNull( StateLanguage.Description , '--') as RegionCodeName
                FROM State 
                INNER JOIN StateLanguage ON State.StateId = StateLanguage.StateId  AND StateLanguage.LanguageID = {0}",
                _requestRepository.LanguageId //0
                );
                result = dbHelper.GetQueryList(query, ref freeRegionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                freeRegionsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRelatedEmployees(int employeeID, int organizationID, int employeeTypeId, ref List<EmployeeModel> relatedEmployeeList)
        {
            return GetRelatedEmployees(employeeID, organizationID, employeeTypeId, ref relatedEmployeeList, null);
        }
        public GlobalErrors GetRelatedEmployees(int employeeID, int organizationID, int employeeTypeId, ref List<EmployeeModel> relatedEmployeeList, DBHelper<int> dBHelper)
        {
            DBHelper<EmployeeModel> dBHelper2 = null;
            if (dBHelper != null)
            {
                dBHelper2 = new DBHelper<EmployeeModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
            }
            else
            {
                dBHelper2 = new DBHelper<EmployeeModel>();
            }
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string filterQuery = string.Empty;
                string supervisedEmployees = GetSupervisorAccess();
                bool searchInactive = false;
                string OrgParentJoin = string.Empty;
                string OrgAccess = string.Empty;

                if (!supervisedEmployees.Equals(" NOT IN (-1)"))
                {
                    supervisedEmployees = supervisedEmployees.Replace(")", string.Format(", {0} )", _requestRepository.CurrentOperator.EmployeeId));
                }
                if (employeeID != -1)
                {
                    filterQuery = string.Format(" AND Employee.EmployeeID <> {0} ", employeeID);
                }
               
                StringBuilder employeeQuery = new StringBuilder();
                StringBuilder OrgParentsQuery = new StringBuilder();

                if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                {
                    OrgParentsQuery.AppendFormat(string.Format(CoreDataBaseConstants.OrgParentsQuery, _requestRepository.CurrentOperator.OrganizationAccess));
                    OrgParentJoin = string.Format(@"INNER JOIN @OrganizationTemp Org ON Employee.OrganizationID = Org.OrganizationID AND Org.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OriginalOrganizationAccess);
                }
                else
                {
                    OrgAccess = @$"AND Employee.OrganizationID IN ({_requestRepository.CurrentOperator.OrganizationAccess})";
                }

                employeeQuery.AppendFormat(@"  
                {1}
                SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName, Employee.EmployeeCode,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                FROM Employee      
                INNER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID And EmployeeLanguage.LanguageID = {0}
                {3}
                WHERE Employee.EmployeeID {2} {4}",
                _requestRepository.LanguageId, //0
                OrgParentsQuery, //1
                supervisedEmployees, //2
                OrgParentJoin, //3
                OrgAccess // 4
                );

                if (employeeTypeId != EmployeeTypes.None.GetHashCode())
                {
                    employeeQuery.AppendFormat(" AND Employee.EmployeeTypeID = {0} ", employeeTypeId);
                }
                //if (organizationID != -1)
                //{
                //    employeeQuery.AppendFormat(" AND Employee.OrganizationID = {0} ", organizationID);
                //}
                if (!searchInactive)
                {
                    employeeQuery.AppendFormat(" AND Employee.Inactive = 0 ");
                }
                if (filterQuery != string.Empty)
                {
                    employeeQuery.AppendFormat(filterQuery);
                }
                employeeQuery.Append(" ORDER BY EmployeeLanguage.Description ");

                result = dBHelper2.GetQueryList(employeeQuery.ToString(), ref relatedEmployeeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                relatedEmployeeList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public string GetSupervisorAccess()
        {
            string supervisorString = string.Empty;
            try
            {
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisorString = string.Format(" IN ({0})", _requestRepository.CurrentOperator.SubordinatesEmployeesAsString);
                }
                else
                {
                    supervisorString = " NOT IN (-1)";
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return supervisorString;
        }
        public string GetSupervisorAccessForReport(int employeeTypeId , int employeeId)
        {
            string supervisorString = string.Empty;
            try
            {
                if (employeeTypeId == EmployeeTypes.Supervisor.GetHashCode()
                    || employeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || employeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisorString = string.Format(" IN ({0})", GetAllSuppervisedEmployees(employeeId, null));
                }
                else
                {
                    supervisorString = " NOT IN (-1)";
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return supervisorString;
        }
        public string GetVehiclesUnderEmployeeAccess()
        {
            string vehiclesUnderOrgAccess = "-1";
            try
            {
                List<int> vehicleIdsList = new List<int>();
                DBHelper<int> dBHelper = new DBHelper<int>();

                string query = $@"select VehicleID from Vehicle
                inner join warehouse on warehouse.warehouseid = vehicle.vehicleid where warehouse.organizationid in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";

                GlobalErrors result = dBHelper.GetQueryList(query, ref vehicleIdsList);
                if (result == GlobalErrors.Success)
                {
                    if(vehicleIdsList == null || vehicleIdsList.Count == 0)
                    {
                        vehicleIdsList.Add(-1);
                    }
                    vehiclesUnderOrgAccess = string.Join(",", vehicleIdsList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return vehiclesUnderOrgAccess;
        }
        public string GetAllSuppervisedEmployees(int employeeId, DBHelper<int> dBHelper)
        {
            // send employee id because in login process (core session data are still ot cashed)
            string supervisedEmployeesString = "-1,";
            bool useSameHelper = false;
            try
            {
                DataTable dt = new DataTable();
                if (dBHelper != null)
                {
                    useSameHelper = true;
                }
                else
                {
                    dBHelper = new DBHelper<int>();
                    useSameHelper = false;
                }
                // This part to explain the returnrd valur from each part in the below query
                //                SELECT DISTINCT EmployeeSupervisor.EmployeeID
                //FROM EmployeeSupervisor
                //WHERE
                //--Employees under the Login Supervisor
                //EmployeeSupervisor.SupervisorID ={ 0}
                //                --Employees under Supervisor under Login Sales Manager
                //OR EmployeeSupervisor.SupervisorID IN
                //(Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID ={ 0}) 
                //--Employees under Supervisor under Sales Manager under the login Director
                //OR EmployeeSupervisor.SupervisorID IN
                //(Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID in
                //(select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID ={ 0})) 
                //union
                //Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID
                //from SupervisorSalesMngr
                //where
                //--Supervisor under the Login Sales Manager
                //SalesManagerID = { 0 }
                //--Supervisors under Sales Manager under Login Director
                //OR SupervisorSalesMngr.SalesManagerID in 
                //(select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID ={ 0}) 
                //--Sales Manager under Login Director
                //union
                //Select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID ={ 0}

                string query = string.Format(@" SELECT DISTINCT EmployeeSupervisor.EmployeeID 
                FROM EmployeeSupervisor 
                WHERE EmployeeSupervisor.SupervisorID ={0}  
                OR EmployeeSupervisor.SupervisorID IN 
                ( Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID={0}) 
                OR EmployeeSupervisor.SupervisorID IN 
                ( Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID in 
                (select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID={0})) 
                union                  
                Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID 
                from SupervisorSalesMngr 
                where 
                SalesManagerID={0} 
                OR SupervisorSalesMngr.SalesManagerID in 
                ( select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID={0}) 
                union   
                Select DISTINCT SalesManagerDirector.ManagerID EmployeeID from SalesManagerDirector where DirectorID={0}" ,
                employeeId //0
                );

                GlobalErrors result = dBHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString()))
                        {
                            supervisedEmployeesString += dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString() + ",";
                        }
                    }
                    supervisedEmployeesString += employeeId.ToString();
                    supervisedEmployeesString = supervisedEmployeesString.TrimEnd(",".ToCharArray());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null && !useSameHelper)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return supervisedEmployeesString;
        }

        public static string GetAllSuppervisedEmployeesOld(int employeeId, DBHelper<int> dBHelper)
        {
            // send employee id because in login process (core session data are still ot cashed)
            string supervisedEmployeesString = "-1,";
            bool useSameHelper = false;
            try
            {
                DataTable dt = new DataTable();
                if (dBHelper != null)
                {
                    useSameHelper = true;
                }
                else
                {
                    dBHelper = new DBHelper<int>();
                    useSameHelper = false;
                }

                string query = string.Format(@" SELECT DISTINCT EmployeeSupervisor.EmployeeID FROM EmployeeSupervisor 
                WHERE EmployeeSupervisor.SupervisorID ={0} OR EmployeeSupervisor.SupervisorID IN
                (SELECT EmployeeSupervisor.EmployeeID FROM EmployeeSupervisor WHERE EmployeeSupervisor.SupervisorID = {0})
                OR EmployeeSupervisor.SupervisorID IN ( Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID={0})
                union                  
                Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID={0}
                union                  
                Select DISTINCT EmployeeSalesRep.EmployeeID EmployeeID from EmployeeSalesRep where SalesRepID={0}
                or SalesRepID in(SELECT EmployeeSupervisor.EmployeeID FROM EmployeeSupervisor WHERE EmployeeSupervisor.SupervisorID = {0})
                or SalesRepID in(SELECT EmployeeSupervisor.EmployeeID FROM EmployeeSupervisor WHERE EmployeeSupervisor.SupervisorID 
                IN ( Select DISTINCT SupervisorSalesMngr.SupervisorID EmployeeID from SupervisorSalesMngr where SalesManagerID={0}))",
                employeeId //0
                );

                GlobalErrors result = dBHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null)
                {
                    for (int i = 0; i < dt.Rows.Count; i++)
                    {
                        if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString()))
                        {
                            supervisedEmployeesString += dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString() + ",";
                        }
                    }
                    supervisedEmployeesString = supervisedEmployeesString.TrimEnd(",".ToCharArray());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null && !useSameHelper)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return supervisedEmployeesString;
        }
        public GlobalErrors GetEmployeeTypes(ref List<EmployeeTypeModel> employeeTypesList)
        {
            DBHelper<EmployeeTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                employeeTypesList = new List<EmployeeTypeModel>();
                dbHelper = new DBHelper<EmployeeTypeModel>();

                string employeeTypeFilter = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode())
                {
                    employeeTypeFilter = string.Format("And EmployeeTypeID not in ({0})", EmployeeTypes.SalesManager.GetHashCode());
                }
                else if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode())
                {
                    employeeTypeFilter = string.Format("And EmployeeTypeID not in ({0},{1})", EmployeeTypes.Supervisor.GetHashCode(), EmployeeTypes.SalesManager.GetHashCode());
                }
                string employeeTypesQuery = string.Format(@"Select EmployeeTypeLanguage.Description EmployeeTypeName, EmployeeTypeLanguage.EmployeeTypeID  
                from EmployeeTypeLanguage 
                where EmployeeTypeLanguage.LanguageID = {0} {1} 
                order by EmployeeTypeLanguage.EmployeeTypeID",
                _requestRepository.LanguageId, //0, 
                employeeTypeFilter //1
                );

                result = dbHelper.GetQueryList(employeeTypesQuery, ref employeeTypesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                employeeTypesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public static int GetMaxEmployeeID(DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "Select IsNull(max(EmployeeID),0) + 1 maxEmployee from Employee";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        public GlobalErrors SaveEmployee(EmployeeModel employee)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();

                result = SaveEmployeeProcess(employee, dbHelper);

                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors SaveEmployeeProcess(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string CountryeEmployeeFilter = string.Empty;
            object field = null;
            int CountryID = -1;
            try
            {
                string query = string.Empty;

                #region [Add New]


                if (!string.IsNullOrEmpty(employee.CustomerID_OutletID))
                {
                    employee.CustomerId = int.Parse(employee.CustomerID_OutletID.Split("_")[0]);
                    employee.OutletId = int.Parse(employee.CustomerID_OutletID.Split("_")[1]);
                }
                else
                {
                    employee.CustomerId = -1;
                    employee.OutletId = -1;
                }
                if (employee.RegionId != -1)
                {
                    CountryeEmployeeFilter = string.Format(@"select CountryID from State where StateID = {0}", employee.RegionId);
                    result = dbHelper.ExecuteScalar(CountryeEmployeeFilter, ref field);
                    if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                            CountryID = (int)field;
                    }
                }

                if (employee.IsNewEmployee && employee.EmployeeId < 0)
                {
                    int maxID = GetMaxEmployeeID(dbHelper);
                    if (maxID != -1)
                    {
                        employee.EmployeeId = maxID;
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        return result;
                    }


                    #region [Basic Data]
                    query = string.Format(@"INSERT INTO Employee(EmployeeID,EmployeeCode,Phone,Mobile,Email,NationalIDNumber,OrganizationID,EmployeeTypeID,Inactive,OnHold,HourlyRegularRate, HourlyOvertimeRate,
                                            MinHours, MaxOTHours, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate,Discount, Outsource, RegionID, ChannelID,CustomerId,OutletId,CountryID,EmployeeBranchID,ContactCountryId)
                                            VALUES({0},'{1}','{2}','{3}','{4}','{5}',{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{23},{24},{25},{26})",
                    employee.EmployeeId, //0
                    employee.EmployeeCode.Replace("'", "''"), //1
                    employee.Phone, //2
                    employee.Mobile, //3
                    employee.Email, //4
                    employee.NationalIDNumber.Replace("'", "''"), //5
                    employee.OrganizationId, //6
                    employee.EmployeeTypeId, //7
                    employee.Inactive ? "1" : "0", //8
                    employee.OnHold ? "1" : "0", //9
                    "NULL",//employee.HourlyRegularRate.Equals(0.0) ? "NULL" : employee.HourlyRegularRate.ToString(), //10
                    "NULL",//employee.HourlyOTRate.Equals(0.0) ? "NULL" : employee.HourlyOTRate.ToString(), //11
                    "NULL",//employee.MinHours.Equals(0.0) ? "NULL" : employee.MinHours.ToString(), //12
                    "NULL",//employee.MaxOTHours.Equals(0.0) ? "NULL" : employee.MaxOTHours.ToString(), //13
                    _requestRepository.CurrentOperator.EmployeeId, //14
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //15
                    _requestRepository.CurrentOperator.EmployeeId, //16
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //17
                    "NULL",//(employee.Discount == -1) ? "NULL" : employee.Discount.ToString(), //18
                    employee.OutSource ? "1" : "0", //19
                    employee.RegionId, //20
                    employee.ChannelId, //21
                    employee.CustomerId,//22
                    employee.OutletId, //23
                    CountryID, //24
                    employee.EmployeeBranchId, // 25
                    employee.ContactCountryId // 26
                   );
                    result = dbHelper.ExecuteNonQuery(query);
                    #endregion

                    #region[TeleRep Related Tables]
                    if (result == GlobalErrors.Success && employee.EmployeeTypeId == (int)EmployeeTypes.TeleRep) 
                    {
                        result = PrepareTablesForTeleRep(employee.EmployeeId, dbHelper);
                    }
                    #endregion
                }
                #endregion

                #region [Update Existing]
                else
                {
                    query = string.Format(@" UPDATE Employee SET EmployeeCode ='{0}',Phone ='{1}',Mobile = '{2}',Email = '{3}',NationalIDNumber = '{4}',OrganizationID = {5},EmployeeTypeID = {6},Inactive = {7},OnHold = {8},
                    HourlyRegularRate = {10},HourlyOvertimeRate = {11},MinHours = {12},MaxOTHours = {13},UpdatedBy = {14},UpdatedDate = {15}, Discount = {16}, Outsource = {17}, RegionID = {18}, ChannelID = {19}, CustomerId = {20},OutletId ={21},CountryID = {22}, EmployeeBranchID = {23} , ContactCountryId = {24} WHERE EmployeeID = {9}",
                    employee.EmployeeCode.Replace("'", "''"),
                    employee.Phone,
                    employee.Mobile,
                    employee.Email,
                    employee.NationalIDNumber.Replace("'", "''"),
                    employee.OrganizationId,
                    employee.EmployeeTypeId,
                    employee.Inactive ? "1" : "0",
                    employee.OnHold ? "1" : "0",
                    employee.EmployeeId,
                    "Null", //employeeObject.HourlyRegularRate.Equals(0.0) ? "0" : employeeObject.HourlyRegularRate.ToString(), 
                    "Null",//employeeObject.HourlyOTRate.Equals(0.0) ? "0" : employeeObject.HourlyOTRate.ToString(),
                    "Null",//(employeeObject.MinHours.Equals(0.0) ? "0" : employeeObject.MinHours.ToString()),
                    "Null",//employeeObject.MaxOTHours.Equals(0.0) ? "0" : employeeObject.MaxOTHours.ToString(), 
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    "Null",//(employeeObject.Discount == -1) ? "NULL" : employeeObject.Discount.ToString(),
                    employee.OutSource ? "1" : "0",
                    employee.RegionId,
                    employee.ChannelId,
                    employee.CustomerId,
                    employee.OutletId,
                    CountryID,
                    employee.EmployeeBranchId,
                    employee.ContactCountryId);
                    result = dbHelper.ExecuteNonQuery(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM EmployeeLanguage WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM EmployeeSupervisor WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM SupervisorSalesMngr WHERE SupervisorID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM SalesManagerDirector WHERE ManagerID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM employeeSalesRep WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (employee.EmployeeTypeId != EmployeeTypes.Supervisor.GetHashCode() && (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                    {
                        query = string.Format("DELETE FROM EmployeeSupervisor WHERE SupervisorID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (employee.EmployeeTypeId != EmployeeTypes.SalesManager.GetHashCode() && (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                    {
                        query = string.Format("DELETE FROM SupervisorSalesMngr WHERE SalesManagerID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (employee.EmployeeTypeId != EmployeeTypes.Director.GetHashCode() && (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                    {
                        query = string.Format("DELETE FROM SalesManagerDirector WHERE DirectorID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (employee.EmployeeTypeId != EmployeeTypes.SalesRepresentative.GetHashCode() && (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected))
                    {
                        query = string.Format("DELETE FROM employeeSalesRep WHERE SalesRepID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        string myDivivsionAccess = string.Empty;
                        if (employee.EmployeeAccess)
                        {
                            myDivivsionAccess = string.Format(" and DivisionID IN ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                        } 
                        else
                        {
                            myDivivsionAccess = string.Format(" and DivisionID IN ({0})", _requestRepository.CurrentOperator.OriginalDivisionAccess);
                        }
                        query = string.Format("DELETE FROM EmployeeDivision WHERE EmployeeID = {0} {1}",
                        employee.EmployeeId, myDivivsionAccess);

                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM DriverTruck WHERE DriverID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        if (employee.EmployeeTypeId == EmployeeTypes.Driver.GetHashCode())
                        {
                            query = string.Format("Delete From EmployeeVehicle Where EmployeeID = {0}",
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM EmployeeHelper WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM EmployeeDriver WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM EmployeeVirualWarehouse WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM VanInChargePreSales WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM WarehouseEmployees WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format("DELETE FROM WarehouseStoreKeeper WHERE EmployeeID = {0}",
                        employee.EmployeeId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.EmployeeTypeId == (int)EmployeeTypes.TeleRep)
                        {
                            // add if not exists.
                            result = PrepareTablesForTeleRep(employee.EmployeeId, dbHelper);
                        }
                        else 
                        {
                            // delete if exists.
                            result = DeleteTablesForTeleRep(employee.EmployeeId, dbHelper);
                            if (result == GlobalErrors.Success)
                                result = ClearTeleRepCustomers(employee.EmployeeId, dbHelper);
                        } 
                    }
                }
                #endregion

                #region[Shared methods between add new & Edit]

                if (result == GlobalErrors.Success)
                {
                    #region[Name]
                    if (employee.DescriptionLanguages != null)
                    {
                        foreach (var descriptionObject in employee.DescriptionLanguages)
                        {
                            if (descriptionObject.Description.Trim() != string.Empty)
                            {
                                query = string.Format(@"Insert Into EmployeeLanguage (EmployeeID,LanguageID,Description) Values ({0},{1},'{2}')",
                                employee.EmployeeId,
                                descriptionObject.LanguageId,
                                descriptionObject.Description.Replace("'", "''")
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                {
                                    return result;
                                }
                            }
                        }
                    }
                    #endregion

                    #region Audit Master Data
                    if (result == GlobalErrors.Success)
                    {
                        var auditMaster = new AuditMasterData();
                        auditMaster.ReferenceId = employee.EmployeeId;
                        auditMaster.ScreenID = MasterDataScreens.Employees.GetHashCode();
                        auditMaster.Status = employee.Inactive ? MasterDataStatus.Deactivate : MasterDataStatus.Activate;
                        auditMaster.ReasonId = employee.StatusReasonId;

                        DBHelper<AuditMasterData> dBHelperAudit = null;
                        dBHelperAudit = new DBHelper<AuditMasterData>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                        result = _masterDataManager.InsertAuditMasterReason(auditMaster, true, dBHelperAudit);
                    }
                    #endregion

                    #region[Account]
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.Account.CurrencyId != -1 && employee.Account.OrganizationId != -1) // account is defined correctly
                        {
                            if (employee.Account.AccountId == -1)
                            {
                                // insert new account
                                employee.Account.AccountId = _accountManager.GetMaxAccountID(dbHelper);
                                if (employee.Account.AccountId == -1)
                                {
                                    return GlobalErrors.Error;
                                }
                                result = _accountManager.CreateNewAccount(employee.Account, dbHelper);
                                if (result == GlobalErrors.Success)
                                {
                                    result = _accountManager.CreateEmployeeAccount(employee.Account.AccountId, employee.EmployeeId, dbHelper);
                                }
                            }
                            else
                            {
                                // update account
                                result = _accountManager.UpdateAccountWithoutUpdateBalance(employee.Account, dbHelper);
                            }
                            if (result == GlobalErrors.Success)
                            {
                                result = _accountManager.SaveAccountLanguage(employee.Account.AccountId, employee.EmployeeName, employee.DescriptionLanguages, dbHelper);
                            }
                        }
                    }
                    #endregion

                    #region[Organization Access]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveEmployeeOrganizationAccess(employee, dbHelper);
                    }
                    #endregion

                    #region [Operator]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveEmployeeOperator(employee, dbHelper);
                    }
                    #endregion

                    #region[Security Groups]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveOperatorSecurityGroup(employee, dbHelper);
                    }
                    #endregion

                    #region[Divisions]
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.Divisions != null && employee.Divisions.Count > 0)
                        {
                            result = SaveEmployeeDivisions(employee, dbHelper);
                        }
                    }
                    #endregion

                    #region[Items List]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveEmployeeItemsList(employee, dbHelper);
                    }
                    #endregion
                    #region [Accounts Division]
                    if (result == GlobalErrors.Success && employee.AccountsDivision != null && employee.AccountsDivision.Count > 0)
                    {
                        if (_requestRepository.Configurations.CheckCreditLimitOnEmployeeDivisionAccount && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                        {
                            result = SaveAccountsDivision(employee, employee.Account.AccountId, dbHelper);
                        }
                    }
                    #endregion

                    #region[DocumentSequence]
                    if (result == GlobalErrors.Success && (employee.EmployeeDocumentSequenceList != null && employee.EmployeeDocumentSequenceList.Count > 0))
                    {
                        result = SaveEmployeeDocumentSequenceInfo(employee, dbHelper);
                    }

                    #region[Document Sequence Customer]
                    if (result == GlobalErrors.Success && (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence))
                    {
                        result = SaveEmployeeDocumentSequenceCustomerInfo(employee, dbHelper);
                    }
                    #endregion
                    #region[Document Sequence Sales Channel]
                    if (result == GlobalErrors.Success && (_requestRepository.Configurations.EnableSalesDistributionChannel && _requestRepository.Configurations.ApplyDocumentSequencePerSalesChannel))
                    {
                        result = SaveEmployeeDocumentSequenceSalesChannelInfo(employee, dbHelper);
                    }
                    #endregion
                    #endregion

                    #region [Employee Territory]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveEmployeeTerritory(employee, dbHelper);
                    }
                    #endregion

                    #region[Employee Vehicle]
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.EmployeeTypeId == EmployeeTypes.Driver.GetHashCode())
                        {
                            if (employee.TruckId != -1)
                            {
                                query = string.Format("INSERT INTO DriverTruck (DriverID, TruckID) VALUES ({0},{1})",
                                employee.EmployeeId,
                                employee.TruckId);
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                        else
                        {
                            result = SaveEmployeeVehicle(employee, dbHelper);
                        }
                    }
                    #endregion

                    #region[Employee Device]
                    if (result == GlobalErrors.Success)
                    {
                        result = SaveEmployeeDevice(employee, dbHelper);
                    }
                    #endregion

                    #region[Related Employee]
                    if (result == GlobalErrors.Success)
                    {                       
                        if (employee.IsNewEmployee && employee.RelatedEmployeeId == -1 && _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode())
                        {
                            List<EmployeeModel> employeeModels = new List<EmployeeModel>();
                            result = GetRelatedEmployees(employee.EmployeeId, employee.OrganizationId, EmployeeTypes.Supervisor.GetHashCode(), ref employeeModels, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                            if (employeeModels != null && employeeModels.Count() > 0 && employeeModels.Where(emp => emp.EmployeeId == _requestRepository.CurrentOperator.EmployeeId).ToList().Count > 0)
                            {
                                employee.RelatedEmployeeTypeId = EmployeeTypes.Supervisor.GetHashCode();
                                employee.RelatedEmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                            }
                        }
                        else if (employee.IsNewEmployee && employee.RelatedEmployeeId == -1 && _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode())
                        {
                            List<EmployeeModel> employeeModels = new List<EmployeeModel>();
                            result = GetRelatedEmployees(employee.EmployeeId, employee.OrganizationId, EmployeeTypes.SalesManager.GetHashCode(), ref employeeModels, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                            if (employeeModels != null && employeeModels.Count() > 0 && employeeModels.Where(emp => emp.EmployeeId == _requestRepository.CurrentOperator.EmployeeId).ToList().Count > 0)
                            {
                                employee.RelatedEmployeeTypeId = EmployeeTypes.SalesManager.GetHashCode();
                                employee.RelatedEmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                            }
                        }

                        if (employee.RelatedEmployeeId != -1)
                        {
                            if (employee.RelatedEmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode())
                            {
                                query = string.Format("INSERT INTO EmployeeSupervisor (EmployeeID,SupervisorID) VALUES ({0},{1})",
                                employee.EmployeeId, //0
                                employee.RelatedEmployeeId //1
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                            else if (employee.RelatedEmployeeTypeId == EmployeeTypes.SalesRepresentative.GetHashCode())
                            {
                                query = string.Format("INSERT INTO EmployeeSalesRep (EmployeeID,SalesRepID) VALUES ({0},{1})",
                                employee.EmployeeId, //0
                                employee.RelatedEmployeeId //1
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                            else if (employee.RelatedEmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode())
                            {
                                query = string.Format("INSERT INTO SupervisorSalesMngr (SupervisorID,SalesManagerID) VALUES ({0},{1})",
                                employee.EmployeeId, //0
                                employee.RelatedEmployeeId //1
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                            else if(employee.RelatedEmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                            {
                                query = string.Format("INSERT INTO SalesManagerDirector (ManagerID,DirectorID) VALUES ({0},{1})",
                               employee.EmployeeId, //0
                               employee.RelatedEmployeeId //1
                               );
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                    }
                    #endregion

                    #region[Employee Helper]
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.HelperId != -1)
                        {
                            query = string.Format("INSERT INTO EmployeeHelper (EmployeeID,HelperID) VALUES ({0},{1})",
                            employee.EmployeeId, //0
                            employee.HelperId //1
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                    #endregion

                    #region[Employee Driver]
                    if (result == GlobalErrors.Success)
                    {
                        if (employee.DriverId != -1)
                        {
                            query = string.Format("INSERT INTO EmployeeDriver(EmployeeID,DriverID) VALUES ({0},{1})",
                            employee.EmployeeId, //0
                            employee.DriverId //1
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                    #endregion


                    #region[Update core session data after Save employee]
                    if (result == GlobalErrors.Success)
                    {
                        // Cashing employees under current employee supervision/managment
                        _requestRepository.CurrentOperator.SubordinatesEmployeesAsString = GetAllSuppervisedEmployees(_requestRepository.CurrentOperator.EmployeeId, dbHelper);

                        if (employee.EmployeeId == _requestRepository.CurrentOperator.EmployeeId)
                        {
                            _requestRepository.CurrentOperator.Email = employee.Email;
                            _requestRepository.CurrentOperator.EmployeeName = employee.EmployeeName;
                            _requestRepository.CurrentOperator.EmployeeCode = employee.EmployeeCode;

                            _requestRepository.CurrentOperator.SupervisorId = employee.RelatedEmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() ? employee.RelatedEmployeeId : -1;

                            _requestRepository.CurrentOperator.SalesRepId = employee.RelatedEmployeeTypeId == EmployeeTypes.SalesRepresentative.GetHashCode() ? employee.RelatedEmployeeId : -1;

                            _requestRepository.CurrentOperator.SalesManagerId = employee.RelatedEmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode() ? employee.RelatedEmployeeId : -1;

                            _requestRepository.CurrentOperator.HelperId = employee.HelperId;
                            _requestRepository.CurrentOperator.DriverId = employee.DriverId;


                            _requestRepository.CurrentOperator.OrganizationId = employee.OrganizationId;

                            if(!_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                            {
                              _requestRepository.CurrentOperator.OrganizationAccess = GetEmployeeOrganizationAccess(employee.EmployeeId, dbHelper);
                            }

                            string divisions = string.Empty;
                            foreach (DivisionModel division in employee.Divisions)
                            {
                                divisions += division.DivisionId + ',';
                            }
                            if (!string.IsNullOrEmpty(divisions))
                            {
                                divisions = divisions.TrimEnd(',');
                            }
                            _requestRepository.CurrentOperator.DivisionAccess = divisions;
                        }
                    }

                    #endregion
                }

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeOperator(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            int isFrontOfficeint = 0;
            string updatePasswordFilter = string.Empty;
            bool saveChangeHistory = false;
            if (employee.IsFrontOfficUser)
            {
                isFrontOfficeint = 1;
            }
            else
            {
                isFrontOfficeint = 0;
            }
            object maxOperatorID = new object();
            object savedOperatorID = new object();
            try
            {
                query = string.Format(@"select OperatorID  from EmployeeOperator where employeeID = {0}", employee.EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref savedOperatorID);

                if (employee.OperatorPassword != null && !string.IsNullOrEmpty(employee.OperatorPassword.TrimEnd()))
                {
                    employee.OperatorPassword = EncryptionManager.Instance.EncryptPassword(employee.OperatorPassword);
                }
                if (result == GlobalErrors.Success)
                {
                    if (savedOperatorID == null)
                    {
                        query = string.Format(@"select max(OperatorID + 1) as OperatorID from Operator");
                        result = dbHelper.ExecuteScalar(query, ref maxOperatorID);
                        if (result == GlobalErrors.Success && maxOperatorID != null && !string.IsNullOrEmpty(maxOperatorID.ToString()))
                        {
                            if (!string.IsNullOrEmpty(employee.OperatorName) && (!string.IsNullOrEmpty(employee.OperatorPassword) || employee.IsActiveDirectoryLogin))
                            {
                                query = string.Format(@"INSERT INTO Operator
                                                                    (OperatorID, OperatorName, OperatorPassword,
                                                                     FrontOffice, LoginTypeID, PasswordChangeDate,
                                                                     IsLocked, ActiveDirectoryLogin, CreatedBy, 
                                                                     CreatedDate, UpdatedBy, UpdatedDate)
                                                               VALUES ({0}, '{1}','{2}',{3}, 1,null,null, {4},{5},{6},{5},{6})",
                                Int32.Parse(maxOperatorID.ToString()),
                                employee.OperatorName,
                                employee.OperatorPassword,
                                isFrontOfficeint,
                                employee.IsActiveDirectoryLogin ? 1 : 0,
                                _requestRepository.CurrentOperator.EmployeeId,
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));

                                result = dbHelper.ExecuteNonQuery(query);

                                if (result == GlobalErrors.Success)
                                {
                                    query = string.Format(@" insert into EmployeeOperator values ({0},{1},{2},{3},{2},{3})",
                                    employee.EmployeeId,
                                    int.Parse(maxOperatorID.ToString()),
                                    _requestRepository.CurrentOperator.EmployeeId,
                                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));

                                    result = dbHelper.ExecuteNonQuery(query);
                                }
                            }
                        }
                    }
                    else
                    {
                        if (string.IsNullOrEmpty(employee.OperatorName) && string.IsNullOrEmpty(employee.OperatorPassword))
                        {
                            query = string.Format(@" Delete From EmployeeOperator where EmployeeID = {0}", employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result == GlobalErrors.Success)
                            {
                                query = string.Format(@" delete from OperatorSecurityGroup where operatorID = '{0}'", savedOperatorID);
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    result = GlobalErrors.Success;
                                }
                            }

                            if (result == GlobalErrors.Success)
                            {
                                query = string.Format(@" Delete From Operator where operatorID = {0}", int.Parse(savedOperatorID.ToString()));
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                        else if (!string.IsNullOrEmpty(employee.OperatorName) && (!string.IsNullOrEmpty(employee.OperatorPassword) || employee.IsActiveDirectoryLogin))
                        {
                            if (employee.AllowToChangePassword && employee.OperatorPassword != EncryptionManager.Instance.EncryptPassword(employee.OldPassword))
                            {
                                saveChangeHistory = true;
                                updatePasswordFilter = string.Format(", operatorPassword = '{0}', PasswordChangeDate = {1}", employee.OperatorPassword, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                            }
                            query = string.Format(@" update Operator set operatorName = '{0}', frontOffice = {1}, UpdatedBy = {3},UpdatedDate = {4}, ActiveDirectoryLogin = {5}  {6} where operatorID = {2}",
                            employee.OperatorName, //0
                            isFrontOfficeint,//1
                            int.Parse(savedOperatorID.ToString()),//2
                            _requestRepository.CurrentOperator.EmployeeId,//3
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//4
                            employee.IsActiveDirectoryLogin ? 1 : 0,//5
                            updatePasswordFilter);//6
                            result = dbHelper.ExecuteNonQuery(query);

                            if (result == GlobalErrors.Success && saveChangeHistory)
                                result = RecordPasswordChangeHistory(int.Parse(savedOperatorID.ToString()), dbHelper);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors RecordPasswordChangeHistory(int operatorID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            Object count = 0;
            try
            {
                var query = string.Format(@"UPDATE Operator SET PasswordChangeDate = {0} WHERE OperatorID= {1}", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), operatorID);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"INSERT INTO OperatorPasswordChangeHistory (operatorID,OperatorName,OperatorPassword,PasswordChangeDate,ChangedBy, MachineName)
                        SELECT {0},OperatorName ,OperatorPassword ,{1} ,{3},'{2}' FROM Operator WHERE Operator.operatorID = {0}",
                       operatorID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), Environment.MachineName, _requestRepository.CurrentOperator.EmployeeId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors SaveOperatorSecurityGroup(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            object savedOperatorID = new object();
            object count = 0;
            string query = string.Empty;
            try
            {
                query = string.Format(@"select operatorID from EmployeeOperator where employeeID = {0}",
                employee.EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref savedOperatorID);

                if (result == GlobalErrors.Success && savedOperatorID != null)
                {
                    query = string.Format(@"select count(*) from OperatorSecurityGroup where OperatorID = {0}",
                    savedOperatorID);
                    result = dbHelper.ExecuteScalar(query, ref count);

                    if (result == GlobalErrors.Success)
                    {
                        
                        if (count != null && Int32.Parse(count.ToString()) > 0)
                        {
                            string administionGroup = string.Empty;
                            if (employee.EmployeeId == 0 && !employee.SecurityGroups.Any(x => x.SecurityGroupId == 1))
                            {
                                administionGroup = " And SecurityGroupId != 1 ";
                            }
                            query = string.Format(@" delete from OperatorSecurityGroup where operatorID = '{0}' {1}", savedOperatorID, administionGroup);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if(result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                result = GlobalErrors.Success;
                            }
                        }
                        if (result == GlobalErrors.Success)
                        {
                            foreach (SecurityGroupModel securityGroup in employee.SecurityGroups)
                            {
                                query = string.Format(@" insert into OperatorSecurityGroup values ({0}, {1})",
                                int.Parse(savedOperatorID.ToString()),
                                securityGroup.SecurityGroupId
                                );
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                {
                                    return GlobalErrors.Error;
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeDivisions(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;

                foreach (DivisionModel division in employee.Divisions)
                {
                    query = string.Format("INSERT INTO EmployeeDivision (EmployeeID, DivisionID,IsDefault) VALUES ({0},{1},{2})",
                   employee.EmployeeId, //0
                   division.DivisionId, //1
                   employee.DefaultDivisionId == division.DivisionId ? "1" : "0" //2
                   );
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeDocumentSequenceInfo(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var isDivision = (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence);
                object field = null;
                foreach (EmployeeDocumentSequence employeeDocumentOnDivisionLevel in employee.EmployeeDocumentSequenceList)
                {
                    field = null;
                    string query = string.Format("SELECT COUNT(*) FROM DocumentSequence WHERE EmployeeID = {0} AND DivisionID = {1}", employee.EmployeeId, employeeDocumentOnDivisionLevel.DivisionId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success)
                    {
                        employeeDocumentOnDivisionLevel.EmployeeId = employee.EmployeeId;
                        if (field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()) && Convert.ToInt32(field) == 1)
                        {
                            //update
                            query = string.Format(" UPDATE DocumentSequence SET MaxTransactionInvoiceID = '{0}',MaxTransactionReturnID = '{1}',MaxTransactionOrderID = '{2}',MaxWarehouseTransactionID = '{3}',MaxTransactionCreditNote = '{4}', MaxTransactionDebitNote = '{5}',MaxTransactionPaymentID = '{6}',MaxTransactionSampleID ='{7}',MaxNewCustomerCodeID='{8}',MaxAppliedPaymentID = '{9}',MaxTransactionReplenishID ='{10}',MaxTransactionRemoveID ='{11}' ,MaxSettelmentID='{12}',MaxOrderInvoiceID='{13}',MaxReturnOrderID='{14}',MaxContractedFOCID='{15}',MaxUnlimitedFOCID='{16}',MaxFixedIncentiveID='{17}',MaxVariableIncentiveID='{18}' ,MaxOrgCreditNote='{19}' ,MaxOrgDebitNote='{20}',MaxPurchaseOrderID='{21}', MaxPrisonExpensesID ='{22}', MaxGuaranteesExpensesID='{23}', MaxGiftVoucherID='{24}',UpdatedBy = {25}, UpdatedDate = {26}, MaxICashTopUpTransactionID = '{29}',MaxICashReversalTransactionID = '{30}',MaxDeliveryNoteTransactionID='{31}',MaxPromotionTransactionID = '{32}',MaxCustomerCode = '{33}' ,MaxCreditNoteRequestTransactionID = '{34}' WHERE (EmployeeID = {27} AND DivisionID = {28})",
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Invoice.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Return.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Order.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.WarhouseTransaction.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.CreditNote.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.DebitNote.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Collection.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Sample.GetHashCode()).Value,
                            isDivision ? " " : employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.NewCustomerCode.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.AppliedPayment.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Replenish.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Remove.GetHashCode()).Value,
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Settelment.GetHashCode()).Value, //12

                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.OrderInvoice.GetHashCode()).Value, //13
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.ReturnOrder.GetHashCode()).Value, //14
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.ContractedFOC.GetHashCode()).Value, //15
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.UnlimitedFOC.GetHashCode()).Value, //16
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.FixedIncentive.GetHashCode()).Value, //17
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.VariableIncentive.GetHashCode()).Value, //18
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.OrgCreditNote.GetHashCode()).Value, //19
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.OrgDebitNote.GetHashCode()).Value, //20
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.PurchaseOrder.GetHashCode()).Value, //21
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.PrisonExpenses.GetHashCode()).Value, //22
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.GuaranteesExpenses.GetHashCode()).Value, //23
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.GiftVoucher.GetHashCode()).Value, //24

                            _requestRepository.CurrentOperator.EmployeeId, //25
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //26
                            employeeDocumentOnDivisionLevel.EmployeeId, //27
                            employeeDocumentOnDivisionLevel.DivisionId, //28
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.ICashTransaction.GetHashCode()).Value,//29
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.ICashReversal.GetHashCode()).Value,//30
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.DeliveryNote.GetHashCode()).Value,//31
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Promotion.GetHashCode()).Value,//32
                            isDivision ? " " : employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.CustomerCode.GetHashCode()).Value,//33
                            employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.CreditNoteRequest.GetHashCode()).Value//34

                            );

                            result = dbHelper.ExecuteNonQuery(query);

                        }
                        else
                        {
                            if (employeeDocumentOnDivisionLevel.DocumentSequenceList.Any(x => x.Value.Trim() != string.Empty))
                            {
                                // insert new
                                query = string.Format(@"INSERT INTO DocumentSequence (EmployeeID ,MaxTransactionInvoiceID,MaxTransactionReturnID,MaxTransactionOrderID,MaxWarehouseTransactionID,MaxTransactionCreditNote,MaxTransactionDebitNote,MaxTransactionPaymentID,MaxTransactionSampleID,MaxNewCustomerCodeID,MaxAppliedPaymentID,MaxTransactionReplenishID,MaxTransactionRemoveID,
                                DivisionID,MaxSettelmentID ,MaxOrderInvoiceID ,MaxReturnOrderID ,MaxContractedFOCID,MaxUnlimitedFOCID ,MaxFixedIncentiveID ,MaxVariableIncentiveID ,MaxOrgCreditNote ,MaxOrgDebitNote ,MaxPurchaseOrderID ,MaxPrisonExpensesID ,MaxGuaranteesExpensesID, MaxGiftVoucherID, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate, MaxICashTopUpTransactionID, MaxICashReversalTransactionID,MaxDeliveryNoteTransactionID,MaxPromotionTransactionID ,MaxCustomerCode, MaxCreditNoteRequestTransactionID)
		                        VALUES ({13},'{0}','{1}','{2}','{3}','{4}', '{5}','{6}','{7}','{8}','{9}','{10}','{11}', {14} ,'{12}','{15}','{16}','{17}','{18}','{19}','{20}','{21}','{22}','{23}','{24}','{25}','{26}', {27}, {28}, {27}, {28}, '{29}','{30}','{31}','{32}','{33}' ,'{34}')",

                                employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Invoice.GetHashCode()).Value,
                                string.Empty,
                                employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Order.GetHashCode()).Value,
                                string.Empty,
                           string.Empty,
                           string.Empty,
                              string.Empty,
                        string.Empty,
                                isDivision ? " " : employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.NewCustomerCode.GetHashCode()).Value,
                             string.Empty,
                              string.Empty,
                            string.Empty,
                        string.Empty,

                                employeeDocumentOnDivisionLevel.EmployeeId,
                                employeeDocumentOnDivisionLevel.DivisionId,

                                employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.OrderInvoice.GetHashCode()).Value,
                            string.Empty,
                            string.Empty,
                          string.Empty,
                             string.Empty,
                              string.Empty,
                             string.Empty,
                              string.Empty,
                            string.Empty,
                           string.Empty,
                              string.Empty,
                          string.Empty,
                                _requestRepository.CurrentOperator.EmployeeId,
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                           string.Empty,//29
                             string.Empty,//30
                                employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.DeliveryNote.GetHashCode()).Value,//31
                                employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.Promotion.GetHashCode()).Value,//32
                                isDivision ? " " : employeeDocumentOnDivisionLevel.DocumentSequenceList.Find(x => x.Key == DocumentTypes.CustomerCode.GetHashCode()).Value,//33
                            string.Empty//34

                                );

                                result = dbHelper.ExecuteNonQuery(query);
                            }
                            else
                            {
                                // No row inserted, all values are empty
                                result = GlobalErrors.Success;
                            }
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors SaveEmployeeDocumentSequenceCustomerInfo(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlQuery = string.Empty;

                sqlQuery = $"Delete from DocumentSequence where EmployeeID = {employee.EmployeeId} and DivisionID = '-1'";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery); result = result == GlobalErrors.SuccessWithZeroRowAffected ? GlobalErrors.Success : result;

                if (result == GlobalErrors.Success)
                {
                    if (!string.IsNullOrEmpty(employee.NewCustomerCode) || !string.IsNullOrEmpty(employee.MaxCustomerCode))
                    {
                        sqlQuery = $"INSERT INTO DocumentSequence (EmployeeID,DivisionID,MaxNewCustomerCodeID,MaxCustomerCode)values({employee.EmployeeId},{"-1"},{"'" + employee.NewCustomerCode + "'"},{"'" + employee.MaxCustomerCode + "'"})";
                        result = dbHelper.ExecuteNonQuery(sqlQuery);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors SaveEmployeeDocumentSequenceSalesChannelInfo(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlQuery = string.Empty;
                sqlQuery = $"Delete scdc from SalesChannelDocumentSequence scdc inner join SDCOrganization on SDCOrganization.SDCID = scdc.SalesChannelID and SDCOrganization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) where EmployeeID = {employee.EmployeeId} and DivisionID = '-1'";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery); 
                result = result == GlobalErrors.SuccessWithZeroRowAffected ? GlobalErrors.Success : result;
                if(result == GlobalErrors.Success) {
                    if (employee.SalesChannelDocumentSequenceList != null && employee.SalesChannelDocumentSequenceList.Count > 0)
                    {
                        if (result == GlobalErrors.Success)
                        {
                            foreach (SalesDistributionChannelModel salesChannelEmployee in employee.SalesChannelDocumentSequenceList)
                            {
                                sqlQuery = $"INSERT INTO SalesChannelDocumentSequence (SalesChannelID,EmployeeID,DivisionID,MaxTransactionInvoiceID)values({salesChannelEmployee.SDCId},{employee.EmployeeId},{"-1"},{"'" + salesChannelEmployee.MaxInvoiceId + "'"})";
                                result = dbHelper.ExecuteNonQuery(sqlQuery);
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors SaveEmployeeVehicle(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            object count = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format(@"Select Count(*) From EmployeeVehicle
                WHERE EmployeeID = {0} ", employee.EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref count);

                if (result == GlobalErrors.Success)
                {
                    if (count == null || string.IsNullOrEmpty(count.ToString()) || int.Parse(count.ToString()) == 0)
                    {
                        if (employee.VehicleId != -1)
                        {
                            query = string.Format(@" INSERT INTO EmployeeVehicle (VehicleID, EmployeeID, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate) VALUES ({0},{1},{2},{3},{2},{3})",
                            employee.VehicleId,
                            employee.EmployeeId,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                    else if (count != null && !string.IsNullOrEmpty(count.ToString()) && Int32.Parse(count.ToString()) > 0)
                    {
                        if (employee.VehicleId != -1)
                        {
                            query = string.Format(@" Update EmployeeVehicle set VehicleID = {0}, UpdatedBy = {1}, UpdatedDate = {2} Where EmployeeID = {3} ",
                            employee.VehicleId,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                        else
                        {
                            query = string.Format(@" Delete from EmployeeVehicle Where EmployeeID = {0} ",
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeDevice(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            object count = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format(@"Select Count(*) From EmployeeDevice
                WHERE EmployeeID = {0} ", employee.EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref count);

                if (result == GlobalErrors.Success)
                {
                    if (count == null || string.IsNullOrEmpty(count.ToString()) || int.Parse(count.ToString()) == 0)
                    {
                        if (!string.IsNullOrEmpty(employee.DeviceSerial))
                        {
                            query = string.Format(@" INSERT INTO EmployeeDevice (EmployeeID, DeviceSerial, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate) VALUES ({0},'{1}',{2},{3},{2},{3})",
                            employee.EmployeeId,
                            employee.DeviceSerial,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                    else if (count != null && !string.IsNullOrEmpty(count.ToString()) && Int32.Parse(count.ToString()) > 0)
                    {
                        if (!string.IsNullOrEmpty(employee.DeviceSerial))
                        {
                            query = string.Format(@" Update EmployeeDevice set DeviceSerial = '{0}', UpdatedBy = {1}, UpdatedDate = {2} Where EmployeeID = {3} ",
                            employee.DeviceSerial,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                        else
                        {
                            query = string.Format(@" Delete from EmployeeDevice Where EmployeeID = {0} ",
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveAccountsDivision(EmployeeModel employee, int parentAccountId, DBHelper<int> dBHelper)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;
            string insertQuery = string.Empty;
            string updateQuery = string.Empty;
            string deleteQuery = string.Empty;
            try
            {
                foreach (var item in employee.AccountsDivision)
                {

                    if (item.AccountId != -1 && item.DataAction == DataActions.Edit)
                    {
                        updateQuery = string.Format(@"update Account set CreditLimit = {0}  ,OrganizationId = {1}
                                                      where AccountID = {2}", item.CreditLimit, employee.OrganizationId, item.AccountId);
                        result = dBHelper.ExecuteNonQuery(updateQuery);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                    else if (item.DataAction == DataActions.Add)
                    {
                        item.AccountId = _accountManager.GetMaxAccountID(dBHelper);
                        item.ParentAccountId = parentAccountId;
                        result = _accountManager.CreateNewAccount(item, dBHelper);
                        if (result != GlobalErrors.Success)
                            break;
                        insertQuery = string.Format(@"insert into AccountEmpDiv(AccountID,DivisionID,EmployeeID,ParentAccountID)
                                            values({0},{1},{2},{3})", item.AccountId, item.DivisionId, employee.EmployeeId,
                                                parentAccountId);
                        result = dBHelper.ExecuteNonQuery(insertQuery);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                    else if (item.DataAction == DataActions.Delete)
                    {
                        deleteQuery = string.Format(@"delete from AccountEmpDiv where AccountID = {0}", item.AccountId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);

                        if (result != GlobalErrors.Success || result != GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            deleteQuery = string.Format(@"delete from Account where AccountID = {0}", item.AccountId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                        }
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveEmployeeTerritory(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            object count = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format(@"Select Count(*) From EmployeeTerritory
                WHERE EmployeeID = {0} ", employee.EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref count);

                if (result == GlobalErrors.Success)
                {
                    if (count == null || string.IsNullOrEmpty(count.ToString()) || int.Parse(count.ToString()) == 0)
                    {
                        if (employee.TerritoryId != -1)
                        {
                            query = string.Format(@" INSERT INTO EmployeeTerritory (EmployeeID, TerritoryID, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate) VALUES ({0},{1},{2},{3},{2},{3})",
                            employee.EmployeeId,
                            employee.TerritoryId,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                    else if (count != null && !string.IsNullOrEmpty(count.ToString()) && Int32.Parse(count.ToString()) > 0)
                    {
                        if (employee.TerritoryId != -1)
                        {
                            query = string.Format(@" Update EmployeeTerritory set TerritoryID = {0}, UpdatedBy = {1}, UpdatedDate = {2} Where EmployeeID = {3} ",
                            employee.TerritoryId,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                        else
                        {
                            query = string.Format(@" Delete from EmployeeTerritory Where EmployeeID = {0} ",
                            employee.EmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeOrganizationAccess(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format("Delete From EmployeeOrganization Where EmployeeId = {0} And OrganizationId in ({1})",
                employee.EmployeeId, //0
                _requestRepository.Configurations.ForceOrganizationSelectionOnLogin ? _requestRepository.CurrentOperator.OriginalOrganizationAccess : _requestRepository.CurrentOperator.OrganizationAccess//1
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    if (employee.OrganizationsAccessList != null && employee.OrganizationsAccessList.Count > 0)
                    {
                        foreach (OrganizationModel organization in employee.OrganizationsAccessList)
                        {
                            query = string.Format(@" INSERT INTO EmployeeOrganization VALUES ({0},{1},{2},{3},{2},{3})",
                            employee.EmployeeId, //0
                            organization.OrganizationId, //1
                            _requestRepository.CurrentOperator.EmployeeId, //2
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //3
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveEmployeeItemsList(EmployeeModel employee, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format("Delete From ItemListEmployee Where EmployeeId = {0}",
                employee.EmployeeId //0
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    if (employee.ItemsList != null && employee.ItemsList.Count > 0)
                    {
                        foreach (ItemListModel itemList in employee.ItemsList)
                        {
                            int itemListAssignmentID = GetMaxID("ItemListEmployeeID", "ItemListEmployee", dbHelper);
                            query = string.Format(@" INSERT INTO ItemListEmployee VALUES ({0},{1},{2})",
                            itemListAssignmentID, //0
                            employee.EmployeeId, //1
                            itemList.ItemListId //2
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeesList(EmployeeFilter employeeFilter, ref SharedTableResult<EmployeeModel> sharedEmployeesList)
        {
            sharedEmployeesList = new SharedTableResult<EmployeeModel>();
            List<EmployeeModel> employees = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string excludeAdminFilter = string.Empty;
                if (employeeFilter != null)
                {
                    if (!employeeFilter.IncludeInactive)
                    {
                        searchFilter = " and (Employee.Inactive = 0 OR Employee.Inactive is null)";
                    }
                    if (!string.IsNullOrEmpty(employeeFilter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@"and ((Employee.EmployeeCode LIKE '%{0}%') OR (EmployeeLanguage.Description LIKE '%{0}%' ))",
                        employeeFilter.CustomListFilter.SearchFilter.Replace("'", "''").Trim());
                    }
                    if (employeeFilter.EmployeeTypeId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeTypeID = {0})", employeeFilter.EmployeeTypeId);
                    }
                    if (employeeFilter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.OrganizationID= {0}) ", employeeFilter.OrganizationId);
                    }
                    if (employeeFilter.EmployeeBranchId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeBranchID= {0}) ", employeeFilter.EmployeeBranchId);
                    }
                    if (employeeFilter.VehicleId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeID in (Select EmployeeID from EmployeeVehicle Where EmployeeVehicle.VehicleID= {0})) ", employeeFilter.VehicleId);
                    }
                    if (!string.IsNullOrEmpty(employeeFilter.DeviceSerial))
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeID in (Select EmployeeID from EmployeeDevice Where EmployeeDevice.DeviceSerial = '{0}' )) ", employeeFilter.DeviceSerial);
                    }
                    if (employeeFilter.DivisionId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeID in (Select EmployeeID from EmployeeDivision Where EmployeeDivision.DivisionID= {0})) ", employeeFilter.DivisionId);
                    }
                    if (employeeFilter.SecurityGroupId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeID in (Select EmployeeOperator.EmployeeID from EmployeeOperator Inner join OperatorSecurityGroup ON EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID Where OperatorSecurityGroup.SecurityGroupID = {0} )) ", employeeFilter.SecurityGroupId);
                    }
                    if(employeeFilter.TerritoryId != -1)
                    {
                        searchFilter += string.Format(" And (Employee.EmployeeID in (Select EmployeeID from EmployeeTerritory Where EmployeeTerritory.TerritoryID = {0} )) ", employeeFilter.TerritoryId);
                    }
                    if (employeeFilter.EmployeeId > 0)
                    {
                        searchFilter += string.Format(" AND Employee.EmployeeID = {0} ", employeeFilter.EmployeeId);
                    }
                    if (string.IsNullOrEmpty(employeeFilter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By EmployeeLanguage.Description");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        employeeFilter.CustomListFilter.SortBy,
                        employeeFilter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (_requestRepository.CurrentOperator.EmployeeId != 0)
                    {
                        excludeAdminFilter = "AND Employee.EmployeeID <> 0";
                    }
                }

                string mainQuery = string.Format(@" From Employee
                left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {0}
                Left outer join EmployeeTypeLanguage on EmployeeTypeLanguage.employeeTypeID = Employee.EmployeeTypeID And EmployeeTypeLanguage.LanguageID = {0}
                Inner join Organization On Organization.OrganizationID = Employee.OrganizationID
                Left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID And OrganizationLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeBranchLanguage ON EmployeeBranchLanguage.EmployeeBranchID = Employee.EmployeeBranchID And EmployeeBranchLanguage.LanguageID = {0}
                where Employee.OrganizationID in ({1}) AND Employee.EmployeeID {2} {3}",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess,
                 GetSupervisorAccess(),
                excludeAdminFilter);

                string employeesQuery = string.Format(@"Select ROW_NUMBER() Over(Order By EmployeeLanguage.Description ) AS RowSeq,
                Employee.EmployeeID,
                IsNull( Employee.EmployeeCode , '--') As EmployeeCode,
                IsNull( EmployeeLanguage.Description , '--') as EmployeeName,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
                EmployeeTypeLanguage.Description EmployeeType,
                Case When Employee.Inactive = 1 and Employee.OnHold = 1 then '{5}' + ' , ' + '{6}'
				When Employee.Inactive = 1 then '{5}' 
                When Employee.OnHold = 1 then '{6}'
                else  '---' end as Status,
                Employee.Inactive,
                Employee.OnHold,
                IsNull( EmployeeTypeLanguage.Description , '--') as EmployeeTypeName,
                Employee.Phone,
                Employee.Mobile,
                Employee.Email,
                IsNull( EmployeeBranchLanguage.Description , '--') as EmployeeBranchName,
                IsNull( Organization.OrganizationCode , '--')as OrganizationCode,
                IsNull( OrganizationLanguage.Description , '--') as OrganizationName,
                IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                {0} {1} {2} 
                OFFSET  {3} ROWS       
                FETCH NEXT {4} ROWS ONLY",
                mainQuery,
                searchFilter,
                orderByFilter,
                (employeeFilter.CustomListFilter.Page) * employeeFilter.CustomListFilter.PageSize,
                employeeFilter.CustomListFilter.PageSize,
                ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive, _requestRepository.LanguageId),
                ResourcesManager.TranslateKey(MessagesConstants.Desc_OnHold, _requestRepository.LanguageId)
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) {0} {1}",
                mainQuery,
                searchFilter);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    sharedEmployeesList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (sharedEmployeesList.TotalItems <= 0)
                    {
                        sharedEmployeesList.Data = employees;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(employeesQuery, ref employees , true);
                sharedEmployeesList.Data = employees;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                sharedEmployeesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateEmployeeActiveStatus(int employeeId, bool isActive, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                string query = string.Format(" Update Employee set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where employeeID = {3}",
                isActive ? 0 : 1, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                employeeId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            //finally
            //{
            //    if (dbHelper != null)
            //    {
            //        dbHelper.Dispose();
            //        dbHelper = null;
            //    }
            //}
            return result;
        }
        public GlobalErrors GetEmployeeData(int employeeId, ref EmployeeModel selectedEmployee)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            try
            {
                #region[basic Data]
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;

                query = string.Format(@" SELECT DISTINCT Employee.EmployeeID, Employee.EmployeeTypeID, EmployeeLanguage.Description EmployeeName,
                Employee.EmployeeCode, Employee.OrganizationID, Employee.Phone, Employee.Mobile, Employee.Email,
                EmployeeTypeLanguage.Description EmployeeTypeName, Employee.NationalIDNumber,
                Employee.Inactive,Employee.Inactive OldInactiveStatus, Employee.OnHold, Employee.Outsource,
                EmployeeVehicle.VehicleID, EmployeeDevice.DeviceSerial, EmployeeHelper.HelperID, EmployeeDriver.DriverID, EmployeeTerritory.TerritoryID, DriverTruck.TruckID,Employee.CustomerID,
                CONVERT(nvarchar,(ISNULL(Employee.CustomerID,'')))+'_'+CONVERT(nvarchar,isnull(Employee.OutletID,'')) CustomerID_OutletID,
                
                Case When EmployeeSupervisor.SupervisorID is not null then EmployeeSupervisor.SupervisorID
                When EmployeeSalesRep.SalesRepID is not null then EmployeeSalesRep.SalesRepID
                When SupervisorSalesMngr.SalesManagerID is not null then SupervisorSalesMngr.SalesManagerID
                When SalesManagerDirector.DirectorID is not null then SalesManagerDirector.DirectorID
                ELSE -1 End As RelatedEmployeeId,

                Case When EmployeeSupervisor.SupervisorID is not null then 4
                When EmployeeSalesRep.SalesRepID is not null then 13
                When SupervisorSalesMngr.SalesManagerID is not null then 9
				When SalesManagerDirector.DirectorID is not null then 20
                ELSE -1 End As RelatedEmployeeTypeId,

                IsNull(EmployeeOperator.OperatorID, -1)OperatorID, Operator.OperatorPassword, Operator.OperatorName, Operator.ActiveDirectoryLogin isActiveDirectoryLogin, Operator.FrontOffice isFrontOfficUser
                , ChannelId, RegionId , EmployeeBranchID , ContactCountryId           
                FROM Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID AND EmployeeTypeLanguage.LanguageID = {0}
                LEFT OUTER JOIN EmployeeVehicle ON EmployeeVehicle.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeDevice ON EmployeeDevice.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeDriver ON EmployeeDriver.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeHelper ON EmployeeHelper.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeTerritory ON EmployeeTerritory.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN DriverTruck On DriverTruck.DriverID = Employee.EmployeeID
                LEFT OUTER JOIN EmployeeSupervisor ON  Employee.EmployeeID = EmployeeSupervisor.EmployeeID
                LEFT OUTER JOIN employeeSalesRep on employeeSalesRep.EmployeeID= Employee.EmployeeID   
                LEFT OUTER JOIN SupervisorSalesMngr ON Employee.EmployeeID=SupervisorSalesMngr.SupervisorID Or SupervisorSalesMngr.SupervisorID in (Select SupervisorID from EmployeeSupervisor where EmployeeID={1})
                LEFT OUTER JOIN SalesManagerDirector ON Employee.EmployeeID=SalesManagerDirector.ManagerID
                LEFT OUTER JOIN EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN Operator on Operator.OperatorID = EmployeeOperator.OperatorID
                WHERE Employee.EmployeeID = {1}",
                _requestRepository.LanguageId, //0
                employeeId, //1
                MasterDataScreens.Employees.GetHashCode() //2
                );
                result = dbHelper.GetQuerySingle(query, ref selectedEmployee);

                #endregion
                if (result == GlobalErrors.Success && selectedEmployee != null && selectedEmployee.EmployeeId != -1)
                {
                    if (!string.IsNullOrEmpty(selectedEmployee.OperatorPassword))
                    {
                        selectedEmployee.OperatorPassword = EncryptionManager.Instance.DecryptPassword(selectedEmployee.OperatorPassword.TrimEnd());
                    }

                    #region[Descriptions]
                    DBHelper<TextLanguage> descriptionsDBHelper = new DBHelper<TextLanguage>();
                    List<TextLanguage> descriptions = new List<TextLanguage>();
                    query = string.Format(@"Select * from EmployeeLanguage where EmployeeID = {0}", employeeId);
                    result = descriptionsDBHelper.GetQueryList(query, ref descriptions);
                    if (descriptionsDBHelper != null)
                    {
                        descriptionsDBHelper.Dispose();
                        descriptionsDBHelper = null;
                    }
                    selectedEmployee.DescriptionLanguages = descriptions;
                    #endregion

                    #region[Divisions]
                    DBHelper<DivisionModel> DBHelperForDivisions = new DBHelper<DivisionModel>();
                    List<DivisionModel> divisions = new List<DivisionModel>();
                    string divisionAccess = string.Empty;
                    if (selectedEmployee.EmployeeId != _requestRepository.CurrentOperator.EmployeeId)
                    {
                        divisionAccess = string.Format(" and Division.DivisionID in ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                    }
                    else
                    {
                        divisionAccess = string.Format(" and Division.DivisionID in ({0})", _requestRepository.CurrentOperator.OriginalDivisionAccess);
                    }
                    query = string.Format(@" Select distinct Division.DivisionID, Division.OrganizationID, Divisionlanguage.Description, Division.DivisionCode,
                    IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName, EmployeeDivision.IsDefault
                    From EmployeeDivision
                    Inner join Division on Division.DivisionID = EmployeeDivision.DivisionID
                    Left Outer join Divisionlanguage on Division.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {0}
                    Where EmployeeID = {1} {2}",
                    _requestRepository.LanguageId,
                    employeeId,
                    divisionAccess);
                    result = DBHelperForDivisions.GetQueryList(query, ref divisions);

                    if (result == GlobalErrors.Success && divisions != null && divisions.Count > 0)
                    {
                        selectedEmployee.Divisions = divisions;
                        selectedEmployee.DefaultDivisionId = -1;
                        if (divisions.Any(x => x.IsDefault == true))
                        {
                            selectedEmployee.DefaultDivisionId = divisions.Find(x => x.IsDefault == true).DivisionId;
                        }
                    }
                    if (DBHelperForDivisions != null)
                    {
                        DBHelperForDivisions.Dispose();
                        DBHelperForDivisions = null;
                    }
                    #endregion

                    #region[Sales Channels]
                    if (_requestRepository.Configurations.EnableSalesDistributionChannel && _requestRepository.Configurations.ApplyDocumentSequencePerSalesChannel)
                    {
                        DBHelper<SalesDistributionChannelModel> DBHelperForSalesChannel = new DBHelper<SalesDistributionChannelModel>();
                        List<SalesDistributionChannelModel> SalesChannels = new List<SalesDistributionChannelModel>();
                        query = string.Format(@" Select distinct SalesChannelDocumentSequence.SalesChannelID SDCId,SalesChannelDocumentSequence.MaxTransactionInvoiceID MaxInvoiceID,SDC.SDCCode,SDCLanguage.Description SDCDescription  
                        From SalesChannelDocumentSequence
                        Inner join SDC on SalesChannelDocumentSequence.SalesChannelID = SDC.SDCID
						inner join SDCOrganization on SDCOrganization.SDCID = SDC.SDCID and SDCOrganization.OrganizationID in ({2})
                        Left Outer join SDCLanguage on SalesChannelDocumentSequence.SalesChannelID = SDCLanguage.SDCID And SDCLanguage.LanguageID = {0}
                        Where EmployeeID = {1}",
                        _requestRepository.LanguageId,
                        employeeId,
                        _requestRepository.CurrentOperator.OrganizationAccess);
                        result = DBHelperForSalesChannel.GetQueryList(query, ref SalesChannels);

                        if (result == GlobalErrors.Success && SalesChannels != null && SalesChannels.Count > 0)
                        {
                            selectedEmployee.SalesChannelDocumentSequenceList = SalesChannels;
                        }
                        if (DBHelperForSalesChannel != null)
                        {
                            DBHelperForSalesChannel.Dispose();
                            DBHelperForSalesChannel = null;
                        }
                    }
                    #endregion


                    #region[Organization Access]
                    DBHelper<OrganizationModel> DBHelperForOrganization = new DBHelper<OrganizationModel>();
                    List<OrganizationModel> organizations = new List<OrganizationModel>();

                    query = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                    IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                    FROM EmployeeOrganization
                    inner join Organization on Organization.OrganizationID = EmployeeOrganization.OrganizationID
                    left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                    where EmployeeOrganization.EmployeeId = {1} and EmployeeOrganization.OrganizationID in ({2})",
                    _requestRepository.LanguageId,
                    employeeId,
                    _requestRepository.Configurations.ForceOrganizationSelectionOnLogin ? _requestRepository.CurrentOperator.OriginalOrganizationAccess : _requestRepository.CurrentOperator.OrganizationAccess);

                    result = DBHelperForOrganization.GetQueryList(query, ref organizations);

                    if (result == GlobalErrors.Success && organizations != null && organizations.Count > 0)
                    {
                        selectedEmployee.OrganizationsAccessList = organizations;
                    }
                    if (DBHelperForOrganization != null)
                    {
                        DBHelperForOrganization.Dispose();
                        DBHelperForOrganization = null;
                    }
                    #endregion

                    #region[Items List]
                    DBHelper<ItemListModel> DBHelperForItemsList = new DBHelper<ItemListModel>();
                    List<ItemListModel> itemsList = new List<ItemListModel>();

                    query = string.Format(@"SELECT distinct ItemsList.ItemListID,ItemsList.ItemListCode,ItemsListLanguage.Description,IsNull( ItemsList.ItemListCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemsListLanguage.Description , '--') as ItemListCodeName 
                    FROM ItemListEmployee
                    inner join ItemsList on ItemsList.ItemListID = ItemListEmployee.ItemListID
                    left join ItemsListLanguage on ItemsListLanguage.ItemListID = ItemsList.ItemListID and ItemsListLanguage.LanguageID = {0}
                    where ItemListEmployee.EmployeeId = {1}",
                    _requestRepository.LanguageId,
                    employeeId);

                    result = DBHelperForItemsList.GetQueryList(query, ref itemsList);

                    if (result == GlobalErrors.Success && itemsList != null && itemsList.Count > 0)
                    {
                        selectedEmployee.ItemsList = itemsList;
                    }
                    if (DBHelperForItemsList != null)
                    {
                        DBHelperForItemsList.Dispose();
                        DBHelperForItemsList = null;
                    }
                    #endregion
                    #region [Security Groups]
                    if (result == GlobalErrors.Success)
                    {
                        List<SecurityGroupModel> securityGroups = new List<SecurityGroupModel>();
                        result = _masterDataManager.GetSecurityGroupsList(selectedEmployee.EmployeeId, selectedEmployee.OrganizationId, ref securityGroups);
                        if (result == GlobalErrors.Success && securityGroups != null && securityGroups.Count > 0)
                        {
                            selectedEmployee.SecurityGroups = securityGroups;
                        }
                        if (result == GlobalErrors.Success && selectedEmployee.OperatorId != -1)
                        {
                            object privillageCount = null;
                            DBHelper<int> dbHelperForProvillage = new DBHelper<int>();
                            query = string.Format(@" SELECT count(*) from OperatorPrivilege WHERE operatorID = {0}", selectedEmployee.OperatorId);
                            result = dbHelperForProvillage.ExecuteScalar(query, ref privillageCount);
                            if (result == GlobalErrors.Success)
                            {
                                if (privillageCount != null && !string.IsNullOrEmpty(privillageCount.ToString()) && Int32.Parse(privillageCount.ToString()) > 0)
                                {
                                    selectedEmployee.IsOperatorLinkedWithOperatorPrivilege = true;
                                }
                            }
                            else
                            {
                                return result;
                            }
                        }
                    }
                    #endregion

                    #region [Document Sequence]

                    DBHelper<int> DBHelperForDocumentSequence = new DBHelper<int>();
                    DataTable dtDocumentSequence = new DataTable();

                    query = string.Format(@" Select * From DocumentSequence Where EmployeeID = {0}", employeeId);
                    result = DBHelperForDocumentSequence.GetQueryDataTable(query, ref dtDocumentSequence);
                    if (result == GlobalErrors.Success)
                    {
                        if (dtDocumentSequence != null && dtDocumentSequence.Rows.Count > 0)
                        {
                            selectedEmployee.EmployeeDocumentSequenceList = new List<EmployeeDocumentSequence>();
                            var isDivisionsMode = _requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence;
                            EmployeeDocumentSequence employeeDocumentSequence = null;
                            foreach (DataRow row in dtDocumentSequence.Rows)
                            {
                                employeeDocumentSequence = new EmployeeDocumentSequence();
                                employeeDocumentSequence.EmployeeId = employeeId;
                                if (isDivisionsMode)
                                    employeeDocumentSequence.divisionName = divisions.Where(x => x.DivisionId == int.Parse(row.ItemArray[13].ToString())).FirstOrDefault()?.DivisionCodeName;
                                employeeDocumentSequence.FillEmployeeDocumentSequence(row);

                                if (employeeDocumentSequence != null &&
                                    ((!string.IsNullOrEmpty(employeeDocumentSequence.divisionName) && isDivisionsMode)) || !isDivisionsMode)
                                {
                                    selectedEmployee.EmployeeDocumentSequenceList.Add(employeeDocumentSequence);
                                }
                            }
                        }
                        else
                        {
                            // No Document Sequence Defined
                            selectedEmployee.EmployeeDocumentSequenceList = null;
                        }
                    }
                    if (DBHelperForDocumentSequence != null)
                    {
                        DBHelperForDocumentSequence.Dispose();
                        DBHelperForDocumentSequence = null;
                    }

                    #endregion
                    #region [Document Sequence Customer]
                    if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.ApplyDivisionsOnDocumentSequence)
                    {
                        DBHelper<int> DBHelperForDocumentSequenceCustomer = new DBHelper<int>();
                        DataTable dtDocumentSequenceCustomer = new DataTable();
                        query = $"select MaxCustomerCode,MaxNewCustomerCodeID from DocumentSequence where EmployeeID = {employeeId} and DivisionID = '-1'  ";
                        result = DBHelperForDocumentSequenceCustomer.GetQueryDataTable(query, ref dtDocumentSequenceCustomer);

                        if (dtDocumentSequenceCustomer != null && dtDocumentSequenceCustomer.Rows.Count > 0)
                        {
                            selectedEmployee.NewCustomerCode = dtDocumentSequenceCustomer.Rows[0].Field<string>("MaxNewCustomerCodeID");
                            selectedEmployee.MaxCustomerCode = dtDocumentSequenceCustomer.Rows[0].Field<string>("MaxCustomerCode");
                        }

                    }

                    #endregion

                    #region[Account]

                    DBHelper<AccountModel> DBHelperForAccount = new DBHelper<AccountModel>();
                    AccountModel account = new AccountModel();

                    query = string.Format(@" Select distinct Account.*, CurrencyLanguage.Description AS CurrencyName
                    From Account
                    Inner join AccountEmp on AccountEmp.AccountID = Account.AccountID
                    Left outer join CurrencyLanguage on CurrencyLanguage.CurrencyID = Account.CurrencyID and CurrencyLanguage.LanguageID = {0}
                    Where EmployeeID = {1}",
                    _requestRepository.LanguageId,
                    employeeId);

                    result = DBHelperForAccount.GetQuerySingle(query, ref account);
                    #endregion

                    #region [AccountsDivisions]
                    DBHelper<AccountModel> dBHelperAccountsDivisions = new DBHelper<AccountModel>();
                    List<AccountModel> accountsDivision = new List<AccountModel>();
                    query = string.Format(@"SELECT Sum(tt.CreditLimit) as TotalCreditLimit,tt.CreditLimit, tt.AccountID, tt.Balance, tt.DivisionID,
                          tt.divisionCodeName, 3 DataAction,tt.AccountTypeID,tt.OrganizationID,tt.CurrencyID  FROM (
                          select ISNULL(AED.AccountID, -1) AccountID, AC.CurrencyID,
                          AC.CreditLimit, ISNULL(AED.DivisionID, -1) DivisionID,
                          AC.OrganizationID, CASE WHEN AED.AccountID IS NULL THEN 0 ELSE AC.Balance END as Balance, 
                          AC.AccountTypeID, D.DivisionCode +'-'+ DL.Description divisionCodeName 
                          from Account AC
                          INNER JOIN AccountEmpDiv  ON AccountEmpDiv.AccountID = AC.AccountID
                          LEFT JOIN AccountEmpDiv AED ON AED.AccountID = AC.AccountID AND AED.DivisionID IN ({2}) AND AED.EmployeeID = {0}
                          LEFT JOIN Division D on D.DivisionID = AED.DivisionID
                          LEFT JOIN DivisionLanguage DL on DL.DivisionID = D.DivisionID and DL.LanguageID = {1} 
                          where  AccountEmpDiv.employeeID = {0}) as tt
                          GROUP BY tt.AccountID, tt.Balance, tt.DivisionID, tt.divisionCodeName ,
                          tt.AccountTypeID ,tt.OrganizationID ,tt.CurrencyID,tt.CreditLimit ORDER BY tt.divisionCodeName",
                                             employeeId, _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess);
                    result = dBHelperAccountsDivisions.GetQueryList(query, ref accountsDivision); // division
                    #endregion

                    if (result == GlobalErrors.Success && account != null)
                    {
                        selectedEmployee.Account = account;
                        selectedEmployee.AccountId = account.AccountId;
                        selectedEmployee.AccountsDivision = accountsDivision;
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        #endregion
        public GlobalErrors FillOperatorRelatedStaff()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int operatorSupervisor = -1;
                int operatorHelper = -1;
                int operatorDriver = -1;
                int operatorSalesManager = -1;
                int operatorSalesRep = -1;
                int salesManagerId = -1;

                // This flag to cash data from data base on login and refresh
                bool isLoginOperation = true;
                result = GetEmployeeRelatedStaff(_requestRepository.CurrentOperator.EmployeeId, null, ref operatorHelper, ref operatorDriver, ref operatorSupervisor, ref operatorSalesRep, ref salesManagerId, isLoginOperation);

                if (result == GlobalErrors.Success)
                {
                    _requestRepository.CurrentOperator.SupervisorId = operatorSupervisor;
                    _requestRepository.CurrentOperator.HelperId = operatorHelper;
                    _requestRepository.CurrentOperator.DriverId = operatorDriver;
                    _requestRepository.CurrentOperator.SalesRepId = operatorSalesRep;
                    _requestRepository.CurrentOperator.SalesManagerId = operatorSalesManager;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEmployeeDivisionAccessAsString(int employeeID, ref List<DivisionModel> divisions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DivisionModel> DBHelper = new DBHelper<DivisionModel>();
            try
            {
                string query = string.Format(@" Select Distinct EmployeeDivision.DivisionID , Division.OrganizationID
                from EmployeeDivision 				
				INNER JOIN Division ON EmployeeDivision.DivisionID = Division.DivisionID 
                where EmployeeDivision.EmployeeID = {0}", employeeID);
                
                result = DBHelper.GetQueryList(query, ref divisions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }                       
        public string ReadConfigurationValue(string configName)
        {
            DBHelper<string> dBHelper = null;
            try
            {
                object value = null;
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"select KeyValue from configuration where KeyName='{0}'", configName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref value);
                if (result == GlobalErrors.Success && value != null && !string.IsNullOrEmpty(value.ToString()))
                {
                    return value.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return string.Empty;
        }
        public bool AllowChangePassword(int operatorID, ref string errorMessage)
        {
            bool isValid = true;
            Object field = null;
            DBHelper<string> dbHelper;
            var result = GlobalErrors.NotInitialized;
            TimeSpan difference;
            errorMessage = string.Empty;
            try
            {
                string value = "";
                double period = -1;
                value = ReadConfigurationValue("MinChangingOperatorPasswordPeriod");
                if (!string.IsNullOrEmpty(value))
                    period = Convert.ToDouble(value.ToString());
                if (period > 0)
                {
                    dbHelper = new DBHelper<string>();
                    var query = string.Format(@"SELECT PasswordChangeDate FROM  Operator WHERE OperatorID = {0}", operatorID);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        DateTime date = Convert.ToDateTime(field.ToString()).AddDays(period);
                        difference = date.Date - DateTime.Now.Date;
                        if (double.Parse(difference.TotalDays.ToString()) <= 0)
                        {
                            isValid = true;
                            return isValid;
                        }
                        else
                        {
                            errorMessage = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Cannot_Reset_Password, _requestRepository.LanguageId), difference.TotalDays.ToString("#.#").Trim());
                            isValid = false;
                            return isValid;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                isValid = false;
            }
            return isValid;
        }
        public GlobalErrors ChangePassword(int operatorID, OperatorProfileModel operatorModel, int languageID, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            errorMessage = string.Empty;
            bool isValidPassword = false;
            int employeeTypeID = -1;
            try
            {
                if (operatorID == -1)
                    operatorID = GetOperatorID(operatorModel.UserName);
                employeeTypeID = EmployeeManager.GetEmployeeTypeID(operatorID);
                if (!string.IsNullOrEmpty(operatorModel.OldPassword))
                {
                    result = CheckOldPasswordIfMatch(operatorModel.OldPassword, operatorID);
                    if (result == GlobalErrors.PasswordNotMatch)
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Incorrect, languageID);
                        return result;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    isValidPassword = _passwordManager.ValidatePassword(operatorModel.NewPassword, operatorID, employeeTypeID, languageID, ref errorMessage);
                    if (isValidPassword)
                    {
                        result = _passwordManager.ChangeOperatorPassword(operatorID, operatorModel.NewPassword);
                        if (result == GlobalErrors.Success)
                            result = _passwordManager.RecordPasswordChangeHistory(operatorID,operatorModel);
                    }
                    else
                        result = GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public int GetOperatorID(string operatorName)
        {
            Object field = null;
            int operatorID = -1;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format("SELECT OperatorID FROM  Operator WHERE OperatorName = '{0}'", operatorName);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    operatorID = int.Parse(field.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return operatorID;
        }
        public static int GetEmployeeTypeID(int operatorID)
        {
            Object field = null;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            int employeeTypeID = -1;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format(@"SELECT Employee.EmployeeTypeID FROM  Operator
                Inner join EmployeeOperator on Operator.OperatorID =  EmployeeOperator.OperatorID
                Inner join Employee on Employee.EmployeeID =EmployeeOperator.EmployeeID
                where Operator.OperatorID ={0}", operatorID);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    employeeTypeID = int.Parse(field.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return employeeTypeID;
        }
        public static int GetEmployeeType(int EmployeeID)
        {
            Object field = null;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            int employeeTypeID = -1;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format(@"SELECT Employee.EmployeeTypeID FROM Employee
                where Employeeid ={0}", EmployeeID);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    employeeTypeID = int.Parse(field.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return employeeTypeID;
        }
        public GlobalErrors GetEmployeeRelatedStaff(int employeeID, ref int helperId, ref int driverId, ref int supervisorId, ref int salesRepId, ref int SalesManagerId)
        {
            return GetEmployeeRelatedStaff(employeeID, null, ref helperId, ref driverId, ref supervisorId, ref salesRepId, ref SalesManagerId);
        }
        public GlobalErrors GetEmployeeRelatedStaff(int employeeID, DBHelper<int> dbHelper, ref int helperId, ref int driverId, ref int supervisorId, ref int salesRepId, ref int salesManagerId)
        {
            return GetEmployeeRelatedStaff(employeeID, dbHelper, ref helperId, ref driverId, ref supervisorId, ref salesRepId, ref salesManagerId, false);
        }
        public GlobalErrors GetEmployeeRelatedStaff(int employeeID, DBHelper<int> dbHelper, ref int helperId, ref int driverId, ref int supervisorId, ref int salesRepId, ref int salesManagerId, bool isLoginOperation)
        {
            DataTable dt = new DataTable();
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool useSameDBHelper = true;
            try
            {
                // isLoginOperation -> flag set as true in [login operation] to get data from DB for currenct operator for the first time.
                // if employee id <> currenct logged in user then get data from DB
                if (isLoginOperation || employeeID != _requestRepository.CurrentOperator.EmployeeId)
                {
                    if (dbHelper == null)
                    {
                        useSameDBHelper = false;
                        dbHelper = new DBHelper<int>();
                    }
                    string query = string.Format(@"SELECT
                    EmployeeSupervisor.SupervisorID,
                    EmployeeHelper.HelperID,
                    VanInChargePreSales.EmployeeID AS PreSalesID,
                    IsNull(SupervisorSalesMngr.SalesManagerID,NULL)SalesManagerID,
                    Employee.OrganizationID,
                    EmployeeDriver.DriverID,
                    employeeSalesRep.salesRepID
                    FROM Employee
                    LEFT OUTER JOIN EmployeeSupervisor ON  Employee.EmployeeID = EmployeeSupervisor.EmployeeID
                    LEFT OUTER JOIN EmployeeHelper ON  Employee.EmployeeID = EmployeeHelper.EmployeeID
                    LEFT OUTER JOIN EmployeeDriver ON  Employee.EmployeeID = EmployeeDriver.EmployeeID
                    LEFT OUTER JOIN VanInChargePreSales ON  Employee.EmployeeID = VanInChargePreSales.VanInChargeID
                    left Outer join employeeSalesRep on employeeSalesRep.EmployeeID= Employee.EmployeeID
                    Left Outer join SupervisorSalesMngr ON Employee.EmployeeID=SupervisorSalesMngr.SupervisorID Or  SupervisorSalesMngr.SupervisorID in (Select SupervisorID from EmployeeSupervisor where EmployeeID={0})
                    WHERE Employee.EmployeeID = {0}", employeeID);

                    result = dbHelper.GetQueryDataTable(query, ref dt);
                    if (result == GlobalErrors.Success)
                    {
                        if (dt.Rows.Count > 0)
                        {
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.HelperID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.HelperID].ToString()))
                            {
                                helperId = Int32.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.HelperID].ToString());
                            }
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.DriverID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.DriverID].ToString()))
                            {
                                driverId = Int32.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.DriverID].ToString());
                            }
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SupervisorID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SupervisorID].ToString()))
                            {
                                supervisorId = Int32.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SupervisorID].ToString());
                            }
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SalesRepID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SalesRepID].ToString()))
                            {
                                salesRepId = Int32.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SalesRepID].ToString());
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        salesManagerId = GetSupervisorSalesManager(employeeID, dbHelper);
                    }
                }
                else if (!isLoginOperation && employeeID == _requestRepository.CurrentOperator.EmployeeId)
                {
                    // get data from cashed data
                    helperId = _requestRepository.CurrentOperator.HelperId;
                    driverId = _requestRepository.CurrentOperator.DriverId;
                    supervisorId = _requestRepository.CurrentOperator.SupervisorId;
                    salesRepId = _requestRepository.CurrentOperator.SalesRepId;
                    salesManagerId = _requestRepository.CurrentOperator.SalesManagerId;
                    return GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (!useSameDBHelper && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetEmployeeIdByUsername(string Username, ref int EmployeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                string Query = string.Format(@"Select EmployeeID from EmployeeOperator 
                where OperatorID = (select OperatorID from Operator where OperatorName = '{0}')", Username);
                result = dbHelper.GetQueryDataTable(Query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    EmployeeId = int.Parse(dt.Rows[0][0].ToString());
                }
                else
                {
                    EmployeeId = -1;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetRouteIDByEmployeeId(int EmployeeId, ref int RouteId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                string Query = string.Format(@"select RouteID from Route R
                INNER JOIN Territory T on T.TerritoryID = R.TerritoryID
                INNER JOIN EmployeeTerritory ET on ET.TerritoryID = T.TerritoryID AND EmployeeId = {0}", EmployeeId);
                result = dbHelper.GetQueryDataTable(Query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    RouteId = int.Parse(dt.Rows[0][0].ToString());
                }
                else
                {
                    RouteId = -1;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveEmployeeChannel(ChannelModel channelObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                channelObj.ChannelId = GetMaxID(CoreDataBaseConstants.QueryColumnsNames.ChannelID, CoreDataBaseConstants.TableNames.EmployeeChannelDefinition, dBHelper);
                dBHelper.BeginTransaction();
                string query = string.Format(@"Insert into EmployeeChannelDefinition (ChannelID, ChannelCode)
                values({0},'{1}')",
                channelObj.ChannelId, //0
                channelObj.ChannelCode.Replace("'", "''")//2
                );//17
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    foreach (TextLanguage language in channelObj.ChannelDescriptionLanguages)
                    {
                        query = string.Format(@"insert into EmployeeChannelDefinitionLanguage (ChannelID,LanguageID,Description) values ({0},{1},'{2}')", channelObj.ChannelId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if(result == GlobalErrors.Success)
                {
                    foreach (OrganizationModel organization in channelObj.OrganizationList)
                    {
                        query = string.Format(@"insert into EmployeeChannelOrganization (ChannelID,OrganizationID) values ({0},{1})", channelObj.ChannelId, organization.OrganizationId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors GetAllEmployeeChannels(GeneralFilter filter, ref SharedTableResult<ChannelModel> allChannels)
        {
            DBHelper<ChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<ChannelModel> lists = new List<ChannelModel>();
                dbHelper = new DBHelper<ChannelModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" and ( (EmployeeChannelDefinitionLanguage.Description LIKE '%{0}%')
                    OR ( EmployeeChannelDefinition.ChannelCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (!string.IsNullOrEmpty(filter.OrganizationId.ToString()) && filter.OrganizationId > -1)
                    {
                        searchFilter += string.Format(@" And  EmployeeChannelDefinition.OrganizationID ={0}", filter.OrganizationId);
                    }
                    if (!string.IsNullOrEmpty(filter.ChannelId.ToString()) && filter.ChannelId > -1)
                    {
                        searchFilter += string.Format(@" And  EmployeeChannelDefinition.ChannelID ={0}", filter.ChannelId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@" Order By tt.ChannelCode desc");
                    }
                }
                string mainQuery = string.Format(@" inner join EmployeeChannelOrganization on EmployeeChannelOrganization.ChannelID = EmployeeChannelDefinition.ChannelID
                                   inner join EmployeeChannelDefinitionLanguage on 
                                   EmployeeChannelDefinition.ChannelID=EmployeeChannelDefinitionLanguage.ChannelID and EmployeeChannelDefinitionLanguage.LanguageID={0}
                                   Where EmployeeChannelOrganization.OrganizationID in ({1}) ",
                                    _requestRepository.LanguageId,//0
                                    _requestRepository.CurrentOperator.OrganizationAccess///1
                                    );

                string allDataQuery = string.Format(@"
                                      Select ROW_NUMBER() Over(Order By tt.ChannelId) AS RowSeq,*
                                      from (Select distinct EmployeeChannelDefinition.ChannelID ChannelId, EmployeeChannelDefinition.ChannelCode,
                EmployeeChannelDefinitionLanguage.Description ChannelName
                from EmployeeChannelDefinition 
                                    
                                    {0}
                                    {1} 
                                    ) tt
                                    {2} 
                                    OFFSET  {3} ROWS       
                                    FETCH NEXT {4} ROWS ONLY",

                                    mainQuery,//0
                                    searchFilter,//1
                                    orderByFilter,//2
                                   (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//3
                                   filter.CustomListFilter.PageSize//4


                                   );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from (select distinct EmployeeChannelDefinition.*  From EmployeeChannelDefinition {0} {1})tt ",
                                             mainQuery,
                                             searchFilter);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField ,true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    allChannels.TotalItems = int.Parse(objField.ToString().Trim());
                    if (allChannels.TotalItems <= 0)
                    {
                        allChannels.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists , true);
                allChannels.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeTransactions(GeneralFilter filter, ref SharedTableResult<TransactionModel> transactions)
        {
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<TransactionModel> lists = new List<TransactionModel>();
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();              
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendFormat(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" AND ( 
                        ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                        OR ( CustomerOutlet.CustomerCode LIKE '%{0}%')
                        OR ( [Transaction].TransactionDate LIKE '%{0}%')
                        OR ( [Transaction].TransactionID LIKE '%{0}%' )
                        OR ( [Transaction].CustomerID LIKE '%{0}%' )
						OR ( [Transaction].OutletID LIKE '%{0}%' )
                        )",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.FromEmployeeId != -1)
                    {
                        searchFilter += string.Format(@" AND [transaction].EmployeeID = {0}", filter.FromEmployeeId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By tt.TransactionDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }

                List<TransactionType> transactionTypes = new List<TransactionType>() { TransactionType.Sales,TransactionType.SalesExchange,TransactionType.DebitNote};
                string transactionTypesString = string.Join(",", transactionTypes.Select(t => (int)t));

                string mainQuery = string.Format(@"
                    SELECT DISTINCT {2}.TransactionID, {2}.TransactionDate,{2}.CustomerID,{2}.OutletID,{2}.RemainingAmount, 
                    IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as CustomerCodeName, {2}.DivisionID , CustomerOutlet.CustomerTypeID , {2}.SalesMode
                    FROM {2} 
                    INNER JOIN CustomerOutlet ON {2}.CustomerID = CustomerOutlet.CustomerID 
					AND CustomerOutlet.OutletID = {2}.OutletID
                    LEFT JOIN CustomerOutletLanguage ON {2}.CustomerID = CustomerOutletLanguage.CustomerID AND 
                    {2}.OutletID = CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {1}
                    {3}
                    WHERE  {2}.[TransactionTypeID] IN ({4}) And ({2}.RemainingAmount > 0) AND {2}.Posted = 1 AND {2}.Voided != 1 {0}", 
                    searchFilter, _requestRepository.LanguageId , CoreDataBaseConstants.TableNames.Transaction, orgAccessJoin,transactionTypesString);

                string allDataQuery = string.Format(@"Select * from ({0}) tt {1} OFFSET {2} ROWS  FETCH NEXT {3} ROWS ONLY",
                                    mainQuery,//0
                                    orderByFilter,//1
                                    (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//2
                                    filter.CustomListFilter.PageSize//3
                                   );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})tt ", mainQuery);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transactions.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transactions.TotalItems <= 0)
                    {
                        transactions.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists , true);
                transactions.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transactions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetChannelDescriptions(int channelId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from EmployeeChannelDefinitionLanguage
                where EmployeeChannelDefinitionLanguage.ChannelID={0}", channelId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetChannelOrganizations(int channelId, ref List<OrganizationModel> organizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"select Organization.OrganizationID OrganizationId ,IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                from EmployeeChannelOrganization
                inner join Organization on Organization.OrganizationID = EmployeeChannelOrganization.OrganizationID
                left join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {1}
                where ChannelID = {0}", channelId,_requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref organizations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditEmployeeChannel(ChannelModel channelObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                string query = string.Format(@"Update EmployeeChannelDefinition set ChannelCode='{0}' where channelID = {1}",
                                channelObj.ChannelCode.Replace("'", "''"),// 0
                                channelObj.ChannelId //2
                               );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //update language
                    foreach (TextLanguage language in channelObj.ChannelDescriptionLanguages)
                    {
                        query = string.Format(@"update EmployeeChannelDefinitionLanguage set Description = '{0}' where ChannelID = {1} and LanguageID = {2}", language.Description.Replace("'", "''"), channelObj.ChannelId, language.LanguageId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"delete from EmployeeChannelOrganization where ChannelID = {0}", channelObj.ChannelId);
                    result = dBHelper.ExecuteNonQuery(query);
                    if(result == GlobalErrors.Success)
                    {
                        foreach (OrganizationModel organization in channelObj.OrganizationList)
                        {
                            query = string.Format(@"insert into EmployeeChannelOrganization (ChannelID,OrganizationID) values ({0},{1})", channelObj.ChannelId, organization.OrganizationId);
                            result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors DeleteEmployeeChannel(int channelID)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<int> dBHelper = null;
            string queryString = string.Empty;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                queryString = string.Format("Delete from EmployeeChannelDefinitionLanguage  where ChannelID= {0} ", channelID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    queryString = string.Format("Delete from EmployeeChannelOrganization  where ChannelID= {0} ", channelID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    queryString = string.Format("Delete from EmployeeChannelDefinition  where ChannelID= {0} ", channelID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public bool IsChannelLinkedToEmployees(int channelId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select * From Employee WHERE channelId = {0} ", channelId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public List<EmployeeModel> GetAvailableDrivers(int driverId)
        {
            List<EmployeeModel> employeesList = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dbHelper = null;
            EmployeeModel employee = new EmployeeModel();
            GlobalErrors result = GlobalErrors.NotInitialized;
            string filter = string.Empty;

            try
            {
                result = GetEmployeeData(driverId, ref employee);
                if (result == GlobalErrors.Success)
                {
                    if (employee.EmployeeTypeId == (int)EmployeeTypes.Deliveryperson)
                    {
                        filter = string.Format("AND Employee.EmployeeTypeID = {0}", (int)EmployeeTypes.Deliveryperson);
                    }
                    else
                    {
                        filter = string.Format("AND Employee.EmployeeTypeID <> {0}", (int)EmployeeTypes.Deliveryperson);
                    }
                    dbHelper = new DBHelper<EmployeeModel>();
                    string query = string.Empty;
                    //Until get access to employee loggedin data
                    string storeKeeperFilter = string.Empty;
                    query = string.Format(@"SELECT distinct EmployeeLanguage.Description EmployeeName,Employee.EmployeeCode,Employee.EmployeeID
                            ,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--')  as EmployeeCodeName,Employee.EmployeeTypeId
                             FROM  Employee
                            inner join EmployeeVehicle on EmployeeVehicle.EmployeeID = Employee.EmployeeID
                            Left Join Trips on Trips.DriverId = Employee.EmployeeID AND Trips.Status in ({2},{3},{4},{5},{6},{7})
                            Left JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID   AND EmployeeLanguage.LanguageID = {0}
                            WHERE Trips.DriverId IS NULL {9} AND Employee.Inactive = 0 AND Employee.OrganizationID IN({1}) AND Employee.EmployeeID <> 0
                            ORDER BY EmployeeLanguage.Description", _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess,
                                (int)TripStatus.New, (int)TripStatus.Assigned, (int)TripStatus.CheckOutStarted, (int)TripStatus.CheckOutMismatchCounting,
                                    (int)TripStatus.CheckedOut, (int)TripStatus.CheckInStarted, (int)TripStatus.CheckInMismatch, filter);
                    dbHelper.GetQueryList(query, ref employeesList);
                }
                return employeesList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public GlobalErrors EditEmployeeTerritoryAndVehicle(int employeeID, int vehicleID, int territoryID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update EmployeeVehicle set EmployeeID={0} where VehicleID = {1}",
                                employeeID,// 0
                                vehicleID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Update EmployeeTerritory set EmployeeID={0} where TerritoryID = {1}",
                               employeeID,// 0
                               territoryID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteEmployeeTerritoryAndVehicle(int employeeID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete From EmployeeVehicle where EmployeeID={0}",
                                employeeID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From EmployeeTerritory where EmployeeID={0}",
                               employeeID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors AddTerritoryAndVehicle(int employeeID, int vehicleID, int territoryID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            try
            {
                if (vehicleID > 0)
                {

                    query = string.Format(@"Insert Into EmployeeVehicle  (VehicleID,EmployeeID) Values ({0},{1})",
                                   vehicleID, employeeID);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success && territoryID > 0)
                {
                    query = string.Format(@"Insert Into EmployeeTerritory  (EmployeeID,TerritoryID) Values ({0},{1})",
                               employeeID, territoryID);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeTerritory(int employeeID, ref int Territory)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            DBHelper<int> dBHelper;
            object scalerValue = null;
            try
            {
                dBHelper = new DBHelper<int>();
                query = string.Format(@"Select TerritoryID From EmployeeTerritory Where EmployeeID = {0}", employeeID);
                result = dBHelper.ExecuteScalar(query, ref scalerValue);
                if (scalerValue != null)
                {
                    Territory = Convert.ToInt32(scalerValue.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeVehicle(int employeeID, ref int vehicleId)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            DBHelper<int> dBHelper;
            object scalerValue = null;
            try
            {
                dBHelper = new DBHelper<int>();
                query = string.Format(@"Select VehicleID From EmployeeVehicle Where EmployeeID = {0}", employeeID);
                result = dBHelper.ExecuteScalar(query, ref scalerValue);
                if (scalerValue != null)
                {
                    vehicleId = Convert.ToInt32(scalerValue.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllInspectors(string organizationIds, ref List<EmployeeModel> inspectorList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            string orgFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                if (!string.IsNullOrEmpty(organizationIds))
                {
                    orgFilter = string.Format(" And Employee.OrganizationID in ({0})", organizationIds);
                }
                var employeeQuery = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName,
                Employee.EmployeeCode,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                FROM Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                Where Employee.OrganizationID in ({1}) and Employee.Inactive <> 1 and Employee.EmployeeTypeID = {2} {3}
				ORDER BY EmployeeName ",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess, EmployeeTypes.Inspector.GetHashCode(), orgFilter);

                result = dbHelper.GetQueryList(employeeQuery, ref inspectorList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllSurveyEmployees(string organizationIds, ref List<EmployeeModel> employeeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeModel> dbHelper = null;
            string orgFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                if (!string.IsNullOrEmpty(organizationIds))
                {
                    orgFilter = string.Format(" And Employee.OrganizationID in ({0})", organizationIds);
                }
                var employeeQuery = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName,
                Employee.EmployeeCode,IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,Employee.OrganizationID
                FROM Employee
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                Where Employee.OrganizationID in ({1}) and Employee.Inactive <> 1 and Employee.EmployeeTypeID not in (1,5,7,9,12,19) {2}
				ORDER BY EmployeeName ",
                _requestRepository.LanguageId,
                _requestRepository.CurrentOperator.OrganizationAccess, orgFilter);

                result = dbHelper.GetQueryList(employeeQuery, ref employeeList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors getAllSecurityGroups(string organizationIds,bool getAll, ref List<SecurityGroupModel> securityGroups)
        {
            GlobalErrors err = GlobalErrors.NotInitialized;
            string orgFilter = string.Empty;
            try
            {
                DBHelper<SecurityGroupModel> dBHelper = new DBHelper<SecurityGroupModel>();
                if (!string.IsNullOrEmpty(organizationIds))
                {
                    orgFilter = string.Format(@" where SecurityGroup.OrganizationID in ({0})", organizationIds);
                }
                else if (_requestRepository.CurrentOperator.OrganizationId > 0 && !getAll)
                {
                    orgFilter = string.Format(@" where SecurityGroup.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationId);
                }
                else if (getAll)
                {
                    orgFilter = string.Format(@" where SecurityGroup.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                string query = string.Format(@"Select SecurityGroup.SecurityGroupID, SecurityGroupLanguage.Description SecurityGroupName,SecurityGroup.OrganizationID from
                SecurityGroup 
                Inner join SecurityGroupLanguage on SecurityGroup.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID  and  SecurityGroupLanguage.LanguageID={0}
                {1}", _requestRepository.LanguageId, orgFilter);
                err = dBHelper.GetQueryList(query, ref securityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return err;
        }
        public GlobalErrors GetItemsList(ref List<ItemListModel> itemsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ItemListModel> dBHelper = new DBHelper<ItemListModel>();
                string query = string.Format(@" Select ItemsList.ItemListID,IsNull( ItemsList.ItemListCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemsListLanguage.Description , '--') as ItemListCodeName from ItemsList
                left join ItemsListLanguage on ItemsListLanguage.ItemListID = ItemsList.ItemListID and ItemsListLanguage.LanguageID = {0}
                where ItemListType = {1}", _requestRepository.LanguageId,ItemListType.ItemListEmployee.GetHashCode());
                result = dBHelper.GetQueryList(query, ref itemsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfEmployeeIsOnHold(int employeeId, ref bool isOnhold)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                object obj = null;
                dbHelper = new DBHelper<int>();
                var query = string.Format(@"SELECT 'True' FROM Employee WHERE EmployeeID = {0} AND OnHold = 1", employeeId);
                result = dbHelper.ExecuteScalar(query, ref obj);

                if (result == GlobalErrors.Success && obj != null && !obj.ToString().Equals(string.Empty))
                {
                    isOnhold = true;
                }
                else
                {
                    isOnhold = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        public string GetEmployeeCodeName(int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<string>();
                object field = new object();

                string query = string.Format(@"
                                select IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                                From Employee 
                                Left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and LanguageID = {0}
                                Where Employee.EmployeeId = {1} ", _requestRepository.LanguageId, employeeId);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field.ToString() != string.Empty)
                {
                    return field.ToString();
                }
                else
                {
                    return string.Empty;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
        }
        public GlobalErrors GetDevicesList(EmployeeFilter filter, ref SharedTableResult<DeviceModel> devices)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DeviceModel> dBHelper = new DBHelper<DeviceModel>();
                var devicesList = new List<DeviceModel>();
                SharedTableResult<DeviceModel> shredTableDevices = new SharedTableResult<DeviceModel>();
                string selectSqlQuery = string.Empty;
                string joinAndConditionsSqlQuery = string.Empty;
                string filters = string.Empty;
                string orderBy = string.Empty;
                string includeInactive = " And D.Inactive = 0";
                object field = 0;

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        filters = string.Format(@" And ((D.Serial like '%{0}%') OR
                                                        (D.Brand like '%{0}%') OR
                                                        (D.ModelNumber like '%{0}%') OR
                                                        (DL.Description like '%{0}%') OR
                                                        (EL.Description like '%{0}%') OR
                                                        (OL.Description like '%{0}%'))",
                                                        filter.CustomListFilter.SearchFilter);
                    }

                    if (filter.EmployeeId != -1)
                    {
                        filters += string.Format(@" And E.EmployeeID = {0}", filter.EmployeeId);
                    }

                    if (filter.OrganizationId != -1)
                    {
                        filters += string.Format(@" And O.OrganizationID = {0}", filter.OrganizationId);
                    }
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderBy = string.Format(@" Order By {0} {1}", filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    else
                    {
                        orderBy = string.Format(@"Order By DL.Serial {0} ", filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                    if (filter.IncludeInactive)
                    {
                        includeInactive = string.Empty; ;
                    }
                }
                selectSqlQuery = string.Format(@"select DL.Description DeviceName,D.Serial DeviceSerial,EL.Description EmployeeCodeName,D.WarrantyExpiry,D.PurchaseDate,
                                                        D.ModelNumber, D.Brand,D.PurchaseDate,D.WarrantyExpiry,D.Inactive,E.EmployeeId,O.OrganizationId,OL.Description OrganizationCodeName");

                joinAndConditionsSqlQuery = string.Format(@"from Device D
                                           LEFT JOIN EmployeeDevice ED ON ED.DeviceSerial = D.Serial
                                           LEFT JOIN Employee E ON ED.EmployeeID = E.EmployeeID
                                           LEFT OUTER JOIN EmployeeLanguage EL ON EL.EmployeeID = E.EmployeeID And EL.LanguageID = {0}
                                           INNER JOIN Organization O ON O.OrganizationID = D.OrganizationID
                                           LEFT OUTER JOIN OrganizationLanguage OL ON OL.OrganizationID = O.OrganizationID And OL.LanguageID = {0}
                                           LEFT JOIN DeviceLanguage DL ON DL.Serial = D.Serial And DL.LanguageID = {0} 
                                           where 1 = 1  and D.OrganizationID in ({3}) {1}  {2} ",
                                           _requestRepository.LanguageId, //0
                                           includeInactive, //2
                                           filters,//1
                                           _requestRepository.CurrentOperator.OrganizationAccess //3
                                           );

                string countQuery = string.Format(@"select ISNULL(Count(*),0) {0}", joinAndConditionsSqlQuery);
                result = dBHelper.ExecuteScalar(countQuery, ref field , true);
                if (result == GlobalErrors.Success)
                {
                    shredTableDevices.TotalItems = int.Parse(field.ToString());
                    if (shredTableDevices.TotalItems > 0)
                    {
                        string finalQuery = string.Format(@"{0} {1} {2} OFFSET  {3} ROWS  
                                                            FETCH NEXT {4} ROWS ONLY",
                                                            selectSqlQuery,//0
                                                            joinAndConditionsSqlQuery,//1
                                                            orderBy,//2
                                                            ((filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize), //3
                                                            filter.CustomListFilter.PageSize //4
                                                            );
                        result = dBHelper.GetQueryList(finalQuery, ref devicesList , true);
                        shredTableDevices.Data = devicesList;
                    }

                }
                else
                {
                    shredTableDevices.TotalItems = 0;
                    shredTableDevices.Data = null;
                }
                devices = shredTableDevices;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDeviceData(string deviceSerial, ref DeviceModel deviceData)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DeviceModel> dBHelper = new DBHelper<DeviceModel>();
                string sqlQuery = string.Empty;
                var textLanguageList = new List<TextLanguage>();
                object field = 0;
                sqlQuery = string.Format(@"select DL.Description DeviceName,D.Serial DeviceSerial,EL.Description EmployeeCodeName,
                                           D.WarrantyExpiry,D.PurchaseDate,
                                           D.ModelNumber, D.Brand,D.PurchaseDate,D.WarrantyExpiry,D.Inactive,D.AvailableForUsage,E.EmployeeId,
                                           O.OrganizationId,OL.Description OrganizationCodeName 
                                           from Device D
                                           LEFT JOIN EmployeeDevice ED ON ED.DeviceSerial = D.Serial
                                           LEFT JOIN Employee E ON ED.EmployeeID = E.EmployeeID
                                           LEFT OUTER JOIN EmployeeLanguage EL ON EL.EmployeeID = E.EmployeeID And EL.LanguageID = {0}
                                           INNER JOIN Organization O ON O.OrganizationID = D.OrganizationID
                                           LEFT OUTER JOIN OrganizationLanguage OL ON OL.OrganizationID = O.OrganizationID And OL.LanguageID = {0}
                                           LEFT JOIN DeviceLanguage DL ON DL.Serial = D.Serial And DL.LanguageID = {0} 
                                           where D.Serial = '{1}'
                                           ", _requestRepository.LanguageId, deviceSerial);
                result = dBHelper.GetQuerySingle(sqlQuery, ref deviceData);

                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"select Count(*) from EmployeeDevice where DeviceSerial = '{0}'", deviceSerial);
                    result = dBHelper.ExecuteScalar(sqlQuery, ref field);
                    if (int.Parse(field.ToString()) > 0)
                    {
                        deviceData.DisableOrganization = true;
                    }
                }


                if (result == GlobalErrors.Success && int.Parse(field.ToString()) == 0)
                {
                    sqlQuery = string.Format(@"SELECT ISNULL(count(*),0) FROM RouteHistory WHERE RouteHistoryID = (SELECT MAX(RouteHistoryID) 
                                                       FROM RouteHistory WHERE DeviceSerial = '{0}') AND Uploaded = 1 ", deviceSerial);
                    result = dBHelper.ExecuteScalar(sqlQuery, ref field); //isUploaded = field != null ? true : false;
                    if (int.Parse(field.ToString()) > 0)
                    {
                        deviceData.DisableOrganization = true;
                    }

                }

                deviceData.PurchaseDate = deviceData.PurchaseDate == default(DateTime) ? null : deviceData.PurchaseDate;
                deviceData.WarrantyExpiry = deviceData.PurchaseDate == default(DateTime) ? null : deviceData.WarrantyExpiry;
                if (result == GlobalErrors.Success)
                {
                    var dBHelperText = new DBHelper<TextLanguage>();
                    sqlQuery = string.Format(@"Select * from DeviceLanguage where Serial = '{0}'", deviceSerial);
                    result = dBHelperText.GetQueryList(sqlQuery, ref textLanguageList);

                    if (result == GlobalErrors.Success)
                        deviceData.TextLanguage = textLanguageList;

                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDevice(string deviceSerial, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Empty;
                object field = 0;
                dbHelper.BeginTransaction();

                sqlQuery = string.Format(@"select Count(*) from SyncHistory  where DeviceSerial = '{0}'", deviceSerial);
                result = dbHelper.ExecuteScalar(sqlQuery, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (int.Parse(field.ToString()) > 0)
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_You_Cannot_Delete_Used_Device;
                    }
                }



                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"select Count(*) from RouteHistory where DeviceSerial = '{0}'", deviceSerial);
                    result = dbHelper.ExecuteScalar(sqlQuery, ref field);
                    if (int.Parse(field.ToString()) > 0)
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_You_Cannot_Delete_Used_Device;
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"select Count(*) from EmployeeDevice where DeviceSerial = '{0}'", deviceSerial);
                    result = dbHelper.ExecuteScalar(sqlQuery, ref field);
                    if (int.Parse(field.ToString()) > 0)
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_You_Cannot_Delete_Device_Linked_To_An_Employee;
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    sqlQuery = string.Format(@"Delete from DeviceLanguage where Serial='{0}'", deviceSerial);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);

                    if (result == GlobalErrors.Success)
                    {
                        sqlQuery = string.Format(@"Delete from Device where Serial='{0}'", deviceSerial);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(sqlQuery);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;

        }
        public GlobalErrors ActivateDeactivateDevice(string deviceSerial, bool isActivate)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string sqlQuery = string.Empty;
                object field = 0;
                dbHelper.BeginTransaction();

                sqlQuery = string.Format(@"update Device set Inactive = {1} where Serial = '{0}'", deviceSerial, isActivate ? "0" : "1");
                result = dbHelper.ExecuteNonQuery(sqlQuery);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;

        }
        public GlobalErrors GetDriverID(int truckId, ref int driverId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(truckId > 0 && dBHelper != null)
                {
                    string query = $@"Select DriverID from DriverTruck 
                    Inner join Warehouse on DriverTruck.TruckID = Warehouse.WarehouseID
                    where Warehouse.WarehouseID = {truckId} and Warehouse.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) ";
                    result = dBHelper.GetQuerySingle(query, ref driverId);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetCRMMenus(DBHelper<CRMMenuModel> menu_dbHelper, ref List<CRMMenuModel> teleRepMenus, OperatorModel operatorModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (menu_dbHelper == null)
                {
                    menu_dbHelper = new DBHelper<CRMMenuModel>();
                }
                teleRepMenus = new List<CRMMenuModel>();
                string allMenusQuery = string.Format(@"select distinct CRMMenus.*
                from CRMMenus
                INNER JOIN TeleRepCRMMenus on TeleRepCRMMenus.MenuID = CRMMenus.MenuID ");
                result = menu_dbHelper.GetQueryList(allMenusQuery, ref teleRepMenus);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        //public string GetEmployeeSecurityGroupAccessString(int employeeId)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        List<int> employeeSecurityGroupsList = new List<int>();
        //        DBHelper<int> dBHelper = new DBHelper<int>();
        //        string query = string.Format(@"select OperatorSecurityGroup.SecurityGroupID from Employee
        //        Inner Join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
        //        Inner Join OperatorSecurityGroup on OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID
        //        where Employee.EmployeeID = {0}", employeeId);

        //        result = dBHelper.GetQueryList(query, ref employeeSecurityGroupsList);

        //        if (result == GlobalErrors.Success && employeeSecurityGroupsList != null && employeeSecurityGroupsList.Count > 0)
        //        {
        //            return string.Join(", ", employeeSecurityGroupsList);
        //        }
        //        else
        //        {
        //            return string.Empty;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return string.Empty;
        //    }
        //}

        #region[Chatting]

        public GlobalErrors GetChattingListForAvailableUsersToAdd(EmployeeFilter filter, ref List<EmployeeModel> chattingList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string chattingListAssignmentjoin = string.Empty;
            string supervisedEmployees = string.Empty;
            string employeeTypes = string.Empty;
            string excludeCurrentEmployee = string.Empty;
            string employeeFilter = string.Empty;
            try
            {
                if (filter.EmployeeId != -1 && filter.SecurityGroupId == -1)
                {
                    object obj = null;
                    int employeeTypeId = -1;
                    DBHelper<int> dbhelper = new DBHelper<int>();

                    bool isBOUser = false;
                    string employeeTypeQuery = string.Format(@"select EmployeeTypeID from Employee where EmployeeID = {0} ", filter.EmployeeId);
                    result = dbhelper.ExecuteScalar(employeeTypeQuery, ref obj);
                    if (result == GlobalErrors.Success && obj != null && !string.IsNullOrEmpty(obj.ToString()))
                    {
                        employeeTypeId = int.Parse(obj.ToString());
                    }
                    if (dbhelper != null)
                    {
                        dbhelper.Dispose();
                        dbhelper = null;
                    }
                    if (employeeTypeId == EmployeeTypes.Employee.GetHashCode() || employeeTypeId == EmployeeTypes.SalesManager.GetHashCode() || employeeTypeId == EmployeeTypes.Supervisor.GetHashCode())
                    {
                        isBOUser = true;
                    }
                    if (isBOUser)
                    {
                        employeeTypes = string.Format("{0},{1},{2}", EmployeeTypes.Employee.GetHashCode(), EmployeeTypes.SalesManager.GetHashCode(), EmployeeTypes.Supervisor.GetHashCode());
                    }
                    supervisedEmployees = string.Format(@"AND(Employee.EmployeeID {0})", GetSupervisorAccess());
                    chattingListAssignmentjoin = string.Format(@" LEFT OUTER JOIN ChattingListAssignment addedFirst on addedFirst.FirstUserID = {0} and addedFirst.SecondUserID = EmployeeLanguage.EmployeeID
                        LEFT OUTER JOIN ChattingListAssignment addedSecond on addedSecond.FirstUserID = EmployeeLanguage.EmployeeID and addedSecond.SecondUserID = {0}", filter.EmployeeId);
                    excludeCurrentEmployee = string.Format(@" And(Employee.EmployeeID <> {0}) ", filter.EmployeeId);

                    employeeFilter = string.Format(@"And(addedFirst.SecondUserID is null) 
                        And (addedSecond.FirstUserID is null)");
                }
                else if (filter.EmployeeId == -1 && filter.SecurityGroupId != -1)
                {
                    chattingListAssignmentjoin = string.Format(@" LEFT OUTER JOIN ChattingListAssignment  on ChattingListAssignment.FirstSecurityGroupID = {0} and ChattingListAssignment.FirstUserID = EmployeeLanguage.EmployeeID", filter.SecurityGroupId);
                    employeeFilter = string.Format(@" And(ChattingListAssignment.FirstUserID is null) ");
                }
                else
                {
                    return GlobalErrors.Error;
                }


                DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();
                string query = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName,    
                Employee.EmployeeCode, EmployeeTypeLanguage.Description EmployeeType, Employee.EmployeeTypeID,EmployeeDevice.DeviceSerial,DeviceToken.DeviceToken,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
                EmployeeTypeLanguage.Description EmployeeTypeName
                FROM Employee    
                INNER JOIN EmployeeOrganization ON EmployeeOrganization.EmployeeID = Employee.EmployeeID      
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID 
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID
                LEFT OUTER JOIN EmployeeDevice On EmployeeDevice.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN DeviceToken On DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                {5}
                WHERE (EmployeeTypeLanguage.LanguageID = {0}) 
                AND (EmployeeLanguage.LanguageID = {0}) 
                AND (Employee.OrganizationID IN ({1})) 
                AND (Employee.Inactive = 0 or Employee.Inactive Is Null)
                {2}
                {3}
                {4}",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess, //1
                supervisedEmployees, //2
                excludeCurrentEmployee, //3
                employeeFilter, //4
                chattingListAssignmentjoin //5
                );

                // exclude BO types if selected one is BO user
                //if (!string.IsNullOrEmpty(employeeTypes) && filter.EmployeeId != -1) // exclude BO types if selected one is BO user
                //{
                //    query += string.Format(" AND (Employee.EmployeeTypeID Not In ({0})) ", employeeTypes);
                //}
                query += string.Format(@" ORDER BY Employee.EmployeeCode ");
                result = dBHelper.GetQueryList(query, ref chattingList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetChattingListForAvailableSecurityGroupsToAdd(EmployeeFilter filter, ref List<SecurityGroupModel> chattingList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string chattingListAssignmentjoin = string.Empty;
            string excludeCurrentSecurityGroupId = string.Empty;
            string securityGroupFilter = string.Empty;

            try
            {
                if (filter.EmployeeId != -1 && filter.SecurityGroupId == -1)
                {
                    chattingListAssignmentjoin = string.Format(@" LEFT OUTER JOIN ChattingListAssignment  on ChattingListAssignment.FirstUserID = {0} and ChattingListAssignment.FirstSecurityGroupID = SecurityGroup.SecurityGroupID", filter.EmployeeId);
                    securityGroupFilter = string.Format(@" And(ChattingListAssignment.FirstSecurityGroupID is null)  ");
                }
                else if (filter.EmployeeId == -1 && filter.SecurityGroupId != -1)
                {
                    chattingListAssignmentjoin = string.Format(@" LEFT OUTER JOIN ChattingListAssignment addedFirst on addedFirst.FirstSecurityGroupID = {0} and addedFirst.SecondSecurityGroupID = SecurityGroup.SecurityGroupID
                LEFT OUTER JOIN ChattingListAssignment addedSecond on addedSecond.FirstSecurityGroupID = SecurityGroup.SecurityGroupID and addedSecond.SecondSecurityGroupID = {0} ", filter.SecurityGroupId);
                    excludeCurrentSecurityGroupId = string.Format(@" And(SecurityGroup.SecurityGroupID <> {0})", filter.SecurityGroupId);
                    securityGroupFilter = string.Format(@" And(addedFirst.SecondSecurityGroupID is null) And (addedSecond.FirstSecurityGroupID is null) ");
                }
                else
                {
                    return GlobalErrors.Error;
                }

                DBHelper<SecurityGroupModel> dBHelper = new DBHelper<SecurityGroupModel>();

                string query = string.Format(@" Select distinct SecurityGroup.SecurityGroupID, SecurityGroupLanguage.Description SecurityGroupName,
                IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName
                from  SecurityGroup
                left outer join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID = SecurityGroup.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0} 
                {1} WHERE (SecurityGroup.OrganizationID IN ({2})) {3} {4} ORDER BY SecurityGroup.SecurityGroupID ",
                _requestRepository.LanguageId,
                chattingListAssignmentjoin,
                _requestRepository.CurrentOperator.OrganizationAccess,
                securityGroupFilter,
                excludeCurrentSecurityGroupId
                );
                result = dBHelper.GetQueryList(query, ref chattingList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetChattingListForAddedBeforeUsers(EmployeeFilter filter, ref List<EmployeeModel> addedChattingList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string queryJoin = string.Empty;
            try
            {
                string supervisedEmployees = GetSupervisorAccess();

                if (filter.EmployeeId != -1 && filter.SecurityGroupId == -1)
                {
                    queryJoin = string.Format(@" Inner JOIN ChattingListAssignment on 
                    ChattingListAssignment.FirstUserID = {3} and ChattingListAssignment.SecondUserID = Employee.EmployeeID
                    OR 
                    ChattingListAssignment.FirstUserID = Employee.EmployeeID and ChattingListAssignment.SecondUserID = {3}
                    And Employee.EmployeeID <> {3}

                    WHERE (EmployeeTypeLanguage.LanguageID = {0}) AND (EmployeeLanguage.LanguageID = {0}) AND (Employee.OrganizationID IN ({1})) AND (Employee.Inactive = 0 or Employee.Inactive Is Null)
                    AND (Employee.EmployeeID {2}) ",
                    _requestRepository.LanguageId, //0
                    _requestRepository.CurrentOperator.OrganizationAccess, //1
                    supervisedEmployees, //2
                    filter.EmployeeId //3
                    );
                }
                else if (filter.EmployeeId == -1 && filter.SecurityGroupId != -1)
                {
                    queryJoin = string.Format(@"Inner JOIN ChattingListAssignment on 
                        ChattingListAssignment.FirstSecurityGroupID = {2} and ChattingListAssignment.FirstUserID = Employee.EmployeeID
                        WHERE (EmployeeTypeLanguage.LanguageID = {0}) AND (EmployeeLanguage.LanguageID = {0}) AND (Employee.OrganizationID IN ({1})) AND (Employee.Inactive = 0 or Employee.Inactive Is Null)",
                     _requestRepository.LanguageId, //0
                     _requestRepository.CurrentOperator.OrganizationAccess, //1
                     filter.SecurityGroupId //2
                     );
                }
                else
                {
                    return GlobalErrors.Error;
                }
                DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();

                string query = string.Format(@"SELECT DISTINCT Employee.EmployeeID, EmployeeLanguage.Description EmployeeName,    
                Employee.EmployeeCode, EmployeeTypeLanguage.Description EmployeeType, Employee.EmployeeTypeID,EmployeeDevice.DeviceSerial,DeviceToken.DeviceToken,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
                EmployeeTypeLanguage.Description EmployeeTypeName
                FROM Employee    
                INNER JOIN EmployeeOrganization ON EmployeeOrganization.EmployeeID = Employee.EmployeeID      
                LEFT OUTER JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID 
                LEFT OUTER JOIN EmployeeTypeLanguage ON Employee.EmployeeTypeID = EmployeeTypeLanguage.EmployeeTypeID
                LEFT OUTER JOIN EmployeeDevice On EmployeeDevice.EmployeeID = Employee.EmployeeID
                LEFT OUTER JOIN DeviceToken On DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                {0}", queryJoin);

                query += string.Format(@" ORDER BY Employee.EmployeeCode ");

                result = dBHelper.GetQueryList(query, ref addedChattingList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetChattingListForAddedBeforeSecurityGroups(EmployeeFilter filter, ref List<SecurityGroupModel> addedBeforeSGChattingList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string selectionQuery = string.Empty;
            string query = string.Empty;
            string chattingListAssignmentJoin = string.Empty;
            try
            {
                if (filter.EmployeeId != -1 && filter.SecurityGroupId == -1)
                {
                    chattingListAssignmentJoin = string.Format(@"left outer join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = SecurityGroup.SecurityGroupID
                    left outer join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
                    inner join ChattingListAssignment on
                    ChattingListAssignment.FirstUserID = {0} and  ChattingListAssignment.FirstSecurityGroupID = SecurityGroup.SecurityGroupID", filter.EmployeeId);
                }
                else if (filter.EmployeeId == -1 && filter.SecurityGroupId != -1)
                {
                    chattingListAssignmentJoin = string.Format(@"inner join ChattingListAssignment on
                    ChattingListAssignment.FirstSecurityGroupID = {0} and  ChattingListAssignment.SecondSecurityGroupID = SecurityGroup.SecurityGroupID
                    OR
                    ChattingListAssignment.FirstSecurityGroupID = SecurityGroup.SecurityGroupID and  ChattingListAssignment.SecondSecurityGroupID =  {0}
                    and 
                    SecurityGroup.SecurityGroupID <> {0}", filter.SecurityGroupId);
                }
                else
                {
                    return GlobalErrors.Error;
                }
                DBHelper<SecurityGroupModel> dBHelper = new DBHelper<SecurityGroupModel>();

                query = string.Format(@"Select distinct SecurityGroup.SecurityGroupID, SecurityGroupLanguage.Description SecurityGroupName,
                IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName
                from  SecurityGroup
                left outer join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID = SecurityGroup.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0}
                {1}
                where SecurityGroup.OrganizationID in ({2})
                ",
                _requestRepository.LanguageId, //0
                chattingListAssignmentJoin, //1
                _requestRepository.CurrentOperator.OrganizationAccess //2
                );
                query += string.Format(@" ORDER BY  SecurityGroup.SecurityGroupID");
                result = dBHelper.GetQueryList(query, ref addedBeforeSGChattingList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }
        public GlobalErrors GetAllEmployeePromotion(Promotion promotion , ref List<EmployeeModel> allEmployees)
        {
            allEmployees = new List<EmployeeModel>();
            DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (promotion.AssignToAllCustomers)
                {
                    query = string.Format(@"select distinct EmployeeDevice.EmployeeID,DeviceToken.DeviceToken from Employee
                    INNER JOIN EmployeeDevice on EmployeeDevice.EmployeeID = Employee.EmployeeID
                    INNER JOIN DeviceToken on DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                    inner JOIN RouteHistory on RouteHistory.DeviceSerial = DeviceToken.DeviceSerial and EmployeeDevice.EmployeeID = RouteHistory.EmployeeID and Uploaded = 1
                    Inner join EmployeeOrganization on Employee.EmployeeID = EmployeeOrganization.EmployeeID
                    Inner join CustomerPromotionOrganization on EmployeeOrganization.OrganizationID = CustomerPromotionOrganization.OrganizationID
                    where CustomerPromotionOrganization.PromotionID ={0}", promotion.PromotionId);
                }
                else
                {
                    if (promotion.CustomersList != null && promotion.CustomersList.Count > 0)
                    {
                        query = string.Format(@"select distinct EmployeeDevice.EmployeeID,DeviceToken.DeviceToken from CustomerPromotion
                        INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID =  CustomerPromotion.CustomerID and CustOutTerritory.OutletID = CustomerPromotion.OutletID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
                        INNER JOIN EmployeeDevice on EmployeeDevice.EmployeeID = EmployeeTerritory.EmployeeID
                        INNER JOIN DeviceToken on DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                        inner JOIN RouteHistory on RouteHistory.DeviceSerial = DeviceToken.DeviceSerial and EmployeeTerritory.TerritoryID = RouteHistory.TerritoryID 
                        and EmployeeDevice.EmployeeID = RouteHistory.EmployeeID and Uploaded = 1
                        Inner join EmployeeOrganization on EmployeeOrganization.EmployeeID = EmployeeTerritory.EmployeeID
                        inner join CustomerPromotionOrganization on CustomerPromotionOrganization.OrganizationID = EmployeeOrganization.OrganizationID
                        and CustomerPromotion.PromotionID = CustomerPromotionOrganization.PromotionID
                        where CustomerPromotion.PromotionID = {0}", promotion.PromotionId);
                    }
                    if (promotion.GroupsList != null && promotion.GroupsList.Count > 0)
                    {
                        if (!string.IsNullOrEmpty(query))
                            query += " Union ";
                        query += string.Format(@" select distinct EmployeeDevice.EmployeeID,DeviceToken.DeviceToken from CustomerPromotion
                        inner join CustomerOutletGroup on CustomerPromotion.CustomerGroupID = CustomerOutletGroup.GroupID
                        INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID =  CustomerOutletGroup.CustomerID 
                        and CustOutTerritory.OutletID = CustomerOutletGroup.OutletID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
                        INNER JOIN EmployeeDevice on EmployeeDevice.EmployeeID = EmployeeTerritory.EmployeeID
                        INNER JOIN DeviceToken on DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                        inner JOIN RouteHistory on RouteHistory.DeviceSerial = DeviceToken.DeviceSerial and EmployeeTerritory.TerritoryID = RouteHistory.TerritoryID 
                        and EmployeeDevice.EmployeeID = RouteHistory.EmployeeID and Uploaded = 1
                        Inner join EmployeeOrganization on EmployeeOrganization.EmployeeID = EmployeeTerritory.EmployeeID                        
                        inner join CustomerPromotionOrganization on CustomerPromotionOrganization.OrganizationID = EmployeeOrganization.OrganizationID
                        and CustomerPromotion.PromotionID = CustomerPromotionOrganization.PromotionID
                        where CustomerPromotion.PromotionID = {0}", promotion.PromotionId);

                    }
                    if (promotion.ChannelsList != null && promotion.ChannelsList.Count > 0)
                    {
                        if (!string.IsNullOrEmpty(query))
                            query += " Union ";
                        query += string.Format(@" select distinct EmployeeDevice.EmployeeID,DeviceToken.DeviceToken from CustomerPromotion
                        inner join CustomerGroup on CustomerPromotion.ChannelID = CustomerGroup.ChannelID
                        and CustomerGroup.SubChannelID = CustomerPromotion.SubChannelID
                        inner join CustomerOutletGroup on CustomerGroup.GroupID = CustomerOutletGroup.GroupID
                        INNER JOIN CustOutTerritory on CustOutTerritory.CustomerID =  CustomerOutletGroup.CustomerID 
                        and CustOutTerritory.OutletID = CustomerOutletGroup.OutletID
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID
                        INNER JOIN EmployeeDevice on EmployeeDevice.EmployeeID = EmployeeTerritory.EmployeeID
                        INNER JOIN DeviceToken on DeviceToken.DeviceSerial = EmployeeDevice.DeviceSerial
                        inner JOIN RouteHistory on RouteHistory.DeviceSerial = DeviceToken.DeviceSerial and EmployeeTerritory.TerritoryID = RouteHistory.TerritoryID 
                        and EmployeeDevice.EmployeeID = RouteHistory.EmployeeID and Uploaded = 1
                        Inner join EmployeeOrganization on EmployeeOrganization.EmployeeID = EmployeeTerritory.EmployeeID                        
                        inner join CustomerPromotionOrganization on CustomerPromotionOrganization.OrganizationID = EmployeeOrganization.OrganizationID
                        and CustomerPromotion.PromotionID = CustomerPromotionOrganization.PromotionID
                        where CustomerPromotion.PromotionID = {0}", promotion.PromotionId);
                    }

                }
                    result = dBHelper.GetQueryList(query, ref allEmployees);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allEmployees = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        //public GlobalErrors SaveAddedEmployeesToChattingList(List<ChattingAssignmentModel> assignmentList)
        //{
        //    string sqlStatement = string.Empty;
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        object field = null;
        //        DBHelper<int> dBHelper = new DBHelper<int>();
        //        // Check whether assignment list is for an employee or security group.
        //        if(assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
        //        {
        //            foreach (ChattingAssignmentModel assignment in assignmentList)
        //            {
        //                // Check if currenct user is already added [by another logged in user]
        //                sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
        //                Where (FirstUserID = {0} And SecondUserID =  {1}) OR (FirstUserID = {1} And SecondUserID =  {0})", assignment.SelectedUserId, assignment.AddedUserId);
        //                result = dBHelper.ExecuteScalar(sqlStatement, ref field);
        //                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
        //                {
        //                    if (Convert.ToInt32(field.ToString()) == 0)
        //                    {
        //                        sqlStatement = string.Format(@" Insert into ChattingListAssignment (FirstUserID, SecondUserID,FirstSecurityGroupID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedUserId, assignment.AddedUserId);
        //                        result = dBHelper.ExecuteNonQuery(sqlStatement);
        //                        if (result != GlobalErrors.Success)
        //                            return GlobalErrors.Error;
        //                    }
        //                    else
        //                    {
        //                        // if inserted before , go to next user
        //                        continue;
        //                    }
        //                } 
        //                else
        //                {
        //                    return GlobalErrors.Error;
        //                }
        //            }
        //        } 
        //        else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
        //        {
        //            foreach (ChattingAssignmentModel assignment in assignmentList)
        //            {
        //                // Check if currenct user is already added [by another logged in user]
        //                sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
        //                Where (FirstSecurityGroupID = {0} And FirstUserID = {1})", assignment.SelectedSecurityGroupId, assignment.AddedUserId);
        //                result = dBHelper.ExecuteScalar(sqlStatement, ref field);
        //                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
        //                {
        //                    if (Convert.ToInt32(field.ToString()) == 0)
        //                    {
        //                        sqlStatement = string.Format(@" Insert into ChattingListAssignment (FirstSecurityGroupID, FirstUserID,SecondUserID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedSecurityGroupId, assignment.AddedUserId);
        //                        result = dBHelper.ExecuteNonQuery(sqlStatement);
        //                        if (result != GlobalErrors.Success)
        //                            return GlobalErrors.Error;
        //                    }
        //                    else
        //                    {
        //                        // if inserted before , go to next user
        //                        continue;
        //                    }
        //                }
        //                else
        //                {
        //                    return GlobalErrors.Error;
        //                }
        //            }
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return GlobalErrors.Error;
        //    }
        //    return result;
        //}

        //public GlobalErrors SaveAddedSecurityGroupsToChattingList(List<ChattingAssignmentModel> assignmentList)
        //{
        //     string sqlStatement = string.Empty;
        //     GlobalErrors result = GlobalErrors.NotInitialized;
        //     try
        //     {
        //         object field = null;
        //         DBHelper<int> dBHelper = new DBHelper<int>();

        //         if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
        //         {
        //             foreach (ChattingAssignmentModel assignment in assignmentList)
        //             {
        //                 // Check if currenct Security group is already added [by another logged in user]
        //                 sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
        //                 Where (FirstUserID =  {0} And FirstSecurityGroupID = {1} )",assignment.SelectedUserId,assignment.AddedSecurityGroupId);
        //                 result = dBHelper.ExecuteScalar(sqlStatement, ref field);
        //                 if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
        //                 {
        //                     if (Convert.ToInt32(field.ToString()) == 0)
        //                     {
        //                         sqlStatement = string.Format(@"  Insert into ChattingListAssignment (FirstUserID, FirstSecurityGroupID,SecondUserID,SecondSecurityGroupID) Values ({0}, {1},-1,-1)", assignment.SelectedUserId, assignment.AddedSecurityGroupId);
        //                         result = dBHelper.ExecuteNonQuery(sqlStatement);
        //                         if (result != GlobalErrors.Success)
        //                             return GlobalErrors.Error;
        //                     }
        //                     else
        //                     {
        //                         // if inserted before , go to next user
        //                         continue;
        //                     }
        //                 }
        //                 else
        //                 {
        //                     return GlobalErrors.Error;
        //                 }
        //             }
        //         }
        //         else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
        //         {
        //             foreach (ChattingAssignmentModel assignment in assignmentList)
        //             {
        //                 // Check if currenct Security group is already added [by another logged in user]
        //                 sqlStatement = string.Format(@" Select IsNull(Count(*), 0) InsertedRows From ChattingListAssignment 
        //                 Where (FirstSecurityGroupID = {0} And SecondSecurityGroupID =  {1}) OR (FirstSecurityGroupID = {1} And SecondSecurityGroupID =  {0})", assignment.SelectedSecurityGroupId, assignment.AddedSecurityGroupId);
        //                 result = dBHelper.ExecuteScalar(sqlStatement, ref field);
        //                 if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
        //                 {
        //                     if (Convert.ToInt32(field.ToString()) == 0)
        //                     {
        //                         sqlStatement = string.Format(@"  Insert into ChattingListAssignment (FirstSecurityGroupID, SecondSecurityGroupID, FirstUserID,SecondUserID ) Values ({0}, {1},-1,-1)", assignment.SelectedSecurityGroupId, assignment.AddedSecurityGroupId);
        //                         result = dBHelper.ExecuteNonQuery(sqlStatement);
        //                         if (result != GlobalErrors.Success)
        //                             return GlobalErrors.Error;
        //                     }
        //                     else
        //                     {
        //                         // if inserted before , go to next user
        //                         continue;
        //                     }
        //                 }
        //                 else
        //                 {
        //                     return GlobalErrors.Error;
        //                 }
        //             }
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //         return GlobalErrors.Error;
        //     }
        //     return result;
        //}

        // public GlobalErrors DeleteEmployeesFromChattingList(List<ChattingAssignmentModel> assignmentList)
        // {
        //     string query = string.Empty;
        //     GlobalErrors result = GlobalErrors.NotInitialized;
        //     try
        //     {
        //         var deletedUsers = assignmentList.Select(assignmentList => assignmentList.AddedUserId).ToArray();
        //         var deletedUserIds = string.Join(",", deletedUsers);
        //         DBHelper<int> dBHelper = new DBHelper<int>();

        //         if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
        //         {
        //             query = string.Format(@"Delete From ChattingListAssignment 
        //             Where (FirstUserID = {0} And SecondUserID in ({1})) OR (FirstUserID in ({1}) And SecondUserID =  {0})", assignmentList[0].SelectedUserId, deletedUserIds);
        //             result = dBHelper.ExecuteNonQuery(query);
        //         }
        //         else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
        //         {
        //             query = string.Format(@"Delete From ChattingListAssignment 
        //             Where (FirstSecurityGroupID = {0} And FirstUserID in ({1}))", assignmentList[0].SelectedSecurityGroupId, deletedUserIds);
        //             result = dBHelper.ExecuteNonQuery(query);
        //         }
        //         else
        //         {
        //             return GlobalErrors.Error;
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //         return GlobalErrors.Error;
        //     }
        //     return result;
        // }

        // public GlobalErrors DeleteSecurityGroupsFromChattingList(List<ChattingAssignmentModel> assignmentList)
        // {
        //     string query = string.Empty;
        //     GlobalErrors result = GlobalErrors.NotInitialized;
        //     try
        //     {
        //         var deletedSGs = assignmentList.Select(assignmentList => assignmentList.AddedSecurityGroupId).ToArray();
        //         var deletedSGIds = string.Join(",", deletedSGs);
        //         DBHelper<int> dBHelper = new DBHelper<int>();

        //         if (assignmentList[0].SelectedUserId != -1 && assignmentList[0].SelectedSecurityGroupId == -1)
        //         {
        //             query = string.Format(@"Delete From ChattingListAssignment 
        //             Where (FirstUserID = {0} And FirstSecurityGroupID in ({1}) ) ", assignmentList[0].SelectedUserId, deletedSGIds);
        //             result = dBHelper.ExecuteNonQuery(query);
        //         }
        //         else if (assignmentList[0].SelectedUserId == -1 && assignmentList[0].SelectedSecurityGroupId != -1)
        //         {
        //             query = string.Format(@"Delete From ChattingListAssignment 
        //             Where (FirstSecurityGroupID = {0} And SecondSecurityGroupID in ({1}) OR FirstSecurityGroupID in ({1})  And SecondSecurityGroupID = {0} )", assignmentList[0].SelectedSecurityGroupId, deletedSGIds);
        //             result = dBHelper.ExecuteNonQuery(query);
        //         }
        //         else
        //         {
        //             return GlobalErrors.Error;
        //         }
        //     }
        //     catch (Exception ex)
        //     {
        //         ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //         return GlobalErrors.Error;
        //     }
        //     return result;
        // }

        //public GlobalErrors GetAvailableUsersInChattingAssignment(int employeeId, string employeeSecurityGroupAccess, int languageId, ref List<ChattingUserModel> availableUsers)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

        //        string query = string.Format(@"Select distinct Employee.EmployeeID UserId, EmployeeLanguage.Description UserName ,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then IsNull(LastBOLogin.IsLoggedIn,0) Else IsNull(LastFOLogin.Uploaded,0) End As IsLoggedIn,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then (case when IsNull(LastBOLogin.IsLoggedIn,0) = 1 then 1 else 2 end) Else (case when IsNull(LastFOLogin.Uploaded,0) = 1 then 1 else 2 end) End As Status,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then 1 Else 0 End As IsBOUser,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceToken, '') End As DeviceToken ,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceSerial, '') End As DeviceSerial ,
        //        Case When Employee.EmployeeTypeID in (1,4,5,9) Then '' Else IsNull(LastFOLogin.DeviceName, '') End As DeviceName 
        //        From Employee
        //        inner join EmployeeOperator on EmployeeOperator.EmployeeID = Employee.EmployeeID
        //        left join OperatorSecurityGroup on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
        //        left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}

        //        inner join ChattingListAssignment on 
        //        ChattingListAssignment.FirstUserID = {0} and ChattingListAssignment.SecondUserID = Employee.EmployeeID
        //        or 
        //        ChattingListAssignment.SecondUserID = {0} and ChattingListAssignment.FirstUserID = Employee.EmployeeID
        //        And Employee.EmployeeID <> {0}
        //        or
        //        ChattingListAssignment.FirstUserID = {0} and ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
        //        And Employee.EmployeeID <> {0}
        //        or
        //        ChattingListAssignment.FirstSecurityGroupID in ({2}) and ChattingListAssignment.SecondSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
        //        And Employee.EmployeeID <> {0}
        //        or
        //        ChattingListAssignment.SecondSecurityGroupID in ({2}) and ChattingListAssignment.FirstSecurityGroupID = OperatorSecurityGroup.SecurityGroupID
        //        And Employee.EmployeeID <> {0}
        //        left join (
        //        Select OperatorLoginHistory.OperatorID,OperatorLoginHistory.IsLoggedIn from OperatorLoginHistory
        //        inner join
        //        (Select OperatorID,max(OperatorCounter)OperatorCounter From OperatorLoginHistory group by operatorid)x on x.OperatorID = OperatorLoginHistory.OperatorID and OperatorLoginHistory.OperatorCounter = x.OperatorCounter
        //        )LastBOLogin On LastBOLogin.OperatorID = EmployeeOperator.OperatorID
        //        left Join(
        //        Select RouteHistory.EmployeeID,Uploaded,DeviceToken.DeviceToken,RouteHistory.DeviceSerial,DeviceLanguage.Description DeviceName from RouteHistory
        //        inner join (Select EmployeeID,max(RouteHistoryID)RouteHistoryID From RouteHistory group by EmployeeID)z on z.EmployeeID = RouteHistory.EmployeeID and z.RouteHistoryID = RouteHistory.RouteHistoryID
        //        inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
        //        left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {1}             
        //        )LastFOLogin On LastFOLogin.EmployeeID = Employee.EmployeeID
        //        Order By EmployeeLanguage.Description
        //        ", employeeId, languageId, employeeSecurityGroupAccess);

        //        result = dBHelper.GetQueryList(query, ref availableUsers);

        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return GlobalErrors.Error;
        //    }
        //    return result;
        //}

        //        public GlobalErrors GetUploadedFOUsersInChattingAssignment(int employeeId, bool uploadedOnly, ref List<ChattingUserModel> uploadedFOUsers)
        //        {
        //            string uploadedFilter = string.Empty;
        //            GlobalErrors result = GlobalErrors.NotInitialized;
        //            try
        //            {
        //                string employeeTypes = string.Format("{0},{1},{2}", EmployeeTypes.Employee.GetHashCode(), EmployeeTypes.SalesManager.GetHashCode(), EmployeeTypes.Supervisor.GetHashCode());

        //                if (uploadedOnly)
        //                {
        //                    uploadedFilter = " And (RouteHistory.Uploaded = 1)";
        //                }
        //                DBHelper<ChattingUserModel> dBHelper = new DBHelper<ChattingUserModel>();

        //                string query = string.Format(@" Select Distinct RouteHistory.EmployeeID  UserId, RouteHistory.DeviceSerial, EmployeeLanguage.Description UserName, DeviceLanguage.Description DeviceName, DeviceToken, 
        //                Case When RouteHistory.Uploaded = 1 then 1 else 2 End As  ChattingConnectionStatusValue
        //                From Employee
        //                inner join RouteHistory on RouteHistory.EmployeeID = Employee.EmployeeID
        //                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
        //                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {0}

        //                Inner JOIN ChattingListAssignment on 
        //                ChattingListAssignment.FirstUserID = {1} and ChattingListAssignment.SecondUserID = RouteHistory.EmployeeID
        //                OR 
        //                ChattingListAssignment.FirstUserID = RouteHistory.EmployeeID and ChattingListAssignment.SecondUserID = {1}
        //                And Employee.EmployeeID <> {1}

        //                inner join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
        //                WHERE (Employee.EmployeeTypeID NOT IN ({2})) And (RouteHistory.RouteHistoryID in (
        //                    Select Max(RouteHistoryID)
        //                    From RouteHistory
        //                    group by RouteHistory.EmployeeID))  {3}
        //                Order By EmployeeLanguage.Description",
        //                _requestRepository.LanguageId, //0
        //                employeeId, //1
        //                employeeTypes, //2
        //                uploadedFilter //3
        //                );
        //                string query2 = string.Format(@" Select Distinct Employee.EmployeeID  UserId, RouteHistory.DeviceSerial, EmployeeLanguage.Description UserName, DeviceLanguage.Description DeviceName, DeviceToken, 
        //                Case When RouteHistory.Uploaded = 1 then 1 else 2 End As  ChattingConnectionStatusValue
        //                From Employee
        //                left join RouteHistory on RouteHistory.EmployeeID = Employee.EmployeeID
        //                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = {0}
        //                left join DeviceLanguage on DeviceLanguage.Serial = RouteHistory.DeviceSerial and DeviceLanguage.LanguageID = {0}             
        //                Inner JOIN ChattingListAssignment on 
        //                ChattingListAssignment.FirstUserID = {1} and ChattingListAssignment.SecondUserID = Employee.EmployeeID
        //                OR 
        //                ChattingListAssignment.FirstUserID = Employee.EmployeeID and ChattingListAssignment.SecondUserID = {1}
        //                And Employee.EmployeeID <> {1}
        //                left join DeviceToken on DeviceToken.DeviceSerial = RouteHistory.DeviceSerial
        //                WHERE --(Employee.EmployeeTypeID NOT IN ({2}))
        //               -- And 
        //                ( (RouteHistory.RouteHistoryID in (
        //                Select Max(RouteHistoryID)
        //                From RouteHistory
        //                group by RouteHistory.EmployeeID)) OR RouteHistory.RouteHistoryID IS NULL )
        //                Order By EmployeeLanguage.Description",
        //                _requestRepository.LanguageId, //0
        //                employeeId, //1
        //                employeeTypes, //2
        //                uploadedFilter //3
        //                );

        //                result = dBHelper.GetQueryList(query2, ref uploadedFOUsers);
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //        public GlobalErrors GetChattingHistory(ChattingHistoryModel chatInfo, ref List<ChattingHistoryModel> chattingHistory)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;

        //            string customerFilter = string.Empty;
        //            string outletFilter = string.Empty;
        //            try
        //            {

        //                if (chatInfo.CustomerId != -1)
        //                {
        //                    customerFilter = string.Format(" And (ChattingHistory.CustomerID = {0}) ", chatInfo.CustomerId);
        //                }
        //                if (chatInfo.OutletId != -1)
        //                {
        //                    outletFilter = string.Format(" And (ChattingHistory.OutletID = {0}) ", chatInfo.OutletId);
        //                }
        //                DBHelper<ChattingHistoryModel> dBHelper = new DBHelper<ChattingHistoryModel>();

        //                string query = string.Format(@"Select
        //                --ChattingHistory.*
        //                convert(nvarchar(max),ChattingHistory.MessageID) MessageId ,
        //                ChattingHistory.MessageBody, ChattingHistory.SenderID, ChattingHistory.ReceiverID, ChattingHistory.CustomerID,ChattingHistory.OutletID, ChattingHistory.MessageDate, ChattingHistory.IsRead, ChattingHistory.ReadingDate
        //                , ChattingHistory.SenderName , ChattingHistory.ReceiverName, ChattingHistory.IsMessageReceived
        //                , Customer.CustomerCode As CustomerCode, CustomerOutlet.CustomerCode As OutletCode, CustomerLanguage.Description As CustomerName, CustomerOutletLanguage.Description As OutletName
        //                From ChattingHistory 
        //                Left outer join Customer on Customer.CustomerID = ChattingHistory.CustomerID
        //                Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID And CustomerLanguage.LanguageID = {4}
        //                Left outer join CustomerOutlet on CustomerOutlet.CustomerID = ChattingHistory.CustomerID And CustomerOutlet.OutletID = ChattingHistory.OutletID
        //                Left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID And CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID And CustomerOutletLanguage.LanguageID = {4}
        //                where ((SenderID = {0} and ReceiverID = {1}) or (SenderID = {1} and ReceiverID = {0}) )
        //                {2} {3}
        //                Order By MessageDate",
        //                chatInfo.SenderId,
        //                chatInfo.ReceiverId,
        //                customerFilter,
        //                outletFilter,
        //                _requestRepository.LanguageId);
        //                result = dBHelper.GetQueryList(query, ref chattingHistory);
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //        public GlobalErrors GetChattingCustomers(int employeeId, ref List<CustomerModel> chattingCustomers)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;

        //            try
        //            {
        //                DBHelper<CustomerModel> dBHelper = new DBHelper<CustomerModel>();
        //                string territoryJoin = string.Empty;
        //                if (employeeId != -1)
        //                {
        //                    territoryJoin = string.Format(@" 
        //                    inner join CustOutTerritory on CustOutTerritory.CustomerID = customer.CustomerID
        //                    inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID and EmployeeTerritory.EmployeeID = {0} ", employeeId);
        //                }
        //                string query = string.Format(@"select distinct Customer.CustomerID, Customer.CustomerCode,CustomerLanguage.Description CustomerDescription ,
        //                    IsNull( Customer.CustomerCode , '--') + ' - ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
        //                    from Customer 
        //                    inner join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.LanguageID = 1
        //                    where customer.Inactive <> 1 
        //                    Order By CustomerLanguage.Description", _requestRepository.LanguageId, territoryJoin);
        //                result = dBHelper.GetQueryList(query, ref chattingCustomers);

        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //        public GlobalErrors SaveChattingHistory(ChattingHistoryModel message, bool isBroadCast, DBHelper<int> dBHelper)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;
        //            try
        //            {
        //                string query = string.Format(@"insert into ChattingHistory(MessageID, SenderID, ReceiverID, MessageBody, IsRead, MessageDate, ReadingDate, SenderName, ReceiverName, CustomerID, OutletID) 
        //                values('{0}',{1},{2},'{3}',{4},{5},{6},'{7}','{8}', {9}, {10})",
        //                message.MessageId,
        //                message.SenderId,
        //                message.ReceiverId,
        //                message.MessageBody.Replace("'", "''"),
        //                0, // Message not read yet
        //                LocalUtilities.ParseDateAndTimeToSQL(message.MessageDateTimeModel.Date),
        //                "Null", // Message not read yet
        //                message.SenderName.Replace("'", "''"),
        //                message.ReceiverName.Replace("'", "''"),
        //                message.CustomerId,
        //                message.OutletId
        //                );

        //                if (!isBroadCast && dBHelper == null)
        //                {
        //                    DBHelper<int> dbHelper = new DBHelper<int>();
        //                    result = dbHelper.ExecuteNonQuery(query);
        //                }
        //                else if (isBroadCast && dBHelper != null)
        //                {
        //                    result = dBHelper.ExecuteNonQuery(query);
        //                }
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //        public GlobalErrors SetMessageAsRead(List<ChattingHistoryModel> messages)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;

        //            try
        //            {
        //                DBHelper<int> dbHelper = new DBHelper<int>();
        //                foreach (ChattingHistoryModel message in messages)
        //                {
        //                    string query = string.Format(@" Update ChattingHistory Set ReadingDate = {0}, IsRead = 1 Where MessageID in ('{1}') ", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), message.MessageId);
        //                    result = dbHelper.ExecuteNonQuery(query);
        //                    if(result != GlobalErrors.Success)
        //                    {
        //                        break;
        //                    }
        //                }
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //        public GlobalErrors GetEmployeeUnreadMessages(int employeeId, ref List<ChattingHistoryModel> unreadMessages)
        //        {
        //            GlobalErrors result = GlobalErrors.NotInitialized;

        //            try
        //            {
        //                DBHelper<ChattingHistoryModel> dBHelper = new DBHelper<ChattingHistoryModel>();
        //                string query = string.Format(@"Select  convert(nvarchar(max),ChattingHistory.MessageID) MessageId, SenderID, ReceiverID, MessageBody, IsRead, MessageDate,
        //ReadingDate , SenderName, ReceiverName, IsMessageReceived, CustomerID,OutletID  from ChattingHistory where IsRead = 0 and ReceiverID = {0}", employeeId);
        //                result = dBHelper.GetQueryList(query, ref unreadMessages);
        //            }
        //            catch (Exception ex)
        //            {
        //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //                return GlobalErrors.Error;
        //            }
        //            return result;
        //        }

        //public static async Task<GlobalErrors> SendNotificationWhenUpdatingChattingUsers(ChattingUserModel user, string connectedUserDeviceToken, NotificationTypes notificationType, bool Await)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        if (connectedUserDeviceToken != null && !string.IsNullOrEmpty(LocalUtilities.SonicFONotificationID) && !string.IsNullOrEmpty(LocalUtilities.SonicFONotificationSenderID))
        //        {
        //            var serverKey = string.Format("key ={0}", LocalUtilities.SonicFONotificationID);
        //            var senderId = string.Format("id={0}", LocalUtilities.SonicFONotificationSenderID);

        //            // Data to be sent
        //            var data = new Object();
        //            data = new
        //            {
        //                to = connectedUserDeviceToken,
        //                data = new
        //                {
        //                    type = notificationType.GetHashCode(),
        //                    ChattingUser = user
        //                }
        //            };
        //            var jsonBody = JsonConvert.SerializeObject(data);
        //            using (var httpRequest = new HttpRequestMessage(HttpMethod.Post, "https://fcm.googleapis.com/fcm/send"))
        //            {
        //                httpRequest.Headers.TryAddWithoutValidation("Authorization", serverKey);
        //                httpRequest.Headers.TryAddWithoutValidation("Sender", senderId);
        //                httpRequest.Content = new StringContent(jsonBody, Encoding.UTF8, "application/json");
        //                ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };

        //            }

        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //    }

        //}

        #endregion
        #region [Employee Brands List]
        public GlobalErrors GetEmployeeBrandsListSharedTable(GeneralFilter filter, ref SharedTableResult<EmployeeBrandsModel> employeeBrandsList)
        {
            employeeBrandsList = new SharedTableResult<EmployeeBrandsModel>();
            List<EmployeeBrandsModel> newEmployeeBrandsList = new List<EmployeeBrandsModel>();
            DBHelper<EmployeeBrandsModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmployeeBrandsModel>();
                string searchFilter = "1=1 ";
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter += string.Format(@" and 
                        ((BrandsListLanguage.Description  LIKE '%{0}%') 
                        OR (BrandListCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += string.Format(" And (BrandsListEmployee.EmployeeID = {0}) ", filter.EmployeeId);
                    }
                    if (filter.SecurityGroupId != -1)
                    {
                        searchFilter += string.Format(" And (BrandsListEmployee.SecurityGroupID = {0}) ", filter.SecurityGroupId);
                    }
                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" And (BrandsListOrganization.OrganizationID = {0}) ", filter.OrganizationId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By BrandsList.BrandListID");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }


                string mainQuery = string.Format(@" select distinct 
                BrandsList.BrandListID BrandsListId,IsNull( BrandsListLanguage.Description, '--') EmployeeBrandsName,BrandsList.BrandListCode EmployeeBrandsCode
                from BrandsList 
                left join BrandsListLanguage on BrandsListLanguage.BrandListID = BrandsList.BrandListID and BrandsListLanguage.LanguageID = {0}
                inner join BrandsListOrganization on BrandsList.BrandListID = BrandsListOrganization.BrandListID
                inner join BrandsListDetails on BrandsListDetails.BrandListID = BrandsListDetails.BrandListID
                left join BrandsListEmployee on BrandsListEmployee.BrandListID = BrandsList.BrandListID
                where {1} and BrandsListOrganization.OrganizationId in ({2}) ",
                _requestRepository.LanguageId,
                searchFilter,
                _requestRepository.CurrentOperator.OrganizationAccess
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})d",
                mainQuery);

                string selectionQuery = mainQuery + @$"{orderByFilter}
                OFFSET  {(filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize}
                ROWS
                FETCH NEXT {filter.CustomListFilter.PageSize}
                ROWS ONLY";
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success)
                {
                    employeeBrandsList.TotalItems = 0;
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                    {
                        result = dbHelper.GetQueryList(selectionQuery, ref newEmployeeBrandsList , true);
                        employeeBrandsList.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                    employeeBrandsList.Data = newEmployeeBrandsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                newEmployeeBrandsList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertEmployeeBrandsList(EmployeeBrandsModel brandList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                brandList.BrandsListId = GetMaxID("BrandListID", "BrandsList", dbHelper);
                dbHelper.BeginTransaction();
                string query = string.Format(@"Insert into BrandsList (BrandListID,BrandListCode) values({0},'{1}')",
                brandList.BrandsListId, //0
                brandList.EmployeeBrandsCode.Replace("'", "''") //1
                );
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    foreach (TextLanguage language in brandList.LanguageDescriptions)
                    {
                        query = string.Format(@"insert into BrandsListLanguage (BrandListID,LanguageId,Description) values ({0},{1},'{2}')", brandList.BrandsListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //Save Organizations

                    if (brandList.OrganizationList != null && brandList.OrganizationList.Count > 0)
                    {
                        foreach (OrganizationModel organization in brandList.OrganizationList)
                        {
                            query = string.Format(@"insert into BrandsListOrganization (BrandListID,OrganizationID) values ({0},{1})", brandList.BrandsListId, organization.OrganizationId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    // Save Details
                    if (brandList.Brands != null && brandList.Brands.Count > 0)
                    {
                        foreach (BrandModel brand in brandList.Brands)
                        {
                            query = string.Format(@"insert into BrandsListDetails (BrandListID,BrandID,MinimumNoImages,MaximumNoImages) values ({0},{1},{2},{3})", brandList.BrandsListId, brand.BrandId,brand.MinimumNoImages,brand.MaximumNoImages);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    if (brandList.AllEmployee)
                    {
                        EmployeeModel employee = new EmployeeModel();
                        SecurityGroupModel securityGroup = new SecurityGroupModel();
                        result = InsertBrandsListEmployee(employee, securityGroup, brandList.BrandsListId, true, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else
                    {
                        if (brandList.Employees != null && brandList.Employees.Count > 0)
                        {
                            foreach (EmployeeModel employee in brandList.Employees)
                            {
                                SecurityGroupModel securityGroup = new SecurityGroupModel();
                                result = InsertBrandsListEmployee(employee, securityGroup, brandList.BrandsListId,false, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        //Save applied SecurityGroups
                        if (brandList.SecurityGroups != null && brandList.SecurityGroups.Count > 0)
                        {
                            foreach (SecurityGroupModel securityGroup in brandList.SecurityGroups)
                            {
                                EmployeeModel employee = new EmployeeModel();
                                result = InsertBrandsListEmployee(employee, securityGroup, brandList.BrandsListId, brandList.AllEmployee, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertBrandsListEmployee(EmployeeModel employee, SecurityGroupModel securityGroup, int brandListId, bool allEmployee, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into BrandsListEmployee (BrandListID,EmployeeID,SecurityGroupID,AllEmployee) values ({0},{1},{2},{3})",
                brandListId, employee.EmployeeId, securityGroup.SecurityGroupId, allEmployee ? "1": "0");
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBrandsForEmployeeBrandsList(int brandListID, ref List<BrandModel> brands)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<BrandModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<BrandModel>();
                    query = string.Format(@" Select BrandsListDetails.BrandListID,BrandLanguage.Description BrandName,BrandsListDetails.BrandID,BrandsListDetails.MaximumNoImages,BrandsListDetails.MinimumNoImages
                    from BrandsListDetails   
                    inner join Brand  on Brand .BrandID =BrandsListDetails.BrandID
                    Left join BrandLanguage on BrandLanguage.BrandID = Brand.BrandID and BrandLanguage.LanguageID = {0}                               
                    where BrandsListDetails.BrandListID = {1}",
                    _requestRepository.LanguageId,
                    brandListID);

                result = dbHelper.GetQueryList(query, ref brands);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetBrandsListDescriptions(int brandListId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from BrandsListLanguage
                where BrandsListLanguage.BrandListID={0}", brandListId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBrandsListOrganizations(int brandListId, ref List<OrganizationModel> orginazations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {//accsess
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT Organization.OrganizationID,(Organization.OrganizationCode + ' - ' +OrganizationLanguage.Description) OrganizationCodeName
                FROM BrandsListOrganization 
                INNER JOIN Organization ON BrandsListOrganization.OrganizationID = Organization.OrganizationID and Organization.OrganizationID in ({2}) INNER JOIN
                OrganizationLanguage ON Organization.OrganizationID = OrganizationLanguage.OrganizationID 
                AND OrganizationLanguage.LanguageID = {0}
                WHERE BrandsListOrganization.BrandListID = {1}", _requestRepository.LanguageId, brandListId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref orginazations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBrandListAppliedEmployees(int brandListId, ref List<EmployeeModel> appliedEmployees)
        {
            DBHelper<EmployeeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;
                
                query = string.Format(@" select Employee.EmployeeID , Employee.EmployeeCode ,EmployeeLanguage.Description EmployeeName,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from BrandsListEmployee 
                Inner Join Employee on Employee.EmployeeID =BrandsListEmployee.EmployeeID and Employee.OrganizationID in ({2})
                Inner Join EmployeeLanguage on EmployeeLanguage.EmployeeID = BrandsListEmployee.EmployeeID and EmployeeLanguage.LanguageID ={1}
                where BrandsListEmployee.BrandListID ={0}", brandListId, _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQueryList(query, ref appliedEmployees);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedEmployees = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBrandListAppliedToAllEmployees(int brandListId, ref bool allEmployees)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object feild = null;

            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Format(@"select BrandsListEmployee.AllEmployee from BrandsListEmployee where BrandListID = {0}", brandListId, _requestRepository.LanguageId);
                result = dbHelper.ExecuteScalar(query, ref feild);
                if (result == GlobalErrors.Success && feild != null && feild != DBNull.Value && feild.ToString() != string.Empty)
                {
                    if ((bool)feild)
                        allEmployees = true;
                    else
                        allEmployees = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBrandListAppliedSecurityGroups(int brandListId, ref List<SecurityGroupModel> appliedSecurityGroups)
        {
            DBHelper<SecurityGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SecurityGroupModel>();
                string query = string.Empty;

                query = string.Format(@" select SecurityGroup.SecurityGroupID , IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupName
                from BrandsListEmployee 
                Inner Join SecurityGroup on SecurityGroup.SecurityGroupID =BrandsListEmployee.SecurityGroupID and SecurityGroup.OrganizationID in ({2})
                Left join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID= SecurityGroup.SecurityGroupID and SecurityGroupLanguage.LanguageID = {1}
                where BrandsListEmployee.BrandListID = {0}", brandListId, _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQueryList(query, ref appliedSecurityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedSecurityGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateEmployeeBrandsList(EmployeeBrandsModel brandlist)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"Update BrandsList set BrandListCode='{1}' where BrandListID = {0}",
                brandlist.BrandsListId, //0
                brandlist.EmployeeBrandsCode.Replace("'", "''") //1
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                //Save language
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"Delete From BrandsListLanguage Where BrandListID = {0}", brandlist.BrandsListId);
                    result = dbHelper.ExecuteNonQuery(query);
                    // delete BrandsListDetails
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Delete From BrandsListDetails Where BrandListID = {0}", brandlist.BrandsListId);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                    #region[Delete Brands List Related Data]
                    if (result == GlobalErrors.Success)
                    {
                        // Delete saved  data 
                         result = DeleteEmployeeBrandsListFromRelatedTable("BrandsListOrganization", brandlist, dbHelper);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeleteEmployeeBrandsListFromRelatedTable("BrandsListEmployee", brandlist, dbHelper);
                        }
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = GlobalErrors.Success;
                        }
                    }
                    #endregion
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    foreach (TextLanguage language in brandlist.LanguageDescriptions)
                    {
                        query = string.Format(@"insert into BrandsListLanguage (BrandListID,LanguageId,Description) values ({0},{1},'{2}')", brandlist.BrandsListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    // Save Organization
                    if (brandlist.OrganizationList != null && brandlist.OrganizationList.Count > 0)
                    {
                        foreach (OrganizationModel organization in brandlist.OrganizationList)
                        {
                            query = string.Format(@"insert into BrandsListOrganization (BrandListID,OrganizationID) values ({0},{1})", brandlist.BrandsListId, organization.OrganizationId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    // Save Details
                    if (brandlist.Brands != null && brandlist.Brands.Count > 0)
                    {
                        foreach (BrandModel brand in brandlist.Brands)
                        {
                            query = string.Format(@"insert into BrandsListDetails (BrandListID,BrandID,MinimumNoImages,MaximumNoImages) values ({0},{1},{2},{3})", brandlist.BrandsListId, brand.BrandId,brand.MinimumNoImages, brand.MaximumNoImages);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    if (brandlist.AllEmployee)
                    {
                        EmployeeModel employee = new EmployeeModel();
                        SecurityGroupModel securityGroup = new SecurityGroupModel();
                        result = InsertBrandsListEmployee(employee, securityGroup, brandlist.BrandsListId, true, dbHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else
                    {
                        if (brandlist.Employees != null && brandlist.Employees.Count > 0)
                        {
                            foreach (EmployeeModel employee in brandlist.Employees)
                            {
                                SecurityGroupModel securityGroup = new SecurityGroupModel();
                                result = InsertBrandsListEmployee(employee, securityGroup, brandlist.BrandsListId, false, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        if (brandlist.SecurityGroups != null && brandlist.SecurityGroups.Count > 0)
                        {
                            foreach (SecurityGroupModel securityGroup in brandlist.SecurityGroups)
                            {
                                EmployeeModel employee = new EmployeeModel();
                                result = InsertBrandsListEmployee(employee, securityGroup, brandlist.BrandsListId, false, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        private GlobalErrors DeleteEmployeeBrandsListFromRelatedTable(string tableName, EmployeeBrandsModel brandsObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Empty;
                if (tableName.Equals("BrandsListOrganization"))
                {
                    query = $"DELETE FROM {tableName} WHERE BrandListID = {brandsObj.BrandsListId} and OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (tableName.Equals("BrandsListEmployee"))
                {
                    query = $@"DELETE P FROM {tableName} P
                    inner join EmployeeOrganization CG  on CG.EmployeeID = P.EmployeeID
                    and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                    WHERE BrandListID = {brandsObj.BrandsListId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    query = $@"DELETE FROM {tableName} WHERE BrandListID = {brandsObj.BrandsListId} and AllEmployee = 1";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (tableName.Equals("BrandsListEmployee"))
                {
                    query = $@" DELETE P FROM {tableName} P                               
                                inner join SecurityGroup CG  on CG.SecurityGroupID = P.SecurityGroupID
                                and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                WHERE P.BrandListID = {brandsObj.BrandsListId} ";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteEmployeeBrandsList(int brandListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                //delete BrandsListLanguage
                string query = string.Format(@"Delete From BrandsListLanguage Where BrandListID = {0}", brandListId);
                result = dbHelper.ExecuteNonQuery(query);
                // delete BrandsListDetails
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From BrandsListDetails Where BrandListID = {0}", brandListId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    //delete BrandsList
                    query = string.Format(@"Delete From BrandsList Where BrandListID = {0}", brandListId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From BrandsListOrganization Where BrandListID = {0}", brandListId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                // delete BrandsListEmployee
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From BrandsListEmployee Where BrandListID = {0}", brandListId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsBrandValidToAdd(EmployeeBrandsModel brandsModel, DBHelper<int> dBHelper,ref bool isUsed)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string selection = string.Empty;
            int brandsId = 0;
            string Ids = string.Empty;
            string securityGroupIds = string.Empty;
            string brandsIds = string.Empty;
            EmployeeBrandsModel employeeBrandModel = new EmployeeBrandsModel();
            try 
            {
                DataTable dt = new DataTable();
                if (brandsModel.AllEmployee)
                {
                    selection = string.Format(" and AllEmployee = 1");
                }
                else
                {
                    if (brandsModel.Employees != null && brandsModel.Employees.Count > 0)
                    {
                        foreach(EmployeeModel employee in brandsModel.Employees)
                        {
                            Ids += employee.EmployeeId.ToString() + ',';
                        }
                        selection = string.Format(@" and EmployeeID in ({0})", Ids.TrimEnd(','));
                    }
                    if (brandsModel.SecurityGroups != null && brandsModel.SecurityGroups.Count > 0)
                    {
                        foreach (SecurityGroupModel securityGroup in brandsModel.SecurityGroups)
                        {
                            securityGroupIds += securityGroup.SecurityGroupId.ToString() + ',';
                        }
                        selection = string.Format(" and SecurityGroupID in ({0})", securityGroupIds.TrimEnd(','));
                    }
                }
                if(brandsModel.Brands != null && brandsModel.Brands.Count > 0)
                {
                    foreach (BrandModel brand in brandsModel.Brands)
                    {
                        brandsIds += brand.BrandId.ToString() + ',';
                    }
                    selection = string.Format(" and BrandID in ({0})", brandsIds.TrimEnd(','));
                }

                string query = string.Format(@" select BrandID from BrandsListEmployee 
                inner join BrandsListDetails on BrandsListDetails.BrandListID = BrandsListEmployee.BrandListID
                where 1=1 {0}", selection);
                result = dBHelper.GetQuerySingle(query, ref brandsId);
                if (result == GlobalErrors.Success && brandsId != null)
                {
                    foreach(BrandModel brand in brandsModel.Brands)
                    {
                        if(brand.BrandId == brandsId)
                        {
                            isUsed = true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion

        #region [Employee Calendar]
        public GlobalErrors InsertEmployeeCalendarEvents(EmployeeCalendarModel employeeCalendar,DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                if (!employeeCalendar.ToWeekendDays)
                {
                    employeeCalendar.EventId = GetMaxID("EventID", "CalendarEvents", dbHelper);
                }
                dbHelper.BeginTransaction();
                if (employeeCalendar.Employees != null && employeeCalendar.Employees.Count > 0)
                {
                    foreach (EmployeeModel employee in employeeCalendar.Employees)
                    {
                        string checkQuery = string.Format("SELECT COUNT(*) FROM CalendarEvents WHERE EmployeeID IN ({0},-1) AND Year = {1} AND Month = {2} AND Day = {3}", employee.EmployeeId, employeeCalendar.Year, employeeCalendar.Month, employeeCalendar.Day);
                        object checkObj = null;
                        result = dbHelper.ExecuteScalar(checkQuery, ref checkObj);
                        bool hasRecords = false;
                        if (result == GlobalErrors.Success && checkObj != null)
                        {
                            hasRecords = Convert.ToBoolean(checkObj);
                        }
                        if (result == GlobalErrors.Success && !hasRecords)
                        {
                            string query = string.Format(@"INSERT INTO CalendarEvents (EventID,EventTypeID,EmployeeID,Year,Month,Day,Notes)
                                                     VALUES ({0},{1},{2},{3},{4},{5},'{6}')",
                            employeeCalendar.EventId, //0
                            employeeCalendar.ToWeekendDays? CalendarEventsTypes.Weekend.GetHashCode() :CalendarEventsTypes.Vacation.GetHashCode(), //1
                            employee.EmployeeId,
                            employeeCalendar.Year,
                            employeeCalendar.Month,
                            employeeCalendar.Day,
                            string.IsNullOrEmpty(employeeCalendar.Notes) ? "NULL" : employeeCalendar.Notes.Replace("'", "''").Trim()  //10
                            );
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetEmployeeCalendar(EmployeeCalendarModel employeeCalendar)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            List<DayOfWeek> WeekEndDays = new List<DayOfWeek>();
            try
            {
                dbHelper = new DBHelper<int>();
                object checkObj = null;
                bool hasRecords = false;
                dbHelper.BeginTransaction();
                string checkQuery = string.Format("SELECT COUNT(*) FROM CalendarEvents WHERE EventTypeID = {0} AND Year = {1} AND Month = {2} AND Day >= {3}"
                     , CalendarEventsTypes.Weekend.GetHashCode(), employeeCalendar.Year, employeeCalendar.Month, 1);
                result = dbHelper.ExecuteScalar(checkQuery, ref checkObj);
                if (result != GlobalErrors.Success) return result;
                if (checkObj != DBNull.Value)
                {
                    hasRecords = (Convert.ToInt32(checkObj) == 0 ? false : true);
                }
                if (!hasRecords)
                {
                    employeeCalendar.EventId = GetMaxID("EventID", "CalendarEvents", dbHelper);
                    if (result != GlobalErrors.Success) return result;
                    DateTime currentDate = new DateTime(employeeCalendar.Year, employeeCalendar.Month, 1);
                    if (!string.IsNullOrEmpty(_requestRepository.Configurations.WeekendDays))
                    {
                        string[] days = _requestRepository.Configurations.WeekendDays.Split(',');
                        for (int i = 0; i < days.Length; i++)
                        {
                            int day = int.Parse(days[i]);
                            switch (day)
                            {
                                case 1:
                                    WeekEndDays.Add(DayOfWeek.Sunday);
                                    break;
                                case 2:
                                    WeekEndDays.Add(DayOfWeek.Monday);
                                    break;
                                case 3:
                                    WeekEndDays.Add(DayOfWeek.Tuesday);
                                    break;
                                case 4:
                                    WeekEndDays.Add(DayOfWeek.Wednesday);
                                    break;
                                case 5:
                                    WeekEndDays.Add(DayOfWeek.Thursday);
                                    break;
                                case 6:
                                    WeekEndDays.Add(DayOfWeek.Friday);
                                    break;
                                case 7:
                                    WeekEndDays.Add(DayOfWeek.Saturday);
                                    break;
                            }
                        }
                        while (currentDate.Month == employeeCalendar.Month)
                        {
                            if (WeekEndDays.Contains(currentDate.DayOfWeek))
                            {
                                string deleteQuery = string.Format("DELETE FROM CalendarEvents WHERE Year = {0} AND Month = {1} AND Day = {2}"
                                    , employeeCalendar.Year, employeeCalendar.Month, currentDate.Day);
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                                if (result != GlobalErrors.SuccessWithZeroRowAffected) break;
                                employeeCalendar.Day = currentDate.Day;
                                employeeCalendar.EventTypeId = CalendarEventsTypes.Weekend.GetHashCode();
                                employeeCalendar.Notes = String.Empty;
                                EmployeeModel employee = new EmployeeModel();
                                employeeCalendar.Employees.Add(employee);
                                employeeCalendar.ToWeekendDays = true;
                                result = InsertEmployeeCalendarEvents(employeeCalendar, dbHelper);
                                if (result != GlobalErrors.Success) break;
                            }
                            currentDate = currentDate.AddDays(1);
                        }
                    } 
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetMonthEvents(EmployeeCalendarModel calendarEvent, ref List<EmployeeCalendarModel> monthEvents)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeCalendarModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeCalendarModel>();
                string getQuery = string.Format(@"SELECT CalendarEvents.EventID,CalendarEvents.EventTypeID,CalendarEvents.Day,CalendarEvents.EmployeeID,CalendarEvents.Notes, EmployeeLanguage.EmployeeId, EmployeeLanguage.Description EmployeeName, IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') EmployeeCodeName,
                                                  CalendarEvents.Month,CalendarEvents.Year
                                                  FROM CalendarEvents 
                                                  LEFT JOIN Employee ON CalendarEvents.EmployeeID = Employee.EmployeeID AND Employee.Inactive = 0
                                                  LEFT OUTER JOIN EmployeeLanguage ON CalendarEvents.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {0}
                                                  WHERE Year = {1} AND Month = {2}"
                    , _requestRepository.LanguageId, calendarEvent.Year, calendarEvent.Month);
                result = dbHelper.GetQueryList(getQuery, ref monthEvents);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateEmployeeCalendarEvents(EmployeeCalendarModel employeeCalendar, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                int newEventId = GetMaxID("EventID", "CalendarEvents", dbHelper);
                string updateQuery = string.Format(@"UPDATE CalendarEvents 
                                                              SET EventID = {5}, Notes = '{0}'                                                          
                                                              WHERE EmployeeID = {1}
                                                              AND CAST(Year AS nvarchar(4)) 
                                                              + RIGHT('00' + CAST(Month AS nvarchar(2)),2)
                                                              + RIGHT('00' + CAST(Day AS nvarchar(2)),2) >= '{2}{3}{4}'"
                , employeeCalendar.Notes, employeeCalendar.EmployeeId, employeeCalendar.Year, employeeCalendar.Month.ToString().PadLeft(2, '0'), employeeCalendar.Day.ToString().PadLeft(2, '0'), newEventId);
                result = dbHelper.ExecuteNonQuery(updateQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCalendarEvents(EmployeeCalendarModel calendarEvent)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string selection = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                if(calendarEvent.EventTypeId == CalendarEventsTypes.Weekend.GetHashCode())
                {
                    selection = string.Format(@"AND EventTypeID = {0}", calendarEvent.EventTypeId);
                }
                string query = string.Format(@"DELETE FROM CalendarEvents WHERE Year = {0} AND Month = {1} AND Day = {2} And EmployeeID = {3} {4}", calendarEvent.Year, calendarEvent.Month, calendarEvent.Day,calendarEvent.EmployeeId, selection);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[TeleRep Plan - CRM]
        public GlobalErrors PrepareTablesForTeleRep(int employeeId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null) dBHelper = new DBHelper<int>();
                string query = $@"
                IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'CallPlan_{employeeId}') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
                BEGIN
                CREATE TABLE CallPlan_{employeeId}(
                      [CallPlanID] INT IDENTITY(1,1) NOT NULL ,
                      [Date] DATETIME NOT NULL UNIQUE,

                 CONSTRAINT [aaaaaCallPlan_{employeeId}_PK] PRIMARY KEY CLUSTERED 
                (
                  CallPlanID
                ));
                END
                IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'CallPlanDetail_{employeeId}') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
                BEGIN
                CREATE TABLE CallPlanDetail_{employeeId}(
                      [CallPlanID] INT NOT NULL ,
                      [CustomerID] INT NOT NULL ,
                      [OutletID] INT NOT NULL ,
                      [Sequence] INT NOT NULL ,

                 CONSTRAINT [aaaaaCallPlanDetail_{employeeId}_PK] PRIMARY KEY CLUSTERED 
                (
                  CallPlanID,CustomerID,OutletID
                ));
                END
                ";
                result = dBHelper.ExecuteSQLCommand(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ClearTeleRepCustomers(int employeeId, DBHelper<int> dBHelper) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                string query = $@"
                IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'TeleRepCustomers') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
                BEGIN
                Delete From TeleRepCustomers where EmployeeID = {employeeId}
                END";
                result = dBHelper.ExecuteSQLCommand(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteTablesForTeleRep(int employeeId, DBHelper<int> dBHelper) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"
                IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'CallPlanDetail_{employeeId}') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
                BEGIN
                 DROP TABLE CallPlanDetail_{employeeId}
                END
                IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'CallPlan_{employeeId}') AND OBJECTPROPERTY(id, N'IsUserTable') = 1)
                BEGIN
                 DROP TABLE CallPlan_{employeeId}
                END";
                result = dBHelper.ExecuteSQLCommand(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTeleRepCustomers(int employeeId, ref List<SimpleCustomerModel> customers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SimpleCustomerModel> dBHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = $@"Select Distinct TRC.CustomerID,TRC.OutletID,IsNull( C.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CL.Description  , '--') as CustomerCodeName, C.CustomerCode, Cl.Description CustomerName,
                IsNull( CO.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( COL.Description  , '--') as OutletCodeName
                from TeleRepCustomers TRC
                Inner join Customer C on C.CustomerID = TRC.CustomerID 
                Inner join CustomerOutlet CO on CO.CustomerID = TRC.CustomerID AND CO.OutletID = TRC.OutletID
                {orgAccessJoin}
                LEFT JOIN CustomerLanguage CL on CL.CustomerID = C.CustomerID AND CL.LanguageID = {_requestRepository.LanguageId}
                LEFT JOIN CustomerOutletLanguage COL on COL.CustomerID = TRC.CustomerID  AND COL.OutletID = TRC.OutletID AND COL.LanguageID = {_requestRepository.LanguageId}
                WHERE TRC.EmployeeID = {employeeId}";
                result = dBHelper.GetQueryList(query, ref customers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors FixFutureCallPlansCustomers(int employeeId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                string query = $@"DELETE CPD from CallPlanDetail_{employeeId} CPD
                    INNER JOIN CallPlan_{employeeId} CP on CP.CallPlanID = CPD.CallPlanID
                    LEFT JOIN TeleRepCustomers TRC on TRC.CustomerID = CPD.CustomerID AND TRC.OutletID = CPD.OutletID and TRC.EmployeeID = {employeeId}
                    WHERE TRC.OutletID IS NULL AND CP.Date >= {LocalUtilities.ParseDateToSQLString(DateTime.Now)} ";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success) 
                {
                    query = $@"Update CPD set Sequence = tt.Sequence
                    from CallPlanDetail_{employeeId} CPD
                    INNER JOIN (
	                    Select CPD.CallPlanID,CPD.CustomerID,CPD.OutletID,Sequence = ROW_NUMBER() OVER(Partition by CPD.CallPlanID order by Sequence ASC)
	                    from CallPlanDetail_{employeeId} CPD
	                    INNER JOIN CallPlan_{employeeId} CP on CP.CallPlanID = CPD.CallPlanID
	                    AND CP.Date >= {LocalUtilities.ParseDateToSQLString(DateTime.Now)} 
                    ) tt on tt.CallPlanID = CPD.CallPlanID and tt.CustomerID = CPD.CustomerID and tt.OutletID = CPD.OutletID";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteTeleRepCustomers(int employeeId, DBHelper<int> dBHelper) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "t", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = $@"Delete t From TeleRepCustomers t
                        {orgAccessJoin}
                        Where t.EmployeeId = {employeeId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertTeleRepCustomers(int employeeId, List<SimpleCustomerModel> customers, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                StringBuilder values = new StringBuilder();
                foreach (SimpleCustomerModel customer in customers) 
                {
                    values.Append($" Insert into TeleRepCustomers (EmployeeID,CustomerID,OutletID) VALUES ( {employeeId}, {customer.CustomerId}, {customer.OutletId})");
                }
                string query = $@"{values.ToString().TrimEnd(',')}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTeleRepPlanDetails(int employeeId, DateModel dateModel, int callPlanId,ref List<SimpleCustomerModel> callPlanCustomers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                // USE SCOPED_IDENTITY HERE?
                DBHelper<SimpleCustomerModel> dBHelper = new DBHelper<SimpleCustomerModel>();
                string query = $@"Select distinct  CPD.CallPlanID, CPD.CustomerID, CPD.OutletID, Sequence , C.CustomerCode, Cl.Description CustomerName,
                COL.Description OutletName,
                IsNull(C.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CL.Description , '--') as CustomerCodeName,
                IsNull(CO.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( COL.Description , '--') as OutletCodeName
                from CallPlanDetail_{employeeId} CPD
                INNER JOIN CallPlan_{employeeId} CP on CP.CallPlanId = CPD.CallPlanId
                Inner join Customer C on C.CustomerID = CPD.CustomerID 
                Inner join CustomerOutlet CO on CO.CustomerID = CPD.CustomerID and CO.OutletID = CPD.OutletID
                {orgAccessJoin}
                LEFT JOIN CustomerLanguage CL on CL.CustomerID = C.CustomerID AND CL.LanguageID = {_requestRepository.LanguageId}
                LEFT JOIN CustomerOutletLanguage COL on COL.CustomerID = CO.CustomerID and COL.OutletID = CO.OutletID AND COL.LanguageID = {_requestRepository.LanguageId}
                WHERE CP.Date = {LocalUtilities.ParseDateToSQLString(dateModel.Date)} AND CP.CallPlanID = {callPlanId} order by cpd.Sequence";
                result = dBHelper.GetQueryList(query,ref callPlanCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveTeleRepCallPlanHeader(int employeeId, DateModel dateModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" INSERT INTO CallPlan_{employeeId} (Date) VALUES ({LocalUtilities.ParseDateToSQLString(dateModel.Date)})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveTeleRepCallPlanDetails(int employeeId, int callPlanId, List<SimpleCustomerModel> customers, DBHelper<int> dBHelper) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                StringBuilder values = new StringBuilder();
                foreach (SimpleCustomerModel customer in customers) 
                {
                    values.AppendFormat("({0}, {1}, {2},{3}),",callPlanId,customer.CustomerId,customer.OutletId,customer.Sequence);
                }
                string query = $@"INSERT INTO CallPlanDetail_{employeeId} (CallPlanID, CustomerID, OutletID, Sequence) VALUES {values.ToString().TrimEnd(',')}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteExistingCallPlanWithNoCustomers(int employeeId, int callPlanId,  DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // there may be customers under another organization that the current user does not have access to, so delete if IS NULL.
                string query = $@"Delete cp from CallPlan_{employeeId} cp 
						left join CallPlanDetail_{employeeId} cpd on cp.CallPlanID = cpd.CallPlanID
						where cp.CallPlanID = {callPlanId} and cpd.CallPlanID IS NULL";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCallPlanId(ref int callPlanId , int employeeId, DateModel dateModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null) dBHelper = new DBHelper<int>();
                object field = null;
                string query = $@" Select ISNULL(CallPlanId,-1) From CallPlan_{employeeId} Where Date =  ({LocalUtilities.ParseDateToSQLString(dateModel.Date)})";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) )
                {
                    callPlanId = int.Parse(field.ToString()) > 0 ? int.Parse(field.ToString()) : -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteTeleRepPlansDetailsInEdit(int employeeId, int callPlanId, DateModel dateModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CPD", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = $@"
                Delete CPD From CallPlanDetail_{employeeId} CPD
                INNER JOIN CallPlan_{employeeId} CP ON CP.CallPlanID = CPD.CallPlanID
                {orgAccessJoin}
                WHERE CP.Date = ({LocalUtilities.ParseDateToSQLString(dateModel.Date)}) AND CP.CallPlanId = {callPlanId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTeleRepVisitStatuses(ref List<TeleRepVisitStatusModel> teleRepVisitStatuses)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<TeleRepVisitStatusModel> dBHelper = new DBHelper<TeleRepVisitStatusModel>();
                string query = $@"Select TeleRepVisitStatusLanguage.VisitStatusId , TeleRepVisitStatusLanguage.Description VisitStatusDescription from TeleRepVisitStatusLanguage where LanguageID = {_requestRepository.LanguageId}";
                result = dBHelper.GetQueryList(query, ref teleRepVisitStatuses);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNewGenesysToken(GenesysTokenModel tokenModel)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                var query = $@"Delete From CRMTelerepToken Where EmployeeId = {tokenModel.EmployeeId}; 
                               Insert into CRMTelerepToken (EmployeeId, TokenString, ExpirySeconds, ExpiryDate) Values
                ({tokenModel.EmployeeId}, '{tokenModel.TokenString}', {tokenModel.ExpirySeconds}, {LocalUtilities.ParseDateAndTimeToSQL(tokenModel.ExpiryDate.GetValueOrDefault())})";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                }
            }
            return result;
        }
        public GlobalErrors GetEmployeeGenesysToken(ref GenesysTokenModel tokenModel)
        {
            DBHelper<GenesysTokenModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<GenesysTokenModel>();
                string query = $@"Delete From CRMTelerepToken Where ExpiryDate <= {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}; Select Top 1 * From CRMTelerepToken Where EmployeeId = {_requestRepository.CurrentOperator.EmployeeId} order by ExpiryDate Desc";
                result = dbHelper.GetQuerySingle(query, ref tokenModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                }
            }
            return result;
        }
        #endregion
    }
}