﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using InCube.Security;

namespace Sonic.Web.Core
{
    public class PasswordManager
    {
        private readonly IRequestRepository _requestRepository;
        public PasswordManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public string ReadConfigurationValue(string configName)
        {
            DBHelper<string> dBHelper = null;
            try
            {
                object value = null;
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"select KeyValue from configuration where KeyName='{0}'", configName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref value);
                if (result == GlobalErrors.Success && value != null && !string.IsNullOrEmpty(value.ToString()))
                {
                    return value.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return string.Empty;
        }
        public bool IsStrongPassword(string stringValue, int passwordLength)
        {
            bool isValid = false;
            try
            {

                bool blnResult = true;
                Regex rxRNumeric = new Regex(@"^\S*(?=\S{" + passwordLength.ToString() + @",})(?=\S*[a-z])(?=\S*[A-Z])(?=\S*[\d])(?=\S*[\@\?\%\!\#\$\^\&\*\(\)\{\}\|\[\]\<\>\\\/\\:\;\'\+\=\-\\_])\S*$");
                blnResult = rxRNumeric.IsMatch(stringValue);
                isValid = blnResult;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                isValid = false;
            }
            return isValid;
        }
        public bool IsUsedPassword(string newPassword, int operatorID)
        {
            bool isUsedPassword = false;
            Object field = null;
            DBHelper<string> dbHelper;
            var result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            DataRow[] row;
            try
            {
                string value = "";
                int numberOfUsedPasswords = -1;
                value = ReadConfigurationValue("NumberOfNewPasswordsBeforeReuse");
                if (!string.IsNullOrEmpty(value))
                    numberOfUsedPasswords = int.Parse(value.ToString());
                if (numberOfUsedPasswords != -1)
                {
                    dbHelper = new DBHelper<string>();
                    var query = string.Format(@"SELECT Top {0} * FROM  OperatorPasswordChangeHistory WHERE OperatorID ={1}  
                                          order by PasswordChangeDate desc", numberOfUsedPasswords, operatorID);
                    result = dbHelper.GetQueryDataTable(query, ref dt);
                    if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                    {
                        row = dt.Select(string.Format(" OperatorPassword = '{0}'", EncryptionManager.Instance.EncryptPassword(newPassword)));
                        if (row != null && row.Length > 0)
                        {
                            isUsedPassword = true;
                        }
                        else
                        {
                            isUsedPassword = false;
                        }
                    }
                    if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        isUsedPassword = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsedPassword;
        }
        public bool ValidatePassword(string newPassword, int operatorID, int employeeTypeID, int languageId, ref string errorMessage)
        {

            bool result = true;
            bool configValue = false;
            int passwordLength = 1;
            errorMessage = string.Empty;
            try
            {
                if (employeeTypeID != -1 && employeeTypeID != EmployeeTypes.Deliveryperson.GetHashCode() && employeeTypeID != EmployeeTypes.Presales.GetHashCode()
                     && employeeTypeID != EmployeeTypes.Salesperson.GetHashCode())
                {
                    string value = "";
                    value = ReadConfigurationValue("ForceOperatorStrongPassword");
                    if (!string.IsNullOrEmpty(value))
                    {
                        configValue = Convert.ToBoolean(value);
                    }
                    value = "";
                    value = ReadConfigurationValue("OperatorPasswordLength");
                    if (!int.TryParse(value.ToString(), out passwordLength))
                    {
                        passwordLength = 1;
                    }
                    if (newPassword.Length < passwordLength)
                    {
                        errorMessage = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Length, languageId), passwordLength);
                        return false;
                    }
                    if (configValue && !IsStrongPassword(newPassword, passwordLength))
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Strong_Password, languageId) + "</br>" +
                            ResourcesManager.TranslateKey(MessagesConstants.Desc_Alpha_Numeric, languageId) + "</br>" +
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_AtLeast_6Characters, languageId) + " " + passwordLength + "</br>" +
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_One_Capital, languageId) + "</br>" +
                             ResourcesManager.TranslateKey(MessagesConstants.Desc_One_Small, languageId) + "</br>" +
                              ResourcesManager.TranslateKey(MessagesConstants.Desc_One_Special_Character, languageId);
                        return false;
                    }
                    if (IsUsedPassword(newPassword, operatorID))
                    {
                        errorMessage = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Used_Before, languageId), passwordLength);
                        return false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = false;
            }
            return result;
        }
        public GlobalErrors ChangeOperatorPassword(int operatorID, string newPassword)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format("update operator set OperatorPassword = '{0}' ,UpdatedBy = {1} , UpdatedDate ={2}  where OperatorID = {1}",
                      EncryptionManager.Instance.EncryptPassword(newPassword), operatorID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors RecordPasswordChangeHistory(int operatorID, OperatorProfileModel operatorModel)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            Object count = 0;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format(@"UPDATE Operator SET PasswordChangeDate = {0} WHERE OperatorID= {1}", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), operatorID);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"INSERT INTO OperatorPasswordChangeHistory (operatorID,OperatorName,OperatorPassword,PasswordChangeDate,ChangedBy, MachineName)
                        SELECT {0},OperatorName ,OperatorPassword ,{1} ,{3},'{2}' FROM Operator WHERE Operator.operatorID = {0}",
                        operatorID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), Environment.MachineName, operatorModel.EmployeeId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
    }
}