﻿using Microsoft.AspNetCore.Hosting.Internal;
using Microsoft.AspNetCore.Http;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class ItemManager
    {
        private readonly IRequestRepository _requestRepository;
        public ItemManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        #region [DECLARATIONS]

        private const string selectedColumnsOfItems = @"ItemCode, ItemLanguage.Description as ItemName
            , Item.ItemID , ItemCode + ' - ' + ItemLanguage.Description as ItemCodeName
            , ItemCategoryLanguage.Description Category,ItemCategoryLanguage.ItemCategoryID,BrandLanguage.BrandID,BrandLanguage.Description Brand ,ModelLanguage.Description Model,ModelLanguage.ModelID
            ,Item.PackDefinition ItemDefinition,Item.IsBatchPriced IsBatchPriced,Item.ItemType ItemTypeId,Item.ShelfLifeTime,Item.TemporaryCredit IsTempCredit,Item.IsPriceProtected,Item.IsPowerSKU,Item.IsInitiative IsInitiactive,Item.IsDefaultBatchNo IsDefultBatch,Item.IsPriceProtected,Item.IsNew
            ,Item.ShelfLifeTime,item.Inactive";

        //, isNULL((Select STRING_AGG(PackGroupDetail.PackGroupID, ', ')   FROM PackGroupDetail  WHERE PackGroupDetail.PackID = pack.PackID  ) , '') AS PackGroupIDs

        #endregion [DECLARATIONS]

        #region [ITEM IMAGES]

        public static GlobalErrors FillItemsImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string folderName = "";
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    folderName = "echo\\item";
                }
                else
                {
                    folderName = LocalUtilities.ItemImageFolderPath;
                }
                string newPath = Path.Combine(rootPath, folderName);
                string pathString = Path.Combine(rootPath, folderName);

                //if (Directory.Exists(pathString))
                //{
                //    Directory.Delete(pathString);
                //}
                if (!Directory.Exists(pathString))
                    Directory.CreateDirectory(pathString);

                int count = 0;
                //1. Get Item Images from DB
                result = GetImages(pathString, ImageMode.Items, ref count);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors FillCategoriesImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string folderName = "";
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    folderName = "echo\\category";
                }
                else { folderName = "Resources\\categories-img"; }

                string newPath = Path.Combine(rootPath, folderName);
                string pathString = Path.Combine(rootPath, folderName);

                if (!Directory.Exists(pathString))
                    Directory.CreateDirectory(pathString);


                int count = 0;
                //1. Get Item Category Images from DB
                result = GetImages(pathString, ImageMode.Categories, ref count);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors FillBrandsImages(string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string folderName = "";
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    folderName = "echo\\brand";
                }
                else { folderName = "Resources\\brands-img"; }

                string newPath = Path.Combine(rootPath, folderName);
                string pathString = Path.Combine(rootPath, folderName);

                if (!Directory.Exists(pathString))
                    Directory.CreateDirectory(pathString);


                int count = 0;
                //1. Get Brand Images from DB
                result = GetImages(pathString, ImageMode.Brands, ref count);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool IsPackUsedInTransactions(int packID, DBHelper<int> dBHelper)
        {

            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"select count(*) from (
                select PackID from TransactionDetail where PackID = {packID}
                union all
                select PackID from WhTransDetail where PackID = {packID}
                union all
                select PackID from SalesOrderDetail where PackID = {packID}
                ) c";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public bool IsPackUsedInDiscount(int packID, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@"SELECT Count(*) FROM Discount WHERE packId = {0}", packID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public string getPackGroupName(int groupId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dBHelper = new DBHelper<string>();
            object field = null;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@" select Description from PackGroupLanguage where PackGroupID = {0} and LanguageID = {1} ", groupId, _requestRepository.LanguageId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && field.ToString().Length > 0)
                {
                    return field.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return "";
        }

        public bool IsPackUsedInPromotion(int packID, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@"SELECT Count(*) FROM PromotionOptionDetail 
                    WHERE PromotionOptionDetail.PackId = {0} AND PromotionID NOT IN (SELECT PromotionID FROM Promotion WHERE IsDeleted = 1)", packID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public static bool IsPackLinkedToPackGroup(int packID, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@" SELECT Count(*) FROM PackGroupDetail WHERE PackGroupDetail.PackId = {0} ", packID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public bool IsPackExistingInTheWarehouseStock(int packID, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@" SELECT Count(*) FROM WarehouseStock WHERE PackId = {0} ", packID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public GlobalErrors DeletePack(int packId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM pack where PackId = {0}", packId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    return GlobalErrors.Success;
                else return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public bool IsPackExistingInTheVehicleUploadStock(int packID, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(@" SELECT Count(*) FROM VehicleUploadStock WHERE packId = {0} ", packID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors CheckIfUniqueValue(string tableName, string columnName, string insertedValue, string excludedString, ref bool isUniqueValue)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isUniqueValue = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT Count(*) From {0} Where {1} = '{2}' {3} ",
                tableName, //0
                columnName, //1
                insertedValue.Replace("'", "''"), //2
                excludedString //3
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isUniqueValue = false;
                    }
                    else
                    {
                        isUniqueValue = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private static ImageCodecInfo GetEncoder(ImageFormat format)
        {
            try
            {
                ImageCodecInfo[] codecs = ImageCodecInfo.GetImageDecoders();
                foreach (ImageCodecInfo codec in codecs)
                {
                    if (codec.FormatID == format.Guid)
                        return codec;
                }
                return null;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public static GlobalErrors GetImages(string path, ImageMode imgMode, ref int count)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ImageGeneralModel> dbHelper = null;
            try
            {
                List<ImageGeneralModel> list = new List<ImageGeneralModel>();
                string query = string.Empty;
                string countQuery = string.Empty;
                switch (imgMode)
                {
                    case ImageMode.Items:
                        query = "Select ItemID as ID, Image FROM ItemImage ORDER BY ItemID";
                        countQuery = "Select Count(*) FROM ItemImage ";
                        break;
                    case ImageMode.Categories:
                        query = "Select ItemCategoryID as ID, Image FROM ItemCategoryImage ORDER BY ItemCategoryID";
                        countQuery = "Select Count(*) FROM ItemCategoryImage ";
                        break;
                    case ImageMode.Brands:
                        query = "Select BrandID as ID, Image FROM BrandImage ORDER BY BrandID";
                        countQuery = "Select Count(*) FROM BrandImage ";
                        break;
                    default:
                        return GlobalErrors.Error;
                        break;
                }
                //Get Counts
                DBHelper<int> dBHelperCount = new DBHelper<int>();
                object obj = new object();
                result = dBHelperCount.ExecuteScalar(countQuery, ref obj);
                if (result == GlobalErrors.Success && obj != null && !string.IsNullOrEmpty(obj.ToString().Trim()) && int.Parse(obj.ToString()) > 0)
                {
                    int spliterSize = int.Parse(Math.Ceiling(int.Parse(obj.ToString()) / 25.0).ToString());
                    dbHelper = new DBHelper<ImageGeneralModel>();
                    string pathString = Path.Combine(path);
                    if (Directory.Exists(pathString))
                    {
                        Directory.Delete(pathString, true);
                        System.Threading.Thread.Sleep(500);
                    }
                    Directory.CreateDirectory(pathString);
                    for (int index = 0; index < spliterSize; index++)
                    {
                        result = dbHelper.GetQueryList(string.Format(@"{0} OFFSET {1} ROWS FETCH NEXT {2} ROWS ONLY", query, 25 * index, 25), ref list);
                        if (result == GlobalErrors.Success && list != null)
                        {

                            for (int i = 0; i < list.Count; i++)
                            {
                                try
                                {
                                    if (SaveImageFile(list[i], pathString) == GlobalErrors.Success)
                                    {
                                        count++;
                                    }

                                    //using (var streamBitmap = new MemoryStream(list[i].Image))
                                    //{
                                    //    string fileName = Path.Combine(pathString, list[i].Id + ".png");
                                    //    using (Bitmap newBitmap = new Bitmap(streamBitmap))
                                    //    {
                                    //        newBitmap.Save(fileName, ImageFormat.Png);
                                    //        //ImageCodecInfo jgpEncoder = GetEncoder(ImageFormat.Jpeg);
                                    //        //System.Drawing.Imaging.Encoder myEncoder = System.Drawing.Imaging.Encoder.Quality;
                                    //        //EncoderParameters myEncoderParameters = new EncoderParameters(1);
                                    //        //EncoderParameter myEncoderParameter = new EncoderParameter(myEncoder, 25L);
                                    //        //myEncoderParameters.Param[0] = myEncoderParameter;
                                    //        //newBitmap.Save(fileName, jgpEncoder, myEncoderParameters);
                                    //        count++;
                                    //    }
                                    //}
                                }
                                catch (Exception ex)
                                {
                                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                                }

                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        private static GlobalErrors GetImages(ref List<ItemImageModel> itemImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            itemImages = new List<ItemImageModel>();
            DBHelper<ItemImageModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT ItemImage.*,Item.ItemCode FROM ItemImage 
                                inner join Item on Item.ItemID=ItemImage.ItemID
                                inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                               ");
                dbHelper = new DBHelper<ItemImageModel>();
                result = dbHelper.GetQueryList(query, ref itemImages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        private static GlobalErrors GetCategoryImages(ref List<CategoryImageModel> categoryImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            categoryImages = new List<CategoryImageModel>();
            DBHelper<CategoryImageModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT ItemCategoryImage.*,ItemCategory.ItemCategoryCode FROM ItemCategoryImage 
                                inner join ItemCategory on ItemCategory.ItemCategoryID = ItemCategoryImage.ItemCategoryID 
                               ");
                dbHelper = new DBHelper<CategoryImageModel>();
                result = dbHelper.GetQueryList(query, ref categoryImages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private static GlobalErrors GetBrandImages(ref List<BrandImageModel> brandImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            brandImages = new List<BrandImageModel>();
            DBHelper<BrandImageModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT * FROM BrandImage");
                dbHelper = new DBHelper<BrandImageModel>();
                result = dbHelper.GetQueryList(query, ref brandImages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        #endregion [ITEM IMAGES]

        #region [IMAGES GENERAL]

        public static GlobalErrors SaveImageFile(ImageGeneralModel img, string pathString)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                using (var streamBitmap = new MemoryStream(img.Image))
                {
                    string fileName = Path.Combine(pathString, img.Id + LocalUtilities.ImageExtension);
                    using (Bitmap newBitmap = new Bitmap(streamBitmap))
                    {
                        newBitmap.Save(fileName, ImageFormat.Png);
                        //ImageCodecInfo jgpEncoder = GetEncoder(ImageFormat.Jpeg);
                        //System.Drawing.Imaging.Encoder myEncoder = System.Drawing.Imaging.Encoder.Quality;
                        //EncoderParameters myEncoderParameters = new EncoderParameters(1);
                        //EncoderParameter myEncoderParameter = new EncoderParameter(myEncoder, 25L);
                        //myEncoderParameters.Param[0] = myEncoderParameter;
                        //newBitmap.Save(fileName, jgpEncoder, myEncoderParameters);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors SaveImageFile(IFormFile file, string fileName)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                using (var streamBitmap = new MemoryStream())
                {
                    file.CopyTo(streamBitmap);
                    using (Bitmap newBitmap = new Bitmap(streamBitmap))
                    {
                        newBitmap.Save(fileName, ImageFormat.Png);
                        result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        #endregion [IMAGES GENERAL]

        #region [ITEMS]

        public GlobalErrors SavePackType(PackTypeModel packType, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            try
            {
                string query = "select IsNull(Max(PackTypeId),0) + 1 from PackType";
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    packType.PackTypeId = Int32.Parse(objField.ToString().Trim());
                    if (packType.PackTypeId > 0)
                    {
                        query = string.Format(@"insert into PackType values ({0})", packType.PackTypeId);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SavePackTypeLanguage(PackTypeModel packType, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage textLanguage in packType.DescriptionLanguages)
                {
                    if (textLanguage.Description == null || string.IsNullOrEmpty(textLanguage.Description.Trim()))
                    {
                        textLanguage.Description = packType.PackTypeName;
                    }
                    string sqlStatment = string.Format("INSERT INTO PackTypeLanguage (PackTypeID,LanguageID,Description) Values ({0},{1},'{2}')",
                    packType.PackTypeId,
                    textLanguage.LanguageId,
                    textLanguage.Description.Replace("'", "''").Trim());
                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static int MaxPackID(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            int maxPackID = -1;
            try
            {
                string maxPack = "select IsNull(Max(PackID),0) + 1 from Pack";
                result = dBHelper.ExecuteScalar(maxPack, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    maxPackID = int.Parse(objField.ToString().Trim());
                    if (maxPackID <= 0)
                    {
                        maxPackID = 1;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return maxPackID;
        }

        public bool HasPackGroups(int PackId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            try
            {
                string maxPack = "select count(*) from PackGroupDetail where PackId = " + PackId;
                result = dBHelper.ExecuteScalar(maxPack, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString().Trim()) > 0)
                {
                    return true;
                }
                else
                    return false;
            }
            catch
            {
                return false;
            }
        }

        //public static GlobalErrors saveItemPack(ItemPackWebModel itemPack,ref int ItemID)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    int maxItemID = -1;
        //    int maxPackID = -1;
        //    try
        //    {
        //        DBHelper<int> dBHelper = new DBHelper<int>();
        //        maxItemID =getMaxItemID(dBHelper);
        //        maxPackID = MaxPackID();
        //        result = InsertItem(itemPack, maxItemID, dBHelper);

        //        if (result == GlobalErrors.Success)
        //        {
        //            result = InsertPack(itemPack.PackGroups, maxPackID, maxItemID, dBHelper);

        //        }
        //        return result;
        //    }
        //    catch (Exception ex) {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return GlobalErrors.Error;
        //    }
        //}

        public GlobalErrors GetItemsLazyLoading(GeneralFilter filter, ref SharedTableResult<ItemPackModelSimple> ItemsListTable)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModelSimple> dbHelper = null;
            List<ItemPackModelSimple> ItemsList = new List<ItemPackModelSimple>();
            try
            {
                dbHelper = new DBHelper<ItemPackModelSimple>();

                string searchFilter = string.Empty;
                string contractedFoc = string.Empty;
                string itemsWithUpperLimitFilter = string.Empty;
                string itemExtraInfoSelection = string.Empty;
                string pageOffestFilter = string.Empty;
                string orderByFilter = "Order By sort DESC, ItemCodeName ASC";
                if (filter.CustomListFilter.SortBy != null)
                {
                    if (!filter.CustomListFilter.IsSortAscending)
                    {
                        orderByFilter = "Order By sort DESC,ItemCodeName DESC";
                    }
                }


                string searchClm = string.Empty;
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    //filter.Page = 0;
                    if(filter.IzLazyLodingCombo)
                    orderByFilter = "Order By ExactSearch";
                    searchClm = filter.IzLazyLodingCombo ? string.Format(@" ,Case when Item.ItemCode = '%{0}%' then 0
                    when ItemLanguage.Description = '%{0}%' then 1 when PackTypeLanguage.Description = '%{0}%' then 2 else 3 end as ExactSearch  ", filter.CustomListFilter.SearchFilter.Trim()) : string.Empty;
                    searchFilter = string.Format(@"and ((ItemCode LIKE '%{0}%')
                            or ( ItemLanguage.Description LIKE '%{0}%')
                            or ( PackTypeLanguage.Description LIKE '%{0}%')
                           )", filter.CustomListFilter.SearchFilter.Trim());
                }
                if (filter.DivisionId > 0)
                {
                    searchFilter += string.Format(" and ItemCategory.DivisionId={0}", filter.DivisionId);
                }
                if (!string.IsNullOrEmpty(filter.OrganizationIds))
                {
                    searchFilter += string.Format(@" and Organization.OrganizationID in ({0})", filter.OrganizationIds);
                }
                if (filter.ItemCategoryId > 0)
                {
                    searchFilter += string.Format(" and ItemCategory.ItemCategoryID={0}", filter.ItemCategoryId);
                }
                if (filter.BrandId != -1)
                {
                    searchFilter += string.Format(" and Item.BrandId = {0}", filter.BrandId);
                }
                if (filter.PackTypeId != -1)
                {
                    searchFilter += string.Format(" and Pack.PackTypeID = {0}", filter.PackTypeId);
                }
                if (filter.ExcludeCompetitorItem)
                {
                    searchFilter += string.Format(" and Item.ItemType != {0}", ItemTypes.CompetitorItem.GetHashCode());
                }
                if(filter.ItemId > 0)
                {
                    searchFilter += string.Format(" and Item.ItemId={0}", filter.ItemId);
                }
                if(filter.ShowUpperLimitOnly)
                {
                    itemsWithUpperLimitFilter = string.Format(@" inner JOIN ItemExtraInfo IEI on IEI.ItemID = Item.ItemID AND IEI.AllowCheckUpperLimit = 1");
                    itemExtraInfoSelection = string.Format(@"   IEI.AllowCheckUpperLimit ,");
                }
                if (filter.IsContractedFoc)
                {
                    contractedFoc += string.Format(" ,1 ValueType, 1 DisableValuesUsed");
                }
                if (!filter.GetAllItems)
                {
                    pageOffestFilter = string.Format(@"   OFFSET     {0} ROWS
                                    FETCH NEXT {1} ROWS ONLY", 
                                    filter.IzLazyLodingCombo ? filter.CustomListFilter.Page : (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //0
                                    filter.CustomListFilter.PageSize);
                }
                string mainQuery = string.Format(@"from Item
                                    INNER JOIN ItemLanguage on Item.ItemID = ItemLanguage.ItemID and languageid = {0}
                                    inner join ItemCategory on ItemCategory.ItemCategoryID=Item.ItemCategoryID
                                    inner join division on itemcategory.divisionid = division.DIVISIONID And Division.OrganizationID in ({1}) and Division.DivisionID in ({2})
                                    INNER JOIN Pack on Pack.ItemID = Item.ItemID
                                    INNER JOIN PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                                    INNER JOIN Organization on Organization.OrganizationID = Division.OrganizationID 
                                    {3}
                                    where Inactive = 0 ",
                                    _requestRepository.LanguageId,
                                    _requestRepository.CurrentOperator.OrganizationAccess,
                                    _requestRepository.CurrentOperator.DivisionAccess,
                                    itemsWithUpperLimitFilter);
                string itemsQuery = string.Empty;
                itemsQuery = string.Format(@"select ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq, Item.ItemID , Pack.PackId, ItemCode ,ItemLanguage.Description as ItemName , IsNull(ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( '+ PackTypeLanguage.Description +' ) ' as ItemCodeName
                                     ,PackTypeLanguage.Description Uom, {6} case when Pack.PackID = {5} then 1 else 0 end as sort {4} {7}
                                    {0} {1} {2}     
                                    {3}",
                                    mainQuery, //0
                                    searchFilter,//1
                                    orderByFilter, //2
                                    pageOffestFilter, //3
                                    searchClm, //4
                                    filter.PackId,  //5
                                    itemExtraInfoSelection, //6
                                    contractedFoc //7
                                    );

                var countQuery = string.Format(@"select Count(*) {0} {1}", mainQuery, searchFilter);
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null)
                {
                   result = dbHelper.GetQueryList(itemsQuery, ref ItemsList);
                    ItemsListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    ItemsListTable.Data = ItemsList;
                }
                else
                {
                    return GlobalErrors.Error;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ItemsListTable = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors GetItemGroupLazyLoading(GeneralFilter filter, ref SharedTableResult<ItemGroupModel> ItemGroupListTable)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemGroupModel> dbHelper = null;
            List<ItemGroupModel> ItemGroupList = new List<ItemGroupModel>();
            try
            {
                dbHelper = new DBHelper<ItemGroupModel>();

                string searchFilter = string.Empty;
                string searchClm = string.Empty;
                string orgFilter = string.Empty;

                if (!string.IsNullOrWhiteSpace(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@" and ItemGroupLanguage.Description LIKE '%{0}%'"
                                             , filter.CustomListFilter.SearchFilter.Trim());
                }
                if (!string.IsNullOrEmpty(filter.ItemGroupIdsString)) 
                {
                    searchFilter += $@" AND ItemGroup.ItemGroupID in ({filter.ItemGroupIdsString}) ";
                }
                if (!string.IsNullOrEmpty(filter.OrganizationIds))
                {
                    orgFilter = string.Format(@" and ItemGroupOrganization.OrganizationID in ({0})", filter.OrganizationIds);
                }
                string mainQuery = string.Format(@"from ItemGroup 
                                    left outer join ItemGroupLanguage on ItemGroup.ItemGroupID = ItemGroupLanguage.ItemGroupID  and ItemGroupLanguage.LanguageID = {0} "
                                     , _requestRepository.LanguageId);

                string itemGroupQuery = string.Format(@"select ROW_NUMBER() Over(Order By ItemGroup.ItemGroupID ) AS RowSeq, 
                                    ItemGroup.ItemGroupID ItemGroupId
                                   ,isnull(ItemGroupLanguage.Description,'---')   ItemGroupName,ItemGroup.MasterItemGroupID
                                    from ItemGroup 
                                    left outer join ItemGroupLanguage on ItemGroup.ItemGroupID = ItemGroupLanguage.ItemGroupID  and ItemGroupLanguage.LanguageID = {0}
                                    left outer join ItemGroupOrganization on ItemGroupOrganization.ItemGroupID = ItemGroup.ItemGroupID
                                    where 1=1 {3} {4}
                                    group by  ItemGroup.ItemGroupID,ItemGroupLanguage.Description,ItemGroup.MasterItemGroupID
                                    order by ItemGroup.ItemGroupID 
                                    OFFSET     {1} ROWS
                                    FETCH NEXT {2} ROWS ONLY", _requestRepository.LanguageId,
                                  filter.CustomListFilter.Page, filter.CustomListFilter.PageSize, searchFilter, orgFilter);
                var countQuery = string.Format(@"select Count(*) {0} {1}", mainQuery, searchFilter);
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null)
                {
                    result = dbHelper.GetQueryList(itemGroupQuery, ref ItemGroupList , true);
                    ItemGroupListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    ItemGroupListTable.Data = ItemGroupList;
                }
                else
                {
                    return GlobalErrors.Error;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ItemGroupListTable = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }
        public GlobalErrors GetAllItems(GeneralFilter itemsFilter, ref SharedTableResult<ItemPackModel> itemList, int stockWHID)
        {
            itemList = new SharedTableResult<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                var searchFilter = "";
                var orderByFilter = "";
                var fetchQuery = "";
                var categoryFilter = "";
                var divisionFilter = "";
                var packFilter = "";
                var activeFilter = " and (Item.Inactive =0 or Item.Inactive is null )";
                if (itemsFilter.CustomListFilter != null && !string.IsNullOrEmpty(itemsFilter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(@"and ( (ItemCode LIKE '%{0}%')
                    OR ( ItemLanguage.Description LIKE '%{0}%')
                    OR ( PackTypeLanguage.Description LIKE '%{0}%' )
                   -- OR ( DivisionLanguage.Description LIKE '%{0}%' )
                    )", itemsFilter.CustomListFilter.SearchFilter.Trim());
                }
                if (itemsFilter.CustomListFilter != null && string.IsNullOrEmpty(itemsFilter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By ItemCode");
                }
                else if (itemsFilter.CustomListFilter != null)
                {
                    orderByFilter = string.Format(@"Order By {0} {1} "
                    , itemsFilter.CustomListFilter.SortBy, itemsFilter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }
                else
                {
                    orderByFilter = string.Format(@"Order By ItemLanguage.Description");
                }

                if (itemsFilter.DivisionId > 0)
                {
                    divisionFilter = " and ItemCategory.DivisionID = " + itemsFilter.DivisionId;
                }
                else
                {
                    divisionFilter = string.Format(" and ItemCategory.DivisionID in ({0}) ", _requestRepository.CurrentOperator.DivisionAccess);
                }
                if (itemsFilter.Active)
                {
                    activeFilter = string.Empty;
                }

                if (itemsFilter.ItemCategoryId > 0)
                {
                    categoryFilter = "  and item.ItemCategoryID  = " + itemsFilter.ItemCategoryId;
                }
                if (itemsFilter.ShowPacks)
                {
                    packFilter = string.Format(@"inner join Pack on pack.ItemID=item.ItemID
                                                    inner join PackTypeLanguage on PackTypeLanguage.PackTypeID = pack.PackTypeID and PackTypeLanguage.LanguageID = {0}
                    " + _requestRepository.LanguageId);
                }

                // New configuration
                bool LimitBackEndSalesToWarehouseStock = true;
                string stockLimitJoin = " LEFT OUTER ";
                string stockLimitCondition = string.Empty;
                string stockQtyJoin = string.Empty;
                string whIDCheck = string.Empty;
                if (stockWHID == -1)
                {
                    whIDCheck = "not in (-1)";
                }
                else
                {
                    whIDCheck = string.Format(" in ({0}) ", stockWHID);
                }

                //   if (stockWHID != -1)
                {
                    if (stockWHID != -1 || (itemsFilter.FormProcessMode == ItemFormProcessMode.Sales && LimitBackEndSalesToWarehouseStock))//itemsFilter.FormProcessMode == ItemFormProcessMode.Sales &&
                    {
                        stockLimitJoin = " INNER ";
                        stockLimitCondition = " And (ItemStock.AvailableQtyPCs > 0) ";
                    }

                    stockQtyJoin = string.Format(@" {0} join(
                        select tt.ItemID, sum(tt.AvailableQtyPCs) AvailableQtyPCs from (
                        select pack.ItemID, (pack.Quantity* isNull(WarehouseStock.Quantity,0)) AvailableQtyPCs
                        from pack
                        inner join WarehouseStock on WarehouseStock.PackID = pack.PackID and WarehouseStock.WarehouseID {1}
                        )tt group by tt.ItemID
                        ) ItemStock on ItemStock.ItemID = Item.ItemID {2}",
                        stockLimitJoin,
                        whIDCheck,
                        stockLimitCondition);
                }
                if (itemsFilter.CustomListFilter != null)
                {
                    fetchQuery = string.Format(@"OFFSET     {0} ROWS
                                            FETCH NEXT {1} ROWS ONLY", (itemsFilter.CustomListFilter.Page) * itemsFilter.CustomListFilter.PageSize, itemsFilter.CustomListFilter.PageSize);
                }

                string itemQuery = string.Format(@"SELECT ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq,{4}
                        from ITEM
                        INNER JOIN ITEMLANGUAGE ON ITEMLANGUAGE.ItemID = ITEM.ItemID AND ITEMLANGUAGE.LanguageID = {6}
                        {10}
                        inner join ItemCategory on ItemCategory.ItemCategoryID=item.ItemCategoryID
                        left outer join ItemCategorylanguage on ItemCategory.ItemCategoryID=ItemCategorylanguage.ItemCategoryID and ItemCategorylanguage.languageID = {6}
                        left outer join Brandlanguage on Brandlanguage.BrandID=Item.BrandID and Brandlanguage.languageID = {6}
                        left outer join Modellanguage on Modellanguage.ModelID=Item.ModelID and Modellanguage.languageID = {6}
                        left outer join divisionlanguage on divisionlanguage.divisionid=itemcategory.divisionid and DivisionLanguage.LanguageID = {6}

                        {5}

                        where  (Item.ItemType not in (7,9))
                        {7}
                        {8}
                        {9}
                        {2}
                        {3}
                        {0}
                        {1}
                        "
                        ,
                        fetchQuery,
                        "",
                        searchFilter,
                        orderByFilter,
                        selectedColumnsOfItems,
                        stockQtyJoin,
                        _requestRepository.LanguageId,
                        divisionFilter,
                        categoryFilter,
                        activeFilter,
                        packFilter);

                var countQuery = string.Format(@"select Count(*) from ITEM
                        INNER JOIN ITEMLANGUAGE ON ITEMLANGUAGE.ItemID = ITEM.ItemID AND ITEMLANGUAGE.LanguageID = {2}
				        inner join Pack on pack.ItemID=item.ItemID
				        inner join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID = {2}
				        inner join ItemCategory on ItemCategory.ItemCategoryID=item.ItemCategoryID and ItemCategory.DivisionID in ({3})
				        left outer join divisionlanguage on divisionlanguage.divisionid=itemcategory.divisionid and DivisionLanguage.LanguageID = {2}

                        {0}

                        where  1=1 {1} ",
                        stockQtyJoin,
                        searchFilter,
                        _requestRepository.LanguageId,
                        _requestRepository.CurrentOperator.DivisionAccess);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    itemList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (itemList.TotalItems <= 0)
                    {
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                List<ItemPackModel> items = new List<ItemPackModel>();
                result = dbHelper.GetQueryList(itemQuery, ref items);
                itemList.Data = items;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetItemFromCode(string itemCode, DBHelper<int> main_dbHelper, ref ItemPackModel item)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dBHelper = null;
            try
            {
                if (main_dbHelper == null)
                    dBHelper = new DBHelper<ItemPackModel>();
                else
                    dBHelper = new DBHelper<ItemPackModel>(main_dbHelper.GetConnection(), main_dbHelper.GetDBTransaction());

                string query = string.Format(@"Select * from Item where ItemCode='{0}'", itemCode);
                result = dBHelper.GetQuerySingle(query, ref item);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                item = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors isUOMExists(string packType, DBHelper<int> main_dbHelper, ref bool isExist, ref int packTypeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            isExist = false;
            packTypeID = -1;
            try
            {
                string query = string.Format(@"Select PackTypeID from PackTypeLanguage where Description='{0}'", packType);
                result = main_dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    packTypeID = int.Parse(field.ToString());
                    if (packTypeID != -1)
                        isExist = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors isPackTypeRelatedItem(int itemID, int packTypeID, DBHelper<int> main_dbHelper, ref bool isRelated)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            int count = 0;
            isRelated = false;
            try
            {
                string query = string.Format(@"Select count(*) count from Pack where ItemID = {0} and PackTypeID = {1}", itemID, packTypeID);
                result = main_dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    count = int.Parse(field.ToString());
                    if (count > 0)
                        isRelated = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCategory(int categoryId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete From ItemCategoryLanguage where ItemCategoryID = {0}", categoryId);
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete From ItemCategoryImage where ItemCategoryID = {0}", categoryId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Delete From ItemCategory where ItemCategoryID = {0}", categoryId);
                        result = dBHelper.ExecuteNonQuery(query);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        result = DeleteItemCategoryCustomerApp(categoryId);
                        if (result != GlobalErrors.Success) return result;
                        result = DeletePackCustomerAppByItemCategoryId(categoryId);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDivision(int divisionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM DivisionLanguage where DivisionID = {0}", divisionId);
                result = dBHelper.ExecuteNonQuery(query);

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM EmployeeDivision where DivisionID = {0}", divisionId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"DELETE FROM Division where DivisionID = {0}", divisionId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
            return result;
        }

        public bool IsDivisionLinkedToCustomers(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select * From CustomerOutletDivision WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public bool IsCategoryLinkedToItem(int categoryId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" SELECT Count(ItemCategoryID) FROM Item  WHERE ItemCategoryID = {0} ", categoryId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors GetPacksHierarchy(int customerId, int outletId, ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dBHelper = null;
            try
            {
                ItemPackModel childPack = new ItemPackModel();
                List<ItemPackModel> allPacks = new List<ItemPackModel>();
                dBHelper = new DBHelper<ItemPackModel>();
                string childPackId = string.Empty;
                if (itemPack.ChildPackId != -1)
                    childPackId = string.Format(@" and Pack.PackID = {0}", itemPack.ChildPackId);
                string query = string.Format(@" select Pack.*,PackTypeLanguage.Description uom,pack.Quantity PiecesInPack
,isnull( PackSerialTrimRule.StartTrimDigits,-1)  PackTrimSerialStartDigits,isnull(PackSerialTrimRule.EndTrimDigits,-1) PackTrimSerialEndDigits
from Pack
  left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and LanguageID={0}
Left Outer join PackSerialTrimRule on PackSerialTrimRule.PackID=PAck.PAckID  
where pack.itemId={1} and pack.Quantity<{2} {3} order by pack.Quantity desc"
                , _requestRepository.LanguageId, itemPack.ItemId, itemPack.PiecesInPack, childPackId);
                result = dBHelper.GetQueryList(query, ref allPacks);
                if (result == GlobalErrors.Success && allPacks != null && allPacks.Count > 0)
                {
                    int index = 0;

                    if (allPacks[0].PackTrimSerialStartDigits != -1 || allPacks[0].PackTrimSerialEndDigits != -1)
                    {
                        allPacks[0].PackHasTrimSerialRule = true;
                        if (allPacks[0].PackTrimSerialStartDigits == -1) allPacks[0].PackTrimSerialStartDigits = 0;
                        if (allPacks[0].PackTrimSerialEndDigits == -1) allPacks[0].PackTrimSerialEndDigits = 0;
                    }

                    itemPack.PackQuantityInLevels = itemPack.PiecesInPack / allPacks[0].PiecesInPack;
                    itemPack.ChildPack = allPacks[0];
                    itemPack.ChildPackPrice = GetPackPrice(itemPack.ChildPack.PackId, customerId, outletId);

                    while (allPacks[index].PiecesInPack > 1 && allPacks.Count > index)
                    {
                        index++;
                        if (allPacks[index].PackTrimSerialStartDigits != -1 || allPacks[index].PackTrimSerialEndDigits != -1)
                        {
                            allPacks[index].PackHasTrimSerialRule = true;
                            if (allPacks[index].PackTrimSerialStartDigits == -1) allPacks[index].PackTrimSerialStartDigits = 0;
                            if (allPacks[index].PackTrimSerialEndDigits == -1) allPacks[index].PackTrimSerialEndDigits = 0;
                        }

                        allPacks[index - 1].PackQuantityInLevels = allPacks[index - 1].PiecesInPack / allPacks[index].PiecesInPack;
                        allPacks[index - 1].ChildPack = allPacks[index];
                        allPacks[index - 1].ChildPackPrice = GetPackPrice(allPacks[index].PackId, customerId, outletId);
                    }
                }
                else
                {
                    itemPack.PackQuantityInLevels = 1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public decimal GetPackPrice(int packId, int customerId, int outletId)
        {
            decimal price = 0;
            try
            {
                GeneralFilter filter = new GeneralFilter();
                List<PriceModel> prices = new List<PriceModel>();
                filter.PackId = packId;
                filter.CustomerId = customerId;
                filter.OutletId = outletId;
                GlobalErrors result = GetPriceList(filter, ref prices);
                if (result == GlobalErrors.Success && prices != null && prices.Count > 0)
                {
                    return prices[0].Price;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
            return price;
        }
        public GlobalErrors GetSerialStartAndEndIndexTemplate(DBHelper<int> main_dBHelper, ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                if (main_dBHelper == null)
                    dBHelper = new DBHelper<BarcodeTemplateModel>();
                else
                    dBHelper = new DBHelper<BarcodeTemplateModel>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());

                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @serialSeq  int;
declare @serialFieldLength int;

select @serialSeq=FieldSequence,@serialFieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@serialFieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@serialSeq
"
             , itemPack.TemplateId, BarcodeTemplateFields.Serial.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateSerialsIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.TemplateSerialsIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateSerialsIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetGTINStartAndEndIndexTemplate(ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<BarcodeTemplateModel>();
                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @seq  int;
declare @fieldLength int;

select @seq=fieldSequence,@fieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@fieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@seq
"
             , itemPack.TemplateId, BarcodeTemplateFields.GTIN.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateGTINIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.TemplateGTINIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateGTINIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetGLNStartAndEndIndexTemplate(ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<BarcodeTemplateModel>();
                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @seq  int;
declare @fieldLength int;

select @seq=fieldSequence,@fieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@fieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@seq
"
             , itemPack.TemplateId, BarcodeTemplateFields.GLN.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateGLNIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.TemplateGLNIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateGLNIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetProductionDateStartAndEndIndexTemplate(ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<BarcodeTemplateModel>();
                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @seq  int;
declare @fieldLength int;

select @seq=fieldSequence,@fieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@fieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@seq
"
             , itemPack.TemplateId, BarcodeTemplateFields.ProductionDate.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateProductionDateIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.ProductionIncludedInTemplate = true;
                        itemPack.TemplateProductionDateIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateProductionDateIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBatchNoStartAndEndIndexTemplate(DBHelper<int> main_dBHelper, ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                if (main_dBHelper == null)
                    dBHelper = new DBHelper<BarcodeTemplateModel>();
                else
                    dBHelper = new DBHelper<BarcodeTemplateModel>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());

                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @batchSeq  int;
declare @batchFieldLength int;

select @batchSeq=FieldSequence,@batchFieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@batchFieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@batchSeq
"
             , itemPack.TemplateId, BarcodeTemplateFields.BatchNumber.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateBatchNoIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.TemplateBatchNoIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateBatchNoIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        //public GlobalErrors CheckIfItemTemplateHasProductionDate(ref ItemPackModel itemPack)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    DBHelper<int> dBHelper = null;
        //    try
        //    {
        //        int seq = 0;
        //         dBHelper = new DBHelper<int>();
        //        string query = string.Format(@" select isnull(fieldSequence,-1) from BarcodeTemplateDetails
        //            where TemplateID={0}",itemPack.TemplateId);
        //        result = dBHelper.GetQuerySingle(query, ref seq);
        //        if(result== GlobalErrors.Success && seq > 0)
        //        {
        //            itemPack.ProductionIncludedInTemplate = true;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        result = GlobalErrors.Error;
        //    }
        //    return result;
        //}
        public GlobalErrors GetTotalFieldsLengthOfItemTemplate(DBHelper<int> main_dBHelper, ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                int total = 0;
                if (main_dBHelper == null)
                    dBHelper = new DBHelper<int>();
                else
                    dBHelper = new DBHelper<int>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());

                string query = string.Format(@" select isnull(sum(FieldLength),0) from BarcodeTemplateDetails
                    where TemplateID={0}", itemPack.TemplateId);
                result = dBHelper.GetQuerySingle(query, ref total);
                if (result == GlobalErrors.Success)
                {
                    itemPack.TotalFieldsLengthOfItemTemplate = total;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetExpiryDateStartAndEndIndexTemplate(DBHelper<int> main_dBHelper, ref ItemPackModel itemPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<BarcodeTemplateModel> dBHelper = null;
            try
            {
                if (main_dBHelper == null)
                    dBHelper = new DBHelper<BarcodeTemplateModel>();
                else
                    dBHelper = new DBHelper<BarcodeTemplateModel>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());
                BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                string query = string.Format(@" declare @expirySeq  int;
declare @expiryFieldLength int;

select @expirySeq=FieldSequence,@expiryFieldLength=FieldLength from BarcodeTemplateDetails where TemplateID={0} and FieldID={1}

select (isnull(sum(FieldLength),0)) StartIndex,((isnull(sum(FieldLength),0)-1)+@expiryFieldLength) EndIndex from BarcodeTemplateDetails
where TemplateID={0} and FieldSequence<@expirySeq
", itemPack.TemplateId, BarcodeTemplateFields.ExpiryDate.GetHashCode());
                result = dBHelper.GetQuerySingle(query, ref barcodeTemplate);
                if (result == GlobalErrors.Success && barcodeTemplate != null)
                {
                    itemPack.TemplateExpiryDateIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        itemPack.TemplateExpiryDateIndecies.Add(barcodeTemplate.StartIndex);
                        itemPack.TemplateExpiryDateIndecies.Add(barcodeTemplate.EndIndex);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool IsDivisionLinkedToCustomerAccount(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format("Select count(*) From AccountCustOutDiv WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public GlobalErrors IsDivisionLinkedToCustomerAccount(int customerId, int outletId, int divisionId, ref bool isLinked)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                object field = null;
                isLinked = false;
                string query = string.Format("Select count(*) From AccountCustOutDiv WHERE divisionId = {0} and customerId = {1} and outletId = {2}", divisionId, customerId, outletId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isLinked = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool IsDivisionLinkedToDocumentSequence(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format("Select count(*) From DocumentSequence WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public bool IsDivisionLinkedToAccount(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format("Select count(*) From AccountCustOutDivEmp WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public static bool IsDivisionLinkedToEmployee(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select count(*) From EmployeeDivision WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }

        public GlobalErrors getGroupPacks(int groupID, ref List<PackModel> packs)
        {
            DBHelper<PackModel> dBHelperItems = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelperItems = new DBHelper<PackModel>();
                string queryItemsModel = string.Format(@" Select PackGroupDetail.PackID,IsNull(ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( '+ PackTypeLanguage.Description +' ) ' as ItemCodeName from PackGroupDetail
															 inner join Pack on Pack.PackID = PackGroupDetail.PackID
                                                             inner join Item on Item.ItemID = Pack.ItemID 
                                                             left join ItemLanguage on ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageId = {0} 
                                                             left join PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.PackTypeID and PackTypeLanguage.LanguageID = {0}
                                                             where PackGroupDetail.PackGroupID = {1} ", _requestRepository.LanguageId, groupID);
                result = dBHelperItems.GetQueryList(queryItemsModel, ref packs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllPacks(ref List<PackModel> packs)
        {
            DBHelper<PackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackModel>();
                string itemQuery = string.Format(@"select Pack.PackID,Item.ItemCode PackCode,ItemLanguage.Description PackName from Pack 
                                                    inner join Item on Item.ItemID = Pack.ItemID
                                                    left join ItemLanguage on ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageID = {0}", _requestRepository.LanguageId == 0 ? 1 : _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(itemQuery, ref packs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors deletePackGroup(int groupID, ref string errorMessage)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<string>();

                object field = null;
                List<string> tablesNames = new List<string>();
                string chkQuery = string.Empty;
                string query = string.Empty;
                dbHelper.BeginTransaction();
                chkQuery = string.Format(@"declare @TablesUsedPackGroup table(TableName nvarchar(250));
                                           INSERT INTO @TablesUsedPackGroup (TableName)
                                           (SELECT      TABLE_NAME AS  'TableName'
                                           FROM        INFORMATION_SCHEMA.COLUMNS
                                           WHERE       COLUMN_NAME LIKE '%PackGroupID%' and TABLE_NAME <> 'PackGroup' 
                                           and TABLE_NAME <> 'PackGroupDetail' and TABLE_NAME <> 'PackGroupLanguage'  )
                                           SELECT * FROM @TablesUsedPackGroup");
                result = dbHelper.GetQueryList(chkQuery, ref tablesNames);

                if (tablesNames != null && tablesNames.Count > 0)
                {
                    foreach (var item in tablesNames)
                    {
                        query = string.Format(@"select ISNULL(COUNT(*),0) from {0} where PackGroupID = {1}", item, groupID);
                        result = dbHelper.ExecuteScalar(query, ref field);

                        if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                        {
                            errorMessage = MessagesConstants.Desc_Cannot_delete_used_pack_groups;
                            result = GlobalErrors.Error;
                            break;
                        }
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"UPDATE PackGroup SET IsDeleted = 1 where PackGroupID = {0}", groupID);
                    result = dbHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public static GlobalErrors DeleteItemList(int itemListID, int itemListType, bool oosListMode)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                if (oosListMode)
                {
                    string query = string.Format(@"delete OOSListHeaderLanguage WHERE OOSItemsListID ={0}", itemListID);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format(@"delete from OOSListDetails where OOSItemsListID ={0}", itemListID);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                                query = string.Format(@"delete from OOSListAssignment WHERE OOSItemsListID ={0}", itemListID);
                            else
                                query = string.Format(@"delete from ItemListEmployee where ItemListID ={0}", itemListID);

                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                query = string.Format(@"delete from OOSListOrganization where OOSItemsListID ={0} ", itemListID);
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    query = string.Format(@"DELETE FROM OOSListHeader WHERE OOSItemsListID ={0}", itemListID);
                                    result = dbHelper.ExecuteNonQuery(query);
                                }
                            }
                        }
                    }
                }
                else
                {

                    string query = string.Format(@"delete from ItemsListLanguage where ItemListID ={0}", itemListID);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = string.Format(@"delete from ItemsListDetails where ItemListID ={0}", itemListID);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                                query = string.Format(@"delete from ItemsListAssignment where ItemListID ={0}", itemListID);
                            else
                                query = string.Format(@"delete from ItemListEmployee where ItemListID ={0}", itemListID);

                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                                {
                                    query = string.Format(@"delete from CustomerItemsListOrganization where ItemListID ={0}", itemListID);
                                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                                }
                                query = string.Format(@"delete from ItemsList where ItemListID ={0}", itemListID);
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemGroup(int ItemGroupId,ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
           

           
                    string queryDeleteGroupName = string.Format(@"delete from ItemGroupLanguage where ItemGroupID = {0}", ItemGroupId);
                    string queryDeleteGroupDetails = string.Format(@"delete from ItemGroupDetail where  ItemGroupID = {0}", ItemGroupId);
                    string queryDeleteGroupOrganizations = string.Format(@"delete from ItemGroupOrganization where  ItemGroupID = {0}", ItemGroupId);
                    string deleteItemGroupQuery = string.Format(@"delete ItemGroup where ItemGroupID = {0}", ItemGroupId);

                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupName);
                    if (result == GlobalErrors.Success)
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupDetails);
                    if (result == GlobalErrors.Success)
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupOrganizations);
                    if (result == GlobalErrors.Success)
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteItemGroupQuery);
                


            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public static GlobalErrors AddEditPackGroup(PackGroupModel packGroup)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (packGroup.PackGroupId > 0)
                {
                    string query = string.Format(@"update PackGroup set PackGroupCode = '{1}' ,OrganizationID = {2} where PackGroupID = {0}", packGroup.PackGroupId, packGroup.PackGroupCode, packGroup.OrganizationID);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {

                        string delete = string.Format(@"delete from PackGroupDetail where PackGroupID = {0}", packGroup.PackGroupId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(delete);

                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            foreach (PackModel packs in packGroup.Packs)
                            {
                                string PackGroupDetailQuery = string.Format(@"insert into PackGroupDetail (PackGroupID,PackID) values ({0},{1})", packGroup.PackGroupId, packs.PackId);
                                result = dbHelper.ExecuteNonQuery(PackGroupDetailQuery);
                                if (result != GlobalErrors.Success) break;
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        string PackGroupLanguage = string.Format(@"delete from PackGroupLanguage  where PackGroupID = {0} ", packGroup.PackGroupId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(PackGroupLanguage);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = InsertPackLanguage(packGroup.DescriptionLanguages, packGroup.PackGroupName, packGroup.PackGroupId, dbHelper);
                    }

                }
                else
                {
                    int maxGroupID = getMaxGroupId();
                    string query = string.Format(@"insert into PackGroup (PackGroupID,PackGroupCode,IsDeleted,OrganizationID) values ({0},'{1}',{2},{3})", maxGroupID == -1 ? 1 : maxGroupID, packGroup.PackGroupCode, 0, packGroup.OrganizationID);
                    result = dbHelper.ExecuteNonQuery(query);

                    if (result == GlobalErrors.Success)
                    {
                        foreach (PackModel packs in packGroup.Packs)
                        {
                            string PackGroupDetailQuery = string.Format(@"insert into PackGroupDetail (PackGroupID,PackID) values ({0},{1})", maxGroupID == -1 ? 1 : maxGroupID, packs.PackId);
                            result = dbHelper.ExecuteNonQuery(PackGroupDetailQuery);
                            if (result != GlobalErrors.Success) break;
                        }
                    }

                    if (result == GlobalErrors.Success)
                    {
                        result = InsertPackLanguage(packGroup.DescriptionLanguages, packGroup.PackGroupName, maxGroupID, dbHelper);

                    }
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        private static int getMaxGroupId()
        {
            var result = GlobalErrors.NotInitialized;
            int maxGroupID = -1;
            try
            {
                Object field = null;
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = string.Format(@"select isnull(Max(PackGroupId),0) +1 from PackGroup");
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    maxGroupID = (int)field;
                }
                return maxGroupID;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return maxGroupID;
            }
        }

        private static GlobalErrors InsertPackLanguage(List<TextLanguage> descriptionLanguages, string packGroupName, int packGroupId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (descriptionLanguages != null && descriptionLanguages.Count > 0)
                {
                    foreach (TextLanguage textLanguage in descriptionLanguages)
                    {
                        string query = string.Format(@"insert into PackGroupLanguage (PackGroupID,languageID,Description) values ({0},{1},'{2}')",
                                                    packGroupId,
                                                    textLanguage.LanguageId,
                                                    textLanguage.Description.Equals("") ? packGroupName.Replace("'", "''") : textLanguage.Description.Replace("'", "''")
                                                    );
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors getPackGroups(ref List<PackGroupModel> packGroup, bool getGroupsHavingSamePackQuantity, string selectedOraganizationIds, bool includePacks, DBHelper<PackGroupModel> dBHelper, List<int> allowedPackGroupIds = null)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string orgFilter = string.Empty;
                string groupsHavingSamePackQuantityFilter = string.Empty;
                string packGroupIdsFilter = string.Empty;
                if (_requestRepository.Configurations.ForceOrganizationFilterForPackGroups)
                {
                    orgFilter += string.Format(" And PackGroup.OrganizationID IN ({0})", !string.IsNullOrEmpty(selectedOraganizationIds) ? selectedOraganizationIds : _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (getGroupsHavingSamePackQuantity)
                {
                    groupsHavingSamePackQuantityFilter = @"And PackGroup.PackGroupID in ( select PackGroupID from (
                    select distinct PackGroupDetail.PackGroupID, pack.Quantity
                    from PackGroupDetail
                    inner join Pack on pack.PackID = PackGroupDetail.PackID
                    )tt
                    group by tt.PackGroupID
                    having count(*) = 1 ) ";
                }
                if(allowedPackGroupIds != null && allowedPackGroupIds.Count > 0)
                {
                    string packGroupIdsString = string.Join(",", allowedPackGroupIds);
                    packGroupIdsFilter = $@" and PackGroup.PackGroupId in ({packGroupIdsString})";
                }
                if (dBHelper == null) dBHelper = new DBHelper<PackGroupModel>();
                string query = string.Format(@"select distinct PackGroup.PackGroupId ,PackGroup.PackGroupCode ,PackGroup.OrganizationID,PackGroupLanguage.Description PackGroupName,
                IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName,
                CASE WHEN Prm.CountOfInputPromotion > 0 then 1 else 0 end as HasPromotion, ISNULL(PackGroup.masterPackGroupId,-1) masterPackGroupId
                from PackGroup
                inner join PackGroupDetail on PackGroup.PackGroupID = PackGroupDetail.PackGroupID
                inner join Pack on Pack.PackID = PackGroupDetail.PackID
                inner join Item on Item.ItemID = Pack.ItemID
                left join(
                select count(*) CountOfInputPromotion, PromotionOptionDetail.PackGroupID 
                from PromotionOptionDetail 
                where PromotionOptionDetail.PromotionOptionTypeID = 1 and PromotionOptionDetail.PromotionOptionDetailTypeID = 5
                group by PromotionOptionDetail.PackGroupID
                ) Prm on Prm.PackGroupID = PackGroup.PackGroupID
                Left join PackGroupLanguage on PackGroup.PackGroupID = PackGroupLanguage.PackGroupID And PackGroupLanguage.LanguageID = {0}
                where Item.Inactive = 0 and (PackGroup.IsDeleted <> 1) AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) {1} {2} {3}",
                _requestRepository.LanguageId, //0
                orgFilter, //1
                groupsHavingSamePackQuantityFilter, //2
                packGroupIdsFilter //3
                );
                result = dBHelper.GetQueryList(query, ref packGroup);


                if(result == GlobalErrors.Success && packGroup != null && packGroup.Count > 0 && includePacks)
                {
                    DBHelper<PackModel> dBHelperPacks = new DBHelper<PackModel>();
                    var packs = new List<PackModel>();
                    query = string.Format(@"SELECT P.*,PG.PackGroupID 
                                            FROM PackGroup PG
                                            INNER JOIN PackGroupDetail PGD ON PG.PackGroupID = PGD.PackGroupID
                                            INNER JOIN Pack P ON P.PackID = PGD.PackID
                                            WHERE PG.PackGroupID IN({0})", string.Join(",", packGroup.Select(d => d.PackGroupId).ToList()));
                    result = dBHelperPacks.GetQueryList(query, ref packs);
                    if(result == GlobalErrors.Success && packs != null && packs.Count > 0)
                    {
                        packGroup.Select(c => { c.Packs = packs.Where(x => x.PackGroupID == c.PackGroupId).ToList();  return c; }).ToList();
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                packGroup = null;
            }
            return result;
        }
        public GlobalErrors GetPackGroupsListSharedTable(CustomListFilters filter, ref SharedTableResult<PackGroupModel> sharedTableList)
        {
            DBHelper<PackGroupModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string orgFilter = string.Empty;
                List<PackGroupModel> packGroups = new List<PackGroupModel>();
                dBHelper = new DBHelper<PackGroupModel>();

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ((PackGroup.PackGroupCode LIKE '%{0}%') OR (PackGroupLanguage.Description LIKE '%{0}%'))",
                        filter.SearchFilter.Trim());
                    }
                    if (string.IsNullOrEmpty(filter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By PackGroup.PackGroupCode");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.SortBy,
                        filter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                if (_requestRepository.Configurations.ForceOrganizationFilterForPackGroups)
                {
                    orgFilter += string.Format(" And PackGroup.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                }

                string mainQuery = string.Format(@"select distinct PackGroup.PackGroupId ,PackGroup.PackGroupCode ,PackGroup.OrganizationID,PackGroupLanguage.Description PackGroupName,
                IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName
                from PackGroup
                Left join PackGroupLanguage on PackGroup.PackGroupID = PackGroupLanguage.PackGroupID And PackGroupLanguage.LanguageID = {0}
                where (PackGroup.IsDeleted = 0 or PackGroup.IsDeleted is null) AND (PackGroup.Inactive= 0 or PackGroup.Inactive is null) {1} {2}",
                _requestRepository.LanguageId, //0
                orgFilter, //1
                searchFilter //2
                );

                string selectionQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                 mainQuery, //0
                 orderByFilter, //1
                 (filter.Page) * filter.PageSize, //2
                 filter.PageSize //3
                 );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt",
                mainQuery);

                object objField = 0;
                result = dBHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    sharedTableList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (sharedTableList.TotalItems <= 0)
                    {
                        sharedTableList.Data = packGroups;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dBHelper.GetQueryList(selectionQuery, ref packGroups , true);
                sharedTableList.Data = packGroups;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors checkIfSelectAllItems(int itemListID, ref bool isSelectedAll, bool oosListMode)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string countItemsQuery = string.Empty;
            string countSelectedItemsQuery = string.Empty;
            object countSelectedItems = null;
            try
            {

                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object countItems = null;
                if (oosListMode)
                {
                    countItemsQuery = string.Format(@"select distinct count(*) from OOSListDetails o where  OOSItemsListID = {0}", itemListID);
                    result = dBHelper.ExecuteScalar(countItemsQuery, ref countItems);
                    if (result == GlobalErrors.Success && countItems != null && !string.IsNullOrEmpty(countItems.ToString()))
                    {
                        int.Parse(countItems.ToString());
                    }


                    countSelectedItemsQuery = string.Format(@"SELECT   count(*) FROM Item
                     LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                     INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                     LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                     LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0}       
                     where Item.Inactive = 0 ", _requestRepository.LanguageId);
                    result = dBHelper.ExecuteScalar(countSelectedItemsQuery, ref countSelectedItems);
                    if (result == GlobalErrors.Success && countSelectedItems != null && !string.IsNullOrEmpty(countSelectedItems.ToString()))
                    {
                        int.Parse(countSelectedItems.ToString());
                    }


                }
                else
                {
                    countItemsQuery = string.Format(@"select distinct count(*) from ItemsListDetails o where  ItemListID = {0}", itemListID);
                    result = dBHelper.ExecuteScalar(countItemsQuery, ref countItems);
                    if (result == GlobalErrors.Success && countItems != null && !string.IsNullOrEmpty(countItems.ToString()))
                    {
                        int.Parse(countItems.ToString());
                    }


                    countSelectedItemsQuery = string.Format(@"SELECT   count(*) FROM Item
                     LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                     INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                     LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                     LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0}       
                     where Item.Inactive = 0 ", _requestRepository.LanguageId);
                    result = dBHelper.ExecuteScalar(countSelectedItemsQuery, ref countSelectedItems);
                    if (result == GlobalErrors.Success && countSelectedItems != null && !string.IsNullOrEmpty(countSelectedItems.ToString()))
                    {
                        int.Parse(countSelectedItems.ToString());
                    }
                }

                if (countItems.GetHashCode() == countSelectedItems.GetHashCode())
                {
                    isSelectedAll = true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;

            }
            return result;

        }
        public int MaxSecondaryPackID(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            int maxPackID = -1;
            try
            {
                string maxPack = "select IsNull(Max(SecondaryPackID),0) + 1 from SecondaryPack";
                result = dBHelper.ExecuteScalar(maxPack, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    maxPackID = int.Parse(objField.ToString().Trim());
                    if (maxPackID <= 0)
                    {
                        maxPackID = 1;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return maxPackID;
        }
        public GlobalErrors InsertSecondaryPacksOfItem(int itemId, SecondaryPackModel secondaryPack, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SecondaryPack (SecondaryPackID,ItemID,PackTypeID,Quantity,Barcode)
values ({0},{1},{2},{3},'{4}')", secondaryPack.SecondaryPackId, itemId, secondaryPack.PackTypeId, secondaryPack.Quantity, secondaryPack.Barcode);
                result = dBHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteSecondaryPacksOfItem(int itemId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Delete from SecondaryPack where ItemID={0}", itemId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSecondaryPacks(int itemId, ref List<SecondaryPackModel> secondaryPacks)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<SecondaryPackModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<SecondaryPackModel>();
                query = string.Format(@" select *,PackTypeLanguage.Description PackType from SecondaryPack 
inner join PackTypeLanguage on PackTypeLanguage.PackTypeID=SecondaryPack.PackTypeID 
and LanguageID={1}
where ItemID={0}", itemId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref secondaryPacks);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public bool IsSecondaryPackUsedInOrders(int secondaryPackID, DBHelper<int> dBHelper)
        {

            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" SELECT Count(*)  FROM SalesOrderDetail
                    where SecondaryPackId={0}", secondaryPackID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors checkIfSelectAllItemsInItemGroup(int itemGroupId, ref bool isSelectedAll)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object countSelectedItems = null;
            try
            {
                string countItemsQuery = string.Empty;
                string countSelectedItemsQuery = string.Empty;

                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object countItems = null;

                countItemsQuery = string.Format(@"select distinct count(*) from ItemGroupDetail o where  ItemGroupID = {0}", itemGroupId);
                result = dBHelper.ExecuteScalar(countItemsQuery, ref countItems);
                if (result == GlobalErrors.Success && countItems != null && !string.IsNullOrEmpty(countItems.ToString()))
                {
                    int.Parse(countItems.ToString());
                }


                countSelectedItemsQuery = string.Format(@"SELECT   count(*) FROM Item
                     LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                     INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                     LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                     LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0}       
                     where Item.Inactive = 0 ", _requestRepository.LanguageId);
                result = dBHelper.ExecuteScalar(countSelectedItemsQuery, ref countSelectedItems);
                if (result == GlobalErrors.Success && countSelectedItems != null && !string.IsNullOrEmpty(countSelectedItems.ToString()))
                {
                    int.Parse(countSelectedItems.ToString());
                }

                if (countItems.GetHashCode() == countSelectedItems.GetHashCode())
                {
                    isSelectedAll = true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;

            }
            return result;

        }
        public GlobalErrors getItemsForItemGroup(int itemGroupId, ref List<ItemPackModel> itemsId)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<ItemPackModel>();

                //query = string.Format(@"select I.ItemID ,IL.Description ItemCodeName from ItemGroupDetail IG 
                //  inner join Item I on I.ItemID = IG.ItemID 
                //  left join ItemLanguage IL on IL.ItemID = I.ItemID and IL.LanguageID = {1}
                //   where IG.ItemGroupID = {0}", itemGroupId, _requestRepository.LanguageId);

                query = string.Format(@" Select ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq,
                                              Item.*,ISNULL( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName
                                              from ItemGroupDetail IGD
                                              left join ItemLanguage  on IGD.ItemID = ItemLanguage .ItemID  and ItemLanguage.LanguageID = {0}
                                              inner join Item  on ItemLanguage .ItemID =Item.ItemID
                                              inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID
                                              inner join Division on Division.DivisionID = ItemCategory.DivisionID and Division.OrganizationID IN ({3}) AND Division.DivisionID IN ({4})
                                              INNER JOIN  ItemGroup IG ON IG.ItemGroupID = IGD.ItemGroupID                                             
                                              where IG.ItemGroupID = {1}",
                                             _requestRepository.LanguageId,
                                             itemGroupId,
                                             _requestRepository.CurrentOperator.EmployeeId,
                                             _requestRepository.CurrentOperator.OrganizationAccess,
                                             _requestRepository.CurrentOperator.DivisionAccess
                                             );

                result = dbHelper.GetQueryList(query, ref itemsId);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors getItemsLists(int itemListType, GeneralFilter filter, ref List<ItemListModel> itemLists)
        {
            DBHelper<ItemListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string searchFilter = string.Empty;
            string itemListJoin = "";
            string organizationSelection = string.Empty;
            string organizationJoin = string.Empty;
            string organizationAccess = string.Empty;
            string query = string.Empty;
            try
            {
                dBHelper = new DBHelper<ItemListModel>();
                if (filter != null)
                {
                    if (filter.OOSMode)
                    {
                        if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                        {
                            searchFilter = string.Format(@"and ( (OOSListHeaderLanguage.Description LIKE '%{0}%')
                                  OR ( ItemListCode LIKE '%{0}%') OR (ValidFrom Like '%{0}%') OR (ValidTo Like '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                        }
                        if (!string.IsNullOrEmpty(filter.groupId.ToString()) && filter.groupId > -1)
                        {
                            searchFilter += string.Format(@" And  OOSListAssignment.GroupID ={0}", filter.groupId);
                        }
                        if (!string.IsNullOrEmpty(filter.CustomerId.ToString()) && filter.CustomerId > -1)
                        {
                            searchFilter += string.Format(@" And  OOSListAssignment.CustomerID ={0}", filter.CustomerId);
                        }
                        if (!string.IsNullOrEmpty(filter.OutletId.ToString()) && filter.OutletId > -1)
                        {
                            searchFilter += string.Format(@" And  OOSListAssignment.OutletID ={0}", filter.OutletId);
                        }
                        if (!string.IsNullOrEmpty(filter.EmployeeId.ToString()) && filter.EmployeeId > -1)
                        {
                            searchFilter += string.Format(@" And  OOSListAssignment.EmployeeID ={0}", filter.EmployeeId);
                        }
                        if (filter.FromToDate != null && filter.FromToDate.Count() > 0)
                        {

                            searchFilter += string.Format(" And  OOSListHeader.ValidFrom <= {1} and  OOSListHeader.ValidTo >= {0}",
                            LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)));
                        }
                        if (!string.IsNullOrEmpty(filter.OrganizationId.ToString()) && filter.OrganizationId > -1)
                        {
                            searchFilter += string.Format(@" And  Organization.OrganizationId ={0}", filter.OrganizationId);
                        }


                        query = string.Format(@"SELECT DISTINCT OOSListHeader.OOSItemsListID ItemListID,
                                OOSListHeader.OOSItemsListCode ItemListCode,
                                OOSListHeader.ValidFrom StartDate,
                                OOSListHeader.ValidTo EndDate,
                                OOSListHeaderLanguage.Description ItemListName,
                                CASE (SELECT COUNT(OrganizationID) AS ItemListID FROM OOSListOrganization WHERE OOSListOrganization.OOSItemsListID = OOSListHeader.OOSItemsListID) 
                                    WHEN 0 THEN '---'
                                    WHEN 1 THEN (select  Organization.OrganizationCode + ' - ' +  OrganizationLanguage.Description  as OrganizationCodeName from Organization inner join OOSListOrganization on Organization.OrganizationID = OOSListOrganization.OrganizationID inner join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0} where OOSItemsListID = OOSListHeader.OOSItemsListID)
                                    ELSE '{2}'
                                    END OrganizationCodeName
                                FROM OOSListHeader
                                LEFT JOIN dbo.OOSListHeaderLanguage ON 
                                OOSListHeader.OOSItemsListID = OOSListHeaderLanguage.OOSItemsListID AND
                                OOSListHeaderLanguage.LanguageID = {0}
                                INNER JOIN dbo.OOSListAssignment ON OOSListAssignment.OOSItemsListID = OOSListHeader.OOSItemsListID
                                INNER JOIN OOSListOrganization on OOSListHeader.OOSItemsListID = OOSListOrganization.OOSItemsListID
                                INNER join Organization on Organization.OrganizationID = OOSListOrganization.OrganizationID 
                                LEFT join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {0}
                                where 2=2 and Organization.OrganizationID in ({3}) {1} ",
                                _requestRepository.LanguageId,//0
                                searchFilter, //1
                                ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organization, _requestRepository.LanguageId),//2
                                _requestRepository.CurrentOperator.OrganizationAccess//3
                                );
                    }
                    else
                    {

                        if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                        {
                            searchFilter = string.Format(@"and ( (ItemsListLanguage.Description LIKE '%{0}%')
                    OR ( ItemListCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                        }
                        if (!string.IsNullOrEmpty(filter.groupId.ToString()) && filter.groupId > -1)
                        {
                            searchFilter += string.Format(@" And  ItemsListAssignment.CustomerGroupID ={0}", filter.groupId);
                        }
                        if (!string.IsNullOrEmpty(filter.CustomerId.ToString()) && filter.CustomerId > -1)
                        {
                            string itemsListAssignmentOutlet = string.Empty;
                            string customerOutletGroupOutlet = string.Empty;
                            if (!string.IsNullOrEmpty(filter.OutletId.ToString()) && filter.OutletId > -1)
                            {
                                itemsListAssignmentOutlet = string.Format(@" AND  ItemsListAssignment.OutletId ={0} ", filter.OutletId);
                                customerOutletGroupOutlet = string.Format(@" AND CustomerOutletGroup.OutletID = {0}", filter.OutletId);
                            }
                            searchFilter += string.Format(@" And ( (ItemsListAssignment.CustomerID ={0} {1} )  OR
                              (ItemsListAssignment.CustomerGroupID in   (select GroupID from CustomerGroup where groupid in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} {2})))
                            OR (ItemsListAssignment.AllCustomers = 1) )
                            ", filter.CustomerId, itemsListAssignmentOutlet, customerOutletGroupOutlet);
                        }
                        if (!string.IsNullOrEmpty(filter.EmployeeId.ToString()) && filter.EmployeeId > -1)
                        {
                            searchFilter += string.Format(@" And  ItemListEmployee.EmployeeId ={0}", filter.EmployeeId);
                        }
                        if (!string.IsNullOrEmpty(filter.OrganizationId.ToString()) && filter.OrganizationId > -1)
                        {
                            searchFilter += string.Format(@" And  Organization.OrganizationId ={0}", filter.OrganizationId);
                        }

                        //if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                        //{
                        //    orderByFilter = string.Format(@"Order By tt.StartDate desc");
                        //}
                        //else
                        //{
                        //    if (filter.CustomListFilter.SortBy == "amountString")
                        //        filter.CustomListFilter.SortBy = "amount";
                        //    orderByFilter = string.Format(@"Order By {0} {1} "
                        //    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                        //}


                        if (itemListType == ItemListType.ItemListCustomer.GetHashCode())
                        {
                            itemListJoin = string.Format("Left Join ItemsListAssignment ON ItemsList.ItemListID =ItemsListAssignment.ItemListID ");

                            organizationSelection = string.Format(@", CASE (SELECT COUNT(OrganizationID) AS ItemListID FROM CustomerItemsListOrganization WHERE CustomerItemsListOrganization.ItemListID = ItemsList.ItemListID) 
                                WHEN 0 THEN '---'
                                WHEN 1 THEN (select  Organization.OrganizationCode + ' - ' +  OrganizationLanguage.Description  as OrganizationCodeName from Organization inner join CustomerItemsListOrganization on Organization.OrganizationID = CustomerItemsListOrganization.OrganizationID inner join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0} where ItemListID = ItemsList.ItemListID)
                                ELSE '{1}'
                                END OrganizationCodeName", _requestRepository.LanguageId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organization, _requestRepository.LanguageId));
                            organizationJoin = string.Format(" INNER join CustomerItemsListOrganization on ItemsList.ItemListID = CustomerItemsListOrganization.ItemListID  INNER join Organization on Organization.OrganizationID = CustomerItemsListOrganization.OrganizationID left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                            organizationAccess = string.Format(" and CustomerItemsListOrganization.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                        }
                        else
                            itemListJoin = string.Format("Left Join ItemListEmployee ON ItemsList.ItemListID =ItemListEmployee.ItemListID ");

                        query = string.Format(@"select distinct ItemsList.ItemListID,ItemsList.ItemListCode,ItemsListLanguage.Description ItemListName ,ItemsList.ItemListType {4} 
                        from ItemsListLanguage inner join ItemsList on ItemsListLanguage.ItemListID = ItemsList.ItemListID and LanguageID={0} {1} {5} where ItemsList.ItemListType = {2} {3} {6}",
                        _requestRepository.LanguageId, //0
                        itemListJoin,//1
                        itemListType, //2
                        searchFilter,//3
                        organizationSelection,//4
                        organizationJoin,//5
                        organizationAccess//6
                        );
                    }
                }
                result = dBHelper.GetQueryList(query, ref itemLists , true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                itemLists = null;
            }
            return result;
        }
        public GlobalErrors GetIsAppliedToAllCustomers(int itemListId, ref bool allCustomers, bool oosListMode)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object feild = null;
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"select IsNull(Count(*),0)countt from OOSListAssignment where OOSListAssignment.OOSItemsListID = {0} and AllCustomers = 1", itemListId);
                    result = dbHelper.ExecuteScalar(query, ref feild);
                    if (result == GlobalErrors.Success && feild != null && !string.IsNullOrEmpty(feild.ToString()) && Int32.Parse(feild.ToString()) > 0)
                    {
                        allCustomers = true;
                    }
                }
                else
                {
                    query = string.Format(@"select ItemsListAssignment.AllCustomers from ItemsListAssignment where ItemListID = {0}", itemListId, _requestRepository.LanguageId);
                    result = dbHelper.ExecuteScalar(query, ref feild);
                    if (result == GlobalErrors.Success && feild != null && feild != DBNull.Value && feild.ToString() != string.Empty)
                    {
                        allCustomers = bool.Parse(feild.ToString());
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetIsAppliedToAllEmployees(int itemListId, ref bool allEmployees)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object feild = null;

            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Format(@"select ItemListEmployee.EmployeeID from ItemListEmployee where ItemListID = {0}", itemListId, _requestRepository.LanguageId);
                result = dbHelper.ExecuteScalar(query, ref feild);
                if (result == GlobalErrors.Success && feild != null && feild != DBNull.Value && feild.ToString() != string.Empty)
                {
                    if (feild.ToString() == "-1")
                        allEmployees = true;
                    else
                        allEmployees = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemListAppliedCustomers(int itemListId, ref List<SimpleCustomerModel> appliedCustomers, bool oosListMode)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                //}

                if (oosListMode)
                {
                    query = string.Format(@"select DISTINCT OOSItemsListID,OOSListAssignment.CustomerID,OOSListAssignment.OutletID,Customer.CustomerCode,
                                            CustomerOutlet.CustomerCode OutletCode,
                                            CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                                            ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                                            FROM OOSListAssignment 
                                            INNER JOIN dbo.Customer ON Customer.CustomerID = OOSListAssignment.CustomerID
                                            inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                            INNER JOIN dbo.CustomerOutlet ON CustomerOutlet.CustomerID = dbo.OOSListAssignment.CustomerID AND dbo.OOSListAssignment.OutletID=dbo.CustomerOutlet.OutletID
                                            left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID = {1}
                                            and CustomerLanguage.OrganizationId in ({3})
                                            left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                                            and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                                            and CustomerOutletLanguage.LanguageID = {1}
                                            {2}
                                            WHERE OOSItemsListID ={0}",
                                            itemListId, _requestRepository.LanguageId, orgAccessJoin,
                                            _requestRepository.CurrentOperator.OrganizationAccess
                                            );
                }
                else
                {

                    query = string.Format(@"
                select ItemsListAssignment.ItemListID ,ItemsListAssignment.CustomerID ,ItemsListAssignment.OutletID ,
                Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                from ItemsListAssignment
                inner join Customer on Customer.CustomerID=ItemsListAssignment.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID=ItemsListAssignment.CustomerID and CustomerOutlet.OutletID=ItemsListAssignment.OutletID
                left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                and CustomerLanguage.OrganizationId in ({3})
                left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                and CustomerOutletLanguage.LanguageID={1}
                {2}
                where ItemsListAssignment.ItemListID={0}", itemListId, _requestRepository.LanguageId, orgAccessJoin, _requestRepository.CurrentOperator.OrganizationAccess);
                }
                result = dbHelper.GetQueryList(query, ref appliedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemListAppliedEmployees(int itemListId, ref List<EmployeeModel> appliedEmployees, bool oosListMode)
        {
            DBHelper<EmployeeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<EmployeeModel>();
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@" select Employee.EmployeeID , Employee.EmployeeCode ,EmployeeLanguage.Description EmployeeName,
                    IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName 
                    from OOSListAssignment 
                    Inner Join Employee on Employee.EmployeeID =OOSListAssignment.EmployeeID and Employee.OrganizationID in ({2})
                    Inner Join EmployeeLanguage on EmployeeLanguage.EmployeeID =OOSListAssignment.EmployeeID and EmployeeLanguage.LanguageID ={1}
                    where OOSListAssignment.OOSItemsListID ={0}", itemListId, _requestRepository.LanguageId,_requestRepository.CurrentOperator.OrganizationAccess);
                }
                else
                {
                    query = string.Format(@"
                    select ItemListEmployee.EmployeeID , Employee .EmployeeCode ,EmployeeLanguage .Description EmployeeName,
                    IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName from ItemListEmployee 
                    Inner Join Employee on Employee .EmployeeID =ItemListEmployee.EmployeeID and Employee.OrganizationID in ({2})
                    Inner Join EmployeeLanguage on EmployeeLanguage .EmployeeID =ItemListEmployee.EmployeeID and EmployeeLanguage .LanguageID ={1}
                    Inner Join ItemsListLanguage on ItemsListLanguage .ItemListID =ItemListEmployee.ItemListID 
                    where ItemsListLanguage .ItemListID ={0} and ItemsListLanguage.LanguageID= {1}", itemListId, _requestRepository.LanguageId,_requestRepository.CurrentOperator.OrganizationAccess);
                }

                result = dbHelper.GetQueryList(query, ref appliedEmployees);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedEmployees = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemListAppliedSecurityGroups(int itemListId, ref List<SecurityGroupModel> appliedSecurityGroups)
        {
            DBHelper<SecurityGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SecurityGroupModel>();
                string query = string.Format(@" select SecurityGroup.SecurityGroupID, SecurityGroupLanguage.Description SecurityGroupName,
                IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName 
                from OOSListAssignment 
                Inner Join SecurityGroup on SecurityGroup.SecurityGroupID =OOSListAssignment.SecurityGroupID
                Inner Join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID =OOSListAssignment.SecurityGroupID and SecurityGroupLanguage.LanguageID ={1}
                where OOSListAssignment.OOSItemsListID ={0}", itemListId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref appliedSecurityGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedSecurityGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemListAppliedGroups(int itemListId, ref List<CustomerGroupModel> appliedGroups, bool oosListMode)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;

                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"select OLA.OOSItemsListID ,
                                                   OLA.GroupID GroupId ,CustomerGroup.*,CGL.Description GroupName,
                                                   IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CGL.Description, '--') as GroupCodeName 
                                                   from OOSListAssignment OLA
                                                   inner join CustomerGroup  on CustomerGroup.GroupID = OLA.GroupID {2}
                                                   left outer join CustomerGroupLanguage CGL on CGL.GroupID = CustomerGroup.GroupID and CGL.LanguageID = {1}
                                                   where OLA.OOSItemsListID = {0}", itemListId, _requestRepository.LanguageId, orgAccess);
                }
                else
                {
                    query = string.Format(@"select ItemsListAssignment.ItemListID ,ItemsListAssignment.CustomerGroupID GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                from ItemsListAssignment
                                inner join CustomerGroup on CustomerGroup.GroupID=ItemsListAssignment.CustomerGroupID {2}
                                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                where ItemsListAssignment.ItemListID={0}", itemListId, _requestRepository.LanguageId, orgAccess);
                }
                dbHelper = new DBHelper<CustomerGroupModel>();
                result = dbHelper.GetQueryList(query, ref appliedGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemListAppliedChannels(int itemListId, ref List<CustomerChannelModel> appliedChannels, bool oosListMode)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (oosListMode)
                {

                    query = string.Format(@"select OLA.OOSItemsListID,OLA.ChannelID,OLA.SubChannelID,
                                            (CONVERT(varchar(10),OLA.ChannelID) + '-' + CONVERT(varchar(10),OLA.SubChannelID)) ChannelSubChannelIds,
                                            (CH.Description + '-' + SCH.Description) ChannelSubChannelDescriptions
                                            from OOSListAssignment OLA
			                                Inner JOIN ChannelLanguage CH on CH.ChannelID = OLA.ChannelID and CH.LanguageID = {1}
                                            left JOIN SubChannelLanguage SCH on SCH.SubChannelID = OLA.SubChannelID and SCH.LanguageID = {1}
			                                where OLA.OOSItemsListID = {0}", itemListId, _requestRepository.LanguageId);
                }
                else
                {
                    query = string.Format(@"select ItemsListAssignment.ItemListID ,ItemsListAssignment.ChannelID, ItemsListAssignment.SubChannelID,
                               (CONVERT(varchar(10),ItemsListAssignment.ChannelID) + '-' + CONVERT(varchar(10),ItemsListAssignment.SubChannelID)) ChannelSubChannelIds ,
                               (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                from ItemsListAssignment
                                Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = ItemsListAssignment.ChannelID and ChannelLanguage.LanguageID = {1}
                                left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = ItemsListAssignment.SubChannelID and SubChannelLanguage.LanguageID = {1}
                                where ItemsListAssignment.ItemListID={0}", itemListId, _requestRepository.LanguageId);
                }

                dbHelper = new DBHelper<CustomerChannelModel>();

                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemListDescriptions(int itemListId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from ItemsListLanguage
                where ItemsListLanguage.ItemListID={0}", itemListId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerItemListOrganizations(int itemListId, ref List<OrganizationModel> orginazations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {//accsess
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT Organization.OrganizationID,(Organization.OrganizationCode + ' - ' +OrganizationLanguage.Description) OrganizationCodeName
                FROM CustomerItemsListOrganization INNER JOIN
		                Organization ON CustomerItemsListOrganization.OrganizationID = Organization.OrganizationID and Organization.OrganizationID in ({2}) INNER JOIN
		                OrganizationLanguage ON Organization.OrganizationID = OrganizationLanguage.OrganizationID 
		                AND OrganizationLanguage.LanguageID = {0}
                WHERE CustomerItemsListOrganization.ItemListID = {1}", _requestRepository.LanguageId, itemListId,_requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref orginazations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetOOSListOrganizations(int itemListId, ref List<OrganizationModel> orginazations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {//accsess
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT Organization.OrganizationID,(Organization.OrganizationCode + ' - ' +OrganizationLanguage.Description) OrganizationCodeName
                FROM OOSListOrganization INNER JOIN
		                Organization ON OOSListOrganization.OrganizationID = Organization.OrganizationID and Organization.OrganizationID in ({2}) INNER JOIN
		                OrganizationLanguage ON Organization.OrganizationID = OrganizationLanguage.OrganizationID 
		                AND OrganizationLanguage.LanguageID = {0}
                WHERE OOSListOrganization.OOSItemsListID = {1}", _requestRepository.LanguageId, itemListId,_requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref orginazations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemGroupDescriptions(int itemGroupId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from ItemGroupLanguage
                where ItemGroupID = {0}", itemGroupId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemGroupOrganizations(int itemGroupId, ref List<OrganizationModel> organizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"select distinct ItemGroupOrganization.*, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName  
                from ItemGroupOrganization 
                Inner JOIN Organization on ItemGroupOrganization.OrganizationID = Organization.OrganizationID
                Left JOIN OrganizationLanguage on ItemGroupOrganization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageId = {0}
                where ItemGroupOrganization.ItemGroupID  = {1} and Organization.OrganizationID in ({2})", _requestRepository.LanguageId,itemGroupId,_requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref organizations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getItemsForItemList(int itemListID, ref List<ItemPackModel> items, bool oosListMode)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<ItemPackModel>();
                if (oosListMode)
                {
                    query = string.Format(@" Select ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq,
                                              Item.*,dbo.OOSListHeader.ValidFrom DateFrom,dbo.OOSListHeader.ValidTo DateTo,ISNULL( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName,
                                              OOSListDetails.Listed BooleanValue,OOSListDetails.MinimumQuantity, 2 ValueType
                                              from OOSListDetails   
                                              left join ItemLanguage  on OOSListDetails .ItemID =ItemLanguage .ItemID  and ItemLanguage.LanguageID={0}
                                              inner join Item  on ItemLanguage .ItemID =Item.ItemID
                                              inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID and ItemCategory.DivisionID IN ({3})
                                              INNER JOIN dbo.OOSListHeader ON OOSListHeader.OOSItemsListID = OOSListDetails.OOSItemsListID                                              
                                              where OOSListDetails.OOSItemsListID ={1}",
                                              _requestRepository.LanguageId,
                                              itemListID,
                                              _requestRepository.CurrentOperator.EmployeeId,
                                              _requestRepository.CurrentOperator.DivisionAccess
                                              );
                }
                else
                {
                    query = string.Format(@" Select ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq,
                                              Item.*,IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName
                                              from ItemsListDetails   
                                              left join ItemLanguage  on ItemsListDetails .ItemID =ItemLanguage .ItemID  and ItemLanguage.LanguageID={0}
                                              inner join Item  on ItemLanguage .ItemID =Item.ItemID
                                              inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID and ItemCategory.DivisionID IN ({3})
                                              where ItemListID ={1}", _requestRepository.LanguageId, itemListID, _requestRepository.CurrentOperator.EmployeeId, _requestRepository.CurrentOperator.DivisionAccess);
                }
                result = dbHelper.GetQueryList(query, ref items);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPackGroupLanguages(int groupID, ref List<TextLanguage> descriptionLanguages)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from  PackGroupLanguage Where PackGroupID = {0}", groupID);
                result = dBHelper.GetQueryList(query, ref descriptionLanguages);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public bool IsDivisionLinkedToItemCategory(int divisionId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select count(*) From ItemCategory WHERE divisionId = {0} ", divisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public static GlobalErrors GetItemLanguages(int ItemId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from ItemLanguage Where ItemID = {0}", ItemId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetItemPacksAndGroups(int ItemId, ref List<PackModel> packsList)
        {
            DBHelper<PackModel> dbHelper = null;
            DBHelper<PackGroupModel> dbHelperGroup = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                packsList = new List<PackModel>();
                dbHelper = new DBHelper<PackModel>();

                string itemQuery = string.Format(@"Select distinct pack.Barcode PackBarcode ,Pack.* , CASE WHEN Item.DefaultPackID = pack.PackID THEN 1 ELSE 0 END AS IsDefaultPack, PackTypeLanguage.Description PackTypeName
                from pack 
                inner join Item on Item.ItemID = Pack.ItemID
                left join PackTypeLanguage on PackTypeLanguage.PackTypeID =Pack.PackTypeID and PackTypeLanguage.LanguageID = {1}
                where Item.ItemID = {0}",
                ItemId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(itemQuery, ref packsList);
                if (result == GlobalErrors.Success)
                {
                    GetPackOperationsList(ref packsList, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    List<PackGroupModel> packGroups = new List<PackGroupModel>();
                    dbHelperGroup = new DBHelper<PackGroupModel>();
                    foreach (PackModel pack in packsList)
                    {
                        pack.PackGroupsList = new List<PackGroupModel>();
                        string packQuery = string.Format(@"select Distinct PackGroup.PackGroupID ,PackGroup.PackGroupCode ,PackGroupLanguage.Description PackGroupName,
                        IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName
                        from PackGroupDetail
                        inner join PackGroup on PackGroup.PackGroupID = PackGroupDetail.PackGroupID
                        left join PackGroupLanguage on PackGroupLanguage.PackGroupID = PackGroup.PackGroupID and PackGroupLanguage.LanguageID = {0}
                        where PackGroupDetail.PackID = {1}",
                        _requestRepository.LanguageId, pack.PackId);
                        result = dbHelperGroup.GetQueryList(packQuery, ref packGroups);
                        if (result == GlobalErrors.Success && packGroups != null && packGroups.Count > 0)
                        {
                            pack.PackGroupsList = packGroups;
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                packsList = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors SaveDivisionEmployee(DivisionModel division, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO EmployeeDivision (EmployeeId,DivisionId ,isDefault) values ");
                sqlStatment.Append("(");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(division.DivisionId);
                sqlStatment.Append(",");
                sqlStatment.Append(0);
                sqlStatment.Append(")");
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveDivisionEmployeeAdmin(DivisionModel division, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO EmployeeDivision (EmployeeId,DivisionId ,isDefault) values ");
                sqlStatment.Append("(");
                sqlStatment.Append(0);
                sqlStatment.Append(",");
                sqlStatment.Append(division.DivisionId);
                sqlStatment.Append(",");
                sqlStatment.Append(0);
                sqlStatment.Append(")");
                result = dBHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors insertPack(PackModel packGroup, int maxPack, int ItemId, DBHelper<int> dbHelper)
        {
            try
            {
                string query = string.Format(@"INSERT INTO Pack
                                               ([PackID]
                                               ,[Barcode]
                                               ,[ItemID]
                                               ,[PackTypeID]
                                               ,[Quantity]
                                               ,[EquivalencyFactor]
                                               ,[HasSerialNumber]
                                               ,[AllowFractionInQty]
                                               ,[TrackCaseBySerialNumber]
                                               ,[IsWeightPriced]
                                               ,[SerialSeparator]
                                               ,[CreatedBy]
                                               ,[CreatedDate]
                                               ,[UpdatedBy]
                                               ,[UpdatedDate]
                                               ,[TemplateID]
                                               ,[GTIN]
                                               ,[ChildPackID])
                                                VALUES ({0},'{1}',{2},{3},{4},{5},{6},{7},{8},{9},'{10}',{11},{12},{13},{14},{15},'{16}',{17})", maxPack, packGroup.PackBarcode.Equals("") ? "''" : packGroup.PackBarcode.Replace("'", "''"), ItemId, packGroup.PackTypeId, packGroup.Quantity, packGroup.Quantity, packGroup.HasSerialNumber ? 1 : 0, 0,
                                                              0, packGroup.IsWeightPriced ? 1 : 0, packGroup.SerialSeparator.Equals("") ? "''" : packGroup.SerialSeparator == null ? "''" : packGroup.SerialSeparator.Replace("'", "''"), _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), 0, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), packGroup.TemplateId, packGroup.GTIN, packGroup.ChildPackId);
                return dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SavePackGroupDetail(PackModel pack, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (pack.PackGroupsList != null && pack.PackGroupsList.Count > 0)
                {
                    foreach (PackGroupModel group in pack.PackGroupsList)
                    {
                        string query = string.Format(@"INSERT INTO PackGroupDetail([PackID],[PackGroupID],[IsDefault]) VALUES ({0},{1},{2})",
                        pack.PackId, group.PackGroupId, 0);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            break;
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public void GetPackOperationsList(ref List<PackModel> packList, DBHelper<PackModel> dbHelper)
        {
            try
            {
                DataTable dt = new DataTable();
                foreach (PackModel pack in packList)
                {
                    pack.PackOperationsList = new List<PackOperationModel>();
                    string query = string.Format(@"SELECT * FROM PackOperations where ItemID = {0} and packId = {1}", pack.ItemId, pack.PackId);
                    GlobalErrors result = dbHelper.GetQueryDataTable(query, ref dt);
                    if (result != GlobalErrors.Success) break;
                    if (dt != null && dt.Rows.Count > 0)
                    {
                        if (bool.Parse(dt.Rows[0]["AllowSales"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Sales.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowOrder"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Order.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowReturn"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Return.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowExchange"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Exchange.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowLoad"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Load.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowOffload"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.Offload.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowInputVoucher"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.InputVoucher.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowOutputVoucher"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.OutputVoucher.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowIncomingStock"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.IncomingStock.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowIncomingReturns"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.IncomingReturns.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowManufacturingDefects"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.ManufacturingDefects.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowDamagedStock"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.DamagedStock.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowReturnOrder"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.ReturnOrder.GetHashCode() });
                        if (bool.Parse(dt.Rows[0]["AllowCreditNoteRequest"].ToString()))
                            pack.PackOperationsList.Add(new PackOperationModel { OperationId = PackOperations.CreditNoteRequest.GetHashCode() });
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors SavePackOperationList(PackModel pack, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // output voucher and offload operation will be added by default
                string query = string.Format(@"INSERT INTO PackOperations (ItemID, PackID, AllowSales, AllowOrder, AllowReturn, AllowLoad, AllowOffload, AllowInputVoucher, AllowOutputVoucher, AllowExchange , AllowIncomingStock , AllowIncomingReturns , AllowManufacturingDefects , AllowDamagedStock, AllowReturnOrder, AllowCreditNoteRequest)
                                VALUES ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15})"
                                , pack.ItemId
                                , pack.PackId
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Sales.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Order.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Return.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Load.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Offload.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.InputVoucher.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.OutputVoucher.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.Exchange.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.IncomingStock.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.IncomingReturns.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.ManufacturingDefects.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.DamagedStock.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.ReturnOrder.GetHashCode()) ? 1 : 0
                                , pack.PackOperationsList.Any(op => op.OperationId == PackOperations.CreditNoteRequest.GetHashCode()) ? 1 : 0);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeletePackGroupDetails(int packId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                string query = string.Format(@"DELETE FROM PackGroupDetail where PackId = {0}", packId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeletePackOperationsList(PackModel pack, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                string query = string.Format(@"DELETE FROM PackOperations where ItemId = {0} and packId = {1} ", pack.ItemId, pack.PackId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllItemsNew(int divisionId, int stockWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, int requestedBy, int orderTypeId)
        {
            return GetAllItemsNew(divisionId, stockWarehouseId, -1, customerId, outletId, processMode, ref itemList, onlyCRMItems, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, string.Empty, string.Empty, string.Empty, false, false, string.Empty, -1, requestedBy, orderTypeId);
        }
        public GlobalErrors GetAllItemsNew(int divisionId, int stockWarehouseId, int detailsWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId, int requestedBy, int orderTypeId)
        {
            return GetAllItemsNew(divisionId, stockWarehouseId, detailsWarehouseId, -1, customerId, outletId, processMode, ref itemList, onlyCRMItems, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, orderSignature, -1, false, true, requestedBy, loadingWarehouses, excludedOrderID, showQuantityInOrder, restrictReturnItemIds, allowedItemsInReturn, sdcId, orderTypeId);
        }
        public GlobalErrors CRMGetAllItemsNew(int divisionId, int stockWarehouseId, int detailsWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<CRMItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId, int requestedBy, int orderTypeId)
        {
            return CRMGetAllItemsNew(divisionId, stockWarehouseId, detailsWarehouseId, -1, customerId, outletId, processMode, ref itemList, onlyCRMItems, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, orderSignature, -1, false, true, requestedBy, loadingWarehouses, excludedOrderID, showQuantityInOrder, restrictReturnItemIds, allowedItemsInReturn, sdcId, orderTypeId);
        }
        public GlobalErrors GetAllItemsNew(int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, int vendorId, bool isQualityControl, bool allowAddingNewItems, int requestedBy, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId, int orderTypeId)
        {
            return GetAllItemsNew(-1, divisionId, stockWarehouseId, detailsWarehouseId, -1, customerId, outletId, processMode, ref itemList, onlyCRMItems, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, orderSignature, -1, false, true, requestedBy, string.Empty, string.Empty, loadingWarehouses, excludedOrderID, showQuantityInOrder, restrictReturnItemIds, allowedItemsInReturn, sdcId, orderTypeId);
        }
        public GlobalErrors CRMGetAllItemsNew(int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<CRMItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, int vendorId, bool isQualityControl, bool allowAddingNewItems, int requestedBy, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId, int orderTypeId)
        {
            return CRMGetAllItemsNew(-1, divisionId, stockWarehouseId, detailsWarehouseId, -1, customerId, outletId, processMode, ref itemList, onlyCRMItems, includePrices, joinWithStock, includeTax, editedTransactionItemIds, editedTransactionPackIds, orderSignature, -1, false, true, requestedBy, string.Empty, string.Empty, loadingWarehouses, excludedOrderID, showQuantityInOrder, restrictReturnItemIds, allowedItemsInReturn, sdcId, orderTypeId);
        }
        public GlobalErrors GetAllItemsNew(int selectedEmployeeId, int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<ItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, int vendorId, bool isQualityControl, bool allowAddingNewItems, int requestedBy, string stockCountingTaskId, string purchaseOrderId, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId,int orderTypeId)
        {
            itemList = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Check Items List Assignment]
                string itemsListSelection = string.Empty;
                string itemsListJoin = string.Empty;
                string itemsListWhere = string.Empty;
                string divisionFilter = string.Empty;
                string vehicleQtyJoin = string.Empty;
                string mainWHQtyJoin = string.Empty;
                string vehicleSelectedQuantity = string.Empty;
                string mainWarehouseSelectedQuantity = string.Empty;
                string serialItemsFilter = " and pack.HasSerialNumber=0";
                string filterTransferInItems = "";
                string orderExcludeContainers = string.Empty;
                string purchaseOrderDetailsJoin = string.Empty;
                string purchaseOrderQtySelection = string.Empty;
                string filterItemsInReturnOrder = string.Empty;
                string warehouseCategoryFilter = string.Empty;
                string transferCategoryFilter = string.Empty;
                string itemStockSelection = string.Empty;
                string orderByFilter = string.Empty;
                string itemsListSelectionCust = string.Empty;
                string itemListForLoadAndOff = string.Empty;
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && divisionId != -1)
                {
                    divisionFilter = string.Format(" and ItemCategory.DivisionID = {0} ", divisionId);
                }
                if(processMode == ItemFormProcessMode.ExchangeReturn && _requestRepository.Configurations.LinkItemsToWarehouse && _requestRepository.Configurations.RestoreBOReturnToWarehouse)
                {
                    refWarehouseId = int.Parse(loadingWarehouses);
                }
                if (_requestRepository.Configurations.LinkItemsToWarehouse &&
                    (processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.ROIIncommingWithoutRef || processMode == ItemFormProcessMode.OutputVoucher || processMode == ItemFormProcessMode.ROIIncommingReturnsWithoutRef
                    || processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.TransferIn
                    || processMode == ItemFormProcessMode.MoveOrder || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.StockCounting
                    || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad || ((processMode == ItemFormProcessMode.Return || processMode == ItemFormProcessMode.ExchangeReturn) && _requestRepository.Configurations.RestoreBOReturnToWarehouse)))
                {
                    if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.MoveOrder || (processMode == ItemFormProcessMode.TransferIn && _requestRepository.Configurations.AllowEditItemInTransfer))
                        transferCategoryFilter = string.Format(@" INNER JOIN WarehouseCategory destinationCategory ON destinationCategory.ItemCategoryID = WarehouseCategory.ItemCategoryID AND destinationCategory.WarehouseID = {0} ", processMode == ItemFormProcessMode.TransferIn ? detailsWarehouseId : refWarehouseId);
                    warehouseCategoryFilter = string.Format(@" INNER JOIN WarehouseCategory on WarehouseCategory.ItemCategoryID = Item.ItemCategoryID and WarehouseCategory.WarehouseID = {0} {1} ", (processMode == ItemFormProcessMode.OffLoad || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ExchangeReturn) ? refWarehouseId : stockWarehouseId, transferCategoryFilter);
                }
                if (processMode == ItemFormProcessMode.Orders)
                {
                    orderExcludeContainers = "2,";
                }
                if (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad || processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.ROIIncommingWithoutRef || processMode == ItemFormProcessMode.OutputVoucher || processMode == ItemFormProcessMode.ROIIncommingReturnsWithoutRef || processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.Sales || processMode == ItemFormProcessMode.ConsignmentOrder || processMode == ItemFormProcessMode.SerialReassignment)
                {
                    string itemListMainQuery = string.Empty;
                    if (processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.ConsignmentOrder || processMode == ItemFormProcessMode.Sales || processMode == ItemFormProcessMode.SerialReassignment)
                    {
                        itemsListSelectionCust = string.Format(@"

                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerGroup CG ON CG.ChannelID = ItemsListAssignment.ChannelID AND CG.SubChannelID = ItemsListAssignment.SubChannelID
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND COG.CustomerID = {0} and COG.OutletID = {1}
                    WHERE ItemsListAssignment.SubChannelID IS NOT NULL AND ItemsListAssignment.ChannelID IS NOT NULL
                    UNION
                   
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = ItemsListAssignment.CustomerGroupID AND COG.CustomerID = {0} and COG.OutletID = {1}
                    WHERE ItemsListAssignment.CustomerGroupID IS NOT NULL
                    UNION
                    
                    SELECT distinct ItemsListAssignment.ItemListID 
                    FROM ItemsListAssignment
                    WHERE ItemsListAssignment.CustomerID IS NOT NULL AND ItemsListAssignment.OutletID IS NOT NULL AND CustomerID = {0} and OutletID = {1}
                    UNION
                   
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment 
                    WHERE ItemsListAssignment.AllCustomers = 1
                    UNION", customerId, outletId);
                    }

                    itemListMainQuery = @"Declare @{2} table (ItemListID int, ItemID int)
                    Insert into @{2}
                    SELECT DISTINCT IL.ItemListID, ItemsListDetails.ItemID FROM (

                    {0}

                    SELECT distinct ItemListEmployee.ItemListID 
                    from ItemListEmployee 
                    INNER JOIN Employee ON Employee.EmployeeID = ItemListEmployee.EmployeeID 
					INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = ItemListEmployee.ItemListID AND Employee.EmployeeID = {1}
                    UNION 

                    SELECT distinct ItemListEmployee.ItemListID 
                    FROM ItemListEmployee 
                    WHERE ItemListEmployee.EmployeeID = -1                   
                    ) T 
                    INNER JOIN ItemsList IL ON IL.ItemListID = T.ItemListID
                    INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = IL.ItemListID ";

                    itemsListSelection = string.Format(itemListMainQuery, itemsListSelectionCust, processMode == ItemFormProcessMode.Orders ? requestedBy : _requestRepository.CurrentOperator.EmployeeId, "ItemsListDummy");

                    if (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad)
                    {
                        itemListForLoadAndOff = string.Format(itemListMainQuery, itemsListSelectionCust, requestedBy, "ItemsListDummyRequest");
                        itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1  LEFT OUTER JOIN @ItemsListDummyRequest ILR on 1=1 ";
                        itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) )  And ( (ILR.ItemListID is null) OR (ILR.ItemListID is not null and ILR.ItemID = Item.ItemID) ) ";
                    }
                    else
                    {
                        itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1 ";
                        itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) ) ";
                    }
                }
                #endregion

                dbHelper = new DBHelper<ItemPackModel>();

                #region[CRM]
                string crmQueryFilter = string.Empty;

                bool isBRFCRM = false;
                string stockStatusDetailsSelection = string.Empty;
                if (onlyCRMItems)
                {
                    isBRFCRM = _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;
                    if (isBRFCRM)
                    {
                        string priceEditableSalesOrderTypes = _requestRepository.Configurations.EditableSalesOrderTypePrices;
                        priceEditableSalesOrderTypes = !string.IsNullOrEmpty(priceEditableSalesOrderTypes) ? priceEditableSalesOrderTypes : "-1";
                        stockStatusDetailsSelection = $" , prices.ApprovalPrice , SSC.Description Color , prices.SalesOrderTypeID, ItemStock.StockStatusID, ItemStock.SalesOrderTypeId, ItemStock.PriceEditable, CASE WHEN ItemStock.SalesOrderTypeID in ({priceEditableSalesOrderTypes}) THEN 0 ELSE 1 END as DisableEditPrice ";
                        joinWithStock = true;
                    }
                    if (!_requestRepository.Configurations.RemoveHomeAndOfficesConceptFromCRM)
                    {
                        crmQueryFilter = " INNER JOIN HomeAndOfficeItemCategory ON HomeAndOfficeItemCategory.ItemCategoryID = ItemCategory.ItemCategoryID ";
                    }
                }
                #endregion

                #region[Price]
                string priceSelection = string.Empty;
                string consumerPriceQuery = string.Empty;
                string consumerPriceJoin = string.Empty;
                string consumerPriceSelection = string.Empty;
                string priceQuery = string.Empty;
                string priceTableQuery = string.Empty;
                string zeroPriceFilter = string.Empty;
                string retailSelection = string.Empty;
                string retailQuery = string.Empty;
                string retailJoin = string.Empty;
                string costPriceQuery = string.Empty;
                string costPriceSelection = string.Empty;
                string costPriceJoin = string.Empty;
                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")";
                if (includePrices)
                {
                    bool excludeZeroPrice = processMode == ItemFormProcessMode.Sales || (processMode == ItemFormProcessMode.Orders && string.IsNullOrEmpty(allowedItemsInReturn)) || processMode == ItemFormProcessMode.ConsignmentOrder || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.RestrictReturnFromInvoices);
                    if (excludeZeroPrice)
                    {
                        if (!string.IsNullOrEmpty(editedTransactionPackIds))
                        {
                            zeroPriceFilter = string.Format(" And (Pack.PackID in ({0}) OR (Prices.PackID Is not Null and Prices.Price > 0)) ", editedTransactionPackIds);
                        }
                        else
                        {
                            zeroPriceFilter = " And (Prices.PackID Is not Null and Prices.Price > 0) ";
                        }
                    }

                    #region[Tax]
                    //bool getTax = Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                    string taxSelection = " 0 As Tax";
                    string promotedItemBaseTax = string.Empty;
                    if (includeTax)
                    {
                        if (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery && !_requestRepository.Configurations.AllowTaxOverFreeItems)
                        {
                            promotedItemBaseTax = " , ISNULL(prices.tax, 0) BaseTax ";
                            taxSelection = $@" CASE WHEN SalesOrderDetail.SalesTransactionTypeID <> {SalesTransactionTypes.Promotion.GetHashCode()} then ISNULL(prices.tax, 0) else 0 end Tax ";
                        }
                        else
                        {
                            taxSelection = " ISNULL(prices.tax, 0) As Tax ";
                        }
                    }
                    #endregion

                    #region [CostPrice] 

                    if (processMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.CheckCostPrice)
                    {
                        costPriceQuery = $@"DECLARE @CostPriceTable as Table (PackID INT, Price numeric(19,9));
                            INSERT INTO @CostPriceTable 
                            SELECT PackID, Price FROM (
                            SELECT PackID, Price, ROW_NUMBER() OVER (PARTITION BY PACKID ORDER BY PriceDefinition.PriceListID) Num FROM PriceDefinition INNER JOIN pricelist on pricelist.PriceListID = PriceDefinition.PriceListID 
                            Where PriceListTypeID = {PriceListTypes.CostPrice.GetHashCode()} 
                            AND PriceList.OrganizationID in({_requestRepository.CurrentOperator.OrganizationAccess})
                            {priceDateFilter}) as tt WHERE tt.Num = 1";
                        costPriceJoin = " LEFT JOIN @CostPriceTable as costPrice ON costPrice.PackID = Pack.PackID  ";
                        costPriceSelection = " , ISNULL(costPrice.Price, 0) as CostPrice ";
                    }

                    #endregion

                    #region[Retail Tax]
                    if (includeTax && _requestRepository.Configurations.AllowRetailTaxOnItemsForCustomer(customerId, outletId))
                    {
                        retailSelection = " ,ISNULL(retailPrices.price,0) as RetailPrice,ISNULL(retailPrices.tax,0) as RetailTax,(ISNULL(retailPrices.price,0)* ISNULL(retailPrices.tax,0))/100 as RetailValue ";
                        retailJoin = " left outer join @Retail as retailPrices on retailPrices.packid=pack.PackID ";
                        retailQuery = string.Format(@"    declare @Retail table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int)
                                    insert into @Retail
                                    SELECT distinct packID , isnull(retailPrices.Price,0) price, isnull(retailPrices.Tax,0)tax, 
                                    retailPrices.PriceListID                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                     PriceDefinition.CurrencyID              
                                    from PriceDefinition                      
                                    inner join(                      
                                                  
                                    select PriceListID from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({0}) ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={1}  AND (PriceList.StartDate <=  {2} )AND (PriceList.EndDate >=   {3} )
                                    ) as retailPrices 
                                    WHERE  (retailPrices.PriceListID is not null)", _requestRepository.Configurations.DefaultRetailPriceListID, PriceListTypes.Retail.GetHashCode(), LocalUtilities.ParseDateToSQLString(DateTime.Now), LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                    }
                    else
                    {
                        retailSelection = " ,0 as RetailPrice,0 as RetailTax ,0 as RetailValue";
                    }

                    #endregion
                    int defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                    if (selectedEmployeeId != -1 && (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad))
                    {
                        var config = _requestRepository.Configurations.GetConfigurationValue("DefaultPriceListID", selectedEmployeeId);
                        if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                        {
                            defaultPriceListId = int.Parse(config.KeyValue.Trim());
                        }
                    }
                    if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.ROIIncommingWithoutRef || processMode == ItemFormProcessMode.OutputVoucher || processMode == ItemFormProcessMode.ROIIncommingReturnsWithoutRef)
                    {
                        int whOrganizationId = -1;
                        DBHelper<int> dBHelper = new DBHelper<int>();
                        object field = null;
                        string orgQuery = $" select ISNULL(OrganizationID, -1) OrganizationID from Warehouse Where warehouseId = {detailsWarehouseId}";
                        result = dBHelper.ExecuteScalar(orgQuery, ref field);
                        if (result != GlobalErrors.Success) return GlobalErrors.Error;

                        if (field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            whOrganizationId = int.Parse(field.ToString());
                        }
                        var config = _requestRepository.Configurations.GetConfigurationOnOrganization("DefaultPriceListID", whOrganizationId);
                        if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                        {
                            defaultPriceListId = int.Parse(config.KeyValue.Trim());
                        }
                        else
                        {
                            defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                        }
                    }
                    string sdcPrice = string.Empty;
                    if (_requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1)
                    {
                        sdcPrice = $@" UNION
				                        select PriceListID, 5 as priority FROM SDCPrice
				                        where SDCId = {sdcId}";
                    }
                    string promotedItemBasePrice = processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery ? @$" , ISNULL(prices.price, 0) BasePrice " : "";
                    string itemPrice = (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery) ?
                        $" CASE WHEN SalesOrderDetail.SalesTransactionTypeID <> {SalesTransactionTypes.Promotion.GetHashCode()} then ISNULL(prices.price, 0) else 0  end Price {promotedItemBasePrice}"
                        : " ISNULL(prices.price, 0) Price";
                    string returnPriceListUnion = string.Empty;
                    string returnPriceTable = string.Empty;
                    string returnPriceJoin = string.Empty;
                    if (_requestRepository.Configurations.UseReturnPriceListForReturns && (processMode == ItemFormProcessMode.Return|| processMode == ItemFormProcessMode.ExchangeReturn))
                    {
                        priceSelection = string.Format(" ,{1}, ISNULL(prices.TaxIncludedInPrice,0) As TaxIncludedInPrice, ISNULL(prices.BasePrice,0) AS BasePrice, ISNULL(prices.PriceListID, -1) UsedPriceListID, {0},CASE WHEN returnPrices.price is not null then returnPrices.price else ISNULL(prices.price, 0)  end as ReturnPrice ,  ISNULL(returnPrices.PriceListID, -1) ReturnUsedPriceListID", taxSelection, itemPrice);
                        returnPriceTable = "declare @returnPrice table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)";
                        returnPriceJoin = " LEFT OUTER JOIN @returnPrice as returnPrices ON returnPrices.PackID = Pack.PackID ";
                        returnPriceListUnion = string.Format(@" Insert into @returnPrice
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax,
                                    prices.PriceListID, prices.priority, prices.rowNumber
		                                    FROM   (
		                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
		                                    tt.priority, PriceDefinition.CurrencyID                      ,
		                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
		                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd
		                                    from PriceDefinition
		                                    inner join (
				                                    select PriceListID, 1 as priority from CustomerPrice
				                                    where CustomerID = {0} and OutletID = {1}
				                                    union
				                                    select PriceListID, 2 as priority from GroupPrice
				                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})
				                                    union
				                                    select PriceListID, 3 as priority from ChannelPrice
				                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in
				                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))
		                                    ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null
		                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0
		                                    and PriceList.PriceListTypeID = {3} {2}
		                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
		                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd )
                                    ) as prices
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null)
                                    and (Prices.PriceListID is not null)",
                                    customerId, //0
                                    outletId, //1
                                    priceDateFilter, //2
                                    PriceListTypes.Return.GetHashCode() // 3
                                   );
                    }
                    else
                    {
                        priceSelection = string.Format(" ,{1}, ISNULL(prices.TaxIncludedInPrice,0) As TaxIncludedInPrice, ISNULL(prices.BasePrice,0) AS BasePrice , ISNULL(prices.PriceListID, -1) UsedPriceListID, {0}, 0 as ReturnPrice ,  -1 ReturnUsedPriceListID", taxSelection, itemPrice);
                    }

                    priceTableQuery = string.Format(@"declare @x table (packid int,price numeric(19,9),tax numeric(19,9), TaxIncludedInPrice numeric(19,9) , BasePrice numeric(19,9) , pricelistid int,priority int,rownumber int,MinPrice numeric(19,9) , MaxPrice numeric(19,9) {9} )
                                    {13}
                                    insert into @x
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, prices.TaxIncludedInPrice , prices.BasePrice ,
                                    prices.PriceListID, prices.priority, prices.rowNumber, MinPrice , MaxPrice {10}
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , {15} , PriceDefinition.Price AS BasePrice,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID {12}  ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd , ISNULL(MinPrice,0) MinPrice, ISNULL(MaxPrice,0) MaxPrice {11}  
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))                                                             
                                    {8}
                                    union                      
                                    select PriceListID, {7} as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.OrganizationId in ({16}) and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    
                                    {14}
                                    ", customerId, //0
                                    outletId, //1
                                    defaultPriceListId.ToString(), //2
                                    priceDateFilter, //3
                                   PriceListTypes.General.GetHashCode(), //4
                                   _requestRepository.Configurations.UseReturnPriceListForReturns, // 5
                                   PriceListTypes.Return.GetHashCode(), // 6
                                   _requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1 ? "6" : "5", // 7
                                   sdcPrice, //8
                                   isBRFCRM ? ", SalesOrderTypeID INT , ApprovalPrice numeric(19,9) " : string.Empty, //9
                                   isBRFCRM ? ", SalesOrderTypeID ,  ApprovalPrice" : string.Empty, //10
                                   isBRFCRM ? " , ISNULL(SalesOrderTypeID,-1) SalesOrderTypeID ,  PriceDefinition.Price ApprovalPrice  " : string.Empty, //11
                                   isBRFCRM ? " , SalesOrderTypeID " : string.Empty, //12
                                   returnPriceTable, //13
                                   returnPriceListUnion, //14
                                   _requestRepository.Configurations.IncludeTaxInPrice ? " (isnull(PriceDefinition.Tax,0)/100) * isnull(PriceDefinition.Price,0) + PriceDefinition.Price AS price , 0 AS tax, PriceDefinition.Tax As TaxIncludedInPrice " : " PriceDefinition.Price, PriceDefinition.Tax, 0 As TaxIncludedInPrice ", //15
                                   _requestRepository.CurrentOperator.OrganizationAccess //16
                                   );
                    if (isBRFCRM)
                    {
                        priceQuery = string.Format(@" OUTER APPLY (select top(1) * from @x p where p.packid = pack.PackID and (p.SalesOrderTypeID = ItemStock.SalesOrderTypeID OR ISNULL(p.SalesOrderTypeID,-1) = -1) Order by p.priority ) as prices
                                                  {0}", returnPriceJoin);
                    }
                    else
                    {
                        priceQuery = string.Format(@" LEFT OUTER JOIN @x as prices ON prices.PackID = Pack.PackID
                                                  {0}", returnPriceJoin);
                    }


                    if (processMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.CheckConsumerPrice)
                    {
                        consumerPriceQuery = string.Format(@"declare @ConsumerPrice table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
                                    insert into @ConsumerPrice
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
                                    prices.PriceListID, prices.priority, prices.rowNumber                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))                      
                                    union                      
                                    select PriceListID, 5 as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd)) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    ", customerId, //0
                                    outletId, //1
                                    _requestRepository.Configurations.ConsumerPriceListID.ToString(), //2
                                    priceDateFilter, //3
                                    PriceListTypes.ConsumerPrice.GetHashCode() //4
                                    );
                        consumerPriceJoin = string.Format(@" LEFT OUTER JOIN @ConsumerPrice as consumerPrices ON consumerPrices.PackID = Pack.PackID ");
                        consumerPriceSelection = " ,ISNULL(consumerPrices.price, 0) ConsumerPrice, ISNULL(consumerPrices.PriceListID, -1) consumerPriceListID";
                    }
                }
                else if (processMode == ItemFormProcessMode.LoadRequest && _requestRepository.Configurations.CheckAvailableCreditToLoad.Contains("1"))
                {
                    int defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                    var config = _requestRepository.Configurations.GetConfigurationValue("DefaultPriceListID", selectedEmployeeId);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        defaultPriceListId = int.Parse(config.KeyValue.Trim());
                    }
                    priceSelection = " , ISNULL(PriceDefinition.price, 0) Price";
                    priceQuery = string.Format(@" LEFT OUTER JOIN PriceDefinition ON PriceDefinition.PacKID = Pack.PackID AND  PriceDefinition.PriceListID={0} ", defaultPriceListId.ToString());
                }
                #endregion

                #region[Stock]
                string stockQuery = string.Empty;
                string itemStockTable = string.Empty;
                string stockLimitConditionInMainQuery = string.Empty;
                string limitItemsToMainWarehouseJoin = string.Empty;
                string limitItemsToMainWarehouseCondition = string.Empty;
                string stockSelection = " ,  0 as AvailableQtyInPcs ";
                string customerOrganizationCheck = string.Empty;
                int customerOrganizationId = -1;

                string loadingWarehousesIdsFilter = string.Empty;
                string warehouseFilterForPendingOrders = string.Empty;
                string organizationAccessSalesOrder = string.Empty;
                string organizationAccessWarehouse = string.Empty;
                var employeeTypeId = EmployeeManager.GetEmployeeType(requestedBy);


                var employeeTypeFO = string.Format(@"{0},{1},{2},{3},{4},{5},{6},{7}",
                EmployeeTypes.Salesperson.GetHashCode(),
                EmployeeTypes.Deliveryperson.GetHashCode(),
                EmployeeTypes.Collector.GetHashCode(),
                EmployeeTypes.Presales.GetHashCode(),
                EmployeeTypes.Driver.GetHashCode(),
                EmployeeTypes.SalesRepresentative.GetHashCode(),
                EmployeeTypes.VanInCharge.GetHashCode(),
                EmployeeTypes.Merchandiser.GetHashCode());

                var employeeTypeIds = employeeTypeFO.Split(",").Select(int.Parse).ToList();
                var IsFOEmployee = employeeTypeIds.Contains(employeeTypeId);

                if (joinWithStock)
                {
                    stockSelection = " , ISNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs, ISNULL(ItemStock.ExistingQty/Pack.Quantity,0) ExistingQty ";
                    string excludeZeroAndMinusStock = string.Empty;
                    string excludeReservedquantity = string.Empty;

                    if (!isQualityControl)
                        excludeReservedquantity = " Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)";
                    else
                        excludeReservedquantity = string.Format(" Where WarehouseStock.PackiD in ({0})", editedTransactionPackIds);

                    // get only postive stock items, and get old saved items even if they don't have stock now
                    if ((processMode != ItemFormProcessMode.Packing && processMode != ItemFormProcessMode.Receiving && processMode != ItemFormProcessMode.LoadRequest && processMode != ItemFormProcessMode.BackToStoreOffload && processMode != ItemFormProcessMode.ResendHelloJordan && processMode != ItemFormProcessMode.InputVoucher && processMode != ItemFormProcessMode.ROIIncommingWithoutRef && processMode != ItemFormProcessMode.GenerateSerials && processMode != ItemFormProcessMode.PurchaseOrder && processMode != ItemFormProcessMode.TransferIn && processMode != ItemFormProcessMode.StockCounting) || (processMode == ItemFormProcessMode.LoadRequest && _requestRepository.Configurations.AutoExecuteLoadRequestInBO  && _requestRepository.Configurations.CheckMainWHStockForLoad) || isBRFCRM)
                    {
                        if(processMode != ItemFormProcessMode.Orders  ||
                            (processMode == ItemFormProcessMode.Orders && 
                            _requestRepository.Configurations.LimitItemsToMainWarehouseStock.Contains("1") && 
                            orderTypeId == OrderTypes.Sales.GetHashCode()))
                            excludeZeroAndMinusStock = " Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0 ";

                        if (string.IsNullOrEmpty(editedTransactionItemIds) || isBRFCRM)
                        {
                            stockLimitConditionInMainQuery = " And (ItemStock.ItemID Is not Null)";
                        }
                        else
                        {
                            stockLimitConditionInMainQuery = string.Format(" And (ItemStock.ItemID Is not Null OR Item.ItemID in ({0})) ", editedTransactionItemIds);
                        }
                    }

                    string joinWithWarehouseId = string.Empty;

                    if (stockWarehouseId > 0)
                    {
                        joinWithWarehouseId = $" and  WarehouseStock.WarehouseID = {stockWarehouseId}";
                    }
                    else
                    {
                        if (IsFOEmployee)
                        {
                            if (!string.IsNullOrEmpty(loadingWarehouses))
                            {


                                loadingWarehousesIdsFilter = string.Format("inner join Warehouse on Warehouse.WarehouseID = WarehouseStock.WarehouseID and Warehouse.WarehouseID in ({0}) ", loadingWarehouses);
                            }

                        }
                        else
                        {


                                organizationAccessWarehouse = string.Format(@"inner join Warehouse on Warehouse.WarehouseID = WarehouseStock.WarehouseID and Warehouse.OrganizationID in ({0}) AND Warehouse.WarehouseTypeID = 1", _requestRepository.CurrentOperator.OrganizationAccess);


                        }
                    }
                    if (isBRFCRM  && !string.IsNullOrEmpty(loadingWarehouses))
                    {
                        joinWithWarehouseId = $" and  WarehouseStock.WarehouseID in ({loadingWarehouses})";
                    }
                    string stockStatusJoin = string.Empty;
                    string groupByStockStatus = string.Empty;
                    string stockStatusSelection = string.Empty;
                    string stockStatusColorJoin = string.Empty;
                    if (isBRFCRM)
                    {
                        if (processMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.RestrictDataToCustomerOrganization)
                        {
                            DBHelper<int> dBHelper = new DBHelper<int>();
                            string orgQuery = $" select ISNULL(OrganizationID, -1) OrganizationID from CustomerOutlet Where CustomerId = {customerId} and OutletId = {outletId} ";
                            result = dBHelper.GetQuerySingle(orgQuery, ref customerOrganizationId);
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                            customerOrganizationCheck = $" And Division.OrganizationId in ({customerOrganizationId}) ";
                        }

                        stockStatusJoin = $@" inner join StockStatus SS on SS.StockStatusID = WarehouseStock.StockStatusID 
                                              inner join SalesOrderType on SalesOrderType.SalesOrderTypeID = SS.SalesOrderTypeID";
                        groupByStockStatus = $" , WarehouseStock.StockStatusID , SS.SalesOrderTypeID, SS.ColorID, SalesOrderType.PriceEditable ";
                        stockStatusSelection = $" ,WarehouseStock.StockStatusID , SS.SalesOrderTypeID, SS.ColorID, SalesOrderType.PriceEditable ";
                        itemStockSelection = $" ,StockStatusID int,SalesOrderTypeID int,ColorID int,PriceEditable int ";
                        stockStatusColorJoin = $"  LEFT join StockStatusColors SSC on SSC.ColorID = ItemStock.ColorID and SSC.LanguageID = { _requestRepository.LanguageId}";
                        if (_requestRepository.Configurations.LimitItemsToMainWarehouseStock.Contains(LimitItemsToWarehouseTypes.Order.GetHashCode().ToString()))
                        {
                            limitItemsToMainWarehouseJoin = string.Format(@" inner join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                            limitItemsToMainWarehouseCondition = string.Format(@" and ( ISNull(ItemStock.AvailableQtyInPcs,0) > 0   )");
                        }
                        else
                        {
                            limitItemsToMainWarehouseJoin = string.Format(@" left join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                        }
                    }
                    else
                    {
                        limitItemsToMainWarehouseJoin = string.Format(@" inner join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                    }
                    itemStockTable = string.Format(@" declare @ItemStock as table (ItemID int,AvailableQtyInPcs numeric(19,9),ExistingQty numeric(19,9) {7})
                    insert into @ItemStock
                    Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs ,Sum(pack.Quantity * WarehouseStock.Quantity) ExistingQty {5}
                    From pack
                    {6}
                    {8}
                    {9}
                    {2}
                    {1}
                    group by pack.ItemID {4}
                    {0}",
                                  excludeZeroAndMinusStock, //0
                                  excludeReservedquantity, //1
                                  stockStatusJoin, //2
                                  string.Empty, //3 
                                  groupByStockStatus, //4
                                  stockStatusSelection, //5
                                  limitItemsToMainWarehouseJoin, //6
                                  itemStockSelection, //7
                                  loadingWarehousesIdsFilter,//8
                                  organizationAccessWarehouse//9
                                 );
                    stockQuery = string.Format(@" LEFT OUTER join @ItemStock ItemStock on ItemStock.ItemID = Item.ItemID 
                    {0}",
                     stockStatusColorJoin //0
                    );
                    if (processMode == ItemFormProcessMode.SSCCFromLoadExecute || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                    {
                        vehicleQtyJoin = string.Format(@"  left outer join (select pack.itemid ,  IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) VehicleAvailableQtyInPcs from WarehouseStock 
				        inner join Pack on Pack.PackID = WarehouseStock.PackID and WarehouseStock.WarehouseID={0}
                        Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)
				        group by pack.ItemID )vehicleWarehouseStock on vehicleWarehouseStock.ItemID=Item.ItemID", detailsWarehouseId);
                        vehicleSelectedQuantity = ",ISNULL(vehicleWarehouseStock.VehicleAvailableQtyInPcs,0 ) VehicleAvailableQtyInPCs";
                    }
                    else if (processMode == ItemFormProcessMode.OffLoad && refWarehouseId != -1)
                    {
                        mainWHQtyJoin = string.Format(@"  left outer join (select pack.itemid ,  IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) warehouseAvailableQtyInPCs from WarehouseStock 
				        inner join Pack on Pack.PackID = WarehouseStock.PackID and WarehouseStock.WarehouseID={0}
                        Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)
				        group by pack.ItemID )mainWarehouseStock on mainWarehouseStock.ItemID=Item.ItemID", refWarehouseId);
                        mainWarehouseSelectedQuantity = ",ISNULL(mainWarehouseStock.warehouseAvailableQtyInPCs,0 ) warehouseAvailableQtyInPCs";
                    }
                }
                #endregion
                #region Serials Filter

                if (processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.OutputVoucher
                    || processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.TransferOut
                    || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad
                    || processMode == ItemFormProcessMode.Delivery || processMode == ItemFormProcessMode.PartialDelivery
                    || processMode == ItemFormProcessMode.SSCCFromDelivery
                    || (processMode == ItemFormProcessMode.Orders)
                    || processMode == ItemFormProcessMode.SSCCFromLoadExecute
                    || processMode == ItemFormProcessMode.SSCCFromMainList
                    || processMode == ItemFormProcessMode.StockCounting
                    || processMode == ItemFormProcessMode.Sales
                    || processMode == ItemFormProcessMode.BackToStoreOffload
                    || processMode == ItemFormProcessMode.ResendHelloJordan
                    || processMode == ItemFormProcessMode.SerialReassignment
                    || processMode == ItemFormProcessMode.ROIIncommingWithoutRef
                    || processMode == ItemFormProcessMode.ROIIncommingReturnsWithoutRef)
                {
                    serialItemsFilter = string.Empty;
                }
                if (processMode == ItemFormProcessMode.SerialsAggregation)
                {
                    serialItemsFilter = " and pack.HasSerialNumber=1 and pack.Quantity>1";
                }
                if (processMode == ItemFormProcessMode.GenerateSerials)
                {
                    serialItemsFilter = " and pack.HasSerialNumber = 1 ";
                }
                #endregion
                #region DeliveryMode
                string orderItemsFilter = string.Empty;
                string salesTypeSelection = string.Empty;
                string discountsForDeliverySelection = string.Empty;
                string orderBySalesTransactionType = string.Empty;
                OrderModel orderModel = new OrderModel();
                if ((processMode == ItemFormProcessMode.Delivery || processMode == ItemFormProcessMode.PartialDelivery || processMode == ItemFormProcessMode.SSCCFromDelivery || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.AllowPartialDeliveryInProcessReturn)) && !string.IsNullOrEmpty(orderSignature))
                {
                    string salesTypeFilter = string.Empty;
                    string filterItems = string.Empty;
                    if (processMode == ItemFormProcessMode.SSCCFromDelivery)
                    {
                        salesTypeSelection = ",SalesOrderDetail.SalesTransactionTypeID , SalesOrderDetail.Quantity, SalesOrderDetail.BatchNo, SalesOrderDetail.ExpiryDate ";
                        orderBySalesTransactionType = "SalesOrderDetail.SalesTransactionTypeID,";
                        if (!string.IsNullOrEmpty(editedTransactionItemIds) && !string.IsNullOrEmpty(editedTransactionPackIds))
                        {
                            filterItems = string.Format(" and Pack.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                        }
                    }
                    else
                    {
                        if (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery == true)
                        {
                            salesTypeFilter = string.Empty;
                            salesTypeSelection = ",SalesOrderDetail.SalesTransactionTypeID";
                        }
                        else
                        {
                            salesTypeFilter = string.Format(" and SalesOrderDetail.SalesTransactionTypeID={0} ", (processMode != ItemFormProcessMode.ProcessReturn? SalesTransactionTypes.Sales.GetHashCode(): SalesTransactionTypes.None.GetHashCode()));
                        }
                        discountsForDeliverySelection = $@" ,SalesOrderDetail.AllItemDiscount, SalesOrderDetail.ItemPromotedDiscount ,SalesOrderDetail.PromotedDiscount,  
                            CASE WHEN SalesOrderDetail.SalesTransactionTypeID = {(int)SalesTransactionTypes.Sales} and  SalesOrderDetail.ItemPromotedDiscount < 100  then
                            salesorderdetail.AllItemDiscount / 
                            ((SalesOrderDetail.Price * SalesOrderDetail.Quantity - (SalesOrderDetail.Price * SalesOrderDetail.Quantity * SalesOrderDetail.ItemPromotedDiscount / 100 )) /
                            (SalesOrderDetail.Price * SalesOrderDetail.Quantity)) else 0 end as OriginalAllItemDiscount ";
                    }
                    orderModel.GetOrderDataFromSignature(orderSignature);
                    orderItemsFilter = string.Format(@" inner join SalesOrderDetail with (nolock) on SalesOrderDetail.PackID=pack.PackID and SalesOrderDetail.OrderID='{0}' 
                   and SalesOrderDetail.CustomerID={1} and SalesOrderDetail.OutletID={2} and SalesOrderDetail.DivisionID={3} {4} {5}"
                   , orderModel.OrderId, orderModel.CustomerId, orderModel.OutletId, orderModel.DivisionId, salesTypeFilter, filterItems);
                    if (processMode == ItemFormProcessMode.PartialDelivery || processMode == ItemFormProcessMode.SSCCFromDelivery || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.AllowPartialDeliveryInProcessReturn))
                    {
                        stockQuery = string.Format(@"   LEFT OUTER join(
                    Select pack.ItemID, Sum(pack.Quantity * SalesOrderDetail.Quantity) AvailableQtyInPcs
                    From pack
                    inner join SalesOrderDetail on SalesOrderDetail.PackID = pack.PackID  and SalesOrderDetail.OrderID = '{0}' and SalesOrderDetail.CustomerID = {1} and SalesOrderDetail.OutletID = {2} and SalesOrderDetail.DivisionID = {3}  {4} {5}
                    group by pack.ItemID
                     Having Sum(pack.Quantity * SalesOrderDetail.Quantity) > 0
                    ) ItemStock on ItemStock.ItemID = Item.ItemID ", orderModel.OrderId, orderModel.CustomerId, orderModel.OutletId, orderModel.DivisionId, salesTypeFilter, filterItems);
                        stockSelection = ", ISNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs";
                    }


                }
                #endregion
                #region [Order]
                string stockOrderTable = string.Empty;
                string stockOrderSelection = string.Empty;
                string stockOrderJoin = string.Empty;
                string bookedJoin = string.Empty;
                string bookedSelection = string.Empty;
                string bookedLoadReqPeriod = string.Empty;
                string bookedOrderPeriod = string.Empty;
                string orderIdFilter = string.Empty;

                string BookedQtyPeriod = _requestRepository.Configurations.BookedQtyPeriod;
                string includeOrderQty = string.Empty;
                string includeLoadRequestQty = string.Empty;
                string bookedLoadRequests = string.Empty;
                string bookedQtyForOrder = string.Empty;
                string bookedQtyForLoadReq = string.Empty;

                if (processMode == ItemFormProcessMode.Orders && showQuantityInOrder)
                {
                    if (!string.IsNullOrEmpty(excludedOrderID))
                    {
                        orderIdFilter = string.Format(" and SO.OrderID != '{0}' ", excludedOrderID);
                    }
                    if (stockWarehouseId > 0 && _requestRepository.Configurations.AllowWarehouseSelectionInPendingOrders && orderTypeId == OrderTypes.Sales.GetHashCode())
                    {
                        warehouseFilterForPendingOrders = $" and  SO.WarehouseID = {stockWarehouseId}";
                        loadingWarehousesIdsFilter = $" and  w.WarehouseID = {stockWarehouseId}";
                    }
                    else
                    {
                        


                        if (IsFOEmployee)
                        {
                            if (!string.IsNullOrEmpty(loadingWarehouses))
                            {
                                warehouseFilterForPendingOrders = string.Format(@" And (( SO.EmployeeID in (select EmployeeID from EmployeeVehicle 
                                        where VehicleID in (select VehicleID from VehicleLoadingWh where warehouseid in ({0})))) ) ", loadingWarehouses);

                                loadingWarehousesIdsFilter = string.Format("and w.WarehouseID in ({0})", loadingWarehouses);
                            }

                        }
                        else
                        {


                                organizationAccessSalesOrder = string.Format(@"and SO.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                                organizationAccessWarehouse = string.Format(@"and w.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);


                        }
                        
                     
                    }
                    int daysStart = 0;
                    int daysEnd = 0;

                    if (_requestRepository.Configurations.EnableBookedQuantity && !string.IsNullOrEmpty(BookedQtyPeriod) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim()) && BookedQtyPeriod.Trim().Split(',') != null && BookedQtyPeriod.Trim().Split(',').Length == 2)
                    {
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0].Trim()))
                        {
                            daysStart = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[0].Trim());
                        }
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1].Trim()))
                        {
                            daysEnd = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[1].Trim());
                        }
                        bookedOrderPeriod = string.Format(@" and SO.DesiredDeliveryDate >= {0} and SO.DesiredDeliveryDate <= {1}", LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(daysStart)), LocalUtilities.ParseEndDateToSQLString(DateTime.Now.AddDays(daysEnd)));
                        bookedLoadReqPeriod  = string.Format(@" and WT.TransactionDate >= {0} and WT.TransactionDate <= {1}", LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(daysStart)),LocalUtilities.ParseEndDateToSQLString(DateTime.Now.AddDays(daysEnd)));
                    }

                    bookedQtyForLoadReq = string.Format(@" 0 bookedQtyForLoadReq");
                    bookedQtyForOrder = string.Format(@" 0 bookedQty");
                    bookedSelection = string.Format(@" {0}, {1} ", bookedQtyForOrder, bookedQtyForLoadReq);
                    stockOrderTable = string.Format(@" declare @orderQty as table (ItemID int,stockQty numeric(38,9), bookedQty numeric(38,9), bookedQtyForLoadReq numeric(38,9))
                    insert into @orderQty
                    
					Select Item.ItemID, availableStock.stockQty, {3}   
					from Item
                    {0}
                    {4}
                    LEFT OUTER join(
                    select pack.ItemID, isnull(sum(WS.quantity*Pack.quantity),0) stockQty 
                    from warehousestock WS
                    inner join Warehouse w on WS.warehouseID = w.warehouseID {1} and w.WarehouseTypeID = 1 {2}
                    inner join pack on pack.packID = WS.PackID 
                    group by pack.ItemID) availableStock on availableStock.ItemID = Item.ItemID
                    where item.Inactive <> 1",
                     bookedJoin, //0
                     organizationAccessWarehouse, //1
                     loadingWarehousesIdsFilter, //2
                     bookedSelection, //3
                     bookedLoadRequests //4
                     );

                    stockOrderSelection = @" , isnull(orderQty.stockQty,0) as onHandQty, (isnull(orderQty.bookedQty,0) + isnull(orderQty.bookedQtyForLoadReq,0)) as reservedQty, (isnull(orderQty.stockQty,0) - (isnull(orderQty.bookedQty,0) + isnull(orderQty.bookedQtyForLoadReq,0))) as stockQty  ";
                    stockOrderJoin = @" LEFT OUTER JOIN @orderQty as orderQty ON orderQty.ItemId = Pack.ItemId  ";
                }
                #endregion

           
                #region Transfer In Items Filter
                if (processMode == ItemFormProcessMode.TransferIn && !_requestRepository.Configurations.AllowEditItemInTransfer && !string.IsNullOrEmpty(editedTransactionItemIds) && !string.IsNullOrEmpty(editedTransactionPackIds))
                {
                    filterTransferInItems = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                }

                #endregion
                #region [PackOperations]
                string allowOperation = "";
                string operationFilter = "";

                if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.OffLoad) allowOperation = "AllowOffload = 1";
                else if (processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan || processMode == ItemFormProcessMode.SSCCFromLoadExecute) allowOperation = "AllowLoad = 1";
                else if (processMode == ItemFormProcessMode.InputVoucher) allowOperation = "AllowInputVoucher =1";
                else if (processMode == ItemFormProcessMode.OutputVoucher) allowOperation = "AllowOutputVoucher =1";
                else if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Sales.GetHashCode()) allowOperation = "AllowOrder =1";
                else if (processMode == ItemFormProcessMode.Return) allowOperation = "PackOperations.AllowReturn =1";
                else if (processMode == ItemFormProcessMode.Sales) allowOperation = "AllowSales=1";
                else if (processMode == ItemFormProcessMode.ROIIncomming) allowOperation = "AllowIncomingStock =1";
                else if (processMode == ItemFormProcessMode.ROIIncommingReturns) allowOperation = "AllowIncomingReturns =1";
                else if (processMode == ItemFormProcessMode.ManufacturingDefects) allowOperation = "AllowManufacturingDefects =1";
                else if (processMode == ItemFormProcessMode.DamagedStock) allowOperation = "AllowDamagedStock =1";
                else if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Return.GetHashCode()) allowOperation = "AllowReturnOrder =1";

                if (allowOperation != "")
                    operationFilter = string.Format(" AND (PackOperations.PackId is null OR {0})", allowOperation);

                #endregion
                #region storeKeeper
                #region stockCounting
                string stockCountingfilter = "";
                if (processMode == ItemFormProcessMode.StockCounting && stockCountingTaskId != string.Empty)
                {
                    stockCountingfilter = string.Format(" INNER JOIN StockCountingTaskItems SC ON SC.ItemId = Item.ItemID and SC.StockCountingTaskID = {0}", stockCountingTaskId);
                }
                #endregion
                #region Purchase Order
                string poFilter = string.Empty;
                if (processMode == ItemFormProcessMode.PurchaseOrder)
                {
                    if (_requestRepository.Configurations.AllowSelectWarehouseInPO &&
                        _requestRepository.Configurations.ShowDivisionSelectionOnWHTransaction)
                    {
                        poFilter = string.Format(@" And ItemCategory.DivisionID={0} ", divisionId);
                    }
                    if (!_requestRepository.Configurations.AllowSelectWarehouseInPO)
                    {
                        poFilter = string.Format(@" And Item.VendorID={0} ", vendorId);
                    }
                    //Allow to add serial items without adding the serials
                    serialItemsFilter = string.Empty;
                    if (editedTransactionPackIds != null && editedTransactionPackIds != string.Empty && !allowAddingNewItems)
                    {
                        poFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                    }
                }
                if (!allowAddingNewItems)
                {
                    if (editedTransactionPackIds != null && editedTransactionPackIds != string.Empty)
                    {
                        poFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                    }
                }
                #endregion
                #region Receiving
                if (processMode == ItemFormProcessMode.Receiving)
                {
                    if (!string.IsNullOrEmpty(purchaseOrderId))
                    {
                        poFilter = string.Format(@" And (Item.VendorID={0} or IsNull(PurchaseOrderDetails.Quantity,0) > 0 ) AND Item.ItemType = {1} ", vendorId, ItemTypes.RawMaterial.GetHashCode());
                        purchaseOrderDetailsJoin = string.Format(@" left Join PurchaseOrderDetails on Pack.PackID = PurchaseOrderDetails.PackID and PurchaseOrderID = '{0}' ",purchaseOrderId);
                        purchaseOrderQtySelection = " , IsNull(PurchaseOrderDetails.Quantity,0) as PurchaseOrderQty";
                    }
                    else
                    {
                        poFilter = string.Format(@" And Item.VendorID={0} AND Item.ItemType = {1} ", vendorId, ItemTypes.RawMaterial.GetHashCode());
                    }
                }
                #endregion
                #endregion
                #region SSCC
                string loadItemsFilter = string.Empty;
                if (processMode == ItemFormProcessMode.SSCCFromLoadExecute && editedTransactionItemIds != null && editedTransactionPackIds != null)// && _requestRepository.Configurations.EnableGeneratingSSCC && !string.IsNullOrEmpty(ssccBarcode))
                {
                    //otherSSCCJoin =string.Format( @"Left outer join SSCCDetails on SSCCDetails.PackId=Pack.PackId");
                    //quantityFromOtherSSCC = ",sum(SSCCDetails.Quantity) SSCCQuantities";
                    loadItemsFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                }
                #endregion
                #region Check Secondary Pack in Order
                string secondaryPackJoin = string.Empty;
                string secondaryPackSelection = string.Empty;
                if (processMode == ItemFormProcessMode.Orders && !onlyCRMItems)
                {
                    secondaryPackJoin = " left outer join SecondaryPack on SecondaryPack.ItemID=item.ItemID ";
                    secondaryPackSelection = ",CASE WHEN SecondaryPack.ItemID IS NULL THEN 0 ELSE 1 END AS HasSecondaryPack ";
                }

                #endregion
                #region[Requested By division]
                string requestedByDivisionAccess = string.Empty;
                if (processMode == ItemFormProcessMode.LoadRequest && requestedBy != -1)
                {
                    requestedByDivisionAccess = string.Format("INNER JOIN EmployeeDivision RequestedByDivision ON RequestedByDivision.DivisionID = ItemCategory.DivisionID AND RequestedByDivision.EmployeeID = {0}", requestedBy);
                }
                #endregion
                #region [Packing]
                string packingFilter = "";
                string packingSelection = "";
                if (processMode == ItemFormProcessMode.Packing)
                {
                    packingFilter = string.Format(" and pack.Quantity = 1 and item.ItemType = {0} ", ItemTypes.TradingItem.GetHashCode());
                    packingSelection = " , isnull(item.ShelfLifeTime,0) ShelfLifeTime ";
                }
                #endregion


                #region [Serial Reassignmen]
                string serialReassignmentJoin = string.Empty;
                if (processMode == ItemFormProcessMode.SerialReassignment)
                {
                    serialReassignmentJoin = string.Format("INNER JOIN  SerialCurrentStatus on  SerialCurrentStatus.PackID =Pack.PackID  " +
                        "And ((SerialCurrentStatus.SerialStatusID = {0}) " +
                        "OR (SerialCurrentStatus.SerialStatusID = {1}) " +
                        "OR (SerialCurrentStatus.SerialStatusID = {2})) " +
                        "And SerialCurrentStatus.CustomerID = {3} " +
                        "And SerialCurrentStatus.OutletID = {4} " +
                        "inner join ItemExtraInfo on Item.ItemID = ItemExtraInfo.ItemID and ItemExtraInfo.AllowReassign = 1", SerialStatus.SoldToCustomer.GetHashCode(),
                        SerialStatus.ManuallySold.GetHashCode(), SerialStatus.Reassign.GetHashCode(), customerId, outletId);
                }

                #endregion

                #region [ReturnBatchesfromInvoices]
                if ((processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.ProcessReturn || processMode == ItemFormProcessMode.Return)
                    && _requestRepository.Configurations.RestrictReturnFromInvoices
                    && !string.IsNullOrEmpty(allowedItemsInReturn))
                {
                    filterItemsInReturnOrder = $@" and Item.ItemId in ({allowedItemsInReturn})";
                }
                #endregion
                //#region [BACK TO STORE OFFLOAD]
                //string backToStoreJoin = string.Empty;
                //string backToStoreTempTable = string.Empty;
                //string backToStoreResendTable = string.Empty;
                //string itemExtraInfoJoin = string.Empty; 
                //string whereAllowReturn = string.Empty; 
                //if (processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                //{
                //    string includeLoadedSerials = string.Empty;
                //    if(processMode == ItemFormProcessMode.ResendHelloJordan)
                //    {

                //        backToStoreResendTable = string.Format(@"DECLARE @Table2 AS TABLE (PackID INT);
                //                                                 INSERT INTO @Table2 SELECT DISTINCT SCS.PACKID FROM SerialCurrentStatus SCS
                //                                                 INNER  join SerialTransTracking STT on STT.FromSerial = SCS.FromSerial and STT.SerialStatusID = {0}
                //                                                 WHERE SCS.SerialStatusID IN({1});",
                //                                                 SerialStatus.BackToStore.GetHashCode(), SerialStatus.LoadedToMainWarehouse.GetHashCode());
                //        includeLoadedSerials = " INNER JOIN @Table2 TT ON T.PackID = Pack.PackID";
                //        //includeLoadedSerials = string.Format(@",{0}",SerialStatus.LoadedToMainWarehouse.GetHashCode());
                //    }
                //    backToStoreTempTable = string.Format(@"DECLARE @Table1 AS TABLE (PackID INT);
                //                                INSERT INTO @Table1 SELECT DISTINCT PACKID FROM SerialCurrentStatus WHERE SerialStatusID IN({0}, {1}) {2};",
                //                                SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode(), backToStoreResendTable);
                //    backToStoreJoin = "INNER JOIN @Table1 t ON t.PackID = Pack.PackID" + includeLoadedSerials;
                //    itemExtraInfoJoin = "inner join ItemExtraInfo IEF on IEF.ItemID = Item.ItemID";
                //    whereAllowReturn = " And IEF.AllowReturn = 1";
                //}
                //#endregion
                #region [BACK TO STORE OFFLOAD]
                string backToStoreJoin = string.Empty;
                string backToStoreTempTable = string.Empty;
                string itemExtraInfoJoin = string.Empty;
                string whereAllowReturn = string.Empty;
                if (processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                {
                    if (processMode == ItemFormProcessMode.ResendHelloJordan)
                    {

                        backToStoreTempTable = string.Format(@"DECLARE @Table AS TABLE (PackID INT);
                                                                   INSERT INTO @Table SELECT DISTINCT SCS.PACKID FROM SerialCurrentStatus SCS
                                                                   INNER join SerialTransTracking STT on STT.FromSerial = SCS.FromSerial and STT.SerialStatusID = {0}
                                                                   WHERE SCS.SerialStatusID in({0},{1},{2})",
                                                SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode(),SerialStatus.LoadedToMainWarehouse.GetHashCode());

                    }
                    else
                    {
                        backToStoreTempTable = string.Format(@"DECLARE @Table AS TABLE (PackID INT);
                                                INSERT INTO @Table SELECT DISTINCT PACKID FROM SerialCurrentStatus WHERE SerialStatusID IN({0}, {1});",
                                                    SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode());
                    }
                    backToStoreJoin = "INNER JOIN @Table t ON t.PackID = Pack.PackID";
                    itemExtraInfoJoin = "inner join ItemExtraInfo IEF on IEF.ItemID = Item.ItemID";
                    whereAllowReturn = " And IEF.AllowReturn = 1";
                }
                #endregion

                #region[Items Main Select]
                if (processMode == ItemFormProcessMode.SSCCFromDelivery)
                    orderByFilter = "ORDER BY ItemLanguage.Description, seq,Item.ItemCode, PackTypeLanguage.Description";
                else
                    orderByFilter = " ORDER BY Item.ItemID,CASE WHEN Pack.PackID = Item.DefaultPackID THEN 0 ELSE 1 END,Item.ItemCode, ItemLanguage.Description, seq , PackTypeLanguage.Description";

                string itemQuery = string.Format(@"{9} {47}
                    {10} 
                    {59}
                    {14}
                    {35}
                    {40}
                    {51}
                    {58}
                    SELECT Distinct Item.ItemType ItemTypeId, Item.ItemID ItemId, ItemCategory.ItemCategoryID ItemCategoryId, item.ModelID , Pack.HasSerialNumber,Item.EnableBatchForSerial,Item.AutoGenerateSubSerials,Pack.TemplateID,Pack.GTIN, Pack.PackTypeID PackTypeId, Pack.PackID PackId, Pack.Quantity PiecesInPack,  Pack.SerialSeparator,pack.IsWeightPriced ,ItemCategory.DivisionID,
                    PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, ItemCategoryLanguage.Description Category, ItemCategory.ItemCategoryCode CategoryCode, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END AS HasImage, item.RequiredByLiter,CASE WHEN Pack.PackID = Item.DefaultPackID THEN 0 ELSE 1 END IsDefault
                    ,isnull( PackSerialTrimRule.StartTrimDigits,-1)  PackTrimSerialStartDigits,isnull(PackSerialTrimRule.EndTrimDigits,-1) PackTrimSerialEndDigits, IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as itemCodeName, item.InStock, item.InSCS , Pack.ChildPackID
                    {2}  {16} {5} {18} {26} {28} {32} {34} {36} {39} {45} {48} {52} {55} , prices.MinPrice, prices.MaxPrice, ISNULL(convert(bigint,item.sequence), (select isnull(max(sequence),1)+1 from item))seq      
                    FROM Item
                    LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                    INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                    {46}
                    LEFT JOIN PackOperations on PackOperations.ItemID = Pack.ItemID and PackOperations.packID = Pack.PackID
                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID {17}
                    inner join Division on Division.DivisionID=ItemCategory.DivisionID {60}
                    inner join Organization on Organization.OrganizationID=Division.OrganizationID
                    {1}
                    LEFT OUTER JOIN ItemCategoryLanguage ON ItemCategory.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID AND ItemCategoryLanguage.LanguageID = {0}
                    LEFT OUTER JOIN ItemImage ON ItemImage.ItemID = Item.ItemID
                    INNER JOIN EmployeeDivision ON EmployeeDivision.DivisionID = ItemCategory.DivisionID AND EmployeeDivision.EmployeeID = {4}               
                    Left Outer join PackSerialTrimRule on PackSerialTrimRule.PackID=PAck.PAckID  
                    {43}
                    {30} 
                    {13}
                    {6}
                    {3}
                    {15}
                    {19}
                    {11}
                    {29}
                    {31}
                    {33}
                    {37}
                    {38}
                    {42}
                    {41}
                    {49}
                    {53}
                    {54}
                    WHERE (isnull(Item.Inactive,0) = 0) AND (Item.ItemType NOT IN ({24} 7,9)) {57}
                    {7} {8} {12} {20} {21} {22} {23} {25} {38} {44} {50}
                    {56}",
                    _requestRepository.LanguageId, //0
                    crmQueryFilter, //1
                    priceSelection, //2
                    priceQuery, //3
                    _requestRepository.CurrentOperator.EmployeeId, //4
                    string.Empty,//stockSelection, //5
                    string.Empty,//stockQuery, //6
                   string.Empty,// stockLimitConditionInMainQuery, //7
                    zeroPriceFilter,//8
                    priceTableQuery, //9
                    itemsListSelection, //10
                    itemsListJoin, //11
                    itemsListWhere, //12
                    orderItemsFilter, //13
                    retailQuery, //14
                    retailJoin, //15
                    retailSelection, //16
                    divisionFilter, //17
                    vehicleSelectedQuantity,//18
                    vehicleQtyJoin,  //19
                    operationFilter, //20
                    serialItemsFilter, //21
                    filterTransferInItems, //22
                    poFilter, //23
                    orderExcludeContainers,//24
                    loadItemsFilter, //25
                    salesTypeSelection, //26
                    orderBySalesTransactionType, //27
                    mainWarehouseSelectedQuantity, // 28
                    mainWHQtyJoin, //29
                    requestedByDivisionAccess, //30
                    stockCountingfilter, //31
                    secondaryPackSelection,//32
                    secondaryPackJoin, //33
                    discountsForDeliverySelection, //34
                    consumerPriceQuery, //35
                    consumerPriceSelection, //36
                    consumerPriceJoin, //37
                    packingFilter, //38
                    packingSelection, //39
                    backToStoreTempTable, //40
                    serialReassignmentJoin, //41
                    backToStoreJoin, //42
                    itemExtraInfoJoin, //43
                    whereAllowReturn, //44
                    purchaseOrderQtySelection, //45
                    purchaseOrderDetailsJoin, //46
                    string.Empty,////stockOrderTable, //47
                    string.Empty,//stockOrderSelection, //48
                    string.Empty,//stockOrderJoin, //49
                    filterItemsInReturnOrder, //50
                    costPriceQuery, //51
                    costPriceSelection, //52
                    costPriceJoin, //53
                    warehouseCategoryFilter, // 54
                    stockStatusDetailsSelection, //55
                    orderByFilter, //56
                    limitItemsToMainWarehouseCondition, //57
                    string.Empty,//itemStockTable, //58
                    itemListForLoadAndOff, // 59
                    customerOrganizationCheck // 60
                    );

                Stopwatch stopWatch = new Stopwatch();
                stopWatch.Start();

                result = dbHelper.GetQueryList(itemQuery, ref itemList);

                stopWatch.Stop();
                TimeSpan ts = stopWatch.Elapsed;

                string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}",ts.Hours, ts.Minutes, ts.Seconds,ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId,MethodBase.GetCurrentMethod().DeclaringType.FullName,System.Reflection.MethodBase.GetCurrentMethod().Name,itemQuery,elapsedTime);

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                itemList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExecuteCRMItemsWithStockStatusProcedure(int customerId, int outletId, string warehouseIds, int customerOrganizationId, bool includeTax, ref List<CRMSimpleItemPackModel> itemList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                
                int daysStart = 0;
                int daysEnd = 0;
                if (_requestRepository.Configurations.EnableBookedQuantity)
                {
                    string BookedQtyPeriod = _requestRepository.Configurations.BookedQtyPeriod;
                    if (!string.IsNullOrEmpty(BookedQtyPeriod) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim()) && BookedQtyPeriod.Trim().Split(',') != null && BookedQtyPeriod.Trim().Split(',').Length == 2)
                    {
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0].Trim()))
                        {
                            daysStart = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[0].Trim());
                        }
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1].Trim()))
                        {
                            daysEnd = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[1].Trim());
                        }
                    }
                }
                string itemQuery = string.Empty;
                if (DBManager.CheckIfProcedureExisted(CoreDataBaseConstants.ProceduresConstants.CRMItemsWithStockStatus))
                {
                    DBHelper<CRMSimpleItemPackModel> dbHelper = new DBHelper<CRMSimpleItemPackModel>();

                    

                    itemQuery = $@" EXEC {CoreDataBaseConstants.ProceduresConstants.CRMItemsWithStockStatus}
                    @EmployeeID = {_requestRepository.CurrentOperator.EmployeeId},
                    @CustomerID = {customerId},
                    @OutletID = {outletId},
                    @DefaultPriceListID = {_requestRepository.Configurations.DefaultPriceListID},
                    @WarehouseID = {Int32.Parse(warehouseIds)},
                    @CustomerOrganizationID = {customerOrganizationId},
                    @LanguageID = {_requestRepository.LanguageId},
                    @StarDateForBooked = {daysStart},
                    @EndDateForBooked = {daysEnd},
                    @CalculateBookedQty = {_requestRepository.Configurations.EnableBookedQuantity.GetHashCode()},
                    @CalculateBlockedQty = {_requestRepository.Configurations.EnableBlockedQuantity.GetHashCode()},
                    @RestrictCustomerOrganization = {_requestRepository.Configurations.RestrictDataToCustomerOrganization.GetHashCode()},
                    @OrganizationAccess = '{_requestRepository.CurrentOperator.OrganizationAccess}',
                    @PriceEditableSalesOrderTypes = '{ (!string.IsNullOrEmpty(_requestRepository.Configurations.EditableSalesOrderTypePrices) ? _requestRepository.Configurations.EditableSalesOrderTypePrices : "-1")}',
                    @IncludeTax = {includeTax.GetHashCode()},
                    @StockStatusMode = { (_requestRepository.Configurations.ConsiderStockStatusInOrderFlow && _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock).GetHashCode()}; ";

                    Stopwatch stopWatch = new Stopwatch();
                    stopWatch.Start();

                    result = dbHelper.GetQueryList(itemQuery, ref itemList);

                    stopWatch.Stop();
                    TimeSpan ts = stopWatch.Elapsed;

                    string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                    ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, itemQuery, elapsedTime);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CRMGetAllItemsNew(int selectedEmployeeId, int divisionId, int stockWarehouseId, int detailsWarehouseId, int refWarehouseId, int customerId, int outletId, ItemFormProcessMode processMode, ref List<CRMItemPackModel> itemList, bool onlyCRMItems, bool includePrices, bool joinWithStock, bool includeTax, string editedTransactionItemIds, string editedTransactionPackIds, string orderSignature, int vendorId, bool isQualityControl, bool allowAddingNewItems, int requestedBy, string stockCountingTaskId, string purchaseOrderId, string loadingWarehouses, string excludedOrderID, bool showQuantityInOrder, bool restrictReturnItemIds, string allowedItemsInReturn, int sdcId, int orderTypeId)
        {
            itemList = new List<CRMItemPackModel>();
            DBHelper<CRMItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Check Items List Assignment]
                string itemsListSelection = string.Empty;
                string itemsListJoin = string.Empty;
                string itemsListWhere = string.Empty;
                string divisionFilter = string.Empty;
                string vehicleQtyJoin = string.Empty;
                string mainWHQtyJoin = string.Empty;
                string vehicleSelectedQuantity = string.Empty;
                string mainWarehouseSelectedQuantity = string.Empty;
                string serialItemsFilter = " and pack.HasSerialNumber=0";
                string filterTransferInItems = "";
                string orderExcludeContainers = string.Empty;
                string purchaseOrderDetailsJoin = string.Empty;
                string purchaseOrderQtySelection = string.Empty;
                string filterItemsInReturnOrder = string.Empty;
                string warehouseCategoryFilter = string.Empty;
                string transferCategoryFilter = string.Empty;
                string itemStockSelection = string.Empty;
                string orderByFilter = string.Empty;
                string itemsListSelectionCust = string.Empty;
                string itemListForLoadAndOff = string.Empty;
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel && divisionId != -1)
                {
                    divisionFilter = string.Format(" and ItemCategory.DivisionID = {0} ", divisionId);
                }
                if (processMode == ItemFormProcessMode.ExchangeReturn && _requestRepository.Configurations.LinkItemsToWarehouse && _requestRepository.Configurations.RestoreBOReturnToWarehouse)
                {
                    refWarehouseId = int.Parse(loadingWarehouses);
                }
                if (_requestRepository.Configurations.LinkItemsToWarehouse &&
                    (processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.OutputVoucher
                    || processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.TransferIn
                    || processMode == ItemFormProcessMode.MoveOrder || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.StockCounting
                    || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad || ((processMode == ItemFormProcessMode.Return || processMode == ItemFormProcessMode.ExchangeReturn) && _requestRepository.Configurations.RestoreBOReturnToWarehouse)))
                {
                    if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.MoveOrder || (processMode == ItemFormProcessMode.TransferIn && _requestRepository.Configurations.AllowEditItemInTransfer))
                        transferCategoryFilter = string.Format(@" INNER JOIN WarehouseCategory destinationCategory ON destinationCategory.ItemCategoryID = WarehouseCategory.ItemCategoryID AND destinationCategory.WarehouseID = {0} ", processMode == ItemFormProcessMode.TransferIn ? detailsWarehouseId : refWarehouseId);
                    warehouseCategoryFilter = string.Format(@" INNER JOIN WarehouseCategory on WarehouseCategory.ItemCategoryID = Item.ItemCategoryID and WarehouseCategory.WarehouseID = {0} {1} ", (processMode == ItemFormProcessMode.OffLoad || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ExchangeReturn) ? refWarehouseId : stockWarehouseId, transferCategoryFilter);
                }
                if (processMode == ItemFormProcessMode.Orders)
                {
                    orderExcludeContainers = "2,";
                }
                if (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad || processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.OutputVoucher || processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.Sales || processMode == ItemFormProcessMode.ConsignmentOrder || processMode == ItemFormProcessMode.SerialReassignment)
                {
                    string itemListMainQuery = string.Empty;
                    if (processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.ConsignmentOrder || processMode == ItemFormProcessMode.Sales || processMode == ItemFormProcessMode.SerialReassignment)
                    {
                        itemsListSelectionCust = string.Format(@"

                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerGroup CG ON CG.ChannelID = ItemsListAssignment.ChannelID AND CG.SubChannelID = ItemsListAssignment.SubChannelID
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND COG.CustomerID = {0} and COG.OutletID = {1}
                    WHERE ItemsListAssignment.SubChannelID IS NOT NULL AND ItemsListAssignment.ChannelID IS NOT NULL
                    UNION
                   
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = ItemsListAssignment.CustomerGroupID AND COG.CustomerID = {0} and COG.OutletID = {1}
                    WHERE ItemsListAssignment.CustomerGroupID IS NOT NULL
                    UNION
                    
                    SELECT distinct ItemsListAssignment.ItemListID 
                    FROM ItemsListAssignment
                    WHERE ItemsListAssignment.CustomerID IS NOT NULL AND ItemsListAssignment.OutletID IS NOT NULL AND CustomerID = {0} and OutletID = {1}
                    UNION
                   
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment 
                    WHERE ItemsListAssignment.AllCustomers = 1
                    UNION", customerId, outletId);
                    }

                    itemListMainQuery = @"Declare @{2} table (ItemListID int, ItemID int)
                    Insert into @{2}
                    SELECT DISTINCT IL.ItemListID, ItemsListDetails.ItemID FROM (

                    {0}

                    SELECT distinct ItemListEmployee.ItemListID 
                    from ItemListEmployee 
                    INNER JOIN Employee ON Employee.EmployeeID = ItemListEmployee.EmployeeID 
					INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = ItemListEmployee.ItemListID AND Employee.EmployeeID = {1}
                    UNION 

                    SELECT distinct ItemListEmployee.ItemListID 
                    FROM ItemListEmployee 
                    WHERE ItemListEmployee.EmployeeID = -1                   
                    ) T 
                    INNER JOIN ItemsList IL ON IL.ItemListID = T.ItemListID
                    INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = IL.ItemListID ";

                    itemsListSelection = string.Format(itemListMainQuery, itemsListSelectionCust, processMode == ItemFormProcessMode.Orders ? requestedBy : _requestRepository.CurrentOperator.EmployeeId, "ItemsListDummy");

                    if (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad)
                    {
                        itemListForLoadAndOff = string.Format(itemListMainQuery, itemsListSelectionCust, requestedBy, "ItemsListDummyRequest");
                        itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1  LEFT OUTER JOIN @ItemsListDummyRequest ILR on 1=1 ";
                        itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) )  And ( (ILR.ItemListID is null) OR (ILR.ItemListID is not null and ILR.ItemID = Item.ItemID) ) ";
                    }
                    else
                    {
                        itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1 ";
                        itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) ) ";
                    }
                }
                #endregion

                dbHelper = new DBHelper<CRMItemPackModel>();

                #region[CRM]
                string crmQueryFilter = string.Empty;

                bool isBRFCRM = false;
                string stockStatusDetailsSelection = string.Empty;
                if (onlyCRMItems)
                {
                    isBRFCRM = _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;
                    if (isBRFCRM)
                    {
                        string priceEditableSalesOrderTypes = _requestRepository.Configurations.EditableSalesOrderTypePrices;
                        priceEditableSalesOrderTypes = !string.IsNullOrEmpty(priceEditableSalesOrderTypes) ? priceEditableSalesOrderTypes : "-1";
                        stockStatusDetailsSelection = $" , prices.ApprovalPrice , SSC.Description Color , prices.SalesOrderTypeID, ItemStock.StockStatusID, ItemStock.SalesOrderTypeId, ItemStock.PriceEditable, CASE WHEN ItemStock.SalesOrderTypeID in ({priceEditableSalesOrderTypes}) THEN 0 ELSE 1 END as DisableEditPrice ";
                        joinWithStock = true;
                    }
                    if (!_requestRepository.Configurations.RemoveHomeAndOfficesConceptFromCRM)
                    {
                        crmQueryFilter = " INNER JOIN HomeAndOfficeItemCategory ON HomeAndOfficeItemCategory.ItemCategoryID = ItemCategory.ItemCategoryID ";
                    }
                }
                #endregion

                #region[Price]
                string priceSelection = string.Empty;
                string consumerPriceQuery = string.Empty;
                string consumerPriceJoin = string.Empty;
                string consumerPriceSelection = string.Empty;
                string priceQuery = string.Empty;
                string priceTableQuery = string.Empty;
                string zeroPriceFilter = string.Empty;
                string retailSelection = string.Empty;
                string retailQuery = string.Empty;
                string retailJoin = string.Empty;
                string costPriceQuery = string.Empty;
                string costPriceSelection = string.Empty;
                string costPriceJoin = string.Empty;
                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")";
                if (includePrices)
                {
                    bool excludeZeroPrice = processMode == ItemFormProcessMode.Sales || (processMode == ItemFormProcessMode.Orders && string.IsNullOrEmpty(allowedItemsInReturn)) || processMode == ItemFormProcessMode.ConsignmentOrder || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.RestrictReturnFromInvoices);
                    if (excludeZeroPrice)
                    {
                        if (!string.IsNullOrEmpty(editedTransactionPackIds))
                        {
                            zeroPriceFilter = string.Format(" And (Pack.PackID in ({0}) OR (Prices.PackID Is not Null and Prices.Price > 0)) ", editedTransactionPackIds);
                        }
                        else
                        {
                            zeroPriceFilter = " And (Prices.PackID Is not Null and Prices.Price > 0) ";
                        }
                    }

                    #region[Tax]
                    //bool getTax = Configurations.AllowTax && CustomerManager.IsTaxableOutlet(customerId, outletId);
                    string taxSelection = " 0 As Tax";
                    string promotedItemBaseTax = string.Empty;
                    if (includeTax)
                    {
                        if (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery && !_requestRepository.Configurations.AllowTaxOverFreeItems)
                        {
                            promotedItemBaseTax = " , ISNULL(prices.tax, 0) BaseTax ";
                            taxSelection = $@" CASE WHEN SalesOrderDetail.SalesTransactionTypeID <> {SalesTransactionTypes.Promotion.GetHashCode()} then ISNULL(prices.tax, 0) else 0 end Tax ";
                        }
                        else
                        {
                            taxSelection = " ISNULL(prices.tax, 0) As Tax ";
                        }
                    }
                    #endregion

                    #region [CostPrice] 

                    if (processMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.CheckCostPrice)
                    {
                        costPriceQuery = $@"DECLARE @CostPriceTable as Table (PackID INT, Price numeric(19,9));
                            INSERT INTO @CostPriceTable 
                            SELECT PackID, Price FROM (
                            SELECT PackID, Price, ROW_NUMBER() OVER (PARTITION BY PACKID ORDER BY PriceDefinition.PriceListID) Num FROM PriceDefinition INNER JOIN pricelist on pricelist.PriceListID = PriceDefinition.PriceListID 
                            Where PriceListTypeID = {PriceListTypes.CostPrice.GetHashCode()} 
                            AND PriceList.OrganizationID in({_requestRepository.CurrentOperator.OrganizationAccess})
                            {priceDateFilter}) as tt WHERE tt.Num = 1";
                        costPriceJoin = " LEFT JOIN @CostPriceTable as costPrice ON costPrice.PackID = Pack.PackID  ";
                        costPriceSelection = " , ISNULL(costPrice.Price, 0) as CostPrice ";
                    }

                    #endregion

                    #region[Retail Tax]
                    if (includeTax && _requestRepository.Configurations.AllowRetailTaxOnItemsForCustomer(customerId, outletId))
                    {
                        retailSelection = " ,ISNULL(retailPrices.price,0) as RetailPrice,ISNULL(retailPrices.tax,0) as RetailTax,(ISNULL(retailPrices.price,0)* ISNULL(retailPrices.tax,0))/100 as RetailValue ";
                        retailJoin = " left outer join @Retail as retailPrices on retailPrices.packid=pack.PackID ";
                        retailQuery = string.Format(@"    declare @Retail table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int)
                                    insert into @Retail
                                    SELECT distinct packID , isnull(retailPrices.Price,0) price, isnull(retailPrices.Tax,0)tax, 
                                    retailPrices.PriceListID                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                     PriceDefinition.CurrencyID              
                                    from PriceDefinition                      
                                    inner join(                      
                                                  
                                    select PriceListID from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({0}) ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={1}  AND (PriceList.StartDate <=  {2} )AND (PriceList.EndDate >=   {3} )
                                    ) as retailPrices 
                                    WHERE  (retailPrices.PriceListID is not null)", _requestRepository.Configurations.DefaultRetailPriceListID, PriceListTypes.Retail.GetHashCode(), LocalUtilities.ParseDateToSQLString(DateTime.Now), LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                    }
                    else
                    {
                        retailSelection = " ,0 as RetailPrice,0 as RetailTax ,0 as RetailValue";
                    }

                    #endregion
                    int defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                    if (selectedEmployeeId != -1 && (processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad))
                    {
                        var config = _requestRepository.Configurations.GetConfigurationValue("DefaultPriceListID", selectedEmployeeId);
                        if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                        {
                            defaultPriceListId = int.Parse(config.KeyValue.Trim());
                        }
                    }
                    if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.OutputVoucher)
                    {
                        int whOrganizationId = -1;
                        DBHelper<int> dBHelper = new DBHelper<int>();
                        object field = null;
                        string orgQuery = $" select ISNULL(OrganizationID, -1) OrganizationID from Warehouse Where warehouseId = {detailsWarehouseId}";
                        result = dBHelper.ExecuteScalar(orgQuery, ref field);
                        if (result != GlobalErrors.Success) return GlobalErrors.Error;

                        if (field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            whOrganizationId = int.Parse(field.ToString());
                        }
                        var config = _requestRepository.Configurations.GetConfigurationOnOrganization("DefaultPriceListID", whOrganizationId);
                        if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                        {
                            defaultPriceListId = int.Parse(config.KeyValue.Trim());
                        }
                        else
                        {
                            defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                        }
                    }
                    string sdcPrice = string.Empty;
                    if (_requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1)
                    {
                        sdcPrice = $@" UNION
				                        select PriceListID, 5 as priority FROM SDCPrice
				                        where SDCId = {sdcId}";
                    }
                    string promotedItemBasePrice = processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery ? @$" , ISNULL(prices.price, 0) BasePrice " : "";
                    string itemPrice = (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery) ?
                        $" CASE WHEN SalesOrderDetail.SalesTransactionTypeID <> {SalesTransactionTypes.Promotion.GetHashCode()} then ISNULL(prices.price, 0) else 0  end Price {promotedItemBasePrice}"
                        : " ISNULL(prices.price, 0) Price";
                    string returnPriceListUnion = string.Empty;
                    string returnPriceTable = string.Empty;
                    string returnPriceJoin = string.Empty;
                    if (_requestRepository.Configurations.UseReturnPriceListForReturns && (processMode == ItemFormProcessMode.Return || processMode == ItemFormProcessMode.ExchangeReturn))
                    {
                        priceSelection = string.Format(" ,{1}, ISNULL(prices.TaxIncludedInPrice,0) As TaxIncludedInPrice, ISNULL(prices.BasePrice,0) AS BasePrice, ISNULL(prices.PriceListID, -1) UsedPriceListID, {0},CASE WHEN returnPrices.price is not null then returnPrices.price else ISNULL(prices.price, 0)  end as ReturnPrice ,  ISNULL(returnPrices.PriceListID, -1) ReturnUsedPriceListID", taxSelection, itemPrice);
                        returnPriceTable = "declare @returnPrice table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)";
                        returnPriceJoin = " LEFT OUTER JOIN @returnPrice as returnPrices ON returnPrices.PackID = Pack.PackID ";
                        returnPriceListUnion = string.Format(@" Insert into @returnPrice
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax,
                                    prices.PriceListID, prices.priority, prices.rowNumber
		                                    FROM   (
		                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
		                                    tt.priority, PriceDefinition.CurrencyID                      ,
		                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
		                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd
		                                    from PriceDefinition
		                                    inner join (
				                                    select PriceListID, 1 as priority from CustomerPrice
				                                    where CustomerID = {0} and OutletID = {1}
				                                    union
				                                    select PriceListID, 2 as priority from GroupPrice
				                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})
				                                    union
				                                    select PriceListID, 3 as priority from ChannelPrice
				                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in
				                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))
		                                    ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null
		                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0
		                                    and PriceList.PriceListTypeID = {3} {2}
		                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
		                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd )
                                    ) as prices
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null)
                                    and (Prices.PriceListID is not null)",
                                    customerId, //0
                                    outletId, //1
                                    priceDateFilter, //2
                                    PriceListTypes.Return.GetHashCode() // 3
                                   );
                    }
                    else
                    {
                        priceSelection = string.Format(" ,{1}, ISNULL(prices.TaxIncludedInPrice,0) As TaxIncludedInPrice, ISNULL(prices.BasePrice,0) AS BasePrice , ISNULL(prices.PriceListID, -1) UsedPriceListID, {0}, 0 as ReturnPrice ,  -1 ReturnUsedPriceListID", taxSelection, itemPrice);
                    }

                    priceTableQuery = string.Format(@"declare @x table (packid int,price numeric(19,9),tax numeric(19,9), TaxIncludedInPrice numeric(19,9) , BasePrice numeric(19,9) , pricelistid int,priority int,rownumber int,MinPrice numeric(19,9) , MaxPrice numeric(19,9) {9} )
                                    {13}
                                    insert into @x
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, prices.TaxIncludedInPrice , prices.BasePrice ,
                                    prices.PriceListID, prices.priority, prices.rowNumber, MinPrice , MaxPrice {10}
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , {15} , PriceDefinition.Price AS BasePrice,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID {12}  ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd , ISNULL(MinPrice,0) MinPrice, ISNULL(MaxPrice,0) MaxPrice {11}  
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))
                                    {8}
                                    union                      
                                    select PriceListID, {7} as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    
                                    {14}
                                    ", customerId, //0
                                    outletId, //1
                                    defaultPriceListId.ToString(), //2
                                    priceDateFilter, //3
                                   PriceListTypes.General.GetHashCode(), //4
                                   _requestRepository.Configurations.UseReturnPriceListForReturns, // 5
                                   PriceListTypes.Return.GetHashCode(), // 6
                                   _requestRepository.Configurations.EnableSalesDistributionChannel && sdcId > -1 ? "6" : "5", // 7
                                   sdcPrice, //8
                                   isBRFCRM ? ", SalesOrderTypeID INT , ApprovalPrice numeric(19,9) " : string.Empty, //9
                                   isBRFCRM ? ", SalesOrderTypeID ,  ApprovalPrice" : string.Empty, //10
                                   isBRFCRM ? " , ISNULL(SalesOrderTypeID,-1) SalesOrderTypeID ,  PriceDefinition.Price ApprovalPrice  " : string.Empty, //11
                                   isBRFCRM ? " , SalesOrderTypeID " : string.Empty, //12
                                   returnPriceTable, //13
                                   returnPriceListUnion, //14
                                   _requestRepository.Configurations.IncludeTaxInPrice ? " (isnull(PriceDefinition.Tax,0)/100) * isnull(PriceDefinition.Price,0) + PriceDefinition.Price AS price , 0 AS tax, PriceDefinition.Tax As TaxIncludedInPrice " : " PriceDefinition.Price, PriceDefinition.Tax, 0 As TaxIncludedInPrice " //15
                                   );
                    if (isBRFCRM)
                    {
                        priceQuery = string.Format(@" OUTER APPLY (select top(1) * from @x p where p.packid = pack.PackID and (p.SalesOrderTypeID = ItemStock.SalesOrderTypeID OR ISNULL(p.SalesOrderTypeID,-1) = -1) Order by p.priority ) as prices
                                                  {0}", returnPriceJoin);
                    }
                    else
                    {
                        priceQuery = string.Format(@" LEFT OUTER JOIN @x as prices ON prices.PackID = Pack.PackID
                                                  {0}", returnPriceJoin);
                    }


                    if (processMode == ItemFormProcessMode.Orders && _requestRepository.Configurations.CheckConsumerPrice)
                    {
                        consumerPriceQuery = string.Format(@"declare @ConsumerPrice table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
                                    insert into @ConsumerPrice
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
                                    prices.PriceListID, prices.priority, prices.rowNumber                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))
                                    union                      
                                    select PriceListID, 5 as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd)) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    ", customerId, //0
                                    outletId, //1
                                    _requestRepository.Configurations.ConsumerPriceListID.ToString(), //2
                                    priceDateFilter, //3
                                    PriceListTypes.ConsumerPrice.GetHashCode() //4
                                    );
                        consumerPriceJoin = string.Format(@" LEFT OUTER JOIN @ConsumerPrice as consumerPrices ON consumerPrices.PackID = Pack.PackID ");
                        consumerPriceSelection = " ,ISNULL(consumerPrices.price, 0) ConsumerPrice, ISNULL(consumerPrices.PriceListID, -1) consumerPriceListID";
                    }
                }
                else if (processMode == ItemFormProcessMode.LoadRequest && _requestRepository.Configurations.CheckAvailableCreditToLoad.Contains("1"))
                {
                    int defaultPriceListId = _requestRepository.Configurations.DefaultPriceListID;
                    var config = _requestRepository.Configurations.GetConfigurationValue("DefaultPriceListID", selectedEmployeeId);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        defaultPriceListId = int.Parse(config.KeyValue.Trim());
                    }
                    priceSelection = " , ISNULL(PriceDefinition.price, 0) Price";
                    priceQuery = string.Format(@" LEFT OUTER JOIN PriceDefinition ON PriceDefinition.PacKID = Pack.PackID AND  PriceDefinition.PriceListID={0} ", defaultPriceListId.ToString());
                }
                #endregion

                #region[Stock]
                string stockQuery = string.Empty;
                string itemStockTable = string.Empty;
                string stockLimitConditionInMainQuery = string.Empty;
                string limitItemsToMainWarehouseJoin = string.Empty;
                string limitItemsToMainWarehouseCondition = string.Empty;
                string stockSelection = " ,  0 as AvailableQtyInPcs ";

                if (joinWithStock)
                {
                    stockSelection = " , ISNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs, ISNULL(ItemStock.ExistingQty/Pack.Quantity,0) ExistingQty ";
                    string excludeZeroAndMinusStock = string.Empty;
                    string excludeReservedquantity = string.Empty;

                    if (!isQualityControl)
                        excludeReservedquantity = " Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)";
                    else
                        excludeReservedquantity = string.Format(" Where WarehouseStock.PackiD in ({0})", editedTransactionPackIds);

                    // get only postive stock items, and get old saved items even if they don't have stock now
                    if ((processMode != ItemFormProcessMode.Packing && processMode != ItemFormProcessMode.Receiving && processMode != ItemFormProcessMode.LoadRequest && processMode != ItemFormProcessMode.BackToStoreOffload && processMode != ItemFormProcessMode.ResendHelloJordan && processMode != ItemFormProcessMode.InputVoucher && processMode != ItemFormProcessMode.GenerateSerials && processMode != ItemFormProcessMode.PurchaseOrder && processMode != ItemFormProcessMode.TransferIn && processMode != ItemFormProcessMode.StockCounting) || (processMode == ItemFormProcessMode.LoadRequest && _requestRepository.Configurations.AutoExecuteLoadRequestInBO && _requestRepository.Configurations.CheckMainWHStockForLoad) || isBRFCRM)
                    {
                        excludeZeroAndMinusStock = " Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0 ";
                        if (string.IsNullOrEmpty(editedTransactionItemIds) || isBRFCRM)
                        {
                            stockLimitConditionInMainQuery = " And (ItemStock.ItemID Is not Null)";
                        }
                        else
                        {
                            stockLimitConditionInMainQuery = string.Format(" And (ItemStock.ItemID Is not Null OR Item.ItemID in ({0})) ", editedTransactionItemIds);
                        }
                    }

                    string joinWithWarehouseId = string.Empty;
                    if (stockWarehouseId > 0)
                    {
                        joinWithWarehouseId = $" and  WarehouseStock.WarehouseID = {stockWarehouseId}";
                    }
                    if (isBRFCRM && !string.IsNullOrEmpty(loadingWarehouses))
                    {
                        joinWithWarehouseId = $" and  WarehouseStock.WarehouseID in ({loadingWarehouses})";
                    }
                    string stockStatusJoin = string.Empty;
                    string groupByStockStatus = string.Empty;
                    string stockStatusSelection = string.Empty;
                    string stockStatusColorJoin = string.Empty;
                    if (isBRFCRM)
                    {
                        stockStatusJoin = $@" inner join StockStatus SS on SS.StockStatusID = WarehouseStock.StockStatusID 
                                              inner join SalesOrderType on SalesOrderType.SalesOrderTypeID = SS.SalesOrderTypeID";
                        groupByStockStatus = $" , WarehouseStock.StockStatusID , SS.SalesOrderTypeID, SS.ColorID, SalesOrderType.PriceEditable ";
                        stockStatusSelection = $" ,WarehouseStock.StockStatusID , SS.SalesOrderTypeID, SS.ColorID, SalesOrderType.PriceEditable ";
                        itemStockSelection = $" ,StockStatusID int,SalesOrderTypeID int,ColorID int,PriceEditable int ";
                        stockStatusColorJoin = $"  LEFT join StockStatusColors SSC on SSC.ColorID = ItemStock.ColorID and SSC.LanguageID = { _requestRepository.LanguageId}";
                        if (_requestRepository.Configurations.LimitItemsToMainWarehouseStock.Contains(LimitItemsToWarehouseTypes.Order.GetHashCode().ToString()))
                        {
                            limitItemsToMainWarehouseJoin = string.Format(@" inner join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                            limitItemsToMainWarehouseCondition = string.Format(@" and ( ISNull(ItemStock.AvailableQtyInPcs,0) > 0   )");
                        }
                        else
                        {
                            limitItemsToMainWarehouseJoin = string.Format(@" left join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                        }
                    }
                    else
                    {
                        limitItemsToMainWarehouseJoin = string.Format(@" inner join WarehouseStock on WarehouseStock.PackID = pack.PackID {0}", joinWithWarehouseId);
                    }
                    itemStockTable = string.Format(@" declare @ItemStock as table (ItemID int,AvailableQtyInPcs numeric(19,9),ExistingQty numeric(19,9) {7})
                    insert into @ItemStock
                    Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs ,Sum(pack.Quantity * WarehouseStock.Quantity) ExistingQty {5}
                    From pack
                    {6}
                    {3}
                    {2}
                    {1}
                    group by pack.ItemID {4}
                    {0}",
                     excludeZeroAndMinusStock, //0
                     excludeReservedquantity, //1
                     stockStatusJoin, //2
                     string.Empty, //3 
                     groupByStockStatus, //4
                     stockStatusSelection, //5
                     limitItemsToMainWarehouseJoin, //6
                     itemStockSelection //7
                    );
                    stockQuery = string.Format(@" LEFT OUTER join @ItemStock ItemStock on ItemStock.ItemID = Item.ItemID 
                    {0}",
                     stockStatusColorJoin //0
                    );
                    if (processMode == ItemFormProcessMode.SSCCFromLoadExecute || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                    {
                        vehicleQtyJoin = string.Format(@"  left outer join (select pack.itemid ,  IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) VehicleAvailableQtyInPcs from WarehouseStock 
				        inner join Pack on Pack.PackID = WarehouseStock.PackID and WarehouseStock.WarehouseID={0}
                        Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)
				        group by pack.ItemID )vehicleWarehouseStock on vehicleWarehouseStock.ItemID=Item.ItemID", detailsWarehouseId);
                        vehicleSelectedQuantity = ",ISNULL(vehicleWarehouseStock.VehicleAvailableQtyInPcs,0 ) VehicleAvailableQtyInPCs";
                    }
                    else if (processMode == ItemFormProcessMode.OffLoad && refWarehouseId != -1)
                    {
                        mainWHQtyJoin = string.Format(@"  left outer join (select pack.itemid ,  IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) warehouseAvailableQtyInPCs from WarehouseStock 
				        inner join Pack on Pack.PackID = WarehouseStock.PackID and WarehouseStock.WarehouseID={0}
                        Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null)
				        group by pack.ItemID )mainWarehouseStock on mainWarehouseStock.ItemID=Item.ItemID", refWarehouseId);
                        mainWarehouseSelectedQuantity = ",ISNULL(mainWarehouseStock.warehouseAvailableQtyInPCs,0 ) warehouseAvailableQtyInPCs";
                    }
                }
                #endregion
                #region Serials Filter

                if (processMode == ItemFormProcessMode.InputVoucher || processMode == ItemFormProcessMode.OutputVoucher
                    || processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.TransferOut
                    || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.OffLoad
                    || processMode == ItemFormProcessMode.Delivery || processMode == ItemFormProcessMode.PartialDelivery
                    || processMode == ItemFormProcessMode.SSCCFromDelivery
                    || (processMode == ItemFormProcessMode.Orders)
                    || processMode == ItemFormProcessMode.SSCCFromLoadExecute
                    || processMode == ItemFormProcessMode.SSCCFromMainList
                    || processMode == ItemFormProcessMode.StockCounting
                    || processMode == ItemFormProcessMode.Sales
                    || processMode == ItemFormProcessMode.BackToStoreOffload
                    || processMode == ItemFormProcessMode.ResendHelloJordan
                    || processMode == ItemFormProcessMode.SerialReassignment)
                {
                    serialItemsFilter = string.Empty;
                }
                if (processMode == ItemFormProcessMode.SerialsAggregation)
                {
                    serialItemsFilter = " and pack.HasSerialNumber=1 and pack.Quantity>1";
                }
                if (processMode == ItemFormProcessMode.GenerateSerials)
                {
                    serialItemsFilter = " and pack.HasSerialNumber = 1 ";
                }
                #endregion
                #region DeliveryMode
                string orderItemsFilter = string.Empty;
                string salesTypeSelection = string.Empty;
                string discountsForDeliverySelection = string.Empty;
                string orderBySalesTransactionType = string.Empty;
                OrderModel orderModel = new OrderModel();
                if ((processMode == ItemFormProcessMode.Delivery || processMode == ItemFormProcessMode.PartialDelivery || processMode == ItemFormProcessMode.SSCCFromDelivery || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.AllowPartialDeliveryInProcessReturn)) && !string.IsNullOrEmpty(orderSignature))
                {
                    string salesTypeFilter = string.Empty;
                    string filterItems = string.Empty;
                    if (processMode == ItemFormProcessMode.SSCCFromDelivery)
                    {
                        salesTypeSelection = ",SalesOrderDetail.SalesTransactionTypeID , SalesOrderDetail.Quantity, SalesOrderDetail.BatchNo, SalesOrderDetail.ExpiryDate ";
                        orderBySalesTransactionType = "SalesOrderDetail.SalesTransactionTypeID,";
                        if (!string.IsNullOrEmpty(editedTransactionItemIds) && !string.IsNullOrEmpty(editedTransactionPackIds))
                        {
                            filterItems = string.Format(" and Pack.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                        }
                    }
                    else
                    {
                        if (processMode == ItemFormProcessMode.Delivery && _requestRepository.Configurations.AllowBatchSelectionInDelivery == true)
                        {
                            salesTypeFilter = string.Empty;
                            salesTypeSelection = ",SalesOrderDetail.SalesTransactionTypeID";
                        }
                        else
                        {
                            salesTypeFilter = string.Format(" and SalesOrderDetail.SalesTransactionTypeID={0} ", (processMode != ItemFormProcessMode.ProcessReturn ? SalesTransactionTypes.Sales.GetHashCode() : SalesTransactionTypes.None.GetHashCode()));
                        }
                        discountsForDeliverySelection = $@" ,SalesOrderDetail.AllItemDiscount, SalesOrderDetail.ItemPromotedDiscount ,SalesOrderDetail.PromotedDiscount,  
                            CASE WHEN SalesOrderDetail.SalesTransactionTypeID = {(int)SalesTransactionTypes.Sales} then
                            salesorderdetail.AllItemDiscount / 
                            ((SalesOrderDetail.Price * SalesOrderDetail.Quantity - (SalesOrderDetail.Price * SalesOrderDetail.Quantity * SalesOrderDetail.ItemPromotedDiscount / 100 )) /
                            (SalesOrderDetail.Price * SalesOrderDetail.Quantity)) else 0 end as OriginalAllItemDiscount ";
                    }
                    orderModel.GetOrderDataFromSignature(orderSignature);
                    orderItemsFilter = string.Format(@" inner join SalesOrderDetail with (nolock) on SalesOrderDetail.PackID=pack.PackID and SalesOrderDetail.OrderID='{0}' 
and SalesOrderDetail.CustomerID={1} and SalesOrderDetail.OutletID={2} and SalesOrderDetail.DivisionID={3} {4} {5}"
, orderModel.OrderId, orderModel.CustomerId, orderModel.OutletId, orderModel.DivisionId, salesTypeFilter, filterItems);
                    if (processMode == ItemFormProcessMode.PartialDelivery || processMode == ItemFormProcessMode.SSCCFromDelivery || (processMode == ItemFormProcessMode.ProcessReturn && !_requestRepository.Configurations.AllowPartialDeliveryInProcessReturn))
                    {
                        stockQuery = string.Format(@"   LEFT OUTER join(
                    Select pack.ItemID, Sum(pack.Quantity * SalesOrderDetail.Quantity) AvailableQtyInPcs
                    From pack
                    inner join SalesOrderDetail on SalesOrderDetail.PackID = pack.PackID  and SalesOrderDetail.OrderID = '{0}' and SalesOrderDetail.CustomerID = {1} and SalesOrderDetail.OutletID = {2} and SalesOrderDetail.DivisionID = {3}  {4} {5}
                    group by pack.ItemID
                     Having Sum(pack.Quantity * SalesOrderDetail.Quantity) > 0
                    ) ItemStock on ItemStock.ItemID = Item.ItemID ", orderModel.OrderId, orderModel.CustomerId, orderModel.OutletId, orderModel.DivisionId, salesTypeFilter, filterItems);
                        stockSelection = ", ISNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs";
                    }


                }
                #endregion
                #region [Order]
                string stockOrderTable = string.Empty;
                string stockOrderSelection = string.Empty;
                string stockOrderJoin = string.Empty;

                string orderIdFilter = string.Empty;
                string loadingWarehousesIdsFilter = string.Empty;
                string warehouseFilterForPendingOrders = string.Empty;
                string includeOrderQty = string.Empty;
                string includeLoadRequestQty = string.Empty;
                string bookedJoin = string.Empty;
                string bookedLoadRequestsJoin = string.Empty;
                string bookedSelection = string.Empty;
                string bookedLoadRequestSelection = string.Empty;

                if (processMode == ItemFormProcessMode.Orders && showQuantityInOrder)
                {
                    if (!string.IsNullOrEmpty(excludedOrderID))
                    {
                        orderIdFilter = string.Format(" and SO.OrderID != '{0}' ", excludedOrderID);
                    }

                    if (!string.IsNullOrEmpty(loadingWarehouses))
                    {
                        warehouseFilterForPendingOrders = string.Format(@" And ((Employee.EmployeeTypeID != 1 and SO.EmployeeID in (select EmployeeID from EmployeeVehicle 
                        where VehicleID in (select VehicleID from VehicleLoadingWh where warehouseid in ({0})))) 
                        or Employee.EmployeeTypeID = 1) ", loadingWarehouses);

                        loadingWarehousesIdsFilter = string.Format("and w.WarehouseID in ({0})", loadingWarehouses);
                    }
       
                    bookedSelection = string.Format(@"0 bookedQty");
                    bookedLoadRequestSelection = string.Format(@" 0 bookedQtyForLoadReq  ");

                    stockOrderTable = string.Format(@" declare @orderQty as table (ItemID int, bookedQty numeric(38,9), stockQty numeric(38,9), bookedQtyForLoadReq numeric(38,9))
                    insert into @orderQty
                    
					Select Item.ItemID, {2}, availableStock.stockQty, {3}  
					from Item
            
                    {4}

                    LEFT OUTER join(
                    select pack.ItemID, isnull(sum(WS.quantity*Pack.quantity),0) stockQty 
                    from warehousestock WS
                    inner join Warehouse w on WS.warehouseID = w.warehouseID and W.OrganizationID in ({0}) and w.WarehouseTypeID = 1 {1}
                    inner join pack on pack.packID = WS.PackID 
                    group by pack.ItemID) availableStock on availableStock.ItemID = Item.ItemID

                    {5}
                    where item.Inactive <> 1",
                     _requestRepository.CurrentOperator.OrganizationAccess, //0
                     loadingWarehousesIdsFilter, //1
                     bookedSelection, //2
                     bookedLoadRequestSelection, //3
                     bookedJoin, //4
                     bookedLoadRequestsJoin //5
                     );

                    stockOrderSelection = @" , isnull(orderQty.stockQty,0) as onHandQty, (isnull(orderQty.bookedQty,0) + isnull(orderQty.bookedQtyForLoadReq,0)) as reservedQty, (isnull(orderQty.stockQty,0) - (isnull(orderQty.bookedQty,0) + isnull(orderQty.bookedQtyForLoadReq,0))) as stockQty  ";
                    stockOrderJoin = @" LEFT OUTER JOIN @orderQty as orderQty ON orderQty.ItemId = Pack.ItemId  ";
                }
                #endregion

                #region Transfer In Items Filter
                if (processMode == ItemFormProcessMode.TransferIn && !_requestRepository.Configurations.AllowEditItemInTransfer && !string.IsNullOrEmpty(editedTransactionItemIds) && !string.IsNullOrEmpty(editedTransactionPackIds))
                {
                    filterTransferInItems = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                }

                #endregion
                #region [PackOperations]
                string allowOperation = "";
                string operationFilter = "";

                if (processMode == ItemFormProcessMode.TransferOut || processMode == ItemFormProcessMode.OffLoad) allowOperation = "AllowOffload = 1";
                else if (processMode == ItemFormProcessMode.TransferIn || processMode == ItemFormProcessMode.LoadRequest || processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan || processMode == ItemFormProcessMode.SSCCFromLoadExecute) allowOperation = "AllowLoad = 1";
                else if (processMode == ItemFormProcessMode.InputVoucher) allowOperation = "AllowInputVoucher =1";
                else if (processMode == ItemFormProcessMode.OutputVoucher) allowOperation = "AllowOutputVoucher =1";
                else if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Sales.GetHashCode()) allowOperation = "AllowOrder =1";
                else if (processMode == ItemFormProcessMode.Return) allowOperation = "PackOperations.AllowReturn =1";
                else if (processMode == ItemFormProcessMode.Sales) allowOperation = "AllowSales=1";
                else if (processMode == ItemFormProcessMode.ROIIncomming) allowOperation = "AllowIncomingStock =1";
                else if (processMode == ItemFormProcessMode.ROIIncommingReturns) allowOperation = "AllowIncomingReturns =1";
                else if (processMode == ItemFormProcessMode.ManufacturingDefects) allowOperation = "AllowManufacturingDefects =1";
                else if (processMode == ItemFormProcessMode.DamagedStock) allowOperation = "AllowDamagedStock =1";
                else if (processMode == ItemFormProcessMode.Orders && orderTypeId == OrderTypes.Return.GetHashCode()) allowOperation = "AllowReturnOrder =1";

                if (allowOperation != "")
                    operationFilter = string.Format(" AND (PackOperations.PackId is null OR {0})", allowOperation);

                #endregion
                #region storeKeeper
                #region stockCounting
                string stockCountingfilter = "";
                if (processMode == ItemFormProcessMode.StockCounting && stockCountingTaskId != string.Empty)
                {
                    stockCountingfilter = string.Format(" INNER JOIN StockCountingTaskItems SC ON SC.ItemId = Item.ItemID and SC.StockCountingTaskID = {0}", stockCountingTaskId);
                }
                #endregion
                #region Purchase Order
                string poFilter = string.Empty;
                if (processMode == ItemFormProcessMode.PurchaseOrder)
                {
                    if (_requestRepository.Configurations.AllowSelectWarehouseInPO &&
                        _requestRepository.Configurations.ShowDivisionSelectionOnWHTransaction)
                    {
                        poFilter = string.Format(@" And ItemCategory.DivisionID={0} ", divisionId);
                    }
                    if (!_requestRepository.Configurations.AllowSelectWarehouseInPO)
                    {
                        poFilter = string.Format(@" And Item.VendorID={0} ", vendorId);
                    }
                    //Allow to add serial items without adding the serials
                    serialItemsFilter = string.Empty;
                    if (editedTransactionPackIds != null && editedTransactionPackIds != string.Empty && !allowAddingNewItems)
                    {
                        poFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                    }
                }
                if (!allowAddingNewItems)
                {
                    if (editedTransactionPackIds != null && editedTransactionPackIds != string.Empty)
                    {
                        poFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                    }
                }
                #endregion
                #region Receiving
                if (processMode == ItemFormProcessMode.Receiving)
                {
                    if (!string.IsNullOrEmpty(purchaseOrderId))
                    {
                        poFilter = string.Format(@" And (Item.VendorID={0} or IsNull(PurchaseOrderDetails.Quantity,0) > 0 ) AND Item.ItemType = {1} ", vendorId, ItemTypes.RawMaterial.GetHashCode());
                        purchaseOrderDetailsJoin = string.Format(@" left Join PurchaseOrderDetails on Pack.PackID = PurchaseOrderDetails.PackID and PurchaseOrderID = '{0}' ", purchaseOrderId);
                        purchaseOrderQtySelection = " , IsNull(PurchaseOrderDetails.Quantity,0) as PurchaseOrderQty";
                    }
                    else
                    {
                        poFilter = string.Format(@" And Item.VendorID={0} AND Item.ItemType = {1} ", vendorId, ItemTypes.RawMaterial.GetHashCode());
                    }
                }
                #endregion
                #endregion
                #region SSCC
                string loadItemsFilter = string.Empty;
                if (processMode == ItemFormProcessMode.SSCCFromLoadExecute && editedTransactionItemIds != null && editedTransactionPackIds != null)// && _requestRepository.Configurations.EnableGeneratingSSCC && !string.IsNullOrEmpty(ssccBarcode))
                {
                    //otherSSCCJoin =string.Format( @"Left outer join SSCCDetails on SSCCDetails.PackId=Pack.PackId");
                    //quantityFromOtherSSCC = ",sum(SSCCDetails.Quantity) SSCCQuantities";
                    loadItemsFilter = string.Format(" and Item.ItemID in ({0}) and Pack.PackId in ({1})", editedTransactionItemIds, editedTransactionPackIds);
                }
                #endregion
                #region Check Secondary Pack in Order
                string secondaryPackJoin = string.Empty;
                string secondaryPackSelection = string.Empty;
                if (processMode == ItemFormProcessMode.Orders && !onlyCRMItems)
                {
                    secondaryPackJoin = " left outer join SecondaryPack on SecondaryPack.ItemID=item.ItemID ";
                    secondaryPackSelection = ",CASE WHEN SecondaryPack.ItemID IS NULL THEN 0 ELSE 1 END AS HasSecondaryPack ";
                }

                #endregion
                #region[Requested By division]
                string requestedByDivisionAccess = string.Empty;
                if (processMode == ItemFormProcessMode.LoadRequest && requestedBy != -1)
                {
                    requestedByDivisionAccess = string.Format("INNER JOIN EmployeeDivision RequestedByDivision ON RequestedByDivision.DivisionID = ItemCategory.DivisionID AND RequestedByDivision.EmployeeID = {0}", requestedBy);
                }
                #endregion
                #region [Packing]
                string packingFilter = "";
                string packingSelection = "";
                if (processMode == ItemFormProcessMode.Packing)
                {
                    packingFilter = string.Format(" and pack.Quantity = 1 and item.ItemType = {0} ", ItemTypes.TradingItem.GetHashCode());
                    packingSelection = " , isnull(item.ShelfLifeTime,0) ShelfLifeTime ";
                }
                #endregion


                #region [Serial Reassignmen]
                string serialReassignmentJoin = string.Empty;
                if (processMode == ItemFormProcessMode.SerialReassignment)
                {
                    serialReassignmentJoin = string.Format("INNER JOIN  SerialCurrentStatus on  SerialCurrentStatus.PackID =Pack.PackID  " +
                        "And ((SerialCurrentStatus.SerialStatusID = {0}) " +
                        "OR (SerialCurrentStatus.SerialStatusID = {1}) " +
                        "OR (SerialCurrentStatus.SerialStatusID = {2})) " +
                        "And SerialCurrentStatus.CustomerID = {3} " +
                        "And SerialCurrentStatus.OutletID = {4} " +
                        "inner join ItemExtraInfo on Item.ItemID = ItemExtraInfo.ItemID and ItemExtraInfo.AllowReassign = 1", SerialStatus.SoldToCustomer.GetHashCode(),
                        SerialStatus.ManuallySold.GetHashCode(), SerialStatus.Reassign.GetHashCode(), customerId, outletId);
                }

                #endregion

                #region [ReturnBatchesfromInvoices]
                if ((processMode == ItemFormProcessMode.Orders || processMode == ItemFormProcessMode.ProcessReturn || processMode == ItemFormProcessMode.Return)
                    && _requestRepository.Configurations.RestrictReturnFromInvoices
                    && !string.IsNullOrEmpty(allowedItemsInReturn))
                {
                    filterItemsInReturnOrder = $@" and Item.ItemId in ({allowedItemsInReturn})";
                }
                #endregion
                //#region [BACK TO STORE OFFLOAD]
                //string backToStoreJoin = string.Empty;
                //string backToStoreTempTable = string.Empty;
                //string backToStoreResendTable = string.Empty;
                //string itemExtraInfoJoin = string.Empty; 
                //string whereAllowReturn = string.Empty; 
                //if (processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                //{
                //    string includeLoadedSerials = string.Empty;
                //    if(processMode == ItemFormProcessMode.ResendHelloJordan)
                //    {

                //        backToStoreResendTable = string.Format(@"DECLARE @Table2 AS TABLE (PackID INT);
                //                                                 INSERT INTO @Table2 SELECT DISTINCT SCS.PACKID FROM SerialCurrentStatus SCS
                //                                                 INNER  join SerialTransTracking STT on STT.FromSerial = SCS.FromSerial and STT.SerialStatusID = {0}
                //                                                 WHERE SCS.SerialStatusID IN({1});",
                //                                                 SerialStatus.BackToStore.GetHashCode(), SerialStatus.LoadedToMainWarehouse.GetHashCode());
                //        includeLoadedSerials = " INNER JOIN @Table2 TT ON T.PackID = Pack.PackID";
                //        //includeLoadedSerials = string.Format(@",{0}",SerialStatus.LoadedToMainWarehouse.GetHashCode());
                //    }
                //    backToStoreTempTable = string.Format(@"DECLARE @Table1 AS TABLE (PackID INT);
                //                                INSERT INTO @Table1 SELECT DISTINCT PACKID FROM SerialCurrentStatus WHERE SerialStatusID IN({0}, {1}) {2};",
                //                                SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode(), backToStoreResendTable);
                //    backToStoreJoin = "INNER JOIN @Table1 t ON t.PackID = Pack.PackID" + includeLoadedSerials;
                //    itemExtraInfoJoin = "inner join ItemExtraInfo IEF on IEF.ItemID = Item.ItemID";
                //    whereAllowReturn = " And IEF.AllowReturn = 1";
                //}
                //#endregion
                #region [BACK TO STORE OFFLOAD]
                string backToStoreJoin = string.Empty;
                string backToStoreTempTable = string.Empty;
                string itemExtraInfoJoin = string.Empty;
                string whereAllowReturn = string.Empty;
                if (processMode == ItemFormProcessMode.BackToStoreOffload || processMode == ItemFormProcessMode.ResendHelloJordan)
                {
                    if (processMode == ItemFormProcessMode.ResendHelloJordan)
                    {

                        backToStoreTempTable = string.Format(@"DECLARE @Table AS TABLE (PackID INT);
                                                                   INSERT INTO @Table SELECT DISTINCT SCS.PACKID FROM SerialCurrentStatus SCS
                                                                   INNER join SerialTransTracking STT on STT.FromSerial = SCS.FromSerial and STT.SerialStatusID = {0}
                                                                   WHERE SCS.SerialStatusID in({0},{1},{2})",
                                                SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode(), SerialStatus.LoadedToMainWarehouse.GetHashCode());

                    }
                    else
                    {
                        backToStoreTempTable = string.Format(@"DECLARE @Table AS TABLE (PackID INT);
                                                INSERT INTO @Table SELECT DISTINCT PACKID FROM SerialCurrentStatus WHERE SerialStatusID IN({0}, {1});",
                                                    SerialStatus.BackToStore.GetHashCode(), SerialStatus.Unblocked.GetHashCode());
                    }
                    backToStoreJoin = "INNER JOIN @Table t ON t.PackID = Pack.PackID";
                    itemExtraInfoJoin = "inner join ItemExtraInfo IEF on IEF.ItemID = Item.ItemID";
                    whereAllowReturn = " And IEF.AllowReturn = 1";
                }
                #endregion

                #region[Items Main Select]
                if (processMode == ItemFormProcessMode.SSCCFromDelivery)
                    orderByFilter = "ORDER BY ItemLanguage.Description, seq,Item.ItemCode, PackTypeLanguage.Description";
                else
                    orderByFilter = " ORDER BY Item.ItemID,CASE WHEN Pack.PackID = Item.DefaultPackID THEN 0 ELSE 1 END,Item.ItemCode, ItemLanguage.Description, seq , PackTypeLanguage.Description";

                string itemQuery = string.Format(@"{9} {47}
                    {10} 
                    {59}
                    {14}
                    {35}
                    {40}
                    {51}
                    {58}
                    SELECT Distinct Item.ItemType ItemTypeId, Item.ItemID ItemId, ItemCategory.ItemCategoryID ItemCategoryId, item.ModelID , Pack.HasSerialNumber,Item.EnableBatchForSerial,Item.AutoGenerateSubSerials,Pack.TemplateID,Pack.GTIN, Pack.PackTypeID PackTypeId, Pack.PackID PackId, Pack.Quantity PiecesInPack,  Pack.SerialSeparator,pack.IsWeightPriced ,ItemCategory.DivisionID,
                    PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, ItemCategoryLanguage.Description Category, ItemCategory.ItemCategoryCode CategoryCode, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END AS HasImage, item.RequiredByLiter,CASE WHEN Pack.PackID = Item.DefaultPackID THEN 0 ELSE 1 END IsDefault
                    ,isnull( PackSerialTrimRule.StartTrimDigits,-1)  PackTrimSerialStartDigits,isnull(PackSerialTrimRule.EndTrimDigits,-1) PackTrimSerialEndDigits, IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as itemCodeName, item.InStock, item.InSCS , Pack.ChildPackID
                    {2}  {16} {5} {18} {26} {28} {32} {34} {36} {39} {45} {48} {52} {55} , prices.MinPrice, prices.MaxPrice, ISNULL(convert(bigint,item.sequence), (select isnull(max(sequence),1)+1 from item))seq   
                    FROM Item
                    LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                    INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                    {46}
                    LEFT JOIN PackOperations on PackOperations.ItemID = Pack.ItemID and PackOperations.packID = Pack.PackID
                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID {17}
                    inner join Division on Division.DivisionID=ItemCategory.DivisionID
                    inner join Organization on Organization.OrganizationID=Division.OrganizationID
                    {1}
                    LEFT OUTER JOIN ItemCategoryLanguage ON ItemCategory.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID AND ItemCategoryLanguage.LanguageID = {0}
                    LEFT OUTER JOIN ItemImage ON ItemImage.ItemID = Item.ItemID
                    INNER JOIN EmployeeDivision ON EmployeeDivision.DivisionID = ItemCategory.DivisionID AND EmployeeDivision.EmployeeID = {4}               
                    Left Outer join PackSerialTrimRule on PackSerialTrimRule.PackID=PAck.PAckID  
                    {43}
                    {30} 
                    {13}
                    {6}
                    {3}
                    {15}
                    {19}
                    {11}
                    {29}
                    {31}
                    {33}
                    {37}
                    {38}
                    {42}
                    {41}
                    {49}
                    {53}
                    {54}
                    WHERE (isnull(Item.Inactive,0) = 0) AND (Item.ItemType NOT IN ({24} 7,9)) {57}
                    {7} {8} {12} {20} {21} {22} {23} {25} {38} {44} {50}
                    {56}",
                    _requestRepository.LanguageId, //0
                    crmQueryFilter, //1
                    priceSelection, //2
                    priceQuery, //3
                    _requestRepository.CurrentOperator.EmployeeId, //4
                    stockSelection, //5
                    stockQuery, //6
                    stockLimitConditionInMainQuery, //7
                    zeroPriceFilter,//8
                    priceTableQuery, //9
                    itemsListSelection, //10
                    itemsListJoin, //11
                    itemsListWhere, //12
                    orderItemsFilter, //13
                    retailQuery, //14
                    retailJoin, //15
                    retailSelection, //16
                    divisionFilter, //17
                    vehicleSelectedQuantity,//18
                    vehicleQtyJoin,  //19
                    operationFilter, //20
                    serialItemsFilter, //21
                    filterTransferInItems, //22
                    poFilter, //23
                    orderExcludeContainers,//24
                    loadItemsFilter, //25
                    salesTypeSelection, //26
                    orderBySalesTransactionType, //27
                    mainWarehouseSelectedQuantity, // 28
                    mainWHQtyJoin, //29
                    requestedByDivisionAccess, //30
                    stockCountingfilter, //31
                    secondaryPackSelection,//32
                    secondaryPackJoin, //33
                    discountsForDeliverySelection, //34
                    consumerPriceQuery, //35
                    consumerPriceSelection, //36
                    consumerPriceJoin, //37
                    packingFilter, //38
                    packingSelection, //39
                    backToStoreTempTable, //40
                    serialReassignmentJoin, //41
                    backToStoreJoin, //42
                    itemExtraInfoJoin, //43
                    whereAllowReturn, //44
                    purchaseOrderQtySelection, //45
                    purchaseOrderDetailsJoin, //46
                    stockOrderTable, //47
                    stockOrderSelection, //48
                    stockOrderJoin, //49
                    filterItemsInReturnOrder, //50
                    costPriceQuery, //51
                    costPriceSelection, //52
                    costPriceJoin, //53
                    warehouseCategoryFilter, // 54
                    stockStatusDetailsSelection, //55
                    orderByFilter, //56
                    limitItemsToMainWarehouseCondition, //57
                    itemStockTable, //58
                    itemListForLoadAndOff // 59
                    );

                Stopwatch stopWatch = new Stopwatch();
                stopWatch.Start();

                result = dbHelper.GetQueryList(itemQuery, ref itemList);

                stopWatch.Stop();
                TimeSpan ts = stopWatch.Elapsed;

                string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, itemQuery, elapsedTime);

                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                itemList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDivisionsUnderOrgAccess(ref List<DivisionModel> divisionsList, bool checkEmployeeAccess , bool isFromStaffEmployeeOrgAccess)
        {
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                divisionsList = new List<DivisionModel>();
                dbHelper = new DBHelper<DivisionModel>();
                string divisionAccess = string.Empty;
                if (checkEmployeeAccess)
                {
                    divisionAccess = string.Format(" Division.DivisionID in ({0}) ", _requestRepository.CurrentOperator.DivisionAccess);
                }
                else
                {
                    if (isFromStaffEmployeeOrgAccess)
                    {
                        divisionAccess = string.Format(" Division.organizationID in ({0}) ", _requestRepository.CurrentOperator.OriginalOrganizationAccess);
                    } 
                    else
                    {
                        divisionAccess = string.Format(" Division.organizationID in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                }

                string query = string.Format(@"select distinct Division.DivisionID, Division.OrganizationID, Divisionlanguage.Description, Division.DivisionCode,
                IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName
                from Division
                Left Outer join Divisionlanguage on  Division.DivisionID = Divisionlanguage.DivisionID And Divisionlanguage.LanguageID = {0}
                where {1} ",
                _requestRepository.LanguageId, //0
                divisionAccess //1
                );

                result = dbHelper.GetQueryList(query, ref divisionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDivisionsAccessForEmployee(ref List<DivisionModel> divisionsList, int employeeID)
        {
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                divisionsList = new List<DivisionModel>();
                dbHelper = new DBHelper<DivisionModel>();

                string query = string.Format(@"select ED.DivisionID , D.DivisionID, D.OrganizationID, DL.Description, D.DivisionCode,
                                               IsNull(D.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DL.Description , '--') as DivisionCodeName
                                               from Employee E
                                               inner join EmployeeDivision ED on ED.EmployeeID = E.EmployeeID
                                               inner join Division D on D.DivisionID = ED.DivisionID
                                               left outer join DivisionLanguage DL on DL.DivisionID = D.DivisionID
                                               where E.EmployeeID = {0}", employeeID);

                result = dbHelper.GetQueryList(query, ref divisionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getPackTypes(ref List<PackTypeModel> itemPacks)
        {
            DBHelper<PackTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackTypeModel>();

                string query = string.Format(@"select PackTypeLanguage.Description PackTypeName,PackTypeLanguage.PackTypeID from PackTypeLanguage where LanguageID = {0}",
                _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref itemPacks);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemPacks = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getItemData(ref List<PackTypeModel> packTypes, ref List<ItemTypeModel> itemTypes, ref List<ItemBrandModel> itemBrands, ref List<Item_Model> itemModels, ref List<PackGroupModel> packGroups, ref List<ItemCategoryModel> itemCategory)

        {
            DBHelper<PackTypeModel> dbHelper = null;
            DBHelper<ItemTypeModel> dBHelperItem = null;
            DBHelper<ItemBrandModel> dBHelperBrand = null;
            DBHelper<Item_Model> dBHelperModel = null;
            DBHelper<PackGroupModel> dBHelperPackGroup = null;
            DBHelper<ItemCategoryModel> dBHelperCategory = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackTypeModel>();
                dBHelperItem = new DBHelper<ItemTypeModel>();
                dBHelperBrand = new DBHelper<ItemBrandModel>();
                dBHelperModel = new DBHelper<Item_Model>();
                dBHelperPackGroup = new DBHelper<PackGroupModel>();
                dBHelperCategory = new DBHelper<ItemCategoryModel>();

                string query = string.Format(@"select PackTypeLanguage.Description PackTypeName,PackTypeLanguage.PackTypeId from PackTypeLanguage where LanguageID = {0}",
                _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref packTypes);

                if (result == GlobalErrors.Success)
                {
                    query = string.Empty;
                    query = string.Format(@"select Description ItemTypeName,ItemTypeID from ItemTypeLanguage where LanguageID = {0}",
                                    _requestRepository.LanguageId);
                    result = dBHelperItem.GetQueryList(query, ref itemTypes);
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Empty;
                    query = string.Format(@"select Description ItemBrandName,BrandID ItemBrandId from BrandLanguage where LanguageID = {0}",
                                    _requestRepository.LanguageId);
                    result = dBHelperBrand.GetQueryList(query, ref itemBrands);
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Empty;
                    query = string.Format(@"select Description ItemModelName,ModelID ItemModelId from ModelLanguage where LanguageID = {0}",
                                  _requestRepository.LanguageId);
                    result = dBHelperModel.GetQueryList(query, ref itemModels);
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Empty;
                    query = string.Format(@"select Distinct Description PackGroupName,PackGroupLanguage.PackGroupId,
                                            case when PromotionOptionDetail.PromotionOptionTypeID = 1 and PromotionOptionDetail.PromotionOptionDetailTypeID = 5 then 1 else 0 end as HasPromotion
                                            from PackGroupLanguage
                                            left join PromotionOptionDetail on PromotionOptionDetail.PackGroupID = PackGroupLanguage.PackGroupID
                                            where LanguageID = {0}",
                                  _requestRepository.LanguageId);
                    result = dBHelperPackGroup.GetQueryList(query, ref packGroups);
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Empty;
                    query = string.Format(@"select Description Name,itemCategoryId from ItemCategoryLanguage where LanguageID = {0}",
                                  _requestRepository.LanguageId);
                    result = dBHelperCategory.GetQueryList(query, ref itemCategory);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                packTypes = null;
                itemTypes = null;
                itemBrands = null;
                itemModels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getPackType(ref List<PackTypeModel> packTypes)
        {
            DBHelper<PackTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackTypeModel>();

                string query = string.Format(@"select PackTypeLanguage.Description PackTypeName,PackTypeLanguage.PackTypeId from PackTypeLanguage where LanguageID = {0}",
                _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                packTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPackTypeOfPackGroup(ref List<PackTypeModel> packTypes)
        {
            DBHelper<PackTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackTypeModel>();
                string query = string.Format(@"select distinct PackTypeLanguage.Description PackTypeName,Pack.PackTypeID 
                from PackTypeLanguage 
                inner join  pack on PackTypeLanguage.PackTypeID = Pack.PackTypeID 
                inner join item  on item.itemid =pack.itemid
                inner join itemcategory  c on item.itemcategoryid= c.itemcategoryid
                inner join division D  on c.divisionid = D.DivisionID                                                                
                where D.organizationid in ({1}) AND PackTypeLanguage.LanguageID = {0} 
                ORDER BY Pack.PackTypeID",
                _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                packTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetKPIPackTypes(ref List<PackTypeModel> packTypes)
        {
            DBHelper<PackTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PackTypeModel>();
                string query = string.Format(@"select item.ItemID,Pack.PackTypeID,PackTypeLanguage.Description PackTypeName from PackTypeLanguage 
                inner join  pack on PackTypeLanguage.PackTypeID = Pack.PackTypeID 
                inner join item  on item.itemid =pack.itemid
                inner join itemcategory  c on item.itemcategoryid= c.itemcategoryid
                inner join division D  on c.divisionid = D.DivisionID                                                                
                where D.organizationid in ({1}) AND PackTypeLanguage.LanguageID = {0} 
                ORDER BY Pack.ItemID",
                _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.GetQueryList(query, ref packTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                packTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmpOutDivisions(GeneralFilter filter, ref List<DivisionModel> divisionList)
        {
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<DivisionModel>();
                var custOutDivisonFilter = string.Empty;
                if (filter.CustomerId != 0)
                {
                    custOutDivisonFilter = string.Format(@"inner join AccountCustOutDiv on AccountCustOutDiv.DivisionID = employeeDivision.DivisionID
                                               and AccountCustOutDiv.CustomerID = {0}
                                               and AccountCustOutDiv.OutletID = {1}", filter.CustomerId, filter.OutletId);
                }

                var divisonQuery = string.Format(@"select Distinct  Division.DivisionID, Division.DivisionCode  ,DivisionLanguage.Description
                ,IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName
                from Division
                inner join EmployeeDivision on Division.DivisionID = EmployeeDivision.DivisionID and  employeeid = {0} And Division.DivisionID In ({3})
                left join DivisionLanguage on DivisionLanguage.divisionID = employeeDivision.divisionID and LanguageID = {2}
                {1}", filter.EmployeeId, custOutDivisonFilter, _requestRepository.LanguageId , _requestRepository.CurrentOperator.DivisionAccess);

                result = dbHelper.GetQueryList(divisonQuery, ref divisionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetItemByPackID(int packId, ref ItemPackModel item)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();

                string query = string.Format(@"Select Pack.PackID,Pack.ItemID,Pack.HasSerialNumber ,ItemLanguage.Description AS ItemName,Item.ItemCode,PackTypeLanguage.Description  Uom,Pack.Quantity PiecesInPack
                                , CustomerAppMainDivision.MainDivisionID,Item.EnableBatchForSerial,Pack.GTIN,Organization.GLN, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END AS HasImage
                                From Pack
                                INNER JOIN PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID
                                INNER JOIN Item ON Pack.ItemID=Item.ItemID
Left Outer Join ItemImage on ItemImage.ItemID=Item.ItemID
                                INNER JOIN ItemLanguage ON Pack.ItemID=ItemLanguage.ItemID AND ItemLanguage.LanguageID = {0} And PackTypeLanguage.LanguageID = {0} and Pack.PackID ={1}
                                INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID
inner join Division on Division.DivisionID=ItemCategory.DivisionID
inner join Organization on Organization.OrganizationID=Division.OrganizationID
                                LEFT OUTER JOIN CustomerAppMainDivision ON CustomerAppMainDivision.DivisionID = ItemCategory.DivisionID"
                                , _requestRepository.LanguageId, packId);
                result = dbHelper.GetQuerySingle(query, ref item);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetSearchedItem(string filter, ref ItemPackModel itemPack)
        {
            itemPack = new ItemPackModel();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                var searchFilter = "";
                if (!string.IsNullOrEmpty(filter))
                {
                    searchFilter = string.Format(@"and ( (ItemCode LIKE '%{0}%')
                            OR ( ItemLanguage.Description LIKE '%{0}%')
                            OR ( PackTypeLanguage.Description LIKE '%{0}%' )
                            OR ( Pack.Barcode LIKE '%{0}%' ))", filter.Trim());
                }
                string itemQuery = string.Format(@"SELECT  {1}
                            from ITEM
                            INNER JOIN ITEMLANGUAGE ON ITEMLANGUAGE.ItemID = ITEM.ItemID AND ITEMLANGUAGE.LanguageID = 1
                            inner join Pack on pack.ItemID=item.ItemID
                            inner join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID=1
                            inner join ItemCategory on ItemCategory.ItemCategoryID=item.ItemCategoryID
                            left outer join ItemCategorylanguage on ItemCategory.ItemCategoryID=ItemCategorylanguage.ItemCategoryID and ItemCategorylanguage.languageID=1
                            left outer join Brandlanguage on Brandlanguage.BrandID=Item.BrandID and Brandlanguage.languageID=1
                            left outer join Modellanguage on Modellanguage.ModelID=Item.ModelID and Modellanguage.languageID=1
                            left outer join divisionlanguage on divisionlanguage.divisionid=itemcategory.divisionid and DivisionLanguage.LanguageID=1
                            where  (Item.Inactive = 0 or Item.Inactive is null ) and Item.ItemType not in (7,9) {0}",
                            searchFilter,
                            selectedColumnsOfItems);

                result = dbHelper.GetQuerySingle(itemQuery, ref itemPack);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemPack = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetAllActiveItems(ref List<ItemPackModel> itemsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                var query = string.Format(@"SELECT DISTINCT Item.ItemID, Item.ItemCode, IsNull(ItemLanguage.Description,'---') ItemName,
                IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemDefinition
                FROM Item
                Inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID and ItemCategory.DivisionID in ({1})
                LEFT OUTER JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                Where Item.Inactive = 0
                ORDER BY ItemName ",
                _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.GetQueryList(query, ref itemsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllItems(ref List<ItemPackModel> itemsList, int DivisionId, int BrandId, int CategoryId, GeneralFilter filter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            string divisionFilter = string.Empty;
            string brandFilter = string.Empty;
            string categoryFilter = string.Empty;
            string searchFilter = string.Empty;
            try
            {
                if (DivisionId > 0)
                {
                    divisionFilter = string.Format("INNER JOIN Division on ItemCategory.DivisionID = Division.DivisionID AND Division.DivisionID = {0}", DivisionId);
                }
                if (BrandId > 0)
                {
                    brandFilter = string.Format("INNER JOIN Brand on Brand.BrandID = Item.BrandID AND Brand.BrandID = {0}", BrandId);
                }
                if (CategoryId > 0)
                {
                    categoryFilter = string.Format("AND ItemCategory.ItemCategoryID = {0}", CategoryId);
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.DivisionIdsString))
                    {
                        searchFilter += $" and ItemCategory.DivisionID in ({filter.DivisionIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemCategoryIdsString))
                    {
                        searchFilter += $" AND ItemCategory.ItemCategoryID in ({filter.ItemCategoryIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemIdsString))
                    {
                        searchFilter += $" AND Item.ItemID in ({filter.ItemIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.BrandIdsString))
                    {
                        searchFilter += $" AND Item.BrandID in ({filter.BrandIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemGroupIdsString))
                    {
                        searchFilter += $" AND Item.ItemID in (Select ItemID from ItemGroupDetail where ItemGroupID in ({filter.ItemGroupIdsString}) group by ItemID) ";
                    }
                }
                dbHelper = new DBHelper<ItemPackModel>();
                var query = string.Format(@"SELECT DISTINCT Item.ItemID, Item.ItemCode, IsNull(ItemLanguage.Description,'---') ItemName,
                IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as itemCodeName
                FROM Item
                {2}
                LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID {3} AND ItemCategory.DivisionID IN ({6})
                {1}                
                LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0}        
                where Item.Inactive = 0 {4}",
                _requestRepository.LanguageId, //0
                divisionFilter, //1
                brandFilter, //2
                categoryFilter, //3
                searchFilter, //4
                _requestRepository.CurrentOperator.EmployeeId , //5
                _requestRepository.CurrentOperator.DivisionAccess //6
                );
                result = dbHelper.GetQueryList(query, ref itemsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetAllItemsLazyLoading(ref List<ItemPackModel> itemsList, int DivisionId, int BrandId, int CategoryId, GeneralFilter generalFilter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = null;
            string divisionFilter = string.Empty;
            string brandFilter = string.Empty;
            string categoryFilter = string.Empty;
            string query = string.Empty;
            string searchFilter = string.Empty;
            var selectedItemsList = new List<ItemPackModel>();
            try
            {
                if (DivisionId > 0)
                {
                    divisionFilter = string.Format("INNER JOIN Division on ItemCategory.DivisionID = Division.DivisionID AND Division.DivisionID = {0}", DivisionId);
                }
                if (BrandId > 0)
                {
                    brandFilter = string.Format("INNER JOIN Brand on Brand.BrandID = Item.BrandID AND Brand.BrandID = {0}", BrandId);
                }
                if (CategoryId > 0)
                {
                    categoryFilter = string.Format("AND ItemCategory.ItemCategoryID = {0}", CategoryId);
                }
                if (!string.IsNullOrWhiteSpace(generalFilter.CustomListFilter.SearchFilter))
                {
                    searchFilter = string.Format(" and (ItemLanguage.Description like '%{0}%' or Item.ItemCode like '%{0}%' )", generalFilter.CustomListFilter.SearchFilter);
                }
                dbHelper = new DBHelper<ItemPackModel>();


                query = string.Format(@"SELECT DISTINCT ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq, Item.ItemID, Item.ItemCode, IsNull(ItemLanguage.Description,'---') ItemName,
                IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as itemCodeName
                FROM Item
                {2}
                LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID {3}
                {1}                
                LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0}        
                where Item.Inactive = 0  {6} order by ItemCode 
                OFFSET  {4} ROWS
                FETCH NEXT {5} ROWS ONLY",
           _requestRepository.LanguageId,
           divisionFilter, brandFilter, categoryFilter, generalFilter.CustomListFilter.Page, generalFilter.CustomListFilter.PageSize, searchFilter);


                result = dbHelper.GetQueryList(query, ref itemsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetItemsNameAndCode(string itemIDs, ref List<string> itemsNameAndCode)
        {
            DBHelper<string> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<string>();
                itemsNameAndCode = new List<string>();
                string query = string.Format(@"select IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemNameCode
                From Item
                Left outer Join ItemLanguage On ItemLanguage.ItemID = Item.ItemID And ItemLanguage.LanguageID = {0}
                Where Item.ItemID in ({1})", _requestRepository.LanguageId, itemIDs);
                result = dbHelper.GetQueryList(query, ref itemsNameAndCode);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        #endregion [ITEMS]

        #region [DIVISIONS]


        #endregion [DIVISIONS]

        #region [CATEGORIES]

        public GlobalErrors GetItemCategoryList(ref List<ItemCategoryModel> categoryList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemCategoryModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ItemCategoryModel>();
                var employeeQuery = string.Format(@"SELECT DISTINCT ItemCategory.DivisionID DivisionId, ItemCategory.ItemCategoryID ItemCategoryId, ItemCategory.ItemCategoryCode Code, ItemCategoryLanguage.Description Name
                        FROM ItemCategory
                        LEFT OUTER JOIN ItemCategoryLanguage ON ItemCategory.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID AND ItemCategoryLanguage.LanguageID = {0}
                        where ItemCategory.DivisionID in ({1})
                        ORDER BY ItemCategory.ItemCategoryCode, ItemCategoryLanguage.Description ",
               _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.GetQueryList(employeeQuery, ref categoryList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion [CATEGORIES]

        #region [ITEM BATCHES]

        public static List<ItemStockBatches> GetAvailableBatches(int warehouseId, string itemIds, bool fillDataInMismatch, int tripId, DBHelper<ItemStockBatches> dBHelper)
        {
            // get warehouse stock batches with quantity in pcs on item level.
            var stockBatches = new List<ItemStockBatches>();
            var itemIdsFilter = string.Empty;
            var query = string.Empty;
            var joinWarehousecheck = string.Empty;
            var selectQuantity = string.Empty;
            try
            {
                if (!string.IsNullOrEmpty(itemIds))
                {
                    itemIdsFilter = string.Format(@"AND Pack.ItemID in ({0})", itemIds);
                }
                if (fillDataInMismatch)
                {
                    selectQuantity = @"	,IsNull(Sum(WarehouseCheckCounting.Quantity),0) pickerCount,
				IsNull(Sum(level2Check.Quantity),0) formanCount,
				case when convert(decimal(23,11), IsNull(Sum(level2Check.Quantity),0) )=convert(decimal(23,11),IsNull(Sum(WarehouseCheckCounting.Quantity),0))  then   IsNull(Sum(level2Check.Quantity),0) else -1 end RequiredQty";
                    joinWarehousecheck = string.Format(@"left outer join WarehouseCheckCounting on WarehouseCheckCounting.BatchNumber=WarehouseStock.BatchNo and 
				WarehouseCheckCounting.ExpiryDate=WarehouseStock.ExpiryDate and WarehouseCheckCounting.PackId=WarehouseStock.PackID and TripId={0} and TripOperationId={1}  and WarehouseCheckCounting.CheckLevel=1

				left outer join WarehouseCheckCounting level2Check on level2Check.BatchNumber=WarehouseStock.BatchNo and 
				level2Check.ExpiryDate=WarehouseStock.ExpiryDate and level2Check.PackId=WarehouseStock.PackID and level2Check.TripId={0} and level2Check.TripOperationId={1}  and level2Check.CheckLevel=2", tripId, TripOperationType.CheckOut.GetHashCode());
                }
                query = string.Format(@"Select Distinct
                Pack.ItemID,
                WarehouseStock.BatchNo,
                WarehouseStock.ExpiryDate,
                IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) AvailableQtyInPcs,
                IsNull(Sum(WarehouseStock.Quantity * pack.Quantity),0) ActualAvailableQtyInPcs
	            {2}
                From WarehouseStock
                Inner join Pack on WarehouseStock.PackID = Pack.PackID
                {3}
                Where  WarehouseStock.WarehouseID = {0}  {1}
                Group by Pack.ItemID,
                WarehouseStock.BatchNo,
                WarehouseStock.ExpiryDate
                Having Sum(WarehouseStock.Quantity * pack.Quantity) > 0  "
                , warehouseId
                , itemIdsFilter, selectQuantity, joinWarehousecheck);

                var result = dBHelper.GetQueryList(query, ref stockBatches);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }

            return stockBatches;
        }


        #endregion [ITEM BATCHES]

        #region [PRICES]

        public GlobalErrors GetPriceList(GeneralFilter filter, ref List<PriceModel> itemList)
        {
            DBHelper<PriceModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string packFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<PriceModel>();
                string dateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";
                string retailSelection = string.Empty, retailJoin = string.Empty, retailQuery = string.Empty;
                if (filter.PackId != -1)
                {
                    packFilter = string.Format(@" AND packid = {0}", filter.PackId);
                }
                #region[Retail Tax]
                if (_requestRepository.Configurations.AllowRetailTaxOnItemsForCustomer(filter.CustomerId, filter.OutletId))
                {
                    retailSelection = " ,ISNULL(retailPrices.price,0) as RetailPrice,ISNULL(retailPrices.tax,0) as RetailTax,(ISNULL(retailPrices.price,0)* ISNULL(retailPrices.tax,0))/100 as RetailValue ";
                    retailJoin = " left outer join @Retail as retailPrices on retailPrices.packid=pack.PackID ";
                    retailQuery = string.Format(@"    declare @Retail table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int)
                                    insert into @Retail
                                    SELECT distinct packID , isnull(retailPrices.Price,0) price, isnull(retailPrices.Tax,0)tax, 
                                    retailPrices.PriceListID                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                     PriceDefinition.CurrencyID              
                                    from PriceDefinition                      
                                    inner join(                      
                                                  
                                    select PriceListID from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({0}) ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={1}  AND (PriceList.StartDate <=  {2} )AND (PriceList.EndDate >=   {3} )
                                    ) as retailPrices 
                                    WHERE  (retailPrices.PriceListID is not null)", _requestRepository.Configurations.DefaultRetailPriceListID, PriceListTypes.Retail.GetHashCode(), LocalUtilities.ParseDateToSQLString(DateTime.Now), LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                }
                else
                {
                    retailSelection = " ,0 as RetailPrice,0 as RetailTax ,0 as RetailValue";
                }

                #endregion

                string pricesQuery = string.Format(@" {4}
                select pack.itemID,  pack.PackID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, prices.PriceListID , prices.priority, prices.rowNumber {6}
                from item

                inner join pack on pack.ItemID = item.ItemID
                left outer join (
                select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax, tt.priority, PriceDefinition.CurrencyID
                , row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber, PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd
                from PriceDefinition

                inner join(
                select PriceListID, 1 as priority from CustomerPrice
                where CustomerID = {0} and OutletID = {1}

                union
                select PriceListID, 2 as priority from GroupPrice
                where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})

                 union
                select PriceListID, 3 as priority from ChannelPrice
                where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in  (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))

              
                union
                select PriceListID, 5 as priority from PriceDefinition
		        Where PriceDefinition.PriceListID in ({8})

                ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null {3}
                 inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 
                and PriceList.PriceListTypeID={7}  {2}
                inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd )
                ) prices
                  on pack.PackID = prices.PacKID and prices.rowNumber =1
{5}
               Where  (prices.priority is not null) and (Prices.PriceListID is not null) and (item.inactive is null or item.inactive = 0)
               Order By itemid, pack.PackID",
               filter.CustomerId,
               filter.OutletId,
               dateFilter,
               packFilter, retailQuery, retailJoin, retailSelection, PriceListTypes.General.GetHashCode(), _requestRepository.Configurations.DefaultPriceListID.ToString());

                result = dbHelper.GetQueryList(pricesQuery, ref itemList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDefualtPriceList(GeneralFilter filter, DBHelper<int> dBHelperOpened, ref List<PriceModel> itemList)
        {
            DBHelper<PriceModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string packFilter = string.Empty;
            string packsStringFilter = string.Empty;
            try
            {
                if (dBHelperOpened == null)
                {
                    dbHelper = new DBHelper<PriceModel>();
                }
                else
                {
                    dbHelper = new DBHelper<PriceModel>(dBHelperOpened.GetConnection(), dBHelperOpened.GetDBTransaction());
                }

                string dateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";
                if (filter.PackId != -1)
                {
                    packFilter = string.Format(@" AND pack.packid = {0}", filter.PackId);
                }
                if (filter.PacksString != string.Empty)
                {
                    packsStringFilter = string.Format(@" AND pack.packid in ({0})", filter.PacksString);
                }


                string pricesQuery = string.Format(@" select pack.itemID,  pack.PackID , isnull(PriceDefinition.Price,0) price, isnull(PriceDefinition.Tax,0)tax
, PriceDefinition.PriceListID , PriceList.priority
                from item

                inner join pack on pack.ItemID = item.ItemID
                 inner join PriceDefinition on PriceDefinition.packId=Pack.PackId and PriceDefinition.PriceListID={0}
                inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 
                and PriceList.PriceListTypeID={1}  {2}
                inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd )
               
               Where   (item.inactive is null or item.inactive = 0) {3} {4}
               Order By itemid, pack.PackID"
, _requestRepository.Configurations.DefaultPriceListID, PriceListTypes.General.GetHashCode(), dateFilter, packFilter, packsStringFilter
               );

                result = dbHelper.GetQueryList(pricesQuery, ref itemList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion [PRICES]

        #region [DISCOUNTS]

        public static GlobalErrors GetAllDiscount(int customerId, int outletId, int divisionId, int sdcId , bool enableSalesDistributionChannel,ref List<ItemDiscountModel> discountList, bool getPriceDiscount, string organizationAccess,string packIdsString="", int userId = -1)
        {
            discountList = new List<ItemDiscountModel>();
            string whereFilter = string.Empty;
            string divisionFilter = string.Empty;
            string salesOrderTypeSelection = string.Empty;
            string salesOrderTypeColumn = string.Empty;
            string packIdsCondition = string.Empty;

            DBHelper<ItemDiscountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int discountType = (int)DiscountTypes.Normal;

                dbHelper = new DBHelper<ItemDiscountModel>();
                if (divisionId > -1)
                {
                    divisionFilter = $" OR D.DivisionID = {divisionId}";
                }
                if (getPriceDiscount) 
                {
                    discountType = (int)DiscountTypes.PriceDiscount;
                    salesOrderTypeSelection = " , SalesOrderTypeId ";
                    salesOrderTypeColumn = " ,SalesOrderTypeId int";
                }
                if (!string.IsNullOrEmpty(packIdsString))
                {
                    packIdsCondition = $" and dd.PackID in ({packIdsString})";
                }
                string orgCheck = !string.IsNullOrEmpty(organizationAccess) ? $" AND (D.OrganizationId in ({organizationAccess})) " : "";

                whereFilter = $@" ( D.Inactive != 1 AND D.Status = -1 )  AND (D.StartDate <= {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)}) AND (D.EndDate >= {LocalUtilities.ParseDateToSQLString(DateTime.Today)}) AND 
                (FOC = 0) AND (D.TypeID = {discountType}) AND (ISNULL(D.DivisionID,-1) = -1 {divisionFilter}) {orgCheck}";

                StringBuilder query = new StringBuilder();
                query.Append($@" DECLARE @Discount as table (discountPackID int,DiscountPackGroupID int,AllItems int,CustomerID int,OutletID int,CustomerGroupID int,ChannelID int,Discount numeric(19,9) , DivisionID int,DiscountTypeID int,DiscountProirity int {salesOrderTypeColumn})
                insert into @Discount
                Select 
                D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems,
                DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID,
                D.DiscountTypeID, case when ISNULL(D.PackID,-1) <> -1 then 1
                when ISNULL(D.PackGroupID,-1) <> -1 then 2
				when ISNULL(D.DivisionID,-1) <> -1 then 3
                when D.AllItems = 1 then 4 END DiscountProirity {salesOrderTypeSelection} from Discount D
                INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID
                WHERE DA.CustomerID = {customerId} AND DA.OutletID = {outletId} AND
                ");
                query.Append(whereFilter);
                query.Append(" UNION ");

                query.Append($@" Select 
                D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems,
                DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID,
                D.DiscountTypeID, case when ISNULL(D.PackID,-1) <> -1 then 5
                when ISNULL(D.PackGroupID,-1) <> -1 then 6
				when ISNULL(D.DivisionID,-1) <> -1 then 7
                when D.AllItems = 1 then 8 END DiscountProirity {salesOrderTypeSelection} from Discount D
                INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID
                WHERE DA.CustomerGroupID IN(SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {customerId} and OutletID = {outletId})  AND");
                query.Append(whereFilter);
                query.Append(" UNION ");

                query.Append($@" Select 
                D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems, 
                DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID,
                D.DiscountTypeID, case when ISNULL(D.PackID,-1) <> -1 then 9
                when ISNULL(D.PackGroupID,-1) <> -1 then 10
				when ISNULL(D.DivisionID,-1) <> -1 then 11
                when D.AllItems = 1 then 12 END DiscountProirity {salesOrderTypeSelection}  from Discount D
                INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID 
                INNER JOIN customerGroup CG ON CG.SubChannelID = DA.SubChannelID
                INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND COG.CustomerID = {customerId} AND COG.OutletID = {outletId}  WHERE");
                query.Append(whereFilter);
                query.Append(" UNION ");

                query.Append($@" Select 
                D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems, 
                DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID, 
                D.DiscountTypeID, case when ISNULL(D.PackID,-1) <> -1 then 13
                when ISNULL(D.PackGroupID,-1) <> -1 then 14
				when ISNULL(D.DivisionID,-1) <> -1 then 15
                when D.AllItems = 1 then 16 END DiscountProirity {salesOrderTypeSelection}  from Discount D
                INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID 
                INNER JOIN customerGroup CG ON CG.ChannelID = DA.ChannelID
                INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND COG.CustomerID = {customerId} AND COG.OutletID = {outletId}
                WHERE ");
                query.Append(whereFilter);
                query.Append(" UNION ");

                if (enableSalesDistributionChannel && sdcId > -1)
                {
                    query.Append($@" Select 
                    D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems, 
                    DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID, 
                    D.DiscountTypeID, 
                    case when ISNULL(D.PackID,-1) <> -1 then 17
                    when ISNULL(D.PackGroupID,-1) <> -1 then 18
                    when ISNULL(D.DivisionID,-1) <> -1 then 19
                    when D.AllItems = 1 then 20 
                    END 
                    DiscountProirity {salesOrderTypeSelection}  
                    from Discount D
                    INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID 
                    INNER JOIN SDC  ON SDC.SDCID = DA.SDCID
                    WHERE SDC.SDCID = {sdcId} AND ");
                    query.Append(whereFilter);
                    query.Append(" UNION ");
                }

                query.Append($@" Select 
                D.PackID discountPackID, D.PackGroupID DiscountPackGroupID, D.AllItems, 
                DA.CustomerID, DA.OutletID, DA.CustomerGroupID, DA.ChannelID, D.Discount, D.DivisionID,
                D.DiscountTypeID, case when ISNULL(D.PackID,-1) <> -1 then 21
                when ISNULL(D.PackGroupID,-1) <> -1 then 22
				when ISNULL(D.DivisionID,-1) <> -1 then 23
                when D.AllItems = 1 then 24 END DiscountProirity  {salesOrderTypeSelection}  from Discount D
                INNER JOIN DiscountAssignment DA On D.DiscountID = DA.DiscountID AND DA.AllCustomers = 1
                WHERE  ");
                query.Append(whereFilter);


                query.Append($@"SELECT PackID, Discount, DiscountTypeID {salesOrderTypeSelection} FROM (
                        SELECT pack.packid, discounts.DiscountProirity, discounts.Discount, discounts.DiscountTypeID
                        , row_number ( )  OVER (PARTITION BY pack.packid {salesOrderTypeSelection} ORDER BY discounts.DiscountProirity ASC) AS rowNumber {salesOrderTypeSelection}
                        FROM pack
                        LEFT JOIN PackGroupDetail on PackGroupDetail.PackID = Pack.PackID
                        LEFT JOIN @Discount ");

                query.Append($@"  as discounts ON (discounts.discountPackID = pack.PackID OR discounts.DiscountPackGroupID = PackGroupDetail.PackGroupID OR discounts.AllItems = 1 OR ISNULL(discounts.DivisionID,-1) <> -1)
                        WHERE discounts.Discount is not null AND discounts.DiscountProirity >= 0) as dd 
                        where rowNumber = 1 {packIdsCondition}");
                
                Stopwatch stopWatch = new Stopwatch();
                stopWatch.Start();

                result = dbHelper.GetQueryList(query.ToString(), ref discountList);


                stopWatch.Stop();
                TimeSpan ts = stopWatch.Elapsed;
                string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(userId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, query.ToString(), elapsedTime);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                discountList = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        #endregion [DISCOUNTS]

        #region [Division]
        public GlobalErrors GetAllDivisions(DivisionFilter filter, ref List<DivisionModel> divisionList)
        {
            divisionList = new List<DivisionModel>();
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string employeeFilter = string.Empty;
            string divisionsFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<DivisionModel>();
                if (filter.EmployeeId != -1)
                {
                    employeeFilter = " inner join EmployeeDivision ED2 on ED.DivisionID = ED2.DivisionID and ED2.EmployeeID = " + filter.EmployeeId;
                }
                if (!string.IsNullOrEmpty(filter.DivisionIdsString)) 
                {
                    divisionsFilter = $@" AND Division.DivisionID in ({filter.DivisionIdsString}) ";
                }

                string query = string.Format(@"SELECT Division.DivisionID DivisionId, DivisionLanguage.Description, Division.DivisionCode,
                    IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
                    OrganizationLanguage.Description OrganizationName ,OrganizationLanguage.OrganizationID
                    FROM Division
                    LEFT JOIN DivisionLanguage ON DivisionLanguage.DivisionID = Division.DivisionID AND DivisionLanguage.LanguageID = {0}
					LEFT JOIN OrganizationLanguage on OrganizationLanguage.OrganizationID = Division.OrganizationID and OrganizationLanguage.LanguageID = {0}
                    INNER JOIN EmployeeDivision ED ON ED.DivisionID = Division.DivisionID AND ED.EmployeeID = {1} and ED.DivisionID in ({3})
                    {2}
                    Where 1=1 {4} {5}
                    ORDER BY Division.DivisionCode, DivisionLanguage.Description",
                _requestRepository.LanguageId, _requestRepository.CurrentOperator.EmployeeId, employeeFilter, _requestRepository.CurrentOperator.DivisionAccess, divisionsFilter, 
                _requestRepository.CurrentOperator.EmployeeId == 0 ? "" : " AND Division.OrganizationID = " + _requestRepository.CurrentOperator.OrganizationId);
                result = dbHelper.GetQueryList(query, ref divisionList , true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionList = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetAllMasterGroup(ref List<MasterItemGroupModel> masterGroupList)
        {
            DBHelper<MasterItemGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<MasterItemGroupModel>();
                string query = string.Format(@"SELECT MasterItemGroup.MasterItemGroupID MasterItemGroupId, IsNull(MasterItemGroupLanguage.Description, '--') MasterItemGroupName 
					from MasterItemGroup
                    inner join MasterItemGroupLanguage on MasterItemGroup.MasterItemGroupID= MasterItemGroupLanguage.MasterItemGroupID and MasterItemGroupLanguage.languageId= {0}",
                _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref masterGroupList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static int GetMaxDivisionId()
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            int divisionId = 1;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format("select ISNULL( MAX(DivisionId) , 0)  + 1 From Division");

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    divisionId = (int)field;
                }

                return divisionId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return divisionId;
            }
        }

        public GlobalErrors SaveDivisionData(DivisionModel division, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO Division (DivisionId ,DivisionCode ,OrganizationID, CreatedBy , CreatedDate) values ");
                sqlStatment.Append("(");
                sqlStatment.Append(division.DivisionId);
                sqlStatment.Append(",'");
                sqlStatment.Append(division.DivisionCode.Replace("'", "''"));
                sqlStatment.Append("',");
                sqlStatment.Append(_requestRepository.CurrentOperator.OrganizationId);
                sqlStatment.Append(",");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                //sqlStatment.Append(",");
                //sqlStatment.Append(division.Active ? 1 : 0);
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors SaveDivisionLanguage(int divisionId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO DivisionLanguage (DivisionId , LanguageId , Description) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(divisionId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", (text.Replace("'", "''")).ToString());
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }



        public GlobalErrors EditDivisionData(DivisionModel division, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update Division Set DivisionCode = '{0}' ,OrganizationID = {5}  , UpdatedBy = {2} , UpdatedDate = {3}  Where DivisionId = {4} "
                , division.DivisionCode, 0, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                division.DivisionId, _requestRepository.CurrentOperator.OrganizationId);

                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors EditDivisionLanguage(int divisionId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update DivisionLanguage set Description = '{0}' Where DivisionId = {1} and LanguageId = {2}", text.Replace("'", "''"), divisionId, languageId);
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CheckCodeExist(string tableName, string columnName, string code, string IdColumnName, int Id, ref bool isExist)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                object field = 0;
                isExist = false;
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"select Count(*) from {0} where {1} = '{2}' AND {3} <> {4}", tableName, columnName, code.Replace("'", "''"), IdColumnName, Id);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isExist = true;
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetDivisionData(int divisionId, ref DivisionModel division)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<DivisionModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<DivisionModel>();
                string query = string.Format(@"SELECT Division.DivisionId, Division.DivisionCode, DivisionLanguage.Description DivisionName , Division.Active
                            FROM Division
                            LEFT JOIN DivisionLanguage ON Division.DivisionId = DivisionLanguage.DivisionId AND DivisionLanguage.LanguageId = {0}
							WHERE Division.DivisionId = {1}
                            ORDER BY Division.DivisionCode, DivisionLanguage.Description", _requestRepository.LanguageId, divisionId);
                result = dBHelper.GetQuerySingle(query, ref division);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetDivisionLanguages(int divisionId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"Select * from DivisionLanguage where DivisionId = {0}", divisionId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion [DISCOUNTS]

        public static int GetMaxCategoryId()
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            int categoryId = 1;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format("select ISNULL( MAX(ItemCategoryId) , 0)  + 1 From ItemCategory");

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    categoryId = (int)field;
                }

                return categoryId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return categoryId;
            }
        }

        public GlobalErrors SaveCategoryData(CategoryModel category, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO ItemCategory (ItemCategoryId , ItemCategoryCode , DivisionId , CreatedBy , CreatedDate ) values ");
                sqlStatment.Append("(");
                sqlStatment.Append(category.ItemCategoryId);
                sqlStatment.Append(",'");
                sqlStatment.Append(category.ItemCategoryCode.Replace("'", "''"));
                sqlStatment.Append("',");
                sqlStatment.Append(category.DivisionId);
                sqlStatment.Append(",");
                sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors SaveCategoryLanguage(int categoryId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO ItemCategoryLanguage (ItemCategoryId , LanguageId , Description) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(categoryId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", (text.Replace("'", "''")).ToString());
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetAlllCategories(ItemCategoryFilter filter, ref List<CategoryModel> data)
        {
            DBHelper<CategoryModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string filterOnDivision = string.Empty;
                string filterOnCategory = string.Empty;
                if (filter.DivisionId > 0)
                {
                    filterOnDivision = string.Format(" and IC.DivisionID ={0} ", filter.DivisionId);
                }
                else if (!string.IsNullOrEmpty(filter.DivisionIdsString)) 
                {
                    filterOnDivision = $" AND IC.DivisionID in ({filter.DivisionIdsString}) ";
                }
                if (!string.IsNullOrEmpty(filter.ItemCategoryIdsString))
                {
                    filterOnCategory = $" AND IC.ItemCategoryID in ({filter.ItemCategoryIdsString}) ";
                }
                dBHelper = new DBHelper<CategoryModel>();
                string query = string.Format(@"select distinct IC.ItemCategoryId , IC.ItemCategoryCode , IC.DivisionId , ICL.Description ItemCategoryName , DL.Description DivisionName,OrganizationLanguage.Description OrganizationName
                 ,IsNull( IC.ItemCategoryCode , '--') + ' ' + '-'+ ' ' + IsNull( ICL.Description , '--') as CategoryNameCode,CASE WHEN ItemCategoryImage.ItemCategoryId IS NULL THEN 0 ELSE 1 END AS HasImage 
                from ItemCategory IC
                INNER JOIN Division on Division.DivisionID = IC.DivisionID
                LEFT JOIN ItemCategoryLanguage ICL on ICL.ItemCategoryId = IC.ItemCategoryId AND ICL.LanguageId = {0}
                LEFT JOIN DivisionLanguage DL on DL.DivisionId = IC.DivisionId AND  DL.LanguageId = {0}
				LEFT JOIN OrganizationLanguage on OrganizationLanguage.OrganizationID = Division.OrganizationID and OrganizationLanguage.LanguageId = {0}
                LEFT OUTER JOIN ItemCategoryImage ON ItemCategoryImage.ItemCategoryId = IC.ItemCategoryId
                where IC.DivisionID in ({2}) {1} {3}
                Order by   IC.ItemCategoryCode", _requestRepository.LanguageId, filterOnDivision, _requestRepository.CurrentOperator.DivisionAccess,filterOnCategory);
                result = dBHelper.GetQueryList(query, ref data , true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors GetCategoryData(int categoryId, ref CategoryModel category)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<CategoryModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<CategoryModel>();
                string showInCustomerAppJoin = string.Empty;
                string showInCustomerAppSelection = string.Empty;
                if (_requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    showInCustomerAppSelection = ",CASE WHEN (ItemCategoryCustomerApp.ItemCategoryID IS NULL) THEN 0 ELSE 1 END as ShowInCustomerApp ";
                    showInCustomerAppJoin = "LEFT JOIN ItemCategoryCustomerApp on ItemCategoryCustomerApp.ItemCategoryID = IC.ItemCategoryID";
                }
                string query = string.Format(@"select IC.ItemCategoryId , IC.ItemCategoryCode , IC.DivisionId  , ICL.Description ItemCategoryName , DL.Description DivisionName,
                CASE WHEN ItemCategoryImage.ItemCategoryId IS NULL THEN 0 ELSE 1 END AS HasImage {2}
                from ItemCategory IC
                LEFT JOIN ItemCategoryLanguage ICL on ICL.ItemCategoryId = IC.ItemCategoryId AND ICL.LanguageId = {0}
                LEFT JOIN DivisionLanguage DL on DL.DivisionId = IC.DivisionId AND  DL.LanguageId = {0}
                LEFT OUTER JOIN ItemCategoryImage ON ItemCategoryImage.ItemCategoryId = IC.ItemCategoryId
                {3}
				Where IC.ItemCategoryId = {1}
                Order by IC.ItemCategoryCode", _requestRepository.LanguageId, categoryId, showInCustomerAppSelection, showInCustomerAppJoin);
                result = dBHelper.GetQuerySingle(query, ref category);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetCategoryLanguages(int categoryId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"Select * from ItemCategoryLanguage where ItemCategoryId = {0}", categoryId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors EditCategoryData(CategoryModel category, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update ItemCategory Set ItemCategoryCode = '{0}'  , DivisionId = {1}
                , UpdatedBy = {3} , UpdatedDate = {4}  Where ItemCategoryId = {5} "
                , category.ItemCategoryCode, category.DivisionId, 0, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), category.ItemCategoryId);

                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors EditCategoryLanguage(CategoryModel categoryModel, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format("delete from ItemCategoryLanguage where ItemCategoryID={0}", categoryModel.ItemCategoryId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                //Save language
                foreach (TextLanguage language in categoryModel.DescriptionLanguages)
                {
                    query = string.Format(@"insert into ItemCategoryLanguage (ItemCategoryID,LanguageID,Description) values ({0},{1},'{2}')", categoryModel.ItemCategoryId, language.LanguageId, language.Description.Replace("'", "''"));
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteItemImage(int itemId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM ItemImage WHERE ItemId = {0}", itemId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteItemCategoryImage(int categoryId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM ItemCategoryImage WHERE ItemCategoryId = {0}", categoryId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemImage(int itemId, byte[] image, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object param = new object();
                param = new { image = image };
                string query = string.Format(@"INSERT INTO ItemImage(ItemID,Image) Values({0},{1})", itemId, "@image");
                result = dbHelper.ExecuteNonQueryWithParameters(query, param);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemCategoryImage(int categoryId, byte[] image, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object param = new object();
                param = new { image = image };
                string query = string.Format(@"INSERT INTO ItemCategoryImage(ItemCategoryID,Image) Values({0},{1})", categoryId, "@image");
                result = dbHelper.ExecuteNonQueryWithParameters(query, param);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemCategoryCustomerApp(int categoryId, int divisionId, bool showInCustomerApp, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (showInCustomerApp)
                {
                    query = string.Format("DELETE FROM ItemCategoryCustomerApp WHERE ItemCategoryId ={0}", categoryId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.SuccessWithZeroRowAffected && result != GlobalErrors.Success) return result;
                    query = string.Format("INSERT INTO ItemCategoryCustomerApp VALUES ({0}, {1})", categoryId, divisionId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.SuccessWithZeroRowAffected && result != GlobalErrors.Success) return result;
                }
                else
                {
                    result = DeleteItemCategoryCustomerApp(categoryId);
                    if (result != GlobalErrors.Success) return result;
                    result = DeletePackCustomerAppByItemCategoryId(categoryId);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveBrandCustomerApp(int brandId, bool showInCustomerApp, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (showInCustomerApp)
                {
                    query = string.Format("DELETE FROM BrandCustomerApp WHERE BrandId = {0}", brandId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.SuccessWithZeroRowAffected && result != GlobalErrors.Success) return result;
                    query = string.Format("INSERT INTO BrandCustomerApp VALUES ({0})", brandId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.SuccessWithZeroRowAffected && result != GlobalErrors.Success) return result;
                }
                else
                {
                    result = DeleteBrandCustomerApp(brandId);
                    if (result != GlobalErrors.Success) return result;
                    result = DeletePackCustomerAppByItemBrandId(brandId);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors DeleteItemCategoryCustomerApp(int ItemCategoryId)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"DELETE FROM ItemCategoryCustomerApp WHERE ItemCategoryId = {0}", ItemCategoryId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteBrandCustomerApp(int brandId)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"DELETE FROM BrandCustomerApp WHERE BrandId = {0}", brandId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeletePackCustomerAppByItemCategoryId(int ItemCategoryId)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string brandQuery = string.Empty;
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("2"))
                {
                    brandQuery = string.Format(@" AND (ItemCategoryId NOT IN (SELECT Item.ItemCategoryID FROM Item INNER JOIN  Brand ON Item.BrandID = Brand.BrandID 
                        INNER JOIN BrandCustomerApp ON Brand.BrandID = BrandCustomerApp.BrandId))");
                }
                string query = string.Format(@"DELETE FROM PackCustomerApp WHERE ItemCategoryId = {0} {1}", ItemCategoryId, brandQuery);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeletePackCustomerAppByItemBrandId(int BrandId)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string categoryQuery = string.Empty;
                if (_requestRepository.Configurations.CategoryBrandCustomerAppMode.Contains("1"))
                {
                    categoryQuery = string.Format(@" AND (ItemCategoryId NOT IN (SELECT ItemCategoryID FROM ItemCategoryCustomerApp))");
                }
                string query = string.Format(@"DELETE FROM PackCustomerApp WHERE (ItemId IN (SELECT ItemID FROM Item WHERE (BrandID = {0}))) {1}", BrandId, categoryQuery);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        //public static GlobalErrors GetAllPlansAvailable(ref SharedTableResult<SalesRestrictionModel> SharedPlansList, PlanFilter planFilter)
        //{
        //    SharedPlansList = new SharedTableResult<SalesRestrictionModel>();
        //    List<SalesRestrictionModel> PlansList = new List<SalesRestrictionModel>();
        //    DBHelper<SalesRestrictionModel> dBHelper = null;
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    string searchFilter = string.Empty;
        //    string orderByFilter = string.Empty;
        //    try
        //    {
        //        dBHelper = new DBHelper<SalesRestrictionModel>();
        //        string query = string.Format(@"select SalesRestriction.SalesRestrictionID, SalesRestriction.SalesRestrictionCode, 
        //        SalesRestriction.StartDate, SalesRestriction.EndDate, SalesRestrictionDetails.Quantity as SalesRestrictionQuantity, 
        //        ItemLanguage.Description + ' ( ' + PackTypeLanguage.Description + ' ) ' as ItemUOMDescription
        //        from SalesRestriction
        //        INNER JOIN SalesRestrictionDetails on SalesRestriction.SalesRestrictionID = SalesRestrictionDetails.SalesRestrictionID
        //        LEFT OUTER JOIN ItemLanguage on ItemLanguage.ItemID = SalesRestrictionDetails.ItemID AND ItemLanguage.LanguageID = {0}
        //        LEFT OUTER JOIN Pack on Pack.PackID = SalesRestrictionDetails.PackID
        //        LEFT OUTER JOIN PackType on Pack.PackTypeID = PackType.PackTypeID
        //        LEFT OUTER JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID = PackType.PackTypeID 
        //        AND PackTypeLanguage.LanguageID = {0}
        //        where SalesRestriction.Inactive <> 1",
        //        CoreSession.Instance.LanguageId);
        //        result = dBHelper.GetQueryList(query, ref PlansList);
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        result = GlobalErrors.Error;
        //    }
        //    return result;
        //}

        public static int IsCodeExists(DBHelper<int> dbHelper, string Code, int id, bool isEditMode)
        {
            int NumOfRows = 0;
            string filter = string.Empty, query = string.Empty;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                if (isEditMode)
                {
                    query = string.Format(@"select count(*) from SalesRestriction where SalesRestrictionCode = '{0}' AND SalesRestrictionID <> {1}",
                        Code.Replace("'", "''").Trim(), id);
                }
                else
                {
                    query = string.Format("select Count(*) from SalesRestriction where SalesRestrictionCode = '{0}'", Code.Replace("'", "''").Trim());
                }
                object salesRestrictionIdObj = null;

                GlobalErrors result = dbHelper.ExecuteScalar(query, ref salesRestrictionIdObj);
                if (result == GlobalErrors.Success)
                {
                    if (salesRestrictionIdObj != null && !string.IsNullOrEmpty(salesRestrictionIdObj.ToString()))
                    {
                        NumOfRows = int.Parse(salesRestrictionIdObj.ToString());
                    }
                }
                else
                {
                    NumOfRows = 100;
                }
                return NumOfRows;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
        }

        public static int GetMaxSalesRestrictionID(DBHelper<int> dbHelper)
        {
            int salesRestrictionId = 0;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                object salesRestrictionIdObj = null;
                string query = string.Format("select Max(SalesRestrictionID) from SalesRestriction ");
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref salesRestrictionIdObj);
                if (result == GlobalErrors.Success)
                {
                    if (salesRestrictionIdObj != null && !string.IsNullOrEmpty(salesRestrictionIdObj.ToString()))
                    {
                        salesRestrictionId = int.Parse(salesRestrictionIdObj.ToString()) + 1;
                    }
                    else
                    {
                        salesRestrictionId = 1;
                    }
                }
                else
                {
                    salesRestrictionId = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return salesRestrictionId;
        }

        public GlobalErrors InactivateSalesRestriction(int salesRestrictionId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string sqlQuery = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                sqlQuery = string.Format(@"update SalesRestriction set Inactive = 1, UpdatedBy = {1}, UpdatedDate = {2} where SalesRestrictionID = {0}",
                    salesRestrictionId,
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateToSQLString(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(sqlQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }


        public GlobalErrors GetPackGroupItems(PackGroupModel filter, ref List<ItemPackModel> items)
        {
            DBHelper<ItemPackModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                string packsJoin = string.Empty;
                string salesOrderTypeFilter = string.Empty;
                string salesOrderCRMSelection = string.Empty;
                string warehouseCondition = string.Empty;
                string warehouseFilterForPendingOrders = string.Empty;
                string loadingWarehousesIdsFilter = string.Empty;
                string availableJoin = string.Empty;
                string availableSelection = string.Empty;
                string stockOrderTable = string.Empty;
                string stockOrderJoin = string.Empty;
                string differentGroupJoin = string.Empty;
                string differentGroupQty = string.Empty;
                string packOperationsJoin = string.Empty;
                string packOperationCondition = string.Empty;
                string availableSelectionCRM = string.Empty;
                string stockStatusSalesOrderJoin = string.Empty;
                string stockStatusCondition = string.Empty;

                if (filter.GetAllItemPacks)
                {
                    packsJoin = string.Format(@"and pack.ItemID in(SELECT Pack.ItemID FROM Pack
                    INNER JOIN PackGroupDetail ON PackGroupDetail.PackID = Pack.PackID
                    WHERE PackGroupID = {0}) ", filter.PackGroupId);
                }else if ((filter.IsCRM || filter.IsSkipPromotion) && filter.ItemId != -1)
                {
                    packsJoin = string.Format(@"and pack.ItemID in ({0}) ", filter.ItemId);
                }
                else
                {
                    packsJoin = string.Format(@"and pack.PackId in(SELECT Pack.PackId FROM Pack
                    INNER JOIN PackGroupDetail ON PackGroupDetail.PackID = Pack.PackID
                    WHERE PackGroupID = {0}) ", filter.PackGroupId);
                }
                if (!string.IsNullOrEmpty(filter.SalesOrderTypeIds))
                {
                    salesOrderTypeFilter = string.Format(@" and StockStatus.SalesOrderTypeID in ({0})", filter.SalesOrderTypeIds);
                    salesOrderCRMSelection = string.Format(@" ,isnull(WarehouseStock.StockStatusID,-1) StockStatusID,isnull(SSC.Description,'-') IconColor,'fa fa-circle fa-2x' Icon,isnull(StockStatus.SalesOrderTypeID,-1) SalesOrderTypeID");
                }
                else if (filter.IsCRM)
                {
                    salesOrderCRMSelection = string.Format(@" ,isnull(WarehouseStock.StockStatusID,-1) StockStatusID,isnull(SSC.Description,'-') IconColor,'fa fa-circle fa-2x' Icon,isnull(StockStatus.SalesOrderTypeID,-1) SalesOrderTypeID");
                    packOperationsJoin = string.Format(@" left join PackOperations on PackOperations.ItemID = Pack.ItemId and PackOperations.PackID = Pack.PackID");
                    packOperationCondition = string.Format(@" and isnull(AllowOrder,1) = 1");
                }
                if (!string.IsNullOrEmpty(filter.WarehouseIds))
                {
                    warehouseCondition = string.Format(@" and WarehouseStock.WarehouseID in ({0})", filter.WarehouseIds);
                }
                if(filter.PromotionOptionDetailTypeID == PromotionInputDetailTypes.GroupDifferntQuantity.GetHashCode() || filter.PromotionOptionDetailTypeID == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel.GetHashCode())
                {
                    differentGroupQty = string.Format(@" '(' +IsNull(CONVERT(nvarchar, groupDiff.Quantity) , '--') +')'+ ' ' + ' ' +");
                    differentGroupJoin = string.Format(@" inner join (
			        select PromotionOptionDetailGroup.PackID,PromotionOptionDetailGroup.Quantity from PromotionOptionDetail
			        inner join PromotionOptionDetailGroup on 
			        PromotionOptionDetailGroup.PackGroupID = PromotionOptionDetail.PackGroupID and
			        PromotionOptionDetailGroup.PromotionOptionID = PromotionOptionDetail.PromotionOptionID and
			        PromotionOptionDetailGroup.PromotionOptionDetailID = PromotionOptionDetail.PromotionOptionDetailID 
			        and 
			        PromotionOptionDetail.PromotionOptionTypeID = 1 and 
			        PromotionOptionDetail.PromotionOptionDetailTypeID in ({0}) and
			        PromotionOptionDetail.PromotionID = {1} and 
			        promotionOptionDetail.PromotionOptionID = {2} and 
			        promotionOptionDetail.PromotionOptionDetailID = {3} and 
			        PromotionOptionDetailGroup.Quantity > 0)groupDiff on groupDiff.PackID = pack.PackID", filter.PromotionOptionDetailTypeID,filter.PromotionId,filter.PromotionOptionID,filter.PromotionOptionDetailID);
                }
                string restrictDataToCustomerOrganization = string.Empty;
                if(filter.IsCRM || filter.IsSkipPromotion)
                {
                    restrictDataToCustomerOrganization = _requestRepository.Configurations.RestrictDataToCustomerOrganization && filter.OrganizationID != -1 ? $" And Division.OrganizationID in ({filter.OrganizationID}) " : "";

                    if (filter.IsCRM)
                    {
                        availableSelectionCRM = string.Format(@" ,WarehouseStock.StockStatusID , SS.SalesOrderTypeID, SS.ColorID, SalesOrderType.PriceEditable ");
                        stockStatusSalesOrderJoin = string.Format(@" inner join StockStatus SS on SS.StockStatusID = WarehouseStock.StockStatusID 
                        inner join SalesOrderType on SalesOrderType.SalesOrderTypeID = SS.SalesOrderTypeID");
                        stockStatusCondition = string.Format(@" and ItemStock.StockStatusID = StockStatus.StockStatusID");
                    }
                    availableJoin = string.Format(@"LEFT OUTER join(
                    Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs ,Sum(pack.Quantity * WarehouseStock.Quantity) ExistingQty  {2}
                    From pack
                    inner join WarehouseStock on WarehouseStock.PackID = pack.PackID  {0}
                    inner join Warehouse w on WarehouseStock.warehouseID = w.warehouseID and W.OrganizationID in ({1}) and w.WarehouseTypeID = 1
                    {3}
                    Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null) 
                    group by pack.ItemID  {2}
                    Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0 
                    ) ItemStock on ItemStock.ItemID = Item.ItemID {4}", warehouseCondition,_requestRepository.CurrentOperator.OrganizationAccess, availableSelectionCRM, stockStatusSalesOrderJoin, stockStatusCondition);
                    if (filter.IsCRM)
                    {
                        availableSelection = string.Format(@" ,isNull(orderQty.blockedQty,0) blockedQty,isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ReservedQty,isNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs,isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) )+ isNull(orderQty.blockedQty,0) StockQty, isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) )+ isNull(orderQty.blockedQty,0) OriginalStockQty");
                        stockOrderJoin = @" LEFT OUTER JOIN @orderQty as orderQty ON orderQty.ItemId = Pack.ItemId  and orderQty.StockStatusID = ItemStock.StockStatusID  ";
                    }
                    else if (filter.IsSkipPromotion)
                    {
                        availableSelection = string.Format(@" ,isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ReservedQty,isNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs,isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ) StockQty, isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ) OriginalStockQty");
                        stockOrderJoin = @" LEFT OUTER JOIN @orderQty as orderQty ON orderQty.ItemId = Pack.ItemId ";
                    }
                }
                string query = string.Format(@" {9}
                SELECT Distinct Pack.ItemID,pack.Quantity as PiecesInPack ,ItemLanguage.Description ItemName ,Item.ItemCode ,Pack.PackID, PackTypeLanguage.Description UOM, {14} IsNull(Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( '+ PackTypeLanguage.Description +' ) ' as ItemCodeName {5} {8}
                FROM Pack 
                INNER JOIN Item ON Pack.ItemID = Item.ItemID 
                INNER JOIN PackTypeLanguage ON Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0} 
                INNER JOIN ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID
                INNER JOIN Division on Division.DivisionID = ItemCategory.DivisionID and Division.DivisionId in ({2}) {15}
                INNER JOIN ItemLanguage ON Pack.ItemID =ItemLanguage.ItemID AND ItemLanguage.LanguageID = {0}
                left join WarehouseStock on WarehouseStock.PackID = Pack.PackID
				left join StockStatus on StockStatus.StockStatusID = WarehouseStock.StockStatusID
				LEFT join StockStatusColors SSC on SSC.ColorID = StockStatus.ColorID and SSC.LanguageID=1
                {11}
                {7}
                {10}
                {12}
                WHERE Item.Inactive = 0 {4} {3} {6} {13} ORDER BY ItemLanguage.Description", 
                _requestRepository.LanguageId, //0,
                filter.PackGroupId, //1
                _requestRepository.CurrentOperator.DivisionAccess,//2
                packsJoin,//3
                salesOrderTypeFilter,//4
                salesOrderCRMSelection,//5
                warehouseCondition,//6
                availableJoin,//7
                availableSelection,//8
                stockOrderTable,//9
                stockOrderJoin,//10
                differentGroupJoin,//11
                packOperationsJoin,//12
                packOperationCondition,//13
                differentGroupQty,//14
                restrictDataToCustomerOrganization//15
                );

                result = dBHelper.GetQueryList(query, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPackItemsWithPrice(int customerId, int outletId, int packGroupId, ref List<ItemPackModel> items, bool includeTax,bool isSkipPromotion)
        {
            DBHelper<ItemPackModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string stockOrderTable = string.Empty;
            string availableJoin = string.Empty;
            string availableSelection = string.Empty;
            string stockOrderJoin = string.Empty;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                string packGroupFilter = "";
                if (packGroupId > 0)
                {
                    packGroupFilter = string.Format(@"INNER JOIN PackGroupDetail ON PackGroupDetail.PackID = Pack.PackID 
                                    WHERE  PackGroupID = {0}", packGroupId);
                }

                string taxSelection = " 0 As Tax";
                if (includeTax)
                {
                    taxSelection = " ISNULL(PriceTempTable.Tax, 0) As Tax ";
                }

                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")";
                if (isSkipPromotion)
                {
                    availableJoin = string.Format(@"LEFT OUTER join(
                    Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs ,Sum(pack.Quantity * WarehouseStock.Quantity) ExistingQty 
                    From pack
                    inner join WarehouseStock on WarehouseStock.PackID = pack.PackID 
                    inner join Warehouse w on WarehouseStock.warehouseID = w.warehouseID and W.OrganizationID in ({0}) and w.WarehouseTypeID = 1
                    Where (WarehouseStock.IsReserved = 0  or WarehouseStock.IsReserved is null) 
                    group by pack.ItemID 
                    Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0 
                    ) ItemStock on ItemStock.ItemID = Item.ItemID", _requestRepository.CurrentOperator.OrganizationAccess);
                    availableSelection = string.Format(@" ,isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ReservedQty,isNull(ItemStock.AvailableQtyInPcs,0) AvailableQtyInPcs,isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ) StockQty, isNull(ItemStock.AvailableQtyInPcs,0) - (isNull(orderQty.bookedQty,0)  + isNull(orderQty.bookedQtyForLoadReq,0) ) OriginalStockQty");
                    stockOrderJoin = @" LEFT OUTER JOIN @orderQty as orderQty ON orderQty.ItemId = Pack.ItemId ";
                }
                string query = string.Format(@" {9}
                                    declare @x table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
                                    insert into @x
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
                                    prices.PriceListID, prices.priority, prices.rowNumber                  
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))                                                                             
                                    union                      
                                    select PriceListID, 5 as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    
                                    SELECT Pack.ItemID,pack.Quantity as PiecesInPack ,ItemLanguage.Description ItemName ,Item.ItemCode ,Pack.PackID, PackTypeLanguage.Description UOM,
                                    PriceTempTable.Price, {8} {10}
                                    FROM Pack
                                    INNER JOIN @x PriceTempTable ON Pack.PackID = PriceTempTable.PacKID
                                    INNER JOIN Item ON Pack.ItemID = Item.ItemID
                                    INNER JOIN PackTypeLanguage ON Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {5} 
                                    INNER JOIN ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID AND ItemCategory.DivisionID IN ( {7} )
                                    INNER JOIN ItemLanguage ON Pack.ItemID =ItemLanguage.ItemID AND ItemLanguage.LanguageID = {5}  
                                    {12}
                                    {11}
                                    WHERE  pack.ItemID in(SELECT Pack.ItemID FROM Pack  {6}
                                    )  ORDER BY ItemLanguage.Description
                                    ",
                                    customerId, //0
                                    outletId, //1
                                    _requestRepository.Configurations.DefaultPriceListID.ToString(), //2
                                    priceDateFilter, //3
                                    PriceListTypes.General.GetHashCode(), //4
                                    _requestRepository.LanguageId, //5
                                     packGroupFilter, //6
                                     _requestRepository.CurrentOperator.DivisionAccess, //7
                                     taxSelection, //8
                                     stockOrderTable, //9
                                     availableSelection, //10
                                     stockOrderJoin, //11
                                     availableJoin //12
                                    );

                result = dBHelper.GetQueryList(query, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPackGroupName(int packGroupId, ref string name)
        {
            DBHelper<string> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                dBHelper = new DBHelper<string>();

                string query = string.Format(@"SELECT Description FROM PackGroupLanguage  WHERE LanguageID = {0} AND   PackGroupID = {1}", _requestRepository.LanguageId, packGroupId);

                result = dBHelper.ExecuteScalar(query, ref field);

                if (field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    name = field.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetAllVendors(bool IncludeInactive, ref List<VendorModel> vendorList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<VendorModel> dBHelper = null;
            string inactiveFilter = string.Empty;
            try
            {
                if(!IncludeInactive)
                {
                    inactiveFilter = " where Vendor.Inactive is null or Vendor.Inactive=0 ";
                }
                dBHelper = new DBHelper<VendorModel>();
                string query = string.Format(@"select Vendor.VendorID,Description VendorDescription
                ,IsNull( Vendor.VendorCode , '--') + ' - ' + IsNull( VendorLanguage.Description , '--') as VendorCodeName
                from Vendor 
                Left outer join VendorLanguage on VendorLanguage.VendorID=Vendor.VendorID and LanguageID={0}
                {1} ",
                _requestRepository.LanguageId, //0
                inactiveFilter //1
                );
                result = dBHelper.GetQueryList(query, ref vendorList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        #region[old static methods]
        public static GlobalErrors GetPriceListOld(GeneralFilter filter, ref List<PriceModel> itemList, int DefaultPriceListID)
        {
            DBHelper<PriceModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string packFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<PriceModel>();
                string dateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";

                if (filter.PackId != -1)
                {
                    packFilter = string.Format(@" AND packid = {0}", filter.PackId);
                }

                string pricesQuery = string.Format(@"
                select pack.itemID,  pack.PackID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, prices.PriceListID , prices.priority, prices.rowNumber
                from item

                inner join pack on pack.ItemID = item.ItemID
                left outer join (
                select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax, tt.priority, PriceDefinition.CurrencyID
                , row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber, PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd
                from PriceDefinition

                inner join(
                select PriceListID, 1 as priority from CustomerPrice
                where CustomerID = {0} and OutletID = {1}

                union
                select PriceListID, 2 as priority from GroupPrice
                where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})

                 union
                select PriceListID, 3 as priority from ChannelPrice
                where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in  (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))


                union
                select PriceListID, 5 as priority from PriceDefinition
		        Where PriceDefinition.PriceListID in ({4})

                ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null {3}
                 inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 {2}
                inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID
                and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd )
                ) prices
                  on pack.PackID = prices.PacKID and prices.rowNumber =1
               Where  (prices.priority is not null) and (Prices.PriceListID is not null) and (item.inactive is null or item.inactive = 0)
               Order By itemid, pack.PackID",
               filter.CustomerId,
               filter.OutletId,
               dateFilter,
               packFilter,
               DefaultPriceListID);

                result = dbHelper.GetQueryList(pricesQuery, ref itemList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[Item Definition]
        public GlobalErrors UpdateItemActiveStatus(int itemId, bool setInactive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@" Update Item Set Inactive = {0} Where ItemID = {1}",
                setInactive ? "1" : "0",
                itemId);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors UpdateSelectedItemsProperities(ItemAction itemAction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();

                string SelectedAction = itemAction.SelectedAction == WebMenuActions.SetAsNew ? "IsNew" :
                                        itemAction.SelectedAction == WebMenuActions.SetAsPowerSKU ? "IsPowerSKU" :
                                        itemAction.SelectedAction == WebMenuActions.SetAsInitiative ? "IsInitiative" : null;
                string ItemIds = itemAction.ItemIds;

                string query = string.Format("UPDATE Item SET {0} = 1 WHERE ItemID IN ({1})",
                    SelectedAction, // 0
                    ItemIds // 1
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetItemsListSharedTable(ItemsFilter filter, ref SharedTableResult<ItemPackModel> itemsSharedList)
        {
            itemsSharedList = new SharedTableResult<ItemPackModel>();
            List<ItemPackModel> itemsList = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                string searchFilter = string.Empty;
                string selectedEmployeeFilter = string.Empty;
                string orderByFilter = string.Empty;
                string exceptedItems = string.Empty;
                string orderBySelectedItem = string.Empty;
                string showItemsWithUpperLimitFilter = string.Empty;
                string oosListSelection = string.Empty;
                string packTypeSelection = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" and ( (ItemLanguage.Description LIKE '%{0}%') OR (Item.ItemCode LIKE '%{0}%') OR (Item.PackDefinition LIKE '%{0}%') OR (ItemCategoryLanguage.Description LIKE '%{0}%') OR (ItemCategory.ItemCategoryCode LIKE '%{0}%')) ",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }

                    if (filter.ItemCategoryId > 0)
                    {
                        searchFilter += string.Format(" and ItemCategory.ItemCategoryID = {0}", filter.ItemCategoryId);
                    }
                    else if (filter.DivisionId > 0)
                    {
                        searchFilter += string.Format(" and ItemCategory.DivisionID = {0} ", filter.DivisionId);
                    }
                    else
                    {
                        searchFilter += string.Format(" and ItemCategory.DivisionID in ({0}) ", _requestRepository.CurrentOperator.DivisionAccess);
                    }
                    if (filter.ModelId > 0)
                    {
                        searchFilter += string.Format(" and Item.ModelId = {0} ", filter.ModelId);
                    }
                    if (filter.BrandId != -1)
                    {
                        searchFilter += string.Format(" and Item.BrandId = {0}", filter.BrandId);
                    }
                    if (filter.ModelId != -1)
                    {
                        searchFilter += string.Format(" and Item.ModelId = {0}", filter.ModelId);
                    }

                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " And (Item.Inactive is null Or Item.Inactive = 0) ";
                    }
                    if (filter.IncludePowerSKU)
                    {
                        searchFilter += " And (IsNull(Item.IsPowerSKU,0) = 1) ";
                    }
                    if (filter.IncludeNew)
                    {
                        searchFilter += " And (IsNull(Item.IsNew,0) = 1) ";
                    }
                    if (filter.IncludeInitiative)
                    {
                        searchFilter += " And (IsNull(Item.IsInitiative,0) = 1) ";
                    }
             
                    if (filter.ExcludeCompetitorItem)
                    {
                        searchFilter += string.Format("  And(Item.ItemType != {0}) ", ItemTypes.CompetitorItem.GetHashCode());
                    }
                    if (filter.ItemTypeId > -1)
                    {
                        searchFilter += string.Format("  And(Item.ItemType = {0}) ", filter.ItemTypeId);
                    }
                    if (filter.SelectedEmployeeId != -1)
                    {
                        selectedEmployeeFilter += " inner join EmployeeDivision ED on ItemCategory.DivisionID = ED.DivisionID and ED.EmployeeID = " + filter.SelectedEmployeeId;
                    }
                    if (filter.PackTypeId != -1)
                    {
                        packTypeSelection = string.Format(@" INNER JOIN Pack on Pack.ItemID = Item.ItemID
                        INNER JOIN PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}",_requestRepository.LanguageId);
                        searchFilter += string.Format(" and Pack.PackTypeID = {0}", filter.PackTypeId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By Item.ItemCode");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (_requestRepository.Configurations.EnableSplitOrder && filter.ItemGroupMode)
                    {
                        string extraCondition = filter.itemIdsList != null && filter.itemIdsList.Count() > 0 ? "and I.ItemId Not In (" + string.Join(',', filter.itemIdsList) + ")" : string.Empty;
                        exceptedItems = string.Format(@" and Item.ItemID not in (select I.ItemID from ItemGroupDetail I where 1 = 1 {0})", extraCondition);
                    }
                    if(filter.excludedItemIdsList!=null && filter.excludedItemIdsList.Count()>0)
                    {
                        searchFilter += string.Format("and Item.ItemID Not In ( {0} )", string.Join(',',filter.excludedItemIdsList));
                    }
                    if(filter.SelectItemId > 0)
                    {
                        orderBySelectedItem = string.Format(@",case when Item.ItemId = {0} then 1 else 0 end as sort ",filter.SelectItemId);
                        orderByFilter = "order by sort desc";

                    }
                    if (filter.ShowUpperLimitOnly)
                    {
                        showItemsWithUpperLimitFilter = string.Format(@" inner JOIN ItemExtraInfo IEI on IEI.ItemID = Item.ItemID AND IEI.AllowCheckUpperLimit = 1 ");
                    }
                    if (filter.isOosList)
                    {
                        oosListSelection = string.Format(@" , 2 ValueType, 1 DisableValuesUsed ");
                    }
                    if (!string.IsNullOrEmpty(filter.DivisionIdsString))
                    {
                        searchFilter += $" and ItemCategory.DivisionID in ({filter.DivisionIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemCategoryIdsString)) 
                    {
                        searchFilter += $" AND ItemCategory.ItemCategoryID in ({filter.ItemCategoryIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemIdsString))
                    {
                        searchFilter += $" AND Item.ItemID in ({filter.ItemIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.BrandIdsString)) 
                    {
                        searchFilter += $" AND Item.BrandID in ({filter.BrandIdsString}) ";
                    }
                    if (!string.IsNullOrEmpty(filter.ItemGroupIdsString))
                    {
                        searchFilter += $" AND Item.ItemID in (Select ItemID from ItemGroupDetail where ItemGroupID in ({filter.ItemGroupIdsString}) group by ItemID) ";
                    }
                    if(filter.checkExpireIsNew)
                    {
                        searchFilter += $" and isNewExpireDate is not null";
                    }
                }
                string mainQuery = string.Format(@" FROM Item
                LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID
                Left join ItemCategoryLanguage on ItemCategoryLanguage.ItemCategoryID = ItemCategory.ItemCategoryID and ItemCategoryLanguage.LanguageID = {0}
                LEFT OUTER JOIN ItemImage ON ItemImage.ItemID = Item.ItemID {3} {4} {5}
                Where 1=1 {1} {2}",
                _requestRepository.LanguageId, //0
                searchFilter, //1
                exceptedItems,//2
                selectedEmployeeFilter, //3
                showItemsWithUpperLimitFilter, //4
                packTypeSelection //5
                );

                string selectionQuery = string.Format(@"Select ROW_NUMBER() Over(Order By ItemCode ) AS RowSeq,
                Item.*, ItemType ItemTypeID, ISNULL(ShelfLifeTime,-1) ShelfLifeTime, ItemCategory.ItemCategoryID ItemCategoryId, ItemCategory.DivisionID, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END AS HasImage,
                ItemLanguage.Description ItemName, IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName,
                IsNull( ItemCategory.ItemCategoryCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemCategoryLanguage.Description , '--') as CategoryNameCode,
                Case Item.Inactive when 1 then '{4}' else '{5}' end as ItemStatusName, ISNULL(Item.ProductionDateType,0) as ProductionDateType {7}
                {6}
                {0} {1} 
                
                OFFSET  {2} ROWS       
                FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.IsLazyLodingCombo ? filter.CustomListFilter.Page : (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
                filter.CustomListFilter.PageSize,
                ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive, _requestRepository.LanguageId), //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId), //5
                orderBySelectedItem, //6
                oosListSelection //7
                );


        
                if (filter.checkExpireIsNew)
                {
                    string itemsIsNewQuery = string.Format(@" select Item.ItemID,isNewExpireDate {0}",
              mainQuery);

                    result = dbHelper.GetQueryList(itemsIsNewQuery, ref itemsList, true);
                itemsSharedList.Data = itemsList;
                return result;

                }
                
                string countQuery = string.Format(@"select IsNull(Count(*),0) {0}",
              mainQuery);


                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    itemsSharedList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (itemsSharedList.TotalItems <= 0)
                    {
                        itemsSharedList.Data = itemsList;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(selectionQuery, ref itemsList , true);
                itemsSharedList.Data = itemsList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsSharedList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateItemsListIsNewExpireDate(List<ItemPackModel> itemList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dbHelper = new DBHelper<ItemPackModel>();
            try
            {
                //isNewExpireDate = Null ,
                foreach (var item in itemList)
                {
                    string query = string.Format(@"Update Item set  IsNew = 0 Where ItemId = {0}",
                    item.ItemId //0
               );
                    result = dbHelper.ExecuteNonQuery(query);
                }
               
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemModel(ref List<Item_Model> itemModel)
        {
            DBHelper<Item_Model> dBHelperModel = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelperModel = new DBHelper<Item_Model>();
                string query = string.Empty;
                query = string.Format(@"Select Model.*, ModelLanguage.Description ModelName,
                IsNull( Model.ModelCode , '--') + ' ' + '-'+ ' ' + IsNull( ModelLanguage.Description , '--') as ModelCodeName
                From Model 
                left join ModelLanguage on ModelLanguage.ModelID = Model.ModelID and ModelLanguage.LanguageID = {0}",
                _requestRepository.LanguageId);
                result = dBHelperModel.GetQueryList(query, ref itemModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemModel = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemBrand(ref List<ItemBrandModel> brandsList)
        {
            DBHelper<ItemBrandModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ItemBrandModel>();
                string query = string.Format(@"select distinct Brand.BrandID ItemBrandId, BrandLanguage.Description ItemBrandName 
                from Brand
                Left join BrandLanguage on BrandLanguage.BrandID = Brand.BrandID And BrandLanguage.LanguageID = {0}
                LEFT JOIN BrandOrganizations On Brand.BrandId = BrandOrganizations.BrandId where BrandOrganizations.OrganizationID IN ({1})",
                   _requestRepository.LanguageId, //0
                   _requestRepository.CurrentOperator.OrganizationAccess //1
                   );
                result = dBHelper.GetQueryList(query, ref brandsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                brandsList = null;
            }
            return result;
        }
        public GlobalErrors GetItemTypes(ref List<ItemTypeModel> typesList)
        {
            DBHelper<ItemTypeModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ItemTypeModel>();
                string query = string.Format(@"select ItemType.ItemTypeID, ItemTypeLanguage.Description ItemTypeName 
                from ItemType
                Left join ItemTypeLanguage on ItemTypeLanguage.ItemTypeID = ItemType.ItemTypeID And ItemTypeLanguage.LanguageID = {0}",
                _requestRepository.LanguageId //0
                );
                result = dBHelper.GetQueryList(query, ref typesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                typesList = null;
            }
            return result;
        }
        public static int GetMaxItemId(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            int maxItemID = -1;
            try
            {
                string maxItem = "select IsNull(Max(ItemID),0) + 1 from Item";
                result = dBHelper.ExecuteScalar(maxItem, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    maxItemID = Int32.Parse(objField.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return maxItemID;
        }
        public static int GetMaxItemListId(DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object objField = null;
            int maxItemListID = -1;
            try
            {
                string maxItemList = "select IsNull(Max(ItemListID),0) + 1 from ItemsList";
                result = dBHelper.ExecuteScalar(maxItemList, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    maxItemListID = Int32.Parse(objField.ToString().Trim());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return maxItemListID;
        }
        public GlobalErrors GetItemDescriptions(int itemId, ref List<TextLanguage> itemDescriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                itemDescriptions = new List<TextLanguage>();
                string query = string.Format(@"Select * from ItemLanguage where ItemID = {0}", itemId);
                result = dbHelper.GetQueryList(query, ref itemDescriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTradingItemCompetitorsInEditMode(int itemId, int itemTypeId, ref List<CompetitorModel> itemCompetitorsList)
        {
            DBHelper<CompetitorModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CompetitorModel>();
                string query = string.Format(@"select CompetitorItem.CompetitorItemID ,
                IsNull( CompetitorLanguage.Description  , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as CompetitorItemName
                from CompetitorItem
                inner join Competitor on Competitor.CompetitorID = CompetitorItem.CompetitorID
                inner join Item on Item.ItemID = CompetitorItem.CompetitorItemID
                left join ItemLanguage on ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageID = {2}
                left join CompetitorLanguage on CompetitorLanguage.CompetitorID = CompetitorItem.CompetitorID and CompetitorLanguage.LanguageID =  {2}
                where Competitor.OrganizationID in ({1})  and CompetitorItem.ItemID = {0}",
                itemId, //0
                _requestRepository.CurrentOperator.OrganizationAccess, //1
                _requestRepository.LanguageId //2
                );
                result = dbHelper.GetQueryList(query, ref itemCompetitorsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCompetitorItemDataInEditMode(int itemId, int itemTypeId, ref CompetitorModel competitor)
        {
            DBHelper<CompetitorModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<CompetitorModel>();
                string query = string.Format(@"select CompetitorItem.ItemID, CompetitorItem.CompetitorID from CompetitorItem
                        where CompetitorItem.CompetitorItemID = {0}",
                        itemId, //0
                        _requestRepository.CurrentOperator.OrganizationAccess, //1
                        _requestRepository.LanguageId //2
                        );
                result = dbHelper.GetQuerySingle(query, ref competitor);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckIfItemHasImage(int itemId, ref List<TextLanguage> itemDescriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                itemDescriptions = new List<TextLanguage>();
                string query = string.Format(@"Select * from ItemLanguage where ItemID = {0}", itemId);
                result = dbHelper.GetQueryList(query, ref itemDescriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteItemLanguage(int itemID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from ItemLanguage where ItemId = {0}", itemID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemSensors(int itemID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from ItemSensors where ItemId = {0}", itemID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemListLanguage(int itemListID, DBHelper<int> dbHelper, bool oosListMode)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"DELETE FROM dbo.OOSListHeaderLanguage WHERE OOSItemsListID = {0}", itemListID);
                }
                else
                {
                    query = string.Format(@"delete from ItemsListLanguage where ItemListId = {0}", itemListID);
                }
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemListDetails(int itemListID, DBHelper<int> dbHelper, bool oosListMode)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (oosListMode)
                {
                    query = $@"delete Os from OOSListDetails Os
                                 inner join Item I on I.ItemID = Os.ItemID
                                 inner join ItemCategory IC on IC.ItemCategoryID = I.ItemCategoryID
                                 inner join Division D on D.DivisionID = IC.DivisionID and D.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess})
                                 where Os.OOSItemsListID = {itemListID}";
                }
                else
                {
                    query = $@"delete ID from ItemsListDetails ID
                                 inner join Item I on I.ItemID = ID.ItemID
                                 inner join ItemCategory IC on IC.ItemCategoryID = I.ItemCategoryID
                                 inner join Division D on D.DivisionID = IC.DivisionID and D.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess})
                                 where ID.ItemListId = {itemListID}";
                }
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteItemListAssignment(string itemListType, int itemListID, DBHelper<int> dbHelper, bool oosListMode)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                string tableName = oosListMode ? "OOSListAssignment" : "ItemsListAssignment";
                string columnName = oosListMode ? "OOSItemsListID" : "ItemListId";
                string groupColumnName = oosListMode ? "GroupID" : "CustomerGroupID";
                string oosConditions = oosListMode ? "or (EmployeeID is not null or EmployeeID <> -1) or (SecurityGroupID is not null or SecurityGroupID <> -1)" : string.Empty;
                if (itemListType != ItemListType.ItemListEmployee.GetHashCode().ToString() && (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups))
                {
                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                    }

                    string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or ({groupColumnName} is not null or {groupColumnName} <> -1) " : string.Empty;
                    string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                    query = $@"DELETE FROM {tableName} WHERE {columnName} = {itemListID} and ((ChannelID <> -1 or ChannelID is not null)
                                     or (SubChannelID <> -1 or SubChannelID is not null) or AllCustomers = 1 {deleteGroups} {deleteCustomers} {oosConditions})";

                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        query = $@" DELETE TBLA FROM {tableName} TBLA 
                                    inner join CustomerGroup CG  on CG.GroupID = TBLA.{groupColumnName} and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                    WHERE TBLA.{columnName} = {itemListID}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        query = $@" DELETE TBLA FROM {tableName} TBLA 
                                    inner join CustomerOutlet CO on CO.CustomerID = TBLA.CustomerID and CO.OutletID = TBLA.OutletID
                                    { orgAccessJoin }
                                    WHERE TBLA.{columnName} = {itemListID}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    if (oosListMode)
                    {
                        query = string.Format(@"delete from OOSListAssignment where OOSItemsListID = {0}", itemListID);
                    }
                    else
                    {
                        if (itemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                        {
                            query = string.Format(@"delete from ItemsListAssignment where ItemListId = {0}", itemListID);
                        }
                        else
                        {
                            query = string.Format(@"delete from ItemListEmployee where ItemListId = {0}", itemListID);
                        }
                    }
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }



                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors DeleteCustomerItemListOrganization(int itemListID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {//accsess
                query = string.Format(@"delete from CustomerItemsListOrganization where ItemListID ={0} AND OrganizationID in ({1})", itemListID, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteOOSListOrganization(int itemListID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {//accsess
                query = string.Format(@"delete from OOSListOrganization where OOSItemsListID ={0} AND OrganizationID in ({1})", itemListID, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveItemLanguage(ItemPackModel item, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage textLanguage in item.DescriptionLanguages)
                {
                    if (textLanguage.Description == null || string.IsNullOrEmpty(textLanguage.Description.Trim()))
                    {
                        textLanguage.Description = item.ItemName;
                    }
                    string sqlStatment = string.Format("INSERT INTO ItemLanguage (ItemID,LanguageID,Description) Values ({0},{1},'{2}')",
                    item.ItemId,
                    textLanguage.LanguageId,
                    textLanguage.Description.Replace("'", "''").Trim());
                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }        public GlobalErrors SaveItemListLanguage(ItemListModel itemList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlStatment = string.Empty;
                foreach (TextLanguage textLanguage in itemList.DescriptionLanguages)
                {
                    if (textLanguage.Description == null || string.IsNullOrEmpty(textLanguage.Description.Trim()))
                    {
                        textLanguage.Description = itemList.ItemListName;
                    }
                    if (itemList.OOSListMode)
                    {
                        sqlStatment = string.Format("INSERT INTO OOSListHeaderLanguage(OOSItemsListID, LanguageID, Description)VALUES({0},{1},'{2}')",
                            itemList.ItemListId,
                        textLanguage.LanguageId,
                        textLanguage.Description.Replace("'", "''"));
                    }
                    else
                    {
                        sqlStatment = string.Format("INSERT INTO ItemsListLanguage (ItemListID,LanguageID,Description) Values ({0},{1},'{2}')",

                        itemList.ItemListId,
                    textLanguage.LanguageId,
                    textLanguage.Description.Replace("'", "''"));
                    }
                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveItemListDetails(ItemListModel itemList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (itemList.itemsId != null && itemList.itemsId.Count > 0)
                {
                    foreach (var item in itemList.items)
                    {
                        if (itemList.OOSListMode)
                        {
                            query = string.Format(@"INSERT INTO OOSListDetails (ItemID,OOSItemsListID,Listed,MinimumQuantity) values({0},{1},{2},{3}) ", item.ItemId, itemList.ItemListId, item.BooleanValue ? "1" : "0", item.MinimumQuantity);
                        }
                        else
                        {
                            query = string.Format(@"insert into ItemsListDetails (ItemID , ItemListID) values({0},{1}) ", item.ItemId, itemList.ItemListId);
                        }
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
                //if (!itemList.AllItems)
                //{
                //}
                //else
                //{

                //    if (itemList.OOSListMode)
                //    {

                //        query = string.Format(@"INSERT INTO OOSListDetails (ItemID,OOSItemsListID) SELECT   Item.ItemID ,{1} FROM Item
                //                                    LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                //                                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                //                                    LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                //                                    LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0} 
                //                                    where Item.Inactive = 0 ", _requestRepository.LanguageId, itemList.ItemListId);
                //    }
                //    else
                //    {
                //        query = string.Format(@"insert into ItemsListDetails (ItemID , ItemListID)  SELECT   Item.ItemID ,{1} FROM Item
                //                                    LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {0}
                //                                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                //                                    LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {0}
                //                                    LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {0} 
                //                                    where Item.Inactive = 0 ", _requestRepository.LanguageId, itemList.ItemListId);
                //    }

                //    result = dbHelper.ExecuteNonQuery(query);

                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveCustomerItemListOrganization(ItemListModel itemList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (itemList.AppliedOrganizations != null && itemList.AppliedOrganizations.Count != 0)
                {
                    foreach (var org in itemList.AppliedOrganizations)
                    {
                        query = string.Format(@"INSERT INTO CustomerItemsListOrganization VALUES ({0}, {1})", itemList.ItemListId, org.OrganizationId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveOOSListOrganization(ItemListModel itemList, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (itemList.AppliedOrganizations != null && itemList.AppliedOrganizations.Count != 0)
                {
                    foreach (var org in itemList.AppliedOrganizations)
                    {
                        query = string.Format(@"INSERT INTO OOSListOrganization VALUES ({0}, {1})", itemList.ItemListId, org.OrganizationId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertItemListAssignment(int itemListAssignmentId, ItemListModel itemList, DBHelper<int> dbHelper, bool oosListMode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                if (itemList.ItemListType == ItemListType.ItemListCustomer.GetHashCode().ToString())
                {
                    if (oosListMode)
                    {
                        if (itemList.AppliedEmployees != null && itemList.AppliedEmployees.Count > 0)
                        {
                            foreach (EmployeeModel employee in itemList.AppliedEmployees)
                            {
                                result = InsertAppliedEmployeesToItemList(employee.EmployeeId, itemListAssignmentId, itemList.ItemListId, oosListMode, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                                itemListAssignmentId++;
                            }
                        }
                        if (itemList.AppliedSecurityGroups != null && itemList.AppliedSecurityGroups.Count > 0)
                        {
                            foreach (SecurityGroupModel securityGroup in itemList.AppliedSecurityGroups)
                            {
                                result = AssignOOSItemListToSecurityGroup(securityGroup, itemList.ItemListId, dbHelper);
                                if (result != GlobalErrors.Success) return result;
                                itemListAssignmentId++;
                            }
                        }
                    }
                    if (itemList.AllCustomers)
                    {
                        SimpleCustomerModel customer = new SimpleCustomerModel();
                        result = InsertAppliedCustomersToItemList(customer, itemListAssignmentId, itemList.ItemListId, true, dbHelper, oosListMode);
                        if (result != GlobalErrors.Success) return result;
                    }
                    else
                    {
                        if (itemList.AppliedCustomers != null && itemList.AppliedCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel customer in itemList.AppliedCustomers)
                            {
                                result = InsertAppliedCustomersToItemList(customer, itemListAssignmentId, itemList.ItemListId, itemList.AllCustomers, dbHelper, oosListMode);
                                if (result != GlobalErrors.Success) return result;
                                itemListAssignmentId++;
                            }
                        }
                        //Save applied groups
                        if (itemList.AppliedGroups != null && itemList.AppliedGroups.Count > 0)
                        {
                            foreach (CustomerGroupModel group in itemList.AppliedGroups)
                            {
                                result = InsertAppliedGroupsToItemList(group, itemListAssignmentId, itemList.ItemListId, dbHelper, oosListMode);
                                if (result != GlobalErrors.Success) return result;
                                itemListAssignmentId++;
                            }
                        }
                        //Save applied channels
                        if (itemList.AppliedChannels != null && itemList.AppliedChannels.Count > 0)
                        {
                            foreach (CustomerChannelModel channel in itemList.AppliedChannels)
                            {
                                result = InsertAppliedChannelsToItemList(channel, itemListAssignmentId, itemList.ItemListId, dbHelper, oosListMode);
                                if (result != GlobalErrors.Success) return result;
                                itemListAssignmentId++;
                            }
                        }
                    }
                }
                else
                {
                    if (itemList.AllEmployees)
                    {
                        result = InsertAppliedEmployeesToItemList(-1, itemListAssignmentId, itemList.ItemListId, oosListMode, dbHelper);
                    }
                    else
                    {
                        foreach (EmployeeModel employee in itemList.AppliedEmployees)
                        {
                            result = InsertAppliedEmployeesToItemList(employee.EmployeeId, itemListAssignmentId, itemList.ItemListId, oosListMode, dbHelper);
                            if (result != GlobalErrors.Success) return result;
                            itemListAssignmentId++;
                        }
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateItem(ItemPackModel item, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update Item set ItemCode='{1}',ItemType={2},ItemCategoryID={3},BrandID={4},ModelID={5},
                ShelfLifeTime={6},PackDefinition='{7}',CreatedBy={8},CreatedDate={9},UpdatedBy={8},UpdatedDate={9},DefaultPackID={10}, 
                Inactive={11},TemporaryCredit={12},ForceDefaultPack={13},IsBatchPriced={14},IsNew={15},IsPriceProtected={16},IsPowerSKU={17},
                IsInitiative={18},IsDefaultBatchNo={19}, HasSerialNumber = {20}, AutoGenerateSubSerials = {21}, EnableBatchForSerial={22}, RequiredByLiter ={23}, VendorID = {24}, ProductionDateType = {25},
                InSCS = {26}, InStock = {27}, Sequence = {28}, StockTolerance = {29}, StorageTolerance = {30}, WeightTolerance = {31}, LowStockQty ={32} , isNewExpireDate = {33}
                Where ItemId = {0}",
                item.ItemId, //0
                item.ItemCode.Replace("'", "''").Trim(), //1
                item.ItemTypeId, //2
                item.ItemCategoryId, //3
                item.BrandId == -1 ? "null" : item.BrandId.ToString(), //4
                item.ModelId == -1 ? "null" : item.ModelId.ToString(), //5
                item.ShelfLifeTime == -1 ? "Null" : item.ShelfLifeTime.ToString(), //6
                item.PackDefinition.Replace("'", "''"), //7
                _requestRepository.CurrentOperator.EmployeeId, //8
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //9
                "Null", // default pack id will set later //10
                item.Inactive ? 1 : 0, //11
                item.TemporaryCredit ? 1 : 0, //12
                item.ForceDefaultPack ? 1 : 0, //13
                item.IsBatchPriced ? 1 : 0, //14
                item.IsNew ? 1 : 0, //15
                item.IsPriceProtected ? 1 : 0, //16
                item.IsPowerSKU ? 1 : 0, //17
                item.IsInitiative ? 1 : 0, //18
                item.IsDefaultBatchNo ? 1 : 0, //19
                item.HasSerialNumber ? 1 : 0, //20
                item.AutoGenerateSubSerials ? 1 : 0, //21
                item.EnableBatchForSerial ? 1 : 0, //22
                item.RequiredByLiter ? 1 : 0, //23
                item.VendorId == -1 ? "null" : item.VendorId.ToString(), //24
                item.ProductionDateType > -1 ? item.ProductionDateType : 0, //25
                item.InSCS ? 1 : 0, //26
                item.InStock ? 1 : 0, //27
                item.Sequence == -1 ? "Null" : item.Sequence.ToString(), //28
                item.StockTolerance == 0 ? "Null" : item.StockTolerance.ToString(), //29
                item.StorageTolerance == 0 ? "Null" : item.StorageTolerance.ToString(), //30
                item.WeightTolerance == 0 ? "Null" : item.WeightTolerance.ToString(),//31
                item.LowStockQty,//32
                item.isNewExpireDateModel.Date.Year==1 ? "Null" : LocalUtilities.ParseDateToSQLString(item.isNewExpireDateModel.Date)
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateItemList(ItemListModel itemList, DBHelper<int> dbHelper, bool oosListMode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (oosListMode)
                {
                    query = string.Format(@"UPDATE dbo.OOSListHeader 
                                            SET   OOSItemsListCode = '{1}',ValidFrom = {2},ValidTo = {3},UpdatedBy = {4},UpdatedDate = {5}
                                            where OOSItemsListID={0}"
                                            , itemList.ItemListId,//0
                                            itemList.ItemListCode,//1
                                            LocalUtilities.ParseDateToSQLString(itemList.StartDate),//2
                                            LocalUtilities.ParseDateToSQLString(itemList.EndDate),//3
                                            _requestRepository.CurrentOperator.EmployeeId,//4
                                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //5
                                            );
                }
                else
                {
                    query = string.Format(@"update ItemsList set ItemListCode='{1}' where ItemListID={0}", itemList.ItemListId, itemList.ItemListCode);
                }
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateItemGroup(ItemGroupEntryModel itemGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Empty;
                string updateQuery = string.Empty;

                deleteQuery = $@"delete IG from ItemGroupDetail IG
                                 inner join Item I on I.ItemID = IG.ItemID
                                 inner join ItemCategory IC on IC.ItemCategoryID = I.ItemCategoryID
                                 inner join Division D on D.DivisionID = IC.DivisionID and D.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                 where IG.ItemGroupID = {itemGroup.ItemGroupId}";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    deleteQuery = string.Format(@"delete from ItemGroupLanguage where ItemGroupID = {0}", itemGroup.ItemGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    deleteQuery = string.Format(@"delete from ItemGroupOrganization where ItemGroupID = {0}", itemGroup.ItemGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    updateQuery = string.Format(@"Update ItemGroup Set MasterItemGroupID = {0} Where ItemGroupID = {1}", itemGroup.MasterItemGroupID, itemGroup.ItemGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(updateQuery);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = InsertItemGroupDetails(itemGroup, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertItemGroupLanguage(itemGroup, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertItemGroupOrganization(itemGroup, dbHelper);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertItemGroup(ItemGroupEntryModel itemGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"insert into ItemGroup(ItemGroupID,MasterItemGroupID) values({0},{1})", itemGroup.ItemGroupId, itemGroup.MasterItemGroupID);

                result = dbHelper.ExecuteNonQuery(query);

                if (result == GlobalErrors.Success)
                    result = InsertItemGroupDetails(itemGroup, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertItemGroupLanguage(itemGroup, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertItemGroupOrganization(itemGroup, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertItemGroupDetails(ItemGroupEntryModel itemGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {

                if (itemGroup.AllItems)
                {
                    var configuration = _requestRepository.Configurations.EnableSplitOrder;
                    var filter = configuration ? " and Item.ItemID not in (select I.ItemID from ItemGroupDetail I)" : string.Empty;

                    query = string.Format(@"insert into ItemGroupDetail(ItemID,ItemGroupID) SELECT   Item.ItemID ,{0} FROM Item
                                                    LEFT OUTER JOIN BrandLanguage ON BrandLanguage.BrandID = Item.BrandID AND BrandLanguage.LanguageID = {1}
                                                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                                                    LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = ItemCategory.DivisionID AND DivisionLanguage.LanguageID = {1}
                                                    LEFT OUTER JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemId AND Itemlanguage.LanguageID = {1} 
                                                    where Item.Inactive = 0 {2} ", itemGroup.ItemGroupId, _requestRepository.LanguageId, filter);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                {
                    foreach (var item in itemGroup.itemIdsList)
                    {
                        query = string.Format(@"insert into ItemGroupDetail(ItemGroupID, ItemID)values({0},{1})", itemGroup.ItemGroupId, item.ItemId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }

                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertItemGroupLanguage(ItemGroupEntryModel itemGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlStatment = string.Empty;
                foreach (TextLanguage textLanguage in itemGroup.languageDescriptions)
                {
                    if (!string.IsNullOrEmpty(textLanguage.Description))
                    {
                        sqlStatment = string.Format("insert into ItemGroupLanguage(ItemGroupID, LanguageID, Description)VALUES({0},{1},'{2}')",
                            itemGroup.ItemGroupId,
                        textLanguage.LanguageId,
                        textLanguage.Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                    }
                    //if (result != GlobalErrors.Success)
                    //    break;

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertItemGroupOrganization(ItemGroupEntryModel itemGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                foreach (OrganizationModel organization in itemGroup.OrganizationsList)
                {
                        query = string.Format(@"insert into ItemGroupOrganization (ItemGroupID,OrganizationID) values ({0},{1})", itemGroup.ItemGroupId, organization.OrganizationId);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertNewItem(ItemPackModel item, DBHelper<int> dBHelper)
        {
            try
            {
                string query = string.Format(@"INSERT INTO Item (ItemID,ItemCode,ItemType,ItemCategoryID,BrandID,ModelID,ShelfLifeTime,PackDefinition,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,DefaultPackID, 
                Inactive,TemporaryCredit,ForceDefaultPack,IsBatchPriced,IsNew,IsPriceProtected,IsPowerSKU,IsInitiative,IsDefaultBatchNo, HasSerialNumber, AutoGenerateSubSerials,EnableBatchForSerial,RequiredByLiter,VendorID,ProductionDateType,InSCS,InStock, Sequence, StockTolerance, StorageTolerance, WeightTolerance,LowStockQty,isNewExpireDate )
                VALUES({0},'{1}',{2},{3},{4},{5},{6},'{7}',{8},{9},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{23},{24},{25},{26},{27},{28},{29},{30},{31},{32},{33})",
                item.ItemId, //0
                item.ItemCode.Replace("'", "''").Trim(), //1
                item.ItemTypeId, //2
                item.ItemCategoryId, //3
                item.BrandId == -1 ? "null" : item.BrandId.ToString(), //4
                item.ModelId == -1 ? "null" : item.ModelId.ToString(), //5
                item.ShelfLifeTime == -1 ? "Null" : item.ShelfLifeTime.ToString(), //6
                item.PackDefinition.Replace("'", "''"), //7
                _requestRepository.CurrentOperator.EmployeeId, //8
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //9
                "Null", // default pack id will set later //10
                item.Inactive ? 1 : 0, //11
                item.TemporaryCredit ? 1 : 0, //12
                item.ForceDefaultPack ? 1 : 0, //13
                item.IsBatchPriced ? 1 : 0, //14
                item.IsNew ? 1 : 0, //15
                item.IsPriceProtected ? 1 : 0, //16
                item.IsPowerSKU ? 1 : 0, //17
                item.IsInitiative ? 1 : 0, //18
                item.IsDefaultBatchNo ? 1 : 0, //19
                item.HasSerialNumber ? 1 : 0, //20
                item.AutoGenerateSubSerials ? 1 : 0, //21
                item.EnableBatchForSerial ? 1 : 0, //22
                item.RequiredByLiter ? 1 : 0, //23
                item.VendorId == -1 ? "null" : item.VendorId.ToString(), // 24
                item.ProductionDateType > -1 ? item.ProductionDateType : 0, //25
                item.InSCS ? 1 : 0, //26
                item.InStock ? 1 : 0, //27
                item.Sequence == -1 ? "Null" : item.Sequence.ToString(), //28
                item.StockTolerance == 0 ? "Null" : item.StockTolerance.ToString(), //29
                item.StorageTolerance == 0 ? "Null" : item.StorageTolerance.ToString(), //30
                item.WeightTolerance == 0 ? "Null" : item.WeightTolerance.ToString(), //31
                item.LowStockQty, //32
                item.isNewExpireDateModel.Date.Year == 1 ? "Null" : LocalUtilities.ParseDateToSQLString(item.isNewExpireDateModel.Date)//33
                );

                return dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;

            }
        }
        public GlobalErrors InsertNewItemList(ItemListModel itemList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (itemList.OOSListMode)
                {
                    query = string.Format(@"INSERT INTO dbo.OOSListHeader
                                          (OOSItemsListID,OOSItemsListCode,CreatedBy,
                                           CreatedDate,ValidFrom,ValidTo,UpdatedBy,UpdatedDate)
                                           VALUES({0},'{1}',{2},{3},{4},{5},{6},{7})",
                               itemList.ItemListId, //0
                               itemList.ItemListCode, //1
                               _requestRepository.CurrentOperator.EmployeeId,  //2
                                                                               //itemList.ItemListType
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //3
                               LocalUtilities.ParseDateToSQLString(itemList.StartDate), //4
                               LocalUtilities.ParseDateToSQLString(itemList.EndDate), //5
                               _requestRepository.CurrentOperator.EmployeeId,//6
                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //7
                               );
                }
                else
                {
                    query = string.Format(@"insert into ItemsList (ItemListID , ItemListCode , ItemListType) Values({0},'{1}',{2})",
                               itemList.ItemListId, itemList.ItemListCode, itemList.ItemListType);
                }
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetItemDefaultPackId(ItemPackModel item, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update Item Set DefaultPackID = {0} Where ItemID = {1}",
                item.DefaultPackId, //0
                item.ItemId //1
                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertCompetitor(ItemPackModel item, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (item.ItemTypeId == ItemTypes.CompetitorItem.GetHashCode() && item.Competitor != null)
                {
                    string query = string.Format(@"Insert into CompetitorItem (CompetitorItemID, ItemID, CompetitorID) 
                            values ({0} , {1} , {2} )",
                            item.ItemId, // 0
                            item.Competitor.ItemId, // 1
                            item.Competitor.CompetitorId // 2
                            );

                    result = dBHelper.ExecuteNonQuery(query);
                }
                else if (item.ItemTypeId == ItemTypes.TradingItem.GetHashCode() && item.CompetitorsList != null && item.CompetitorsList.Count > 0)
                {
                    foreach (CompetitorModel competitor in item.CompetitorsList)
                    {
                        string queryString = string.Format(@"update CompetitorItem set ItemID = {1} where CompetitorItemID = {0}",
                               competitor.CompetitorItemId, // 0
                               item.ItemId, // 1
                               competitor.CompetitorItemId // 2
                               );
                        result = dBHelper.ExecuteNonQuery(queryString);
                    }
                }
                else
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;

            }
        }
        public GlobalErrors DeleteCompetitor(ItemPackModel item, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (item.ItemTypeId == ItemTypes.TradingItem.GetHashCode() || item.ItemTypeId == ItemTypes.CompetitorItem.GetHashCode())
                {
                    string queryStringSQL = string.Format(@"
                            update CompetitorItem set ItemID = -1 where ItemID = {0}",
                       item.ItemId// 0
                       );
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryStringSQL);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }

                }
                string queryString = string.Format(@"
                            Delete from CompetitorItem where CompetitorItem.CompetitorItemID = {0}",
                           item.ItemId // 0
                           );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNewPack(PackModel pack, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO Pack (PackID,Barcode,ItemID,PackTypeID,Quantity,EquivalencyFactor,AllowFractionInQty,
                TrackCaseBySerialNumber,IsWeightPriced,SerialSeparator,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,TemplateID,HasSerialNumber,Height,Width,Dipth,Weight,ChildPackID,GTIN,CompanyPrefix)
                VALUES ({0},'{1}',{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{10},{11},{12},{13},{14},{15},{16},{17},{18},'{19}',{20})",
                pack.PackId, //0
                pack.PackBarcode.Replace("'", "''"), //1
                pack.ItemId, //2
                pack.PackTypeId, //3
                pack.Quantity, //4
                pack.EquivalencyFactor, //5
                pack.AllowFractionInQty ? 1 : 0, //6
                0, //7
                pack.IsWeightPriced ? 1 : 0,  //8
                pack.SerialSeparator == null || string.IsNullOrEmpty(pack.SerialSeparator) ? "Null" : "'" + pack.SerialSeparator.Replace("'", "''") + "'", //9
                _requestRepository.CurrentOperator.EmployeeId, //10
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//11
                pack.TemplateId, //12
                pack.HasSerialNumber ? 1 : 0, //13
                pack.Height, //14
                pack.Width, //15
                pack.Dipth, //16
                pack.Weight, //17
                pack.ChildPackId, // 18
                pack.GTIN.Replace("'", "''"), // 19
                pack.CompanyPrefix >= 0 ? pack.CompanyPrefix.ToString() : "NULL" //20
                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePack(PackModel packGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update Pack set [Barcode] ='{1}',[PackTypeID]= {2},[Quantity] = {3},[EquivalencyFactor] = {4},
                [IsWeightPriced]= {5},[SerialSeparator]= {6},[UpdatedBy]= {7},[UpdatedDate]= {8}, [TemplateID] = {9},HasSerialNumber={10},
                Height={11},Width={12},Dipth={13},Weight={14},GTIN = '{15}', ChildPackID = {16}, CompanyPrefix = {17},AllowFractionInQty = {18}
                where PackID = {0} ",
                packGroup.PackId, //0
                packGroup.PackBarcode.Replace("'", "''"),//1
                packGroup.PackTypeId,//2
                packGroup.Quantity,//3
                packGroup.EquivalencyFactor,//4
                packGroup.IsWeightPriced ? 1 : 0,//5
                packGroup.SerialSeparator == null || string.IsNullOrEmpty(packGroup.SerialSeparator) ? "Null" : "'" + packGroup.SerialSeparator.Replace("'", "''") + "'",//6
                _requestRepository.CurrentOperator.EmployeeId,//7
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//8
                packGroup.TemplateId,//9
                packGroup.HasSerialNumber ? 1 : 0,//10
                packGroup.Height,//11
                packGroup.Width,//12
                packGroup.Dipth,//13
                packGroup.Weight,//14
                packGroup.GTIN, //15
                packGroup.ChildPackId, //16
                packGroup.CompanyPrefix >= 0 ? packGroup.CompanyPrefix.ToString() : "NULL", //17
                packGroup.AllowFractionInQty ? 1 :0 //18
                );

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPackGroupsItemDefinition(ref List<PackGroupModel> packGroupList)
        {
            DBHelper<PackGroupModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string orgFilter = string.Empty;
                string groupsHavingSamePackQuantityFilter = string.Empty;
                dBHelper = new DBHelper<PackGroupModel>();

                if (_requestRepository.Configurations.ForceOrganizationFilterForPackGroups)
                {
                    orgFilter += string.Format(" And PackGroup.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                }

                string query = string.Format(@"DECLARE @Table as table(PackGroupID int, Quantity decimal(19, 9), RowNumber int);
                INSERT INTO @Table select DISTINCT PackGroupID, Pack.Quantity, Dense_RANK() OVER(
                PARTITION BY PackGroupID
                ORDER BY PackGroupID, Pack.Quantity) as RowNum
                from PackGroupDetail
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID;

                SELECT Distinct PackGroup.PackGroupID ,PackGroup.PackGroupCode ,PackGroupLanguage.Description PackGroupName,
                IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName,
                CASE WHEN PromotionOptionDetail.PackGroupID is not null then 1 else 0 end as HasPromotion, GroupDetails.CountNum, IsNull(GroupQty.Quantity,0) GroupPackQuantity
                FROM PackGroup

                LEFT JOIN PromotionOptionDetail on PromotionOptionDetail.PackGroupID = PackGroup.PackGroupID
                LEFT JOIN Promotion on Promotion.PromotionID = PromotionOptionDetail.PromotionID And Promotion.IsDeleted = 0
                LEFT JOIN PackGroupLanguage on PackGroup.PackGroupID = PackGroupLanguage.PackGroupID And PackGroupLanguage.LanguageID = {0}

                LEFT JOIN(SELECT PackGroupID, COUNT(*) CountNum FROM @Table GROUP BY PackGroupID) as GroupDetails on GroupDetails.PackGroupID = PackGroup.PackGroupID
                LEFT JOIN(SELECT PackGroupID, Quantity FROM @Table WHERE RowNumber = 1) as GroupQty on GroupQty.PackGroupID = PackGroup.PackGroupID
                where (PackGroup.IsDeleted <> 1) AND (PackGroup.Inactive = 0 or PackGroup.Inactive is null) 
                And ((PromotionOptionDetail.PackGroupID is not null AND GroupDetails.CountNum = 1) OR (PromotionOptionDetail.PackGroupID is null)) {1}",
                _requestRepository.LanguageId, //0
                orgFilter //1
                );

                result = dBHelper.GetQueryList(query, ref packGroupList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                packGroupList = null;
            }
            return result;
        }
        public GlobalErrors InsertAppliedCustomersToItemList(SimpleCustomerModel customerOutlet, int itemListAssignmentID, int itemListId, bool allCustomers, DBHelper<int> dBHelper, bool oosListMode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"INSERT INTO OOSListAssignment (OOSItemsListID,CustomerID,OutletID,GroupID,ChannelID,SubChannelID,AllCustomers,EmployeeID,SecurityGroupID)
                                             VALUES ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8})",
                                            itemListId, customerOutlet.CustomerId, customerOutlet.OutletId, -1, -1, -1, allCustomers ? 1 : 0, -1, -1);
                }
                else
                {
                    query = string.Format(@"insert into ItemsListAssignment(ItemsListAssignmentID, ItemListID, CustomerID, OutletID, AllCustomers)
                            values({0},{1},{2},{3},{4})"
                   , itemListAssignmentID, itemListId, customerOutlet.CustomerId, customerOutlet.OutletId, allCustomers ? "1" : "0");//, -1, -1, -1);
                }
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors AssignOOSItemListToSecurityGroup(SecurityGroupModel securityGroup, int itemListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO OOSListAssignment (OOSItemsListID,CustomerID,OutletID,GroupID,ChannelID,SubChannelID,AllCustomers,EmployeeID,SecurityGroupID)
                                             VALUES ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8})",
                                            itemListId, -1, -1, -1, -1, -1, 0, -1, securityGroup.SecurityGroupId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedEmployeesToItemList(int employeeID, int itemListAssignmentID, int itemListId, bool oosListMode, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"INSERT INTO OOSListAssignment (OOSItemsListID,CustomerID,OutletID,GroupID,ChannelID,SubChannelID,AllCustomers,EmployeeID,SecurityGroupID)
                                             VALUES ({0}, {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8})",
                                            itemListId, -1, -1, -1, -1, -1, 0, employeeID, -1);
                }
                else
                {
                    query = string.Format(@"insert into ItemListEmployee (ItemListEmployeeID , EmployeeID , ItemListID) values ({0} , {1} , {2})"
                    , itemListAssignmentID, employeeID, itemListId);
                }
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToItemList(CustomerGroupModel group, int itemListAssignmentID, int itemListId, DBHelper<int> dBHelper, bool oosListMode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"INSERT INTO OOSListAssignment
                                           (OOSItemsListID,CustomerID,OutletID,GroupID,ChannelID,SubChannelID,
                                            AllCustomers,EmployeeID,SecurityGroupID)
                                            VALUES({0},{1},-1,{2},-1,-1,0,-1,-1)",
                                            itemListId, -1, group.GroupId);
                }
                else
                {
                    query = string.Format(@"Insert into ItemsListAssignment (itemListID,ItemsListAssignmentID,CustomerGroupID) values ({0},{1},{2})",
                   itemListId, itemListAssignmentID, group.GroupId);
                }
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedChannelsToItemList(CustomerChannelModel channel, int itemListAssignmentID, int itemListId, DBHelper<int> dBHelper, bool oosListMode)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Empty;
                if (oosListMode)
                {
                    query = string.Format(@"INSERT INTO OOSListAssignment
                                           (OOSItemsListID,CustomerID,OutletID,GroupID,ChannelID,SubChannelID,
                                            AllCustomers,EmployeeID,SecurityGroupID)
                                            VALUES({0},{1},-1,-1,{2},{3}, 0,-1,-1)",
                                            itemListId, -1, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);
                }
                else
                {

                    query = string.Format(@"Insert into ItemsListAssignment (ItemListID,ItemsListAssignmentID,ChannelID,SubChannelID) values ({0},{1},{2},{3})",
                    itemListId, itemListAssignmentID, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);
                }


                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetItemsTemplate(ref List<BarcodeTemplateModel> itemsTemplateList)
        {
            DBHelper<BarcodeTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                itemsTemplateList = new List<BarcodeTemplateModel>();
                dbHelper = new DBHelper<BarcodeTemplateModel>();
                string query = string.Format(@"SELECT DISTINCT BarcodeTemplate.TemplateId TemplateId, BarcodeTemplateLanguage.Description TemplateName, BarcodeTemplate.TemplateCode TemplateCode,
                IsNull( BarcodeTemplate.TemplateCode , '--') + ' ' + '-'+ ' ' + IsNull( BarcodeTemplateLanguage.Description , '--') as TemplateCodeName,
                case when BarcodeTemplateDetails.fieldID is not null  then 1 else 0 end as ContainsGTIN
                FROM BarcodeTemplate 
                INNER JOIN BarcodeTemplateLanguage ON BarcodeTemplate.TemplateId = BarcodeTemplateLanguage.TemplateId  AND BarcodeTemplateLanguage.LanguageID = {0}
                left JOIN BarcodeTemplateDetails on BarcodeTemplateDetails.TemplateID = BarcodeTemplate.TemplateID and FieldID = 1",
                _requestRepository.LanguageId //0
                );
                result = dbHelper.GetQueryList(query, ref itemsTemplateList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsTemplateList = null;
                return GlobalErrors.Error;
            }
            return result;
        }


        #endregion

        public static int GetMaxBrandID()
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            int brandId = 1;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format("select ISNULL( MAX(BrandId) , 0)  + 1 From Brand");

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    brandId = (int)field;
                }

                return brandId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return brandId;
            }
        }
        public GlobalErrors GetAlllBrands(string brandIdsString, ref List<BrandModel> allBrands)
        {
            
                DBHelper<BrandModel> dBHelper = null;
                GlobalErrors result = GlobalErrors.NotInitialized;
                try
                {
                    dBHelper = new DBHelper<BrandModel>();
                    string showInCustomerAppJoin = string.Empty;
                    string showInCustomerAppSelection = string.Empty;
                    string filterByBrandIds = string.Empty;
                    if (_requestRepository.Configurations.AllowCustomerAppLogin)
                    {
                        showInCustomerAppSelection = ",CASE WHEN (BrandCustomerApp.BrandId IS NULL) THEN 0 ELSE 1 END as ShowInCustomerApp ";
                        showInCustomerAppJoin = "LEFT JOIN BrandCustomerApp on BrandCustomerApp.BrandId = Brand.BrandId";
                    }
                    if (!string.IsNullOrEmpty(brandIdsString))
                    {
                        filterByBrandIds = $"and Brand.BrandID in ({brandIdsString}) ";
                    }
                    string query = string.Format(@"select distinct Brand.BrandId , BrandLanguage.Description BrandName , Brand.BrandCode,
                Case Brand.OrganizationID when -1 then '{4}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName,
                CASE WHEN BrandImage.BrandId IS NULL THEN 0 ELSE 1 END AS HasImage {1}
                from Brand 
                LEFT JOIN BrandLanguage on BrandLanguage.BrandId = Brand.BrandId AND BrandLanguage.LanguageId = {0}
                Left Join BrandImage on BrandImage.BrandID = Brand.BrandID
                left join Organization on Brand.OrganizationId = Organization.OrganizationID 
                left join OrganizationLanguage on Brand.OrganizationId = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                LEFT OUTER JOIN BrandOrganizations On Brand.BrandId = BrandOrganizations.BrandId
                {2}
                Where BrandOrganizations.OrganizationID IN ({5}) {3}",
                    _requestRepository.LanguageId, //0
                    showInCustomerAppSelection, //1
                    showInCustomerAppJoin,//2
                    filterByBrandIds,//3
                    ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organizations, _requestRepository.LanguageId),//4
                    _requestRepository.CurrentOperator.OrganizationAccess //5

                    );
                    result = dBHelper.GetQueryList(query, ref allBrands, true);

                    #region [Get organizations]
                    result = GetBrandOrganizations(ref allBrands);
                    if (result != GlobalErrors.Success) return result = GlobalErrors.Error;
                    #endregion

                }
                catch (Exception ex)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                    result = GlobalErrors.Error;
                    allBrands = null;
                }
                finally
                {
                    if (dBHelper != null)
                    {
                        dBHelper.Dispose();
                        dBHelper = null;
                    }
                }
                return result;
            }
            public GlobalErrors GetBrandOrganizations(ref List<BrandModel> allBrands)
            {
                DBHelper<OrganizationModel> dBHelper2 = new DBHelper<OrganizationModel>(); ;
                GlobalErrors result = GlobalErrors.NotInitialized;
                try
                {
                    List<OrganizationModel> brandOrganizations = new List<OrganizationModel>();
                    foreach (BrandModel brand in allBrands)
                    {
                        string query2 = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, 
                        IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                        FROM BrandOrganizations
                        inner join Organization on Organization.OrganizationID = BrandOrganizations.OrganizationID
                        left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                        where BrandOrganizations.BrandId = {1} and BrandOrganizations.OrganizationId in ({2})",
                        _requestRepository.LanguageId, //0
                        brand.BrandId, //1
                        _requestRepository.CurrentOperator.OrganizationAccess //2
                        );
                        result = dBHelper2.GetQueryList(query2, ref brandOrganizations);
                        if (result == GlobalErrors.Success && brandOrganizations != null && brandOrganizations.Count > 0)
                        {
                            brand.OrganizationsList = brandOrganizations;
                        }
                    }
                }
                catch (Exception ex)
                {
                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                    return GlobalErrors.Error;
                }
                return result;
            }
            public GlobalErrors GetBrandDescriptions(int brandlId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from BrandLanguage
                where BrandLanguage.BrandID={0}", brandlId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveBrandData(BrandModel brand, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (brand.BrandId == -1)
                {
                    brand.BrandId = GetMaxBrandID();
                    query = string.Format(@"INSERT INTO Brand(BrandID,BrandCode, OrganizationId) Values({0},'{1}',{2})",
                    brand.BrandId, brand.BrandCode, brand.OrganizationsList.Count == 1 ? brand.OrganizationsList[0].OrganizationId : -1);
                    result = dbHelper.ExecuteNonQuery(query.ToString());

                }
                else
                {
                    query = string.Format(@"Update Brand Set BrandCode = '{1}', OrganizationId = {2} where BrandId = {0}",
                    brand.BrandId, brand.BrandCode, brand.OrganizationsList.Count == 1 ? brand.OrganizationsList[0].OrganizationId : -1);
                    result = dbHelper.ExecuteNonQuery(query.ToString());
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Delete from BrandOrganizations where BrandId = {0} and OrganizationId in ({1})", brand.BrandId, _requestRepository.CurrentOperator.OrganizationAccess);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                }

                // save brand org
                result = SaveBrandOrganization(brand, dbHelper);
                if (result != GlobalErrors.Success) return result;

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveBrandOrganization(BrandModel brand, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (brand.OrganizationsList != null && brand.OrganizationsList.Count > 0)
                {
                    StringBuilder values = new StringBuilder();
                    foreach (OrganizationModel organizationObject in brand.OrganizationsList)
                    {
                        values.AppendFormat("( {0},{1} ),",
                        brand.BrandId, //1
                        organizationObject.OrganizationId //2
                        );
                    }
                    query = string.Format(@"Insert Into BrandOrganizations (BrandId, OrganizationId) Values {0}", values.ToString().TrimEnd(','));
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveBrandLanguage(int brandId, int languageId, string text, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO BrandLanguage (BrandId , LanguageId , Description) Values  ");
                sqlStatment.Append("(");
                sqlStatment.Append(brandId);
                sqlStatment.Append(",");
                sqlStatment.Append(languageId);
                sqlStatment.Append(",");
                sqlStatment.AppendFormat("'{0}'", (text.Replace("'", "''")).ToString());
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteBrandImage(int brandId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM BrandImage WHERE BrandId = {0}", brandId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {

                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveBrandImage(int brandId, byte[] image, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object param = new object();
                param = new { image = image };
                string query = string.Format(@"INSERT INTO BrandImage(BrandID,Image) Values({0},{1})", brandId, "@image");
                result = dbHelper.ExecuteNonQueryWithParameters(query, param);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditBrandLanguage(BrandModel brandModel, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format("delete from BrandLanguage where BrandID={0}", brandModel.BrandId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                //Save language
                foreach (TextLanguage language in brandModel.DescriptionLanguages)
                {
                    query = string.Format(@"insert into BrandLanguage (BrandID,LanguageID,Description) values ({0},{1},'{2}')", brandModel.BrandId, language.LanguageId, language.Description.Replace("'", "''"));
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool IsBrandLinkedToItem(int brandId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select * From Item WHERE BrandID = {0} ", brandId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors DeleteBrand(int brandId, string hostingEnv)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<int> dBHelper = null;
            string queryString = string.Empty;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                queryString = string.Format("Delete from BrandOrganizations where BrandID = {0} and OrganizationId in ({1})", brandId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                //queryString = string.Format("Delete from BrandLanguage  where BrandID= {0} ", brandId);
                //result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                //{
                //    queryString = string.Format("Delete from BrandImage  where BrandID= {0} ", brandId);
                //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                //}
                //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                //{
                //    queryString = string.Format("Delete from Brand  where BrandID= {0} ", brandId);
                //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                //}
                if (result == GlobalErrors.Success)
                {
                    result = DeleteBrandCustomerApp(brandId);
                    if (result != GlobalErrors.Success) return result;
                    result = DeletePackCustomerAppByItemBrandId(brandId);
                    if (result != GlobalErrors.Success) return result;
                }
                if (result == GlobalErrors.Success)
                {
                    string folderName = "Resources\\brands-img";
                    string newPath = Path.Combine(hostingEnv, folderName);
                    string fileName = brandId + ".png";
                    string fullPath = Path.Combine(newPath, fileName);
                    // Delete the file if it exists.
                    if (System.IO.File.Exists(fullPath))
                    {
                        System.IO.File.Delete(fullPath);
                    }
                    // Delete the file if it exists.
                    //string path = string.Format(@"{0}", LocalUtilities.CustomerAppServicePath);
                    //folderName = "wwwroot\\img\\Echo\\brand";
                    //newPath = Path.Combine(path, folderName);
                    //fullPath = Path.Combine(newPath, fileName);
                    //// Delete the file if it exists.
                    //if (System.IO.File.Exists(fullPath))
                    //{
                    //    System.IO.File.Delete(fullPath);
                    //}
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }

        public GlobalErrors CheckIfItemSerialsAvailable(ref bool isExist, ref bool isAnyPackHasTrimRule)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                object field = 0;
                isExist = false;
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"select Count(*) from Item 
                where Inactive <> 1 and HasSerialNumber = 1");

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isExist = true;
                }
                query = string.Format(@"select Count(*) from PackSerialTrimRule 
               ");

                result = dBHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isAnyPackHasTrimRule = true;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCompetitorsList(ref List<CompetitorModel> competitorsList)
        {
            DBHelper<CompetitorModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<CompetitorModel>();
                string query = string.Format(@"select Competitor.CompetitorID, CompetitorLanguage.Description CompetitorName from Competitor 
                    left join CompetitorLanguage on CompetitorLanguage.CompetitorID = Competitor.CompetitorID and CompetitorLanguage.LanguageID = {0}
                    where Competitor.OrganizationID in ({1})",
                _requestRepository.LanguageId, // 0
                _requestRepository.CurrentOperator.OrganizationAccess // 1
                );
                result = dBHelper.GetQueryList(query, ref competitorsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                competitorsList = null;
            }
            return result;
        }
        public GlobalErrors GetAvailableCompetitorItemList(int itemId, ref List<CompetitorModel> competitorItemList)
        {
            //Get competitor items fo multiselect dropdown
            DBHelper<CompetitorModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<CompetitorModel>();
                string query = string.Format(@"SELECT t.ItemID CompetitorItemID, t.ItemCode, c.CompetitorID ,CompetitorLanguage.Description CompetitorName, 
                            IsNull( CompetitorLanguage.Description  , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as CompetitorItemName
                            FROM item t
                            LEFT JOIN CompetitorItem c
                            ON t.itemid = c.CompetitorItemID
                            left join ItemLanguage on ItemLanguage.ItemID = t.ItemID and ItemLanguage.LanguageID = {0}
                            left join CompetitorLanguage on CompetitorLanguage.CompetitorID = c.CompetitorID and CompetitorLanguage.LanguageID =  {0}
                            WHERE (c.ItemID = -1  or c.ItemID = {2}) and t.itemtype = {3}",
                            _requestRepository.LanguageId, // 0
                            _requestRepository.CurrentOperator.OrganizationAccess, // 1
                            itemId, //2
                            ItemTypes.CompetitorItem.GetHashCode() //3
                            );
                result = dBHelper.GetQueryList(query, ref competitorItemList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                competitorItemList = null;
            }
            return result;
        }
        public int GetItemTypeId(int itemId)
        {
            var result = GlobalErrors.NotInitialized;
            int itemTypeId = -1;
            try
            {
                Object field = null;
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = string.Format(@"select item.ItemType from item where itemid = {0}", itemId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    itemTypeId = (int)field;
                }
                return itemTypeId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemTypeId;
            }
        }
        public GlobalErrors GetItemsPackQuantities(ref List<ItemPackModel> allItems)
        {
            DBHelper<ItemPackModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                string query = string.Format(@"Select 
                Item.ItemID,
                Case WHEN DefaultPack.PackID IS NULL THEN LargestPack.PackID ELSE DefaultPack.PackID END TargetPackID,
                Case WHEN DefaultPack.PackID IS NULL THEN LargestPack.Quantity ELSE DefaultPack.Quantity END TargetPackQty,
                MinPack.PackID MinPackID, MinPack.Quantity MinPackQty, ItemCategory.DivisionID

                From Item
                inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID
                inner join Division on Division.DivisionID = ItemCategory.DivisionID

                LEFT OUTER JOIN(
                Select pack.Quantity, pack.PackID, Pack.ItemID
                from pack
                ) DefaultPack on DefaultPack.ItemID = Item.ItemID and DefaultPack.PackID = Item.DefaultPackID

                LEFT OUTER JOIN (
                Select Pack.ItemID, MAX(Quantity) Quantity 
                From Pack 
                Group By ItemID
                ) LargetQty ON LargetQty.ItemID = Item.ItemID

                LEFT OUTER JOIN (
                Select Pack.ItemID, Pack.PackID, Pack.Quantity 
                From Pack
                )  LargestPack ON LargestPack.ItemID = Item.ItemID AND LargestPack.Quantity = LargetQty.Quantity

                INNER JOIN (
                Select Pack.ItemID, Pack.PackID, Pack.Quantity 
                From Pack 
                Where Pack.Quantity = 1
                )  MinPack ON MinPack.ItemID = Item.ItemID 

                Where (item.Inactive is null or item.Inactive = 0) And (Division.OrganizationID IN ({1}) AND Division.DivisionID IN ({2))",
               _requestRepository.CurrentOperator.EmployeeId, //0
               _requestRepository.CurrentOperator.OrganizationAccess, //1
               _requestRepository.CurrentOperator.DivisionAccess //2
               );

                result = dBHelper.GetQueryList(query, ref allItems);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region [ECHO]

        public GlobalErrors GetEchoDivisions(ref List<DivisionModel> divisionList)
        {
            divisionList = new List<DivisionModel>();
            DBHelper<DivisionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<DivisionModel>();
                string query = string.Format(@"SELECT DISTINCT Division.DivisionID DivisionId, DivisionLanguage.Description, Division.DivisionCode,
                    IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName
                    FROM Division
                    INNER JOIN ItemCategoryCustomerApp ON ItemCategoryCustomerApp.DivisionID = Division.DivisionID
                    LEFT JOIN DivisionLanguage ON DivisionLanguage.DivisionID = Division.DivisionID AND DivisionLanguage.LanguageID = {1}
                    WHERE Division.DivisionID IN ({0})
                    ORDER BY DivisionLanguage.Description", _requestRepository.CurrentEchoOperator.DivisionIds, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref divisionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                divisionList = null;
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetEchoCategories(int divisionId, ref List<CategoryModel> data)
        {
            DBHelper<CategoryModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<CategoryModel>();
                string filter = string.Empty;
                if (divisionId > 0)
                {
                    filter = " ic.DivisionId = " + divisionId;
                }
                else
                {
                    filter = string.Format(" ic.DivisionId IN({0}) ", _requestRepository.CurrentEchoOperator.DivisionIds);
                }
                List<ItemPackModel> itemList = new List<ItemPackModel>();
                List<string> itemsQuery = new List<string>();
                result = GetEchoItems(new EchoGeneralFilter(), string.Empty, ref itemList, true, ref itemsQuery, false);
                if (result == GlobalErrors.Success && itemsQuery.Count == 2)
                {
                    string query = string.Format(@"
                            {0}
                            SELECT Distinct ic.ItemCategoryId , ic.ItemCategoryCode , ic.DivisionId , icl.Description ItemCategoryName FROM ItemCategory ic
                            LEFT JOIN ItemCategoryLanguage icl on ICL.ItemCategoryId = ic.ItemCategoryId AND icl.LanguageId = {1} 
                            INNER JOIN ItemCategoryCustomerApp ON ItemCategoryCustomerApp.ItemCategoryId = ic.ItemCategoryId
                            WHERE {2} AND ic.ItemCategoryId IN (SELECT Distinct ItemCategory.ItemCategoryId {3}) 
                            Order by icl.Description ",
                             itemsQuery[0], //0
                            _requestRepository.LanguageId, //1
                            filter, //2
                            itemsQuery[1] //3
                            );
                    result = dBHelper.GetQueryList(query, ref data);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetEchoBrands(ref List<GeneralModel> data)
        {
            DBHelper<GeneralModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<GeneralModel>();
                List<ItemPackModel> itemList = new List<ItemPackModel>();
                List<string> itemsQuery = new List<string>();
                result = GetEchoItems(new EchoGeneralFilter(), string.Empty, ref itemList, true, ref itemsQuery, false);
                if (result == GlobalErrors.Success && itemsQuery.Count == 2)
                {

                    string query = string.Format(@"
                        {0}
                        SELECT b.BrandID Id, ISNULL(bl.Description, '---') Name FROM Brand b 
                        LEFT JOIN BrandLanguage bl ON bl.BrandID = b.BrandID AND bl.LanguageID = {1} 
                        INNER JOIN BrandCustomerApp ON BrandCustomerApp.BrandId = b.BrandID
                        WHERE b.BrandID IN (SELECT DISTINCT Item.BrandId {2})
                        ORDER BY bl.Description ",
                        itemsQuery[0], //0
                        _requestRepository.LanguageId, //1
                        itemsQuery[1] //2
                        );
                    result = dBHelper.GetQueryList(query, ref data);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                data = null;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetEchoItems(EchoGeneralFilter filter, string orderId, ref List<ItemPackModel> itemList, bool fromFlutter)
        {
            List<string> query = new List<string>();
            return GetEchoItems(filter, orderId, ref itemList, false, ref query, fromFlutter);
        }
        public GlobalErrors GetEchoItems(EchoGeneralFilter filter, string orderId, ref List<ItemPackModel> itemList, bool returnQuery, ref List<string> itemQuery, bool fromFlutter)
        {
            itemList = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string itemsListSelection = string.Empty;
                string itemsListJoin = string.Empty;
                string itemsListWhere = string.Empty;
                string itemCustomerApp = string.Empty;
                string itemsInFlutterCustomerApp = string.Empty;
                string CategoryBrandJoin = " INNER ";
                string CustomerAppMostSellingSequenceSelction = ", 0 as CustomerAppMostSellingSequence ";
                string IsCustomerAppMostSellingSelction = ", 0 as IsCustomerAppMostSelling ";
                string InnerWithFlutterItems = string.Empty;
                string ImagePath = string.Empty;

                #region [Check Items List Assignment]
                if (fromFlutter)
                {
                    itemsListSelection = string.Format(@"Declare @ItemsListDummy table (ItemListID int, ItemID int)
                    Insert into @ItemsListDummy
                    SELECT DISTINCT ItemsListAssignment.ItemListID, ItemsListDetails.ItemID FROM (
                    ----Sub channel level
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerGroup CG ON CG.ChannelID = ItemsListAssignment.ChannelID AND CG.SubChannelID = ItemsListAssignment.SubChannelID
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND concat(COG.CustomerID, '-', COG.OutletID) in ({0})
                    WHERE ItemsListAssignment.SubChannelID IS NOT NULL AND ItemsListAssignment.ChannelID IS NOT NULL
                    UNION
                    --Group level
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment
                    INNER JOIN CustomerOutletGroup COG ON COG.GroupID = ItemsListAssignment.CustomerGroupID AND concat(COG.CustomerID, '-', COG.OutletID) in ({0})
                    WHERE ItemsListAssignment.CustomerGroupID IS NOT NULL
                    UNION
                    --Customer level
                    SELECT distinct ItemsListAssignment.ItemListID 
                    FROM ItemsListAssignment
                    WHERE ItemsListAssignment.CustomerID IS NOT NULL AND ItemsListAssignment.OutletID IS NOT NULL AND concat(CustomerID, '-', OutletID) in ({0})
                    UNION
                    --All customers
                    SELECT distinct ItemsListAssignment.ItemListID
                    FROM ItemsListAssignment 
                    WHERE ItemsListAssignment.AllCustomers = 1
                    ) T 
                    INNER JOIN ItemsList IL ON IL.ItemListID = T.ItemListID
                    INNER JOIN ItemsListAssignment on ItemsListAssignment.ItemListID = IL.ItemListID
                    INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = IL.ItemListID ", _requestRepository.CurrentEchoOperator.CustomerOutletIds);
                    itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1 ";
                    itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) ) ";
                }
                #endregion [Check Items List Assignment]

                dbHelper = new DBHelper<ItemPackModel>();

                #region [Price]

                string priceSelction = string.Empty;
                string priceQuery = string.Empty;
                string priceTableQuery = string.Empty;
                string zeroPriceFilter = string.Empty;
                string retailSelection = string.Empty;
                string retailQuery = string.Empty;
                string retailJoin = string.Empty;

                #region [Tax]

                string taxSelection = " 0 As Tax, 0 AS BaseTax ";
                if (_requestRepository.CurrentEchoOperator.Taxable)
                {
                    taxSelection = " ISNULL(prices.tax, 0) As Tax, ISNULL(prices.tax, 0) As BaseTax ";
                }

                #endregion [Tax]

                #region [Retail Tax]

                //if (_requestRepository.CurrentEchoOperator.Taxable && _requestRepository.Configurations.AllowRetailTaxOnItems)
                //{
                //    retailSelection = " ,ISNULL(retailPrices.price,0) as RetailPrice,ISNULL(retailPrices.tax,0) as RetailTax,(ISNULL(retailPrices.price,0)* ISNULL(retailPrices.tax,0))/100 as RetailValue ";
                //    retailJoin = " left outer join @Retail as retailPrices on retailPrices.packid=pack.PackID ";
                //    retailQuery = string.Format(@"    declare @Retail table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int)
                //                insert into @Retail
                //                SELECT distinct packID , isnull(retailPrices.Price,0) price, isnull(retailPrices.Tax,0)tax, 
                //                retailPrices.PriceListID                     
                //                FROM (                      
                //                select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                //                 PriceDefinition.CurrencyID              
                //                from PriceDefinition                      
                //                inner join(                      

                //                select PriceListID from PriceDefinition                      
                //                Where PriceDefinition.PriceListID in ({0}) ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                //                inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={1}  AND (PriceList.StartDate <=  {2} )AND (PriceList.EndDate >=   {3} )
                //                ) as retailPrices 
                //                WHERE  (retailPrices.PriceListID is not null)", _requestRepository.Configurations.DefaultRetailPriceListID, PriceListTypes.Retail.GetHashCode(), LocalUtilities.ParseDateToSQLString(DateTime.Now), LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                //}
                //else
                //{
                //    retailSelection = " ,0 as RetailPrice,0 as RetailTax ,0 as RetailValue";
                //}

                #endregion [Retail Tax]

                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";
                priceSelction = string.Format(" ,ISNULL(prices.price, 0) Price, ISNULL(prices.price, 0) BasePrice,((ISNULL(prices.price, 0) * 1) + (ISNULL(prices.price, 0) * ISNULL(prices.tax, 0) / 100)) as ExclusivePrice, ISNULL(prices.PriceListID, -1) UsedPriceListID, {0} ", taxSelection);
                priceTableQuery = string.Format(@"declare @x table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
                                    insert into @x
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
                                    prices.PriceListID, prices.priority, prices.rowNumber                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where concat(CustomerID, '-', OutletID) in ({0})                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE concat(CustomerID, '-', OutletID) in ({0}) )                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE concat(CustomerID, '-', OutletID) in ({0})))                      
                                    union                      
                                    select PriceListID, 5 as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({1})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={3}  {2}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    ", _requestRepository.CurrentEchoOperator.CustomerOutletIds, //0
                                _requestRepository.Configurations.DefaultPriceListID.ToString(), //1
                                priceDateFilter, //2
                                PriceListTypes.General.GetHashCode() //3
                                );
                priceQuery = string.Format(@" LEFT OUTER JOIN @x as prices ON prices.PackID = Pack.PackID ");

                #endregion [Price]

                #region [Stock]

                string stockQuery = string.Empty;
                string stockLimitConditionInMainQuery = string.Empty;
                if (_requestRepository.Configurations.LimitItemsToMainWarehouseStock.Contains(LimitItemsToWarehouseTypes.Order.GetHashCode().ToString()))
                {
                    stockLimitConditionInMainQuery = " And (ItemStock.ItemID Is not Null)";
                    stockQuery = string.Format(@" LEFT OUTER join(
                    Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs 
                    From pack
                    inner join WarehouseStock on WarehouseStock.PackID = pack.PackID and WarehouseStock.WarehouseID IN ({0})
                    group by pack.ItemID Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0) ItemStock on ItemStock.ItemID = Item.ItemID",
                     String.IsNullOrEmpty(_requestRepository.CurrentEchoOperator.RouteLoadingWarehouseIds)? 1+"" : _requestRepository.CurrentEchoOperator.RouteLoadingWarehouseIds);
                }

                #endregion [Stock]

                #region FlutterCustomerApp
                if (fromFlutter)
                {
                    itemsInFlutterCustomerApp = string.Format(@"
                    Declare @y table (ItemID int)
                    Insert into @y
                    SELECT ItemID from (
	
	                    SELECT Item.ItemID
	                    FROM Item 
	                    INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID 
	                    INNER JOIN ItemCategoryCustomerApp ON ItemCategory.ItemCategoryID = ItemCategoryCustomerApp.ItemCategoryID
	
	                    UNION 
	                    SELECT Item.ItemID
	                    FROM Item 
	                    INNER JOIN Brand ON Brand.BrandID = Item.BrandID 
	                    INNER JOIN BrandCustomerApp ON Brand.BrandID = BrandCustomerApp.BrandId
	
	                    UNION 
	                    SELECT ItemsMostSellingCustomerApp.ItemID
	                    FROM ItemsMostSellingCustomerApp 

	                    UNION 
	                    SELECT Item.ItemID
	                    FROM Item
	                    WHERE Item.IsNew = 1 OR Item.IsPowerSKU = 1 OR Item.IsInitiative = 1 

	                    UNION
	                    SELECT ItemGroupDetail.ItemID
	                    FROM  ItemGroupDetail
	                    INNER JOIN ItemGroup ON ItemGroup.ItemGroupID = ItemGroupDetail.ItemGroupID
	                    INNER JOIN MasterItemGroup ON MasterItemGroup.MasterItemGroupID = ItemGroup.MasterItemGroupID 
	                    AND MasterItemGroup.ShowInCustomerApp = 1

                    ) tt
                   ");
                    CategoryBrandJoin = " Left ";
                    CustomerAppMostSellingSequenceSelction = " ,ISNULL(ItemsMostSellingCustomerApp.Sequence, 0) CustomerAppMostSellingSequence";
                    IsCustomerAppMostSellingSelction = " ,CASE WHEN ItemsMostSellingCustomerApp.itemId is null THEN 0 ELSE 1 END IsCustomerAppMostSelling ";
                    InnerWithFlutterItems = " INNER Join @y ItemList on ItemList.ItemID = Item.ItemID ";
                }
                #endregion


                #region [Items Main Select]


                string echoFilters = string.Empty;
                string echoSelection = string.Empty;


                if (filter.ItemCategoryId > 0)
                {
                    echoFilters += " AND Item.ItemCategoryID = " + filter.ItemCategoryId;
                }
                if (filter.BrandId > 0)
                {
                    echoFilters += " AND Item.BrandID = " + filter.BrandId;
                }
                if (filter.DivisionId > 0)
                {
                    echoFilters += " AND ItemCategory.DivisionID = " + filter.DivisionId;
                }
                if (filter.PackId > 0)
                {
                    echoFilters += " AND pack.packId = " + filter.PackId;
                }
                if (filter.IsDivisionLevel)
                {
                    echoSelection = " , ItemCategory.DivisionID ";
                }
            

                string orderJoin = string.Empty;
                string orderQtySelection = string.Empty;
                if (!string.IsNullOrEmpty(orderId))
                {
                    orderJoin = string.Format(@" INNER JOIN SalesOrderDetail sod ON sod.OrderID = '{0}' AND concat(sod.CustomerID, '-', sod.OutletID) in ({1}) 
                                AND sod.PackID = Pack.PackID AND sod.SalesTransactionTypeID = 1 ",
                                orderId, _requestRepository.CurrentEchoOperator.CustomerOutletIds);
                    orderQtySelection = " , sod.Quantity RequiredQty ";
                    zeroPriceFilter = string.Empty;
                }
                else
                {
                    //// no commit/////
                    zeroPriceFilter = " And (Prices.PackID Is not Null and Prices.Price > 0) ";
                }
                if (!string.IsNullOrEmpty(filter.SearchText))
                {
                    string[] filterList = filter.SearchText.TrimEnd(' ').Split(' ');
                    if (filterList.Length > 0)
                    {
                        string itemSearch = " 1=1 ";
                        //string codeSearch = " 1=1 ";
                        //string uomSearch = " 1=1 ";
                        //string barcodeSearch = " 1=1 ";
                        foreach (string word in filterList)
                        {
                            itemSearch += string.Format(" and ItemLanguage.Description like '%{0}%' ", word);
                            //codeSearch += string.Format(" and Item.ItemCode like '%{0}%' ", word);
                            //uomSearch += string.Format(" and PackTypeLanguage.Description like '%{0}%' ", word);
                            //barcodeSearch += string.Format(" and Pack.Barcode like '%{0}%' ", word);
                        }
                        filter.SearchText = string.Format(" AND (({0})) ", itemSearch);
                        //filter.SearchText = string.Format(" AND ( ({0}) OR ({1}) OR ({2}) OR ({3}) ) ", itemSearch, codeSearch, barcodeSearch, uomSearch);
                    }
                }
                else
                {
                    filter.SearchText = string.Empty;
                }
                string mainDivisionFilter = string.Empty;
                if (_requestRepository.Configurations.AllowSameOperatorForMultiCustomer)
                {
                    mainDivisionFilter = " INNER JOIN CustomerAppMainDivision MainDivision ON MainDivision.DivisionID = ItemCategory.DivisionID ";
                }
                else
                {
                    mainDivisionFilter = " LEFT JOIN CustomerAppMainDivision MainDivision ON MainDivision.DivisionID = ItemCategory.DivisionID ";
                }
                if (!fromFlutter)
                {
                    
                    ImagePath = string.Format(", CASE WHEN ItemImage.ItemID IS NULL THEN CONCAT('{0}', 'img/echo/no-image.png') ELSE CONCAT('{0}' ,'img/echo/item/', ItemImage.ItemID, '.png') END imagePath ", filter.EchoApi);
                }
                string advancedFilterText = string.IsNullOrEmpty(filter.AdvancedFilterText) ? "" : filter.AdvancedFilterText;
                if (returnQuery)
                {
                    result = GlobalErrors.Success;
                    itemQuery = new List<string>();
                    itemQuery.Add(string.Format(@"
                    {0} 
                    {1} 
                    {2}", priceTableQuery, itemsListSelection, retailQuery));
                    itemQuery.Add(string.Format(@"
                    FROM Item
                    LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                    INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID
                    INNER JOIN Division on Division.DivisionID = ItemCategory.DivisionID AND Division.OrganizationID = {10}
                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                    INNER JOIN ItemCategoryCustomerApp ON ItemCategoryCustomerApp.ItemCategoryId = ItemCategory.ItemCategoryId
                    INNER JOIN BrandCustomerApp ON BrandCustomerApp.BrandId = Item.BrandId 
                    {9}
                    LEFT JOIN ItemImage ON ItemImage.ItemID = Item.ItemID
                    {1}
                    {2}
                    {3}
                    {4}
                    WHERE (Item.Inactive = 0 OR Item.Inactive IS NULL) AND (Item.ItemType NOT IN (7,9)) AND ItemCategory.DivisionID IN ({8})
                    {5} {6} {7}",
                    _requestRepository.LanguageId, //0
                    priceQuery, //1
                    retailJoin, //2
                    stockQuery, //3
                    itemsListJoin, //4
                    stockLimitConditionInMainQuery, //5
                    zeroPriceFilter,//6
                    itemsListWhere, //7
                    _requestRepository.CurrentEchoOperator.DivisionIds, //8
                    mainDivisionFilter, //9
                    filter.OrganizationId//10
                    ));
                }
                else
                {
                    string query = string.Format(@"select Count(*) from PackCustomerApp");
                    DBHelper<int> dBHelper = new DBHelper<int>();

                    object count = null;
                    result = dBHelper.ExecuteScalar(query, ref count);
                    if (result == GlobalErrors.Success)
                    {
                        if ((int)count > 0)
                        {
                            itemCustomerApp = " inner join PackCustomerApp on PackCustomerApp.PackID = Pack.PackID ";
                        }
                    }

                    query = string.Format(@"{0} 
                    {1} 
                    {2}
                    {24}
                    SELECT Distinct Item.ItemID ItemId, Item.ItemCategoryID ItemCategoryId, Pack.PackTypeID PackTypeId, Pack.PackID PackId,
                    PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, Pack.Quantity as PiecesInPack,
                    Item.IsInitiative, Item.IsNew, Item.IsPowerSKU, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END HasImage,
                    MainDivision.MainDivisionID, EmployeeDivision.EmployeeID, Item.BrandId,ISNULL(ItemCategoryLanguage.Description, '---') Category, 
                    ISNULL(BrandLanguage.Description, '---') Brand, CASE when ItemCategoryCustomerApp.ItemCategoryID is null then 0 else 1 end ItemCategoryInCustomerApp , CASE when BrandCustomerApp.BrandId is null then 0 else 1 end BrandInCustomerApp
                    , IsNull( Item.ItemCode , '--') + ' ' + ' | '+ ' ' + IsNull( ItemLanguage.Description , '--') + ' ' + ' | '+ ' ' + IsNull( item.PackDefinition , '--') ItemDefinition {28}
                    {3} {4} {15} {22} {23} {26}
                    ,CASE WHEN bestSellers.ItemId IS NULL THEN 0 ELSE 1 END IsBestSeller, ISNULL(bestSellers.Sequence,0) BestSellerSeq
                    ,isnull(EchoCustRate.RateValue,0) RateValue ,(select Sum(RateValue)/count(RateValue) from EchoCustRate where packid = Pack.PackID) TotalRateValue 
                    FROM Item
                    {25}
                    LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {5}
                    INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                    {20}
                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID
                    INNER JOIN Division on Division.DivisionID = ItemCategory.DivisionID AND Division.OrganizationID = {30}
                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {5}
                    {21} JOIN ItemCategoryCustomerApp ON ItemCategoryCustomerApp.ItemCategoryId = ItemCategory.ItemCategoryId
                    {21} JOIN BrandCustomerApp ON BrandCustomerApp.BrandId = Item.BrandId 
                    Left JOIN BrandLanguage on Item.BrandID = BrandLanguage.BrandID and BrandLanguage.LanguageID = {5} 
                    Left JOIN ItemCategoryLanguage on Item.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID and ItemCategoryLanguage.LanguageID = {5} 
                    LEFT JOIN ItemImage ON ItemImage.ItemID = Item.ItemID
                    LEFT JOIN ItemsMostSellingCustomerApp on  ItemsMostSellingCustomerApp.Itemid = Item.ItemId  
					{19}
                    LEFT OUTER JOIN EmployeeDivision on EmployeeDivision.DivisionID = MainDivision.DivisionID and EmployeeDivision.EmployeeID in ({17})
                    Left join EchoCustRate on EchoCustRate.PackID = Pack.PackID and CustomerID = {29}
                       Left join ItemGroupDetail on ItemGroupDetail.ItemID = Item.ItemID
					 LEFT JOIN ItemsMostSellingCustomerApp bestSellers ON bestSellers.ItemId = Item.ItemID

                    {6}
                    {7}
                    {8}
                    {9}
                    {14}
                    WHERE (Item.Inactive = 0 OR Item.Inactive IS NULL) AND (Item.ItemType NOT IN (7,9)) AND ItemCategory.DivisionID IN ({18})
                    {10} {11} {12} {13} {16} {27} 
                    ORDER BY Item.ItemCode, ItemLanguage.Description, PackTypeLanguage.Description",
                   //--OFFSET {15} ROWS
                   // --FETCH NEXT {16} ROWS ONLY
                   priceTableQuery, //0
                   itemsListSelection, //1
                   retailQuery, //2
                   priceSelction, //3
                   retailSelection, //4
                   _requestRepository.LanguageId, //5
                   priceQuery, //6
                   retailJoin, //7
                   stockQuery, //8
                   itemsListJoin, //9
                   stockLimitConditionInMainQuery, //10
                   zeroPriceFilter,//11
                   itemsListWhere, //12
                   echoFilters, //13
                   orderJoin, //14
                   orderQtySelection, //15
                   filter.SearchText, //16
                   _requestRepository.CurrentEchoOperator.RouteEmployeeIds, //17
                   _requestRepository.CurrentEchoOperator.DivisionIds, //18
                   mainDivisionFilter, //19
                   itemCustomerApp,//20 
                   CategoryBrandJoin, //21
                   CustomerAppMostSellingSequenceSelction, //22
                   IsCustomerAppMostSellingSelction, //23
                   itemsInFlutterCustomerApp, //24
                   InnerWithFlutterItems, //25
                   ImagePath, //26
                   advancedFilterText, //27
                   echoSelection, //28
                   _requestRepository.CurrentEchoOperator.CustomerId, //29
                   filter.OrganizationId //30
                   );
                    result = dbHelper.GetQueryList(query, ref itemList);
                }

                #endregion [Items Main Select]



            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
     //   public GlobalErrors GetEchoItemsNew(ref List<ItemPackModel> itemList)
     //   {
     //       itemList = new List<ItemPackModel>();
     //       DBHelper<ItemPackModel> dbHelper = null;
     //       GlobalErrors result = GlobalErrors.NotInitialized;
     //       try
     //       {
     //           string itemsListSelection = string.Empty;
     //           string itemsListJoin = string.Empty;
     //           string itemsListWhere = string.Empty;
     //           string itemCustomerApp = string.Empty;
     //           string itemsInCustomerApp = string.Empty;

     //           #region [Check Items List Assignment]

     //           itemsListSelection = string.Format(@"Declare @ItemsListDummy table (ItemListID int, ItemID int)
     //               Insert into @ItemsListDummy
     //               SELECT DISTINCT ItemsListAssignment.ItemListID, ItemsListDetails.ItemID FROM (
     //               ----Sub channel level
     //               SELECT distinct ItemsListAssignment.ItemListID
     //               FROM ItemsListAssignment
     //               INNER JOIN CustomerGroup CG ON CG.ChannelID = ItemsListAssignment.ChannelID AND CG.SubChannelID = ItemsListAssignment.SubChannelID
     //               INNER JOIN CustomerOutletGroup COG ON COG.GroupID = CG.GroupID AND concat(COG.CustomerID, '-', COG.OutletID) in ({0})
     //               WHERE ItemsListAssignment.SubChannelID IS NOT NULL AND ItemsListAssignment.ChannelID IS NOT NULL
     //               UNION
     //               --Group level
     //               SELECT distinct ItemsListAssignment.ItemListID
     //               FROM ItemsListAssignment
     //               INNER JOIN CustomerOutletGroup COG ON COG.GroupID = ItemsListAssignment.CustomerGroupID AND concat(COG.CustomerID, '-', COG.OutletID) in ({0})
     //               WHERE ItemsListAssignment.CustomerGroupID IS NOT NULL
     //               UNION
     //               --Customer level
     //               SELECT distinct ItemsListAssignment.ItemListID 
     //               FROM ItemsListAssignment
     //               WHERE ItemsListAssignment.CustomerID IS NOT NULL AND ItemsListAssignment.OutletID IS NOT NULL AND concat(CustomerID, '-', OutletID) in ({0})
     //               UNION
     //               --All customers
     //               SELECT distinct ItemsListAssignment.ItemListID
     //               FROM ItemsListAssignment 
     //               WHERE ItemsListAssignment.AllCustomers = 1
     //               ) T 
     //               INNER JOIN ItemsList IL ON IL.ItemListID = T.ItemListID
     //               INNER JOIN ItemsListAssignment on ItemsListAssignment.ItemListID = IL.ItemListID
     //               INNER JOIN ItemsListDetails ON ItemsListDetails.ItemListID = IL.ItemListID ", _requestRepository.CurrentEchoOperator.CustomerOutletIds);
     //           itemsListJoin = " LEFT OUTER JOIN @ItemsListDummy ILD on 1=1 ";
     //           itemsListWhere = " And( (ILD.ItemListID is null) OR (ILD.ItemListID is not null and ILD.ItemID = Item.ItemID) ) ";

     //           #endregion [Check Items List Assignment]

     //           dbHelper = new DBHelper<ItemPackModel>();

     //           #region [Price]

     //           string priceSelction = string.Empty;
     //           string priceQuery = string.Empty;
     //           string priceTableQuery = string.Empty;
     //           string zeroPriceFilter = string.Empty;
     //           string retailSelection = string.Empty;
     //           string retailQuery = string.Empty;
     //           string retailJoin = string.Empty;

     //           #region [Tax]

     //           string taxSelection = " 0 As Tax, 0 AS BaseTax ";
     //           if (_requestRepository.CurrentEchoOperator.Taxable)
     //           {
     //               taxSelection = " ISNULL(prices.tax, 0) As Tax, ISNULL(prices.tax, 0) As BaseTax ";
     //           }

     //           #endregion [Retail Tax]

     //           string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseEndDateToSQLString(DateTime.Now) + ")";
     //           priceSelction = string.Format(" ,ISNULL(prices.price, 0) Price, ISNULL(prices.price, 0) BasePrice,((ISNULL(prices.price, 0) * 1) + (ISNULL(prices.price, 0) * ISNULL(prices.tax, 0) / 100)) as ExclusivePrice, ISNULL(prices.PriceListID, -1) UsedPriceListID, {0} ", taxSelection);
     //           priceTableQuery = string.Format(@"declare @x table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
     //                               insert into @x
     //                               SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
     //                               prices.PriceListID, prices.priority, prices.rowNumber                     
     //                               FROM (                      
     //                               select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
     //                               tt.priority, PriceDefinition.CurrencyID                      , 
     //                               row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
     //                               PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
     //                               from PriceDefinition                      
     //                               inner join(                      
     //                               select PriceListID, 1 as priority from CustomerPrice                     
     //                               where concat(CustomerID, '-', OutletID) in ({0})                      
     //                               union                      
     //                               select PriceListID, 2 as priority from GroupPrice                     
     //                               where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE concat(CustomerID, '-', OutletID) in ({0}) )                      
     //                               union                      
     //                               select PriceListID, 3 as priority from ChannelPrice                      
     //                               where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
     //                               (SELECT GroupID FROM CustomerOutletGroup WHERE concat(CustomerID, '-', OutletID) in ({0})))                      
     //                               union                      
     //                               select PriceListID, 4 as priority from ChannelPrice                     
     //                               where  ChannelID in 
     //                               (SELECT ChannelID FROM CustomerGroup Where GroupID in (SELECT GroupID FROM CustomerOutletGroup 
     //                               WHERE concat(CustomerID, '-', OutletID) in ({0}) ))                     
     //                               union                      
     //                               select PriceListID, 5 as priority from PriceDefinition                      
     //                               Where PriceDefinition.PriceListID in ({1})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
     //                               inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={3}  {2}
     //                               inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
     //                               and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
     //                               WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
     //                               and (Prices.PriceListID is not null)
     //                               ", _requestRepository.CurrentEchoOperator.CustomerOutletIds, //0
     //                           _requestRepository.Configurations.DefaultPriceListID.ToString(), //1
     //                           priceDateFilter, //2
     //                           PriceListTypes.General.GetHashCode() //3
     //                           );
     //           priceQuery = string.Format(@" LEFT OUTER JOIN @x as prices ON prices.PackID = Pack.PackID ");

     //           #endregion [Price]

     //           #region [Stock]

     //           string stockQuery = string.Empty;
     //           string stockLimitConditionInMainQuery = string.Empty;
     //           if (_requestRepository.Configurations.LimitItemsToMainWarehouseStock)
     //           {
     //               stockLimitConditionInMainQuery = " And (ItemStock.ItemID Is not Null)";
     //               stockQuery = string.Format(@" LEFT OUTER join(
     //               Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs 
     //               From pack
     //               inner join WarehouseStock on WarehouseStock.PackID = pack.PackID and WarehouseStock.WarehouseID IN ({0})
     //               group by pack.ItemID Having Sum(pack.Quantity * WarehouseStock.Quantity) > 0) ItemStock on ItemStock.ItemID = Item.ItemID",
     //                _requestRepository.CurrentEchoOperator.RouteLoadingWarehouseIds);
     //           }

     //           #endregion [Stock]

     //           #region ItemsInCustomerApp
     //           itemsInCustomerApp = string.Format(@"
     //               Declare @y table (ItemID int)
     //               Insert into @y
     //               SELECT ItemID from (
	
	    //                SELECT Item.ItemID
	    //                FROM Item 
	    //                INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID 
	    //                INNER JOIN ItemCategoryCustomerApp ON ItemCategory.ItemCategoryID = ItemCategoryCustomerApp.ItemCategoryID
	
	    //                UNION 
	    //                SELECT Item.ItemID
	    //                FROM Item 
	    //                INNER JOIN Brand ON Brand.BrandID = Item.BrandID 
	    //                INNER JOIN BrandCustomerApp ON Brand.BrandID = BrandCustomerApp.BrandId
	
	    //                UNION 
	    //                SELECT ItemsMostSellingCustomerApp.ItemID
	    //                FROM ItemsMostSellingCustomerApp 

	    //                UNION 
	    //                SELECT Item.ItemID
	    //                FROM Item
	    //                WHERE Item.IsNew = 1 OR Item.IsPowerSKU = 1 OR Item.IsInitiative = 1 

	    //                UNION
	    //                SELECT ItemGroupDetail.ItemID
	    //                FROM  ItemGroupDetail
	    //                INNER JOIN ItemGroup ON ItemGroup.ItemGroupID = ItemGroupDetail.ItemGroupID
	    //                INNER JOIN MasterItemGroup ON MasterItemGroup.MasterItemGroupID = ItemGroup.MasterItemGroupID 
	    //                AND MasterItemGroup.ShowInCustomerApp = 1

     //               ) tt
     //           ");
     //           #endregion

     //           #region [Items Main Select]

     //           string echoFilters = string.Empty;

     //           string brandCategoryJoin = "";

     //           string orderJoin = string.Empty;
     //           string orderQtySelection = string.Empty;


     //           //// no commit/////
     //           zeroPriceFilter = " And (Prices.PackID Is not Null and Prices.Price > 0) ";


     //           string mainDivisionFilter = string.Empty;
     //           if (_requestRepository.Configurations.AllowSameOperatorForMultiCustomer)
     //           {
     //               mainDivisionFilter = " INNER JOIN CustomerAppMainDivision MainDivision ON MainDivision.DivisionID = ItemCategory.DivisionID ";
     //           }
     //           else
     //           {
     //               mainDivisionFilter = " LEFT JOIN CustomerAppMainDivision MainDivision ON MainDivision.DivisionID = ItemCategory.DivisionID ";
     //           }



     //           string query = string.Format(@"select Count(*) from PackCustomerApp");
     //           DBHelper<int> dBHelper = new DBHelper<int>();

     //           object count = null;
     //           result = dBHelper.ExecuteScalar(query, ref count);
     //           if (result == GlobalErrors.Success)
     //           {
     //               if ((int)count > 0)
     //               {
     //                   itemCustomerApp = " inner join PackCustomerApp on PackCustomerApp.PackID = Pack.PackID ";
     //               }
     //           }

     //           query = string.Format(@"{0} 
     //               {1} 
     //               {2}
     //               {22}
     //               ----Items
     //               SELECT Distinct Item.ItemID ItemId, Item.ItemCategoryID ItemCategoryId, Pack.PackTypeID PackTypeId, Pack.PackID PackId,
     //               PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, Pack.Quantity as PiecesInPack,
     //               Item.IsInitiative, Item.IsNew, Item.IsPowerSKU, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END HasImage,
     //               MainDivision.MainDivisionID, EmployeeDivision.EmployeeID , Item.BrandId, Item.ItemType
     //               {3} {4} {15} , ISNULL(ItemsMostSellingCustomerApp.Sequence, 0) CustomerAppMostSellingSequence, CASE WHEN ItemsMostSellingCustomerApp.itemId is null THEN 0 ELSE 1 END IsCustomerAppMostSelling, ISNULL(ItemCategoryLanguage.Description, '---')  Category, ISNULL(BrandLanguage.Description, '---') Brand ,  
					//CASE when ItemCategoryCustomerApp.ItemCategoryID is null then 0 else 1 end ItemCategoryInCustomerApp , CASE when BrandCustomerApp.BrandId is null then 0 else 1 end BrandInCustomerApp
     //               FROM Item
     //               INNER Join @y ItemList on ItemList.ItemID = Item.ItemID
     //               INNER JOIN Pack ON Pack.ItemID = Item.ItemID
     //               {20}
     //               LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {5}
     //               INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID
     //               Left JOIN ItemCategoryCustomerApp on  ItemCategory.ItemCategoryID = ItemCategoryCustomerApp.ItemCategoryID
     //               Left JOIN BrandCustomerApp on  BrandCustomerApp.BrandId = Item.BrandID
     //               Left JOIN BrandLanguage on Item.BrandID = BrandLanguage.BrandID and BrandLanguage.LanguageID = {5} 
     //               Left JOIN ItemCategoryLanguage on Item.ItemCategoryID = ItemCategoryLanguage.ItemCategoryID and ItemCategoryLanguage.LanguageID = {5} 
     //               LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {5}
     //               LEFT JOIN ItemsMostSellingCustomerApp on  ItemsMostSellingCustomerApp.Itemid = Item.ItemId  
     //               LEFT JOIN ItemImage ON ItemImage.ItemID = Item.ItemID
     //               {19} 
     //               LEFT OUTER JOIN EmployeeDivision on EmployeeDivision.DivisionID = MainDivision.DivisionID and EmployeeDivision.EmployeeID in ({17})
     //               {6}
     //               {7}
     //               {8}
     //               {9}
     //               {14}
                    
     //               WHERE (Item.Inactive = 0 OR Item.Inactive IS NULL) AND (Item.ItemType NOT IN (7,9)) AND ItemCategory.DivisionID IN ({18})
     //               {10} {11} {12} {13} {16}
     //               ORDER BY Item.ItemCode, ItemLanguage.Description, PackTypeLanguage.Description",
     //              //--OFFSET {15} ROWS
     //              // --FETCH NEXT {16} ROWS ONLY
     //              priceTableQuery, //0
     //              itemsListSelection, //1
     //              retailQuery, //2
     //              priceSelction, //3
     //              retailSelection, //4
     //              _requestRepository.LanguageId, //5
     //              priceQuery, //6
     //              retailJoin, //7
     //              stockQuery, //8
     //              itemsListJoin, //9
     //              stockLimitConditionInMainQuery, //10
     //              zeroPriceFilter,//11
     //              itemsListWhere, //12
     //              echoFilters, //13
     //              orderJoin, //14
     //              orderQtySelection, //15
     //              "", //16  
     //              _requestRepository.CurrentEchoOperator.RouteEmployeeIds, //17
     //              _requestRepository.CurrentEchoOperator.DivisionIds, //18
     //              mainDivisionFilter, //19
     //              itemCustomerApp,//20
     //              brandCategoryJoin, //21
     //              itemsInCustomerApp // 22
     //              );
     //           result = dbHelper.GetQueryList(query, ref itemList);

     //           #endregion [Items Main Select]
     //       }
     //       catch (Exception ex)
     //       {
     //           ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
     //           itemList = null;
     //           return GlobalErrors.Error;
     //       }
     //       return result;
     //   }
        
        private static GlobalErrors GetDocumentsImages(int itemId, ref List<ItemImageModel> itemImages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            itemImages = new List<ItemImageModel>();
            DBHelper<ItemImageModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT ItemDocuments.* FROM ItemDocuments where itemid = {0}", itemId);
                dbHelper = new DBHelper<ItemImageModel>();
                result = dbHelper.GetQueryList(query, ref itemImages);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors FillItemDocumentImages(int itemId, string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string folderName = "Resources\\documents";
                string newPath = Path.Combine(rootPath, folderName);
                string pathString = Path.Combine(rootPath, folderName);

                //if (Directory.Exists(pathString))
                //{
                //    Directory.Delete(pathString);
                //}
                if (!Directory.Exists(pathString))
                    Directory.CreateDirectory(pathString);

                List<ItemImageModel> documnets = null;
                //1. Get Item Images from DB
                result = GetDocumentsImages(itemId, ref documnets);
                if (result == GlobalErrors.Success && documnets != null && documnets.Count > 0)
                {
                    MemoryStream _itemImage;
                    //. Fill Item Images
                    documnets.ForEach(i =>
                    {
                        Byte[] byteBLOBData = new Byte[0];
                        using (_itemImage = new MemoryStream(i.Image))
                        {
                            string fileName = Path.Combine(pathString, i.ItemCode + ".png");
                            if (File.Exists(fileName))
                                File.Delete(fileName);
                            Bitmap varBmp = new Bitmap(_itemImage);
                            Bitmap newBitmap = new Bitmap(varBmp);
                            ImageCodecInfo jgpEncoder = GetEncoder(ImageFormat.Jpeg);
                            System.Drawing.Imaging.Encoder myEncoder = System.Drawing.Imaging.Encoder.Quality;
                            EncoderParameters myEncoderParameters = new EncoderParameters(1);
                            EncoderParameter myEncoderParameter = new EncoderParameter(myEncoder, 25L);
                            myEncoderParameters.Param[0] = myEncoderParameter;
                            newBitmap.Save(fileName, jgpEncoder, myEncoderParameters);
                            newBitmap.Dispose();
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public static GlobalErrors GetItemDocuments(int itemId, ref List<string> itemDocuments)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string path = Path.Combine(Directory.GetCurrentDirectory(), string.Format("wwwroot\\img\\Echo\\item-attachements\\{0}", itemId));
                if (Directory.Exists(path))
                {
                    var list = Directory.GetFiles(path);
                    if (list != null && list.Length > 0)
                    {
                        List<string> documents = new List<string>();
                        list.ToList().ForEach(i =>
                        {
                            documents.Add(Path.GetFileName(i));
                        });
                        itemDocuments.AddRange(documents);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetMasterGroupesItems(ref List<ItemPackModel> items, bool isCustomerApp)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            items = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            string isCustomerAppFilter = string.Empty;

            try
            {
                if (isCustomerApp)
                {
                    isCustomerAppFilter = " AND (MIG.ShowInCustomerApp = 1) ";
                }
                string query = string.Format(@"SELECT distinct MIG.MasterItemGroupID, IG.ItemGroupID, IGD.ItemID, ISNULL(MIGL.Description, '---')  AS MasterItemGroup, ISNULL(IGL.Description, '---') AS ItemGroup, IGD.ItemID
                        FROM MasterItemGroup AS MIG INNER JOIN
                        ItemGroup AS IG ON MIG.MasterItemGroupID = IG.MasterItemGroupID INNER JOIN
                        ItemGroupDetail AS IGD ON IG.ItemGroupID = IGD.ItemGroupID INNER JOIN
                        MasterItemGroupLanguage AS MIGL ON MIG.MasterItemGroupID = MIGL.MasterItemGroupID AND MIGL.LanguageID = {0} INNER JOIN
                        ItemGroupLanguage AS IGL ON IGL.ItemGroupID = IG.ItemGroupID AND IGL.LanguageID = {0}
                        WHERE (1 = 1) {1}
                    ", _requestRepository.LanguageId, isCustomerAppFilter);
                dbHelper = new DBHelper<ItemPackModel>();
                result = dbHelper.GetQueryList(query, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetItemGroups(ref List<ItemGroupModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            list = new List<ItemGroupModel>();
            DBHelper<ItemGroupModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT IG.ItemGroupID, IG.MasterItemGroupID, IGL.Description ItemGroupName
                    FROM ItemGroup AS IG INNER JOIN
                    ItemGroupCustomerApp AS IGCA ON IG.ItemGroupID = IGCA.ItemGroupID LEFT OUTER JOIN
                    ItemGroupLanguage AS IGL ON IG.ItemGroupID = IGL.ItemGroupID AND IGL.LanguageID = {0} ORDER BY IG.ItemGroupID", _requestRepository.LanguageId);
                dbHelper = new DBHelper<ItemGroupModel>();
                result = dbHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getMainCustomeHomePageDetails(ref List<EchoCustomeHomePageModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            list = new List<EchoCustomeHomePageModel>();
            DBHelper<EchoCustomeHomePageModel> dbHelper = null;
            try
            {
                string query = string.Format(@"SELECT SectionTypeId, SectionName, Sequence, Enabled FROM EchoCustomeHomePage 
                    WHERE Enabled = 1 ORDER BY Sequence");
                dbHelper = new DBHelper<EchoCustomeHomePageModel>();
                result = dbHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion [ECHO]

        #region [STOREKEEPER APP]
        public static List<DivisionModel> GetDivisionList(string divisionIds, int langId)
        {
            List<DivisionModel> divisions = new List<DivisionModel>();
            try
            {
                DBHelper<DivisionModel> dBHelper = new DBHelper<DivisionModel>();
                string query = string.Format(@"SELECT Division.DivisionID DivisionId, DivisionLanguage.Description, Division.DivisionCode,
                    IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName
                    FROM Division
                    LEFT JOIN DivisionLanguage ON DivisionLanguage.DivisionID = Division.DivisionID AND DivisionLanguage.LanguageID = {1}
                    WHERE Division.DivisionID IN ({0})
                    ORDER BY Division.DivisionCode, DivisionLanguage.Description", divisionIds, langId);
                dBHelper.GetQueryList(query, ref divisions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return divisions;
        }

        #endregion;

     
        public GlobalErrors fillDataInItemExtraInfo()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string insertStatement = string.Format(@"insert into ItemExtraInfo (ItemID,AllowReassign,AllowReturn,AllowCheckUpperLimit)
                                                         select I.ItemID,0 AllowReassign,0 AllowReturn,0 AllowCheckUpperLimit 
                                                         from Item I 
                                                         left join ItemExtraInfo Ex on ex.ItemID = I.ItemID
                                                         where (I.Inactive is null or I.Inactive = 0)  and Ex.ItemID is null");
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(insertStatement);
                if(result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateItemSerialOperations(List<ItemSerialOperations> serialOperations)
        {

            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                if (serialOperations != null && serialOperations.Count > 0)
                {
                    for (int i = 0; i < serialOperations.Count; i++)
                    {
                        string query = string.Format(@"update ItemExtraInfo set AllowReassign = {0} , AllowReturn = {1} , AllowCheckUpperLimit = {2} where ItemID = {3}"
                            , Convert.ToInt32(serialOperations[i].AllowReassign)
                            , Convert.ToInt32(serialOperations[i].AllowReturn)
                            , Convert.ToInt32(serialOperations[i].AllowCheckUpperLimit), serialOperations[i].ItemId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors CheckIfItemsWithUpperLimitAvailable(ref bool allowCheckUpperLimit)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            allowCheckUpperLimit = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = null;
                string query = string.Format(@"select Count(*)
                from Item
                INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID AND
                ItemCategory.DivisionID IN ({0})
                INNER JOIN ItemExtraInfo IEI on IEI.ItemID = Item.ItemID AND IEI.AllowCheckUpperLimit = 1
                WHERE Item.Inactive = 0", _requestRepository.CurrentOperator.DivisionAccess);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    allowCheckUpperLimit = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetMasterPackGroups(ref List<MasterPackGroupModel> masterPackGroups)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                masterPackGroups = new List<MasterPackGroupModel>();
                DBHelper<MasterPackGroupModel> dBHelper = new DBHelper<MasterPackGroupModel>();
                string query = $@"select MPG.MasterPackGroupID, ISNULL(MPG.MasterPackGroupCode, '--') + ' - ' + ISNULL(MPGL.Description, '--') MasterPackGroupDescription
                from MasterPackGroup MPG
                left outer join MasterPackGroupLanguage MPGL on MPG.MasterPackGroupID=MPGL.MasterPackGroupID
                and MPGL.LanguageID={_requestRepository.LanguageId}";
                result = dBHelper.GetQueryList(query , ref masterPackGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveCustomerBasket(ItemPackModel itemPack, string token, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO CustomerAppBasket (OperatorID, PackId, Quantity, Token) VALUES ({0}, {1}, {2}, '{3}')", _requestRepository.CurrentEchoOperator.OperatorId, itemPack.PackId, itemPack.RequiredQty, token);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteCustomerBasket(DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE CustomerAppBasket WHERE OperatorID = {0}", _requestRepository.CurrentEchoOperator.OperatorId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SetPackRate(DBHelper<int> dBHelper,RateModel rate)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select count(*) from EchoCustRate where PackID = {0} and CustomerID = {1}  ", rate.packId , rate.CustomerId);
                object Value = 0;
                dBHelper.ExecuteScalar(query, ref Value);
                if (!Value.ToString().Equals("0"))
                    query = String.Format("update EchoCustRate set RateValue = {0} where  PackID = {1} and CustomerID = {2}", rate.RateValue, rate.packId, rate.CustomerId);
                else
                    query = String.Format("insert into EchoCustRate (RateValue, PackID, CustomerID) values ({0},{1},{2})", rate.RateValue, rate.packId, rate.CustomerId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetGS1TemplateDetail(int TemplateID , ref ItemPackModel pack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            ImportItemDetailsModel itemsDetail = new ImportItemDetailsModel();
            DBHelper<ImportItemDetailsModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<ImportItemDetailsModel>();
                string query = string.Format(@"Select isnull(BarcodeTemplate.Length, 0) Length, isnull(serial.FieldSequence, 0) SerialSequence, isnull(serial.FieldLength, 0) SerialLength,
                isnull(batchNo.FieldSequence, 0) BatchSequence, isnull(batchNo.FieldLength, 0) BatchLength, isnull(expiryDate.FieldSequence, 0) ExpirySequence,
                isnull(expiryDate.FieldLength, 0) ExpiryLength, isnull(gtin.FieldSequence, 0) gtinSequence, isnull(gtin.FieldLength, 0) gtinLength
                ,isnull(gln.FieldSequence, 0) glnSequence, isnull(gln.FieldLength, 0) glnLength ,isnull(productionDate.FieldSequence, 0) productionDateSequence, isnull(productionDate.FieldLength, 0) productionDateLength
                from  BarcodeTemplate
                Left Join BarcodeTemplateDetails serial on serial.TemplateID = BarcodeTemplate.TemplateID
                and serial.FieldID = {0}
                Left Join BarcodeTemplateDetails batchNo  on batchNo.TemplateID = BarcodeTemplate.TemplateID
                and batchNo.FieldID = {1}
                Left Join BarcodeTemplateDetails expiryDate on expiryDate.TemplateID = BarcodeTemplate.TemplateID
                and expiryDate.FieldID = {2}
                Left Join BarcodeTemplateDetails gtin  on gtin.TemplateID = BarcodeTemplate.TemplateID
                and gtin.FieldID = {3}
                Left Join BarcodeTemplateDetails gln  on gln.TemplateID = BarcodeTemplate.TemplateID
                and gln.FieldID = {4}
                Left Join BarcodeTemplateDetails productionDate  on productionDate.TemplateID = BarcodeTemplate.TemplateID
                and productionDate.FieldID = {5} Where BarcodeTemplate.TemplateID = {6}", 
                BarcodeTemplateFields.Serial.GetHashCode(), //0
                BarcodeTemplateFields.BatchNumber.GetHashCode(), //1
                BarcodeTemplateFields.ExpiryDate.GetHashCode(), //2
                BarcodeTemplateFields.GTIN.GetHashCode(), //3
                BarcodeTemplateFields.GLN.GetHashCode(), //4
                BarcodeTemplateFields.ProductionDate.GetHashCode(), //5
                TemplateID //6
                );
                result = dBHelper.GetQuerySingle(query, ref itemsDetail);

                if (result == GlobalErrors.Success)
                {
                    BarcodeTemplateModel barcodeTemplate = new BarcodeTemplateModel();
                    GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.Serial, ref barcodeTemplate);
                    pack.TemplateSerialsIndecies = new List<int>();
                    if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                    {
                        pack.TemplateSerialsIndecies.Add(barcodeTemplate.StartIndex);
                        pack.TemplateSerialsIndecies.Add(barcodeTemplate.EndIndex);
                    }
                    if (itemsDetail.GTINLength > 0)
                    {
                        GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.GTIN, ref barcodeTemplate);
                        pack.TemplateGTINIndecies = new List<int>();
                        if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                        {
                            pack.TemplateGTINIndecies.Add(barcodeTemplate.StartIndex);
                            pack.TemplateGTINIndecies.Add(barcodeTemplate.EndIndex);
                        }
                    }
                    if (itemsDetail.BatchLength > 0)
                    {
                        GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.BatchNumber, ref barcodeTemplate);
                        pack.TemplateBatchNoIndecies = new List<int>();
                        if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                        {
                            pack.TemplateBatchNoIndecies.Add(barcodeTemplate.StartIndex);
                            pack.TemplateBatchNoIndecies.Add(barcodeTemplate.EndIndex);
                        }
                    }
                    if (itemsDetail.ExpiryLength > 0)
                    {
                        GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.ExpiryDate, ref barcodeTemplate);
                        pack.TemplateExpiryDateIndecies = new List<int>();
                        if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                        {
                            pack.TemplateExpiryDateIndecies.Add(barcodeTemplate.StartIndex);
                            pack.TemplateExpiryDateIndecies.Add(barcodeTemplate.EndIndex);
                        }
                    }
                    if (itemsDetail.ProductionDateLength > 0)
                    {
                        GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.ProductionDate, ref barcodeTemplate);
                        pack.TemplateProductionDateIndecies = new List<int>();
                        if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                        {
                            pack.TemplateProductionDateIndecies.Add(barcodeTemplate.StartIndex);
                            pack.TemplateProductionDateIndecies.Add(barcodeTemplate.EndIndex);
                        }
                    }
                    if (itemsDetail.GLNLength > 0)
                    {
                        GetStartIndexAndEndIndex(itemsDetail, BarcodeTemplateFields.GLN, ref barcodeTemplate);
                        pack.TemplateGLNIndecies = new List<int>();
                        if (barcodeTemplate.StartIndex != barcodeTemplate.EndIndex)
                        {
                            pack.TemplateGLNIndecies.Add(barcodeTemplate.StartIndex);
                            pack.TemplateGLNIndecies.Add(barcodeTemplate.EndIndex);
                        }
                    }
                    pack.TotalFieldsLengthOfItemTemplate += itemsDetail.Length;

                    return GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                }
            }
            return result;

        }
        public void GetStartIndexAndEndIndex(ImportItemDetailsModel itemsDetails, BarcodeTemplateFields barcodeTemplateField, ref BarcodeTemplateModel barcodeTemplate)
        {
            try
            {
                int seq = 0;
                int fieldLength = 0;
                int totalLength = 0;
                int startIndex = 0;
                int endIndex = 0;
                barcodeTemplate = new BarcodeTemplateModel();
                switch (barcodeTemplateField)
                {
                    case BarcodeTemplateFields.Serial:
                        seq = itemsDetails.SerialSequence;
                        fieldLength = itemsDetails.SerialLength + 2;
                        if (itemsDetails.BatchSequence > 0 && itemsDetails.BatchSequence < seq)
                            totalLength += itemsDetails.BatchLength + 2;
                        if (itemsDetails.ExpirySequence > 0 && itemsDetails.ExpirySequence < seq)
                            totalLength += itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.GLNSequence > 0 && itemsDetails.GLNSequence < seq)
                            totalLength += itemsDetails.GLNLength + 3;
                        if (itemsDetails.GTINSequence > 0 && itemsDetails.GTINSequence < seq)
                            totalLength += itemsDetails.GTINLength + 2;
                        if (itemsDetails.ProductionDateSequence > 0 && itemsDetails.ProductionDateSequence < seq)
                            totalLength += itemsDetails.ProductionDateLength + 2;
                        break;
                    case BarcodeTemplateFields.BatchNumber:
                        seq = itemsDetails.BatchSequence;
                        fieldLength = itemsDetails.BatchLength + 2;
                        if (itemsDetails.SerialSequence > 0 && itemsDetails.SerialSequence < seq)
                            totalLength += itemsDetails.SerialLength + 2;
                        if (itemsDetails.ExpirySequence > 0 && itemsDetails.ExpirySequence < seq)
                            totalLength += itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.GLNSequence > 0 && itemsDetails.GLNSequence < seq)
                            totalLength += itemsDetails.GLNLength + 3;
                        if (itemsDetails.GTINSequence > 0 && itemsDetails.GTINSequence < seq)
                            totalLength += itemsDetails.GTINLength + 2;
                        if (itemsDetails.ProductionDateSequence > 0 && itemsDetails.ProductionDateSequence < seq)
                            totalLength += itemsDetails.ProductionDateLength + 2;
                        break;
                    case BarcodeTemplateFields.ExpiryDate:
                        seq = itemsDetails.ExpirySequence;
                        fieldLength = itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.SerialSequence > 0 && itemsDetails.SerialSequence < seq)
                            totalLength += itemsDetails.SerialLength + 2;
                        if (itemsDetails.BatchSequence > 0 && itemsDetails.BatchSequence < seq)
                            totalLength += itemsDetails.BatchLength + 2;
                        if (itemsDetails.GLNSequence > 0 && itemsDetails.GLNSequence < seq)
                            totalLength += itemsDetails.GLNLength + 3;
                        if (itemsDetails.GTINSequence > 0 && itemsDetails.GTINSequence < seq)
                            totalLength += itemsDetails.GTINLength + 2;
                        if (itemsDetails.ProductionDateSequence > 0 && itemsDetails.ProductionDateSequence < seq)
                            totalLength += itemsDetails.ProductionDateLength + 2;
                        break;
                    case BarcodeTemplateFields.GTIN:
                        seq = itemsDetails.GTINSequence;
                        fieldLength = itemsDetails.GTINLength + 2;
                        if (itemsDetails.SerialSequence > 0 && itemsDetails.SerialSequence < seq)
                            totalLength += itemsDetails.SerialLength + 2;
                        if (itemsDetails.BatchSequence > 0 && itemsDetails.BatchSequence < seq)
                            totalLength += itemsDetails.BatchLength + 2;
                        if (itemsDetails.ExpirySequence > 0 && itemsDetails.ExpirySequence < seq)
                            totalLength += itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.GLNSequence > 0 && itemsDetails.GLNSequence < seq)
                            totalLength += itemsDetails.GLNLength + 3;
                        if (itemsDetails.ProductionDateSequence > 0 && itemsDetails.ProductionDateSequence < seq)
                            totalLength += itemsDetails.ProductionDateLength + 2;
                        break;
                    case BarcodeTemplateFields.GLN:
                        seq = itemsDetails.GLNSequence;
                        fieldLength = itemsDetails.GLNLength + 3;
                        if (itemsDetails.SerialSequence > 0 && itemsDetails.SerialSequence < seq)
                            totalLength += itemsDetails.SerialLength + 2;
                        if (itemsDetails.BatchSequence > 0 && itemsDetails.BatchSequence < seq)
                            totalLength += itemsDetails.BatchLength + 2;
                        if (itemsDetails.ExpirySequence > 0 && itemsDetails.ExpirySequence < seq)
                            totalLength += itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.GTINSequence > 0 && itemsDetails.GTINSequence < seq)
                            totalLength += itemsDetails.GTINLength + 2;
                        if (itemsDetails.ProductionDateSequence > 0 && itemsDetails.ProductionDateSequence < seq)
                            totalLength += itemsDetails.ProductionDateLength + 2;
                        break;
                    case BarcodeTemplateFields.ProductionDate:
                        seq = itemsDetails.ProductionDateSequence;
                        fieldLength = itemsDetails.ProductionDateLength + 2;
                        if (itemsDetails.SerialSequence > 0 && itemsDetails.SerialSequence < seq)
                            totalLength += itemsDetails.SerialLength + 2;
                        if (itemsDetails.BatchSequence > 0 && itemsDetails.BatchSequence < seq)
                            totalLength += itemsDetails.BatchLength + 2;
                        if (itemsDetails.ExpirySequence > 0 && itemsDetails.ExpirySequence < seq)
                            totalLength += itemsDetails.ExpiryLength + 2;
                        if (itemsDetails.GTINSequence > 0 && itemsDetails.GTINSequence < seq)
                            totalLength += itemsDetails.GTINLength + 2;
                        if (itemsDetails.GLNSequence > 0 && itemsDetails.GLNSequence < seq)
                            totalLength += itemsDetails.GLNLength + 3;
                        break;
                }
                startIndex = totalLength;
                endIndex = (totalLength - 1) + fieldLength;
                barcodeTemplate.StartIndex = startIndex;
                barcodeTemplate.EndIndex = endIndex;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public GlobalErrors PrepareMustSellItemWhileImportFromExcel(ref List<dynamic> items, ref int importedCount, ref int notImportedCount, DBHelper<int> dBHelperCount)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                DBHelper<dynamic> dBHelper = null;
                if (dBHelperCount == null)
                {
                    dBHelperCount = new DBHelper<int>();
                    dBHelper = new DBHelper<dynamic>();
                }
                else
                {
                    dBHelper = new DBHelper<dynamic>(dBHelperCount.GetConnection(), dBHelperCount.GetDBTransaction());
                }
                object itemsCount = 0;
                object invalidRangeCount = 0;
                object invalidDublicatePackCount = 0;
                string divisionOrgAccess = string.Empty;
                //int baseCurrencyId = _currencyManager.GetBaseCurrencyId();

                #region VALIDATION
                string invalidationQuery = @" select top 1 Count(*)
                    from ImportMustSellItemsTemplate 
                    group by ImportMustSellItemsTemplate.ItemCode
                    HAVING count(*) > 1
                    ORDER BY count(*) desc
                        ";
                result = dBHelperCount.ExecuteScalar(invalidationQuery, ref invalidDublicatePackCount);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;

                if (invalidDublicatePackCount != null && (int)invalidDublicatePackCount > 0)
                    return GlobalErrors.DataAlreadyExists;

                #endregion


                string query = $@"

                                select distinct item.ItemID itemId,IL.Description itemName,item.ItemCode itemCode,
                                item.ItemCode +' - '+IL.Description itemCodeName
                                from ImportMustSellItemsTemplate
                                inner join item on LOWER(item.ItemCode) = LOWER(ImportMustSellItemsTemplate.ItemCode)
                                left join ItemLanguage IL on IL.ItemID = item.ItemID and IL.LanguageID =  {_requestRepository.LanguageId} 
                                INNER JOIN ItemCategory ON item.ItemCategoryID = ItemCategory.ItemCategoryID
                                inner join Division on Division.DivisionID = ItemCategory.DivisionID  and Division.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess })";
                string countQuery = $"select Count(*) ItemsCount from ImportMustSellItemsTemplate ";

                result = dBHelperCount.ExecuteScalar(countQuery, ref itemsCount);
                if (result == GlobalErrors.Success && itemsCount != null && int.Parse(itemsCount.ToString()) > 0)
                {
                    result = dBHelper.GetQueryList(query, ref items);
                    importedCount = items.Count();
                    notImportedCount = int.Parse(itemsCount.ToString()) - importedCount;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetSmallestItemPack(int itemId, ref ItemPackModel smallestPack)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                DBHelper<ItemPackModel> dBHelper = dBHelper = new DBHelper<ItemPackModel>();
                string query = $@" SELECT Pack.PackID , Pack.Barcode , PackTypeLanguage.Description UOM,Pack.HasSerialNumber ,Pack.Quantity, pack.PackTypeID From Pack
                INNER JOIN PackTypeLanguage ON Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                WHERE Pack.ItemID =  {itemId} and pack.Quantity=(select min(Pack.Quantity) from pack where Pack.ItemID = {itemId})";
                result = dBHelper.GetQuerySingle(query, ref smallestPack);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPromotionItemsWithStockStatus(GeneralFilter filter, ref List<CRMPromotionItem> promotionItem)
        {
            DBHelper<CRMPromotionItem> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CRMPromotionItem>();

                string query = string.Format(@"select tt.* from item
                inner join ItemCategory on ItemCategory.ItemCategoryID = item.ItemCategoryID
                inner join Division on Division.DivisionID = ItemCategory.DivisionID and Division.DivisionId in ({4}) {5}
			    inner join ( 
                
                Select Pack.PackID,Details.SalesOrderTypeID SalesOrderTypeIDs,Pack.ItemID as ItemID,Promotion.PromotionId as PromotionID, PromotionLanguage.Description as Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID AND AllCustomers = 1
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1  and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN Pack on Pack.PackID = Details.PackID 
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)

                Union
                Select  Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID AND AllCustomers = 1
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)

                Union
                Select  Pack.PackID,PromotionOptionDetailGroup.SalesOrderTypeIDs,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID AND AllCustomers = 1
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null and Details.PromotionOptionDetailTypeID = 25
                INNER JOIN PromotionOptionDetailGroup On PromotionOptionDetailGroup.PackID = PackGroupDetail.PackID And PromotionOptionDetailGroup.PromotionID = Promotion.PromotionID and PromotionOptionDetailGroup.SalesOrderTypeIDs is not null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0) 

                Union
                Select  Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID AND AllCustomers = 1
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0) 
                   
                Union
                Select  Pack.PackID,PromotionOptionDetailGroup.SalesOrderTypeIDs,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID AND AllCustomers = 1
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID = 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN PromotionOptionDetailGroup On PromotionOptionDetailGroup.PackID = PackGroupDetail.PackID And PromotionOptionDetailGroup.PromotionID = Promotion.PromotionID and PromotionOptionDetailGroup.SalesOrderTypeIDs is not null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0) 
                   
                Union
                Select Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID And CustomerPromotion.CustomerID = {0} and  CustomerPromotion.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN Pack on Pack.PackID = Details.PackID 
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
             
                Union    
                Select Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID And CustomerPromotion.CustomerID = {0} and  CustomerPromotion.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)

                Union
                Select Pack.PackID,PromotionOptionDetailGroup.SalesOrderTypeIDs,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID And CustomerPromotion.CustomerID = {0} and  CustomerPromotion.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID = 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN PromotionOptionDetailGroup On PromotionOptionDetailGroup.PackID = PackGroupDetail.PackID And PromotionOptionDetailGroup.PromotionID = Promotion.PromotionID and PromotionOptionDetailGroup.SalesOrderTypeIDs is not null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
                
                Union  
                Select Pack.PackID, Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID
                Inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerPromotion.CustomerGroupID And CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN Pack on Pack.PackID = Details.PackID 
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
                    
                Union
                Select Pack.PackID,PromotionOptionDetailGroup.SalesOrderTypeIDs,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID
                Inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerPromotion.CustomerGroupID And CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID = 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN PromotionOptionDetailGroup On PromotionOptionDetailGroup.PackID = PackGroupDetail.PackID And PromotionOptionDetailGroup.PromotionID = Promotion.PromotionID and PromotionOptionDetailGroup.SalesOrderTypeIDs is not null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
                    
                   
                Union
                Select Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON
                CustomerPromotion.PromotionID = Promotion.PromotionID
                Inner Join CustomerGroup On CustomerGroup.SubChannelID = CustomerPromotion.SubChannelID
                Inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID And CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN Pack on Pack.PackID = Details.PackID 
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
                    
                Union
                Select Pack.PackID,Details.SalesOrderTypeID,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON
                CustomerPromotion.PromotionID = Promotion.PromotionID
                Inner Join CustomerGroup On CustomerGroup.SubChannelID = CustomerPromotion.SubChannelID
                Inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID And CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID <> 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)

                Union
                Select Pack.PackID,PromotionOptionDetailGroup.SalesOrderTypeIDs,Pack.ItemID,Promotion.PromotionId, PromotionLanguage.Description from Promotion  
                INNER JOIN CustomerPromotion ON
                CustomerPromotion.PromotionID = Promotion.PromotionID
                Inner Join CustomerGroup On CustomerGroup.SubChannelID = CustomerPromotion.SubChannelID
                Inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID And CustomerOutletGroup.CustomerID = {0} And CustomerOutletGroup.OutletID = {1}
                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1 and Details.PromotionOptionDetailTypeID = 25
                INNER JOIN PackGroupDetail On PackGroupDetail.PackGroupID = Details.PackGroupID And Details.PackID Is Null
                INNER JOIN PromotionOptionDetailGroup On PromotionOptionDetailGroup.PackID = PackGroupDetail.PackID And PromotionOptionDetailGroup.PromotionID = Promotion.PromotionID and PromotionOptionDetailGroup.SalesOrderTypeIDs is not null
                INNER JOIN Pack On Pack.PackID = PackGroupDetail.PackID
                Left Join CustomerPromotionExclusion On CustomerPromotionExclusion.PromotionID = Promotion.PromotionID And CustomerPromotionExclusion.CustomerID = {0} And CustomerPromotionExclusion.OutletID = {1}
                INNER JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID AND PromotionLanguage.LanguageID = {3}
                WHERE
                CustomerPromotionExclusion.PromotionID Is Null And
                Promotion.Inactive = 0
                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                AND  Promotion.PromotionType <> 4
                AND  (Promotion.StartDate <= {6})
                AND  (Promotion.EndDate   >= {2})
                AND  (promotion.IsDeleted=0)
                AND  (promotion.IsBundle <> 1)
                AND  (promotion.IsLoyaltyPromotion = 0)
                )tt on tt.ItemID = item.ItemID",
                filter.CustomerId, filter.OutletId, LocalUtilities.ParseEndDateToSQLString(DateTime.Now), _requestRepository.LanguageId, _requestRepository.CurrentOperator.DivisionAccess, _requestRepository.Configurations.RestrictDataToCustomerOrganization ? $" And Division.OrganizationId in ({filter.OrganizationId}) " : "",
                LocalUtilities.ParseDateToSQLString(DateTime.Now));

                Stopwatch stopWatch = new Stopwatch();
                stopWatch.Start();

                result = dbHelper.GetQueryList(query, ref promotionItem);

                stopWatch.Stop();
                TimeSpan ts = stopWatch.Elapsed;
                string elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, query.ToString(), elapsedTime);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promotionItem = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPromotionsDetailsWithStockStatus(string promotionIds, ref List<CRMPromotionItem> promotionDetails)
        {
            DBHelper<CRMPromotionItem> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<CRMPromotionItem>();

                string query = string.Format(@"Select PromOptionDetailLanguage.PromotionID,Description PromotionDetailsDescription,PromotionOptionDetail.PromotionOptionTypeID,
                isNull(PromotionOptionDetail.PackGroupID,-1) PackGroupID,PromotionOptionDetail.PromotionOptionDetailTypeID,PromotionOptionDetail.PromotionOptionID,PromotionOptionDetail.PromotionOptionDetailID
                from PromOptionDetailLanguage
                inner join PromotionOptionDetail on PromotionOptionDetail.PromotionID = PromOptionDetailLanguage.PromotionID
                and PromOptionDetailLanguage.PromotionOptionID = PromotionOptionDetail.PromotionOptionID
                and PromOptionDetailLanguage.PromotionOptionDetailID = PromotionOptionDetail.PromotionOptionDetailID
                 AND PromOptionDetailLanguage.LanguageID = {0}
                where PromOptionDetailLanguage.PromotionID in ({1})",
                _requestRepository.LanguageId, promotionIds);
                result = dbHelper.GetQueryList(query, ref promotionDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promotionDetails = null;
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}