﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class LocationManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly MasterDataManager _masterDataManager;
        public LocationManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _masterDataManager = new MasterDataManager(requestRepository);
        }
        public GlobalErrors GetCountries(ref List<Country> countries, bool isGeoLocationMode, DBHelper<Country> dBHelper, int countryId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<Country>();
                }
                
                string filter = countryId > 0 ? $" where Country.CountryID = {countryId}" : string.Empty;
                string query = string.Format(@"select Country.CountryID , Country.CountryCode , CountryLanguage.Description CountryName , ISNULL(Country.CountryCode , '---') + ' -- ' + ISNULL(CountryLanguage.Description , '--')
                from Country
                LEFT JOIN CountryLanguage on CountryLanguage.CountryID = Country.CountryID AND CountryLanguage.LanguageID = {0} {1}", _requestRepository.LanguageId,filter);
                result = dBHelper.GetQueryList(query, ref countries);


                if (result == GlobalErrors.Success && (countries != null && countries.Count > 0) && isGeoLocationMode)
                {
                    DBHelper < TextLanguage > dbHelperDescription = new DBHelper<TextLanguage>();
                    dbHelperDescription = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    var descriptionsList = new List<TextLanguage>();
                    var countryIds = countries.Select(c => c.CountryId).Distinct().ToList();
                    query = $" select CountryID Id,LanguageID,Description from CountryLanguage where CountryID in({string.Join(",", countryIds)})";
                    result = dbHelperDescription.GetQueryList(query, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        countries.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.CountryId).ToList(); return x; }).ToList();
                    }

                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetStates(int countryId, ref List<State> State, bool isGeoLocationMode, DBHelper<State> dBHelper, int stateId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<State>();
                }
                var filter = string.Empty;
                if (countryId > 0)
                {
                    filter = string.Format(@" and State.CountryID = {0}", countryId);
                }
                if(stateId > 0)
                {
                    filter += $" and State.StateID = {stateId}";
                }
                string query = string.Format(@"Select State.CountryID , State.StateID , State.StateCode , StateLanguage.Description statessName
                from State
                LEFT JOIN StateLanguage on State.CountryID = StateLanguage.CountryID AND State.StateID = StateLanguage.StateID AND StateLanguage.LanguageID = {1}
                where 1=1  {0}", filter, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref State);


                if (result == GlobalErrors.Success && (State != null && State.Count > 0) && isGeoLocationMode)
                {
                    DBHelper<TextLanguage> dbHelperDescription = new DBHelper<TextLanguage>();
                    dbHelperDescription = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    var descriptionsList = new List<TextLanguage>();
                    var stateIds = State.Select(c => c.StateId).Distinct().ToList();
                    query = $" select StateID Id,LanguageID,Description from StateLanguage where StateID  in({string.Join(",", stateIds)})";
                    result = dbHelperDescription.GetQueryList(query, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        State.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.StateId).ToList(); return x; }).ToList();
                    }

                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCities(int countryId, int stateId, ref List<City> city, bool isGeoLocationMode, DBHelper<City> dBHelper, int cityId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            var filter = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<City>();
                }

                if (countryId > 0)
                {
                    filter = string.Format(@" AND City.CountryID = {0} ", countryId);
                }
                if (stateId > 0)
                {
                    filter += string.Format(@" AND City.StateID = {0} ", stateId);
                }
                if(cityId > 0)
                {
                    filter += $" and City.CityID = {cityId}";
                }
                string query = string.Format(@"Select City.CountryID , City.StateID ,City.CityID , City.CityCode , CityLanguage.Description CityName
                 from City
                 LEFT JOIN CityLanguage on CityLanguage.CountryID = City.CountryID AND CityLanguage.StateID = City.StateID AND CityLanguage.CityID = City.CityID AND CityLanguage.LanguageID = {1} 
                 Where 1=1 {0}  ", filter, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref city);



                if (result == GlobalErrors.Success && (city != null && city.Count > 0) && isGeoLocationMode)
                {
                    DBHelper<TextLanguage> dbHelperDescription = new DBHelper<TextLanguage>();
                    dbHelperDescription = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    var descriptionsList = new List<TextLanguage>();
                    var cityIds = city.Select(c => c.CityId).Distinct().ToList();
                    query = $" select CityID Id,LanguageID,Description from CityLanguage where CityID in({string.Join(",", cityIds)})";
                    result = dbHelperDescription.GetQueryList(query, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        city.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.CityId).ToList(); return x; }).ToList();
                    }

                }


                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAreas(int countryID, int stateID, int cityId, ref List<Area> area, bool isGeoLocationMode, DBHelper<Area> dBHelper, int areaId = -1)
        {
            var result = GlobalErrors.NotInitialized;

            var filter = string.Empty;
            try
            {
                if (countryID > 0)
                {
                    filter = string.Format(@" AND Area.CountryID = {0} ", countryID);
                }
                if (stateID > 0)
                {
                    filter += string.Format(@" AND Area.StateID = {0} ", stateID);
                }
                if (cityId > 0)
                {
                    filter += string.Format(@" AND Area.CityID = {0} ", cityId);
                }
                if(areaId > 0)
                {
                    filter += $" and Area.AreaID = {areaId}";
                }
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<Area>();
                }
                string query = string.Format(@"Select Area.CountryID , Area.StateID , Area.CityID , Area.AreaID , Area.AreaCode , AreaLanguage.Description AreaName
                FROM Area
                LEFT JOIN AreaLanguage on AreaLanguage.CountryID = Area.CountryID AND AreaLanguage.StateID = Area.StateID AND AreaLanguage.CityID = Area.CityID AND AreaLanguage.AreaID = Area.AreaID AND AreaLanguage.LanguageID ={0}
                Where 1=1 {1} ", _requestRepository.LanguageId, filter);
                result = dBHelper.GetQueryList(query, ref area);


                if (result == GlobalErrors.Success && (area != null && area.Count > 0) && isGeoLocationMode)
                {
                    DBHelper<TextLanguage> dbHelperDescription = new DBHelper<TextLanguage>();
                    dbHelperDescription = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    var descriptionsList = new List<TextLanguage>();
                    var areaIds = area.Select(c => c.AreaId).Distinct().ToList();
                    query = $" select AreaID Id,LanguageID,Description from AreaLanguage where AreaID in({string.Join(",", areaIds)})";
                    result = dbHelperDescription.GetQueryList(query, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        area.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.AreaId).ToList(); return x; }).ToList();
                    }

                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetStreets(int countryID, int stateID, int cityId, int areaId, ref List<Street> street, bool isGeoLocationMode)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<Street> dBHelper = null;
            var countryFilter = string.Empty;
            var stateFilter = string.Empty;
            var cityFilter = string.Empty;
            var areaFilter = string.Empty;
            try
            {
                if (countryID > 0)
                {
                    countryFilter = string.Format(@" AND Street.CountryID = {0} ", countryID);
                }
                if (stateID > 0)
                {
                    stateFilter = string.Format(@" AND Street.StateID = {0} ", stateID);
                }
                if (cityId > 0)
                {
                    cityFilter = string.Format(@" AND Street.CityID = {0} ", cityId);
                }
                if (areaId > 0)
                {
                    areaFilter = string.Format(@" AND Street.AreaID = {0} ", areaId);
                }
                dBHelper = new DBHelper<Street>();
                string query = string.Format(@"Select Street.CountryID , Street.StateID , Street.CityID , Street.AreaID , Street.StreetID, Street.StreetCode , StreetLanguage.Description StreetName
                FROM Street
                LEFT JOIN StreetLanguage on StreetLanguage.CountryID = Street.CountryID
                AND StreetLanguage.StateID = Street.StateID 
                AND StreetLanguage.CityID = Street.CityID 
                AND StreetLanguage.AreaID = Street.AreaID 
                AND StreetLanguage.StreetID = Street.StreetID 
                AND StreetLanguage.LanguageID ={0}
                Where 1=1 {1} {2} {3} {4} ", _requestRepository.LanguageId, countryFilter, stateFilter, cityFilter, areaFilter);
                result = dBHelper.GetQueryList(query, ref street);


                if (result == GlobalErrors.Success && (street != null && street.Count > 0) && isGeoLocationMode)
                {
                    var dbHelperDescription = new DBHelper<TextLanguage>();
                    var descriptionsList = new List<TextLanguage>();
                    var streetIds = street.Select(c => c.StreetId).Distinct().ToList();
                    query = $"select StreetID Id,LanguageID,Description from StreetLanguage where StreetID in({string.Join(",", streetIds)})";
                    result = dbHelperDescription.GetQueryList(query, ref descriptionsList);

                    if (result == GlobalErrors.Success && descriptionsList != null && descriptionsList.Count > 0)
                    {
                        street.Select(x => { x.Descriptions = descriptionsList.Where(c => c.Id == x.StreetId).ToList(); return x; }).ToList();
                    }

                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetLocatoinLists(ref List<LocationModel> LocationsList)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<LocationModel> dbHelper = null;
            LocationsList = new List<LocationModel>();
            try
            {
                dbHelper = new DBHelper<LocationModel>();
                string mainQuery = string.Format(@" select Area.CountryID, Area.StateID, Area.CityID, Area.AreaID,
                Country.CountryCode, State.StateCode, City.CityCode, Area.AreaCode,
                CountryLanguage.Description CountryName, StateLanguage.Description StateName,
                CityLanguage.Description CityName, AreaLanguage.Description AreaName,
                IsNull( CountryLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( StateLanguage.Description, '--') 
                + ' ' + '-'+ ' ' + IsNull( CityLanguage.Description , '--') + ' ' + '-'+ ' ' + '('+ IsNull( Area.AreaCode , '--') + '-'+ ' '+ 
                IsNull( AreaLanguage.Description , '--') + ')'
                as LocationCodeName from Area
                INNER JOIN Country on Country.CountryID = Area.CountryID
                INNER JOIN State on State.StateID = Area.StateID 
                INNER JOIN City on City.CityID = Area.CityID 
                INNER JOIN AreaLanguage on Area.AreaID = AreaLanguage.AreaID and AreaLanguage.languageid = {0}
                INNER JOIN CountryLanguage on Country.CountryID = CountryLanguage.CountryID and CountryLanguage.languageid = {0}
                INNER JOIN StateLanguage on State.StateID = StateLanguage.StateID and StateLanguage.languageid = {0}
                INNER JOIN CityLanguage on City.CityID = CityLanguage.CityID and CityLanguage.languageid = {0} ", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(mainQuery, ref LocationsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetContactCountry(ref List<Country> contactCountryList)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<Country> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<Country>();
                string query = string.Format(@" select ContactCountry.CountryId,ContactCountry.CountryCode,ContactCountryLanguage.Description CountryName,ISNULL(ContactCountry.CountryCode , '-') + ' - ' + ISNULL(ContactCountry.PrefixCode , '--') CountryPrefixCode,ContactCountry.PrefixCode  from ContactCountry
                LEFT JOIN ContactCountryLanguage on ContactCountryLanguage.CountryId = ContactCountry.CountryId and ContactCountryLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref contactCountryList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRouteAreas(int routeId, ref List<LocationModel> locations)
        {
            DBHelper<LocationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<LocationModel>();
                string query = string.Format(@"select RouteAreas.RouteId, RouteAreas.AreaId 
                                from RouteAreas
                                where RouteAreas.RouteId={0}", routeId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref locations);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                locations = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        #region Locations Hierarchy 
        public GlobalErrors InsertUpdateCountry(bool isEditMode, int countryId, string countryCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage,ref int insertedId)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("Country", "CountryCode", countryCode, $"And(CountryID != {countryId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update Country set CountryCode = '{countryCode}' where CountryID = {countryId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from CountryLanguage where CountryID = {countryId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into CountryLanguage(CountryID,LanguageID,Description)values({countryId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("Country", "CountryCode", countryCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxCountryId = insertedId = GetMaxID("Country", "CountryID", dbHelper);
                        if (maxCountryId == -1) return GlobalErrors.Error;
                        query = $"insert into Country(CountryID,CountryCode)values({maxCountryId},'{countryCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into CountryLanguage(CountryID,LanguageID,Description)values({maxCountryId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateState(bool isEditMode, int countryId, int stateId, string stateCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage,ref int insertedId)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("State", "StateCode", stateCode, $"And(StateID != {stateId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update State set CountryID = {countryId},StateCode = '{stateCode}' where StateID  = {stateId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from StateLanguage where StateID = {stateId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into StateLanguage(CountryID,StateID,LanguageID,Description)values({countryId},{stateId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("State", "StateCode", stateCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxStateId = insertedId = GetMaxID("State", "StateID", dbHelper);
                        if (maxStateId == -1) return GlobalErrors.Error;
                        query = $"insert into State(CountryID,StateID,StateCode)values({countryId},{maxStateId},'{stateCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into StateLanguage(CountryID,StateID,LanguageID,Description)values({countryId},{maxStateId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateCity(bool isEditMode, int countryId, int stateId, int cityId, string cityCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage,ref int insertedId)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("City", "CityCode", cityCode, $"And(CityID != {cityId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update City set CountryID = {countryId} ,StateID = {stateId} ,CityCode = '{cityCode}' where CityID =  {cityId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from CityLanguage where CityID = {cityId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into CityLanguage(CountryID,StateID,CityID,LanguageID,Description)values({countryId},{stateId},{cityId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("City", "CityCode", cityCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxCityId = insertedId = GetMaxID("City", "CityID", dbHelper);
                        if (maxCityId == -1) return GlobalErrors.Error;
                        query = $"insert into City (CountryID,StateID,CityID,CityCode)values({countryId},{stateId},{maxCityId},'{cityCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into CityLanguage(CountryID,StateID,CityID,LanguageID,Description)values({countryId},{stateId},{maxCityId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateArea(bool isEditMode, int countryId, int stateId, int cityId, int areaId, string areaCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage,ref int insertedId)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("Area", "AreaCode", areaCode, $"And(AreaID != {areaId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update Area set CountryID = {countryId} ,StateID = {stateId}, CityID = {cityId},AreaCode = '{areaCode}' where AreaID = {areaId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from AreaLanguage where AreaID = {areaId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into AreaLanguage(CountryID,StateID,CityID,AreaID,LanguageID,Description)values({countryId},{stateId},{cityId},{areaId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("Area", "AreaCode", areaCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxAreaId = insertedId = GetMaxID("Area", "AreaID", dbHelper);
                        if (maxAreaId == -1) return GlobalErrors.Error;
                        query = $"insert into Area(CountryID,StateID,CityID,AreaID,AreaCode)values({countryId},{stateId},{cityId},{maxAreaId},'{areaCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into AreaLanguage(CountryID,StateID,CityID,AreaID,LanguageID,Description)values({countryId},{stateId},{cityId},{maxAreaId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertUpdateStreet(bool isEditMode, int countryId, int stateId, int cityId, int areaId, int streetId, string streetCode, List<TextLanguage> descriptions, DBHelper<int> dbHelper, ref string errorMessage,ref int insertedId)
        {
            var result = GlobalErrors.NotInitialized;
            bool isUniqueCode = true;
            try
            {
                string query = string.Empty;
                var defaultDescription = descriptions.Where(x => x.LanguageId == _requestRepository.LanguageId).FirstOrDefault()?.Description;

                if (isEditMode)
                {
                    result = _masterDataManager.CheckIfUniqueValue("Street", "StreetCode", streetCode, $"And(StreetID != {streetId})", ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        query = $"update Street set CountryID = {countryId},StateID = {stateId},CityID = {cityId},AreaID = {areaId},StreetCode='{streetCode}' where StreetID = {streetId}";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            query = $"delete from StreetLanguage where StreetID = {streetId}";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (var item in descriptions)
                                {
                                    query = $@"insert into StreetLanguage(CountryID,StateID,CityID,AreaID,StreetID,LanguageID,Description)values({countryId},{stateId},{cityId},{areaId},{streetId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }

                }
                else
                {
                    result = _masterDataManager.CheckIfUniqueValue("Street", "StreetCode", streetCode, string.Empty, ref isUniqueCode, dbHelper);
                    if (result == GlobalErrors.Success && isUniqueCode)
                    {
                        int maxStreetId = insertedId = GetMaxID("Street", "StreetID", dbHelper);
                        if (maxStreetId == -1) return GlobalErrors.Error;
                        query = $"insert into Street(CountryID,StateID,CityID,AreaID,StreetID,StreetCode)values({countryId},{stateId},{cityId},{areaId},{maxStreetId},'{streetCode}')";
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            foreach (var item in descriptions)
                            {
                                query = $@"insert into StreetLanguage(CountryID,StateID,CityID,AreaID,StreetID,LanguageID,Description)values({countryId},{stateId},{cityId},{areaId},{maxStreetId},{item.LanguageId},N'{(!string.IsNullOrEmpty(item.Description) ? item.Description.Replace("'", "''") : defaultDescription)}')";
                                result = dbHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                        errorMessage = MessagesConstants.Desc_Unique_Code;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteCountry(int countryId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                string query = $"delete from CountryLanguage where CountryID = {countryId}";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = $"delete from Country where CountryID =  {countryId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteState(int countryId, int stateId, DBHelper<int> dbHelper, bool isDeleteByParent)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }

                if (!isDeleteByParent)
                {
                    string query = $"delete from StateLanguage where StateID = {stateId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from State where StateID = {stateId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {

                    string countryCondition = string.Empty;
                    string stateCondition = string.Empty;

                    if (countryId > 0)
                    {
                        countryCondition = $"CountryID = {countryId}";
                    }
                    if (stateId > 0)
                    {
                        stateCondition = $"StateID = {stateId}";
                    }

                    string query = $"delete from StateLanguage where {countryCondition} {stateCondition}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from State where {countryCondition} {stateCondition} ";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteCity(int countryId, int stateId, int cityId, DBHelper<int> dbHelper, bool isDeleteByParent)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                if (!isDeleteByParent)
                {
                    string query = $"delete from CityLanguage where CityId = {cityId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from City where CityId = {cityId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    string countryCondition = string.Empty;
                    string stateCondition = string.Empty;
                    string cityCondition = string.Empty;
                    if (countryId > 0)
                    {
                        countryCondition = $"CountryID = {countryId}";
                    }
                    if (stateId > 0)
                    {
                        stateCondition = $"StateID = {stateId}";
                    }
                    if (cityId > 0)
                    {
                        cityCondition = $"CityID = {cityId}";
                    }

                    string query = $"delete from CityLanguage where  {countryCondition} {stateCondition} {cityCondition} ";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from City where {countryCondition} {stateCondition} {cityCondition} ";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteArea(int countryId, int stateId, int cityId, int areaId, DBHelper<int> dbHelper, bool isDeleteByParent)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                if (!isDeleteByParent)
                {
                    string query = $"delete from AreaLanguage where AreaID = {areaId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from Area where AreaID = {areaId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    string countryCondition = string.Empty;
                    string stateCondition = string.Empty;
                    string cityCondition = string.Empty;
                    string areaCondition = string.Empty;
                    if (countryId > 0)
                    {
                        countryCondition = $"CountryID = {countryId}";
                    }
                    if (stateId > 0)
                    {
                        stateCondition = $"StateID = {stateId}";
                    }
                    if (cityId > 0)
                    {
                        cityCondition = $"CityID = {cityId}";
                    }
                    if (areaId > 0)
                    {
                        areaCondition = $"AreaID = {areaId}";
                    }

                    string query = $"delete from AreaLanguage where {countryCondition} {stateCondition} {cityCondition} {areaCondition} ";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from Area where {countryCondition} {stateCondition} {cityCondition} {areaCondition}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }

                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteStreet(int countryId, int stateId, int cityId, int areaId, int streetId, DBHelper<int> dbHelper, bool isDeleteByParent)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                if (!isDeleteByParent)
                {
                    string query = $"delete from StreetLanguage where StreetID = {streetId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from Street where StreetID = {streetId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    string countryCondition = string.Empty;
                    string stateCondition = string.Empty;
                    string cityCondition = string.Empty;
                    string areaCondition = string.Empty;
                    string streetCondition = string.Empty;
                    if (countryId > 0)
                    {
                        countryCondition = $"CountryID = {countryId}";
                    }
                    if (stateId > 0)
                    {
                        stateCondition = $"StateID = {stateId}";
                    }
                    if (cityId > 0)
                    {
                        cityCondition = $"CityID = {cityId}";
                    }
                    if (areaId > 0)
                    {
                        areaCondition = $"AreaID = {areaId}";
                    }
                    if (streetId > 0)
                    {
                        streetCondition = $"StreetID = {streetId}";
                    }
                    string query = $"delete from StreetLanguage where {countryCondition} {stateCondition} {cityCondition} {areaCondition} {streetCondition}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        query = $"delete from Street where {countryCondition} {stateCondition} {cityCondition} {areaCondition} {streetCondition}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }

                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors GetDummyLevelData(string fieldName,string tableName,ref int valueField, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                object field = -1;
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                string query = $"select isnull(max({fieldName}),-1) Id from {tableName}";
                result = dBHelper.ExecuteScalar(query, ref field);
                if(result == GlobalErrors.Success && (field != null && int.Parse(field.ToString()) > 0))
                {
                    valueField = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #endregion


        public static int GetMaxID(string tableName, string columnName, DBHelper<int> dbHelper)
        {
            int customerID = 0;
            bool disposeNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    disposeNow = true;
                }
                object customerIDObj = null;
                string query = string.Format("select Max({1}) from {0} ", tableName, columnName);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref customerIDObj);
                if (result == GlobalErrors.Success)
                {
                    if (customerIDObj != null && !string.IsNullOrEmpty(customerIDObj.ToString()))
                    {
                        customerID = int.Parse(customerIDObj.ToString()) + 1;
                    }
                    else
                    {
                        customerID = 1;
                    }
                }
                else
                {
                    customerID = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            finally
            {
                if (disposeNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return customerID;
        }
    }
}
