﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using InCube.Security;
using Sonic.Web.Licensing.Models;

namespace Sonic.Web.Core
{
    public class LoginManager
    {
        private readonly EmployeeManager _employeeManager;
        private readonly IRequestRepository _requestRepository;

        public LoginManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _employeeManager = new EmployeeManager(requestRepository);
        }

        #region [SONIC]

        public GlobalErrors InsertSupervisorAppDeviceToken(string DeviceToken, int employeeId)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = new DBHelper<string>();
            Object count = 0;
            int counter = -1;
            bool isOperatorExists = false;
            int operatorID = -1;
            string query = string.Empty;
            try
            {
                isOperatorExists = IsDeviceTokenExists(employeeId);
                if (!isOperatorExists)
                {
                    query = string.Format(@"INSERT INTO SupervisorDeviceToken (EmployeeId,Token) Values ({0}, '{1}') ",
                            employeeId, DeviceToken);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                { //insert into new table
                    query = string.Format(@"Update SupervisorDeviceToken set Token = '{0}' where EmployeeId = {1}",
                        DeviceToken, employeeId);
                    result = dbHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }


        public static GlobalErrors GetOldMenus(ref List<MenuModel> parentMenus)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            //   List<MenuModel> parentMenues = null;
            List<MenuModel> childMenus = null;
            DBHelper<MenuModel> dbHelper = null;
            try
            {
                // get Parent Menu
                parentMenus = new List<MenuModel>();
                string parentFilter = "webmenu.IsParentMenu = 1";

                string menuString = @"select distinct webmenu.*, webmenulanguage.Description MenuName from webmenu
                    inner join webmenulanguage on webmenulanguage.MenuID = webmenu.MenuID and webmenulanguage.LanguageID = 1
                    where  ({1})";

                string menuQuery = string.Format(menuString, parentFilter);

                result = dbHelper.GetQueryList(menuQuery, ref parentMenus);

                //  Get Child menus
                if (result == GlobalErrors.Success && parentMenus != null && parentMenus.Count > 0)
                {
                    childMenus = new List<MenuModel>();
                    parentFilter = "webmenu.IsParentMenu = 0";

                    //menuQuery = string.Format(menuString, currenctOperator.OperatorId, parentFilter);
                    //dbHelper = new DBHelper<MenuModel>();
                    //result = dbHelper.GetQueryList(menuQuery, ref childMenus);

                    //if (childMenus != null && childMenus.Count > 0)
                    //{
                    //    foreach (MenuModel parentMenu in parentMenues)
                    //    {
                    //        IEnumerable<MenuModel> menusQuery =
                    //        from child in childMenus
                    //        where child.ParentMenuID == parentMenu.MenuID
                    //        select child;

                    //        // Adding all childs to menu
                    //        parentMenu.ChildMenus = menusQuery;
                    //    }
                    //}
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }

        public static GlobalErrors Login(string username, string password, ref OperatorModel operatorModel, bool isCRM, string remoteIpAddress = "")
        {
            DBHelper<OperatorModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                operatorModel = new OperatorModel();
                dbHelper = new DBHelper<OperatorModel>();
                string filter = string.Empty;
                if(isCRM)
                {
                    filter = @"inner join OperatorSecurityGroup on OperatorSecurityGroup.OperatorID = Operator.OperatorID 
                            inner join CRMSecurityGroup on CRMSecurityGroup.SecurityGroupID = OperatorSecurityGroup.SecurityGroupID";
                }
                var operatorQuery = string.Format(@"Select top(1) Operator.OperatorID, employee.EmployeeID, Employee.EmployeeCode, EmployeeLanguage.Description EmployeeName,Employee.Email, employee.OrganizationID, Employee.EmployeeTypeID
                from Operator
                inner join EmployeeOperator on EmployeeOperator.OperatorID = Operator.OperatorID
                inner join Employee on Employee.EmployeeID = EmployeeOperator.EmployeeID
                inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = 1
                {2}
                Where Operator.OperatorName = '{0}' and Operator.OperatorPassword = '{1}'", username, password, filter);
                result = dbHelper.GetQuerySingle(operatorQuery, ref operatorModel);
                if (result == GlobalErrors.Success && operatorModel != null)
                {
                    operatorModel.EncryptedEmployeeId = EncryptionManager.Instance.EncryptData(operatorModel.EmployeeId.ToString());
                    operatorModel.EncryptedOperatorId = EncryptionManager.Instance.EncryptData(operatorModel.OperatorId.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ClearFailureLoggings(int operatorID)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format(@"UPDATE OperatorLoginFailure SET IsCleared = 1 WHERE OperatorID = {0}", operatorID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors GetlandingMenus(ref OperatorModel operatorModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                MenuModel landingMenu = null;
                result = _employeeManager.GetLandingMenu(ref landingMenu, operatorModel.OperatorId);
                operatorModel.LandingMenu = landingMenu;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetMenus(ref OperatorModel operatorModel, ref List<MenuModel> AllAvailableMenus, ref List<MenuModel> addedMenus, int langId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = _employeeManager.CashOperatorMenus(null, ref AllAvailableMenus, operatorModel, ref addedMenus, -1, langId, FormMode.None);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetExternalURLs(ref List<ExternalURLModel> externalURLs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ExternalURLModel> dBHelper = new DBHelper<ExternalURLModel>();
                string query = "Select * from ExternalURLs";
                result = dBHelper.GetQueryList(query, ref externalURLs);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool IsOperatorExists(string operatorName, ref int operatorID)
        {
            Object field = null;
            operatorID = -1;
            bool isOperatorExists = false;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format("SELECT OperatorID FROM  Operator WHERE OperatorName = '{0}'", operatorName);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    operatorID = int.Parse(field.ToString());
                if (operatorID != -1)
                    isOperatorExists = true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isOperatorExists;
        }
        public bool IsDeviceTokenExists(int EmployeeId)
        {
            Object field = null;
            int operatorID = -1;
            bool isOperatorExists = false;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format("SELECT EmployeeId FROM  SupervisorDeviceToken WHERE EmployeeId = '{0}'", EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                    operatorID = int.Parse(field.ToString());
                if (operatorID != -1)
                    isOperatorExists = true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isOperatorExists;
        }

        public bool IsUserBlocked(int operatorID, int numberOfFailedLogin)
        {
            Object field = null;
            int count = 0;
            bool isUserBlocked = false;
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper;
            try
            {
                dbHelper = new DBHelper<string>();
                var query = string.Format(@"SELECT COUNT(*) FROM  OperatorLoginFailure WHERE OperatorID = {0} AND IsCleared = 0", operatorID);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && field != DBNull.Value)
                    count = Convert.ToInt32(field);
                if (count >= numberOfFailedLogin)
                {
                    isUserBlocked = true;
                    query = string.Format(@"UPDATE Operator SET IsLocked = 1 WHERE OperatorID = {0}", operatorID);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUserBlocked;
        }

        public string ReadConfigurationValue(string configName)
        {
            DBHelper<string> dBHelper = null;
            try
            {
                object value = null;
                dBHelper = new DBHelper<string>();
                string query = string.Format(@"select KeyValue from configuration where KeyName='{0}'", configName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref value);
                if (result == GlobalErrors.Success && value != null && !string.IsNullOrEmpty(value.ToString()))
                {
                    return value.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return string.Empty;
        }

        public GlobalErrors RecordLoginStatus(string remoteIpAddress, string operatorName, string password, string deviceInfo, bool isLoggedIn)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = new DBHelper<string>();
            Object count = 0;
            int counter = -1;
            bool isOperatorExists = false;
            int operatorID = -1;
            string query = string.Empty;
            try
            {
                isOperatorExists = IsOperatorExists(operatorName, ref operatorID);
                if (isOperatorExists)
                { 
                    query = string.Format(@"INSERT INTO OperatorLoginHistory
                                SELECT {0}, ISNULL(MAX(OperatorCounter) + 1, 1), {2}, '{3}', {4}, {5} FROM  OperatorLoginHistory WHERE OperatorID = {0}",
                            operatorID, counter, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), deviceInfo, isLoggedIn ? 0 : 1, isLoggedIn ? 1 : 0);
                    result = dbHelper.ExecuteNonQuery(query);

                    if (!isLoggedIn && result == GlobalErrors.Success)
                    {
                        query = string.Format(@"INSERT INTO OperatorLoginFailure
                                SELECT {0}, ISNULL(MAX(OperatorCounter) + 1, 1), {2}, '{3}','{4}',{5} FROM  OperatorLoginFailure WHERE OperatorID = {0}",
                            operatorID, counter, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), password, deviceInfo, 0);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                } else
                { //insert into new table
                    query = string.Format(@"INSERT INTO InvalidOperatorHistory(LoginDate, UserName, Password, IPaddress, DeviceInfo) values ({0}, '{1}', '{2}', '{3}', '{4}')",
     LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), operatorName, password, remoteIpAddress, deviceInfo);
                    result = dbHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public bool IsUsernameLocked(string username)
        {
            DBHelper<int> dbHelper = null;
            bool isUserLocked = false;
            try
            {
                object field = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"SELECT COUNT(*)
                FROM  OperatorLoginFailure
                WHERE OperatorID = (select OperatorID from Operator where OperatorName = '{0}')
                AND IsCleared = 0
                HAVING COUNT(*) >= (Select CAST(KeyValue as INT) from Configuration where Keyname = 'NumberOfFailedLogin' AND CAST(KeyValue as INT) > 0)", username);
                GlobalErrors result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                    {
                        isUserLocked = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return isUserLocked;
        }

        public GlobalErrors SimpleLogin(string username, string password, string deviceInfo, ref OperatorModel operatorModel, ref string errorMessage, int langId, string remoteIpAddress = "" , bool CheckEnableActiveDirectoryLogin = false , bool ValidADLogin = false)
        {
            DBHelper<OperatorModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string encryptedPassword = string.Empty;
            string passwordValidation = string.Empty;
            bool isOnHold = false;
            try
            {
                if (IsUsernameLocked(username))
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Account_Suspended, langId);
                    result = GlobalErrors.Error;
                    return result;
                }                
                operatorModel = new OperatorModel();
                dbHelper = new DBHelper<OperatorModel>();
                encryptedPassword = EncryptionManager.Instance.EncryptPassword(password);

                if (!CheckEnableActiveDirectoryLogin)
                {
                    passwordValidation = $@" and Operator.OperatorPassword = '{encryptedPassword}' ";
                }

                var operatorQuery = string.Format(@"Select top(1) Operator.OperatorID,
				isnull(Employee.Inactive,0) Inactive, isnull(IsLocked,0) IsLocked,Operator.PasswordChangeDate,
				employee.EmployeeID, Employee.EmployeeCode, EmployeeLanguage.Description EmployeeName,Employee.Email, employee.OrganizationID, Employee.EmployeeTypeID
				,Organization.GLN OrgGLN , Operator.ActiveDirectoryLogin , Operator.OperatorPassword
				from Operator
				inner join EmployeeOperator on EmployeeOperator.OperatorID = Operator.OperatorID
				inner join Employee on Employee.EmployeeID = EmployeeOperator.EmployeeID
				inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = 1
				left join Organization on Organization.OrganizationID=Employee.OrganizationID               
				Where Operator.OperatorName = '{0}' {1} AND Operator.LoginTypeID = 1", username, passwordValidation);
                result = dbHelper.GetQuerySingle(operatorQuery, ref operatorModel);
                if (result == GlobalErrors.Success)
                {
                    if(CheckEnableActiveDirectoryLogin)
                    {
                        if (operatorModel.ActiveDirectoryLogin && operatorModel.EmployeeTypeId != (int)EmployeeTypes.Salesperson)
                        {
                            if (!ValidADLogin)
                            {
                                return result = GlobalErrors.Error; // Domain Credentials are incorrect
                            }
                        }
                        else
                        {
                            if (encryptedPassword != operatorModel.OperatorPassword)
                            {
                                errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);
                                return result = GlobalErrors.Error; // operator Credentials are incorrect
                            }
                        }
                        
                    } 
                    
                    result = RecordLoginStatus(remoteIpAddress, username, password, deviceInfo, operatorModel != null ? true : false);
                    if (result == GlobalErrors.Success && operatorModel != null)
                    {
                        //Read Config on All Levels 
                        _requestRepository.CurrentOperator = operatorModel;
                        operatorModel.ChangePasswordOnLogin = _requestRepository.Configurations.ForceChangeOperatorPasswordAtFirstLogin;
                        operatorModel.PasswordExpiryDays = _requestRepository.Configurations.PasswordExpiryDays;
                        operatorModel.NumberOfFailedLogin =  _requestRepository.Configurations.NumberOfFailedLogin;
                        if (operatorModel.IsLocked)
                        {
                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Account_Suspended, langId);
                            result = GlobalErrors.Error;
                            return result;
                        }
                        if (operatorModel.Inactive)
                        {
                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Employee_Is_Inactive, langId);
                            result = GlobalErrors.Error;
                            return result;
                        } 
                        result = _employeeManager.CheckIfEmployeeIsOnHold(operatorModel.EmployeeId, ref isOnHold);
                        if (isOnHold)
                        {
                            errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_The_Destination_Employee_Is_On_Hold, langId);
                            result = GlobalErrors.Error;
                            return result;
                        }
                        //loginTypeID = GetLoginTypeID(operatorModel.OperatorId);
                        //if (loginTypeID != 1)
                        //{
                        //    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Operator_Not_Authorized_To_Login, langId);
                        //    result = GlobalErrors.Error;
                        //    return result;
                        //}
                        if (operatorModel.NumberOfFailedLogin > 0)
                        {
                            if (IsUserBlocked(operatorModel.OperatorId, operatorModel.NumberOfFailedLogin))
                            {
                                errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Account_Suspended, langId);
                                result = GlobalErrors.Error;
                                return result;
                            }
                            else
                            {
                                result = ClearFailureLoggings(operatorModel.OperatorId);
                                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    result = GlobalErrors.Success;
                                }
                            }
                        }
                        else
                        {
                            result = ClearFailureLoggings(operatorModel.OperatorId);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                result = GlobalErrors.Success;
                            }
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        // check password validations in case not AD login
                        if (!CheckEnableActiveDirectoryLogin || !operatorModel.ActiveDirectoryLogin)
                        {
                            if (operatorModel.ChangePasswordOnLogin && operatorModel.PasswordChangeDate.HasValue == false)// == null || operatorModel.PasswordChangeDate == DateTime.MinValue))
                            {
                                errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Must_Be_Changed_On_First_Login, langId);
                                result = GlobalErrors.PasswordShouldBeChanged;
                                return result;
                                //isNeedToChangePassword = true;
                            }
                            if (operatorModel.PasswordExpiryDays != -1)
                            {
                                if (operatorModel.PasswordChangeDate.HasValue == false)// && operatorModel.PasswordChangeDate == DateTime.MinValue)
                                {
                                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Expired, langId);
                                    result = GlobalErrors.PasswordShouldBeChanged;
                                    return result;
                                }
                                else
                                {
                                    if (operatorModel.PasswordChangeDate.Value.AddDays(operatorModel.PasswordExpiryDays) <= DateTime.Now)
                                    {
                                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Password_Expired, langId);
                                        result = GlobalErrors.PasswordShouldBeChanged;
                                        return result;
                                    }
                                }
                            }
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                    else
                    {
                        errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Invalid_UserName_Password, langId);

                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetEmployeeOrganizationAccess(ref List<OrganizationModel> operatorOrganizations , int employeeId)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"	SELECT Organization.OrganizationID,
								ISNULL(Organization.OrganizationCode, '--') + ' - ' + ISNULL(OrganizationLanguage.Description, '--') AS OrganizationCodeName
								FROM EmployeeOrganization
								Inner JOIN Organization ON Organization.OrganizationID = EmployeeOrganization.OrganizationID 
								Inner JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = EmployeeOrganization.OrganizationID AND OrganizationLanguage.languageid = {0}
								WHERE EmployeeOrganization.EmployeeID = {1}", _requestRepository.LanguageId , employeeId);
                result = dbHelper.GetQueryList(query, ref operatorOrganizations);                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorOrganizations = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateLoginStatus(string deviceInfo,int operatorId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                string countQuery = string.Format(@" select count(*) from  (Select top (1) OperatorCounter from OperatorLoginHistory where OperatorID = {0} and MachineName = '{1}'  and IsLoggedIn = 1
                order by LoginDate desc) as c", operatorId, deviceInfo);
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString().Trim()) > 0)
                {
                    string query = string.Format(@"
                        update OperatorLoginHistory set IsLoggedIn = 0 where OperatorCounter =
                        (Select top (1) OperatorCounter from OperatorLoginHistory where OperatorID = {0} and MachineName = '{1}'  and IsLoggedIn = 1
                        order by LoginDate desc)", operatorId, deviceInfo);
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetNumberofLoginOperator(ref object objField, int operatorId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                string countQuery = string.Format(@"
                SELECT OperatorCounter 
                FROM OperatorLoginHistory 
                WHERE OperatorID = {0} 
                AND IsLoggedIn = 1;
               ", operatorId);
               
                result = dbHelper.ExecuteScalar(countQuery, ref objField);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion [SONIC]

        #region [ECHO CUSTOMER APP]

        public static GlobalErrors EchoLogin(string username, string password, ref List<EchoOperatorModel> operatorList, int langId)
        {
            DBHelper<EchoOperatorModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                operatorList = new List<EchoOperatorModel>();
                dbHelper = new DBHelper<EchoOperatorModel>();
                var operatorQuery = string.Format(@"SELECT o.OperatorID, co.CustomerID,co.email, co.OutletID, co.phone, CASE WHEN (co.Inactive = 1 OR o.IsLocked = 1 OR c.New = 1) THEN 0 ELSE 1 END Active, co.CustomerCode Code, col.Description Name, co.Taxeable Taxable, co.CustomerTypeID,isnull(IC.Balance,0.0) ICashBalance
                        FROM CustomerOutlet co
                        INNER JOIN Customer c ON c.CustomerID = co.CustomerID
                        INNER JOIN CustomerOutletAccess coa ON coa.CustomerID = co.CustomerID AND coa.OutletID = co.OutletID
						left join ICashBalance IC on IC.CustomerID = c.CustomerID and CO.OutletID = IC.OutletID
                        LEFT JOIN CustomerOutletLanguage col ON col.CustomerID = co.CustomerID AND col.OutletID = co.OutletID AND col.LanguageID = {0} 
                        INNER JOIN Operator o ON o.OperatorID = coa.OperatorID
                        WHERE o.OperatorName = '{1}'  COLLATE SQL_Latin1_General_CP1_CS_AS  AND o.OperatorPassword = '{2}'  COLLATE SQL_Latin1_General_CP1_CS_AS ", langId, username.Replace("'", "''"), EncryptionManager.Instance.EncryptPassword(password));
                result = dbHelper.GetQueryList(operatorQuery, ref operatorList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorList = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetEchoCachedData(int customerID, int outletID,int organizationID, ref EchoOperatorModel model)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EchoOperatorModel> dBHelper = null;
            try
            {
                string organizationFilter = String.Empty;
                if(organizationID != -1)
                {
                    organizationFilter = string.Format(@" And Employee.OrganizationID = {0} ", organizationID);
                }
                dBHelper = new DBHelper<EchoOperatorModel>();
                string query = string.Format(@"DECLARE @temp Table (EmpId INT, OrgID INT, OperatorID INT, VehicleID INT, PriorityNum INT, NUMDigit INT, CurCode Nvarchar(100), NumberOfStockDigits INT);
                                INSERT INTO @temp
                                SELECT Employee.EmployeeID, Employee.OrganizationID, eo.OperatorID, ev.VehicleID,
                                CASE WHEN Employee.EmployeeTypeID = 10 THEN 1 ELSE
                                CASE WHEN Employee.EmployeeTypeID = 6 THEN 2 ELSE
                                CASE WHEN Employee.EmployeeTypeID = 2 THEN 3 ELSE
                                CASE WHEN Employee.EmployeeTypeID = 3 THEN 4 ELSE 5 END END END END as RowNum,
                                ISNULL(c.KeyValue, 2) NUMDigit, ISNULL(Currency.Code, '$') Currency, ISNULL(conStock.KeyValue, 2) NumberOfStockDigits
                                FROM Employee
							    LEFT JOIN EmployeeTerritory ON Employee.EmployeeID = EmployeeTerritory.EmployeeID
							    LEFT JOIN CustOutTerritory ON CustOutTerritory.TerritoryID = EmployeeTerritory.TerritoryID
                                LEFT JOIN EmployeeOperator eo ON eo.EmployeeID = Employee.EmployeeID
                                LEFT JOIN EmployeeVehicle ev ON ev.EmployeeID = Employee.EmployeeID 
                                LEFT JOIN Configuration c ON c.KeyName = 'NumberOfDigits' AND c.EmployeeID = -1
                                LEFT JOIN Configuration conStock ON c.KeyName = 'NumberOfStockDigits' AND conStock.EmployeeID = -1
                                LEFT JOIN Currency ON Currency.Base = 1
                                WHERE (CustOutTerritory.CustomerID = {0} AND CustOutTerritory.OutletID = {1}  {2}) OR (CustOutTerritory.CustomerID IS NULL AND Employee.EmployeeID = 0);
                                DECLARE @EmpID INT = -1;
                                DECLARE @VanID INT = -1;
                                DECLARE @MainDiviID INT = -1;
                                DECLARE @EmpOrgIDs NVARCHAR(2000) = '';
                                DECLARE @EmpDivIDs NVARCHAR(2000) = '';
                                DECLARE @EmpLoadingWHs NVARCHAR(2000) = '';
                                SELECT Top(1) @EmpID = EmpID, @VanID = VehicleID FROM @temp ORDER BY PriorityNum;
								SELECT TOP(1) @MainDiviID = MainDivisionID FROM (SELECT MainDivisionID From EmployeeDivision ED inner join CustomerAppMainDivision MD on MD.DivisionID = ED.DivisionID where ED.EmployeeID = @EmpID) MainDiv

                                IF(@EmpID > -1)
                                BEGIN
	                                --Read Div IDs
	                                SELECT @EmpDivIDs = @EmpDivIDs + CONVERT(NVARCHAR(10), EmployeeDivision.DivisionID) + ', ' FROM EmployeeDivision
                                    WHERE EmployeeID = @EmpID;
	                                SET @EmpDivIDs = SUBSTRING(@EmpDivIDs, 0, LEN(@EmpDivIDs));
	                                IF(@VanID > -1)
	                                BEGIN
		                                --Read Loading WHs IDs
		                                SELECT @EmpLoadingWHs = @EmpLoadingWHs + CONVERT(NVARCHAR(10), WarehouseID) + ', ' FROM VehicleLoadingWh WHERE VehicleID = @VanID;
		                                SET @EmpLoadingWHs = SUBSTRING(@EmpLoadingWHs, 0, LEN(@EmpLoadingWHs));
	                                END
	                                SELECT EmpId RouteEmployeeId, OrgID RouteOrganizationId, OperatorID RouteOperatorId, @EmpDivIDs as DivisionIds, @EmpLoadingWHs RouteLoadingWarehouseIds, VehicleID as RouteVehicleId, {0} as CustomerId, {1} as OutletId, NUMDigit as NumberOfDigit, CurCode as CurrencyCode, @MainDiviID MainDivisionId, NumberOfStockDigits FROM @temp
	                                WHERE EmpId = @EmpID;
                                END", customerID, outletID, organizationFilter);
                result = dBHelper.GetQuerySingle(query, ref model);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                model = null;
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public static GlobalErrors GetItemOfferList(EchoOperatorModel loginOperator,  ref List<ItemOffers> itemOffers, string ForceCustomerOrganizationSelection)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string organizationFilter = string.Empty;
            string echoForceOrgSelectionFilter = string.Empty;
            try
            {
                DBHelper<ItemOffers> dBHelper = new DBHelper<ItemOffers>();
                itemOffers = new List<ItemOffers>();
                if (!string.IsNullOrEmpty(ForceCustomerOrganizationSelection) && ForceCustomerOrganizationSelection.ToLower() == "true")
                { 
                    echoForceOrgSelectionFilter = string.Format(@" And EmployeeOrganization.OrganizationID =  {0}", loginOperator.RouteOrganizationId);
                }

                string query = string.Format(@"
                                DECLARE @Table as table(ItemId int, PromotionId INT);
                                INSERT INTO @Table 
                                SELECT DISTINCT Pack.ItemID, Promotion.PromotionID
                                FROM Promotion
                                INNER JOIN CustomerPromotion ON
                                CustomerPromotion.PromotionID = Promotion.PromotionID
                                AND ((AllCustomers = 1)
                                OR concat(CustomerPromotion.CustomerID, '-', CustomerPromotion.OutletID) in ({0})
                                OR (CustomerGroupID in (select GroupID from CustomerOutletGroup where concat(CustomerID, '-', OutletID) in ({0})))
                                OR (SubChannelID in (Select SubChannelID From CustomerGroup Where CustomerGroup.GroupID  IN (select GroupID from CustomerOutletGroup where concat(CustomerID, '-', OutletID) in ({0})))))
                                INNER JOIN CustomerPromotionOrganization cpo ON cpo.PromotionID = Promotion.PromotionID AND cpo.OrganizationID IN (SELECT OrganizationID FROM EmployeeOrganization WHERE EmployeeID in ({1}) {3})
                                INNER JOIN PromotionOptionDetail Details ON Details.PromotionID = Promotion.PromotionID AND Details.PromotionOptionTypeID = 1
                                INNER JOIN Pack on Pack.PackID = Details.PackID  
                                INNER JOIN PromotionCustomerApp on PromotionCustomerApp.PromotionId = Promotion.PromotionId
                                INNER JOIN item on item.ItemID = Pack.ItemID
                                INNER JOIN ItemCategory ic on ic.ItemCategoryID = Item.ItemCategoryID
                                INNER JOIN EmployeeDivision ED on ED.DivisionID = ic.DivisionID and ed.DivisionID in( {4} )
                                WHERE   Promotion.OfferAppliedOptions like '%{5}%' And
                                (Promotion.Inactive IS NULL OR  Promotion.Inactive = 0)
                                AND  (Promotion.IsGiftVoucher = 0 OR Promotion.IsGiftVoucher IS NULL)
                                AND  (Promotion.FreeGoodsTypeID <> 3 or Promotion.FreeGoodsTypeID is null)
                                AND  Promotion.PromotionType <> 4
                                AND  (Promotion.StartDate <= {2})
                                AND  (Promotion.EndDate   >= {2})
                                AND  (promotion.IsDeleted=0)
                                AND  (Promotion.PromotionID not in (select PromotionID from CustomerPromotionExclusion where concat(CustomerID, '-', OutletID) in ({0})))
                                AND  (promotion.IsLoyaltyPromotion = 0)

                                SELECT 
                                   SS.ItemId,
                                   STUFF((SELECT ', ' + CONVERT(NVARCHAR(10), PromotionId) 
                                          FROM @Table US
                                          WHERE US.ItemId = SS.ItemId
                                          FOR XML PATH('')), 1, 1, '') OfferIds
                                FROM @Table SS
                                GROUP BY SS.ItemId
                                ORDER BY 1", 
                                loginOperator.CustomerOutletIds, //0
                                loginOperator.RouteEmployeeIds, //1 
                                LocalUtilities.ParseDateToSQLString(DateTime.Now), //2
                                echoForceOrgSelectionFilter, //3
                                loginOperator.DivisionIds,//4
                                 OfferAppliedOptions.CustomerApp.GetHashCode());//5
                result = dBHelper.GetQueryList(query, ref itemOffers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                itemOffers = null;
            }
            return result;
        }
        public static GlobalErrors SaveCustomerLoginHisotry(int operatorId, CustomerLoginSource loginSource)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"INSERT INTO CustomerLoginHistory VALUES ({0}, {1}, {2})", 
                    operatorId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), loginSource.GetHashCode());
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetOrganizationsList(int operatorId, int languageId, ref List<OrganizationModel> organizationsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrganizationModel> dBHelper = null;

            try
            {
                dBHelper = new DBHelper<OrganizationModel>();

                string query = string.Format(@"SELECT DISTINCT Organization.OrganizationID, Organization.OrganizationCode + ' - ' + OrganizationLanguage.Description AS OrganizationCodeName
                    FROM     Organization
					LEFT JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = Organization.OrganizationID AND OrganizationLanguage.LanguageID = 1
                    WHERE  (Organization.OrganizationID > 1)",
                    languageId, operatorId);
                result = dBHelper.GetQueryList(query, ref organizationsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion [ECHO CUSTOMER APP]

        #region [STOREKEEPER APP]
        public static GlobalErrors StorekeeperLogin(string username, string password, ref StorekeeperOperatorModel operatorModel, int langId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<StorekeeperOperatorModel> dbHelper = new DBHelper<StorekeeperOperatorModel>();
                operatorModel = null;
                var operatorQuery = string.Format(@"SELECT E.EmployeeID EmployeeId, E.Inactive , O.OperatorID OperatorId
                                    FROM Operator O
                                    INNER JOIN EmployeeOperator EO ON O.OperatorID = EO.OperatorID
                                    INNER JOIN EMPLOYEE E ON E.EmployeeID = EO.EmployeeID
                                    WHERE O.OperatorName = '{1}' AND O.OperatorPassword = '{2}' AND  E.EmployeeTypeID = {3} "
                                , langId, username.Replace("'", "''"), EncryptionManager.Instance.EncryptPassword(password), EmployeeTypes.StoreKeeper.GetHashCode());
                result = dbHelper.GetQuerySingle(operatorQuery, ref operatorModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetStorekeeperMenus(int operatorId, ref List<string> MenuIds)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<string> dBHelper = new DBHelper<string>();
                MenuIds = new List<string>();
                string query = string.Format(@"select distinct WebMenu.MenuID from OperatorSecurityGroup 
                                INNER JOIN WebSecurityGroupPrivilege ON WebSecurityGroupPrivilege.SecurityGroupID = OperatorSecurityGroup.SecurityGroupID
                                INNER JOIN WebMenu ON WebMenu.MenuID = WebSecurityGroupPrivilege.MenuID
                                where OperatorSecurityGroup.Operatorid = {0} AND ParentMenuID = '1400'", operatorId);
                result = dBHelper.GetQueryList(query, ref MenuIds);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetStorekeeperCachedData(int employeeId, int languageId, ref StorekeeperOperatorModel model)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<StorekeeperOperatorModel> dBHelper = new DBHelper<StorekeeperOperatorModel>();
                string query = string.Format(@"DECLARE @DivIds NVARCHAR(2000) = '';
                                               DECLARE @OrgIds NVARCHAR(2000) = '';

                                               SELECT @DivIds = @DivIds + CONVERT(NVARCHAR(10), EmployeeDivision.DivisionID) + ', ' FROM EmployeeDivision
                                               WHERE EmployeeID = {0};
                                               SET @DivIds = SUBSTRING(@DivIds, 0, LEN(@DivIds));


                                               SELECT @OrgIds = @OrgIds + CONVERT(NVARCHAR(10), EmployeeOrganization.OrganizationID) + ', ' FROM EmployeeOrganization
                                               WHERE EmployeeID = {0};
                                               SET @OrgIds = SUBSTRING(@OrgIds, 0, LEN(@OrgIds));


                                               SELECT Employee.EmployeeID,Employee.OrganizationID, Employee.EmployeeCode, EL.Description EmployeeName, @OrgIds OrgnizationIds, @DivIds DivisionIds FROM Employee 
                                               LEFT OUTER JOIN EmployeeLanguage EL ON Employee.EmployeeID = EL.EmployeeID AND EL.LanguageID = {1}
                                               WHERE Employee.EmployeeID = {0}", employeeId, languageId);
                result = dBHelper.GetQuerySingle(query, ref model);
                if(result == GlobalErrors.Success)
                {
                    model.ConfigurationList = ConfigurationManager.GetStoreKeeperConfiguartionList(employeeId);
                    model.DivisionList = ItemManager.GetDivisionList(model.DivisionIds, languageId);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors CheckDeviceLic(string deviceSerial, ref bool isLicensed)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                isLicensed = false;
                string encFilePath = Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase), "Devices.enc");
                encFilePath = encFilePath.TrimStart("file:\\".ToCharArray());
                if (System.IO.File.Exists(encFilePath))
                {
                    if (InCube.Sync.Licensing.BackSyncLicense.IsDeviceLisenced(encFilePath, deviceSerial))
                    {
                        isLicensed = true;
                        result = GlobalErrors.Success;
                    }
                    else
                    {
                        isLicensed = false;
                        result = GlobalErrors.DevicesNotLicenced;
                    }
                }
                else
                {
                    isLicensed = false;
                    result = GlobalErrors.DevicesNotLicenced;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result; 
            }
            return result;
        }



        #endregion
        public static GlobalErrors GetCRMMenus(ref OperatorModel operatorModel, ref List<CRMMenuModel> teleRepMenus)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                result = EmployeeManager.GetCRMMenus(null, ref teleRepMenus, operatorModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorModel = null;
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetAllSessions(ref List<SessionInfoModel> sessionLists)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SessionInfoModel> dBHelper = new DBHelper<SessionInfoModel>();
                string query = string.Format(@"select SessionId ,  Employee.EmployeeCode+' - '+ EmployeeLanguage.Description EmployeeCodeName , 
					ExpiryDate , MachineName , browserName , ConcurrentSessions.EmployeeId , ConcurrentSessions.ModuleId
                    from ConcurrentSessions
					inner join Employee on Employee.EmployeeID = ConcurrentSessions.EmployeeId
					left join EmployeeLanguage	ON EmployeeLanguage.EmployeeID = ConcurrentSessions.EmployeeId AND LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref sessionLists);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        } 
        
        public GlobalErrors InsertIntoConcurrentSessionsLogsHistory(SessionInfoModel sessionInfoModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SessionInfoModel> dBHelper = new DBHelper<SessionInfoModel>();
                string query = string.Format(@"INSERT INTO ConcurrentSessionsLogs (SessionId , EmployeeId , ModuleId , MachineName , BrowserName , DeletedBy , DeletedDate) 
                VALUES ( '{0}' , {1} , {2} , '{3}' , '{4}' , {5} , {6})", 
                sessionInfoModel.SessionId , // 0
                sessionInfoModel.EmployeeId , // 1
                sessionInfoModel.ModuleId ,  // 2
                sessionInfoModel.MachineName , // 3
                sessionInfoModel.BrowserName , // 4
                _requestRepository.CurrentOperator.EmployeeId, // 5
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) // 6
                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}