﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using static Sonic.Web.Model.CoreDataBaseConstants;

namespace Sonic.Web.Core
{
    public class MasterDataManager
    {
        private readonly IRequestRepository _requestRepository;

        public MasterDataManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;    
        }
        public GlobalErrors GetOrganizationList(int excludedOrganizationId, ref List<OrganizationModel> organizationList , bool isFromStaffEmployeeOrgAccess = false)
        {
            return GetOrganizationList(excludedOrganizationId, false, false, ref organizationList , isFromStaffEmployeeOrgAccess);
        }
        public GlobalErrors GetOrganizationList(int excludedOrganizationId, bool showCompanyOrganizationOnly, bool showDistributorOrganizationsOnly, ref List<OrganizationModel> organizationList , bool isFromStaffEmployeeOrgAccess)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                organizationList = new List<OrganizationModel>();
                dbHelper = new DBHelper<OrganizationModel>();
                string filter = string.Empty;
                bool OrganizationAcessEmp = _requestRepository.Configurations.ForceOrganizationSelectionOnLogin && isFromStaffEmployeeOrgAccess;
                if (showCompanyOrganizationOnly)
                {
                    filter = " AND Organization.ParentOrganizationID IS NULL ";
                }
                if (showDistributorOrganizationsOnly)
                {
                    filter += " AND Organization.ParentOrganizationID IS NOT NULL ";
                }
                string query = string.Format(@"SELECT Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM Organization
                left outer join OrganizationLanguage  on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                WHERE Organization.OrganizationID in ({1}) and Organization.OrganizationID not in ({2}) {3} ",
                _requestRepository.LanguageId, //0
                OrganizationAcessEmp ? _requestRepository.CurrentOperator.OriginalOrganizationAccess : _requestRepository.CurrentOperator.OrganizationAccess, //1
                excludedOrganizationId, //2
                filter //3
                );

                result = dbHelper.GetQueryList(query, ref organizationList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                organizationList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBanks(ref List<BankModel> banksList)
        {
            DBHelper<BankModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                banksList = new List<BankModel>();
                dbHelper = new DBHelper<BankModel>();

                string query = string.Format(@"Select Bank.BankID, Bank.OrganizationId, BankLanguage.Description BankName, Bank.Code, IsNull( Bank.Code , '--') + ' ' + '-'+ ' ' + IsNull( BankLanguage.Description , '--') as BankCodeName, Bank.SwiftCode
                From Bank 
                left join BankLanguage on BankLanguage.BankID = Bank.BankID and BankLanguage.LanguageId = {0}
                left join Organization on Organization.OrganizationID = Bank.OrganizationID
                left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Organization.OrganizationID and OrganizationLanguage.LanguageID = {0}
                Where (Bank.OrganizationID is null or bank.OrganizationID = -1 or Bank.OrganizationID in ({1}))",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess //1
                );

                result = dbHelper.GetQueryList(query, ref banksList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                banksList = null;
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetSecurityGroupsList(int employeeId, int organizationId, ref List<SecurityGroupModel> securityGroupsList , bool isFromApprovalCyclePromotion = false)
        {
            DBHelper<SecurityGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string excludeAdminFilter = string.Empty;
            try
            {
                securityGroupsList = new List<SecurityGroupModel>();
                dbHelper = new DBHelper<SecurityGroupModel>();

                string orgFilter = string.Empty;
                string OrgParentsJoin = string.Empty;
                string SecurityGroupWhere = string.Empty;
                StringBuilder OrgParentsQuery = new StringBuilder();

                if(_requestRepository.CurrentOperator.EmployeeId != 0)
                {
                    if (isFromApprovalCyclePromotion)
                    {
                        OrgParentsQuery.AppendFormat(string.Format(CoreDataBaseConstants.OrgParentsQuery, organizationId));
                        OrgParentsJoin = string.Format(@" INNER JOIN @OrganizationTemp Org ON SecurityGroup.OrganizationID = Org.OrganizationID AND Org.OrganizationID IN ({0})", _requestRepository.CurrentOperator.OriginalOrganizationAccess);
                    }
                    else
                    {
                        if (organizationId > 0)
                        {
                            orgFilter = string.Format(" And SecurityGroup.OrganizationID IN ({0}) ", organizationId);
                        }
                        SecurityGroupWhere = string.Format(@"WHERE SecurityGroup.OrganizationID IN ({0}) {1}", _requestRepository.CurrentOperator.OrganizationAccess, orgFilter);
                    }
                }
               
                // No need for this line since we handle security group saving for admin from employee screen
                //if (_requestRepository.CurrentOperator.EmployeeId != 0)
                //{
                //    excludeAdminFilter = " AND SecurityGroup.SecurityGroupID <> 1";
                //}

                string getAddedSecurityGroups = string.Empty;
                if (employeeId != -1)
                {
                    getAddedSecurityGroups = string.Format(@"inner join OperatorSecurityGroup on OperatorSecurityGroup.SecurityGroupID = SecurityGroup.SecurityGroupID
                    inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID and EmployeeOperator.EmployeeID = {0}",
                    employeeId);
                }

                string query = string.Format(@"
                {4}
                Select SecurityGroup.SecurityGroupID, SecurityGroupLanguage.Description SecurityGroupName,
                IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName
               
                from SecurityGroup
                inner join SecurityGroupLanguage on SecurityGroupLanguage.SecurityGroupID = SecurityGroup.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0} 
                {5}
                {1}
                {2} {3}",
                _requestRepository.LanguageId, //0
                getAddedSecurityGroups, //1
                SecurityGroupWhere, //2                
                excludeAdminFilter, //3
                OrgParentsQuery, //4
                OrgParentsJoin // 5
                );


                result = dbHelper.GetQueryList(query, ref securityGroupsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                securityGroupsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckIfUniqueValue(string tableName, string columnName, string insertedValue, string excludedString, ref bool isUniqueValue, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            isUniqueValue = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }

                object objField = 0;
                string query = string.Format(@"SELECT Count(*) From {0} Where {1} = '{2}' {3} ",
                tableName, //0
                columnName, //1
                insertedValue.Replace("'", "''"), //2
                excludedString //3
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isUniqueValue = false;
                    }
                    else
                    {
                        isUniqueValue = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfUniqueDeviceSerial(DeviceModel device, ref bool isUniqueValue, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            isUniqueValue = true;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }

                object objField = 0;
                string query = string.Format(@"SELECT Count(*) From Device Where Serial = '{0}'",
                device.DeviceSerial.Replace("'","''")
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        if (device.IsNew || (device.OldDeviceSerial != device.DeviceSerial))
                        {
                            isUniqueValue = false;
                        }
                        else
                        {
                            if(int.Parse(objField.ToString()) > 1)
                            {
                                isUniqueValue = false;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfUniqueDescription(string tableName, string columnName, string excludedString, ref bool isUniqueValue, string descriptionLanguages)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isUniqueValue = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = 0;

                string query = string.Format(@"SELECT Count(*) From {0} Where {1} = '{2}' {3} ",
                tableName, //0
                columnName, //1
                descriptionLanguages.Replace("'", "''"), //2
                excludedString //3
                );

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()) && int.Parse(objField.ToString()) > 0)
                    {
                        isUniqueValue = false;
                    }
                    else
                    {
                        isUniqueValue = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveDevice(DeviceModel device)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Empty;

                if (device.IsNew || device.DeviceSerial == "-1")
                {
                    query = string.Format(@"Insert into  Device (Serial, OrganizationID,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,Inactive,Brand,ModelNumber,WarrantyExpiry,PurchaseDate,AvailableForUsage)
                    values ('{0}',{1},{2},{3},{2},{3},{4},{5},{6},{7},{8},{9})",
                    device.DeviceSerial.Replace("'", "''"), //0
                    device.OrganizationId, //1
                    _requestRepository.CurrentOperator.EmployeeId, //2
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //3
                    0, //4
                    !string.IsNullOrEmpty(device.Brand) ? "'" + device.Brand + "'" : "NULL",//5
                    !string.IsNullOrEmpty(device.ModelNumber) ? "'" + device.ModelNumber + "'" : "NULL",//6
                    device.WarrantyExpiryDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(device.WarrantyExpiryDateModel.Date) : "NULL",//7
                    device.PurchaseDateDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(device.PurchaseDateDateModel.Date) : "NULL", //8
                    device.AvailableForUsage ? "1" : "0"//9
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                {
                    query = string.Format(@"Update Device set OrganizationID ={0} , UpdatedBy = {1},UpdatedDate = {2}, Inactive = {4},Brand = {5},ModelNumber = {6},
                                                              WarrantyExpiry = {7} ,PurchaseDate = {8},AvailableForUsage = {9} where Serial = '{3}' ",
                    device.OrganizationId, //0
                    _requestRepository.CurrentOperator.EmployeeId, //1
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                    device.DeviceSerial.Replace("'", "''"), //3
                    device.Inactive ? 1 : 0, //4
                    !string.IsNullOrEmpty(device.Brand) ? "'" + device.Brand + "'" : "NULL",//5
                    !string.IsNullOrEmpty(device.ModelNumber) ? "'" + device.ModelNumber + "'" : "NULL",//6
                    device.WarrantyExpiryDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(device.WarrantyExpiryDateModel.Date) : "NULL",//7
                    device.PurchaseDateDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(device.PurchaseDateDateModel.Date) : "NULL", //8
                    device.AvailableForUsage ? "1" : "0"//9
                    );

                    result = dbHelper.ExecuteNonQuery(query);

                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from DeviceLanguage where Serial = '{0}'",
                        device.DeviceSerial //0
                        );

                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = GlobalErrors.Success;
                        }
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage language in device.TextLanguage)
                    {
                        query = string.Format(@"Insert into DeviceLanguage (Serial, LanguageID, Description,Remarks)  values ('{0}',{1},'{2}',{3})", device.DeviceSerial.Replace("'", "''"), language.LanguageId, language.Description.Equals("") ? device.DeviceName.Replace("'", "''") : language.Description.Replace("'", "''"), !string.IsNullOrEmpty(device.Remark) ? "'" + device.Remark + "'" : "NULL");
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                dbHelper = null;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetDevicesList(int employeeId, int organizationId, bool getFreeDevicesOnly, ref List<DeviceModel> devicesList)
        {
            DBHelper<DeviceModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                devicesList = new List<DeviceModel>();
                dbHelper = new DBHelper<DeviceModel>();
                string freeDevicesJoin = string.Empty;
                string freeDevicesCondition = string.Empty;
                string organizationidCondition = string.Empty;

                if (getFreeDevicesOnly)
                {
                    freeDevicesJoin = " left outer join EmployeeDevice on EmployeeDevice.DeviceSerial = device.Serial ";
                    freeDevicesCondition = string.Format(" and (EmployeeDevice.EmployeeID is null or EmployeeDevice.EmployeeID = -1 or EmployeeDevice.EmployeeID = {0}) ", employeeId);
                }
                if (organizationId > 0)
                {
                    organizationidCondition = string.Format(" and (Device.OrganizationID = {0}) ", organizationId);
                }

                string query = string.Format(@"select device.serial DeviceSerial,devicelanguage.description DeviceName,
                IsNull( devicelanguage.description , '--') + ' ' + '-'+ ' ' + IsNull( device.Serial , '--') as DeviceNameSerial
                from device 
                inner join devicelanguage on device.serial = devicelanguage.serial And devicelanguage.languageid = {0}
                {2}
                where device.organizationid in ({1}) {3} {4} ",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess, //1
                freeDevicesJoin, //2
                freeDevicesCondition, //3
                organizationidCondition //4
                );

                result = dbHelper.GetQueryList(query, ref devicesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                devicesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveBarcodeTemplate(BarcodeTemplateModel templateObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            int sequence = 0;
            int templateLength = 0;
            try
            {
                foreach (TemplateFieldModel field in templateObj.TemplateFieldsList)
                {
                    if (field.FieldId == BarcodeTemplateFields.BatchNumber.GetHashCode() || field.FieldId == BarcodeTemplateFields.ExpiryDate.GetHashCode()
                        || field.FieldId == BarcodeTemplateFields.GTIN.GetHashCode() || field.FieldId == BarcodeTemplateFields.Serial.GetHashCode() || field.FieldId == BarcodeTemplateFields.ProductionDate.GetHashCode())
                        templateLength += field.FieldLength + 2;
                    else
                        if (field.FieldId == BarcodeTemplateFields.GLN.GetHashCode())
                        templateLength += field.FieldLength + 3;
                }
                dBHelper = new DBHelper<int>();
                templateObj.TemplateId = GetMaxID(CoreDataBaseConstants.QueryColumnsNames.TemplateID, CoreDataBaseConstants.TableNames.BarcodeTemplate, dBHelper);
                dBHelper.BeginTransaction();
                string query = string.Format(@"Insert into BarcodeTemplate (TemplateID, TemplateCode, Length)
                values({0},'{1}',{2})",
                templateObj.TemplateId, //0
                templateObj.TemplateCode.Replace("'", "''"),//1
                templateLength //2
                );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    foreach (TextLanguage language in templateObj.TemplateDescriptionLanguages)
                    {
                        query = string.Format(@"insert into BarcodeTemplateLanguage (TemplateID,LanguageID,Description) values ({0},{1},'{2}')", templateObj.TemplateId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    //Save Details
                    sequence = 0;
                    foreach (TemplateFieldModel field in templateObj.TemplateFieldsList)
                    {
                        sequence += 1;
                        query = string.Format(@"insert into BarcodeTemplateDetails (TemplateID, FieldID, FieldSequence, FieldLength) values ({0},{1},{2},{3})", templateObj.TemplateId, field.FieldId, sequence, field.FieldLength);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }

        public GlobalErrors GetAllBarcodeTemplates(GeneralFilter filter, ref SharedTableResult<BarcodeTemplateModel> allTemplates)
        {
            DBHelper<BarcodeTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<BarcodeTemplateModel> lists = new List<BarcodeTemplateModel>();
                dbHelper = new DBHelper<BarcodeTemplateModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" and ( (BarcodeTemplateLanguage.Description LIKE '%{0}%')
                    OR ( BarcodeTemplate.TemplateCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (!string.IsNullOrEmpty(filter.TemplateId.ToString()) && filter.TemplateId > -1)
                    {
                        searchFilter += string.Format(@" And  BarcodeTemplate.TemplateID ={0}", filter.TemplateId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@" Order By tt.TemplateCode desc");
                    }
                }
                string mainQuery = string.Format(@"  inner join BarcodeTemplateLanguage on 
                                   BarcodeTemplate.TemplateID=BarcodeTemplateLanguage.TemplateID and BarcodeTemplateLanguage.LanguageID={0}",
                                    _requestRepository.LanguageId//0
                                    );

                string allDataQuery = string.Format(@"
                                     Select ROW_NUMBER() Over(Order By tt.TemplateID) AS RowSeq,*
                                      from (Select BarcodeTemplate.TemplateID TemplateId, BarcodeTemplate.TemplateCode,BarcodeTemplate.Length,
                BarcodeTemplateLanguage.Description TemplateName
                from BarcodeTemplate 
                                    
                                    {0}
                                    {1} 
                                     ) tt
                                    {2} 
                                    OFFSET  {3} ROWS       
                                    FETCH NEXT {4} ROWS ONLY",

                                    mainQuery,//0
                                    searchFilter,//1
                                    orderByFilter,//2
                                   (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//3
                                   filter.CustomListFilter.PageSize//4


                                   );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from (select distinct BarcodeTemplate.*  From BarcodeTemplate {0} {1})tt ",
                                             mainQuery,
                                             searchFilter);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    allTemplates.TotalItems = int.Parse(objField.ToString().Trim());
                    if (allTemplates.TotalItems <= 0)
                    {
                        allTemplates.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists);
                allTemplates.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allTemplates = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTemplateDescriptions(int templateId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from BarcodeTemplateLanguage
                where BarcodeTemplateLanguage.TemplateID={0}", templateId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTemplateDetails(int templateId, ref List<TemplateFieldModel> fields)
        {
            DBHelper<TemplateFieldModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TemplateFieldModel>();
                string query = string.Format(@"select * from BarcodeTemplatedetails
                where TemplateID={0} order by FieldSequence", templateId);
                result = dbHelper.GetQueryList(query, ref fields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                fields = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditBarcodeTemplate(BarcodeTemplateModel templateObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            int templateLength = 0;
            int sequence = 0;
            try
            {
                foreach (TemplateFieldModel field in templateObj.TemplateFieldsList)
                {
                    if (field.FieldId == BarcodeTemplateFields.BatchNumber.GetHashCode() || field.FieldId == BarcodeTemplateFields.ExpiryDate.GetHashCode()
                        || field.FieldId == BarcodeTemplateFields.GTIN.GetHashCode() || field.FieldId == BarcodeTemplateFields.Serial.GetHashCode() || field.FieldId == BarcodeTemplateFields.ProductionDate.GetHashCode())
                        templateLength += field.FieldLength + 2;
                    else
                        if (field.FieldId == BarcodeTemplateFields.GLN.GetHashCode())
                        templateLength += field.FieldLength + 3;
                }
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                string query = string.Format(@"Update BarcodeTemplate set TemplateCode='{0}', Length = {2} where templateID = {1}",
                                templateObj.TemplateCode.Replace("'", "''"),// 0
                                templateObj.TemplateId, //1
                                templateLength //2
                               );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("delete from BarcodeTemplateLanguage where TemplateID={0}", templateObj.TemplateId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                    //Save language
                    foreach (TextLanguage language in templateObj.TemplateDescriptionLanguages)
                    {
                        query = string.Format(@"insert into BarcodeTemplateLanguage (TemplateID,LanguageID,Description) values ({0},{1},'{2}')", templateObj.TemplateId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format("delete from BarcodeTemplateDetails where TemplateID={0}", templateObj.TemplateId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                    //Save Details
                    sequence = 0;
                    foreach (TemplateFieldModel field in templateObj.TemplateFieldsList)
                    {
                        sequence += 1;
                        query = string.Format(@"insert into BarcodeTemplateDetails (TemplateID, FieldID, FieldSequence, FieldLength) values ({0},{1},{2},{3})", templateObj.TemplateId, field.FieldId, sequence, field.FieldLength);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public bool IsTemplateLinkedToPack(int templateId, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                string query = string.Format(" Select * From Pack WHERE TemplateId = {0} ", templateId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors DeleteBarcodeTemplate(int templateID)
        {
            GlobalErrors result = GlobalErrors.Error;
            DBHelper<int> dBHelper = null;
            string queryString = string.Empty;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                queryString = string.Format("Delete from BarcodeTemplateLanguage  where TemplateID= {0} ", templateID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    queryString = string.Format("Delete from BarcodeTemplatedetails  where TemplateID= {0} ", templateID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    queryString = string.Format("Delete from BarcodeTemplate  where TemplateID= {0} ", templateID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors GetTemplateFields(ref List<TemplateFieldModel> templateFields)
        {
            DBHelper<TemplateFieldModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TemplateFieldModel>();
                string query = string.Format(@"select BarcodeTemplateField.FieldID FieldId ,BarcodeTemplateFieldLanguage.Description FieldName from BarcodeTemplateField
                inner join BarcodeTemplateFieldLanguage on BarcodeTemplateFieldLanguage.FieldID=BarcodeTemplateField.FieldID
                and BarcodeTemplateFieldLanguage.LanguageID={0} ", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref templateFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templateFields = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetUploadedEmployeeDeviceToken(int employeeId, ref string deviceToken, DBHelper<int> openedHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                deviceToken = string.Empty;
                DBHelper<string> dbHelperForToken = new DBHelper<string>(openedHelper.GetConnection(), openedHelper.GetDBTransaction());
                string query = string.Format(@"Select DeviceToken from DeviceToken
                inner join(
                select top (1) RouteHistory.*  from RouteHistory 
                where EmployeeID = {0}
                order by RouteHistoryID desc
                )tt on tt.DeviceSerial = DeviceToken.DeviceSerial and tt.Uploaded = 1",
                employeeId);
                result = dbHelperForToken.GetQuerySingle(query, ref deviceToken);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetActivateDeactivateReason(MasterDataScreens screen, MasterDataStatus status, ref List<dynamic> reasonsList)
        {
            DBHelper<dynamic> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<dynamic>();
                string tableName = string.Empty;
                switch (status)
                {
                    case MasterDataStatus.Activate:
                        tableName = TableNames.ActivationReason;
                        break;
                    case MasterDataStatus.Deactivate:
                        tableName = TableNames.DeactivationReason;
                        break;
                }

                string query = $@"select AR.{QueryColumnsNames.ReasonId} ReasonId,ARL.Description ReasonDescription
                                  from {tableName} AR
                                  left join {tableName}Language  ARL on ARL.{QueryColumnsNames.ReasonId} = AR.{QueryColumnsNames.ReasonId} and ARL.LanguageID = {_requestRepository.LanguageId}
                                  inner join {tableName}Assignment ARA on ARA.{QueryColumnsNames.ReasonId} = AR.{QueryColumnsNames.ReasonId} 
                                  inner join MasterDataScreens MDS on MDS.ScreenID = ARA.ScreenID and MDS.ScreenID = {screen.GetHashCode()}
                                  left join MasterDataScreensLanguage MDSL on MDSL.ScreenID = MDS.ScreenID and MDSL.LanguageID = {_requestRepository.LanguageId}
                                  ";

                result = dbHelper.GetQueryList(query, ref reasonsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAuditMasterReason(AuditMasterData auditMaster,bool isEditMode, DBHelper<AuditMasterData> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            var commitTransaction = false;
            try
            {

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<AuditMasterData>();
                    dBHelper.BeginTransaction();
                    commitTransaction = true;
                }

                string query = string.Empty; 
                DataTable data = new DataTable();
                bool insertAudit = false;
                var auditMasterObj = new AuditMasterData();
                query = $"select top 1 * from AuditMasterData where ReferenceId = {auditMaster.ReferenceId} and ScreenId = {auditMaster.ScreenID} order by UpdatedDate desc";
                result = dBHelper.GetQuerySingle(query, ref auditMasterObj);

                if (result == GlobalErrors.Success)
                {
                    if (auditMasterObj != null)
                    {
                        if(auditMasterObj.ReasonId != auditMaster.ReasonId || auditMasterObj.Status != auditMaster.Status)
                        insertAudit = true;
                    }
                    else
                    {
                        insertAudit = true;
                    }
                }
                DBHelper<int> dBHelperOperation = null;
                dBHelperOperation = new DBHelper<int>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());

                if (result == GlobalErrors.Success && insertAudit)
                    {
                        query = $@"insert into AuditMasterData(ReferenceId,ScreenID,Status,ReasonId,UpdatedBy,UpdatedDate)
                                        values({auditMaster.ReferenceId},{auditMaster.ScreenID},{auditMaster.Status.GetHashCode()},{auditMaster.ReasonId},{_requestRepository.CurrentOperator.EmployeeId},{LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)})";
                        result = dBHelperOperation.ExecuteNonQuery(query);
                    }
                
                
                if(result == GlobalErrors.Success && !isEditMode)
                {
                    
                    var status = auditMaster.Status == MasterDataStatus.Activate ;
                    switch ((MasterDataScreens)auditMaster.ScreenID)
                    {
                        case MasterDataScreens.Employees:
                            var _empManager = new EmployeeManager(_requestRepository);
                            result = _empManager.UpdateEmployeeActiveStatus(auditMaster.ReferenceId,status, dBHelperOperation);
                            break;
                        case MasterDataScreens.Territories:
                            break;
                        case MasterDataScreens.Customers:
                            break;
                        case MasterDataScreens.Devices:
                            break;
                        case MasterDataScreens.Items:
                            break;
                        case MasterDataScreens.Vehicles:
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (commitTransaction)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                }
            }
            return result;
        }
        public static GlobalErrors GetTemplatesFields(string templateIDs, ref List<TemplateFieldModel> templateFields)
        {
            DBHelper<TemplateFieldModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TemplateFieldModel>();
                string query = string.Format(@"select TemplateID, FieldID, FieldSequence,FieldLength from BarcodeTemplateDetails where TemplateID in ({0}) order by FieldSequence ", templateIDs);
                result = dbHelper.GetQueryList(query, ref templateFields);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templateFields = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfDeviceLinkedToUploadedRoute(DeviceModel employeeDevice, ref bool isUploadedRoute)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            isUploadedRoute = false;
            try
            {
                dbHelper = new DBHelper<int>();
                object objField = null;

                string query = string.Format(@"select uploaded from RouteHistory
                     where RouteHistoryID in (select max(RouteHistoryid) routehistoryid from RouteHistory where employeeid = {0}) ", employeeDevice.EmployeeId);

                result = dbHelper.ExecuteScalar(query, ref objField);
  
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && !string.IsNullOrEmpty(objField.ToString()))
                    {
                        if (bool.Parse(objField.ToString()))
                        {
                            isUploadedRoute = true;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}
