﻿using Newtonsoft.Json;
using OfficeOpenXml.FormulaParsing.LexicalAnalysis;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace Sonic.Web.Core
{
    public class NotificationManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmployeeManager _employeeManager;

        public NotificationManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _employeeManager = new EmployeeManager(requestRepository);
        }
        public GlobalErrors GetEchoNotificationList(int pageNumber, int pageSize, ref List<NotificaitonsModel> notifications)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<NotificaitonsModel> dbHelper = new DBHelper<NotificaitonsModel>();
                notifications = new List<NotificaitonsModel>();
                string query = string.Format(@"select * from (
                                SELECT Distinct
                                notifications.TypeID
                                ,CASE WHEN {3} = 2 THEN notifications.ArabicTitle ELSE notifications.Title END subject
                                ,CASE WHEN {3} = 2 THEN notifications.ArabicBody ELSE notifications.Body END Body
                                , ImageName
                                , VideoName
                                , CreatedDate
                                , '' orderId
                                ,Case when UnRead is null then 0 else UnRead end UnRead
                                ,-1 as OrderStatusID
                                FROM EchoNotifications notifications
                                INNER JOIN EchoNotificationHistory ON EchoNotificationHistory.NotificationId = notifications.NotificationId and EchoNotificationHistory.IsOrder = 0
                                LEFT OUTER JOIN CustomerOutletGroup OutGroup ON OutGroup.GroupID = notifications.GroupID
                                LEFT OUTER JOIN 
                                (
                                SELECT G.ChannelID, G.SubChannelID, COG.CustomerID, COG.OutletID FROM CustomerGroup G
                                INNER JOIN CustomerOutletGroup COG ON G.GroupID = COG.GroupID
                                ) CustomerChannel ON CustomerChannel.ChannelID = notifications.ChannelID and CustomerChannel.SubChannelID = notifications.SubChannelID
                                WHERE 
                                (concat(notifications.CustomerId, '-', notifications.outletid) in ({0}))
                                OR (concat(CustomerChannel.CustomerId, '-', CustomerChannel.outletid) in ({0}))
                                OR (concat(OutGroup.CustomerId, '-', OutGroup.outletid) in ({0}))
                                UNION ALL
                                SELECT Distinct TypeID 
                                ,CASE WHEN {3} = 2 THEN ArabicTitle ELSE Title END subject
                                ,CASE WHEN {3} = 2 THEN ArabicBody ELSE Body END Body
                                , ''
                                ,''
                                ,CustomerAppOrderHistory.CreatedDate 
                                ,CustomerAppOrderHistory.orderId 
                                ,Case when UnRead is null then 0 else UnRead end UnRead
                                ,SalesOrder.OrderStatusID
                                FROM CustomerAppOrderHistory
                                INNER JOIN  EchoNotificationHistory ON EchoNotificationHistory.NotificationId = CustomerAppOrderHistory.NotificationId and EchoNotificationHistory.IsOrder = 1
                                Inner JOIN SalesOrder ON SalesOrder.OrderId = CustomerAppOrderHistory.OrderId and SalesOrder.CustomerId = CustomerAppOrderHistory.CustomerId and SalesOrder.OutletId = CustomerAppOrderHistory.OutletId
                                
                                where concat(CustomerAppOrderHistory.CustomerID, '-', CustomerAppOrderHistory.OutletID) in ({0}) 
                                ) tt
                                ORDER BY CreatedDate DESC 
                                OFFSET     {1} ROWS
                                FETCH NEXT {2} ROWS ONLY"
                                , _requestRepository.CurrentEchoOperator.CustomerOutletIds
                                , pageNumber * pageSize, pageSize, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref notifications);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetNotificationAsRead()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = string.Format("UPDATE EchoNotificationHistory set UnRead = 0 Where concat(CustomerID, '-', OutletID) in ({0})", _requestRepository.CurrentEchoOperator.CustomerOutletIds);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerTokenIds(NotificaitonsModel notificaitonsModel, ref List<CustomerOutletModel> customerTokenList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<CustomerOutletModel> dBHelper = new DBHelper<CustomerOutletModel>();
                customerTokenList = new List<CustomerOutletModel>();


                string query = string.Format(@"SELECT DISTINCT CustomerToken.CustomerID, CustomerToken.OutletID, Token FROM CustomerDeviceToken CustomerToken
                                LEFT OUTER JOIN CustomerOutletGroup CustomerGroup ON CustomerToken.CustomerID = CustomerGroup.CustomerID and CustomerToken.OutletID = CustomerGroup.OutletID
                                LEFT OUTER JOIN
                                (
                                SELECT G.ChannelID, G.SubChannelID, COG.CustomerID, COG.OutletID FROM CustomerGroup G
                                INNER JOIN CustomerOutletGroup COG ON G.GroupID = COG.GroupID
                                ) CustomerChannel ON CustomerChannel.CustomerID = CustomerToken.CustomerID and CustomerChannel.OutletID = CustomerToken.OutletID

                                INNER JOIN EchoNotifications Notifications ON(Notifications.CustomerID = CustomerToken.CustomerID and Notifications.OutletID = CustomerToken.OutletID)
                                OR(Notifications.GroupID = CustomerGroup.GroupID) OR(Notifications.ChannelID = CustomerChannel.ChannelID AND Notifications.SubChannelID = CustomerChannel.SubChannelID)

                                WHERE Notifications.NotificationId = {0} ", notificaitonsModel.NotificationId);
                result = dBHelper.GetQueryList(query, ref customerTokenList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }
        public GlobalErrors SaveNotificationHistroy(int customerId, int outletId, int notificationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"INSERT INTO EchoNotificationHistory (CustomerID, OutletID, NotificationID, UnRead, IsOrder) VALUES ({0},{1},{2},1, 0)", customerId, outletId, notificationId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetBadgeCount(int customerId, int outletId, ref int badge)
        {
            DBHelper<int> dBHelper = new DBHelper<int>();
            return GetBadgeCount( customerId,  outletId, ref badge, dBHelper);
        }
        public GlobalErrors GetBadgeCount(int customerId, int outletId, ref int badge, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object fieldObj = null;
                badge = 0;
                string query = string.Format(@"Declare @operator int
                                SELECT @operator = OperatorID from CustomerOutletAccess where CustomerID = {0} and OutletID = {1}
                                SELECT COUNT(*) count 
                                from EchoNotificationHistory 
                                WHERE UnRead = 1 and concat(CustomerID, '-', OutletID) in (select concat(CustomerID, '-', OutletID) from CustomerOutletAccess where OperatorID = @operator)"
                               , customerId, outletId);
                result = dBHelper.ExecuteScalar(query, ref fieldObj);
                if (result == GlobalErrors.Success && fieldObj != null && !string.IsNullOrEmpty(fieldObj.ToString()))
                {
                    badge = int.Parse(fieldObj.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateCustomerDeviceToken(string token)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string query = string.Format(@"delete from CustomerDeviceToken where (concat(CustomerID, '-', OutletID) in ({1}))", token, _requestRepository.CurrentEchoOperator.CustomerOutletIds);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {
                    foreach (OperatorCustomerModel op in _requestRepository.CurrentEchoOperator.OperatorCustomers)
                    {
                        query = string.Format(@"INSERT INTO CustomerDeviceToken VALUES ({0},{1},'{2}') ", op.CustomerId, op.OutletId, token);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public async void SendNotificationToCustomer(FCMNotificationModel fCMNotificationModel)
        {
            HttpRequestMessage httpRequest = null;
            HttpClient httpClient = null;
            var authorizationKey = string.Format("key={0}", LocalUtilities.CustomerAppNotificationID);
            var jsonBody = JsonConvert.SerializeObject(fCMNotificationModel);
            try
            {
                httpRequest = new HttpRequestMessage(HttpMethod.Post, "https://fcm.googleapis.com/fcm/send");

                httpRequest.Headers.TryAddWithoutValidation("Authorization", authorizationKey);
                httpRequest.Content = new StringContent(jsonBody, Encoding.UTF8, "application/json");

                httpClient = new HttpClient();
                using (await httpClient.SendAsync(httpRequest))
                {
                }
            }
            catch
            {
                throw;
            }
            finally
            {
                httpRequest.Dispose();
                httpClient.Dispose();
            }
        }
        public GlobalErrors SendOrderUpdatedNotificationToCustomerApp(int customerId, int outletId, int employeeId, string orderId, OrderStatus status, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string token = "";
                result = GetCustomerAppToken(customerId, outletId, dbHelper, ref token);

                if (result == GlobalErrors.Success)
                {
                    string title = "", body = "";

                    result = SaveNotificationOrderHistory(customerId, outletId, employeeId, orderId, status, ref title, ref body, dbHelper);
                    if (result == GlobalErrors.Success && token != string.Empty)
                    {
                        int badge = 0;
                        result = GetBadgeCount(customerId, outletId, ref badge, dbHelper);
                        if (result == GlobalErrors.Success)
                        {
                            FCMNotificationModel fCMNotificationModel = new FCMNotificationModel();
                            fCMNotificationModel.To = token;
                            fCMNotificationModel.priority = "high";
                            fCMNotificationModel.Message = new MessageModel();
                            fCMNotificationModel.Message.title = title;
                            fCMNotificationModel.Message.body = body;
                            fCMNotificationModel.Message.click_action = "FCM_PLUGIN_ACTIVITY";
                            //fCMNotificationModel.Message.click_action = "FLUTTER_NOTIFICATION_CLICK";
                            fCMNotificationModel.Message.icon = "fcm_push_icon";
                            fCMNotificationModel.Message.badge = "1";
                            fCMNotificationModel.Message.sound = "default";
                            fCMNotificationModel.data = new NotificaitonDataModel();
                            fCMNotificationModel.data.badge = badge.ToString();
                            fCMNotificationModel.data.orderId = "";
                            fCMNotificationModel.data.employeeId = "";
                            fCMNotificationModel.data.statusId = "";
                            SendNotificationToCustomer(fCMNotificationModel);
                        }

                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors SaveNotificationOrderHistory(int customerId, int outletId, int employeeId, string orderId, OrderStatus OrderStatus, ref string title, ref string body, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                title = string.Format("{0}: {1}", ResourcesManager.TranslateKey(MessagesConstants.Desc_Order_Number, 1), orderId);
                string arTitle = string.Format("{0}: {1}", ResourcesManager.TranslateKey(MessagesConstants.Desc_Order_Number, 2), orderId);
                string arBody = "";
                int typeId = CustomerAppNotificationTypes.updateOrder.GetHashCode();
                switch (OrderStatus)
                {
                    case OrderStatus.New:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Updated, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Updated, 2);
                        break;
                    case OrderStatus.Approved:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Approved, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Approved, 2);
                        typeId = CustomerAppNotificationTypes.approveOrder.GetHashCode();
                        break;
                    case OrderStatus.Assigned:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Assigned, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Assigned, 2);
                        typeId = CustomerAppNotificationTypes.updateOrder.GetHashCode();

                        break;
                    case OrderStatus.Invoiced:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Invoiced, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Invoiced, 2);
                        typeId = CustomerAppNotificationTypes.updateOrder.GetHashCode();

                        break;
                    case OrderStatus.Canceled:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Rejected, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Rejected, 2);
                        typeId = CustomerAppNotificationTypes.cancelOrder.GetHashCode();
                        break;
                    case OrderStatus.Delivered:
                        body = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Delivered, 1);
                        arBody = ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Delivered, 2);
                        typeId = CustomerAppNotificationTypes.deliveredOrder.GetHashCode();
                        break;
                }

                string query = string.Format(@"INSERT INTO CustomerAppOrderHistory (EmployeeID, CustomerID, OutletID, CreatedDate, TypeID, OrderID, Title, Body, ArabicTitle, ArabicBody) 
                                               Values ({0}, {1}, {2}, {3}, {4}, '{5}', '{6}', '{7}', '{8}', '{9}') ",
                                               employeeId,
                                               customerId,
                                               outletId,
                                               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                                               typeId,
                                               orderId,
                                               title.Replace("'", "''"),
                                               body.Replace("'", "''"),
                                               arTitle.Replace("'", "''"),
                                               arBody.Replace("'", "''")
                                               );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    result = SaveNotificationHistroy(orderId, customerId, outletId, dBHelper);
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors SaveNotificationHistroy(string orderID, int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                int notificationId = -1;
                string query = string.Format(@"select Max(NotificationId) NotificationId from CustomerAppOrderHistory where OrderID = '{0}' and CustomerID ={1} and OutletID = {2} "
                                , orderID, customerId, outletId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    notificationId = int.Parse(field.ToString());
                }
                query = string.Format(@"INSERT INTO EchoNotificationHistory (CustomerID, OutletID, NotificationID, UnRead, IsOrder) VALUES ({0},{1},{2},1, 1)", customerId, outletId, notificationId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors GetCustomerAppToken(int customerId, int outletId, DBHelper<int> dBHelper, ref string token)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object fieldObj = null;
                string query = string.Format("SELECT token from CustomerDeviceToken where customerid = {0} and outletid = {1} ", customerId, outletId);
                result = dBHelper.ExecuteScalar(query, ref fieldObj);
                if (result == GlobalErrors.Success && fieldObj != null && !string.IsNullOrEmpty(fieldObj.ToString()))
                {
                    token = fieldObj.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private string GetDeviceToken(int employeeId)
        {
            int routeId = -1;
            return GetDeviceToken(employeeId, ref routeId, null);
        }

        public string GetDeviceToken(int employeeId, DBHelper<int> dbHelper)
        {
            int routeId = -1;
            return GetDeviceToken(employeeId, ref routeId, dbHelper);
        }

        private string GetDeviceToken(int employeeId, ref int routeId, DBHelper<int> dbHelper)
        {
            string deviceToken = string.Empty;
            string deviceSerial = string.Empty;
            DBHelper<string> dBHelper2 = null;
            DBHelper<RouteHistoryModel> dBHelper_route = null;
            try
            {
                if (dbHelper == null)
                {
                    dBHelper2 = new DBHelper<string>();
                    dBHelper_route = new DBHelper<RouteHistoryModel>();
                }
                else
                {
                    dBHelper2 = new DBHelper<string>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                    dBHelper_route = new DBHelper<RouteHistoryModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                }
                RouteHistoryModel route = null;
                string query = string.Format(@"select top(1) DeviceSerial, routeId,Uploaded from RouteHistory where Employeeid = {0} order by RouteHistoryID desc", employeeId);
                GlobalErrors result = dBHelper_route.GetQuerySingle(query, ref route);
                if (route != null && route.Uploaded && !string.IsNullOrEmpty(route.DeviceSerial))
                {
                    query = string.Format(@"select DeviceToken from DeviceToken where DeviceSerial = '{0}'", route.DeviceSerial);
                    result = dBHelper2.GetQuerySingle(query, ref deviceToken);
                    routeId = route.RouteId;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return deviceToken;
        }
        public async void SendNotifiactionToSonicFO(List<OrderModel> orders)
        {
            try
            {
                if (orders != null && orders.Count > 0)
                {
                    for (int index = 0; index < orders.Count; index++)
                    {
                        var success = await SendNotifiactionToSonicFO(orders[index], "", 1);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public async Task<bool> SendNotifiactionToSonicFO(OrderModel order, string token, int counter)
        {
            bool success = false;
            try
            {
                string deviceToken = token;
                if (string.IsNullOrEmpty(deviceToken))
                {
                    deviceToken = GetDeviceToken(order.EmployeeId);
                }
                if (deviceToken != string.Empty)
                {
                    var data = new Object();
                    data = new
                    {
                        registration_ids = new string[1] { deviceToken },
                        data = new
                        {
                            type = CustomerAppNotificationTypes.CreateNewOrder,
                            Order = PrepareSimpleOrderFromOrder(order)
                        }

                    };
                    var serverKey = string.Format("key={0}", LocalUtilities.SonicFONotificationID);
                    var senderId = string.Format("id={0}", LocalUtilities.SonicFONotificationSenderID);
                    var jsonBody = JsonConvert.SerializeObject(data);
                    using (var httpRequest = new HttpRequestMessage(HttpMethod.Post, "https://fcm.googleapis.com/fcm/send"))
                    {
                        httpRequest.Headers.TryAddWithoutValidation("Authorization", serverKey);
                        httpRequest.Headers.TryAddWithoutValidation("Sender", senderId);
                        httpRequest.Content = new StringContent(jsonBody, Encoding.UTF8, "application/json");
                        ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
                        using (var httpClient = new HttpClient())
                        {
                            var res = await httpClient.SendAsync(httpRequest);
                            if (res.IsSuccessStatusCode)
                            {
                                success = true;
                                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, string.Format("Success sending Order [{0}] to Sonic FO, Token is [{1}]", order.OrderId, deviceToken), null, "", 0);
                            }
                            else
                            {
                                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, string.Format("Error sending Order [{0}] to Sonic FO, Token is [{1}]", order.OrderId, deviceToken), null, "", 0);
                                System.Threading.Thread.Sleep(1000);
                                if (counter < 3)
                                {
                                    counter++;
                                    await SendNotifiactionToSonicFO(order, "", counter);
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return success;
        }
        private OnlineOrder PrepareSimpleOrderFromOrder(OrderModel order)
        {
            OnlineOrder onlineOrder = new OnlineOrder();
            try
            {
                onlineOrder.OrderID = order.OrderId;
                onlineOrder.CustomerName = order.CustomerName;
                onlineOrder.CustomerID = order.CustomerId;
                onlineOrder.OutletID = order.OutletId;
                onlineOrder.DivisionID = order.DivisionId;
                onlineOrder.NetTotal = order.NetTotal;
                onlineOrder.Discount = order.Discount;
                onlineOrder.GrossTotal = order.GrossTotal;
                onlineOrder.Tax = order.Tax;
                onlineOrder.CreationSource = CreationSource.Echo.GetHashCode();
                onlineOrder.OrganizationID = order.OrganizationId;
                onlineOrder.OrderDate = order.OrderDate;
                onlineOrder.OrderDateString = order.OrderDate.ToString("yyyy-MM-dd HH:mm:ss");
                onlineOrder.DesiredDeliveryDate = order.DesiredDeliveryDate;
                onlineOrder.DesiredDeliveryDateString = order.DesiredDeliveryDate.ToString("yyyy-MM-dd HH:mm:ss");
                onlineOrder.SalesOrderContainerLimit = new SalesOrderContainerDetails();
                //if (Configuration.AllowPaymentMethodInOrder)
                //{
                //    onlineOrder.paymentMethodTypeID = order.PaymentMethodTypeID;
                //    onlineOrder.paymentReferenceNumber = order.PaymentReferenceNumber;
                //    if (Configuration.AllowPaymentMethodInOrder)
                //    {
                //        onlineOrder.SalesOrderContainerLimit = getSalesOrderContainerlimitObj(order, dbTransaction);
                //    }
                //}
                onlineOrder.ItemPacks = new List<ItemPack>();
                onlineOrder.EmployeeID = order.EmployeeId;
                onlineOrder.SalesMode = order.SalesMode;
                onlineOrder.RouteID = -1;
                onlineOrder.Notes = order.Notes;
                //ItemPack pack;
                //int numberOfItems = 0;
                //foreach (ItemPackModel item in order.SoldItems)
                //{
                //    pack = new ItemPack();
                //    pack.PackID = item.PackId;
                //    pack.RequiredQuanity = item.RequiredQty;
                //    pack.RequestedQuantity = item.RequestedQuantity;
                //    pack.Price = item.Price;
                //    pack.Discount = item.Discount;
                //    pack.DiscountTypeID = item.DiscountTypeId;
                //    pack.CalculatedDiscount = item.CalculatedDiscount;
                //    pack.PromotedDiscount = item.PromotedDiscount;
                //    pack.Tax = item.Tax;
                //    pack.UsedPriceList = int.Parse(item.UsedPriceListId.ToString());
                //    pack.SalesTransactionTypeID = item.SalesTransactionTypeId.GetHashCode();
                //    pack.BasePrice = item.BasePrice;
                //    onlineOrder.ItemPacks.Add(pack);
                //    numberOfItems++;
                //}
                onlineOrder.NumberOfItems = order.SoldItems.Count;
                //FillOrderPromBenefitHistoryData(ref onlineOrder);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return onlineOrder;
        }

        private static void FillOrderPromBenefitHistoryData(ref OnlineOrder order)
        {
            DBHelper<PromotionBenefitHistoryModel> dBHelper = null;
            try
            {
                List<PromotionBenefitHistoryModel> benefitList = new List<PromotionBenefitHistoryModel>();
                order.PromotionBenifetHistoryData = new List<PromotionBenefitHistoryModel>();
                dBHelper = new DBHelper<PromotionBenefitHistoryModel>();
                string query = string.Format(@"select * from PromotionBenefitHistory Where TransactionID='{0}' and CustomerID ={1} AND OutletID ={2} And DivisionID = {3}"
                , order.OrderID, order.CustomerID, order.OutletID, order.DivisionID);
                GlobalErrors result = dBHelper.GetQueryList(query, ref benefitList);
                if (result == GlobalErrors.Success)
                {
                    order.PromotionBenifetHistoryData.AddRange(benefitList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }


        #region[Sonic Notifications]

        public GlobalErrors SaveEmployeeKeysNotification(NotificationModel notification, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Format(@"INSERT INTO EmployeeKeysNotification (MessageID, MessageBody, CustomerID, OutletID, EmployeeID, IsBOReceiver, IsBOSender, KeyTypeID, SenderDeviceToken, StatusId, ReceivedDate )
                                                values ('{0}', '{1}', {2}, {3}, {4}, {5}, {6}, {7}, '{8}', {9}, {10} )",
                                                notification.NotificationId, //0
                                                notification.EmployeeKeyModel.MessageBody,//1
                                                notification.EmployeeKeyModel.CustomerID, //2
                                                notification.EmployeeKeyModel.OutletID, //3
                                                notification.EmployeeKeyModel.EmployeeID, //4
                                                (notification.EmployeeKeyModel.IsBOReceiver ? 1 : 0), //5
                                                (notification.EmployeeKeyModel.IsBOSender ? 1 : 0), //6
                                                notification.EmployeeKeyModel.KeyTypeID, //7
                                                notification.EmployeeKeyModel.SenderDeviceToken, //8
                                                1, //9
                                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //10
                                                );
                                                result = dbHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNotification(NotificationModel notification, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (notification.NotificationTypeId != NotificationTypes.EmployeeKeys) 
                    notification.NotificationId = Guid.NewGuid().ToString();
                if (!string.IsNullOrEmpty(notification.NotificationId))
                {
                    string query = string.Format(@"Insert into Notification (NotificationID, NotificationTypeID, TemplateID, SenderID, NotificationDate)
                    values ('{0}',{1},{2},{3},{4})",
                    notification.NotificationId, //0
                    notification.NotificationTypeId.GetHashCode(), //1
                    notification.TemplateId, //2
                    notification.SenderId, //3
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //4
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNotificationDescriptions(NotificationModel notification, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (NotificationTextLanguage descriptionObject in notification.DescriptionsList)
                {
                    string query = string.Format(@"Insert Into NotificationLanguage (NotificationId,HeaderDescription,BodyDescription,LanguageId) Values ('{0}','{1}','{2}',{3})",
                    notification.NotificationId, //0
                    descriptionObject.HeaderDescription.Replace("'", "''"), //1
                    descriptionObject.BodyDescription.Replace("'", "''"), //2
                    descriptionObject.LanguageId //3
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNotificationAssignment(NotificationModel notification, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (int receiverId in notification.ReceiversList)
                {
                    values.AppendFormat("('{0}',{1},{2},{3}),",
                    notification.NotificationId, //0
                    receiverId, //1
                    0, // 2 : IsRead
                    "NULL" //3 // ReadingData
                    );
                }
                query = string.Format(@"Insert Into NotificationAssignment (NotificationId,ReceiverId,IsRead,ReadingDate) Values {0}", values.ToString().TrimEnd(','));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetNotificationReadFlag(SetNotificationAsReadModel notification)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"Update NotificationAssignment Set IsRead = {0}, ReadingDate = {1} Where NotificationID = '{2}' and ReceiverId = {3}",
                notification.MarkAsRead ? 1 : 0, //0
                notification.MarkAsRead ? LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) : "Null", //0
                notification.NotificationId, //2
                notification.ReceiverId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                }
            }
            return result;
        }
        public GlobalErrors GetEmployeeNotificationsLazyLoading(int currentNotificationCount, ref List<NotificationModel> notificationsList)
        {
            DBHelper<NotificationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                notificationsList = new List<NotificationModel>();
                dbHelper = new DBHelper<NotificationModel>();
                int notificationsCount = 10; // Maybe configuration
                string query = string.Format(@"Select CAST(Notification.NotificationID AS VARCHAR(max)) NotificationID, Notification.NotificationTypeID, Notification.TemplateID, Notification.SenderID, Notification.NotificationDate, 
                NotificationAssignment.IsRead, NotificationAssignment.ReadingDate, NotificationAssignment.ReceiverId, Employee.EmployeeCode SenderCode, IsNull(EmployeeLanguage.Description, '--') as SenderDescription,
                NotificationLanguage.HeaderDescription, NotificationLanguage.BodyDescription, 
                NotificationLanguage.LanguageID,
                EKN.CustomerID, EKN.OutletID, EKN.EmployeeID, EKN.KeyTypeID,
                case when ChangeHistoryID is null then EKN.CustomerID else RH.CustomerID end as CustomerID
                from Notification
                inner join NotificationAssignment on NotificationAssignment.NotificationID = Notification.NotificationID
                inner join NotificationLanguage on NotificationLanguage.NotificationID = Notification.NotificationID
                inner join Employee on Employee.EmployeeID = Notification.SenderId and Employee.EmployeeID {4}
                left join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID and EmployeeLanguage.LanguageID = NotificationLanguage.LanguageID
                LEFT JOIN EmployeeKeysNotification EKN ON EKN.MessageID = Notification.NotificationID
                LEFT JOIN ApprovalRangeHistory RH ON RH.MessageID = Notification.NotificationID
                Where NotificationAssignment.ReceiverId = {0} and NotificationLanguage.LanguageID = {1}
                Order By Notification.NotificationDate Desc
                OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                _requestRepository.CurrentOperator.EmployeeId, //0
                _requestRepository.LanguageId, //1
                currentNotificationCount, //2
                notificationsCount, //3
                _employeeManager.GetSupervisorAccess() //4
                );
                result = dbHelper.GetQueryList(query, ref notificationsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                notificationsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeUnreadNotificationsCount(ref int unreadNotificationsCoun)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"select IsNull(Count(*), 0) from NotificationAssignment where ReceiverId = {0} and IsRead = 0",
                _requestRepository.CurrentOperator.EmployeeId //0
                );
                result = dbHelper.GetQuerySingle(query, ref unreadNotificationsCoun);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetNotificationTemplateListSharedTable(NotificationTemplateFilterModel filter, ref SharedTableResult<NotificationTemplateModel> templatesSharedList)
        {
            templatesSharedList = new SharedTableResult<NotificationTemplateModel>();
            List<NotificationTemplateModel> recallList = new List<NotificationTemplateModel>();
            DBHelper<NotificationTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<NotificationTemplateModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and (NotificationTemplateLanguage.Description LIKE '%{0}%')",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.NotificationTypeId != -1)
                    {
                        searchFilter += string.Format(" And (NotificationTemplate.NotificationTypeID = {0}) ", filter.NotificationTypeId);
                    }
                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " And (NotificationTemplate.Inactive = 0) ";
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By NotificationTemplateLanguage.Description");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string mainQuery = string.Format(@"select NotificationTemplate.*, NotificationTemplateLanguage.Description, NotificationTemplateLanguage.BodyDescription, NotificationTemplateLanguage.HeaderDescription,
                Case NotificationTemplate.Inactive when 1 then '{1}' else '{2}'end as TemplateStatuName,
                Case NotificationTemplate.NotificationTypeId when 11 then '{3}' when 12 then '{4}' 
                when 8 then '{6}' else '---' end as NotificationTypeName
                from NotificationTemplate
                inner join NotificationTemplateLanguage on NotificationTemplateLanguage.TemplateID = NotificationTemplate.TemplateID and NotificationTemplateLanguage.LanguageID = {0}
                {5} ",
                _requestRepository.LanguageId, //0
                ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive, _requestRepository.LanguageId), //1
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId), //2
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Recall_Caption, _requestRepository.LanguageId), //3
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Quality_Control_Caption, _requestRepository.LanguageId), //4
                searchFilter, //5
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Commission_Calculation, _requestRepository.LanguageId)//6
                );

                string selectionQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt",
                mainQuery);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    templatesSharedList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (templatesSharedList.TotalItems <= 0)
                    {
                        templatesSharedList.Data = recallList;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(selectionQuery, ref recallList);
                templatesSharedList.Data = recallList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templatesSharedList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetFirstKeyFromEmployeeKeysNotification(EmployeeKeyFilter filter, ref EmployeeKeyModel key)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<EmployeeKeyModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<EmployeeKeyModel>();
                string customerFilter = string.Empty;
                if (filter.CustomerId != -1)
                    customerFilter = string.Format(@$"INNER JOIN Customer on Customer.CustomerID = {filter.CustomerId}");
                var query = string.Format(@$"						
                        Select Top 1 KeyValue, RouteHistoryID , KeyType.NotCusotmerRelatedKey
						from EmployeeKey
						INNER JOIN KeyType on KeyType.KeyTypeID = EmployeeKey.KeyTypeID 
                        {customerFilter}
						where EmployeeKey.EmployeeID = 100 and EmployeeKey.KeyTypeID = {(int)filter.KeyTypeId} And 
						KeyValue not in(select KeyValue from EmployeeKeyHistory where EmployeeID = {filter.EmployeeId} and KeyTypeID = {(int)filter.KeyTypeId} and Provided = 1)");

                result = dbHelper.GetQuerySingle(query, ref key);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors IsValidToGetCommCalcNotificationType(ref bool isValid)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            isValid = true;
            try
            {
                dbHelper = new DBHelper<int>();

                string query = string.Format(@"SELECT COUNT(*) FROM NotificationTemplate WHERE  (NotificationTypeID = {0}) AND (ISNULL(Inactive, 0) = 0)", NotificationTypes.FinalIncentive.GetHashCode());

                int count = -1;
                result = dbHelper.GetQuerySingle(query, ref count);
                if (result == GlobalErrors.Success)
                {
                    if (count > 0)
                        isValid = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetNotificationTemplateList(int notificationTypeId, ref List<NotificationTemplateModel> templatesList)
        {
            DBHelper<NotificationTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<NotificationTemplateModel>();
                string query = string.Format(@"select NotificationTemplate.*, NotificationTemplateLanguage.Description
                from NotificationTemplate
                inner join NotificationTemplateLanguage on NotificationTemplateLanguage.TemplateID = NotificationTemplate.TemplateID and NotificationTemplateLanguage.LanguageID = {0}
                Where Inactive = 0 and NotificationTypeId = {1} ",
                _requestRepository.LanguageId, //0
                notificationTypeId //1
                );

                result = dbHelper.GetQueryList(query, ref templatesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                templatesList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetNotificationTemplateDescriptions(int templateId, string columnName, ref List<TextLanguage> descriptionsList)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                descriptionsList = new List<TextLanguage>();
                dbHelper = new DBHelper<TextLanguage>();

                string query = string.Format(@"Select NotificationTemplateLanguage.{0} as Description, LanguageId 
                from NotificationTemplateLanguage Where NotificationTemplateLanguage.TemplateId = {1}",
                columnName, templateId);

                result = dbHelper.GetQueryList(query, ref descriptionsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptionsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveNotificationTemplateDescriptions(NotificationTemplateModel template, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string header = string.Empty;
                string body = string.Empty;
                string name = string.Empty;
                foreach (TextLanguage textLanguage in template.DescriptionsList)
                {
                    header = string.Empty;
                    body = string.Empty;
                    name = string.Empty;

                    // Name
                    name = textLanguage.Description;
                    if (string.IsNullOrEmpty(name))
                    {
                        name = template.Description;
                    }

                    // Header
                    if (template.HeaderDescriptionsList != null)
                    {
                        header = template.HeaderDescriptionsList.Where(a => a.LanguageId == textLanguage.LanguageId).FirstOrDefault().Description;
                    }
                    if (string.IsNullOrEmpty(header))
                    {
                        header = template.HeaderDescription;
                    }

                    // Body
                    if (template.BodyDescriptionsList != null)
                    {
                        body = template.BodyDescriptionsList.Where(a => a.LanguageId == textLanguage.LanguageId).FirstOrDefault().Description;
                    }
                    if (string.IsNullOrEmpty(body))
                    {
                        body = template.BodyDescription;
                    }

                    string query = string.Format(@"Insert Into NotificationTemplateLanguage (TemplateID, HeaderDescription, BodyDescription, LanguageID, Description) 
                    Values ({0},'{1}','{2}',{3},'{4}')",
                    template.TemplateId, //0
                    header.Replace("'", "''"), //1
                    body.Replace("'", "''"), //2
                    textLanguage.LanguageId, //3
                    name.Replace("'", "''") //4
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteNotificationTemplateDescriptions(int templateId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete From NotificationTemplateLanguage Where TemplateId = {0}",
                templateId //0
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetNotificationTemplateByType(ref NotificationTemplateModel template, NotificationTypes NotificationType, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<NotificationTemplateModel> dbHelper2 = null;
            try
            {
                if(dbHelper == null)
                {
                    dbHelper2 = new DBHelper<NotificationTemplateModel>();
                }
                else
                {
                    dbHelper2 = new DBHelper<NotificationTemplateModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                }
                
                string query = string.Format(@"SELECT TOP (1) NotificationTemplate.TemplateID, NotificationTemplateLanguage.HeaderDescription, NotificationTemplateLanguage.BodyDescription, NotificationTemplateLanguage.Description

                    FROM     NotificationTemplate INNER JOIN
                                      NotificationTemplateLanguage ON NotificationTemplate.TemplateID = NotificationTemplateLanguage.TemplateID AND NotificationTemplateLanguage.LanguageID = {1}
                    WHERE  (ISNULL(NotificationTemplate.Inactive, 0) = 0) AND NotificationTypeID = {0}", NotificationType.GetHashCode(), _requestRepository.LanguageId);
                result = dbHelper2.GetQuerySingle(query, ref template);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public int GetMaxNotificationTemplateID(DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "Select IsNull(Max(TemplateId),0) + 1 MaxTemplateId from NotificationTemplate";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        public GlobalErrors InsertNewNotificationTemplate(NotificationTemplateModel template, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int maxID = GetMaxNotificationTemplateID(dbHelper);
                if (maxID != -1)
                {
                    template.TemplateId = maxID;
                    string query = string.Format(@"Insert into NotificationTemplate (TemplateId, NotificationTypeId, CreatedBy, CreatedDate) values ({0},{1},{2},{3})",
                    template.TemplateId, //0
                    template.NotificationTypeId.GetHashCode(), //1
                    _requestRepository.CurrentOperator.EmployeeId, //2
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //3
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateNotificationTemplate(NotificationTemplateModel template, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update NotificationTemplate set NotificationTypeID = {0}, Inactive = {1}, UpdatedBy = {2}, UpdatedDate = {3} Where TemplateId = {4}",
                template.NotificationTypeId.GetHashCode(), //0
                template.Inactive ? 1 : 0, //1
                _requestRepository.CurrentOperator.EmployeeId, //2
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //3
                template.TemplateId //4
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateNotificationTemplateActiveStatus(int templateId, bool isActive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(" Update NotificationTemplate set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where TemplateId = {3}",
                isActive ? 0 : 1, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                templateId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public async void SendSonicNotifiactionToAndroid(OrderModel order, int employeeId, NotificationTypes notificationType , bool newWebOrder)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int routeId = -1;
                order.EmployeeId = employeeId;
                if (!string.IsNullOrEmpty(LocalUtilities.SonicFONotificationID) && !string.IsNullOrEmpty(LocalUtilities.SonicFONotificationSenderID))
                {
                    string deviceToken = GetDeviceToken(employeeId, ref routeId, null);
                    if (deviceToken != string.Empty)
                    {
                        var data = new Object();
                        data = new
                        {
                            registration_ids = new string[1] { deviceToken },
                            data = new
                            {
                                type = notificationType,
                                Order = PrepareSimpleOrderFromOrderInSonic(order , newWebOrder)
                            }

                        };
                        var serverKey = string.Format("key={0}", LocalUtilities.SonicFONotificationID);
                        var senderId = string.Format("id={0}", LocalUtilities.SonicFONotificationSenderID);
                        var jsonBody = JsonConvert.SerializeObject(data);
                        using (var httpRequest = new HttpRequestMessage(HttpMethod.Post, "https://fcm.googleapis.com/fcm/send"))
                        {
                            httpRequest.Headers.TryAddWithoutValidation("Authorization", serverKey);
                            httpRequest.Headers.TryAddWithoutValidation("Sender", senderId);
                            httpRequest.Content = new StringContent(jsonBody, Encoding.UTF8, "application/json");
                            ServicePointManager.ServerCertificateValidationCallback = delegate { return true; };
                            using (var httpClient = new HttpClient())
                            {
                                var res = await httpClient.SendAsync(httpRequest);
                                if (res.IsSuccessStatusCode)
                                {

                                    result = SetDeliveryAssignmentAsUploaded(order.OrderId, employeeId);


                                }
                                else
                                {
                                    ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, "Error Code --> " + res.StatusCode.ToString(), new Exception("Error in sending to FO"), "", 0, 0);

                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {

            }

        }
        private OnlineOrder PrepareSimpleOrderFromOrderInSonic(OrderModel order , bool newOrderWeb)
        {
            OnlineOrder onlineOrder = new OnlineOrder();
            try
            {
                onlineOrder.OrderTypeID = order.OrderTypeId > 0? order.OrderTypeId.GetHashCode():-1;
                onlineOrder.OrderID = order.OrderId;
                onlineOrder.CustomerName = order.CustomerName;
                onlineOrder.CustomerCode = order.CustomerCode;
                onlineOrder.CustomerPhoneNumber = order.CustomerPhoneNumber;
                onlineOrder.GPSLatitude = order.GPSLatitude;
                onlineOrder.GPSLongitude = order.GPSLongitude;
                onlineOrder.CustomerID = order.CustomerId;
                onlineOrder.OutletID = order.OutletId;
                onlineOrder.DivisionID = order.DivisionId;
                onlineOrder.NetTotal = order.NetTotal;
                onlineOrder.Discount = order.Discount;
                onlineOrder.GrossTotal = order.GrossTotal;
                onlineOrder.Tax = order.Tax;
                onlineOrder.CreationSource = CreationSource.SonicWeb.GetHashCode();
                onlineOrder.OrganizationID = _requestRepository.CurrentOperator.OrganizationId;
                onlineOrder.OrderDate = newOrderWeb ? order.DesiredDeliveryDateModel.Date : order.OrderDate;
                onlineOrder.OrderDateString = newOrderWeb ? order.DesiredDeliveryDateModel.Date.ToString("dd/MM/yyyy HH:mm:ss") : order.OrderDate.ToString("dd/MM/yyyy HH:mm:ss");
                onlineOrder.SalesOrderContainerLimit = new SalesOrderContainerDetails();
                onlineOrder.DesiredDeliveryDate = newOrderWeb ? order.DesiredDeliveryDateModel.Date : order.DesiredDeliveryDate;
                onlineOrder.DesiredDeliveryDateString = newOrderWeb ? order.DesiredDeliveryDateModel.Date.ToString("dd/MM/yyyy HH:mm:ss") : order.DesiredDeliveryDate.ToString("dd/MM/yyyy HH:mm:ss");
                onlineOrder.OrganizationID = order.OrganizationId;
                onlineOrder.DeliveryChargesId = order.DeliveryChargesId;
                onlineOrder.DeliveryTax = order.DeliveryTax;
                onlineOrder.DeliveryValue = order.DeliveryValue;
                onlineOrder.CreatedBy = order.CreatedBy;
                onlineOrder.CreatedDate = order.CreatedDate;
                onlineOrder.CreatedDateString = order.CreatedDate.ToString("dd/MM/yyyy HH:mm:ss");
                onlineOrder.SDCID = order.SDCId;
                //if (Configuration.AllowPaymentMethodInOrder)
                //{
                //    onlineOrder.paymentMethodTypeID = order.PaymentMethodTypeID;
                //    onlineOrder.paymentReferenceNumber = order.PaymentReferenceNumber;
                //    if (Configuration.AllowPaymentMethodInOrder)
                //    {
                //        onlineOrder.SalesOrderContainerLimit = getSalesOrderContainerlimitObj(order, dbTransaction);
                //    }
                //}
                onlineOrder.EmployeeID = order.EmployeeId;
                onlineOrder.DispatcherID = _requestRepository.CurrentOperator.EmployeeId;
                onlineOrder.ItemPacks = new List<ItemPack>();
                onlineOrder.SalesMode = order.SalesMode;
                onlineOrder.RouteID = -1;
                onlineOrder.Notes = order.Notes;
                onlineOrder.OrderSourceId = order.OrderSourceId.ToString();

                int numberOfItems = 0;
                List<ItemPack> items = new List<ItemPack>();
                FillOrderDetails(order.AllItems, ref items, ref numberOfItems);

                onlineOrder.ItemPacks = items;
                onlineOrder.NumberOfItems = order.AllItems.Count;
                onlineOrder.LPO = order.LPO;
                //FillOrderPromBenefitHistoryData(ref onlineOrder);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return onlineOrder;
        }
        private static void FillOrderDetails(List<ItemPackModel> orderItems, ref List<ItemPack> items, ref int numberOfItems)
        {
            try
            {
                ItemPack pack;
                if (items == null) items = new List<ItemPack>();
                foreach (ItemPackModel item in orderItems)
                {
                    pack = new ItemPack();
                    pack.PackID = item.PackId;
                    pack.RequiredQuanity = item.RequiredQty;
                    pack.RequestedQuantity = item.RequestedQuantity;
                    pack.Price = item.Price;
                    pack.Discount = item.Discount;
                    pack.DiscountTypeID = item.DiscountTypeId;
                    pack.CalculatedDiscount = item.CalculatedDiscount;
                    pack.PromotedDiscount = item.PromotedDiscount;
                    pack.Tax = item.Tax;
                    pack.UsedPriceList = int.Parse(item.UsedPriceListId.ToString());
                    pack.SalesTransactionTypeID = item.SalesTransactionTypeId.GetHashCode();
                    pack.BasePrice = item.BasePrice;
                    items.Add(pack);
                    numberOfItems++;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private GlobalErrors SetDeliveryAssignmentAsUploaded(string orderId, int driverId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"UPDATE DeliveryAssignment SET Uploaded = 1 WHERE EmployeeID = {0} and OrderID = '{1}'",
                    driverId, orderId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        //public GlobalErrors GetEmployeeHasPrivilegeKey(ref List<int> ReceiversList, int KeyTypeID)
        //{
        //    DBHelper<int> dbHelper = null;
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {

        //        dbHelper = new DBHelper<int>();
        //        string query = string.Format(@"SELECT KeyTypesPrivileges.EmployeeID
        //        FROM KeyTypesPrivileges
        //        where KeyTypeID = {0}
        //        union
        //        SELECT EmployeeOperator.EmployeeID
        //        FROM KeyTypesPrivileges
        //        inner join OperatorSecurityGroup on KeyTypesPrivileges.SecurityGroupID = OperatorSecurityGroup.SecurityGroupID
        //        inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
        //        where KeyTypeID = {0}",
        //        KeyTypeID //0
        //        );
        //        result = dbHelper.GetQueryList(query, ref ReceiversList);
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        ReceiversList = null;
        //        return GlobalErrors.Error;
        //    }
        //    return result;
        //}
        public GlobalErrors GetEmployeeHasPrivilegeKey(ref List<int> ReceiversList, string keyName , int keyTypeID, int EmployeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string employeeIdsCondition = string.Empty;
            List<int> employeeIds = new List<int>();
            string query = string.Empty;
            string employeeIdsString = string.Empty;
            string employeeType = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format(@" Select DISTINCT SupervisorID EmployeeId from EmployeeSupervisor where EmployeeID = {0}
                union 
                Select DISTINCT SupervisorSalesMngr.SalesManagerID EmployeeID 
                from SupervisorSalesMngr 
                where 
                SupervisorID in (select SupervisorID EmployeeId from EmployeeSupervisor where EmployeeID = {0})
                union 
                Select DISTINCT SalesManagerDirector.DirectorID EmployeeID 
                from SalesManagerDirector 
                where ManagerID in (Select DISTINCT SupervisorSalesMngr.SalesManagerID EmployeeID 
                from SupervisorSalesMngr 
                where 
                SupervisorID in (select SupervisorID EmployeeId from EmployeeSupervisor where EmployeeID = {0}))", EmployeeID);
                result = dbHelper.GetQueryList(query, ref employeeIds);
                if (result != GlobalErrors.Success)
                {
                    return GlobalErrors.Error;
                }
                if (employeeIds != null && employeeIds.Count > 0)
                {
                    employeeIdsString = string.Join(",", employeeIds);
                    if (!string.IsNullOrEmpty(employeeIdsString))
                    {
                        employeeIdsCondition = string.Format(@" or (Employee.EmployeeTypeID in ({1},{2},{3}) and Employee.EmployeeID in ({0}))", employeeIdsString, EmployeeTypes.Supervisor.GetHashCode(), EmployeeTypes.SalesManager.GetHashCode(), EmployeeTypes.Director.GetHashCode());
                    }
                }
                employeeType = string.Format(@" {0},{1},{2}",EmployeeTypes.Supervisor.GetHashCode(),EmployeeTypes.SalesManager.GetHashCode(),EmployeeTypes.Director.GetHashCode());
                query = string.Format(@"
                    SELECT Distinct tt.EmployeeID  
					From KeyTypesPrivileges	
					INNER JOIN WebSecurityGroupPrivilege SGP on SGP.MenuID in ('600-001')
                    INNER JOIN Employee on Employee.EmployeeID = KeyTypesPrivileges.EmployeeID
					inner join (					
					SELECT Distinct KeyTypesPrivileges.EmployeeId , OperatorSecurityGroup.SecurityGroupID from KeyTypesPrivileges
					INNER JOIN EmployeeOperator ON EmployeeOperator.EmployeeID = KeyTypesPrivileges.EmployeeId
                    INNER JOIN Employee on Employee.EmployeeID = EmployeeOperator.EmployeeID
					INNER JOIN OperatorSecurityGroup ON OperatorSecurityGroup.OperatorID = EmployeeOperator.OperatorID 
					WHERE KeyTypeID in ({0}) AND KeyTypesPrivileges.EmployeeID != -1 
					UNION 
					Select Distinct EmployeeOperator.EmployeeId  , OperatorSecurityGroup.SecurityGroupID From KeyTypesPrivileges 
					INNER JOIN OperatorSecurityGroup ON OperatorSecurityGroup.SecurityGroupID = KeyTypesPrivileges.SecurityGroupID 
					INNER JOIN EmployeeOperator ON EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
                    INNER JOIN Employee on Employee.EmployeeID = EmployeeOperator.EmployeeID
                    where (Employee.EmployeeTypeID not in ({2}) {1}) and KeyTypeID in ({0})
					) tt on tt.SecurityGroupID = SGP.SecurityGroupID
					WHERE KeyTypeID in ({0}) and (Employee.EmployeeTypeID not in ({2}) {1}) 
                ", keyTypeID, employeeIdsCondition, employeeType);

                result = dbHelper.GetQueryList(query, ref ReceiversList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ReceiversList = null;
            }
            return result;
        }
        public GlobalErrors GetMessageBodyForRequestKey(ref List<NotificationTextLanguage> descriptionList, int KeyTypeID)
        {
            DBHelper<NotificationTextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<NotificationTextLanguage>();
                string query = string.Format(@"SELECT KeyName AS BodyDescription,LanguageID FROM KeyTypeLanguage WHERE KeyTypeID = {0}",
                KeyTypeID //0
                );
                result = dbHelper.GetQueryList(query, ref descriptionList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptionList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveApprovalRangeHistory(NotificationModel notification, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO ApprovalRangeHistory (RouteHistoryID,CustomerID,OutletID,DivisionID,TransactionID,ItemID,PackID,OldLowerRange,OldUpperRange,NewRequestedValue,NewLowerRange,NewUpperRange,StatusID,RequestedBy,RequestedDate,ProcessedBy,ProcessedDate,TypeID,MessageID,SenderDeviceToken)  
                values ({0},{1},{2},{3},'{4}',{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},'{18}','{19}')",
                notification.DiscountKeyModel.RouteHistoryId,
                notification.DiscountKeyModel.CustomerId,
                notification.DiscountKeyModel.OutletId,
                notification.DiscountKeyModel.DivisionId,
                notification.DiscountKeyModel.TransactionId,
                notification.DiscountKeyModel.ItemId,
                notification.DiscountKeyModel.PackId,
                notification.DiscountKeyModel.OldLowerRange,
                notification.DiscountKeyModel.OldUpperRange,
                notification.DiscountKeyModel.NewRequestedValue,
                notification.DiscountKeyModel.NewLowerRange,
                notification.DiscountKeyModel.NewUpperRange,
                notification.DiscountKeyModel.StatusId,
                notification.DiscountKeyModel.RequestedBy,
                LocalUtilities.ParseDateAndTimeToSQL(notification.DiscountKeyModel.RequestedDateModel.Date),
                notification.ReceiverId,
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                notification.DiscountKeyModel.TypeId,
                notification.NotificationId,
                notification.DiscountKeyModel.SenderDeviceToken 
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerDescription(KeyLimitModel keyLimit, ref List<KeyLimitModel> key)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<KeyLimitModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<KeyLimitModel>();
                string customerFilter = string.Empty;
                string query = string.Format(@"select distinct CustomerLanguage.LanguageID,
                IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--') CustomerDescription
                from Customer
                inner join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID
                where Customer.CustomerID= {0}",
                keyLimit.CustomerId
                );
                result = dbHelper.GetQueryList(query, ref key);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEchoNotificationCount(ref int NotificationCount)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var dbHelper = new DBHelper<int>();
            try
            {
                object count = null;
                string query = string.Format(@"SELECT COUNT(*) 
                FROM     EchoNotificationHistory
                WHERE   CONCAT(CustomerID, '-', OutletID)  IN ({0}) AND (UnRead = 1)", _requestRepository.CurrentEchoOperator.CustomerOutletIds);
                result = dbHelper.ExecuteScalar(query, ref count);
                if(result == GlobalErrors.Success && count!= null)
                {
                    NotificationCount = (int)count;
                }
                else
                {
                    NotificationCount = 0;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        #endregion

        #region [Queries]
        //Select tt.EmployeeID from(
        //Select alllevels.EmployeeID, alllevels.proirity ConfigurationLevelPriority,
        //row_number() OVER (PARTITION BY alllevels.EmployeeID ORDER BY alllevels.proirity ASC) AS rowNumber
        //from Configuration
        //left outer
        //join (
        //select Employee.EmployeeID, KeyName, KeyValue, 1 proirity from Configuration
        //inner join Employee on Employee.EmployeeID = Configuration.EmployeeID and Employee.EmployeeTypeID in (1, 4, 9, 19, 20)
        //where KeyName = '{0}' and KeyValue = 'True'
        //union
        //select  Employee.EmployeeID, KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
        //Inner join OperatorSecurityGroup on ConfigurationSecurityGroup.SecurityGroupID = OperatorSecurityGroup.SecurityGroupID
        //inner join EmployeeOperator on EmployeeOperator.OperatorID = OperatorSecurityGroup.OperatorID
        //inner join Employee on Employee.EmployeeID = EmployeeOperator.EmployeeID
        //and Employee.EmployeeTypeID in (1, 4, 9, 19, 20)
        //where KeyName = '{0}' and KeyValue = 'True'
        //union
        //select Employee.EmployeeID, KeyName, KeyValue, 3 proirity from ConfigurationOrganization
        //Inner Join EmployeeOrganization on ConfigurationOrganization.OrganizationID = EmployeeOrganization.OrganizationID
        //inner join Employee on Employee.EmployeeID = EmployeeOrganization.EmployeeID and Employee.EmployeeTypeID in (1, 4, 9, 19, 20)
        //where KeyName = '{0}' and KeyValue = 'True'
        //union
        //select emp.EmployeeID, KeyName, KeyValue, 4 proirity from Configuration
        //inner join(select employee.EmployeeID from Employee where EmployeeTypeID in (1, 4, 9, 19, 20))emp on 1 = 1
        //where KeyName = '{0}' and KeyValue = 'True'
        //) allLevels on allLevels.KeyName = Configuration.KeyName
        //)tt
        //where
        //tt.rowNumber = 1 and
        //tt.ConfigurationLevelPriority is not null
        #endregion
    }
}

