﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.ApiIntegration.OrderModel;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.Xml;
using Microsoft.AspNetCore.Http;
using System.Collections.ObjectModel;
using System.Transactions;
using System.Diagnostics;
using Sonic.Web.Model.ProcedureResult;

namespace Sonic.Web.Core
{
    public class OrderManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PromotionManager _promotionManager;
        private readonly EmployeeManager _employeeManager;
        private readonly CustomerManager _customerManager;
        private readonly TransactionManager _transactionManager;
        private readonly AccountManager _accountManager;
        private readonly CurrencyManager _currencyManager;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly ItemManager _itemManager;
        private readonly NotificationManager _notificationManager;

        public OrderManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _promotionManager = new PromotionManager(requestRepository);
            _employeeManager = new EmployeeManager(requestRepository);
            _customerManager = new CustomerManager(requestRepository);
            _transactionManager = new TransactionManager(requestRepository);
            _accountManager = new AccountManager(requestRepository);
            _currencyManager = new CurrencyManager(requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(requestRepository);
            _itemManager = new ItemManager(requestRepository);
            _notificationManager = new NotificationManager(requestRepository);

        }
        public int GetMaxOrderNoteId(OrderModel order, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Select IsNull(max(NoteID),0) + 1 NoteID from SalesOrderNote Where OrderID = '{0}' And CustomerID = {1} And OutletID = {2} And DivisionID = {3}",
                order.OrderId,
                order.CustomerId,
                order.OutletId,
                order.DivisionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                return Int32.Parse(field.ToString());
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }

        public GlobalErrors VoidOrderTransaction(OrderModel order, bool isPartialDelivery, ref string voidedTransactionID, DBHelper<int> dbHelper, ref string voidedMsg)
        {
            List<PromotionsHistoryModel> oldPromotionsHistoryData = new List<PromotionsHistoryModel>();
            return VoidOrderTransaction(order, isPartialDelivery, ref voidedTransactionID, dbHelper, ref voidedMsg, ref oldPromotionsHistoryData);
        }

        public GlobalErrors VoidOrderTransaction(OrderModel order, bool isPartialDelivery, ref string voidedTransactionID, DBHelper<int> dbHelper, ref string voidedMsg, ref List<PromotionsHistoryModel> oldPromotionBenefitHistoryData)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;
            bool commitNow = false;
            string errorMessage = string.Empty;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    commitNow = true;
                }

                object field = null;
                voidedMsg = string.Empty;
                decimal remainig = 0, PDCAmount = 0, balanceChange = 0;
                string query = string.Empty;
                TransactionModel transaction = new TransactionModel();
                result = GetInvoiceOrderID(order, dbHelper, ref transaction);

                if (result == GlobalErrors.Success && transaction != null && !string.IsNullOrEmpty(transaction.TransactionId))
                {
                    voidedTransactionID = transaction.TransactionId;
                    result = _transactionManager.GetTransactionData(ref transaction, dbHelper);

                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                #region [Validate]
                if (transaction.RouteHistoryId > 0)
                {
                    if (_transactionManager.InvoiceIsUploaded(transaction, dbHelper))
                    {
                        voidedMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Order_Invoice_Uploaded, _requestRepository.LanguageId);
                        return GlobalErrors.Error;
                    }
                }
                if (isPartialDelivery && order.OrderStatus == OrderStatus.Delivered && (transaction.CreationReason != TransactionCreationReason.OrderManualDeliveryBOInvoice && transaction.CreationReason != TransactionCreationReason.PartialDeliveryInBO))
                {
                    voidedMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Partial_Delivery_Not_Allowed_FODelivery, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
                if (_promotionManager.IsAnyTransactionAchievedPromotion(order))
                {
                    voidedMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_You_Cannot_Void_Invoice_Previous_Ach, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
                if (_promotionManager.IsAnyLaterTransactionAchievedRelatedToTargetPromotion(order))
                {
                    voidedMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_You_Cannot_Void_Invoice_With_Related_Target_Prom, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
                #endregion



                #region [Reflect Accounts and balances]
                var withReflectBalance = order.OrderStatus == OrderStatus.Delivered;
                if (withReflectBalance)
                {
                    remainig = _transactionManager.GetTransactionRemainingAmount(transaction, dbHelper);

                    query = string.Format("SELECT SUM(CustomerPayment.AppliedAmount) FROM CustomerPayment WHERE PaymentTypeID = {3} AND TransactionID = '{0}' AND CustomerID = {1} AND OutletID = {2} AND CustomerPayment.PaymentStatusID <> {4} AND CustomerPayment.Posted <> 1",
                     transaction.TransactionId,
                     transaction.CustomerId,
                     transaction.OutletId,
                     PaymentTypes.PostedDatedCheque.GetHashCode(),
                     PaymentStatusTypes.Voided.GetHashCode());

                    result = dbHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && decimal.Parse(field.ToString()) > 0)
                    {
                        PDCAmount = decimal.Parse(field.ToString());
                    }
                    balanceChange = PDCAmount + remainig;

                    if (result == GlobalErrors.Success)
                    {
                        if (result == GlobalErrors.Success)
                        {
                            // Reflect balances with voided transaction remaining amount
                            if (balanceChange != 0)
                            {
                                result = _accountManager.UpdateAccountBalance(transaction.AccountId, (balanceChange * -1), transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId, DateTime.Now, transaction.TransactionId, dbHelper, 5);
                                if (result == GlobalErrors.Success && (
                                    (!transaction.Outlet.IsCredit && transaction.SalesMode != SalesModes.CreditSales) ||
                                    (transaction.Outlet.IsCredit && _requestRepository.Configurations.UpdateEmployeeBalanceOnCreditSale) ||
                                    (transaction.SalesMode == SalesModes.CreditSales && !transaction.Outlet.IsCredit && _requestRepository.Configurations.UpdateEmployeeBalanceOnCreditSaleForCashCustomerOnly))
                                   )
                                {
                                    int employeeAccountID = -1;
                                    result = _accountManager.GetEmployeeAccountID(transaction.EmployeeId, ref employeeAccountID, dbHelper);
                                    if (result == GlobalErrors.Success && employeeAccountID != -1)
                                    {
                                        result = _accountManager.UpdateAccountBalance(employeeAccountID, (balanceChange * -1), transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId, DateTime.Now, transaction.TransactionId, dbHelper, 5);
                                    }
                                    if (result == GlobalErrors.Success && _requestRepository.Configurations.ControlTransactionOnDivisionLevel && _requestRepository.Configurations.CheckCreditLimitOnEmployeeDivisionAccount)
                                    {
                                        result = _accountManager.UpdateEmployeeDivisionAccountBalance(employeeAccountID, (balanceChange * -1), transaction.TransactionDate, transaction.EmployeeId, _requestRepository.CurrentOperator.EmployeeId, DateTime.Now, transaction.TransactionId, dbHelper, 5, transaction.DivisionId, ref errorMessage);
                                    }
                                }
                            }
                            if (result == GlobalErrors.Success)
                            {
                                decimal appliedAmount = 0;
                                string CNTransactionID = string.Empty;
                                DataTable dtPayments = new DataTable();

                                // Update CN transaction remaning amount for transactions used as payment for currenct voided transaction 
                                query = string.Format(@"Select CustomerPayment.PaymentTypeID, CustomerPayment.AppliedAmount, [Transaction].RemainingAmount, CustomerPayment.SourceTransactionID 
                            From CustomerPayment 
                            inner join [Transaction] on CustomerPayment.TransactionID = [Transaction].TransactionID 
                            WHERE CustomerPayment.TransactionID =  '{0}' AND CustomerPayment.CustomerID = {1} AND CustomerPayment.OutletID = {2} AND CustomerPayment.DivisionID = {3} AND PaymentTypeID = {4} AND PaymentStatusID <> {5}",
                                transaction.TransactionId,
                                transaction.CustomerId,
                                transaction.OutletId,
                                transaction.DivisionId,
                                PaymentTypes.CreditNote.GetHashCode(),
                                PaymentStatusTypes.Voided.GetHashCode());
                                result = dbHelper.GetQueryDataTable(query, ref dtPayments);

                                if (result == GlobalErrors.Success)
                                {
                                    for (int i = 0; i < dtPayments.Rows.Count; i++)
                                    {
                                        DataRow dr = dtPayments.Rows[i];
                                        appliedAmount = Convert.ToDecimal(dr["AppliedAmount"].ToString());
                                        CNTransactionID = dr["SourceTransactionID"].ToString();

                                        query = string.Format(@"Update [Transaction] set RemainingAmount = RemainingAmount + {0} WHERE TransactionID =  '{1}' AND [Transaction].CustomerID = {2} AND [Transaction].OutletID = {3}", appliedAmount, CNTransactionID, transaction.CustomerId, transaction.OutletId);
                                        result = dbHelper.ExecuteNonQuery(query);
                                        if (result != GlobalErrors.Success)
                                        {
                                            return result;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                #endregion

                #region[Void all transaction's payments]
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"UPDATE CustomerPayment SET PaymentStatusID = {0}, UpdatedBy = {1}, UpdatedDate = {2}
                        WHERE TransactionID = '{3}' ",
                    TransactionStatues.Voided.GetHashCode(),
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    transaction.TransactionId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
                #endregion
                #region [Reflect Loyalty promotions]
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Update PromotionLoyaltyStatus
                        Set IsSatisfied = 0 , IsTaken = 0
                        From PromotionLoyaltyStatus
                        Inner Join
                        PromotionBenefitHistory ON PromotionLoyaltyStatus.PromotionID = PromotionBenefitHistory.PromotionID AND PromotionLoyaltyStatus.CustomerID = PromotionBenefitHistory.CustomerID
                        AND PromotionLoyaltyStatus.OutletID = PromotionBenefitHistory.OutletID
                        inner join Promotion on promotion.PromotionID = PromotionBenefitHistory.PromotionID and promotion.IsLoyaltyPromotion=1 
                        Where  PromotionBenefitHistory.TransactionID = '{2}' AND PromotionBenefitHistory.CustomerID ={0} AND PromotionBenefitHistory.OutletID = {1}
                         ", transaction.CustomerId, transaction.OutletId, transaction.TransactionId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
                #endregion
                if ((order.OrderStatus == OrderStatus.Invoiced && !_requestRepository.Configurations.AffectVanStockInDeliveryInFO && _requestRepository.Configurations.DeliveryMode.Contains(((int)DeliveryModes.BOInvoicingFODelivery).ToString()) && (_requestRepository.Configurations.AffectMainWarehouseUponOrderBOInvoicing || _requestRepository.Configurations.EnableOrderPreparationCycle))
                   || (order.OrderStatus == OrderStatus.Delivered && _requestRepository.Configurations.DeliveryMode.Contains(((int)DeliveryModes.BOInvoicingAndDelivery).ToString()) && _requestRepository.Configurations.AffectMainWarehouseUponOrderBOInvoicing))
                {
                    #region [Restore Voided Transaction Items]
                    if (result == GlobalErrors.Success)
                    {
                        List<ItemPackModel> notInStockList = transaction.AllItems.FindAll(x => !x.InStock).ToList();
                        List<ItemPackModel> inSCSList = transaction.AllItems.FindAll(x => !x.InSCS).ToList();
                        //result = _warehouseStockManager.RestoreVoidedTransactionItems(dbHelper, transaction.TransactionId, transaction.CustomerId, transaction.OutletId, transaction.EmployeeId, transaction.WarehouseId, (TransactionType)(transaction.TransactionTypeId), transaction.DivisionId, notInStockList);
                        //#region [Restore Serial Items]
                        //if (result == GlobalErrors.Success)
                        //{
                        //    int warehouseId = -1, ssccCount = 0;
                        //    result = _ssccGenerationManager.CheckIfTransactionOrOrderHasAddedSSCC(string.Empty, order.OrderId, ref warehouseId, ref ssccCount);
                        //    if (result == GlobalErrors.Success)
                        //    {
                        //        result = _serialManager.RestoreSerialsForVoidedTransaction(dbHelper, SerialStatus.LoadedToMainWarehouse, transaction.TransactionId, ssccCount > 0, _requestRepository.Configurations.EnableOrderPreparationCycle ? order.OrderId : "");
                        //    }
                        //    if (result == GlobalErrors.Success)
                        //    {
                        //        result = _warehouseStockManager.RestoreVoidedTransactionSerialItems(dbHelper, transaction.TransactionId, transaction.CustomerId, transaction.OutletId, transaction.EmployeeId, transaction.WarehouseId, (TransactionType)(transaction.TransactionTypeId), transaction.DivisionId, notInStockList);
                        //    }
                        //    else if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        //    {
                        //        result = GlobalErrors.Success;
                        //    }
                        //    if (result == GlobalErrors.Success && ssccCount > 0)
                        //    {
                        //        result = _ssccGenerationManager.UpdateLinkedSSCCStatusToActive(string.Empty, order.OrderId);
                        //    }
                        //}
                        //#endregion
                    }
                }
                #endregion

                #region [Update transaction set as voided]
                if (result == GlobalErrors.Success)
                {
                    // Set trasnaction as voided
                    query = string.Format("Update [Transaction] set Voided = 1 , TransactionStatusID = {0}  , UpdatedBy ={3}, UpdatedDate ={4} where TransactionID= '{1}' AND TransactionTypeID = {2}",
                   TransactionStatues.Voided.GetHashCode(),
                    transaction.TransactionId,
                   TransactionType.Sales.GetHashCode(),
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));

                    result = dbHelper.ExecuteNonQuery(query);
                }
                #endregion

                #region [UpdateTargetAgainstVoidedInvoices] 
                if (result == GlobalErrors.Success)
                {
                    result = _transactionManager.UpdateTargetsAgainstVoidedTransactions(transaction.TransactionId, dbHelper, transaction);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected) // this mean there are no achevement promotions taken in this transaction . 
                    result = GlobalErrors.Success;
                if ((result == GlobalErrors.Success) && !isPartialDelivery)
                {
                    //dbHelper = new DBHelper<int>();
                    List<AchievementTargetCustomer> neededTargets = new List<AchievementTargetCustomer>();
                    //result = _promotionManager.GetCustomerDefinedTargets(ref neededTargets, ref targetsString, transaction ,dbHelper);
                    if (result == GlobalErrors.Success)
                        result = _promotionManager.RunCalculateAchievementProcedure(transaction, true, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _promotionManager.DeleteVoidedDataFromPromotionsHistory(transaction.TransactionId, ref oldPromotionBenefitHistoryData, dbHelper);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = _promotionManager.DeleteVoidedDataFromAccumulativePromotionsHistory(CoreDataBaseConstants.TableNames.AccumulativePromotionsHistory, transaction.TransactionId, transaction.CustomerId, transaction.OutletId, dbHelper);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = _promotionManager.DeleteVoidedDataFromPromBenefitSequenceDetail(CoreDataBaseConstants.TableNames.PromBenefitSequenceDetail, transaction.TransactionId, transaction.CustomerId, transaction.OutletId, dbHelper);
                        }
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                }
                #endregion

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (commitNow && dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors AddOrderNote(OrderModel order, string note, int noteId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO SalesOrderNote (CustomerID,OutletID,OrderID,EmployeeID,NoteID,Note,NoteDate,DivisionID)
                VALUES ({0},{1},'{2}',{3},{4},'{5}',{6}, {7})",
                order.Outlet.CustomerId,
                order.Outlet.OutletId,
                order.OrderId,
                order.EmployeeId,
                noteId,
                note.Replace("'", "''").Trim(),
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                order.DivisionId);
                result = dbHelper.ExecuteNonQuery(query.ToString());
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveOrderNotes(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;

                query = string.Format(@"Delete From SalesOrderNote where CustomerID = {0} And OutletID = {1} And OrderID = '{2}'",
                order.Outlet.CustomerId, order.Outlet.OutletId, order.OrderId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query.ToString());

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success && order.Notes != null && order.Notes.Count > 0)
                {
                    for (int index = 0; index < order.Notes.Count; index++)
                    {
                        result = AddOrderNote(order, order.Notes[index], (index + 1), dbHelper);
                        if (result != GlobalErrors.Success)
                        {
                            break;
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public bool CheckIfOrderInPreparation(OrderModel orderModel)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                DBHelper<int> dbHelper = new DBHelper<int>();

                string query = string.Format(@" SELECT Count(*)
                FROM OrdersInPreparation
                WHERE OrderID = '{0}' AND CustomerID = {1} AND OutletID = {2}  AND StorekeeperID != {3} "
                   , orderModel.OrderId, orderModel.CustomerId, orderModel.OutletId, _requestRepository.CurrentOperator.EmployeeId);
                object field = new object();
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString().Trim()) && int.Parse(field.ToString()) > 0)
                {
                    return true;
                }
                else return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors SetOrderInPreparation(OrderModel orderModel)
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                DBHelper<int> dbHelper = new DBHelper<int>();

                string query = string.Format(@"DELETE FROM OrdersInPreparation WHERE ORDERID = '{0}'  AND CustomerID = {2} AND OutletID = {3} AND StorekeeperID = {1}
                                                INSERT INTO OrdersInPreparation VALUES ('{0}', {1}, {2}, {3}, {4})"
                                            , orderModel.OrderId
                                            , _requestRepository.CurrentOperator.EmployeeId
                                            , orderModel.CustomerId
                                            , orderModel.OutletId
                                            , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteOrderInPreparation()
        {
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                DBHelper<int> dbHelper = new DBHelper<int>();

                string query = string.Format(@"DELETE FROM OrdersInPreparation WHERE StorekeeperID = {0}"
                                            , _requestRepository.CurrentOperator.EmployeeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CheckOrderCanbeEdited(string orderId, int customerId, int outletId, ref bool canbeEdited)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<bool> dbHelper = null;
            canbeEdited = false;
            try
            {
                dbHelper = new DBHelper<bool>();
                string query = string.Format(@" SELECT CASE  WHEN (SalesOrder.OrderStatusID = 1 AND Synchronized <> 1) THEN 1 ELSE 0 END as AllowEdit
                FROM SalesOrder with (nolock)
                WHERE OrderID = '{0}' AND CustomerID = {1} AND OutletID = {2} ", orderId, customerId, outletId);
                object field = new object();
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    canbeEdited = Convert.ToBoolean(field);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors InsertIntoDeliveryAssignment(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // commit this code no need for  it
                //int maxDeliveryAssignmentID = GetMaxDeliveryAssignment(order, dbHelper);
                //if(maxDeliveryAssignmentID == -1)
                //{
                //    return GlobalErrors.Error;
                //}

                // Delete all assignments for the order
                int maxDeliveryAssignmentID = 1;
                string query = string.Format("Delete From DeliveryAssignment Where OrderId = '{0}' and CustomerId = {1} And OutletId = {2} And DivisionID = {3}",
                    order.OrderId, //0
                    order.CustomerId, //1
                    order.OutletId, //2
                    order.DivisionId //3
                    );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    StringBuilder sqlStatment = new StringBuilder();
                    sqlStatment.Append(@"INSERT INTO DeliveryAssignment
                     (OrderID ,EmployeeID, ScheduleDate
                    ,AssignmentDate ,DispatcherID, DeliveryStatusID
                    ,CustomerID,OutletID,SupervisorID,helperID,DeliveryAssignmentID
                    ,SalesManagerID,OrganizationID,DivisionID,DriverID,SalesRepID,Uploaded)  values ");
                    sqlStatment.Append("('");
                    sqlStatment.Append(order.OrderId); // order ID
                    sqlStatment.Append("',");
                    sqlStatment.Append(order.DriverId); // Employee ID
                    sqlStatment.Append(",");
                    sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(order.ScheduleDateModel.Date)); // ScheduleDate
                    sqlStatment.Append(",");
                    sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)); // AssignmentDate
                    sqlStatment.Append(",");
                    sqlStatment.Append(_requestRepository.CurrentOperator.EmployeeId);// DispatcherID
                    sqlStatment.Append(",");
                    sqlStatment.Append(DeliveryStatus.Assigned.GetHashCode()); // DeliveryStatusID
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.CustomerId); // CustomerID
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.OutletId); // OutletID
                    sqlStatment.Append(",");
                    sqlStatment.Append((order.SupervisorId == -1 ? "NULL" : order.SupervisorId.ToString())); // SupervisorId
                    sqlStatment.Append(",");
                    sqlStatment.Append((order.HelperId == -1 ? "NULL" : order.HelperId.ToString())); // helperID
                    sqlStatment.Append(",");
                    sqlStatment.Append(maxDeliveryAssignmentID); // DeliveryAssignmentID
                    sqlStatment.Append(",");
                    sqlStatment.Append((order.SalesManagerId == -1 ? "NULL" : order.SalesManagerId.ToString())); // SalesManagerID
                    sqlStatment.Append(",");
                    sqlStatment.Append((order.OrganizationId == -1 ? "NULL" : order.OrganizationId.ToString())); // OrganizationID
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.DivisionId); // DivisionID
                    sqlStatment.Append(",");
                    sqlStatment.Append("NULL"); // DriverID
                    sqlStatment.Append(",");
                    sqlStatment.Append((order.SalesRepId == -1 ? "NULL" : order.SalesRepId.ToString())); // SalesRepID
                    sqlStatment.Append(",");
                    sqlStatment.Append("0"); // Uploaded
                    sqlStatment.Append(")");

                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public int GetMaxDeliveryAssignment(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int maxDeliveryAssignmentID = -1;
            try
            {
                object field = new object();

                string query = string.Format(@"select isNULL(max(DeliveryAssignmentID) + 1  , 1) DeliveryAssignmentID from DeliveryAssignment Where OrderID = '{0}' AND EmployeeID={1}"
                                             , order.OrderId, order.DriverId);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()))
                {
                    maxDeliveryAssignmentID = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                maxDeliveryAssignmentID = -1;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return maxDeliveryAssignmentID;
        }
        public GlobalErrors EditOrder(OrderModel order)
        {
            return EditOrder(order, null);
        }
        public GlobalErrors EditWarehouseOrder(OrderModel order)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<OrderModel> dbHelper = new DBHelper<OrderModel>();
                string query = $"UPDATE SalesOrder SET WarehouseID = {order.WarehouseId} where OrderID = '{order.OrderId}' AND DivisionID ='{order.DivisionId}' ";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditOrder(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            bool AllowPromotion = true;
            bool commitNow = false;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    commitNow = true;
                }

                var numberOfDigits = _requestRepository.Configurations.NumberOfDigits;

                order.NetTotal = LocalUtilities.GetRoundedDecimal(order.NetTotal, numberOfDigits);
                order.GrossTotal = LocalUtilities.GetRoundedDecimal(order.GrossTotal, numberOfDigits);
                order.Discount = LocalUtilities.GetRoundedDecimal(order.Discount, numberOfDigits);
                order.Tax = LocalUtilities.GetRoundedDecimal(order.Tax, numberOfDigits);
                order.CalculatedRetailTax = LocalUtilities.GetRoundedDecimal(order.CalculatedRetailTax, numberOfDigits);
                order.PromotedDiscount = LocalUtilities.GetRoundedDecimal(order.PromotedDiscount, numberOfDigits);
                order.HeaderDiscount = LocalUtilities.GetRoundedDecimal(order.HeaderDiscount, numberOfDigits);
                order.Notes = new List<string>();
                if (order.Remarks != null && !string.IsNullOrEmpty(order.Remarks.Trim()))
                {
                    order.Notes.Add(order.Remarks);
                }
                result = UpdateOrderHeaders(order, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    result = UpdateOrderDetails(order, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = _promotionManager.UpdatePromotionBenefitHistoryData(order, order.CustomerPromotions, PromotionBenefitTransactionTypes.SalesOrder, AllowPromotion, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = UpdateRecurringOrder(order, dbHelper);
                }
                if (result == GlobalErrors.Success)
                {
                    result = SaveOrderNotes(order, dbHelper);
                }
                if (order.ModifyReasonId > 0 && order.ModifySourceId > 0)
                {
                    result = SaveOrderChangeHistory(order, dbHelper, OrderModificationTypes.Edit);
                }
                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    _notificationManager.SendOrderUpdatedNotificationToCustomerApp(order.CustomerId, order.OutletId, order.EmployeeId, order.OrderId, order.OrderStatus, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (commitNow)
                    {
                        if (result == GlobalErrors.Success)
                        {
                            dbHelper.CommitTransaction();
                        }
                        else
                        {
                            dbHelper.RollBackTransaction();
                        }
                    }
                    dbHelper.Dispose();
                }
            }
            return result;
        }
        public bool CheckOrderStatusBeforeAnyAction(OrderModel order, DBHelper<int> dbHelper)
        {
            int currentOrderStatusId = -1;
            return CheckOrderStatusBeforeAnyAction(order, ref currentOrderStatusId, dbHelper);
        }

        public bool CheckOrderStatusBeforeAnyAction(OrderModel order,ref int currentOrderStatusId, DBHelper<int> dbHelper)
        {
            if (dbHelper == null)
            {
                dbHelper = new DBHelper<int>();
            }
           
            GlobalErrors result = GlobalErrors.NotInitialized;
            OrderModel tempOrder = new OrderModel();
            bool isValid = false;
            try
            {
                tempOrder.OrderId = order.OrderId;
                tempOrder.CustomerId = order.CustomerId;
                tempOrder.OutletId = order.OutletId;
                tempOrder.DivisionId = order.DivisionId;
                result = GetLastOrderStatus(ref tempOrder, dbHelper);
                currentOrderStatusId = tempOrder.OrderStatusId;
                if (result == GlobalErrors.Success)
                {
                    if (tempOrder.OrderStatusId == OrderStatus.None.GetHashCode())
                    {
                        // in add mode
                        isValid = true;
                        return isValid;
                    }
                    if (tempOrder.OrderStatusId == order.OrderStatusFromUI.GetHashCode())
                    {
                        isValid = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isValid;
        }
        public bool CheckPreparedOrderStatusBeforeAnyAction(OrderModel order)
        {
            DBHelper<int> dbHelper = new DBHelper<int>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            OrderModel tempOrder = new OrderModel();
            bool isValid = false;
            try
            {
                tempOrder.OrderId = order.OrderId;
                tempOrder.CustomerId = order.CustomerId;
                tempOrder.OutletId = order.OutletId;
                tempOrder.DivisionId = order.DivisionId;
                result = GetLastOrderStatus(ref tempOrder, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    if (tempOrder.OrderStatusId == order.SelectedOrderStatusId)
                    {
                        isValid = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isValid;
        }
        public GlobalErrors GetPreparedOrderList(OrderListFilter filter, ref SharedTableResult<OrderModel> orderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<OrderModel> dbHelper = new DBHelper<OrderModel>();
                List<OrderModel> orders = new List<OrderModel>();

                string query = string.Format(@"SELECT 
                                SO.OrderID,
                                CL.Description CustomerName,
                                OL.Description OutletName,
                                ISNULL(EL.Description, '') AssignTo,
                                SO.OrderDate
                                FROM SalesOrder SO
                                LEFT OUTER JOIN CustomerLanguage CL ON CL.CustomerID = SO.CustomerID AND CL.LanguageID = {0}
                                LEFT OUTER JOIN CustomerOutletLanguage OL ON OL.CustomerID = SO.CustomerID AND OL.OutletID = SO.OutletID AND OL.LanguageID = {0}
                                LEFT OUTER JOIN DeliveryAssignment on SO.OrderID = DeliveryAssignment.OrderID 
                                AND SO.CustomerID = DeliveryAssignment.CustomerID 
                                AND SO.outletID = DeliveryAssignment.outletID and SO.DivisionID = DeliveryAssignment.DivisionID 
                                left outer join EmployeeLanguage EL on EL.EmployeeID = DeliveryAssignment.EmployeeID AND EL.LanguageID = {0}
                                WHERE OrderStatusID = {2} AND UpdatedBy = {1}
                                ORDER BY OrderDate DESC
                                OFFSET {3} ROWS FETCH NEXT {4} ROWS ONLY "
                                , _requestRepository.LanguageId
                                , _requestRepository.CurrentOperator.EmployeeId
                                , OrderStatus.Prepared.GetHashCode()
                                , (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize
                                , filter.CustomListFilter.PageSize);
                result = dbHelper.GetQueryList(query, ref orders,true);
                if (result == GlobalErrors.Success && orders != null)
                {
                    orderList.Data = orders;
                    orderList.TotalItems = orders.Count;
                }
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAssignedOrderList(OrderListFilter filter, ref SharedTableResult<OrderModel> orderList , bool isExportMode = false)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            List<OrderModel> orders = new List<OrderModel>();
            string customerConfigPriority = string.Empty;
            try
            {            
                dbHelper = new DBHelper<OrderModel>();
                string dataQuery = string.Empty;
                string orderByFilter = string.Empty;
                string groupByFilter = string.Empty;
                var mainQuery = new StringBuilder();
                var orderStatus = string.Empty;
                var deliveryStatus = string.Empty;
                var invoicedOrdersFilter = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string getPageSizeRows = string.Empty;
                var extraConditionForQuery = string.Empty;
                var driverIdField = "-1";
                string extraConditionForEmployee = string.Empty;
                string ssccFilter = string.Empty;
                string ssccWhereCondition = string.Empty;
                string supervisionJoin = string.Empty;
                string showReturnBtn = string.Empty;
                string OrderTypeCondition = string.Empty;
                string divisionSelection = string.Empty;
                string divisionJoin = string.Empty;
                string divisionGroupBy = string.Empty;
                string divisionSearch = string.Empty;
                string storeKeeperGroupBy = string.Empty;
                string orderPrepartionFilter = string.Empty, orderPrepartionSelection = string.Empty;
                string areaFilter = string.Empty;
                string showVoidBtnSelect = string.Empty;
                string showReassignBtnSelect = string.Empty;
                string custConfigJoin = string.Empty;
                string custConfigGroup = string.Empty;
                string transactionJoin = string.Empty;
                string routeHistoryIDSelection = string.Empty;
                string transactionGroup = string.Empty;
                string returnHistoryJoin = string.Empty;
                string returnHistorySelect = string.Empty;
                string returnHistoryGroupBy = string.Empty;
                string transactionIDColumn = string.Empty;
         
                if(filter.OrderOperation != OrderOperation.GetPrepared && filter.OrderOperation != OrderOperation.GetCancelPrepared)
                {
                    returnHistoryJoin = " LEFT OUTER JOIN ReturnInvoicesPacksHistory RIPH on RIPH.ReturnTransactionID = SalesOrder.OrderID and RIPH.CustomerID = SalesOrder.CustomerID and RIPH.OutletID = SalesOrder.OutletID ";
                    returnHistorySelect = "  ,CASE WHEN RIPH.ReturnTransactionID IS NOT NULL THEN 1 ELSE 0 END AS IsRestrictedFromOldInvoices ";
                    returnHistoryGroupBy = " ,RIPH.ReturnTransactionID ";
                }


                transactionJoin = @" left join [Transaction] t on t.CustomerID = SalesOrder.CustomerID and t.OutletID = SalesOrder.OutletID and t.DivisionID = SalesOrder.DivisionID and t.SourceTransactionID = SalesOrder.OrderID AND t.Voided <> 1 ";
                routeHistoryIDSelection = " ,t.RouteHistoryID ";
                transactionGroup = " ,t.RouteHistoryID,t.CreationReason";

                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                //}
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode() 
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    if (_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                    {
                        if (filter.OrderOperation == OrderOperation.GetAssigned)
                        {
                            supervisionJoin = string.Format(@" And DeliveryAssignment.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                        }
                        else
                        {
                            supervisionJoin = string.Format(@" And salesOrder.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                        }
                    }
                    else
                    {
                        supervisionJoin = string.Format(@" And DeliveryAssignment.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                    }
                    
                }
                if (filter.OrderOperation == OrderOperation.GetInvoiced)
                {
                    OrderTypeCondition = $@" {OrderTypes.Sales.GetHashCode()}";
                }
                else
                {
                    OrderTypeCondition = filter.OrderTypeId != -1 ?
                        string.Format(@"{0}", filter.OrderTypeId) :
                        string.Format(@"{0},{1}", OrderTypes.Sales.GetHashCode(), OrderTypes.Return.GetHashCode());

                }
                
                if (filter.AreaId > -1 && filter.StreetId == -1)
                {
                    areaFilter = string.Format(@" Inner join Street on Street.StreetId = CustomerOutlet.StreetId
                                 Inner join Area on Area.AreaID = Street.AreaID and Area.AreaID = {0}", filter.AreaId);
                }
                switch (filter.OrderOperation)
                {
                    case OrderOperation.GetAssigned:
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        orderStatus = string.Format("{0},{1},{2}", (int)OrderStatus.Assigned, (int)OrderStatus.LoadRequestAccepted, (int)OrderStatus.WaitForLoad);
                        showReturnBtn = $",CASE WHEN salesOrder.OrderTypeID = {OrderTypes.Return.GetHashCode()} THEN 1 ELSE 0 END ShowReturnBtn" ;
                        break;

                    case OrderOperation.GetInvoice:
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        orderStatus = string.Format("{0},{1}", (int)OrderStatus.Assigned, (int)OrderStatus.LoadRequestAccepted);
                        break;
                    case OrderOperation.GetInvoiced:
                        deliveryStatus = string.Format("{0},{1}", (int)DeliveryStatus.Assigned, (int)DeliveryStatus.Delivered);

                        if (_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                        {
                            orderStatus = string.Format("{0},{1},{2}", (int)OrderStatus.Invoiced, (int)OrderStatus.Delivered, (int)OrderStatus.Rescheduled);
                        }
                        else
                        {
                            orderStatus = string.Format("{0},{1}", (int)OrderStatus.Invoiced, (int)OrderStatus.Delivered);
                        }
                        break;
                    case OrderOperation.GetForSSCC:
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        if (filter.IsFromStorekeeper)
                        {
                            filter.CustomListFilter.IsSortAscending = false;
                            filter.CustomListFilter.SortBy = "SalesOrder.OrderDate";
                            orderStatus = string.Format("{0},{1}", (int)OrderStatus.Assigned, (int)OrderStatus.PartiallyPrepared);
                            orderPrepartionSelection = string.Format(" , CASE WHEN OIP.OrderID IS NULL OR OIP.StorekeeperID = {0} THEN 0 ELSE 1 END IsOrderInPreparation ", _requestRepository.CurrentOperator.EmployeeId);
                            orderPrepartionFilter = " left outer join OrdersInPreparation OIP ON OIP.OrderID = SalesOrder.OrderID AND OIP.CustomerID = SalesOrder.CustomerID AND OIP.OutletID = SalesOrder.OutletID";
                            storeKeeperGroupBy = string.Format(@" ,OIP.OrderID, OIP.StorekeeperID");
                            transactionJoin = string.Empty;
                            routeHistoryIDSelection = string.Empty;
                            transactionGroup = string.Empty;
                        }
                        else
                            orderStatus = string.Format("{0},{1},{2},{3}", (int)OrderStatus.Assigned, (int)OrderStatus.LoadRequestAccepted, (int)OrderStatus.WaitForLoad, (int)OrderStatus.Approved);
                        if (filter.ExcludeLinkedWithSSCC)
                        {
                            ssccFilter = string.Format(@"  Inner join
                            (select  SalesOrder.DivisionID, SalesOrder.OrderID from 
							SalesOrder 
							left join (Select CustomerID,OutletID,DivisionID,OrderID,Sum(Quantity)Quantity From SalesOrderDetail
							Group By CustomerID,OutletID,DivisionID,OrderID) SalesOrderDetail on SalesOrderDetail.OrderID = SalesOrder.OrderID
							and SalesOrderDetail.CustomerID = SalesOrder.CustomerID
							and SalesOrderDetail.OutletID = SalesOrder.OutletID
							and SalesOrderDetail.DivisionID = SalesOrder.DivisionID
							Left Join (Select SSCCHeader.divisionid,SSCCHeader.OrderID,Sum(SSCCDetails.Quantity)Quantity From SSCCHeader
							Inner Join SSCCDetails On SSCCDetails.SSCCBarcode = SSCCHeader.SSCCBarcode
							Group By SSCCHeader.divisionid,SSCCHeader.OrderID) SSCC On SSCC.OrderID = SalesOrder.OrderID And  SSCC.DivisionID = SalesOrder.DivisionID
							Group By SalesOrder.DivisionID, SalesOrder.OrderID
							having isnull(sum(SSCC.quantity),0) <> isnull(sum(SalesOrderDetail.quantity),0)) tt on SalesOrder.OrderID = tt.OrderID and SalesOrder.DivisionID = tt.DivisionID ");
                            ssccWhereCondition = "";
                        }
                        break;
                    case OrderOperation.GetCollected:
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        orderStatus = string.Format("{0}", (int)OrderStatus.Collected);
                        break;
                    case OrderOperation.GetPrepared:
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        orderStatus = string.Format("{0}", (int)OrderStatus.Prepared);
                        break;
                    case OrderOperation.GetCancelPrepared:
                        transactionIDColumn = " , t.TransactionID ";
                        deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                        orderStatus = string.Format("{0},{1},{2},{3},{4}", (int)OrderStatus.Approved, (int)OrderStatus.Assigned, (int)OrderStatus.Prepared, (int)OrderStatus.PartiallyPrepared, (int)OrderStatus.Canceled);
                        break;
                }



                if (!_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder && filter.OrderOperation != OrderOperation.GetCollected)
                {
                    extraConditionForQuery = string.Format(" And ( DeliveryAssignment.DeliveryStatusID in ({0}) or DeliveryAssignment.DeliveryStatusID is null)", deliveryStatus);
                }
                else
                {
                    if (filter.OrderStatus == OrderStatus.Assigned)
                    {
                        extraConditionForQuery = string.Format(" And DeliveryAssignment.DeliveryStatusID in ({0})", deliveryStatus);
                    }


                //    if (filter.OrderStatus == OrderStatus.Invoiced && !string.IsNullOrWhiteSpace(filter.EmployeeCode))
                //    {
                //        driverIdField = string.Format(@"(isnull((select EmployeeID from Employee where Employee.EmployeeCode = '{0}'), (select e.EmployeeID
                //from Warehouse w
                //inner join EmployeeVehicle e on w.WarehouseID = e.VehicleID and w.WarehouseTypeID = 2 and w.Barcode = '{0}'
                //left join employee em on em.EmployeeID = e.EmployeeID)))  ", filter.EmployeeCode = !string.IsNullOrEmpty(filter.EmployeeCode) ? filter.EmployeeCode : "");
                //    }
               }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionSelection = string.Format(@" ISNULL (DivisionLanguage.Description,'') Division, IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,");
                    divisionJoin = string.Format(@" LEFT OUTER JOIN Division on Division.DivisionID = SalesOrder.DivisionID 
                                   LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                    divisionGroupBy = string.Format(@", DivisionLanguage.Description , Division.DivisionCode ");

                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                        divisionSearch = string.Format(@" OR (DivisionLanguage.Description LIKE '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());

                }

                if (_requestRepository.Configurations.AllowReAssignInovicedOrders && filter.OrderOperation == OrderOperation.GetInvoiced)
                {
                    showReassignBtnSelect = string.Format(@" , CASE WHEN SalesOrder.OrderStatusID in ({0}) THEN 1 ELSE 0 END ShowReassignBtn " , OrderStatus.Invoiced.GetHashCode());
                }

                //if (filter.DriverId != -1 && _requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                //{
                //    extraConditionForEmployee = string.Format(@" and ET.EmployeeID = {0}", filter.DriverId);
                //}
                if(!filter.IsFromStorekeeper)
                {
                    customerConfigPriority = $@" Declare @t table (ConfigurationID int, CustomerID int, OutletID int ,KeyValue nvarchar(10), rowNumber int )
                Insert into @t 
                select tt.ConfigurationID, tt.CustomerID, tt.OutletID, tt.KeyValue,
                row_number ( )  OVER (PARTITION BY tt.customerid,tt.outletid ORDER BY tt.Priority ASC) AS rowNumber from
                ( 
                select CCO.ConfigurationID,  CCO.CustomerID ,CCO.OutletID , CCO.KeyValue, 1 Priority from ConfigurationCustOut CCO
                INNER JOIN Customer C on C.CustomerID = CCO.CustomerID
                INNER JOIN CustomerOutlet CO on CO.CustomerID = CCO.CustomerID AND CO.OutletID = CCO.OutletID
                WHERE KeyName = ('DeliveryMode')  
                union
                select ConfigurationID,COG.CustomerID, COG.OutletID ,KeyValue, 2 Priority
                from ConfigurationCustomerGroup CCG
                INNER JOIN CustomerGroup CG on CG.GroupID = CCG.GroupID
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CCG.GroupID
                WHERE KeyName = ('DeliveryMode') 
                union
                select 
                CC.ConfigurationID, COG.CustomerID, COG.OutletID ,CC.KeyValue, 3 Priority from ConfigurationChannel CC
                INNER JOIN Channel C on CC.ChannelID = C.ChannelID
                INNER JOIN SubChannel SC on SC.ChannelID = C.ChannelID AND CC.SubChannelID = SC.SubChannelID
                INNER JOIN CustomerGroup CG on CG.SubChannelID = SC.SubChannelID and CG.ChannelID = C.ChannelID 
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CG.GroupID
                WHERE KeyName = ('DeliveryMode') 
                ) as tt ";

                    showVoidBtnSelect = string.Format(@" ,
                            CASE WHEN ((SalesOrder.OrderStatusID in ({0}) and (CASE WHEN custconfig.KeyValue IS NOT NULL THEN custconfig.KeyValue ELSE '{7}' END) like '%{5}%')  or (SalesOrder.OrderStatusID in ({1}) and (CASE WHEN custconfig.KeyValue IS NOT NULL THEN custconfig.KeyValue ELSE '{7}' END) like '%{6}%') ) and SalesOrder.OrderTypeID <> 2  THEN 1 ELSE 0 END ShowInvoiceBtn,
                            CASE WHEN (SalesOrder.OrderStatusID in ({0})  or ((SalesOrder.OrderStatusID in ({3}) and WarehouseTransaction.TransactionID is not null) and (CASE WHEN custconfig.KeyValue IS NOT NULL THEN custconfig.KeyValue ELSE '{7}'  END) like '%{6}%')) and SalesOrder.OrderTypeID <> 2  THEN 1 ELSE 0 END ShowDeliveryBtn,
                            CASE WHEN SalesOrder.OrderStatusID in ({2}) and t.RouteHistoryID = -1  THEN 1 ELSE 0 END ShowPartialDeliveryBtn ,
                            CASE WHEN (t.CreationReason IN ({1}) and SalesOrder.OrderStatusID in({2})) or(SalesOrder.OrderStatusID in({3},{4}) and (DeliveryAssignment.Uploaded is null or DeliveryAssignment.Uploaded = 0)) THEN 1 ELSE 0 END ShowVoidBtn",
                            OrderStatus.Assigned.GetHashCode(),//0
                            OrderStatus.LoadRequestAccepted.GetHashCode(),//1
                            OrderStatus.Delivered.GetHashCode(), //2
                            OrderStatus.Invoiced.GetHashCode(), //3
                            OrderStatus.Rescheduled.GetHashCode(), //4 
                            DeliveryModes.BOInvoicingFODelivery.GetHashCode(),//5
                            DeliveryModes.BOInvoicingThirdPartyDelivery.GetHashCode(), //6
                             _requestRepository.Configurations.DeliveryMode //7
                                                                             );

                    custConfigJoin = " Left join @t custconfig on custconfig.CustomerID = SalesOrder.CustomerID and custconfig.OutletID = SalesOrder.OutletID and custconfig.rowNumber = 1";

                    custConfigGroup = " ,custconfig.KeyValue";
                }
                else
                {
                   
                }
               

               mainQuery.AppendFormat(@"
                            Select
                            SalesOrder.OrderID,
                            SalesOrder.WarehouseTransactionID,
                            SalesOrder.OrderDate OrderDate ,
                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                            CustomerLanguage.Description CustomerName,
                            CustomerOutletLanguage.Description OutletName,
                            ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                            {24}
                            IsNull( Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                            IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                            SalesOrder.OrderStatusID OrderStatus,
                            OrderStatusLanguage.Description OrderStatusDescription,
                            case when SalesOrder.OrderTypeID = 3 then cast('Exchange' as nvarchar(100))
                            else OrderTypeLanguage.Description end OrderType,salesOrder.OrderTypeID ,
                            isNull(DeliveryAssignment.ScheduleDate,SalesOrder.DesiredDeliveryDate) ScheduleDate,
                                          isnull(DeliveryAssignment.EmployeeID,SalesOrder.EmployeeID) EmployeeId,
                                          isnull(DeliveryAssignment.EmployeeID,{8}) as DriverId,
                            isnull(EL.Description,'--') AssignTo,
                            SalesOrder.CustomerID ,
                            SalesOrder.OutletID,
                            SalesOrder.NetTotal,
                            SalesOrder.Discount,
                            SalesOrder.GrossTotal,
                            SalesOrder.Tax,
                            SalesOrder.HeaderDiscount,
                            SalesOrder.ExciseTax  CalculatedRetailTax,
                            SalesOrder.ExchangeRate,
                            SalesOrder.OrganizationID as OrganizationId,
                            SalesOrder.DivisionID,
                            SalesOrder.LPO,
                            SalesOrder.CustomerRef,
                            SalesOrder.PreviousOrderStatus,
                            CASE WHEN SalesOrder.OrderStatusID IN (13) THEN 0 ELSE 1 END AS ShowCancelBtn,
                            SalesOrder.Description {27} {31}
                            {30}
                            {32}
                            {21}
                            {22}
                            {34}
                            FROM SalesOrder
                            INNER JOIN Customer ON Customer.CustomerID=SalesOrder.CustomerID
                            inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                            Inner Join CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                            {26}
                            LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID  AND CustomerLanguage.LanguageID = {5}
                            and CustomerLanguage.OrganizationId in ({35})
                            LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {5}
                            LEFT OUTER JOIN OrderStatusLanguage ON SalesOrder.OrderstatusID = OrderStatusLanguage.OrderStatusID  AND  OrderStatusLanguage.LanguageID = {5}
                            {25}
                            LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID= {5}
                            INNER JOIN  Employee on Employee.EmployeeID = SalesOrder.EmployeeID
                            LEFT OUTER JOIN  EmployeeLanguage ON  SalesOrder.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {5}
                            left outer JOIN DeliveryAssignment on SalesOrder.OrderID = DeliveryAssignment.OrderID 
                            AND SalesOrder.CustomerID = DeliveryAssignment.CustomerID 
                            AND SalesOrder.outletID = DeliveryAssignment.outletID and SalesOrder.DivisionID = DeliveryAssignment.DivisionID 
                            left outer join EmployeeLanguage EL on EL.EmployeeID = DeliveryAssignment.EmployeeID AND EL.LanguageID = {5}
                            {29}
                            left join WarehouseTransaction on SalesOrder.WarehouseTransactionID = WarehouseTransaction.TransactionID    
                            {23}
                            {14}
                            {7}
                           {28}
                            {33}
                            where Customer.New <> 1 {15} And isnull(SalesOrder.RecallId,-1) = -1 And SalesOrder.OrderTypeID <> 4 {2} AND  SalesOrder.OrderStatusID in({4}) and SalesOrder.OrganizationID in ({6}) and SalesOrder.OrderTypeID in ({0}) {20}",
                OrderTypeCondition, //0
                TransactionCreationReason.OrderManualDeliveryBOInvoice.GetHashCode() + ", " + TransactionCreationReason.PartialDeliveryInBO.GetHashCode(), //1
                extraConditionForQuery, //2
                deliveryStatus,  //3
                orderStatus, //4
                _requestRepository.LanguageId, //5
                _requestRepository.CurrentOperator.OrganizationAccess, //6
                orgAccessJoin, //7
                driverIdField, //8
                OrderStatus.Delivered.GetHashCode(), //9
                OrderStatus.Invoiced.GetHashCode(), //10
                OrderStatus.Rescheduled.GetHashCode(), //11
                OrderStatus.Assigned.GetHashCode(), //12
                OrderStatus.LoadRequestAccepted.GetHashCode(),//, //13
                ssccFilter, //14
                ssccWhereCondition,//15
                DeliveryModes.BOInvoicingFODelivery.GetHashCode(),///16
                DeliveryModes.BOInvoicingThirdPartyDelivery.GetHashCode(), //17
                _requestRepository.Configurations.DeliveryMode, //18
                customerConfigPriority, //19
                supervisionJoin, //20
                showReturnBtn, //21
                orderPrepartionSelection, //22
                orderPrepartionFilter, //23
                divisionSelection, //24
                divisionJoin, //25
                areaFilter, //26
                showVoidBtnSelect, //27
                custConfigJoin ,//28
                transactionJoin, //29
                routeHistoryIDSelection, //30
                showReassignBtnSelect, // 31
                returnHistorySelect, //32
                returnHistoryJoin, //33
                transactionIDColumn, //34
                _requestRepository.CurrentOperator.OrganizationAccess //35

                //         extraConditionForEmployee //14
                );


                //if (!string.IsNullOrWhiteSpace(filter.ScanByOrderId) && _requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                //{
                //    mainQuery.AppendFormat(@" and((t.TransactionID LIKE '%{0}%')
                //                              OR (SalesOrder.OrderID LIKE '%{0}%')) ", filter.ScanByOrderId);
                //}
                //if (!string.IsNullOrWhiteSpace(filter.EmployeeCode) && _requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                //{
                //    mainQuery.AppendFormat(@" AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                //                              IN (Select Distinct ( CAST(CustomerID as nvarchar)  + '_' + CAST(OutletID as nvarchar)) 
                //                              From CustOutTerritory 
                //                              Where TerritoryID = (Select TerritoryID From EmployeeTerritory 
                //                              Where EmployeeID = isnull((select EmployeeID from Employee where  Employee.EmployeeCode  = '{0}'),(select e.EmployeeID
                //                              from Warehouse w
                //                              inner join EmployeeVehicle e on w.WarehouseID = e.VehicleID and w.WarehouseTypeID = 2 and w.Barcode = '{0}'
                //                              left join employee em on em.EmployeeID = e.EmployeeID) )))", filter.EmployeeCode);
                //}

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {

                    var extraFields = !_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder || filter.OrderStatus == OrderStatus.Assigned ? "OR ((EmployeeLanguage.Description LIKE '%" + filter.CustomListFilter.SearchFilter.Trim() + "%') OR ( DeliveryAssignment.ScheduleDate LIKE '%" + filter.CustomListFilter.SearchFilter.Trim() + "%'))" : string.Empty;
                    var transactionId = filter.OrderOperation == OrderOperation.GetCancelPrepared ? "OR (t.TransactionID LIKE '%" + filter.CustomListFilter.SearchFilter.Trim() + "%')" : string.Empty;
                    mainQuery.AppendFormat(@"and( ( (SalesOrder.OrderID LIKE '%{1}%')
                             {3}
                             {3}
                             OR ( CustomerOutletLanguage.Description LIKE '%{1}%')
                            OR ( SalesOrder.OrderDate LIKE '%{1}%')
                            OR ( OrderStatusLanguage.Description LIKE '%{1}%')
                            OR ( customer.CustomerCode LIKE '%{1}%' )) {0} {2} )", extraFields, filter.CustomListFilter.SearchFilter.Trim(), transactionId.Trim(),divisionSearch);
                }
                if (filter.DivisionId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.DivisionID = {0}", filter.DivisionId);
                }
                if (filter.CustomerId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.CustomerID = {0}", filter.CustomerId);
                }

                if (filter.OutletId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.OutletID = {0}", filter.OutletId);
                }

                if (filter.StreetId != -1)
                {
                    mainQuery.AppendFormat(@" And CustomerOutlet.StreetID = {0}", filter.StreetId);
                }

                if (filter.EmployeeId != -1)
                {
                    //if (!_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                        mainQuery.AppendFormat(@"And Employee.EmployeeID = {0}", filter.EmployeeId);
                }
                if (filter.DriverId != -1)
                {
                    if ((((filter.OrderOperation == OrderOperation.GetAssigned || !_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                        ||(_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder && filter.OrderOperation == OrderOperation.GetInvoiced)) && filter.OrderStatus == OrderStatus.Assigned) || filter.OrderStatus == OrderStatus.Prepared
                        || _requestRepository.Configurations.AllowReAssignInovicedOrders && filter.OrderOperation == OrderOperation.GetInvoiced)
                    {
                        mainQuery.AppendFormat(@"And DeliveryAssignment.EmployeeID = {0}", filter.DriverId);
                    }
                }
                if (filter.OrderDateRange != null && filter.OrderDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  SalesOrder.OrderDate>={0} and  SalesOrder.OrderDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.OrderDateRange[0].Year, filter.OrderDateRange[0].Month, filter.OrderDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.OrderDateRange[1].Year, filter.OrderDateRange[1].Month, filter.OrderDateRange[1].Day)));
                }
                if (filter.DesiredDeliveryDateRange != null && filter.DesiredDeliveryDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And (( DeliveryAssignment.ScheduleDate>=  {0}  and  DeliveryAssignment.ScheduleDate<=  {1} and DeliveryAssignment.OrderID is not null) or( SalesOrder.DesiredDeliveryDate>=  {0}  and  SalesOrder.DesiredDeliveryDate<=  {1} and DeliveryAssignment.OrderID is null)) "
                       , LocalUtilities.ParseDateToSQLString(new DateTime(filter.DesiredDeliveryDateRange[0].Year, filter.DesiredDeliveryDateRange[0].Month, filter.DesiredDeliveryDateRange[0].Day)),
                       LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.DesiredDeliveryDateRange[1].Year, filter.DesiredDeliveryDateRange[1].Month, filter.DesiredDeliveryDateRange[1].Day)));
                }

                if (filter.AssignmentDateRange != null && filter.AssignmentDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  DeliveryAssignment.AssignmentDate>={0} and  DeliveryAssignment.AssignmentDate<={1} "
                    , LocalUtilities.ParseDateToSQLString(new DateTime(filter.AssignmentDateRange[0].Year, filter.AssignmentDateRange[0].Month, filter.AssignmentDateRange[0].Day)),
                    LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.AssignmentDateRange[1].Year, filter.AssignmentDateRange[1].Month, filter.AssignmentDateRange[1].Day)));
                }
                if (!filter.IsFromReassignButton)
                {
                    if (filter.DriverId != -1 && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                    {
                        if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                        {
                            mainQuery.AppendFormat(@"AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(CustomerID as nvarchar)  + '_' + CAST(OutletID as nvarchar)) 
                        From CustOutTerritory 
                        Where TerritoryID = (Select TerritoryID From EmployeeTerritory Where EmployeeID = {0}))", filter.DriverId);
                        }
                        else
                        {
                            mainQuery.AppendFormat(@"AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(RouteCustomer.CustomerID as nvarchar)  + '_' + CAST(RouteCustomer.OutletID  as nvarchar))  
                        From Route
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID AND EmployeeTerritory.EmployeeID = {0}
                        INNER JOIN RouteCustomer on RouteCustomer.RouteID = Route.RouteID)", filter.DriverId);
                        }
                    }
                }
                groupByFilter = string.Format(@" group by SalesOrder.OrderID,SalesOrder.WarehouseTransactionID, 
                            SalesOrder.OrderDate  ,
                            SalesOrder.DesiredDeliveryDate ,
                            CustomerLanguage.Description ,
                            CustomerOutletLanguage.Description ,
                            ISNULL (EmployeeLanguage.Description,''),Customer.CustomerCode,CustomerOutlet.CustomerCode,
                            SalesOrder.OrderStatusID,OrderStatusLanguage.Description,SalesOrder.OrderTypeID,OrderTypeLanguage.Description,DeliveryAssignment.ScheduleDate,DeliveryAssignment.EmployeeID,SalesOrder.EmployeeID,
                            SalesOrder.CustomerID,SalesOrder.OutletID,SalesOrder.NetTotal,SalesOrder.Discount,SalesOrder.GrossTotal,SalesOrder.Tax,
                            SalesOrder.HeaderDiscount,
                            SalesOrder.ExciseTax  ,
                            SalesOrder.ExchangeRate,
                            SalesOrder.OrganizationID  ,
                            SalesOrder.DivisionID,
                            SalesOrder.LPO,
                            SalesOrder.CustomerRef,
                            SalesOrder.PreviousOrderStatus,WarehouseTransaction.TransactionID {3} ,DeliveryAssignment.Uploaded,EL.Description ,
							SalesOrder.Description {2} {4} {0} {1} {5} ", divisionGroupBy, storeKeeperGroupBy,custConfigGroup,transactionGroup,returnHistoryGroupBy, transactionIDColumn);

                if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"ORDER BY SalesOrder.OrderID");
                }
                else
                {
                    orderByFilter = string.Format(@"Order By {0} {1} "
                    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }
                if (!filter.GetAllData)
                {
                    getPageSizeRows = string.Format("  OFFSET {0} ROWS FETCH NEXT {1} ROWS ONLY", (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
                                 filter.CustomListFilter.PageSize);
                }
                
                    dataQuery = string.Format(@" {0} {1} {2} {3}",
                mainQuery.ToString(), //0
                groupByFilter, //1
                orderByFilter, //2
                isExportMode ? "" : getPageSizeRows //3
                );
                if (!isExportMode)
                {
                    object objField = 0;
                    if(!string.IsNullOrWhiteSpace(filter.ScanByOrderId) && !string.IsNullOrEmpty(filter.EmployeeCode) && _requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                    {
                        dataQuery = string.Format(@"Select 
                                                SalesOrder.OrderID,
                                                SalesOrder.OrderDate OrderDate ,
                                                SalesOrder.orderStatusId,
                                                SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                                                SalesOrder.DesiredDeliveryDate ScheduleDate,
                                                SalesOrder.EmployeeID EmployeeId,
                                                isnull(EMP.EmployeeID,EV.EmployeeID)  DriverId,
                                                SalesOrder.CustomerID ,
                                                SalesOrder.OutletID,
                                                SalesOrder.DivisionID,
                                                case when   t.TransactionId <> '{0}' then  NULL else t.TransactionId end transactionId
                                                ,SalesOrder.Description
                                                FROM SalesOrder
                                                INNER JOIN Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                                Inner Join CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                                LEFT OUTER JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                                                INNER JOIN  Employee on Employee.EmployeeID = SalesOrder.EmployeeID
                                                left join [Transaction] t on t.CustomerID = SalesOrder.CustomerID
                                                and t.OutletID = SalesOrder.OutletID and t.DivisionID = SalesOrder.DivisionID
                                                and t.SourceTransactionID = SalesOrder.OrderID AND t.Voided <> 1
                                                left join WarehouseTransaction on SalesOrder.WarehouseTransactionID = WarehouseTransaction.TransactionID                             
                                                {2}
                                                outer apply(Select top 1 TerritoryID from [CustOutTerritory] c where c.CustomerID = SalesOrder.CustomerID and c.OutletID = SalesOrder.OutletID  ) COT
                                                --left join CustOutTerritory COT on COT.CustomerID = SalesOrder.CustomerID and COT.OutletID = SalesOrder.OutletID
                                                left join EmployeeTerritory ET on et.TerritoryID = COT.TerritoryID
                                                left join Employee EMP on EMP.EmployeeID = ET.EmployeeID and EMP.EmployeeCode = '{1}'
                                                
                                                outer apply(Select top 1 WarehouseID from [Warehouse] w where w.WarehouseTypeID = {4} and w.Barcode = '{1}') W
                                                --left join Warehouse W on w.WarehouseTypeID = {4}  and W.Barcode = '{1}'
                                                left join EmployeeVehicle EV on EV.VehicleID = W.WarehouseID 
                                                
                                                where Customer.New <> 1 and (SalesOrder.RecallId is null or SalesOrder.RecallId = -1) And SalesOrder.OrderTypeID <> 4  AND  SalesOrder.OrderStatusID in ({5},{6},{7}) 
                                                and SalesOrder.OrganizationID in ({3}) and SalesOrder.OrderTypeID = 1  and (t.TransactionID = '{0}' or SalesOrder.OrderID = '{0}')
                                                ",
                                                     filter.ScanByOrderId, //0
                                                     filter.EmployeeCode, //1
                                                     orgAccessJoin, //2
                                                     _requestRepository.CurrentOperator.OrganizationAccess, //3
                                                     WarehouseType.Vehicle.GetHashCode(), //4
                                                     (int)OrderStatus.Invoiced,
                                                     (int)OrderStatus.Delivered,
                                                     (int)OrderStatus.Rescheduled
                                                     );
                        orderList.TotalItems = 1;
                        result = GlobalErrors.Success;
                    }
                    else
                    {
                        var countQuery = string.Format(@"{1}  Select IsNull(Count(*),0) From ({0} {2}) tt", mainQuery.ToString(), customerConfigPriority, groupByFilter);
                            result = dbHelper.ExecuteScalar(countQuery, ref objField,true);
                            if (result == GlobalErrors.Success && objField != null)
                                orderList.TotalItems = int.Parse(objField.ToString().Trim());
                    }

                    if (result == GlobalErrors.Success && objField != null)
                    {
                        dataQuery = string.Format(@"{0} {1}", customerConfigPriority, dataQuery);
                        result = dbHelper.GetQueryList(dataQuery, ref orders,true);
                        orderList.Data = orders;
                    }
                }
                else if (isExportMode)
                {
                    dataQuery = string.Format(@"{0} {1}", customerConfigPriority, dataQuery);
                    result = dbHelper.GetQueryList(dataQuery, ref orders,true);
                    orderList.Data = orders;
                }  
                else
                { 
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public async Task<List<OrderDashboards>> GetTopItemsDashboard(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new List<OrderDashboards>();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<OrderDashboards> dBHelper = new DBHelper<OrderDashboards>();

                if (isToday)
                {
                    dateFilter = "AND Convert(date ,OrderDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = "AND MONTH(OrderDate) = MONTH(GetDate()) AND YEAR(OrderDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = "AND YEAR(OrderDate) = YEAR(GetDate())";
                }

                string query = string.Format(@" Select TOP (10) (ItemLanguage.Description + ' (' + PackTypeLanguage.Description +')' ) Name , SUM(SalesOrderDetail.Quantity) Value
                 From SalesOrderDetail
                 INNER JOIN SalesOrder on SalesOrder.OrderID = SalesOrderDetail.OrderID {2}
                 INNER JOIN Pack on Pack.PackID = SalesOrderDetail.PackID
                 INNER JOIN PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                 INNER JOIN ItemLanguage on ItemLanguage.ItemID = Pack.ItemID AND ItemLanguage.LanguageID = {0}
                 Where SalesOrderDetail.SalesTransactionTypeID = {1} AND SalesOrder.OrganizationID in ({3})
                 Group by SalesOrderDetail.PackID , ItemLanguage.Description , PackTypeLanguage.Description
                 ORDER BY Value DESC"
                , _requestRepository.LanguageId
                , (int)SalesTransactionTypes.Sales
                , dateFilter
                , _requestRepository.CurrentOperator.OrganizationAccess);

                var result = await Task.Run(() => dBHelper.GetQueryList(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public async Task<List<OrderDashboards>> GetOrdersByStatus(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new List<OrderDashboards>();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<OrderDashboards> dBHelper = new DBHelper<OrderDashboards>();

                if (isToday)
                {
                    dateFilter = " AND Convert(date ,OrderDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = " AND MONTH(OrderDate) = MONTH(GetDate()) AND YEAR(OrderDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = " AND YEAR(OrderDate) = YEAR(GetDate())";
                }

                string query = string.Format(@"select Count(*) As Value ,OSL.Description As Name
                From SalesOrder
                INNER JOIN OrderStatusLanguage OSL on Osl.OrderStatusID = SalesOrder.OrderStatusID and LanguageID = {0}
                Where SalesOrder.OrderStatusID Not In({3}) And SalesOrder.OrganizationID in ({2})  {1}
                group by Salesorder.OrderStatusID , OSL.Description"
                , _requestRepository.LanguageId//0
                , dateFilter//1
                , _requestRepository.CurrentOperator.OrganizationAccess//2
                ,(int)OrderStatus.Splitted//3
                );

                var result = await Task.Run(() => dBHelper.GetQueryList(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public async Task<VolumeDashboards> GetOverAllOrders(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new VolumeDashboards();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<VolumeDashboards> dBHelper = new DBHelper<VolumeDashboards>();

                if (isToday)
                {
                    dateFilter = "Convert(date ,OrderDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = "MONTH(OrderDate) = MONTH(GetDate()) AND YEAR(OrderDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = "YEAR(OrderDate) = YEAR(GetDate())";
                }

                string query = string.Format(@"Select SUM(SalesOrder.NetTotal) TotalIncome , COUNT(*) TotalCount 
                From SalesOrder 
                Where {0} AND OrderStatusID NOT IN ({1} , {2} , {3} , {4}, {6}) AND SalesOrder.OrganizationID in ({5})"
                , dateFilter//0
                , (int)OrderStatus.Canceled//1
                , (int)OrderStatus.Deleted//2
                , (int)OrderStatus.OnHold//3
                , (int)OrderStatus.Rejected//4
                , _requestRepository.CurrentOperator.OrganizationAccess//5
                , (int)OrderStatus.Splitted//6
                );

                var result = await Task.Run(() => dBHelper.GetQuerySingle(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public async Task<VolumeDashboards> GetReadyToDeliveryOrder(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new VolumeDashboards();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<VolumeDashboards> dBHelper = new DBHelper<VolumeDashboards>();

                if (isToday)
                {
                    dateFilter = "Convert(date ,DS.ScheduleDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = "MONTH(DS.ScheduleDate) = MONTH(GetDate()) AND YEAR(DS.ScheduleDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = "YEAR(DS.ScheduleDate) = YEAR(GetDate())";
                }

                string query = string.Format(@"Select SUM(SalesOrder.NetTotal) TotalIncome , COUNT(*) TotalCount 
                From SalesOrder 
                INNER JOIN DeliveryAssignment DS on DS.OrderID = SalesOrder.OrderID AND DS.DeliveryStatusID = {0}  AND {1}
                Where SalesOrder.OrganizationID in ({2}) AND DS.DeliveryAssignmentID = (Select MAX(DeliveryAssignmentID) From DeliveryAssignment Where DeliveryAssignment.OrderID = SalesOrder.OrderID )"
                , (int)DeliveryStatus.Assigned
                , dateFilter,
                _requestRepository.CurrentOperator.OrganizationAccess);

                var result = await Task.Run(() => dBHelper.GetQuerySingle(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public async Task<VolumeDashboards> GetDeliveredOrdersValue(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new VolumeDashboards();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<VolumeDashboards> dBHelper = new DBHelper<VolumeDashboards>();

                if (isToday)
                {
                    dateFilter = "Convert(date ,TransactionDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = "MONTH(TransactionDate) = MONTH(GetDate()) AND YEAR(TransactionDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = "YEAR(TransactionDate) = YEAR(GetDate())";
                }

                string query = string.Format(@"	Select SUM(T.NetTotal) TotalIncome , COUNT(*) TotalCount 
	            From [Transaction] T 
	            INNER JOIN SalesOrder on SalesOrder.OrderID = T.SourceTransactionID
	            Where {0} AND  T.Voided <> 1 AND SalesOrder.OrganizationID in ({1})"
                , dateFilter,
                _requestRepository.CurrentOperator.OrganizationAccess);

                var result = await Task.Run(() => dBHelper.GetQuerySingle(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public async Task<VolumeDashboards> GetAllPendingOrdersDashboard(bool isToday, bool isMonthly, bool isAnnual)
        {
            var data = new VolumeDashboards();
            var dateFilter = string.Empty;
            try
            {
                DBHelper<VolumeDashboards> dBHelper = new DBHelper<VolumeDashboards>();

                if (isToday)
                {
                    dateFilter = "Convert(date ,OrderDate) = Convert(date ,GetDate())";
                }
                else if (isMonthly)
                {
                    dateFilter = "MONTH(OrderDate) = MONTH(GetDate()) AND YEAR(OrderDate) = YEAR(GetDate())";
                }
                else if (isAnnual)
                {
                    dateFilter = "YEAR(OrderDate) = YEAR(GetDate())";
                }

                string query = string.Format(@"Select SUM(SalesOrder.NetTotal) TotalIncome , COUNT(*) TotalCount   
                From SalesOrder 
                Where OrderStatusID in (1 , 2) AND SalesOrder.OrganizationID in ({0}) AND {1}", _requestRepository.CurrentOperator.OrganizationAccess, dateFilter);

                var result = await Task.Run(() => dBHelper.GetQuerySingle(query, ref data));

                return data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        public GlobalErrors GetLastOrderDetails(string orderId, int customerId, int outletId, ref List<ItemPackModel> list)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                string query = string.Format(@"SELECT PackId ,Quantity RequiredQty, SalesOrderDetail.OrderID
                FROM SalesOrderDetail with (nolock)
                INNER JOIN SalesOrder with (nolock) ON SalesOrder.OrderID = SalesOrderDetail.OrderID AND SalesOrder.CustomerID = SalesOrderDetail.CustomerID
                AND SalesOrder.OutletID = SalesOrderDetail.OutletID AND SalesOrder.DivisionID = SalesOrderDetail.DivisionID
                INNER JOIN (SELECT SalesOrder.CustomerID, SalesOrder.OutletID, SalesOrder.DivisionID, Max(OrderDate) OrderDate FROM SalesOrder WHERE SalesOrder.OrderID <> '{0}' AND SalesOrder.CustomerID = {1} AND  SalesOrder.OutletID = {2} GROUP BY SalesOrder.CustomerID, SalesOrder.OutletID, SalesOrder.DivisionID) AS orders ON orders.CustomerID = SalesOrder.CustomerID
                AND orders.OutletID = SalesOrder.OutletID AND orders.DivisionID = SalesOrder.DivisionID AND SalesOrder.OrderDate = orders.OrderDate "
                , orderId, customerId, outletId);
                result = dBHelper.GetQueryList(query, ref list);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetLastOrderStatus(ref OrderModel order, DBHelper<int> dbHelper)
        {
            if(dbHelper == null)
            {
                dbHelper = new DBHelper<int>();
            }
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"Select OrderStatusID From SalesOrder  Where OrderID = '{0}' and DivisionID = {1} and CustomerID = {2} and OutletID = {3}"
                 , order.OrderId, order.DivisionId, order.CustomerId, order.OutletId);

                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    order.OrderStatusId = int.Parse(field.ToString());
                }

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetSuggestedOrderItems(int customerId, int outletId, ref List<ItemPackModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
                string query = $@"Select ForecastingDetails.*,ForecastingDetails.Quantity as RequiredQty ,ForecastingDetails.StockStatusID ,ForecastingDetails.SalesOrderTypeID ,SS.ColorID
                    ,IsNull(sot.TypeCode , '--') + ' ' + '-'+ ' ' + IsNull( sotl.Description , '--') as SalesOrderTypeCodeName,  color.Description Color, color.Description iconColor,
                    IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( il.Description , '--') as itemCodeName,  Item.ItemCategoryID,
                    CASE WHEN ISNULL(Item.DefaultPackID, -1) <> -1 then item.DefaultPackID ELSE LargestPack.PackID END AS PackID,
                    CASE WHEN ISNULL(Item.DefaultPackID, -1) <> -1 then (Select Quantity from pack where packid = Item.DefaultPackID) ELSE LargestPack.Quantity END As PackQuantity, 'fa fa-circle fa - 2x' As Icon
                    from ForecastingDetails 
	                inner join item on item.ItemID = ForecastingDetails.ItemID
					inner join ItemLanguage il on il.ItemID = item.ItemID and il.LanguageID = {_requestRepository.LanguageId}
                    inner join SalesOrderType sot on sot.SalesOrderTypeID = ForecastingDetails.SalesOrderTypeID
                    inner join SalesOrderTypeLanguage sotl on sotl.SalesOrderTypeID = ForecastingDetails.SalesOrderTypeID and sotl.LanguageID = {_requestRepository.LanguageId} 
                    inner join StockStatus SS on SS.StockStatusID = ForecastingDetails.StockStatusID
                    inner join StockStatusColors color on color.ColorID = SS.ColorID and color.LanguageID = {_requestRepository.LanguageId} 
                    CROSS APPLY (
					SELECT top 1 * FROM Pack where Pack.ItemID = item.ItemID order by Quantity DESC
					) LargestPack                    
                    Where ForecastingDetails.CustomerID = {customerId} and ForecastingDetails.OutletID = {outletId} and ForecastingDate = {LocalUtilities.ParseDateToSQLString(DateTime.Now)} 
                    order by ForecastingDetails.ItemID  ";
                List<ItemPackModel> itemsStockLevel = new List<ItemPackModel>();
                result = dBHelper.GetQueryList(query, ref list);
                //if (result == GlobalErrors.Success && itemsStockLevel != null && itemsStockLevel.Count > 0) 
                //{
                //    list = itemsStockLevel.GroupBy(i => i.ItemId).Select(grp => new ItemPackModel
                //    {
                //        ItemId = grp.Key,
                //        PackId = grp.FirstOrDefault().PackId,
                //        ItemCodeName = grp.FirstOrDefault().ItemCodeName,
                //        RequiredQty = grp.FirstOrDefault().Quantity,
                //        Icon = "fa fa-circle fa-2x",
                //        IconColor = "Transparent",
                //        ItemCategoryId = grp.FirstOrDefault().ItemCategoryId,
                //        SalesOrderTypeId = -1,
                //        SalesOrderTypes = grp.Select(el => new SalesOrderTypeModel { 
                //            SalesOrderTypeId = el.SalesOrderTypeId,
                //            SalesOrderTypeCodeName = el.SalesOrderTypeCodeName,
                //            StockStatusId = el.StockStatusId,
                //            Color = el.Color
                //        }).ToList()
                //    }).ToList();
                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetStockStatuses(ref List<SalesOrderTypeModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SalesOrderTypeModel> dBHelper = new DBHelper<SalesOrderTypeModel>();
                string query = $@"select StockStatus.*, StockStatusColors.Description Color from StockStatus
                inner join StockStatusColors on StockStatus.ColorID = StockStatusColors.ColorID
                where LanguageID = 1 and StockStatusID <> 5";
                List<SalesOrderTypeModel> itemsStockLevel = new List<SalesOrderTypeModel>();
                result = dBHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetNewOrderList(OrderListFilter filter, ref SharedTableResult<OrderModel> orderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            List<OrderModel> orders = new List<OrderModel>();
            string orderStatuses = string.Empty;
            try
            {
                dbHelper = new DBHelper<OrderModel>();

                string dataQuery = string.Empty;
                string empCustomers = string.Empty;
                string itemFilter = string.Empty;
                string orderTypeFilter = string.Empty;
                string orderByFilter = string.Empty;

                string groupByFilter = string.Empty;
                string divisionSelection = string.Empty;
                string divisionJoin = string.Empty;
                string divisionGroupBy = string.Empty;
                string searchFilter = string.Empty;

                string supervisionJoin = string.Empty;
                string approvalSelection = string.Empty;
                var mainQuery = new StringBuilder();
                StringBuilder orgAccessJoin = new StringBuilder();

                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                //}
                if (LocalUtilities.WebApplication == WebApplication.Echo && _requestRepository.CurrentOperator.EmployeeTypeId != EmployeeTypes.Employee.GetHashCode())
                {
                    empCustomers = string.Format(@"INNER JOIN CustOutTerritory ON CustomerOutlet.CustomerID = CustOutTerritory.CustomerID AND CustomerOutlet.OutletID = CustOutTerritory.OutletID
                                                   INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID AND EmployeeTerritory.EmployeeID = {0}", _requestRepository.CurrentOperator.EmployeeId);

                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" And SalesOrder.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                if (filter.ItemId != -1)
                {
                    itemFilter = string.Format(@"
                            CROSS APPLY ( SELECT TOP (1)  SalesOrderDetail.PackID  FROM SalesOrderDetail inner join pack on pack.packid = SalesOrderDetail.PackID
                            where pack.ItemId = {0} AND SalesOrderDetail.OrderID = SalesOrder.OrderID AND SalesOrderDetail.CustomerID = SalesOrder.CustomerID AND
			    			SalesOrderDetail.OutletID = SalesOrder.OutletID  AND SalesOrderDetail.DivisionID = SalesOrder.DivisionID) AS SalesItem" , filter.ItemId);
                }
                if (filter.OrderStatus.GetHashCode() == OrderStatus.Approved.GetHashCode())
                {
                    orderStatuses = string.Format(@"{0},{1}", OrderStatus.Approved.GetHashCode(), OrderStatus.Rescheduled.GetHashCode());
                }
                else
                {
                    orderStatuses = string.Format(@"{0},{1}", filter.OrderStatus.GetHashCode() , OrderStatus.NewWebOrder.GetHashCode());
                }
                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("6"))
                {
                    approvalSelection = string.Format(@" CASE 
					WHEN COALESCE(SalesOrder.ApprovalStatus, -1) = -1 THEN '{0}'
					WHEN COALESCE(SalesOrder.ApprovalStatus, -1) = 0 THEN '{2}' 
					ELSE CONCAT('{1}', SalesOrder.ApprovalStatus) 
					END AS OrderApprovalStatusName, " ,
                    ResourcesManager.TranslateKey("Desc_Active", _requestRepository.LanguageId),// 0
                    ResourcesManager.TranslateKey("Desc_Approved_from", _requestRepository.LanguageId), // 1
                    ResourcesManager.TranslateKey("Desc_Need_Approval", _requestRepository.LanguageId) // 2
                    );
                }

                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionSelection = string.Format(@" ISNULL (DivisionLanguage.Description,'') Division, IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,");
                    divisionJoin = string.Format(@" LEFT OUTER JOIN Division on Division.DivisionID = SalesOrder.DivisionID 
                                   LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                    divisionGroupBy = string.Format(@", DivisionLanguage.Description , Division.DivisionCode ");
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"OR ( DivisionLanguage.Description LIKE '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());
                    }
                }
                mainQuery.AppendFormat(@"Select 
                                    SalesOrder.WarehouseID,
                                    SalesOrder.OrderTypeID,
                                    SalesOrder.OrderID,
                                    SalesOrder.OrderDate OrderDate ,
                                    SalesOrder.OrderStatusID OrderStatus,
                                    CASE WHEN SalesOrder.OrderStatusID IN (7) AND DA.OrderID IS NOT NULL THEN DA.RescheduleDate ELSE SalesOrder.DesiredDeliveryDate END AS DesiredDeliveryDate,
                                    CASE WHEN SalesOrder.OrderStatusID IN (25) THEN 1 ELSE 0 END AS IsNewWebOrder,
                                    CustomerLanguage.Description CustomerName,
                                    CustomerOutletLanguage.Description OutletName,
									Customer.CustomerCode,
									CustomerOutlet.Phone CustomerPhoneNumber,
                                    CustomerOutlet.GPSLatitude,CustomerOutlet.GPSLongitude,
                                    ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                    {14}
                                    IsNull( Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                                    IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                                    SalesOrder.CustomerID ,
                                    SalesOrder.OutletID,
                                    SalesOrder.EmployeeID,
                                    SalesOrder.DivisionID,
                                    SalesOrder.RouteHistoryID,
                                    SalesOrder.CreationSource,
                                    SalesOrder.Tax,
                                    SalesOrder.GrossTotal,
                                    SalesOrder.NetTotal,
                                    SalesOrder.OrganizationID,
                                    SalesOrder.Discount,
                                    SalesOrder.WarehouseTransactionID,
                                    SalesOrder.CreatedBy,
                                    SalesOrder.CreatedDate,
                                    SalesOrder.DeliveryChargesId,
                                    SalesOrder.DeliveryTax,
                                    SalesOrder.DeliveryValue,
                                    SalesOrder.DriverId,
                                    OrderTypeLanguage.Description as OrderType,
									SalesNote.Note,
									CASE WHEN FOC.focCount > 0 THEN '{11}' ELSE '{12}' END AS HasunlimitedFOC,
                                    CASE WHEN SalesOrder.IsBundle = 1 THEN '{11}' ELSE '{12}' END AS BundleStatus,
                                    CASE WHEN SalesOrder.OrderTypeID <> {9} THEN 1 ELSE 0 END AS IsNotReturnOrder,
                                    Case when SalesOrder.OrderStatusID in {8} and SalesOrder.OrderTypeID <> {9} then 1 else 0 end ShowInvoiceBtn,
                                    CASE WHEN SalesOrder.OrderTypeID <> {9} THEN 1 ELSE 0 END AS ShowdeliveryBtn,
                                    CASE WHEN salesOrder.OrderTypeID = {9} THEN 1 ELSE 0 END ShowReturnBtn,
                                    CASE WHEN RIPH.ReturnTransactionID IS NOT NULL THEN 1 ELSE 0 END AS IsRestrictedFromOldInvoices,
                                    ISNULL(SDCID,-1) SDCID,
                                    SalesOrder.LPO,{13} ApprovalStatus,
                                    SalesOrder.SalesMode
                                    FROM
                                    SalesOrder
                                    INNER JOIN Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                    inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
									INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                    LEFT OUTER JOIN CustomerLanguage ON Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {1}
                                    and CustomerLanguage.OrganizationId in ({17})
                                    LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND  CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {1}
                                    LEFT OUTER JOIN OrderStatusLanguage ON SalesOrder.OrderstatusID = OrderStatusLanguage.OrderStatusID  AND  OrderStatusLanguage.LanguageID = {1}
                                    INNER JOIN  Employee on Employee.EmployeeID = salesorder.EmployeeID
                                    LEFT OUTER JOIN EmployeeLanguage ON SalesOrder.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {1}
                                    {15}
                                    LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID= {1}
			                        {10}
                                    OUTER APPLY (SELECT COUNT(*) AS focCount
                                    FROM SalesOrderDetail WHERE SalesOrderDetail.OrderID = SalesOrder.OrderID AND SalesOrderDetail.CustomerID = SalesOrder.CustomerID AND
                                    SalesOrderDetail.OutletID = SalesOrder.OutletID   AND SalesOrderDetail.DivisionID = SalesOrder.DivisionID and SalesOrderDetail.SalesTransactionTypeID = 2) AS FOC
                        
                                    OUTER APPLY ( SELECT TOP (1) SalesOrderNote.Note FROM SalesOrderNote WHERE SalesOrderNote.OrderID = SalesOrder.OrderID
                                    AND SalesOrderNote.CustomerID = SalesOrder.CustomerID AND SalesOrderNote.OutletID = SalesOrder.OutletID AND SalesOrderNote.DivisionID = SalesOrder.DivisionID) AS SalesNote
                                    LEFT OUTER JOIN DeliveryAssignment DA ON DA.OrderID = SalesOrder.OrderID AND DA.CustomerID = SalesOrder.CustomerID AND DA.OutletID = SalesOrder.OutletID AND DA.DivisionID = SalesOrder.DivisionID
                                    LEFT OUTER JOIN ReturnInvoicesPacksHistory RIPH on RIPH.ReturnTransactionID = SalesOrder.OrderID and RIPH.CustomerID = SalesOrder.CustomerID and RIPH.OutletID = SalesOrder.OutletID
                                    {4}
                                    {5}
                                    {16}
                                    where Employee.EmployeeID {2} and (SalesOrder.RecallId Is null or SalesOrder.RecallId = -1) And SalesOrder.orderTypeID <> 4 AND SalesOrder.OrderStatusID in  ({0}) And SalesOrder.OrganizationID in ({3}) and SalesOrder.OrderTypeID in ({6}) {7}",
                                    orderStatuses, //0
                                    _requestRepository.LanguageId, //1
                                    _employeeManager.GetSupervisorAccess(), //2
                                    _requestRepository.CurrentOperator.OrganizationAccess, // 3
                                    orgAccessJoin, //4
                                    empCustomers, //5
                                    filter.OrderTypeId != -1? string.Format(@"{0}", filter.OrderTypeId) : string.Format(@"{0},{1}", OrderTypes.Sales.GetHashCode(), OrderTypes.Return.GetHashCode()), //6
                                    supervisionJoin, //7
                                    (OrderStatus.Approved.GetHashCode(), OrderStatus.Rescheduled.GetHashCode()), //8
                                    OrderTypes.Return.GetHashCode(), //9
                                    itemFilter, // 10
                                    ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId), //11
                                    ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId), // 12
                                    approvalSelection, // 13
                                    
                                    divisionSelection, //14
                                    divisionJoin, //15
                                    searchFilter, //16
                                    _requestRepository.CurrentOperator.OrganizationAccess //17
                                    );
                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    mainQuery.AppendFormat(" AND SalesOrder.CreationSource = {0} ", CreationSource.Echo.GetHashCode());
                }

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    mainQuery.AppendFormat(@"and ( (SalesOrder.OrderID LIKE '%{0}%')
                            {1}
                            OR ( CustomerLanguage.Description LIKE '%{0}%')
                            OR ( CustomerOutletLanguage.Description LIKE '%{0}%')
                            OR ( EmployeeLanguage.Description LIKE '%{0}%')
                            OR ( Customer.CustomerCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim(), searchFilter);
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    if (filter.DivisionId != -1)
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID = {0}", filter.DivisionId);
                    }
                    else if (!string.IsNullOrWhiteSpace(_requestRepository.CurrentOperator.DivisionAccess))
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID in ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                    }
                    else
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID in (-1)");
                    }

                }
                if (filter.CustomerId != -1)
                {
                    mainQuery.AppendFormat(@" And SalesOrder.CustomerID = {0}", filter.CustomerId);
                }

                if (filter.OutletId != -1)
                {
                    mainQuery.AppendFormat(@" And SalesOrder.OutletID = {0}", filter.OutletId);
                }

                if (filter.EmployeeId != -1)
                {
                    mainQuery.AppendFormat(@" And SalesOrder.EmployeeID = {0}", filter.EmployeeId);
                }
                if (filter.IsBundle)
                {
                    mainQuery.AppendFormat(@" And SalesOrder.IsBundle = 1");
                }
                if (filter.hasUnlimitedFOC)
                {
                    mainQuery.AppendFormat(@" AND FOC.focCount > 0");
                }
                if (filter.WarehouseId !=-1)
                {
                    mainQuery.AppendFormat(@$" AND SalesOrder.WarehouseId = {filter.WarehouseId}");
                }
                if (filter.OrderDateRange != null && filter.OrderDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  SalesOrder.OrderDate>={0} and  SalesOrder.OrderDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.OrderDateRange[0].Year, filter.OrderDateRange[0].Month, filter.OrderDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.OrderDateRange[1].Year, filter.OrderDateRange[1].Month, filter.OrderDateRange[1].Day)));
                }
                if (filter.DesiredDeliveryDateRange != null && filter.DesiredDeliveryDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  SalesOrder.DesiredDeliveryDate>={0} and  SalesOrder.DesiredDeliveryDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.DesiredDeliveryDateRange[0].Year, filter.DesiredDeliveryDateRange[0].Month, filter.DesiredDeliveryDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.DesiredDeliveryDateRange[1].Year, filter.DesiredDeliveryDateRange[1].Month, filter.DesiredDeliveryDateRange[1].Day)));
                }
                if (filter.DriverId != -1 && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        mainQuery.AppendFormat(@" AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(CustomerID as nvarchar)  + '_' + CAST(OutletID as nvarchar)) 
                        From CustOutTerritory 
                        Where TerritoryID = (Select TerritoryID From EmployeeTerritory Where EmployeeID = {0}))", filter.DriverId);
                    }
                    else
                    {
                        mainQuery.AppendFormat(@" AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(RouteCustomer.CustomerID as nvarchar)  + '_' + CAST(RouteCustomer.OutletID  as nvarchar))  
                        From Route
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID AND EmployeeTerritory.EmployeeID = {0}
                        INNER JOIN RouteCustomer on RouteCustomer.RouteID = Route.RouteID)", filter.DriverId);
                    }
                }

                groupByFilter = string.Format(@" 
                            group by SalesOrder.OrderID,SalesOrder.WarehouseTransactionID, 
                            SalesOrder.OrderDate  ,
                            SalesOrder.DesiredDeliveryDate,
                            FOC.focCount,
							SalesOrder.IsBundle,
							SDCID,
							SalesOrder.SalesMode,
							SalesOrder.LPO,
                            ApprovalStatus,
							SalesNote.Note,
							SalesOrder.DriverId,
							SalesOrder.DeliveryValue,
							SalesOrder.DeliveryTax,
							SalesOrder.DeliveryChargesId,
							SalesOrder.CreationSource,
							SalesOrder.WarehouseID,
							SalesOrder.CreatedBy,
							DA.RescheduleDate,
							CustomerOutlet.GPSLongitude,
							DA.OrderID,
							SalesOrder.CreatedDate,
							CustomerOutlet.Phone,
							CustomerOutlet.GPSLatitude,
                            SalesOrder.DesiredDeliveryDate,
							SalesOrder.RouteHistoryID,
                            CustomerLanguage.Description ,
                            CustomerOutletLanguage.Description ,
                            EmployeeLanguage.Description,
                            Customer.CustomerCode,CustomerOutlet.CustomerCode,
                            SalesOrder.OrderStatusID,OrderStatusLanguage.Description,SalesOrder.OrderTypeID,OrderTypeLanguage.Description,DA.ScheduleDate,DA.EmployeeID,SalesOrder.EmployeeID,
                            SalesOrder.CustomerID,SalesOrder.OutletID,SalesOrder.NetTotal,SalesOrder.Discount,SalesOrder.GrossTotal,SalesOrder.Tax,
                            SalesOrder.HeaderDiscount,
                            SalesOrder.ExciseTax  ,
                            SalesOrder.ExchangeRate,
                            SalesOrder.OrganizationID  ,
                            SalesOrder.DivisionID,
                            SalesOrder.LPO,
                            SalesOrder.CustomerRef,
                            SalesOrder.PreviousOrderStatus, DA.Uploaded,
							SalesOrder.Description, RIPH.ReturnTransactionID {0} ", divisionGroupBy);

                if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"ORDER BY SalesOrder.OrderID");
                }
                else
                {
                    orderByFilter = string.Format(@"Order By {0} {1} "
                    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                dataQuery = string.Format(@" {0} {1} {2} OFFSET {3} ROWS FETCH NEXT {4} ROWS ONLY",
                mainQuery.ToString(), //0
                groupByFilter, //1
                orderByFilter, //2
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //3
                filter.CustomListFilter.PageSize //4
                );
                var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0} {1}) tt",
                mainQuery.ToString(), //0,
                groupByFilter //1
                );

                object objField = 0;

                 result = dbHelper.ExecuteScalar(countQuery, ref objField,true);
                if (result == GlobalErrors.Success && objField != null)
                {
                    orderList.TotalItems = 
                        int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(dataQuery, ref orders,true);
                    orderList.Data = orders;
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetCancelledOrderList(OrderListFilter filter, ref SharedTableResult<OrderModel> orderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            List<OrderModel> orders = new List<OrderModel>();
            try
            {
                dbHelper = new DBHelper<OrderModel>();

                string dataQuery = string.Empty;
                string empCustomers = string.Empty;
                string orderByFilter = string.Empty;
                var mainQuery = new StringBuilder();
                string supervisionJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" And SalesOrder.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }

                mainQuery.AppendFormat(@"SELECT DISTINCT 
                            SalesOrder.OrderID,
                            SalesOrder.OrderDate ,
                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                            CustomerLanguage.Description CustomerName,
                            CustomerOutletLanguage.Description OutletName,
                            ISNULL (salesperson.Description,'') EmployeeName,
                            ISNULL (DivisionLanguage.Description,'') Division,
                            IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
                            IsNull( Customer.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description  , '--') as CustomerCodeName,
                            IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description  , '--') as OutletCodeName,
                            SalesOrder.CustomerID ,
                            SalesOrder.OutletID,
                            SalesOrder.EmployeeID,
                            SalesOrder.DivisionID,
                            SalesOrder.RouteHistoryID,
                            SalesOrder.CreationSource,
                            SalesOrder.WarehouseTransactionID,                          
                            OrderTypeLanguage.Description OrderType,
                            SalesOrder.OrderTypeID, SalesOrder.LPO,
                            SalesNote.Note
                            FROM SalesOrder 
				INNER JOIN Customer ON Customer.CustomerID = SalesOrder.CustomerID 
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
				INNER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID =  {1} 
                INNER JOIN CustomerOutlet ON CustomerOutlet.CustomerID = SalesOrder.CustomerID AND SalesOrder.OutletID = CustomerOutlet.OutletID
				INNER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND SalesOrder.OutletID = 
				CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID =  {1} 
                {4}
				LEFT OUTER JOIN EmployeeLanguage AS salesperson ON SalesOrder.EmployeeID = salesperson.EmployeeID AND salesperson.LanguageID =  {1} 				 
				LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {1} 
				LEFT OUTER JOIN Division on Division.DivisionID = DivisionLanguage.DivisionID
				LEFT OUTER JOIN Employee ON Employee.EmployeeID = SalesOrder.EmployeeID   AND Employee.OrganizationID IN ({3}) 				
				LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID = SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID =  {1}
                OUTER APPLY ( SELECT TOP (1) SalesOrderNote.Note FROM SalesOrderNote WHERE SalesOrderNote.OrderID = SalesOrder.OrderID
                AND SalesOrderNote.CustomerID = SalesOrder.CustomerID AND SalesOrderNote.OutletID = SalesOrder.OutletID AND SalesOrderNote.DivisionID = SalesOrder.DivisionID) AS SalesNote                
                WHERE 
                (Customer.New <> 1) AND (SalesOrder.OrganizationID IN ({3})) AND (SalesOrder.OrderStatusID IN ({5})) and SalesOrder.OrderTypeID in ({6},{8}) {7}",
                                     filter.OrderStatus.GetHashCode(), //0
                                     _requestRepository.LanguageId, //1
                                     _employeeManager.GetSupervisorAccess(), //2
                                     _requestRepository.CurrentOperator.OrganizationAccess, // 3
                                     orgAccessJoin, //4
                                     filter.OrderStatus.GetHashCode(),//5
                                     OrderTypes.Sales.GetHashCode(),//6
                                     supervisionJoin, //7
                                     OrderTypes.Return.GetHashCode()//8
                                     );                

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    mainQuery.AppendFormat(@" and ( (SalesOrder.OrderID  LIKE '%{0}%')
                            OR ( CustomerLanguage.Description LIKE '%{0}%')
                            OR ( CustomerOutletLanguage.Description LIKE '%{0}%')
							OR ( SalesOrder.Description LIKE '%{0}%')
                            OR ( SalesOrder.OrderDate  LIKE '%{0}%')	
                            OR ( salesperson.Description LIKE '%{0}%')
                            OR ( SalesNote.Note LIKE '%{0}%')
							OR ( OrderTypeLanguage.Description  LIKE '%{0}%')
                            OR ( DivisionLanguage.Description  LIKE '%{0}%')
                            OR ( Customer.CustomerCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    if (filter.DivisionId != -1)//&& _requestRepository.Configurations.ControlTransactionOnDivisionLevel != true)
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID = {0}", filter.DivisionId);
                    }
                    else if (!string.IsNullOrWhiteSpace(_requestRepository.CurrentOperator.DivisionAccess))
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID in ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                    }
                    else
                    {
                        mainQuery.Append(@" And SalesOrder.DivisionID in (-1)");
                    }
                }
                if (filter.CustomerId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.CustomerID = {0}", filter.CustomerId);
                }

                if (filter.OutletId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.OutletID = {0}", filter.OutletId);
                }

                if (filter.EmployeeId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.EmployeeID = {0}", filter.EmployeeId);
                }
                if (filter.OrderDateRange != null && filter.OrderDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  SalesOrder.OrderDate>={0} and  SalesOrder.OrderDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.OrderDateRange[0].Year, filter.OrderDateRange[0].Month, filter.OrderDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.OrderDateRange[1].Year, filter.OrderDateRange[1].Month, filter.OrderDateRange[1].Day)));
                }                               

                if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"ORDER BY SalesOrder.OrderID");
                }
                else
                {
                    orderByFilter = string.Format(@"Order By {0} {1} "
                    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                dataQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery.ToString(), //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );
                var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery.ToString());

                object objField = 0;

                result = dbHelper.ExecuteScalar(countQuery, ref objField,true);
                if (result == GlobalErrors.Success && objField != null)
                {
                    orderList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(dataQuery, ref orders,true);
                    orderList.Data = orders;
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors GetRejectedOrderList(OrderListFilter filter, ref SharedTableResult<OrderModel> orderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            List<OrderModel> orders = new List<OrderModel>();
            try
            {
                dbHelper = new DBHelper<OrderModel>();

                string dataQuery = string.Empty;
                string empCustomers = string.Empty;
                string orderByFilter = string.Empty;
                var mainQuery = new StringBuilder();
                string supervisionJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" And SalesOrder.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }

                if (LocalUtilities.WebApplication == WebApplication.Echo && _requestRepository.CurrentOperator.EmployeeTypeId != EmployeeTypes.Employee.GetHashCode())
                {
                    empCustomers = string.Format(@"INNER JOIN CustOutTerritory ON CustomerOutlet.CustomerID = CustOutTerritory.CustomerID AND CustomerOutlet.OutletID = CustOutTerritory.OutletID
                                                   INNER JOIN EmployeeTerritory ON EmployeeTerritory.TerritoryID = CustOutTerritory.TerritoryID AND EmployeeTerritory.EmployeeID = {0}", _requestRepository.CurrentOperator.EmployeeId);

                }

                mainQuery.AppendFormat(@"SELECT DISTINCT 
                            SalesOrder.OrderID,
                            SalesOrder.OrderDate OrderDate ,
                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                            CustomerLanguage.Description CustomerName,
                            CustomerOutletLanguage.Description OutletName,
                            ISNULL (salesperson.Description,'') EmployeeName,
                            ISNULL (DivisionLanguage.Description,'') Division,
                            IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
                            IsNull( Customer.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description  , '--') as CustomerCodeName,
                            IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description  , '--') as OutletCodeName,
                            SalesOrder.CustomerID ,
                            SalesOrder.OutletID,
                            SalesOrder.EmployeeID,
                            SalesOrder.DivisionID,
                            SalesOrder.RouteHistoryID,
                            SalesOrder.CreationSource,
                            SalesOrder.WarehouseTransactionID,
                            DeliveryAssignment.RejectNote RejectNote,
                            DeliveryAssignment.ScheduleDate RejectDate,
                            OrderTypeLanguage.Description OrderType,
                            RejectReasonLanguage.Description RejectReason,
                            SalesOrder.OrderTypeID, SalesOrder.LPO
FROM            SalesOrder 
				INNER JOIN Customer ON Customer.CustomerID = SalesOrder.CustomerID 
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
				INNER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID =  {1} 
                INNER JOIN CustomerOutlet ON CustomerOutlet.CustomerID = SalesOrder.CustomerID AND SalesOrder.OutletID = 
                CustomerOutlet.OutletID
				INNER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND SalesOrder.OutletID = 
						CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID =  {1} 
				LEFT OUTER JOIN EmployeeLanguage AS salesperson ON SalesOrder.EmployeeID = salesperson.EmployeeID AND salesperson.LanguageID =  {1} 
				INNER JOIN DeliveryAssignment ON DeliveryAssignment.OrderID = SalesOrder.OrderID AND DeliveryAssignment.CustomerID = SalesOrder.CustomerID 
						AND DeliveryAssignment.OutletID = SalesOrder.OutletID AND 
                         DeliveryAssignment.DeliveryAssignmentID =
                             (SELECT        MAX(DeliveryAssignmentID) AS Expr1
                               FROM            DeliveryAssignment
                               WHERE        (SalesOrder.OrderID = OrderID) AND (SalesOrder.DivisionID = DivisionID)) 
				LEFT OUTER JOIN EmployeeLanguage AS deliveryPerson ON DeliveryAssignment.EmployeeID = deliveryPerson.EmployeeID AND deliveryPerson.LanguageID =  {1} 
				LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {1} 
				LEFT OUTER JOIN Division on Division.DivisionID = DivisionLanguage.DivisionID
				LEFT OUTER JOIN Employee ON Employee.EmployeeID = SalesOrder.EmployeeID   AND Employee.OrganizationID IN ({3}) 
				LEFT OUTER JOIN RejectReasonLanguage ON RejectReasonLanguage.RejectReasonID = DeliveryAssignment.RejectReasonID 
						AND RejectReasonLanguage.LanguageID =  {1}
				LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID = SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID =  {1}
WHERE        (Customer.New <> 1) AND (SalesOrder.OrganizationID IN ({3})) AND (DeliveryAssignment.DeliveryStatusID IN (3))  AND (SalesOrder.OrderStatusID IN ({6})) and SalesOrder.OrderTypeID in ({7},{9}) {8}",
                                     filter.OrderStatus.GetHashCode(), //0
                                     _requestRepository.LanguageId, //1
                                     _employeeManager.GetSupervisorAccess(), //2
                                     _requestRepository.CurrentOperator.OrganizationAccess, // 3
                                     orgAccessJoin, //4
                                     empCustomers,//5
                                     filter.OrderStatus.GetHashCode(),//6
                                     OrderTypes.Sales.GetHashCode(),//7
                                     supervisionJoin, //8
                                     OrderTypes.Return.GetHashCode()//9
                                     );

                if (LocalUtilities.WebApplication == WebApplication.Echo)
                {
                    mainQuery.AppendFormat(" AND SalesOrder.CreationSource = {0} ", CreationSource.Echo.GetHashCode());
                }

                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    mainQuery.AppendFormat(@" and ( (SalesOrder.OrderID  LIKE '%{0}%')
                            OR ( CustomerLanguage.Description LIKE '%{0}%')
                            OR ( CustomerOutletLanguage.Description LIKE '%{0}%')
							OR ( SalesOrder.Description LIKE '%{0}%')
                            OR ( SalesOrder.OrderDate  LIKE '%{0}%')
							OR ( DeliveryAssignment.ScheduleDate LIKE '%{0}%')
							OR ( RejectReasonLanguage.Description LIKE '%{0}%')
							OR ( OrderTypeLanguage.Description  LIKE '%{0}%')
                            OR ( DivisionLanguage.Description  LIKE '%{0}%')
                            OR ( Customer.CustomerCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    if (filter.DivisionId != -1)//&& _requestRepository.Configurations.ControlTransactionOnDivisionLevel != true)
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID = {0}", filter.DivisionId);
                    }
                    else if (!string.IsNullOrWhiteSpace(_requestRepository.CurrentOperator.DivisionAccess))
                    {
                        mainQuery.AppendFormat(@" And SalesOrder.DivisionID in ({0})", _requestRepository.CurrentOperator.DivisionAccess);
                    }
                    else
                    {
                        mainQuery.Append(@" And SalesOrder.DivisionID in (-1)");
                    }
                }
                if (filter.CustomerId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.CustomerID = {0}", filter.CustomerId);
                }

                if (filter.OutletId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.OutletID = {0}", filter.OutletId);
                }

                if (filter.EmployeeId != -1)
                {
                    mainQuery.AppendFormat(@"And SalesOrder.EmployeeID = {0}", filter.EmployeeId);
                }
                if (filter.OrderDateRange != null && filter.OrderDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  SalesOrder.OrderDate>={0} and  SalesOrder.OrderDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.OrderDateRange[0].Year, filter.OrderDateRange[0].Month, filter.OrderDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.OrderDateRange[1].Year, filter.OrderDateRange[1].Month, filter.OrderDateRange[1].Day)));
                }
                if (filter.RejectDateRange != null && filter.RejectDateRange.Count == 2)
                {
                    mainQuery.AppendFormat(" And  DeliveryAssignment.ScheduleDate>={0} and  DeliveryAssignment.ScheduleDate<={1} "
                      , LocalUtilities.ParseDateToSQLString(new DateTime(filter.RejectDateRange[0].Year, filter.RejectDateRange[0].Month, filter.RejectDateRange[0].Day)),
                      LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.RejectDateRange[1].Year, filter.RejectDateRange[1].Month, filter.RejectDateRange[1].Day)));
                }
                if (filter.DriverId != -1 && !_requestRepository.Configurations.AllowDispatchAnyOrderToDriver)
                {
                    if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                    {
                        mainQuery.AppendFormat(@"AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(CustomerID as nvarchar)  + '_' + CAST(OutletID as nvarchar)) 
                        From CustOutTerritory 
                        Where TerritoryID = (Select TerritoryID From EmployeeTerritory Where EmployeeID = {0}))", filter.DriverId);
                    }
                    else
                    {
                        mainQuery.AppendFormat(@"AND ( CAST(SalesOrder.CustomerID as nvarchar)  + '_' + CAST(SalesOrder.OutletID as nvarchar))  
                        IN (Select Distinct ( CAST(RouteCustomer.CustomerID as nvarchar)  + '_' + CAST(RouteCustomer.OutletID  as nvarchar))  
                        From Route
                        INNER JOIN EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID AND EmployeeTerritory.EmployeeID = {0}
                        INNER JOIN RouteCustomer on RouteCustomer.RouteID = Route.RouteID)", filter.DriverId);
                    }
                }

                if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                {
                    orderByFilter = string.Format(@"ORDER BY SalesOrder.OrderID");
                }
                else
                {
                    orderByFilter = string.Format(@"Order By {0} {1} "
                    , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                }

                dataQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery.ToString(), //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );
                var countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery.ToString());

                object objField = 0;

                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null)
                {
                    orderList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(dataQuery, ref orders , true);
                    orderList.Data = orders;
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public List<ItemPackModel> GetOrderDetails(OrderModel order)
        {
            return GetOrderDetails(order, null);
        }
        public List<ItemPackModel> GetOrderDetails(OrderModel order, DBHelper<int> dBHelper)
        {
            DBHelper<ItemPackModel> dbHelper_items = null;
            List<ItemPackModel> itemPacksList = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dbHelper_items = new DBHelper<ItemPackModel>();
                }
                else
                {
                    dbHelper_items = new DBHelper<ItemPackModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }

                itemPacksList = new List<ItemPackModel>();

                string query = string.Format(@"
                                        DECLARE @Table as Table(TotalRecords INT, PackID INT);
                                        INSERT INTO @Table 

                                        SELECT COUNT(*) TotalRecords, SalesOrderDetail.PackID FROM 
                                        SalesOrderDetail 
                                        INNER JOIN PromotionBenefitHistory p ON p.TransactionID = SalesOrderDetail.OrderID AND p.TransactionTypeID = 2
                                        LEFT JOIN PackGroupDetail pgd ON pgd.PackID = SalesOrderDetail.PackID AND p.PackGroupID = pgd.PackGroupID
                                        WHERE p.TransactionID = '{0}' AND PromotionOptionDetailTypeID IN ({5},{6},{7})
                                        AND (
                                        p.PackID = SalesOrderDetail.PackID 
                                        OR
                                        (p.PackID = -1 AND p.PackGroupID IS NOT NULL)
                                        OR 
                                        (
                                        (p.PackID = -1 AND p.PackGroupID = -1)
                                        )
                                        )
                                        GROUP BY SalesOrderDetail.PackID;

                                      SELECT
                                            CASE WHEN promoHistory.PackID IS NOT NULL AND promoHistory.TotalRecords > 0
											THEN 1 ELSE 0 END UseBasePrice,
                                            SalesOrderDetail.* ,
                                            SalesOrderDetail.ReturnReason as ReturnReasonId,
                                            SalesOrderDetail.ExciseTax as CalculatedRetailTax,
                                            (SalesOrderDetail.ExciseTax/SalesOrderDetail.Quantity) as RetailValue,
                                            SalesOrderDetail.Quantity AS RequiredQty ,
                                            ItemLanguage.Description AS itemName,
                                            Pack.Quantity PiecesInPack ,
                                            PackTypeLanguage.Description Uom,
                                            Pack.HasSerialNumber,
pack.IsWeightPriced,
                                            Item.ItemCode,
                                            Item.PackDefinition,
                                            Item.ItemID,
                                            ItemCategory.DivisionID ItemDivisionID,
                                            SalesOrderDetail.Quantity OriginalQuantity,
                                            isnull(SalesOrderDetail.SecondaryPackId,-1) SecondaryPackId,
                                            isnull(SecondaryPack.Quantity,0) SecondaryDefinedQuantity,
                                            PS.ReSellable,
CASE WHEN SalesOrderDetail.SalesTransactionTypeID = {8} and SalesOrderDetail.ItemPromotedDiscount < 100 then
salesorderdetail.AllItemDiscount / 
((SalesOrderDetail.Price * SalesOrderDetail.Quantity - (SalesOrderDetail.Price * SalesOrderDetail.Quantity * SalesOrderDetail.ItemPromotedDiscount / 100 )) /
(SalesOrderDetail.Price * SalesOrderDetail.Quantity)) else 0 end as OriginalAllItemDiscount, item.InStock, item.InSCS,
                                            SalesOrderDetail.ExpiryDate,
                                            SalesOrderDetail.BatchNo,
                                            SalesOrderDetail.StockStatusID
                                             FROM  SalesOrderDetail
                                            INNER JOIN pack on pack.PackID=SalesOrderDetail.PackID
                                            INNER JOIN item on Item.ItemID=Pack.ItemID
                                            INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                                            LEFT JOIN PackStatus PS on PS.StatusID = SalesOrderDetail.PackStatusID
											LEFT JOIN (SELECT * FROM @Table) as promoHistory ON promoHistory.PackID = SalesOrderDetail.PackID

                                            LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND (PackTypeLanguage.LanguageID = {4})
                                            LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND (ItemLanguage.LanguageID = {4})
                                             left outer join SecondaryPack on SecondaryPack.ItemID=item.ItemID and secondaryPack.SecondaryPackId=SalesOrderDetail.SecondaryPackId 
WHERE
                                            SalesOrderDetail.OrderId = '{0}' and SalesOrderDetail.CustomerID= {1} and SalesOrderDetail.OutletID= {2}
                                            and SalesOrderDetail.DivisionID = {3}
                                            Order by SalesTransactionTypeID,item.itemID,Sequence,ItemLanguage.Description"
                                           , order.OrderId, order.CustomerId, order.OutletId, order.DivisionId, _requestRepository.LanguageId,
                                           PromotionOutputDetailTypes.FixedPriceOverItem.GetHashCode(),
                                           PromotionOutputDetailTypes.FixedPriceOverAllItem.GetHashCode(),
                                           PromotionOutputDetailTypes.FixedPriceOverGroup.GetHashCode(),
                                           SalesTransactionTypes.Sales.GetHashCode());

                result = dbHelper_items.GetQueryList(query, ref itemPacksList);
                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }
        public List<ItemPackModel> GetOrderDetailsFromActual(OrderModel order, DBHelper<int> dBHelper)
        {
            DBHelper<ItemPackModel> dbHelper_items = null;
            List<ItemPackModel> itemPacksList = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dbHelper_items = new DBHelper<ItemPackModel>();
                }
                else
                {
                    dbHelper_items = new DBHelper<ItemPackModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }

                itemPacksList = new List<ItemPackModel>();

                string query = string.Format(@"SELECT
                                            TransactionDetail.* ,

                                            TransactionDetail.ExciseTax as CalculatedRetailTax,
 TransactionDetail.ExciseTax/TransactionDetail.Quantity as RetailValue,
                                            TransactionDetail.Quantity AS RequiredQty ,
                                            ItemLanguage.Description AS itemName,
                                            Pack.Quantity PiecesInPack ,
                                            PackTypeLanguage.Description Uom,
                                            Item.ItemCode,
                                            Item.PackDefinition,
                                            Item.ItemID,
                                            ItemCategory.DivisionID ItemDivisionID
                                            FROM  TransactionDetail
											inner join [Transaction] on [Transaction].TransactionID=TransactionDetail.TransactionID and [Transaction].CustomerID=TransactionDetail.CustomerID and [Transaction].OutletID=TransactionDetail.OutletID and [Transaction].DivisionID=TransactionDetail.DivisionID
                                            inner join pack on pack.PackID=TransactionDetail.PackID
                                            inner join item on Item.ItemID=Pack.ItemID
                                            INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                                            LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND (PackTypeLanguage.LanguageID = {4})
                                            LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND (ItemLanguage.LanguageID = {4})
                                            WHERE
                                           [Transaction].SourceTransactionID = '{0}' and TransactionDetail.CustomerID= {1} and TransactionDetail.OutletID= {2}
                                            and TransactionDetail.DivisionID = {3} and ([Transaction].Voided is null or [Transaction].Voided=0)
                                            Order by SalesTransactionTypeID,item.itemID,Sequence,ItemLanguage.Description"
                                           , order.OrderId, order.CustomerId, order.OutletId, order.DivisionId, _requestRepository.LanguageId);

                result = dbHelper_items.GetQueryList(query, ref itemPacksList);

                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }
        public List<ItemPackModel> GetInvoicedOrderDetailsForView(OrderModel order)
        {
            DBHelper<ItemPackModel> dbHelper_items = null;
            List<ItemPackModel> itemPacksList = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper_items = new DBHelper<ItemPackModel>();
                itemPacksList = new List<ItemPackModel>();

                string batchTransactionSelection = string.Empty;
                string batchOrderSelection = string.Empty;
                string batchTransactionGrouping = string.Empty;
                string batchOrderGrouping = string.Empty;
                string defautBatch = string.Empty;
                string defaultExpiryDate = string.Empty;
                string batchAndExpiryJoin = string.Empty;

                if (_requestRepository.Configurations.AllowBatchSelectionInDelivery)
                {
                    batchTransactionSelection = "TransactionDetail.BatchNo,TransactionDetail.ExpiryDate";
                    batchOrderSelection = "SOD.BatchNo,SOD.ExpiryDate";
                    batchTransactionGrouping = ",TransactionDetail.BatchNo,TransactionDetail.ExpiryDate";
                    batchOrderGrouping = ",SOD.BatchNo,SOD.ExpiryDate";
                }
                else
                {
                    batchTransactionSelection = string.Format(" '{0}' BatchNo, {1} ExpiryDate ", LocalUtilities.DefaultBatchNo, LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate));
                    batchOrderSelection = batchTransactionSelection;
                }
                if(order.PreviousOrderStatus == OrderStatus.Prepared)
                {
                    batchAndExpiryJoin = " And TransactionDetail.BatchNo = SOD.BatchNo and TransactionDetail.ExpiryDate = SOD.ExpiryDate ";
                }

                string query = string.Format(@"DECLARE @table as Table (OrderID nvarchar(100), CustomerID int, OutletID int, PackId int, RequiredQty numeric(19,9), OrderedQuantity numeric(19,9), SalesTransactionTypeID int,Price  numeric(19,9) ,BatchNo nvarchar(100), ExpiryDate dateTime,NetTotal numeric(19,9),Discount numeric(19,9),CalculatedDiscountTotal numeric(19,9) , Tax numeric(19,9) , CalculatedTax numeric(19,9) , CalculatedRetailTax numeric(19,9));

                INSERT INTO @table 
                SELECT '{0}' OrderID,TransactionDetail.CustomerID,TransactionDetail.OutletID,TransactionDetail.PackID, SUM(TransactionDetail.Quantity), SUM(ISNULL(SOD.Quantity, 0)), TransactionDetail.SalesTransactionTypeID,TransactionDetail.Price,{5},SUM(TransactionDetail.NetTotal),SUM(TransactionDetail.Discount),SUM(TransactionDetail.Discount),SUM(TransactionDetail.Tax),SUM(TransactionDetail.Tax),SUM(TransactionDetail.ExciseTax)
                from TransactionDetail 
                INNER JOIN [Transaction] ON [Transaction].TransactionID = TransactionDetail.TransactionID AND [Transaction].DivisionID = TransactionDetail.DivisionID AND [Transaction].CustomerId = TransactionDetail.CustomerId AND [Transaction].OutletID = TransactionDetail.OutletID
                LEFT JOIN SalesOrderDetail SOD ON SOD.OrderID = [Transaction].SourceTransactionID AND SOD.DivisionID = [Transaction].DivisionID AND [Transaction].CustomerId = SOD.CustomerId AND [Transaction].OutletID = SOD.OutletID AND SOD.PackID = TransactionDetail.PackID AND SOD.SalesTransactionTypeID = TransactionDetail.SalesTransactionTypeID
                {11}
                Where [Transaction].SourceTransactionID = '{0}' AND [Transaction].CustomerId ={1} 
                and [Transaction].OutletID = {2}
                and [Transaction].DivisionID = {3}
                and ([Transaction].Voided is null or [Transaction].Voided=0)
                group by TransactionDetail.CustomerID,TransactionDetail.OutletID,TransactionDetail.PackID,TransactionDetail.Price,TransactionDetail.SalesTransactionTypeID {6}

                INSERT INTO @table 
                SELECT '{0}' OrderID,SOD.CustomerID,SOD.OutletID,SOD.PackID, 0, SUM(ISNULL(SOD.Quantity, 0)), SOD.SalesTransactionTypeID,
                SOD.Price,{9}, 0,0,0,0,0,0
                from SalesOrderDetail SOD 
                LEFT JOIN (SELECT TransactionDetail.PackID, TransactionDetail.SalesTransactionTypeID FROM TransactionDetail 
                INNER JOIN  [Transaction] ON [Transaction].TransactionID = TransactionDetail.TransactionID AND [Transaction].DivisionID = TransactionDetail.DivisionID AND [Transaction].CustomerId = TransactionDetail.CustomerId AND [Transaction].OutletID = TransactionDetail.OutletID
                Where [Transaction].SourceTransactionID = '{0}' and [Transaction].CustomerId = {1}
                and [Transaction].OutletID = {2}
                and [Transaction].DivisionID = {3}
                and ([Transaction].Voided is null or [Transaction].Voided=0) ) as tt ON tt.PackID = SOD.PackID AND tt.SalesTransactionTypeID = SOD.SalesTransactionTypeID
                Where SOD.OrderID = '{0}' AND SOD.CustomerId = {1} 
                and SOD.OutletID = {2}
                and SOD.DivisionID = {3}
                AND tt.PackID IS NULL
                group by SOD.CustomerID,SOD.OutletID,SOD.PackID,SOD.Price, SOD.SalesTransactionTypeID {10}

                SELECT t.*,ItemLanguage.Description AS itemName,
                Pack.Quantity PiecesInPack ,
                PackTypeLanguage.Description Uom,
                Item.ItemCode,
                Item.PackDefinition,
                Item.ItemID,
                ItemCategory.DivisionID ItemDivisionID FROM @table t
                INNER JOIN Pack ON Pack.PackID = t.PackId
                INNER JOIN item on Item.ItemID=Pack.ItemID
                INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory.ItemCategoryID
                LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID
                AND (PackTypeLanguage.LanguageID ={4} )
                LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID
                AND (ItemLanguage.LanguageID = {4})", order.OrderId, //0
                                           order.CustomerId, //1
                                           order.OutletId, //2
                                           order.DivisionId, //3
                                           _requestRepository.LanguageId, //4
                                           batchTransactionSelection, //5
                                           batchTransactionGrouping, //6
                                           LocalUtilities.DefaultBatchNo, //7
                                           LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate), //8
                                           batchOrderSelection,//9
                                           batchOrderGrouping,//10
                                           batchAndExpiryJoin //11
                                           );

                result = dbHelper_items.GetQueryList(query, ref itemPacksList);

                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }

        public GlobalErrors GetCollectedOrderDetailsForView(OrderModel order,ref List<ItemPackModel> itemPacksList)
        {
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                string query = $@"
                select Distinct sod.PackStatusID, sod.ReturnReason ,td.*,td.Quantity RequiredQuantity, td.Quantity OrderedQuantity ,
                ptl.Description UOM, il.Description ItemName, item.ItemCode, psl.Description PackStatus
                from [TransactionDetail] td
                Inner join [Transaction] t on t.TransactionID = td.TransactionID and t.CustomerID = td.CustomerID and t.OutletID = td.OutletID
                Inner join SalesOrder SO on SO.OrderID = t.SourceTransactionID and SO.CustomerID = t.CustomerID and SO.OutletID = t.OutletID
                Inner join SalesOrderDetail sod on sod.OrderID = so.OrderID and sod.CustomerID = so.CustomerID and sod.OutletID
                 = so.OutletID and sod.PackID = td.PackID
                Inner join Pack on Pack.PackID = td.PackID
                Inner join item on item.ItemID = pack.ItemID
                Left join PackTypeLanguage ptl on ptl.PackTypeID = pack.PackTypeID and ptl.LanguageID =  {_requestRepository.LanguageId}
                Left join ItemLanguage il on il.ItemID = Pack.ItemID and il.LanguageID =  {_requestRepository.LanguageId}
                Left join PackStatusLanguage psl on psl.StatusID = sod.PackStatusID and psl.LanguageID =  {_requestRepository.LanguageId}
                where SO.OrderID = '{order.OrderId}' and t.CustomerID = {order.CustomerId} and t.OutletID = {order.OutletId} and IsNull(t.Voided,0) = 0
                 ";
                
               dbHelper = new DBHelper<ItemPackModel>();
                result = dbHelper.GetQueryList(query, ref itemPacksList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetOrderDetailsCRM(int customerId, int outletId, string orderId, ref OrderCRMModel orderModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderCRMModel> dbHelper = null;
            DBHelper<ItemPackModel> dbHelperItems = null;
            try
            {
                dbHelper = new DBHelper<OrderCRMModel>();
                string query = string.Format(@"SELECT SalesOrder.*, SalesOrderNote.Note as remarks, IsNull(OptionType, -1) RecurringTypeId,
                                IsNull(RecurringOrder.OptionType, -1) RecurringTypeId, OptionData RecurringValue, IsNull(RecurringOrder.RecurringStatusID, -1) RecurringStatusId,
                                Comment RecurringComment, IsNull(RecurringOrder.ChangedReasonID, -1) RecurringChangedReasonId, RecurringOrder.ResumeDate
                                ,EmployeeLanguage.Description EmployeeName, SalesOrder.DeliveryChargesId, SalesOrder.DeliveryValue, SalesOrder.DeliveryTax
                                FROM SalesOrder with (nolock)
                                Left JOIN RouteCustomer on RouteCustomer.CustomerID = SalesOrder.CustomerID AND RouteCustomer.OutletID  = SalesOrder.OutletID  
                                Left JOIN Route on RouteCustomer.RouteID = Route.RouteID
                                Left Join EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID 
                                Left JOIN Employee on Employee.EmployeeID = EmployeeTerritory.EmployeeID
                                LEFT JOIN EmployeeLanguage on Employee.EmployeeID = EmployeeLanguage.EmployeeID ANd EmployeeLanguage.LanguageID = {3}
                                LEFT JOIN SalesOrderNote with (nolock)  ON SalesOrderNote.CustomerID = SalesOrder.CustomerID AND SalesOrderNote.OutletID = SalesOrder.OutletID AND SalesOrderNote.OrderID = SalesOrder.OrderID AND SalesOrderNote.DivisionID = SalesOrder.DivisionID
                                LEFT OUTER JOIN RecurringOrder with (nolock)  ON RecurringOrder.OrderID = SalesOrder.OrderID AND RecurringOrder.CustomerID = SalesOrder.CustomerID AND RecurringOrder.OutletID = SalesOrder.OutletID AND RecurringOrder.DivisionID = SalesOrder.DivisionID
                                WHERE SalesOrder.OrderID = '{0}' AND SalesOrder.CustomerID ={1} AND SalesOrder.OutletID ={2} ", orderId, customerId, outletId, _requestRepository.LanguageId);
                result = dbHelper.GetQuerySingle(query, ref orderModel);
                if (result == GlobalErrors.Success && orderModel != null)
                {
                    orderModel.DesiredDeliveryDateModel = new DateModel(orderModel.DesiredDeliveryDate);
                    dbHelperItems = new DBHelper<ItemPackModel>();
                    var itemList = new List<ItemPackModel>();
                    query = string.Format(@"SELECT
                                            SalesOrderDetail.* ,
                                            SalesOrderDetail.Quantity AS RequiredQty ,
                                            ItemLanguage.Description AS itemName,
                                            Pack.Quantity PackQuantity ,
                                            PackTypeLanguage.Description Uom,
                                            Item.ItemCode,
                                            Item.PackDefinition,
                                            Item.ItemID,
                                            Item.ItemCategoryID,
                                            ItemCategory.DivisionID ItemDivisionID
                                            FROM  SalesOrderDetail with (nolock)
                                            inner join pack on pack.PackID=SalesOrderDetail.PackID
                                            inner join item on Item.ItemID=Pack.ItemID
                                            INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                                            LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND (PackTypeLanguage.LanguageID = {3})
                                            LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND (ItemLanguage.LanguageID = {3})
                                            WHERE SalesOrderDetail.SalesTransactionTypeId = 1 AND
                                            SalesOrderDetail.OrderId = '{0}' and SalesOrderDetail.CustomerID= {1} and SalesOrderDetail.OutletID= {2}
                                            Order by SalesTransactionTypeID,item.itemID,Sequence,ItemLanguage.Description"
                                           , orderId, customerId, outletId, _requestRepository.LanguageId);
                    result = dbHelperItems.GetQueryList(query, ref itemList);
                    if (result == GlobalErrors.Success && itemList != null && itemList.Count > 0)
                    {
                        itemList.ForEach(i =>
                        {
                            i.NetTotal = i.RequiredQty * i.Price;
                            i.NetTotal = i.NetTotal * (1 - i.Discount / 100) * (1 + i.Tax / 100);
                            if (i.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && i.Discount > 0)
                            {
                                i.Discount = LocalUtilities.GetRoundedDecimal(i.Price * i.RequiredQty * i.Discount / 100, _requestRepository.Configurations.NumberOfDigits);
                            }
                        });
                        orderModel.SoldItems = itemList;
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (dbHelperItems != null)
                {
                    dbHelperItems.Dispose();
                    dbHelperItems = null;
                }
            }
        }
        public GlobalErrors GetOrderHeader(OrderListFilter filter, ref OrderModel order)
        {
            return GetOrderHeader(filter, ref order, null);
        }
        public GlobalErrors GetOrderHeader(OrderListFilter filter, ref OrderModel order, DBHelper<int> dbHelper_trans)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            string WarehouseNameCode = string.Empty;
            string joinWarehouse = string.Empty;
            try
            {

                string orderFilter = string.Empty;
                if (dbHelper_trans == null)
                {
                    dbHelper = new DBHelper<OrderModel>();
                }
                else
                {
                    dbHelper = new DBHelper<OrderModel>(dbHelper_trans.GetConnection(), dbHelper_trans.GetDBTransaction());
                }
                if (filter.CustomerId > 0)
                {
                    orderFilter = string.Format(@"  and SalesOrder.CustomerID = {0} ", filter.CustomerId);
                }
                if (filter.OutletId > 0)
                {
                    orderFilter += string.Format(@"  and SalesOrder.OutletID = {0} ", filter.OutletId);
                }
                if (filter.DivisionId > 0)
                {
                    orderFilter += string.Format(@"  and SalesOrder.DivisionId = {0} ", filter.DivisionId);
                }

                if (_requestRepository.Configurations.AllowWarehouseSelectionInPendingOrders)
                {
                     WarehouseNameCode = string.Format("IsNull(warehouse.WarehouseCode, '--') + ' ' + '-' + ' ' + IsNull(warehouseLanguage.Description, '--') WarehouseNameCode ,");
                     joinWarehouse = string.Format(@"left JOIN  Warehouse ON Warehouse.WarehouseID=SalesOrder.WarehouseID
                                            LEFT JOIN  WarehouseLanguage ON WarehouseLanguage.WarehouseID = SalesOrder.WarehouseID 
                                             AND WarehouseLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                }

                var query = string.Format(@"Select Salesorder.WarehouseID,
                                            {3}
                                            SalesOrder.OrderID,
                                            SalesOrder.OrderDate OrderDate ,
                                            SalesOrder.OrderStatusId,
                                            isnull(DeliveryAssignment.ScheduleDate,SalesOrder.DesiredDeliveryDate)   DesiredDeliveryDate,
                                            CustomerLanguage.Description CustomerName,
                                            CustomerOutletLanguage.Description CustomerOutletName,
                                            ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                            ISNULL (DivisionLanguage.Description,'') Division,
                                            salesOrder.OrderTypeID ,
                                            SalesOrder.CustomerID ,
                                            SalesOrder.OutletID,
                                            ISNULL(DeliveryAssignment.EmployeeID,SalesOrder.EmployeeID) EmployeeID,
                                            ISNULL(DeliveryAssignment.EmployeeID,SalesOrder.EmployeeID) DriverID,
                                            SalesOrder.DivisionID,
											SalesOrder.NetTotal,
											SalesOrder.Discount,
											SalesOrder.GrossTotal,
											SalesOrder.Tax,
											SalesOrder.HeaderDiscount,
											SalesOrder.ExciseTax as CalculatedRetailTax,
											SalesOrder.ExchangeRate,
                                            SalesOrder.OrganizationID,
                                            SalesOrder.SalesMode,
                                            SalesOrder.LPO,
                                            SalesOrder.CustomerRef,
                                            SalesOrder.PreviousOrderStatus,
                                            SalesOrder.IncludedTaxAmount,
                                            CustomerOutlet.Taxeable IsTaxeableOutlet,
											IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
											IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
											IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName ,
											IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
	                                       -- ,IsNull(OptionType, -1) RecurringTypeId,
											--OptionData RecurringValue,
											--IsActive isRecurringActive
                                           ,IsNull(OptionType, -1) RecurringTypeId,
                                           IsNull(RecurringOrder.OptionType, -1) RecurringTypeId, OptionData RecurringValue, IsNull(RecurringOrder.RecurringStatusID, -1) RecurringStatusId,
                                           Comment RecurringComment, IsNull(RecurringOrder.ChangedReasonID, -1) RecurringChangedReasonId, RecurringOrder.ResumeDate,
                                            [Transaction].TransactionId,[Transaction].WarehouseId,[Transaction].CreationReason,
                                            SalesOrder.WarehouseTransactionId,WarehouseTransaction.WarehouseId,WarehouseTransaction.RefWarehouseId ReferenceWarehouseId,
	                                        DeliveryAssignment.RejectNote RejectNote, RejectReasonLanguage.Description RejectReason, DeliveryAssignment.ScheduleDate rejectDate, SalesOrder.OrderSourceID,
                                            CASE WHEN RIPH.ReturnTransactionID IS NOT NULL THEN 1 ELSE 0 END AS IsRestrictedFromOldInvoices,
                                            ISNULL(SalesOrder.SDCID, -1 ) SDCID
                                            , SalesOrder.PreparedBy
                                            , SalesOrder.IsBundle
                                            , Salesorder.CollectionMethod
                                            FROM  SalesOrder
                                           {4}
                                            INNER JOIN  Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                            inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                            INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                            LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {2}
                                            and CustomerLanguage.OrganizationId in ({5})
                                            LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {2}
                                            left outer JOIN DeliveryAssignment on SalesOrder.OrderID = DeliveryAssignment.OrderID AND SalesOrder.CustomerID = DeliveryAssignment.CustomerID AND SalesOrder.outletID = DeliveryAssignment.outletID and SalesOrder.DivisionID = DeliveryAssignment.DivisionID
                                            left JOIN RejectReason on RejectReason.RejectReasonID = DeliveryAssignment.RejectReasonID 
                                            left JOIN RejectReasonLanguage on RejectReasonLanguage.RejectReasonID = RejectReason.RejectReasonID And RejectReasonLanguage.LanguageID = {2}                                            
                                            LEFT OUTER JOIN employee on employee.employeeid = DeliveryAssignment.EmployeeID                                            
                                            LEFT OUTER JOIN EmployeeLanguage ON employee.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {2}
                                           
                                            Left OUTER  JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                                            LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {2}
                                            LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID={2}
                                            LEFT OUTER JOIN RecurringOrder ON RecurringOrder.OrderID = SalesOrder.OrderID AND RecurringOrder.CustomerID = SalesOrder.CustomerID AND RecurringOrder.OutletID = SalesOrder.OutletID AND RecurringOrder.DivisionID = SalesOrder.DivisionID
                                            Left outer join [Transaction] on [Transaction].SourceTransactionId = SalesOrder.OrderID and( [Transaction].Voided=null or [Transaction].Voided=0)
                                             Left outer join WarehouseTransaction on WarehouseTransaction.TransactionId = SalesOrder.WarehouseTransactionId 
                                            LEFT OUTER JOIN ReturnInvoicesPacksHistory RIPH on RIPH.ReturnTransactionID = SalesOrder.OrderID and RIPH.CustomerID = SalesOrder.CustomerID and RIPH.OutletID = SalesOrder.OutletID  
                                           
where SalesOrder.OrderID in ('{0}') {1}"
, filter.OrderId, orderFilter, _requestRepository.LanguageId, WarehouseNameCode, joinWarehouse, _requestRepository.CurrentOperator.OrganizationAccess);


                result = dbHelper.GetQuerySingle(query, ref order);

                // GET ORDER DETAILS

                if (result == GlobalErrors.Success)
                {
                    object remarks = null;
                    query = string.Format("select top(1) note from SalesOrderNote where customerId = {0} and OutletId = {1} and OrderID = '{2}' order by NoteDate desc",
                    order.CustomerId, order.OutletId, order.OrderId);

                    result = dbHelper.ExecuteScalar(query, ref remarks);
                    if (result == GlobalErrors.Success)
                    {
                        if (remarks != null && !string.IsNullOrEmpty(remarks.ToString()))
                        {
                            order.Remarks = remarks.ToString();
                        }
                        if (order.OrderStatusId == OrderStatus.Delivered.GetHashCode() && filter.OrderOperation == OrderOperation.ViewInvoiced)
                        {
                            order.AllItems = GetOrderDetailsFromActual(order, null);
                        }
                        else
                        {
                            order.AllItems = GetOrderDetails(order);
                        }
                        if (order.OrderTypeId != OrderTypes.Return)
                        {
                            order.SoldItems = order.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Sales || a.SalesTransactionTypeId == SalesTransactionTypes.FOC).ToList();
                        }
                        else
                        {
                            order.SoldItems = order.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.None).ToList();
                        }
                        order.PromotedItems = order.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Promotion).ToList();
                        if (filter.OrderOperation != OrderOperation.FullDelivery)
                        {
                            order.PromotedItems.ForEach(i =>
                          {
                              // reset promoted discounts to retake them in angular, if currency mode is not view
                              if (i.Price == 0)
                              {
                                  if (filter.IsViewMode)
                                  {
                                      if (_requestRepository.Configurations.CalculateTaxBeforeDiscounts)
                                      {
                                          i.CalculatedTax = ((i.BasePrice * i.RequiredQty) + i.CalculatedRetailTax) * (i.Tax / 100);
                                      }
                                      else
                                      {

                                          i.CalculatedTax = ((i.BasePrice * i.RequiredQty) + i.CalculatedRetailTax - i.CalculatedDiscountTotal) * (i.Tax / 100);
                                      }
                                      i.NetTotal = i.CalculatedTax;
                                  }
                              }

                          });
                            if (order.OrderStatusId == OrderStatus.Delivered.GetHashCode() && filter.OrderOperation == OrderOperation.ViewInvoiced)
                            {
                                order.SoldItems.ForEach(i =>
                                {
                                    // reset promoted discounts to retake them in angular, if currency mode is not view
                                    if (i.ItemPromotedDiscount > 100)
                                        i.ItemPromotedDiscount = 100;
                                    if (i.AllItemDiscount > 100)
                                        i.AllItemDiscount = 100;
                                    if (i.PromotedDiscount > 100)
                                        i.PromotedDiscount = 100;

                                    if (!filter.IsViewMode)
                                    {
                                        i.PromotedDiscount = 0;
                                        i.AllItemDiscount = 0;
                                        i.ItemPromotedDiscount = 0;
                                        if (i.UseBasePrice)
                                        {
                                            // convert percentage to amount if discount type is amount
                                            if (i.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && i.Discount > 0)
                                            {
                                                i.Discount = LocalUtilities.GetRoundedDecimal((i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                            }
                                            i.Price = i.BasePrice;
                                        }
                                    }
                                    else
                                    {
                                        i.GrossTotal = i.Price * i.RequiredQty;
                                        i.CalculatedDiscountTotal = i.Discount;
                                        if (_requestRepository.Configurations.CalculateTaxBeforeDiscounts)
                                        {
                                            i.CalculatedTax = ((i.Price * i.RequiredQty) + i.CalculatedRetailTax) * (i.Tax / 100);
                                        }
                                        else
                                        {
                                            i.CalculatedTax = ((i.Price * i.RequiredQty) + i.CalculatedRetailTax - i.CalculatedDiscountTotal) * (i.Tax / 100);
                                        }
                                        i.NetTotal = i.GrossTotal + i.CalculatedRetailTax + i.CalculatedTax - i.CalculatedDiscountTotal;
                                        // convert percentage to amount if discount type is amount
                                        if (i.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && i.Discount > 0)
                                        {
                                            if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                                            {
                                                i.Discount = LocalUtilities.GetRoundedDecimal((i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                            }
                                            else
                                            {
                                                i.Discount = LocalUtilities.GetRoundedDecimal((i.Quantity * i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                            }
                                        }
                                    }



                                });
                            }
                            else
                            {
                                order.SoldItems.ForEach(i =>
                                {
                                bool CalculatedNormalDiscountAmount = false;
                                if (i.SecondaryPackId > 0)
                                {
                                    i.HasSecondaryPack = true;
                                    i.SecondaryPack = new SecondaryPackModel();
                                    i.SecondaryPack.SecondaryPackId = i.SecondaryPackId;
                                    i.SecondaryPack.SecondaryQuantity = i.SecondaryQuantity;
                                    i.SecondaryPack.ModifiedPrice = i.Price;
                                    i.SecondaryPack.RequiredQuantity = i.RequiredQty;
                                    i.SecondaryPack.PackTypeId = i.SecondaryPackTypeId;
                                    i.SecondaryPack.ItemId = i.ItemId;
                                    i.SecondaryPack.PackId = i.PackId;
                                    i.SecondaryPack.Quantity = i.SecondaryDefinedQuantity;
                                    i.SecondaryPack.OriginalPrice = i.BasePrice;
                                }
                                // reset promoted discounts to retake them in angular, if currency mode is not view
                                if (i.ItemPromotedDiscount > 100)
                                    i.ItemPromotedDiscount = 100;
                                if (i.AllItemDiscount > 100)
                                    i.AllItemDiscount = 100;
                                if (i.PromotedDiscount > 100)
                                    i.PromotedDiscount = 100;
                                if (!filter.IsViewMode)
                                {
                                    i.PromotedDiscount = 0;
                                    i.AllItemDiscount = 0;
                                    i.ItemPromotedDiscount = 0;
                                    if (i.UseBasePrice)
                                    {
                                        // convert percentage to amount if discount type is amount
                                        if (i.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && i.Discount > 0)
                                        {
                                            CalculatedNormalDiscountAmount = true;
                                            i.Discount = LocalUtilities.GetRoundedDecimal((i.Quantity * i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                        }
                                        i.Price = i.BasePrice;
                                    }
                                }
                                else
                                {

                                    i.GrossTotal = i.Price * i.RequiredQty;

                                    decimal defenetionDiscont = ((i.GrossTotal * i.Discount / 100));
                                    decimal promotDiscount = (i.GrossTotal-defenetionDiscont) * i.PromotedDiscount / 100;
                                    decimal headerDiscount = (i.GrossTotal - defenetionDiscont - promotDiscount) * i.HeaderDiscount / 100;

                                    i.CalculatedDiscountTotal = defenetionDiscont + promotDiscount + headerDiscount;
                                    i.CalculatedHeaderDiscount = headerDiscount;


                                        if (_requestRepository.Configurations.CalculateTaxBeforeDiscounts)
                                        {
                                            i.CalculatedTax = ((i.Price * i.RequiredQty) + i.CalculatedRetailTax) * (i.Tax / 100);
                                        }
                                        else
                                        {
                                            if (i.SalesTransactionTypeId == SalesTransactionTypes.FOC)
                                            {
                                                i.CalculatedTax = ((i.BasePrice * i.RequiredQty) + i.CalculatedRetailTax - i.CalculatedDiscountTotal) * (i.Tax / 100);
                                            }
                                            else
                                            {
                                                i.CalculatedTax = ((i.Price * i.RequiredQty) + i.CalculatedRetailTax - i.CalculatedDiscountTotal) * (i.Tax / 100);
                                            }

                                        }
                                        i.NetTotal = i.GrossTotal + i.CalculatedRetailTax + i.CalculatedTax - i.CalculatedDiscountTotal;
                                    }
                                    // convert percentage to amount if discount type is amount
                                    if (i.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && i.Discount > 0 && !CalculatedNormalDiscountAmount)
                                    {
                                        if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                                        {
                                            i.Discount = LocalUtilities.GetRoundedDecimal((i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                        }
                                        else
                                        {
                                            i.Discount = LocalUtilities.GetRoundedDecimal((i.Quantity * i.Price * i.Discount / 100), _requestRepository.Configurations.NumberOfDigits);
                                        }
                                    }
                                });
                            }
                        }
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                order.IsPromotionTaken = _promotionManager.IsPromotionTaken(order.OrderId, order.CustomerId, order.OutletId, order.DivisionId);

                order.Outlet = new CustomerOutletModel();
                order.Outlet = _customerManager.FillOutletData(order.CustomerId, order.OutletId, order.DivisionId);
                if (_requestRepository.Configurations.DeductPendingOrdersFromAvailableCredit)
                { // get balance of all pending orders
                    order.Outlet.Account.PendingOrdersTotal = GetPendingOrdersTotal(order.Outlet.CustomerId, order.Outlet.OutletId, order.DivisionId, order.OrderId);
                }
                if (order.AllItems.Count == 0)
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors RemoveSSCCAssignmentFromOrder(string orderId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                string query = string.Format(@"Update  SSCCHeader set   TransactionId=null , OrderId=null where OrderID='{0}'", orderId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors GetInvoicedOrderForView(OrderListFilter filter, ref OrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderModel>();

                var query = string.Format(@"Select
                                            SalesOrder.OrderID,
                                            SalesOrder.OrderDate OrderDate ,
                                            SalesOrder.OrderStatusId,
                                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                                            CustomerLanguage.Description CustomerName,
                                            CustomerOutletLanguage.Description CustomerOutletName,
                                            ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                            ISNULL (DivisionLanguage.Description,'') Division,
                                            salesOrder.OrderTypeID ,
                                            SalesOrder.CustomerID ,
                                            SalesOrder.OutletID,
                                            ISNULL(SalesOrder.EmployeeID,SalesOrder.EmployeeID) EmployeeID,
                                            SalesOrder.DivisionID,
											[Transaction].NetTotal,
											[Transaction].Discount,
											[Transaction].GrossTotal,
											[Transaction].Tax,
											SalesOrder.HeaderDiscount,
											 SalesOrder.ExciseTax as CalculatedRetailTax,
											SalesOrder.ExchangeRate,
                                            SalesOrder.OrganizationID,
                                            SalesOrder.SalesMode,
                                            SalesOrder.LPO,
                                            SalesOrder.CustomerRef,
                                            SalesOrder.PreviousOrderStatus,
											[Transaction].CreatedDate TransactionDate,
                                            CustomerOutlet.Taxeable IsTaxeableOutlet,
											IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
											IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
											IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName ,
											IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                                            [Transaction].TransactionId,[Transaction].WarehouseId,[Transaction].CreationReason                                            
	                                       
                                            FROM  SalesOrder
                                            INNER JOIN  Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                            inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                            INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                            LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {1}
                                            and CustomerLanguage.OrganizationId in ({5})
                                            LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {1}
                                            
                                            LEFT OUTER JOIN employee on employee.employeeid = SalesOrder.EmployeeID                                            
                                            LEFT OUTER JOIN EmployeeLanguage ON employee.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {1}
                                           
                                            Left OUTER  JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                                            LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {1}
                                            LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID={1}
                                            Left outer join [Transaction] on [Transaction].SourceTransactionId = SalesOrder.OrderID and( [Transaction].Voided=null or [Transaction].Voided=0)

                                            where SalesOrder.OrderID in ('{0}') 
                                                  AND SalesOrder.CustomerId = {2}
                                                  AND SalesOrder.OutletId = {3}
                                                  AND SalesOrder.DivisionId = {4} "
                                            , filter.OrderId, //0 
                                            _requestRepository.LanguageId, //1 
                                            filter.CustomerId, //2
                                            filter.OutletId, //3
                                            filter.DivisionId, //4
                                            _requestRepository.CurrentOperator.OrganizationAccess //5
                                            );


                result = dbHelper.GetQuerySingle(query, ref order);

                // GET ORDER DETAILS

                if (result == GlobalErrors.Success)
                {
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }

                    order.AllItems = GetInvoicedOrderDetailsForView(order);

                    order.SoldItems = order.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Sales).ToList();
                    order.PromotedItems = order.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Promotion).ToList();

                }
                else
                {
                    return GlobalErrors.Error;
                }

                order.IsPromotionTaken = _promotionManager.IsPromotionTaken(order.OrderId, order.CustomerId, order.OutletId, order.DivisionId);

                order.Outlet = new CustomerOutletModel();
                order.Outlet = _customerManager.FillOutletData(order.CustomerId, order.OutletId, order.DivisionId);
                if (order.AllItems.Count == 0)
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetCollectedOrderForView(OrderListFilter filter, ref OrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderModel>();

                var query = string.Format(@"Select
                                            SalesOrder.OrderID,
                                            SalesOrder.OrderDate OrderDate ,
                                            SalesOrder.OrderStatusId,
                                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                                            CustomerLanguage.Description CustomerName,
                                            CustomerOutletLanguage.Description CustomerOutletName,
                                            ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                            ISNULL (DivisionLanguage.Description,'') Division,
                                            salesOrder.OrderTypeID ,
                                            SalesOrder.CustomerID ,
                                            SalesOrder.OutletID,
                                            ISNULL(SalesOrder.EmployeeID,SalesOrder.EmployeeID) EmployeeID,
                                            SalesOrder.DivisionID,
											[Transaction].NetTotal,
											[Transaction].Discount,
											[Transaction].GrossTotal,
											[Transaction].Tax,
											SalesOrder.HeaderDiscount,
											 SalesOrder.ExciseTax as CalculatedRetailTax,
											SalesOrder.ExchangeRate,
                                            SalesOrder.OrganizationID,
                                            SalesOrder.SalesMode,
                                            SalesOrder.LPO,
                                            SalesOrder.CustomerRef,
                                            SalesOrder.PreviousOrderStatus,
											[Transaction].CreatedDate TransactionDate,
                                            CustomerOutlet.Taxeable IsTaxeableOutlet,
											IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
											IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
											IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName ,
											IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                                            [Transaction].TransactionId,[Transaction].WarehouseId,[Transaction].CreationReason                                            
	                                       
                                            FROM  SalesOrder
                                            INNER JOIN  Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                            INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                            LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {1}
                                            LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {1}
                                            
                                            LEFT OUTER JOIN employee on employee.employeeid = SalesOrder.EmployeeID                                            
                                            LEFT OUTER JOIN EmployeeLanguage ON employee.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {1}
                                           
                                            Left OUTER  JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                                            LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {1}
                                            LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID={1}
                                            Left outer join [Transaction] on [Transaction].SourceTransactionId = SalesOrder.OrderID and( [Transaction].Voided=null or [Transaction].Voided=0)

                                            where SalesOrder.OrderID in ('{0}') 
                                                  AND SalesOrder.CustomerId = {2}
                                                  AND SalesOrder.OutletId = {3}
                                                  AND SalesOrder.DivisionId = {4} "
                                            , filter.OrderId, //0 
                                            _requestRepository.LanguageId, //1 
                                            filter.CustomerId, //2
                                            filter.OutletId, //3
                                            filter.DivisionId //4
                                            );
                result = dbHelper.GetQuerySingle(query, ref order);

                if (result == GlobalErrors.Success) 
                {
                    List<ItemPackModel> items = new List<ItemPackModel>();
                    result = GetCollectedOrderDetailsForView(order,ref items);
                    if (result == GlobalErrors.Success && items != null && items.Count > 0) 
                    {
                        order.AllItems = items;
                    }
                    else 
                    {
                        result = GlobalErrors.Error;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public List<ItemPackModel> GetOrderItemsToLoad(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ItemPackModel> itemPacksList = null;
            DBHelper<ItemPackModel> dbHelper1 = null;
            try
            {
                dbHelper1 = new DBHelper<ItemPackModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                itemPacksList = new List<ItemPackModel>();

                string query = string.Format(@"SELECT SUM(SalesOrderDetail.Quantity) as RequiredQty,OrderID,SalesOrderDetail.PackID,CustomerID,OutletID,DivisionID, ExpiryDate , BatchNo , ItemId , pack.Quantity PiecesInPack
                                From SalesOrderDetail
                                INNER JOIN Pack on Pack.PackID = SalesOrderDetail.PackID 
                                Where OrderID = '{0}' AND DivisionID = {1}
                                group by Pack.ItemID , SalesOrderDetail.PackID ,OrderID,CustomerID,OutletID,DivisionID, ExpiryDate , BatchNo , pack.Quantity", order.OrderId, order.DivisionId);

                result = dbHelper1.GetQueryList(query, ref itemPacksList);

                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }
        public List<ItemPackModel> GetOrderItems(string orderIDs,int divisionID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ItemPackModel> itemPacksList = null;
            DBHelper<ItemPackModel> dbHelper1 = null;
            try
            {
                dbHelper1 = new DBHelper<ItemPackModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                itemPacksList = new List<ItemPackModel>();

                string query = string.Format(@"SELECT SUM(SalesOrderDetail.Quantity) as RequiredQty,SalesOrderDetail.PackID, ExpiryDate , BatchNo , ItemId , pack.Quantity PiecesInPack
                                From SalesOrderDetail
                                INNER JOIN Pack on Pack.PackID = SalesOrderDetail.PackID 
                                Where OrderID in ({0}) AND DivisionID = {1}
                                group by Pack.ItemID , SalesOrderDetail.PackID , ExpiryDate , BatchNo , pack.Quantity", orderIDs, divisionID);

                result = dbHelper1.GetQueryList(query, ref itemPacksList);

                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }
        public GlobalErrors GetOrderDeliveryDetails(OrderModel order, ref DeliveryAssignmentModel deliveryAssignment)
        {
            return GetOrderDeliveryDetails(order, ref deliveryAssignment, null);
        }
        public GlobalErrors GetOrderDeliveryDetails(OrderModel order, ref DeliveryAssignmentModel deliveryAssignment, DBHelper<int> main_dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DeliveryAssignmentModel> dbHelper = null;
            try
            {
                if (main_dBHelper == null)
                {
                    dbHelper = new DBHelper<DeliveryAssignmentModel>();
                }
                else
                {
                    dbHelper = new DBHelper<DeliveryAssignmentModel>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());
                }


                string query = string.Format(@"Select DA.Orderid , DA.EmployeeId , MAX(DA.DeliveryAssignmentID) DeliveryAssignmentID , WT.WarehouseID , WT.RefWarehouseID,  EV.VehicleID
                FROM DeliveryAssignment DA
                INNER JOIN SalesOrder SO on SO.OrderID = DA.OrderID 
                LEFT JOIN WarehouseTransaction WT on WT.TransactionID = SO.WarehouseTransactionID
				inner join EmployeeVehicle EV on EV.EmployeeID = DA.EmployeeID
                Where DA.OrderID = '{0}'  
                GROUP BY DA.OrderID , DA.EmployeeID , WT.WarehouseID , WT.RefWarehouseID,  EV.VehicleID", order.OrderId);

                result = dbHelper.GetQuerySingle(query, ref deliveryAssignment);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors GetOrderSources(ref List<OrderSourceModel> sourceList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderSourceModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderSourceModel>();
                string query = " SELECT OrderSourceID SourceId, Description Name From OrderSourceLanguage WHERE LanguageId = " + _requestRepository.LanguageId;
                result = dbHelper.GetQueryList(query, ref sourceList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }


        public GlobalErrors GetDeliveryChargesList(int orderSourceID, ref List<DeliveryChargesModel> deliveryChargesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<DeliveryChargesModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<DeliveryChargesModel>();
                string query = string.Format(@"SELECT        DeliveryCharges.DeliveryChargesId, DeliveryCharges.DeliveryValue, DeliveryCharges.Tax DeliveryTax, DeliveryCharges.IsDefault, DeliveryChargesLanguage.Description, OrderSourceID 
                    FROM            DeliveryCharges INNER JOIN
                                             DeliveryChargesLanguage ON DeliveryCharges.DeliveryChargesId = DeliveryChargesLanguage.DeliveryChargesId
                    WHERE        (DeliveryChargesLanguage.LanguageID = {0}) AND OrderSourceID = {1}", _requestRepository.LanguageId, orderSourceID);
                result = dbHelper.GetQueryList(query, ref deliveryChargesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetOrderModificationSources(ref List<OrderSourceModel> list, OrderModificationTypes type)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderSourceModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderSourceModel>();
                string query = string.Format(@"SELECT MO.ModifyOrderSourceID SourceId, MOL.Description Name From ModifyOrderSourceLanguage MOL
                    INNER JOIN ModifyOrderSource MO ON MOL.ModifyOrderSourceID = MO.ModifyOrderSourceID
                    WHERE(MO.ModifyTypeID IS NULL OR MO.ModifyTypeID = {0}) AND LanguageId = {1}", type.GetHashCode(), _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetOrderModificationReasons(ref List<OrderSourceModel> list, OrderModificationTypes type)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderSourceModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderSourceModel>();
                string query = string.Format(@"SELECT MO.ModifyOrderReasonID SourceId, MOL.Description Name From ModifyOrderReasonLanguage MOL
					INNER JOIN ModifyOrderReason MO ON MOL.ModifyOrderReasonID = MO.ModifyOrderReasonID
                    WHERE(MO.ModifyTypeID IS NULL OR MO.ModifyTypeID = {0}) AND LanguageId = {1}", type.GetHashCode(), _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetOrderRecurringChangeReason(ref List<RecurringChangedReasoneModel> reasonList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string supervisionJoin = string.Empty;
            DBHelper<RecurringChangedReasoneModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<RecurringChangedReasoneModel>();
                string query = string.Format(@" SELECT RecurringChangedReason.RecurringChangedReasonID ChangedReasonID, Description Name, RecurringChangedReason.RecurringStatusID StatusId From RecurringChangedReasonLanguage
                    INNER JOIN RecurringChangedReason ON RecurringChangedReasonLanguage.RecurringChangedReasonID = RecurringChangedReason.RecurringChangedReasonID 
                    WHERE LanguageId = {0}", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref reasonList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetOrderWarehouseTransactionID(ref OrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderStatus> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderStatus>();
                object field = new object();

                string query = string.Format(@"Select isNULL(WarehouseTransactionID , '') from SalesOrder where OrderID = '{0}' and CustomerID = {1} and OutletID = {2} and DivisionID = {3}"
                                , order.OrderId, order.CustomerId, order.OutletId, order.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref field);

                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(field.ToString()))
                {
                    order.WarehouseTransactionId = field.ToString();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public decimal GetPendingOrdersTotal(int customerId, int outletId, int divisionId, string currentOrderId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object amount = null;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                string orgCheck = _requestRepository.Configurations.ForceCustomerOrganizationSelection ? $" And SalesOrder.OrganizationId = {_requestRepository.CurrentOperator.OrganizationId} " : "";

                string query = string.Format(@"Select Sum (NetTotal) as Total
                FROM SalesOrder with (nolock)
                Where CustomerID = {0} and OutletID = {1} and OrderID not in ('{2}') and DivisionID = {3}
                and OrderStatusID not in ({4},{5},{6},{7},{8},{9}) {10} ",
                customerId,  //0
                outletId,  //1
                currentOrderId, //2
                divisionId, //3
                (int)OrderStatus.Delivered, //4
                (int)OrderStatus.Deleted, //5
                (int)OrderStatus.Rejected, //6
                (int)OrderStatus.Canceled, //7
                (int)OrderStatus.Closed, //8
                (int)OrderStatus.Collected, //9
                orgCheck //10
                );

                result = dbHelper.ExecuteScalar(query, ref amount);
                if (result == GlobalErrors.Success && amount != null && !string.IsNullOrEmpty(amount.ToString()))
                {
                    return Convert.ToDecimal(amount);
                }
                else
                {
                    return 0;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
        }

        public bool IsDeliveryAssignmentUploaded(OrderModel order)
        {
            return IsDeliveryAssignmentUploaded(order, null);
        }
        public bool IsDeliveryAssignmentUploaded(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                object objField = 0;

                string query = string.Format(@" SELECT IsNUll(Uploaded , 0) FROM DeliveryAssignment
                WHERE EmployeeID = {0} and orderID = '{1}' and DeliveryStatusID = {2} and DivisionID = {3}", order.DriverId, order.OrderId,
                DeliveryStatus.Assigned.GetHashCode(), order.DivisionId);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && Convert.ToBoolean(objField.ToString()))
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }

        public GlobalErrors RemoveOrderAssignemnt(OrderModel order, DBHelper<int> dbHelper)
        {
            return RemoveOrderAssignemnt(order, false, dbHelper);
        }
        public GlobalErrors RemoveOrderAssignemnt(OrderModel order,bool removeSourceID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from DeliveryAssignment where OrderID =  '{0}'  and  DivisionID = {1} and CustomerId = {2} and OutletID = {3}",
                    removeSourceID ? order.SourceOrderId : order.OrderId, order.DivisionId, order.CustomerId, order.OutletId);

                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateOrderAfterWarehouseTransaction(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("update SalesOrder set OrderstatusID = {0}, PreviousOrderStatus = {8}, WarehouseTransactionID = {1} , UpdatedBy = {2} , UpdatedDate = {3} " +
                    "where OrderID='{4}' and DivisionID = {5} and CustomerID = {6} and OutletID = {7}"
                    , order.OrderStatus.GetHashCode()
                    , order.WarehouseTransactionId == string.Empty ? "NULL" : "'" + order.WarehouseTransactionId + "'"
                    , _requestRepository.CurrentOperator.EmployeeId
                    , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                    , order.OrderId, order.DivisionId
                    , order.CustomerId, order.OutletId, order.PreviousOrderStatus.GetHashCode());

                result = dbHelper.ExecuteNonQuery(query);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateOrdersAfterWarehouseTransaction(string orderIds, OrderStatus orderStatus, string warehouseTransactionID, int divisionID,  DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"update SalesOrder set OrderstatusID = {0}, WarehouseTransactionID = '{1}' , UpdatedBy = {2} , UpdatedDate = {3} 
                    where OrderID in ({4}) and DivisionID = {5}"
                    , orderStatus.GetHashCode()
                    , warehouseTransactionID
                    , _requestRepository.CurrentOperator.EmployeeId
                    , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                    , orderIds
                    , divisionID
                    );
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateOrderAndAssignmentOnDelivery(OrderModel order, DBHelper<int> dbHelper)
        {
            return UpdateOrderAndAssignmentOnDelivery(order, false, dbHelper);
        }
        public GlobalErrors UpdateOrderAndAssignmentOnDelivery(OrderModel order, bool setDeliveryDate, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                DateTime deliveryDate = DateTime.Now;
                if (setDeliveryDate)
                {
                    deliveryDate = new DateTime(order.DesiredDeliveryDateModel.Year, order.DesiredDeliveryDateModel.Month, order.DesiredDeliveryDateModel.Day);
                }
                query = string.Format(@"update SalesOrder Set OrderStatusID = {0} , UpdatedBy = {1} , UpdatedDate = {2}
                ,ActualNetTotal={3},ActualGrossTotal={4},ActualDiscount={5},ActualTax={6}
                ,ActualDeliveryDate={7}, ActualExciseTax={8},PreviousOrderStatus={13}
                Where OrderID = '{9}' and DivisionID = {10} and CustomerID = {11} and OutletID = {12}"
                , order.OrderStatus.GetHashCode()
                , _requestRepository.CurrentOperator.EmployeeId
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                , order.NetTotal
                , order.GrossTotal
                , order.Discount
                , order.Tax
                , LocalUtilities.ParseDateAndTimeToSQL(deliveryDate)
                , order.CalculatedRetailTax
                , order.OrderId
                , order.DivisionId
                , order.CustomerId
                , order.OutletId
                , order.PreviousOrderStatus.GetHashCode());

                result = dbHelper.ExecuteNonQuery(query);

                //if (result == GlobalErrors.Success)
                //{
                //    foreach (ItemPackModel pack in order.AllItems)
                //    {
                //        query = string.Format(@"update SalesOrderDetail Set ActualDeliveredQuantity = {0} , ActualPrice = {1} , ActualTax = {2}
                //        ,ActualDiscount={3}
                //        Where OrderID = '{4}' and CustomerID = {5} and OutletID = {6} and PackID = {7} and SalesTransactionTypeID = {8}"
                //        , pack.RequiredQty
                //        , pack.Price
                //        , pack.Tax
                //        , pack.Discount
                //        , order.OrderId
                //        , order.CustomerId
                //        , order.OutletId
                //        , pack.PackId
                //        , (int)pack.SalesTransactionTypeId);

                //        result = dbHelper.ExecuteNonQuery(query);

                //        if (result != GlobalErrors.Success) break;
                //    }
                //}

                if (result == GlobalErrors.Success && !_requestRepository.Configurations.AllowInvoiceOrderBeforeAssignOrder)
                {
                    query = string.Format(@"update DeliveryAssignment set  DeliveryStatusID  = {0}, SupervisorID = {1},HelperID = {2}
                    ,SalesManagerID={3},OrganizationID={4},DriverID={5},SalesRepID={6}
                    Where OrderID = '{7}' and DivisionID = {8} and CustomerID = {9} and OutletID = {10} and DeliveryStatusID <> 6"
                    , (int)DeliveryStatus.Delivered
                    , order.SupervisorId == -1 ? "NULL" : order.SupervisorId.ToString()
                    , order.HelperId == -1 ? "NULL" : order.HelperId.ToString()
                    , order.SalesManagerId == -1 ? "NULL" : order.SalesManagerId.ToString()
                    , order.OrganizationId == -1 ? "NULL" : order.OrganizationId.ToString()
                    , order.DriverId == -1 ? "NULL" : order.DriverId.ToString()
                    , order.SalesRepId == -1 ? "NULL" : order.SalesRepId.ToString()
                    , order.OrderId
                    , order.DivisionId
                    , order.CustomerId
                    , order.OutletId);

                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateOrderStatus(OrderModel order)
        {
            return UpdateOrderStatus(order,false, null);
        }
        public GlobalErrors UpdateOrderStatus(OrderModel order, DBHelper<int> dbHelper)
        {
            return UpdateOrderStatus(order,false,dbHelper);
        }
        public GlobalErrors UpdateOrderStatus(OrderModel order, bool updateSourceOrderID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string approvalSelection = string.Empty;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();
                if(order.OrderOperation == OrderOperation.DisApprove)
                {
                    if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("6"))
                    {
                        approvalSelection = string.Format(@" ,ApprovalStatus = 0");
                    }
                    else
                    {
                        approvalSelection = string.Format(@" ,ApprovalStatus = -1");
                    }
                }
                string query = string.Format(@"
				 update SalesOrder Set OrderStatusID = {0},PreviousOrderStatus={7} , UpdatedBy = {1} , UpdatedDate = {2} {8}  Where OrderID = '{3}' and DivisionID = {4} and CustomerID = {5} and OutletID = {6}"
                 , order.OrderStatus.GetHashCode() 
                 , _requestRepository.CurrentOperator.EmployeeId 
                 , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) 
                 , updateSourceOrderID ? order.SourceOrderId : order.OrderId 
                 , order.DivisionId 
                 , order.CustomerId 
                 , order.OutletId 
                 , order.PreviousOrderStatus.GetHashCode()
                 , approvalSelection); 

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateAllOrdersInSameLoadRequest(string loadReqId, string allOrderselected,bool withOffload, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<OrderModel> ordersOnSameLoadReq = new List<OrderModel>();
                string ordersOnSameLoadReqString = "";
                result = GetOrdersForSameLoadReq(loadReqId, allOrderselected, ref ordersOnSameLoadReqString, ref ordersOnSameLoadReq, dbHelper);
                if (result == GlobalErrors.Success && ordersOnSameLoadReq != null && ordersOnSameLoadReq.Count > 0)
                {
                    foreach (OrderModel orderOnSameLoad in ordersOnSameLoadReq)
                    {
                        if (orderOnSameLoad.OrderStatus == OrderStatus.WaitForLoad || orderOnSameLoad.OrderStatus == OrderStatus.LoadRequestAccepted)
                        {
                            orderOnSameLoad.PreviousOrderStatus = orderOnSameLoad.OrderStatus;
                            if(withOffload)
                               orderOnSameLoad.OrderStatus = OrderStatus.Assigned;
                            result = UpdateOrderStatus(orderOnSameLoad, false, dbHelper);
                        }
                        if (result == GlobalErrors.Success && withOffload)
                            result = RemoveLoadRequestAssignment(orderOnSameLoad, false, dbHelper);
                        if (result == GlobalErrors.Success && orderOnSameLoad.OrderTypeId == OrderTypes.ExchangeSales && orderOnSameLoad.SourceOrderId != string.Empty)
                        {
                            if (result == GlobalErrors.Success && (orderOnSameLoad.OrderStatus == OrderStatus.WaitForLoad || orderOnSameLoad.OrderStatus == OrderStatus.LoadRequestAccepted))
                            {
                                result = UpdateOrderStatus(orderOnSameLoad, true, dbHelper);
                            }
                            if (result == GlobalErrors.Success && withOffload)
                                result = RemoveLoadRequestAssignment(orderOnSameLoad, true, dbHelper);
                        }
                        if (result != GlobalErrors.Success) break;
                    }
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors RemoveLoadRequestAssignment(OrderModel order, bool isSourceOrderID,  DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"update SalesOrder set WarehouseTransactionID = NULL ,UpdatedBy = {4} , UpdatedDate = {5} 
                where OrderID ='{0}' and CustomerID = {1} and OutletID ={2} and DivisionID ={3}",
                isSourceOrderID ? order.SourceOrderId : order.OrderId,
                order.CustomerId,
                order.OutletId,
                order.DivisionId,
                _requestRepository.CurrentOperator.EmployeeId,
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetOrdersForSameLoadReq(string warehouseTransactionID, string orderIds, ref string ordersInSameLoadReqString, ref List<OrderModel> ordersInSameLoadReq, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DataTable dt = new DataTable();
                ordersInSameLoadReq = new List<OrderModel>();
                ordersInSameLoadReqString = string.Empty;
                DBHelper<OrderModel> dbHelper1 = null;
                if (dbHelper == null)
                {
                    dbHelper1 = new DBHelper<OrderModel>();
                }
                else
                {
                    dbHelper1 = new DBHelper<OrderModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                }
                string query = string.Format(@"SELECT OrderID, SourceOrderID, DivisionID, CustomerID, OutletID, OrderStatusID from SalesOrder WHERE WarehouseTransactionID ='{0}' AND OrderID NOT IN ({1}) "
                                            , warehouseTransactionID
                                            , orderIds);
                result = dbHelper1.GetQueryList(query, ref ordersInSameLoadReq);
                if (result == GlobalErrors.Success && ordersInSameLoadReq != null && ordersInSameLoadReq.Count > 0)
                {
                    foreach (OrderModel order in ordersInSameLoadReq)
                    {
                        ordersInSameLoadReqString += order.OrderId + ',';
                    }
                    ordersInSameLoadReqString = ordersInSameLoadReqString.TrimEnd(',');
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors RescheduleOrder(OrderModel order, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Update DeliveryAssignment SET ScheduleDate = {0} Where OrderID = '{1}' AND CustomerID = {2} AND OutletID = {3}"
                    , LocalUtilities.ParseDateAndTimeToSQL(order.ScheduleDateModel.Date)
                    , order.OrderId
                    , order.CustomerId
                    , order.OutletId);

                result = dbHelper.ExecuteNonQuery(query);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors ReassignOrders(List<OrderModel> orders , ref string messageResult)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (OrderModel order in orders)
                {
                    if (!CheckOrderStatusBeforeAnyAction(order, dBHelper))
                    {
                        messageResult += string.Format("  </br>  {0} : {1} ", order.OrderId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Order_Status_Changed, _requestRepository.LanguageId));
                        continue;
                    }

                    values.AppendFormat(@" Update DeliveryAssignment SET EmployeeID = {0} Where OrderID = '{1}' AND CustomerID = {2} AND OutletID = {3} "
                    , order.DriverId // 0
                    , order.OrderId // 1
                    , order.CustomerId // 2
                    , order.OutletId // 3
                    );
                    messageResult += string.Format("  </br>  {0} : {1} ", order.OrderId, ResourcesManager.TranslateKey(MessagesConstants.Desc_Your_Order_Updated, _requestRepository.LanguageId));
                }
                if (values.Length > 0)
                {
                     query = string.Format("{0}", values);
                     result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveOrderDetails(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                int itemSequance = 0;
                StringBuilder sqlStatment = null;
                foreach (ItemPackModel pack in order.AllItems)
                {
                    if(pack.IsFromProductDiscount)
                    {
                        continue;
                    }
                    itemSequance++;
                    sqlStatment = new StringBuilder();
                    if (pack.DiscountTypeId == DiscountValueTypes.Amount.GetHashCode() && pack.Discount > 0)
                    {
                        //Caclulate it to percentage
                        decimal disc = pack.CalculatedDiscount / (pack.RequiredQty * pack.Price);
                        pack.Discount = disc * 100;
                    }
                    if (pack.SalesTransactionTypeId == SalesTransactionTypes.Promotion || pack.SalesTransactionTypeId == SalesTransactionTypes.FOC)
                    {
                        if (_requestRepository.Configurations.AllowTaxOverFreeItems)
                        {
                            pack.Tax = pack.BaseTax;
                        }
                    }

                        pack.RequestedQuantity = pack.RequiredQty;
                    //pack.SalesOrderTypeID = -1;
                    pack.OrderItemIsApproved = true;

                        sqlStatment.Append(@"Insert into SalesOrderDetail
                    (OrderID ,PackID ,Quantity , Price,Tax ,Discount ,
                    CustomerID, OutletID,SalesTransactionTypeID,
                    BasePrice, DivisionID, FOC,DiscountTypeID,
                    ActualDeliveredQuantity,PromotedDiscount,
                    FinalDiscount,AdditionalDiscount,Sequence,
                    PackStatusID,BatchNo,ExpiryDate,SalesOrderTypeID,
                    StockStatusID , BaseDiscount,
                    ItemPromotedDiscount, AllItemDiscount, BaseTax,
                    UsedPriceListID,RequestedQuantity, ExciseTax, BaseDiscountTypeID
                    ,SecondaryPackTypeID,SecondaryQuantity,SecondaryPackID, ConsumerPrice , ConsumerPriceListID, ReturnReason,OrderItemIsApproved,DiscountFromReturn, HeaderDiscount, TaxIncludedInPrice , IncludedTaxAmount, UsedFilterId)
                        values");
                    sqlStatment.Append("('");
                    sqlStatment.Append(order.OrderId); // OrderId
                    sqlStatment.Append("',");
                    sqlStatment.Append(pack.PackId); //PackId
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.RequiredQty); //RequiredQty
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.Price); //Price
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.Tax); //Tax
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.Discount); //Discount
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.Outlet.CustomerId); //CustomerID
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.Outlet.OutletId); //OutletID
                    sqlStatment.Append(",");
                    sqlStatment.Append((int)pack.SalesTransactionTypeId); //SalesTransactionTypeID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.BasePrice); //BasePrice
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.DivisionId); //DivisionId
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.Foc); //Foc
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.DiscountTypeId); // DiscountTypeID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.ActualDeliveredQuantity); //ActualDeliveredQuantity
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.PromotedDiscount); // PromotedDiscount
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.FinalDiscountPercentage); //FinalDiscountPercentage
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.AdditionalDiscount); //AdditionalDiscount
                    sqlStatment.Append(",");
                    sqlStatment.Append(itemSequance); //itemSequance
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.OrderTypeId == OrderTypes.Return && pack.PackStatusId > -1 ? pack.PackStatusId.ToString() : "-1"); //PackStatusID
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.OrderTypeId == OrderTypes.Return && pack.BatchNo != null && pack.BatchNo != string.Empty ? "'" + pack.BatchNo + "'" :  "'" + LocalUtilities.DefaultBatchNo + "'"); //BatchNo
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.OrderTypeId == OrderTypes.Return && pack.ExpiryDateModel != null && (pack.ExpiryDateModel.Year.ToString().Length > 1) ? LocalUtilities.ParseDateToSQLString(pack.ExpiryDateModel.Date) : LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate)); //DefaultExpiryDate
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.SalesOrderTypeId); //OrderTypes
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.StockStatusId); //StockStatusID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.BaseDiscount); //BaseDiscount
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.ItemPromotedDiscount); //ItemPromotedDiscount
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.AllItemDiscount); //AllItemDiscount
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.BaseTax); //BaseTax
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.UsedPriceListId); //UsedPriceListID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.RequestedQuantity); //RequestedQuantity
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.CalculatedRetailTax); //ExciseValue
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.BaseDiscountTypeId); //BaseDiscountTypeID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.SecondaryPack != null && pack.SecondaryPack.SecondaryPackId > 0 ? pack.SecondaryPack.PackTypeId.ToString() : "NULL"); //SecondaryPackTypeID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.SecondaryPack != null && pack.SecondaryPack.SecondaryPackId > 0 ? pack.SecondaryPack.SecondaryQuantity.ToString() : "NULL"); //SecondaryQuantity
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.SecondaryPack != null && pack.SecondaryPack.SecondaryPackId > 0 ? pack.SecondaryPack.SecondaryPackId.ToString() : "NULL"); //SecondaryPackID
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.ConsumerPrice);
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.ConsumerPriceListId);
                    sqlStatment.Append(",");
                    sqlStatment.Append(order.OrderTypeId == OrderTypes.Return && pack.ReturnReasonId > -1? pack.ReturnReasonId.ToString() : "-1"); // return reason
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.OrderItemIsApproved ? "1" : "NULL"); // return reason
                    sqlStatment.Append(","); 
                    sqlStatment.Append(pack.ReturnDiscountPercentage); // Return Discount Percentage
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.HeaderDiscount); // Percentage
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.TaxIncludedInPrice);
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.IncludedTaxAmount);
                    sqlStatment.Append(",");
                    sqlStatment.Append(pack.UsedFilterId);
                    sqlStatment.Append(")");

                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                    if (result != GlobalErrors.Success)
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateOrderStatusesWithActualQty(OrderModel order, OrderStatus orderNewStatus, DeliveryStatus deliveryNewStatus, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DeliveryAssignmentModel deliveryAssignment = new DeliveryAssignmentModel();

                string query = string.Format(@"update SalesOrder set OrderstatusID = {0}, ActualNetTotal = null, 
                ActualGrossTotal = null,PreviousOrderStatus = {3} where OrderID='{1}' and DivisionID = {2}",
               ((int)orderNewStatus).ToString(), order.OrderId, order.DivisionId,order.OrderStatusId);
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    string sql = string.Format(@"update SalesOrderDetail set ActualDeliveredQuantity = null where OrderID = '{0}' and DivisionID = {1}", order.OrderId, order.DivisionId);
                    result = dBHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateDeliveryStatusForOrder(OrderModel order, DeliveryStatus deliveryNewStatus, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DeliveryAssignmentModel deliveryAssignment = new DeliveryAssignmentModel();

                result = GetOrderDeliveryDetails(order, ref deliveryAssignment, dBHelper);
                if (deliveryAssignment != null)
                {
                    string query = string.Format(@"update DeliveryAssignment set DeliveryStatusID = {0} where OrderID='{1}' and DeliveryAssignmentID={2}"
               , ((int)deliveryNewStatus).ToString(), order.OrderId, deliveryAssignment.DeliveryAssignmentId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
                else
                {
                    result = GlobalErrors.Success;
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public bool IsOrderConnectWithLoadReq(string orderId, DBHelper<int> dBHelper)
        {
            bool isConnected = false;
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;
                object whTransID = null;
                string query = string.Format("select WarehouseTransactionID from SalesOrder where OrderID = '{0}'"
                    , orderId);
                result = dBHelper.ExecuteScalar(query, ref whTransID);
                if (result == GlobalErrors.Success && whTransID != null && !string.IsNullOrEmpty(whTransID.ToString()))
                {
                    isConnected = true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                isConnected = false;
            }
            return isConnected;
        }

        public GlobalErrors GetInvoiceOrderID(OrderModel order, DBHelper<int> main_dBHelper, ref TransactionModel transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TransactionModel> dBHelper;
            try
            {
                if (main_dBHelper == null)
                {
                    dBHelper = new DBHelper<TransactionModel>();
                }
                else
                {
                    dBHelper = new DBHelper<TransactionModel>(main_dBHelper.GetConnection(), main_dBHelper.GetDBTransaction());
                }

                string query = string.Format("select * from [Transaction] where SourceTransactionID='{0}' and DivisionID={1} and CustomerID={2} and OutletID={3}  and (Voided=null or voided=0)", order.OrderId, order.DivisionId, order.CustomerId, order.OutletId);
                result = dBHelper.GetQuerySingle(query, ref transaction);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
 
        public GlobalErrors IsCreditNoteUsed(string transactionID, ref bool isUsed, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = $@"SELECT COUNT(CustomerPayment.SourceTransactionID) AS CRNcount 
                FROM  CustomerPayment 
                INNER JOIN [Transaction] ON CustomerPayment.SourceTransactionID = [Transaction].TransactionID AND CustomerPayment.PaymentTypeID = 4 
                AND [Transaction].SourceTransactionID = '{transactionID}' AND [Transaction].Voided = 0 AND CustomerPayment.PaymentStatusID <> {PaymentStatusTypes.Voided.GetHashCode()}";
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && decimal.Parse(field.ToString()) > 0)
                    {
                        isUsed = true;
                    }
                    else
                    {
                        isUsed = false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckForPostedCustomerTransactions(OrderModel order, ref bool hasPostedTransactions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<DateTime> dBHelper = new DBHelper<DateTime>();
                DateTime endDate = LocalUtilities.DefaultExpiryDate;
                object field1 = null;
                string query = $@"select Count(*)  from WindowsServicesHistory 
                inner join WindowsServicesLanguage on WindowsServicesHistory.ServiceID = WindowsServicesLanguage.ServiceID and WindowsServicesLanguage.LanguageID = 1
                where WindowsServicesLanguage.Description = '{CoreDataBaseConstants.WindowsServicesNames.FillingCustomerBatchesList}' and WindowsServicesHistory.ServiceResult = 'Success'";
                result = dBHelper.ExecuteScalar(query, ref field1);
                if(result == GlobalErrors.Success)
                {
                    if(field1 != null && !string.IsNullOrEmpty(field1.ToString()))
                    {
                        query = $@"select top(1) EndDate from WindowsServicesHistory 
                        inner join WindowsServicesLanguage on WindowsServicesHistory.ServiceID = WindowsServicesLanguage.ServiceID and WindowsServicesLanguage.LanguageID = 1
                        where 
                        WindowsServicesLanguage.Description = '{CoreDataBaseConstants.WindowsServicesNames.FillingCustomerBatchesList}' and 
                        WindowsServicesHistory.ServiceResult = 'Success'
                        order by EndDate desc";
                        result = dBHelper.GetQuerySingle(query, ref endDate);
                    }
                    if (result == GlobalErrors.Success)
                    {
                        string dateFilter = " ) ";
                        if (endDate != null && endDate.Year > 2000)
                        {
                            dateFilter = $@" and t.TransactionDate > {LocalUtilities.ParseDateAndTimeToSQL(endDate)} ) OR (t.UpdatedDate > {LocalUtilities.ParseDateAndTimeToSQL(endDate)}) ";
                        }
                        DBHelper<int> dBHelper1 = new DBHelper<int>();
                        object field = 0;
                        query = $@"select count(*) c from [Transaction] t where (t.Voided <> 1 and t.Posted = 1 
                            and t.TransactionTypeID in ({TransactionType.Sales.GetHashCode()},{TransactionType.SalesExchange.GetHashCode()},{TransactionType.Return.GetHashCode()},{TransactionType.ReturnExchange.GetHashCode()})
                            and t.CreationReason not in ({TransactionCreationReason.DiscrepancyInvoice.GetHashCode()})
                            {dateFilter}";
                        result = dBHelper1.ExecuteScalar(query, ref field);
                        if (field != null && !string.IsNullOrEmpty(field.ToString()) && Convert.ToInt32(field.ToString()) > 0)
                        {
                            hasPostedTransactions = true;
                        }
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveOrderHeaders(OrderModel order, DBHelper<int> dbHelper, int tryCounter , int employeeId = -1)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (tryCounter == 0) return GlobalErrors.Error;
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append(@"INSERT INTO SalesOrder
                (CustomerID, OutletID, OrderID
                ,DesiredDeliveryDate, OrderDate, Synchronized
                ,OrderstatusID , EmployeeID, LPO
                ,NetTotal,PromotedDiscount,ConfirmationSignature
                ,Downloaded,Discount,GrossTotal
                ,Tax,CreatedBy,CreatedDate
                ,UpdatedBy,UpdatedDate,CreationSource
                ,supervisorID,helperID,DivisionID
                ,SalesManagerID,RecievedBOTime,OrganizationID
                ,Description,DriverID,SalesRepID
                ,ActualNetTotal,OrderTypeID,HeaderDiscount
                ,SourceOrderID, GPSLatitude, GPSlongitude
                ,RouteHistoryID, VisitNo, ExciseTax
                ,ExchangeRate, SelectedCurrencyID, OrderSourceID,ReferenceOrderID
                ,SalesMode, DeliveryChargesId, DeliveryValue, DeliveryTax
                , PaymentMethodTypeID, PaymentReferenceNumber, CustomerRef, SDCID, ApprovalStatus,WarehouseID,CollectionMethod,IncludedTaxAmount,IsBundle)
                values ");

                sqlStatment.Append("(");
                sqlStatment.Append(order.Outlet.CustomerId); // CustomerID
                sqlStatment.Append(",");
                sqlStatment.Append(order.Outlet.OutletId); //OutletID
                sqlStatment.Append(",'");
                sqlStatment.Append(order.OrderId); //OrderId
                sqlStatment.Append("',");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(order.DesiredDeliveryDateModel.Date)); // DesiredDeliveryDate
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)); // AssignmentDate
                sqlStatment.Append(",");
                sqlStatment.Append(0);// Synchronized
                sqlStatment.Append(",");
                sqlStatment.Append((int)order.OrderStatus); // OrderStatus
                sqlStatment.Append(",");
                sqlStatment.Append(order.OrderStatus == OrderStatus.NewWebOrder ? employeeId : order.EmployeeId); // EmployeeId
                sqlStatment.Append(",");
                sqlStatment.Append(string.IsNullOrEmpty(order.LPO) || string.IsNullOrEmpty(order.LPO.Trim()) ? "NULL" : "'" + order.LPO.Replace("'", "''").Trim() + "'"); // LPO
                sqlStatment.Append(",");
                sqlStatment.Append(order.NetTotal); // NetTotal
                sqlStatment.Append(",");
                sqlStatment.Append("0"); // PromotedDiscount
                sqlStatment.Append(",");
                sqlStatment.Append(order.ConfirmationSignature == null ? "NULL" : order.ConfirmationSignature); // ConfirmationSignature
                sqlStatment.Append(",");
                sqlStatment.Append("0"); // Downloaded
                sqlStatment.Append(",");
                sqlStatment.Append(order.Discount); // Discount
                sqlStatment.Append(",");
                sqlStatment.Append(order.GrossTotal); // GrossTotal
                sqlStatment.Append(",");
                sqlStatment.Append(order.Tax); // Tax
                sqlStatment.Append(",");
                sqlStatment.Append(order.CreatedBy); // CreatedBy
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)); // CreatedDate
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // UpdatedBy
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // UpdatedDate
                sqlStatment.Append(",");
                sqlStatment.Append((int)order.CreationSource); // CreationSource
                sqlStatment.Append(",");
                sqlStatment.Append(order.SupervisorId == -1 ? "NULL" : order.SupervisorId.ToString()); // SupervisorId
                sqlStatment.Append(",");
                sqlStatment.Append(order.HelperId == -1 ? "NULL" : order.HelperId.ToString()); // HelperId
                sqlStatment.Append(",");
                sqlStatment.Append(order.DivisionId); // DivisionId
                sqlStatment.Append(",");
                sqlStatment.Append(order.SalesManagerId == -1 ? "NULL" : order.SalesManagerId.ToString()); // SalesManagerId
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)); // RecievedBOTime
                sqlStatment.Append(",");
                sqlStatment.Append(order.OrganizationId == 0 ? "NULL" : order.OrganizationId.ToString()); // OrganizationId
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // Description
                sqlStatment.Append(",");
                sqlStatment.Append(order.DriverId == -1 ? "NULL" : order.DriverId.ToString()); // DriverId
                sqlStatment.Append(",");
                sqlStatment.Append(order.SalesRepId == -1 ? "NULL" : order.SalesRepId.ToString()); // SalesRepId
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // ActualNetTotal
                sqlStatment.Append(",");
                sqlStatment.Append((int)order.OrderTypeId); // OrderTypeId
                sqlStatment.Append(",");
                sqlStatment.Append(order.HeaderDiscount); // HeaderDiscount
                sqlStatment.Append(",");
                sqlStatment.Append(order.SourceOrderId == null ? "NULL" : "'" + order.SourceOrderId + "'"); // SourceOrderId
                sqlStatment.Append(",");
                sqlStatment.Append(order.deliveryLocation == null || string.IsNullOrEmpty(order.deliveryLocation.Trim()) || order.deliveryLocation.Split(',') == null || order.deliveryLocation.Split(',').Length != 2 ? "0" : "'" + order.deliveryLocation.Split(',')[0] + "'"); // GpsLatitude
                sqlStatment.Append(",");
                sqlStatment.Append(order.deliveryLocation == null || string.IsNullOrEmpty(order.deliveryLocation.Trim()) || order.deliveryLocation.Split(',') == null || order.deliveryLocation.Split(',').Length != 2 ? "0" : "'" + order.deliveryLocation.Split(',')[1] + "'"); // GpsLongitude
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // RouteHistoryID
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // VisitNo
                sqlStatment.Append(",");
                sqlStatment.Append(order.CalculatedRetailTax); // ExciseTax
                sqlStatment.Append(",");
                sqlStatment.Append(order.ExchangeRate); // ExchangeRate
                sqlStatment.Append(",");
                sqlStatment.Append("NULL"); // SelectedCurrencyID
                sqlStatment.Append(",");
                sqlStatment.Append(order.OrderSourceId <= 0 ? "NULL" : order.OrderSourceId.ToString()); // OrderSourceId
                sqlStatment.Append(",");
                sqlStatment.Append(order.ReferenceOrderID == null ? "NULL" : "'" + order.ReferenceOrderID + "'"); // ReferenceOrderID
                sqlStatment.Append(",");
                sqlStatment.Append(order.OrderTypeId == OrderTypes.Return? "NULL" : order.SalesMode.ToString()); // ReferenceOrderID
                sqlStatment.Append(",");
                sqlStatment.Append(order.DeliveryChargesId.HasValue ? order.DeliveryChargesId.ToString() : "NULL");
                sqlStatment.Append(",");
                sqlStatment.Append(order.DeliveryValue.HasValue ? order.DeliveryValue.ToString() : "NULL");
                sqlStatment.Append(",");
                sqlStatment.Append(order.DeliveryTax.HasValue ? order.DeliveryTax.ToString() : "NULL");
                sqlStatment.Append(",");
                sqlStatment.Append(order.PaymentMethodTypeID.HasValue && order.OrderTypeId != OrderTypes.Return ? order.PaymentMethodTypeID.ToString() : "NULL"); // PaymentMethodTypeID
                sqlStatment.Append(",");
                sqlStatment.Append(order.PaymentReferenceNumber != null ? "'" + order.PaymentReferenceNumber.ToString() + "'" : "NULL");// PaymentReferenceNumber
                sqlStatment.Append(",");
                sqlStatment.Append(order.CustomerRef != null ? "'" + order.CustomerRef.Replace("'", "''") + "'" : "NULL");// PaymentReferenceNumber
                sqlStatment.Append(",");
                sqlStatment.Append(order.SDCId > 0 ? order.SDCId.ToString() : "NULL");
                sqlStatment.Append(",");
                sqlStatment.Append(order.ApprovalStatus/* > 0 ? order.ApprovalStatus.ToString() : "NULL"*/);
                sqlStatment.Append(",");
                sqlStatment.Append(order.WarehouseId);
                sqlStatment.Append(",");
                sqlStatment.Append(order.CollectionMethod);
                sqlStatment.Append(",");
                sqlStatment.Append(order.IncludedTaxAmount);
                sqlStatment.Append(",");
                sqlStatment.Append(order.IsBundle ? "1": "0");
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());

                if (result != GlobalErrors.Success)
                {
                    Thread.Sleep(200);
                    return SaveOrderHeaders(order, dbHelper, --tryCounter);
                }
                else
                {
                    return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveRecurringOrder(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO RecurringOrder
                                (OrderID
                                ,CustomerID
                                ,OutletID
                                ,DivisionID
                                ,CreatedBy
                                ,CreatedDate
                                ,ActivationDate
                                ,DeActivationDate
                                ,OptionType
                                ,OptionData
                                ,RecurringStatusID
                                ,Comment
                                ,ChangedReasonID
                                ,LastGeneratedDate
                                ,ResumeDate) VALUES ('{0}',{1},{2},{3},{4},{5},{6},{7},{8},'{9}',{10},{11},{12},{13},{14})",
                            order.OrderId
                            , order.Outlet.CustomerId
                            , order.Outlet.OutletId
                            , order.DivisionId
                            , _requestRepository.CurrentOperator.EmployeeId
                            , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                            , order.RecurringStatusId == RecurringOrderStatus.Active.GetHashCode() ? LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) : "NULL"
                            , order.RecurringStatusId != RecurringOrderStatus.Active.GetHashCode() ? LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) : "NULL"
                            , order.RecurringTypeId
                            , order.RecurringValue.TrimEnd(',')
                            , order.RecurringStatusId
                            , (order.RecurringComment != null && !string.IsNullOrEmpty(order.RecurringComment.Trim())) ? "'" + order.RecurringComment.Replace("'", "''").Trim() + "'" : "NULL"
                            , (order.RecurringChangedReasonId <= 0 ? -1 : order.RecurringChangedReasonId)
                            , LocalUtilities.ParseDateToSQLString(new DateTime(1990, 1, 1))
                            , ((order.ResumeDateModel != null && order.ResumeDateModel.Date != DateTime.MinValue) ? LocalUtilities.ParseDateToSQLString(order.ResumeDateModel.Date) : "NULL"));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors UpdateOrderDetails(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM SalesOrderDetail
                               WHERE OrderID  = '{3}' AND CustomerID = {0} AND OutletID = {1} AND DivisionID = {2}"
                , order.Outlet.CustomerId
                , order.Outlet.OutletId
                , order.DivisionId
                , order.OrderId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    result = SaveOrderDetails(order, dbHelper);
                }
                if (result == GlobalErrors.Success &&
                    order.OrderTypeId == OrderTypes.Return &&
                    _requestRepository.Configurations.RestrictReturnFromInvoices &&
                    _requestRepository.Configurations.RestrictReturnQtyFromInvoices &&
                    order.IsRestrictedFromOldInvoices &&
                    (order.OrderStatus == OrderStatus.New || order.OrderStatus == OrderStatus.Approved))
                {
                    query = $@"Delete from ReturnInvoicesPacksHistory where returnTransactionId = '{order.OrderId}' 
                        and ReturnInvoicesPacksHistory.CustomerId = {order.CustomerId} and ReturnInvoicesPacksHistory.OutletId = {order.OutletId}";
                    result = dbHelper.ExecuteNonQuery(query);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors UpdateOrderHeaders(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"
                UPDATE SalesOrder
                SET DesiredDeliveryDate = {2}, LPO = {3},CustomerRef = {22}
                , Discount = {4}, GrossTotal = {5}, Tax = {6}, ActualNetTotal = {7},ExciseTax={18}
                , NetTotal = {8}, DivisionID = {9}, PromotedDiscount = {10}, RecievedBOTime = {11}
                , Synchronized = {12}, HeaderDiscount = {13}, UpdatedBy = {15}, UpdatedDate = {16}, OrderSourceId = {17}
                ,DeliveryChargesId ={19}, DeliveryValue={20}, DeliveryTax ={21}, CollectionMethod = {23} , IncludedTaxAmount = {24}
                 WHERE OrderID = '{14}' And DivisionID = {9} And CustomerID = {0}  And OutletID = {1}"
                , order.Outlet.CustomerId //0
                , order.Outlet.OutletId //1
                , LocalUtilities.ParseDateAndTimeToSQL(order.DesiredDeliveryDateModel.Date) //2
                , string.IsNullOrEmpty(order.LPO) || string.IsNullOrEmpty(order.LPO.Trim()) ? "NULL" : "'" + order.LPO.Replace("'", "''").Trim() + "'" //3
                , order.Discount //4
                , order.GrossTotal//5
                , order.Tax//6
                , order.ActualNetTotal//7
                , order.NetTotal//8
                , order.DivisionId//9
                , "0"//10
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)//11
                , 0//12
                , order.HeaderDiscount//13
                , order.OrderId//14
                , _requestRepository.CurrentOperator.EmployeeId//15
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)//16
                , (order.OrderSourceId > 0 ? order.OrderSourceId.ToString() : "OrderSourceId")//17
                , order.CalculatedRetailTax//18
                , order.DeliveryChargesId == null ? "null" : order.DeliveryChargesId.ToString()//19
                , order.DeliveryValue == null ? "null" : order.DeliveryValue.ToString()//20
                , order.DeliveryTax == null ? "null" : order.DeliveryTax.ToString()//21
                , string.IsNullOrEmpty(order.CustomerRef) || string.IsNullOrEmpty(order.CustomerRef.Trim()) ? "NULL" : "'" + order.CustomerRef.Replace("'", "''").Trim() + "'"//22
                , order.CollectionMethod //23
                , order.IncludedTaxAmount // 24
                );
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors SaveOrderChangeHistory(OrderModel order, DBHelper<int> dbHelper, OrderModificationTypes type)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO SalesOrderChangeHistory
                           (OrderID
                           ,CustomerID
                           ,OutletID
                           ,DivisionID
                           ,UpdatedDate
                           ,UpdatedBy
                           ,ModifyOrderSourceID
                           ,ModifyOrderReasonID
                           ,Action)
                           VALUES ('{0}',{1},{2},{3}, {4}, {5},{6},{7},{8})",
                order.OrderId
                , order.Outlet.CustomerId
                , order.Outlet.OutletId
                , order.DivisionId
                , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                , _requestRepository.CurrentOperator.EmployeeId
                , order.ModifySourceId
                , order.ModifyReasonId
                , type.GetHashCode());
                result = dbHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateRecurringOrder(OrderModel order, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                if (order.RecurringTypeId <= 0 || order.RecurringValue == null || string.IsNullOrEmpty(order.RecurringValue.Trim()))
                {
                    return GlobalErrors.Success;
                }
                string query = string.Format(@"UPDATE RecurringOrder SET ActivationDate = {4}, DeActivationDate = {5}, OptionType = {6},
                            OptionData = '{7}', RecurringStatusID = {8}, Comment = {9}, ChangedReasonID = {10}, LastGeneratedDate = {11}, UpdatedBy = {12}, UpdatedDate = {13}, ResumeDate = {14}
                            WHERE OrderID = '{0}' AND CustomerID = {1} AND OutletID = {2} AND DivisionID = {3}",
                           order.OrderId
                           , order.Outlet.CustomerId
                           , order.Outlet.OutletId
                           , order.DivisionId
                           // Change the Activation Date only if the old status is not active and the new status is active
                           , order.RecurringStatusId == RecurringOrderStatus.Active.GetHashCode() ? string.Format("Case when RecurringStatusID <> 1 THEN {0} ELSE ActivationDate END", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)) : "ActivationDate"   // --> Keep it Same don't change it
                           , order.RecurringStatusId != RecurringOrderStatus.Active.GetHashCode() ? string.Format("Case when RecurringStatusID = 1 THEN {0} ELSE DeActivationDate END", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)) : "DeActivationDate"   // --> Keep it Same don't change it
                           , order.RecurringTypeId
                           , order.RecurringValue.TrimEnd(',')
                           , order.RecurringStatusId
                           , (order.RecurringComment != null && !string.IsNullOrEmpty(order.RecurringComment.Trim())) ? "'" + order.RecurringComment.Replace("'", "''").Trim() + "'" : "NULL"
                           , (order.RecurringChangedReasonId <= 0 ? -1 : order.RecurringChangedReasonId)
                           , LocalUtilities.ParseDateToSQLString(new DateTime(1990, 1, 1))
                           , _requestRepository.CurrentOperator.EmployeeId
                           , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                           , ((order.ResumeDateModel != null && order.ResumeDateModel.Date != DateTime.MinValue) ? LocalUtilities.ParseDateToSQLString(order.ResumeDateModel.Date) : "NULL"));
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = SaveRecurringOrder(order, dbHelper);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateRecurringOrder(OrderCRMModel recurringModel)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = new DBHelper<int>();

            try
            {
                string query = string.Format(@"UPDATE RecurringOrder SET ActivationDate = {4}, DeActivationDate = {5}, OptionType = {6},
                            OptionData = '{7}', RecurringStatusID = {8}, Comment = {9}, ChangedReasonID = {10}, LastGeneratedDate = {11}, UpdatedBy = {12}, UpdatedDate = {13}, ResumeDate = {14}
                            WHERE OrderID = '{0}' AND CustomerID = {1} AND OutletID = {2} AND DivisionID = {3}",
                           recurringModel.OrderId
                           , recurringModel.CustomerId
                           , recurringModel.OutletId
                           , recurringModel.DivisionId
                           // Change the Activation Date only if the old status is not active and the new status is active
                           , recurringModel.RecurringStatusId == RecurringOrderStatus.Active.GetHashCode() ? string.Format("Case when RecurringStatusID <> 1 THEN {0} ELSE ActivationDate END", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)) : "ActivationDate"   // --> Keep it Same don't change it
                           , recurringModel.RecurringStatusId != RecurringOrderStatus.Active.GetHashCode() ? string.Format("Case when RecurringStatusID = 1 THEN {0} ELSE DeActivationDate END", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)) : "DeActivationDate"   // --> Keep it Same don't change it
                           , recurringModel.RecurringTypeId
                           , recurringModel.RecurringValue.TrimEnd(',')
                           , recurringModel.RecurringStatusId
                           , (recurringModel.RecurringComment != null && !string.IsNullOrEmpty(recurringModel.RecurringComment.Trim())) ? "'" + recurringModel.RecurringComment.Replace("'", "''").Trim() + "'" : "NULL"
                           , (recurringModel.RecurringChangedReasonId <= 0 ? -1 : recurringModel.RecurringChangedReasonId)
                           , LocalUtilities.ParseDateToSQLString(new DateTime(1990, 1, 1))
                           , _requestRepository.CurrentOperator.EmployeeId
                           , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                           , ((recurringModel.RecurringStatusId == RecurringOrderStatus.OnHold.GetHashCode() && recurringModel.ResumeDateModel != null && recurringModel.ResumeDateModel.Date != DateTime.MinValue) ? LocalUtilities.ParseDateToSQLString(recurringModel.ResumeDateModel.Date) : "NULL"));
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteOrder(OrderModel order)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"UPDATE SalesOrder SET OrderStatusId = {0}, UpdatedBy = {1}, UpdatedDate = {2}
                            WHERE OrderID = '{3}' AND CustomerID = {4} AND OutletID = {5} AND DivisionID = {6}",
                           order.OrderStatusId
                           , _requestRepository.CurrentOperator.EmployeeId
                           , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)
                           , order.OrderId
                           , order.Outlet.CustomerId
                           , order.Outlet.OutletId
                           , order.DivisionId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    result = SaveOrderChangeHistory(order, dbHelper, OrderModificationTypes.Delete);
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetRecurringHistory(int customerId, int outletId, ref SharedTableResult<RecurringModel> recurringList)
        {
            recurringList = new SharedTableResult<RecurringModel>();
            DBHelper<RecurringModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<RecurringModel> recurringHistory = new List<RecurringModel>();
            string orderByFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<RecurringModel>();
                string query = string.Format(@"SELECT RecurringOrder.RecurringID, RecurringStatusLanguage.Description RecurringStatus, RecurringOrder.OrderId,
                            ISNULL(RecurringChangedReasonLanguage.Description, '---') ChangedReason,
                            ISNULL(RecurringOrder.Comment, '---') Comment,
                            ISNULL(lastOrder.OrderID, '---') LastOrderId,
                            ISNULL(UpdatedBy.Description, '---') UpdatedBy,
                            RecurringOrder.CreatedDate, RecurringOrder.OptionType, RecurringOrder.OptionData,
                            RecurringOrder.ResumeDate, RecurringOrder.DeActivationDate,
                            lastOrder.OrderDate lastOrderDate, RecurringOrder.UpdatedDate, CreatedBy.Description CreatedBy
                            FROM RecurringOrder  with (nolock)
                            INNER JOIN SalesOrder  with (nolock) ON SalesOrder.OrderID = RecurringOrder.OrderID AND SalesOrder.CustomerID = RecurringOrder.CustomerID AND SalesOrder.OutletID = RecurringOrder.OutletID AND SalesOrder.DivisionID = RecurringOrder.DivisionID
                            INNER JOIN RecurringStatusLanguage with (nolock) ON RecurringStatusLanguage.RecurringStatusID = RecurringOrder.RecurringStatusID AND RecurringStatusLanguage.LanguageID = {2}
                            LEFT JOIN (SELECT MAX(OrderDate) orderDate, lastOrder.SourceOrderID, lastOrder.CustomerID, lastOrder.OutletID, lastOrder.DivisionID , lastOrder.OrderID
                            FROM SalesOrder lastOrder  with (nolock) WHERE lastOrder.OrderStatusID NOT IN ({3},{4}) GROUP BY lastOrder.SourceOrderID,lastOrder.OrderID, lastOrder.CustomerID, lastOrder.OutletID, lastOrder.DivisionID) as lastOrder ON lastOrder.SourceOrderID = SalesOrder.OrderID AND SalesOrder.CustomerID = lastOrder.CustomerID AND SalesOrder.OutletID = lastOrder.OutletID AND SalesOrder.DivisionID = lastOrder.DivisionID
                            LEFT JOIN RecurringChangedReasonLanguage ON RecurringChangedReasonLanguage.RecurringChangedReasonID = RecurringOrder.ChangedReasonID AND RecurringChangedReasonLanguage.LanguageID = {2}
                            LEFT JOIN EmployeeLanguage CreatedBy ON CreatedBy.EmployeeID = RecurringOrder.CreatedBy AND CreatedBy.LanguageID = {2}
                            LEFT JOIN EmployeeLanguage UpdatedBy ON UpdatedBy.EmployeeID = RecurringOrder.UpdatedBy AND UpdatedBy.LanguageID = {2}
                            WHERE RecurringOrder.CustomerID = {0} AND RecurringOrder.OutletID = {1} ",
                customerId, outletId, _requestRepository.LanguageId, OrderStatus.Canceled.GetHashCode(), OrderStatus.Deleted.GetHashCode());

                orderByFilter = string.Format(@" ORDER BY RecurringOrder.CreatedDate desc, RecurringOrder.RecurringStatusID, RecurringOrder.ActivationDate desc");
                string selectionQuery = string.Format(@" {0} {1}",
                query, //0
                orderByFilter//1
               );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt",
                query);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    recurringList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(query, ref recurringHistory);
                    recurringHistory.ForEach(a =>
                    {
                        if (a.UpdatedDate == DateTime.MinValue)
                        {
                            a.UpdatedDateString = "---";
                        }
                        else
                        {
                            a.UpdatedDateString = a.UpdatedDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.DeActivationDate == DateTime.MinValue)
                        {
                            a.DeActivationDateString = "---";
                        }
                        else
                        {
                            a.DeActivationDateString = a.DeActivationDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.LastOrderDate == DateTime.MinValue)
                        {
                            a.LastOrderDateString = "---";
                        }
                        else
                        {
                            a.LastOrderDateString = a.LastOrderDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.ResumeDate == DateTime.MinValue)
                        {
                            a.ResumeDateString = "---";
                        }
                        else
                        {
                            a.ResumeDateString = a.ResumeDate.ToString("dd/MM/yyyy");
                        }
                        if (a.OptionType == "1")
                        {
                            a.OptionType = "Weekly";
                            string values = string.Empty;
                            if (a.OptionData.Contains("1"))
                                values = "Sun, ";
                            if (a.OptionData.Contains("2"))
                                values += "Mon, ";
                            if (a.OptionData.Contains("3"))
                                values += "Tue, ";
                            if (a.OptionData.Contains("4"))
                                values += "Wed, ";
                            if (a.OptionData.Contains("5"))
                                values += "Thu, ";
                            if (a.OptionData.Contains("6"))
                                values += "Fri, ";
                            if (a.OptionData.Contains("7"))
                                values += "Sat";
                            a.OptionData = values.Trim().TrimEnd(',');
                        }
                        else if (a.OptionType == "2")
                        {
                            a.OptionType = "Monthly";
                        }
                        else if (a.OptionType == "3")
                        {
                            a.OptionType = "Every 2 Weeks";
                            string values1 = "Week1 [";
                            string values2 = "Week2 [";
                            var options = a.OptionData.Split(',').ToList();

                            if (options.Contains("1"))
                                values1 += "Sun, ";
                            if (options.Contains("2"))
                                values1 += "Mon, ";
                            if (options.Contains("3"))
                                values1 += "Tue, ";
                            if (options.Contains("4"))
                                values1 += "Wed, ";
                            if (options.Contains("5"))
                                values1 += "Thu, ";
                            if (options.Contains("6"))
                                values1 += "Fri, ";
                            if (options.Contains("7"))
                                values1 += "Sat";
                            if (options.Contains("8"))
                                values2 += "Sun, ";
                            if (options.Contains("9"))
                                values2 += "Mon, ";
                            if (options.Contains("10"))
                                values2 += "Tue, ";
                            if (options.Contains("11"))
                                values2 += "Wed, ";
                            if (options.Contains("12"))
                                values2 += "Thu, ";
                            if (options.Contains("13"))
                                values2 += "Fri, ";
                            if (options.Contains("14"))
                                values2 += "Sat";
                            a.OptionData = string.Empty;
                            if (values1 != "Week1 [")
                            {
                                a.OptionData = values1.Trim().TrimEnd(',').Trim() + "]";
                            }
                            if (values2 != "Week2 [")
                            {
                                if (a.OptionData != string.Empty)
                                {
                                    a.OptionData += Environment.NewLine;
                                }
                                a.OptionData += values2.Trim().TrimEnd(',').Trim() + "]";
                            }
                        }
                    });
                    recurringList.Data = recurringHistory;
                }
                else
                {
                    return GlobalErrors.Error;
                }
                //result = dbHelper.GetQueryList(query, ref recurringList);
                //if (result == GlobalErrors.Success && recurringList != null && recurringList.Count > 0)
                //{
                //    
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                recurringList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetRecurringHistory(ref List<RecurringModel> recurringList)
        {
            recurringList = new List<RecurringModel>();
            DBHelper<RecurringModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string supervisionJoin = string.Empty;
            try
            {
                dbHelper = new DBHelper<RecurringModel>();
                StringBuilder orgAccessJoin = new StringBuilder();

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" And SalesOrder.EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                    string query = string.Format(@"SELECT Distinct RecurringOrder.RecurringStatusID, RecurringOrder.ActivationDate, RecurringOrder.RecurringID, RecurringStatusLanguage.Description RecurringStatus, RecurringOrder.OrderId,
                            RecurringOrder.CustomerID , RecurringOrder.OutletID,
                            CustomerLanguage.Description CustomerName, CustomerOutletLanguage.Description OutletName,
                            IsNull( Customer.CustomerCode , '--')  + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description  , '--') as CustomerCodeName,
                            IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description  , '--') as OutletCodeName,
                            ISNULL(RecurringChangedReasonLanguage.Description, '---') ChangedReason,
                            ISNULL(RecurringOrder.Comment, '---') Comment,
                            --ISNULL(lastSelectedOrder.OrderID, '---') LastOrderId,
                            ISNULL(UpdatedBy.Description, '---') UpdatedBy,
                            RecurringOrder.CreatedDate, RecurringOrder.OptionType, RecurringOrder.OptionData,
                            RecurringOrder.ResumeDate, RecurringOrder.DeActivationDate,
                            lastOrder.OrderDate lastOrderDate, RecurringOrder.UpdatedDate, CreatedBy.Description CreatedBy
                            FROM RecurringOrder
                            INNER JOIN SalesOrder with (nolock)  ON SalesOrder.OrderID = RecurringOrder.OrderID AND SalesOrder.CustomerID = RecurringOrder.CustomerID AND SalesOrder.OutletID = RecurringOrder.OutletID AND SalesOrder.DivisionID = RecurringOrder.DivisionID
                            INNER JOIN Customer ON Customer.CustomerID=RecurringOrder.CustomerID
                            Inner Join CustomerOutlet on CustomerOutlet.CustomerID = RecurringOrder.CustomerID and CustomerOutlet.OutletID = RecurringOrder.OutletID 
                            {3} {5}
 LEFT OUTER JOIN CustomerLanguage ON RecurringOrder.CustomerID = CustomerLanguage.CustomerID  AND CustomerLanguage.LanguageID = {0}
                LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  RecurringOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {0}                    
INNER JOIN RecurringStatusLanguage ON RecurringStatusLanguage.RecurringStatusID = RecurringOrder.RecurringStatusID AND RecurringStatusLanguage.LanguageID = {0}
                            LEFT JOIN (SELECT MAX(OrderDate) orderDate, lastOrder.SourceOrderID, lastOrder.CustomerID, lastOrder.OutletID, lastOrder.DivisionID 
                            FROM SalesOrder lastOrder with (nolock)  WHERE lastOrder.OrderStatusID NOT IN ({1},{2}) GROUP BY lastOrder.SourceOrderID, lastOrder.CustomerID, lastOrder.OutletID, lastOrder.DivisionID) as lastOrder ON lastOrder.SourceOrderID = SalesOrder.OrderID AND SalesOrder.CustomerID = lastOrder.CustomerID AND SalesOrder.OutletID = lastOrder.OutletID AND SalesOrder.DivisionID = lastOrder.DivisionID and SalesOrder.OrderTypeID = {4}
	  LEFT JOIN (SELECT lastSelectedOrder.OrderID,lastSelectedOrder.OrderDate
							  ,lastSelectedOrder.SourceOrderID,lastSelectedOrder.CustomerID, lastSelectedOrder.OutletID, lastSelectedOrder.DivisionID 
                            FROM SalesOrder lastSelectedOrder with (nolock)  WHERE lastSelectedOrder.OrderStatusID NOT IN ({1},{2})) as lastSelectedOrder ON lastOrder.CustomerID = lastSelectedOrder.CustomerID AND lastOrder.OutletID = lastSelectedOrder.OutletID AND lastOrder.DivisionID = lastSelectedOrder.DivisionID and lastSelectedOrder.orderDate=lastOrder.orderDate
							and lastSelectedOrder.SourceOrderID=lastOrder.SourceOrderID
                            LEFT JOIN RecurringChangedReasonLanguage ON RecurringChangedReasonLanguage.RecurringChangedReasonID = RecurringOrder.ChangedReasonID AND RecurringChangedReasonLanguage.LanguageID = {0}
                            LEFT JOIN EmployeeLanguage CreatedBy ON CreatedBy.EmployeeID = RecurringOrder.CreatedBy AND CreatedBy.LanguageID = {0}
                            LEFT JOIN EmployeeLanguage UpdatedBy ON UpdatedBy.EmployeeID = RecurringOrder.UpdatedBy AND UpdatedBy.LanguageID = {0}
                            ORDER BY RecurringOrder.CreatedDate desc, RecurringOrder.RecurringStatusID, RecurringOrder.ActivationDate desc  ",
                           _requestRepository.LanguageId, //0
                           OrderStatus.Canceled.GetHashCode(), //1 
                           OrderStatus.Deleted.GetHashCode(), //2
                           orgAccessJoin, //3
                           OrderTypes.Sales.GetHashCode(), //4
                           supervisionJoin //5

                           );
                result = dbHelper.GetQueryList(query, ref recurringList);
                if (result == GlobalErrors.Success && recurringList != null && recurringList.Count > 0)
                {
                    recurringList.ForEach(a =>
                    {
                        if (a.UpdatedDate == DateTime.MinValue)
                        {
                            a.UpdatedDateString = "---";
                        }
                        else
                        {
                            a.UpdatedDateString = a.UpdatedDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.DeActivationDate == DateTime.MinValue)
                        {
                            a.DeActivationDateString = "---";
                        }
                        else
                        {
                            a.DeActivationDateString = a.DeActivationDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.LastOrderDate == DateTime.MinValue)
                        {
                            a.LastOrderDateString = "---";
                        }
                        else
                        {
                            a.LastOrderDateString = a.LastOrderDate.ToString("dd/MM/yyyy hh:mm tt");
                        }
                        if (a.ResumeDate == DateTime.MinValue)
                        {
                            a.ResumeDateString = "---";
                        }
                        else
                        {
                            a.ResumeDateString = a.ResumeDate.ToString("dd/MM/yyyy");
                        }
                        if (a.OptionType == "1")
                        {
                            a.OptionType = ResourcesManager.TranslateKey(MessagesConstants.Desc_Weekly, _requestRepository.LanguageId);
                            string values = string.Empty;
                            if (a.OptionData.Contains("1"))
                                values = ResourcesManager.TranslateKey(MessagesConstants.Desc_Sunday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("2"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Monday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("3"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Tuesday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("4"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Wednesday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("5"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Thursday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("6"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Friday, _requestRepository.LanguageId) + ", ";
                            if (a.OptionData.Contains("7"))
                                values += ResourcesManager.TranslateKey(MessagesConstants.Desc_Saturday, _requestRepository.LanguageId);
                            a.OptionData = values.Trim().TrimEnd(',');
                        }
                        else if (a.OptionType == "2")
                        {
                            a.OptionType = ResourcesManager.TranslateKey(MessagesConstants.Desc_Monthly, _requestRepository.LanguageId);
                        }
                        else if (a.OptionType == "3")
                        {
                            a.OptionType = ResourcesManager.TranslateKey(MessagesConstants.Desc_Every_Two_Weeks, _requestRepository.LanguageId);
                            string values1 = "Week1 [";
                            string values2 = "Week2 [";
                            var options = a.OptionData.Split(',').ToList();

                            if (options.Contains("1"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Sunday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("2"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Monday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("3"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Tuesday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("4"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Wednesday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("5"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Thursday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("6"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Friday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("7"))
                                values1 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Saturday, _requestRepository.LanguageId);
                            if (options.Contains("8"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Sunday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("9"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Monday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("10"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Tuesday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("11"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Wednesday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("12"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Thursday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("13"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Friday, _requestRepository.LanguageId) + ", ";
                            if (options.Contains("14"))
                                values2 += ResourcesManager.TranslateKey(MessagesConstants.Desc_Saturday, _requestRepository.LanguageId);
                            a.OptionData = string.Empty;
                            if (values1 != ResourcesManager.TranslateKey(MessagesConstants.Desc_Saturday, _requestRepository.LanguageId) + "1 [")
                            {
                                a.OptionData = values1.Trim().TrimEnd(',').Trim() + "]";
                            }
                            if (values2 != ResourcesManager.TranslateKey(MessagesConstants.Desc_Saturday, _requestRepository.LanguageId) + "2 [")
                            {
                                if (a.OptionData != string.Empty)
                                {
                                    a.OptionData += Environment.NewLine;
                                }
                                a.OptionData += values2.Trim().TrimEnd(',').Trim() + "]";
                            }
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                recurringList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRecurringDetails(RecurringModel recurringOrder, ref OrderCRMModel orderModel)
        {
            DBHelper<RecurringModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                orderModel = new OrderCRMModel();
                result = GetOrderDetailsCRM(recurringOrder.CustomerId, recurringOrder.OutletId, recurringOrder.OrderId, ref orderModel);
                if (result == GlobalErrors.Success && orderModel != null)
                {
                    orderModel.NetTotal = orderModel.SoldItems.Sum(a => a.NetTotal);
                    dbHelper = new DBHelper<RecurringModel>();
                    string query = string.Format(@"SELECT OptionType, OptionData FROM RecurringOrder
                        WHERE RecurringOrder.CustomerID = {0} AND RecurringOrder.OutletID = {1} AND RecurringOrder.RecurringId = {2} AND RecurringOrder.OrderID = '{3}'",
                    recurringOrder.CustomerId, recurringOrder.OutletId, recurringOrder.RecurringId, recurringOrder.OrderId);
                    RecurringModel recurModel = new RecurringModel();
                    result = dbHelper.GetQuerySingle(query, ref recurModel);
                    DateTime nextDate = DateTime.Today;
                    if (result == GlobalErrors.Success && recurModel != null)
                    {
                        if (recurModel.OptionType == "1")
                        {
                            for (int i = 0; i < 7; i++)
                            {
                                int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                if (recurModel.OptionData.Contains(todayDayOfWeek.ToString()))
                                {
                                    if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                    {
                                        nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                    }
                                    else
                                    {
                                        int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                        if (DateTime.Now.Month == 12)
                                            nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);
                                        else
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                    }
                                    break;
                                }
                            }
                        }
                        else if (recurModel.OptionType == "2")
                        {
                            List<int> daysOfMonth = recurModel.OptionData.Split(',').ToList().Select(int.Parse).ToList();
                            daysOfMonth.Sort();
                            var x = daysOfMonth.Where(a => a >= DateTime.Today.Day).ToList();
                            if (x != null && x.Count > 0)
                            {
                                if (x[0] <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                {
                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, x[0], 12, 0, 0);
                                }
                                else
                                {
                                    if (DateTime.Now.Month == 12)
                                        nextDate = new DateTime(DateTime.Today.Year + 1, 1, 1, 12, 0, 0);
                                    else
                                        nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, 1, 12, 0, 0);

                                }
                                if (nextDate.DayOfWeek == DayOfWeek.Friday)
                                {
                                    nextDate = nextDate.AddDays(1);
                                }
                            }
                            else if (daysOfMonth.Count > 0)
                            {
                                if (DateTime.Now.Month == 12)
                                    nextDate = new DateTime(DateTime.Today.Year + 1, 1, daysOfMonth[0], 12, 0, 0);
                                else
                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, daysOfMonth[0], 12, 0, 0);

                                if (nextDate.DayOfWeek == DayOfWeek.Friday)
                                {
                                    nextDate = nextDate.AddDays(1);
                                }
                            }
                        }
                        else if (recurModel.OptionType == "3")
                        {
                            List<string> optionValues = recurModel.OptionData.Split(',').ToList();
                            int todayWeekNo = LocalUtilities.GetWeekNumber(DateTime.Today);
                            bool isEven = todayWeekNo % 2 == 0;
                            if (isEven)
                            {
                                bool isCalculated = false;
                                //Start from second week then first week
                                for (int i = 0; i < 7; i++)
                                {
                                    int todayDayOfWeek = DateTime.Today.AddDays(i).DayOfWeek.GetHashCode();
                                    if (todayDayOfWeek == DayOfWeek.Saturday.GetHashCode())
                                    {
                                        todayDayOfWeek = 14;
                                    }
                                    else
                                    {
                                        todayDayOfWeek += 8;
                                    }
                                    if (optionValues.Contains(todayDayOfWeek.ToString()))
                                    {
                                        if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                        {
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                        }
                                        else
                                        {
                                            int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                            if (DateTime.Now.Month == 12)
                                                nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);
                                            else
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                        }
                                        isCalculated = true;
                                        break;
                                    }
                                }
                                if (!isCalculated)
                                {
                                    for (int i = 0; i < 7; i++)
                                    {
                                        int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                        if (optionValues.Contains(todayDayOfWeek.ToString()))
                                        {
                                            if (DateTime.Today.Day + i + 7 <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                            {
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i + 7, 12, 0, 0);
                                            }
                                            else
                                            {
                                                int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                                if (DateTime.Now.Month == 12)
                                                    nextDate = new DateTime(DateTime.Today.Year + 1, 1, ((i + 7) - days), 12, 0, 0);
                                                else
                                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, ((i + 7) - days), 12, 0, 0);

                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                            else
                            {
                                //Start from first week then second week
                                for (int i = 0; i < 13; i++)
                                {
                                    int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                    if (i > 6)
                                    {
                                        todayDayOfWeek += 7;
                                    }
                                    if (optionValues.Contains(todayDayOfWeek.ToString()))
                                    {
                                        if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                        {
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                        }
                                        else
                                        {
                                            int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                            if (DateTime.Now.Month == 12)
                                                nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);
                                            else
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        orderModel.NextDeliveryDate = nextDate;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                orderModel = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetRecurringDetails(int customerId, int outletId, string orderId, int recurId, ref OrderCRMModel orderModel)
        {
            DBHelper<RecurringModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                orderModel = new OrderCRMModel();
                result = GetOrderDetailsCRM(customerId, outletId, orderId, ref orderModel);
                if (result == GlobalErrors.Success)
                {
                    orderModel.NetTotal = orderModel.SoldItems.Sum(a => a.NetTotal);
                    dbHelper = new DBHelper<RecurringModel>();
                    string query = string.Format(@"SELECT OptionType, OptionData FROM RecurringOrder
                        WHERE RecurringOrder.CustomerID = {0} AND RecurringOrder.OutletID = {1} AND RecurringOrder.RecurringId = {2} AND RecurringOrder.OrderID = '{3}'",
                    customerId, outletId, recurId, orderId);
                    RecurringModel recurModel = new RecurringModel();
                    result = dbHelper.GetQuerySingle(query, ref recurModel);
                    DateTime nextDate = DateTime.Today;
                    if (result == GlobalErrors.Success && recurModel != null)
                    {
                        if (recurModel.OptionType == "1")
                        {
                            for (int i = 0; i < 7; i++)
                            {
                                int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                if (recurModel.OptionData.Contains(todayDayOfWeek.ToString()))
                                {
                                    if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                    {
                                        nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                    }
                                    else
                                    {
                                        int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                        if (DateTime.Now.Month == 12)
                                            nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);
                                        else
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                    }
                                    break;
                                }
                            }
                        }
                        else if (recurModel.OptionType == "2")
                        {
                            List<int> daysOfMonth = recurModel.OptionData.Split(',').ToList().Select(int.Parse).ToList();
                            daysOfMonth.Sort();
                            var x = daysOfMonth.Where(a => a >= DateTime.Today.Day).ToList();
                            if (x != null && x.Count > 0)
                            {
                                if (x[0] <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                {
                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, x[0], 12, 0, 0);
                                }
                                else
                                {
                                    if (DateTime.Now.Month == 12)
                                        nextDate = new DateTime(DateTime.Today.Year + 1, 1, 1, 12, 0, 0);
                                    else
                                        nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, 1, 12, 0, 0);
                                }
                                if (nextDate.DayOfWeek == DayOfWeek.Friday)
                                {
                                    nextDate = nextDate.AddDays(1);
                                }
                            }
                            else if (daysOfMonth.Count > 0)
                            {
                                if (DateTime.Now.Month == 12)
                                    nextDate = new DateTime(DateTime.Today.Year + 1, 1, daysOfMonth[0], 12, 0, 0);
                                else
                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, daysOfMonth[0], 12, 0, 0);

                                if (nextDate.DayOfWeek == DayOfWeek.Friday)
                                {
                                    nextDate = nextDate.AddDays(1);
                                }
                            }
                        }
                        else if (recurModel.OptionType == "3")
                        {
                            List<string> optionValues = recurModel.OptionData.Split(',').ToList();
                            int todayWeekNo = LocalUtilities.GetWeekNumber(DateTime.Today);
                            bool isEven = todayWeekNo % 2 == 0;
                            if (isEven)
                            {
                                bool isCalculated = false;
                                //Start from second week then first week
                                for (int i = 0; i < 7; i++)
                                {
                                    int todayDayOfWeek = DateTime.Today.AddDays(i).DayOfWeek.GetHashCode();
                                    if (todayDayOfWeek == DayOfWeek.Saturday.GetHashCode())
                                    {
                                        todayDayOfWeek = 14;
                                    }
                                    else
                                    {
                                        todayDayOfWeek += 8;
                                    }
                                    if (optionValues.Contains(todayDayOfWeek.ToString()))
                                    {
                                        if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                        {
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                        }
                                        else
                                        {
                                            int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                            if (DateTime.Now.Month == 12)
                                                nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);
                                            else
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                        }
                                        isCalculated = true;
                                        break;
                                    }
                                }
                                if (!isCalculated)
                                {
                                    for (int i = 0; i < 7; i++)
                                    {
                                        int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                        if (optionValues.Contains(todayDayOfWeek.ToString()))
                                        {
                                            if (DateTime.Today.Day + i + 7 <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                            {
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i + 7, 12, 0, 0);
                                            }
                                            else
                                            {
                                                int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                                if (DateTime.Now.Month == 12)
                                                    nextDate = new DateTime(DateTime.Today.Year + 1, 1, ((i + 7) - days), 12, 0, 0);
                                                else
                                                    nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, ((i + 7) - days), 12, 0, 0);

                                            }
                                            break;
                                        }
                                    }
                                }
                            }
                            else
                            {
                                //Start from first week then second week
                                for (int i = 0; i < 13; i++)
                                {
                                    int todayDayOfWeek = (DateTime.Today.AddDays(i).DayOfWeek.GetHashCode() + 1);
                                    if (i > 6)
                                    {
                                        todayDayOfWeek += 7;
                                    }
                                    if (optionValues.Contains(todayDayOfWeek.ToString()))
                                    {
                                        if (DateTime.Today.Day + i <= DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month))
                                        {
                                            nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month, DateTime.Today.Day + i, 12, 0, 0);
                                        }
                                        else
                                        {
                                            int days = DateTime.DaysInMonth(DateTime.Today.Year, DateTime.Now.Month) - DateTime.Now.Day;
                                            if (DateTime.Now.Month == 12)
                                                nextDate = new DateTime(DateTime.Today.Year, DateTime.Now.Month + 1, (i - days), 12, 0, 0);
                                            else
                                                nextDate = new DateTime(DateTime.Today.Year + 1, 1, (i - days), 12, 0, 0);

                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        orderModel.NextDeliveryDate = nextDate;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                orderModel = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckSelectedDateHasOrder(string orderId, int customerId, int outletId, DateTime selectedDate, bool checkOrdersForToday, ref OrderDateValidationResponse resultData)
        {
            DateTime BiWeeklyRefDate = new DateTime(2020, 1, 5);

            DBHelper<OrderDateValidationResponse> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            resultData = null;
            try
            {
                if (orderId == null)
                {
                    orderId = string.Empty;
                }
                string orderDateColumn = string.Empty;
                string recurringOrderUnion = string.Empty;
                string editRecurringOptionFilter = string.Empty;
                if (checkOrdersForToday)
                {
                    orderDateColumn = " OrderDate ";
                    // when checking for order creation date, check for normal orders and recurring orders.
                    editRecurringOptionFilter = " CASE WHEN RecurringOrder.OrderID IS NOT NULL THEN 1 ELSE 0 END as ShowEditRecurringOption  ";
                }
                else
                {
                    #region[Every Two Weeks Recurring Type]
                    TimeSpan diff = selectedDate - BiWeeklyRefDate;
                    int dayNum = diff.Days % 14 + 1;

                    XmlDocument xmlDoc = new XmlDocument();
                    xmlDoc.Load(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase) + "\\DataSources.xml");

                    string refDate = xmlDoc.SelectSingleNode("Connections/refDate") != null ? xmlDoc.SelectSingleNode("Connections/refDate").InnerText : string.Empty;
                    if (!string.IsNullOrEmpty(refDate))
                    {
                        DateTime.TryParse(refDate, out BiWeeklyRefDate);
                    }
                    #endregion
                    // when checking for order desired delivery date, check for normal orders only, and check recurring from recurringOrder table.
                    editRecurringOptionFilter = " 0  as ShowEditRecurringOption";
                    orderDateColumn = " DesiredDeliveryDate ";
                    recurringOrderUnion = $@"UNION
                SELECT OrderID, 0 as ShowEditOrderOption,1 as ShowEditRecurringOption FROM RecurringOrder with(nolock) WHERE CustomerID = {customerId} AND OutletID = {outletId} AND RecurringStatusID = {RecurringOrderStatus.Active.GetHashCode()}
                AND
                OptionData like '%{selectedDate.DayOfWeek.GetHashCode() + 1}%' AND OptionType = {RecurOrderOptionType.Weekly.GetHashCode()}  --(Weekly)
                AND OrderID <> '{orderId}'
                  UNION
                SELECT OrderID, 0 as ShowEditOrderOption,1 as ShowEditRecurringOption FROM RecurringOrder with(nolock) WHERE CustomerID = {customerId} AND OutletID = {outletId} AND RecurringStatusID = {RecurringOrderStatus.Active.GetHashCode()}
                AND
                OptionData like '%{selectedDate.Day}%' AND OptionType = {RecurOrderOptionType.Monthly.GetHashCode()}  --(Monthly)
                AND OrderID <> '{orderId}'
                UNION
                SELECT OrderID, 0 as ShowEditOrderOption,1 as ShowEditRecurringOption FROM RecurringOrder with(nolock) WHERE CustomerID = {customerId} AND OutletID = {outletId} AND RecurringStatusID = {RecurringOrderStatus.Active.GetHashCode()}
                AND
                OptionData like '%{dayNum}%' AND OptionType = {RecurOrderOptionType.EveryTwoWeeks.GetHashCode()}  --(Every Two Weeks)
                AND OrderID <> '{orderId}'";
                }
                dbHelper = new DBHelper<OrderDateValidationResponse>();
                string query = string.Format(@"SELECT SalesOrder.OrderID,
CASE WHEN SalesOrder.OrderStatusID = {4} THEN 1 ELSE 0 END as ShowEditOrderOption,
{10}
FROM SalesOrder with (nolock) 
LEFT JOIN RecurringOrder with (nolock) on RecurringOrder.OrderID = SalesOrder.OrderID
WHERE {5} >= {0} AND {5} < {1}
                AND SalesOrder.CustomerID = {2} AND SalesOrder.OutletId = {3} 				
AND ((SalesOrder.OrderStatusID <> {7}) OR (SalesOrder.OrderStatusID = {7} and RecurringOrder.OrderID IS NOT NULL and RecurringOrder.RecurringStatusID = {8}))
AND SalesOrder.OrderID <> '{9}'
                {6}",
                    LocalUtilities.ParseDateToSQLString(selectedDate), //0
                    LocalUtilities.ParseDateToSQLString(selectedDate.AddDays(1)), //1
                    customerId, //2
                    outletId, //3
                    OrderStatus.New.GetHashCode(), //4
                    orderDateColumn, //5
                    recurringOrderUnion, //6
                    OrderStatus.Deleted.GetHashCode(), //7
                    RecurringOrderStatus.Active.GetHashCode(), //8
                    orderId, //9
                    editRecurringOptionFilter // 10
                    );

                List<OrderDateValidationResponse> validationResult = new List<OrderDateValidationResponse>();

                TimeSpan ts = new TimeSpan();
                Stopwatch stopWatch = new Stopwatch();
                string elapsedTime = string.Empty;
                stopWatch.Start();


                result = dbHelper.GetQueryList(query, ref validationResult);

                stopWatch.Stop();
                ts = stopWatch.Elapsed;
                elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, query, elapsedTime);


                if (result == GlobalErrors.Success && validationResult != null && validationResult.Count > 0)
                {
                    resultData = new OrderDateValidationResponse();
                    resultData.IsThereAnyOrders = true;
                    resultData.ShowEditOrderOption = validationResult.Any(x => x.ShowEditOrderOption);
                    resultData.ShowEditRecurringOption = validationResult.Any(r => r.ShowEditRecurringOption);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                resultData = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public bool IsAbleToOffloadOrder(string orderId, int vehicleId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            DataTable dt = new DataTable();
            try
            {
                dbHelper = new DBHelper<int>();

                string query = string.Format(@"select *  from 
                ( select p.ItemID , sum( p.Quantity * ABS(wh.QuantityChange)) as WHQty
                  from WarehouseStockHistoryArc  wh 
                  inner join salesorder so on so.WarehouseTransactionID = wh.TransactionID 
                  inner join pack p on wh.PackID = p.PackID 
                  where so.OrderID  ='{0}' 
                  group by p.ItemID )  
                as t1
                left join( 
	                select p.ItemID , sum( p.Quantity * ws.Quantity) as WSQty 
		                from WarehouseStock  ws  
	                inner join pack p on ws.PackID = p.PackID 
	                WHERE ws.WarehouseID = {1}  group by p.ItemID ) as t2                                      
                on t1.ItemID = t2.ItemID  and t2.WSQty > = t1.WHQty   
                where  t2.ItemID is null", orderId, vehicleId);

                result = dbHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    return false;
                }
                else
                {
                    return true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }

        public bool IsAbleToLoadOrderFromWarehouse(string orderId, int warehouseId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            DataTable dt = new DataTable();
            try
            {
                dbHelper = new DBHelper<int>();

                string query = string.Format(@"select *  from 
                ( select p.ItemID , sum( p.Quantity * sod.Quantity) as RequiredQty
                from salesorder  so 
                inner join SalesOrderDetail sod on sod.OrderID = so.OrderID 
                inner join pack p on sod.PackID = p.PackID 
                where so.OrderID  = '{0}' 
                group by p.ItemID )  
                as t1
                left join( 
                select p.ItemID, sum( p.Quantity * ws.Quantity) as AvailableQtyInPcs 
                from WarehouseStock  ws  
                inner join pack p on ws.PackID = p.PackID 
                WHERE ws.WarehouseID = {1}  group by p.ItemID) as t2                                      
                on t1.ItemID = t2.ItemID  and t2.AvailableQtyInPcs > = t1.RequiredQty   
                where  t2.ItemID is null", orderId, warehouseId);

                result = dbHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    return false;
                }
                else
                {
                    return true;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public bool CheckIfOrderHasSerialItems(string orderId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            int count = 0;
            try
            {
                dbHelper = new DBHelper<int>();

                string query = string.Format(@"select count(*) countOfSerializedItems from SalesOrderDetail 
inner join Pack on pack.PackID=SalesOrderDetail.PackID
where SalesOrderDetail.OrderID='{0}' and pack.HasSerialNumber=1", orderId);

                result = dbHelper.GetQuerySingle(query, ref count);
                if (result == GlobalErrors.Success && count > 0)
                {
                    return true;
                }
                else
                {
                    return false;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public static GlobalErrors GetLoadingWarehousesForEmployeeAsString(int employeeId, DBHelper<int> dBHelper, ref string warehouseIds)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                List<int> warehousesList = new List<int>();
                string query = string.Format(@" select VehicleLoadingWh.WarehouseId 
                from VehicleLoadingWh 
                inner join Warehouse on Warehouse.WarehouseId = VehicleLoadingWh.WarehouseId
                inner join EmployeeVehicle on EmployeeVehicle.VehicleId = VehicleLoadingWh.VehicleId and EmployeeVehicle.EmployeeId = {0}",
                employeeId);
                result = dBHelper.GetQueryList(query, ref warehousesList);
                if (result == GlobalErrors.Success && warehousesList != null && warehousesList.Count > 0)
                {
                    warehouseIds = string.Join(",", warehousesList.Select(n => n.ToString()).ToArray());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetMainWarehouseForEmployeeAsString(ref string warehouseIds)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                List<int> warehousesList = new List<int>();
                string query = string.Format(@" select WarehouseID from Warehouse where WarehouseTypeID = 1 and OrganizationID in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);

                TimeSpan ts = new TimeSpan();
                Stopwatch stopWatch = new Stopwatch();
                string elapsedTime = string.Empty;
                stopWatch.Start();

                result = dBHelper.GetQueryList(query, ref warehousesList);

                stopWatch.Stop();
                ts = stopWatch.Elapsed;
                elapsedTime = String.Format("{0:00}:{1:00}:{2:00}.{3:00}", ts.Hours, ts.Minutes, ts.Seconds, ts.Milliseconds / 10);
                ErrorLogger.TrackQuery(_requestRepository.CurrentOperator.EmployeeId, MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, query, elapsedTime);

                if (result == GlobalErrors.Success && warehousesList != null && warehousesList.Count > 0)
                {
                    warehouseIds = string.Join(",", warehousesList.Select(n => n.ToString()).ToArray());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetEmployeeAssignedOrdersList(int EmployeeID, ref List<OrderModel> orderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<OrderModel>();
                string dataQuery = string.Empty;
                string orderByFilter = string.Empty;
                var mainQuery = new StringBuilder();
                var orderStatus = string.Empty;
                var deliveryStatus = string.Empty;
                var invoicedOrdersFilter = string.Empty;
                deliveryStatus = string.Format("{0}", (int)DeliveryStatus.Assigned);
                orderStatus = string.Format("{0},{1},{2}", (int)OrderStatus.Assigned, (int)OrderStatus.LoadRequestAccepted, (int)OrderStatus.WaitForLoad);
                mainQuery.AppendFormat(@" FROM SalesOrder
                INNER JOIN Customer ON Customer.CustomerID=SalesOrder.CustomerID
                Inner Join CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID  AND CustomerLanguage.LanguageID = {2}
                and CustomerLanguage.OrganizationId in ({3})
                LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {2}
                LEFT OUTER JOIN OrderStatusLanguage ON SalesOrder.OrderstatusID = OrderStatusLanguage.OrderStatusID  AND  OrderStatusLanguage.LanguageID = {2}
                INNER JOIN DeliveryAssignment on SalesOrder.OrderID = DeliveryAssignment.OrderID AND SalesOrder.CustomerID = DeliveryAssignment.CustomerID AND SalesOrder.outletID = DeliveryAssignment.outletID and SalesOrder.DivisionID = DeliveryAssignment.DivisionID
                LEFT OUTER JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {2}
                LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID= {2}
                INNER JOIN  Employee on Employee.EmployeeID = DeliveryAssignment.EmployeeID
                LEFT OUTER JOIN  EmployeeLanguage ON DeliveryAssignment.EmployeeID = EmployeeLanguage.EmployeeID AND EmployeeLanguage.LanguageID = {2}
                where Customer.New <> 1  And SalesOrder.OrderTypeID <> 4 AND DeliveryAssignment.DeliveryStatusID in ({0}) and SalesOrder.OrderStatusID in({1}) and SalesOrder.OrganizationID in ({3}) AND DeliveryAssignment.EmployeeID = {4} "
                , deliveryStatus, orderStatus, _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess, EmployeeID);
                dataQuery = string.Format(@"Select Distinct
                                             SalesOrder.OrderID,
                                             SalesOrder.OrderDate OrderDate ,
                                             SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                                             DeliveryAssignment.ScheduleDate ScheduleDate,
                                             CustomerLanguage.Description CustomerName,
                                             CustomerOutletLanguage.Description OutletName,
                                             ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                             ISNULL (DivisionLanguage.Description,'') Division,
                                             IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
	                                         SalesOrder.OrderStatusID OrderStatus,
                                             OrderStatusLanguage.Description OrderStatusDescription,
                                             case when SalesOrder.OrderTypeID = 3 then cast('Exchange' as nvarchar(100))
                                             else OrderTypeLanguage.Description end OrderType,salesOrder.OrderTypeID ,
                                             SalesOrder.CustomerID ,
                                             SalesOrder.OutletID,
                                             DeliveryAssignment.EmployeeID,
											 SalesOrder.NetTotal,
											 SalesOrder.Discount,
											 SalesOrder.GrossTotal,
											 SalesOrder.Tax,
											 SalesOrder.HeaderDiscount,
											 SalesOrder.ExciseTax  CalculatedRetailTax,
											 SalesOrder.ExchangeRate,
											 DeliveryAssignment.EmployeeID as DriverId,
											 SalesOrder.OrganizationID as OrganizationId,
											 SalesOrder.DivisionID
                                             {0}
                                           ", mainQuery.ToString());
                result = dbHelper.GetQueryList(dataQuery, ref orderList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateOrderAssignment(int EmployeeID, string changeDriverOrders, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format(@"update DeliveryAssignment Set EmployeeID = {0} 
                Where OrderID in ({1})"
                , EmployeeID, changeDriverOrders);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteOrderAssignment(string changeDriverOrders, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                query = string.Format(@"Delete From  DeliveryAssignment
                Where OrderID in ({0})"
                , changeDriverOrders);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateOrderStatus(string orderID, int orderStatusID, int previousOrderStatusID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();

                string query = string.Format(@"update SalesOrder Set OrderStatusID = {0},PreviousOrderStatus={1} Where OrderID in ({2})"
                 , orderStatusID, previousOrderStatusID, orderID);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsAnyDeliveryAssignmentUploadedPerSelectedOrder(OrderModel order, ref bool IsAnyDeliveryAssignmentUploaded, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                IsAnyDeliveryAssignmentUploaded = false;
                object objField = 0;
                string query = string.Format(@"SELECT IsNull(Count(*),0) countt FROM DeliveryAssignment WHERE OrderID = '{0}' and CustomerId = {1} and OutletId = {2} and DivisionId = {3} and Uploaded = 1",
                order.OrderId,
                order.CustomerId,
                order.OutletId,
                order.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && Int32.Parse(objField.ToString()) > 0)
                {
                    IsAnyDeliveryAssignmentUploaded = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors IsMultiOrderLoadRequest(OrderModel order, ref bool IsMultiOrderLoadRequest, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                IsMultiOrderLoadRequest = false;
                object objField = 0;
                string query = string.Format(@"SELECT SourceTransactionID FROM WarehouseTransaction WHERE TransactionID = '{0}' and DivisionId = {1}",
                order.WarehouseTransactionId,
                order.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()) && objField.ToString() == CoreDataBaseConstants.QueryColumnsNames.MultiOrdersCaption)
                {
                    IsMultiOrderLoadRequest = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        #region[Validate Transaction Statuses]
        public GlobalErrors ValidateVoidedTransactionStatus(string voidedTransactionId, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string test = Environment.StackTrace;
                if (dbHelper != null)
                {
                    TransactionModel voidedTransaction = new TransactionModel();
                    DBHelper<TransactionModel> dBHelper1 = new DBHelper<TransactionModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());

                    string query = $@"Select Voided, TransactionStatusID from [Transaction] where transactionid = '{voidedTransactionId}'
                    and CustomerId = {customerId} and outletId = {outletId}";
                    result = dBHelper1.GetQuerySingle(query, ref voidedTransaction);
                    if (result == GlobalErrors.Success)
                    {
                        if ((voidedTransaction.Voided == false && voidedTransaction.TransactionStatusId == TransactionStatues.Voided.GetHashCode()) ||
                                                (voidedTransaction.Voided == true && voidedTransaction.TransactionStatusId != TransactionStatues.Voided.GetHashCode()))
                        {
                            string errorMessage = $" Transaction ('{voidedTransactionId}') has TransactionStatusId of {voidedTransaction.TransactionStatusId} and Voided flag value of {(voidedTransaction.Voided ? 1 : 0)} ";
                            string stackTrace = Environment.StackTrace;
                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, errorMessage, null, stackTrace, 0);
                            result = GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ValidateVoidedTransactionPaymentStatus(string voidedTransactionId, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper != null)
                {
                    // PaymentStatusTypes
                    PaymentModel voidedTxPayment = new PaymentModel();
                    DBHelper<PaymentModel> dbHelper1 = new DBHelper<PaymentModel>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                    string query = $@"select CustomerPaymentId ,PaymentStatusID from CustomerPayment where transactionid = '{voidedTransactionId}' 
                    and CustomerId = {customerId} and outletId = {outletId}";
                    result = dbHelper1.GetQuerySingle(query, ref voidedTxPayment);
                    if (result == GlobalErrors.Success && voidedTxPayment != null)
                    {
                        if (voidedTxPayment.PaymentStatusId != PaymentStatusTypes.Voided)
                        {
                            string errorMessage = $" Transaction ('{voidedTransactionId}') was voided but payment: ({voidedTxPayment.CustomerPaymentId}) has PaymentStatus of ('{voidedTxPayment.PaymentStatusId}') ";
                            string stackTrace = Environment.StackTrace;
                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, errorMessage, null, stackTrace, 0);
                            result = GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion


        public GlobalErrors RestoreVoidedTransactionShelveIncentive(int customerId, int outletId, string voidedTransactionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" UPDATE D set D.RemainingValue = D.RemainingValue + H.Value  from  ContractedFOCDetail D 
                inner join ContractedFOCHistory H on D.ContractID = H.ContractID AND D.CustomerID = H.CustomerID and D.OutletID = H.OutletID AND H.TransactionID = '{voidedTransactionId}' 
                inner join ContractedFOC C on C.ContractID = D.ContractID and C.CustomerID = D.CustomerID AND C.OutletID = D.OutletID AND C.ContractTypeID = {(int)ContractType.ShelfIncentive} 
                WHERE D.CustomerID = {customerId} AND D.OutletID = {outletId}";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        #region APIs

        public GlobalErrors GetOrderStatus(string OrderNumber, ref OrderStatusAPIModel Status)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderStatusAPIModel> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<OrderStatusAPIModel>();
                string Query = string.Format(@"Select OrderStatusLanguage.Description AS Status
                                            FROM SalesOrder
                                            INNER JOIN OrderStatusLanguage ON OrderStatusLanguage.OrderStatusID = SalesOrder.OrderStatusID 
                                            AND OrderStatusLanguage.LanguageID = 1
                                            where SalesOrder.OrderID = '{0}' ", OrderNumber);

                result = dbHelper.GetQuerySingle(Query, ref Status);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOrdersList(string SiteCode, string From_Date, string To_Date, ref List<OrderAPIModel> OrderList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderAPIModel> dbHelper = null;
            OrderList = new List<OrderAPIModel>();
            int CustomerId = -1, OutletId = -1;
            try
            {
                _customerManager.GetIDsByCustomerCode(SiteCode, ref CustomerId, ref OutletId);
                dbHelper = new DBHelper<OrderAPIModel>();
                string Query = string.Format(@"Select SalesOrder.OrderID AS OrderNumber, SalesOrder.OrderDate,CustomerOutlet.CustomerCode as SiteCode, 
                                               CustomerOutletLanguage.Description AS CustomerName, OrderStatusLanguage.Description AS Status, 
                                               SalesOrder.NetTotal, SalesOrder.GrossTotal, SalesOrder.Tax, SalesOrder.Discount
                                               FROM SalesOrder
                                               INNER JOIN Customer ON Customer.CustomerID = SalesOrder.CustomerID
                                               inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                               INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID 
                                               AND CustomerOutlet.OutletID = SalesOrder.OutletID
                                               LEFT OUTER JOIN CustomerLanguage ON Customer.CustomerID = CustomerLanguage.CustomerID 
                                               AND CustomerLanguage.LanguageID = 1 and CustomerLanguage.OrganizationId in ({4})
                                               LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID 
                                               AND CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = 1
                                               LEFT OUTER JOIN OrderStatusLanguage ON SalesOrder.OrderstatusID = OrderStatusLanguage.OrderStatusID  
                                               AND OrderStatusLanguage.LanguageID = 1
                                               LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID 
                                               AND OrderTypeLanguage.LanguageID= 1                                     
                                               Where SalesOrder.CustomerID = {0} AND SalesOrder.OutletID = {1} AND SalesOrder.OrderDate >= {2} 
                                               AND SalesOrder.OrderDate <= {3}",
                                               CustomerId,
                                               OutletId,
                                               LocalUtilities.ParseDateToSQLString(DateTime.Parse(From_Date)),
                                               LocalUtilities.ParseEndDateToSQLString(DateTime.Parse(To_Date)),
                                               _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQueryList(Query, ref OrderList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetOrderItems(string SiteCode, string OrderId, ref List<ItemPackAPIModel> itemsList)
        {
            DBHelper<ItemPackAPIModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            int CustomerId = -1, OutletId = -1;
            try
            {
                _customerManager.GetIDsByCustomerCode(SiteCode.Trim(), ref CustomerId, ref OutletId);
                dbHelper = new DBHelper<ItemPackAPIModel>();

                string query = string.Format(@"SELECT SalesOrderDetail.Tax as ItemTax, SalesOrderDetail.Price, SalesOrderDetail.PackID, 
                                            SalesOrderDetail.Quantity, ItemLanguage.Description AS itemName, PackTypeLanguage.Description Uom, 
                                            Item.ItemCode
                                            FROM  SalesOrderDetail
                                            INNER JOIN Pack on pack.PackID=SalesOrderDetail.PackID
                                            INNER JOIN Item on Item.ItemID=Pack.ItemID
                                            INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                                            LEFT OUTER JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND PackTypeLanguage.LanguageID = 1
                                            LEFT OUTER JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND ItemLanguage.LanguageID = 1
                                            WHERE SalesOrderDetail.OrderId = '{0}' AND SalesOrderDetail.CustomerID = {1} AND SalesOrderDetail.OutletID = {2} 
                                            Order by SalesTransactionTypeID,Sequence,ItemLanguage.Description"
                                           , OrderId, CustomerId, OutletId);

                result = dbHelper.GetQueryList(query, ref itemsList);

                return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public bool CheckIfValueIsUsed(DBHelper<int> dbHelper, string tableName, string columnName, string value, string extraFilter)
        {
            bool used = false;
            string query = string.Empty;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = new object();
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                query = string.Format(@"Select count(*) from {0} where {1} = '{2}' {3}",
                    tableName, columnName,
                    columnName.Equals(CoreDataBaseConstants.QueryColumnsNames.Phone)
                    || columnName.Equals(CoreDataBaseConstants.QueryColumnsNames.Number) ? value.TrimStart('0') : value,
                    extraFilter);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null
                    && !string.IsNullOrEmpty(field.ToString())
                    && int.Parse(field.ToString()) > 0)
                {
                    used = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return used;
        }

        public GlobalErrors SaveOrderFromAPI(SendOrderAPIModel Order)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            bool AllowPromotion = true;

            int CustomerId = -1, OutletId = -1, EmployeeId = -1, CurrencyId = -1;
            string Query = string.Empty;
            try
            {
                result = _customerManager.GetIDsByCustomerCode(Order.SiteCode, ref CustomerId, ref OutletId);
                if (result == GlobalErrors.Success && _requestRepository.LoginData != null)
                {
                    EmployeeId = int.Parse(_requestRepository.LoginData.UserId);

                    if (result == GlobalErrors.Success)
                    {
                        result = _currencyManager.GetBaseCurrencyId(ref CurrencyId);
                    }
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    if (result == GlobalErrors.Success && CheckIfValueIsUsed(dbHelper, CoreDataBaseConstants.TableNames.SalesOrder, CoreDataBaseConstants.QueryColumnsNames.OrderID, Order.OrderNumber, string.Empty))
                    {
                        result = GlobalErrors.DataAlreadyExists;
                    }
                    else if (result == GlobalErrors.Success && CustomerId <= 0 && OutletId <= 0)
                    {
                        result = GlobalErrors.AllSerialsInvalid;
                    }

                    if (result == GlobalErrors.Success)
                    {
                        Query = string.Format(@"INSERT INTO SalesOrder (CustomerID, OutletID, OrderID, DesiredDeliveryDate, OrderDate, Synchronized,
                        OrderstatusID, EmployeeID, LPO, NetTotal, PromotedDiscount, ConfirmationSignature, Downloaded, Discount, GrossTotal,
                        Tax, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate, CreationSource, supervisorID, helperID, DivisionID, 
                        SalesManagerID, RecievedBOTime, OrganizationID, Description, DriverID, SalesRepID, ActualNetTotal, OrderTypeID, 
                        HeaderDiscount, SourceOrderID, GPSLatitude, GPSlongitude, RouteHistoryID, VisitNo, ExciseTax, ExchangeRate, 
                        SelectedCurrencyID) VALUES ({0}, {1}, '{2}', {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, {18}, {19}, 
                        {20}, {21}, {22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {31}, {32}, {33}, {34}, {35}, {36}, {37}, {38}, {39}, {40})",
                        CustomerId, //CustomerId 0
                        OutletId, // OutletId 1
                        Order.OrderNumber,// OrderId 2
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Parse(Order.DeliveryDate)),// DesirderDeliveryDate 3
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//OrderDate 4
                        0, // Synchronized 5
                        OrderStatus.Approved.GetHashCode(), // OrderStatus 6
                        EmployeeId, // EmployeeId 7
                        "NULL", // LPO 8
                        Order.NetTotal, // NetTotal 9
                        "0", // PromotedDiscount 10
                        "NULL", // ConfirmationSignature 11
                        "0", // Downloaded 12
                        Order.Discount, // Discount 13
                        Order.GrossTotal, // GrossTotal 14
                        Order.Tax, // Tax 15
                        EmployeeId, // CreatedBy 16
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), // CreatedDate 17
                        "NULL", // UpdatedBy 18
                        "NULL", // UpdatedDate 19
                        CreationSource.SonicAPI.GetHashCode(), // CreationSource 20
                        "NULL", // SupervisorId 21
                        "NULL", // HelperId 22
                        -1, // DivisionId 23
                        "NULL",// SalesManagerId 24
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),// RecievedBOTime 25
                        1, // OrganizationId26
                        "NULL", // Description 27
                        "NULL", // DriverId 28
                        "NULL", // SalesRepId 29
                        "NULL", // ActualNetTotal 30
                        1, // OrderTypeId 31
                        Order.Discount, // HeaderDiscount 32
                        "NULL", // SourceOrderId 33
                        "0", // GpsLatitude 34
                        "0", // GpsLongitude 35
                        "NULL", // RouteHistoryID 36
                        "NULL", // VisitNo 37
                        "0", // ExciseTax 38
                        "0", // ExchangeRate 39
                        CurrencyId); // SelectedCurrencyID 40
                        result = dbHelper.ExecuteNonQuery(Query);
                    }
                }
                //return result;
                if (result == GlobalErrors.Success)
                {
                    int itemSequance = 0;
                    if (Order.AllItems == null || Order.AllItems.Count <= 0)
                    {
                        result = GlobalErrors.NotEnoughQuantity;
                    }

                    if (result == GlobalErrors.Success)
                    {
                        foreach (SendItemPackAPIModel pack in Order.AllItems)
                        {
                            itemSequance++;
                            int packid = 0;
                            Query = string.Format(@"Select PackID from pack 
                            inner join item on item.ItemID = pack.ItemID 
                            inner join PackTypeLanguage on PackTypeLanguage.PackTypeID = pack.PackTypeID 
                            where item.ItemCode = '{0}' and PackTypeLanguage.Description = '{1}'", pack.ItemCode, pack.UOM);
                            result = dbHelper.GetQuerySingle(Query, ref packid);

                            if (result == GlobalErrors.Success)
                            {
                                Query = string.Format(@"Insert into SalesOrderDetail (OrderID, PackID, Quantity, Price, Tax, Discount, CustomerID, 
                                OutletID, SalesTransactionTypeID, BasePrice, DivisionID, FOC, DiscountTypeID, ActualDeliveredQuantity, 
                                PromotedDiscount, FinalDiscount, AdditionalDiscount, Sequence, PackStatusID, BatchNo, ExpiryDate, 
                                SalesOrderTypeID, StockStatusID, BaseDiscount, ItemPromotedDiscount, AllItemDiscount, BaseTax, 
                                UsedPriceListID, RequestedQuantity, ExciseTax, BaseDiscountTypeID, SecondaryPackTypeID, SecondaryQuantity, 
                                SecondaryPackID) Values ('{0}', {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, 
                                {18}, {19}, {20}, {21}, {22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {31}, {32}, {33})",
                                Order.OrderNumber, // OrderId 0
                                packid, //PackId 1
                                pack.Quantity, //RequiredQty 2
                                pack.Price, //Price 3
                                pack.TaxAmount, //Tax 4
                                pack.DiscountAmount, //Discount 5
                                CustomerId, //CustomerID 6
                                OutletId, //OutletID 7
                                1, //SalesTransactionTypeID 8
                                pack.Price, //BasePrice 9
                                -1, //DivisionId 10
                                0, //Foc 11
                                1, // DiscountTypeID 12
                                0, //ActualDeliveredQuantity 13
                                0, // PromotedDiscount 14
                                0, //FinalDiscountPercentage 15
                                0, //AdditionalDiscount 16
                                itemSequance, //itemSequance 17
                                "-1", //PackStatusID 18
                                "1990/01/01", //BatchNo 19
                                "01-01-1990", //DefaultExpiryDate 20
                                OrderTypes.Sales.GetHashCode(), //OrderTypes 21
                                -1, //StockStatusID 22
                                pack.DiscountAmount, //BaseDiscount 23
                                0, //ItemPromotedDiscount 24
                                0, //AllItemDiscount 25
                                pack.TaxAmount, //BaseTax 26
                                -1, //UsedPriceListID 27
                                pack.Quantity, //RequestedQuantity 28
                                0, //ExciseValue 29
                                "Null", //BaseDiscountTypeID 30
                                "NULL", //SecondaryPackTypeID 31
                                "NULL", //SecondaryQuantity 32
                                "NULL"); //SecondaryPackID 33

                                result = dbHelper.ExecuteNonQuery(Query);
                            }
                            if (result != GlobalErrors.Success)
                                break;
                        }
                    }

                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    return result;
                }
                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, DocumentTypes.Order, Order.OrderNumber, long.Parse(EmployeeId.ToString()), 1);
                }

                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetSiteUpdatedProducts(string SiteCode, ref ProductsAPIModel Products)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ProductsAPIModel.ItemDetail> dbHelper = null;
            List<ProductsAPIModel.ItemDetail> Items = new List<ProductsAPIModel.ItemDetail>();
            int CustomerId = -1, OutletId = -1;
            try
            {
                result = _customerManager.GetIDsByCustomerCode(SiteCode, ref CustomerId, ref OutletId);
                dbHelper = new DBHelper<ProductsAPIModel.ItemDetail>();
                string Query = string.Format(@"select distinct I.ItemCode, IL.Description as ItemName, ICL.Description as Category, PTL.Description as UOM, 
                ISNULL(Prices.Price,0) Price, P.PackID
                from RouteCustomer RC
                INNER JOIN CustomerOutlet CO on RC.CustomerID = CO.CustomerID AND RC.OutletID = CO.OutletID
                INNER JOIN Route R on R.RouteID = RC.RouteID
                INNER JOIN Territory T on T.TerritoryID = R.TerritoryID
                INNER JOIN EmployeeTerritory ET on ET.TerritoryID = T.TerritoryID
                INNER JOIN EmployeeDivision ED on ED.EmployeeID = ET.EmployeeID
                INNER JOIN Division D on D.DivisionID = ED.DivisionID
                INNER JOIN ItemCategory IC on IC.DivisionID = D.DivisionID
                LEFT OUTER JOIN ItemCategoryLanguage ICL on ICL.ItemCategoryID = IC.ItemCategoryID AND ICL.LanguageID = {0}
                INNER JOIN Item I on I.ItemCategoryID = IC.ItemCategoryID
                LEFT OUTER JOIN ItemLanguage IL on IL.ItemID = I.ItemID AND IL.LanguageID = {0}
                INNER JOIN Pack P on P.ItemID = I.ItemID
                INNER JOIN PackType PT on PT.PackTypeID = P.PackTypeID
                LEFT OUTER JOIN PackTypeLanguage PTL on PTL.PackTypeID = PT.PackTypeID AND PTL.LanguageID = {0}
                LEFT OUTER JOIN (
                select PriceDefinition.PacKID, PriceDefinition.Price, PriceDefinition.PriceListID , 
                row_number ()  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber, 
                tt.Priority
                from PriceDefinition

                inner join(
                select PriceListID, 1 as Priority from CustomerPrice
                where CustomerID = {1} and OutletID = {2}

                union
                select PriceListID, 2 as Priority from GroupPrice
                where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {1} and OutletID = {2})

                union
                select PriceListID, 3 as Priority from ChannelPrice
                where  SubChannelID in (select SubChannelID from CustomerGroup 
                where GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {1} and OutletID = {2}))

                 
                union
                select PriceListID, 5 as Priority from PriceDefinition
                Where 
                PriceDefinition.PriceListID in ({3})

                union
                select PriceListID, 6 as Priority from PriceDefinition
                Where PriceDefinition.PriceListID in ({3})
                ) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null
                inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 
                )Prices on P.PackID = Prices.PacKID and Prices.Priority is not null and Prices.PriceListID is not null
                and prices.rowNumber = 1 or Prices.rowNumber is null
                Where CO.CustomerId = {1} AND CO.OutletID = {2}
                ", _requestRepository.LanguageId, CustomerId, OutletId, _requestRepository.Configurations.DefaultPriceListID);

                result = dbHelper.GetQueryList(Query, ref Items);

                if (result == GlobalErrors.Success && Items != null && Items.Count > 0)
                {
                    Products.ItemDetails = Items;
                    Products.TotalItems = Items.Count;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetUpdatedProducts(string PriceListCode, ref ProductsAPIModel Products)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ProductsAPIModel.ItemDetail> dbHelper = null;
            List<ProductsAPIModel.ItemDetail> Items = new List<ProductsAPIModel.ItemDetail>();
            try
            {

                dbHelper = new DBHelper<ProductsAPIModel.ItemDetail>();
                string Query = string.Format(@"select distinct I.ItemCode, IL.Description as ItemName, ICL.Description as Category, 
                PTL.Description as UOM, PD.Price, P.PackID 
                from Pack P
                INNER JOIN Item I on I.ItemID = P.ItemID
                LEFT OUTER JOIN ItemLanguage IL on IL.ItemID = I.ItemID AND IL.LanguageID = {0}
                LEFT OUTER JOIN ItemCategoryLanguage ICL on ICL.ItemCategoryID = I.ItemCategoryID AND ICL.LanguageID = {0}
                LEFT OUTER JOIN PackTypeLanguage PTL on PTL.PackTypeID = P.PackTypeID AND PTL.LanguageID = {0}
                INNER JOIN PriceDefinition PD on PD.PacKID = P.PackID
                INNER JOIN PriceList PL on PL.PriceListID = PD.PriceListID
                where PL.PriceListCode = '{1}'", _requestRepository.LanguageId, PriceListCode);

                result = dbHelper.GetQueryList(Query, ref Items);

                if (result == GlobalErrors.Success && Items != null && Items.Count > 0)
                {
                    Products.ItemDetails = Items;
                    Products.TotalItems = Items.Count;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveEDIOrder(OrderModel orderModel, ref EDIOrderOutputModel afterSavingData)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            int currencyID = -1;
            string Query = string.Empty;
            DateTime desiredDeliveryDate = DateTime.Today.AddDays(1);
            try
            {
                result = _currencyManager.GetBaseCurrencyId(ref currencyID);
                if (DateTime.Now.DayOfWeek == DayOfWeek.Thursday)
                {
                    desiredDeliveryDate = desiredDeliveryDate.AddDays(1);
                }
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if (result == GlobalErrors.Success)
                {
                    Query = string.Format(@"INSERT INTO SalesOrder (CustomerID, OutletID, OrderID, DesiredDeliveryDate, OrderDate, Synchronized,
                    OrderstatusID, EmployeeID, LPO, NetTotal, PromotedDiscount, ConfirmationSignature, Downloaded, Discount, GrossTotal,
                    Tax, CreatedBy, CreatedDate, UpdatedBy, UpdatedDate, CreationSource, supervisorID, helperID, DivisionID, 
                    SalesManagerID, RecievedBOTime, OrganizationID, Description, DriverID, SalesRepID, ActualNetTotal, OrderTypeID, 
                    HeaderDiscount, SourceOrderID, GPSLatitude, GPSlongitude, RouteHistoryID, VisitNo, ExciseTax, ExchangeRate, 
                    SelectedCurrencyID,SalesMode) VALUES ({0}, {1}, '{2}', {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, {18}, {19}, 
                    {20}, {21}, {22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {31}, {32}, {33}, {34}, {35}, {36}, {37}, {38}, {39}, {40},{41})",
                    orderModel.CustomerId, //CustomerId 0
                    orderModel.OutletId, // OutletId 1
                    orderModel.OrderId,// OrderId 2
                    LocalUtilities.ParseDateAndTimeToSQL(desiredDeliveryDate),// DesirderDeliveryDate 3
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//OrderDate 4
                    0, // Synchronized 5
                    OrderStatus.New.GetHashCode(), // OrderStatus 6
                    orderModel.CreatedBy, // EmployeeId 7
                     "Null", // LPO 8
                    orderModel.NetTotal, // NetTotal 9
                    "0", // PromotedDiscount 10
                     "Null", // ConfirmationSignature 11
                    "0", // Downloaded 12
                    orderModel.Discount, // Discount 13
                    orderModel.GrossTotal, // GrossTotal 14
                    orderModel.Tax, // Tax 15
                    orderModel.CreatedBy, // CreatedBy 16
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), // CreatedDate 17
                     "Null", // UpdatedBy 18
                     "Null", // UpdatedDate 19
                    (int)orderModel.CreationSource, // CreationSource 20
                     "Null", // SupervisorId 21
                     "Null", // HelperId 22
                    orderModel.DivisionId, // DivisionId 23
                     "Null",// SalesManagerId 24
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),// RecievedBOTime 25
                    _requestRepository.CurrentOperator.OrganizationId, // OrganizationId26
                     "Null", // Description 27
                     "Null", // DriverId 28
                     "Null", // SalesRepId 29
                     "Null", // ActualNetTotal 30
                    (int)OrderTypes.Sales, // OrderTypeId 31
                    orderModel.HeaderDiscount, // HeaderDiscount 32
                     "Null", // SourceOrderId 33
                    "0", // GpsLatitude 34
                    "0", // GpsLongitude 35
                     "Null", // RouteHistoryID 36
                     "Null", // VisitNo 37
                    orderModel.CalculatedRetailTax, // ExciseTax 38
                    "0", // ExchangeRate 39
                    currencyID, // SelectedCurrencyID 40
                    orderModel.SalesMode); //SalesMode 41
                    result = dbHelper.ExecuteNonQuery(Query);
                }
                if (result == GlobalErrors.Success)
                {
                    int itemSequance = 0;
                    foreach (ItemPackModel pack in orderModel.AllItems)
                    {
                        itemSequance++;
                        Query = string.Format(@"Insert into SalesOrderDetail (OrderID, PackID, Quantity, Price, Tax, Discount, CustomerID, 
                            OutletID, SalesTransactionTypeID, BasePrice, DivisionID, FOC, DiscountTypeID, ActualDeliveredQuantity, 
                            PromotedDiscount, FinalDiscount, AdditionalDiscount, Sequence, PackStatusID, BatchNo, ExpiryDate, 
                            SalesOrderTypeID, StockStatusID, BaseDiscount, ItemPromotedDiscount, AllItemDiscount, BaseTax, 
                            UsedPriceListID, RequestedQuantity, ExciseTax, BaseDiscountTypeID, SecondaryPackTypeID, SecondaryQuantity, 
                            SecondaryPackID) Values ('{0}', {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, 
                            {18}, '{19}', '{20}', {21}, {22}, {23}, {24}, {25}, {26}, {27}, {28}, {29}, {30}, {31}, {32}, {33})",
                        orderModel.OrderId, // OrderId 0
                        pack.PackId, //PackId 1
                        pack.RequiredQty, //RequiredQty 2
                        pack.Price, //Price 3
                        pack.Tax, //Tax 4
                        pack.Discount, //Discount 5
                        orderModel.CustomerId, //CustomerID 6
                        orderModel.OutletId, //OutletID 7
                        (int)pack.SalesTransactionTypeId, //SalesTransactionTypeID 8
                        pack.Price, //BasePrice 9
                        -1, //DivisionId 10
                        0, //Foc 11
                        pack.DiscountTypeId, // DiscountTypeID 12
                        0, //ActualDeliveredQuantity 13
                        pack.PromotedDiscount, // PromotedDiscount 14
                        0, //FinalDiscountPercentage 15
                        0, //AdditionalDiscount 16
                        itemSequance, //itemSequance 17
                        "-1", //PackStatusID 18
                        "1990/01/01", //BatchNo 19
                        "01-01-1990", //DefaultExpiryDate 20
                        OrderTypes.Sales.GetHashCode(), //OrderTypes 21
                        0, //StockStatusID 22
                        pack.Discount, //BaseDiscount 23
                        0, //ItemPromotedDiscount 24
                        pack.AllItemDiscount, //AllItemDiscount 25
                        pack.Tax, //BaseTax 26
                        pack.UsedPriceListId, //UsedPriceListID 27
                        pack.RequestedQuantity, //RequestedQuantity 28
                        pack.CalculatedRetailTax, //ExciseValue 29
                        "Null", //BaseDiscountTypeID 30
                        "NULL", //SecondaryPackTypeID 31
                        "NULL", //SecondaryQuantity 32
                        "NULL"); //SecondaryPackID 33
                        result = dbHelper.ExecuteNonQuery(Query);
                        if (result != GlobalErrors.Success)
                            break;
                    }


                }
                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, DocumentTypes.Order, orderModel.OrderId,
                        long.Parse(orderModel.CreatedBy.ToString()), -1);
                }
                if (result == GlobalErrors.Success && orderModel.CustomerPromotions != null && orderModel.CustomerPromotions.Count > 0)
                {
                    result = _promotionManager.SavePromotionBenefitHistoryData(CoreDataBaseConstants.TableNames.PromotionBenefitHistory, orderModel.OrderId, orderModel.Outlet.CustomerId, orderModel.Outlet.OutletId, orderModel.DivisionId, orderModel.EmployeeId, orderModel.CustomerPromotions, PromotionBenefitTransactionTypes.SalesOrder, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                    afterSavingData.Message = "Order Placed Successfully ";
                    afterSavingData.Tax = orderModel.Tax;
                    afterSavingData.NetTotal = orderModel.NetTotal;
                    afterSavingData.ExciseTax = orderModel.CalculatedRetailTax;
                    afterSavingData.OrderID = orderModel.OrderId;
                    afterSavingData.Discount = orderModel.Discount;
                    afterSavingData.ExpectedDeliveryDate = desiredDeliveryDate.Date.ToString();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                    afterSavingData.Message = "Order Saving Failed, please try again";
                }
            }
            return result;
        }

        public GlobalErrors InsertCustomerIntoEmployeeRoutes(int customerId, int outletId, int routeId, int employeeId, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string routeFilter = string.Empty;
                if (routeId != -1)
                {
                    routeFilter = string.Format("and Route.RouteID={0}", routeId);
                }
                string query = string.Format(@"Insert into RouteCustomer (RouteID , CustomerID , OutletID)
                Select RouteID, {0} , {1}
                from Route
inner join EmployeeTerritory on EmployeeTerritory.TerritoryID=Route.TerritoryID and EmployeeTerritory.EmployeeID={3}
                where 1=1 {2} and Route.RouteID not in (Select RouteCustomer.RouteID From RouteCustomer inner join Route on Route.RouteID=RouteCustomer.RouteID
inner join EmployeeTerritory on EmployeeTerritory.TerritoryID=[route].TerritoryID and EmployeeTerritory.EmployeeID={3} where RouteCustomer.CustomerID = {0} AND RouteCustomer.OutletID = {1}  {2}  )
"
                , customerId
                , outletId
                , routeFilter
                , employeeId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertCustomerIntoEmployeeTerritory(int customerId, int outletId, int employeeId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO CustOutTerritory (CustomerID , OutletID , TerritoryID)
                Select  {0} ,  {1} , TerritoryID
                FROM EmployeeTerritory where EmployeeID = {2} AND TerritoryID not in (Select TerritoryID From CustOutTerritory where CustomerID = {0} AND OutletID = {1})"
                , customerId
                , outletId
                , employeeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                //if (result == GlobalErrors.SuccessWithZeroRowAffected)
                //{
                //    result = GlobalErrors.Success;
                //}
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        #endregion

        #region [ECHO]

        public GlobalErrors GetCustomerOrderHistoryForEcho(int pageNumber, int pageSize, bool descendingSort, ref List<EchoOrderModel> list)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                list = new List<EchoOrderModel>();
                DBHelper<EchoOrderModel> dbHelper = new DBHelper<EchoOrderModel>();
                string allowCancel = "0";
                if (_requestRepository.Configurations.CustomerAppCancellationPeriod > 0)
                {
                    allowCancel = string.Format("case when (OrderDate <= DATEADD(DAY, {0}, OrderDate) AND SalesOrder.OrderStatusID = {1}) then 1 else 0 end",
                    _requestRepository.Configurations.CustomerAppCancellationPeriod, OrderStatus.New.GetHashCode());
                }
                string query = string.Format(@"Select 
                SalesOrder.OrderID, convert(varchar, SalesOrder.DesiredDeliveryDate, 100) DesiredDeliveryDate, OrderStatusLanguage.Description Status ,CONVERT(varchar(10), OrderDate, 103) OrderDate, SalesOrder.NetTotal, SalesOrder.OrderStatusID StatusID
                , {4} AllowCancel, SalesOrder.Tax TaxTotal, SalesOrder.GrossTotal, SalesOrder.Discount DiscountTotal,
                case when SalesOrder.OrderStatusID in (3,4,5) and DA.Uploaded = 0 then 1 else 0 end as IsPreparing,
                case when SalesOrder.OrderStatusID in (3,5) and DA.Uploaded = 1 then 1 else 0 end as IsOnTheWay
                from SalesOrder
                inner join OrderStatusLanguage on OrderStatusLanguage.OrderStatusID = SalesOrder.OrderStatusID and OrderStatusLanguage.LanguageID = {1}
                left join DeliveryAssignment DA on DA.OrderId = SalesOrder.OrderId and DA.CustomerId = SalesOrder.CustomerId and DA.OutletId = SalesOrder.OutletId and DA.DivisionId = SalesOrder.DivisionId
                where concat(SalesOrder.CustomerID, '-', SalesOrder.OutletID) in ({0})  AND SalesOrder.OrderStatusID NOT IN ({6}) AND SalesOrder.OrganizationID in ({7})  order by SalesOrder.OrderDate {5}
                OFFSET     {2} ROWS
                FETCH NEXT {3} ROWS ONLY ", _requestRepository.CurrentEchoOperator.CustomerOutletIds,
                _requestRepository.LanguageId, pageNumber * pageSize, pageSize, allowCancel, descendingSort ? "DESC" : "ASC", OrderStatus.Splitted.GetHashCode(), _requestRepository.CurrentOperator.OrganizationId);
                result = dbHelper.GetQueryList(query, ref list);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CancelOrderForEcho(EchoOrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"UPDATE SalesOrder Set OrderStatusID = {0}, UpdatedBy = {1}, UpdatedDate = {2}, 
                        Description = 'Cancelled By the Customer From Customer Ordering App'
                        WHERE OrderID = '{3}'",
                        OrderStatus.Canceled.GetHashCode(), _requestRepository.CurrentEchoOperator.RouteEmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                        order.OrderId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    result = DeleteEchoFirstOrderCustomerOutlet(order.OrderId, dbHelper);
                }
                if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableCustomerAppPoints && _requestRepository.Configurations.PointsWeight > 0)
                {
                    //Save Customer Points
                    decimal val = order.NetTotal * _requestRepository.Configurations.PointsWeight;
                    result = UpdateCustomersPoints(order.OrderId, CustomerPointsAction.CancelOrder, val, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public GlobalErrors DeleteEchoFirstOrderCustomerOutlet(string OrderId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                query = string.Format(@"delete from EchoFirstOrderCustomerOutlet where OrderID = '{0}'", OrderId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors ApproveOrderForEcho(EchoOrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"UPDATE SalesOrder Set OrderStatusID = {0}, UpdatedBy = {1}, UpdatedDate = {2}, 
                        Description = 'Approved By the Customer From Customer Ordering App'
                        WHERE OrderID = '{3}'",
                        OrderStatus.New.GetHashCode(), _requestRepository.CurrentEchoOperator.RouteEmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                        order.OrderId);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors UpdateCustomersPoints(string orderId, CustomerPointsAction action, decimal value, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (action == CustomerPointsAction.CancelOrder)
                {
                    value = value * -1;
                }
                string sqlQuery = string.Format(@"
                            DECLARE @Balance as Decimal(19,9) = 0;
                            SELECT @Balance = ISNULL(PointsBalance, 0) FROM CustomerAppPoints WHERE CustomerID = {0} and OutletID = {1};
                            Insert Into CustomerAppPointsHistory (CustomerID,OutletID,TransactionID,ActionID,OldPointsBalance,NewPointsBalance,
                            UpdatedDate,Updatedby,Note) Values ({0},{1},'{5}',{6},@Balance,@Balance + {2},{3},{4},'{7}')
                            IF not EXISTS 
                            (SELECT * FROM CustomerAppPoints WHERE CustomerID = {0} and OutletID = {1})
                            Insert Into CustomerAppPoints (CustomerID,OutletID,PointsBalance,CreatedDate,CreatedBy,UpdatedDate,Updatedby) Values ({0},{1},{2},{3},{4},
                            {3},{4})
                            else Update CustomerAppPoints set PointsBalance = PointsBalance + {2}, UpdatedDate ={3}, Updatedby = {4} WHERE CustomerID ={0} and OutletID = {1}",
                            _requestRepository.CurrentEchoOperator.CustomerId, // 0
                            _requestRepository.CurrentEchoOperator.OutletId, // 1
                            LocalUtilities.GetRoundedDecimal(value, _requestRepository.Configurations.NumberOfDigits),  //2
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //3
                            _requestRepository.CurrentEchoOperator.RouteEmployeeId, //4
                            orderId, //5
                            action.GetHashCode(), //6
                            action.ToString() //7
                            );
                result = dbHelper.ExecuteNonQuery(sqlQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public int GetEmployeeUnderCustTerritory(ref int employeeId ,ref int uploaded , int customerId , int outletId , string DivisionAccess , ref string employeeCodeName , DBHelper<int> dbHelper)
        {
            try
            {
                string query = string.Empty;
                DataTable dt = new DataTable();
                query = string.Format(@" SELECT TOP(1) EmployeeTerritory.EmployeeID , tt.Uploaded , EmployeeLanguage.Description EmployeeCodeName FROM EmployeeTerritory
					INNER JOIN Employee ON Employee.EmployeeID = EmployeeTerritory.EmployeeID 
                    LEFT JOIN EmployeeLanguage ON Employee.EmployeeID = EmployeeLanguage.EmployeeID AND LanguageID = {3}
					INNER JOIN CustOutTerritory ON CustOutTerritory.TerritoryID = EmployeeTerritory.TerritoryID 
					OUTER APPLY (SELECT TOP(1) uploaded from RouteHistory WHere RouteHistory.EmployeeID = EmployeeTerritory.EmployeeID
				    Order by RouteHistory.ActualStart DESC) tt
					INNER JOIN (SELECT DISTINCT EmployeeDivision.EmployeeID FROM EmployeeDivision					
					Where EmployeeDivision.DivisionID IN ({2})
					) AS ED ON ED.EmployeeID = EmployeeTerritory.EmployeeID
					WHERE CustOutTerritory.CustomerID = {0} AND CustOutTerritory.OutletID = {1}
					ORDER BY CASE 
					WHEN Employee.EmployeeTypeID = 10 THEN 1
					WHEN Employee.EmployeeTypeID = 2 THEN 2
					ELSE 3
					END,
				    tt.Uploaded DESC;", customerId, outletId, DivisionAccess , _requestRepository.LanguageId);

                GlobalErrors result = dbHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success)
                {
                    if (dt.Rows.Count > 0)
                    {
                        if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeID] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString()))
                        {
                            employeeId = Int32.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString());
                        }
                        if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.Uploaded] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.Uploaded].ToString()))
                        {
                            uploaded = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.Uploaded].ToString().ToLower() == "true" ? 1 : 0;
                        }
                        if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeCodeName] != DBNull.Value && !string.IsNullOrEmpty(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeCodeName].ToString()))
                        {
                            employeeCodeName = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.EmployeeCodeName].ToString();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return employeeId;
        }
        public GlobalErrors GetCustomerCodeName(ref OrderModel order , int customerId)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            DBHelper<OrderModel> dbHelper = null;
            OrderModel orderModel = new OrderModel();
            try
            {
                dbHelper = new DBHelper<OrderModel>();
                query = string.Format(@"
                  SELECT CustomerLanguage.Description CustomerName , customer.CustomerCode from customer 
			      LEFT OUTER JOIN CustomerLanguage ON Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
			      WHERE customer.CustomerID = {1}", _requestRepository.LanguageId, customerId);

                result = dbHelper.GetQuerySingle(query, ref orderModel);
                order.CustomerName = orderModel.CustomerName;
                order.CustomerCode = orderModel.CustomerCode;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromReturnInvoicesHistory(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                query = $@" Delete from ReturnInvoicesHistory
                where ReturnTransactionID = '{transaction.TransactionId}' 
                and CustomerID = {transaction.CustomerId} and OutletID = {transaction.OutletId} ";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromReturnInvoicesPacksHistory(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                query = $@" Delete from ReturnInvoicesPacksHistory
                where ReturnTransactionID = '{transaction.TransactionId}' 
                and CustomerID = {transaction.CustomerId} and OutletID = {transaction.OutletId} ";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromAccumulativePromotionsHistory(string transactionId,int customerId,int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" Delete from AccumulativePromotionsHistory
                where TransactionID = '{transactionId}' 
                and CustomerID = {customerId} and OutletID = {outletId} ";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if(result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromReturnPromBenefitHistory(string transactionId, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" Delete from ReturnPromBenefitHistory
                where TransactionID = '{transactionId}' 
                and CustomerID = {customerId} and OutletID = {outletId} ";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromForcedReturnInvoicesPacks(string returnTransactionId, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"DELETE FROM ForcedReturnInvoicesPacks WHERE ReturnTransactionID = '{returnTransactionId}' AND CustomerID = {customerId} AND OutletID = {outletId}";
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }



        public GlobalErrors GetOrderDataForEcho(string orderId, ref List<ItemPackModel> itemList, ref string notes)
        {
            itemList = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                notes = string.Empty;
                dbHelper = new DBHelper<ItemPackModel>();
                string query = string.Format(@"
                    SELECT Distinct Item.ItemID ItemId, Item.ItemCategoryID ItemCategoryId, Pack.PackTypeID PackTypeId, Pack.PackID PackId, sod.Price, sod.Tax, ISNULL(sod.Discount, 0) Discount, ISNULL(sod.PromotedDiscount, 0) PromotedDiscount,
                    PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, Pack.Quantity as PiecesInPack
                    , CASE WHEN t.TransactionID is not NULL then ISNULL(td.Quantity,0) else 0 END RequiredQty
                    , CASE WHEN sod.RequestedQuantity IS NULL OR sod.RequestedQuantity <= 0 THEN sod.Quantity ELSE sod.RequestedQuantity END RequestedQuantity
                    , sod.SalesTransactionTypeID
                    FROM Item
                    LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {0}
                    INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                    INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID
                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                    INNER JOIN SalesOrderDetail sod ON sod.OrderID = '{1}' AND sod.PackID = Pack.PackID                    
                    LEFT JOIN [Transaction] t on t.SourceTransactionID = sod.orderID and t.CustomerID = sod.CustomerID and t.OutletID = sod.OutletID and (t.voided is null or t.Voided = 0) and t.CreationReason <> 6
                    LEFT JOIN TransactionDetail td on td.TransactionID = t.TransactionID and t.CustomerID = td.CustomerID and t.OutletID = td.OutletID and td.PackID = sod.PackID
                    WHERE (Item.Inactive = 0 OR Item.Inactive IS NULL) AND (Item.ItemType NOT IN (7,9)) 
                    ORDER BY Item.ItemCode, ItemLanguage.Description, PackTypeLanguage.Description",
                    _requestRepository.LanguageId, //0
                    orderId);//1
                result = dbHelper.GetQueryList(query, ref itemList);

                if (result == GlobalErrors.Success)
                {
                    object remarks = null;
                    query = string.Format("select top(1) note from SalesOrderNote where OrderID = '{0}' order by NoteDate desc", orderId);
                    result = dbHelper.ExecuteScalar(query, ref remarks);
                    if (remarks != null && !string.IsNullOrEmpty(remarks.ToString())) notes = remarks.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetOrderDataAchivemantsForEcho(string orderId, ref List<Promotion> achivements)
        {
            achivements = new List<Promotion>();
            DBHelper<Promotion> dbHelper = null;
            DBHelper<PromotionOption> dbHelper2 = null;
            DBHelper<PromotionOptionDetail> dbHelper3 = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<Promotion>();
                dbHelper2 = new DBHelper<PromotionOption>();
                dbHelper3 = new DBHelper<PromotionOptionDetail>();
                string query = string.Format(@"SELECT DISTINCT CAOA.PromotionID, PromotionLanguage.Description AS PromotionName
                    FROM CustomerAppOrderAchivment AS CAOA INNER JOIN  PromotionLanguage ON PromotionLanguage.PromotionID = CAOA.PromotionID AND PromotionLanguage.LanguageID = {1}
                    WHERE (CAOA.OrderID = '{0}')", orderId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref achivements);
                if (result == GlobalErrors.Success)
                {
                    achivements.ForEach(achive =>
                    {
                        List<PromotionOption> promotionOptions = new List<PromotionOption>();
                        string query = string.Format(@"SELECT CAOA.PromotionOptionID, CAOA.PromotionID
                            FROM PromotionOptionDetail INNER JOIN
	                             CustomerAppOrderAchivment AS CAOA ON PromotionOptionDetail.PromotionOptionID = CAOA.PromotionOptionID AND 
	                             PromotionOptionDetail.PromotionID = CAOA.PromotionID
                            WHERE (PromotionOptionDetail.PromotionID = {0}) AND (CAOA.OrderID = '{1}')", achive.PromotionId, orderId);
                        result = dbHelper2.GetQueryList(query, ref promotionOptions);
                        if(result == GlobalErrors.Success)
                        {
                            if(promotionOptions.Count > 0)
                            {
                                achive.PromotionOutputs = promotionOptions;
                                achive.PromotionOutputs.ForEach(output =>
                                {
                                    List<PromotionOptionDetail> promotionOptionDetails = new List<PromotionOptionDetail>();
                                    string query = string.Format(@"SELECT PromotionID, PromotionOptionID, PromotionOptionDetailID, Description Description
                                        FROM PromOptionDetailLanguage
                                        WHERE (PromotionOptionID = {0}) AND (PromotionID = {1}) AND (LanguageID = {2})", output.PromotionOptionId ,output.PromotionId,_requestRepository.LanguageId);
                                    result = dbHelper3.GetQueryList(query, ref promotionOptionDetails);
                                    if(result == GlobalErrors.Success)
                                    {
                                        output.PromotionOptionDetails = promotionOptionDetails;
                                    }
                                });
                            }
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                achivements = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrderDataAppliedOffersForEcho(string orderId, ref List<Promotion> applied)
        {
            applied = new List<Promotion>();
            DBHelper<Promotion> dbHelper = null;
            DBHelper<PromotionOption> dbHelper2 = null;
            DBHelper<PromotionOptionDetail> dbHelper3 = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<Promotion>();
                dbHelper2 = new DBHelper<PromotionOption>();
                dbHelper3 = new DBHelper<PromotionOptionDetail>();
                string query = string.Format(@"SELECT DISTINCT Promotion.PromotionID, PromotionLanguage.Description AS PromotionName
                FROM Promotion INNER JOIN PromotionLanguage ON PromotionLanguage.PromotionID = Promotion.PromotionID AND PromotionLanguage.LanguageID = {1} INNER JOIN 
                PromotionBenefitHistory AS PBH ON Promotion.PromotionID = PBH.PromotionID where PBH.TransactionID = '{0}'", orderId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref applied);
                if (result == GlobalErrors.Success)
                {
                    applied.ForEach(achive =>
                    {
                        List<PromotionOption> promotionOptions = new List<PromotionOption>();
                        string query = string.Format(@"
                            SELECT PBH.PromotionOptionID, PBH.PromotionID
                            FROM  PromotionBenefitHistory PBH
                            WHERE (PBH.PromotionID = {0}) AND (PBH.TransactionID = '{1}')", achive.PromotionId, orderId);
                        result = dbHelper2.GetQueryList(query, ref promotionOptions);
                        if (result == GlobalErrors.Success)
                        {
                            if (promotionOptions.Count > 0)
                            {
                                achive.PromotionOutputs = promotionOptions;
                                achive.PromotionOutputs.ForEach(output =>
                                {
                                    List<PromotionOptionDetail> promotionOptionDetails = new List<PromotionOptionDetail>();
                                    string query = string.Format(@"SELECT PromotionID, PromotionOptionID, PromotionOptionDetailID, Description Description
                                        FROM PromOptionDetailLanguage
                                        WHERE (PromotionOptionID = {0}) AND (PromotionID = {1}) AND (LanguageID = {2})", output.PromotionOptionId, output.PromotionId, _requestRepository.LanguageId);
                                    result = dbHelper3.GetQueryList(query, ref promotionOptionDetails);
                                    if (result == GlobalErrors.Success)
                                    {
                                        output.PromotionOptionDetails = promotionOptionDetails;
                                    }
                                });
                            }
                        }
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                applied = null;
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetOrderStatusForEcho(string orderId, ref int statusId)
        {
            DBHelper<int> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<int>();
                string itemQuery = string.Format(@"Select OrderStatusID from SalesOrder WHERE OrderID = '{0}'", orderId);//1
                object obj = new object();
                result = dbHelper.ExecuteScalar(itemQuery, ref obj);
                if (result == GlobalErrors.Success && obj != null)
                {
                    statusId = int.Parse(obj.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                statusId = -1;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrderHeader(string orderId, ref OrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<OrderModel>();
                order = new OrderModel();
                var query = string.Format(@"Select SalesOrder.*
                                            FROM  SalesOrder
                                            where SalesOrder.OrderID ='{0}' ", orderId);

                result = dbHelper.GetQuerySingle(query, ref order);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveOrderAchivementForEcho(string OrderId, int PromotionId, int PromotionOptionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            if (dbHelper == null)
            {
                dbHelper = new DBHelper<int>();
            }
            try
            {
                query = string.Format(@"INSERT INTO CustomerAppOrderAchivment VALUES('{0}', {1}, {2})", OrderId, PromotionId, PromotionOptionId);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors CallProcedureSplitOrder(int customerId, int outletId, int divisionId, string orderId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<string> dBHelper = new DBHelper<string>();
                string procedureName = "SP_SplitOrder";
                Dictionary<string, object> inputParamters = new Dictionary<string, object>();
                inputParamters.Add("@CustomerID", customerId);
                inputParamters.Add("@OutletID", outletId);
                inputParamters.Add("@OrderID", orderId);
                inputParamters.Add("@DivisionID", divisionId);

                Dictionary<string, object> outputParamters = new Dictionary<string, object>();
                outputParamters.Add("@Result", 0);
                outputParamters.Add("@Msg", string.Empty);
                Dictionary<string, object> resultParameters = null;
                object field = null;
                string query = string.Format(@"if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].{0}') 
                        and OBJECTPROPERTY(id, N'IsProcedure') = 1) select x='1'", procedureName);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString()) && (field.ToString() == "1"))
                {
                    result = dBHelper.ExecuteProcedureWithParameters(procedureName, inputParamters, outputParamters, ref resultParameters, 0);
                    // 1 : Success else failed
                    //if (resultParameters != null && resultParameters.ContainsKey("@Result") && int.Parse(resultParameters["@Result"].ToString()) == 1)
                    //    result = GlobalErrors.Success;
                    //else
                    //{
                    //    result = GlobalErrors.Error;
                    //    if (resultParameters != null && resultParameters.ContainsKey("@Msg"))
                    //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Order was not splitted, the error is: " + resultParameters["@Msg"], null, "", 0);
                    //}
                }
                else return GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }



        public GlobalErrors GetExchangeReturnOrder(OrderModel order, DBHelper<int> dbHelper, ref string source)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object obj = new object();
                string query = string.Format(@"select SourceOrderID from SalesOrder Where OrderID='{0}' and CustomerID ={1} 
                    AND OutletID ={2} AND DivisionID = {3}", order.OrderId, order.CustomerId, order.OutletId, order.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref obj);
                if (result == GlobalErrors.Success && obj != null)
                {
                    source = obj.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        //public  GlobalErrors UpdateOrderDeliveryStatus(OrderModel orderDelivery, DeliveryStatus newStatus, DBHelper<int> dbHelper)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;

        //    try
        //    {
        //        string query = string.Format("update DeliveryAssignment set DeliveryStatusID = {0} where OrderID='{1}' and customerid = {2} and outletid = {3}", 
        //            ((int)newStatus).ToString(), 
        //            orderDelivery.OrderId, 
        //            orderDelivery.CustomerId, 
        //            orderDelivery.OutletId);
        //        result = dbHelper.ExecuteNonQuery(query);
        //        return result;
        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        result = GlobalErrors.Error;
        //    }
        //    return result;

        //} 

        public GlobalErrors IsEchoFirstOrderCustomerOutlet(ref bool isFirstOrderCustomerOutlet)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                object obj = new object();
                string query = string.Format(@"SELECT COUNT(*) FROM EchoFirstOrderCustomerOutlet where CustomerID = {0} and OutletID = {1} ", _requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId);
                result = dbHelper.ExecuteScalar(query, ref obj);
                if (result == GlobalErrors.Success && obj != null && !string.IsNullOrEmpty(obj.ToString()))
                {
                    if ((int)obj == 0 && _requestRepository.Configurations.EchoFirstDiscountCustomerOutlet != 0)
                        isFirstOrderCustomerOutlet = true;
                    else
                        isFirstOrderCustomerOutlet = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors IsEchoFirstOrderHaveFreeItems(ref bool isEchoFirstOrderHaveFreeItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = new DBHelper<int>();
            try
            {
                object obj = new object();
                string query = string.Format(@"SELECT COUNT(*) FROM EchoFirstOrderFreeItems
                    WHERE (EchoFirstOrderFreeItems.OrganizationID IN ({1}))", _requestRepository.LanguageId, _requestRepository.CurrentEchoOperator.RouteOrganizationIds);
                result = dbHelper.ExecuteScalar(query, ref obj);
                if (result == GlobalErrors.Success && obj != null && !string.IsNullOrEmpty(obj.ToString()))
                {
                    if ((int)obj > 0)
                        isEchoFirstOrderHaveFreeItems = true;
                    else
                        isEchoFirstOrderHaveFreeItems = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertEchoFirstOrderCustomerOutlet(string OrderId, DBHelper<int> dBHelper)
        {
            if (dBHelper == null)
            {
                dBHelper = new DBHelper<int>();
            }
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO EchoFirstOrderCustomerOutlet (CustomerID, OutletID, OrderID) VALUES ({0}, {1}, '{2}')", _requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId, OrderId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        public static GlobalErrors GetOrderHeaderStatic(string orderId, ref OrderModel order)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dbHelper = null;
            try
            {
                string deliveryAssignment = string.Empty;
                string tableToGetEmployeeFrom = "SalesOrder";
                string orderFilter = string.Empty;
                string deliveryAssignmentItems = string.Empty;
                {
                    dbHelper = new DBHelper<OrderModel>();
                }
                var query = string.Format(@"Select
                                            SalesOrder.OrderID,
                                            SalesOrder.OrderDate OrderDate ,
                                            SalesOrder.OrderStatusId,
                                            SalesOrder.DesiredDeliveryDate DesiredDeliveryDate,
                                            CustomerLanguage.Description CustomerName,
                                            CustomerOutletLanguage.Description CustomerOutletName,
                                            ISNULL (EmployeeLanguage.Description,'') EmployeeName,
                                            ISNULL (DivisionLanguage.Description,'') Division,
                                            salesOrder.OrderTypeID ,
                                            SalesOrder.CustomerID ,
                                            SalesOrder.OutletID,
                                            {4}.EmployeeID,
                                            SalesOrder.DivisionID,
											SalesOrder.NetTotal,
											SalesOrder.Discount,
											SalesOrder.GrossTotal,
											SalesOrder.Tax,
											SalesOrder.HeaderDiscount,
											 SalesOrder.ExciseTax as CalculatedRetailTax,
											SalesOrder.ExchangeRate,
                                            SalesOrder.OrganizationID,
                                            SalesOrder.SalesMode,
                                            SalesOrder.LPO,
                                            CustomerOutlet.Taxeable IsTaxeableOutlet,
											IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
											IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
											IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName ,
											IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
	                                       -- ,IsNull(OptionType, -1) RecurringTypeId,
											--OptionData RecurringValue,
											--IsActive isRecurringActive
                                           ,IsNull(OptionType, -1) RecurringTypeId,
                                           IsNull(RecurringOrder.OptionType, -1) RecurringTypeId, OptionData RecurringValue, IsNull(RecurringOrder.RecurringStatusID, -1) RecurringStatusId,
                                           Comment RecurringComment, IsNull(RecurringOrder.ChangedReasonID, -1) RecurringChangedReasonId, RecurringOrder.ResumeDate,
                                            [Transaction].TransactionId,[Transaction].WarehouseId,[Transaction].CreationReason
	                                       {5}
                                            FROM  SalesOrder
                                            INNER JOIN  Customer ON Customer.CustomerID=SalesOrder.CustomerID
                                            inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                            INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = SalesOrder.CustomerID and CustomerOutlet.OutletID = SalesOrder.OutletID
                                            LEFT OUTER JOIN CustomerLanguage ON SalesOrder.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {2}
                                            LEFT OUTER JOIN CustomerOutletLanguage ON SalesOrder.CustomerID = CustomerOutletLanguage.CustomerID AND  SalesOrder.OutletID = CustomerOutletLanguage.OutletID  AND CustomerOutletLanguage.LanguageID = {2}
{3}
 LEFT OUTER JOIN employee on employee.employeeid ={4}.EmployeeID                                            
LEFT OUTER JOIN EmployeeLanguage ON employee.EmployeeID = EmployeeLanguage.EmployeeID  AND EmployeeLanguage.LanguageID = {2}
                                           
                                            Left OUTER  JOIN Division on Division.DivisionID = SalesOrder.DivisionID
                                            LEFT OUTER JOIN DivisionLanguage ON DivisionLanguage.DivisionID = SalesOrder.DivisionID AND DivisionLanguage.LanguageID = {2}
                                            LEFT OUTER JOIN OrderTypeLanguage ON OrderTypeLanguage.OrderTypeID=SalesOrder.OrderTypeID AND OrderTypeLanguage.LanguageID={2}
                                            LEFT OUTER JOIN RecurringOrder ON RecurringOrder.OrderID = SalesOrder.OrderID AND RecurringOrder.CustomerID = SalesOrder.CustomerID AND RecurringOrder.OutletID = SalesOrder.OutletID AND RecurringOrder.DivisionID = SalesOrder.DivisionID
                                            Left outer join [Transaction] on [Transaction].SourceTransactionId = SalesOrder.OrderID and( [Transaction].Voided=null or [Transaction].Voided=0)  
where SalesOrder.OrderID in ('{0}') {1}"
, orderId, orderFilter, 1, deliveryAssignment, tableToGetEmployeeFrom, deliveryAssignmentItems);
                result = dbHelper.GetQuerySingle(query, ref order);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }

        public GlobalErrors GetEchoFirstOrderFreeItems(ref List<ItemPackModel> itemPacks)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
            try
            {
                string query = string.Format(@"
                    SELECT Item.ItemID, EchoFirstOrderFreeItems.PackID, EchoFirstOrderFreeItems.Quantity AS RequiredQty, ItemLanguage.Description AS ItemName, PackTypeLanguage.Description UOM, CASE WHEN ItemImage.ItemID IS NULL THEN 0 ELSE 1 END HasImage, 2 SalesTransactionTypeId
                    FROM EchoFirstOrderFreeItems INNER JOIN
                        Pack ON EchoFirstOrderFreeItems.PackID = Pack.PackID INNER JOIN
                        Item ON Item.ItemID = Pack.ItemID INNER JOIN
                        PackTypeLanguage on Pack.PackTypeID =  PackTypeLanguage.PackTypeID and PackTypeLanguage.LanguageID={0} inner join 
                        ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND ItemLanguage.LanguageID = {0}  left join 
	                    ItemImage on ItemImage.ItemID = Item.ItemID 
					
                    WHERE (EchoFirstOrderFreeItems.OrganizationID IN ({1}))
                    ", _requestRepository.LanguageId, _requestRepository.CurrentEchoOperator.RouteOrganizationIds);
                result = dBHelper.GetQueryList(query, ref itemPacks);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOrderTypes(List<int> orderTypesFilter, ref List<OrderTypeModel> orderTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OrderTypeModel> dBHelper = null;
            string typeFilter = string.Empty;
            try
            {
                if(orderTypesFilter !=null && orderTypesFilter.Count > 0)
                {
                    typeFilter = string.Format(@" where  OrderType.OrderTypeID in ({0})", string.Join(',', orderTypesFilter));
                }
                dBHelper = new DBHelper<OrderTypeModel>();
                string query = string.Format(@"select OrderType.*, OrderTypeLanguage.Description as OrderTypeDescription from OrderType
									inner join OrderTypeLanguage on OrderTypeLanguage.OrderTypeID = OrderType.OrderTypeID and OrderTypeLanguage.LanguageID = {0} {1}"
                ,_requestRepository.LanguageId, typeFilter);
                result = dBHelper.GetQueryList(query,ref orderTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors CheckResellableItems(string packStatuses, ref bool isContainResellable)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object isContain = -1;
                string query = $@"select COUNT(*) isContain
                from PackStatus PS
                where PS.ReSellable = {PackStatus.ReSellable.GetHashCode()} and PS.StatusID in ({packStatuses})";
                result = dBHelper.ExecuteScalar(query, ref isContain);
                if (result == GlobalErrors.Success && isContain != null && int.Parse(isContain.ToString()) > 0)
                {
                    isContainResellable = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PreparedOrderGetBatchAndSerials(OrderModel order, ref TransactionModel transaction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                if (transaction.AllItems != null && transaction.AllItems.Count > 0)
                {
                    List<ItemPackModel> tempAllItems = new List<ItemPackModel>(transaction.AllItems);
                    transaction.AllItems = new List<ItemPackModel>();
                    ItemStockBatches tempBatch = new ItemStockBatches();
                    foreach (ItemPackModel item in tempAllItems)
                    {
                        tempBatch = new ItemStockBatches();
                        tempBatch.ItemId = item.ItemId;
                        tempBatch.PackId = item.PackId;
                        tempBatch.PiecesInPack = item.PiecesInPack;
                        tempBatch.Quantity = item.Quantity;
                        tempBatch.BatchNo = item.BatchNo;
                        tempBatch.ExpiryDate = item.ExpiryDate;
                        tempBatch.ExpiryDateModel = item.ExpiryDateModel;
                        tempBatch.RequiredQty = item.RequiredQty;
                        tempBatch.SalesTransactionTypeId = item.SalesTransactionTypeId.GetHashCode();
                        if (transaction.AllItems.FindIndex(i => i.ItemId == item.ItemId && i.PackId == item.PackId) == -1)
                        {
                            item.OrderDetailsBatches = new List<ItemStockBatches>();
                            item.OrderDetailsBatches.Add(tempBatch);
                            transaction.AllItems.Add(item);
                        }
                        else if (transaction.AllItems.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.FindIndex(b => b.BatchNo == item.BatchNo && b.ExpiryDate == item.ExpiryDate && b.SalesTransactionTypeId == item.SalesTransactionTypeId.GetHashCode()) == -1)
                        {
                            transaction.AllItems.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).Quantity += item.Quantity;
                            transaction.AllItems.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.Add(tempBatch);
                        }
                        else
                        {
                            transaction.AllItems.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).Quantity += item.Quantity;
                            transaction.AllItems.Find(i => i.ItemId == item.ItemId && i.PackId == item.PackId).OrderDetailsBatches.Find(b => b.BatchNo == item.BatchNo && b.ExpiryDate == item.ExpiryDate).RequiredQty += item.RequiredQty;
                        }

                    }


                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #region [Cancel Route]

        public GlobalErrors UpdateOrdersAndDeliveryTransactionsAfterCancelRoute(int routeHistoryID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                List<OrderModel> orderModel = new List<OrderModel>();
                List<TransactionModel> transaction = new List<TransactionModel>();
                string orderID = string.Empty;
                string transactionID = string.Empty;
                int customerID = -1;
                int outletID = -1;
                OrderStatus oldStatus = OrderStatus.None;
                // 1. Get Orders that Delivered in current route history
                result = GetOrdersDeliveredInCurrentRouteHistory(routeHistoryID, ref orderModel);

                if (result == GlobalErrors.Success && orderModel != null && orderModel.Count > 0)
                {
                    foreach (OrderModel order in orderModel)
                    {
                        orderID = order.OrderId;
                        customerID = order.CustomerId;
                        outletID = order.OutletId;
                        oldStatus = order.PreviousOrderStatus;
                        if (oldStatus == OrderStatus.Invoiced)
                        {
                            // Get All delivery transactions related to order
                            result = GetAllDeliveryTransactionsRelatedToOrder(orderID, ref transaction);
                            if (result == GlobalErrors.Success && transaction != null && transaction.Count > 0)
                            {
                                // Check for Partial Delivery
                                foreach(TransactionModel transaction1 in transaction)
                                {
                                    if(transaction1.CreationReason == TransactionCreationReason.OrderDeliveryBOInvoice)
                                    {
                                        transactionID = transaction1.TransactionId;
                                        result = _transactionManager.UpdateTransactionVoidedForOrderDeliveryBOInvoice(transactionID, dBHelper);
                                        if(result != GlobalErrors.Success)
                                        {
                                            result = GlobalErrors.Error;
                                        }
                                    }
                                }
                                
                            }
                        }
                        if (oldStatus == OrderStatus.Invoiced || oldStatus == OrderStatus.LoadRequestAccepted || oldStatus == OrderStatus.Assigned)
                        {
                            // Set All order delivery transactions to be voided
                            if (result == GlobalErrors.Success)
                            {
                                result = _transactionManager.UpdateDeliveryTransactionsVoided(orderID, transactionID, oldStatus, dBHelper);
                            }
                            // Update order current status to old status
                            order.OrderId = orderID;
                            order.CustomerId = customerID;
                            order.OutletId = outletID;
                            if (result == GlobalErrors.Success)
                            {
                                result = UpdateOrderStatusesWithActualQty(order, oldStatus, DeliveryStatus.Assigned,dBHelper);
                            }
                            // Update DeliveryAssignment Status to be = Assigned
                            if (result == GlobalErrors.Success)
                            {
                                result = UpdateDeliveryStatusForOrder(order,DeliveryStatus.Assigned, dBHelper);
                            }
                        }
                        if (result != GlobalErrors.Success) break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrdersDeliveredInCurrentRouteHistory(int routeHistoryID,ref List<OrderModel> order)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<OrderModel> dBHelper = new DBHelper<OrderModel>();
            try
            {
                string query = string.Format(@" Select distinct SalesOrder.OrderID, SalesOrder.PreviousOrderStatus, SalesOrder.CustomerID, SalesOrder.OutletID,SalesOrder.DivisionID
                From SalesOrder
                inner join DeliveryAssignment on DeliveryAssignment.OrderID = SalesOrder.OrderID  AND SalesOrder.CustomerID = DeliveryAssignment.CustomerID 
                AND SalesOrder.outletID = DeliveryAssignment.outletID and SalesOrder.DivisionID = DeliveryAssignment.DivisionID
                and DeliveryAssignment.DeliveryStatusID  = 1 and Uploaded = 1
                inner join RouteHistory on RouteHistory.EmployeeID = DeliveryAssignment.EmployeeID and RouteHistory.Uploaded = 1 and RouteHistory.RouteHistoryID = {0} 
                where SalesOrder.OrderStatusID = {1} ",routeHistoryID, OrderStatus.Delivered.GetHashCode());
                result = dBHelper.GetQueryList(query, ref order);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAllDeliveryTransactionsRelatedToOrder(string orderID, ref List<TransactionModel> transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TransactionModel> dBHelper = new DBHelper<TransactionModel>();
            try
            {
                string query = string.Format(@" Select [Transaction].Voided, [Transaction].CreationReason, [Transaction].TransactionID
                From SalesOrder
                INNER join [Transaction] on [Transaction].SourceTransactionID = SalesOrder.OrderID and [Transaction].CustomerID = SalesOrder.CustomerID and [Transaction].OutletID = SalesOrder.OutletID 
                AND [Transaction].DivisionID = SalesOrder.DivisionID
                Where SalesOrder.OrderID = '{0}'", orderID);
                result = dBHelper.GetQueryList(query, ref transaction);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        public GlobalErrors GetOrderSalesMode(string orderId, int customerId, int outletId, ref int salesMode)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                if(orderId == null || string.IsNullOrEmpty(orderId)) 
                {
                    return GlobalErrors.Error;
                }
                object field = null;
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = $@"select SalesMode from SalesOrder where orderid = '{orderId}' and CustomerID = {customerId} and OutletID = {outletId}";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    salesMode = int.Parse(field.ToString());
                }
                else 
                {
                    result = GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetOrderSDC(string orderId, int customerId, int outletId, ref int sdcId)
        {
            sdcId = -1;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = $@" SELECT ISNULL(SDCID,-1) SDCID FROM SalesOrder where OrderId = '{orderId}' AND CustomerId = {customerId} And OutletId = {outletId}";
                DBHelper<int> dBHelper = new DBHelper<int>();
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString())) 
                {
                    sdcId = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool AllowSalesModeSelectionForCustomerInOrder(int customerTypeId)
        {
            return _requestRepository.Configurations.AllowSalesModeSelectionInOrder && customerTypeId == CustomerTypes.CreditCustomer.GetHashCode();
        }


        #region[Contracted FOC]
        public GlobalErrors UpdateContractedFOCDetails(int customerId, int outletId, AppliedContractedFOCModel foc, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@" Update ContractedFOCDetail set  RemainingValue = RemainingValue - {foc.TakenValue} Where ContractID = {foc.ContractId}
                AND CustomerID = {customerId} AND OutletID = {outletId}";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveFOCImages(OrderModel order, string transactionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int sequenceId = 1; // Initialize the sequence number to 1
                foreach (var foc in order.ContractedFOCs)
                {
                    foreach (var seq in foc.FOCimagesSequence)
                    {
                        string query = $@"Insert into ContractedFOCImage (TransactionID, CustomerID, OutletID, ShelfIncentiveImage,SequenceID,ContractID) VALUES
                                ('{transactionId}',{order.CustomerId},{order.OutletId},'',{sequenceId},{foc.ContractId})";

                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }

                        sequenceId++;
                    }
                }         
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertIntoContractedFOCHistory(int customerId, int outletId, string transactionId, DateTime transactionDate, AppliedContractedFOCModel foc, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"Insert into ContractedFOCHistory (CustomerID, OutletID, ContractID, TransactionID, Date,PackID, Quantity, Value, RouteHistoryID, Posted) VALUES
                                ({customerId},{outletId},{foc.ContractId},'{transactionId}',{LocalUtilities.ParseDateAndTimeToSQL(transactionDate)}, -1,0, {foc.TakenValue}, -1 , 1)";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        public GlobalErrors CheckTerritorySDCWithOrderSDC(int employeeId, int sdcId, ref bool isOrderSDCWithinTerritorySDCs,DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            isOrderSDCWithinTerritorySDCs = false;
            try
            {
                string query = $@"select count(*) c from SDCTerritory
                            inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = SDCTerritory.TerritoryID 
                            where EmployeeTerritory.EmployeeID = {employeeId} and SDCTerritory.SDCID = {sdcId}";
                object field = null;
                result = dbHelper.ExecuteScalar(query,ref field);
                if (result == GlobalErrors.Success) 
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) &&  int.Parse(field.ToString()) > 0 ) 
                    {
                        // territory sdcs include order sdc.
                        isOrderSDCWithinTerritorySDCs = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors UpdateOrderApprovalStatus(OrderModel order, int newStatus, DBHelper<int> dbHelper) 
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = $@"UPDATE SalesOrder Set ApprovalStatus = {newStatus} WHERE OrderId = '{order.OrderId}' AND CustomerID = {order.CustomerId} AND OutletID = {order.OutletId} AND DivisionID = {order.DivisionId}";
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrderPromotionBenefitHistory(TransactionCommonData order, ref List<Promotion> promotionBenefitList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                DBHelper<Promotion> dBHelper = new DBHelper<Promotion>();
                query = string.Format(@" SELECT distinct PromotionOptionDetail.PromotionOptionDetailTypeID,isnull(BundleUsedQuantity.Quantity,0)UsedQuantity  ,PromotionLanguage.PromotionID,PromotionLanguage.Description PromotionName,Promotion.PromotionCode ,isnull(Promotion.BundleLimit,0) BundleLimit,isnull(PromotionBenefitHistory.RepeatCount,0) OriginalRepeatCount
                FROM Promotion
                LEFT OUTER JOIN PromotionLanguage ON PromotionLanguage.PromotionID = Promotion.PromotionID AND PromotionLanguage.LanguageID = {3}
                left JOIN BundleUsedQuantity ON BundleUsedQuantity.PromotionID = Promotion.PromotionID
                inner join PromotionBenefitHistory on PromotionBenefitHistory.PromotionID = Promotion.PromotionID 
                inner join PromotionOptionDetail on PromotionOptionDetail.PromotionID = promotion.PromotionID and PromotionOptionDetail.PromotionOptionID = {4}
                where PromotionBenefitHistory.TransactionID = '{0}'  and CustomerID = {1} AND OutletID = {2} and PromotionBenefitHistory.DivisionID = {5}
                AND   (Promotion.IsBundle = 1)", order.OrderId, order.CustomerId, order.OutletId, _requestRepository.LanguageId, PromotionOptionTypes.Output.GetHashCode(),order.DivisionId);
                result = dBHelper.GetQueryList(query, ref promotionBenefitList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerBundles(TransactionCommonData order, int promotionDetailTypeId, ref List<Promotion> orderBundles)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            string PromoBenefitFilter = string.Empty;
            try
            {
                if(promotionDetailTypeId != -1)
                {
                    PromoBenefitFilter = string.Format(@" and  PromotionOptionDetail.PromotionOptionDetailTypeID = {0}", promotionDetailTypeId);
                }
                DBHelper<Promotion> dBHelper = new DBHelper<Promotion>();
                query = string.Format(@" SELECT distinct isnull(BundleUsedQuantity.Quantity,0)UsedQuantity ,PromotionLanguage.PromotionID,PromotionLanguage.Description PromotionName ,Promotion.PromotionCode ,isnull(Promotion.BundleLimit,0) BundleLimit, 0 OriginalRepeatCount
                FROM Promotion
                LEFT OUTER JOIN PromotionLanguage ON PromotionLanguage.PromotionID = Promotion.PromotionID AND PromotionLanguage.LanguageID = {3}
                INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID
                left JOIN BundleUsedQuantity ON BundleUsedQuantity.PromotionID = Promotion.PromotionID
                inner join PromotionOptionDetail on PromotionOptionDetail.PromotionID = promotion.PromotionID and PromotionOptionDetail.PromotionOptionID = {5} {4}
                left join PromotionBenefitHistory on PromotionBenefitHistory.PromotionID = Promotion.PromotionID  and PromotionBenefitHistory.TransactionID = '{6}'
                WHERE (Promotion.Inactive IS NULL OR  Promotion.Inactive = 0) AND Promotion.IsDeleted <> 1
                AND   (Promotion.IsBundle = 1)
                AND   (Promotion.StartDate <=  {2} )
                AND   (Promotion.EndDate   >=  {2} )
                AND   ((AllCustomers = 1) OR (CustomerPromotion.CustomerID = {0} AND CustomerPromotion.OutletID = {1}) OR (CustomerGroupID IN (select GroupID from CustomerOutletGroup where CustomerID = {0} and  OutletID = {1})) OR (CustomerPromotion.SubChannelID in (Select SubChannelID from CustomerGroup where CustomerGroup.GroupID IN  (select GroupID from CustomerOutletGroup where CustomerID = {0} and OutletID = {1} )))) and PromotionBenefitHistory.PromotionID is null
                AND  (Promotion.PromotionID not in (select PromotionID from CustomerPromotionExclusion where CustomerID = {0} and OutletID = {1}))",
                order.CustomerId,order.OutletId,LocalUtilities.ParseDateToSQLString(DateTime.Now), _requestRepository.LanguageId, PromoBenefitFilter, PromotionOptionTypes.Output.GetHashCode(),order.OrderId);
                result = dBHelper.GetQueryList(query, ref orderBundles);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrderBundlesDetails(string bundleIds, TransactionCommonData order, ref List<ItemPackModel> bundlesDetails)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = string.Empty;
            try
            {
                DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
                query = string.Format(@" select BenefitValues.PriceValue,BenefitValues.DiscountValue,BundleItems.PromotionID,Item.ForceDefaultPack ,Item.DefaultPackID,ItemCategory.divisionID,Pack.Quantity PackQuantity,Pack.ItemID,Item.ItemCode,BundleItems.PackID,PackTypeLanguage.Description UOM,
                ItemLanguage.Description ItemName,BundleItems.Quantity,Item.IsBatchPriced,DiscountDetails.PromotionOptionDetailTypeID,BenefitValues.DiscountValue Value
                ,DiscountDetails.PromotionOptionID,DiscountDetails.PromotionOptionDetailID,DiscountDetails.PromotionOptionTypeID,BundleItems.PackGroupID
                FROM PromotionOptionDetailGroup BundleItems
                INNER JOIN PromotionOptionDetail DiscountDetails ON BundleItems.PromotionID = DiscountDetails.PromotionID
                AND BundleItems.PackGroupID = DiscountDetails.PackGroupID
                AND DiscountDetails.PromotionOptionTypeID = {1}
                INNER JOIN PromotionBenefitDetailGroup BenefitValues ON BundleItems.PromotionID = BenefitValues.PromotionID AND
                BundleItems.PackGroupID = BenefitValues.PackGroupID AND
                BundleItems.PackID = BenefitValues.PackID
                left join(select distinct pbg.PromotionID from PromotionBenefitDetailGroup pbg
                inner join promotion on promotion.promotionid = pbg.promotionid
                left join pack on pack.PackID = pbg.PackID
                where Promotion.IsBundle =1 and pack.packid is null
                )t on t.PromotionID = BundleItems.PromotionID 
                INNER JOIN Pack ON BundleItems.PackID = Pack.PackID
                INNER JOIN Item ON Pack.ItemID = Item.ItemID
                INNER JOIN ItemCategory ON Item.ItemCategoryID = ItemCategory.ItemCategoryID
                LEFT OUTER JOIN PackTypeLanguage ON PACK.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                LEFT OUTER JOIN ItemLanguage ON ItemLanguage.ItemID = Pack.ItemID AND ItemLanguage.LanguageID = {0}
                WHERE BundleItems.PromotionID in ({2})  and t.PromotionID is null and (BundleItems.Quantity is not null and BundleItems.Quantity >0)", _requestRepository.LanguageId,PromotionOptionTypes.Output.GetHashCode(), bundleIds, order.CustomerId,order.OutletId);
                result = dBHelper.GetQueryList(query, ref bundlesDetails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExecuteCalculateUsedBundles_SP()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var procedureResult = new ProcedureResult();
            string query = string.Empty;
            DBHelper<ProcedureResult> dbHelperProcedure = null;
            try
            {

                query = string.Format(@"EXEC [{0}]
                                       @IncludePendingQuantityForBundle = {1},
                                       @IncludeApprovedQuantityForBundle = {2}",
                                       CoreDataBaseConstants.ProceduresConstants.CalculateUsedBundles,//0
                                       _requestRepository.Configurations.IncludePendingQuantityForBundle ? "1": "0", //1
                                       _requestRepository.Configurations.IncludeApprovedQuantityForBundle? "1": "0" //2
                                       );
                dbHelperProcedure = new DBHelper<ProcedureResult>();
                result = dbHelperProcedure.GetQuerySingle(query, ref procedureResult);
                if (result != GlobalErrors.Success)
                {
                    return GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateOrderAfterPreparation(OrderModel order,DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string approvalSelection = string.Empty;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();
               
                string query = string.Format(@"update SalesOrder Set OrderStatusID = {0},PreviousOrderStatus={7} , UpdatedBy = {1} , UpdatedDate = {2}, 
                 PreparedBy = {1}, PreparedDate = {2}  Where OrderID = '{3}' and DivisionID = {4} and CustomerID = {5} and OutletID = {6}"
                 , order.OrderStatus.GetHashCode() //0
                 , _requestRepository.CurrentOperator.EmployeeId //1
                 , LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //2
                 , order.OrderId //3
                 , order.DivisionId //4
                 , order.CustomerId //5
                 , order.OutletId //6
                 , order.PreviousOrderStatus.GetHashCode() //7
                 );

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCRMEmployeeOrdersHistory(CustomerFilter filter, ref string query)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                string customerTelerepCondition = string.Empty;
                string customerTelerepJoin = string.Empty;
                string searchFilter = string.Empty;
              
                if(!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    searchFilter = $" And CustomerOutlet.CustomerCode Like '%{filter.CustomListFilter.SearchFilter.Replace("'","''")}%' ";
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.TeleRep.GetHashCode())
                {
                    customerTelerepJoin += ($@"INNER JOIN TeleRepCustomers TRC on TRC.EmployeeId = {_requestRepository.CurrentOperator.EmployeeId} AND TRC.CustomerID = CustomerOutlet.CustomerID AND TRC.OutletID = CustomerOutlet.OutletID");
                    if (filter.ShowUnplannedCustomers)
                    {
                        customerTelerepJoin += ($@"      
                        LEFT JOIN CallPlan_{_requestRepository.CurrentOperator.EmployeeId} CP ON CP.Date = {(LocalUtilities.ParseDateToSQLString(DateTime.Now))}              
                        LEFT JOIN CallPlanDetail_{_requestRepository.CurrentOperator.EmployeeId} CPD on CPD.CallPlanID = CP.CallPlanID AND CPD.CustomerID = CustomerOutlet.CustomerID AND CPD.OutletID = CustomerOutlet.OutletID");

                        customerTelerepCondition += (" AND CPD.CallPlanID IS NULL ");
                    }
                    else
                    {
                        customerTelerepJoin += ($@" 
                        INNER JOIN CallPlan_{_requestRepository.CurrentOperator.EmployeeId} CP ON CP.Date = {(LocalUtilities.ParseDateToSQLString(DateTime.Now))}              
                        INNER JOIN CallPlanDetail_{_requestRepository.CurrentOperator.EmployeeId} CPD on CPD.CallPlanID = CP.CallPlanID AND CPD.CustomerID = CustomerOutlet.CustomerID AND CPD.OutletID = CustomerOutlet.OutletID");
                    }
                }
                string dateFilter = string.Empty;
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.Today)
                {
                    dateFilter = $" And Convert(date ,SO.OrderDate)  between Convert(date ,  {LocalUtilities.ParseDateToSQLString(DateTime.Now)} ) and Convert(date ,  {LocalUtilities.ParseEndDateToSQLString(DateTime.Now)}) ";
                }
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.CustomRange && filter.FromToDate != null && filter.FromToDate.Count == 2)
                {
                    dateFilter = $" And Convert(date ,SO.OrderDate)  between Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date)} ) and Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date)}) ";
                }

                
                query = $@" SELECT tt.OrderID 'Order ID', tt.OrderDate 'Order Date', tt.OrderStatus 'Order Status', tt.CustomerCode 'Outlet Code', tt.OutletName 'Outlet Name', tt.ItemCode 'Item Code', tt.ItemName 'Item Name', tt.Uom,
                tt.QTY, tt.Price, tt.Tax, 
                ((tt.GrossTotal - tt.NormalDiscountAmount - tt.PromotedDiscountAmount + tt.ExciseTax) * tt.Tax / 100) 
                +
                (tt.GrossTotal - tt.NormalDiscountAmount - tt.PromotedDiscountAmount + tt.ExciseTax)  As 'Item Net Total'
                From (
                SELECT Distinct SO.OrderID, SO.OrderDate, CustomerOutlet.CustomerCode, CustomerOutletLanguage.Description OutletName, Item.ItemCode ItemCode, ItemLanguage.Description ItemName, PackTypeLanguage.Description Uom,
                SOD.Quantity QTY, ISNULL(SOD.price, 0) Price, ISNULL(SOD.tax, 0) Tax, ISNULL(SOD.ExciseTax, 0) ExciseTax, SOD.Quantity * Price As GrossTotal,
				SOD.Quantity * Price*SOD.Discount / 100 As NormalDiscountAmount, (SOD.Quantity * Price - (SOD.Quantity*Price*SOD.Discount /100))*SOD.PromotedDiscount /100 As PromotedDiscountAmount,
                case when SO.Synchronized = 0 then  'Not sent to SAP yet' else OrderSubStatusLanguage.Description end as OrderStatus
                FROM Item
                INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                INNER JOIN SalesOrderDetail SOD on SOD.PackID = Pack.PackID
                INNER JOIN SalesOrder SO on SO.OrderID = SOD.OrderID and SO.DivisionID = SOD.DivisionID and SO.CustomerID = SOD.CustomerID and SO.OutletID = SOD.OutletID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = SO.CustomerID AND CustomerOutlet.OutletID = SO.OutletID
                Left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {_requestRepository.LanguageId} 
                {customerTelerepJoin}
                LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = {_requestRepository.LanguageId}
                LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                LEFT join OrderSubStatus on OrderSubStatus.OrderStatusID = SO.OrderStatusID and OrderSubStatus.OrderSubStatusID = IsNull(SO.OrderSubStatusID,1)
                LEFT join OrderSubStatusLanguage on OrderSubStatusLanguage.OrderStatusID = SO.OrderStatusID and OrderSubStatusLanguage.OrderSubStatusID = IsNull(SO.OrderSubStatusID,1)
                and OrderSubStatusLanguage.LanguageID = {_requestRepository.LanguageId}
                LEFT join OrderStatusColorLanguage on OrderStatusColorLanguage.OrderStatusColorID = OrderSubStatus.OrderStatusColorID and OrderStatusColorLanguage.LanguageID = 1
                LEFT join OrderMainStatusColor on OrderMainStatusColor.OrderStatusID = SO.OrderStatusID
                
                Where SO.CreatedBy = {_requestRepository.CurrentOperator.EmployeeId} And SO.OrganizationId in ({_requestRepository.CurrentOperator.OrganizationAccess}) 
                {customerTelerepCondition} {dateFilter} {searchFilter}
                )tt
                Order By tt.OrderDate Desc";
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                return GlobalErrors.Error;
            }
            return result;
        }

    }
}