﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class PaymentTermManager
    {
        public static PaymentTermModel GetPaymentTerm(int PaymentTermID)
        {
            return GetPaymentTerm(PaymentTermID,null);
        }
        public static PaymentTermModel GetPaymentTerm(int PaymentTermID,DBHelper<int> dBHelper)
        {
            PaymentTermModel paymentTerm = null;
            DBHelper<PaymentTermModel> dBHelper2 = null;
            try
            {
                paymentTerm = new PaymentTermModel();
                if (dBHelper != null)
                {
                    dBHelper2 = new DBHelper<PaymentTermModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper2 = new DBHelper<PaymentTermModel>();
                }
             

                string query = string.Format(@"Select PaymentTerm.*,PaymentTermLanguage.Description  As PaymentTermDescription 
                from PaymentTerm 
                LEFT JOIN PaymentTermLanguage ON PaymentTerm.PaymentTermID = PaymentTermLanguage.PaymentTermID AND PaymentTermLanguage.LanguageID ={0} 
                Where PaymentTerm.PaymentTermID = {1}" , 1 , PaymentTermID);

                var result = dBHelper2.GetQuerySingle(query, ref paymentTerm);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                paymentTerm = null;
            }
            return paymentTerm;

        }

        public static Dictionary<int , PaymentTermModel> ReadDivisionsPaymentTerms(int customerId , int outletId,DBHelper<int> dbHelper)
        {
            Dictionary<int, PaymentTermModel> _divisionsPaymentTerm = new Dictionary<int, PaymentTermModel>();

            //DBHelper<int> dbHelper = null;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                
                DataTable dt = new DataTable();

                string query = string.Format(@"SELECT Division.DivisionID,Division.PaymentTermID DivisionPaymenTermID,CustOutDivPaymentTerm.PaymentTermID OutletPaymenTermID 
                FROM Division LEFT OUTER JOIN CustOutDivPaymentTerm ON Division.DivisionID = CustOutDivPaymentTerm.DivisionID AND CustomerID = {0} AND OutletID = {1}" , customerId , outletId);

                var result = dbHelper.GetQueryDataTable(query, ref dt);

                if(result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    for(int i = 0; i < dt.Rows.Count; i++)
                    {
                        int divisionID = -1;
                        int paymentTermID = -1;

                        if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.DivisionID] != DBNull.Value)
                        {
                            divisionID = int.Parse(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.DivisionID].ToString());
                            if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.OutletPaymenTermID] != DBNull.Value)
                            {
                                paymentTermID = int.Parse(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.OutletPaymenTermID].ToString());
                            }
                            else if (dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.DivisionPaymenTermID] != DBNull.Value)
                            {
                                paymentTermID = int.Parse(dt.Rows[i][CoreDataBaseConstants.QueryColumnsNames.DivisionPaymenTermID].ToString());
                            }
                        }

                        if (divisionID > 0 && paymentTermID > 0)
                        {
                            if (!_divisionsPaymentTerm.ContainsKey(divisionID))
                            {
                                _divisionsPaymentTerm.Add(divisionID, GetPaymentTerm(paymentTermID));
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return _divisionsPaymentTerm;
        }

    }
}
