﻿using Microsoft.AspNetCore.Hosting.Internal;
using Microsoft.AspNetCore.Http;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class PriceRequestManager
    {
        private readonly IRequestRepository _requestRepository;
        public PriceRequestManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public static int GetMaxRequestId(DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            int requestId = 1;
            try
            {
                if(dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                string query = string.Format("select ISNULL( MAX(RequestID) , 0)  + 1 From PriceListRequest");

                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    requestId = (int)field;
                }

                return requestId;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return requestId;
            }
        }

        public GlobalErrors SavePriceRequest(PendingPriceListModel priceRequest)
        {
            DBHelper<int> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                if(dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                }
                int requestId = GetMaxRequestId(dbHelper);
                StringBuilder sqlStatment = new StringBuilder();
                sqlStatment.Append("INSERT INTO PriceListRequest (RequestID , CustomerID , OutletID , OrganizationId , UpdateBy, RequestDate, StatusId, Reason) values ");
                sqlStatment.Append("(");
                sqlStatment.Append(requestId);
                sqlStatment.Append(",");
                sqlStatment.Append(priceRequest.CustomerId);
                sqlStatment.Append(",");
                sqlStatment.Append(priceRequest.OutletId);
                sqlStatment.Append(",");
                sqlStatment.Append(priceRequest.OrganizationId);
                sqlStatment.Append(",");
                sqlStatment.Append(-1);
                sqlStatment.Append(",");
                sqlStatment.Append(LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                sqlStatment.Append(",");
                sqlStatment.Append(OrderStatus.New.GetHashCode());
                sqlStatment.Append(",");
                sqlStatment.Append("''");
                sqlStatment.Append(")");
                result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                if(result == GlobalErrors.Error)
                {
                    sqlStatment.Append("SET IDENTITY_INSERT PriceListRequest OFF");
                    result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if(result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
        }
    }
}