﻿using Microsoft.AspNetCore.Mvc;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;

namespace Sonic.Web.Core
{
    public class PricesAndOffersManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly CurrencyManager _currencyManager;
        private readonly CustomerManager _customerManager;

        public PricesAndOffersManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _currencyManager = new CurrencyManager(requestRepository);
            _customerManager = new CustomerManager(requestRepository);
        }
        #region Price

        public GlobalErrors GetPriceLists(GeneralFilter filter, ref SharedTableResult<PriceListModel> priceLists)
        {
            DBHelper<PriceListModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceListModel> lists = new List<PriceListModel>();
                dbHelper = new DBHelper<PriceListModel>();
                string searchFilter = string.Empty;
                string searchCustomerOutlet = string.Empty;
                string orderByFilter = string.Empty;
                string pendingQuery = string.Empty;
                string statusFilter = string.Empty;
                string priceStatusNameFilter = string.Empty;
                string isPendingFilter = string.Empty;
                string isApprovePendingFilter = string.Empty;
                string isApproveOrginalFilter = string.Empty;
                string showEditFilter  = string.Empty;
                string showDeleteFilter = string.Empty;
                string isExistInPendingListFilter = string.Empty;
                string joinCustomerSearch = string.Empty;
                int currentStatus = -1;

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( (PriceList.PriceListName LIKE '%{0}%')
                            OR ( PriceList.PriceListID LIKE '%{0}%')
                            OR ( PriceList.PriceListCode LIKE '%{0}%')
                            OR ( PriceList.PriceListType LIKE '%{0}%' ))", filter.CustomListFilter.SearchFilter.Trim());
                    }

                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" AND  PriceList.StartDate <= {0} ",
                            LocalUtilities.ParseDateToSQLString(filter.DateModel.Date));
                    }

                    if (filter.ToDate != null )
                    {
                        searchFilter += string.Format(" AND PriceList.EndDate >= {0}",
                             LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                    }

                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" And (PriceList.OrganizationID = {0}) ", filter.OrganizationId);
                    }

                    if(filter.PriceListTypeId != -1)
                    {
                        searchFilter += string.Format(" And (PriceList.PriceListTypeID = {0}) ", filter.PriceListTypeId);
                    }

                    if ( filter.CustomerId != -1)
                    {
                        joinCustomerSearch = "LEFT OUTER JOIN CustomerPrice ON CustomerPrice.PriceListId = PriceList.PriceListID";
                        searchCustomerOutlet += string.Format(" And (CustomerPrice.CustomerID = {0}) ", filter.CustomerId);

                        if( filter.OutletId != -1)
                            searchCustomerOutlet += string.Format(" And (CustomerPrice.OutletID = {0}) ", filter.OutletId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By StartDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }
                string activeStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId);
                string pendingAddStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Add_Level, _requestRepository.LanguageId);
                string pendingEditStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Edit_Level, _requestRepository.LanguageId);
                string pendingDeleteStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Delete_Level, _requestRepository.LanguageId);

                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                {
                    int level = -1;
                    currentStatus = GetCurrentStatus();
                    if (currentStatus == -1)
                        level = GetMaxApprovalCycleLevels(ApprovalCycleOperations.Price.GetHashCode());// For Max Level
                    else
                        level = currentStatus;
                    pendingQuery = string.Format(@" union all
                        SELECT PriceList_Pending.PriceListID,
                        PriceList_Pending.PriceListCode,
                        PriceList_Pending.StartDate,
                        PriceList_Pending.EndDate,
                        PriceList_Pending.Priority,
                        PriceList_Pending.PriceListTypeID,
                        PriceList_Pending.IsDeleted,
                        PriceList_Pending.OrganizationID,
                        PriceList_Pending.SalesOrderTypeID,
                        PriceList_Pending.StockStatusID,
                        PriceList_Pending.Status,
                        PriceListLanguage_Pending.Description AS PriceListName,
                        PriceListTypeLanguage.Description AS PriceListType,
                        Organization.OrganizationCode + ' - ' + OrganizationLanguage.Description AS OrganizationCodeName,

                        CASE WHEN PL.PriceListID is null and PriceList_Pending.IsDeleted = 0 THEN  CONCAT('{4} ', PriceList_Pending.Status)
                        WHEN PL.PriceListID is not null and PriceList_Pending.IsDeleted = 0  THEN  CONCAT('{5} ', PriceList_Pending.Status)
                        WHEN PriceList_Pending.IsDeleted = 1 THEN  CONCAT('{6} ', PriceList_Pending.Status) ELSE '{3} ' END AS PriceStatusName,

                        CASE IsNull(PriceList_Pending.Status, -1) WHEN - 1 THEN 0 ELSE 1 END AS IsPending,
                            CASE WHEN   PriceList_Pending.Status = {2} 
                            THEN 1 ELSE 0 END AS IsApprove,
				        CASE WHEN PriceList_Pending.CreationLevel = {2}
                            and PriceList_Pending.Status = {2}
                            and PriceList_Pending.IsDeleted = 0 THEN 1 ELSE 0 END AS ShowEdit,

                        CASE WHEN  PriceList_Pending.Status = {2}
                            or PriceList_Pending.Status = -1 THEN 1 ELSE 0 END AS ShowDelete,
                        CASE WHEN  PriceList_Pending.CreationLevel = {2}
                            THEN 1 ELSE 0 END AS IsCreationLevel,
					        CASE WHEN(select top 1 PriceListID from PriceList where PriceListID = PriceList_Pending.PriceListID ) = PriceList_Pending.PriceListID

                         THEN 1 ELSE 0 END AS ShowViewOriginal
                        FROM PriceList_Pending
                        LEFT OUTER JOIN PriceListLanguage_Pending ON PriceListLanguage_Pending.PriceListID = PriceList_Pending.PriceListID
                        AND PriceListLanguage_Pending.LanguageID = {0}
                            LEFT OUTER JOIN PriceListTypeLanguage ON PriceListTypeLanguage.PriceListTypeID = PriceList_Pending.PriceListTypeID
                        AND PriceListTypeLanguage.LanguageID = {0}
                            left outer join PriceList PL on PL.PriceListID = PriceList_Pending.PriceListID
                        LEFT OUTER JOIN Organization ON Organization.OrganizationID = PriceList_Pending.OrganizationID
                        LEFT OUTER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = PriceList_Pending.OrganizationID
                        AND OrganizationLanguage.LanguageID = {0}
                          ",
                    _requestRepository.LanguageId,//0
                    _requestRepository.CurrentOperator.OrganizationAccess,//1
                    level,//2
                    activeStr,//3
                    pendingAddStr,//4
                    pendingEditStr,//5
                    pendingDeleteStr);
                    if (currentStatus == -1)
                        isApprovePendingFilter = " CASE WHEN PriceList_Pending.Status = (Select Top 1 LevelID from ApprovalCycleLevels where OperationID = 4 order by LevelID desc) THEN 1 ELSE 0 END AS IsApprove";
                    else isApprovePendingFilter = string.Format(" CASE WHEN  PriceList_Pending.Status = {0} THEN 1 ELSE 0 END AS IsApprove", currentStatus);

                    statusFilter = " PriceList.Status ";
                    priceStatusNameFilter = string.Format(@" CASE IsNull(PriceList.Status, - 1) WHEN - 1 THEN '{0} ' ELSE CONCAT('Waiting for approval - level ', PriceList.Status) END AS PriceStatusName ", activeStr);
                    isPendingFilter = " 0 as IsPending ";
                    isApproveOrginalFilter = "CASE IsNull(PriceList.Status, - 1) WHEN - 1  THEN 0 ELSE 1 END AS IsApprove";

                    showEditFilter = " CASE WHEN IsNull(PriceList.Status, - 1) = -1  THEN 1 ELSE 0 END AS ShowEdit ";
                    showDeleteFilter = " CASE WHEN IsNull(PriceList.Status, - 1) = -1  THEN 1 ELSE 0 END AS ShowDelete ";
                    isExistInPendingListFilter = " and (PriceList.PriceListID NOT IN (SELECT PriceListID FROM PriceList_Pending))";
                }
                else
                {
                    statusFilter = " -1 as Status ";
                    priceStatusNameFilter = " 0 AS PriceStatusName  ";
                    isPendingFilter = " 0 as IsPending ";
                    isApproveOrginalFilter = " 0 AS IsApprove ";
                    showEditFilter = " 1 AS ShowEdit ";
                    showDeleteFilter = " 1 AS ShowDelete ";
                }
                string mainQuery = string.Format(@"(
                SELECT PriceList.PriceListID, 
                PriceList.PriceListCode,
                PriceList.StartDate, 
                PriceList.EndDate, 
                PriceList.Priority, 
                PriceList.PriceListTypeID,
                PriceList.IsDeleted,
                PriceList.OrganizationID, 
                PriceList.SalesOrderTypeID, 
                PriceList.StockStatusID,
                PriceList.isDefault,
                {4}, 
                PriceListLanguage.Description AS PriceListName,
                PriceListTypeLanguage.Description AS PriceListType, 
                Organization.OrganizationCode + ' - ' + OrganizationLanguage.Description AS OrganizationCodeName, 
                {5},
                {6},
				{7},
				{8},
                {10},
				0 AS IsCreationLevel, 0 AS ShowViewOriginal 
               
  
                FROM PriceList 
                LEFT OUTER JOIN PriceListLanguage ON PriceListLanguage.PriceListID = PriceList.PriceListID 
                AND PriceListLanguage.LanguageID = {0} 
                LEFT OUTER JOIN PriceListTypeLanguage ON PriceListTypeLanguage.PriceListTypeID = PriceList.PriceListTypeID 
                AND PriceListTypeLanguage.LanguageID = {0} 
                LEFT OUTER JOIN Organization ON Organization.OrganizationID = PriceList.OrganizationID 
                LEFT OUTER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = PriceList.OrganizationID
                {12}
                AND OrganizationLanguage.LanguageID = {0} 
                WHERE 1=1 {9} AND (IsDeleted = 0)
                {3} {11}
                )PriceList where(OrganizationID IN ({1}))
               ",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess,//1
                currentStatus,//2
                pendingQuery,//3
                statusFilter,//4
                priceStatusNameFilter,//5
                isPendingFilter,//6
                isApproveOrginalFilter,//7
                showEditFilter,//8
                isExistInPendingListFilter,//9
                showDeleteFilter,//10
                searchCustomerOutlet, //11
                joinCustomerSearch
                );



                string allDataQuery = string.Format(@"Select ROW_NUMBER() Over(Order By PriceList.PriceListID) AS RowSeq, PriceList.*, CASE WHEN PriceList.IsApprove = 1 and PriceList.IsCreationLevel = 0 then 1 else 0 end as ShowApprove ,
                CASE WHEN PriceList.IsApprove = 1 and PriceList.IsCreationLevel = 1 then 1 else 0 end as ShowRequest
                from 
                {0} {1} {2} 
                OFFSET  {3} ROWS       
                FETCH NEXT {4} ROWS ONLY",
              mainQuery,
              searchFilter,
              orderByFilter,
              (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
              filter.CustomListFilter.PageSize);

                string countQuery = string.Format(@"select IsNull(Count(*),0) from {0} {1}",
                    mainQuery,
                    searchFilter);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    priceLists.TotalItems = int.Parse(objField.ToString().Trim());
                    if (priceLists.TotalItems <= 0)
                    {
                        priceLists.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists , true);
                priceLists.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceLists = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertcustomerPriceList(SimpleCustomerModel customerPricList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            if (dBHelper == null)
            {
                dBHelper = new DBHelper<int>();
            }

                        result = InsertAppliedCustomersToPriceList(customerPricList, customerPricList.PriceListID, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                        //Save Customer Price Audit
                        result = SaveCustomerPriceAudit(customerPricList.PriceListID, customerPricList, AuditActions.Add, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                    
            return result;
        }
        public GlobalErrors UpdatePendingPriceLists(PendingPriceListModel priceLists)
        {
            DBHelper<int> dBHelper = new DBHelper<int>();

            var reasonUpdate = string.Empty;
            if (!string.IsNullOrEmpty(priceLists.Reason))
            {
                reasonUpdate = string.Format(@",Reason = '{0}'", priceLists.Reason); 

            }
            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;

                string query = string.Format(@"update PriceListRequest set StatusID = {0} , updateBy = {1} {3} where requestId = {2} 
               ",
                   priceLists.StatusId,//1
                   _requestRepository.CurrentOperator.EmployeeId,//2
                   priceLists.RequestID,
                   reasonUpdate
                   );

                result = dBHelper.ExecuteNonQuery(query);
                return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceLists = null;
                return GlobalErrors.Error;
            }
        

        }
        public GlobalErrors GetSalesOrderStatusTypes(ref List<OrderModel> salesOrderTypes, List<int> orderStatuses)
        {
            DBHelper<OrderModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            string orderStatusesFilter = string.Join(", ", orderStatuses);

            try
            {

                string onDeliveryDesc = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending, _requestRepository.LanguageId);
                dbHelper = new DBHelper<OrderModel>();
                string query = string.Format(@" select OrderStatus.OrderStatusId,CASE
                                                WHEN OrderStatus.OrderStatusID = 1 THEN '{2}'
                                                ELSE OrderStatusLanguage.Description
                                                END AS  OrderStatusDescription from OrderStatus
                                                INNER JOIN OrderStatusLanguage ON OrderStatus.OrderStatusID =
				                                OrderStatusLanguage.OrderStatusID WHERE OrderStatusLanguage.LanguageID = {0}
				                                and OrderStatus.OrderStatusID in ({1})", _requestRepository.LanguageId, orderStatusesFilter, onDeliveryDesc);

                result = dbHelper.GetQueryList(query, ref salesOrderTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                salesOrderTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPendingPriceLists(GeneralFilter filter, ref SharedTableResult<PendingPriceListModel> priceLists)
        {
            DBHelper<PendingPriceListModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PendingPriceListModel> lists = new List<PendingPriceListModel>();
                dbHelper = new DBHelper<PendingPriceListModel>();
                string searchFilter = string.Empty;
                string searchCustomerOutlet = string.Empty;
                string orderByFilter = string.Empty;
                string pendingQuery = string.Empty;
                string statusFilter = string.Empty;
                string priceStatusNameFilter = string.Empty;
                string isPendingFilter = string.Empty;
                string isApprovePendingFilter = string.Empty;
                string isApproveOrginalFilter = string.Empty;
                string showEditFilter = string.Empty;
                string showDeleteFilter = string.Empty;
                string isExistInPendingListFilter = string.Empty;
                string joinCustomerSearch = string.Empty;
                int currentStatus = -1;

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( PriceListRequest.OrganizationCodeName LIKE '%{0}%')
                            OR ( PriceListRequest.EmployeeName LIKE '%{0}%')
                            OR ( PriceListRequest.CustomerCodeName LIKE '%{0}%')
                            OR ( PriceListRequest.OutletCodeName LIKE '%{0}%' )", filter.CustomListFilter.SearchFilter.Trim());
                    }

                    if (filter.DateModel != null)
                    {
                        var date = LocalUtilities.ParseDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day));
                        searchFilter += string.Format(" AND  PriceListRequest.RequestDate = {0} ",
                            date);
                    }

                    if(filter.TypeId != -1)
                    {

                        searchFilter += string.Format(" And (PriceListRequest.statusId = {0}) ", filter.TypeId);

                    }

                    //if (filter.ToDate != null)
                    //{
                    //    searchFilter += string.Format(" AND PriceList.EndDate >= {0}",
                    //         LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                    //}

                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" And (PriceListRequest.OrganizationID = {0}) ", filter.OrganizationId);
                    }
            

                    if (filter.CustomerId != -1)
                    {
                        //joinCustomerSearch = "LEFT OUTER JOIN CustomerPrice ON CustomerPrice.PriceListId = PriceList.PriceListID";
                        searchCustomerOutlet += string.Format(" And (PriceListRequest.CustomerID = {0}) ", filter.CustomerId);

                        if (filter.OutletId != -1)
                            searchCustomerOutlet += string.Format(" And (PriceListRequest.OutletID = {0}) ", filter.OutletId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By PriceListRequest.RequestDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }
                string activeStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId);
                string pendingAddStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Add_Level, _requestRepository.LanguageId);
                string pendingEditStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Edit_Level, _requestRepository.LanguageId);
                string pendingDeleteStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Delete_Level, _requestRepository.LanguageId);

              
                
                    //statusFilter = " -1 as Status ";
                    //priceStatusNameFilter = " 0 AS PriceStatusName  ";
                    //isPendingFilter = " 0 as IsPending ";
                    //isApproveOrginalFilter = " 0 AS IsApprove ";
                    //showEditFilter = " 1 AS ShowEdit ";
                    //showDeleteFilter = " 1 AS ShowDelete ";
                
                string mainQuery = string.Format(@"(
                SELECT PriceListRequest.*,
                Customer.CustomerCode + ' - ' + CustomerLanguage.Description AS CustomerCodeName,
				CustomerOutletLanguage.Description AS OutletCodeName,
                Organization.OrganizationCode + ' - ' + OrganizationLanguage.Description AS OrganizationCodeName,
                EmployeeLanguage.Description AS EmployeeName,
                 CASE 
            WHEN PriceListRequest.StatusID = 1 THEN 'Pending'
            WHEN PriceListRequest.StatusID = 2 THEN 'Approved'
            WHEN PriceListRequest.StatusID = 8 THEN 'Rejected'
            ELSE 'Unknown'
            END AS StatusDescription,
            CASE 
            WHEN PriceListRequest.StatusID = 1 then 1 else 0 end 
			as isPending,
				CASE 
            WHEN PriceListRequest.StatusID = 8 then 1 else 0 end 
			as isRejected
                FROM PriceListRequest 
                LEFT OUTER JOIN Organization ON Organization.OrganizationID = PriceListRequest.OrganizationID 
                LEFT OUTER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = PriceListRequest.OrganizationID
                {12}
                AND OrganizationLanguage.LanguageID = {0} 
	            LEFT OUTER JOIN Customer ON Customer.CustomerID = PriceListRequest.CustomerID 
				 LEFT OUTER JOIN CustomerLanguage ON CustomerLanguage.CustomerID = PriceListRequest.CustomerID
				 and CustomerLanguage.LanguageID = {0} 
				LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutletLanguage.CustomerID = PriceListRequest.CustomerID 
				and CustomerOutletLanguage.OutletID = PriceListRequest.outletId
				and CustomerOutletLanguage.LanguageID = {0}
	            Left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = PriceListRequest.updateBy
				and EmployeeLanguage.LanguageID = {0}
                WHERE 1=1 
                {3} {11}
                )PriceListRequest where(PriceListRequest.OrganizationID IN ({1}))
               ",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess,//1
                currentStatus,//2
                pendingQuery,//3
                statusFilter,//4
                priceStatusNameFilter,//5
                isPendingFilter,//6
                isApproveOrginalFilter,//7
                showEditFilter,//8
                isExistInPendingListFilter,//9
                showDeleteFilter,//10
                searchCustomerOutlet, //11
                joinCustomerSearch
                );



                string allDataQuery = string.Format(@"Select ROW_NUMBER() Over(Order By PriceListRequest.RequestID) AS RowSeq, PriceListRequest.*
                from 
                {0} {1} {2} 
                OFFSET  {3} ROWS       
                FETCH NEXT {4} ROWS ONLY",
              mainQuery,
              searchFilter,
              orderByFilter,
              (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
              filter.CustomListFilter.PageSize);

                string countQuery = string.Format(@"select IsNull(Count(*),0) from {0} {1}",
                    mainQuery,
                    searchFilter);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField, true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    priceLists.TotalItems = int.Parse(objField.ToString().Trim());
                    if (priceLists.TotalItems <= 0)
                    {
                        priceLists.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists, true);
                priceLists.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceLists = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListAppliedChannels(int priceListId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"select ChannelPrice.*,
 (CONVERT(varchar(10),ChannelPrice.ChannelID) + '-' + CONVERT(varchar(10),ChannelPrice.SubChannelID)) ChannelSubChannelIds , (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
from ChannelPrice
 LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = ChannelPrice.ChannelID and ChannelLanguage.LanguageID = {1}
LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = ChannelPrice.SubChannelID and SubChannelLanguage.LanguageID = {1}
where ChannelPrice.PriceListID={0}", priceListId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListAppliedChannelsPending(int priceListId, ref List<CustomerChannelModel> appliedChannels, DBHelper<int> dBHelper)
        {
            DBHelper<CustomerChannelModel> dbHelper_CustomerChannel = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_CustomerChannel = new DBHelper<CustomerChannelModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_CustomerChannel = new DBHelper<CustomerChannelModel>();
                }
                string query = string.Format(@"select ChannelPrice_Pending.*,
                 (CONVERT(varchar(10),ChannelPrice_Pending.ChannelID) + '-' + CONVERT(varchar(10),ChannelPrice_Pending.SubChannelID)) ChannelSubChannelIds , (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                from ChannelPrice_Pending
                 LEFT OUTER JOIN ChannelLanguage on ChannelLanguage.ChannelID = ChannelPrice_Pending.ChannelID and ChannelLanguage.LanguageID = {1}
                LEFT OUTER JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = ChannelPrice_Pending.SubChannelID and SubChannelLanguage.LanguageID ={1}
                where ChannelPrice_Pending.PriceListID={0}", priceListId, _requestRepository.LanguageId);
                result = dbHelper_CustomerChannel.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListAppliedGroups(int priceListId, ref List<CustomerGroupModel> appliedGroups)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                dbHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"select GroupPrice.*,CustomerGroup.*,CustomerGroupLanguage.Description GroupName,
                                               IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                               from GroupPrice
                                               inner join CustomerGroup on CustomerGroup.GroupID=GroupPrice.GroupID {2}
                                               left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=GroupPrice.GroupID and CustomerGroupLanguage.LanguageID={1}
                                               where GroupPrice.PriceListID={0}", priceListId, _requestRepository.LanguageId, orgAccess);
                result = dbHelper.GetQueryList(query, ref appliedGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListAppliedGroupsPending(int priceListId, ref List<CustomerGroupModel> appliedGroups, DBHelper<int> dBHelper)
        {
            DBHelper<CustomerGroupModel> dbHelper_CustomerGroup = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_CustomerGroup = new DBHelper<CustomerGroupModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_CustomerGroup = new DBHelper<CustomerGroupModel>();
                }
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                string query = string.Format(@"select GroupPrice_Pending.*,CustomerGroup.*,CustomerGroupLanguage.Description GroupName,
                                               IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                               from GroupPrice_Pending
                                               inner join CustomerGroup on CustomerGroup.GroupID=GroupPrice_Pending.GroupID {2}
                                               left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=GroupPrice_Pending.GroupID and CustomerGroupLanguage.LanguageID={1}
                                               where GroupPrice_Pending.PriceListID= {0}", priceListId, _requestRepository.LanguageId, orgAccess);
                result = dbHelper_CustomerGroup.GetQueryList(query, ref appliedGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListAppliedSDCs(int priceListId, ref List<SalesDistributionChannelModel> appliedSDCs)
        {
            DBHelper<SalesDistributionChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SalesDistributionChannelModel>();
                string query = $@"select DISTINCT SDCPrice.*,  SDC.SDCCode, SDCLanguage.Description SDCDescription,  IsNull( SDC.SDCCode, '--') +' ' + '-' + ' ' + IsNull(SDCLanguage.Description, '--') as SDCCodeName ,
                        --STRING_AGG(O.OrganizationID,',')  as OrganizationIds
                            O.OrganizationID
                            from SDCPrice
                            INNER JOIN SDC on SDC.SDCID=SDCPrice.SDCID 
                            INNER JOIN SDCOrganization O on O.SDCID = SDCPrice.SDCID  AND O.OrganizationID  in ({_requestRepository.CurrentOperator.OrganizationAccess})
                            LEFT OUTER JOIN SDCLanguage on SDCLanguage.SDCID=SDCPrice.SDCID and SDCLanguage.LanguageID=  {_requestRepository.LanguageId}
                            where SDCPrice.PriceListID= {priceListId}
							--Group by SDCPrice.SDCID,SDCPrice.PriceListID, SDC.SDCCode, SDCLanguage.Description";
                result = dbHelper.GetQueryList(query, ref appliedSDCs);
                if (result == GlobalErrors.Success && appliedSDCs != null && appliedSDCs.Count > 0)
                {
                    appliedSDCs = appliedSDCs.GroupBy(ch => ch.SDCId).Select(grp => new SalesDistributionChannelModel
                    {
                        SDCId = grp.Key,
                        SDCCode = grp.FirstOrDefault().SDCCode,
                        SDCDescription = grp.FirstOrDefault().SDCDescription,
                        SDCCodeName = grp.FirstOrDefault().SDCCodeName,
                        OrganizationIds = string.Join(',', grp.Select(el => el.OrganizationId).ToList()),
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedSDCs = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListAppliedSDCsPending(int priceListId, ref List<SalesDistributionChannelModel> appliedSDCs, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SalesDistributionChannelModel> dbHelper_SDC = null;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_SDC = new DBHelper<SalesDistributionChannelModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_SDC = new DBHelper<SalesDistributionChannelModel>();
                }
                string query = $@"select DISTINCT SDCPrice_Pending.*, SDC.SDCCode,SDCLanguage.Description SDCDescription,
                    IsNull( SDC.SDCCode, '--') +' ' + '-' + ' ' + IsNull(SDCLanguage.Description, '--') as SDCCodeName ,
					--STRING_AGG(O.OrganizationID,',')  as OrganizationIds
                    O.OrganizationID
                    from SDCPrice_Pending
                    INNER JOIN SDC on SDC.SDCID=SDCPrice_Pending.SDCID 
                    INNER JOIN SDCOrganization O on O.SDCID = SDCPrice_Pending.SDCID  AND O.OrganizationID  in ({_requestRepository.CurrentOperator.OrganizationAccess})
                    LEFT OUTER JOIN SDCLanguage on SDCLanguage.SDCID=SDCPrice_Pending.SDCID and SDCLanguage.LanguageID= {_requestRepository.LanguageId}
                    where SDCPrice_Pending.PriceListID=  {priceListId}
					--GROUP BY SDCPrice_Pending.SDCID, SDCPrice_Pending.PriceListID, SDC.SDCCode, SDCLanguage.Description";
                result = dbHelper_SDC.GetQueryList(query, ref appliedSDCs);
                if (result == GlobalErrors.Success && appliedSDCs != null && appliedSDCs.Count > 0)
                {
                    appliedSDCs = appliedSDCs.GroupBy(ch => ch.SDCId).Select(grp => new SalesDistributionChannelModel
                    {
                        SDCId = grp.Key,
                        SDCCode = grp.FirstOrDefault().SDCCode,
                        SDCDescription = grp.FirstOrDefault().SDCDescription,
                        SDCCodeName = grp.FirstOrDefault().SDCCodeName,
                        OrganizationIds = string.Join(',', grp.Select(el => el.OrganizationId).ToList()),
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedSDCs = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListDescriptions(int priceListId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from PriceListLanguage
where PriceListLanguage.PriceListID={0}", priceListId);
                result = dbHelper.GetQueryList(query, ref descriptions);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListDescriptionsPending(int priceListId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from PriceListLanguage_Pending
                where PriceListLanguage_Pending.PriceListID={0}", priceListId);
                result = dbHelper.GetQueryList(query, ref descriptions);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListAppliedCustomers(int priceListId, ref List<SimpleCustomerModel> appliedCustomers)
        {   
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string getCustomerPriceList = string.Empty;
                if (priceListId > -1)
                    getCustomerPriceList=   string.Format(@"where CustomerPrice.PriceListID={0}", priceListId);

                dbHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                //if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                //{
                //    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                //}



                string query = string.Format(@"select Distinct CustomerPrice.*,PriceList.PriceListCode,Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName,
                                               IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                                               CustomerOutletLanguage.Description as OutletName ,
                                               IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                                               from CustomerPrice
                                               inner join Customer on Customer.CustomerID=CustomerPrice.CustomerID 
                                               inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                               inner join CustomerOutlet on CustomerOutlet.CustomerID=CustomerPrice.CustomerID 
                                               and CustomerOutlet.OutletID=CustomerPrice.OutletID 
											   inner join PriceList on  PriceList.PriceListID = CustomerPrice.PriceListID 
                                               left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                                               and CustomerLanguage.OrganizationId in ({3})
                                               left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                                               and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                                               and CustomerOutletLanguage.LanguageID={1}
                                               {2}
                                               {0}
                                               ", getCustomerPriceList, _requestRepository.LanguageId, orgAccessJoin, _requestRepository.CurrentOperator.OrganizationAccess);

                result = dbHelper.GetQueryList(query, ref appliedCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListAppliedCustomersPending(int priceListId, ref List<SimpleCustomerModel> appliedCustomers, DBHelper<int> dBHelper)
        {
            DBHelper<SimpleCustomerModel> dbHelper_CustomerModel = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_CustomerModel = new DBHelper<SimpleCustomerModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_CustomerModel = new DBHelper<SimpleCustomerModel>();
                }
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = string.Format(@"select CustomerPrice_Pending.*,Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName,
                                               IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName, 
                                               CustomerOutletLanguage.Description as OutletName ,
                                               IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                                               from CustomerPrice_Pending
                                               inner join Customer on Customer.CustomerID=CustomerPrice_Pending.CustomerID
                                               inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                                               inner join CustomerOutlet on CustomerOutlet.CustomerID=CustomerPrice_Pending.CustomerID 
                                               and CustomerOutlet.OutletID=CustomerPrice_Pending.OutletID 
                                               left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                                                and CustomerLanguage.OrganizationId in ({3})
                                               left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                                               and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                                               and CustomerOutletLanguage.LanguageID={1}
                                               {2}
                                               where CustomerPrice_Pending.PriceListID={0}", priceListId, _requestRepository.LanguageId, orgAccessJoin, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dbHelper_CustomerModel.GetQueryList(query, ref appliedCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePriceList(PriceListModel priceListObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Update PriceList set PriceListCode='{1}',StartDate={2},EndDate={3},Priority={4},PriceListTypeID={5},OrganizationID={6},StockStatusID={7}, SalesOrderTypeID = {8} , IsDefault = {9}
              where PriceListId={0} ", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'","''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
               priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 && priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode()? priceListObj.StockStatusId : -1, priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode() && priceListObj.SalesOrderTypeId  > 0? priceListObj.SalesOrderTypeId.ToString() : "NULL",priceListObj.IsDefault?1:0);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    //save in Audit
                    result = SavePriceListAudit(priceListObj.PriceListId, priceListObj.PriceListAuditDetails, AuditActions.Edit, dBHelper);
                    if (result != GlobalErrors.Success) return result;
                    //Save language
                    query = string.Format("delete from PriceListLanguage where priceListID={0}", priceListObj.PriceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in priceListObj.PriceListDescriptionLanguages)
                    {
                        query = string.Format(@"insert into PriceListLanguage (PriceListId,LanguageId,Description) values ({0},{1},'{2}')", priceListObj.PriceListId, language.LanguageId, language.Description.Replace("'","''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //Delete Price Definition Tax Details
                    if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                    {
                        result = deletePriceDefinitionTaxDetails(priceListObj.PriceListId, dBHelper);
                    }
                    if (result != GlobalErrors.Success) return result;

                 
                    //Save Items
                    if (priceListObj.PriceListItems != null && priceListObj.PriceListItems.Count > 0)
                    {  
                        //int quantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                        foreach (PriceListItemsModel item in priceListObj.PriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            //item.QuantityRangeId = quantityRangeId;
                            if (priceListObj.PriceListTypeId == PriceListTypes.Retail.GetHashCode()
                                || priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                            {
                                item.MinPrice = -1;
                                item.MaxPrice = -1;
                                item.QuantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                                if (priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                                {
                                    item.Tax = 0;
                                }
                            }
                            if (item.PriceDefinitionId > 0 && item.DataAction == DataActions.Edit)
                            {
                                result = UpdatePriceListItems(item, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                            else if (item.DataAction == DataActions.Add)
                            {
                                result = InsertPriceListItems(item, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                    if (priceListObj.DeletedPriceListItems != null && priceListObj.DeletedPriceListItems.Count > 0)
                    {
                        foreach (PriceListItemsModel item in priceListObj.DeletedPriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            result = DeletePriceListItems(item, dBHelper);
                            if (result != GlobalErrors.Success) return result;

                        }
                    }
                    //Save applied customer
                    string addedCustomerOutletPairs = "'-1'";
                    string addedCustomerOutletPairsInDummyTable = "'-1'";
                    if (priceListObj.AppliedCustomers != null && priceListObj.AppliedCustomers.Count > 0)
                    {
                        if (priceListObj.NewlyAddedCustomers != null && priceListObj.NewlyAddedCustomers.Count > 0)
                        {
                           

                            foreach (SimpleCustomerModel customer in priceListObj.NewlyAddedCustomers)
                            {
                                result = InsertAppliedCustomersToPriceList(customer, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                //Save Customer Price Audit
                                result = SaveCustomerPriceAudit(priceListObj.PriceListId, customer, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        //else
                        //{

                         
                        //    foreach (SimpleCustomerModel customer in priceListObj.AppliedCustomers)
                        //    {
                        //        query = string.Format(@"Delete from CustomerPrice where CustomerID = {0} AND OutletID = {1} ", customerId
                        //     , outletId);
                        //        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        //        AssignOutletToPriceList(customer.CustomerId, customer.OutletId, priceListObj.PriceListId, dBHelper);
                        //    }
             
                        //    //queryString = string.Format("Delete from CustomerPrice  where PriceListID = {0} ", priceListID);
                        //    //result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                        //}
                        addedCustomerOutletPairs = String.Concat(priceListObj.AppliedCustomers.Select(o => "'" + o.CustomerId + "-" + o.OutletId + "',"));
                        addedCustomerOutletPairsInDummyTable = String.Concat(priceListObj.AppliedCustomers.Select(o => "insert into @CustomerOutlet(CustomerId,OutletId) values(" + o.CustomerId + "," + o.OutletId + ")"));
                    }



                    if(addedCustomerOutletPairsInDummyTable.Equals("'-1'"))
                    {
                        addedCustomerOutletPairsInDummyTable = string.Empty;
                    }
                    query = $@"declare  @CustomerOutlet as table (CustomerId int,OutletId int)
                                                        {addedCustomerOutletPairsInDummyTable}";
                    query += $@"

                               insert into CustomerPriceAudit(CustomerPriceAuditID,PriceListID,CustomerID,OutletID,ChangeDate,MachineName,ActionID,EmployeeID)
                               select distinct (select isnull(max(CustomerPriceAuditID),0)  from CustomerPriceAudit) + ROW_NUMBER() OVER(order by CP.customerid,CP.outletId) CustomerPriceAuditID,
                               PriceListID,CP.CustomerId CustomerID,CP.OutletId OutletID,
                               {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)} ChangeDate,
                               N'{System.Environment.MachineName.ToString()}' MachineName,
                               {AuditActions.Delete.GetHashCode()} ActionID,{_requestRepository.CurrentOperator.EmployeeId} EmployeeID
                               from CustomerPrice CP
                               left join @CustomerOutlet CO on CO.CustomerId = CP.CustomerID and CO.OutletId = CP.OutletID 
                               where PriceListID = {priceListObj.PriceListId} and CO.CustomerId is null";


                    ////Hande deleted customers
//                    query = string.Format(@"insert  into customerpriceaudit  select (select isnull(max(customerpriceauditid),0) from CustomerPriceAudit)+ ROW_NUMBER() OVER(order by customerid,outletId), {0},customerID,OutletID,{1},{2},'{3}',{4} from CustomerPrice 
//where  cast(CustomerID as nvarchar(300)) + '-' + cast(OutletID as nvarchar(300)) not in ({5}) and PriceListID={0}", priceListObj.PriceListId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), AuditActions.Delete.GetHashCode(),
//addedCustomerOutletPairs.TrimEnd(",".ToCharArray()));
                    
                    //if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;


                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        StringBuilder orgAccessJoin = new StringBuilder();    
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                        
                        query += $@" 

                                           DELETE CP FROM CustomerPrice CP 
                                           inner join CustomerOutlet CO on CO.CustomerID = CP.CustomerID and CO.OutletID = CP.OutletID
                                           { orgAccessJoin }
                                           left join @CustomerOutlet COO  on  COO.CustomerId = CP.CustomerID and COO.OutletId = CP.OutletID
                                           WHERE CP.priceListID = { priceListObj.PriceListId} and COO.CustomerId is null";
                    }
                    else
                    {
                        query += $@"
                                   delete CP from CustomerPrice CP 
                                    left join @CustomerOutlet CO on CO.CustomerId = CP.CustomerID and CO.OutletId = CP.OutletID 
                                    where priceListID={priceListObj.PriceListId} and  CO.CustomerId is null";
                    }

                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    //Save applied groups
                    string addedGroups = "'-1'";
                    if (priceListObj.AppliedGroups != null && priceListObj.AppliedGroups.Count > 0)
                    {
                        if (priceListObj.NewlyAddedGroups != null && priceListObj.NewlyAddedGroups.Count > 0)
                        {

                            foreach (CustomerGroupModel group in priceListObj.NewlyAddedGroups)
                            {

                                result = InsertAppliedGroupsToPriceList(group, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                //Save Group Price Audit
                                result = SaveGroupPriceAudit(priceListObj.PriceListId, group, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        addedGroups = String.Concat(priceListObj.AppliedGroups.Select(o => o.GroupId + ","));
                    }
                    //Handle deleted Groups
                    query = string.Format(@"insert  into GroupPriceAudit  select (select isnull(max(GroupPriceAuditId),0) from GroupPriceAudit)+ ROW_NUMBER() OVER(order by groupID),GroupID, {0},{1},{2},'{3}',{4} from GroupPrice 
where  GroupID not in ({5}) and PriceListID={0}", priceListObj.PriceListId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), AuditActions.Delete.GetHashCode(),
addedGroups.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;


                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        query = $@" DELETE GP FROM GroupPrice GP                               
                                           inner join CustomerGroup CG  on CG.GroupID = GP.GroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE GP.priceListID = {priceListObj.PriceListId} 
                                           and GP.GroupID not in ({addedGroups.TrimEnd(",".ToCharArray())})";
                    }
                    else
                    {
                        query = string.Format("delete from GroupPrice where priceListID={0} and GroupID not in ({1}) ", priceListObj.PriceListId, addedGroups.TrimEnd(",".ToCharArray()));
                    }

                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    #region[Save applied SDCS]
                    //Save applied SDCS
                    if (_requestRepository.Configurations.EnableSalesDistributionChannel) 
                    {
                        string addedSDCs = "'-1'";
                        if (priceListObj.AppliedSDCs != null && priceListObj.AppliedSDCs.Count > 0) 
                        {
                            if (priceListObj.NewlyAddedSDCs != null && priceListObj.NewlyAddedSDCs.Count > 0)
                            {
                                foreach (SalesDistributionChannelModel sdc in priceListObj.NewlyAddedSDCs)
                                {
                                    result = InsertAppliedSDCsToPriceList(sdc, priceListObj.PriceListId, dBHelper);
                                    if (result != GlobalErrors.Success) return result;
                                    //Save SDC Price Audit
                                    result = SaveSDCPriceAudit(priceListObj.PriceListId, sdc, AuditActions.Add, dBHelper);
                                    if (result != GlobalErrors.Success) return result;
                                }
                            }
                            addedSDCs = String.Concat(priceListObj.AppliedSDCs.Select(o => "'" + o.SDCId + "',"));
                        }
                        //Handle deleted SDCS
                        query = string.Format(@"insert  into SDCPriceAudit  select (select isnull(max(SDCPriceAuditId),0) from SDCPriceAudit)+ ROW_NUMBER() OVER(order by SDCID),SDCID, {0},{1},{2},'{3}',{4} from SDCPrice 
                            where  SDCID not in ({5}) and PriceListID={0}",
                            priceListObj.PriceListId,
                            _requestRepository.CurrentOperator.EmployeeId,
                            LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                            System.Environment.MachineName.ToString(),
                            AuditActions.Delete.GetHashCode(),
                            addedSDCs.TrimEnd(",".ToCharArray()));
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            query = $@"DELETE SDCP FROM SDCPrice SDCP
                            INNER JOIN SDCOrganization O ON O.SDCID = SDCP.SDCID AND O.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                            WHERE SDCP.PriceListID = {priceListObj.PriceListId}
                            AND SDCP.SDCID not in ({addedSDCs.TrimEnd(",".ToCharArray())})";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        }
                    }
                    #endregion
                    //Save applied channels
                    string addedChannels = "'-1'";
                    if (priceListObj.AppliedChannels != null && priceListObj.AppliedChannels.Count > 0)
                    {
                        if (priceListObj.NewlyAddedChannels != null && priceListObj.NewlyAddedChannels.Count > 0)
                        {

                            foreach (CustomerChannelModel channel in priceListObj.NewlyAddedChannels)
                            {

                                result = InsertAppliedChannelsToPriceList(channel, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                //Save Channel Price Audit
                                result = SaveChannelPriceAudit(priceListObj.PriceListId, channel, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        addedChannels = String.Concat(priceListObj.AppliedChannels.Select(o => "'" + o.ChannelSubChannelIds + "',"));
                    }
                    //Handle deleted channels
                    query = string.Format(@"insert  into ChannelPriceAudit  select (select isnull(max(ChannelPriceAuditID),0) from ChannelPriceAudit)+ ROW_NUMBER() OVER(order by channelID,SubChannelID), ChannelID,SubChannelID,{0},{1},{2},'{3}',{4} from ChannelPrice 
where  cast(ChannelID as nvarchar(300)) + '-' + cast(SubChannelID as nvarchar(300)) not in ({5}) and PriceListID={0}", priceListObj.PriceListId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), AuditActions.Delete.GetHashCode(),
addedChannels.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                    query = string.Format("delete from ChannelPrice where priceListID={0} and cast(ChannelID as nvarchar(300)) + '-' + cast(SubChannelID as nvarchar(300)) not in ({1}) ", priceListObj.PriceListId, addedChannels.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                    
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    if (priceListObj.IsDefault)
                    {
                        result = UpdateDefaultPrice(priceListObj.PriceListId, dBHelper);
                    }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
           
            return result;
        }

        public GlobalErrors UpdatePriceListPending(PriceListModel priceListObj,DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
           
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                string query = string.Format(@"Update PriceList_Pending set PriceListCode='{1}',StartDate={2},EndDate={3},Priority={4},PriceListTypeID={5},OrganizationID={6},StockStatusID={7}, SalesOrderTypeID = {8}
              where PriceListId={0} ", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'", "''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
               priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 && priceListObj.PriceListId == PriceListTypes.General.GetHashCode() ? priceListObj.StockStatusId : -1, priceListObj.PriceListId == PriceListTypes.General.GetHashCode() && priceListObj.SalesOrderTypeId > 0 ? priceListObj.SalesOrderTypeId.ToString() : "NULL" );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                if (result == GlobalErrors.Success || result ==  GlobalErrors.SuccessWithZeroRowAffected)
                {
                    //Save language
                    query = string.Format("delete from PriceListLanguage_Pending where priceListID={0}", priceListObj.PriceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in priceListObj.PriceListDescriptionLanguages)
                    {
                        query = string.Format(@"insert into PriceListLanguage_Pending (PriceListId,LanguageId,Description) values ({0},{1},'{2}')", priceListObj.PriceListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }

                    //Delete Price Definition Tax Details
                    if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                    {
                        result = deletePriceDefinitionTaxDetails_Pending(priceListObj.PriceListId, dBHelper);
                    }
                    if (result != GlobalErrors.Success) return result;

                    //Save Items
                    if (priceListObj.PriceListItems != null && priceListObj.PriceListItems.Count > 0)
                    {
                        if (result != GlobalErrors.Success) return result;
                        int quantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                        foreach (PriceListItemsModel item in priceListObj.PriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            item.QuantityRangeId = quantityRangeId;
                            if (priceListObj.PriceListTypeId == PriceListTypes.Retail.GetHashCode()
                                || priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                            {
                                item.MinPrice = -1;
                                item.MaxPrice = -1;
                                if (priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                                {
                                    item.Tax = 0;
                                }
                            }
                            if (item.PriceDefinitionId > 0 && item.DataAction == DataActions.Edit)
                            {   
                                result = UpdatePriceListItemsPending(item, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                            else if (item.DataAction == DataActions.Add)
                            {
                                result = InsertPriceListItemsPending(item, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                    if (priceListObj.DeletedPriceListItems != null && priceListObj.DeletedPriceListItems.Count > 0)
                    {
                        foreach (PriceListItemsModel item in priceListObj.DeletedPriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            result = DeletePriceListItemsPending(item, dBHelper);
                            if (result != GlobalErrors.Success) return result;

                        }
                    }
                    //Save applied customer
                    string addedCustomerOutletPairs = "'-1'";
                    if (priceListObj.AppliedCustomers != null && priceListObj.AppliedCustomers.Count > 0)
                    {
                        if (priceListObj.NewlyAddedCustomers != null && priceListObj.NewlyAddedCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel customer in priceListObj.NewlyAddedCustomers)
                            {
                                result = InsertAppliedCustomersToPriceListPending(customer, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        addedCustomerOutletPairs = String.Concat(priceListObj.AppliedCustomers.Select(o => "'" + o.CustomerId + "-" + o.OutletId + "',"));

                    }

                    query = string.Format("delete from CustomerPrice_Pending where priceListID={0} and  cast(CustomerID as nvarchar(300)) + '-' + cast(OutletID as nvarchar(300)) not in ({1}) ", priceListObj.PriceListId, addedCustomerOutletPairs.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    //Save applied groups
                    string addedGroups = "'-1'";
                    if (priceListObj.AppliedGroups != null && priceListObj.AppliedGroups.Count > 0)
                    {
                        if (priceListObj.NewlyAddedGroups != null && priceListObj.NewlyAddedGroups.Count > 0)
                        {

                            foreach (CustomerGroupModel group in priceListObj.NewlyAddedGroups)
                            {

                                result = InsertAppliedGroupsToPriceListPending(group, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        addedGroups = String.Concat(priceListObj.AppliedGroups.Select(o => o.GroupId + ","));
                    }
                    
                    query = string.Format("delete from GroupPrice_Pending where priceListID={0} and GroupID not in ({1}) ", priceListObj.PriceListId, addedGroups.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                    //Save applied SDCs
                    #region[Sales Distribution Channels]
                    if (_requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        string addedSDCs = "'-1'";
                        if (priceListObj.AppliedSDCs != null && priceListObj.AppliedSDCs.Count > 0)
                        {
                            if (priceListObj.NewlyAddedSDCs != null && priceListObj.NewlyAddedSDCs.Count > 0)
                            {
                                foreach (SalesDistributionChannelModel sdc in priceListObj.NewlyAddedSDCs)
                                {
                                    result = InsertAppliedSDCsToPriceListPending(sdc, priceListObj.PriceListId, dBHelper);
                                    if (result != GlobalErrors.Success) return result;
                                }
                            }
                            addedSDCs = string.Concat(priceListObj.AppliedSDCs.Select(o => o.SDCId + ","));
                        }
                        query = string.Format("delete from SDCPrice_Pending where priceListID={0} and SDCID not in ({1}) ", priceListObj.PriceListId, addedSDCs.TrimEnd(",".ToCharArray()));
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    }
                    #endregion
                    //Save applied channels
                    string addedChannels = "'-1'";
                    if (priceListObj.AppliedChannels != null && priceListObj.AppliedChannels.Count > 0)
                    {
                        if (priceListObj.NewlyAddedChannels != null && priceListObj.NewlyAddedChannels.Count > 0)
                        {

                            foreach (CustomerChannelModel channel in priceListObj.NewlyAddedChannels)
                            {

                                result = InsertAppliedChannelsToPriceListPending(channel, priceListObj.PriceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                        addedChannels = String.Concat(priceListObj.AppliedChannels.Select(o => "'" + o.ChannelSubChannelIds + "',"));
                    }
                    query = string.Format("delete from ChannelPrice_Pending where priceListID={0} and cast(ChannelID as nvarchar(300)) + '-' + cast(SubChannelID as nvarchar(300)) not in ({1}) ", priceListObj.PriceListId, addedChannels.TrimEnd(",".ToCharArray()));
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                   
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
          
            return result;
        }

        public GlobalErrors ApproveOperation(int Id, int operationTypeId , ref int actualNewLevel ,ref int newStatus, string organizationFilter, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ApprovalCycleOperationsModel> dBHelper2 = null;
            string query = "";
            newStatus = 0;
            actualNewLevel = 0;
            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    dBHelper2 = new DBHelper<ApprovalCycleOperationsModel>();
                }
                else
                {
                    dBHelper2 = new DBHelper<ApprovalCycleOperationsModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                List<ApprovalCycleOperationsModel> operatorAssignedLevels = new List<ApprovalCycleOperationsModel>();
                List<int> allOperationLevels = new List<int>();
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetOperatorAssignedLevels(ref operatorAssignedLevels, operationTypeId, Id, organizationFilter, dBHelper2);
                if (result == GlobalErrors.Success)
                { // valid to approve
                    int organizationId = -1;
                    if (operatorAssignedLevels != null && operatorAssignedLevels.Count > 0 && (operationTypeId == (int)ApprovalCycleOperations.Promotions || operationTypeId == (int)ApprovalCycleOperations.Orders)) 
                    {
                        // the organization id is the same for all assigned levels (all the assigned levels are for security groups that belong to the operator's organization).
                        organizationId = operatorAssignedLevels.FirstOrDefault().OrganizationId; 
                    }
                    result = settingManager.GetAllOperationLevels(ref allOperationLevels, operationTypeId, organizationId, dBHelper);
                    if (result == GlobalErrors.Success && allOperationLevels != null && allOperationLevels.Count > 0 && operatorAssignedLevels.Select(x => x.LevelId).Max()==(allOperationLevels.Max()))
                    {
                        newStatus = -1; //active.
                        actualNewLevel = operatorAssignedLevels.Select(x => x.LevelId).Max();
                    }
                    else
                    {
                        newStatus = operatorAssignedLevels.Select(x => x.LevelId).Max();
                        actualNewLevel = newStatus;
                    }

                    if (operationTypeId == (int)ApprovalCycleOperations.Orders) 
                    {
                        // in case of orders, get new status for order, but do not affect DB values, as this will be done later.
                        return GlobalErrors.Success;
                    }
                    switch ((ApprovalCycleOperations) operationTypeId)
                    {
                        case ApprovalCycleOperations.Promotions:
                            query = string.Format("Update Promotion set Status = {0} Where Promotion.PromotionID = {1}", newStatus, Id);
                            break;
                        case ApprovalCycleOperations.Discounts:
                            query = string.Format("Update Discount set Status = {0} Where Discount.DiscountID = {1}", newStatus, Id);
                            break;
                        case ApprovalCycleOperations.CreditRelease:
                            query = string.Format("Update CreditRelease set Status = {0} Where CreditRelease.CreditReleaseID = {1}", newStatus, Id);
                            break;
                        case ApprovalCycleOperations.Price:
                            
                            if (newStatus == -1)
                            {
                                result = ConvertPriceListFromPendingToApproval(Id, dBHelper);
                                query = string.Format("Update PriceList set Status = {0} Where PriceList.PriceListID = {1}", newStatus, Id);
                            }
                            else
                            {
                                if (_requestRepository.Configurations.ForcePreviousLevelApproval)
                                {
                                    newStatus = newStatus + 1;
                                }
                                query = string.Format("Update PriceList_Pending set Status = {0} Where PriceList_Pending.PriceListID = {1}", newStatus, Id);
                            }
                           
                            break;
                        case ApprovalCycleOperations.ContractedFOC:

                            if (newStatus == -1)
                            {
                                result = ConvertContractedFocFromPendingToApproval(Id, dBHelper);
                                if (result != GlobalErrors.Success)
                                    return result;
                                query = string.Format("Update ContractedFOC set Status = {0} Where ContractedFOC.ContractID = {1}", newStatus, Id);
                            }
                            else
                            {
                                if (_requestRepository.Configurations.ForcePreviousLevelApproval)
                                {
                                    newStatus = newStatus + 1;
                                }
                                query = string.Format("Update ContractedFOC_Pending set Status = {0} Where ContractedFOC_Pending.ContractID = {1}", newStatus, Id);
                            }

                            break;

                    }
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ConvertPriceListFromPendingToApproval(int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                PriceListModel priceListObj = new PriceListModel();
                PriceListModel priceList = new PriceListModel();
                List<PriceListItemsModel> priceListItemsPending = new List<PriceListItemsModel>();
                List<PriceListItemsModel> priceListItems = new List<PriceListItemsModel>();
                List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                List<SalesDistributionChannelModel> appliedSDCs = new List<SalesDistributionChannelModel>();
                List<TaxTypesModel> taxTypes = new List<TaxTypesModel>();

                result = GetPriceListDataPending(priceListId, ref priceListObj, dBHelper);// get PriceList Pending
                if (result == GlobalErrors.Success)
                {
                    result = GetPriceList(priceListId, ref priceList, dBHelper);// get PriceList
                    string q = string.Empty;
                    if (priceList == null)
                    {
                        q = string.Format(@"Insert into PriceList (PriceListID,PriceListCode,StartDate,EndDate,Priority,PriceListTypeID,IsDeleted,OrganizationID,StockStatusID,[Status])
                        values({0},'{1}',{2},{3},{4},{5},0,{6},{7},{8} )", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'", "''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
                           priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 ? priceListObj.StockStatusId : -1, -1);
                    }
                    else
                    {
                        q = string.Format(@"update PriceList set PriceListCode = '{1}', StartDate = {2} ,EndDate = {3} ,Priority = {4} ,PriceListTypeID = {5} , IsDeleted = 0 , OrganizationID = {6},StockStatusID = {7} ,[Status] = {8} where PriceListID = {0}", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'", "''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
                           priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 ? priceListObj.StockStatusId : -1, -1);
                    }
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(q);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = SavePriceListAudit(priceListId, priceListObj.PriceListAuditDetails, AuditActions.Add, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    if (result != GlobalErrors.Success) return result;
                }

                ////// Price List Language
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from  PriceListLanguage where PriceListId = {0}", priceListObj.PriceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in priceListObj.PriceListDescriptionLanguages)
                    {
                        query = string.Format(@"insert into PriceListLanguage (PriceListId,LanguageId,Description) values ({0},{1},'{2}')", priceListObj.PriceListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    }
                }

                ////// Price List Items
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    //Delete Price Definition Tax Details
                    if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                    {
                        result = deletePriceDefinitionTaxDetails(priceListObj.PriceListId, dBHelper);
                    }
                    if (result != GlobalErrors.Success) return result;

                    //Save Items
                    result = GetPriceListItemsPending(priceListId, ref priceListItemsPending, dBHelper);//get PriceListPending

                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from  PriceDefinition where PriceListId = {0}", priceListObj.PriceListId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        if (priceListItemsPending != null && priceListItemsPending.Count > 0)
                        {
                            foreach (PriceListItemsModel item in priceListItemsPending)
                            {
                                item.PriceListId = priceListId;
                                result = InsertPriceListItems(item, dBHelper);//insert PriceListItems if not found
                                if (result != GlobalErrors.Success) return result;

                            }
                        }
                            
                       
                    }
                }

            

                ////// Price List AppliedChannels
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GetPriceListAppliedChannelsPending(priceListId, ref appliedChannels, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from  ChannelPrice where PriceListId = {0}", priceListObj.PriceListId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        if (appliedChannels != null && appliedChannels.Count > 0)
                        {

                            foreach (CustomerChannelModel channel in appliedChannels)
                            {
                                result = InsertAppliedChannelsToPriceList(channel, priceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                result = SaveChannelPriceAudit(priceListId, channel, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                    }
                }

                ////// Price List AppliedGroups
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GetPriceListAppliedGroupsPending(priceListId, ref appliedGroups, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from  GroupPrice where PriceListId = {0}", priceListObj.PriceListId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        if(appliedGroups != null && appliedGroups.Count > 0)
                        {
                            foreach (CustomerGroupModel group in appliedGroups )
                            {
                                result = InsertAppliedGroupsToPriceList(group, priceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                result = SaveGroupPriceAudit(priceListId, group, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                        
                    }
                }


                ////// Price List AppliedCustomers
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {

                    result = GetPriceListAppliedCustomersPending(priceListId, ref appliedCustomers, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from  CustomerPrice where PriceListId = {0}", priceListObj.PriceListId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        if(appliedCustomers != null && appliedCustomers.Count > 0)
                        {
                            foreach (SimpleCustomerModel customer in appliedCustomers)
                            {
                                result = InsertAppliedCustomersToPriceList(customer, priceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                result = SaveCustomerPriceAudit(priceListId, customer, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                             
                        
                    }
                }

                ////// Price List AppliedSDC
                if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.EnableSalesDistributionChannel)
                {
                    result = GetPriceListAppliedSDCsPending(priceListId, ref appliedSDCs, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"delete from  SDCPrice where PriceListId = {0}", priceListObj.PriceListId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                        if (appliedSDCs != null && appliedSDCs.Count > 0)
                        {
                            foreach (SalesDistributionChannelModel sdc in appliedSDCs)
                            {
                                result = InsertAppliedSDCsToPriceList(sdc, priceListId, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                                result = SaveSDCPriceAudit(priceListId, sdc, AuditActions.Add, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = DeletePriceListPending(priceListId, dBHelper);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeletePriceListPending(int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                ////Delete Pending

                query = string.Format(@"delete from PriceList_Pending where PriceListID = {0}", priceListId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from PriceDefinition_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from PriceListLanguage_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from CustomerPrice_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from GroupPrice_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from ChannelPrice_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SDCPrice_Pending where PriceListID = {0}", priceListId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    result = deletePriceDefinitionTaxDetails_Pending(priceListId, dBHelper);
                    if (result != GlobalErrors.Success) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAppliedCustomer(ref List<SimpleCustomerModel> appliedCustomers)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
              var  dBHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Empty;

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<SimpleCustomerModel>();
                };
                ////Delete Pending

                foreach (SimpleCustomerModel customer in appliedCustomers)
                {
                    query = string.Format(@" delete from CustomerPrice where CustomerID='{0}' and PriceListID = {1}", customer.CustomerId,customer.PriceListID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    //    query = string.Format(@" delete from CustomerPriceAuditDetails where CustomerID='{0}' and PriceListID = {1}", customer.CustomerId, customer.PriceListID);
                    //result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;


                }

                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors DeleteActivePriceList(PriceListModel price, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                SettingManager settingManager = new SettingManager(_requestRepository);
                bool isMaxLevel = false;
                result = settingManager.IsMaxOperationLevel(ApprovalCycleOperations.Price.GetHashCode(), ref isMaxLevel, dBHelper);
                if (isMaxLevel)
                {
                    result = DeletePriceList(price.PriceListId, dBHelper);
                }
                else
                {
                    int level = GetCurrentStatus();
                    if (result == GlobalErrors.Success)
                    {
                        if (!CheckIsPriceListPendingExisit(price.PriceListId))
                        {
                            List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                            List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                            List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                            List<SalesDistributionChannelModel> appliedSDCs = new List<SalesDistributionChannelModel>();
                            List<TextLanguage> priceDescription = new List<TextLanguage>();
                            List<PriceListItemsModel> PriceListItemsModel = new List<PriceListItemsModel>();

                            result = GetPriceListAppliedCustomers(price.PriceListId, ref appliedCustomers);
                            if (result != GlobalErrors.Success) return result;
                            result = GetPriceListAppliedGroups(price.PriceListId, ref appliedGroups);
                            if (result != GlobalErrors.Success) return result;
                            result = GetPriceListAppliedChannels(price.PriceListId, ref appliedChannels);
                            if (result != GlobalErrors.Success) return result;
                            result = GetPriceListAppliedSDCs(price.PriceListId, ref appliedSDCs);
                            if (result != GlobalErrors.Success) return result;
                            result = GetPriceListDescriptions(price.PriceListId, ref priceDescription);
                            if (result != GlobalErrors.Success) return result;
                            result = GetPriceListItems(price.PriceListId, ref PriceListItemsModel);

                            price.AppliedCustomers = appliedCustomers;
                            price.AppliedGroups = appliedGroups;
                            price.AppliedChannels = appliedChannels;
                            price.PriceListDescriptionLanguages = priceDescription;
                            price.PriceListItems = PriceListItemsModel;

                            result = InsertPriceListPending(price, dBHelper);
                        }
                        query = string.Format("update PriceList_Pending set IsDeleted = 1 , Status = {1} where PriceListID = {0}", price.PriceListId, level);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeletePriceListPendingIsDeleted(int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper;
            try
            {
                string query = string.Empty;
                dBHelper = new DBHelper<int>();
                query = string.Format(@"update PriceList_Pending set IsDeleted = 1 where PriceListID = {0}", priceListId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
               
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public int GetMaxPriceCycleHistoryID(int priceListId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            string query = string.Empty;
            try
            {
                object max = null;
                dBHelper = new DBHelper<int>();
                query = string.Format(@"SELECT ISNULL(MAX(HistoryID) + 1, 1) FROM PriceCycleHistory WHERE (PriceListID = {0}) and (NewStatus = -1)", priceListId);
                result = dBHelper.ExecuteScalar(query, ref max);
                if (max == null)
                    return 1;
                return (int)max;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }
        }
        public GlobalErrors SaveInApprovalCycleHistory(int id, int currentStatusId, int operationTypeId, int newStatus, DBHelper<int> dBHelper)
        {
            int approvalHistoryId = -1;
            return SaveInApprovalCycleHistory(id, currentStatusId, operationTypeId, newStatus, ref approvalHistoryId, dBHelper);
        }
        public GlobalErrors SaveInApprovalCycleHistory(int id, int currentStatusId, int operationTypeId, int newStatus, ref int approvalHistoryID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            
            try
            {
                if(dBHelper == null)
                    dBHelper = new DBHelper<int>();
                approvalHistoryID = GetMaxID("approvalHistoryID", "ApprovalCycleHistory", dBHelper);
                string query = string.Format(@"Insert Into ApprovalCycleHistory (approvalHistoryID , operationTypeID , OperationID , OldStatus , NewStatus , approvedBy , ApprovedDate)
                            VALUES ({0},{1},{2},{3},{4},{5},{6})", approvalHistoryID, operationTypeId, id, currentStatusId, newStatus, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveInOrderApprovalCycleHistory(int approvalHistoryId, string orderId, int customerId, int outletId, int divisionId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                string query = $@"Insert into OrderApprovalCycleHistory(ApprovalHistoryID, OrderID, CustomerID, OutletID, DivisionID) Values ( {approvalHistoryId} ,'{orderId}',{customerId},{outletId},{divisionId})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsValidToApprove(int status, int OperationTypeId, int operationDetailId, string organizationFilter,ref bool isValid, ref List<int> validationIds, ref int currentLevel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            DBHelper<ApprovalCycleOperationsModel> dBHelper2 = null;
            int newStatus = 0;
            try
            {
                List<ApprovalCycleOperationsModel> operatorAssignedLevels = new List<ApprovalCycleOperationsModel>();
                List<int> allOperationLevels = new List<int>();
                dBHelper = new DBHelper<int>();
                dBHelper2 = new DBHelper<ApprovalCycleOperationsModel>();
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetOperatorAssignedLevels(ref operatorAssignedLevels, OperationTypeId, operationDetailId, organizationFilter, dBHelper2);
                if (result == GlobalErrors.Success && operatorAssignedLevels != null && operatorAssignedLevels.Count > 0)
                {
                    currentLevel = operatorAssignedLevels.Max(x => x.LevelId);
                    if (_requestRepository.Configurations.ForcePreviousLevelApproval && (OperationTypeId == ApprovalCycleOperations.Price.GetHashCode() || OperationTypeId == ApprovalCycleOperations.ContractedFOC.GetHashCode() || OperationTypeId == (int)ApprovalCycleOperations.Promotions || OperationTypeId == (int)ApprovalCycleOperations.Orders))
                    {
                        int statusToApprove = OperationTypeId == (int)ApprovalCycleOperations.Promotions || OperationTypeId == (int)ApprovalCycleOperations.Orders ? status + 1 : status;
                        if (operatorAssignedLevels.FindAll(x => x.LevelId == statusToApprove).Count > 0)
                        {
                            validationIds = operatorAssignedLevels.FindAll(x => x.LevelId >= statusToApprove).SelectMany(level => level.Validations).Distinct().ToList();
                            validationIds = validationIds.Distinct().ToList();
                            isValid = true;
                        }
                        else
                        {
                            isValid = false;
                        }
                    }
                    else if (operatorAssignedLevels.FindAll(x => x.LevelId > status).Count > 0)
                    {
                        validationIds = operatorAssignedLevels.FindAll(x => x.LevelId > status).SelectMany(level => level.Validations).Distinct().ToList();
                        // valid to approve
                        isValid = true;
                    }
                    else
                    {
                        // not valid to approve.
                        isValid = false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors IsValidToAffect(int status, int OperationTypeId, ref bool isValid)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            DBHelper<ApprovalCycleOperationsModel> dBHelper2 = null;
            int newStatus = 0;
            try
            {
                List<ApprovalCycleOperationsModel> operatorAssignedLevels = new List<ApprovalCycleOperationsModel>();
                List<int> allOperationLevels = new List<int>();
                dBHelper = new DBHelper<int>();
                dBHelper2 = new DBHelper<ApprovalCycleOperationsModel>();
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetOperatorAssignedLevels(ref operatorAssignedLevels, OperationTypeId, dBHelper2);
                if (result == GlobalErrors.Success && operatorAssignedLevels != null && operatorAssignedLevels.Count > 0)
                {
                    if (_requestRepository.Configurations.ForcePreviousLevelApproval && (OperationTypeId == ApprovalCycleOperations.Price.GetHashCode()  || OperationTypeId == ApprovalCycleOperations.ContractedFOC.GetHashCode()))
                    {
                        if(status == -1 || status == 0)
                        {
                            isValid = true;
                        }
                        else
                        {
                            if (operatorAssignedLevels.FindAll(x => x.LevelId == (status)).Count > 0)
                            {
                                isValid = true;
                            }
                            else
                            {
                                isValid = false;
                            }
                        }

                    }
                    else
                    {
                        isValid = false;
                    }
                }
                else
                {
                    if(status == -1)
                        isValid = true;
                    else isValid = false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsValidToEditFoc(ContractedFOCModel contractedFOC, ref bool isValid,ref string editingMsg)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            bool allowEditFOC = false;
            try
            {
                if (!UsedContractedFOC(contractedFOC.CustomerId, contractedFOC.OutletId, contractedFOC.ContractId))
                {
                    isValid = true;
                    result = CheckUploadedContractFOC(contractedFOC.ContractId, ref allowEditFOC, contractedFOC.CustomerId, contractedFOC.OutletId, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        if (!allowEditFOC)
                        {
                            isValid = false;
                            editingMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Cannot_Edit_Uploaded_Contracted_FOC, _requestRepository.LanguageId);
                            return GlobalErrors.Error;
                        }
                        else
                        {
                            isValid = true;
                        }
                    }
                }
                else
                {
                    isValid = false;
                    editingMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Used_Contracted_FOC_Cannot_Be_Edited, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public int GetDefaultQuantityRangeID(DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object id = null;
                int definedRangeID = -1;
                string query = string.Format(@"select  top 1 PriceQuantityRangeID  from PriceQuantityRange where RangeStart=0 and RangeEnd=999999999 ");
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref id);
                if (result == GlobalErrors.Success && id != null && !string.IsNullOrEmpty(id.ToString()))
                {
                    definedRangeID = int.Parse(id.ToString());
                }
                if (definedRangeID <= 0)
                {
                    definedRangeID = GetMaxID("PriceQuantityRangeID", "PriceQuantityRange", dBHelper);
                    query = string.Format(@"insert into PriceQuantityRange (PriceQuantityRangeID,RangeStart,RangeEnd)values ({0},0 ,999999999) ", definedRangeID);
                    result = dBHelper.ExecuteNonQuery(query);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
        public GlobalErrors InsertPriceList(PriceListModel priceListObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int status = GetCurrentStatus();
                if (GetMaxID("PriceListID", "PriceList", dBHelper) > GetMaxID("PriceListID", "PriceList_Pending", dBHelper))
                {
                    priceListObj.PriceListId = GetMaxID("PriceListID", "PriceList", dBHelper);
                }
                else
                {
                    priceListObj.PriceListId = GetMaxID("PriceListID", "PriceList_Pending", dBHelper);
                }
                string query = string.Format(@"Insert into PriceList (PriceListID,PriceListCode,StartDate,EndDate,Priority,PriceListTypeID,IsDeleted,OrganizationID,StockStatusID,[Status],SalesOrderTypeID)
                values({0},'{1}',{2},{3},{4},{5},0,{6},{7},{8},{9} )", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'","''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
                priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 && priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode() ? priceListObj.StockStatusId : -1, status,  priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode() && priceListObj.SalesOrderTypeId > 0 ? priceListObj.SalesOrderTypeId.ToString(): "NULL");
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //save in Audit
                    result = SavePriceListAudit(priceListObj.PriceListId, priceListObj.PriceListAuditDetails, AuditActions.Add, dBHelper);
                    if (result != GlobalErrors.Success) return result;
                    //Save language
                    foreach (TextLanguage language in priceListObj.PriceListDescriptionLanguages)
                    {
                        query = string.Format(@"insert into PriceListLanguage (PriceListId,LanguageId,Description) values ({0},{1},'{2}')", priceListObj.PriceListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;              
                        //save in Audit
                    }

                 
                 

                    //Save Items
                    if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                    {
                        result = deletePriceDefinitionTaxDetails(priceListObj.PriceListId, dBHelper);
                    }
                    if (result == GlobalErrors.Success)
                        if (priceListObj.IsDefault)
                        {
                            result = UpdateDefaultPrice(priceListObj.PriceListId, dBHelper);
                        }
                    if (result != GlobalErrors.Success) return result;
                    if (priceListObj.PriceListItems != null && priceListObj.PriceListItems.Count > 0)
                    {
                        //int quantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                        foreach (PriceListItemsModel item in priceListObj.PriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            //item.QuantityRangeId = quantityRangeId;
                            if(priceListObj.PriceListTypeId == PriceListTypes.Retail.GetHashCode() || priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                            {
                                item.QuantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                            }
                            if (priceListObj.PriceListTypeId == PriceListTypes.Retail.GetHashCode()
                               || priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                            {
                                item.MinPrice = -1;
                                item.MaxPrice = -1;
                                if (priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                                {
                                    item.Tax = 0;
                                }
                            }
                            result = InsertPriceListItems(item, dBHelper);
                            if (result != GlobalErrors.Success) return result; 
                        }
                    }
                    //Save applied customer
                    if (priceListObj.AppliedCustomers != null && priceListObj.AppliedCustomers.Count > 0)
                    {
                        foreach (SimpleCustomerModel customer in priceListObj.AppliedCustomers)
                        {

                            result = InsertAppliedCustomersToPriceList(customer, priceListObj.PriceListId, dBHelper);                           
                            if (result != GlobalErrors.Success) return result;
                            //Save Customer Price Audit
                            result = SaveCustomerPriceAudit(priceListObj.PriceListId, customer, AuditActions.Add, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }

                    }

                    if (result != GlobalErrors.Success) return result;
                    //Save applied groups
                    if (priceListObj.AppliedGroups != null && priceListObj.AppliedGroups.Count > 0)
                    {
                        foreach (CustomerGroupModel group in priceListObj.AppliedGroups)
                        {

                            result = InsertAppliedGroupsToPriceList(group, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            //Save Group Price Audit
                            result = SaveGroupPriceAudit(priceListObj.PriceListId, group, AuditActions.Add, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    //Save applied channels
                    if (priceListObj.AppliedChannels != null && priceListObj.AppliedChannels.Count > 0)
                    {
                        foreach (CustomerChannelModel channel in priceListObj.AppliedChannels)
                        {

                            result = InsertAppliedChannelsToPriceList(channel, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            //Save Group Price Audit
                            result = SaveChannelPriceAudit(priceListObj.PriceListId, channel, AuditActions.Add, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                    //Save applied Sales Distribution Channels
                    if (priceListObj.AppliedSDCs != null && priceListObj.AppliedSDCs.Count > 0 && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        foreach (SalesDistributionChannelModel sdc in priceListObj.AppliedSDCs)
                        {
                            result = InsertAppliedSDCsToPriceList(sdc, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            //Save SDC Price Audit
                            result = SaveSDCPriceAudit(priceListObj.PriceListId, sdc, AuditActions.Add, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
           
            return result;
        }

        public GlobalErrors UpdateDefaultPrice(int priceListId,DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Update PriceList set isDefault = 0");
                result = dBHelper.ExecuteNonQuery(query);

                if(result == GlobalErrors.Success)
                {
                query = string.Format(@"Update PriceList set isDefault = 1 where PriceListId = {0}", priceListId);
                result = dBHelper.ExecuteNonQuery(query);
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Update Configuration set KeyValue='{0}' where KeyName='DefaultPriceListID' and EmployeeID=-1", priceListId);
                result = dBHelper.ExecuteNonQuery(query);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors InsertPriceCycleHistory(int PriceListID,int ActionNo, int UpdatedBy, int Level, int OldStatus, int NewStatus, string Note, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int HistoryID = GetMaxPriceCycleHistoryID(PriceListID);
                string query = string.Format(@" insert into PriceCycleHistory([HistoryID],[PriceListID],[ActionNo],[UpdatedBy],[UpdatedDate],[Level],[OldStatus],[NewStatus],[Note])
                    values({0},{1},{2},{3},GETDATE(),{4},{5},{6},'{7}')", HistoryID, PriceListID, ActionNo, UpdatedBy, Level, OldStatus, NewStatus, Note);               
                result = dBHelper.ExecuteNonQuery(query);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors InsertPriceListPending(PriceListModel priceListObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int status = GetCurrentStatus();
                if (priceListObj.PriceListId < 1)
                {
                    if (GetMaxID("PriceListID", "PriceList", dBHelper) > GetMaxID("PriceListID", "PriceList_Pending", dBHelper))
                    {
                        priceListObj.PriceListId = GetMaxID("PriceListID", "PriceList", dBHelper);
                    }
                    else
                    {
                        priceListObj.PriceListId = GetMaxID("PriceListID", "PriceList_Pending", dBHelper);
                    }
                }
                
                
                if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                {
                    string q = string.Format(@"Insert into PriceList_Pending (PriceListID,PriceListCode,StartDate,EndDate,Priority,PriceListTypeID,IsDeleted,OrganizationID,StockStatusID,[Status],CreationLevel,SalesOrderTypeId)
                        values({0},'{1}',{2},{3},{4},{5},0,{6},{7},{8},{8},{9} )", priceListObj.PriceListId, priceListObj.PriceListCode.Replace("'", "''"), LocalUtilities.ParseDateToSQLString(priceListObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(priceListObj.EndDate.Value),
                        priceListObj.Priority, priceListObj.PriceListTypeId, priceListObj.OrganizationId, priceListObj.StockStatusId > 0 && priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode() ? priceListObj.StockStatusId : -1, status, priceListObj.PriceListTypeId == PriceListTypes.General.GetHashCode() && priceListObj.SalesOrderTypeId > 0 ? priceListObj.SalesOrderTypeId.ToString() : "NULL");
                    result = dBHelper.ExecuteNonQuery(q);
                }
                if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                {
                    foreach (TextLanguage language in priceListObj.PriceListDescriptionLanguages)
                    {
                        query = string.Format(@"insert into PriceListLanguage_Pending (PriceListId,LanguageId,Description) values ({0},{1},'{2}')", priceListObj.PriceListId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                    {
                        result = deletePriceDefinitionTaxDetails_Pending(priceListObj.PriceListId, dBHelper);
                    }
                    
                    if (result != GlobalErrors.Success) return result;
                    if (priceListObj.PriceListItems != null && priceListObj.PriceListItems.Count > 0)
                    { 
                        int quantityRangeId = GetDefaultQuantityRangeID(dBHelper);
                        foreach (PriceListItemsModel item in priceListObj.PriceListItems)
                        {
                            item.PriceListId = priceListObj.PriceListId;
                            item.QuantityRangeId = quantityRangeId;
                            if (priceListObj.PriceListTypeId == PriceListTypes.Retail.GetHashCode()
                               || priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                            {
                                item.MinPrice = -1;
                                item.MaxPrice = -1;
                                if (priceListObj.PriceListTypeId == PriceListTypes.CostPrice.GetHashCode())
                                {
                                    item.Tax = 0;
                                }
                            }
                            if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                            {
                                result = InsertPriceListItemsPending(item, dBHelper);
                            }
                        }
                    }
                    //Save applied customer
                    if (priceListObj.AppliedCustomers != null && priceListObj.AppliedCustomers.Count > 0)
                    {
                        foreach (SimpleCustomerModel customer in priceListObj.AppliedCustomers)
                        {
                            result = InsertAppliedCustomersToPriceListPending(customer, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }



                    if (result != GlobalErrors.Success) return result;
                    //Save applied groups
                    if (priceListObj.AppliedGroups != null && priceListObj.AppliedGroups.Count > 0)
                    {
                        foreach (CustomerGroupModel group in priceListObj.AppliedGroups)
                        {
                            if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
                            {
                                result = InsertAppliedGroupsToPriceListPending(group, priceListObj.PriceListId, dBHelper);
                            }
                            if (result != GlobalErrors.Success) return result;
                        }
                    }


                    //Save applied channels
                    if (priceListObj.AppliedChannels != null && priceListObj.AppliedChannels.Count > 0)
                    {
                        foreach (CustomerChannelModel channel in priceListObj.AppliedChannels)
                        {
                            result = InsertAppliedChannelsToPriceListPending(channel, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }

                    //Save applied SDCs (Sales Distribution Channels)
                    if (priceListObj.AppliedSDCs != null && priceListObj.AppliedSDCs.Count > 0 && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        foreach (SalesDistributionChannelModel sdc in priceListObj.AppliedSDCs)
                        {
                            result = InsertAppliedSDCsToPriceListPending(sdc, priceListObj.PriceListId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
          
            return result;
        }
        private GlobalErrors SavePriceListAudit(int priceListId, List<PriceAuditDetailsModel> priceListAuditDetails, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int priceListAuditID = GetMaxID("PriceListAuditID", "PriceListAudit", dBHelper);
                string query = string.Format(@"Insert into PriceListAudit (PriceListAuditID,PriceListId,EmployeeID,ChangeDate,MachineName,ActionID) 
                    values ({0},{1},{2},{3},'{4}',{5})"
               , priceListAuditID, priceListId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), auditAction.GetHashCode());
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;
                if (priceListAuditDetails != null && priceListAuditDetails.Count > 0)
                {
                    foreach (PriceAuditDetailsModel detail in priceListAuditDetails)
                    {
                        query = string.Format(@"Insert into PriceListAuditDetails (PriceListAuditID,FieldNumber,FieldName,OldValue,NewValue)
                    values ({0},{1},'{2}','{3}','{4}')"
            , priceListAuditID, detail.FieldNumber, detail.FieldName, detail.OldValue?.Replace("'", "''"), detail.NewValue.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }

                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePriceDefnitionAudit(PriceListItemsModel item, List<PriceAuditDetailsModel> priceListAuditDetails, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (priceListAuditDetails != null && priceListAuditDetails.Count > 0)
                {
                    int auditID = GetMaxID("PriceDefinitionAuditID", "PriceDefinitionAudit", dBHelper);
                    string query = string.Format(@"Insert into PriceDefinitionAudit (PriceDefinitionAuditID,PriceDefinitionID,EmployeeID,ChangeDate,MachineName,ActionID,PackID,PriceListID) 
                    values ({0},{1},{2},{3},'{4}',{5},{6},{7})"
                   , auditID, item.PriceDefinitionId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString()
                   , auditAction.GetHashCode(), item.PackId, item.PriceListId);
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;

                    foreach (PriceAuditDetailsModel detail in priceListAuditDetails)
                    {
                        query = string.Format(@"Insert into PriceDefinitionAuditDetails (PriceDefinitionAuditID,FieldNumber,FieldName,OldValue,NewValue)
                    values ({0},{1},'{2}','{3}','{4}')"
            , auditID, detail.FieldNumber, detail.FieldName, detail.OldValue.Replace("'", "''"), detail.NewValue.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }

                }
                else
                {
                    result = GlobalErrors.Success;
                }              

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveCustomerPriceAudit(int priceListId, SimpleCustomerModel customer, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int customerPriceAuditID = -1;
                string query = string.Empty;

                customerPriceAuditID = GetMaxID("CustomerPriceAuditID", "CustomerPriceAudit", dBHelper);
                query = string.Format(@"Insert into CustomerPriceAudit (CustomerPriceAuditID,PriceListId,CustomerId,OutletID,EmployeeID,ChangeDate,MachineName,ActionID) 
                    values ({0},{1},{2},{3},{4},{5},'{6}',{7})"
              , customerPriceAuditID, priceListId, customer.CustomerId, customer.OutletId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), auditAction.GetHashCode());
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;
                query = string.Format(@"Insert into CustomerPriceAuditDetails (CustomerPriceAuditID,FieldNumber,FieldName,OldValue,NewValue)
                    values ({0},{1},'{2}','{3}','{4}')"
       , customerPriceAuditID, 1, "Outlet Code", "", customer.OutletCode.Replace("'","''"));
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveGroupPriceAudit(int priceListId, CustomerGroupModel group, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int groupPriceAuditID = -1;
                string query = string.Empty;

                groupPriceAuditID = GetMaxID("GroupPriceAuditID", "GroupPriceAudit", dBHelper);
                query = string.Format(@"Insert into GroupPriceAudit (GroupPriceAuditID,PriceListId,GroupID,EmployeeID,ChangeDate,MachineName,ActionID) 
                    values ({0},{1},{2},{3},{4},'{5}',{6})"
              , groupPriceAuditID, priceListId, group.GroupId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), auditAction.GetHashCode());
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;
                query = string.Format(@"Insert into GroupPriceAuditDetails (GroupPriceAuditID,FieldNumber,FieldName,OldValue,NewValue)
                    values ({0},{1},'{2}','{3}','{4}')"
       , groupPriceAuditID, 1, "Group Name", "", !string.IsNullOrEmpty(group.GroupCodeName) ? group.GroupCodeName.Replace("'", "''") : string.Empty);
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveChannelPriceAudit(int priceListId, CustomerChannelModel channel, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int channelPriceAuditID = -1;
                string query = string.Empty;

                channelPriceAuditID = GetMaxID("ChannelPriceAuditID", "ChannelPriceAudit", dBHelper);
                query = string.Format(@"Insert into ChannelPriceAudit (ChannelPriceAuditID,PriceListId,ChannelID,SubChannelID,EmployeeID,ChangeDate,MachineName,ActionID) 
                    values ({0},{1},{2},{3},{4},{5},'{6}',{7})"
              , channelPriceAuditID, priceListId, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1], _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), System.Environment.MachineName.ToString(), auditAction.GetHashCode());
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveSDCPriceAudit(int priceListId, SalesDistributionChannelModel sdc, AuditActions auditAction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int sdcPriceAuditID = -1;
                string query = string.Empty;

                sdcPriceAuditID = GetMaxID("SDCPriceAuditID", "SDCPriceAudit", dBHelper);
                query = $@"INSERT INTO SDCPriceAudit (SDCPriceAuditID, SDCID, PriceListID, EmployeeID, ChangeDate,MachineName, ActionID) VALUES
                    ({sdcPriceAuditID},{sdc.SDCId},{priceListId},{_requestRepository.CurrentOperator.EmployeeId},{LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)} , '{System.Environment.MachineName.ToString()}' , {auditAction.GetHashCode()} )";
                
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;

                query = $@"INSERT INTO SDCPriceAuditDetails (SDCPriceAuditID,FieldNumber, FieldName, OldValue, NewValue) VALUES
                    ({sdcPriceAuditID},{1},'{"SDC NAME"}', '{""}' , '{(!string.IsNullOrEmpty(sdc.SDCCodeName) ? sdc.SDCCodeName.Replace("'", "''") : string.Empty)}')  ";
                
                result = dBHelper.ExecuteNonQuery(query);
                if (result != GlobalErrors.Success) return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedCustomersToPriceList(SimpleCustomerModel customerOutlet, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                string query = string.Format(@"Insert into CustomerPrice (CustomerID,OutletID,PriceListID) values ({0},{1},{2})"
                , customerOutlet.CustomerId, customerOutlet.OutletId, priceListId);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //save in Audit


                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }



        public GlobalErrors InsertAppliedCustomersToPriceListPending(SimpleCustomerModel customerOutlet, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                string query = string.Format(@"Insert into CustomerPrice_Pending (CustomerID,OutletID,PriceListID) values ({0},{1},{2})"
                , customerOutlet.CustomerId, customerOutlet.OutletId, priceListId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedChannelsToPriceList(CustomerChannelModel channel, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Insert into ChannelPrice (ChannelID,SubChannelID,PriceListID) values ({0},{1},{2})"
                , channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1], priceListId);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //save in Audit


                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedChannelsToPriceListPending(CustomerChannelModel channel, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                string query = string.Format(@"Insert into ChannelPrice_Pending (ChannelID,SubChannelID,PriceListID) values ({0},{1},{2})"
                , channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1], priceListId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToPriceList(CustomerGroupModel group, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Insert into GroupPrice (GroupID,PriceListID) values ({0},{1})"
                , group.GroupId, priceListId);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //save in Audit


                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedGroupsToPriceListPending(CustomerGroupModel group, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {

                string query = string.Format(@"Insert into GroupPrice_Pending (GroupID,PriceListID) values ({0},{1})"
                , group.GroupId, priceListId);

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedSDCsToPriceList(SalesDistributionChannelModel sdc, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Insert into SDCPrice (SDCID,PriceListID) values ({0},{1})"
               , sdc.SDCId, priceListId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedSDCsToPriceListPending(SalesDistributionChannelModel sdc, int priceListId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                string query = $@"Insert into SDCPrice_Pending (SDCID, PriceListID) values ({sdc.SDCId}, {priceListId})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeletePriceListItems(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                string query = string.Format(@"delete from  PriceDefinition where PriceDefinitionID={0} and PriceListID={1} ", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //save in Audit
                    List<PriceAuditDetailsModel> auditList = new List<PriceAuditDetailsModel>();
                    PriceAuditDetailsModel data = new PriceAuditDetailsModel();
                    data.AuditId = -1;
                    data.FieldNumber = 1;
                    data.FieldName = "Item";
                    data.OldValue = priceListItemObj.ItemName;
                    data.NewValue = "";
                    auditList.Add(data);
                    result = SavePriceDefnitionAudit(priceListItemObj, auditList, AuditActions.Delete, dBHelper);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeletePriceListItemsPending(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"delete from  PriceDefinition_Pending where PriceDefinitionID={0} and PriceListID={1} ", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId);

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertPriceListItems(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if(dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                priceListItemObj.PriceDefinitionId = GetMaxID("PriceDefinitionID", "PriceDefinition", dBHelper);
                string query = string.Format(@"Insert into PriceDefinition (PriceDefinitionID,PriceListID,QuantityRangeID,PackID,CurrencyID,Tax,Price,ExpiryDate,BatchNo,MinPrice,MaxPrice,NetPrice)
                values({0},{1},{2},{3},{4},{5},{6},{7},'{8}',{9},{10},{11} )", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId, priceListItemObj.QuantityRangeId == -1 ? "Null" : priceListItemObj.QuantityRangeId.ToString()
                , priceListItemObj.PackId, priceListItemObj.CurrencyId, priceListItemObj.Tax, priceListItemObj.Price, priceListItemObj.ExpiryDate == null || priceListItemObj.ExpiryDate == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(priceListItemObj.ExpiryDate.Value),
                priceListItemObj.BatchNo == "" ? "NULL" : priceListItemObj.BatchNo, priceListItemObj.MinPrice, priceListItemObj.MaxPrice, priceListItemObj.NetPrice);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    if (priceListItemObj.TaxTypes != null)
                    {
                        foreach (TaxTypesModel type in priceListItemObj.TaxTypes)
                        {
                            if (type.Tax != 0)
                            {
                                type.PriceListID = priceListItemObj.PriceListId;
                                type.PriceDefinitionID = priceListItemObj.PriceDefinitionId;
                                type.PackID = priceListItemObj.PackId;
                                type.PriceQuantityRangeID = priceListItemObj.QuantityRangeId;
                                result = InsertPriceDefinitionTaxDetails(type, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                            else
                            {
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    //save in Audit
                    result = SavePriceDefnitionAudit(priceListItemObj, priceListItemObj.PriceDefinitionAuditDetails, AuditActions.Add, dBHelper);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertPriceDefinitionTaxDetails(TaxTypesModel taxTypes, DBHelper<int> dBHelper)
        {

            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"insert into PriceDefinitionTaxDetails (PriceListID ,PriceDefinitionID,PackID,TaxTypeId ,Tax,PriceQuantityRangeID)
                    values ({0}, {1}, {2}, {3}, {4}, {5})",
                    taxTypes.PriceListID,//0 
                    taxTypes.PriceDefinitionID,//1 
                    taxTypes.PackID,//2
                    taxTypes.TaxTypeId,//3 
                    taxTypes.Tax,//4
                    taxTypes.PriceQuantityRangeID);

                result = dBHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors InsertPriceDefinitionTaxDetails_Pending(TaxTypesModel taxTypes, DBHelper<int> dBHelper)
        {

            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"insert into PriceDefinitionTaxDetails_Pending (PriceListID ,PriceDefinitionID,PackID,TaxTypeId ,Tax,PriceQuantityRangeID)
                    values ({0}, {1}, {2}, {3}, {4}, {5})",
                    taxTypes.PriceListID,//0 
                    taxTypes.PriceDefinitionID,//1 
                    taxTypes.PackID,//2
                    taxTypes.TaxTypeId,//3 
                    taxTypes.Tax,//4
                    taxTypes.PriceQuantityRangeID);

                result = dBHelper.ExecuteNonQuery(query);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors deletePriceDefinitionTaxDetails_Pending(int PriceListId, DBHelper<int> dBHelper)
        {

            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"delete from PriceDefinitionTaxDetails_Pending where PriceListID = {0}",
                    PriceListId);

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        public GlobalErrors deletePriceDefinitionTaxDetails(int PriceListId, DBHelper<int> dBHelper)
        {

            try
            {
                GlobalErrors result = GlobalErrors.NotInitialized;

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"delete from PriceDefinitionTaxDetails where PriceListID = {0}",
                    PriceListId);

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertPriceListItemsPending(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>(); 
                }
                if (GetMaxID("PriceDefinitionID", "PriceDefinition", dBHelper) > GetMaxID("PriceDefinitionID", "PriceDefinition_Pending", dBHelper))
                {
                    priceListItemObj.PriceDefinitionId = GetMaxID("PriceDefinitionID", "PriceDefinition", dBHelper);
                }
                else
                {
                    priceListItemObj.PriceDefinitionId = GetMaxID("PriceDefinitionID", "PriceDefinition_Pending", dBHelper);
                }
                string query = string.Format(@"Insert into PriceDefinition_Pending (PriceDefinitionID,PriceListID,QuantityRangeID,PackID,CurrencyID,Tax,Price,ExpiryDate,BatchNo,MinPrice,MaxPrice,NetPrice)
                values({0},{1},{2},{3},{4},{5},{6},{7},'{8}',{9},{10},{11} )", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId, priceListItemObj.QuantityRangeId
                , priceListItemObj.PackId, priceListItemObj.CurrencyId, priceListItemObj.Tax, priceListItemObj.Price, priceListItemObj.ExpiryDate == null || priceListItemObj.ExpiryDate == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(priceListItemObj.ExpiryDate.Value),
                priceListItemObj.BatchNo == "" ? "NULL" : priceListItemObj.BatchNo, priceListItemObj.MinPrice, priceListItemObj.MaxPrice, priceListItemObj.NetPrice);

                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    if (priceListItemObj.TaxTypes != null)
                    {
                        foreach (TaxTypesModel type in priceListItemObj.TaxTypes)
                        {
                            if (type.Tax != 0)
                            {
                                type.PriceListID = priceListItemObj.PriceListId;
                                type.PriceDefinitionID = priceListItemObj.PriceDefinitionId;
                                type.PackID = priceListItemObj.PackId;
                                type.PriceQuantityRangeID = priceListItemObj.QuantityRangeId;
                                result = InsertPriceDefinitionTaxDetails_Pending(type, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePriceListItems(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>(); 
                }
                string query = string.Format(@"Update PriceDefinition  set QuantityRangeID={2},PackID={3},CurrencyID={4},Tax={5},Price={6},ExpiryDate={7},BatchNo='{8}',MinPrice={9},MaxPrice={10},NetPrice={11}
                where PriceDefinitionID={0} and PriceListID={1} ", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId, priceListItemObj.QuantityRangeId
                , priceListItemObj.PackId, priceListItemObj.CurrencyId, priceListItemObj.Tax, priceListItemObj.Price, priceListItemObj.ExpiryDate == null || priceListItemObj.ExpiryDate == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(priceListItemObj.ExpiryDate.Value),
                priceListItemObj.BatchNo == "" ? "NULL" : priceListItemObj.BatchNo, priceListItemObj.MinPrice, priceListItemObj.MaxPrice, priceListItemObj.NetPrice);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    if (priceListItemObj.TaxTypes != null)
                    {
                        foreach (TaxTypesModel type in priceListItemObj.TaxTypes)
                        {
                            if (type.Tax != 0)
                            {
                                type.PriceListID = priceListItemObj.PriceListId;
                                type.PriceDefinitionID = priceListItemObj.PriceDefinitionId;
                                type.PackID = priceListItemObj.PackId;
                                type.PriceQuantityRangeID = priceListItemObj.QuantityRangeId;
                                result = InsertPriceDefinitionTaxDetails(type, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    //save in Audit
                    result = SavePriceDefnitionAudit(priceListItemObj, priceListItemObj.PriceDefinitionAuditDetails, AuditActions.Edit, dBHelper);

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdatePriceListItemsPending(PriceListItemsModel priceListItemObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format(@"Update PriceDefinition_Pending  set QuantityRangeID={2},PackID={3},CurrencyID={4},Tax={5},Price={6},ExpiryDate={7},BatchNo='{8}',MinPrice={9},MaxPrice={10},NetPrice={11}
                where PriceDefinitionID={0} and PriceListID={1} ", priceListItemObj.PriceDefinitionId, priceListItemObj.PriceListId, priceListItemObj.QuantityRangeId
                , priceListItemObj.PackId, priceListItemObj.CurrencyId, priceListItemObj.Tax, priceListItemObj.Price, priceListItemObj.ExpiryDate == null || priceListItemObj.ExpiryDate == DateTime.MinValue ? "NULL" : LocalUtilities.ParseDateToSQLString(priceListItemObj.ExpiryDate.Value),
                priceListItemObj.BatchNo == "" ? "NULL" : priceListItemObj.BatchNo, priceListItemObj.MinPrice, priceListItemObj.MaxPrice, priceListItemObj.NetPrice);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    if (priceListItemObj.TaxTypes != null)
                    {
                        foreach (TaxTypesModel type in priceListItemObj.TaxTypes)
                        {
                            if (type.Tax != 0)
                            {
                                type.PriceListID = priceListItemObj.PriceListId;
                                type.PriceDefinitionID = priceListItemObj.PriceDefinitionId;
                                type.PackID = priceListItemObj.PackId;
                                type.PriceQuantityRangeID = priceListItemObj.QuantityRangeId;
                                result = InsertPriceDefinitionTaxDetails_Pending(type, dBHelper);
                                if (result != GlobalErrors.Success) return result;
                            }

                        }
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0)+1 from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }


        public GlobalErrors GetPriceListItems(int priceListId, ref List<PriceListItemsModel> priceListItems)
        {
            DBHelper<PriceListItemsModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceListItemsModel> lists = new List<PriceListItemsModel>();
                dbHelper = new DBHelper<PriceListItemsModel>();
                string query = string.Format(@"select PriceDefinition.*,PriceDefinition.QuantityRangeID OldQuantityRangeID,Item.ItemId,PackTypeLanguage.Description Uom
     ,IsNull( item.ItemCode , '--') + ' - ' + IsNull( ItemLanguage.Description , '--')+ ' ( ' + IsNull( PackTypeLanguage.Description , '--') + ' ) ' as ItemCodeName
  ,IsNull( Currency.Code , '--') + ' - ' + IsNull( CurrencyLanguage.Description , '--') as CurrencyCodeName
,item.ItemCode,ItemLanguage.Description ItemName
 from PriceDefinition 
inner join pack on pack.PackID=PriceDefinition.PacKID
inner join Item on item.ItemID=pack.ItemID
left outer  join Currency on Currency.CurrencyID= PriceDefinition.CurrencyID 
left outer join CurrencyLanguage  on CurrencyLanguage.CurrencyID=Currency.CurrencyID and CurrencyLanguage.LanguageID={0}
left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID={0}
left outer join ItemLanguage on ItemLanguage.ItemID=Item.ItemID and ItemLanguage.LanguageID={0}
where PriceDefinition.PriceListID={1}", _requestRepository.LanguageId, priceListId);
                result = dbHelper.GetQueryList(query, ref priceListItems);
                if (result == GlobalErrors.Success && priceListItems != null && priceListItems.Count > 0 && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    foreach (PriceListItemsModel item in priceListItems)
                    {
                        List<TaxTypesModel> taxTypes = new List<TaxTypesModel>();
                        result = GetPriceDefinitionTaxDetailsForPack(priceListId, item.PackId, ref taxTypes);
                        if (result == GlobalErrors.Success)
                        {
                            item.TaxTypes = taxTypes;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceListItems = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListItemsPending(int priceListId, ref List<PriceListItemsModel> priceListItems, DBHelper<int> dBHelper)
        {
            DBHelper<PriceListItemsModel> dbHelper_PriceListItems = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_PriceListItems = new DBHelper<PriceListItemsModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_PriceListItems = new DBHelper<PriceListItemsModel>();
                }
                List<PriceListItemsModel> lists = new List<PriceListItemsModel>();
                string query = string.Format(@"select PriceDefinition_Pending.*,Item.ItemId,PackTypeLanguage.Description Uom
                    ,IsNull( item.ItemCode , '--') + ' - ' + IsNull( ItemLanguage.Description , '--')+ ' ( ' + IsNull( PackTypeLanguage.Description , '--') + ' ) ' as ItemCodeName
                    ,IsNull( Currency.Code , '--') + ' - ' + IsNull( CurrencyLanguage.Description , '--') as CurrencyCodeName
                    ,item.ItemCode,ItemLanguage.Description ItemName
                    from PriceDefinition_Pending 
                    inner join pack on pack.PackID=PriceDefinition_Pending.PacKID
                    inner join Item on item.ItemID=pack.ItemID
                    left outer  join Currency on Currency.CurrencyID= PriceDefinition_Pending.CurrencyID 
                    left outer join CurrencyLanguage  on CurrencyLanguage.CurrencyID=Currency.CurrencyID and CurrencyLanguage.LanguageID={0}
                    left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID={0}
                    left outer join ItemLanguage on ItemLanguage.ItemID=Item.ItemID and ItemLanguage.LanguageID={0}
                    where PriceDefinition_Pending.PriceListID= {1}", _requestRepository.LanguageId, priceListId);
                result = dbHelper_PriceListItems.GetQueryList(query, ref priceListItems);
                if(result == GlobalErrors.Success && priceListItems != null && priceListItems.Count > 0 && _requestRepository.Configurations.ApplyTaxTypesInPrices)
                {
                    foreach (PriceListItemsModel item in priceListItems)
                    {
                        List<TaxTypesModel> taxTypes = new List<TaxTypesModel>();
                        result = GetPriceDefinitionTaxDetailsPendingForPack(priceListId, item.PackId, ref taxTypes, dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            item.TaxTypes = taxTypes;
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceListItems = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        
        public GlobalErrors GetPriceDefinitionTaxDetailsPendingForPack(int PriceListId,int PackId , ref List<TaxTypesModel> TaxTypes, DBHelper<int> dBHelper)
        {
            DBHelper<TaxTypesModel> dbHelper_TaxTypes = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_TaxTypes = new DBHelper<TaxTypesModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_TaxTypes = new DBHelper<TaxTypesModel>();
                }
                string query = string.Format(@"
                    SELECT TaxType.TaxTypeId, TaxTypeLanguage.LanguageID, TaxTypeLanguage.Description AS TaxTypeName, 
                    CASE ISNULL(PriceDefinitionTaxDetails_Pending.Tax, 0) WHEN 0 THEN 0 ELSE PriceDefinitionTaxDetails_Pending.Tax END AS Tax, 
                    CASE WHEN PriceDefinitionTaxDetails_Pending.Tax >= 0 THEN 1 ELSE 0 END AS IsPlusValue
                    FROM TaxType left JOIN
                    TaxTypeLanguage ON TaxType.TaxTypeId = TaxTypeLanguage.TaxTypeId AND TaxTypeLanguage.LanguageID = {0} LEFT OUTER JOIN
                    PriceDefinitionTaxDetails_Pending ON PriceDefinitionTaxDetails_Pending.TaxTypeId = TaxType.TaxTypeId 
                    AND PriceDefinitionTaxDetails_Pending.PriceListID = {1} 
                    AND PriceDefinitionTaxDetails_Pending.PackID = {2}", _requestRepository.LanguageId, PriceListId, PackId);
                result = dbHelper_TaxTypes.GetQueryList(query, ref TaxTypes);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                TaxTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceDefinitionTaxDetailsForPack(int PriceListId, int PackId, ref List<TaxTypesModel> TaxTypes)
        {
            DBHelper<TaxTypesModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<PriceListItemsModel> lists = new List<PriceListItemsModel>();
                dbHelper = new DBHelper<TaxTypesModel>();
                string query = string.Format(@"SELECT TaxType.TaxTypeId, TaxTypeLanguage.LanguageID, TaxTypeLanguage.Description AS TaxTypeName, 
                    CASE ISNULL(PriceDefinitionTaxDetails.Tax, 0) WHEN 0 THEN 0 ELSE PriceDefinitionTaxDetails.Tax END AS Tax, 
                    CASE WHEN PriceDefinitionTaxDetails.Tax >= 0 THEN 1 ELSE 0 END AS IsPlusValue
                    FROM TaxType left JOIN
                    TaxTypeLanguage ON TaxType.TaxTypeId = TaxTypeLanguage.TaxTypeId AND TaxTypeLanguage.LanguageID = {0} LEFT OUTER JOIN
                    PriceDefinitionTaxDetails ON PriceDefinitionTaxDetails.TaxTypeId = TaxType.TaxTypeId 
                    AND PriceDefinitionTaxDetails.PriceListID = {1} 
                    AND PriceDefinitionTaxDetails.PackID = {2}", _requestRepository.LanguageId, PriceListId, PackId);
                result = dbHelper.GetQueryList(query, ref TaxTypes);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                TaxTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListTypes(ref List<PriceListTypesModel> priceListTypes)
        {
            DBHelper<PriceListTypesModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PriceListTypesModel>();
                string query = string.Format(@"select PriceListType.PriceListTypeID ,PriceListTypeLanguage.Description PriceListTypeName from PriceListType
inner join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceListType.PriceListTypeID
and PriceListTypeLanguage.LanguageID={0} and PriceListType.PriceListTypeID not in ({1},{2},{3})"
, _requestRepository.LanguageId, PriceListTypes.PointsOnReturn.GetHashCode(), PriceListTypes.PurchaseOrder.GetHashCode(), PriceListTypes.BatchLevel.GetHashCode());
                result = dbHelper.GetQueryList(query, ref priceListTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceListTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPriceListHeader(int priceListID, ref PriceListModel priceList)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<PriceListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                dBHelper_Languages = new DBHelper<TextLanguage>();
                dBHelper = new DBHelper<PriceListModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList.*,PriceListLanguage.Description PriceListName,
PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName from PriceList
left outer join PriceListLanguage on PriceListLanguage.PriceListID=PriceList.PriceListID and PriceListLanguage.LanguageID={0}
left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList.OrganizationID and OrganizationLanguage.LanguageID={0}
where PriceList.PriceListID={1} ", _requestRepository.LanguageId, priceListID);
                result = dBHelper.GetQuerySingle(query, ref priceList);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from PriceListLanguage where PriceListID={0}", priceListID);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        priceList.PriceListDescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListHeaderPending(int priceListID, ref PriceListModel priceList)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<PriceListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                dBHelper_Languages = new DBHelper<TextLanguage>();
                dBHelper = new DBHelper<PriceListModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                int currentStatus = GetCurrentStatus();
                query = string.Format(@"Select PriceList_Pending.*,PriceListLanguage_Pending.Description PriceListName,
PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName,
 CASE WHEN  PriceList_Pending.CreationLevel = {2}  THEN 1 ELSE 0 END AS IsCreationLevel from PriceList_Pending
left outer join PriceListLanguage_Pending on PriceListLanguage_Pending.PriceListID=PriceList_Pending.PriceListID and PriceListLanguage_Pending.LanguageID={0}
left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList_Pending.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList_Pending.OrganizationID and OrganizationLanguage.LanguageID={0}
where PriceList_Pending.PriceListID={1}", _requestRepository.LanguageId, priceListID, currentStatus);
                result = dBHelper.GetQuerySingle(query, ref priceList);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from PriceListLanguage_Pending where PriceListID={0}", priceListID);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        priceList.PriceListDescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceList(int priceListID, ref PriceListModel priceList, DBHelper<int> dBHelper)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<PriceListModel> dBHelper_PriceList = null;

            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    dBHelper_PriceList = new DBHelper<PriceListModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>();
                    dBHelper_PriceList = new DBHelper<PriceListModel>();
                }
                string query = string.Empty;
          
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList.*,PriceListLanguage.Description PriceListName
,PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName from PriceList
left outer join PriceListLanguage on PriceListLanguage.PriceListID=PriceList.PriceListID and PriceListLanguage.LanguageID={0}
left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList.OrganizationID and OrganizationLanguage.LanguageID={0}
where PriceList.PriceListID={1} ", _requestRepository.LanguageId, priceListID);
                result = dBHelper_PriceList.GetQuerySingle(query, ref priceList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListPending(int priceListID, ref PriceListModel priceList)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<PriceListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                dBHelper_Languages = new DBHelper<TextLanguage>();
                dBHelper = new DBHelper<PriceListModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList_Pending.*,PriceListLanguage_Pending.Description PriceListName
,PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName from PriceList_Pending
left outer join PriceListLanguage_Pending on PriceListLanguage_Pending.PriceListID=PriceList_Pending.PriceListID and PriceListLanguage_Pending.LanguageID={0}
left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList_Pending.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList_Pending.OrganizationID and OrganizationLanguage.LanguageID={0}
where PriceList_Pending.PriceListID={1} ", _requestRepository.LanguageId, priceListID);
                result = dBHelper.GetQuerySingle(query, ref priceList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetPriceListDataPending(int priceListID, ref PriceListModel priceList, DBHelper<int> dBHelper)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<PriceListModel> dBHelper_PriceList = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    dBHelper_PriceList = new DBHelper<PriceListModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>();
                    dBHelper_PriceList = new DBHelper<PriceListModel>();
                }
                string query = string.Empty;
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList_Pending.*,PriceListLanguage_Pending.Description PriceListName
                ,PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName 
				from PriceList_Pending
                left outer join PriceListLanguage_Pending on PriceListLanguage_Pending.PriceListID=PriceList_Pending.PriceListID and PriceListLanguage_Pending.LanguageID={0}
                left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList_Pending.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList_Pending.OrganizationID and OrganizationLanguage.LanguageID={0}
                where PriceList_Pending.PriceListID={1}  ", _requestRepository.LanguageId, priceListID);
                result = dBHelper_PriceList.GetQuerySingle(query, ref priceList);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from PriceListLanguage_Pending where PriceListID={0}", priceListID);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        priceList.PriceListDescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public bool CheckIsPriceListExisit(int priceListID)
        {
            DBHelper<PriceListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            PriceListModel priceList = new PriceListModel();
            try
            {
                string query = string.Empty;
                dBHelper = new DBHelper<PriceListModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList.*,PriceListLanguage.Description PriceListName
                    ,PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName from PriceList
                    left outer join PriceListLanguage on PriceListLanguage.PriceListID=PriceList.PriceListID and PriceListLanguage.LanguageID={0}
                    left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
                    left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList.OrganizationID and OrganizationLanguage.LanguageID={0}
                    where PriceList.PriceListID={1} ", _requestRepository.LanguageId, priceListID);
                result = dBHelper.GetQuerySingle(query, ref priceList);
                if (result == GlobalErrors.Success && priceList != null)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return false;
            }
        }

        public bool CheckIsPriceListPendingExisit(int priceListID)
        {
           
            DBHelper<PriceListModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            PriceListModel priceList = new PriceListModel();
            try
            {
                string query = string.Empty;
                dBHelper = new DBHelper<PriceListModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select PriceList_Pending.*,PriceListLanguage_Pending.Description PriceListName
                    ,PriceListTypeLanguage.Description PriceListType,OrganizationLanguage.Description OrganizationName from PriceList_Pending
                    left outer join PriceListLanguage_Pending on PriceListLanguage_Pending.PriceListID=PriceList_Pending.PriceListID and PriceListLanguage_Pending.LanguageID={0}
                    left outer join PriceListTypeLanguage on PriceListTypeLanguage.PriceListTypeID=PriceList_Pending.PriceListTypeID and PriceListTypeLanguage.LanguageID={0}
                    left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=PriceList_Pending.OrganizationID and OrganizationLanguage.LanguageID={0}
                    where PriceList_Pending.PriceListID={1} ", _requestRepository.LanguageId, priceListID);
                result = dBHelper.GetQuerySingle(query, ref priceList);
                if (result == GlobalErrors.Success && priceList != null)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                priceList = null;
                return false;
            }
        }
        public GlobalErrors CheckAllowEditPromotionByOrgAccess(int CreatedBy, ref bool isValid)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            DBHelper<OrganizationModel> organizationDBHelper = null;
            OrganizationModel organization = new OrganizationModel();
            List<int> listOfParentsOrgs = new List<int>();
            try
            {
                dBHelper = new DBHelper<int>();
                organizationDBHelper = new DBHelper<OrganizationModel>();
                long promotionCreatedBy = CreatedBy;

                if (promotionCreatedBy == _requestRepository.CurrentOperator.EmployeeId)
                {
                    isValid = true;
                    return GlobalErrors.Success;
                }
                    

                string query = string.Format(@"Select Organization.OrganizationID, Organization.ParentOrganizationID from Employee 
                INNER JOIN Organization on Organization.OrganizationID = Employee.OrganizationID
                WHERE EmployeeID = {0} ", promotionCreatedBy);
                result = organizationDBHelper.GetQuerySingle(query, ref organization);
                if (result == GlobalErrors.Success && organization != null)
                {
                    // When login employee Organization equal promotion Organization
                    if (organization.OrganizationId != -1 && organization.OrganizationId == _requestRepository.CurrentOperator.OrganizationId)
                    {
                        isValid = true;
                        return GlobalErrors.Success;
                    }

                    // When login employee parent Organization equal promotion Organization
                    if (organization.ParentOrganizationID != -1)
                    {
                        if (organization.ParentOrganizationID == _requestRepository.CurrentOperator.OrganizationId)
                        {
                            isValid = true;
                            return GlobalErrors.Success;
                        }
                        // check if the parents for login employee = parent of promotion
                        query = string.Format(@"
                            Declare @OrgId int = {0};
                            Declare @OrganizationTemp Table (OrganizationID int);
                            While Exists (Select ParentOrganizationID From Organization Where OrganizationID = @OrgId)
                            BEGIN
                            Select @OrgId = ParentOrganizationID From Organization Where OrganizationID = @OrgId 
                            Insert into  @OrganizationTemp values(@OrgId) 
                            End

                            select * from @OrganizationTemp where OrganizationID is not null  ", organization.ParentOrganizationID);
                        result = dBHelper.GetQueryList(query, ref listOfParentsOrgs);
                        if(result == GlobalErrors.Success && listOfParentsOrgs != null && listOfParentsOrgs.Count > 0)
                        {
                            if(listOfParentsOrgs.Where(x=>x == _requestRepository.CurrentOperator.OrganizationId).ToList().Count > 0)
                            {
                                isValid = true;
                                return GlobalErrors.Success;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            isValid = false;
            return result;
        }

        public GlobalErrors DeletePriceList(int priceListID, DBHelper<int> dBHelper)
        {

            GlobalErrors result = GlobalErrors.Error;
            string queryString = string.Empty;
            try
            {

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                object priceListName = null;
                queryString = string.Format("Delete from CustomerPrice  where PriceListID = {0} ", priceListID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {    
                    queryString = string.Format("Delete from GroupPrice  where PriceListID= {0} ", priceListID);   
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        queryString = string.Format("Delete from ChannelPrice  where PriceListID= {0} ", priceListID);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            queryString = string.Format("Delete from SDCPrice  where PriceListID= {0} ", priceListID);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                if (_requestRepository.Configurations.ApplyTaxTypesInPrices)
                                {
                                    result = deletePriceDefinitionTaxDetails(priceListID, dBHelper);
                                }
                                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    queryString = string.Format("Update PriceList  Set IsDeleted = 1 where PriceListID= {0}", priceListID);
                                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                                    if (result == GlobalErrors.Success)
                                    {
                                        queryString = string.Format("Select Description from PriceListLanguage where pricelistID={0} and LanguageID={1}", priceListID, _requestRepository.LanguageId);
                                        result = dBHelper.ExecuteScalar(queryString, ref priceListName);
                                        if (result != GlobalErrors.Success) return result;
                                        List<PriceAuditDetailsModel> auditList = new List<PriceAuditDetailsModel>();
                                        PriceAuditDetailsModel data = new PriceAuditDetailsModel();
                                        data.AuditId = -1;
                                        data.FieldNumber = 1;
                                        data.FieldName = "Description";
                                        data.OldValue = priceListName != null ? priceListName.ToString() : "";
                                        data.NewValue = "";
                                        auditList.Add(data);
                                        //Why??
                                        // DummyPriceList(-1);
                                        result = SavePriceListAudit(priceListID, auditList, AuditActions.Delete, dBHelper);
                                    }
                                }

                            }
                        }
                    }
                }

            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
          
            return result;
        }
        public int GetCurrentStatus()
        {
            int status = 0;
            DBHelper<int> dBHelper = new DBHelper<int>();
            GlobalErrors result = GlobalErrors.NotInitialized;

            if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("4"))
            {
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetCurrentOperationStatus(ApprovalCycleOperations.Price.GetHashCode(), ref status, dBHelper);
            }
            else if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("5"))
            {
                SettingManager settingManager = new SettingManager(_requestRepository);
                result = settingManager.GetCurrentOperationStatus(ApprovalCycleOperations.ContractedFOC.GetHashCode(), ref status, dBHelper);
            }
            else
            {
                status = -1;
            }
            return status;
        }

        public GlobalErrors GetPriceListStatus(int priceListID, ref int status, ref bool isDeleted)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            
            DBHelper<PriceListModel> dBHelper;
            string query = string.Empty;
            PriceListModel priceListModel = new PriceListModel();
            try
            {
                priceListModel = new PriceListModel();
                dBHelper = new DBHelper<PriceListModel>();
                bool flag = CheckIsPriceListPendingExisit(priceListID);
                if (flag)
                {
                    query = string.Format("SELECT * FROM PriceList_Pending WHERE (PriceListID = {0})", priceListID);
                }
                else
                {
                    query = string.Format("SELECT * FROM PriceList WHERE (PriceListID = {0})", priceListID);
                }
                result = dBHelper.GetQuerySingle(query, ref priceListModel);
                if (result == GlobalErrors.Success && priceListModel != null)
                {
                    status = priceListModel.Status > 0 ? priceListModel.Status : -1;
                    isDeleted = priceListModel.IsDeleted;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }

        }

        public int GetMaxApprovalCycleLevels(int OperationID)
        {
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                object maxLevel = 0;
                string query = string.Format("select top 1(LevelID) from ApprovalCycleLevels where OperationID = {0} order by LevelID desc", OperationID);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref maxLevel);
                if(result == GlobalErrors.Success && maxLevel != null)
                {
                    return (int)maxLevel;
                }
                else
                {
                    return -1;
                }
                return 0;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return 0;
            }

        }

        public GlobalErrors GetTaxTypes(ref List<TaxTypesModel> TaxTypes)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TaxTypesModel> dBHelper;
            try
            {
                dBHelper = new DBHelper<TaxTypesModel>();
                string query = string.Format(@"SELECT TaxType.TaxTypeId, TaxTypeLanguage.LanguageID, TaxTypeLanguage.Description TaxTypeName, 0 as Tax, 'true' as IsPlusValue
                    FROM TaxType left JOIN
                    TaxTypeLanguage ON TaxType.TaxTypeId = TaxTypeLanguage.TaxTypeId 
                    and TaxTypeLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref TaxTypes);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }

        }

        #endregion

        #region Discount

        public GlobalErrors GetDiscounts(GeneralFilter filter, ref SharedTableResult<DiscountModel> discounts)
        {
            DBHelper<DiscountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<DiscountModel> lists = new List<DiscountModel>();
                dbHelper = new DBHelper<DiscountModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string baseCurrency = string.Empty; 
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( (DiscountLanguage.Description LIKE '%{0}%')
                    OR ( DiscountCode LIKE '%{0}%'))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " and (Discount.Inactive = 0 OR Discount.Inactive is null)";
                    }
                    if (!string.IsNullOrEmpty(filter.OrganizationId.ToString()) && filter.OrganizationId > -1)
                    {
                        searchFilter += string.Format(@" And  Discount.OrganizationID ={0}", filter.OrganizationId);
                    }
                    if (!string.IsNullOrEmpty(filter.DivisionId.ToString()) && filter.DivisionId > -1)
                    {
                        searchFilter += string.Format(@" And  Discount.DivisionID ={0}", filter.DivisionId);
                    }
                    if (!string.IsNullOrEmpty(filter.PackGroupId.ToString()) && filter.PackGroupId > -1)
                    {
                        searchFilter += string.Format(@" And  Discount.PackGroupID ={0}", filter.PackGroupId);
                    }
                    if (!string.IsNullOrEmpty(filter.PackId.ToString()) && filter.PackId > -1)
                    {
                        searchFilter += string.Format(@" And  Discount.PackID ={0}", filter.PackId);
                    }
                    if (!string.IsNullOrEmpty(filter.groupId.ToString()) && filter.groupId > -1)
                    {
                        searchFilter += string.Format(@" And  DiscountAssignment.CustomerGroupID ={0}", filter.groupId);
                    }
                    if (!string.IsNullOrEmpty(filter.CustomerId.ToString()) && filter.CustomerId > -1)
                    {
                        searchFilter += string.Format(@" And  DiscountAssignment.CustomerID ={0}", filter.CustomerId);
                    }
                    if (!string.IsNullOrEmpty(filter.OutletId.ToString()) && filter.OutletId > -1)
                    {
                        searchFilter += string.Format(@" And  DiscountAssignment.OutletID ={0}", filter.OutletId);
                    }
                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" And  Discount.StartDate<={0} ",
                            LocalUtilities.ParseEndDateToSQLString(filter.DateModel.Date));
                    }

                    if (filter.ToDate != null )
                    {
                        searchFilter += string.Format(" And Discount.EndDate>={0}",
                            LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                    }

                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By tt.StartDate desc");
                    }
                    else
                    {
                        if (filter.CustomListFilter.SortBy == "amountString")
                            filter.CustomListFilter.SortBy = "amount";
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }

                if(_requestRepository.Configurations.ApplyCurrencyPerOrganization)
                {
                    baseCurrency = $"SELECT top 1 Code FROM  Currency WHERE (Base = 1 and OrganizationID = Discount.OrganizationId)";
                }
                else
                {
                    baseCurrency = $"SELECT top 1 Code FROM  Currency WHERE (Base = 1)";
                }
                string mainQuery = string.Format(@" LEFT JOIN Pack ON Discount.PackID=Pack.PackID 
                                    LEFT JOIN Item ON Pack.ItemID=Item.ItemID 
                                    LEFT JOIN ItemLanguage ON Pack.ItemID=ItemLanguage.ItemID AND ItemLanguage.LanguageID= {0}
                                    LEFT JOIN PackGroup ON Discount.PackGroupID=PackGroup.PackGroupID 
                                    LEFT JOIN PackGroupLanguage ON PackGroup.PackGroupID=PackGroupLanguage.PackGroupID AND PackGroupLanguage.LanguageID= {0}
                                    LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID=Pack.PackTypeID AND PackTypeLanguage.LanguageID= {0}
                                    left join OrganizationLanguage on OrganizationLanguage.OrganizationID=Discount.OrganizationID and OrganizationLanguage.LanguageID={0}
                                    left join DiscountPlanDetails on discount.DiscountID=DiscountPlanDetails.DiscountID
                                    left join DiscountAssignment on discount.DiscountID=DiscountAssignment.Discountid
                                    left join DiscountLanguage on DiscountLanguage.DiscountID=Discount.DiscountID and DiscountLanguage.LanguageID={0}
                                    left join Division on Division.DivisionID=Discount.DivisionID 
                                    left join DivisionLanguage on DivisionLanguage.DivisionID=Discount.DivisionID and DivisionLanguage.languageID={0} 
                                    WHERE (Discount >= 0 and Discount.OrganizationID in({1}) and DiscountPlanDetails.DiscountPlanID is null)",
                                    _requestRepository.LanguageId,//0
                                    _requestRepository.CurrentOperator.OrganizationAccess///1
                                    );

                string allDataQuery = string.Format(@"
                                     Select ROW_NUMBER() Over(Order By tt.DiscountId) AS RowSeq,*
                                      from (select distinct Discount.DiscountID AS DiscountId
                                     , DiscountLanguage.Description As DiscountName
                                     , IsNull(DiscountLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( Discount.DiscountCode , '--') as DiscountNameCode
                                     , Discount.DiscountCode 
                                     , Discount.DiscountTypeId
                                     , Discount.TypeId
                                     , Discount.Status
                                     , case when Discount.TypeID = 1 then (convert(varchar(50),CAST(Discount.Discount as numeric(19,{11})) ) + ' ' + (case when Discount.DiscountTypeID = 1 then '%'
	                                        when Discount.DiscountTypeID = 2 then ({17}) End ))
                                            when Discount.TypeID = 2 then (convert(varchar(50) , CAST(Discount.FOC as numeric(19,{11})))) + ' ' + '%'
                                            when Discount.TypeID = 5 then (convert(varchar(50) , CAST(Discount.Discount as numeric(19,6)))) + ' ' + '%' End AmountString 
                                     , case when Discount.TypeID = 1 then Discount.Discount
                                            when Discount.TypeID = 2 then Discount.FOC
                                            when Discount.TypeID = 5 then Discount.Discount End Amount
                                     , case when Discount.AllItems = 1  then '{0}'
                                            when IsNull( Discount.PackID , -1) <> -1  then '{1}' + ' (' + ItemLanguage.Description + '-' + PackTypeLanguage.Description + ')'
	                                        when IsNull( Discount.PackGroupID , -1) <> -1  then '{2}' + ' (' + PackGroupLanguage.Description + ')'
		                                    when IsNull( Discount.DivisionID  , -1) <> -1  then '{3}' + ' (' + DivisionLanguage.Description + ')'  End AppliedOn
                                     , case when Discount.AllItems = 1  then 4
                                            when IsNull( Discount.PackID , -1) <> -1  then 1
	                                        when IsNull( Discount.PackGroupID , -1) <> -1  then 2
		                                    when IsNull( Discount.DivisionID  , -1) <> -1  then 3  End AppliedOnId
		                             , case when Discount.TypeID = 1 then '{4}'
		                 					when Discount.TypeID = 2 then '{5}' 
                                            when Discount.TypeID = 5 then '{18}' End TypeName
	                                 , Item.ItemId
                                     , Item.ItemCode AS ItemCode
                                     , ItemLanguage.Description AS ItemName
	                                 , Discount.PackId
                                     , PackTypeLanguage.Description AS UOM
	                                 , Discount.PackgroupId
	                                 , PackGroupLanguage.Description AS PackGroup
	                                 , Discount.DivisionId
                                     , Division.DivisionCode
	                                 , DivisionLanguage.Description AS Division
	                                 , Discount.StartDate
                                     , Discount.EndDate
	                                 , Discount.OrganizationId
                                     , Case IsNull(Discount.Status,-1) when -1 then 0 else 1 end as IsPending
                                     , OrganizationLanguage.Description As Organization
                                     , Discount.Inactive
                                     , isNull(DiscountAssignment.AllCustomers,0) AllCustomers
                                     , Case Discount.inactive when 1 then '{16}' else (Case IsNull(Discount.Status,-1)  when -1 then '{14}' else CONCAT('{15}', Discount.Status) end) end as DiscountStatusName
                                     , OfferAppliedOptions
                                     , IsRange
                                     , FromValue
                                     , ToValue
                                     , SalesOrderTypeID
                                     , Priority
                                    From Discount 
                                    {6}
                                    {7} 
                                     ) tt
                                    {8} 
                                    OFFSET  {9} ROWS       
                                    FETCH NEXT {10} ROWS ONLY",
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_All_Items,_requestRepository.LanguageId),//0
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Item,_requestRepository.LanguageId),//1
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Group,_requestRepository.LanguageId),//2
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Division,_requestRepository.LanguageId),//3
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Discount,_requestRepository.LanguageId),//4
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_FOC,_requestRepository.LanguageId),//5
                                    mainQuery,//6
                                    searchFilter,//7
                                    orderByFilter,//8
                                   (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//9
                                   filter.CustomListFilter.PageSize,//10 
                                   _requestRepository.Configurations.NumberOfDigits, // 11
                                   ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive,_requestRepository.LanguageId), // 12
                                    ResourcesManager.TranslateKey(MessagesConstants.Desc_Active,_requestRepository.LanguageId), // 13
                                     ResourcesManager.TranslateKey("Desc_Active", _requestRepository.LanguageId),//14
                                     ResourcesManager.TranslateKey("Desc_Waiting_For_Approval", _requestRepository.LanguageId),//15
                                     ResourcesManager.TranslateKey("Desc_Inactive", _requestRepository.LanguageId),//16
                                     baseCurrency, //17
                                     ResourcesManager.TranslateKey(CaptionsConstants.Desc_Price_Discount, _requestRepository.LanguageId) // 18
                                   );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from (select distinct Discount.*  From discount {0} {1})tt ",
                                             mainQuery,
                                             searchFilter);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    discounts.TotalItems = int.Parse(objField.ToString().Trim());
                    if (discounts.TotalItems <= 0)
                    {
                        discounts.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists , true);
                discounts.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                discounts = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountTypes(ref List<DiscountTypesModel> discountTypes)
        {
            DBHelper<DiscountTypesModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<DiscountTypesModel>();
                string query = string.Format(@"select DiscountType.DiscountTypeID DiscountTypeId ,DiscountTypeLanguage.Description DiscountTypeName from DiscountType
                inner join DiscountTypeLanguage on DiscountTypeLanguage.DiscountTypeID=DiscountType.DiscountTypeID
                and DiscountTypeLanguage.LanguageID={0} where DiscountType.DiscountTypeID in (1,2)", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref discountTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                discountTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSalesOrderTypes(ref List<DiscountModel> salesOrderTypes)
        {
            DBHelper<DiscountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<DiscountModel>();
                string query = string.Format(@"select SalesOrderType.SalesOrderTypeID, IsNull( SalesOrderType.TypeCode , '--') + ' - ' + IsNull( SalesOrderTypeLanguage.Description, '--') SalesOrderTypeName from SalesOrderType
                INNER JOIN SalesOrderTypeLanguage ON SalesOrderType.SalesOrderTypeid = SalesOrderTypeLanguage.SalesOrderTypeid WHERE SalesOrderTypeLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref salesOrderTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                salesOrderTypes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountDescriptions(int discountId, bool isClone, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from DiscountLanguage
                where DiscountLanguage.DiscountID={0}", discountId);
                result = dbHelper.GetQueryList(query, ref descriptions);

                if (result == GlobalErrors.Success && descriptions != null && isClone)
                {
                    descriptions.ForEach(description =>
                    {
                        description.Description = ResourcesManager.TranslateKey(MessagesConstants.Desc_Copied_From, _requestRepository.LanguageId) + " " + description.Description;
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountAppliedChannels(int discountId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"select DiscountAssignment.DiscountID ,DiscountAssignment.ChannelID, DiscountAssignment.SubChannelID,
                               (CONVERT(varchar(10),DiscountAssignment.ChannelID) + '-' + CONVERT(varchar(10),DiscountAssignment.SubChannelID)) ChannelSubChannelIds ,
                               (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                from DiscountAssignment
                                Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = DiscountAssignment.ChannelID and ChannelLanguage.LanguageID = {1}
                                left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = DiscountAssignment.SubChannelID and SubChannelLanguage.LanguageID = {1}
                                where DiscountAssignment.DiscountID={0}", discountId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountAppliedGroups(int discountId, ref List<CustomerGroupModel> appliedGroups)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                dbHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"select DiscountAssignment.DiscountID ,DiscountAssignment.CustomerGroupID GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                from DiscountAssignment
                                inner join CustomerGroup on CustomerGroup.GroupID=DiscountAssignment.CustomerGroupID {2}
                                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                where DiscountAssignment.DiscountID={0}", discountId, _requestRepository.LanguageId, orgAccess);
                result = dbHelper.GetQueryList(query, ref appliedGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountAppliedCustomers(int discountId, ref List<SimpleCustomerModel> appliedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Format(@"
                select distinct DiscountAssignment.DiscountID ,DiscountAssignment.CustomerID ,DiscountAssignment.OutletID ,
                Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                from DiscountAssignment
                inner join Customer on Customer.CustomerID=DiscountAssignment.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID=DiscountAssignment.CustomerID and CustomerOutlet.OutletID=DiscountAssignment.OutletID 
                left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                and CustomerLanguage.OrganizationId in ({3})
                left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                and CustomerOutletLanguage.LanguageID={1}
                {2}
                where DiscountAssignment.DiscountID={0}", discountId,
                _requestRepository.LanguageId,
                 orgAccessJoin,
                 _requestRepository.CurrentOperator.OrganizationAccess
                 );
                result = dbHelper.GetQueryList(query, ref appliedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDiscountAppliedSDCs(int discountId, ref List<SalesDistributionChannelModel> sdcsList)
        {
            DBHelper<SalesDistributionChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SalesDistributionChannelModel>();
                string query = $@"Select DISTINCT DiscountAssignment.SDCID, SDC.SDCCode,
                        SDCLanguage.Description SDCDescription,
                        IsNull(SDC.SDCCode , '--') + ' ' + '-'+ ' ' + IsNull( SDCLanguage.Description , '--') as SDCCodeName,
                        --STRING_AGG(SDCOrganization.OrganizationID,',')  as OrganizationIds
                        SDCOrganization.OrganizationID
                        from DiscountAssignment
                        INNER JOIN SDC on SDC.SDCID = DiscountAssignment.SDCID
                        INNER JOIN SDCOrganization ON SDCOrganization.SDCID = DiscountAssignment.SDCID AND SDCOrganization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                        LEFT OUTER JOIN SDCLanguage on SDCLanguage.SDCID = DiscountAssignment.SDCID AND SDCLanguage.LanguageID = {_requestRepository.LanguageId}
                        WHERE DiscountAssignment.DiscountID = {discountId}
                        --Group by DiscountAssignment.SDCID, SDC.SDCCode, SDCLanguage.Description";
                result = dbHelper.GetQueryList(query, ref sdcsList);
                if (result == GlobalErrors.Success && sdcsList != null && sdcsList.Count > 0)
                {
                    sdcsList = sdcsList.GroupBy(ch => ch.SDCId).Select(grp => new SalesDistributionChannelModel
                    {
                        SDCId = grp.Key,
                        SDCCode = grp.FirstOrDefault().SDCCode,
                        SDCDescription = grp.FirstOrDefault().SDCDescription,
                        SDCCodeName = grp.FirstOrDefault().SDCCodeName,
                        OrganizationIds = string.Join(',', grp.Select(el => el.OrganizationId).ToList()),
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertDiscount(DiscountModel discountObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                discountObj.DiscountId = GetMaxID("DiscountID", "Discount", dBHelper);
                dBHelper.BeginTransaction();
                #region[Get Discount Status]
                int status = 0;
                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("2"))
                {
                    SettingManager settingManager = new SettingManager(_requestRepository);
                    result = settingManager.GetCurrentOperationStatus(ApprovalCycleOperations.Discounts.GetHashCode(), ref status, dBHelper);
                }
                else
                {
                    status = -1;
                }
                discountObj.Status = status;
                #endregion
                string query = string.Format(@"Insert into Discount (DiscountID,PackID,PackGroupID,AllItems,Discount,FOC,StartDate,EndDate,DiscountTypeID,OrganizationID,
                               DiscountCode,TypeID,DivisionID,Inactive,CreatedBy,CreatedDate,UpdatedBy,UpdatedDate,status,OfferAppliedOptions,IsRange,FromValue,ToValue,SalesOrderTypeID,Priority)
                values({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},'{10}',{11},{12},{13},{14},{15},{16},{17},{18},'{19}',{20},{21},{22},{23},{24})",
                discountObj.DiscountId, //0
                discountObj.PackId, //1
                discountObj.PackGroupId,//2
                discountObj.AllItems ? "1" : "0",//3
                discountObj.TypeId == DiscountFOC.Discount.GetHashCode() || discountObj.TypeId == DiscountTypes.PriceDiscount.GetHashCode() ? discountObj.Amount : 0,//4
                discountObj.TypeId == DiscountFOC.FOC.GetHashCode() ? discountObj.Amount : 0,//5
                LocalUtilities.ParseDateToSQLString(discountObj.StartDate.Value),//6
                LocalUtilities.ParseDateToSQLString(discountObj.EndDate.Value),//7
                discountObj.DiscountTypeId,//8
                _requestRepository.CurrentOperator.OrganizationId,//9
                discountObj.DiscountCode.Replace("'", "''"),//10
                discountObj.TypeId,//11
                discountObj.DivisionId,//12
                discountObj.Inactive ? "1" : "0",//13
                _requestRepository.CurrentOperator.EmployeeId, //14
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //15
                _requestRepository.CurrentOperator.EmployeeId, //16
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//17
                status, //18
                discountObj.OfferAppliedOptions, //19
                discountObj.IsRange ? "1" : "0", //20
                discountObj.IsRange == false ?  -1: discountObj.FromValue,//21
                discountObj.IsRange == false ?  -1 : discountObj.ToValue, //22
                discountObj.SalesOrderTypeId, //23
                discountObj.Priority // 24
                );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    string defaultDescription = discountObj.DiscountDescriptionLanguages[1].Description;
                    foreach (TextLanguage language in discountObj.DiscountDescriptionLanguages)
                    {
                        string description = !string.IsNullOrEmpty(language.Description) ? language.Description.Replace("'", "''") : defaultDescription.Replace("'", "''");

                        query = string.Format(@"insert into DiscountLanguage (DiscountId,LanguageId,Description) values ({0},{1},'{2}')", discountObj.DiscountId, language.LanguageId, description);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }

                    int discountAssignmentID = GetMaxID("DiscountAssignmentID", "DiscountAssignment", dBHelper);
                    //Save applied customer
                    result = InsertDiscountAssignment(discountObj, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors UpdateDiscount(DiscountModel discountObj)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                string query = string.Format(@"Update Discount set DiscountCode='{0}',TypeID = {1},StartDate={2},EndDate={3},AllItems = {4},
                               PackID = {5}, PackGroupID={6},FOC = {7}, Discount = {8},DiscountTypeID = {9},OrganizationID = {10},DivisionID = {11},
                               Inactive = {12}, UpdatedBy = {13}, UpdatedDate = {14}, OfferAppliedOptions = '{15}', IsRange= {17} , FromValue={18} , ToValue = {19}, SalesOrderTypeID = {20}, Priority = {21}  where discountID = {16}",
                                discountObj.DiscountCode.Replace("'", "''"),// 0
                                discountObj.TypeId, //1
                                LocalUtilities.ParseDateToSQLString(discountObj.StartDate.Value), //2
                                LocalUtilities.ParseDateToSQLString(discountObj.EndDate.Value),//3
                                discountObj.AllItems ? "1" : "0",//4
                                discountObj.PackId,//5
                                discountObj.PackGroupId, //6
                                discountObj.TypeId == DiscountFOC.FOC.GetHashCode() ? discountObj.Amount : 0, //7
                                discountObj.TypeId == DiscountFOC.Discount.GetHashCode() || discountObj.TypeId == DiscountTypes.PriceDiscount.GetHashCode() ? discountObj.Amount : 0, //8
                                discountObj.DiscountTypeId, //9
                                 _requestRepository.CurrentOperator.OrganizationId,//10
                                discountObj.DivisionId,//11
                                discountObj.Inactive ? "1" : "0", //12
                                _requestRepository.CurrentOperator.EmployeeId, //13
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //14
                                discountObj.OfferAppliedOptions, // 15
                                discountObj.DiscountId, //16
                                discountObj.IsRange ? "1" : "0", //17
                                discountObj.IsRange == false ?  -1 : discountObj.FromValue,//18
                                discountObj.IsRange == false ?  -1 : discountObj.ToValue, //19
                                discountObj.TypeId == DiscountTypes.PriceDiscount.GetHashCode() ? discountObj.SalesOrderTypeId: -1, // 20
                                discountObj.TypeId == DiscountTypes.PriceDiscount.GetHashCode() ? discountObj.Priority : 0 // 21
                                );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {
                    //Save language
                    query = string.Format("delete from DiscountLanguage where discountID={0}", discountObj.DiscountId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                    string defaultDescription = discountObj.DiscountDescriptionLanguages[1].Description;

                    foreach (TextLanguage language in discountObj.DiscountDescriptionLanguages)
                    {
                        string description = !string.IsNullOrEmpty(language.Description) ? language.Description.Replace("'", "''") : defaultDescription.Replace("'", "''");

                        query = string.Format(@"insert into DiscountLanguage (DiscountId,LanguageId,Description) values ({0},{1},'{2}')", discountObj.DiscountId, language.LanguageId, description);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }

                    // Delete customer

                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {

                        StringBuilder orgAccessJoin = new StringBuilder();
                        if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                        }                        

                        string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (CustomerGroupID is not null or CustomerGroupID <> -1) " : string.Empty;
                        string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                        query = $@"DELETE FROM DiscountAssignment WHERE DiscountID = {discountObj.DiscountId} and ((ChannelID <> -1 or ChannelID is not null)
                                     or (SubChannelID <> -1 or SubChannelID is not null) or AllCustomers = 1 {deleteGroups} {deleteCustomers})";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                        {
                            query = $@" DELETE DA FROM DiscountAssignment DA                               
                                           inner join CustomerGroup CG  on CG.GroupID = DA.CustomerGroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE DA.DiscountID = {discountObj.DiscountId} ";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            query = $@" DELETE DA FROM DiscountAssignment DA 
                                           inner join CustomerOutlet CO on CO.CustomerID = DA.CustomerID and CO.OutletID = DA.OutletID
                                           { orgAccessJoin }
                                           WHERE DA.DiscountID = {discountObj.DiscountId} ";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.EnableSalesDistributionChannel)
                        {
                            query = $@" DELETE DA FROM DiscountAssignment DA 
                                        INNER JOIN SDCOrganization O on O.SDCID = DA.SDCID AND O.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                        WHERE DA.DiscountID = {discountObj.DiscountId}";
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                    }
                    else
                    {
                        query = string.Format("delete from DiscountAssignment where DiscountID={0}", discountObj.DiscountId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }

                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    // Save applied customer
                    result = InsertDiscountAssignment(discountObj, dBHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors InsertAppliedCustomersToDiscount(SimpleCustomerModel customerOutlet, int discountAssignmentID, int discountId, bool allCustomers, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into DiscountAssignment (DiscountID,DiscountAssignmentID,CustomerID,OutletID,AllCustomers) values ({0},{1},{2},{3},{4})"
                , discountId, discountAssignmentID, customerOutlet.CustomerId, customerOutlet.OutletId, allCustomers ? "1" : "0");
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors InsertDiscountAssignment(DiscountModel discountObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int discountAssignmentID = GetMaxID("DiscountAssignmentID", "DiscountAssignment", dBHelper);
                //Save applied customer
                if (discountObj.AllCustomers)
                {
                    SimpleCustomerModel customer = new SimpleCustomerModel();
                    result = InsertAppliedCustomersToDiscount(customer, discountAssignmentID, discountObj.DiscountId, true, dBHelper);
                    if (result != GlobalErrors.Success) return result;
                }
                else
                {
                    if (discountObj.AppliedCustomers != null && discountObj.AppliedCustomers.Count > 0)
                    {
                        foreach (SimpleCustomerModel customer in discountObj.AppliedCustomers)
                        {

                            result = InsertAppliedCustomersToDiscount(customer, discountAssignmentID, discountObj.DiscountId, discountObj.AllCustomers, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            discountAssignmentID++;
                        }
                    }
                    //Save applied groups
                    if (discountObj.AppliedGroups != null && discountObj.AppliedGroups.Count > 0)
                    {
                        foreach (CustomerGroupModel group in discountObj.AppliedGroups)
                        {
                            result = InsertAppliedGroupsToDiscount(group, discountAssignmentID, discountObj.DiscountId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            discountAssignmentID++;
                        }
                    }
                    //Save applied channels
                    if (discountObj.AppliedChannels != null && discountObj.AppliedChannels.Count > 0)
                    {
                        foreach (CustomerChannelModel channel in discountObj.AppliedChannels)
                        {
                            result = InsertAppliedChannelsToDiscount(channel, discountAssignmentID, discountObj.DiscountId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            discountAssignmentID++;
                        }
                    }
                    //Save applied SDCs
                    if (discountObj.SDCSList != null && discountObj.SDCSList.Count > 0 && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        foreach (SalesDistributionChannelModel sdc in discountObj.SDCSList)
                        {
                            result = InsertAppliedSDCsToDiscount(sdc, discountAssignmentID, discountObj.DiscountId, dBHelper);
                            if (result != GlobalErrors.Success) return result;
                            discountAssignmentID++;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedChannelsToDiscount(CustomerChannelModel channel, int discountAssignmentID, int discountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into DiscountAssignment (DiscountID,DiscountAssignmentID,ChannelID,SubChannelID) values ({0},{1},{2},{3})",
                discountId, discountAssignmentID, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedGroupsToDiscount(CustomerGroupModel group, int discountAssignmentID, int discountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into DiscountAssignment (DiscountID,DiscountAssignmentID,CustomerGroupID) values ({0},{1},{2})",
                discountId, discountAssignmentID, group.GroupId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertAppliedSDCsToDiscount(SalesDistributionChannelModel sdc, int discountAssignmentID, int discountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Insert into DiscountAssignment (DiscountID,DiscountAssignmentID,SDCID) values ({0},{1},{2})",
                discountId, discountAssignmentID, sdc.SDCId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDiscount(int discountID)
        {

            GlobalErrors result = GlobalErrors.Error;
            DBHelper<int> dBHelper = null;
            string queryString = string.Empty;
            try
            {

                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                queryString = string.Format("Delete from DiscountAssignment  where DiscountID= {0} ", discountID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    queryString = string.Format("Delete from DiscountLanguage  where DiscountID= {0} ", discountID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        queryString = string.Format("Delete from Discount  where DiscountID= {0} ", discountID);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
            }
            return result;
        }
        public GlobalErrors UpdateDiscountActiveStatus(int discountId, bool isActive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(" Update Discount set inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2} where DiscountID = {3}",
                isActive ? 0 : 1, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
                discountId //3
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        #endregion
        public GlobalErrors AssignOutletToPriceList(int customerId, int outletId, int priceListID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                query = string.Format(@"Delete from CustomerPrice where CustomerID = {0} AND OutletID = {1} ", customerId
                    , outletId
                    );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"INSERT INTO CustomerPrice (CustomerID , OutletID , PriceListID) VALUES ({0} , {1} , {2})"
                    , customerId
                    , outletId
                    , priceListID);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }


        #region[Promotion]
        public GlobalErrors GetPromotionsListSharedTable(PromotionFilterModel filter, ref SharedTableResult<Promotion> promotionsSharedList)
        {
            promotionsSharedList = new SharedTableResult<Promotion>();
            List<Promotion> promotionsList = new List<Promotion>();
            DBHelper<Promotion> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string prerequisiteItem = string.Empty;
            string prerequisiteGroup = string.Empty;
            string benefitItem = string.Empty;
            string benefitGroup = string.Empty;
            string customerClass = string.Empty;
            bool isPromotionApprovalCycle = false;
            try
            {
                dbHelper = new DBHelper<Promotion>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string filterJoin = string.Empty;
                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("1"))
                {
                    isPromotionApprovalCycle = true;
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( Promotion.PromotionCode LIKE '%{0}%' )
                        OR ( PromotionLanguage.Description LIKE '%{0}%')
                        OR ( Organization.OrganizationCode LIKE '%{0}%' )
                        OR ( OrganizationLanguage.Description LIKE '%{0}%' )
                        )",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.PromotionTypeId != -1)
                    {
                        searchFilter += string.Format(" And (Promotion.PromotionType = {0}) ", filter.PromotionTypeId);
                    }
                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(" And (Promotion.OrganizationID = {0} OR CustomerPromotionOrganization.OrganizationID = {0}) ", filter.OrganizationId);
                    }
                    if (filter.CustomerId != -1)
                    {
                        filterJoin = string.Format(@" INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID");

                        searchFilter += string.Format(@" AND ( CustomerPromotion.AllCustomers = 1 OR CustomerPromotion.CustomerID = {0} OR CustomerPromotion.CustomerGroupID IN (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0}) 
                        OR CustomerPromotion.ChannelID in (select ChannelID from CustomerGroup WHERE GroupID IN (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0}))) AND Promotion.PromotionID Not in 
                        (select PromotionID from CustomerPromotionExclusion where (select COUNT(OutletID) from CustomerPromotionExclusion where CustomerID = {0} 
                        and CustomerPromotionExclusion.PromotionID=Promotion.PromotionID)= (select COUNT(OutletID) from CustomerOutlet where CustomerID={0}) )  ", filter.CustomerId);
                    }
                    if (filter.CustomerId != -1 && filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (CustomerPromotion.OutletID = {0}) ", filter.OutletId);
                    }
                    if (filter.CustomerGroupId != -1)
                    {
                        filterJoin = string.Format(@" INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID");

                        searchFilter += string.Format(" And (CustomerPromotion.CustomerGroupID = {0}) ", filter.CustomerGroupId);
                    }
                    if (!filter.IncludeInactive)
                    {
                        searchFilter += " And ISNULL (Promotion.Inactive, 0) = 0 ";
                    }
                    if (filter.ChannelSubChannelIds != "")
                    {
                        string channelId = filter.ChannelSubChannelIds.Split('-')[0].ToString();
                        string subChannelID = filter.ChannelSubChannelIds.Split('-')[1];
                        filterJoin = string.Format(@" INNER JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID");

                        searchFilter += string.Format(" And (CustomerPromotion.ChannelID = {0} and CustomerPromotion.SubChannelID = {1})", channelId, subChannelID);
                    }
                    if (filter.PrerequisiteItemId != -1 && filter.PrerequisiteItemId != 0)
                    {
                        prerequisiteItem = string.Format(@" INNER JOIN
                        (Select PromotionID From PromotionOptionDetail
                        Inner Join Pack On Pack.PackID = PromotionOptionDetail.PackID And ItemID = {0}
                        Where PromotionOptionTypeID = 1
                        Union
                        Select PromotionID From PromotionOptionDetail
                        Inner Join PackGroupDetail On PackGroupDetail.PackGroupID = PromotionOptionDetail.PackGroupID
                        Inner Join Pack On Pack.PackID = PackGroupDetail.PackID And ItemID = {0}
                        Where PromotionOptionTypeID = 1) PreItems On PreItems.PromotionID = Promotion.PromotionID", filter.PrerequisiteItemId);
                    }
                    if (filter.PrerequisiteGroupId != -1 && filter.PrerequisiteGroupId != 0)
                    {
                        prerequisiteGroup = string.Format(@" INNER JOIN (Select Distinct PromotionID From PromotionOptionDetail Where PromotionOptionTypeID = 1 AND PackGroupID = {0}) 
                        PreGroup ON PreGroup.PromotionID = Promotion.PromotionID ", filter.PrerequisiteGroupId);
                    }
                    if (filter.BenefitItemId != -1 && filter.BenefitItemId != 0)
                    {
                        benefitItem = string.Format(@" INNER JOIN
                        (Select PromotionID From PromotionOptionDetail
                        Inner Join Pack On Pack.PackID = PromotionOptionDetail.PackID And ItemID = {0}
                        Where PromotionOptionTypeID = 2
                        Union
                        Select PromotionID From PromotionOptionDetail
                        Inner Join PackGroupDetail On PackGroupDetail.PackGroupID = PromotionOptionDetail.PackGroupID
                        Inner Join Pack On Pack.PackID = PackGroupDetail.PackID And ItemID = {0}
                        Where PromotionOptionTypeID = 2) BenItems On BenItems.PromotionID = Promotion.PromotionID
                        ", filter.BenefitItemId);
                    }
                    if (filter.BenefitGroupId != -1 && filter.BenefitGroupId != 0)
                    {
                        benefitGroup = string.Format(@" INNER JOIN (Select Distinct PromotionID From PromotionOptionDetail Where PromotionOptionTypeID = 2 AND PackGroupID = {0}) 
                        BenGroup ON BenGroup.PromotionID = Promotion.PromotionID", filter.BenefitGroupId);
                    }
                    if(filter.CustomerClassId != -1)
                    {
                        customerClass = string.Format(@" left join CustomerOutlet on CustomerPromotion.CustomerID = CustomerOutlet.CustomerID and CustomerPromotion.OutletID = CustomerOutlet.OutletID
                        INNER JOIN CustomerClass on CustomerOutlet.CustomerClassID = CustomerClass.CustomerClassID AND CustomerClass.CustomerClassID = {0} ", filter.CustomerClassId);
                    }
                    if (!filter.SpecificDate)
                    {
                        if (filter.FromDate != null)
                        {
                            searchFilter += string.Format(" AND (Promotion.StartDate <= {0} ) ",
                            LocalUtilities.ParseDateToSQLString(filter.FromDate.Date));
                        }
                        if (filter.ToDate != null)
                        {
                            searchFilter += string.Format(" AND (Promotion.EndDate >= {0}) ",
                            LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                        }
                    }else
                    {
                        if (filter.FromDate != null)
                        {
                            searchFilter += string.Format(" AND (Promotion.StartDate = {0} ) ",
                            LocalUtilities.ParseDateToSQLString(filter.FromDate.Date));
                        }
                        if (filter.ToDate != null)
                        {
                            searchFilter += string.Format(" AND (Promotion.EndDate = {0}) ",
                            LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                        }
                    }
                    
                    if (filter.IsBundle)
                    {
                        searchFilter += " And ISNULL (Promotion.IsBundle , 0) = 1 ";
                    }
                    else
                    {
                        searchFilter += " And ISNULL (Promotion.IsBundle , 0) = 0 ";
                    }
                    if (filter.IsGiftVoucher)
                    {
                        searchFilter += "And ISNULL (Promotion.IsGiftVoucher, 0) = 1 ";
                    }
                    else
                    {
                        searchFilter += " And ISNULL (Promotion.IsGiftVoucher, 0) = 0 ";
                    }

                    if (filter.IsLoyaltyPromotion)
                    {
                        searchFilter += " And ISNULL(Promotion.IsLoyaltyPromotion,0) = 1 ";
                    }
                    else
                    {
                        searchFilter += " And ISNULL(Promotion.IsLoyaltyPromotion,0) = 0 ";
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By StartDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (filter.IsCustomerApp)
                    {
                        searchFilter += string.Format(" And (Promotion.OfferAppliedOptions like '%{0}%') ", OfferAppliedOptions.CustomerApp.GetHashCode());
                    }
                }
                string mainQuery = string.Format(@"From Promotion
                LEFT OUTER JOIN PromotionLanguage ON PromotionLanguage.PromotionID = Promotion.PromotionID And PromotionLanguage.LanguageID = {0}                             
                LEFT OUTER JOIN Organization on Organization.OrganizationID = Promotion.OrganizationID   
                LEFT OUTER JOIN OrganizationLanguage ON Promotion.OrganizationID = OrganizationLanguage.OrganizationID AND OrganizationLanguage.LanguageID = {0} 
                LEFT OUTER JOIN CustomerPromotionOrganization On CustomerPromotionOrganization.PromotionID = Promotion.PromotionID and CustomerPromotionOrganization.OrganizationID IN ({1})
                {8}
                {3}
                {4}
                {5}
                {6}
                {7}
                Where Promotion.IsDeleted = 0
                AND (Promotion.OrganizationID IN ({1}) or CustomerPromotionOrganization.OrganizationID IN ({1}))
                {2}",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.OrganizationAccess, //1
                searchFilter, //2
                prerequisiteItem, //3
                prerequisiteGroup, //4
                benefitItem, //5 
                benefitGroup, //6
                customerClass, //7
                filterJoin //8
                );

                string selectionQuery = string.Format(@"Select tt.* from(
                Select distinct Promotion.*,PromotionLevel OldPromotionLevel, Promotion.RepeatCount OriginalRepeatCount, PromotionLanguage.Description PromotionName,
                IsNull(Organization.OrganizationCode,'--') OrganizationCode, IsNull(OrganizationLanguage.Description,'--') OrganizationName,
                Case Promotion.OrganizationID when -1 then '{4}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName,              
                CASE 
                WHEN Promotion.inactive = 1 THEN '{12}'
                WHEN COALESCE(Promotion.Status, -1) = -1 THEN '{10}'
                WHEN COALESCE(Promotion.Status, -1) = 0 THEN '{22}' 
                ELSE CONCAT('{11}', Promotion.Status) 
                END AS PromotionStatusName,
                Case IsNull(Promotion.Status,-1) when -1 then 0 else 1 end as IsPending,
                Case when Promotion.Status = -1 and 1={21} then 0 else 1 end ShowDeleteBtn,
                Case Promotion.PromotionType when 1 then '{7}'  when 2 then '{8}' when 3 then '{9}' when 4 then '{14}' when 6 then '{15}' when 7 then '{16}' end as PromotionTypeName,
                Case When Promotion.StartDate <= {13} and (Promotion.PromotionType in (4,6) or Promotion.RelatedToTarget = 1 or (Promotion.SurveyID is not null and Promotion.SurveyID <> -1)) then 1 else 0 end as IsStartedTargetPromotion,
				Case When Promotion.LoyaltyModeID = {17} then '{19}' when Promotion.LoyaltyModeID = {18} then '{20}' else '' end as LoyaltyModeDescription
                {0} {1} 
                OFFSET  {2} ROWS       
                FETCH NEXT {3} ROWS ONLY)tt",
                mainQuery, //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize, //3
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organizations, _requestRepository.LanguageId),//4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_InActive, _requestRepository.LanguageId),//5
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId), //6
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Fixed_Promotion_Type, _requestRepository.LanguageId), //7
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Ranges_Promotion_Type, _requestRepository.LanguageId), //8
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Steps_Promotion_Type, _requestRepository.LanguageId), //9
                ResourcesManager.TranslateKey("Desc_Active", _requestRepository.LanguageId),//10
                ResourcesManager.TranslateKey("Desc_Approved_from", _requestRepository.LanguageId),//11
                ResourcesManager.TranslateKey("Desc_Inactive", _requestRepository.LanguageId),//12
                LocalUtilities.ParseDateToSQLString(DateTime.Now), //13
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Monthly_Target_Promotion_Type, _requestRepository.LanguageId), //14
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Dynamic_Target_Promotion_Type, _requestRepository.LanguageId), //15
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Survey_Promotion_Type, _requestRepository.LanguageId), //16
                LoyaltyModes.LoyaltyPromotion.GetHashCode(), //17
                LoyaltyModes.PointsLoyaltyPromotion.GetHashCode(), //18
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Loyalty_Promotion, _requestRepository.LanguageId),  //19
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Loyalty_Points_Promotion, _requestRepository.LanguageId), //20
                isPromotionApprovalCycle? 1: 0, //21
                ResourcesManager.TranslateKey("Desc_Need_Approval", _requestRepository.LanguageId) //22
                );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from( select distinct Promotion.* {0} )tt",
                mainQuery);

                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    promotionsSharedList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (promotionsSharedList.TotalItems <= 0)
                    {
                        promotionsSharedList.Data = promotionsList;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(selectionQuery, ref promotionsList ,true);
                promotionsSharedList.Data = promotionsList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promotionsSharedList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SavePromotionProcess(Promotion promotion, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                int status = 0;
                if (promotion.IsNew)
                {
                    // Add mode
                    promotion.OldPromotionId = -1;
                    promotion.CreatedDate = DateTime.Now;
                    promotion.CreatedBy = _requestRepository.CurrentOperator.EmployeeId;
                    #region[Get Promotion Status]
                    if (!promotion.IsBundle && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("1"))
                    {
                        SettingManager settingManager = new SettingManager(_requestRepository);
                        result = settingManager.GetCurrentOperationStatus(ApprovalCycleOperations.Promotions.GetHashCode(), ref status, dbHelper);
                    }
                    else
                    {
                        status = -1;
                    }
                    #endregion
                    promotion.Status = status;
                }
                else if (!promotion.IsNew)
                {
                    bool isDetailsChanged = false;
                    status = promotion.Status;
                    if(promotion.AllowOring != promotion.OldAllowOring || promotion.IsProductDiscount != promotion.oldIsProductDiscount || promotion.RelatedToTarget != promotion.OldRelatedToTarget) 
                    {
                        isDetailsChanged = true;
                    }
                    result = CheckIfPromotionDetailsChangedOnEdit(promotion, ref isDetailsChanged, dbHelper);
                    if (result == GlobalErrors.Success)
                    {
                        // check for details changes
                        if (isDetailsChanged)
                        {
                            // set old promotion as deleted
                            result = SetPromtionAsDeleted(promotion.PromotionId, dbHelper);
                            if (result == GlobalErrors.Success)
                            {
                                promotion.IsNew = true;
                                promotion.OldPromotionId = promotion.PromotionId;
                                promotion.PromotionId = -1;
                                promotion.UpdatedDate = DateTime.Now;
                                promotion.UpdatedBy = _requestRepository.CurrentOperator.EmployeeId;
                            }
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
                
                #region[Insert New Promotion]
                if (promotion.IsNew && promotion.PromotionId < 0)
                {
                    promotion.PromotionId = GetMaxID("PromotionID", "Promotion", dbHelper);
                    if (promotion.PromotionId != -1)
                    {
                        #region[Save Header]
                        query = string.Format(@"insert into Promotion
                        (PromotionID, StartDate, EndDate, IsRepeated, RepeatCount, Inactive, PromotionType, OrganizationID, CreatedDate, IsDeleted, DeletedDate, 
                        OldPromotionID, PromotionCode, FreeGoodsTypeID, IsBundle, IsGiftVoucher, IsLoyaltyPromotion, Synchronized, AchievementID, GiftVoucherMode, 
                        CreatedBy, UpdatedBy, UpdatedDate, LoyalityWidth, MinValue, LoyaltyModeID, PromotionLevel, Status, OfferAppliedOptions, PromotionReasonId, BundleLimit, RelatedToTarget, TargetMode, SurveyID, ResetLastInvRem, Sequence, AppliedAfterPeriod, AllowOring, MaxLimit, IsProductDiscount, IsRestrictUpperLimit, SalesMode, NoOfInvoices, ApplyBundleView) 
                        values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},'{12}',{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{23},{24},{25},{26},{27},'{28}',{29},{30},{31},{32},{33},{34},{35},{36},{37},{38},{39},{40},'{41}',{42},{43})",

                        promotion.PromotionId, //0
                        LocalUtilities.ParseDateToSQLString(promotion.StartDate), //1
                        LocalUtilities.ParseDateToSQLString(promotion.EndDate), //2
                        promotion.IsRepeated ? 1 : 0, //3
                        promotion.OriginalRepeatCount, //4
                        promotion.Inactive ? 1 : 0, //5
                        promotion.PromotionType.GetHashCode(), //6
                        _requestRepository.CurrentOperator.OrganizationId, //7
                        LocalUtilities.ParseDateToSQLString(promotion.CreatedDate), //8
                        0,      // 9 IsDeleted 
                        "NULL", //10 DeletedDate
                        promotion.OldPromotionId == -1 ? "NULL" : promotion.OldPromotionId.ToString(), //11
                        promotion.PromotionCode.Replace("'", "''"), //12
                        promotion.FreeGoodsType == FreeGoodsTypes.None ? "NULL" : promotion.FreeGoodsType.GetHashCode().ToString(), //13
                        promotion.IsBundle ? 1 : 0, //14
                        promotion.IsGiftVoucher ? 1 : 0, //15
                        promotion.IsLoyaltyPromotion ? 1 : 0, //16
                        0, //17 Synchronized
                        promotion.AchievementId == -1 ? "NULL" : promotion.AchievementId.ToString(), //18
                        promotion.IsGiftVoucher ? promotion.GiftVoucherMode.ToString() : "NULL", //19
                        promotion.CreatedBy, //20
                        promotion.OldPromotionId == -1 ? "NULL" : promotion.UpdatedBy.ToString(), //21
                        promotion.OldPromotionId == -1 ? "NULL" : LocalUtilities.ParseDateToSQLString(promotion.UpdatedDate), //22
                        promotion.LoyalityWidth, //23
                        promotion.MinValue, //24
                        promotion.PromotionModeId > 0 ? promotion.PromotionModeId.ToString() : "-1", //25
                        promotion.PromotionLevel.GetHashCode(), //26
                        status, // 27
                        promotion.OfferAppliedOptions, //28
                        promotion.PromotionReasonId == -1 ? "Null" : promotion.PromotionReasonId.ToString(), //29
                        promotion.BundleLimit, //30
                        promotion.RelatedToTarget ? 1 : 0, //31
                        promotion.TargetMode == -1 ? "NULL" : promotion.TargetMode.ToString() ,//32
                        promotion.SurveyId == -1 ? "NULL" : promotion.SurveyId.ToString(), //33
                        promotion.ResetLastInvRem ? 1 : 0, //34
                        promotion.Sequence < 1 ? "1" : promotion.Sequence.ToString(), //35
                        promotion.AppliedAfterPeriod ? 1 : 0, //36
                        promotion.AllowOring ? 1 : 0, //37
                        promotion.MaxLimit,  //38
                        promotion.IsProductDiscount ? 1 : 0, //39
                        promotion.IsRestrictUpperLimit ? 1 : 0, // 40
                        promotion.SalesMode, // 41
                        promotion.NoOfInvoices, // 42
                        promotion.ApplyBundleView ? 1 : 0 // 43
                        );
                        result = dbHelper.ExecuteNonQuery(query);
                        if(result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        #endregion

                        #region[Replace Old Promotion with new id In BundleUsedQuantity table]
                        if (result == GlobalErrors.Success && promotion.OldPromotionId != -1)
                        {
                            result = ReplaceOldPromotionInBundleUsedQuantity(promotion.PromotionId, promotion.OldPromotionId, dbHelper);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                            //here you should change promotion group assignment
                            result= UpdatePromotionGroupAssignedPromotionID(promotion.PromotionId, promotion.OldPromotionId, dbHelper);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                        #endregion
                        
                        #region [Save Details]
                        long maxDetailId = -1;
                        if (result == GlobalErrors.Success)
                        {
                            maxDetailId = GetMaxID("DetailID", "PromotionOptionDetail", dbHelper);
                            if (maxDetailId == -1)
                            {
                                return GlobalErrors.Error;
                            }
                        }

                        #region[Save Input Details]
                        if (result == GlobalErrors.Success)
                        {
                            foreach (PromotionOption input in promotion.PromotionInputs)
                            {
                                foreach (PromotionOptionDetail detail in input.PromotionOptionDetails)
                                {
                                    detail.PromotionId = promotion.PromotionId;
                                    detail.DetailId = maxDetailId;
                                    result = SavePromotionDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetail, dbHelper);
                                    if (result == GlobalErrors.Success && (detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity || detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel))
                                    {
                                        result = SavePromotionPackGroupDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetailGroup, dbHelper);
                                    }
                                    if (result != GlobalErrors.Success)
                                    {
                                        return GlobalErrors.Error;
                                    }
                                    maxDetailId++;
                                }
                            }
                        }
                        #endregion

                        #region[Save Output Details]
                        if (result == GlobalErrors.Success)
                        {
                            foreach (PromotionOption output in promotion.PromotionOutputs)
                            {
                                foreach (PromotionOptionDetail detail in output.PromotionOptionDetails)
                                {
                                    detail.PromotionId = promotion.PromotionId;
                                    detail.DetailId = maxDetailId;
                                    result = SavePromotionDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetail, dbHelper);
                                    if (result == GlobalErrors.Success && promotion.IsBundle && (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup))
                                    {
                                        result = SaveGroupDetailsBenefitForBundle(detail, CoreDataBaseConstants.TableNames.PromotionBenefitDetailGroup, dbHelper);
                                    }
                                    if (result != GlobalErrors.Success)
                                    {
                                        return GlobalErrors.Error;
                                    }
                                    maxDetailId++;
                                }
                            }
                        }
                        #endregion

                        #region[Save Descriptions]
                        if(result == GlobalErrors.Success)
                        {
                            result = SavePromotionDetailsLanguage(promotion.PromotionId, promotion.AchievementId,promotion.OrganizationId, dbHelper);
                        }
                        #endregion

                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        #endregion
                    }
                    else
                    {
                        result = GlobalErrors.Error;
                    }
                }
                #endregion

                #region[Update Promotion]
                else
                {
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Update Promotion set StartDate = {0}, EndDate = {1}, Inactive = {2}, PromotionLevel = {3}, PromotionCode = '{4}', FreeGoodsTypeID = {5}, UpdatedBy = {6}, UpdatedDate = {7}, LoyalityWidth = {8}, MinValue = {9}, IsRepeated = {10}, RepeatCount = {11}, OrganizationId = {13}, PromotionReasonId = {14}, OfferAppliedOptions = '{15}', BundleLimit = {16}, RelatedToTarget = {17}, TargetMode={18}, SurveyID={19}, ResetLastInvRem={20}, Sequence ={21}, AppliedAfterPeriod = {22}, AllowOring = {23}, MaxLimit={24}, IsProductDiscount = {25}, IsRestrictUpperLimit = {26}, SalesMode = '{27}', DeactivationDate = {28}, NoOfInvoices = {29} , ApplyBundleView = {30} where PromotionID = {12} ",
                        LocalUtilities.ParseDateToSQLString(promotion.StartDate), //0
                        LocalUtilities.ParseDateToSQLString(promotion.EndDate), //1
                        promotion.Inactive ? 1 : 0, //2
                        promotion.PromotionLevel.GetHashCode(), //3
                        promotion.PromotionCode.Replace("'", "''"), //4
                        promotion.FreeGoodsType == FreeGoodsTypes.None ? "NULL" : promotion.FreeGoodsType.GetHashCode().ToString(), //5
                        _requestRepository.CurrentOperator.EmployeeId, //6
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //7
                        promotion.LoyalityWidth, //8
                        promotion.MinValue, //9,
                        promotion.IsRepeated ? 1 : 0, //10
                        promotion.OriginalRepeatCount, //11
                        promotion.PromotionId, //12
                        _requestRepository.CurrentOperator.OrganizationId, //13
                        promotion.PromotionReasonId == -1 ? "Null" : promotion.PromotionReasonId.ToString(), //14
                        promotion.OfferAppliedOptions, //15
                        promotion.BundleLimit, //16
                        promotion.RelatedToTarget ? 1 : 0, //17
                        promotion.TargetMode == -1 ? "Null" : promotion.TargetMode.ToString(), //18
                        promotion.SurveyId == -1 ? "Null" : promotion.SurveyId.ToString(), //19
                        promotion.ResetLastInvRem ? 1 : 0, //20
                        promotion.Sequence < 1 ? "1" : promotion.Sequence.ToString(), //21
                        promotion.AppliedAfterPeriod ? 1 : 0, //22
                        promotion.AllowOring ? 1 : 0, //23
                        promotion.MaxLimit, //24
                        promotion.IsProductDiscount ? 1 : 0, //25
                        promotion.IsRestrictUpperLimit ? 1 : 0, //26
                        promotion.SalesMode, //27
                        promotion.Inactive ? LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) : "NULL", // 28
                        promotion.NoOfInvoices, // 29
                        promotion.ApplyBundleView ? 1 : 0 // 30
                        );
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                    }


                    #region[Delete Promotion Related Data]
                    if (result == GlobalErrors.Success)
                    {
                        result = DeletePromtionFromRelatedTable("PromotionLanguage", promotion, dbHelper);

                        // Delete saved target data for promotion in case edit mode with non started promotion
                        if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && !promotion.IsStartedTargetPromotion && (promotion.OldPromotionType == PromotionTypes.TargetPromotion || promotion.OldPromotionType == PromotionTypes.DynamicTargetPromotion))
                        {
                            result = DeleteAchievementTargetCustomer(promotion.PromotionId, dbHelper);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected){
                                result = DeletePromtionFromRelatedTable("PromotionCustomerAchievement", promotion, dbHelper);
                            }
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeletePromtionFromRelatedTable("CustomerPromotion", promotion, dbHelper);
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeletePromtionFromRelatedTable("CustomerPromotionExclusion", promotion, dbHelper);
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = DeletePromtionFromRelatedTable("CustomerPromotionOrganization", promotion, dbHelper);
                        }
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            result = GlobalErrors.Success;
                        }
                    }
                    #endregion
                }
                #endregion

                #region [Save Promotion Descriptions]
                if (result == GlobalErrors.Success && promotion.DescriptionLanguages != null && promotion.DescriptionLanguages.Count > 0)
                {
                    result = SavePromotionDescriptions(promotion.DescriptionLanguages, promotion.PromotionId, promotion.PromotionName, dbHelper);
                }
                #endregion

                #region [Save Promotion Organizations]
                if (result == GlobalErrors.Success && promotion.OrganizationsList != null && promotion.OrganizationsList.Count > 0)
                {
                    result = SavePromotionOrganizations(promotion.OrganizationsList, promotion.PromotionId, dbHelper);
                }
                #endregion

                #region [Save Promotion in CustomerApp]
                if (result == GlobalErrors.Success && _requestRepository.Configurations.AllowCustomerAppLogin)
                {
                    result = SavePromotionCustomerApp(promotion.OldPromotionId, promotion.PromotionId, promotion.ShowInCustomerApp, dbHelper);
                }
                #endregion

                #region [Save Promotion Customers]
                if (result == GlobalErrors.Success)
                {
                    int customerPromotionId = GetMaxID("CustomerPromotionID", "CustomerPromotion", dbHelper);
                    int customerPromotionExclusionId = GetMaxID("CustomerPromotionExclusionID", "CustomerPromotionExclusion", dbHelper);
                    if (customerPromotionId == -1 || customerPromotionExclusionId == -1)
                    {
                        return GlobalErrors.Error;
                    }
                    if (result == GlobalErrors.Success && promotion.ExcludedCustomersList != null && promotion.ExcludedCustomersList.Count > 0)
                    {
                        result = SavePromotionExcludedCustomers(promotion.ExcludedCustomersList, promotion.PromotionId, ref customerPromotionExclusionId, dbHelper);
                    }
                    if (promotion.AssignToAllCustomers)
                    {
                        query = string.Format(@"Insert Into CustomerPromotion (CustomerPromotionID, PromotionID, AllCustomers) Values ({0}, {1}, {2})",
                        customerPromotionId, promotion.PromotionId, 1);
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                    else
                    {
                        if (result == GlobalErrors.Success && promotion.CustomersList != null && promotion.CustomersList.Count > 0)
                        {
                            result = AssignPromtionsToCustomers(promotion.CustomersList, promotion.PromotionId, ref customerPromotionId, dbHelper);
                        }
                        if (result == GlobalErrors.Success && promotion.GroupsList != null && promotion.GroupsList.Count > 0)
                        {
                            result = AssignPromtionsToGroups(promotion.GroupsList, promotion.PromotionId, ref customerPromotionId, dbHelper);
                        }
                        if (result == GlobalErrors.Success && promotion.ChannelsList != null && promotion.ChannelsList.Count > 0)
                        {
                            result = AssignPromtionsToChannels(promotion.ChannelsList, promotion.PromotionId, ref customerPromotionId, dbHelper);
                        }
                        if(result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel && promotion.SDCSList != null && promotion.SDCSList.Count > 0)
                        {
                            result = AssignPromotionsToSalesDistributionChannels(promotion.SDCSList, promotion.PromotionId, ref customerPromotionId, dbHelper);
                        }
                    }
                }
                if(result != GlobalErrors.Success)
                {
                    return result;
                }
                #endregion

                // IsStartedTargetPromotion will be true in add mode or in edit mode with non started promotion, for theses cases new target will be saved
                if (result == GlobalErrors.Success && !promotion.IsStartedTargetPromotion && (promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion))
                {
                    result = SaveTargetPromotion(promotion, dbHelper);
                }
                // Update and Insert Survey Assignment  From Promotion Assignment if promotion type is survey promotion
                if(promotion.PromotionType == PromotionTypes.SurveyPromotion)
                {
                    result = SaveSurveyPromotionAssignment(promotion, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SavePromotionCustomerApp(int oldPromotionId, int promotionId, bool showInCustomerApp, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE FROM PromotionCustomerApp WHERE PromotionId in ({0},{1}); ", oldPromotionId, promotionId);
                if (showInCustomerApp)
                {
                    query = string.Format("{0} INSERT INTO PromotionCustomerApp VALUES ({1})", query, promotionId);
                }
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        private GlobalErrors SetPromtionAsDeleted(int promotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Update Promotion Set IsDeleted = 1, DeletedDate = {0} , DeletedBy = {2} WHERE PromotionID = {1}",
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                promotionId,
                _requestRepository.CurrentOperator.EmployeeId
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors ReplaceOldPromotionInBundleUsedQuantity(int newPromotionId, int oldPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Update BundleUsedQuantity Set PromotionId = {0} WHERE PromotionID = {1}",
                newPromotionId, 
                oldPromotionId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors UpdatePromotionGroupAssignedPromotionID(int newPromotionId, int oldPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Update PromotionGroupAssignment Set PromotionId = {0} WHERE PromotionID = {1}",
                newPromotionId,
                oldPromotionId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors CheckIfPromotionDetailsChangedOnEdit(Promotion promotion, ref bool isDetailsChanged, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete from {0}; Delete from {1}; Delete from {2}",
                CoreDataBaseConstants.TableNames.PromotionOptionDetailTemp,
                CoreDataBaseConstants.TableNames.PromotionOptionDetailGroupTemp,
                CoreDataBaseConstants.TableNames.PromotionBenefitDetailGroupTemp);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    int maxDetailId = -1;

                    #region[Save Input Details in Temp table]
                    foreach (PromotionOption input in promotion.PromotionInputs)
                    {
                        foreach (PromotionOptionDetail detail in input.PromotionOptionDetails)
                        {
                            detail.PromotionId = promotion.PromotionId;
                            detail.DetailId = maxDetailId;
                            result = SavePromotionDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetailTemp, dbHelper);
                            if (result == GlobalErrors.Success && (detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity || detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel))
                            {
                                result = SavePromotionPackGroupDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetailGroupTemp, dbHelper);
                            }
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                            maxDetailId--;
                        }
                    }
                    #endregion

                    #region[Save Output Details in temp table]
                    if (result == GlobalErrors.Success)
                    {
                        foreach (PromotionOption output in promotion.PromotionOutputs)
                        {
                            foreach (PromotionOptionDetail detail in output.PromotionOptionDetails)
                            {
                                detail.PromotionId = promotion.PromotionId;
                                detail.DetailId = maxDetailId;
                                result = SavePromotionDetails(detail, CoreDataBaseConstants.TableNames.PromotionOptionDetailTemp, dbHelper);
                                if (result == GlobalErrors.Success && promotion.IsBundle && (detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems || detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup))
                                {
                                    result = SaveGroupDetailsBenefitForBundle(detail, CoreDataBaseConstants.TableNames.PromotionBenefitDetailGroupTemp, dbHelper);
                                }
                                if (result != GlobalErrors.Success)
                                {
                                    return GlobalErrors.Error;
                                }
                                maxDetailId--;
                            }
                        }
                    }
                    #endregion

                    if (result == GlobalErrors.Success)
                    {
                        object isDiffrent = null;
                        string sql = string.Format(@"Declare @CountOfDiffrences INT; Set @CountOfDiffrences = 0;
                        --check Diffrences over PromotionOptionDetail table
                        Set @CountOfDiffrences = (                        
                        select Count(*) from PromotionOptionDetailTemp
                        full join PromotionOptionDetail on
                        PromotionOptionDetailTemp.PromotionID = PromotionOptionDetail.PromotionID and
                        PromotionOptionDetailTemp.PromotionOptionID = PromotionOptionDetail.PromotionOptionID and
                        PromotionOptionDetailTemp.PromotionOptionTypeID = PromotionOptionDetail.PromotionOptionTypeID and
                        PromotionOptionDetailTemp.PromotionOptionDetailID = PromotionOptionDetail.PromotionOptionDetailID and
                        PromotionOptionDetailTemp.PromotionOptionDetailTypeID = PromotionOptionDetail.PromotionOptionDetailTypeID and
                        IsNull(PromotionOptionDetailTemp.PackID, -1) = IsNull(PromotionOptionDetail.PackID, -1) and
                        IsNull(PromotionOptionDetailTemp.PackGroupID, -1) = IsNull(PromotionOptionDetail.PackGroupID, -1) and
                        IsNull(PromotionOptionDetailTemp.Value, -1) = IsNull(PromotionOptionDetail.Value, -1) and
                        IsNull(PromotionOptionDetailTemp.Range, 0) = IsNull(PromotionOptionDetail.Range, 0) and
                        IsNull(PromotionOptionDetailTemp.ReferenceOptionID, -1) = IsNull(PromotionOptionDetail.ReferenceOptionID, -1) and
                        IsNull(PromotionOptionDetailTemp.PackTypeID, -1) = IsNull(PromotionOptionDetail.PackTypeID, -1) and
                        IsNull(PromotionOptionDetailTemp.DivisionID, -1) = IsNull(PromotionOptionDetail.DivisionID, -1) and
                        PromotionOptionDetailTemp.ExpiryDate = PromotionOptionDetail.ExpiryDate and
                        PromotionOptionDetailTemp.BatchNo = PromotionOptionDetail.BatchNo and
                        PromotionOptionDetailTemp.PointsValidityPeriodTypeID = PromotionOptionDetail.PointsValidityPeriodTypeID and
                        PromotionOptionDetailTemp.PointsValidityPeriodWidth = PromotionOptionDetail.PointsValidityPeriodWidth and
                        IsNull(PromotionOptionDetailTemp.SalesOrderTypeID, '-') = IsNull(PromotionOptionDetail.SalesOrderTypeID, '-') and
                        IsNull(PromotionOptionDetailTemp.ItemID, -1) = IsNull(PromotionOptionDetail.ItemID, -1) and
                        IsNull(PromotionOptionDetailTemp.FromDate, -1) = IsNull(PromotionOptionDetail.FromDate, -1) and
                        IsNull(PromotionOptionDetailTemp.ToDate, -1) = IsNull(PromotionOptionDetail.ToDate, -1)
                        Where(PromotionOptionDetailTemp.PromotionID = {0} or PromotionOptionDetail.PromotionID = {0}) and(PromotionOptionDetail.PromotionID is null or PromotionOptionDetailTemp.PromotionID Is Null)
                        )
                        IF(@CountOfDiffrences > 0)
                        BeGIN
                        Select 1 as DifferenceCount;
                        Return;
                        END
                        ELSE
                        --check Diffrences over PromotionOptionDetailGroup table
                        Set @CountOfDiffrences = (
                        select Count(*) from PromotionOptionDetailGroupTemp
                        full join PromotionOptionDetailGroup on
                        PromotionOptionDetailGroupTemp.PromotionID = PromotionOptionDetailGroup.PromotionID and
                        PromotionOptionDetailGroupTemp.PromotionOptionID = PromotionOptionDetailGroup.PromotionOptionID and
                        PromotionOptionDetailGroupTemp.PromotionOptionDetailID = PromotionOptionDetailGroup.PromotionOptionDetailID and
                        PromotionOptionDetailGroupTemp.PackGroupID = PromotionOptionDetailGroup.PackGroupID and
                        PromotionOptionDetailGroupTemp.PackID = PromotionOptionDetailGroup.PackID and
                        PromotionOptionDetailGroupTemp.Quantity = PromotionOptionDetailGroup.Quantity and
                        IsNull(PromotionOptionDetailGroupTemp.SalesOrderTypeIDs,'-') = IsNull(PromotionOptionDetailGroup.SalesOrderTypeIDs,'-')
                        Where(PromotionOptionDetailGroupTemp.PromotionID = {0} or PromotionOptionDetailGroup.PromotionID = {0}) and(PromotionOptionDetailGroupTemp.PromotionID is null or PromotionOptionDetailGroup.PromotionID Is Null)
                        )
                        IF(@CountOfDiffrences > 0)
                        BeGIN
                        Select 1 as DifferenceCount;
                        Return;
                        END
                        ELSE
                        --check Diffrences over PromotionBenefitDetailGroup table
                        Set @CountOfDiffrences = (
                        select Count(*) from PromotionBenefitDetailGroupTemp
                        full join PromotionBenefitDetailGroup on
                        PromotionBenefitDetailGroupTemp.PromotionID = PromotionBenefitDetailGroup.PromotionID and
                        PromotionBenefitDetailGroupTemp.PromotionOptionID = PromotionBenefitDetailGroup.PromotionOptionID and
                        PromotionBenefitDetailGroupTemp.PromotionOptionDetailID = PromotionBenefitDetailGroup.PromotionOptionDetailID and
                        PromotionBenefitDetailGroupTemp.PackGroupID = PromotionBenefitDetailGroup.PackGroupID and
                        PromotionBenefitDetailGroupTemp.PackID = PromotionBenefitDetailGroup.PackID and
                        PromotionBenefitDetailGroupTemp.DiscountValue = PromotionBenefitDetailGroup.DiscountValue and
                        PromotionBenefitDetailGroupTemp.PriceValue = PromotionBenefitDetailGroup.PriceValue 
                        Where(PromotionBenefitDetailGroupTemp.PromotionID = {0} or PromotionBenefitDetailGroup.PromotionID = {0}) and (PromotionBenefitDetailGroupTemp.PromotionID is null or PromotionBenefitDetailGroup.PromotionID Is Null)
                        )
                        IF(@CountOfDiffrences > 0)
                        BeGIN
                        Select 1 as DifferenceCount;
                        Return;
                        END
                        ELSE
                        Select 0 as DifferenceCount; ",
                        promotion.PromotionId);
                        result = dbHelper.ExecuteScalar(sql, ref isDiffrent);

                        if (result == GlobalErrors.Success && isDiffrent != null && !string.IsNullOrEmpty(isDiffrent.ToString()) && Int32.Parse(isDiffrent.ToString()) > 0)
                        {
                            isDetailsChanged = true;
                        }
                        if (result == GlobalErrors.Success && isDiffrent != null && !string.IsNullOrEmpty(isDiffrent.ToString()) && Int32.Parse(isDiffrent.ToString()) > 0)
                        {
                            query = string.Format(@"Delete from {0}; Delete from {1}; Delete from {2}",
                            CoreDataBaseConstants.TableNames.PromotionOptionDetailTemp,
                            CoreDataBaseConstants.TableNames.PromotionOptionDetailGroupTemp,
                            CoreDataBaseConstants.TableNames.PromotionBenefitDetailGroupTemp);
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                result = GlobalErrors.Success;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors DeletePromtionFromRelatedTable(string tableName, Promotion promotionObj, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Empty;

                if ((promotionObj.OldPromotionLevel == promotionObj.PromotionLevel)  
                    && (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                     && (tableName.Equals("CustomerPromotion") || tableName.Equals("CustomerPromotionExclusion")))
                {
                    
                        StringBuilder orgAccessJoin = new StringBuilder();
                        if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                        {
                            switch (promotionObj.PromotionLevel)
                            {
                                case PromotionLevel.CustomerLevel:
                                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "P", _requestRepository.CurrentOperator.OrganizationAccess));
                                    break;

                                case PromotionLevel.OutletLevel:
                                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "P", _requestRepository.CurrentOperator.OrganizationAccess));
                                    break;
                            }

                        }


                        if (tableName.Equals("CustomerPromotion"))
                        {
                            string deleteGroups = !_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"or (CustomerGroupID is not null or CustomerGroupID <> -1) " : string.Empty;
                            string deleteCustomers = !_requestRepository.Configurations.ForceCustomerOrganizationSelection ? $"or((CustomerID is not null or CustomerID <> -1) or (OutletID is not null or OutletID <> -1))" : string.Empty;

                            query = $@"DELETE FROM {tableName} WHERE PromotionID = {promotionObj.PromotionId} and ((ChannelID <> -1 or ChannelID is not null)
                                     or (SubChannelID <> -1 or SubChannelID is not null) or AllCustomers = 1 or (PromotionGroupID is not null or PromotionGroupID <> -1) {deleteGroups} {deleteCustomers})";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                            {
                                query = $@" DELETE P FROM { tableName } P                               
                                           inner join CustomerGroup CG  on CG.GroupID = P.CustomerGroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE P.PromotionID = {promotionObj.PromotionId} ";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }

                            if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                            {

                                query = $@" DELETE P FROM {tableName} P 
                                           { orgAccessJoin }
                                           WHERE P.PromotionID = {promotionObj.PromotionId} ";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                            if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.EnableSalesDistributionChannel) 
                            {
                                query = $@"DELETE P FROM {tableName} P 
                                            INNER JOIN SDCOrganization O on O.SDCID = P.SDCID AND O.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                            WHERE P.PromotionID = {promotionObj.PromotionId}";
                                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                            }
                        }
                        
                        if (tableName.Equals("CustomerPromotionExclusion"))
                        {
                            query = $@" DELETE P FROM {tableName} P 
                                           { orgAccessJoin }
                                           WHERE P.PromotionID = {promotionObj.PromotionId} ";
                            result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                    
                }
                else
                {

                    if (tableName.Equals("CustomerPromotionOrganization"))
                    {
                        query = $"DELETE FROM {tableName} WHERE PromotionID = {promotionObj.PromotionId} and OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})";

                    }
                    else
                    {
                    
                        query = string.Format("DELETE FROM {0} WHERE PromotionID = {1}", tableName, promotionObj.PromotionId);
                    }
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors DeleteAchievementTargetCustomer(int promotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"DELETE AchievementTargetCustomer
                FROM AchievementTargetCustomer
                inner join PromotionCustomerAchievement on
                PromotionCustomerAchievement.AchievementID = AchievementTargetCustomer.AchievementID and
                PromotionCustomerAchievement.TargetID = AchievementTargetCustomer.TargetID and
                PromotionCustomerAchievement.CustomerID = AchievementTargetCustomer.CustomerID and
                (PromotionCustomerAchievement.OutletID = AchievementTargetCustomer.OutletID)
                Where PromotionID in ({0})", 
                promotionId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors AssignPromtionsToCustomers(List<SimpleCustomerModel> customersList, int promotionId, ref int customerPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (customersList != null && customersList.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (customersList.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = customersList.Count;
                    }
                    while (end <= customersList.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("( {0},{1},{2},{3} ),",
                            customerPromotionId, //0
                            promotionId, //1
                            customersList[i].CustomerId, //2
                            customersList[i].OutletId //3
                            );
                            customerPromotionId++;
                        }
                        query = string.Format(@"Insert Into CustomerPromotion (CustomerPromotionID, PromotionID, CustomerID, OutletID) Values {0}", values.ToString().TrimEnd(','));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (customersList.Count == end)
                        {
                            break;
                        }
                        if (customersList.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (customersList.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors AssignPromtionsToGroups(List<CustomerGroupModel> groupsList, int promotionId, ref int customerPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (groupsList != null && groupsList.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (groupsList.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = groupsList.Count;
                    }
                    while (end <= groupsList.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("( {0},{1},{2} ),",
                            customerPromotionId, //0
                            promotionId, //1
                            groupsList[i].GroupId //2
                            );
                            customerPromotionId++;
                        }
                        query = string.Format(@"Insert Into CustomerPromotion (CustomerPromotionID, PromotionID, CustomerGroupID) Values {0}", values.ToString().TrimEnd(','));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (groupsList.Count == end)
                        {
                            break;
                        }
                        if (groupsList.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (groupsList.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors AssignPromtionsToChannels(List<CustomerChannelModel> channelsList, int promotionId, ref int customerPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (channelsList != null && channelsList.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (channelsList.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = channelsList.Count;
                    }
                    while (end <= channelsList.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("( {0},{1},{2},{3} ),",
                            customerPromotionId, //0
                            promotionId, //1
                            channelsList[i].ChannelSubChannelIds.Split('-')[0], //2
                            channelsList[i].ChannelSubChannelIds.Split('-')[1] //3
                            );
                            customerPromotionId++;
                        }
                        query = string.Format(@"Insert Into CustomerPromotion (CustomerPromotionID, PromotionID, ChannelID, SubChannelID) Values {0}", values.ToString().TrimEnd(','));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (channelsList.Count == end)
                        {
                            break;
                        }
                        if (channelsList.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (channelsList.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors AssignPromotionsToSalesDistributionChannels(List<SalesDistributionChannelModel> sdcs, int promotionId, ref int customerPromotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (sdcs != null && sdcs.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (sdcs.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = sdcs.Count;
                    }
                    while (end <= sdcs.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("( {0},{1},{2} ),",
                            customerPromotionId, //0
                            promotionId, //1
                            sdcs[i].SDCId //2
                            );
                            customerPromotionId++;
                        }
                        query = string.Format(@"Insert Into CustomerPromotion (CustomerPromotionID, PromotionID, SDCID) Values {0}", values.ToString().TrimEnd(','));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (sdcs.Count == end)
                        {
                            break;
                        }
                        if (sdcs.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (sdcs.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors SavePromotionOrganizations(List<OrganizationModel> organizationsList, int promotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (OrganizationModel organizationObject in organizationsList)
                {
                    values.AppendFormat("( {0},{1} ),",
                    promotionId, //1
                    organizationObject.OrganizationId //2
                    );
                }
                query = string.Format(@"Insert Into CustomerPromotionOrganization (PromotionID, OrganizationID) Values {0}", values.ToString().TrimEnd(','));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePromotionDescriptions(List<TextLanguage> desciptionsList, int promotionId, string promotionName, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (TextLanguage descriptionObject in desciptionsList)
                {
                    values.AppendFormat("( {0},{1},'{2}' ),",
                    promotionId, //0
                    descriptionObject.LanguageId, //1
                    string.IsNullOrEmpty(descriptionObject.Description.Trim()) ? promotionName.Replace("'", "''") : descriptionObject.Description.Replace("'", "''") //2
                    );
                }
                query = string.Format(@"Insert Into PromotionLanguage (PromotionID,LanguageID,Description) Values {0}", values.ToString().TrimEnd(','));
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors GetSavedPromotionAchievementId(int promotionId, ref int achievementId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object achId = null;
                string query = string.Format("Select Top (1) AchievementID From PromotionCustomerAchievement where PromotionID = {0} ",
                promotionId
               );
                result = dbHelper.ExecuteScalar(query, ref achId);
                if(result == GlobalErrors.Success && achId!= null && !string.IsNullOrEmpty(achId.ToString()) && Int32.Parse(achId.ToString()) > 0)
                {
                    achievementId = Int32.Parse(achId.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                achievementId = -1;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        private GlobalErrors SaveTargetPromotion(Promotion promotion, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // Save TargetPromotionPeriodTable
                result = FillTargetPromotionPeriodTable(promotion, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    // Call Procedure to Save AchievementTargetCustomer, PromotionCustomerAchievement tables
                    result = ExecuteTargetPromotionProcedure(promotion, dbHelper);
                }
                if(result == GlobalErrors.Success)
                {
                    result = DeleteTargetPromotionPeriod(promotion.PromotionId, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors SaveSurveyPromotionAssignment(Promotion promotion, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" Update Survey Set ValidFrom = {0}, ValidTo = {1}, AllCustomers = {2}, OrganizationID ={5}, AllSecurityGroups = 1 Where SurveyID = {3};
                delete  from SurveyCustomer Where SurveyID = {3};
                delete  from SurveyGroup Where SurveyID = {3};
                delete  from SurveyChannel Where SurveyID = {3};
                delete from SurveyOrganization Where SurveyID = {3};
                INSERT INTO SurveyCustomer (SurveyID, CustomerID, OutletID) select  {3} , CustomerID, OutletID from CustomerPromotion where 
                PromotionID = {4} and CustomerID is not null and OutletID is not null  ;
                INSERT INTO SurveyGroup (SurveyID, GroupID) select  {3}, CustomerGroupID from CustomerPromotion where 
                PromotionID = {4} and CustomerGroupID is not null;
                INSERT INTO SurveyChannel (SurveyID, ChannelID, SubChannelID) select  {3}, ChannelID, SubChannelID from CustomerPromotion where 
                PromotionID = {4} and ChannelID is not null and SubChannelID is not null ;
                INSERT INTO SurveyOrganization (SurveyID, OrganizationID) select  {3}, OrganizationID from CustomerPromotionOrganization where 
                PromotionID = {4};",
                LocalUtilities.ParseDateAndTimeToSQL(promotion.StartDate), //0
                LocalUtilities.ParseDateAndTimeToSQL(promotion.EndDate), //1
                promotion.AssignToAllCustomers ? "1" : "0",//2
                promotion.SurveyId, //3
                promotion.PromotionId, //4
                promotion.OrganizationId //5
                );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private GlobalErrors DeleteTargetPromotionPeriod(int promotionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                // Delete From Peroid 
                string query = string.Format("Delete From TargetPromotionPeriod Where PromotionId = {0} and SessionId = '{1}'",
                promotionId, _requestRepository.SessionId);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors FillTargetPromotionPeriodTable(Promotion promotion, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder periodValues = new StringBuilder();

                if (promotion.PromotionType == PromotionTypes.TargetPromotion) // For monthly target save target for each customer per each month
                {
                    int startMonth = -1, endMonth = -1, startYear = -1, endYear = -1, multiYearStartMonth = -1;
                    DateTime startDate, endDate;
                    int startedValue;

                    startMonth = promotion.StartDate.Month;
                    endMonth = promotion.EndDate.Month;
                    startYear = promotion.StartDate.Year;
                    endYear = promotion.EndDate.Year;

                    for (int currentYear = startYear; currentYear <= endYear; currentYear++)
                    {
                        if (currentYear != endYear)
                            multiYearStartMonth = 12;
                        else
                            multiYearStartMonth = endMonth;
                        startedValue = startMonth;
                        if (currentYear != startYear) startedValue = 1;

                        for (int currentMonth = startedValue; currentMonth <= multiYearStartMonth; currentMonth++)
                        {
                            startDate = new DateTime(currentYear, currentMonth, 1);
                            endDate = startDate.AddMonths(1).AddSeconds(-1);

                            periodValues.AppendFormat("({0},'{1}',{2},{3}),",
                            promotion.PromotionId,
                            _requestRepository.SessionId,
                            LocalUtilities.ParseDateToSQLString(startDate),
                            LocalUtilities.ParseEndDateToSQLString(endDate));
                        }
                    }
                }
                else  // For dynamic target save target for each customer per promotion date
                {
                    periodValues.AppendFormat("({0},'{1}',{2},{3}),",
                    promotion.PromotionId,
                    _requestRepository.SessionId,
                    LocalUtilities.ParseDateToSQLString(promotion.StartDate),
                    LocalUtilities.ParseEndDateToSQLString(promotion.EndDate));
                }

                string values = periodValues.ToString().TrimEnd(',');
                string query = string.Format(" Insert Into TargetPromotionPeriod Values {0}", values);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExecuteTargetPromotionProcedure(Promotion promotion, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                Dictionary<string, object> inputParamters = new Dictionary<string, object>();
                Dictionary<string, object> outputParamters = new Dictionary<string, object>();
                Dictionary<string, object> resultParameters = null;

                string selectedOrganizations = string.Join(",", promotion.OrganizationsList.Select(x => x.OrganizationId).Distinct().ToList());
                inputParamters.Add("@LoggedInEmployeeId", _requestRepository.CurrentOperator.EmployeeId);
                inputParamters.Add("@SessionId", _requestRepository.SessionId);
                inputParamters.Add("@SelectedOrganizations", selectedOrganizations);
                inputParamters.Add("@PromotionId", promotion.PromotionId);
                inputParamters.Add("@PromotionLevel", promotion.PromotionLevel.GetHashCode());
                inputParamters.Add("@ForceCustOrgSelection", _requestRepository.Configurations.ForceCustomerOrganizationSelection);
                inputParamters.Add("@MinValue", promotion.PromotionInputs[0].PromotionOptionDetails[0].Value);
                inputParamters.Add("@Value2", 0);
                inputParamters.Add("@AchievementTypeId", promotion.AchievementTypeId);
                inputParamters.Add("@AchievementId", promotion.AchievementId);
                inputParamters.Add("@PackId", promotion.PromotionInputs[0].PromotionOptionDetails[0].PackId);
                inputParamters.Add("@ItemId", promotion.PromotionInputs[0].PromotionOptionDetails[0].ItemId);
                inputParamters.Add("@PackGroupId", promotion.PromotionInputs[0].PromotionOptionDetails[0].PackGroupId);
                inputParamters.Add("@PackTypeId", promotion.PromotionInputs[0].PromotionOptionDetails[0].PackTypeId);

                outputParamters.Add("@Result", 0);
                if (DBManager.CheckIfProcedureExisted(CoreDataBaseConstants.ProceduresConstants.SaveTargetPromotion))
                {
                    result = dBHelper.ExecuteProcedureWithParameters(CoreDataBaseConstants.ProceduresConstants.SaveTargetPromotion, inputParamters, outputParamters, ref resultParameters, 0, false);
                    if (result == GlobalErrors.Success)
                    {
                        if (resultParameters.ContainsKey("@Result"))
                        {
                            result = (GlobalErrors)(int.Parse(resultParameters["@Result"].ToString()));
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePromotionExcludedCustomers(List<SimpleCustomerModel> excludedCustomersList, int promotionId, ref int customerPromotionExclusionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (excludedCustomersList != null && excludedCustomersList.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (excludedCustomersList.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = excludedCustomersList.Count;
                    }
                    while (end <= excludedCustomersList.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("( {0},{1},{2},{3} ),",
                            customerPromotionExclusionId, //0
                            promotionId, //1
                            excludedCustomersList[i].CustomerId, //2
                            excludedCustomersList[i].OutletId //3
                            );
                            customerPromotionExclusionId++;
                        }
                        query = string.Format(@"Insert Into CustomerPromotionExclusion (CustomerPromotionExclusionID, PromotionID, CustomerID, OutletID) Values {0}", values.ToString().TrimEnd(','));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (excludedCustomersList.Count == end)
                        {
                            break;
                        }
                        if (excludedCustomersList.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (excludedCustomersList.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePromotionDetails(PromotionOptionDetail detail, string tableName, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(detail.DateRange != null && detail.DateRange.Count == 2 && (detail.InputOptionDetailTypeId == PromotionInputDetailTypes.ItemWithNoSalesInCertainPeriodRestrictedToInvoicesCount || detail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupWithNoSalesInCertainPeriodRestrictedToInvoicesCount))
                {
                    detail.FromDate = new DateTime (detail.DateRange[0].Year, detail.DateRange[0].Month, detail.DateRange[0].Day);
                    detail.ToDate = new DateTime (detail.DateRange[1].Year, detail.DateRange[1].Month, detail.DateRange[1].Day);
                }
                else
                {
                    detail.FromDate = null;
                    detail.ToDate = null;
                }

                string query = string.Format(@"insert into {21} (
                PromotionID, PromotionOptionID, PromotionOptionTypeID, PromotionOptionDetailID, PromotionOptionDetailTypeID,
                PackID, PackGroupID, Value, Range, ReferenceOptionID, DetailID, PackTypeID, DivisionID, ExpiryDate, BatchNo, PointsValidityPeriodTypeID, PointsValidityPeriodWidth, SalesOrderTypeID, ItemId, fromDate, ToDate) 
                Values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},'{14}',{15},{16},{17},{18},{19},{20})",
                detail.PromotionId, //0
                detail.PromotionOptionId, //1
                detail.PromotionOptionTypeId.GetHashCode(), //2
                detail.PromotionOptionDetailId,  //3
                detail.PromotionOptionTypeId == PromotionOptionTypes.Input ? detail.InputOptionDetailTypeId.GetHashCode() : detail.OutputOptionDetailTypeId.GetHashCode(),  //4
                detail.PackId == -1 ? "Null" : detail.PackId.ToString(),  //5
                detail.PackGroupId == -1 ? "Null" : detail.PackGroupId.ToString(),  //6
                detail.Value == -1 ? "Null" : detail.Value.ToString(), //7
                detail.Range == -1 ? "0" : detail.Range.ToString(), //8
                detail.ReferenceOptionId == -1 ? "Null" : detail.ReferenceOptionId.ToString(), //9
                detail.DetailId,  //10
                detail.PackTypeId == -1 ? "Null" : detail.PackTypeId.ToString(), //11
                detail.DivisionId == -1 ? "Null" : detail.DivisionId.ToString(), //12
                LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate), //13
                LocalUtilities.DefaultBatchNo, //14
                detail.PointsValidityPeriodTypeId, //15
                detail.PointsValidityPeriodWidth, //16
                detail.SalesOrderTypeId == "" ? "NULL" : "'" + detail.SalesOrderTypeId.ToString().Replace("'", "''") + "'", // 17
                detail.ItemId == -1 ? "NULL" : detail.ItemId.ToString(), // 18
                detail.FromDate == null ? "NULL" : LocalUtilities.ParseDateToSQLString(detail.FromDate.GetValueOrDefault()), // 19
                detail.ToDate == null ? "NULL" : LocalUtilities.ParseEndDateToSQLString(detail.ToDate.GetValueOrDefault()), // 20
                tableName //21
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePromotionDetailsLanguage(int promotionId, int achievementId, int organizationId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string currencyPerOrgFilter = "";
                string salesOrderType = string.Empty;

                if (_requestRepository.Configurations.ApplyCurrencyPerOrganization)
                {
                    currencyPerOrgFilter = string.Format(@" AND Currency.OrganizationId = {0}", organizationId);
                }
                if (promotionId != -1)
                {
                    salesOrderType =  string.Format(@"declare @PromSalesOrderType table (promotionId int,promotionOptionId int, promotionOptionTypeId int , promotionOptionDetailId int ,promotionOptionDetailTypeId int,salesOrderTypeId int)
                    insert into @PromSalesOrderType

                    SELECT pd.promotionId , pd.promotionOptionId, pd.promotionOptionTypeId, 
                    pd.promotionOptionDetailId, pd.promotionOptionDetailTypeId, pd.salesOrderTypeId          
                    FROM (                      
                    select distinct pod.PromotionID, pod.PromotionOptionID , pod.PromotionOptionTypeID, pod.PromotionOptionDetailID,
                    pod.PromotionOptionDetailTypeID, splitSalesOrderType.value  salesOrderTypeId 
                    from PromotionOptionDetail pod 
                    CROSS APPLY STRING_SPLIT(salesOrderTypeId, ',') as  splitSalesOrderType
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pod.PackGroupID
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    INNER JOIN SalesOrderType on SalesOrderType.SalesOrderTypeID = splitSalesOrderType.value 
                    INNER JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = SalesOrderType.SalesOrderTypeID AND 
                    SOTL.LanguageID = Languages.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pod.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pod.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pod.PromotionID = {0} and pod.PromotionOptionTypeID in (1) and pod.PromotionOptionDetailTypeID in (22,24) 
                    )pd 

                    UNION

                    SELECT pd.promotionId , pd.promotionOptionId, pd.promotionOptionTypeId, 
                    pd.promotionOptionDetailId, pd.promotionOptionDetailTypeId, pd.salesOrderTypeId          
                    FROM (                      
                    select distinct pod.PromotionID, pod.PromotionOptionID , pod.PromotionOptionTypeID, pod.PromotionOptionDetailID,
                    pod.PromotionOptionDetailTypeID, splitSalesOrderType.value  salesOrderTypeId 
                    from PromotionOptionDetail pod 
                    CROSS APPLY STRING_SPLIT(salesOrderTypeId, ',') as  splitSalesOrderType
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pod.PackGroupID
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    INNER JOIN SalesOrderType on SalesOrderType.SalesOrderTypeID = splitSalesOrderType.value 
                    INNER JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = SalesOrderType.SalesOrderTypeID AND 
                    SOTL.LanguageID = Languages.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pod.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pod.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pod.PromotionID = {0} and pod.PromotionOptionTypeID in (2) and pod.PromotionOptionDetailTypeID in (26,32,33) 
                    )pd"
                    , promotionId // 0 
                    );
                }
                #region queryString
                string query = string.Format(@"
                    {6}
                    insert into PromOptionDetailLanguage  

                    SELECT pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, ISNULL(SonicDescription.DescriptionValue, '--') + ' ' + '(' + CONVERT(nvarchar(20), CAST(pd.Value AS numeric(19,{2}))) + ')' + ' ' + ISNULL(CL.Description, '--') AS Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN SonicDescription ON SonicDescription.LanguageId = Languages.LanguageId and SonicDescription.DescriptionKey = '{3}'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where (pd.PackGroupId is null or pd.PackGroupId = -1) and pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (8) 
                    --AND (0 = {5}) 

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(SonicDescription.DescriptionValue,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SonicDescription ON SonicDescription.LanguageId = Languages.LanguageId and SonicDescription.DescriptionKey = '{3}'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where (pd.PackGroupId is not null and pd.PackGroupId != -1) and pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (8) 
                    AND (0 = {5}) 

                    UNION

                    SELECT        PromotionID, PromotionOptionID, PromotionOptionDetailID, Languages.LanguageID,  
                    CONCAT('', 
                    CASE WHEN CAST(Value * pack.Quantity AS int) >= t2.MaxPackTypeValue 
                    THEN '(' + CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) / t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t4.MaxPackTypeDesc, '--') + ']' 
                    ELSE '(' + CONVERT(nvarchar(20), CAST((Value * pack.Quantity) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']' END, 

                    CASE WHEN CAST((Value * pack.Quantity) AS int) > t2.MaxPackTypeValue AND CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) != 0 
                    THEN ' ' + IsNull(SD.DescriptionValue, '&') + ' ' + '(' + CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') 
                    + ']' 
                    ELSE '' END, 
                    ' ' + ISNULL(SonicDescription.DescriptionValue, '--') + ' ' + '(' + ISNULL(PGL.Description, '--') + ')')  AS Description
                    FROM            PromotionOptionDetail AS pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SonicDescription ON SonicDescription.LanguageId = Languages.LanguageId and SonicDescription.DescriptionKey = '{3}'
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 


                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack

                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where (pd.PackGroupId is not null and pd.PackGroupId != -1) and pd.PromotionID =  {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (8) AND (1 = {5})

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (6) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (6) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')      + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (6)  

                    UNION 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (2) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (2) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'                 

                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (2)  AND (0 = {5})

                    UNION 

                    SELECT        pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID,
                    CASE WHEN IsNull(pd.Range, 0) <= 0 
                    THEN CONCAT('', 
                    CASE WHEN CAST(Value * pack.Quantity AS int) >= t2.MaxPackTypeValue 
                    THEN '(' + CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) / t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t4.MaxPackTypeDesc, '--') + ']' 
                    ELSE '(' + CONVERT(nvarchar(20), CAST((Value * pack.Quantity) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']' END, 

                    CASE WHEN CAST((Value * pack.Quantity) AS int) > t2.MaxPackTypeValue AND CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) != 0 
                    THEN ' ' + IsNull(SD.DescriptionValue, '&') + ' ' + '(' + CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']'
                    ELSE '' END, 
                    ' ' + IsNull(PromotionConstants.Description, '--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' + ' ')
                    WHEN IsNull(pd.Range, 0) > 0 THEN CONCAT('(', CASE WHEN CAST(Value * pack.Quantity AS int) >= t2.MaxPackTypeValue 
                    THEN CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) / t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ' ' + '[' + IsNull(t4.MaxPackTypeDesc, '--') + ']' 
                    ELSE CONVERT(nvarchar(20), CAST((Value * pack.Quantity) AS numeric(19,{2}))) + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']' END, 

                    CASE WHEN CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) > t2.MaxPackTypeValue AND CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) != 0 
                    THEN ' ' + IsNull(SD.DescriptionValue, '&') + ' ' + CONVERT(nvarchar(20), CAST(CAST((Value * pack.Quantity) % t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) 
                    + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']' 
                    ELSE '' END, ' - ', 

                    CASE WHEN CAST(((Value + Range) * pack.Quantity) / t2.MaxPackTypeValue AS int) > 0 
                    THEN CONVERT(nvarchar(20), CAST(CAST(((Value + Range) * pack.Quantity)/ t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ' ' + '[' + IsNull(t4.MaxPackTypeDesc, '--') + ']' ELSE CONVERT(nvarchar(20), CAST(((Value + Range) * pack.Quantity) AS numeric(19,{2}))) + ' ' + '[' + IsNull(t3.MinPackTypeDesc, 
                    '--') + ']' END, CASE WHEN CAST(((Value + Range) * pack.Quantity) % t2.MaxPackTypeValue AS int) < t2.MaxPackTypeValue AND CAST(((Value + Range) * pack.Quantity) % t2.MaxPackTypeValue AS int) != 0 

                    THEN ' ' + IsNull(SD.DescriptionValue, '&') + ' ' + CONVERT(nvarchar(20), CAST(CAST(((Value + Range) * pack.Quantity) % t2.MaxPackTypeValue AS int) AS numeric(19,{2}))) + ' ' + '[' + IsNull(t3.MinPackTypeDesc, '--') + ']' 
                    ELSE '' END, 
                    ')', ' ' + IsNull(PromotionConstants.Description, '--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' + ' ')  
                    END AS Description
                    FROM            PromotionOptionDetail AS pd INNER JOIN
                    Pack ON Pack.PackID = pd.PackID

                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    Left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 

                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (2) AND (1 = {5})

                    UNION 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (10) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (10) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (5) then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (7) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (7) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) +')' + ' ' + IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (21) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    end as Description

                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (5,7,10)   

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (3,4) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (3,4) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (21) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                 
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (3,4,21) AND (0 = {5})

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (3,4) and IsNull(pd.Range,0) <= 0 
                    then 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,3)))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' '+  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    )


                    when pd.PromotionOptionDetailTypeID in (3,4) and IsNull(pd.Range,0) > 0  
                    then 
                    CONCAT('(',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then  Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{1}))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,{1})))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,

                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{1}))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end

                    , ' - ',
                    case when cast(((Value + Range) * pack.Quantity) /  t2.MaxPackTypeValue as int) > 0
                    then  Convert(nvarchar(20) , cast( cast( ((Value + Range) * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{1}))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast(((Value + Range) * pack.Quantity) as numeric(19,{1})))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
                    case when cast(((Value + Range) * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0

                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{1}))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end,
                    ')'
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 

                    )	

                    when pd.PromotionOptionDetailTypeID in (21) 
                    then 

                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
	
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{1})))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,{1})))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' ' + '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{1})))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    )

                    end as Description

                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack

                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (3,4,21)  AND (1 = {5})

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When pd.PromotionOptionTypeID in (1) and IsNull(pd.Range,0) <= 0 then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')
                    When pd.PromotionOptionTypeID in (1) and IsNull(pd.Range,0) > 0  then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') 
                    When pd.PromotionOptionTypeID in (14,20)  then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (1,14,20)    

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + IsNull(UOM.Description,'--') +  ' ' +  IsNull(PromotionConstants.Description,'--')
                    When IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + IsNull(UOM.Description,'--') +  ' ' +  IsNull(PromotionConstants.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackType ON PackType.PackTypeID = pd.PackTypeID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON UOM.PackTypeID = PackType.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (9)    

                    UNION 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(UOM.Description,'--') + ']' + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(DL.Description,'--')
                    When IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(UOM.Description,'--') + ']' + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(DL.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Division ON Division.DivisionID = pd.DivisionID 
                    INNER JOIN PackType ON PackType.PackTypeID = pd.PackTypeID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON UOM.PackTypeID = PackType.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    Left JOIN DivisionLanguage DL ON DL.DivisionID = Division.DivisionID AND Languages.LanguageID = DL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (11) 

                    UNION 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    CONVERT(nvarchar(100),pd.FromDate,103) + '  -  ' + CONVERT(nvarchar(100),pd.ToDate,103)  + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' (' +  IsNull(IL.Description,'--') + ')' Description
                    from PromotionOptionDetail pd
                    INNER JOIN Item ON Item.ItemID = pd.ItemID 
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN ItemLanguage IL ON IL.ItemID = Item.ItemID AND Languages.LanguageID = IL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (26) 
                    
                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    CONVERT(nvarchar(100),pd.FromDate,103) + '  -  ' + CONVERT(nvarchar(100),pd.ToDate,103)  + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' (' +  IsNull(PL.Description,'--') + ')' Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup ON PackGroup.PackGroupID = pd.PackGroupID 
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PL ON PL.PackGroupID = PackGroup.PackGroupID AND Languages.LanguageID = PL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (27) 

                    UNION 

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (25, 18) AND (0 = {5})  

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
	
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,{2})))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' ' + '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    )  Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack
                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (25, 18) AND (1 = {5})       

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  '%' + ' ' +  IsNull(PromotionConstants.Description,'--') as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1  {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (17, 19, 24)    

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (6) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (7) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%'                         + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (7) and value is null then '%' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (28) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,4))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '+ IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    end as Description               
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (6,7,28)   

                    UNION 

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (3,35) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (3,35) AND (0 = {5})

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,{2})))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' ' + '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' '
                    ) as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}   order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (3,35) AND (1 = {5})

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (8)   then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (27)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (9) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (9) and value is null then '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (23)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (30)	 and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '  + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (30)	 and value is null then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (31)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    end as Description
                    
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (8,9,23,27,30,31)    

                    UNION 

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (4,5,36) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (4,5,36) AND (0 = {5})  

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
	
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,{2})))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,{2})))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    )
                    as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack
                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (4,5,36) AND (1 = {5})

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    when pd.PromotionOptionDetailTypeID in (11) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (34) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (12) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  '%' + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (12) and value is null then '%' + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (29) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '  +  IsNull(PromotionConstants.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4}  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (11,12,29,34)    

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    when pd.PromotionOptionDetailTypeID in (10) and ISNULL(pd.PackID,-1) = -1 
                    then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,5))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (10) and ISNULL(pd.PackID,-1) <> -1 
                    then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,5))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + IsNull(LOWER(SC.DescriptionValue),'--') + ' ' + '(' + ISNULL(IL.Description,'--') + ')'
                    end as Description
                    from PromotionOptionDetail pd 
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1   order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    LEFT JOIN Pack ON Pack.PackID = pd.PackID  
                    LEFT JOIN ItemLanguage IL on IL.ItemID = Pack.ItemID and Languages.LanguageID = IL.LanguageID
                    Left join SonicDescription SC on SC.DescriptionKey = 'Desc_From' and Languages.LanguageID = SC.LanguageId
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (10)    

                    UNION

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(SL.Description,'--') Description
                    from PromotionOptionDetail pd
                    INNER JOIN Promotion ON Promotion.PromotionID = pd.PromotionID 
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN SurveyLanguage SL ON SL.SurveyID = Promotion.SurveyID AND Languages.LanguageID = SL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (23)     
 
                    UNION

				    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    when pd.PromotionOptionDetailTypeID in (20) then IsNull(PromotionConstants.Description,'--') +'(' + Convert(nvarchar(20) , cast(Value as numeric(19,0))) + ')'
                  
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (20) 

                    UNION

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    when pd.PromotionOptionDetailTypeID in (11) then IsNull('(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')'  + PromotionConstants.Description,'--') 
                  
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (11)    

                    UNION 
 
                    select distinct pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case when pd.PromotionOptionDetailTypeID in (22) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,0))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SD.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
					when pd.PromotionOptionDetailTypeID in (22) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,0))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,0))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SD.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    end as Description
                    from PromotionOptionDetail pd
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    Left join ( 
                    Select SUBSTRING( 
                    ( 
                        SELECT distinct ',' + SalesOrderTypeLanguage.Description AS 'data()'
                            FROM SalesOrderTypeLanguage 
		                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
		                    Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID 
		                    INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
		                    AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
		                    and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID and prom.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
		                    where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (22) and PROM.PromotionOptionTypeID in (1)
		                    FOR XML PATH('')
                    ), 2 , 9999) As name
                    )ds ON 1=1
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (22) AND (0 = {5})

                    UNION 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (22) and IsNull(pd.Range,0) <= 0 
                    then 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,3)))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' '+ IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')' 
                    )


                    when pd.PromotionOptionDetailTypeID in (22) and IsNull(pd.Range,0) > 0  
                    then 
                    CONCAT('(',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then  Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,6)))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,

                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end

                    , ' - ',
                    case when cast(((Value + Range) * pack.Quantity) /  t2.MaxPackTypeValue as int) > 0
                    then  Convert(nvarchar(20) , cast( cast( ((Value + Range) * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast(((Value + Range) * pack.Quantity) as numeric(19,6)))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
                    case when cast(((Value + Range) * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0

                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end,
                    ')'
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')' 

                    )	

                    when pd.PromotionOptionDetailTypeID in (22) 
                    then 

                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
	
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6)))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,6)))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' ' + '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6)))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')' 
                    )

                    end as Description

                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN SalesOrderType SOT ON SOT.SalesOrderTypeID in (
					SELECT  (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(pod.SalesOrderTypeID, ',')) AS SalesOrderTypeID
                    FROM     PromotionOptionDetail pod
					where (pod.PromotionID = {0} and pod.PromotionOptionTypeID in (1) and pod.PromotionOptionDetailTypeID in (22)) 
					)
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    INNER Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    INNER join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left join ( 
                    Select SUBSTRING( 
                    ( 
                        SELECT distinct ',' + SalesOrderTypeLanguage.Description AS 'data()'
                            FROM SalesOrderTypeLanguage 
		                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
		                    Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID 
		                    INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
		                    AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
		                    and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID and prom.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
		                    where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (22) and PROM.PromotionOptionTypeID in (1)
		                    FOR XML PATH('')
                    ), 2 , 9999) As name
                    )ds ON 1=1
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    Left JOIN SonicDescription SonicDesc ON SonicDesc.LanguageId = Languages.LanguageId and SonicDesc.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack

                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (22)  AND (1 = {5})

                    UNION 

                    select distinct pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,0))) + ')'  + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SD.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')' as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left join ( 
                     select  tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID,
                     STRING_AGG(tt.Description, ',') AS name 
                     from
                     (
                        Select distinct  PromotionOptionDetail.PromotionID, PromotionOptionDetail.PromotionOptionID, PromotionOptionDetail.PromotionOptionDetailID,  SalesOrderTypeLanguage.Description
                        FROM SalesOrderTypeLanguage
                        INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                        Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
                        INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
                        AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID
                        and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
                        and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID
                        where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (26) and PROM.PromotionOptionTypeID in (2)
                      ) tt
                        group by tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID
                        ) ds ON ds.PromotionID = pd.PromotionID and
					    ds.PromotionOptionID = pd.PromotionOptionID and 
					    ds.PromotionOptionDetailID = pd.PromotionOptionDetailID
                    
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (26) AND (0 = {5})  

                    UNION

                    select distinct pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (26) and IsNull(pd.Range,0) <= 0 
                    then 
                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,3)))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,3)))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' '+  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    )

                    when pd.PromotionOptionDetailTypeID in (26) and IsNull(pd.Range,0) > 0  
                    then 
                    CONCAT('(',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
                    then  Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,6)))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,

                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end

                    , ' - ',
                    case when cast(((Value + Range) * pack.Quantity) /  t2.MaxPackTypeValue as int) > 0
                    then  Convert(nvarchar(20) , cast( cast( ((Value + Range) * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
                    else  Convert(nvarchar(20) , cast(((Value + Range) * pack.Quantity) as numeric(19,6)))+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
                    case when cast(((Value + Range) * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0

                    then ' '+ IsNull(SD.DescriptionValue,'&')+ ' '+ Convert(nvarchar(20) , cast( cast(((Value + Range) * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6))) + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end,
                    ')'
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'

                    )	

                    when pd.PromotionOptionDetailTypeID in (26) 
                    then 

                    CONCAT('',
                    case when cast(Value * pack.Quantity as int) >= t2.MaxPackTypeValue
	
                    then '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) / t2.MaxPackTypeValue as int) as numeric(19,6)))+')' + ' '+ 
                    '[' + IsNull(t4.MaxPackTypeDesc,'--') + ']'
	
                    else '('+Convert(nvarchar(20) , cast((Value * pack.Quantity) as numeric(19,6)))+')'+' ' +'[' + IsNull(t3.MinPackTypeDesc,'--') + ']' end
                    ,
	
                    case when cast((Value * pack.Quantity)  as int) > t2.MaxPackTypeValue and cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) != 0
                    then  ' '+ IsNull(SD.DescriptionValue,'&')+ ' ' + '('+ Convert(nvarchar(20) , cast( cast((Value * pack.Quantity) %  t2.MaxPackTypeValue as int) as numeric(19,6)))+')' + ' '+ 
                    '[' + IsNull(t3.MinPackTypeDesc,'--') + ']' 
                    else '' end
                    ,
                    ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'  + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    )

                    end as Description

                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID 
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left join ( 
                     select  tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID,
                     STRING_AGG(tt.Description, ',') AS name 
                     from
                     (
                        Select distinct  PromotionOptionDetail.PromotionID, PromotionOptionDetail.PromotionOptionID, PromotionOptionDetail.PromotionOptionDetailID,  SalesOrderTypeLanguage.Description
                        FROM SalesOrderTypeLanguage
                        INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                        Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
                        INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
                        AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID
                        and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
                        and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID
                        where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (26) and PROM.PromotionOptionTypeID in (2)
                     ) tt
                    group by tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID
                    )ds ON ds.PromotionID = pd.PromotionID and
					ds.PromotionOptionID = pd.PromotionOptionID and 
					ds.PromotionOptionDetailID = pd.PromotionOptionDetailID
                    
                    Left JOIN SonicDescription SD ON SD.LanguageId = Languages.LanguageId and SD.DescriptionKey = 'Desc_AND'
                    Left JOIN SonicDescription SonicDesc ON SonicDesc.LanguageId = Languages.LanguageId and SonicDesc.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    cross apply (SELECT top 1 Pack.PackID, Pack.ItemID, Pack.Quantity from Pack inner join PackGroupDetail on PackGroupDetail.PackID = Pack.PackID inner join PackGroup on PackGroup.PackGroupID = PG.PackGroupID and PackGroup.PackGroupID = PackGroupDetail.PackGroupID )  Pack

                    cross apply (SELECT Min(Quantity) MinPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t1
                    cross apply (SELECT Max(Quantity) MaxPackTypeValue FROM Pack p where Pack.ItemID = p.ItemID)  t2
                    cross apply (
                    select  ptl.Description MinPackTypeDesc  FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT MIN(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID
                    )  t3
                    cross apply (
                    select  ptl.Description MaxPackTypeDesc FROM pack p, PackTypeLanguage ptl WHERE ptl.PackTypeID = p.PackTypeID and p.ItemID =  Pack.ItemID
                    AND p.Quantity in (SELECT Max(Quantity) FROM pack where pack.ItemID =  p.ItemID )
                    and ptl.LanguageID = Languages.LanguageID

                    )  t4
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (26)  AND (1 = {5})

                    UNION

					select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (24) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' +IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (24) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) +')' + ' ' +IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    end as Description

                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left join ( 
                    Select SUBSTRING( 
                    ( 
                        SELECT distinct ',' + SalesOrderTypeLanguage.Description AS 'data()'
                            FROM SalesOrderTypeLanguage 
		                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
		                    Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID 
		                    INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
		                    AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
		                    and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID and prom.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
		                    where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (24) and PROM.PromotionOptionTypeID in (1)
		                    FOR XML PATH('')
                    ), 2 , 9999) As name
                    )ds ON 1=1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = 7 AND Languages.LanguageID = PromotionConstants.LanguageID 
					left JOIN (select top 1 Currencyid from Currency  where Base = 1  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    Left JOIN SonicDescription SonicDesc ON SonicDesc.LanguageId = Languages.LanguageId and SonicDesc.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (24) 

                    UNION

                    select distinct pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (32) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'+ ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (32) and value is null then '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'+ ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(SOTL.Description, '--') + ')'
                    end as Description
                    
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left join ( 
                    select  tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID,
                    STRING_AGG(tt.Description, ',') AS name 
                    from
                    (
                        Select distinct  PromotionOptionDetail.PromotionID, PromotionOptionDetail.PromotionOptionID, PromotionOptionDetail.PromotionOptionDetailID,  SalesOrderTypeLanguage.Description
                        FROM SalesOrderTypeLanguage
                        INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                        Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
                        INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
                        AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID
                        and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
                        and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID
                        where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (32) and PROM.PromotionOptionTypeID in (2)
                    ) tt
                    group by tt.PromotionID, tt.PromotionOptionID,tt.PromotionOptionDetailID
                    )ds ON ds.PromotionID = pd.PromotionID and
					ds.PromotionOptionID = pd.PromotionOptionID and 
					ds.PromotionOptionDetailID = pd.PromotionOptionDetailID
                   
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = 9 AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
					Left JOIN SonicDescription SonicDesc ON SonicDesc.LanguageId = Languages.LanguageId and SonicDesc.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (32) 
                    
                    UNION

					select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (33)	 and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,2))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '  + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (33)	 and value is null then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' + ' '  + IsNull(SonicDesc.DescriptionValue, '--') + ' ' + '(' + IsNull(ds.name, '--') + ')'
                    end as Description
                    
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    Inner Join SalesOrderType on SalesOrderType.SalesOrderTypeID <> -1
                    Inner join @PromSalesOrderType prom on prom.salesOrderTypeId = SalesOrderType.SalesOrderTypeID
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SalesOrderTypeLanguage SOTL ON SOTL.SalesOrderTypeID = prom.SalesOrderTypeID AND Languages.LanguageID = SOTL.LanguageID
                    Left join ( 
                    Select SUBSTRING( 
                    ( 
                        SELECT distinct ',' + SalesOrderTypeLanguage.Description AS 'data()'
                            FROM SalesOrderTypeLanguage 
		                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
		                    Inner JOIN @PromSalesOrderType PROM ON PROM.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID 
		                    INNER JOIN PromotionOptionDetail ON PROM.promotionId = PromotionOptionDetail.PromotionID and PROM.promotionOptionDetailId = PromotionOptionDetail.PromotionOptionDetailID
		                    AND PROM.promotionOptionDetailTypeId = PromotionOptionDetail.PromotionOptionDetailTypeID and PROM.promotionOptionId  = PromotionOptionDetail.PromotionOptionID
		                    and prom.promotionOptionTypeId = PromotionOptionDetail.PromotionOptionTypeID and prom.salesOrderTypeId = SalesOrderTypeLanguage.SalesOrderTypeID
		                    where SalesOrderTypeLanguage.LanguageID = Languages.LanguageID and PROM.promotionId = {0} and prom.promotionOptionDetailTypeId in (33) and PROM.PromotionOptionTypeID in (2)
		                    FOR XML PATH('')
                    ), 2 , 9999) As name
                    )ds ON 1=1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = 30 AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
					Left JOIN SonicDescription SonicDesc ON SonicDesc.LanguageId = Languages.LanguageId and SonicDesc.DescriptionKey = 'Desc_From_Sales_Order_Type'
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (33)

                    UNION

		            select  distinct pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (25) then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1  order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (25)  
                    ",
                promotionId, //0
                _requestRepository.Configurations.NumberOfDigits, //1
                _requestRepository.Configurations.NumberOfStockDigits, //2
                achievementId == AchievementValues.MonthlySalesAmount.GetHashCode() ? MessagesConstants.Desc_Monthly_Sales_Amount_Constant : achievementId == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode() ? MessagesConstants.Desc_Sold_Quantity_For_Pack_Group_Constant : "",
                currencyPerOrgFilter, //4
                _requestRepository.Configurations.ForceEqualityInPromotionPackGroup ? "1":"0", //5,
                salesOrderType // 6
                );
                #endregion
                #region oldQuery
                /*
                query = string.Format(@" 
                    insert into PromOptionDetailLanguage  
                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    IsNull(SonicDescription.DescriptionValue,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN SonicDescription ON SonicDescription.LanguageId = Languages.LanguageId and SonicDescription.DescriptionKey = '{3}'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where (pd.PackGroupId is null or pd.PackGroupId = -1) and pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (8)
                    union

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(SonicDescription.DescriptionValue,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN SonicDescription ON SonicDescription.LanguageId = Languages.LanguageId and SonicDescription.DescriptionKey = '{3}'
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where (pd.PackGroupId is not null and pd.PackGroupId != -1) and pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (8) 
                    union

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (2) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (2) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (6) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')      + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (6) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')      + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')' +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    Left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (2,6) 
                    union

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (3,4,10) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (3,4,10) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (5) then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (7) and IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (7) and IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) +')' + ' ' + IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (21) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (3,4,5,7,10,21) 
                    union

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When pd.PromotionOptionTypeID in (1) and IsNull(pd.Range,0) <= 0 then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')
                    When pd.PromotionOptionTypeID in (1) and IsNull(pd.Range,0) > 0  then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') 
                    When pd.PromotionOptionTypeID in (14,20)  then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (1,14,20) 
                    union

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + IsNull(UOM.Description,'--') +  ' ' +  IsNull(PromotionConstants.Description,'--')
                    When IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + IsNull(UOM.Description,'--') +  ' ' +  IsNull(PromotionConstants.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackType ON PackType.PackTypeID = pd.PackTypeID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON UOM.PackTypeID = PackType.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (9) 
                    union 

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    When IsNull(pd.Range,0) <= 0 then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(UOM.Description,'--') + ']' + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(DL.Description,'--')
                    When IsNull(pd.Range,0) > 0  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ' - ' + Convert(nvarchar(20) , cast(Value + Range as numeric(19,{2}))) + ')' + ' ' + '[' + IsNull(UOM.Description,'--') + ']' + ' ' +  IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(DL.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Division ON Division.DivisionID = pd.DivisionID 
                    INNER JOIN PackType ON PackType.PackTypeID = pd.PackTypeID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON UOM.PackTypeID = PackType.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    Left JOIN DivisionLanguage DL ON DL.DivisionID = Division.DivisionID AND Languages.LanguageID = DL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (11) 
                    union 


                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (25, 18)
                    union

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  '%' + ' ' +  IsNull(PromotionConstants.Description,'--') as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (17, 19, 24) 
                    union

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (3) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' '                               + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (6) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (7) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%'                         + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (7) and value is null then '%' + ' ' + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    when pd.PromotionOptionDetailTypeID in (28) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,4))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '+ IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(ItemLanguage.Description, '--') + ')'  +  ' ' +  '[' + IsNull(UOM.Description,'--') + ']'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Pack ON Pack.PackID = pd.PackID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackTypeLanguage UOM ON Pack.PackTypeID = UOM.PackTypeID AND Languages.LanguageID = UOM.LanguageID
                    INNER JOIN Item ON Pack.ItemID = Item.ItemID  
                    Left JOIN ItemLanguage ON Item.ItemID = ItemLanguage.ItemID AND Languages.LanguageID = ItemLanguage.LanguageID 
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (3,6,7,28) 
                    union

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID , 
                    case 
                    when pd.PromotionOptionDetailTypeID in (4,5) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{2}))) + ')' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (8)   then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (27)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (9) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (9) and value is null then '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (23)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    when pd.PromotionOptionDetailTypeID in (30)	 and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '  + IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (30)	 and value is null then IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')' 
                    when pd.PromotionOptionDetailTypeID in (31)  then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + '%' + ' ' +  IsNull(PromotionConstants.Description,'--') + ' ' + '(' + IsNull(PGL.Description, '--') + ')'
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN PackGroup PG ON PG.PackGroupID = pd.PackGroupID  
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PackGroupLanguage PGL ON PGL.PackGroupID = PG.PackGroupID AND Languages.LanguageID = PGL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (4,5,8,9,23,27,30,31) 
                    union

                    select pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    Case
                    when pd.PromotionOptionDetailTypeID in (10,11) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  IsNull(CL.Description,'--') + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (12) and value is not null then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' +  '%' + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (12) and value is null then '%' + ' ' +  IsNull(PromotionConstants.Description,'--')
                    when pd.PromotionOptionDetailTypeID in (29) then '(' + Convert(nvarchar(20) , cast(Value as numeric(19,{1}))) + ')' + ' ' + IsNull(CL.Description,'--') + ' '  +  IsNull(PromotionConstants.Description,'--')
                    end as Description
                    from PromotionOptionDetail pd
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    left JOIN (select top 1 Currencyid from Currency  where Base = 1 {4} order by Currencyid ) C on 1=1
                    left JOIN CurrencyLanguage CL ON CL.CurrencyID = C.CurrencyID and Languages.LanguageID = CL.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (2) and pd.PromotionOptionDetailTypeID in (10,11,12,29) 
                    union

                    select  pd.PromotionID, pd.PromotionOptionID, pd.PromotionOptionDetailID, Languages.LanguageID, 
                    IsNull(PromotionConstants.Description,'--') +  ' ' +  IsNull(SL.Description,'--') Description
                    from PromotionOptionDetail pd
                    INNER JOIN Promotion ON Promotion.PromotionID = pd.PromotionID 
                    INNER JOIN Languages ON 1=1  AND Languages.Active = 1
                    Left JOIN SurveyLanguage SL ON SL.SurveyID = Promotion.SurveyID AND Languages.LanguageID = SL.LanguageID
                    Left JOIN PromotionConstants ON PromotionConstants.OptionTypeID = pd.PromotionOptionTypeID and PromotionConstants.DetailTypeID = pd.PromotionOptionDetailTypeID AND Languages.LanguageID = PromotionConstants.LanguageID 
                    where pd.PromotionID = {0} and pd.PromotionOptionTypeID in (1) and pd.PromotionOptionDetailTypeID in (23) ",
                promotionId, //0
                _requestRepository.Configurations.NumberOfDigits, //1
                _requestRepository.Configurations.NumberOfStockDigits, //2
                achievementId == AchievementValues.MonthlySalesAmount.GetHashCode() ? MessagesConstants.Desc_Monthly_Sales_Amount_Constant : achievementId == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode() ? MessagesConstants.Desc_Sold_Quantity_For_Pack_Group_Constant : "",
                currencyPerOrgFilter
                );
                */
                #endregion

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SavePromotionPackGroupDetails(PromotionOptionDetail detail, string tableName, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (PromotionGroupPackDetail groupDetailObject in detail.PackGroupDetails)
                {
                    values.AppendFormat("( {0},{1},{2},{3},{4},{5},{6}),",
                    detail.PromotionId, //0
                    detail.PromotionOptionId, //1
                    detail.PromotionOptionDetailId, //2
                    detail.PackGroupId, //3
                    groupDetailObject.PackId, //4
                    groupDetailObject.PromotionValue, //5
                    string.IsNullOrEmpty(groupDetailObject.SalesOrderTypeIDs) ? "NULL" : "'" + groupDetailObject.SalesOrderTypeIDs.Replace("'", "''") + "'" //6
                    );
                }
                query = string.Format(@"Insert Into {1} (PromotionID, PromotionOptionID, PromotionOptionDetailID, PackGroupID, PackID, Quantity, SalesOrderTypeIDs) Values {0}", 
                values.ToString().TrimEnd(','), 
                tableName);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors SaveGroupDetailsBenefitForBundle(PromotionOptionDetail detail, string tableName, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (PromotionGroupPackDetail groupDetailObject in detail.PackGroupDetails)
                {
                    values.AppendFormat("( {0},{1},{2},{3},{4},{5},{6}),",
                    detail.PromotionId, //0
                    detail.PromotionOptionId, //1
                    detail.PromotionOptionDetailId, //2
                    detail.PackGroupId, //3
                    groupDetailObject.PackId, //4
                    detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems ? groupDetailObject.PromotionValue : 0, //5
                    detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup ? groupDetailObject.PromotionValue : 0 //6
                    );
                }
                query = string.Format(@"Insert Into {1} (PromotionID, PromotionOptionID, PromotionOptionDetailID, PackGroupID, PackID, DiscountValue, PriceValue) Values {0}",
                values.ToString().TrimEnd(','),
                tableName);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPromotionData(int promotionId, bool isClone, ref Promotion selectedPromotion)
        {
             GlobalErrors result = GlobalErrors.NotInitialized;

            DBHelper<TextLanguage> promotionDescriptionsDBHelper = null;
            DBHelper<Promotion> promotionDBHelper = null;
            List<TextLanguage> promotionDescriptions;

            List<OrganizationModel> organizationsList = null;
            List<SimpleCustomerModel> customersList = null;
            List<CustomerGroupModel> groupsList = null;
            List<CustomerChannelModel> channelsList = null;
            List<SimpleCustomerModel> excludedCustomersList = null;
            List<SalesDistributionChannelModel> sdcsList = null;

            try
            {
                string query = string.Empty;

                #region[main data]

                promotionDBHelper = new DBHelper<Promotion>();
                query = string.Format(@"Select distinct Promotion.*,LoyaltyModeID PromotionModeId,Promotion.PromotionLevel OldPromotionLevel, Promotion.RepeatCount OriginalRepeatCount, IsNull(CustomerPromotion.AllCustomers,0)AssignToAllCustomers, 
                Case When PromotionCustomerApp.PromotionId Is Null then 0 else 1 end as ShowInCustomerApp,
                Case When Promotion.StartDate <= {1} and (Promotion.PromotionType in (4,6)  or Promotion.RelatedToTarget = 1 or (Promotion.SurveyID is not null and Promotion.SurveyID <> -1)) then 1 else 0 end as IsStartedTargetPromotion
                From Promotion
                left join CustomerPromotion on CustomerPromotion.PromotionID = Promotion.PromotionID
                left join PromotionCustomerApp on PromotionCustomerApp.PromotionId = Promotion.PromotionID
                Where Promotion.PromotionID = {0}",
                promotionId, //0
                LocalUtilities.ParseDateToSQLString(DateTime.Now) //1
                );
                result = promotionDBHelper.GetQuerySingle(query, ref selectedPromotion);
                if (result != GlobalErrors.Success || selectedPromotion == null)
                {
                    result = GlobalErrors.Error;
                    return result;
                }
                if (isClone)
                {
                    selectedPromotion.PromotionCode = ResourcesManager.TranslateKey(MessagesConstants.Desc_Copied_From, _requestRepository.LanguageId) + " " + selectedPromotion.PromotionCode;
                    selectedPromotion.IsStartedTargetPromotion = false;
                }
                else
                {
                    selectedPromotion.OldPromotionType = selectedPromotion.PromotionType;
                }
                #endregion

                #region[Descriptions]
                if (result == GlobalErrors.Success)
                {
                    promotionDescriptionsDBHelper = new DBHelper<TextLanguage>();
                    promotionDescriptions = new List<TextLanguage>();
                    query = string.Format(@"Select * from PromotionLanguage where PromotionID = {0}", selectedPromotion.PromotionId);
                    result = promotionDescriptionsDBHelper.GetQueryList(query, ref promotionDescriptions);
                    if (promotionDescriptions != null)
                    {
                        if (isClone)
                        {
                            promotionDescriptions.ForEach(description =>
                            {
                                description.Description = ResourcesManager.TranslateKey(MessagesConstants.Desc_Copied_From, _requestRepository.LanguageId) + " " + description.Description;
                            });
                        }
                        selectedPromotion.DescriptionLanguages = promotionDescriptions;
                        if (selectedPromotion.DescriptionLanguages.Any(x => x.LanguageId == _requestRepository.LanguageId))
                        {
                            selectedPromotion.PromotionName = selectedPromotion.DescriptionLanguages.First(x => x.LanguageId == _requestRepository.LanguageId).Description;
                        }
                    }
                }
                #endregion

                #region[Details]
                if (result == GlobalErrors.Success)
                {
                    result = GetPromotionDetails(selectedPromotion);
                }
                #endregion

                #region[Excluded Customers]
                if (result == GlobalErrors.Success)
                {
                    excludedCustomersList = new List<SimpleCustomerModel>();
                    result = GetPromotionExcludedCustomers(selectedPromotion.PromotionId, selectedPromotion.PromotionLevel, ref excludedCustomersList);
                    if (result == GlobalErrors.Success && excludedCustomersList != null && excludedCustomersList.Count > 0)
                    {
                        selectedPromotion.ExcludedCustomersList = excludedCustomersList;
                    }
                }
                #endregion

                #region[Promotion Assignment]
                if (result == GlobalErrors.Success && !selectedPromotion.AssignToAllCustomers)
                {
                    #region[Customers]

                    if (result == GlobalErrors.Success)
                    {
                        customersList = new List<SimpleCustomerModel>();
                        result = GetAppliedPromotionCustomers(selectedPromotion.PromotionId, selectedPromotion.PromotionLevel, ref customersList);
                        if (result == GlobalErrors.Success && customersList != null && customersList.Count > 0)
                        {
                            selectedPromotion.CustomersList = customersList;
                        }
                    }
                    #endregion

                    #region[Groups]
                    if (result == GlobalErrors.Success)
                    {
                        groupsList = new List<CustomerGroupModel>();
                        result = GetAppliedPromotionGroups(selectedPromotion.PromotionId, ref groupsList);
                        if (result == GlobalErrors.Success && groupsList != null && groupsList.Count > 0)
                        {
                            selectedPromotion.GroupsList = groupsList;
                        }
                    }
                    #endregion

                    #region[Channels]
                    if (result == GlobalErrors.Success)
                    {
                        channelsList = new List<CustomerChannelModel>();
                        result = GetAppliedPromotionChannels(selectedPromotion.PromotionId, ref channelsList);
                        if (result == GlobalErrors.Success && channelsList != null && channelsList.Count > 0)
                        {
                            selectedPromotion.ChannelsList = channelsList;
                        }
                    }
                    #endregion

                    #region[Sales Distribution Channels]
                    if (result == GlobalErrors.Success && _requestRepository.Configurations.EnableSalesDistributionChannel)
                    {
                        sdcsList = new List<SalesDistributionChannelModel>();
                        result = GetAppliedPromotionSDCs(selectedPromotion.PromotionId, ref sdcsList);
                        if (result == GlobalErrors.Success && sdcsList != null && sdcsList.Count > 0)
                        {
                            selectedPromotion.SDCSList = sdcsList;
                        }
                    }
                    #endregion
                }
                #endregion

                #region[Organizations]
                if (result == GlobalErrors.Success)
                {
                    organizationsList = new List<OrganizationModel>();
                    List<OrganizationModel> hiddenOrganizations = new List<OrganizationModel>();
                    if (selectedPromotion.OrganizationId == -1)
                    {
                        result = GetAppliedPromotionOrganizations(selectedPromotion.PromotionId, ref organizationsList, ref hiddenOrganizations);
                    }
                    else
                    {
                        result = GetPromotionOrganization(selectedPromotion.OrganizationId, ref organizationsList);
                    }
                    if (result == GlobalErrors.Success && organizationsList != null && organizationsList.Count > 0)
                    {
                        selectedPromotion.OrganizationsList = organizationsList;
                    }
                    if (result == GlobalErrors.Success && hiddenOrganizations != null && hiddenOrganizations.Count > 0)
                    {
                        selectedPromotion.HiddenOrganizations = hiddenOrganizations;
                    }
                }
                #endregion

                #region[Filter Customer Groups based on promotion organization(s)]
                if (result == GlobalErrors.Success && organizationsList != null && organizationsList.Count > 0 && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups && selectedPromotion.GroupsList != null && selectedPromotion.GroupsList.Count > 0)
                {
                    List<int> organizationIdsList = organizationsList.Select(org => org.OrganizationId).ToList();
                    selectedPromotion.GroupsList = selectedPromotion.GroupsList.Where(group => organizationIdsList.Contains(group.OrganizationId)).ToList();
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (promotionDescriptionsDBHelper != null)
                {
                    promotionDescriptionsDBHelper.Dispose();
                    promotionDescriptionsDBHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetPromotionExcludedCustomers(int promotionId, PromotionLevel promotionLevel, ref List<SimpleCustomerModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SimpleCustomerModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                string organizationIdSelection = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        if (promotionLevel == PromotionLevel.OutletLevel)
                        {
                            organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                        }
                        else
                        {
                            organizationIdSelection = " ,Customer.OrganizationId ";
                        }
                    }
                    else
                    {
                        organizationIdSelection = " ,Account.OrganizationId ";
                    }
                    if (promotionLevel == PromotionLevel.OutletLevel)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                    else
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                }
                if (promotionLevel == PromotionLevel.CustomerLevel)
                {
                    query = string.Format(@" Select distinct -1 OutletID, Customer.CustomerId, Customer.CustomerCode, Customer.Phone, CustomerLanguage.Address, CustomerLanguage.Description CustomerName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName {3}
                    from CustomerPromotionExclusion
                    INNER JOIN Customer on Customer.CustomerID = CustomerPromotionExclusion.CustomerID             
                    inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                    Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID AND CustomerLanguage.LanguageID = {0} 
                    and CustomerLanguage.OrganizationId in ({4})
                    {2}
                    Where CustomerPromotionExclusion.PromotionID = {1}
                    Order By Customer.CustomerCode",
                       _requestRepository.LanguageId,
                       promotionId,
                       orgAccessJoin,
                       organizationIdSelection,
                       _requestRepository.CurrentOperator.OrganizationAccess
                       );
                }
                else
                {
                    
                    query = string.Format(@" Select distinct
                CustomerOutlet.OutletID, CustomerOutlet.CustomerCode OutletCode, CustomerOutletLanguage.Description as OutletName, IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, 
                CustomerOutlet.CustomerID, Customer.CustomerCode, CustomerLanguage.Description CustomerName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName {3}
                from CustomerPromotionExclusion
                INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = CustomerPromotionExclusion.CustomerID AND CustomerOutlet.OutletID = CustomerPromotionExclusion.OutletID
                Left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {0}
                INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID      
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID AND CustomerLanguage.LanguageID = {0}   
                and CustomerLanguage.OrganizationId in ({4})
                {2}
                Where CustomerPromotionExclusion.PromotionID = {1}
                Order By Customer.CustomerCode",
                   _requestRepository.LanguageId,
                   promotionId,
                   orgAccessJoin,
                   organizationIdSelection,
                   _requestRepository.CurrentOperator.OrganizationAccess);
                }

                result = dbHelper.GetQueryList(query, ref customersList);
                if(result == GlobalErrors.Success && customersList != null && customersList.Count > 0 && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    customersList = _customerManager.FillCustomerOrganizationIdsAsList(customersList, promotionLevel == PromotionLevel.OutletLevel,true,false);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAppliedPromotionCustomers(int promotionId, PromotionLevel promotionLevel, ref List<SimpleCustomerModel> customersList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SimpleCustomerModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string organizationIdSelection = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    if (_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                    {
                        if (promotionLevel == PromotionLevel.OutletLevel)
                        {
                            organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                        }
                        else
                        {
                            organizationIdSelection = " ,Customer.OrganizationId ";
                        }
                    }
                    else
                    {
                        organizationIdSelection = " ,Account.OrganizationId ";
                    }

                    if (promotionLevel == PromotionLevel.OutletLevel)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                    else
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustAccountOrgAccessFilterQuery, "Customer", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                }
                if (promotionLevel == PromotionLevel.CustomerLevel)
                {
                    query = string.Format(@" Select distinct -1 OutletID, Customer.CustomerId, Customer.CustomerCode, Customer.Phone, CustomerLanguage.Address, CustomerLanguage.Description CustomerName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName {3}
                    from CustomerPromotion
                    INNER JOIN Customer on Customer.CustomerID = CustomerPromotion.CustomerID                            
                    inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                    Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID AND CustomerLanguage.LanguageID = {0}
                    and CustomerLanguage.OrganizationId in ({4})
                    {2}
                    Where CustomerPromotion.PromotionID = {1}
                    Order By Customer.CustomerCode",
                   _requestRepository.LanguageId,
                   promotionId,
                   orgAccessJoin,
                   organizationIdSelection,
                   _requestRepository.CurrentOperator.OrganizationAccess //4
                   );
                }
                else
                {
                    query = string.Format(@" Select distinct CustomerOutlet.OutletID, CustomerOutlet.CustomerCode OutletCode, CustomerOutlet.Phone, CustomerOutletLanguage.Address, CustomerOutletLanguage.Description as OutletName, IsNull(CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName, 
                    CustomerOutlet.CustomerID, Customer.CustomerCode, CustomerLanguage.Description CustomerName, IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName {3}
                    from CustomerPromotion
                    INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = CustomerPromotion.CustomerID AND CustomerOutlet.OutletID = CustomerPromotion.OutletID 
                    Left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {0}
                    INNER JOIN Customer on Customer.CustomerID = CustomerOutlet.CustomerID                
                    inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                    Left outer join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID AND CustomerLanguage.LanguageID = {0}
                    and CustomerLanguage.OrganizationId in ({4})
                    {2}
                    Where CustomerPromotion.PromotionID = {1}
                    Order By Customer.CustomerCode",
                    _requestRepository.LanguageId,
                    promotionId,
                   orgAccessJoin,
                   organizationIdSelection,
                   _requestRepository.CurrentOperator.OrganizationAccess
                    );
                }
                result = dbHelper.GetQueryList(query, ref customersList);
                if (result == GlobalErrors.Success && customersList != null && customersList.Count > 0 && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    customersList = _customerManager.FillCustomerOrganizationIdsAsList(customersList, promotionLevel == PromotionLevel.OutletLevel,true,false);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAppliedPromotionGroups(int promotionId, ref List<CustomerGroupModel> groupsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<CustomerGroupModel> dbHelper = null;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                dbHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@" select distinct CustomerGroup.*, CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                from CustomerPromotion
                inner join CustomerGroup on CustomerGroup.GroupID = CustomerPromotion.CustomerGroupID {2}
                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID = CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID = {0}
                where CustomerPromotion.PromotionID = {1}",
                _requestRepository.LanguageId,
                promotionId,
                orgAccess);

                result = dbHelper.GetQueryList(query, ref groupsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetAppliedPromotionChannels(int promotionId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"select distinct CustomerPromotion.ChannelID, CustomerPromotion.SubChannelID,
                (CONVERT(varchar(10),CustomerPromotion.ChannelID) + '-' + CONVERT(varchar(10),CustomerPromotion.SubChannelID)) ChannelSubChannelIds,
                (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                from CustomerPromotion
                inner join SubChannel on SubChannel.ChannelID = CustomerPromotion.ChannelID and SubChannel.SubChannelID = CustomerPromotion.SubChannelID
                Left outer join ChannelLanguage on ChannelLanguage.ChannelID = CustomerPromotion.ChannelID and ChannelLanguage.LanguageID = {0}
                left outer join SubChannelLanguage on SubChannelLanguage.SubChannelID = CustomerPromotion.SubChannelID and SubChannelLanguage.LanguageID = {0}
                where CustomerPromotion.PromotionID = {1}",
                _requestRepository.LanguageId,
                promotionId
                );
                result = dbHelper.GetQueryList(query, ref appliedChannels);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedPromotionSDCs(int promotionId, ref List<SalesDistributionChannelModel> sdcs)
        {
            DBHelper<SalesDistributionChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try 
            {
                dbHelper = new DBHelper<SalesDistributionChannelModel>();
                string query = $@"Select DISTINCT CustomerPromotion.SDCID, SDC.SDCCode,
                SDCLanguage.Description SDCDescription,
                IsNull(SDC.SDCCode , '--') + ' ' + '-'+ ' ' + IsNull( SDCLanguage.Description , '--') as SDCCodeName,
                --STRING_AGG(SDCOrganization.OrganizationID,',')  as OrganizationIds
                SDCOrganization.OrganizationID
                from CustomerPromotion
                INNER JOIN SDC on SDC.SDCID = CustomerPromotion.SDCID
                INNER JOIN SDCOrganization ON SDCOrganization.SDCID = CustomerPromotion.SDCID AND SDCOrganization.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                LEFT OUTER JOIN SDCLanguage on SDCLanguage.SDCID = CustomerPromotion.SDCID AND SDCLanguage.LanguageID = {_requestRepository.LanguageId}
                WHERE CustomerPromotion.PromotionID = {promotionId}
                --Group by CustomerPromotion.SDCID, SDC.SDCCode, SDCLanguage.Description";
                result = dbHelper.GetQueryList(query, ref sdcs);
                if (result == GlobalErrors.Success && sdcs != null && sdcs.Count > 0)
                {
                    sdcs = sdcs.GroupBy(ch => ch.SDCId).Select(grp => new SalesDistributionChannelModel
                    {
                        SDCId = grp.Key,
                        SDCCode = grp.FirstOrDefault().SDCCode,
                        SDCDescription = grp.FirstOrDefault().SDCDescription,
                        SDCCodeName = grp.FirstOrDefault().SDCCodeName,
                        OrganizationIds = string.Join(',', grp.Select(el => el.OrganizationId).ToList()),
                    }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAppliedPromotionOrganizations(int promotionId, ref List<OrganizationModel> appliedOrganizations, ref List<OrganizationModel> hiddenOrganizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            List<OrganizationModel> allOrganizations = new List<OrganizationModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM CustomerPromotionOrganization
                inner join Organization on Organization.OrganizationID = CustomerPromotionOrganization.OrganizationID
                left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                 where CustomerPromotionOrganization.PromotionID = {1}",
                _requestRepository.LanguageId,
                promotionId
                );
                result = dbHelper.GetQueryList(query, ref allOrganizations);
                if(result == GlobalErrors.Success && allOrganizations != null && allOrganizations.Count > 0)
                {
                    appliedOrganizations = allOrganizations.Where(org => _requestRepository.CurrentOperator.OrganizationAccess.Contains(org.OrganizationId.ToString())).ToList();
       
                    hiddenOrganizations = allOrganizations.Where(org => !_requestRepository.CurrentOperator.OrganizationAccess.Contains(org.OrganizationId.ToString())).ToList();
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedOrganizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPromotionOrganization(int organizationId, ref List<OrganizationModel> appliedOrganizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM Organization
                left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                where Organization.OrganizationID = {1}",
                _requestRepository.LanguageId,
                organizationId
                );
                result = dbHelper.GetQueryList(query, ref appliedOrganizations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedOrganizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SendNotification(Promotion promotion)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            NotificaitonsModel notification = new NotificaitonsModel();
            EchoCustomers customers = new EchoCustomers();
            EchoChannels channel = new EchoChannels();
            EchoGroups groupList = new EchoGroups();
            SharedTableResult<EchoCustomersModel> echoCustomer = new SharedTableResult<EchoCustomersModel>();
            List<EchoCustomersModel> allEchoCustomersList = new List<EchoCustomersModel>();
            List<SimpleCustomerModel> customerList = new List<SimpleCustomerModel>();
            try
            {
                result = _customerManager.GetAllEchoCustomers(ref echoCustomer);
                if (result == GlobalErrors.Success)
                {
                    notification.Body = promotion.DescriptionLanguages.Find(x => x.LanguageId == 1).Description;
                    notification.ArabicBody = promotion.DescriptionLanguages.Find(x => x.LanguageId == 2).Description;
                    if (promotion.ImageList != null && promotion.ImageList.Count > 0)
                    {
                        notification.ImageName = promotion.ImageList[0];
                    }
                    notification.ArabicSubject = "العرض";
                    if (promotion.ChannelsList != null && promotion.ChannelsList.Count > 0)
                    {
                        for (int i = 0; i < promotion.ChannelsList.Count; i++)
                        {
                            channel = new EchoChannels();
                            channel.ChannelSubChannelIds = promotion.ChannelsList[i].ChannelSubChannelIds;
                            notification.Channels.Add(channel);
                        }
                    }
                    if (promotion.GroupsList != null && promotion.GroupsList.Count > 0)
                    {
                        for (int i = 0; i < promotion.GroupsList.Count; i++)
                        {
                            groupList = new EchoGroups();
                            groupList.GroupId = promotion.GroupsList[i].GroupId;
                            notification.Groups.Add(groupList);
                        }
                    }
                    if (echoCustomer != null && echoCustomer.TotalItems > 0)
                    {
                        allEchoCustomersList = (List<EchoCustomersModel>)echoCustomer.Data;
                        if (promotion.AssignToAllCustomers)
                        {
                            for (int i = 0; i < allEchoCustomersList.Count; i++)
                            {
                                customers = new EchoCustomers();
                                customers.CustomerOutletIds = allEchoCustomersList[i].CustomerID + "-" + allEchoCustomersList[i].OutletID;
                                notification.Customers.Add(customers);
                            }
                        }
                        else
                        {
                            if (promotion.CustomersList != null && promotion.CustomersList.Count > 0)
                                customerList = promotion.CustomersList.Where(x => allEchoCustomersList.Any(y => y.CustomerID == x.CustomerId)).ToList();
                            for (int i = 0; i < customerList.Count; i++)
                            {
                                customers = new EchoCustomers();
                                customers.CustomerOutletIds = promotion.CustomersList[i].CustomerId + "-" + promotion.CustomersList[i].OutletId;
                                notification.Customers.Add(customers);
                            }
                        }
                    }
                    notification.promotionNotification = true;
                    notification.Subject = "Offer";
                    notification.TypeId = CustomerAppNotificationTypes.promotion.GetHashCode();
                    result = _customerManager.SaveCustomerNotifications(ref notification);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetPromotionDetails(Promotion promotion)
        {
            DBHelper<PromotionOptionDetail> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<PromotionOptionDetail> allDetailsList = new List<PromotionOptionDetail>();

            try
            {
                dbHelper = new DBHelper<PromotionOptionDetail>();
                string query = string.Format(@"Select PromotionID, PromotionOptionID, PromotionOptionTypeID, PromotionOptionDetailID, PromotionOptionDetailTypeID, 
                IsNull(PackID, -1)PackID, IsNull(PackGroupID, -1)PackGroupID, IsNull(Value, -1)Value, IsNull(Range, 0)Range, IsNull(ReferenceOptionID, -1)ReferenceOptionID, IsNull(DetailID, -1)DetailID, IsNull(PackTypeID,-1)PackTypeID, IsNull(DivisionID,-1)DivisionID, 
                ExpiryDate, BatchNo, IsNull(PointsValidityPeriodTypeID, -1)PointsValidityPeriodTypeID, IsNull(PointsValidityPeriodWidth, -1)PointsValidityPeriodWidth,PromotionOptionDetail.SalesOrderTypeID, PromotionOptionDetail.ItemId, PromotionOptionDetail.FromDate, PromotionOptionDetail.ToDate
                From PromotionOptionDetail
                where PromotionOptionDetail.PromotionID = {0}",
                promotion.PromotionId
                );
                result = dbHelper.GetQueryList(query, ref allDetailsList);
                if (result == GlobalErrors.Success && allDetailsList != null && allDetailsList.Count > 0)
                {
                    List<PromotionOptionDetail> inputPromoOptionsList = new List<PromotionOptionDetail>();
                    List<PromotionOptionDetail> outputPromoOptionsList = new List<PromotionOptionDetail>();

                    inputPromoOptionsList = allDetailsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input).ToList();
                    outputPromoOptionsList = allDetailsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Output).ToList();

                    if (inputPromoOptionsList != null && inputPromoOptionsList.Count > 0)
                    {
                        promotion.PromotionInputs = FillInputsAndOutputs(promotion.IsBundle, inputPromoOptionsList);
                        if (promotion.PromotionInputs == null || promotion.PromotionInputs.Count == 0)
                        {
                            result = GlobalErrors.Error;
                            return result;
                        }
                        if (promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                        {
                            int achievementId = -1;
                            result = GetSavedPromotionAchievementId(promotion.PromotionId, ref achievementId);
                            if (result == GlobalErrors.Success && achievementId != -1)
                            {
                                promotion.AchievementId = achievementId;
                                switch ((AchievementValues)promotion.AchievementId)
                                {
                                    case AchievementValues.MonthlySalesAmount:
                                    case AchievementValues.DynamicSalesAmountPerCustomer:
                                        promotion.AchievementTypeId = AchievementTypeValues.SalesAmount.GetHashCode();
                                        break;

                                    case AchievementValues.Monthlysoldquantityfrompackgroup:
                                    case AchievementValues.DynamicSalesPerPackGroupPerCustomer:
                                        promotion.AchievementTypeId = AchievementTypeValues.SoldQuantityForPackGroup.GetHashCode();
                                        break;

                                    default:
                                        break;
                                }
                                promotion.TargetInputTypeId = promotion.PromotionInputs[0].PromotionOptionDetails[0].InputOptionDetailTypeId.GetHashCode();
                                if (achievementId == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode() || achievementId == AchievementValues.DynamicSalesPerPackGroupPerCustomer.GetHashCode())
                                {
                                    promotion.TargetInputSelectionId = promotion.PromotionInputs[0].PromotionOptionDetails[0].PackGroupId;
                                }
                                promotion.PromotionInputs.ForEach(input =>
                                {
                                    input.PromotionOptionDetails.ForEach(detail =>
                                    {
                                        detail.AchievementId = promotion.AchievementId;
                                        detail.AchievementTypeId = promotion.AchievementTypeId;
                                    });
                                });
                            }
                        }
                    }
                    if (outputPromoOptionsList != null && outputPromoOptionsList.Count > 0)
                    {
                        promotion.PromotionOutputs = FillInputsAndOutputs(promotion.IsBundle, outputPromoOptionsList);
                        if (promotion.PromotionInputs == null || promotion.PromotionInputs.Count == 0)
                        {
                            result = GlobalErrors.Error;
                            return result;
                        }
                        if (promotion.AchievementId == AchievementValues.Monthlysoldquantityfrompackgroup.GetHashCode() || promotion.AchievementId == AchievementValues.DynamicSalesPerPackGroupPerCustomer.GetHashCode())
                        {
                            promotion.TargetOutputSelectionId = promotion.PromotionOutputs[0].PromotionOptionDetails[0].PackGroupId;
                        }
                    }
                    if (promotion.PromotionType == PromotionTypes.StepsValues && promotion.PromotionInputs != null && promotion.PromotionInputs.Count > 0 && promotion.PromotionOutputs != null && promotion.PromotionOutputs.Count > 0)
                    {
                        //Fill first step selection descriptioninputType
                        PromotionInputDetailTypes inputType = promotion.PromotionInputs[0].PromotionOptionDetails[0].InputOptionDetailTypeId;
                        int selectionValueId = -1;
                        string descriptionQuery = string.Empty;
                        if ((inputType == PromotionInputDetailTypes.ItemAmount || inputType == PromotionInputDetailTypes.ItemQuantity)
                            && promotion.PromotionInputs[0].PromotionOptionDetails[0].PackId != -1)
                        {
                            selectionValueId = promotion.PromotionInputs[0].PromotionOptionDetails[0].PackId;

                            descriptionQuery = string.Format(@"Select IsNull(ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( ' + IsNull(PackTypeLanguage.Description, '--') + ' ) ' as ItemCodeName From Item
                            left outer JOIN ItemLanguage on Item.ItemID = ItemLanguage.ItemID and ItemLanguage.LanguageID = {0}
                            INNER JOIN Pack on Pack.ItemID = Item.ItemID
                            left outer join PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                            where Pack.PackID = {1}",
                            _requestRepository.LanguageId,
                            selectionValueId);
                        }
                        else if ((inputType == PromotionInputDetailTypes.InvoiceAmountOnPackGroup || inputType == PromotionInputDetailTypes.SummationOverGroup
                          || inputType == PromotionInputDetailTypes.GroupEqualQuantity || inputType == PromotionInputDetailTypes.GroupDifferntQuantity
                          || inputType == PromotionInputDetailTypes.CertainNumberOfItemsOverGroup || inputType == PromotionInputDetailTypes.SummationOverGroupOnTypeLevel
                          || inputType == PromotionInputDetailTypes.InvoiceAmountOnPackGroupOnTypeLevel)
                           && promotion.PromotionInputs[0].PromotionOptionDetails[0].PackGroupId != -1)
                        {
                            selectionValueId = promotion.PromotionInputs[0].PromotionOptionDetails[0].PackGroupId;

                            descriptionQuery = string.Format(@"select IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName
                            from PackGroup
                            left outer join PackGroupLanguage on PackGroup.PackGroupID = PackGroupLanguage.PackGroupID And PackGroupLanguage.LanguageID = {0}
                            where PackGroup.PackGroupID = {1}",
                            _requestRepository.LanguageId,
                            selectionValueId);
                        }
                        else if ((inputType == PromotionInputDetailTypes.InvoiceAmountFromDivision || inputType == PromotionInputDetailTypes.ItemQuantityFromDivision) && promotion.PromotionInputs[0].PromotionOptionDetails[0].DivisionId != -1)
                        {
                            selectionValueId = promotion.PromotionInputs[0].PromotionOptionDetails[0].DivisionId;

                            descriptionQuery = string.Format(@"Select IsNull(Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( Divisionlanguage.Description , '--') as DivisionCodeName
                            from Division
                            left outer join DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID And DivisionLanguage.LanguageID = {0}
                            where Division.DivisionID = {1}",
                            _requestRepository.LanguageId,
                            selectionValueId);
                        }
                        else if (inputType == PromotionInputDetailTypes.UOMOverAllItems && promotion.PromotionInputs[0].PromotionOptionDetails[0].PackTypeId != -1)
                        {
                            selectionValueId = promotion.PromotionInputs[0].PromotionOptionDetails[0].PackTypeId;

                            descriptionQuery = string.Format(@"Select IsNull(PackTypeLanguage.Description,'--') PackTypeName
                            from PackTypeLanguage
                            where PackTypeLanguage.LanguageID = {0} And PackTypeLanguage.PackTypeID = {1}",
                            _requestRepository.LanguageId,
                            selectionValueId);
                        }
                        if(selectionValueId != -1)
                        {
                            Object descFiled = null;
                            result = dbHelper.ExecuteScalar(descriptionQuery, ref descFiled);
                            if(result == GlobalErrors.Success && descFiled != null && !string.IsNullOrEmpty(descFiled.ToString()))
                            {
                                promotion.StepInputSelectionDescription = descFiled.ToString();
                            }
                        }

                        if(promotion.RelatedToTarget)
                        {
                            //Fill first step selection descriptioninputType
                            PromotionOutputDetailTypes outputType = promotion.PromotionOutputs[0].PromotionOptionDetails[0].OutputOptionDetailTypeId;
                            int selectionOutputValueId = -1;
                            descriptionQuery = string.Empty;
                            if ((outputType == PromotionOutputDetailTypes.ItemQuantity || outputType == PromotionOutputDetailTypes.DiscountPercentageForItem) && promotion.PromotionOutputs[0].PromotionOptionDetails[0].PackId != -1)
                            {
                                selectionOutputValueId = promotion.PromotionOutputs[0].PromotionOptionDetails[0].PackId;

                                descriptionQuery = string.Format(@"Select IsNull(ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--')  + ' ( ' + IsNull(PackTypeLanguage.Description, '--') + ' ) ' as ItemCodeName From Item
                            left outer JOIN ItemLanguage on Item.ItemID = ItemLanguage.ItemID and ItemLanguage.LanguageID = {0}
                            INNER JOIN Pack on Pack.ItemID = Item.ItemID
                            left outer join PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                            where Pack.PackID = {1}",
                                _requestRepository.LanguageId,
                                selectionOutputValueId);
                            }
                            else if ((outputType == PromotionOutputDetailTypes.SummationOverGroup || outputType == PromotionOutputDetailTypes.DiscountPercentageForGroupItems
                                || outputType == PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount)
                               && promotion.PromotionInputs[0].PromotionOptionDetails[0].PackGroupId != -1)
                            {
                                selectionOutputValueId = promotion.PromotionOutputs[0].PromotionOptionDetails[0].PackGroupId;

                                descriptionQuery = string.Format(@"select IsNull(PackGroup.PackGroupCode , '--') + ' ' + '-'+ ' ' + IsNull( PackGroupLanguage.Description , '--') as PackGroupCodeName
                            from PackGroup
                            left outer join PackGroupLanguage on PackGroup.PackGroupID = PackGroupLanguage.PackGroupID And PackGroupLanguage.LanguageID = {0}
                            where PackGroup.PackGroupID = {1}",
                                _requestRepository.LanguageId,
                                selectionOutputValueId);
                            }
                            if (selectionOutputValueId != -1)
                            {
                                Object descFiled = null;
                                result = dbHelper.ExecuteScalar(descriptionQuery, ref descFiled);
                                if (result == GlobalErrors.Success && descFiled != null && !string.IsNullOrEmpty(descFiled.ToString()))
                                {
                                    promotion.StepOutputSelectionDescription = descFiled.ToString();
                                }
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                allDetailsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        private List<PromotionOption> FillInputsAndOutputs(bool isBundle, List<PromotionOptionDetail> detailsList)
        {
            List<PromotionOption> options = null;
            try
            {
                options = new List<PromotionOption>();
                foreach (PromotionOptionDetail promotionOptionDetail in detailsList)
                {
                    if (promotionOptionDetail.PromotionOptionTypeId == PromotionOptionTypes.Input)
                    {
                        promotionOptionDetail.InputOptionDetailTypeId = (PromotionInputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;

                        if (promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)
                        {
                            promotionOptionDetail.PackGroupDetails = PromotionManager.FillGroupPacksQuantityOld(promotionOptionDetail);
                        }
                    }
                    else if (promotionOptionDetail.PromotionOptionTypeId == PromotionOptionTypes.Output)
                    {
                        promotionOptionDetail.OutputOptionDetailTypeId = (PromotionOutputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;
                        if (isBundle && (promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup))
                        {
                            promotionOptionDetail.PackGroupDetails = PromotionManager.FillGroupBenefitDetailsForBundle(promotionOptionDetail);
                        }
                    }

                    if (!options.Any(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId))
                    {
                        PromotionOption promotionOption = new PromotionOption();
                        promotionOption.PromotionOptionId = promotionOptionDetail.PromotionOptionId;
                        promotionOption.PromotionOptionTypeId = promotionOptionDetail.PromotionOptionTypeId;
                        promotionOption.PromotionId = promotionOptionDetail.PromotionId;
                        promotionOption.ReferenceOptionId = promotionOptionDetail.ReferenceOptionId;
                        options.Add(promotionOption);
                    }
                    options.Find(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId).PromotionOptionDetails.Add(promotionOptionDetail);
                }
            }
            catch (Exception ex)
            {
                options = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return options;
        }
        public GlobalErrors DeletePromotion(Promotion promotion, ref bool isValidToDelete, ref string validationMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                isValidToDelete = true;
                object field = null;
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();

                if (promotion.IsLoyaltyPromotion)
                {
                    string query = string.Format(@"Select count(*) from PromotionLoyaltyStatus where PromotionID = {0} AND (IsTaken = 1 or IsSatisfied = 1)",
                    promotion.PromotionId);
                    result = dbHelper.ExecuteScalar(query, ref field);
                    if(result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    else if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                    {
                        validationMessage = MessagesConstants.MessageErrorHappened;
                        isValidToDelete = false;
                        return result;
                    }
                }
                if(promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                {
                    bool isPromoted = false;
                    result = IsTargetPromotionPromoted(promotion.PromotionId, ref isPromoted, dbHelper);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (isPromoted)
                    {
                        validationMessage = MessagesConstants.Desc_Cannot_Edit_Or_Delete_Promoted_Target_Promotion;
                        isValidToDelete = false;
                        return result;
                    }
                }
                if (isValidToDelete)
                {
                    result = SetPromtionAsDeleted(promotion.PromotionId, dbHelper);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            if (dbHelper != null)
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                dbHelper.Dispose();
                dbHelper = null;
            }
            return result;
        }
        public GlobalErrors UpdatePromotionActiveStatus(int promotionId, bool setInactive)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;

            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@" Update Promotion Set Inactive = {0}, UpdatedBy = {1}, UpdatedDate = {2}, DeactivationDate = {4} , DeactivatedBy = {1} Where PromotionID = {3}",
               setInactive ? "1" : "0",
               _requestRepository.CurrentOperator.EmployeeId, //1
               LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //2
               promotionId, //3
               setInactive ? LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) : "null" // 4
               );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetPromotionReasonList(ref List<PromotionReasonModel> promotionReasonList)
        {
            DBHelper<PromotionReasonModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<PromotionReasonModel>();
                string query = string.Format(@"select PromotionReason.PromotionReasonId, IsNull(PromotionReasonLanguage.Description, '--') Description 
                from PromotionReason
                left join PromotionReasonLanguage on PromotionReasonLanguage.PromotionReasonId = PromotionReason.PromotionReasonId and PromotionReasonLanguage.LanguageID = {0}",
                _requestRepository.LanguageId //0
                );
                result = dbHelper.GetQueryList(query, ref promotionReasonList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promotionReasonList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAchievementTypesForTargetPromotions(ref List<AchievementTypeModel> achievementList)
        {
            DBHelper<AchievementTypeModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<AchievementTypeModel>();
                string query = string.Format(@"select AchievementTypeLanguage.AchievementTypeID, AchievementTypeLanguage.Description 
                from AchievementTypeLanguage
                inner join PerformanceConfig on PerformanceConfig.UsedID = AchievementTypeLanguage.AchievementTypeID 
                and ColumnName='AchievementTypeID' and TableName='AchievementTypeLanguage'
                where AchievementTypeLanguage.LanguageID = {0} and AchievementTypeID in ({1}, {2})",
                _requestRepository.LanguageId, //0
                AchievementTypeValues.SalesAmount.GetHashCode(), //1
                AchievementTypeValues.SoldQuantityForPackGroup.GetHashCode() //2
                );
                result = dBHelper.GetQueryList(query, ref achievementList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                achievementList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsTargetPromotionPromoted(int promotionId, ref bool isPromoted, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool closeNow = false;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    closeNow = true;
                }
                object field = null;
                string query = string.Format(@"select count(*) from AchievementTargetCustomer 
                inner join PromotionCustomerAchievement on
                AchievementTargetCustomer.CustomerID = PromotionCustomerAchievement.CustomerID and
                AchievementTargetCustomer.OutletID = PromotionCustomerAchievement.OutletID and
                AchievementTargetCustomer.TargetID = PromotionCustomerAchievement.TargetID and
                AchievementTargetCustomer.AchievementID = PromotionCustomerAchievement.AchievementID Where PromotionID = {0} and IsPromoted = 1 ",
                promotionId);

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isPromoted = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if(dBHelper != null && closeNow)
                {
                    dBHelper.Dispose();
                }
            }
            return result;
        }
        public GlobalErrors GetAchievementCustomer(int promotionId, ref List<CustomerOutletModel> customerList, DBHelper<CustomerOutletModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool closeNow = false;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<CustomerOutletModel>();
                    closeNow = true;
                }
                string query = string.Format(@"select distinct PromotionBenefitHistory.CustomerID,PromotionBenefitHistory.OutletID, IsNull( Customer.CustomerCode , '--') + ' - ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                from PromotionBenefitHistory
				inner join Customer on Customer.CustomerID = PromotionBenefitHistory.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = PromotionBenefitHistory.CustomerID and CustomerOutlet.OutletID = PromotionBenefitHistory.OutletID
				left join CustomerLanguage on CustomerLanguage.CustomerID = Customer.CustomerID and CustomerLanguage.LanguageID = {1}
                left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {1}
                Where PromotionID = {0}  ",
                promotionId, _requestRepository.LanguageId);

                result = dBHelper.GetQueryList(query, ref customerList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null && closeNow)
                {
                    dBHelper.Dispose();
                }
            }
            return result;
        }
        public GlobalErrors IsPromotionTakenForRelatedToTarget(int promotionId, ref bool isPromotionTaken, DBHelper<int> dBHelper)
        {
            bool closeNow = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<int>();
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    closeNow = true;
                }
                object field = null;
                string query = string.Format(@"select count(*) from PromotionBenefitHistory where PromotionID = {0}"
                , promotionId);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && (int)field > 0)
                {
                    isPromotionTaken = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion

        public GlobalErrors GetQuantityRangeList(ref List<QuantityRange> quantityRanges)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<QuantityRange> dBHelper = new DBHelper<QuantityRange>();
                string query = $@"Select PQR.PriceQuantityRangeID QuantityRangeID,
                                    CAST(PQR.RangeStart AS nvarchar(max)) +'    -   '+ 
                                    CAST(PQR.RangeEnd AS nvarchar(max))  [Range] from PriceQuantityRange PQR";
                result = dBHelper.GetQueryList(query, ref quantityRanges);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertQuantityRange(QuantityRange quantityRange,ref int quantityRangeID)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                int definedRangeID = quantityRangeID = GetMaxID("PriceQuantityRangeID", "PriceQuantityRange", dBHelper);
                string query = $@"insert into PriceQuantityRange(PriceQuantityRangeID,RangeStart,RangeEnd)values({definedRangeID},{quantityRange.RangeStart},{quantityRange.RangeEnd})";
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            finally
            {
                if(result == GlobalErrors.Success)
                {
                    dBHelper.CommitTransaction();
                }
                else
                {
                    dBHelper.RollBackTransaction();
                }
                dBHelper.Dispose();
                dBHelper = null;
            }
            return result;
        }

        public GlobalErrors PreparePricesWhileImportFromExcel(ref List<dynamic> items, ref int importedCount, ref int notImportedCount, DBHelper<int> dBHelperCount)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                int quantityRange = GetDefaultQuantityRangeID(null);
                DBHelper<dynamic> dBHelper = null;
                if (dBHelperCount == null)
                {
                    dBHelperCount = new DBHelper<int>();
                    dBHelper = new DBHelper<dynamic>();
                }
                else 
                {
                    dBHelper = new DBHelper<dynamic>(dBHelperCount.GetConnection(), dBHelperCount.GetDBTransaction());
                }

                object itemsCount = 0;
                object invalidRangeCount = 0;
                object invalidDublicatePackCount = 0;
                string divisionOrgAccess = string.Empty;
                //int baseCurrencyId = _currencyManager.GetBaseCurrencyId();

                #region VALIDATION
                string invalidationQuery = @"
                    SELECT ISNULL(COUNT(*), 0) from (
                    SELECT  
                    (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) AS startVal,
                    (SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-')) AS endVal
                    FROM     ImportItemsPricesTemplate  
                    ) as tt where tt.startVal > tt.endVal 
                    ";
                result = dBHelperCount.ExecuteScalar(invalidationQuery, ref invalidRangeCount);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;

                if (invalidRangeCount != null && (int)invalidRangeCount > 0)
                    return GlobalErrors.SomeInvalidPrices;
          
                invalidationQuery = @"
                    select top 1 Count(*)
                    from ImportItemsPricesTemplate 
                    group by ImportItemsPricesTemplate.ItemCode, ImportItemsPricesTemplate.QuantityRange, ImportItemsPricesTemplate.UOM
                    HAVING count(*) > 1
                    ORDER BY count(*) desc
                        ";
                result = dBHelperCount.ExecuteScalar(invalidationQuery, ref invalidDublicatePackCount);
                if (result != GlobalErrors.Success) return GlobalErrors.Error;

                if (invalidDublicatePackCount != null && (int)invalidDublicatePackCount > 0)
                    return GlobalErrors.DataAlreadyExists;

                #endregion


                string query = $@"

                                DECLARE @MAXPriceQuantityRangeID INT ;
                                SET @MAXPriceQuantityRangeID = (SELECT ISNULL(MAX(PriceQuantityRangeID), 0) from PriceQuantityRange);

                                INSERT INTO PriceQuantityRange 
                                --SELECT * FROM (
                                --    SELECT @MAXPriceQuantityRangeID + ROW_NUMBER() OVER(ORDER BY PriceQuantityRangeID) AS ID, 
                                --    (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) AS startVal,
                                --    (SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-')) AS endVal
                                --    FROM     ImportItemsPricesTemplate 
                                --    --LEFT OUTER JOIN PriceQuantityRange ON ImportItemsPricesTemplate.QuantityRange =  CONCAT(PriceQuantityRange.RangeStart, '-', PriceQuantityRange.RangeEnd) 
                                --    LEFT OUTER JOIN PriceQuantityRange ON 
		                        --           PriceQuantityRange.RangeStart = (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) 
	                            --        and PriceQuantityRange.RangeEnd =(SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-'))
                                --                                        WHERE  (PriceQuantityRange.PriceQuantityRangeID IS NULL)
                                --)tt WHERE startVal is not null and endVal is not null


                                SELECT * FROM ( 
	                                SELECT @MAXPriceQuantityRangeID + ROW_NUMBER() OVER(ORDER BY PriceQuantityRangeID) AS ID, NQR.startVal, NQR.endVal
	                                FROM
	                                (
		                                Select Distinct
		                                (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) AS startVal,
		                                (SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-')) AS endVal
		                                FROM     ImportItemsPricesTemplate 
		                                --LEFT OUTER JOIN PriceQuantityRange ON ImportItemsPricesTemplate.QuantityRange =  CONCAT(PriceQuantityRange.RangeStart, '-', PriceQuantityRange.RangeEnd) 
		                                LEFT OUTER JOIN PriceQuantityRange ON 
		                                PriceQuantityRange.RangeStart = (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) 
		                                and PriceQuantityRange.RangeEnd =(SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-'))
		                                WHERE  (PriceQuantityRange.PriceQuantityRangeID IS NULL)
	                                ) NQR LEFT JOIN PriceQuantityRange  ON NQR.startVal = PriceQuantityRange.RangeStart and NQR.endVal = PriceQuantityRange.RangeEnd
                                    WHERE PriceQuantityRange.PriceQuantityRangeID IS NULL

                                )tt WHERE startVal is not null and endVal is not null


                                select distinct item.ItemID itemId,pack.PackID packId,IL.Description itemName,item.ItemCode itemCode,
                                item.ItemCode +' - '+IL.Description+' '+'( '+PTL.Description+' )' itemCodeName,PackTypeLanguage.Description uom,
                                ImportItemsPricesTemplate.Price price,ImportItemsPricesTemplate.Tax tax,
                                ImportItemsPricesTemplate.Price netPrice,
                                isnull(PQR.PriceQuantityRangeID, {quantityRange}) quantityRangeId,-1 priceListId,-1 priceDefinitionId,{DataActions.Add.GetHashCode()} dataAction,
                                {quantityRange} oldQuantityRangeId
                                from ImportItemsPricesTemplate
                                inner join item on LOWER(item.ItemCode) = LOWER(ImportItemsPricesTemplate.ItemCode)
                                cross apply(select top 1 * from PackTypeLanguage where LOWER(PackTypeLanguage.Description) 
                                = LOWER(ImportItemsPricesTemplate.UOM)) PTL
                                inner join pack on pack.ItemID = item.ItemID and pack.PackTypeID = PTL.PackTypeID
                                left join ItemLanguage IL on IL.ItemID = item.ItemID and IL.LanguageID = {_requestRepository.LanguageId}
                                INNER JOIN PackTypeLanguage on Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                                INNER JOIN ItemCategory ON item.ItemCategoryID = ItemCategory.ItemCategoryID
                                inner join Division on Division.DivisionID = ItemCategory.DivisionID 
                                left join PriceQuantityRange PQR on PQR.RangeStart = (SELECT TOP 1 CAST(value AS INT) FROM STRING_SPLIT(ImportItemsPricesTemplate.QuantityRange, '-')) 
                                and PQR.RangeEnd = (SELECT top 1 CAST(REVERSE(value) AS INT) FROM STRING_SPLIT(REVERSE(ImportItemsPricesTemplate.QuantityRange), '-'))
                                and Division.DivisionID in ({_requestRepository.CurrentOperator.DivisionAccess })
                                  ";
                string countQuery = $"select Count(*) ItemsCount from ImportItemsPricesTemplate ";

                result = dBHelperCount.ExecuteScalar(countQuery, ref itemsCount);
                if (result == GlobalErrors.Success && itemsCount != null && int.Parse(itemsCount.ToString()) > 0)
                {
                    result = dBHelper.GetQueryList(query, ref items);
                    importedCount = items.Count();
                    notImportedCount = int.Parse(itemsCount.ToString()) - importedCount;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #region [Promotion Groups]
        public GlobalErrors GetPromotionGroupsList(GeneralFilter filter, ref SharedTableResult<PromotionGroupModel> PromotionGroupsListTable)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<PromotionGroupModel> dbHelper = null;
            List<PromotionGroupModel> promotionGroups = new List<PromotionGroupModel>();
            try
            {
                dbHelper = new DBHelper<PromotionGroupModel>();

                string searchFilter = string.Empty;
                string itemsWithUpperLimitFilter = string.Empty;
                string itemExtraInfoSelection = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( PromotionGroup.Code LIKE '%{0}%' )
                        OR ( PromotionGroupLanguage.Description LIKE '%{0}%'))",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By PromotionGroupName Asc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string mainQuery = string.Format(@"select PromotionGroup.PromotionGroupID , IsNull( PromotionGroupLanguage.Description , '--') as PromotionGroupName, PromotionGroup.Code PromotionGroupCode
                 from  PromotionGroup
                 inner join PromotionGroupLanguage on PromotionGroup.PromotionGroupID= PromotionGroupLanguage.PromotionGroupID and PromotionGroupLanguage.LanguageID = {0}
                 {1}",
                 _requestRepository.LanguageId, //0
                 searchFilter //1
                 );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    PromotionGroupsListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    if (PromotionGroupsListTable.TotalItems <= 0)
                    {
                        PromotionGroupsListTable.Data = promotionGroups;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref promotionGroups , true);
                PromotionGroupsListTable.Data = promotionGroups;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                PromotionGroupsListTable = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertPromotionGroup(PromotionGroupModel PromotionGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string query = string.Format(@"insert into PromotionGroup(PromotionGroupID,Code) values({0},'{1}')", PromotionGroup.PromotionGroupId, PromotionGroup.PromotionGroupCode);

                result = dbHelper.ExecuteNonQuery(query);

                if (result == GlobalErrors.Success)
                    result = InsertPromotionGroupDetails(PromotionGroup, dbHelper);
                if (result == GlobalErrors.Success)
                    result = InsertPromotionGroupLanguage(PromotionGroup, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertPromotionGroupDetails(PromotionGroupModel PromotionGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                 if (PromotionGroup.PromotionIdsList != null && PromotionGroup.PromotionIdsList.Count > 0) {
                        foreach (var promotion in PromotionGroup.PromotionIdsList)
                        {
                            int promotionId = promotion.PromotionId;
                            int priority = promotion.Priority;
                            query = string.Format(@"INSERT INTO PromotionGroupAssignment (PromotionGroupID, PromotionID, Priority) VALUES ({0},{1},{2})", PromotionGroup.PromotionGroupId, promotionId, (priority == 0 ? "Null" : priority.ToString()));
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                                break;
                        }
                 }
                
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertPromotionGroupLanguage(PromotionGroupModel PromotionGroup, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string sqlStatment = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (TextLanguage textLanguage in PromotionGroup.languageDescriptions)
                {
                    values.AppendFormat("( {0},{1},'{2}' ),",
                    PromotionGroup.PromotionGroupId, //0
                    textLanguage.LanguageId, //1
                    string.IsNullOrEmpty(textLanguage.Description.Trim()) ? PromotionGroup.PromotionGroupName.Replace("'", "''") : textLanguage.Description.Replace("'", "''") //2
                    );
                }
                sqlStatment = string.Format("insert into PromotionGroupLanguage(PromotionGroupID, LanguageID, Description) Values {0}", values.ToString().TrimEnd(','));  
                 result = dbHelper.ExecuteNonQuery(sqlStatment.ToString());


                //string query = string.Empty;
                //StringBuilder values = new StringBuilder();
                //foreach (TextLanguage descriptionObject in desciptionsList)
                //{
                //    values.AppendFormat("( {0},{1},'{2}' ),",
                //    promotionId, //0
                //    descriptionObject.LanguageId, //1
                //    string.IsNullOrEmpty(descriptionObject.Description.Trim()) ? promotionName.Replace("'", "''") : descriptionObject.Description.Replace("'", "''") //2
                //    );
                //}
                //query = string.Format(@"Insert Into PromotionLanguage (PromotionID,LanguageID,Description) Values {0}", values.ToString().TrimEnd(','));
                //result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAssignedPromotions(int PromotionGroupId, ref List<PromotionGroupModel> promotionsList)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<PromotionGroupModel> dbHelper = null;
            try
            {
                string query = string.Empty;
                dbHelper = new DBHelper<PromotionGroupModel>();

                query = string.Format(@" SELECT Promotion.PromotionID PromotionId, Promotion.PromotionCode,PromotionLanguage.Description as PromotionName, Promotion.StartDate as StartDate,Promotion.EndDate as EndDate, PromotionGroupAssignment.Priority as Priority
                                        FROM Promotion
                                        left outer JOIN  PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID and PromotionLanguage.LanguageID = {0} 
                                        INNER JOIN PromotionGroupAssignment ON Promotion.PromotionID = PromotionGroupAssignment.PromotionID
                                        WHERE(PromotionGroupAssignment.PromotionGroupID = {1}) 
                                        and (Promotion.Inactive is null or promotion.Inactive = 0) 
                                        and (Promotion.IsDeleted is null or Promotion.IsDeleted = 0)
                                        order by PromotionGroupAssignment.Priority",
                                             _requestRepository.LanguageId,
                                             PromotionGroupId);

                result = dbHelper.GetQueryList(query, ref promotionsList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetPromotionGroupDescriptions(int PromotionGroupId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from PromotionGroupLanguage
                where PromotionGroupID = {0}", PromotionGroupId);
                result = dbHelper.GetQueryList(query, ref descriptions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetUnAssignedPromotions(PromotionFilterModel filter, ref SharedTableResult<PromotionGroupModel> promotionSharedListTable)
        {
            promotionSharedListTable = new SharedTableResult<PromotionGroupModel>();
            List<PromotionGroupModel> promotionsList = new List<PromotionGroupModel>();
            DBHelper<PromotionGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string customerJoin = string.Empty;
            string excludePromotion = string.Empty;
            try
            {
                dbHelper = new DBHelper<PromotionGroupModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( Promotion.PromotionCode LIKE '%{0}%' )
                        OR ( PromotionLanguage.Description LIKE '%{0}%')
                        )",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (CustomerPromotion.CustomerID = {0} or CustomerPromotion.AllCustomers = 1) ", filter.CustomerId);
                    }
                    if (filter.CustomerGroupId != -1)
                    {
                        searchFilter += string.Format(" And (CustomerPromotion.CustomerGroupID = {0}) ", filter.CustomerGroupId);
                    }
                    if (filter.CustomerId != -1 || filter.CustomerGroupId != -1)
                    {
                        customerJoin = string.Format(@" inner JOIN CustomerPromotion ON CustomerPromotion.PromotionID = Promotion.PromotionID");
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By StartDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    
                }
                if (_requestRepository.Configurations.ApplyPriorityOnPromotionGroups)
                {
                    excludePromotion = string.Format(@" And (Promotion.PromotionID not in(select PromotionID from PromotionGroupAssignment ))");
                }
                string query = string.Empty;
                dbHelper = new DBHelper<PromotionGroupModel>();

                query = string.Format(@" SELECT DISTINCT Promotion.PromotionID PromotionId,Promotion.PromotionCode PromotionCode,  Promotion.StartDate StartDate, Promotion.EndDate EndDate,PromotionLanguage.Description PromotionName, 
                                        PromotionLanguage.LanguageID,1 ValueType,1 DisableValuesUsed
                                        FROM Promotion 
                                        left outer JOIN PromotionLanguage ON Promotion.PromotionID = PromotionLanguage.PromotionID  AND PromotionLanguage.LanguageID = {0}
                                        {3}
                                        WHERE Promotion.IsDeleted <> 1 and Promotion.Inactive <> 1 and Promotion.IsBundle <> 1 {1} {2}", _requestRepository.LanguageId, searchFilter, excludePromotion, customerJoin);
                result = dbHelper.GetQueryList(query, ref promotionsList);

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                 query, //0
                 orderByFilter, //1
                 filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                 filter.CustomListFilter.PageSize //3
                 );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", query);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    promotionSharedListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    if (promotionSharedListTable.TotalItems <= 0)
                    {
                        promotionSharedListTable.Data = promotionsList;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref promotionsList);
                promotionSharedListTable.Data = promotionsList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                promotionSharedListTable = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdatePromotionGroup(PromotionGroupModel PromotionGroup)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Empty;
                string updateQuery = string.Empty;

                deleteQuery = string.Format(@"delete from PromotionGroupAssignment where PromotionGroupID = {0}", PromotionGroup.PromotionGroupId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    deleteQuery = string.Format(@"delete from PromotionGroupLanguage where PromotionGroupID = {0}", PromotionGroup.PromotionGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    updateQuery = string.Format(@"Update PromotionGroup Set Code = '{0}' Where PromotionGroupID = {1}", PromotionGroup.PromotionGroupCode, PromotionGroup.PromotionGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(updateQuery);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = InsertPromotionGroupLanguage(PromotionGroup, dbHelper);
                if (result == GlobalErrors.Success )
                    result = InsertPromotionGroupDetails(PromotionGroup, dbHelper);
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors DeletePromotionGroup(int PromotionGroupId, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                object field = null;
                string query = string.Empty;
                if (IsPromotionGroupLinkedWithCustomerTemplate(PromotionGroupId))
                {
                    errorMessage = ResourcesManager.TranslateKey(MessagesConstants.Desc_Message_Promotion_Group_Assigned_To_Customer, _requestRepository.LanguageId);
                    return GlobalErrors.Success;
                }
                query = $@"select count(tt.promotionGroupCount) from (
                           select PromotionGroupID promotionGroupCount from PromotionGroupAssignment where PromotionGroupID = {PromotionGroupId}
                           )tt";
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null)
                {
                    if (Int32.Parse(field.ToString()) > 0)
                    {
                        string queryDeleteGroupAssignment = string.Format(@"delete from PromotionGroupAssignment where  PromotionGroupID = {0}", PromotionGroupId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupAssignment);
                    }
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    string queryDeleteGroupName = string.Format(@"delete from PromotionGroupLanguage where PromotionGroupID = {0}", PromotionGroupId);
                    string deletePromotionGroupQuery = string.Format(@"delete PromotionGroup where PromotionGroupID = {0}", PromotionGroupId);

                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupName);
                    if (result == GlobalErrors.Success)
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deletePromotionGroupQuery);
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public static bool IsPromotionGroupLinkedWithCustomerTemplate(int promotionGroupID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                object field = null;
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"SELECT COUNT(*) FROM NewCustomerTemplate WHERE PromotionGroupID = {0}", promotionGroupID);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null  && !string.IsNullOrEmpty(field.ToString()))
                {
                    if (int.Parse(field.ToString()) > 0)
                        return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return false;
        }
        public GlobalErrors DeletePromotionAssignment(int PromotionId, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string queryDeleteGroupAssignment = string.Format(@"delete from PromotionGroupAssignment where  PromotionID = {0}", PromotionId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryDeleteGroupAssignment);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion

        #region [Contracted Foc]
        public GlobalErrors GetContractedFocList(ContractedFOCFilterModel filter, ref SharedTableResult<ContractedFOCModel> contractedFocList)
        {
            contractedFocList = new SharedTableResult<ContractedFOCModel>();
            List<ContractedFOCModel> contractedFoc = new List<ContractedFOCModel>();
            DBHelper<ContractedFOCModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ContractedFOCModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string pendingQuery = string.Empty;
                string statusFilter = string.Empty;
                string contractStatusNameFilter = string.Empty;
                string isPendingFilter = string.Empty;
                string isApprovePendingFilter = string.Empty;
                string isApproveOrginalFilter = string.Empty;
                string showEditFilter = string.Empty;
                string showDeleteFilter = string.Empty;
                string isExistInPendingListFilter = string.Empty;
                string territoryFilter = string.Empty;
                int currentStatus = -1;
                StringBuilder orgAccessJoin = new StringBuilder();
                string contractedFilter = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        contractedFilter += string.Format(@"and ( (ContractedFOCLanguage.Description LIKE '%{0}%')
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' )
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    OR ( OrganizationLanguage.Description LIKE '%{0}%')
                    OR ( ContractTypeLanguage.Description LIKE '%{0}%')
                    OR ( PeriodTypeLanguage.Description LIKE '%{0}%')
                   )", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.CustomerId != -1)
                    {
                        contractedFilter += " And ContractedFOC.CustomerID= " + filter.CustomerId;
                    }
                    if (filter.OutletId != -1)
                    {
                        contractedFilter += " And ContractedFOC.OutletID= " + filter.OutletId;
                    }
                    if (filter.TerritoryId != -1)
                    {
                        if (_requestRepository.Configurations.ApplyTerritoryForContractedFOC)
                        {
                            contractedFilter += " And ContractedFOC.TerritoryID= " + filter.TerritoryId;
                        }
                        else
                        {
                            territoryFilter += string.Format(@" INNER JOIN CustOutTerritory ON ContractedFOC.CustomerID = CustOutTerritory.CustomerID And ContractedFOC.OutletID = CustOutTerritory.OutletID And CustOutTerritory.TerritoryID = {0} ", filter.TerritoryId);
                        }
                    }
                    if (filter.DivisionId != -1)
                    {
                        contractedFilter += " And ContractedFOC.DivisionID= " + filter.DivisionId;
                    }
                    if (filter.OrganizationId != -1)
                    {
                        contractedFilter += " And ContractedFOC.OrganizationID= " + filter.OrganizationId;
                    }
                    if (filter.ContractTypeId != -1)
                    {
                        contractedFilter += " And ContractedFOC.ContractTypeId= " + filter.ContractTypeId;
                    }
                    if (filter.PeriodTypeId != -1)
                    {
                        contractedFilter += " And ContractedFOC.PeriodTypeID= " + filter.PeriodTypeId;
                    }
                    if (!filter.IncludeInactive)
                    {
                        contractedFilter += " And ISNULL (ContractedFOC.Inactive, 0) = 0 ";
                    }
                    if (!string.IsNullOrEmpty(filter.ContractName))
                    {
                        contractedFilter += string.Format(" And ContractedFOCLanguage.Description like('%{0}%') ", filter.ContractName);
                    }
                    if (filter.FromDate != null)
                    {
                        contractedFilter += string.Format(" AND ContractedFOC.ValidFrom <= {0}  ",
                        LocalUtilities.ParseDateToSQLString(filter.FromDate.Date));
                    }
                    if (filter.ToDate != null)
                    {
                        contractedFilter += string.Format(" AND ContractedFOC.ValidTo >= {0} ",
                        LocalUtilities.ParseDateToSQLString(filter.ToDate.Date));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"ORDER BY ContractedFOC.ContractID");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string activeStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Active, _requestRepository.LanguageId);
                string pendingAddStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Add_Level, _requestRepository.LanguageId);
                string pendingEditStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Edit_Level, _requestRepository.LanguageId);
                string pendingDeleteStr = ResourcesManager.TranslateKey(MessagesConstants.Desc_Pending_Delete_Level, _requestRepository.LanguageId);

                if (_requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("5"))
                {
                    int level = -1;
                    currentStatus = GetCurrentStatus();
                    if (currentStatus == -1)
                        level = GetMaxApprovalCycleLevels(ApprovalCycleOperations.ContractedFOC.GetHashCode());// For Max Level
                    else
                        level = currentStatus;
                    pendingQuery = string.Format(@" union all
                   select IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                   IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                   IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull(OrganizationLanguage.Description, '--') as OrganizationCodeName,
                   ContractedFOC_Pending.ContractID,
                   ContractedFOCLanguage_Pending.Description ContractName,
                   ContractedFOC_Pending.DivisionID,
                   ContractedFOC_Pending.TerritoryID,
                   ContractedFOC_Pending.OrganizationID,
                   ContractedFOC_Pending.ValidFrom StartDate,
                   ContractedFOC_Pending.ValidTo EndDate,
                   ContractedFOC_Pending.IsOneTime,
                   ContractedFOC_Pending.CustomerID,
                   ContractedFOC_Pending.OutletID,
                   ContractedFOC_Pending.PeriodTypeID,
                   ContractTypeLanguage.Description ContractType,
                   ContractedFOC_Pending.ContractTypeID,
                   ContractedFOC_Pending.ForceGivingAllFOC ForceFoc,
				   ContractedFOC_Pending.Inactive,
				   ContractedFOC_Pending.IsTransferable,
                   ContractedFOC_Pending.IsDeleted,
                   ContractedFOC_Pending.Status,
                   ContractedFOCLanguage_Pending.Description AS ContractedFOCListName,
                   CASE WHEN CF.ContractID is null and ContractedFOC_Pending.IsDeleted = 0 THEN  CONCAT('{4}', ContractedFOC_Pending.Status)
                   WHEN CF.ContractID is not null and ContractedFOC_Pending.IsDeleted = 0  THEN  CONCAT('{5}', ContractedFOC_Pending.Status)
                   WHEN ContractedFOC_Pending.IsDeleted = 1 THEN  CONCAT('{6}', ContractedFOC_Pending.Status) ELSE '{3} ' END AS ContractedFOCStatusName,
                   PeriodTypeLanguage.Description ContractPeriod,
                   CASE IsNull(ContractedFOC_Pending.Status, -1) WHEN - 1 THEN 0 ELSE 1 END AS IsPending,
                   CASE WHEN   ContractedFOC_Pending.Status = {2}
                   THEN 1 ELSE 0 END AS IsApprove,
                   CASE WHEN ContractedFOC_Pending.CreationLevel = {2}
                   and ContractedFOC_Pending.Status = {2}
                   and ContractedFOC_Pending.IsDeleted = 0 THEN 1 ELSE 0 END AS ShowEdit,

                   CASE WHEN  ContractedFOC_Pending.Status = {2}
                   or ContractedFOC_Pending.Status = -1 THEN 1 ELSE 0 END AS ShowDelete,
                   CASE WHEN  ContractedFOC_Pending.CreationLevel = {2}
                   THEN 1 ELSE 0 END AS IsCreationLevel,
                   CASE WHEN(select top 1 ContractID from ContractedFOC where ContractID = ContractedFOC_Pending.ContractID ) = ContractedFOC_Pending.ContractID
                   THEN 1 ELSE 0 END AS ShowViewOriginal
                   FROM ContractedFOC_Pending
                   left outer join ContractedFOC CF on CF.ContractID = ContractedFOC_Pending.ContractID
                   LEFT OUTER JOIN CustomerLanguage ON CustomerLanguage.CustomerID  = ContractedFOC_Pending.CustomerID AND CustomerLanguage.LanguageID = {0}
                   Inner Join Customer On Customer.CustomerID = ContractedFOC_Pending.CustomerID
                   LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutletLanguage.CustomerID  = ContractedFOC_Pending.CustomerID AND CustomerOutletLanguage.OutletID  = ContractedFOC_Pending.OutletID AND CustomerOutletLanguage.LanguageID = {0}
                   Inner Join CustomerOutlet on CustomerOutlet.CustomerID = ContractedFOC_Pending.CustomerID AND CustomerOutlet.OutletID = ContractedFOC_Pending.OutletID
                   INNER JOIN ContractedFOCLanguage_Pending ON ContractedFOC_Pending.ContractID = ContractedFOCLanguage_Pending.ContractID and ContractedFOCLanguage_Pending.LanguageID = {0}
                   Inner Join Organization on Organization.OrganizationID = ContractedFOC_Pending.OrganizationID
                   Inner Join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID = ContractedFOC_Pending.ContractTypeID And ContractTypeLanguage.LanguageID = {0}
                   LEFT Join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID = ContractedFOC_Pending.PeriodTypeID AND PeriodTypeLanguage.LanguageID = {0}
                   INNER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = ContractedFOC_Pending.OrganizationID and OrganizationLanguage.LanguageID = {0}
                   AND OrganizationLanguage.LanguageID = {0}",
                    _requestRepository.LanguageId,//0
                    _requestRepository.CurrentOperator.OrganizationAccess,//1
                    level,//2
                    activeStr,//3
                    pendingAddStr,//4
                    pendingEditStr,//5
                    pendingDeleteStr); //6
                    if (currentStatus == -1)
                        isApprovePendingFilter = " CASE WHEN ContractedFOC_Pending.Status = (Select Top 1 LevelID from ApprovalCycleLevels where OperationID = 5 order by LevelID desc) THEN 1 ELSE 0 END AS IsApprove";
                    else isApprovePendingFilter = string.Format(" CASE WHEN  ContractedFOC_Pending.Status = {0} THEN 1 ELSE 0 END AS IsApprove", currentStatus);

                    statusFilter = " ContractedFOC.Status ";
                    contractStatusNameFilter = string.Format(@" CASE IsNull(ContractedFOC.Status, - 1) WHEN - 1 THEN '{0} ' ELSE CONCAT('Waiting for approval - level ', ContractedFOC.Status) END AS ContractedFOCStatusName ", activeStr);
                    isPendingFilter = " 0 as IsPending ";
                    isApproveOrginalFilter = "CASE IsNull(ContractedFOC.Status, - 1) WHEN - 1  THEN 0 ELSE 1 END AS IsApprove";

                    showEditFilter = " CASE WHEN IsNull(ContractedFOC.Status, - 1) = -1  THEN 1 ELSE 0 END AS ShowEdit ";
                    showDeleteFilter = " CASE WHEN IsNull(ContractedFOC.Status, - 1) = -1  THEN 1 ELSE 0 END AS ShowDelete ";
                    isExistInPendingListFilter = " and (ContractedFOC.ContractID NOT IN (SELECT ContractID FROM ContractedFOC_Pending))";
                }
                else
                {
                    statusFilter = " -1 as Status ";
                    contractStatusNameFilter = " 0 AS ContractedFOCStatusName  ";
                    isPendingFilter = " 0 as IsPending ";
                    isApproveOrginalFilter = " 0 AS IsApprove ";
                    showEditFilter = " 1 AS ShowEdit ";
                    showDeleteFilter = " 1 AS ShowDelete ";
                }
                string mainQuery = string.Format(@"(SELECT IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull(OrganizationLanguage.Description, '--') as OrganizationCodeName,
                ContractedFOC.ContractID,
                ContractedFOCLanguage.Description ContractName,
                ContractedFOC.DivisionID,
                ContractedFOC.TerritoryID,
                ContractedFOC.OrganizationID,
                ContractedFOC.ValidFrom StartDate,
                ContractedFOC.ValidTo EndDate,
                ContractedFOC.IsOneTime,
                ContractedFOC.CustomerID,
                ContractedFOC.OutletID,
                ContractedFOC.PeriodTypeID,
                ContractTypeLanguage.Description ContractType,
                ContractedFOC.ContractTypeID,
                ContractedFOC.ForceGivingAllFOC ForceFoc,
				ContractedFOC.Inactive,
				ContractedFOC.IsTransferable,
                ContractedFOC.IsDeleted,
                {3},
                ContractedFOCLanguage.Description AS ContractedFOCListName,
                {4},        
                PeriodTypeLanguage.Description ContractPeriod,
                {6},
                {7} ,
                {9},
                {5},
                0 AS IsCreationLevel, 0 AS ShowViewOriginal 
                From ContractedFOC
                LEFT OUTER JOIN CustomerLanguage ON CustomerLanguage.CustomerID  = ContractedFOC.CustomerID AND CustomerLanguage.LanguageID = {0}
                Inner Join Customer On Customer.CustomerID = ContractedFOC.CustomerID
                LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutletLanguage.CustomerID  = ContractedFOC.CustomerID AND CustomerOutletLanguage.OutletID  = ContractedFOC.OutletID AND CustomerOutletLanguage.LanguageID = {0}
	            Inner Join CustomerOutlet on CustomerOutlet.CustomerID = ContractedFOC.CustomerID AND CustomerOutlet.OutletID = ContractedFOC.OutletID
                INNER JOIN ContractedFOCLanguage ON ContractedFOC.ContractID = ContractedFOCLanguage.ContractID and ContractedFOCLanguage.LanguageID = {0}
                Inner Join Organization on Organization.OrganizationID = ContractedFOC.OrganizationID
                Inner Join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID = ContractedFOC.ContractTypeID And ContractTypeLanguage.LanguageID = {0}
                LEFT Join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID = ContractedFOC.PeriodTypeID AND PeriodTypeLanguage.LanguageID ={0}
                INNER JOIN OrganizationLanguage ON OrganizationLanguage.OrganizationID = ContractedFOC.OrganizationID and OrganizationLanguage.LanguageID = {0}
                {12}
                Where 1=1 and (IsDeleted = 0) and Organization.OrganizationID in (Select OrganizationID From EmployeeOrganization Where EmployeeID = {1}) {8} {11}
                {2})ContractedFOC where(OrganizationID IN ({10}))",
                _requestRepository.LanguageId, //0
                _requestRepository.CurrentOperator.EmployeeId, //1
                 pendingQuery, //2
                 statusFilter, //3
                 contractStatusNameFilter,//4
                 isPendingFilter,//5
                isApproveOrginalFilter,//6
                showEditFilter,//7
                isExistInPendingListFilter,//8
                showDeleteFilter, //9
                _requestRepository.CurrentOperator.OrganizationAccess, //10
                contractedFilter, //11
                territoryFilter //12
                );

                string invoicesQuery = string.Format(@"Select ROW_NUMBER() Over(Order By ContractedFOC.ContractID) AS RowSeq, ContractedFOC.*, CASE WHEN ContractedFOC.IsApprove = 1 and ContractedFOC.IsCreationLevel = 0 then 1 else 0 end as ShowApprove ,
                CASE WHEN ContractedFOC.IsApprove = 1 and ContractedFOC.IsCreationLevel = 1 then 1 else 0 end as ShowRequest
                from 
                {0} {1} 
                OFFSET  {2} ROWS       
                FETCH NEXT {3} ROWS ONLY",
                mainQuery,
                orderByFilter,
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
                filter.CustomListFilter.PageSize);
                //string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                //mainQuery, //0
                //orderByFilter, //1
                //filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                //filter.CustomListFilter.PageSize //3
                //);

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From {0}", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);

                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    contractedFocList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (contractedFocList.TotalItems <= 0)
                    {
                        contractedFocList.Data = contractedFoc;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref contractedFoc);
                contractedFocList.Data = contractedFoc;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFocList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractTypes(ref List<ContractTypeModel> contractTypes)
        {
            DBHelper<ContractTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ContractTypeModel>();
                string sqlString = string.Format(@"select ContractType.ContractTypeID,ContractTypeLanguage.Description ContractTypeName from ContractType
                left outer join ContractTypeLanguage on ContractType.ContractTypeID=ContractTypeLanguage.ContractTypeID and ContractTypeLanguage.LanguageID={0}", _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(sqlString, ref contractTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractTypes = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GetContractedFocListStatus(int contractID, ref int status, ref bool isDeleted)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            DBHelper<ContractedFOCModel> dBHelper;
            string query = string.Empty;
            ContractedFOCModel contractListModel = new ContractedFOCModel();
            try
            {
                contractListModel = new ContractedFOCModel();
                dBHelper = new DBHelper<ContractedFOCModel>();
                bool flag = CheckIsContracedFocListPendingExisit(contractID);
                if (flag)
                {
                    query = string.Format("SELECT * FROM ContractedFOC_Pending WHERE (ContractID = {0})", contractID);
                }
                else
                {
                    query = string.Format("SELECT * FROM ContractedFOC WHERE (ContractID = {0})", contractID);
                }
                result = dBHelper.GetQuerySingle(query, ref contractListModel);
                if (result == GlobalErrors.Success && contractListModel != null)
                {
                    status = contractListModel.Status > 0 ? contractListModel.Status : -1;
                    isDeleted = contractListModel.IsDeleted;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }

        }
        public bool CheckIsContracedFocListPendingExisit(int contractID)
        {

            DBHelper<ContractedFOCModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            ContractedFOCModel contractList = new ContractedFOCModel();
            try
            {
                string query = string.Empty;
                dBHelper = new DBHelper<ContractedFOCModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select ContractedFOC_Pending.*,ContractedFOCLanguage_Pending.Description ContractName,
                ContractTypeLanguage.Description ContractType,OrganizationLanguage.Description OrganizationName from ContractedFOC_Pending
                left outer join ContractedFOCLanguage_Pending on ContractedFOCLanguage_Pending.ContractID=ContractedFOC_Pending.ContractID and ContractedFOCLanguage_Pending.LanguageID = {0}
                left outer join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID=ContractedFOC_Pending.ContractTypeID and ContractTypeLanguage.LanguageID = {0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=ContractedFOC_Pending.OrganizationID and OrganizationLanguage.LanguageID = {0}
                where ContractedFOC_Pending.ContractID = {1}", _requestRepository.LanguageId, contractID);
                result = dBHelper.GetQuerySingle(query, ref contractList);
                if (result == GlobalErrors.Success && contractList != null)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractList = null;
                return false;
            }
        }
        public GlobalErrors InsertContractedFOCCycleHistory(int ContractID, int ActionNo, int UpdatedBy, int Level, int OldStatus, int NewStatus, string Note, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int HistoryID = GetMaxPriceCycleHistoryID(ContractID);
                string query = string.Format(@" insert into ContractedFOCCycleHistory([HistoryID],[ContractID],[ActionNo],[UpdatedBy],[UpdatedDate],[Level],[OldStatus],[NewStatus],[Note])
                    values({0},{1},{2},{3},GETDATE(),{4},{5},{6},'{7}')", HistoryID, ContractID, ActionNo, UpdatedBy, Level, OldStatus, NewStatus, Note);
                result = dBHelper.ExecuteNonQuery(query);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertContractedFOC(ContractedFOCModel contractedFOC, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<SimpleCustomerModel> appliedCustomer = new List<SimpleCustomerModel>();

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int status = GetCurrentStatus();
                if (GetMaxID("ContractID", "ContractedFOC", dBHelper) > GetMaxID("ContractID", "ContractedFOC_Pending", dBHelper))
                {
                    int contractNumber = GetMaxID("ContractID", "ContractedFOC", dBHelper);
                }
                else
                {
                    int contractNumber = GetMaxID("ContractID", "ContractedFOC_Pending", dBHelper);
                }
                if (contractedFOC.AllCustomers)
                {
                    result = GetAllCustomerForContractedFoc(contractedFOC, ref appliedCustomer);
                    if (result != GlobalErrors.Success)
                        return GlobalErrors.Error;
                    foreach (var customer in appliedCustomer)
                    {
                        contractedFOC.AppliedCustomers.Add(customer);
                    }
                }
                else
                {
                    if ((contractedFOC.AppliedChannels != null && contractedFOC.AppliedChannels.Count > 0) || (contractedFOC.AppliedGroups != null && contractedFOC.AppliedGroups.Count > 0))
                    {
                        result = GetCustomerForContractedFoc(contractedFOC, ref appliedCustomer);
                        if (result != GlobalErrors.Success || appliedCustomer.Count == 0)
                            return GlobalErrors.NoMoreRows;
                        foreach (var customer in appliedCustomer)
                        {
                            contractedFOC.AppliedCustomers.Add(customer);
                        }
                    }
                }
                foreach (SimpleCustomerModel customer in contractedFOC.AppliedCustomers)
                {
                    contractedFOC.ContractId = GetMaxID("ContractID", "ContractedFOC", dBHelper);

                    string query = string.Format(@"INSERT INTO ContractedFOC (CustomerID,OutletID,ContractID,PeriodTypeID,ContractTypeID,ForceGivingAllFOC,Inactive,ValidFrom,ValidTo,
                    IsTransferable,IsOneTime,UpdateDate,DivisionID,TerritoryID,IsDeleted,Status,CreateBy,CreateDate,OrganizationID) VALUES
                    ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},'{15}',{16},{17},{18})", customer.CustomerId, customer.OutletId, contractedFOC.ContractId, contractedFOC.PeriodTypeId, contractedFOC.ContractTypeId, contractedFOC.ForceFoc ? "1" : "0", contractedFOC.Inactive ? "1" : "0", LocalUtilities.ParseDateToSQLString(contractedFOC.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFOC.EndDate.Value),
                    contractedFOC.IsTransferable ? "1" : "0", contractedFOC.IsOneTime ? "1" : "0", LocalUtilities.ParseDateToSQLString(DateTime.Now), contractedFOC.DivisionId, contractedFOC.TerritoryId, contractedFOC.IsDeleted ? "1" : "0", status, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), contractedFOC.OrganizationId);
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                        break;

                    if (result == GlobalErrors.Success)
                    {
                        //Save language
                        foreach (TextLanguage language in contractedFOC.DescriptionLanguages)
                        {
                             query = string.Format(@"insert into ContractedFOCLanguage(ContractID,LanguageId,Description) values ({0},{1},'{2}')", contractedFOC.ContractId, language.LanguageId, language.Description.Equals("") ? contractedFOC.ContractName.Replace("'", "''") : language.Description.Replace("'", "''"));
                            result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) return result;
                        }
                        //Save Items
                        if (contractedFOC.AddedItemsList != null && contractedFOC.AddedItemsList.Count > 0)
                        {
                            foreach (var items in contractedFOC.AddedItemsList)
                            {
                                contractedFOC.RemainingQuantity = items.RequiredQty;
                                query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity) values ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, contractedFOC.ContractId, items.PackId, items.RequiredQty, contractedFOC.RemainingQuantity);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;

                            }
                        }
                        else
                        {
                            if (contractedFOC.ContractTypeId == 2)
                            {
                                contractedFOC.RemainingValue = contractedFOC.Value;
                                query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, contractedFOC.ContractId, -1, contractedFOC.RequiredQty, contractedFOC.RemainingQuantity, contractedFOC.Value == -1 ? 0 : contractedFOC.Value, contractedFOC.RemainingValue == -1 ? 0 : contractedFOC.RemainingValue, contractedFOC.SubTypeId, contractedFOC.PercentageValue != -1 ? contractedFOC.PercentageValue : 0);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                            if (contractedFOC.ContractTypeId == 3)
                            {
                                contractedFOC.ShelfRemainingValue = contractedFOC.ShelfValue;
                                query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, contractedFOC.ContractId, -1, contractedFOC.RequiredQty, contractedFOC.RemainingQuantity, contractedFOC.ShelfValue == -1 ? 0 : contractedFOC.ShelfValue, contractedFOC.ShelfRemainingValue, -1, 0);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;
                            }
                        }
                        //result = InsertContractedFocDetails(contractedFOC, dBHelper);
                        if (result == GlobalErrors.Success)
                        {
                            result = GlobalErrors.Success;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertContractedFOCPending(ContractedFOCModel contractedFocObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            List<SimpleCustomerModel> appliedCustomer = new List<SimpleCustomerModel>();
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                int status = GetCurrentStatus();
                if (contractedFocObj.ContractId < 1)
                {
                    if (GetMaxID("ContractID", "ContractedFOC", dBHelper) > GetMaxID("ContractID", "ContractedFOC_Pending", dBHelper))
                    {
                        contractedFocObj.ContractId = GetMaxID("ContractID", "ContractedFOC", dBHelper);
                    }
                    else
                    {
                        contractedFocObj.ContractId = GetMaxID("ContractID", "ContractedFOC_Pending", dBHelper);
                    }
                }
                if (contractedFocObj.AllCustomers)
                {
                    result = GetAllCustomerForContractedFoc(contractedFocObj, ref appliedCustomer);
                    if (result != GlobalErrors.Success)
                        return GlobalErrors.Error;
                    foreach (var customer in appliedCustomer)
                    {
                        contractedFocObj.AppliedCustomers.Add(customer);
                    }
                }
                else
                {
                    if ((contractedFocObj.AppliedChannels != null && contractedFocObj.AppliedChannels.Count > 0) || (contractedFocObj.AppliedGroups != null && contractedFocObj.AppliedGroups.Count > 0))
                    {
                        result = GetCustomerForContractedFoc(contractedFocObj, ref appliedCustomer);
                        if (result != GlobalErrors.Success || appliedCustomer.Count == 0)
                            return GlobalErrors.Error;
                        foreach (var customer in appliedCustomer)
                        {
                            contractedFocObj.AppliedCustomers.Add(customer);
                        }
                    }
                }
                if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("5"))
                {
                    foreach (SimpleCustomerModel customer in contractedFocObj.AppliedCustomers)
                    {
                        query = string.Format(@"INSERT INTO ContractedFOC_Pending (CustomerID,OutletID,ContractID,PeriodTypeID,ContractTypeID,ForceGivingAllFOC,Inactive,ValidFrom,ValidTo,
                        IsTransferable,IsOneTime,UpdateDate,DivisionID,TerritoryID,IsDeleted,CreateBy,CreateDate,OrganizationID,[Status],CreationLevel) VALUES
                        ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},0,{14},{15},{16},{17},{17})", customer.CustomerId, customer.OutletId, contractedFocObj.ContractId, contractedFocObj.PeriodTypeId, contractedFocObj.ContractTypeId, contractedFocObj.ForceFoc ? "1" : "0", contractedFocObj.Inactive ? "1" : "0", LocalUtilities.ParseDateToSQLString(contractedFocObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFocObj.EndDate.Value),
                        contractedFocObj.IsTransferable ? "1" : "0", contractedFocObj.IsOneTime ? "1" : "0", LocalUtilities.ParseDateToSQLString(DateTime.Now), contractedFocObj.DivisionId, contractedFocObj.TerritoryId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateToSQLString(DateTime.Now), contractedFocObj.OrganizationId,status);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
                if (status != -1 && _requestRepository.Configurations.ApplyApprovalCycleInWeb.Contains("5"))
                {
                    foreach (TextLanguage language in contractedFocObj.DescriptionLanguages)
                    {
                        query = string.Format(@"insert into ContractedFOCLanguage_Pending(ContractID,LanguageId,Description) values ({0},{1},'{2}')", contractedFocObj.ContractId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    foreach (SimpleCustomerModel customer in contractedFocObj.AppliedCustomers)
                    {
                        if (contractedFocObj.AddedItemsList != null && contractedFocObj.AddedItemsList.Count > 0)
                        {
                            foreach (var items in contractedFocObj.AddedItemsList)
                            {
                                contractedFocObj.RemainingQuantity = items.RequiredQty;
                                query = string.Format(@"Insert into ContractedFOCDetail_Pending (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity) values ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, contractedFocObj.ContractId, items.PackId, items.RequiredQty, contractedFocObj.RemainingQuantity);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                    break;

                            }
                        }
                        else
                        {
                            if (contractedFocObj.ContractTypeId == 2)
                            {
                                query = string.Format(@"Insert into ContractedFOCDetail_Pending (CustomerID,OutletID,ContractID,
                                PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, contractedFocObj.ContractId, -1, contractedFocObj.RequiredQty, contractedFocObj.RemainingQuantity, contractedFocObj.Value == -1 ? 0 : contractedFocObj.Value, contractedFocObj.RemainingValue == -1 ? 0 : contractedFocObj.RemainingValue, contractedFocObj.SubTypeId, contractedFocObj.PercentageValue);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                break;
                            }
                            if (contractedFocObj.ContractTypeId == 3)
                            {
                                query = string.Format(@"Insert into ContractedFOCDetail_Pending (CustomerID,OutletID,ContractID,
                                PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, contractedFocObj.ContractId, -1, contractedFocObj.RequiredQty, contractedFocObj.RemainingQuantity, contractedFocObj.ShelfValue == -1 ? 0 : contractedFocObj.ShelfValue, contractedFocObj.ShelfRemainingValue == -1 ? 0 : contractedFocObj.ShelfRemainingValue, contractedFocObj.SubTypeId, contractedFocObj.PercentageValue);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                break;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors UpdateContractedFOCPending(ContractedFOCModel contractedFOCObject, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                foreach (SimpleCustomerModel customer in contractedFOCObject.AppliedCustomers)
                {
                     query = string.Format(@"update ContractedFOC_Pending set CustomerID={1}, OutletID={2},PeriodTypeID={3},ContractTypeID={4},ForceGivingAllFOC={5},Inactive={6},UpdateDate={7},ValidFrom={8},ValidTo={9},IsTransferable={10},IsOneTime={11},DivisionID={12},TerritoryID={13},CreateBy={14},CreateDate={15},IsDeleted={16},OrganizationID={17}
                    where ContractID={0} ", contractedFOCObject.ContractId, customer.CustomerId, customer.OutletId, contractedFOCObject.PeriodTypeId, contractedFOCObject.ContractTypeId, contractedFOCObject.ForceFoc ? "1" : "0", contractedFOCObject.Inactive ? "1" : "0", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), LocalUtilities.ParseDateToSQLString(contractedFOCObject.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFOCObject.EndDate.Value),
                    contractedFOCObject.IsTransferable ? "1" : "0", contractedFOCObject.IsOneTime ? "1" : "0", contractedFOCObject.DivisionId, contractedFOCObject.TerritoryId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), contractedFOCObject.IsDeleted ? "1" : "0", contractedFOCObject.OrganizationId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                        break;
                }
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    //Save language
                    query = string.Format("delete from ContractedFOCLanguage_Pending where ContractID={0}", contractedFOCObject.ContractId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in contractedFOCObject.DescriptionLanguages)
                    {
                        query = string.Format(@"insert into ContractedFOCLanguage_Pending(ContractID,LanguageId,Description) values ({0},{1},'{2}')", contractedFOCObject.ContractId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (contractedFOCObject.ContractTypeId == 2)
                        {
                            query = string.Format(@"UPDATE ContractedFOCDetail_Pending SET value={0},RemainingValue = {1} , SubTypeID = {2},PercentageValue={3} where contractID = {4} "
                                , contractedFOCObject.Value == -1 ? 0 : contractedFOCObject.Value
                                , contractedFOCObject.RemainingValue == -1 ? 0 : contractedFOCObject.RemainingValue, contractedFOCObject.SubTypeId, contractedFOCObject.PercentageValue == -1 ? 0 : contractedFOCObject.PercentageValue, contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNonQuery(query);
                        }
                        if (contractedFOCObject.ContractTypeId == 3)
                        {
                            query = string.Format(@"UPDATE ContractedFOCDetail_Pending SET value={0},RemainingValue = {1}  where contractID = {2} "
                                , contractedFOCObject.ShelfValue
                                , contractedFOCObject.ShelfRemainingValue == -1 ? 0 : contractedFOCObject.ShelfRemainingValue, contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNonQuery(query);
                        }
                        if (contractedFOCObject.ContractTypeId == 1)
                        {
                            //delete old item
                            //foreach (SimpleCustomerModel customer in contractedFOCObject.AppliedCustomers)
                            //{
                            //    query = string.Format(@"delete from ContractedFOCDetail_Pending where contractID = {0} and CustomerID= {1} and OutletID= {2}",
                            //    contractedFOCObject.ContractId, customer.CustomerId, customer.OutletId);
                            //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            //}
                            query = string.Format(@"delete from ContractedFOCDetail_Pending where contractID = {0}",
                               contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            //insert new
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (SimpleCustomerModel customer in contractedFOCObject.AppliedCustomers)
                                {
                                    foreach (var items in contractedFOCObject.AddedItemsList)
                                    {
                                        query = string.Format(@"INSERT INTO ContractedFOCDetail_Pending (CustomerID,OutletID,ContractID, PackID,Quantity, RemainingQuantity)
                                        VALUES ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, contractedFOCObject.ContractId, items.PackId, items.RequiredQty, contractedFOCObject.RemainingQuantity);
                                        result = dBHelper.ExecuteNonQuery(query);
                                    }
                                }
                            }
                            else
                                result = GlobalErrors.Error;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors DeleteContractedFocPending(ContractedFOCModel contractedFOC, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                ////Delete Pending

                query = string.Format(@"delete from ContractedFOC_Pending where ContractID = {0} and CustomerID={1} and OutletID={2}", contractedFOC.ContractId,contractedFOC.CustomerId,contractedFOC.OutletId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from ContractedFOCDetail_Pending where ContractID = {0} and CustomerID={1} and OutletID={2}", contractedFOC.ContractId, contractedFOC.CustomerId, contractedFOC.OutletId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from ContractedFOCLanguage_Pending where ContractID = {0}", contractedFOC.ContractId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteContractedFOC(ContractedFOCModel contractedFOC,ref string deletingMsg, DBHelper<int> dBHelper)
        {

            GlobalErrors result = GlobalErrors.Error;
            bool allowDeleteFOC = false;
            bool isUploaded = false;
            
            try
            {

                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                if (!UsedContractedFOC(contractedFOC.CustomerId, contractedFOC.OutletId, contractedFOC.ContractId))
                {
                    result = CheckUploadedContractFOC(contractedFOC.ContractId, ref allowDeleteFOC, contractedFOC.CustomerId, contractedFOC.OutletId, dBHelper);
                    if (result == GlobalErrors.Success && allowDeleteFOC)
                    {
                        string queryString = string.Format("Update ContractedFOC  Set IsDeleted = 1 where ContractID= {0} and CustomerID = {1} and OutletID = {2} ", contractedFOC.ContractId, contractedFOC.CustomerId, contractedFOC.OutletId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                    else
                    {
                        deletingMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Cannot_Delete_Uploaded_Contracted_FOC, _requestRepository.LanguageId);
                        return GlobalErrors.Error;
                    }
                }
                else
                {
                    deletingMsg = ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Cannot_Delete_Used_Contracted_FOC, _requestRepository.LanguageId);
                    return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors UpdateContractedFoc(ContractedFOCModel contractedFOCObject, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                query = string.Format(@"update ContractedFOC Set PeriodTypeID={1},ContractTypeID={2},ForceGivingAllFOC={3},Inactive={4},UpdateDate={5},ValidFrom={6},ValidTo={7},IsTransferable={8},IsOneTime={9},DivisionID={10},TerritoryID={11},CreateBy={12},CreateDate={13},IsDeleted={14},OrganizationID={15}
                where ContractID={0} ", contractedFOCObject.ContractId, contractedFOCObject.PeriodTypeId, contractedFOCObject.ContractTypeId, contractedFOCObject.ForceFoc ? "1" : "0", contractedFOCObject.Inactive ? "1" : "0", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), LocalUtilities.ParseDateToSQLString(contractedFOCObject.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFOCObject.EndDate.Value),
                   contractedFOCObject.IsTransferable ? "1" : "0", contractedFOCObject.IsOneTime ? "1" : "0", contractedFOCObject.DivisionId, contractedFOCObject.TerritoryId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), contractedFOCObject.IsDeleted ? "1" : "0", contractedFOCObject.OrganizationId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    //Save language
                     query = string.Format("delete from ContractedFOCLanguage where ContractID={0}", contractedFOCObject.ContractId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in contractedFOCObject.DescriptionLanguages)
                    {
                         query = string.Format(@"insert into ContractedFOCLanguage(ContractID,LanguageId,Description) values ({0},{1},'{2}')", contractedFOCObject.ContractId, language.LanguageId, language.Description.Equals("") ? contractedFOCObject.ContractName.Replace("'", "''") : language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        if (contractedFOCObject.ContractTypeId == 2)
                        {
                            contractedFOCObject.RemainingValue = contractedFOCObject.Value;
                            query = string.Format(@"UPDATE ContractedFOCDetail SET value={0},RemainingValue = {1} , SubTypeID = {2},PercentageValue={3} where contractID = {4} "
                                , contractedFOCObject.Value == -1 ? 0 : contractedFOCObject.Value
                                , contractedFOCObject.RemainingValue, contractedFOCObject.SubTypeId, contractedFOCObject.PercentageValue == -1 ? 0 : contractedFOCObject.PercentageValue, contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                        if (contractedFOCObject.ContractTypeId == 3)
                        {
                            contractedFOCObject.ShelfRemainingValue = contractedFOCObject.ShelfValue;
                            query = string.Format(@"UPDATE ContractedFOCDetail SET value={0},RemainingValue = {1}  where contractID = {2} "
                                , contractedFOCObject.ShelfValue
                                , contractedFOCObject.ShelfRemainingValue, contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        }
                        if (contractedFOCObject.ContractTypeId == 1)
                        {
                            //delete old item
                            //foreach (SimpleCustomerModel customer in contractedFOCObject.AppliedCustomers)
                            //{
                            //    query = string.Format(@"delete from ContractedFOCDetail where contractID = {0} and CustomerID= {1} and OutletID= {2}",
                            //    contractedFOCObject.ContractId, customer.CustomerId, customer.OutletId);
                            //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            //}
                            query = string.Format(@"delete from ContractedFOCDetail where contractID = {0}",
                            contractedFOCObject.ContractId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            //insert new
                            if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            {
                                foreach (SimpleCustomerModel customer in contractedFOCObject.AppliedCustomers)
                                {
                                    foreach (var items in contractedFOCObject.AddedItemsList)
                                    {
                                        contractedFOCObject.RemainingQuantity = items.RequiredQty;
                                        query = string.Format(@"INSERT INTO ContractedFOCDetail (CustomerID,OutletID,ContractID, PackID,Quantity, RemainingQuantity)
                                        VALUES ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, contractedFOCObject.ContractId, items.PackId, items.RequiredQty, contractedFOCObject.RemainingQuantity);
                                        result = dBHelper.ExecuteNonQuery(query);
                                    }
                                }
                            }
                            else
                                result = GlobalErrors.Error;
                        }
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

            return result;
        }
        public GlobalErrors InsertContractedFocDetails(ContractedFOCModel ContractedFoc, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                foreach (SimpleCustomerModel customer in ContractedFoc.AppliedCustomers)
                {
                    if (ContractedFoc.AddedItemsList != null && ContractedFoc.AddedItemsList.Count > 0)
                    {
                        foreach (var items in ContractedFoc.AddedItemsList)
                        {
                            ContractedFoc.RemainingQuantity = items.RequiredQty;
                            query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity) values ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, ContractedFoc.ContractId, items.PackId, items.RequiredQty, ContractedFoc.RemainingQuantity);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                                break;

                        }
                    }
                    else
                    {
                        if (ContractedFoc.ContractTypeId == 2)
                        {
                            query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, ContractedFoc.ContractId, -1, ContractedFoc.RequiredQty, ContractedFoc.RemainingQuantity, ContractedFoc.Value == -1 ? 0 : ContractedFoc.Value, ContractedFoc.RemainingValue == -1 ? 0 : ContractedFoc.RemainingValue, ContractedFoc.SubTypeId, ContractedFoc.PercentageValue);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            break;
                        }
                        if (ContractedFoc.ContractTypeId == 3)
                        {
                            query = string.Format(@"Insert into ContractedFOCDetail (CustomerID,OutletID,ContractID,
                            PackID,Quantity,RemainingQuantity,Value,RemainingValue,SubTypeID,PercentageValue) values ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9})", customer.CustomerId, customer.OutletId, ContractedFoc.ContractId, -1, ContractedFoc.RequiredQty, ContractedFoc.RemainingQuantity, ContractedFoc.ShelfValue == -1 ? 0 : ContractedFoc.ShelfValue, ContractedFoc.ShelfRemainingValue == -1 ? 0 : ContractedFoc.ShelfRemainingValue, ContractedFoc.SubTypeId, ContractedFoc.PercentageValue);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            break;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool UsedContractedFOC(int customerID, int outletID, int contractID)
        {
            bool used = false;
            DBHelper<ContractedFOCModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            ContractedFOCModel contractedFoc = new ContractedFOCModel();
            try
            {
                dBHelper = new DBHelper<ContractedFOCModel>();
                string query = string.Format(@"Select * From ContractedFOCHistory
                inner join [Transaction] on ContractedFOCHistory.TransactionID
                = [Transaction].TransactionID  and ContractedFOCHistory.CustomerID
                = [Transaction].CustomerID and ContractedFOCHistory.OutletID
                = [Transaction].OutletID 
                where ContractedFOCHistory.CustomerID={0} and ContractedFOCHistory.OutletID={1} and ContractID={2} and [Transaction].Voided <> 1  ", customerID, outletID, contractID);
                result = dBHelper.GetQuerySingle(query, ref contractedFoc);
                if (result == GlobalErrors.Success && contractedFoc != null)
                {
                    used = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFoc = null;
                return false;
            }
            return used;

        }
        public GlobalErrors CheckUploadedContractFOC(int contractID, ref bool allowEditFOC, int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;      
            allowEditFOC = false;
            object field = new object();
            string filter = string.Empty;
            string query = string.Empty;
            try
            {
                dBHelper = new DBHelper<int>();
                if (_requestRepository.Configurations.ApplyTerritoryForContractedFOC)
                {
                    filter = string.Format(@"Select TerritoryID from ContractedFOC where ContractID = {0}", contractID);

                    query = string.Format(@"select Top(1) Uploaded from RouteHistory
                    inner join ContractedFOC on ContractedFOC.TerritoryID = RouteHistory.TerritoryID And Inactive <> 1 And ValidTo >= GETDATE()
                    where RouteHistory.TerritoryID = ({0}) and RouteHistory.SyncDate>=ContractedFOC.CreateDate and ContractedFOC.ContractID = {1} order by RouteHistoryID desc", filter, contractID);
                }
                else
                {
                    query = string.Format(@"select Top(1) isnull(Uploaded ,  '0') Uploaded  
                    from RouteHistory
                    inner join CustOutTerritory 
                    on  RouteHistory.TerritoryID = CustOutTerritory.TerritoryID and  CustOutTerritory.CustomerID = {0} and CustOutTerritory.OutletID = {1}
                    inner join ContractedFOC on ContractedFOC.CustomerID = CustOutTerritory.CustomerID And ContractedFOC.OutletID = CustOutTerritory.OutletID  And ValidTo >= GETDATE()  
                    Where ContractedFOC.ContractID = {2} And Inactive <> 1 and ContractedFOC.CreateDate <= RouteHistory.SyncDate 
                    order by RouteHistoryID desc", customerId, outletId, contractID);
                }

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field == null)
                        allowEditFOC = true;
                    else
                        allowEditFOC = !Convert.ToBoolean(field.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool CheckIsContractedFocPendingExist(int ContractId)
        {

            DBHelper<ContractedFOCModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            ContractedFOCModel contractedFoc = new ContractedFOCModel();
            try
            {
                string query = string.Empty;
                dBHelper = new DBHelper<ContractedFOCModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select ContractedFOC_Pending.*,ContractedFOCLanguage_Pending.Description ContractName,
                ContractTypeLanguage.Description ContractType,OrganizationLanguage.Description OrganizationName,PeriodTypeLanguage.Description PeriodType from ContractedFOC_Pending
                left outer join ContractedFOCLanguage_Pending on ContractedFOCLanguage_Pending.ContractID=ContractedFOC_Pending.ContractID and ContractedFOCLanguage_Pending.LanguageID = {0}
                left outer join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID=ContractedFOC_Pending.ContractTypeID and ContractTypeLanguage.LanguageID={0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=ContractedFOC_Pending.OrganizationID and OrganizationLanguage.LanguageID={0}
                left outer join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID=ContractedFOC_Pending.PeriodTypeID and PeriodTypeLanguage.LanguageID = {0}
                where ContractedFOC_Pending.ContractID = {1} ", _requestRepository.LanguageId, ContractId);
                result = dBHelper.GetQuerySingle(query, ref contractedFoc);
                if (result == GlobalErrors.Success && contractedFoc != null)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFoc = null;
                return false;
            }
        }
        public GlobalErrors GetContractedFocHeaderPending(int contractId, ref ContractedFOCModel contractedFoc)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<ContractedFOCModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                dBHelper_Languages = new DBHelper<TextLanguage>();
                dBHelper = new DBHelper<ContractedFOCModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                int currentStatus = GetCurrentStatus();
                query = string.Format(@"Select ContractedFOC_Pending.*,ContractedFOCLanguage_Pending.Description ContractName,
                ContractTypeLanguage.Description ContractType,OrganizationLanguage.Description OrganizationName,PeriodTypeLanguage.Description PeriodType,
                CASE WHEN  ContractedFOC_Pending.CreationLevel = {2}  THEN 1 ELSE 0 END AS IsCreationLevel
                from ContractedFOC_Pending
                left outer join ContractedFOCLanguage_Pending on ContractedFOCLanguage_Pending.ContractID=ContractedFOC_Pending.ContractID and ContractedFOCLanguage_Pending.LanguageID = {0}
                left outer join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID=ContractedFOC_Pending.ContractTypeID and ContractTypeLanguage.LanguageID = {0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=ContractedFOC_Pending.OrganizationID and OrganizationLanguage.LanguageID = {0}
                left outer join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID=ContractedFOC_Pending.PeriodTypeID and PeriodTypeLanguage.LanguageID = {0}
                where ContractedFOC_Pending.ContractID= {1}", _requestRepository.LanguageId, contractId, currentStatus);
                result = dBHelper.GetQuerySingle(query, ref contractedFoc);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from ContractedFOCLanguage_Pending where ContractID={0}", contractId);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        contractedFoc.DescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFoc = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocHeader(int contractId, ref ContractedFOCModel contractedFoc)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<ContractedFOCModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                dBHelper_Languages = new DBHelper<TextLanguage>();
                dBHelper = new DBHelper<ContractedFOCModel>();
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select ContractedFOC.*,ContractedFOC.ForceGivingAllFOC ForceFoc,ContractedFOCLanguage.Description ContractName,
                ContractTypeLanguage.Description ContractType,OrganizationLanguage.Description OrganizationName,PeriodTypeLanguage.Description PeriodType,
                ContractedFOC.ValidFrom StartDate,ContractedFOC.ValidTo EndDate
                from ContractedFOC
                left outer join ContractedFOCLanguage on ContractedFOCLanguage.ContractID=ContractedFOC.ContractID and ContractedFOCLanguage.LanguageID={0}
                left outer join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID=ContractedFOC.ContractTypeID and ContractTypeLanguage.LanguageID={0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=ContractedFOC.OrganizationID and OrganizationLanguage.LanguageID = {0}
                left outer join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID=ContractedFOC.PeriodTypeID and PeriodTypeLanguage.LanguageID = {0}
                where ContractedFOC.ContractID={1} ", _requestRepository.LanguageId, contractId);
                result = dBHelper.GetQuerySingle(query, ref contractedFoc);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from ContractedFOCLanguage where ContractID={0}", contractId);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        contractedFoc.DescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFoc = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocItems(ContractedFOCModel contractedFocObject, ref List<ContractedFOCModel> contractedItems)
        {
            DBHelper<ContractedFOCModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<ContractedFOCModel> lists = new List<ContractedFOCModel>();
                dbHelper = new DBHelper<ContractedFOCModel>();
                string query = string.Format(@"select distinct ContractedFOCDetail.*,ContractedFOCDetail.Quantity RequiredQty ,Item.ItemId,PackTypeLanguage.Description Uom
                ,IsNull( item.ItemCode , '--') + ' - ' + IsNull( ItemLanguage.Description , '--')+ ' ( ' + IsNull( PackTypeLanguage.Description , '--') + ' ) ' as ItemCodeName,
                item.ItemCode,ItemLanguage.Description ItemName
                from ContractedFOCDetail 
                inner join pack on pack.PackID=ContractedFOCDetail.PacKID
                inner join Item on item.ItemID=pack.ItemID
                left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID={0}
                left outer join ItemLanguage on ItemLanguage.ItemID=Item.ItemID and ItemLanguage.LanguageID={0}
                where ContractedFOCDetail.ContractID={1} and ContractedFOCDetail.CustomerID = {2} and ContractedFOCDetail.OutletID = {3} ", _requestRepository.LanguageId, contractedFocObject.ContractId, contractedFocObject.CustomerId, contractedFocObject.OutletId);
                result = dbHelper.GetQueryList(query, ref contractedItems);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedItems = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocAppliedCustomers(ContractedFOCModel contractedFocObject, ref List<SimpleCustomerModel> appliedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<SimpleCustomerModel>();
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                string query = string.Format(@"select distinct ContractedFOC.CustomerID,ContractedFOC.OutletID,Customer.CustomerCode CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerOutletLanguage.Description,CustomerLanguage.
                Description as CustomerName,
                IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                CustomerOutletLanguage.Description as OutletName ,
                IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                From ContractedFOC
                Inner Join CustomerOutletLanguage on CustomerOutletLanguage.OutletID = ContractedFOC.OutletID AND CustomerOutletLanguage.CustomerID = ContractedFOC.CustomerID
                and CustomerOutletLanguage.LanguageID={1}
                Inner Join CustomerOutlet on CustomerOutlet.OutletID = ContractedFOC.OutletID and CustomerOutlet.CustomerID=ContractedFOC.CustomerID
                Inner JOin CustomerLanguage on CustomerLanguage.CustomerID = ContractedFOC.CustomerID and CustomerLanguage.LanguageID={1}
                Inner Join Customer on Customer.CustomerID = ContractedFOC.CustomerID
                {2}
                Where ContractID = {0} and ContractedFOC.CustomerID = {3} and ContractedFOC.OutletID = {4}", contractedFocObject.ContractId, _requestRepository.LanguageId, orgAccessJoin, contractedFocObject.CustomerId, contractedFocObject.OutletId);
                result = dbHelper.GetQueryList(query, ref appliedCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocAppliedCustomersPending(ContractedFOCModel contractedFOCObject, ref List<SimpleCustomerModel> appliedCustomers, DBHelper<int> dBHelper)
        {
            DBHelper<SimpleCustomerModel> dbHelper_CustomerModel = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_CustomerModel = new DBHelper<SimpleCustomerModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_CustomerModel = new DBHelper<SimpleCustomerModel>();
                }
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                string query = string.Format(@"select ContractedFOC_Pending.CustomerID,ContractedFOC_Pending.OutletID,Customer.CustomerCode CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerOutletLanguage.Description,CustomerLanguage.
                Description as CustomerName,
                IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                CustomerOutletLanguage.Description as OutletName ,
                IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                From ContractedFOC_Pending
                Inner Join CustomerOutletLanguage on CustomerOutletLanguage.OutletID = ContractedFOC_Pending.OutletID AND CustomerOutletLanguage.CustomerID = ContractedFOC_Pending.CustomerID
                and CustomerOutletLanguage.LanguageID={1}
                Inner Join CustomerOutlet on CustomerOutlet.OutletID = ContractedFOC_Pending.OutletID and CustomerOutlet.CustomerID=ContractedFOC_Pending.CustomerID
                Inner JOin CustomerLanguage on CustomerLanguage.CustomerID = ContractedFOC_Pending.CustomerID and CustomerLanguage.LanguageID={1}
                Inner Join Customer on Customer.CustomerID = ContractedFOC_Pending.CustomerID
                {2}
                Where ContractID = {0} and ContractedFOC_Pending.CustomerID = {3} and ContractedFOC_Pending.OutletID = {4}", contractedFOCObject.ContractId, _requestRepository.LanguageId, orgAccessJoin, contractedFOCObject.CustomerId, contractedFOCObject.OutletId);
                result = dbHelper_CustomerModel.GetQueryList(query, ref appliedCustomers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocItemsPending(ContractedFOCModel contractedFocObject, ref List<ContractedFOCModel> contractedFocItems, DBHelper<int> dBHelper)
        {
            DBHelper<ContractedFOCModel> dbHelper_contractedFocItems = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_contractedFocItems = new DBHelper<ContractedFOCModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_contractedFocItems = new DBHelper<ContractedFOCModel>();
                }
                List<ContractedFOCModel> lists = new List<ContractedFOCModel>();
                string query = string.Format(@"select distinct ContractedFOCDetail_Pending.ContractID,ContractedFOCDetail_Pending.PackID,ContractedFOCDetail_Pending.RemainingQuantity,ContractedFOCDetail_Pending.Quantity RequiredQty ,Item.ItemId,PackTypeLanguage.Description Uom
                ,IsNull( item.ItemCode , '--') + ' - ' + IsNull( ItemLanguage.Description , '--')+ ' ( ' + IsNull( PackTypeLanguage.Description , '--') + ' ) ' as ItemCodeName,
                item.ItemCode,ItemLanguage.Description ItemName
                from ContractedFOCDetail_Pending 
                inner join pack on pack.PackID=ContractedFOCDetail_Pending.PacKID
                inner join Item on item.ItemID=pack.ItemID
                left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID and PackTypeLanguage.LanguageID={0}
                left outer join ItemLanguage on ItemLanguage.ItemID=Item.ItemID and ItemLanguage.LanguageID={0}
                where ContractedFOCDetail_Pending.ContractID = {1} and ContractedFOCDetail_Pending.CustomerID = {2} and ContractedFOCDetail_Pending.OutletID = {3} ", _requestRepository.LanguageId, contractedFocObject.ContractId, contractedFocObject.CustomerId, contractedFocObject.OutletId);
                result = dbHelper_contractedFocItems.GetQueryList(query, ref contractedFocItems);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFocItems = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocDescriptionsPending(int contractId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from ContractedFOCLanguage_Pending
                where ContractedFOCLanguage_Pending.ContractID={0}", contractId);
                result = dbHelper.GetQueryList(query, ref descriptions);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocAmountPending(ContractedFOCModel contractedFocObject , ref ContractedFOCModel contractedAmount, DBHelper<int> dBHelper)
        {
            DBHelper<ContractedFOCModel> dbHelper_contractedFoc = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper_contractedFoc = new DBHelper<ContractedFOCModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper_contractedFoc = new DBHelper<ContractedFOCModel>();
                }
                ContractedFOCModel lists = new ContractedFOCModel();
                string query = string.Format(@"select distinct ContractedFOC_Pending.*,ContractedFOCDetail_Pending.*,Pack.ItemID
                ,ItemLanguage.Description ItemDescription,PackTypeLanguage.Description PackTypeDescription
                From ContractedFOCDetail_Pending 
                Inner join ContractedFOC_Pending on ContractedFOC_Pending.CustomerID=ContractedFOCDetail_Pending.CustomerID
                and ContractedFOC_Pending.OutletID=ContractedFOCDetail_Pending.OutletID
                and ContractedFOC_Pending.ContractID=ContractedFOCDetail_Pending.ContractID
                  left outer  join Pack on Pack.PackID=ContractedFOCDetail_Pending.PackID
                left outer join ItemLanguage on ItemLanguage.ItemID=Pack.ItemID and ItemLanguage.LanguageID={0}
                left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=Pack.PackTypeID and PackTypeLanguage.LanguageID={0}
                Where ContractedFOCDetail_Pending.ContractID={1} and ContractedFOCDetail_Pending.CustomerID = {2} and ContractedFOCDetail_Pending.OutletID = {3}", _requestRepository.LanguageId, contractedFocObject.ContractId, contractedFocObject.CustomerId, contractedFocObject.OutletId);
                result = dbHelper_contractedFoc.GetQuerySingle(query, ref contractedAmount);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedAmount = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocDescriptions(int contractId, ref List<TextLanguage> descriptions)
        {
            DBHelper<TextLanguage> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from ContractedFOCLanguage
                where ContractedFOCLanguage.ContractID={0}", contractId);
                result = dbHelper.GetQueryList(query, ref descriptions);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                descriptions = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocAmount(ContractedFOCModel contractedFOC, ref ContractedFOCModel contractedAmount)
        {
            DBHelper<ContractedFOCModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                ContractedFOCModel lists = new ContractedFOCModel();
                dbHelper = new DBHelper<ContractedFOCModel>();
                string query = string.Format(@"select distinct ContractedFOC.*,ContractedFOCDetail.*,Pack.ItemID
                ,ItemLanguage.Description ItemDescription,PackTypeLanguage.Description PackTypeDescription
                From ContractedFOCDetail 
                Inner join ContractedFOC on ContractedFOC.CustomerID=ContractedFOCDetail.CustomerID
                and ContractedFOC.OutletID=ContractedFOCDetail.OutletID
                and ContractedFOC.ContractID=ContractedFOCDetail.ContractID
                  left outer  join Pack on Pack.PackID=ContractedFOCDetail.PackID
                left outer join ItemLanguage on ItemLanguage.ItemID=Pack.ItemID and ItemLanguage.LanguageID={0}
                left outer join PackTypeLanguage on PackTypeLanguage.PackTypeID=Pack.PackTypeID and PackTypeLanguage.LanguageID={0}
                Where ContractedFOCDetail.ContractID={1} and ContractedFOCDetail.CustomerID = {2} and ContractedFOCDetail.OutletID = {3}", _requestRepository.LanguageId, contractedFOC.ContractId, contractedFOC.CustomerId, contractedFOC.OutletId);
                result = dbHelper.GetQuerySingle(query, ref contractedAmount);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedAmount = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteActiveContractedFoc(ContractedFOCModel contractedFOC, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }

                SettingManager settingManager = new SettingManager(_requestRepository);
                bool isMaxLevel = false;
                result = settingManager.IsMaxOperationLevel(ApprovalCycleOperations.ContractedFOC.GetHashCode(), ref isMaxLevel, dBHelper);
                if (isMaxLevel)
                {
                    string Msg = string.Empty;
                    result = DeleteContractedFOC(contractedFOC, ref Msg, dBHelper);
                }
                else
                {
                    int level = GetCurrentStatus();
                    if (result == GlobalErrors.Success)
                    {
                        if (!CheckIsContracedFocListPendingExisit(contractedFOC.ContractId))
                        {
                            List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();
                            List<CustomerGroupModel> appliedGroups = new List<CustomerGroupModel>();
                            List<CustomerChannelModel> appliedChannels = new List<CustomerChannelModel>();
                            List<TextLanguage> ContractDescription = new List<TextLanguage>();
                            List<ContractedFOCModel> ContractItemsModel = new List<ContractedFOCModel>();
                            ContractedFOCModel ContractAmountModel = new ContractedFOCModel();


                            result = GetContractedFocAppliedCustomers(contractedFOC, ref appliedCustomers);
                            if (result != GlobalErrors.Success) return result;
                            result = GetContractedFocDescriptions(contractedFOC.ContractId, ref ContractDescription);
                            if (result != GlobalErrors.Success) return result;
                            result = GetContractedFocItems(contractedFOC, ref ContractItemsModel);
                            if (result != GlobalErrors.Success) return result;
                            result = GetContractedFocAmount(contractedFOC, ref ContractAmountModel);

                            contractedFOC.AppliedCustomers = appliedCustomers;
                            contractedFOC.DescriptionLanguages = ContractDescription;
                            //contractedFOC.AddedItemsList = ContractItemsModel;

                            result = InsertContractedFOCPending(contractedFOC, dBHelper);
                        }
                        query = string.Format("update ContractedFOC_Pending set IsDeleted = 1 , Status = {1} where contractID = {0}", contractedFOC.ContractId, level);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerForContractedFoc(ContractedFOCModel contractedFOC, ref List<SimpleCustomerModel> appliedCustomer)
        {
            DBHelper<SimpleCustomerModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<SimpleCustomerModel>();
                string GroupId = string.Empty;
                string channelIds = string.Empty;
                string subChannelIDs = string.Empty;
                string groupCustomer = string.Empty;
                string channelCustomer = string.Empty;
                if (contractedFOC.AppliedGroups != null && contractedFOC.AppliedGroups.Count > 0)
                {
                    foreach (CustomerGroupModel customerGroup in contractedFOC.AppliedGroups)
                    {
                         GroupId += customerGroup.GroupId.ToString() + ',';
                    }
                    groupCustomer = string.Format(@" and CustomerGroup.GroupID in ({0}) ", GroupId.TrimEnd(','));

                }
                if (contractedFOC.AppliedChannels != null && contractedFOC.AppliedChannels.Count > 0)
                {
                    foreach (CustomerChannelModel customerChannel in contractedFOC.AppliedChannels)
                    {
                        channelIds += customerChannel.ChannelSubChannelIds.Split('-')[0].ToString() + ',';
                        subChannelIDs += customerChannel.ChannelSubChannelIds.Split('-')[1].ToString() + ',';
                    }
                    channelCustomer = string.Format(@" and ChannelID in ({0}) and SubChannelID in ({1}) ", channelIds.TrimEnd(','), subChannelIDs.TrimEnd(','));
                }
                string query = string.Format(@" Select Distinct CustomerGroup.*,CustomerOutletGroup.*,CustomerOutletGroup.CustomerID, CustomerOutletGroup.OutletID
                                            FROM CustomerGroup
                                            INNER JOIN CustomerOutletGroup on CustomerOutletGroup.GroupID = CustomerGroup.GroupID
                                            INNER JOIN AccountCustOut on AccountCustOut.CustomerID = CustomerOutletGroup.CustomerID and AccountCustOut.OutletID = CustomerOutletGroup.OutletID
                                            INNER JOIN Account on AccountCustOut.AccountID = Account.AccountID
                                            WHERE Account.OrganizationID = {0} {1} {2}", contractedFOC.OrganizationId, channelCustomer, groupCustomer);
                result = dBHelper.GetQueryList(query, ref appliedCustomer);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                appliedCustomer = null;
            }
            return result;

        }
        public GlobalErrors GetAllCustomerForContractedFoc(ContractedFOCModel contractedFOC, ref List<SimpleCustomerModel> appliedCustomer)
        {
            DBHelper<SimpleCustomerModel> dBHelper = null;
            var result = GlobalErrors.NotInitialized;
            string customerQuery = string.Empty;
            try
            {
                dBHelper = new DBHelper<SimpleCustomerModel>();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    customerQuery = string.Format(@"inner join Account on AccountCustOut.AccountID = Account.AccountID
                                                WHERE OrganizationID = {0} ", contractedFOC.OrganizationId);

                }
                string query = string.Format(@"select distinct CustomerID,OutletID from AccountCustOut {0}", customerQuery);
                result = dBHelper.GetQueryList(query, ref appliedCustomer);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
                appliedCustomer = null;
            }
            return result;
        }
        public GlobalErrors ConvertContractedFocFromPendingToApproval(int contractId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                ContractedFOCModel contractedFOCObj = new ContractedFOCModel();
                ContractedFOCModel contractedFocList = new ContractedFOCModel();
                List<ContractedFOCModel> ContractedFocItems = new List<ContractedFOCModel>();
                ContractedFOCModel ContractedFocAmount = new ContractedFOCModel();
                List<SimpleCustomerModel> appliedCustomers = new List<SimpleCustomerModel>();


                result = GetContractedFocDataPending(contractId, ref contractedFOCObj,dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = GetContractedFocAppliedCustomersPending(contractedFOCObj, ref appliedCustomers, dBHelper);
                    if (result == GlobalErrors.Success)
                    {
                        if (contractedFOCObj != null)
                        {
                            foreach (SimpleCustomerModel customer in appliedCustomers)
                            {
                                query = string.Format(@"INSERT INTO ContractedFOC (CustomerID,OutletID,ContractID,PeriodTypeID,ContractTypeID,ForceGivingAllFOC,Inactive,ValidFrom,ValidTo,
                               IsTransferable,IsOneTime,UpdateDate,DivisionID,TerritoryID,IsDeleted,Status,CreateBy,CreateDate,OrganizationID) VALUES
                               ({0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},'{15}',{16},{17},{18})", customer.CustomerId, customer.OutletId, contractedFOCObj.ContractId, contractedFOCObj.PeriodTypeId, contractedFOCObj.ContractTypeId, contractedFOCObj.ForceFoc ? "1" : "0", contractedFOCObj.Inactive ? "1" : "0", LocalUtilities.ParseDateToSQLString(contractedFOCObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFOCObj.EndDate.Value),
                                contractedFOCObj.IsTransferable ? "1" : "0", contractedFOCObj.IsOneTime ? "1" : "0", LocalUtilities.ParseDateToSQLString(DateTime.Now), contractedFOCObj.DivisionId, contractedFOCObj.TerritoryId, contractedFOCObj.IsDeleted ? "1" : "0", -1, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateToSQLString(DateTime.Now), contractedFOCObj.OrganizationId);
                                result = dBHelper.ExecuteNonQuery(query);
                                if (result != GlobalErrors.Success)
                                break;
                            }
                        }
                        else
                        {
                            query = string.Format(@"update ContractedFOC Set PeriodTypeID={1},ContractTypeID={2},ForceGivingAllFOC={3},Inactive={4},UpdateDate={5},ValidFrom={6},ValidTo={7},IsTransferable={8},IsOneTime={9},DivisionID={10},TerritoryID={11},CreateBy={12},CreateDate={13},IsDeleted={14},OrganizationID={15}
                        where ContractID={0} ", contractedFOCObj.ContractId, contractedFOCObj.PeriodTypeId, contractedFOCObj.ContractTypeId, contractedFOCObj.ForceFoc ? "1" : "0", contractedFOCObj.Inactive ? "1" : "0", LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), LocalUtilities.ParseDateToSQLString(contractedFOCObj.StartDate.Value), LocalUtilities.ParseEndDateToSQLString(contractedFOCObj.EndDate.Value),
                            contractedFOCObj.IsTransferable ? "1" : "0", contractedFOCObj.IsOneTime ? "1" : "0", contractedFOCObj.DivisionId, contractedFOCObj.TerritoryId, _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), contractedFOCObj.IsDeleted ? "1" : "0", contractedFOCObj.OrganizationId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result != GlobalErrors.Success || result != GlobalErrors.SuccessWithZeroRowAffected)
                                return result;
                        } 
                    }
                }
                //////Contract List Language
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from  ContractedFOCLanguage where ContractID = {0}", contractedFOCObj.ContractId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                    foreach (TextLanguage language in contractedFOCObj.DescriptionLanguages)
                    {
                        query = string.Format(@"insert into ContractedFOCLanguage (ContractID,LanguageId,Description) values ({0},{1},'{2}')", contractedFOCObj.ContractId, language.LanguageId, language.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                                break;
                    }
                }

                    ////// Price List Items
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        //Save Items
                        result = GetContractedFocItemsPending(contractedFOCObj, ref ContractedFocItems, dBHelper);
                    if (result != GlobalErrors.Success)
                        return result;
                    }
                    if(result == GlobalErrors.Success)
                    {
                        result = GetContractedFocAmountPending(contractedFOCObj, ref ContractedFocAmount, dBHelper);
                        if (result != GlobalErrors.Success)
                        return result;
                    }
                    if (result == GlobalErrors.Success)
                    {
                            if (contractedFOCObj.ContractTypeId == 2)
                            {
                                query = string.Format(@"UPDATE ContractedFOCDetail SET value={0},RemainingValue = {1} , SubTypeID = {2},PercentageValue={3} where contractID = {4} "
                                    , ContractedFocAmount.Value == -1 ? 0 : ContractedFocAmount.Value
                                    , ContractedFocAmount.RemainingValue == -1 ? 0 : ContractedFocAmount.RemainingValue, ContractedFocAmount.SubTypeId, ContractedFocAmount.PercentageValue == -1 ? 0 : ContractedFocAmount.PercentageValue, contractedFOCObj.ContractId);
                                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                            if (contractedFOCObj.ContractTypeId == 3)
                            {
                                query = string.Format(@"UPDATE ContractedFOCDetail SET value={0},RemainingValue = {1}  where contractID = {2} "
                                    , ContractedFocAmount.ShelfValue
                                    , ContractedFocAmount.ShelfRemainingValue == -1 ? 0 : ContractedFocAmount.ShelfRemainingValue, ContractedFocAmount.ContractId);
                                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            }
                            if (contractedFOCObj.ContractTypeId == 1)
                            {
                                query = string.Format(@"delete from ContractedFOCDetail where contractID = {0}", contractedFOCObj.ContractId);
                                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                                if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected) return result;
                                if (ContractedFocItems != null && ContractedFocItems.Count > 0)
                                {
                                    foreach (SimpleCustomerModel customer in contractedFOCObj.AppliedCustomers)
                                    {
                                        foreach (var items in ContractedFocItems)
                                        {
                                            query = string.Format(@"INSERT INTO ContractedFOCDetail (CustomerID,OutletID,ContractID, PackID,Quantity, RemainingQuantity)
                                        VALUES ({0},{1},{2},{3},{4},{5})", customer.CustomerId, customer.OutletId, contractedFOCObj.ContractId, items.PackId, items.RequiredQty, contractedFOCObj.RemainingQuantity);
                                            result = dBHelper.ExecuteNonQuery(query);
                                        }
                                    }
                                }
                            }
                    }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = DeleteContractedFocPending(contractedFOCObj, dBHelper);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetContractedFocDataPending(int contractId, ref ContractedFOCModel contractedFoc, DBHelper<int> dBHelper)
        {
            DBHelper<TextLanguage> dBHelper_Languages = null;
            DBHelper<ContractedFOCModel> dBHelper_contractedFoc = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                    dBHelper_contractedFoc = new DBHelper<ContractedFOCModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper_Languages = new DBHelper<TextLanguage>();
                    dBHelper_contractedFoc = new DBHelper<ContractedFOCModel>();
                }
                string query = string.Empty;
                List<TextLanguage> descriptions = new List<TextLanguage>();
                query = string.Format(@"Select ContractedFOC_Pending.*,ContractedFOCLanguage_Pending.Description ContractName,
                ContractTypeLanguage.Description ContractType,OrganizationLanguage.Description OrganizationName,PeriodTypeLanguage.Description PeriodType,ContractedFOC_Pending.ValidFrom StartDate,ContractedFOC_Pending.ValidTo EndDate
                from ContractedFOC_Pending
                left outer join ContractedFOCLanguage_Pending on ContractedFOCLanguage_Pending.ContractID=ContractedFOC_Pending.ContractID and ContractedFOCLanguage_Pending.LanguageID = {0}
                left outer join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID=ContractedFOC_Pending.ContractTypeID and ContractTypeLanguage.LanguageID = {0}
                left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID=ContractedFOC_Pending.OrganizationID and OrganizationLanguage.LanguageID = {0}
                left outer join PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID=ContractedFOC_Pending.PeriodTypeID and PeriodTypeLanguage.LanguageID = {0}
                where ContractedFOC_Pending.ContractID= {1}  ", _requestRepository.LanguageId, contractId);
                result = dBHelper_contractedFoc.GetQuerySingle(query, ref contractedFoc);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format("select * from ContractedFOCLanguage_Pending where ContractID={0}", contractId);
                    result = dBHelper_Languages.GetQueryList(query, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        contractedFoc.DescriptionLanguages = descriptions;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                contractedFoc = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region Header Discount

        public GlobalErrors GetHeaderDiscountAppliedCustomers(int headerdiscountId, ref List<SimpleCustomerModel> appliedCustomers)
        {
            DBHelper<SimpleCustomerModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                dbHelper = new DBHelper<SimpleCustomerModel>();
                string query = string.Format(@"
                select distinct CustomerHeaderDiscount.HeaderDiscountID ,CustomerHeaderDiscount.CustomerID ,CustomerHeaderDiscount.OutletID ,
                Customer.CustomerCode,CustomerOutlet.CustomerCode OutletCode,CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName 
                ,CustomerOutletLanguage.Description as OutletName ,IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName
                from CustomerHeaderDiscount
                inner join Customer on Customer.CustomerID=CustomerHeaderDiscount.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID=CustomerHeaderDiscount.CustomerID and CustomerOutlet.OutletID=CustomerHeaderDiscount.OutletID 
                left outer join CustomerLanguage on CustomerLanguage.CustomerID=Customer.CustomerID and CustomerLanguage.LanguageID={1}
                left outer join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID=CustomerOutlet.CustomerID 
                and CustomerOutletLanguage.OutletID=CustomerOutlet.OutletID 
                and CustomerOutletLanguage.LanguageID={1}
                {2}
                where CustomerHeaderDiscount.HeaderDiscountID={0}", headerdiscountId,
                _requestRepository.LanguageId,
                 orgAccessJoin);
                result = dbHelper.GetQueryList(query, ref appliedCustomers);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedCustomers = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetHeaderDiscountAppliedGroups(int headerdiscountId, ref List<CustomerGroupModel> appliedGroups)
        {
            DBHelper<CustomerGroupModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string orgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $"and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})" : string.Empty;
                dbHelper = new DBHelper<CustomerGroupModel>();
                string query = string.Format(@"select CustomerHeaderDiscount.HeaderDiscountID ,CustomerHeaderDiscount.GroupID GroupId ,CustomerGroup.*,CustomerGroupLanguage.Description GroupName, IsNull( CustomerGroup.GroupCode, '--') +' ' + '-' + ' ' + IsNull(CustomerGroupLanguage.Description, '--') as GroupCodeName 
                                from CustomerHeaderDiscount
                                inner join CustomerGroup on CustomerGroup.GroupID=CustomerHeaderDiscount.GroupID {2}
                                left outer join CustomerGroupLanguage on CustomerGroupLanguage.GroupID=CustomerGroup.GroupID and CustomerGroupLanguage.LanguageID={1}
                                where CustomerHeaderDiscount.HeaderDiscountID={0}", headerdiscountId, _requestRepository.LanguageId, orgAccess);
                result = dbHelper.GetQueryList(query, ref appliedGroups);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedGroups = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetHeaderDiscountAppliedChannels(int headerdiscountId, ref List<CustomerChannelModel> appliedChannels)
        {
            DBHelper<CustomerChannelModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<CustomerChannelModel>();
                string query = string.Format(@"select CustomerHeaderDiscount.HeaderDiscountID ,CustomerHeaderDiscount.ChannelID, CustomerHeaderDiscount.SubChannelID,
                               (CONVERT(varchar(10),CustomerHeaderDiscount.ChannelID) + '-' + CONVERT(varchar(10),CustomerHeaderDiscount.SubChannelID)) ChannelSubChannelIds ,
                               (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions
                                from CustomerHeaderDiscount
                                Inner JOIN ChannelLanguage on ChannelLanguage.ChannelID = CustomerHeaderDiscount.ChannelID and ChannelLanguage.LanguageID = {1}
                                left JOIN SubChannelLanguage on SubChannelLanguage.SubChannelID = CustomerHeaderDiscount.SubChannelID and SubChannelLanguage.LanguageID = {1}
                                where CustomerHeaderDiscount.HeaderDiscountID={0}", headerdiscountId, _requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref appliedChannels);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedChannels = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedCustomersToHeaderDiscount(HeaderDiscountModel headerDicountObj, ref int customerHeaderDiscountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (headerDicountObj.AppliedCustomers != null && headerDicountObj.AppliedCustomers.Count > 0)
                {
                    int start = 0;
                    int end = 0;
                    int i = 0;
                    if (headerDicountObj.AppliedCustomers.Count > 1000)
                    {
                        end = 1000;
                    }
                    else
                    {
                        end = headerDicountObj.AppliedCustomers.Count;
                    }
                    while (end <= headerDicountObj.AppliedCustomers.Count)
                    {
                        StringBuilder values = new StringBuilder();
                        for (i = start; i < end; i++)
                        {
                            values.AppendFormat("({0},{1},{2},{3},{4}),",
                             headerDicountObj.HeaderDiscountId, //0
                             customerHeaderDiscountId, //1
                             headerDicountObj.AppliedCustomers[i].CustomerId,//2
                             headerDicountObj.AppliedCustomers[i].OutletId ,// 3
                              0 // AllCustomers //4
                            );
                            customerHeaderDiscountId++;
                        }
                        string query = string.Format(@"Insert into CustomerHeaderDiscount (HeaderDiscountID,CustomerHeaderDiscountID,
                                                       CustomerID,OutletID,AllCustomers) Values {0}", values.ToString().TrimEnd(','));
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                        start = i;
                        if (headerDicountObj.AppliedCustomers.Count == end)
                        {
                            break;
                        }
                        if (headerDicountObj.AppliedCustomers.Count - end > 1000)
                        {
                            end = end + 1000;
                        }
                        else
                        {
                            end = end + (headerDicountObj.AppliedCustomers.Count - end);
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedGroupsToHeaderDiscount(HeaderDiscountModel headerDicountObj, ref int customerHeaderDiscountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string groups = string.Empty;
                foreach (CustomerGroupModel group in headerDicountObj.AppliedGroups)
                {
                    groups += string.Format("Insert into CustomerHeaderDiscount(HeaderDiscountID, CustomerHeaderDiscountID, GroupID) values({0},{1},{2})",
                    headerDicountObj.HeaderDiscountId, customerHeaderDiscountId, group.GroupId);
                    customerHeaderDiscountId++;
                }
                result = dBHelper.ExecuteNonQuery(groups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertAppliedChannelsToHeaderDiscount(HeaderDiscountModel headerDicountObj, ref int customerHeaderDiscountId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string channels = string.Empty;
                foreach(CustomerChannelModel channel in headerDicountObj.AppliedChannels)
                {
                    channels += string.Format(@"Insert into CustomerHeaderDiscount (HeaderDiscountID,CustomerHeaderDiscountID,ChannelID,SubChannelID) values ({0},{1},{2},{3})",
                    headerDicountObj.HeaderDiscountId , customerHeaderDiscountId, channel.ChannelSubChannelIds.Split('-')[0], channel.ChannelSubChannelIds.Split('-')[1]);
                    customerHeaderDiscountId++;
                }
                result = dBHelper.ExecuteNonQuery(channels);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertCustomerHeaderDiscount(HeaderDiscountModel HeaderdiscountObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int customerHeaderDiscountId = GetMaxID("CustomerHeaderDiscountID", "CustomerHeaderDiscount", dBHelper);
                //Save applied All customer
                if (HeaderdiscountObj.AllCustomers)
                {
                    string query = string.Format(@"Insert into CustomerHeaderDiscount (HeaderDiscountID ,CustomerHeaderDiscountID, AllCustomers) values ({0},{1},{2})", 
                    HeaderdiscountObj.HeaderDiscountId, customerHeaderDiscountId, 1);
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;
                }
                else
                {
                    //Save applied customer
                    if (HeaderdiscountObj.AppliedCustomers != null && HeaderdiscountObj.AppliedCustomers.Count > 0)
                    {
                        result = InsertAppliedCustomersToHeaderDiscount(HeaderdiscountObj, ref customerHeaderDiscountId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //Save applied groups
                    if (HeaderdiscountObj.AppliedGroups != null && HeaderdiscountObj.AppliedGroups.Count > 0)
                    {
                        result = InsertAppliedGroupsToHeaderDiscount(HeaderdiscountObj, ref customerHeaderDiscountId, dBHelper);
                        if (result != GlobalErrors.Success) return result;
                    }
                    //Save applied channels
                    if (HeaderdiscountObj.AppliedChannels != null && HeaderdiscountObj.AppliedChannels.Count > 0)
                    {
                        result = InsertAppliedChannelsToHeaderDiscount(HeaderdiscountObj, ref customerHeaderDiscountId, dBHelper);
                        if (result != GlobalErrors.Success) return result; 
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteHeaderDiscount(int HeaderdiscountID)
        {

            GlobalErrors result = GlobalErrors.Error;
            string queryString = string.Empty;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                queryString = string.Format("UPDATE HeaderDiscount SET IsDeleted = 1 WHERE HeaderDiscountID = {0}; ", HeaderdiscountID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(queryString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteCustomerHeaderDiscount(HeaderDiscountModel HeaderdiscountObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection || _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                {
                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                    }

                    string query = $@"DELETE FROM CustomerHeaderDiscount WHERE HeaderDiscountID = {HeaderdiscountObj.HeaderDiscountId}
                        and ((IsNull(ChannelID,-1) <> -1) or (IsNull(SubChannelID,-1) <> -1) or AllCustomers = 1)";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        query = $@" DELETE DA FROM CustomerHeaderDiscount DA                               
                                           inner join CustomerGroup CG  on CG.GroupID = DA.GroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE DA.HeaderDiscountID = {HeaderdiscountObj.HeaderDiscountId} ";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                    if ((result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected) && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        query = $@" DELETE DA FROM CustomerHeaderDiscount DA 
                                           inner join CustomerOutlet CO on CO.CustomerID = DA.CustomerID and CO.OutletID = DA.OutletID
                                           {orgAccessJoin}
                                           WHERE DA.HeaderDiscountID = {HeaderdiscountObj.HeaderDiscountId} ";
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                else
                {
                    string query = string.Format("delete from CustomerHeaderDiscount where HeaderDiscountID={0}", HeaderdiscountObj.HeaderDiscountId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateHeaderDiscount(HeaderDiscountModel HeaderdiscountObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"UPDATE HeaderDiscount SET DiscountTypeID = {0} ,Value = {1} , StartDate= {2} ,EndDate = {3} 
                      ,UpdatedDate = {4}  , UpdatedBy = {5}  ,OrganizationID = {6} ,TypeID = {7} ,SaleModeID = {8}  WHERE HeaderDiscountID = {9}",
                                HeaderdiscountObj.DiscountTypeId,// 0
                                HeaderdiscountObj.Value, //1
                                LocalUtilities.ParseDateToSQLString(HeaderdiscountObj.StartDate.GetValueOrDefault()), //2
                                LocalUtilities.ParseEndDateToSQLString(HeaderdiscountObj.EndDate.GetValueOrDefault()),//3
                                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),//4
                                _requestRepository.CurrentOperator.EmployeeId,//5
                                HeaderdiscountObj.OrganizationId, //6
                                HeaderdiscountObj.TypeId, //7
                                HeaderdiscountObj.SaleModeId, //8
                                HeaderdiscountObj.HeaderDiscountId //9
                                );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors InsertHeaderDiscount(HeaderDiscountModel HeaderDiscountObj, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                HeaderDiscountObj.HeaderDiscountId = GetMaxID("HeaderDiscountID", "HeaderDiscount", dBHelper);

                if (HeaderDiscountObj.HeaderDiscountId != -1)
                {
                    string query = string.Format(@"INSERT INTO HeaderDiscount (HeaderDiscountID ,DiscountTypeID ,Value,StartDate
                                              ,EndDate ,CreatedDate ,UpdatedDate ,CreatedBy ,UpdatedBy ,OrganizationID ,TypeID ,SaleModeID)
                                               VALUES ({0},{1},{2},{3},{4},{5},{5},{6},{6},{7},{8},{9})",
                                                   HeaderDiscountObj.HeaderDiscountId, // 0
                                                   HeaderDiscountObj.DiscountTypeId, // 1
                                                   HeaderDiscountObj.Value, // 2
                                                   LocalUtilities.ParseDateToSQLString(HeaderDiscountObj.StartDate.GetValueOrDefault()),// 3
                                                   LocalUtilities.ParseEndDateToSQLString(HeaderDiscountObj.EndDate.GetValueOrDefault()), // 4
                                                   LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //5
                                                   _requestRepository.CurrentOperator.EmployeeId, // 6
                                                   HeaderDiscountObj.OrganizationId, // 7
                                                   HeaderDiscountObj.TypeId, // 18
                                                   HeaderDiscountObj.SaleModeId // 9
                                                  );
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetHeaderDiscounts(GeneralFilter filter, ref SharedTableResult<HeaderDiscountModel> Headerdiscounts)
        {
            DBHelper<HeaderDiscountModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<HeaderDiscountModel> lists = new List<HeaderDiscountModel>();
                dbHelper = new DBHelper<HeaderDiscountModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (filter.TypeId != -1)
                    {
                        searchFilter += string.Format(@" And  HeaderDiscount.TypeID ={0}", filter.TypeId);
                    }
                    if (filter.DiscountTypeId != -1)
                    {
                        searchFilter += string.Format(@" And  HeaderDiscount.DiscountTypeID ={0}", filter.DiscountTypeId);
                    }
                    if (filter.SaleModeId != -1)
                    {
                        searchFilter += string.Format(@" And  HeaderDiscount.SaleModeID ={0}", filter.SaleModeId);
                    }
                    if (filter.OrganizationId != -1)
                    {
                        searchFilter += string.Format(@" And  HeaderDiscount.OrganizationID ={0}", filter.OrganizationId);
                    }
                    if (filter.groupId != -1)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.GroupID ={0}", filter.groupId);
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.CustomerID ={0}", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.OutletID ={0}", filter.OutletId);
                    }
                    if (filter.SubChannelId != -1)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.SubChannelID ={0}", filter.SubChannelId);
                    }
                    if (filter.AllCustomers)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.AllCustomers = 1");
                    }
                    if (!string.IsNullOrEmpty(filter.ChannelId.ToString()) && filter.ChannelId > -1)
                    {
                        searchFilter += string.Format(@" And  CustomerHeaderDiscount.ChannelID ={0}", filter.ChannelId);
                    }
                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" And  HeaderDiscount.StartDate>={0} ",
                            LocalUtilities.ParseDateToSQLString(filter.DateModel.Date));
                    }
                    if (filter.ToDate != null)
                    {
                        searchFilter += string.Format(" And  HeaderDiscount.EndDate<={0} ",
                            LocalUtilities.ParseEndDateToSQLString(filter.ToDate.Date));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By tt.StartDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }

                string mainQuery = string.Format(@"
                                    select distinct HeaderDiscount.HeaderDiscountID,
                                    HeaderDiscount.DiscountTypeID,
                                    HeaderDiscount.Value,
                                    HeaderDiscount.StartDate,
                                    HeaderDiscount.EndDate,
                                    HeaderDiscount.OrganizationID,
                                    HeaderDiscount.TypeID,
                                    case when HeaderDiscount.TypeID = 1 then '{0}'
		                 		    when HeaderDiscount.TypeID = 2 then '{1}'
                                    END AS TypeIdName,
                                    HeaderDiscount.SaleModeID,                                   
                                    OrganizationLanguage.Description As OrganizationName, 
                                    DiscountTypeLanguage.Description As DiscountType,
                                    CASE 
                                    WHEN HeaderDiscount.SaleModeID = -1 THEN '---'
                                    ELSE SalesModeLanguage.Description
                                    END AS SalesModeName,
                                    isNull(CustomerHeaderDiscount.AllCustomers,0) AllCustomers  
                                    From HeaderDiscount 
                                    LEFT JOIN SalesModeLanguage
                                    ON SalesModeLanguage.SalesModeID = HeaderDiscount.SaleModeID
                                    AND SalesModeLanguage.LanguageID = {2}
                                    LEFT JOIN DiscountTypeLanguage 
                                    ON DiscountTypeLanguage.DiscountTypeID = HeaderDiscount.DiscountTypeID 
                                    AND DiscountTypeLanguage.LanguageID = {2}
                                    LEFT JOIN OrganizationLanguage 
                                    ON OrganizationLanguage.OrganizationID = HeaderDiscount.OrganizationID 
                                    AND OrganizationLanguage.LanguageID = {2}
                                    LEFT JOIN CustomerHeaderDiscount 
                                    ON HeaderDiscount.HeaderDiscountID = CustomerHeaderDiscount.HeaderDiscountID
                                    WHERE HeaderDiscount.OrganizationID IN ({3}) {4}
                                    AND HeaderDiscount.IsDeleted = 0",
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Normal_Header_Discount, _requestRepository.LanguageId),// 0
                                    ResourcesManager.TranslateKey(CaptionsConstants.Desc_Cash_Header_Discount, _requestRepository.LanguageId), //1
                                    _requestRepository.LanguageId,//2
                                    _requestRepository.CurrentOperator.OrganizationAccess,//3
                                     searchFilter//4
                                    );

                string allDataQuery = string.Format(@"Select * from ({0}) tt {1} OFFSET {2} ROWS  FETCH NEXT {3} ROWS ONLY",
                                    mainQuery,//0
                                    orderByFilter,//1
                                    (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,//2
                                    filter.CustomListFilter.PageSize//3
                                   );

                string countQuery = string.Format(@"select IsNull(Count(*),0) from ({0})tt ",mainQuery);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    Headerdiscounts.TotalItems = int.Parse(objField.ToString().Trim());
                    if (Headerdiscounts.TotalItems <= 0)
                    {
                        Headerdiscounts.Data = lists;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(allDataQuery, ref lists , true);
                Headerdiscounts.Data = lists;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                Headerdiscounts = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSalesMode(ref List<SalesModeModel> salesModes)
        {
            DBHelper<SalesModeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SalesModeModel>();

                string query = string.Format(@"select SalesMode.SalesModeID SalesModeId ,SalesModeLanguage.Description SalesModeName from SalesMode
                inner join SalesModeLanguage on SalesModeLanguage.SalesModeID = SalesMode.SalesModeID
				and SalesModeLanguage.LanguageID = {0} where SalesMode.SalesModeID in (1,2)", _requestRepository.LanguageId);

                result = dbHelper.GetQueryList(query, ref salesModes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                salesModes = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}
