﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Reflection;

namespace Sonic.Web.Core
{
    public class RouteHistoryManager
    {
        private readonly IRequestRepository _requestRepository;
        public RouteHistoryManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public bool IsEmployeeRouteUploaded(int employeeId)
        {
            return IsEmployeeRouteUploaded(employeeId, null);
        }
        public bool IsEmployeeRouteUploaded(int employeeId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                object objField = 0;

                string query = string.Format(@"select Uploaded from RouteHistory where RouteHistoryID = (Select MAX(RouteHistoryID) From RouteHistory where EmployeeId = {0}) ", employeeId);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && Convert.ToBoolean(objField.ToString()))
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
    }
}