﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.Core
{
    public class RouteManager
    {
        private readonly IRequestRepository _requestRepository;
        public RouteManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public static bool IsCustomerInDriverTerritoy(int customerID, int outletID, int driverID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();

                object objField = 0;
                string query = string.Format(@"SELECT COUNT(*) FROM CustOutTerritory
                             INNER JOIN EmployeeTerritory ON CustOutTerritory.TerritoryID = EmployeeTerritory.TerritoryID AND EmployeeTerritory.EmployeeID = {0}
                             WHERE CustOutTerritory.CustomerID = {1} AND CustOutTerritory.OutletID = {2} ", driverID, customerID, outletID);

                result = dbHelper.ExecuteScalar(query, ref objField);
                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && int.Parse(objField.ToString()) > 0)
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return false;
            }
            return false;
        }

        public static bool IsCustomerInEmployeeTerritorRoutes(int customerID, int outletID, int employeeID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                object objField = 0;
                string query = string.Format(@" Select Count(RouteCustomer.RouteID)
                from RouteCustomer
                inner join Route on Route.RouteID = RouteCustomer.RouteID and RouteCustomer.CustomerID = {0} and RouteCustomer.OutletID = {1}
                inner join EmployeeTerritory on EmployeeTerritory.TerritoryID = Route.TerritoryID
                where EmployeeTerritory.EmployeeID = {2}", customerID, outletID, employeeID);
                result = dbHelper.ExecuteScalar(query, ref objField);

                if (result == GlobalErrors.Success)
                {
                    if (objField != null && objField != DBNull.Value && int.Parse(objField.ToString()) > 0)
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return false;
            }
            return false;
        }

        public bool IsRouteUploaded(int routehistoryID, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                object objField = null;
                string query = string.Format(@"SELECT Uploaded FROM RouteHistory WHERE routehistoryID = {0}", routehistoryID);
                result = dbHelper.ExecuteScalar(query, ref objField);

                if (result == GlobalErrors.Success)
                {
                    if (objField != null && (objField.ToString().Equals("1") || objField.ToString().ToLower().Equals("true")))
                        return true;
                    else
                        return false;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);

                return false;
            }
            return false;
        }

        public int GetEmployeeUploadedRoute(int EmployeeId)
        {
            var result = GlobalErrors.NotInitialized;
            int routeId = -1;
            DBHelper<int> dbHelper;
            try
            {
                dbHelper = new DBHelper<int>();
                object feild = null;
                string query = string.Format(@"SELECT RouteID from RouteHistory Where RouteHistoryID = (Select Max(RouteHistoryID) From RouteHistory Where EmployeeID = {0}) AND Uploaded = 1", EmployeeId);
                result = dbHelper.ExecuteScalar(query, ref feild);
                if (result == GlobalErrors.Success && feild != null && feild != DBNull.Value && feild.ToString() != string.Empty)
                {
                    routeId = int.Parse(feild.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return routeId;
        }

        public  int GetRouteTerritory(int routeId, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            int territoryId = -1;
            try
            {
                object feild = null;
                string query = string.Format(@"SELECT TerritoryID FROM Route WHERE RouteID = {0} ", routeId);
                result = dbHelper.ExecuteScalar(query, ref feild);

                if (result == GlobalErrors.Success && feild != null && feild != DBNull.Value && feild.ToString() != string.Empty)
                {
                    territoryId = int.Parse(feild.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return territoryId;
        }

        public  GlobalErrors GetAllTerritoryCustomers(int territoryId, DBHelper<CustomerModel> dbHelper , ref List<CustomerModel> customers)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select distinct Customer.CustomerID , Customer.CustomerCode , CustomerLanguage.Description CustomerName , IsNull(CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                , CustOutTerritory.TerritoryID
                from CustOutTerritory 
                INNER JOIN Customer on CustOutTerritory.CustomerID = Customer.CustomerID AND Customer.New <> 1
                LEFT JOIN  CustomerLanguage on Customer.CustomerID=CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID ={0}
                where CustOutTerritory.TerritoryID = {1}
                Order By Description"
               , _requestRepository.LanguageId
               , territoryId);

                result = dbHelper.GetQueryList(query, ref customers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public  GlobalErrors GetAllRouteCustomers(int routeId, DBHelper<CustomerModel> dbHelper, ref List<CustomerModel> customers)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select Distinct CustomerLanguage.CustomerID,CustomerLanguage.Description CustomerName ,Customer.CustomerCode ,  IsNull(CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName
                            , Route.TerritoryId
                            FROM RouteCustomer 
                            INNER JOIN Route ON Route.RouteID = RouteCustomer.RouteID
                            INNER JOIN Customer ON RouteCustomer.CustomerID=Customer.CustomerID and Customer.New <> 1 
                            INNER JOIN CustomerLanguage ON Customer.CustomerID=CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID= {0}
                            where  RouteCustomer.RouteID = {1} 
							Order By Description"
               , _requestRepository.LanguageId
               , routeId);

                result = dbHelper.GetQueryList(query, ref customers);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
    }
}