﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Reflection;

namespace Sonic.Web.Core
{
    public class ServicesManager
    {
        private readonly IRequestRepository _requestRepository;

        public ServicesManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public GlobalErrors GetAllServices(ref List<ServicesModel> allServices)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ServicesModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ServicesModel>();
                allServices = new List<ServicesModel>();
                string query = string.Format(@" Select WindowsServices.ServiceID,WindowsServices.IsEnabled,
                WindowsServices.IsCertainTimeRuning,
                Case WindowsServices.IsEnabled when 1 then '{1}' else '{2}' end as ServiceStatus ,
                WindowsServicesLanguage.Description ServiceName,WindowsServicesLanguage.Definition ServiceDefinition,WindowsServices.TimeToRun,
                WindowsServices.NumberOfMinutesToSleep ,WindowsServices.IsWebService,
               Case WindowsServices.IsWebService when 1 then '{3}' else '{4}' end as WebService , WindowsServices.ServiceName ServiceTitle
                from WindowsServices 
                inner join  WindowsServicesLanguage on WindowsServices.ServiceID=WindowsServicesLanguage.ServiceID and LanguageID={0}"
                , _requestRepository.LanguageId,//0
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Enabled,_requestRepository.LanguageId), // 1
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Disabled,_requestRepository.LanguageId),//2
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId),//3
                ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId)//4
                );
                result = dbHelper.GetQueryList(query, ref allServices);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors UpdateServices(ServicesModel serviceModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ServicesModel> dbHelper = null;
                string query = string.Empty;
                dbHelper = new DBHelper<ServicesModel>();
                string filterDate = string.Empty;
                if (serviceModel.IsEnabled)
                {
                    if (serviceModel.IsCertainTimeRuning 
                        && serviceModel.TimeToRunModel != null 
                        && serviceModel.TimeToRunModel.Date != null)
                        filterDate = string.Format(" ,TimeToRun={0}, LastRunTime = {1}", LocalUtilities.ParseDateAndTimeToSQL(serviceModel.TimeToRunModel.Date), LocalUtilities.ParseDateAndTimeToSQL(serviceModel.TimeToRunModel.Date.AddYears(100)));
                    query = string.Format(@"Update WindowsServices set IsCertainTimeRuning= {0}
                                   ,NumberOfMinutesToSleep={1},IsEnabled={2},IsWebService = {5} {4}
                                   where ServiceID={3}  ",
                                   (serviceModel.IsCertainTimeRuning? "1" : "0"), //0
                                   serviceModel.NumberOfMinutesToSleep, //1
                                   (serviceModel.IsEnabled? "1" : "0"), //2
                                   serviceModel.ServiceId , //3
                                   filterDate, //4,
                                   serviceModel.IsWebService ? 1 : 0
                                   );

                    if (serviceModel.ServiceId == 25)
                    {
                        //todo start running
                    }
                }
                else
                {
                    query = string.Format(@"Update WindowsServices set IsEnabled={0} 
                                   where ServiceID={1}  ",
                                   (serviceModel.IsEnabled ? "1" : "0"), //0
                                   serviceModel.ServiceId //1
                                   );

                    if(serviceModel.ServiceId == 25)
                    {
                        //todo stop service from running
                    }
                }
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public WindowsServiceData GetWindowsServiceData()
        {
            WindowsServiceData windowsServiceData = new WindowsServiceData();
            DBHelper<WindowsServiceData> dbHelper = new DBHelper<WindowsServiceData>();
            string query = string.Empty;
            try
            {
                query = string.Format(@"select ServiceID, ServiceName, IsCertainTimeRuning, TimeToRun, NumberOfMinutesToSleep 
                from WindowsServices 
                where IsEnabled = 1 AND ServiceName = 'SendProofEmails'");
                dbHelper.GetQuerySingle(query, ref windowsServiceData);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return windowsServiceData;
        } 

    }
}