﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Model.General;
using Sonic.Web.Model.MasterData;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Data;
using System.Dynamic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core
{
    public class SettingManager
    {
        private readonly IRequestRepository _requestRepository;
        public SettingManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        public static List<LanguageCaption> GetAllDescriptions()
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<LanguageCaption> dBHelper = null;
            List<LanguageCaption> captions = new List<LanguageCaption>();
            try
            {
                dBHelper = new DBHelper<LanguageCaption>();

                string query = string.Format(@"select Trim(DescriptionKey)DescriptionKey , DescriptionValue , LanguageId  From SonicDescription Order by DescriptionKey , LanguageId");

                result = dBHelper.GetQueryList(query, ref captions);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return captions;
        }

        public static GlobalErrors GetAllLanguages(ref List<LanguageModel> languages, bool activeLanguageOnly)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<LanguageModel> dBHelper = null;
            string activeFilter = string.Empty;
            try
            {
                dBHelper = new DBHelper<LanguageModel>();
                if (activeLanguageOnly)
                    activeFilter = " Where Languages.Active = 1 ";
                string query = string.Format(@"select Languages.*,Languages.Active IsChecked,Languages.Active OldStatus from  Languages {0}  order by LanguageID", activeFilter);
                result = dBHelper.GetQueryList(query, ref languages);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public  GlobalErrors GetModuleEditableDescriptions(int moduleId, ref List<dynamic> captions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<dynamic> dBHelper = null;
            string query = "";
            try
            {
                dBHelper = new DBHelper<dynamic>();
                if (moduleId == 1100) { // sonic FO Descriptions
                    query = string.Format(@"declare  @select nvarchar(max)=''
                declare  @columns nvarchar(max)=''
                declare  @joins nvarchar(max)=''
                declare  @Filter nvarchar(max)= ''
                declare  @languageID int
                declare  @description nvarchar(max)=''
                declare @languages table (languageID int , description nvarchar(max))
                insert into @languages select languageid,description from Languages Where Languages.Active = 1
                set @select = 'Select SD1.*'
                set @columns = ''
                WHILE EXISTS(Select * from @languages)
                begin
                Select top 1 @languageID = languageID,@description = description from @languages
                set @columns=@columns+','+Convert(nvarchar(max),@languageID)+' as'+' LanguageID'+Convert(nvarchar(max),@languageID)+
                ','+' LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionValue as DescriptionValue'+Convert(nvarchar(max),@languageID)+
                ','+' LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionValue as DescriptionBeforeEdit'+Convert(nvarchar(max),@languageID)
                set @joins = @joins + ' Left Join SonicFODescription as LanguageID' +Convert(nvarchar(max),@languageID) 
                + ' On LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionKey = SD1.DescriptionKey '+' AND LanguageID'+Convert(nvarchar(max),@languageID)+'.LanguageID =' +Convert(nvarchar(max),@languageID) 
                Delete from @languages Where LanguageID =@languageID
                end
                set @select = @select+@columns
                set @select=@select+' From (Select Distinct DescriptionKey From SonicFODescription) SD1' + +@joins + @Filter
                exec(@select)");
                }
                else {
                    query = string.Format(@"
                declare  @select nvarchar(max)=''
                declare  @columns nvarchar(max)=''
                declare  @joins nvarchar(max)=''
                declare  @Filter nvarchar(max)= ' Where SD1.ModuleID = {0}'
                declare  @languageID int
                declare  @description nvarchar(max)=''
                declare @languages table (languageID int , description nvarchar(max))
                insert into @languages select languageid,description from Languages Where Languages.Active = 1
                set @select = 'Select SD1.*'
                set @columns = ''
                WHILE EXISTS(Select * from @languages)
                begin
                Select top 1 @languageID = languageID,@description = description from @languages
                set @columns=@columns+','+Convert(nvarchar(max),@languageID)+' as'+' LanguageID'+Convert(nvarchar(max),@languageID)+
                ','+' LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionValue as DescriptionValue'+Convert(nvarchar(max),@languageID)+
                ','+' LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionValue as DescriptionBeforeEdit'+Convert(nvarchar(max),@languageID)
                set @joins = @joins + ' Left Join SonicDescription as LanguageID' +Convert(nvarchar(max),@languageID) 
                + ' On LanguageID'+Convert(nvarchar(max),@languageID)+'.DescriptionKey = SD1.DescriptionKey And SD1.ModuleID = '+'LanguageID'+Convert(nvarchar(max),@languageID)+'.ModuleID AND LanguageID'+Convert(nvarchar(max),@languageID)+'.LanguageID =' +Convert(nvarchar(max),@languageID) 
                Delete from @languages Where LanguageID =@languageID
                end
                set @select = @select+@columns
                set @select=@select+' From (Select Distinct Trim(DescriptionKey)DescriptionKey,ModuleID,IsEditable From SonicDescription) SD1' + +@joins + @Filter
                exec(@select)", moduleId);
                }
                DataTable dt = new DataTable();
                result = dBHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    captions = new List<dynamic>();
                    DynamicProperty dynamic;
                    for (int rowIndex = 0; rowIndex < dt.Rows.Count; rowIndex++)
                    {
                        dynamic = new DynamicProperty();
                        for (int index = 0; index < dt.Columns.Count; index++)
                        {
                            dynamic[dt.Columns[index].ColumnName] = dt.Rows[rowIndex][index].ToString();
                        }
                        captions.Add(dynamic.Properties);
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public  static GlobalErrors GetSonicLanguages(ref List<LanguageModel> languages)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<LanguageModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<LanguageModel>();

                string query = string.Format(@"select Languages.*,Languages.Active IsChecked from  Languages Where Languages.Active = 1 order by LanguageID");

                result = dBHelper.GetQueryList(query, ref languages);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public  GlobalErrors UpdateDescriptions(List<ExpandoObject> captions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            string query = string.Empty;
            Dictionary<int, string> LanguagesDescriptions = new Dictionary<int, string>();
            var languages = new List<LanguageModel>();
            try
            {
                result = GetSonicLanguages(ref languages);
                dbHelper = new DBHelper<string>();
                if (result == GlobalErrors.Success)
                {
                    foreach (var caption in captions)
                    {
                        var captionsDictionary = new Dictionary<string, object>(caption);
                        foreach (var language in languages)
                        {
                            query = string.Format(@"Update SonicDescription set DescriptionValue = '{0}' Where DescriptionKey = '{1}' AND ModuleID = {2} AND
                            LanguageID = {3}", Convert.ToString(captionsDictionary["DescriptionValue"+language.LanguageId.ToString()]),
                                 Convert.ToString(captionsDictionary["DescriptionKey"]),
                                 Convert.ToString(captionsDictionary["ModuleID"]),
                                 language.LanguageId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors UpdateFODescriptions(List<ExpandoObject> captions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = null;
            string query = string.Empty;
            Dictionary<int, string> LanguagesDescriptions = new Dictionary<int, string>();
            var languages = new List<LanguageModel>();
            try
            {
                result = GetSonicLanguages(ref languages);
                dbHelper = new DBHelper<string>();
                if (result == GlobalErrors.Success)
                {
                    foreach (var caption in captions)
                    {
                        var captionsDictionary = new Dictionary<string, object>(caption);
                        foreach (var language in languages)
                        {
                            query = string.Format(@"Update SonicFODescription set DescriptionValue = '{0}' Where DescriptionKey = '{1}' AND
                            LanguageID = {2}", Convert.ToString(captionsDictionary["DescriptionValue" + language.LanguageId.ToString()]),
                                 Convert.ToString(captionsDictionary["DescriptionKey"]),
                            language.LanguageId);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) break;
                        }
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public static int GetMaxSecurityGroupID(DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "Select IsNull(max(SecurityGroupID),0) + 1 maxSecurityGroup from SecurityGroup";
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }

        public GlobalErrors SaveOperationLevels(List<ApprovalCycleOperationsModel> DataList) {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                StringBuilder values = new StringBuilder();
                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();
                query = string.Format("Delete From  ApprovalCycleLevels");
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if(result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {
                    foreach (ApprovalCycleOperationsModel record in DataList)
                    {
                        query = string.Format("INSERT INTO ApprovalCycleLevels (OperationId ,LevelId ,SecurityGroupId ,SelectedOrganizationID) Values ({0} , {1} , {2} , {3})",
                             record.OperationId, record.LevelId, record.SecurityGroupId , record.OrganizationId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                            break;
                        if (record.Validations != null && record.Validations.Count > 0)
                        {
                            record.Validations.ForEach(validationId =>
                            {
                                values.Append($"({record.OperationId},{record.LevelId},{record.SecurityGroupId},{validationId}),");
                            });
                        }
                    }
                }
                if (result == GlobalErrors.Success) 
                {
                    query = "Delete From ApprovalCycleValidation";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success && !string.IsNullOrEmpty(values.ToString()))
                {
                    query = $@"Insert into ApprovalCycleValidation (OperationID, LevelID, SecurityGroupID, ValidationID) VALUES {values.ToString().TrimEnd(',')}";
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally 
            {
                if (dBHelper != null) 
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else 
                    {
                        dBHelper.RollBackTransaction();
                    }
                }
            }
            return result;
        }
        public  GlobalErrors UpdateSecurityGroups(SecurityGroupData Data)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            MenuModel[] Menus = Data.Menus;
            int SecurityGroupId = Data.SecurityGroupId;
            int OrganizationId = Data.OrganizationId;
            List<SecurityGroupLanguage> Descriptions = Data.Descriptions;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                if(SecurityGroupId == -1)
                {
                    SecurityGroupId = GetMaxSecurityGroupID(dbHelper);
                    if(SecurityGroupId <= 0)
                    {
                        return GlobalErrors.Error;
                    }

                    query = string.Format(@"INSERT INTO SecurityGroup (SecurityGroupID, LoginTypeID, OrganizationID) Values ({0}, {1}, {2})",
                        SecurityGroupId, 1, OrganizationId);
                    result = dbHelper.ExecuteNonQuery(query);
                }
                else
                {
                    query = string.Format(@"Delete from WebSecurityGroupPrivilege where SecurityGroupID = {0}", SecurityGroupId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Delete from SecurityGroupLanguage where SecurityGroupID = {0} ", SecurityGroupId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }

                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"DELETE SecurityGroupPrivilege from SecurityGroupPrivilege 
                        INNER JOIN Menu on Menu.MenuID = SecurityGroupPrivilege.MenuID
                        where SecurityGroupID = {0} 
                        AND ((SecurityGroupPrivilege.MenuID >= 5000 AND SecurityGroupPrivilege.MenuID < 6000) OR SecurityGroupPrivilege.MenuID = 5 
                        OR Menu.ParentMenuID = 5)", SecurityGroupId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        query = $@"DELETE OSG FROM OperatorSecurityGroup AS OSG 
                        Inner join SecurityGroup on OSG.SecurityGroupID = SecurityGroup.SecurityGroupID
                        where OSG.SecurityGroupID = {SecurityGroupId} and SecurityGroup.OrganizationId <> {OrganizationId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format(@"Update SecurityGroup set OrganizationID = {1} where SecurityGroupID = {0}", SecurityGroupId, OrganizationId);
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected)
                            result = GlobalErrors.Success;
                    }
                }
                
                if(result == GlobalErrors.Success)
                {
                    foreach (MenuModel menu in Menus)
                    {
                        if(result == GlobalErrors.Success && (menu.IsWebMenu || menu.ParentMenuId == "1400" || menu.MenuId=="1400"))
                        {
                            if (menu.AddedActionTypes != null && menu.AddedActionTypes.Count > 0)
                            {
                                foreach (ActionTypesModel action in menu.AddedActionTypes)
                                {
                                    query = string.Format(@"INSERT INTO WebSecurityGroupPrivilege 
                                    (SecurityGroupID, MenuID, ActionTypeId) 
                                    Values ({0}, '{1}', {2})",
                                    SecurityGroupId, //0
                                    menu.MenuId, //1,
                                    action.ActionTypeId);
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success)
                                        break;
                                }
                            }
                            else if (result == GlobalErrors.Success)
                            {
                                query = string.Format(@"INSERT INTO WebSecurityGroupPrivilege 
                                (SecurityGroupID, MenuID, ActionTypeId) 
                                Values ({0}, '{1}', -1)",
                                SecurityGroupId, //0
                                menu.MenuId); //1,
                                result = dbHelper.ExecuteNonQuery(query);
                            }
                        }
                        else
                        {
                            query = string.Format(@"INSERT INTO SecurityGroupPrivilege (SecurityGroupID, ApplicationID, MenuID, AddPermission, EditPermission, DeletePermission)
                            Values ({0}, {1}, {2}, {3}, {4}, {5})", SecurityGroupId, 1, menu.MenuId, 1, 1, 1);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                        if (result != GlobalErrors.Success)
                        {
                            break;
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        foreach (SecurityGroupLanguage descriptions in Descriptions)
                        {
                            query = string.Format(@"INSERT INTO SecurityGroupLanguage (SecurityGroupID, LanguageID, Description) VALUES ({0}, {1}, '{2}')",
                            SecurityGroupId, descriptions.LanguageId, descriptions.Description);
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                                break;
                        }
                    }
                }
                if (result == GlobalErrors.Success) 
                {
                    query = $@"Delete SGP from SecurityGroupPrivilege SGP
                            Inner join MappingReports  MR on MR.BOMenuID = SGP.MenuID 
                            where SGP.SecurityGroupID = {SecurityGroupId}";
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;

                    if (result == GlobalErrors.Success) 
                    {
                        query = $@"
                        Insert into SecurityGroupPrivilege (SecurityGroupID,ApplicationID,MenuID,AddPermission,EditPermission,DeletePermission)
                        Select distinct {SecurityGroupId},  1, MappingReports.BOMenuID, 1,1,1
                        from MappingReports
                        INNER JOIN WebSecurityGroupPrivilege on MappingReports.WebMenuId = WebSecurityGroupPrivilege.MenuID and WebSecurityGroupPrivilege.SecurityGroupID = {SecurityGroupId}";
                        result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                        if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                    }
                }
                if(result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors DeleteSecurityGroup(int securityGroupId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();

                string query = string.Format(@"Delete from OperatorSecurityGroup where SecurityGroupID = {0}", securityGroupId);//remove operator security group
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;


                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from SecurityGroupPrivilege where SecurityGroupID = {0}", securityGroupId);//remove privileges related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from WebSecurityGroupPrivilege where SecurityGroupID = {0}", securityGroupId);//remove web privileges related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from GMSecurityGroupFields where SecurityGroupID = {0}", securityGroupId);//remove golden minute fields related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from GMSecurityGroupGroups where SecurityGroupID = {0}", securityGroupId);//remove golden minute groups related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from SecurityGroupNotification where SecurityGroupID = {0}", securityGroupId);//remove notifications related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from ConfigurationSecurityGroup where SecurityGroupID = {0}", securityGroupId);//remove configurations related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from ConfigurationSecurityGroupHistory where SecurityGroupID = {0}", securityGroupId);//remove configurations history related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from SurveySecurityGroupAssignment where SecurityGroupID = {0}", securityGroupId);//remove surveys related to the security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from SecurityGroupLanguage where SecurityGroupID = {0}", securityGroupId);//remove security group language
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from SecurityGroup WHERE SecurityGroupID = {0}", securityGroupId);//remove security group
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                        result = GlobalErrors.Success;
                }

                if (result == GlobalErrors.Success)
                {
                    result = dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
        }

        public GlobalErrors GetAvailableSecurityGroupsList(ref List<SecurityGroupsListModel> securityGroupsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SecurityGroupsListModel> dBHelper = null;
            DBHelper<SecurityGroupLanguage> dBHelperSecurityGroupLanguage = null;
            List<SecurityGroupLanguage> securityGroupDescriptions = new List<SecurityGroupLanguage>();
            try
            {
                dBHelper = new DBHelper<SecurityGroupsListModel>();
                dBHelperSecurityGroupLanguage = new DBHelper<SecurityGroupLanguage>();
                string excludeAdminFilter = string.Empty;

                // No need for this line since we handle security group saving for admin from employee screen
                //if (_requestRepository.CurrentOperator.EmployeeId != 0)
                //{
                //    excludeAdminFilter = " AND SG.SecurityGroupID <> 1";
                //}
                string query = string.Format(@"select SG.SecurityGroupID, O.OrganizationID, SGL.Description as SecurityGroupName, 
                IsNull( O.OrganizationCode, '--') +' ' + '-' + ' ' + IsNull(OL.Description, '--') as OrganizationNameCode 
                from SecurityGroup SG
                LEFT OUTER JOIN SecurityGroupLanguage SGL on SGL.SecurityGroupID = SG.SecurityGroupID AND SGL.LanguageID = {0}
                INNER JOIN Organization O on O.OrganizationID = SG.OrganizationID
                LEFT OUTER JOIN OrganizationLanguage OL on OL.OrganizationID = O.OrganizationID AND OL.LanguageID = {0}
                WHERE O.OrganizationID IN ({1}) {2}
                ORDER BY SGL.Description",
                _requestRepository.LanguageId,//0
                _requestRepository.CurrentOperator.OrganizationAccess, //1
                excludeAdminFilter //2
                );
             
                result = dBHelper.GetQueryList(query, ref securityGroupsList);

                if(result == GlobalErrors.Success && securityGroupsList != null && securityGroupsList.Count > 0)
                {
                    query = string.Format(@"Select * from SecurityGroupLanguage");
                    result = dBHelperSecurityGroupLanguage.GetQueryList(query, ref securityGroupDescriptions);

                    if(result == GlobalErrors.Success 
                        && securityGroupDescriptions != null 
                        && securityGroupDescriptions.Count > 0)
                    {
                        securityGroupsList.ForEach(x =>
                        {
                            x.Descritpions = securityGroupDescriptions.Where(z => z.SecurityGroupId == x.SecurityGroupId).ToList();
                            if (x.Descritpions.Any(x => x.LanguageId == _requestRepository.LanguageId))
                            {
                                x.SecurityGroupName = x.Descritpions.First(x => x.LanguageId == _requestRepository.LanguageId).Description;
                            }
                        });
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetAllOperationLevels(ref List<int> allOperationLevels, int operationId, DBHelper<int> dbHelper) 
        {
            return GetAllOperationLevels(ref allOperationLevels, operationId, -1, dbHelper);
        }
        public GlobalErrors GetAllOperationLevels(ref List<int> allOperationLevels,int operationId, int organizationId,DBHelper<int> dbHelper) {
        
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try {
                if(dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                string securityGroupJoin = string.Empty;
                string organizationFilter = string.Empty;
                string restrictApprovalCycleToOrganizationLevel = _requestRepository.Configurations.RestrictApprovalCycleToOrganizationLevel;
                if (organizationId > -1 && !string.IsNullOrEmpty(restrictApprovalCycleToOrganizationLevel) && restrictApprovalCycleToOrganizationLevel.Contains(operationId.ToString()))  // get all operation levels for security groups under the same organization (organizationId)
                {
                    securityGroupJoin = " inner join SecurityGroup on SecurityGroup.SecurityGroupID = ApprovalCycleLevels.SecurityGroupID";
                    organizationFilter = $@" AND ApprovalCycleLevels.SelectedOrganizationID = {organizationId}";
                }
                query = string.Format(@"Select levelId From ApprovalCycleLevels {1} Where OperationID = {0} {2} order by levelId ", operationId, securityGroupJoin, organizationFilter);
                result = dbHelper.GetQueryList(query, ref allOperationLevels);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result; 
        }
        public GlobalErrors GetOperatorAssignedLevels(ref List<ApprovalCycleOperationsModel> securityLevels, int operationId, DBHelper<ApprovalCycleOperationsModel> dbHelper)
        {
            return GetOperatorAssignedLevels(ref securityLevels, operationId, -1, string.Empty, dbHelper);
        }
        public GlobalErrors GetOperatorAssignedLevels(ref List<ApprovalCycleOperationsModel> securityLevels, int operationId, int operationDetailId, string organizationFilter, DBHelper<ApprovalCycleOperationsModel> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(dbHelper == null)
                {
                    dbHelper = new DBHelper<ApprovalCycleOperationsModel>();
                }

                #region[Check if selected secu organization = promotion organization]
                string restrictApprovalCycleToOrganizationLevel = _requestRepository.Configurations.RestrictApprovalCycleToOrganizationLevel;
                restrictApprovalCycleToOrganizationLevel = !string.IsNullOrEmpty(restrictApprovalCycleToOrganizationLevel) ? restrictApprovalCycleToOrganizationLevel : string.Empty;
                if (operationDetailId > -1 && operationId == (int)ApprovalCycleOperations.Promotions && restrictApprovalCycleToOrganizationLevel.Contains(((int)ApprovalCycleOperations.Promotions).ToString()))
                {
                    organizationFilter = $@"
                        and ApprovalCycleLevels.SelectedOrganizationID in (
					    select Organizationid from CustomerPromotionOrganization where PromotionID = {operationDetailId})";
                }

                #endregion

                string query = string.Format(@"Select ApprovalCycleLevels.LevelId , OperatorSecurityGroup.SecurityGroupId, ApprovalCycleLevels.OperationId, ApprovalCycleLevels.SelectedOrganizationID AS OrganizationId, 
					ISNULL(ApprovalCycleValidation.ValidationID,-1) ValidationID FROM OperatorSecurityGroup 
					Inner Join ApprovalCycleLevels On 
					OperatorSecurityGroup.SecurityGroupId = ApprovalCycleLevels.SecurityGroupId
					LEFT JOIN ApprovalCycleValidation on ApprovalCycleLevels.OperationID = ApprovalCycleValidation.OperationID and 
					ApprovalCycleLevels.LevelID = ApprovalCycleValidation.LevelID and ApprovalCycleLevels.SecurityGroupID = ApprovalCycleValidation.SecurityGroupID
					Where OperatorSecurityGroup.OperatorID = {0}				
	     			And ApprovalCycleLevels.OperationID = {1} {2}",
                   _requestRepository.CurrentOperator.OperatorId, operationId, organizationFilter);                
               
                result = dbHelper.GetQueryList(query, ref securityLevels);
                if (result == GlobalErrors.Success) 
                {
                    securityLevels = securityLevels.GroupBy(x => new { x.LevelId, x.OperationId, x.SecurityGroupId, x.OrganizationId }).Select(grp =>
                    new ApprovalCycleOperationsModel { LevelId = grp.Key.LevelId, OperationId = grp.Key.OperationId, SecurityGroupId = grp.Key.SecurityGroupId, OrganizationId = grp.Key.OrganizationId , Validations = grp.Count() > 0 ? grp.Select(x => x.ValidationId).ToList() : new List<int>() }).ToList();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public  GlobalErrors GetCurrentOperationStatus(int operationId, ref int status, DBHelper<int> dbHelper)
        {
            DBHelper<ApprovalCycleOperationsModel> dBHelper = null;
            string query = "";
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<int> operatorSecurityGroups = new List<int>();
            Object levelId = null;
            List<ApprovalCycleOperationsModel> securityLevels = new List<ApprovalCycleOperationsModel>(); // secGroupId , levelId
            List<int> allOperationLevels = new List<int>();
            int maxSecurityLevel = 0;
            try
            {
                dBHelper = new DBHelper<ApprovalCycleOperationsModel>(); 
                result = GetOperatorAssignedLevels(ref securityLevels , operationId, dBHelper);
                if (result == GlobalErrors.Success && securityLevels != null && securityLevels.Count > 0)
                {
                    maxSecurityLevel = securityLevels.Select(x => x.LevelId).Max();
                    int organizationId = securityLevels.FirstOrDefault().OrganizationId;
                    result = GetAllOperationLevels(ref allOperationLevels , operationId , organizationId, dbHelper);
                    if (allOperationLevels.Max() == maxSecurityLevel)
                    {
                        status = -1;
                    }
                    else
                    {
                        status = maxSecurityLevel;
                    }
                }
                else { // no approval levels have been defined or employee Level not found in approval
                    status = 0;
                }
                
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

     
        public GlobalErrors IsMaxOperationLevel(int operationId, ref bool isMaxLevel, DBHelper<int> dbHelper)
        {
            DBHelper<ApprovalCycleOperationsModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<int> operatorSecurityGroups = new List<int>();
            List<ApprovalCycleOperationsModel> securityLevels = new List<ApprovalCycleOperationsModel>(); // secGroupId , levelId
            List<int> allOperationLevels = new List<int>();
            int maxSecurityLevel = 0;
            try
            {
                dBHelper = new DBHelper<ApprovalCycleOperationsModel>();
                result = GetOperatorAssignedLevels(ref securityLevels, operationId, dBHelper);
                if (result == GlobalErrors.Success && securityLevels != null && securityLevels.Count > 0)
                {
                    maxSecurityLevel = securityLevels.Select(x => x.LevelId).Max();
                    result = GetAllOperationLevels(ref allOperationLevels, operationId, dbHelper);
                    if (allOperationLevels.Max() == maxSecurityLevel)
                    {
                        isMaxLevel =  true;
                    }
                    else
                    {
                        isMaxLevel =  false;
                    }
                }
                else
                { // no approval levels have been defined 
                    isMaxLevel = true;
                    // not false to make update in orgignal tabels in active price this case appeare in is SavePriceList service in note #1
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }


        public GlobalErrors GetApprovalCycleOperations(ref List<ApprovalCycleOperationsModel> approvalCycleOperations) {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ApprovalCycleOperationsModel> dBHelper = null;
            try
            {
                List<ApprovalCycleOperationsModel> operations = new List<ApprovalCycleOperationsModel>();
                string organizationSelection = string.Empty;
                string restrictApprovalCycleToOrganizationLevel = _requestRepository.Configurations.RestrictApprovalCycleToOrganizationLevel;
                restrictApprovalCycleToOrganizationLevel = !string.IsNullOrEmpty(restrictApprovalCycleToOrganizationLevel) ? restrictApprovalCycleToOrganizationLevel : "-1";

                organizationSelection = $@" , CASE WHEN (cast(ApprovalCycleLevels.OperationID as nvarchar(10)) in ({restrictApprovalCycleToOrganizationLevel})) THEN  ApprovalCycleLevels.SelectedOrganizationID  ELSE -1 END AS OrganizationID ";

                dBHelper = new DBHelper<ApprovalCycleOperationsModel>();
                string query = string.Format(@"Select ApprovalCycleLevels.OperationID , ApprovalCycleLevels.SecurityGroupID ,IsNull(CONVERT(nvarchar, SecurityGroup.SecurityGroupID) , '--') + ' ' + '-'+ ' ' + IsNull( SecurityGroupLanguage.Description , '--') as SecurityGroupIdName,
                    ApprovalCycleLevels.LevelID {1} , ApprovalCycleValidation.ValidationID, ApprovalCycleValidation.ValidationDescription FROM ApprovalCycleLevels 
                    INNER JOIN SecurityGroup ON ApprovalCycleLevels.SecurityGroupID = SecurityGroup.SecurityGroupID
                    left join SecurityGroupLanguage on ApprovalCycleLevels.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID
                    and SecurityGroupLanguage.languageId = {0}
	                LEFT JOIN (
	                    select *,
	                    CASE WHEN ValidationID = 1 THEN (select descriptionValue from SonicDescription where DescriptionKey = 'Desc_Payment_Term' and LanguageId = {0})
	                    WHEN ValidationID = 2 THEN (select descriptionValue from SonicDescription where DescriptionKey = 'Desc_Credit_Limit' and LanguageId = {0})
	                    WHEN ValidationID = 3 THEN (select descriptionValue from SonicDescription where DescriptionKey = 'Desc_On_Hold_Status' and LanguageId = {0})
	                    WHEN ValidationID = 4 THEN (select descriptionValue from SonicDescription where DescriptionKey = 'Desc_Warehouse_Stock' and LanguageId = {0})
	                    ELSE ''
	                    END as ValidationDescription
                        from ApprovalCycleValidation
                    ) ApprovalCycleValidation on ApprovalCycleValidation.OperationID = ApprovalCycleLevels.OperationID
					and ApprovalCycleValidation.SecurityGroupID = ApprovalCycleLevels.SecurityGroupID and 
					ApprovalCycleValidation.LevelID = ApprovalCycleLevels.LevelID
                    Order By ApprovalCycleLevels.OperationID , ApprovalCycleLevels.LevelID ", _requestRepository.LanguageId, organizationSelection);
                result = dBHelper.GetQueryList(query, ref operations);
                if (result == GlobalErrors.Success && operations != null && operations.Count > 0) 
                {
                    approvalCycleOperations = operations.GroupBy(x => new { x.LevelId, x.OperationId, x.SecurityGroupId, x.OrganizationId })
                        .Select(grp => new ApprovalCycleOperationsModel 
                        {   LevelId = grp.Key.LevelId, 
                            OperationId = grp.Key.OperationId, 
                            SecurityGroupId = grp.Key.SecurityGroupId, 
                            OrganizationId = grp.Key.OrganizationId,
                            SecurityGroupIdName = grp.FirstOrDefault().SecurityGroupIdName,
                            Validations = grp.Count() > 0 && grp.Any(g => g.ValidationId > 0) ? grp.Select(x => x.ValidationId).ToList() : new List<int>() ,
                            ValidationsString = grp.Count() > 0 && grp.Any(g => g.ValidationId > 0) ? string.Join(" ,", grp.Select(x => x.ValidationDescription).ToList()) : string.Empty
                        }).ToList();
                }
                return result;
            }
            catch (Exception ex) {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetDescriptionsList(int SecurityGroupId, ref List<TextLanguage> DescriptionsList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();

                string query = string.Format(@"Select LanguageId, Description from SecurityGroupLanguage where SecurityGroupId = {0}",
                SecurityGroupId);

                result = dBHelper.GetQueryList(query, ref DescriptionsList);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetSonicModules( ref List<SonicModulesModel> modulesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SonicModulesModel> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<SonicModulesModel>();
                string query = string.Format(@"Select SonicModules.ModuleId,SonicDescription.DescriptionKey ModuleName From SonicModules
                Inner Join SonicDescription on SonicDescription.DefaultDescription = SonicModules.ModuleName AND SonicDescription.LanguageId = 1
                order by SonicModules.ModuleId");
                result = dBHelper.GetQueryList(query, ref modulesList);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors RestoreDefaultCaptions(ref List<SonicModulesModel> modulesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<SonicModulesModel> dBHelper = null;
            string query = string.Empty;
            try
            {
                dBHelper = new DBHelper<SonicModulesModel>();
                foreach (var module in modulesList)
                {
                    if (!module.ApplyReset) continue;
                    if (module.ModuleID == 1100)
                        query = string.Format("Update SonicFODescription set DescriptionValue = DefaultDescription ");
                    else
                        query = string.Format("Update SonicDescription set DescriptionValue = DefaultDescription Where ModuleID = {0}", module.ModuleID);
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) break;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors UpdateLanguageStatus(int languageId, bool status)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format(@"Update Languages SET Active = {0} Where LanguageID = {1}", status ? 1 : 0, languageId);

                result = dbHelper.ExecuteNonQuery(query);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors CloneDescriptionsFromEnglish(int languageId)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format(@"INSERT INTO SonicDescription (DescriptionKey, DescriptionValue, LanguageId, ModuleId , IsEditable)
                SELECT DescriptionKey, DescriptionValue, {0}, ModuleId , IsEditable
                FROM SonicDescription  AS Table_A
                WHERE LanguageId = 1 --AND NOT EXISTS(SELECT DescriptionKey FROM SonicDescription  AS Table_B  WHERE Table_B.DescriptionKey = Table_A.DescriptionKey AND LanguageId =  {0} )", languageId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                if (result == GlobalErrors.Success)
                {
                    dbHelper = new DBHelper<int>();
                    query = string.Format(@"INSERT INTO WebMenuLanguage (MenuID,LanguageID,Description)
                    SELECT MenuID, {0}, Description
                     FROM WebMenuLanguage  
                     WHERE LanguageId = 1", languageId);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteInActiveDescriptions(int languageID) 
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = string.Empty;
            try
            {
                dbHelper = new DBHelper<int>();
                query = string.Format(@"Delete From SonicDescription Where LanguageID = {0}",languageID);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    dbHelper = new DBHelper<int>();
                    query = string.Format(@"Delete From WebMenuLanguage Where LanguageID = {0}", languageID);
                    result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        result = GlobalErrors.Success;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }






        public GlobalErrors GetMax(ref int Id,string column,string table, string conditionString, int conditionId,DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            string whereCondition = string.Empty;
            try
            {
                if(conditionString != string.Empty && conditionId != -1)
                {
                    whereCondition = $" where {conditionString} = {conditionId} ";
                }
                string query = string.Format($"select ISNULL( MAX({column}) , 0)  + 1 From {table} {whereCondition}");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && (int)field > 0)
                {
                    Id = (int)field;
                }
                else
                {
                    Id = -1;
                    result = GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }


        

        public GlobalErrors InsertAddedStepMenusToSGPrivilege(List<int> menuIds, int securityGroupId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder values = new StringBuilder();

                foreach (int menuId in menuIds)
                {
                    values.AppendFormat("({0},{1},{2},{3},{4},{5}),",
                       securityGroupId, //0
                       WebApplication.Sonic.GetHashCode(), //1
                       menuId, //2
                       1, //3
                       1, //4
                       1 //5
                       );
                }
                string query = $@"Insert into SecurityGroupPrivilege(SecurityGroupId, ApplicationId, MenuId, AddPermission, EditPermission, DeletePermission)
                values {values.ToString().TrimEnd(',')}";

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetExcelSheetDynamicTemplateListSharedTable(GeneralFilter filter, ref SharedTableResult<ExcelSheetDynamicTemplateModel> ExcelSheetTemplatesListTable)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<ExcelSheetDynamicTemplateModel> dbHelper = null;
            List<ExcelSheetDynamicTemplateModel> excelSheetTemplates = new List<ExcelSheetDynamicTemplateModel>();
            try
            {
                dbHelper = new DBHelper<ExcelSheetDynamicTemplateModel>();

                string searchFilter = string.Empty;
                string itemsWithUpperLimitFilter = string.Empty;
                string itemExtraInfoSelection = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( VendorLanguage.Description LIKE '%{0}%' ))",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By VendorNameCode Asc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string mainQuery = string.Format(@"select DISTINCT ExcelSheetDynamicTemplate.VendorID,ExcelSheetDynamicTemplate.ExcelSheetTypeID,IsNull( VendorLanguage.Description , '--') + '-' + IsNull( Vendor.VendorCode , '--')   as VendorNameCode,
                Case ExcelSheetDynamicTemplate.ExcelSheetTypeId when 1 then '{2}' else '---' end as ExcelSheetType,ExcelSheetDynamicTemplate.ParentLevelID,ExcelSheetDynamicTemplate.SSCCLevelID
                from  ExcelSheetDynamicTemplate
                inner join Vendor on Vendor.VendorID= ExcelSheetDynamicTemplate.vendorId
                inner join VendorLanguage on VendorLanguage.VendorID= ExcelSheetDynamicTemplate.vendorId and Vendor.VendorID= VendorLanguage.VendorID and VendorLanguage.LanguageID = {0}
                {1}",
                 _requestRepository.LanguageId, //0
                 searchFilter, //1
                 ResourcesManager.TranslateKey(MessagesConstants.Desc_Input_Caption, _requestRepository.LanguageId) //3
                 );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    ExcelSheetTemplatesListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    if (ExcelSheetTemplatesListTable.TotalItems <= 0)
                    {
                        ExcelSheetTemplatesListTable.Data = excelSheetTemplates;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref excelSheetTemplates);
                ExcelSheetTemplatesListTable.Data = excelSheetTemplates;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ExcelSheetTemplatesListTable = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetExcelSheetSharedTable(ExcelSheetDynamicTemplateModel templateObject,bool fromImport, ref List<ExcelSheetDynamicTemplateModel> excelSheetTemplate, DBHelper<ExcelSheetDynamicTemplateModel> dbHelper)// for web by bana
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if(dbHelper == null)
                    dbHelper = new DBHelper<ExcelSheetDynamicTemplateModel>();
                excelSheetTemplate = new List<ExcelSheetDynamicTemplateModel>();
                string excelSheet = string.Empty;
                if (!fromImport)
                {
                    if (templateObject.ParentLevelId == 0 && templateObject.SSCCLevelId == 2)
                    {
                        excelSheet = string.Format("where ColumnID in (1,2,4,5,6,7,8)");
                    }
                    else if (templateObject.ParentLevelId == 0 && templateObject.SSCCLevelId == 1)
                    {
                        excelSheet = string.Format("where ColumnID in (1,2,4,5,6,7)");
                    }
                    else if (templateObject.ParentLevelId == 1 && templateObject.SSCCLevelId == 1)
                    {
                        excelSheet = string.Format("where ColumnID in (1,2,3,4,5,6,7)");
                    }
                }
                if (templateObject.IsEditMode)
                {
                    string query = string.Format(@"select Distinct ExcelSheetColumn.*, 3 ValueType , ExcelSheetDynamicTemplate.DynamicValue,ParentLevelID,SSCCLevelID
                   from ExcelSheetColumn
                   inner join ExcelSheetDynamicTemplate on ExcelSheetColumn.TemplateID = ExcelSheetDynamicTemplate.ExcelSheetTypeID
                   and ExcelSheetDynamicTemplate.DefaultValue = ExcelSheetColumn.DefaultValue and ExcelSheetDynamicTemplate.VendorID = {0}
                   AND ExcelSheetDynamicTemplate.ExcelSheetTypeID = {1}
                   {2}
                   order by ExcelSheetColumn.ColumnID", templateObject.VendorId,templateObject.ExcelSheetTypeId,excelSheet);
                    result = dbHelper.GetQueryList(query, ref excelSheetTemplate);
                }
                else
                {
                    string query = string.Format(@"select Distinct ExcelSheetColumn.*, 3 ValueType, ExcelSheetDynamicTemplate.DynamicValue,ExcelSheetDynamicTemplate.DynamicValue,ParentLevelID,SSCCLevelID
                    from ExcelSheetColumn
                    left join ExcelSheetDynamicTemplate on ExcelSheetColumn.TemplateID = ExcelSheetDynamicTemplate.ExcelSheetTypeID
                    and ExcelSheetDynamicTemplate.DefaultValue = ExcelSheetColumn.DefaultValue and ExcelSheetDynamicTemplate.VendorID = {0}
                    AND ExcelSheetDynamicTemplate.ExcelSheetTypeID = {1}
                    {2}
                    order by ExcelSheetColumn.ColumnID"
                    , templateObject.VendorId,templateObject.ExcelSheetTypeId,excelSheet);
                    result = dbHelper.GetQueryList(query, ref excelSheetTemplate);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertExcelSheetDynamicTemplate(ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Empty;
                string updateQuery = string.Empty;

                deleteQuery = string.Format(@"delete from ExcelSheetDynamicTemplate where VendorID= {0} and ExcelSheetTypeID = {1}", templateObject.VendorId, templateObject.ExcelSheetTypeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = InsertExcelSheetTemplates(templateObject, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors UpdateExcelSheetDynamicTemplate(ExcelSheetDynamicTemplateModel templateObject)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                string deleteQuery = string.Empty;
                string updateQuery = string.Empty;

                deleteQuery = string.Format(@"delete from ExcelSheetDynamicTemplate where VendorID= {0} and ExcelSheetTypeID = {1}",templateObject.VendorId,templateObject.ExcelSheetTypeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(deleteQuery);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = InsertExcelSheetTemplates(templateObject, dbHelper);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors InsertExcelSheetTemplates(ExcelSheetDynamicTemplateModel templateObject, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;

            try
            {
                if (templateObject.ExcelSheetList != null && templateObject.ExcelSheetList.Count > 0)
                {
                    foreach (ExcelSheetDynamicTemplateModel excelSheet in templateObject.ExcelSheetList)
                    {
                        query = string.Format(@"INSERT INTO ExcelSheetDynamicTemplate (VendorID,ExcelSheetTypeID,DefaultValue,DynamicValue,ParentLevelID,SSCCLevelID) VALUES ({0},{1},'{2}','{3}',{4},{5})", templateObject.VendorId, templateObject.ExcelSheetTypeId, excelSheet.DefaultValue, excelSheet.DynamicValue != null ? excelSheet.DynamicValue.Replace("'", "''"):"",templateObject.ParentLevelId,templateObject.SSCCLevelId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) break;
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return GlobalErrors.Error;
                    }
                }
            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetExcelSheetTemplateData(int VendorId,int ExcelSheetTypeId, ref List<ExcelSheetDynamicTemplateModel> excelSheetTemplateObject)
        {
            DBHelper<ExcelSheetDynamicTemplateModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ExcelSheetDynamicTemplateModel>();
                string query = string.Format(@"select * from ExcelSheetDynamicTemplate where VendorID = {0} and ExcelSheetTypeID = {1}", VendorId, ExcelSheetTypeId);
                result = dbHelper.GetQueryList(query, ref excelSheetTemplateObject);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteExcelSheetData(int vendorId,int ExcelSheetTypeId, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                object field = null;
                string query = string.Format(@"delete from ExcelSheetDynamicTemplate where VendorID= {0} and ExcelSheetTypeID = {1} ", vendorId,ExcelSheetTypeId);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected || result== GlobalErrors.Success)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetOperatorLoginFailuresListSharedTable(GeneralFilter filter, ref SharedTableResult<OperatorLoginFailureModel> OperatorListTable)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<OperatorLoginFailureModel> dbHelper = null;
            List<OperatorLoginFailureModel> operatorModel = new List<OperatorLoginFailureModel>();
            try
            {
                dbHelper = new DBHelper<OperatorLoginFailureModel>();

                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( Operator.OperatorName LIKE '%{0}%' ))",
                        filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.OperatorId != -1)
                    {
                        searchFilter += string.Format(" And (Operator.OperatorID = {0}) ", filter.OperatorId);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By OperatorID Asc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string mainQuery = string.Format(@"SELECT DISTINCT Operator.OperatorID,OperatorName, LoginTypeLanguage.Description LoginType, Operator.LoginTypeID,
                CASE IsLocked WHEN 0 THEN '{3}' ELSE '{2}' END IsLocked
                FROM Operator
                INNER JOIN LoginTypeLanguage ON Operator.LoginTypeID = LoginTypeLanguage.LoginTypeID and LoginTypeLanguage.LanguageID = {0}
                INNER JOIN OperatorLoginFailure ON OperatorLoginFailure.OperatorID = Operator.OperatorID
                WHERE Operator.IsLocked = 1 {1}",
                 _requestRepository.LanguageId, //0
                 searchFilter, //1
                 ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId), //2
                 ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId) //3
                 );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    OperatorListTable.TotalItems = int.Parse(objField.ToString().Trim());
                    if (OperatorListTable.TotalItems <= 0)
                    {
                        OperatorListTable.Data = operatorModel;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref operatorModel);
                OperatorListTable.Data = operatorModel;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                OperatorListTable = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOperatorLoginFailuresDetailsSharedTable(OperatorLoginFailureModel OperatorObject, ref List<OperatorLoginFailureModel> operatorModel)// for web by bana
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<OperatorLoginFailureModel> dbHelper = null;
            try
            {

                dbHelper = new DBHelper<OperatorLoginFailureModel>();
                operatorModel = new List<OperatorLoginFailureModel>();
                string query = string.Format(@"SELECT LoginDate, MachineName,CASE IsCleared WHEN 0 THEN '{2}' ELSE '{1}' END IsCleared
                FROM OperatorLoginFailure
                WHERE OperatorLoginFailure.OperatorID = {0} AND IsCleared = 0",
                OperatorObject.OperatorId,
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId), //1
                ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId) //2
                );
                result = dbHelper.GetQueryList(query, ref operatorModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOperatorNames(ref List<OperatorLoginFailureModel> operatorNames)
        {
            DBHelper<OperatorLoginFailureModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<OperatorLoginFailureModel>();
                string sqlString = string.Format(@"select Operator.OperatorID,Operator.OperatorName from Operator");
                result = dbHelper.GetQueryList(sqlString, ref operatorNames);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                operatorNames = null;
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors UnlockOperator(OperatorLoginFailureModel OperatorObject, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<int>();
                string query = string.Format(@"UPDATE OperatorLoginFailure SET IsCleared = 1 WHERE OperatorID = {0}", OperatorObject.OperatorId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                     query = string.Format(@"UPDATE Operator SET IsLocked = 0 , UpdatedBy = {1}, UpdatedDate = {2} WHERE OperatorID = {0}", OperatorObject.OperatorId,_requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                     result = dbHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetNoProductiveReasonList(ref SharedTableResult<NoProductiveReasonModel> noProductiveReasonList)
        {
            noProductiveReasonList = new SharedTableResult<NoProductiveReasonModel>();
            DBHelper<NoProductiveReasonModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<NoProductiveReasonModel> data = new List<NoProductiveReasonModel>();
            try
            {
                dbHelper = new DBHelper<NoProductiveReasonModel>();
                string query = string.Format(@"SELECT * from NonProductiveVisitReasonLanguage where LanguageId = {0}", _requestRepository.LanguageId.GetHashCode());
                result = dbHelper.GetQueryList(query, ref data);
                if (result == GlobalErrors.Success)
                {
                    noProductiveReasonList.Data = data;
                    noProductiveReasonList.TotalItems = data.Count;
                }
                else
                {
                    noProductiveReasonList = null;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                noProductiveReasonList = null;
                return GlobalErrors.Error;
            }
        }
        public int GetMaxId(string columnName, string TableName, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                }
                string query = string.Format("select ISNULL( MAX({0}) , 0)  + 1 From {1}", columnName, TableName);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    return (int)field;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        public GlobalErrors DeleteNoProductiveReasonLanguages(int reasonId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "DELETE FROM NonProductiveVisitReasonLanguage WHERE ReasonId = " + reasonId;
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveNoProductiveReasonLanguage(NoProductiveReasonModel model, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage language in model.DescriptionLanguages)
                {
                    string query = string.Format(@"insert into NonProductiveVisitReasonLanguage (ReasonId,LanguageId,Description) values ({0},{1},'{2}')", model.ReasonId, language.LanguageId, model.DescriptionLanguages[1].Description.Replace("'", "''"));
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return result;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public bool checkIfNoProductiveReasonIsAvailable(NoProductiveReasonModel model)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            try
            {
                dBHelper = new DBHelper<int>();
                string query = string.Format("select count(*) From NonProductiveVisitReasonLanguage where Description = '{0}'",
                    model.DescriptionLanguages.Find(x=>x.LanguageId == _requestRepository.LanguageId).Description);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    return true;
                }
                else
                    return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public GlobalErrors GetComplainTypeList(ref SharedTableResult<ComplainTypeModel> complainTypeList)
        {
            complainTypeList = new SharedTableResult<ComplainTypeModel>();
            DBHelper<ComplainTypeModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ComplainTypeModel> data = new List<ComplainTypeModel>();
            try
            {
                dbHelper = new DBHelper<ComplainTypeModel>();
                string query = string.Format(@"SELECT * from ComplainTypeLanguage where LanguageId = {0}", _requestRepository.LanguageId.GetHashCode());
                result = dbHelper.GetQueryList(query, ref data);
                if (result == GlobalErrors.Success)
                {
                    complainTypeList.Data = data;
                    complainTypeList.TotalItems = data.Count;
                }
                else
                {
                    complainTypeList = null;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                complainTypeList = null;
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors DeleteComplainType(int complainTypeId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = "DELETE FROM ComplainType WHERE ComplainTypeId = " + complainTypeId;
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = "DELETE FROM ComplainTypeLanguage WHERE ComplainTypeId = " + complainTypeId;
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                result = GlobalErrors.Success;
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveComplainType(ComplainTypeModel model, DBHelper<int> dbHelper)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into ComplainType (ComplainTypeId) values ({0})", model.ComplainTypeId);
                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    foreach (TextLanguage language in model.DescriptionLanguages)
                    {
                        query = string.Format(@"insert into ComplainTypeLanguage (ComplainTypeId,LanguageId,Description) values ({0},{1},'{2}')", model.ComplainTypeId, language.LanguageId, model.DescriptionLanguages[1].Description.Replace("'", "''"));
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success) return result;
                    }
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
    }
}