﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;

namespace Sonic.Web.Core.Setup
{
    public class SetupManager
    {

        public static GlobalErrors InsertSystemSettings(string encData)
        {
            var result = GlobalErrors.NotInitialized;
            var query = string.Empty;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();

                query = string.Format(@"Delete From SystemSettings");

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"INSERT INTO SystemSettings (Data , UpdateDate) Values ('{0}' , {1})", encData, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));

                    result = dBHelper.ExecuteNonQuery(query);

                    return result;
                }
                else
                {
                    return GlobalErrors.Error;
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public static GlobalErrors GetSystemSettings(ref string encData)
        {
            var result = GlobalErrors.NotInitialized;
            var query = string.Empty;
            encData = string.Empty;
            DBHelper<string> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<string>();

                object field = new object();
                query = string.Format(@"Select Data From SystemSettings");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString().Trim()))
                {
                    encData = field.ToString().Trim();
                }
                return result;
            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
    }
}
