﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Globalization;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Text;
using Microsoft.AspNetCore.Hosting;
using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;

namespace Sonic.Web.Core.Survey
{
    public class SurveyManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly OrderManager _orderManager;
        public SurveyManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _orderManager = new OrderManager(requestRepository);
        }
        public int GetMaxID(string columnName, string tableName, DBHelper<int> dBHelper)
        {
            try
            {
                if (dBHelper == null)
                    dBHelper = new DBHelper<int>();
                object max = null;
                string query = string.Format(@"select isnull(max({0}),0) from {1} ", columnName, tableName);
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref max);
                if (result == GlobalErrors.Success && max != null && !string.IsNullOrEmpty(max.ToString()))
                {
                    return int.Parse(max.ToString());
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return -1;
            }
            return 1;
        }
        public GlobalErrors SaveSurveyPeriod(int dcfID, int surveyID, SurveyPeriod period, ref String query)
        {
            try
            {
                query += string.Format(@"Insert into SurveyPeriods (SurveyID ,DCFID,FromDate,ToDate) Values ({0},{1},{2},{3}) ", surveyID, dcfID, LocalUtilities.ParseDateAndTimeToSQL(period.FromDateModel.Date)
                    , LocalUtilities.ParseDateAndTimeToSQL(period.ToDateModel.Date.AddSeconds(-1))); 
                return GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors getAllCustomerSurveys(FilterModel filterModel, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string incudeFilter = " and Survey.InActive = 0";
                string nameFilter = "";
                string dateFilter = "";
                if (filterModel != null && filterModel.Active)
                {
                    incudeFilter = "";
                }
                if (filterModel != null && filterModel.SurveyName != null && !filterModel.SurveyName.Equals(""))
                {
                    nameFilter = string.Format(" and SurveyLanguage.Description like '%{0}%'", filterModel.SurveyName.Replace("'", "''"));
                }
                if (filterModel != null && filterModel.ValidTo != null && filterModel.ValidTo.Value != null && filterModel.ValidTo.Value.CompareTo(DateTime.MinValue) > 0)
                {
                    dateFilter = string.Format(" and Survey.ValidTo <= DATEADD( DAY ,1,{0})", LocalUtilities.ParseEndDateToSQLString(filterModel.ValidTo.Value));
                }
                DBHelper<SurveyModel> dBHelper = new DBHelper<SurveyModel>();
                string query = string.Format(@" select distinct Survey.*,SurveyLanguage.Description SurveyName,SurveyLanguage.LetterHead,OrganizationLanguage.Description OrganizationName,
                Case Survey.OrganizationID when -1 then '{6}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName,
                Case isNull(Promotion.SurveyID,0) when 0 then 0 else 1 end as AssignedToPromotion,
                Case When Promotion.StartDate <= {7} and isNull(Promotion.SurveyID,0) > 0 then 1 else 0 end as StartedPromotion
                from Survey 
                LEFT OUTER JOIN SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID = {1}
                LEFT OUTER JOIN Organization on Organization.OrganizationID = Survey.OrganizationID    
                LEFT OUTER JOIN OrganizationLanguage on OrganizationLanguage.OrganizationID = Survey.OrganizationID and OrganizationLanguage.LanguageID = {1}
                LEFT OUTER JOIN SurveyOrganization On SurveyOrganization.SurveyID = Survey.SurveyID
                LEFT OUTER JOIN Promotion on Promotion.SurveyID = Survey.SurveyID and Promotion.IsDeleted <> 1 
                where SurveyTypeID = {5} and (Survey.OrganizationID in ({4}) or SurveyOrganization.OrganizationID IN ({4})) {0} {2} {3} ",
                incudeFilter, //0
                _requestRepository.LanguageId, //1
                nameFilter,//2
                dateFilter,//3
                _requestRepository.CurrentOperator.OrganizationAccess,//4
                filterModel.SurveyTypeId,//5
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organizations, _requestRepository.LanguageId), //6
                LocalUtilities.ParseDateToSQLString(DateTime.Now) //7
                );
                //and ValidFrom <= {0} and ValidTo >= {0}
                result = dBHelper.GetQueryList(query, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetSurveyHeaderLanguages(int surveyId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select SurveyLanguage.LanguageID,SurveyLanguage.LetterHead Description from SurveyLanguage where surveyId = {0}", surveyId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetSurveyLanguages(int surveyId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"Select * from SurveyLanguage where surveyId = {0}", surveyId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetSurveyLetterHeadLanguages(int surveyId, ref List<TextLanguage> letterHeadDescription)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"Select languageID, LetterHead as Description from SurveyLanguage where surveyId = {0}", surveyId);
                result = dBHelper.GetQueryList(query, ref letterHeadDescription);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
      
        public GlobalErrors GetAllFieldGroup(ref List<SurveyTemplateModel> fieldGroups, DBHelper<SurveyTemplateModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Select FieldGroup.GroupId Id,FieldGroupLanguage.Description Name from FieldGroup inner join FieldGroupLanguage on  FieldGroup.GroupID = FieldGroupLanguage.GroupID where LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref fieldGroups);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors AllowDeleteQuestion(int fieldId, int surveyTypeId, ref bool isFieldHasAnswers, DBHelper<int> dBHelper)
        {

            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            string query = string.Empty;
            try
            {
                if (surveyTypeId != SurveyTypes.QualityControl.GetHashCode())
                {
                    // 1
                    query = string.Format("Select Count(*) From FieldValueBindable Where FieldID = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 2
                    query = string.Format("Select Count(*) From FieldValueBit Where FieldID = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 3
                    query = string.Format("Select Count(*) From FieldValueCheckList Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 4
                    query = string.Format("Select Count(*) From FieldValueDate Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 5
                    query = string.Format("Select Count(*) From FieldValueFlo Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 6
                    query = string.Format("Select Count(*) From FieldValueImages Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 7
                    query = string.Format("Select Count(*) From FieldValueInt Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 8
                    query = string.Format("Select Count(*) From FieldValueLOV Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 9
                    query = string.Format("Select Count(*) From FieldValueMatrix Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }

                    // 10
                    query = string.Format("Select Count(*) From FieldValueString Where fieldId = {0} ", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }
                }
                else
                {
                    query = string.Format("Select Count(*) From QualityControlReadingDetails Where fieldId = {0} and fieldvalue is not null and fieldvalue <> ''", fieldId);
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                    {
                        isFieldHasAnswers = true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteSurvey(int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from surveyGroup where surveyId = {0}", surveyId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SurveySecurityGroupAssignment where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SurveyOrganization where SurveyID = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from surveycustomer where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from surveyEmployee where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from surveychannel where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from surveylanguage where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SurveyPOS where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from survey where surveyId = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = DeleteSurveyPeriodTypes(surveyId, dBHelper);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteQuestions(int fieldId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from FieldLanguage where FieldID  ={0} ", fieldId);
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"Delete from Field where FieldID = {0} ", fieldId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public bool CheckIfSurveyUsed(int surveyId,int dcfId,int surveyTypeId, bool isLinkedToPromotion, DBHelper<int> dBHelper)
        {
            bool isUsed = false;
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = string.Empty;
            try
            {
                if(surveyTypeId == SurveyTypes.QualityControl.GetHashCode())
                {
                    query = string.Format("SELECT COUNT(*) FROM QualityControlReading WHERE surveyid = {0}", surveyId);
                }
                else
                {
                    if (isLinkedToPromotion)
                    {
                        query = string.Format("SELECT COUNT(*) FROM Promotion WHERE SurveyID = {0} and Promotion.IsDeleted <> 1 ", surveyId);
                    }
                    else
                    {
                        query = string.Format("SELECT COUNT(*) FROM Reading WHERE DCFID = {0}", dcfId);
                    }
                }
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    isUsed = true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return isUsed;
        }
        public GlobalErrors GetQuestionsDepend(int surveyId, int fieldId, ref List<SurveyTemplateModel> questionDependList, DBHelper<SurveyTemplateModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Select FL.Name , Field.FieldID , LOVID , FieldTypeID , GroupID
                from Field
                Inner Join FieldLanguage FL on FL.FieldID = Field.FieldID and LanguageID = {0}
                Where DCFID = {1}   AND  FieldTypeID in (4,5) AND Field.FieldID < {2}", _requestRepository.LanguageId, surveyId, fieldId);
                result = dBHelper.GetQueryList(query, ref questionDependList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetLOVOptions(int LOVID, ref List<LOVModel> answerDependList)
        {
            DBHelper<LOVModel> dBHelper = new DBHelper<LOVModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            string LOVFilter = string.Empty;
            try
            {
                if (LOVID > -1)
                {
                    LOVFilter = string.Format(@" Where LOVID = {0}", LOVID);
                }
                string query = string.Format(@"Select LOVOption.LOVOptionID  , LOVOptionLanguage.Description LOVOptionName,LOVOPtion.LOVID LOVID
                from LOVOption 
                inner join LOVOptionLanguage on LOVOptionLanguage.LOVOptionID =  LOVOption.LOVOptionID And LanguageID = {0}
                {1}", _requestRepository.LanguageId, LOVFilter);
                result = dBHelper.GetQueryList(query, ref answerDependList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateDCFLanguage(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage lang in survey.SurveyNameDescriptionLanguages)
                {
                    string query = string.Format(@"update DCFLanguage set Description = '{1}' where DCFID={0} and LanguageID = {2} ", survey.DCFID, lang.Description.Replace("'", "''"), lang.LanguageId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveytoSecurityGroup(int surveyId, int securityGroupId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveySecurityGroupAssignment (SurveyID, SecurityGroupId) values ({0},{1})", surveyId, securityGroupId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveytoEmployee(int surveyId, int employeeId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyEmployee (SurveyID, EmployeeID) values ({0},{1})", surveyId, employeeId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ApplySurveytoDisplayUnit(int displayUnitId, int SurveyID, int TypeID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string MaxDisplayUnitSurvey = string.Format(@"(select ISNULL(MAX(SurveyPOSID), 0)+1 from SurveyPOS)");

                string query = string.Format(@"insert 
                                                into SurveyPOS (SurveyPOSID, SurveyID, POSID, POSTypeID) 
                                                VALUES  ({0}, {1}, {2}, {3})",
                            MaxDisplayUnitSurvey, //0
                            SurveyID, //1
                            displayUnitId, //2
                            TypeID //3
                            );
                    result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteApplySurveytoDisplayUnit(int SurveyID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Format(@"DELETE FROM  surveyPOS WHERE SurveyID = {0}", SurveyID );
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveyToInspectors(int surveyId, int inspectorId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyInspectors (SurveyID, InspectorId) values ({0},{1})", surveyId, inspectorId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveyToWarehouses(int surveyId, int warehouseId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyWarehouses (SurveyID, WarehouseId) values ({0},{1})", surveyId, warehouseId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveyToVehicles(int surveyId, int vehicleId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyVehicles (SurveyID, VehicleId) values ({0},{1})", surveyId, vehicleId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveyToDamagedWarehouse(int surveyId, int damagedWarehouseId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyDamagedWarehouses (SurveyID, DamagedWarehouseID) values ({0},{1})", surveyId, damagedWarehouseId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveyToItems(int surveyId, int itemId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into SurveyItems (SurveyID, ItemID) values ({0},{1})", surveyId, itemId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors saveGroup(string group)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                string query = string.Format(@"insert into FieldGroup values((select ISNULL(max(GroupId)+1,1) from  FieldGroup))");
                result = dBHelper.ExecuteNonQuery(query);

                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"insert into FieldGroupLanguage values((select ISNULL(max(GroupId),1) from  FieldGroup),{0},'{1}')"
                    , 1, group.Replace("'", "''"));
                    result = dBHelper.ExecuteNonQuery(query);
                }
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@"insert into FieldGroupLanguage values((select ISNULL(max(GroupId),1) from  FieldGroup),{0},'{1}')"
                    , 2, group.Replace("'", "''"));
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAppliedCustomers(int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    StringBuilder orgAccessJoin = new StringBuilder();    
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));    
                    query = $@" DELETE SC FROM SurveyCustomer SC 
                                           inner join CustomerOutlet CO on CO.CustomerID = SC.CustomerID and CO.OutletID = SC.OutletID
                                           { orgAccessJoin }
                                           WHERE SC.SurveyID = {surveyId} ";
                }
                else
                {
                    query = string.Format(@"Delete from SurveyCustomer where SurveyID={0}", surveyId);
                }

                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    if(_requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups)
                    {
                        query = $@" DELETE SG FROM SurveyGroup SG                               
                                           inner join CustomerGroup CG  on CG.GroupID = SG.GroupID and CG.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess})
                                           WHERE SG.SurveyID = {surveyId} ";
                    }
                    else
                    {
                        query = string.Format(@"Delete from SurveyGroup where surveyID={0}", surveyId);
                    }
                    
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SurveyChannel where SurveyID = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete SurveySecurityGroupAssignment from SurveySecurityGroupAssignment
                    Inner Join SecurityGroup on SurveySecurityGroupAssignment.SecurityGroupID = SecurityGroup.SecurityGroupID
                    where SurveyID = {0} and SecurityGroup.OrganizationID in ({1}) ", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteAppliedEmployees(int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete SurveyEmployee from SurveyEmployee
                Inner Join Employee on Employee.EmployeeID = SurveyEmployee.EmployeeID
                where SurveyID={0} and Employee.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete SurveySecurityGroupAssignment from SurveySecurityGroupAssignment
                    Inner Join SecurityGroup on SurveySecurityGroupAssignment.SecurityGroupID = SecurityGroup.SecurityGroupID
                    where SurveyID = {0} and SecurityGroup.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteQualityControlAppliedData(int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete SurveyInspectors from SurveyInspectors
                Inner Join Employee on Employee.EmployeeID = SurveyInspectors.InspectorID 
                where SurveyID={0} and Employee.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"Delete SurveyWarehouses from SurveyWarehouses
                    Inner Join Warehouse on Warehouse.WarehouseID = SurveyWarehouses.WarehouseID 
                    where surveyID={0} and Warehouse.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete  SurveyVehicles from SurveyVehicles
                    Inner Join Warehouse on Warehouse.WarehouseID = SurveyVehicles.VehicleID  
                    where SurveyID = {0} and Warehouse.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete SurveyDamagedWarehouses from SurveyDamagedWarehouses
                    Inner Join Warehouse on Warehouse.WarehouseID = SurveyDamagedWarehouses.DamagedWarehouseID   
                    where SurveyID = {0} and Warehouse.OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from SurveyItems where SurveyID = {0}", surveyId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateSurveyLanguage(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage lang in survey.SurveyNameDescriptionLanguages)
                {
                    string query = string.Format(@"update SurveyLanguage set Description = '{0}' , LetterHead='{0}' where SurveyID = {1} and languageid = {2}", lang.Description.Replace("'", "''"), survey.SurveyId, lang.LanguageId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateSurvey(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"update Survey set InActive={0}, ValidFrom={1} ,ValidTo={2}, NumberOfQuestions={3}, TimeToFill={4},ForceFillingMode={5},ApplyForNewCustomers={7},OrganizationID = {8},AllSecurityGroups = {9}, SurveyPeriodTypeID = {10}, Points = {11}, AllCustomers = {12}, AllOrganizationEmployees={13}, IsMainMenu={14}, ImageID='{15}', LinkedToProm={16}, UpdateDate={17},UpdateBy={18} , SurveySequence = {19} , RouteHistoryStatusId = {20} where SurveyID = {6}",
                    Convert.ToInt16(survey.InActive), LocalUtilities.ParseDateAndTimeToSQL(survey.ValidFromModel.Date), LocalUtilities.ParseDateAndTimeToSQL(survey.ValidToModel.Date), survey.NumberOfQuestions, survey.TimeToFill, survey.ForceFillingMode, survey.SurveyId, Convert.ToInt16(survey.ApplyForNewCustomers), survey.OrganizationID, Convert.ToInt16(survey.AllSecurityGroups), survey.SurveyPeriodTypeId, survey.Points, survey.AllCustomers ? 1 : 0, survey.AllOrganizationEmployees ? 1 : 0, survey.IsMainMenu ? 1 : 0, survey.ImageId, survey.LinkedToProm ? 1 : 0,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    _requestRepository.CurrentOperator.EmployeeId , survey.SurveySequence , survey.RouteHistoryStatusId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertUpdateQuestion(int DCFID, QuestionModel question, DBHelper<int> dBHelper, Dictionary<int, int> NewFieldIDs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            int fieldID = -1;
            object field = null;
            try
            {
                string query = "";
                if (question.FieldId > 0)
                {
                    query = string.Format(@"UPDATE Field
                                                   SET [DCFID] = {0}
                                                      ,[FieldTypeID] = {1}
                                                      ,[FieldSubTypeID] = {2}
                                                      ,[LOVID] = {3}
                                                      ,[IsMatrix] = {4}
                                                      ,[XLOVID] = {5}
                                                      ,[YLOVID] = {6}
                                                      ,[GroupID] = {7}
                                                      ,[DependentQuestion] = {8}
                                                      ,[DependentAnswer] = {9}
                                                      ,[IsMandatory] = {10}
                                                      ,[Sequence] = {13}
                                                      ,[PhotoRequired]={14}
                                                      ,[YesScore]={15}
                                                      ,[NumberOfAttachments]={16}
                                                      ,[AfterNumberOfDays]={17}
                                                      ,[IsBarcode]={18}
                                                 WHERE FieldID = {11}",
                   DCFID, question.FieldTypeID, question.FieldSubTypeID, question.LOVID > 0 ? question.LOVID.ToString() : "null", question.IsMatrix ? 1 : 0
                   , question.XLOVID, question.YLOVID, question.FieldGroupId, question.DependentQuestion, question.DependentAnswer, question.IsMandatory ? 1 : 0, question.FieldId, "", question.Sequence, question.PhotoRequired ? 1 : 0, question.YesScore,
                   question.NumberOfAttachments, // 16
                   question.AfterNumberOfDays, //17
                   question.IsBarcode ? 1 : 0 //18
                   );
                    result = dBHelper.ExecuteNonQuery(query);

                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format("Delete from FieldLanguage where FieldID = {0}", question.FieldId);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (question.QuestionNameDescriptionLanguages != null)
                        {
                            List<int> languagesList = question.QuestionNameDescriptionLanguages.Select(x => x.LanguageId).Distinct().ToList();
                            if (languagesList != null && languagesList.Count > 0)
                            {
                                foreach (int langId in languagesList)
                                {
                                    string questionName = question.QuestionName;
                                    string questionBody = question.QuestionBody;

                                    if (question.QuestionNameDescriptionLanguages.Any(x => x.LanguageId == langId))
                                    {
                                        questionName = question.QuestionNameDescriptionLanguages.First(x => x.LanguageId == langId).Description;
                                        if (questionName == null || string.IsNullOrEmpty(questionName.Trim()))
                                        {
                                            questionName = question.QuestionName;
                                        }
                                    }
                                    

                                    if (question.QuestionBodyDescriptionLanguages.Any(x => x.LanguageId == langId))
                                    {
                                        questionBody = question.QuestionBodyDescriptionLanguages.First(x => x.LanguageId == langId).Description;
                                        if (questionBody == null || string.IsNullOrEmpty(questionBody.Trim()))
                                        {
                                            questionBody = question.QuestionBody;
                                        }
                                    }

                                    query = string.Format(@"Insert Into FieldLanguage(FieldID, LanguageID, name, Description) 
                                        Values({0},{1}, '{2}','{3}')",
                                        question.FieldId, langId, questionName.Replace("'", "''"), questionBody.Replace("'", "''"));
                                    result = dBHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success) break;
                                }
                            }
                        }
                    }
                }
                else
                {
                    int dependentQuestion = -1;
                    if ( NewFieldIDs != null && NewFieldIDs.Count > 0 && NewFieldIDs.ContainsKey(question.DependentQuestion) )
                    {
                        dependentQuestion = NewFieldIDs[question.DependentQuestion];
                    } 
                    else 
                    {
                        dependentQuestion = question.DependentQuestion;
                    }
                    query = string.Format(@" INSERT INTO Field
                                               ([DCFID]
                                               ,[FieldTypeID]
                                               ,[FieldSubTypeID]
                                               ,[LOVID]
                                               ,[DataBindID]
                                               ,[IsMatrix]
                                               ,[XLOVID]
                                               ,[YLOVID]
                                               ,[GroupID]
                                               ,[DependentQuestion]
                                               ,[DependentAnswer]
                                               ,[IsMandatory]
                                               ,[Sequence]
                                               ,[PhotoRequired]
                                               ,[YesScore]
                                               ,[NumberOfAttachments]
                                               ,[AfterNumberOfDays]
                                               ,[IsBarcode])
                                         VALUES
                                               ({0},
		                                       {1},
		                                       {2},
		                                       {3},
		                                       {4},
		                                       {5},
		                                       {6},
		                                       {7},
		                                       {8},
		                                       {9},
		                                       {10},
		                                       {11},
                                               {12},
                                               {13},
                                               {14},
                                               {15},
                                               {16},
                                               {17})", DCFID, question.FieldTypeID, question.FieldSubTypeID, question.LOVID > 0 ? question.LOVID.ToString() : "null", -1, question.IsMatrix ? 1 : 0
                                                                 , question.XLOVID, question.YLOVID, question.FieldGroupId, dependentQuestion, question.DependentAnswer, question.IsMandatory ? 1 : 0, question.Sequence, question.PhotoRequired ? 1 : 0, question.YesScore,
                                                                 question.NumberOfAttachments, question.AfterNumberOfDays , question.IsBarcode ? 1 : 0);

                    result = dBHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        if (question.QuestionNameDescriptionLanguages != null)
                        {
                            foreach (var lang in question.QuestionNameDescriptionLanguages)
                            {
                                if (lang.Description != null && lang.Description.Trim() != string.Empty)
                                {
                                    query = string.Format(@"INSERT INTO FieldLanguage
                                                   ([FieldID]
                                                   ,[LanguageID]
                                                   ,[Name]
                                                   ,[Description])
                                             VALUES
                                                  ((select Max(FieldId) from Field),{0},'{1}','{2}')", lang.LanguageId, lang.Description.Replace("'", "''"), question.QuestionBody.Replace("'", "''"));
                                    result = dBHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success) break;
                                }
                            }
                        }
                    }
                    if (result == GlobalErrors.Success)
                    {
                        fieldID = -1;
                        field = null;
                        query = " Select Max(FieldId) from Field";
                        result = dBHelper.ExecuteScalar(query, ref field);
                        if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                        {
                            fieldID = int.Parse(field.ToString());
                        }
                        if (!NewFieldIDs.ContainsKey(question.FieldId))
                        {
                            NewFieldIDs.Add(question.FieldId, fieldID);
                        }
                    }
                }

                fieldID = -1;
                field = null;
                if (question.FieldId > -1)
                {
                    fieldID = question.FieldId;
                }
                else
                {
                    query = " Select Max(FieldId) from Field";
                    result = dBHelper.ExecuteScalar(query, ref field);
                    if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                    {
                        fieldID = int.Parse(field.ToString());
                    }
                }
                query = string.Format(@" Delete from FieldActions where SurveyID = {0} and FieldID = {1}", question.SurveyId, fieldID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                    if (question.ActionTypeId != null && question.ActionTypeId.Count > 0)
                    {
                        string actionTypes = string.Empty;
                        foreach (SurveyActionsTypesModel action in question.ActionTypeId)
                        {
                            actionTypes = actionTypes + action.actionTypeId + ',';
                        }
                        if (!string.IsNullOrEmpty(actionTypes))
                        {
                            actionTypes = actionTypes.TrimEnd(',');
                        }
                        query = string.Format(@" INSERT INTO FieldActions
                         ([SurveyID], [FieldID], [FieldTypeID], [ActionTypeID], [MinValue], [MaxValue], [YesNo], [LOVID], [LOVOptionID], [MinDate], [MaxDate] )
                         VALUES ({0}, {1}, {2}, '{3}', {4}, {5}, {6}, {7}, {8}, {9}, {10})",
                                question.SurveyId, //0
                                fieldID, //1
                                question.FieldTypeID, //2
                                actionTypes, //3
                                question.MinValue, //4
                                question.MaxValue, //5
                                question.YesNo ? 1 : 0, //6
                                question.LOVID > -1 ? question.LOVID : -1, //7
                                question.LOVOptionID > -1 ? question.LOVOptionID : -1, //8
                                (question.MinDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(question.MinDateModel.Date) : "null"), //9
                                (question.MaxDateModel != null ? LocalUtilities.ParseDateAndTimeToSQL(question.MaxDateModel.Date) : "null") //10
                                );
                        result = dBHelper.ExecuteNonQuery(query);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getAppliedList(int surveyId, ref List<CreditReleaseAssignmentModel> applyTo, ref List<SecurityGroupModel> securityGroups)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                List<CreditReleaseAssignmentModel> groups = new List<CreditReleaseAssignmentModel>();
                DBHelper<CreditReleaseAssignmentModel> dBHelper = new DBHelper<CreditReleaseAssignmentModel>();
                string organizationIdSelection = string.Empty;
                //groups


                string customerGroupOrgAccess = _requestRepository.Configurations.ForceOrganizationFilterForCustomerGroups ? $" and CustomerGroup.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) " : string.Empty;
                string sqlQuerey = string.Format(@"select SurveyGroup.GroupID, CustomerGroupLanguage.Description groupName 
                                                   from SurveyGroup 
                                                   inner join CustomerGroup on CustomerGroup.GroupID = SurveyGroup.GroupID {2}
                                                   left join CustomerGroupLanguage on SurveyGroup.GroupID=CustomerGroupLanguage.GroupID 
                                                   and CustomerGroupLanguage.LanguageID = {0}
                                                   where  SurveyGroup.SurveyID = {1}",
                   _requestRepository.LanguageId, surveyId, customerGroupOrgAccess);
                result = dBHelper.GetQueryList(sqlQuerey, ref groups);
                if (result == GlobalErrors.Success && groups != null && groups.Count > 0)
                {
                    applyTo.AddRange(groups);
                }

                //Customer And Outlets
                if (result == GlobalErrors.Success)
                {
                    StringBuilder orgAccessJoin = new StringBuilder();
                    if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        if(_requestRepository.Configurations.ForceOrganizationSelectionOnLogin)
                        {
                            organizationIdSelection = " ,CustomerOutlet.OrganizationId ";
                        }
                        else
                        {
                            organizationIdSelection = " ,Account.OrganizationId ";
                        }
                        orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                    }
                    List<CreditReleaseAssignmentModel> customerOutlet = new List<CreditReleaseAssignmentModel>();
                    sqlQuerey = string.Format(@"select distinct SurveyCustomer.CustomerID,SurveyCustomer.OutletID,
CONCAT(CustomerLanguage.Description, ' - ', CustomerOutletLanguage.Description) customerOutletName ,
CustomerLanguage.Description as CustomerName ,IsNull(Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName ,
IsNull(CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName {3}
from SurveyCustomer
inner join Customer on Customer.CustomerID=SurveyCustomer.CustomerID
inner join CustomerOutlet on CustomerOutlet.CustomerID=SurveyCustomer.CustomerID and CustomerOutlet.OutletID=SurveyCustomer.OutletID {2}
                                            inner join CustomerLanguage ON SurveyCustomer.CustomerID= CustomerLanguage.CustomerID
                                            INNER JOIN CustomerOutletLanguage ON SurveyCustomer.CustomerID = CustomerOutletLanguage.CustomerID AND  SurveyCustomer.OutletID = CustomerOutletLanguage.OutletID 
                                            where CustomerOutletLanguage.LanguageID = {0} and CustomerLanguage.LanguageID={0} and SurveyCustomer.SurveyID = {1}",
                        _requestRepository.LanguageId, surveyId, orgAccessJoin, organizationIdSelection);
                    result = dBHelper.GetQueryList(sqlQuerey, ref customerOutlet);
                    if (result == GlobalErrors.Success && customerOutlet != null && customerOutlet.Count > 0 && _requestRepository.Configurations.ForceCustomerOrganizationSelection)
                    {
                        customerOutlet = FillCustomerOrganizationIdsAsList(customerOutlet,true,false);
                        applyTo.AddRange(customerOutlet);
                    }
                }

                //Channel
                if (result == GlobalErrors.Success)
                {
                    List<CreditReleaseAssignmentModel> channel = new List<CreditReleaseAssignmentModel>();
                    sqlQuerey = string.Format(@"SELECT SurveyChannel.ChannelID, SurveyChannel.SubChannelID,
                                             (CONVERT(varchar(10), SurveyChannel.ChannelID) + '-' + CONVERT(varchar(10), SurveyChannel.SubChannelID)) ChannelSubChannelIds ,
                                             (ChannelLanguage.Description + '-' + SubChannelLanguage.Description) ChannelSubChannelDescriptions,
                                            ChannelLanguage.Description channelName,
                                            SubChannelLanguage.Description SubChannelName FROM SurveyChannel   
                                            INNER JOIN ChannelLanguage ON SurveyChannel.ChannelID = ChannelLanguage.ChannelID
                                            INNER JOIN SubChannelLanguage ON  SurveyChannel.SubChannelID = SubChannelLanguage.SubChannelID
                                            WHERE SubChannelLanguage.LanguageID = {0} AND ChannelLanguage.LanguageID = {0} AND SurveyChannel.SurveyID = {1}",
                        _requestRepository.LanguageId, surveyId);
                    result = dBHelper.GetQueryList(sqlQuerey, ref channel);
                    if (result == GlobalErrors.Success && channel != null && channel.Count > 0)
                    {
                        applyTo.AddRange(channel);
                    }
                }

                //Security Groups
                if (result == GlobalErrors.Success)
                {
                    List<SecurityGroupModel> SecurityGroups = new List<SecurityGroupModel>();
                    DBHelper<SecurityGroupModel> dBHelper1 = new DBHelper<SecurityGroupModel>();
                    sqlQuerey = string.Format(@"select SecurityGroupLanguage.SecurityGroupId,SecurityGroupLanguage.Description SecurityGroupName from SurveySecurityGroupAssignment 
                                                Inner Join SecurityGroup on SecurityGroup.SecurityGroupId = SurveySecurityGroupAssignment.SecurityGroupId
                                                Left join SecurityGroupLanguage on SurveySecurityGroupAssignment.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0}
                                                where SurveySecurityGroupAssignment.SurveyID = {1} and SecurityGroup.OrganizationID in ({2}) ",
                        _requestRepository.LanguageId, surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper1.GetQueryList(sqlQuerey, ref SecurityGroups);
                    if (result == GlobalErrors.Success)
                    {
                        securityGroups = SecurityGroups;
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getEmployeesAppliedList(int surveyId, ref List<EmployeeModel> AppliedEmployees, ref List<SecurityGroupModel> securityGroups)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                AppliedEmployees = new List<EmployeeModel>();
                securityGroups = new List<SecurityGroupModel>();
                DBHelper<EmployeeModel> dBHelper = new DBHelper<EmployeeModel>();
                // Inspectors
                string sqlQuery = string.Format(@"select SurveyEmployee.EmployeeID as EmployeeID, IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName
                from SurveyEmployee
                Inner join Employee on Employee.EmployeeID = SurveyEmployee.EmployeeID
                inner join EmployeeLanguage on SurveyEmployee.EmployeeID=EmployeeLanguage.EmployeeID 
                where EmployeeLanguage.LanguageID = {0} and SurveyEmployee.SurveyID={1} and Employee.OrganizationID in ({2})",
                _requestRepository.LanguageId, surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.GetQueryList(sqlQuery, ref AppliedEmployees);

                //Security Groups
                if (result == GlobalErrors.Success)
                {
                    List<SecurityGroupModel> SecurityGroups = new List<SecurityGroupModel>();
                    DBHelper<SecurityGroupModel> dBHelper1 = new DBHelper<SecurityGroupModel>();
                    sqlQuery = string.Format(@"select SecurityGroupLanguage.SecurityGroupId,SecurityGroupLanguage.Description SecurityGroupName from SurveySecurityGroupAssignment 
                                                Inner Join SecurityGroup on SecurityGroup.SecurityGroupId = SurveySecurityGroupAssignment.SecurityGroupId
                                                Left join SecurityGroupLanguage on SurveySecurityGroupAssignment.SecurityGroupID = SecurityGroupLanguage.SecurityGroupID and SecurityGroupLanguage.LanguageID = {0}
                                                where SurveySecurityGroupAssignment.SurveyID = {1} and SecurityGroup.OrganizationID in ({2})",
                        _requestRepository.LanguageId, surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                    result = dBHelper1.GetQueryList(sqlQuery, ref SecurityGroups);
                    if (result == GlobalErrors.Success)
                    {
                        securityGroups = SecurityGroups;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getSurveyQuestions(int dcfId, ref List<QuestionModel> questions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<QuestionModel> dBHelper = new DBHelper<QuestionModel>();
                List<LOVModel> lovOptions = new List<LOVModel>();
                string query = string.Format(@"select Field.GroupId FieldGroupId,Field.*,FieldSubTypeLanguage.Description QuestionTypeName,FieldLanguage.Description QuestionBody ,FieldLanguage.Name QuestionName, FieldActions.ActionTypeID as ActionTypeIdString,FieldActions.MinValue,
                FieldActions.MaxValue, FieldActions.YesNO, FieldActions.LOVID, FieldActions.LOVOptionID,FieldActions.MinDate, FieldActions.MaxDate, lov.DynamicField
                from Field 
                left join FieldActions on FieldActions.FieldID = Field.FieldID
                left join FieldSubTypeLanguage on FieldSubTypeLanguage.FieldTypeID = Field.FieldTypeID and Field.FieldSubTypeID = FieldSubTypeLanguage.FieldSubTypeID and LanguageID = {1}  
				left join FieldLanguage  on Field.FieldID = FieldLanguage.FieldID and FieldLanguage.LanguageID = {1}
                left join lov on lov.LOVID = field.LOVID
                where DCFID = {0} order by Field.GroupId, Sequence"
                , dcfId, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref questions);

                if (result == GlobalErrors.Success)
                {
                    foreach (QuestionModel questionModel in questions)
                    {
                        if (questionModel.LOVID > -1)
                        {
                            lovOptions = new List<LOVModel>();
                            result = GetLOVOptions(questionModel.LOVID, ref lovOptions);
                            if (result == GlobalErrors.Success && lovOptions != null && lovOptions.Count > 0)
                            {
                                questionModel.QuestionOptions = lovOptions;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyItems(int surveyID, int warehouseID, int readingID, ref List<ItemPackModel> appliedItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
                string query = string.Format(@"select distinct Item.ItemID, Item.ItemCode + ' - ' + ItemLanguage.Description as ItemCodeName, ItemCategory.DivisionID
                from WarehouseStock
                Inner join Pack on Pack.PackID = WarehouseStock.PackID
                Inner join Item on Pack.ItemID = Item.ItemID
                INNER JOIN ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                inner join Division on Division.DivisionID=ItemCategory.DivisionID
                Inner join ItemLanguage on Item.ItemID = ItemLanguage.ItemID and ItemLanguage.LanguageID = {0}
                inner join SurveyItems on(Item.ItemID = SurveyItems.ItemID or SurveyItems.ItemID = -1)
                left join (
                select value itemid,QCR.* from QualityControlReading QCR cross apply string_split(filleditems,',')  where ((QCR.WarehouseID ={2}) 
                or (QCR.VehicleID = {2}) or (QCR.DamagedWarehouseID = {2}))
                and QCR.IsCompletelyFilled <> 1 and QCR.ValidTo >=    {3} 
                ) QCR on 
                SurveyItems.SurveyID = QCR.SurveyID and qcr.ItemID = item.ItemID

                where SurveyItems.SurveyID= {1} and WarehouseStock.WarehouseID = {2}
                and (WarehouseStock.IsReserved is null or WarehouseStock.IsReserved <> 1) 
                and qcr.itemid is  null
                --and (QCR.surveyID is null or (QCR.SurveyID is not null and qcr.itemid is  null))
                group by Item.ItemID, Item.ItemCode, ItemLanguage.Description, ItemCategory.DivisionID
                having sum(WarehouseStock.Quantity) > 0", _requestRepository.LanguageId, surveyID, warehouseID, LocalUtilities.ParseDateToSQLString(DateTime.Now));

                result = dBHelper.GetQueryList(query, ref appliedItems);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetAddedItemsData(string addedItemsString, ref List<ItemPackModel> addedItems)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<ItemPackModel> dBHelper = new DBHelper<ItemPackModel>();
                string query = string.Format(@"select distinct Item.ItemID, Item.ItemCode + ' - ' + ItemLanguage.Description as ItemCodeName
                from Item
                inner join ItemCategory ON ItemCategory.ItemCategoryID = Item.ItemCategoryID 
                inner join Division on Division.DivisionID=ItemCategory.DivisionID
                inner join ItemLanguage on Item.ItemID=ItemLanguage.ItemID and ItemLanguage.LanguageID = {0}
                where Item.ItemID in ({1})", _requestRepository.LanguageId, addedItemsString);
                result = dBHelper.GetQueryList(query, ref addedItems);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyReadingDetails(int surveyID, int readingID, ref SurveyReadingModel surveyReadingModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SurveyReadingModel> dBHelper = new DBHelper<SurveyReadingModel>();
                DBHelper<SurveyReadingDetailsModel> dbHelper = new DBHelper<SurveyReadingDetailsModel>();
                List<SurveyReadingDetailsModel> fieldsAnswers = new List<SurveyReadingDetailsModel>();
                string query = string.Format(@"select * from QualityControlReading QCR
                where QCR.SurveyID = {0} and QCR.ReadingID = {1}", surveyID, readingID);
                result = dBHelper.GetQuerySingle(query, ref surveyReadingModel);
                if (result == GlobalErrors.Success && surveyReadingModel != null)
                {
                    fieldsAnswers = new List<SurveyReadingDetailsModel>();
                    query = string.Format(@"select distinct QCRD.ReadingID, QCRD.SurveyID, QCRD.FieldID, QCRD.FieldTypeID,
                    QCRD.LOVID,QCRD.FieldValue, ReadingDate from QualityControlReadingDetails QCRD
                    where QCRD.SurveyID = {0} and QCRD.ReadingID = {1}", surveyID, readingID);
                    result = dbHelper.GetQueryList(query, ref fieldsAnswers);
                    if (result == GlobalErrors.Success)
                        surveyReadingModel.FieldsAnswers = fieldsAnswers;

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetQuestionBodyLanguages(int fieldId, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select * from FieldLanguage where FieldId = {0}", fieldId);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GeQuestionNameLanguages(int fieldId, string columnName, ref List<TextLanguage> descriptions)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TextLanguage> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<TextLanguage>();
                string query = string.Format(@"select FieldLanguage.LanguageId,FieldLanguage.{1} Description from FieldLanguage where FieldId = {0}", fieldId, columnName);
                result = dBHelper.GetQueryList(query, ref descriptions);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors InsertDCF(int dCFID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" SET IDENTITY_INSERT DCF ON
                                                INSERT INTO DCF (DCFID,Number,DateOfIssue ,status ,IsDeleted) VALUES ({0},{1},{2},{3},{4})
                                                SET IDENTITY_INSERT DCF OFF ", dCFID, -1, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), 2, 0);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors getMaxDCFID(ref int maxDCFId, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select max(DCFID)+1 from DCF");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    maxDCFId = Int32.Parse(field.ToString());
                }
                else
                    maxDCFId = -1;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors InsertDCFLanguage(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (TextLanguage lang in survey.SurveyNameDescriptionLanguages)
                {
                    string query = string.Format(@"INSERT INTO DCFLanguage (DCFID ,LanguageID ,Description) VALUES ({0} ,{1},'{2}')", survey.DCFID, lang.LanguageId, lang.Description.Replace("'", "''"));
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveytoChannel(DBHelper<int> dBHelper, int surveyId, CustomerChannelModel channel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                int ChannelId = 0;
                int SubChannelId = 0;
                var ChannelSubChannelIds = channel.ChannelSubChannelIds.Split("-");
                if (ChannelSubChannelIds.Length > 0)
                {
                    ChannelId = Convert.ToInt32(ChannelSubChannelIds[0]);
                    SubChannelId = Convert.ToInt32(ChannelSubChannelIds[1]);
                }
                else
                {
                    result = GlobalErrors.Error; 
                }
                if (result != GlobalErrors.Error)
                {
                    string query = string.Format(@"insert into SurveyChannel values({0},{1},{2})", surveyId, ChannelId, SubChannelId);
                    result = dBHelper.ExecuteNonQuery(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveytoGroup(CustomerGroupModel group, int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into surveygroup (surveyID, groupID) values ({0},{1})", surveyId, group.GroupId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplySurveytoCustomer(int surveyId, int customerId, int outletId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into surveycustomer (SurveyID, CustomerID, OutletID) values ({0},{1},{2})", surveyId, customerId, outletId);
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertSurveyLanguage(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                if (survey.SurveyNameDescriptionLanguages != null)
                {
                    foreach (var lang in survey.SurveyNameDescriptionLanguages)
                    {
                        if (lang.Description != null && lang.Description.Trim() != string.Empty)
                        {
                            query = string.Format(@"IF not EXISTS 
                            (SELECT * FROM SurveyLanguage WHERE SurveyID = {0} and LanguageID = {1} )
                            Insert Into SurveyLanguage (SurveyID,LanguageID,Description) Values ({0},{1},'{2}')
                            else Update SurveyLanguage set Description = '{2}' WHERE SurveyID = {0} and LanguageID = {1}",
                            survey.SurveyId,
                            lang.LanguageId,
                            lang.Description.Replace("'", "''")
                            );
                            result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors InsertSurveyLetterHeadLanguages(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Success;
            string query = "";
            try
            {
                if (survey.LetterHeadDescriptionLanguages != null)
                {
                    foreach (var lang in survey.LetterHeadDescriptionLanguages)
                    {
                        if (lang.Description != null && lang.Description.Trim() != string.Empty)
                        {
                            query = string.Format(@"IF not EXISTS 
                            (SELECT * FROM SurveyLanguage WHERE SurveyID = {0} and LanguageID = {1} )
                            Insert Into SurveyLanguage (SurveyID,LanguageID,LetterHead) Values ({0},{1},'{2}')
                            else Update SurveyLanguage set LetterHead = '{2}' WHERE SurveyID = {0} and LanguageID = {1}",
                            survey.SurveyId,
                            lang.LanguageId,
                            lang.Description.Replace("'", "''")
                            );
                            result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                            {
                                return result;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteSurveyLanguage(int surveyID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" delete from SurveyLanguage WHERE SurveyID = {0}",
                surveyID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors getMaxSurveyID(ref int Max, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select max(surveyID)+1 from survey");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    Max = Int32.Parse(field.ToString());
                }
                else
                    Max = 1;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors InsertSurvey(SurveyModel survey, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into Survey (SurveyID,InActive,ValidFrom,ValidTo, DCFID, NumberOfQuestions, TimeToFill,ForceFillingMode,SurveyTypeID,AllSecurityGroups,ApplyForNewCustomers,OrganizationID, SurveyPeriodTypeID, Points, AllCustomers, AllOrganizationEmployees, IsMainMenu, ImageID, LinkedToProm,CreatedDate,CreatedBy,UpdateDate,UpdateBy,SurveySequence,RouteHistoryStatusId) 
                                               values ({8},{0},{1},{2},{3},{4},{5},{6},{7},{10},{9},{11},{12},{13},{14},{15},{16},'{17}', {18},{19},{20},{21},{22},{23},{24})",
                    Convert.ToInt16(survey.InActive),
                    LocalUtilities.ParseDateAndTimeToSQL(survey.ValidFromModel.Date),
                    LocalUtilities.ParseDateAndTimeToSQL(survey.ValidToModel.Date),
                    survey.DCFID,
                    survey.NumberOfQuestions,
                    survey.TimeToFill,
                    survey.ForceFillingMode,
                    survey.SurveyTypeId, survey.SurveyId,
                    Convert.ToInt16(survey.ApplyForNewCustomers),
                    Convert.ToInt16(survey.AllSecurityGroups),
                    survey.OrganizationID,
                    survey.SurveyPeriodTypeId,
                    survey.Points,
                    survey.AllCustomers ? 1 : 0,
                    survey.AllOrganizationEmployees ? 1 : 0,
                    survey.IsMainMenu ? 1 : 0,
                    survey.ImageId,
                    survey.LinkedToProm ? 1 : 0,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    _requestRepository.CurrentOperator.EmployeeId,
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now),
                    _requestRepository.CurrentOperator.EmployeeId,
                    survey.SurveySequence,
                    survey.RouteHistoryStatusId
                    );
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }
        public GlobalErrors SaveSurveyOrganizations(int surveyID, List<OrganizationModel> organizationsList, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (OrganizationModel organizationObject in organizationsList)
                {
                    values.Clear();
                    values.AppendFormat("( {0},{1} ),",
                    surveyID, //1
                    organizationObject.OrganizationId //2
                    );
                query = string.Format(@"Insert Into SurveyOrganization (SurveyID, OrganizationID) Values {0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Error)
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteSurveyOrganizaions(int surveyId, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Delete SurveyOrganization from SurveyOrganization where SurveyID={0} and OrganizationID in ({1})", surveyId, _requestRepository.CurrentOperator.OrganizationAccess);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetQuestionsSubType(int surveyTypeId, ref List<FieldSubTypeModel> questionSubTypeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string fieldTypes = string.Empty;
            try
            {
                DBHelper<FieldSubTypeModel> dBHelper = new DBHelper<FieldSubTypeModel>();
                if(surveyTypeId != SurveyTypes.CustomerAppSurvey.GetHashCode())
                {
                    fieldTypes = string.Format(@" and not(FieldSubType.FieldTypeId in ({0}))", FieldTypes.Rate.GetHashCode());
                }
                else
                {
                    fieldTypes = string.Format(@" and (FieldSubType.FieldTypeId not in ({0}, {1})) and not(FieldSubType.FieldSubTypeId in (2, 3, 4) and FieldSubType.FieldTypeId = 2)", FieldTypes.Location.GetHashCode(), FieldTypes.Attachments.GetHashCode());
                }
               
                    
                string query = string.Format(@"Select FieldSubType.FieldSubTypeId ,FieldSubType.FieldTypeId , FieldSubTypeLanguage.Description FieldSubTypeName from FieldSubType 
                inner join FieldSubTypeLanguage on FieldSubType.FieldSubTypeID = FieldSubTypeLanguage.FieldSubTypeID AND FieldSubType.FieldTypeID = FieldSubTypeLanguage.FieldTypeID
                where LanguageID = {0} {1}", _requestRepository.LanguageId, fieldTypes);
                result = dBHelper.GetQueryList(query, ref questionSubTypeList);

                if(surveyTypeId == SurveyTypes.POSStockCounting.GetHashCode() && (questionSubTypeList != null && questionSubTypeList.Count > 0))
                {
                    questionSubTypeList = questionSubTypeList.Where(x => 
                    (x.FieldTypeId != 8 || x.FieldSubTypeId != 8 ) 
                    && (x.FieldTypeId != 2 || x.FieldSubTypeId != 4) 
                    && (x.FieldTypeId != 2 || x.FieldSubTypeId != 3)
                    && (x.FieldTypeId != 9 || x.FieldSubTypeId != 1)
                    ).ToList();
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public FieldSubTypeModel GetSubFields(int fieldId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            FieldSubTypeModel fieldSubTypes = new FieldSubTypeModel();
            try
            {
                DBHelper<FieldSubTypeModel> dBHelper = new DBHelper<FieldSubTypeModel>();
                string query = string.Format(@"select FieldSubTypeID,FieldTypeID from field where FieldID = {0} ", fieldId);
                result = dBHelper.GetQuerySingle(query, ref fieldSubTypes);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return fieldSubTypes;
        }
        //public GlobalErrors EditLOVOptionList(List<LOVOptionModel> LOVOptionList, int LOVID, DBHelper<int> dBHelper)
        //{
        //    GlobalErrors result = GlobalErrors.NotInitialized;
        //    try
        //    {
        //        string LOVOptionQuery = String.Empty;
        //        string LOVOptionLanguageQuery = String.Empty;
        //        foreach (LOVOptionModel option in LOVOptionList)
        //        {
        //            if (option.Id < 0)
        //            {
        //                //new option, insert it as new
        //                LOVOptionQuery = string.Format(@"insert into LOVOption(LOVID,Score) values ({0},{1})",
        //                LOVID, option.OptionScore);
        //                result = dBHelper.ExecuteNonQuery(LOVOptionQuery);

        //                if (result == GlobalErrors.Success)
        //                {
        //                    LOVOptionLanguageQuery = string.Format(@"insert into LOVOptionLanguage(LOVOptionID,LanguageID,Description) values ({0},{1},'{2}')",
        //                    GetMaxID(CoreDataBaseConstants.QueryColumnsNames.LOVOptionID, CoreDataBaseConstants.TableNames.LOVOption, dBHelper), _requestRepository.LanguageId, option.OptionName);
        //                    result = dBHelper.ExecuteNonQuery(LOVOptionLanguageQuery);
        //                }
        //            }
        //            else
        //            { 
        //            LOVOptionQuery = string.Format(@"update LOVOption set LOVOption.Score={0} where LOVOption.LOVOptionID={1} and LOVOption.LOVID={2}",
        //                option.OptionScore, option.Id, LOVID);
        //            result = dBHelper.ExecuteNonQuery(LOVOptionQuery);
        //            if (result == GlobalErrors.Success)
        //            {

        //                LOVOptionLanguageQuery = string.Format(@"update LOVOptionLanguage set LOVOptionLanguage.Description='{0}' where LOVOptionLanguage.LOVOptionID={1} and LOVOptionLanguage.LanguageID={2}",
        //                option.OptionName, GetMaxID(CoreDataBaseConstants.QueryColumnsNames.LOVOptionID, CoreDataBaseConstants.TableNames.LOVOption, dBHelper), _requestRepository.LanguageId);
        //                result = dBHelper.ExecuteNonQuery(LOVOptionLanguageQuery);
        //            }


        //            }



        //            if (result != GlobalErrors.Success)
        //                break;
        //        }

        //    }
        //    catch (Exception ex)
        //    {
        //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
        //        return GlobalErrors.Error;
        //    }
        //    return result;
        //}

        public GlobalErrors SaveLOVOptionList(List<LOVOptionModel> LOVOptionList, int LOVID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {   //get maxid from LOV table
                int maxLOVOptionID = -1;
                string LOVOptionQuery = String.Empty;
                string LOVOptionLanguageQuery = String.Empty;
                bool getFirstOptionID = true;

                foreach (LOVOptionModel option in LOVOptionList)
                {
                    LOVOptionQuery = string.Format(@"insert into LOVOption(LOVID,Score) values ({0},{1})",
                        LOVID, option.OptionScore);
                    result = dBHelper.ExecuteNonQuery(LOVOptionQuery);

                    if (result == GlobalErrors.Success)
                    {
                        if (getFirstOptionID)
                        {
                            maxLOVOptionID = GetMaxID(CoreDataBaseConstants.QueryColumnsNames.LOVOptionID, CoreDataBaseConstants.TableNames.LOVOption, dBHelper);
                            getFirstOptionID = false;
                        }
                        foreach (LOVLanguageModel OptionName in option.OptionName)
                        {
                            LOVOptionLanguageQuery = string.Format(@"insert into LOVOptionLanguage(LOVOptionID,LanguageID,Description) values ({0},{1},'{2}')",
                            maxLOVOptionID, OptionName.LanguageId, OptionName.Description.Replace("'", "''"));
                            result = dBHelper.ExecuteNonQuery(LOVOptionLanguageQuery);
                            if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                                break;
                        }
                        
                    }
                    maxLOVOptionID++;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #region[LOV]
        public GlobalErrors GetLOVByID(int LOVID, ref LOVDynamicModel LOVModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                DBHelper<LOVDynamicModel> dBHelper = new DBHelper<LOVDynamicModel>();
                DBHelper<LOVLanguageModel> languageDBHelper = new DBHelper<LOVLanguageModel>();
                query = string.Format(@"select LOV.LOVID, LOV.LOVQuery as LOVQuery, LOV.DynamicField
                from LOV 
                left outer join LOVLanguage on LOVLanguage.LOVID=LOV.LOVID and LOVLanguage.LanguageID={0}
                where LOV.LOVID={1} ", _requestRepository.LanguageId, LOVID);
                result = dBHelper.GetQuerySingle(query, ref LOVModel);
                if (result == GlobalErrors.Success)
                {
                   List <LOVLanguageModel> languageModel = new List<LOVLanguageModel>();
                    query = string.Format(@"select  LOVLanguage.Name as Description, LOVLanguage.LanguageID as LanguageId
                from LOV 
                left outer join LOVLanguage on LOVLanguage.LOVID=LOV.LOVID
                where LOV.LOVID={0} ", LOVID);
                    result = languageDBHelper.GetQueryList(query, ref languageModel);
                    LOVModel.LOVName = languageModel;
                }
                if (result == GlobalErrors.Success)
                {
                    List<LOVLanguageModel> languageModel = new List<LOVLanguageModel>();
                    query = string.Format(@"select  LOVLanguage.Description as Description, LOVLanguage.LanguageID as LanguageId
                    from LOV 
                    left outer join LOVLanguage on LOVLanguage.LOVID=LOV.LOVID
                    where LOV.LOVID={0} ", LOVID);
                    result = languageDBHelper.GetQueryList(query, ref languageModel);
                    LOVModel.LOVDescription = languageModel;
                }
                if (result == GlobalErrors.Success)
                {
                    List<LOVOptionModel> LOVOptionList = new List<LOVOptionModel>();
                    DBHelper<LOVOptionModel> optionListDBHelper = new DBHelper<LOVOptionModel>();
                    //get option list
                    query = string.Format(@"select LOVOption.LOVOptionID as Id, LOVOption.Score as OptionScore
                    from LOVOption 
                    left outer join LOVOptionLanguage On LOVOptionLanguage.LOVOptionID=LOVOption.LOVOptionID 
                    and LOVOptionLanguage.LanguageID={0}
                    where LOVID={1}", _requestRepository.LanguageId, LOVID);
                    result = optionListDBHelper.GetQueryList(query, ref LOVOptionList);
                    LOVModel.LOVOptionList = LOVOptionList;
                    if(LOVModel.LOVOptionList!=null && LOVModel.LOVOptionList.Count>0)
                    foreach(LOVOptionModel optionModel in LOVModel.LOVOptionList)
                    {
                        if (result == GlobalErrors.Success)
                        {
                                List<LOVLanguageModel> languageModel = new List<LOVLanguageModel>();
                            query = string.Format(@"select LOVOptionLanguage.LanguageID as LanguageId, 
                    LOVOptionLanguage.Description as Description 
                    from LOVOption 
                    left outer join LOVOptionLanguage On LOVOptionLanguage.LOVOptionID=LOVOption.LOVOptionID 
                    where LOVID={0} and LOVOption.LOVOptionID={1}", LOVID, optionModel.Id);
                            result = languageDBHelper.GetQueryList(query, ref languageModel);
                            optionModel.OptionName = languageModel;
                                if (result != GlobalErrors.Success)
                                    break;
                        }
                    }
                }

                if (LOVModel.LOVOptionList == null || LOVModel.LOVOptionList.Count == 0)
                    LOVModel.IsDynamic = true;
                else
                    LOVModel.IsDynamic = false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteLOVOptionList(int LOVID, DBHelper<int> dBHelper,Boolean isEditMode=false)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string query = String.Empty;
            try
            {
                List<int> LOVOPtionIDs = new List<int>();
                query = string.Format(@"select LOVOption.LOVOptionID from LOVOption where LOVID = {0}", LOVID);
                dBHelper.GetQueryList(query, ref LOVOPtionIDs);
                    if (LOVOPtionIDs != null)
                        foreach (int LOVOptionID in LOVOPtionIDs)
                        {
                            query = string.Format(@"delete from LOVOptionLanguage where LOVOptionID = {0}", LOVOptionID);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                                break;
                        }
                #region [Not necessary but double check]
                //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.NotInitialized)
                //{
                //    query = string.Format(@"delete from FieldValueLOV where LOVID = {0}", LOVID);
                //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                //}
                //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.NotInitialized)
                //{
                //    query = string.Format(@"delete from FieldValueMatrix where XLOVID = {0} or YLOVID = {0}", LOVID);
                //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                //}
                //if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.NotInitialized)
                //{
                //    query = string.Format(@"delete from FieldValueCheckList where LOVID = {0}", LOVID);
                //    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                //}
                #endregion
                if (!isEditMode)
                {
                    List<int> LOVFieldIDs = new List<int>();
                    query = string.Format(@"select Field.FieldID from Field where LOVID = {0}", LOVID);
                    dBHelper.GetQueryList(query, ref LOVFieldIDs);
                    if (LOVFieldIDs != null)
                        foreach (int LOVFieldID in LOVFieldIDs)
                        {
                            query = string.Format(@"delete from FieldLanguage where FieldLanguage.FieldID = {0}", LOVFieldID);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                            if (result == GlobalErrors.Error)
                                break;
                        }

                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.NotInitialized)
                    {
                        query = string.Format(@"delete from field where LOVID = {0}", LOVID);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    }
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected || result == GlobalErrors.NotInitialized)
                {
                    query = string.Format(@"delete from LOVOption where LOVID = {0}", LOVID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteLOV(int LOVID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"delete from LOVLanguage where LOVID = {0}", LOVID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {

                    result = DeleteLOVOptionList(LOVID, dBHelper);

                }

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    query = string.Format(@"delete from LOV where LOVID = {0}", LOVID);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                }

                //list of LOVOptionID to delete it from language

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditLOV(LOVDynamicModel LOVModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string LOVquery = string.Format(@"update LOV set LOV.LOVQuery=('{0}') , LOV.DynamicField = {2} where LOV.LOVID={1}",
                                 (LOVModel.IsDynamic) ? LOVModel.LOVQuery.Replace("'", "''") : "", LOVModel.LOVID, 
                                 string.IsNullOrEmpty(LOVModel.DynamicField) || !LOVModel.IsDynamic ? "null" : "'" + LOVModel.DynamicField + "'"
                                 );
                result = dBHelper.ExecuteNonQuery(LOVquery);

                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    foreach (LOVLanguageModel LOVName in LOVModel.LOVName)
                    {
                        string LOVLanguageQuery = string.Format(@"update LOVLanguage set LOVLanguage.Name='{0}' where LOVLanguage.LOVID={1} and LOVLanguage.LanguageID={2}", LOVName.Description.Replace("'", "''"),  LOVModel.LOVID, LOVName.LanguageId);
                        result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(LOVLanguageQuery);
                        if(result == GlobalErrors.SuccessWithZeroRowAffected)
                        {
                            LOVLanguageQuery = string.Format(@"Insert into LOVLanguage(LOVID,LanguageID,Name) values ({0},{1},'{2}')", LOVModel.LOVID, LOVName.LanguageId, LOVName.Description.Replace("'", "''"));
                            result = dBHelper.ExecuteNonQuery(LOVLanguageQuery);
                        }
                        if (result != GlobalErrors.Success)
                            break;
                    }
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        string LOVLanguageQuery = "";
                        foreach (LOVLanguageModel LOVDescription in LOVModel.LOVDescription)
                        {
                            if (LOVDescription.Description != null)
                            { 
                            LOVLanguageQuery = string.Format(@"update LOVLanguage set LOVLanguage.Description='{0}' where LOVLanguage.LOVID={1} and LOVLanguage.LanguageID={2}", LOVDescription.Description.Replace("'", "''"), LOVModel.LOVID, LOVDescription.LanguageId);
                            result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(LOVLanguageQuery);
                                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    LOVLanguageQuery = string.Format(@"Insert into LOVLanguage(LOVID,LanguageID,Description) values ({0},{1},'{2}')", LOVModel.LOVID, LOVDescription.LanguageId, LOVDescription.Description.Replace("'", "''"));
                                    result = dBHelper.ExecuteNonQuery(LOVLanguageQuery);
                                }
                            }
                             if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                                break;
                        }
                    }
                }
                if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = DeleteLOVOptionList(LOVModel.LOVID, dBHelper,true);
                    if (result == GlobalErrors.Success|| result == GlobalErrors.SuccessWithZeroRowAffected)
                    { 
                     if (LOVModel.LOVOptionList.Count > 0)
                        if (!LOVModel.IsDynamic)
                        {
                            result = SaveLOVOptionList(LOVModel.LOVOptionList, LOVModel.LOVID, dBHelper);
                        }
                    }
                   
                        
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveLOV(ref LOVDynamicModel LOVModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string LOVquery = string.Format(@"insert into LOV(LOVType,IsDeleted,LOVQuery,DynamicField) values (2,0,'{0}', {1})",
                   (LOVModel.IsDynamic) ? LOVModel.LOVQuery.Replace("'", "''") : "", string.IsNullOrEmpty(LOVModel.DynamicField) ? "null" : "'" + LOVModel.DynamicField + "'");

                result = dBHelper.ExecuteNonQuery(LOVquery);
                if (result == GlobalErrors.Success)
                {
                    LOVModel.LOVID = GetMaxID(CoreDataBaseConstants.QueryColumnsNames.LOVID, CoreDataBaseConstants.TableNames.LOV, dBHelper);
                    foreach (LOVLanguageModel LOVName in LOVModel.LOVName)
                    {
                        string LOVLanguageQuery = string.Format(@"insert into LOVLanguage(LOVID,LanguageID,Name) values({0},{1},'{2}')", LOVModel.LOVID, LOVName.LanguageId, LOVName.Description.Replace("'", "''"));
                        result = dBHelper.ExecuteNonQuery(LOVLanguageQuery);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                    if (result == GlobalErrors.Success)
                    {
                        string LOVLanguageQuery = "";
                        foreach (LOVLanguageModel LOVDescription in LOVModel.LOVDescription)
                        {
                            if (LOVDescription.Description != null)
                            {
                                LOVLanguageQuery = string.Format(@"update LOVLanguage set LOVLanguage.Description ='{2}' where LOVLanguage.LOVID={0} and LOVLanguage.LanguageID={1}", LOVModel.LOVID, LOVDescription.LanguageId, LOVDescription.Description.Replace("'", "''"));
                                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(LOVLanguageQuery);
                                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                                {
                                    LOVLanguageQuery = string.Format(@"Insert into LOVLanguage(LOVID,LanguageID,Description) values ({0},{1},'{2}')", LOVModel.LOVID, LOVDescription.LanguageId, LOVDescription.Description.Replace("'", "''"));
                                    result = dBHelper.ExecuteNonQuery(LOVLanguageQuery);
                                }
                            }
                             if (result != GlobalErrors.Success && result != GlobalErrors.SuccessWithZeroRowAffected)
                                break;
                        }
                    }


                }
                if (result == GlobalErrors.Success)
                {
                    if (!LOVModel.IsDynamic)
                        if (LOVModel.LOVOptionList.Count > 0)
                            result = SaveLOVOptionList(LOVModel.LOVOptionList, LOVModel.LOVID, dBHelper);
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        public GlobalErrors GetQuestionsValues(ref List<SurveyTemplateModel> questionValuesList, DBHelper<SurveyTemplateModel> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"Select distinct LOV.LOVID Id , LOVLanguage.Name, LOVLanguage.Description,
                case when ((usedInMatrix.XLOVID is null or usedInMatrix.YLOVID is null) and usedInFieldValueLOV.lovid is null  and usedInFieldValueCheckList.lovid is null) then 0 else 1 end IsUsed ,
                CASE WHEN LOV.LOVQuery IS NOT NULL AND CAST(LOV.LOVQuery AS VARCHAR(MAX)) <> '' THEN 1 ELSE 0 END as IsQuery, 
                LOV.DynamicField
                from  
                LOV left outer join  LOVLanguage on LOV.LOVID  = LOVLanguage.LOVID AND LOVLanguage.LanguageID = {0}
                left join
                (select distinct XLOVID,YLOVID from FieldValueMatrix Union select distinct XLOVID,YLOVID from FieldValueMatrix)usedInMatrix On usedInMatrix.xlovid = lov.LOVID or usedInMatrix.YLOVID = lov.LOVID
                left join
                (select distinct LOVID from FieldValueLOV Union select distinct LOVID from FieldValueLOV)usedInFieldValueLOV On usedInFieldValueLOV.lovid = lov.LOVID
                left join
                (select distinct LOVID from FieldValueCheckList Union select distinct LOVID from FieldValueCheckList)usedInFieldValueCheckList On usedInFieldValueCheckList.lovid = lov.LOVID
                where (LOV.IsDeleted = 0 or LOV.IsDeleted Is Not Null) AND LOV.LOVType = 2", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref questionValuesList);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetQuestionsType(ref List<FieldSubTypeModel> questionTypeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<FieldSubTypeModel> dBHelper = new DBHelper<FieldSubTypeModel>();
                string query = string.Format(@"select FieldSubTypeLanguage.FieldSubTypeID,FieldSubTypeLanguage.FieldTypeID,FieldSubTypeLanguage.Description FieldSubTypeName 
                                               from FieldSubTypeLanguage where FieldSubTypeLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref questionTypeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #region [SurveyPeriods]
        public GlobalErrors DeleteSurveyPeriodTypes(int SurveyID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = string.Format(@"DELETE FROM  SurveyPeriods WHERE SurveyID = {0}", SurveyID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyPeriodTypes(int surveyTypeId, ref List<SurveyPeriodTypeModel> surveyPeriodTypeList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string customPeriodFilter = string.Empty;
                if (surveyTypeId != SurveyTypes.CustomerSurvey.GetHashCode())
                    customPeriodFilter = " and SurveyPeriodTypes.PeriodTypeID <> 5";
                DBHelper<SurveyPeriodTypeModel> dBHelper = new DBHelper<SurveyPeriodTypeModel>();
                string query = string.Format(@"select SurveyPeriodTypes.PeriodTypeID, Description as periodTypeName from SurveyPeriodTypes
                inner join SurveyPeriodTypesLanguage on SurveyPeriodTypes.PeriodTypeID = SurveyPeriodTypesLanguage.PeriodTypeID 
                where SurveyPeriodTypesLanguage.LanguageID = {0} {1}", _requestRepository.LanguageId, customPeriodFilter);
                result = dBHelper.GetQueryList(query, ref surveyPeriodTypeList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyPeriods(ref List<SurveyPeriod> surveyPeriods, DBHelper<SurveyPeriod> dBHelper, int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<SurveyPeriodTest> test = new List<SurveyPeriodTest>();
            DBHelper<SurveyPeriodTest> dBHelper2 = new DBHelper<SurveyPeriodTest>();
            try
            {
                string query = string.Format(@"select  SurveyPeriods.FromDate as FromDate,  SurveyPeriods.ToDate as ToDate  From SurveyPeriods where SurveyID  = {0}", surveyId);
                result = dBHelper2.GetQueryList(query, ref test);
                foreach(SurveyPeriodTest periodTest in test)
                {
                        surveyPeriods.Add(new SurveyPeriod(new DateModel( (DateTime.Parse(periodTest.FromDate))), new DateModel((DateTime.Parse(periodTest.ToDate).AddDays(-1).AddSeconds(1)))));
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
        public GlobalErrors GetInspectorSurveys(FilterModel filterModel, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string incudeFilter = " and Survey.InActive = 0";
                string nameFilter = "";
                string dateFilter = "";
                string inspectorIDCheck = "";
                if (filterModel != null && filterModel.Active)
                {
                    incudeFilter = "";
                }
                if (filterModel != null && filterModel.SurveyName != null && !filterModel.SurveyName.Equals(""))
                {
                    nameFilter = string.Format(" and SurveyLanguage.Description like '%{0}%'", filterModel.SurveyName.Replace("'", "''"));
                }
                if (filterModel != null && filterModel.ValidTo != null && filterModel.ValidTo.Value != null && filterModel.ValidTo.Value.CompareTo(DateTime.MinValue) > 0)
                {
                    dateFilter = string.Format(" and Survey.ValidTo <= DATEADD( DAY ,1,{0})", LocalUtilities.ParseEndDateToSQLString(filterModel.ValidTo.Value));
                }
                if(_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Inspector.GetHashCode())
                {
                    inspectorIDCheck = string.Format(@" and  SurveyInspectors.InspectorID = {0} ", _requestRepository.CurrentOperator.EmployeeId);
                }
                DBHelper<SurveyModel> dBHelper = new DBHelper<SurveyModel>();
                string query = string.Format(@"select distinct QCR.readingid,QCR.StartDate as ReadingDate,QCR.ValidTo as ReadingValidTo, Survey.*,SurveyLanguage.Description SurveyName,SurveyLanguage.LetterHead,OrganizationLanguage.Description OrganizationName,
                SurveyWarehouses.WarehouseID,IsNull( warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( warehouseLanguage.Description , '--') Warehouse, 
                Warehouse.WarehouseTypeID, 0 as IsFilled, 0 as IsCompletelyFilled, '{9}' as status,
                Case Survey.OrganizationID when -1 then '{10}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName
                from Survey 
                Inner join SurveyInspectors on SurveyInspectors.SurveyID = Survey.SurveyID 
                inner join SurveyWarehouses on SurveyWarehouses.SurveyID = Survey.SurveyID
                Inner join Warehouse on Warehouse.WarehouseID = SurveyWarehouses.WarehouseID
                Inner join WarehouseLanguage on Warehouse.WarehouseID= WarehouseLanguage.WarehouseID and WarehouseLanguage.LanguageID ={1}
left Join QualityControlReading QCR on QCR.SurveyID = Survey.SurveyID and QCR.WarehouseID = warehouse.WarehouseID
				and (QCR.IsCompletelyFilled = 1 and QCR.ValidTo >= {7})
                left join SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID ={1}
                LEFT OUTER JOIN Organization on Organization.OrganizationID = Survey.OrganizationID    
                left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Survey.OrganizationID and OrganizationLanguage.LanguageID = {1}
                LEFT OUTER JOIN SurveyOrganization On SurveyOrganization.SurveyID = Survey.SurveyID               
                where Survey.ValidFrom <= {7} AND Survey.ValidTo >= {7} and SurveyTypeID = 5 and  SurveyInspectors.InspectorID = {6}  and (Survey.OrganizationID in ({4}) or SurveyOrganization.OrganizationID IN ({4})) {0} {2} {3} and QCR.SurveyID is null
                union
                select distinct QCR.readingid,QCR.StartDate as ReadingDate,QCR.ValidTo as ReadingValidTo, Survey.*,SurveyLanguage.Description SurveyName,SurveyLanguage.LetterHead,OrganizationLanguage.Description OrganizationName
                ,SurveyVehicles.VehicleID,IsNull( warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( warehouseLanguage.Description , '--')Warehouse ,
                Warehouse.WarehouseTypeID, 0 as IsFilled, 0 as IsCompletelyFilled, '{9}' as status ,
                Case Survey.OrganizationID when -1 then '{10}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName
                from Survey 
                Inner join SurveyInspectors on SurveyInspectors.SurveyID = Survey.SurveyID 
                Inner join SurveyVehicles on SurveyVehicles.SurveyID = Survey.SurveyID
                Inner join Warehouse on Warehouse.WarehouseID = SurveyVehicles.VehicleID
                inner join WarehouseLanguage on Warehouse.WarehouseID=WarehouseLanguage.WarehouseID and WarehouseLanguage.LanguageID ={1}
left Join QualityControlReading QCR on QCR.SurveyID = Survey.SurveyID and QCR.VehicleID = warehouse.WarehouseID
				and (QCR.IsCompletelyFilled = 1 and QCR.ValidTo >= {7})
                left join SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID ={1}
                LEFT OUTER JOIN Organization on Organization.OrganizationID = Survey.OrganizationID    
                left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Survey.OrganizationID and OrganizationLanguage.LanguageID = {1}
                LEFT OUTER JOIN SurveyOrganization On SurveyOrganization.SurveyID = Survey.SurveyID
                where Survey.ValidFrom <= {7} AND Survey.ValidTo >= {7} and SurveyTypeID = 5 and  SurveyInspectors.InspectorID = {6} and (Survey.OrganizationID in ({4}) or SurveyOrganization.OrganizationID IN ({4})) {0} {2} {3} and QCR.SurveyID is null
                union
                select distinct QCR.readingid,QCR.StartDate as ReadingDate,QCR.ValidTo as ReadingValidTo, Survey.*,SurveyLanguage.Description SurveyName,SurveyLanguage.LetterHead,OrganizationLanguage.Description OrganizationName,SurveyDamagedWarehouses.DamagedWarehouseID,IsNull( Warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( WarehouseLanguage.Description , '--')  Warehouse,
                Warehouse.WarehouseTypeID, 0 as IsFilled, 0 as IsCompletelyFilled, '{9}' as status,
                Case Survey.OrganizationID when -1 then '{10}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName
                from Survey 
                Inner join SurveyInspectors on SurveyInspectors.SurveyID = Survey.SurveyID 
                Inner join SurveyDamagedWarehouses on SurveyDamagedWarehouses.SurveyID = Survey.SurveyID
                Inner join Warehouse on Warehouse.WarehouseID = SurveyDamagedWarehouses.DamagedWarehouseID
                inner join WarehouseLanguage on Warehouse.WarehouseID = WarehouseLanguage.WarehouseID and WarehouseLanguage.LanguageID ={1}
left Join QualityControlReading QCR on QCR.SurveyID = Survey.SurveyID and QCR.DamagedWarehouseID = warehouse.WarehouseID
				and (QCR.IsCompletelyFilled = 1 and QCR.ValidTo >= {7})
                left join SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID ={1}
                LEFT OUTER JOIN Organization on Organization.OrganizationID = Survey.OrganizationID    
                left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Survey.OrganizationID and OrganizationLanguage.LanguageID = {1}
                LEFT OUTER JOIN SurveyOrganization On SurveyOrganization.SurveyID = Survey.SurveyID
                where Survey.ValidFrom <= {7} AND Survey.ValidTo >= {7} and SurveyTypeID = 5 and  SurveyInspectors.InspectorID = {6} and (Survey.OrganizationID in ({4}) or SurveyOrganization.OrganizationID IN ({4})) {0} {2} {3} and QCR.SurveyID is null

union all
select distinct QCR.readingid,QCR.StartDate as ReadingDate,QCR.ValidTo as ReadingValidTo, Survey.*,SurveyLanguage.Description SurveyName,SurveyLanguage.LetterHead,OrganizationLanguage.Description OrganizationName,Warehouse.WarehouseID,IsNull( Warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( WarehouseLanguage.Description , '--')  Warehouse,
Warehouse.WarehouseTypeID , 1 as IsFilled, QCR.IsCompletelyFilled as IsCompletelyFilled, '{8}' as status,
Case Survey.OrganizationID when -1 then '{10}' else IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') end as OrganizationCodeName
from Survey 
Inner join SurveyInspectors on SurveyInspectors.SurveyID = Survey.SurveyID 
Inner Join QualityControlReading QCR on QCR.SurveyID = Survey.SurveyID
Inner join Warehouse on ((Warehouse.WarehouseID = QCR.WarehouseID) or (Warehouse.WarehouseID = QCR.DamagedWarehouseID)
or (Warehouse.WarehouseID = QCR.VehicleID))
inner join WarehouseLanguage on Warehouse.WarehouseID = WarehouseLanguage.WarehouseID and WarehouseLanguage.LanguageID ={1}
left join SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID ={1}
 LEFT OUTER JOIN Organization on Organization.OrganizationID = Survey.OrganizationID    
left join OrganizationLanguage on OrganizationLanguage.OrganizationID = Survey.OrganizationID and OrganizationLanguage.LanguageID = {1}
LEFT OUTER JOIN SurveyOrganization On SurveyOrganization.SurveyID = Survey.SurveyID
where Survey.ValidFrom <= {7} AND Survey.ValidTo >= {7} and SurveyTypeID = 5 {11} and (Survey.OrganizationID in ({4}) or SurveyOrganization.OrganizationID IN ({4})) {0} {2} {3} ", 
incudeFilter,//0
_requestRepository.LanguageId,//1
nameFilter,//2
dateFilter,//3
_requestRepository.CurrentOperator.OrganizationAccess,//4
filterModel.SurveyTypeId,//5
_requestRepository.CurrentOperator.EmployeeId, //6
LocalUtilities.ParseDateToSQLString(DateTime.Now),//7
ResourcesManager.TranslateKey(MessagesConstants.Desc_Filled, _requestRepository.LanguageId),//8
ResourcesManager.TranslateKey(MessagesConstants.Desc_Not_Filled, _requestRepository.LanguageId),//9
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Multi_Organizations, _requestRepository.LanguageId) ,//10
                inspectorIDCheck //11
                    );
                result = dBHelper.GetQueryList(query, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyData(int surveyId, int dcfid, int warehouseId, int readnigId, int organizationId, bool isClone, ref SurveyModel surveyModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<TextLanguage> descriptions = new List<TextLanguage>();
            List<QuestionModel> questions = new List<QuestionModel>();
            List<ItemPackModel> appliedItems = new List<ItemPackModel>();
            List<int> addedPageGroupIDs = new List<int>();
            PageGroupQuestionsModel pageGroupQuestions = new PageGroupQuestionsModel();
            SurveyActionsTypesModel surveyAction = new SurveyActionsTypesModel();
            int actionID = -1;
            string minValue = string.Empty;
            string maxValue = string.Empty;
            string specificValue = string.Empty;
            string direction = string.Empty;
            List<int> addedSurveyIds = new List<int>();
            SurveyReadingModel surveyReadingModel = new SurveyReadingModel();
            List<ItemPackModel> filledItems = new List<ItemPackModel>();
            List<OrganizationModel> organizationsList = new List<OrganizationModel>();
            try
            {
                DBHelper<int> dBHelper = new DBHelper<int>();
                descriptions = new List<TextLanguage>();
                addedPageGroupIDs = new List<int>();
                result = GetSurveyLanguages(surveyId, ref descriptions);
                if (result == GlobalErrors.Success)
                {
                    surveyModel.SurveyNameDescriptionLanguages = descriptions;
                    descriptions = new List<TextLanguage>();
                    result = GetSurveyLetterHeadLanguages(surveyId, ref descriptions);
                    if (result == GlobalErrors.Success)
                    {
                        surveyModel.LetterHeadDescriptionLanguages = descriptions;

                        #region[Organizations]
                        if (result == GlobalErrors.Success)
                        {
                            organizationsList = new List<OrganizationModel>();
                            if (organizationId == -1)
                            {
                                result = GetAppliedSurveyOrganizations(surveyId, ref organizationsList);
                            }
                            else
                            {
                                result = GetSurveyOrganization(organizationId, ref organizationsList);
                            }
                            if (result == GlobalErrors.Success && organizationsList != null && organizationsList.Count > 0)
                            {
                                surveyModel.OrganizationsList = organizationsList;
                            }
                        }
                        #endregion


                        questions = new List<QuestionModel>();
                        result = getSurveyQuestions(dcfid, ref questions);
                        if (result == GlobalErrors.Success)
                        {
                            surveyModel.Questions = questions;
                            if (surveyModel.Questions != null && surveyModel.Questions.Count > 0)
                            {
                                surveyModel.PageGroupQuestions = new List<PageGroupQuestionsModel>();
                                foreach (QuestionModel questionModel in surveyModel.Questions)
                                {
                                    if (!addedPageGroupIDs.Contains(questionModel.FieldGroupId))
                                    {
                                        pageGroupQuestions = new PageGroupQuestionsModel();
                                        pageGroupQuestions.FieldGroupID = questionModel.FieldGroupId;
                                        pageGroupQuestions.Questions = surveyModel.Questions.Where(x => x.FieldGroupId == questionModel.FieldGroupId).ToList();
                                        surveyModel.PageGroupQuestions.Add(pageGroupQuestions);
                                        addedPageGroupIDs.Add(pageGroupQuestions.FieldGroupID);
                                    }

                                    if (!string.IsNullOrEmpty(questionModel.ActionTypeIdString))
                                    {
                                        string[] actions = questionModel.ActionTypeIdString.Split(',');
                                        foreach (string action in actions)
                                        {
                                            surveyAction = new SurveyActionsTypesModel();
                                            actionID = int.Parse(action.ToString());
                                            surveyAction.actionTypeId = actionID;
                                            if (actionID == SurveyActionsTypes.SendEmail.GetHashCode())
                                            {
                                                surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Send_Email, _requestRepository.LanguageId);
                                            }
                                            else if (actionID == SurveyActionsTypes.SendSystemNotification.GetHashCode())
                                            {
                                                surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Send_System_Notification, _requestRepository.LanguageId);
                                            }
                                            else if (actionID == SurveyActionsTypes.MoveItemToGoodOrDamagedWarehouse.GetHashCode())
                                            {
                                                surveyAction.actionTypeName = ResourcesManager.TranslateKey(MessagesConstants.Desc_Move_Item_To_Good_Or_Damaged_Warehouse, _requestRepository.LanguageId);
                                                if (questionModel.FieldTypeID == FieldTypes.Numeric.GetHashCode() || questionModel.FieldTypeID == FieldTypes.Date.GetHashCode())
                                                {
                                                    if (questionModel.FieldTypeID == FieldTypes.Numeric.GetHashCode())
                                                    {
                                                        if (questionModel.FieldSubTypeID == 1)
                                                        {
                                                            minValue = (LocalUtilities.GetRoundedDecimal(questionModel.MinValue, 0)).ToString();
                                                            maxValue = (LocalUtilities.GetRoundedDecimal(questionModel.MaxValue, 0)).ToString();
                                                        }
                                                        else
                                                        {
                                                            minValue = (LocalUtilities.GetRoundedDecimal(questionModel.MinValue, _requestRepository.Configurations.NumberOfDigits)).ToString();
                                                            maxValue = (LocalUtilities.GetRoundedDecimal(questionModel.MaxValue, _requestRepository.Configurations.NumberOfDigits)).ToString();
                                                        }
                                                    }
                                                    else
                                                    {
                                                        minValue = questionModel.MinDateModel != null ? questionModel.MinDateModel.Date.ToShortDateString() : "---";
                                                        maxValue = questionModel.MaxDateModel != null ? questionModel.MaxDateModel.Date.ToShortDateString() : "---";
                                                    }
                                                    questionModel.ActionNote = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Action_Note_Min_Max, _requestRepository.LanguageId), "'" + surveyAction.actionTypeName + "'", minValue, maxValue);
                                                }
                                                else if (questionModel.FieldTypeID == FieldTypes.YesNo.GetHashCode() || questionModel.FieldTypeID == FieldTypes.MultipleValue.GetHashCode())
                                                {
                                                    if (questionModel.FieldTypeID == FieldTypes.YesNo.GetHashCode())
                                                        specificValue = questionModel.YesNo ? ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId) : ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId);
                                                    else
                                                        specificValue = questionModel.QuestionOptions != null ? questionModel.QuestionOptions.Find(x => x.LOVID == questionModel.LOVID && x.LOVOptionID == questionModel.LOVOptionID).LOVOptionName : string.Empty;
                                                    questionModel.ActionNote = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Action_Note_Specific_Value, _requestRepository.LanguageId), specificValue, "'" + surveyAction.actionTypeName + "'");

                                                }
                                                questionModel.ShowActionOnReading = true;
                                            }
                                            questionModel.ActionTypeId.Add(surveyAction);
                                        }
                                    }
                                }
                            }
                            // survey.IsUsed = _surveyManager.CheckIfSurveyUsed(survey.SurveyId, dBHelper);
                            if (readnigId != -1)
                            {
                                surveyReadingModel = new SurveyReadingModel();
                                result = GetSurveyReadingDetails(surveyId, readnigId, ref surveyReadingModel);
                                if (result == GlobalErrors.Success)
                                {
                                    result = GetAddedItemsData(surveyReadingModel.FilledItems, ref appliedItems);
                                }
                                if (result == GlobalErrors.Success && appliedItems != null && appliedItems.Count > 0)
                                {
                                    surveyReadingModel.AppliedItems = appliedItems;
                                    surveyModel.AppliedItems = appliedItems;
                                    surveyModel.SurveyReadingModel = surveyReadingModel;
                                }
                            }
                            else
                            {
                                // Items
                                appliedItems = new List<ItemPackModel>();
                                result = GetSurveyItems(surveyId, warehouseId, readnigId, ref appliedItems);
                                if (result == GlobalErrors.Success)
                                    surveyModel.AppliedItems = appliedItems;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQualityControlReading(SurveyReadingModel surveyReadingModel, DBHelper<int> dBHelper)
        {
             GlobalErrors result = GlobalErrors.NotInitialized;
            string itemIDsString = string.Empty;
            try
            {
                itemIDsString = string.Join(",", surveyReadingModel.AppliedItems.Select(x => x.ItemId).ToArray());
                surveyReadingModel.FilledItems = itemIDsString;
                switch ((SurveyPeriodTypes)surveyReadingModel.SurveyPeriodTypeId)
                {
                    case SurveyPeriodTypes.Daily:
                        surveyReadingModel.ValidTo = surveyReadingModel.StartDateModel.Date.AddDays(1);
                        break;
                    case SurveyPeriodTypes.Weekly:
                        surveyReadingModel.ValidTo = surveyReadingModel.StartDateModel.Date.AddDays(6);
                        break;
                    case SurveyPeriodTypes.Monthly:
                        //surveyReadingModel.ValidTo = surveyReadingModel.StartDateModel.Date.AddMonths(1);
                        surveyReadingModel.ValidTo = GetLastDayOfMonth(surveyReadingModel.StartDateModel.Date);
                        break;
                    case SurveyPeriodTypes.Yearly:
                        // surveyReadingModel.ValidTo = surveyReadingModel.StartDateModel.Date.AddYears(1);
                        surveyReadingModel.ValidTo = GetLastDayOfYear(surveyReadingModel.StartDateModel.Date);
                        break;
                }
                string query = string.Format(@"insert into QualityControlReading (SurveyID,WarehouseID,VehicleID,DamagedWarehouseID, InspectorID,FilledItems,AllItems,IsCompletelyFilled, StartDate,EndDate,ValidTo) 
                 values ({0},{1},{2},{3},{4},'{5}',{6},{7},{8},{9},{10})",
                surveyReadingModel.SurveyId, //0
                surveyReadingModel.WarehouseId, //1
                surveyReadingModel.VehicleId, //2
                surveyReadingModel.DamagedWarehouseId, //3
                _requestRepository.CurrentOperator.EmployeeId,//4
                surveyReadingModel.FilledItems, //5
                surveyReadingModel.AllItems ? "1" : "0", //6
                surveyReadingModel.IsCompletelyFilled ? "1" : "0", //7
                LocalUtilities.ParseDateAndTimeToSQL(surveyReadingModel.StartDateModel.Date),//8
                LocalUtilities.ParseDateAndTimeToSQL(surveyReadingModel.EndDateModel.Date),//9
                LocalUtilities.ParseDateAndTimeToSQL(surveyReadingModel.ValidToModel.Date)//10
                );
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    foreach (SurveyReadingDetailsModel answer in surveyReadingModel.FieldsAnswers)
                    {
                        result = SaveQualityControlReadingDetails(answer, dBHelper);
                        if (result != GlobalErrors.Success)
                            break;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQualityControlReadingDetails(SurveyReadingDetailsModel surveyReadingDetailsModel, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (ItemPackModel itemPackModel in surveyReadingDetailsModel.AppliedItems)
                {
                    string query = string.Format(@"insert into QualityControlReadingDetails (ReadingID,SurveyID,ItemID,FieldID,FieldTypeID, LOVID, FieldValue, ReadingDate) values ((select Max(ReadingID) from QualityControlReading),{0},{1},{2},{3},{4},'{5}',{6})",
                    surveyReadingDetailsModel.SurveyId, itemPackModel.ItemId, surveyReadingDetailsModel.FieldId, surveyReadingDetailsModel.FieldTypeId, surveyReadingDetailsModel.LOVId,
                    (surveyReadingDetailsModel.FieldTypeId == 3 ? (surveyReadingDetailsModel.DateValueModel != null ? surveyReadingDetailsModel.DateValueModel.Date.ToShortDateString().Replace("'", "''") : null) :
                    ((surveyReadingDetailsModel.FieldTypeId == 7 ? (surveyReadingDetailsModel.DateValueModel != null ? surveyReadingDetailsModel.DateValueModel.Date.ToShortTimeString().ToString().Replace("'", "''") : null) : surveyReadingDetailsModel.FieldValue.Replace("'", "''")))), LocalUtilities.ParseDateToSQLString(DateTime.Now));
                    result = dBHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success)
                        break;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public string PrepareWarehouseTransactionHeaderString(int ReadingID, string transactionId, int warehouseId, int divisionId, int organizationId, WarehouseTransactionType type, WarehouseTransactionOperation operation,
           int supervisorId, int helperId, int salesManagerId, int driverId, int salesRepId)
        {
            string query = string.Empty;
            try
            {
                string refWarehouseSelection = string.Empty;
                if (operation == WarehouseTransactionOperation.TransferOut)
                {
                    refWarehouseSelection = string.Format(@"(select IsNull(max(DamagedWarehouseID),-1)DamagedWarehouseID from(
                    select max(DestinationWarehouseID) DamagedWarehouseID, SourceWarehouseID
                    from WarehouseSourceDestination
                    inner join Warehouse on Warehouse.WarehouseID = WarehouseSourceDestination.DestinationWarehouseID
                    Where SourceWarehouseID = {0} and Warehouse.WarehouseTypeID = {1}
                    group by SourceWarehouseID)tt)",
                    warehouseId,
                    WarehouseType.DamagedWarehouse.GetHashCode() // Damaged
                    );
                }
                else if (operation == WarehouseTransactionOperation.Offload)
                {
                    refWarehouseSelection = string.Format(@"(select IsNull(max(DamagedWarehouseID),-1)DamagedWarehouseID  from (
                    select max(WarehouseID)DamagedWarehouseID
                    from VehicleDamagedWh
                    where VehicleID = {0}
                    group by VehicleID)tt)",
                    warehouseId
                    );
                }

                query = string.Format(@" ('{0}', {1}, {2}, {3}, {4}, {5}, {6}, {7}, {8}, {9}, {10}, {11}, {12}, {13}, {14}, {15}, {16}, {17}, {18}, {19}, {20}, {21}, {22}, {23}, {24}, {25},{26}) ",
                transactionId, //0
                warehouseId, //1
                divisionId, //2  divisionId
                type.GetHashCode(), //3
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //4
                _requestRepository.CurrentOperator.EmployeeId, //5
                _requestRepository.CurrentOperator.EmployeeId, //6
                0, //7 Synchronized
                0, //8 Posted
                LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), //9
                "Null", // Notes 10
                WarehouseTransactionStatus.Approved.GetHashCode(), //11
                CreationSource.SonicWeb.GetHashCode(), //12
                WarehouseTransactionCreationReason.Normal.GetHashCode(), //13
                operation.GetHashCode(), //14
                -1, //15 RouteHistoryID
                supervisorId == -1 ? "NULL" : supervisorId.ToString(), //16
                helperId == -1 ? "NULL" : helperId.ToString(), //17
                salesManagerId == -1 ? "NULL" : salesManagerId.ToString(), //18
                "NULL", //19 source trans
                 "NULL", //20 load date
                organizationId, //21 warehouse
                driverId == -1 ? "NULL" : driverId.ToString(), //22
                salesRepId == -1 ? "NULL" : salesRepId.ToString(), //23
                refWarehouseSelection, //24 RefwarehouseId
                1, // 25 Downloaded
                ReadingID //26
                );
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return string.Empty;
            }
            return query;
        }
        public GlobalErrors SaveWarehouseTransactionHeader(string values, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"insert into WarehouseTransaction(TransactionId,WarehouseID,DivisionID,TransactionTypeID,TransactionDate,
                RequestedBy,ImplementedBy,Synchronized,Posted,ProductionDate,Notes,WarehouseTransactionStatusID,CreationSourceID,
                CreationReason,TransactionOperationID,RouteHistoryID,supervisorID,helperID,SalesManagerID ,SourceTransactionID,LoadDate,OrganizationID,
                DriverID,SalesRepID,RefWarehouseID,Downloaded,ReadingID) values {0}", values);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveWarehouseTransactionsDetails(int readingID, string items, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string divisionFilter = string.Empty;
            string selectFilter = string.Empty;
            string groupByFilter = string.Empty;
            string groupByBatchNo = string.Empty;
            string groupByExpiryDate = string.Empty;
            bool defaultBatchExpiryDate = false;
            try
            {
                if (_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems && !_requestRepository.Configurations.AllowBatchSelectionInWarehouseOperations)
                {
                    defaultBatchExpiryDate = true;
                }
                if (!defaultBatchExpiryDate)
                {
                    groupByBatchNo = " ,WarehouseStock.BatchNo";
                    groupByExpiryDate = " ,WarehouseStock.ExpiryDate";
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionFilter = " and WT.DivisionID = ItemCategory.DivisionID ";
                }
                selectFilter = string.Format(" ,{0} as BatchNo , {1} as ExpiryDate,sum(WarehouseStock.Quantity) ,sum(WarehouseStock.Quantity), sum(WarehouseStock.Quantity)", defaultBatchExpiryDate ? "'" + LocalUtilities.DefaultBatchNo + "'" : "WarehouseStock.BatchNo", defaultBatchExpiryDate ? "'" + LocalUtilities.DefaultExpiryDate.ToString() + "'" : "WarehouseStock.ExpiryDate");
                groupByFilter = string.Format(" group by WT.TransactionID, WT.WarehouseID, WT.DivisionID,  WarehouseStock.PackID {0} {1}", groupByBatchNo, groupByExpiryDate);

                string query = string.Format(@"Insert into WhTransDetail (TransactionID, WarehouseID, DivisionID, ZoneID, PackID, BatchNo, ExpiryDate, Quantity, RequestedQuantity, ApprovedQuantity, PackStatusID)
                Select WT.TransactionID, WT.WarehouseID, WT.DivisionID, 1 as ZoneID, WarehouseStock.PackID  {4}, {2} as PackStatusId
                From WarehouseStock
                inner join Pack on Pack.PackID = WarehouseStock.PackID
                inner join Item on Pack.ItemID = Item.ItemID
                inner join ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID
                inner join WarehouseTransaction WT on WT.WarehouseID = WarehouseStock.WarehouseID {3}
                Where WT.ReadingId = {0} and Item.ItemID in ({1})
                 {5}
                having sum(WarehouseStock.Quantity) > 0",
                readingID,//0
                items, //1
                PackStatus.None.GetHashCode(), //2  
                divisionFilter,//3
                selectFilter, //4
                groupByFilter //5
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ReserveQCTransactionStockAndSerials(SurveyReadingModel surveyReadingModel, string itemIDs, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string statusIDsFilter = string.Empty;
            int warehouseID = -1;
            try
            {
                if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.Offload.GetHashCode())
                {
                    statusIDsFilter = string.Format(" and SerialStatusID in ({0},{1},{2}) and VehicleID = {3}", SerialStatus.LoaddedInVehicle.GetHashCode(), SerialStatus.ReturnedFromCustomer.GetHashCode(), SerialStatus.BackToStore.GetHashCode(), surveyReadingModel.VehicleId);
                    warehouseID = surveyReadingModel.VehicleId;
                }
                if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.TransferOut.GetHashCode())
                {
                    statusIDsFilter = string.Format(" and SerialStatusID in ({0},{1},{2},{3}) and WarehouseID = {4}", SerialStatus.OffloadedToWarehouse.GetHashCode(), SerialStatus.LoadedToMainWarehouse.GetHashCode(), SerialStatus.InTranset.GetHashCode(), SerialStatus.BackToStoreOffload.GetHashCode(), surveyReadingModel.WarehouseId);
                    warehouseID = surveyReadingModel.WarehouseId;
                }
                string query = string.Format(@"UPDATE SerialCurrentStatus set IsReserved = 1 where FromSerial in (
                Select FromSerial From SerialCurrentStatus
                where packid in (select packid from pack where itemid in ({0}) {1} ))", itemIDs, statusIDsFilter);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }

                // This query will update recall task stock according to inserted batches :
                query = string.Format(@"Update WarehouseStock set IsReserved = 1 
                where packid in (select packid from pack where itemid in ({0}) ) and warehouseid = {1}", itemIDs, warehouseID);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetRecieversEmails(SurveyReadingModel surveyReadingModel, ref List<string> recieversEmails)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<string> dbHelper = new DBHelper<string>();
            string query = string.Empty;
            recieversEmails = new List<string>();
            try
            {
                // Send Email to Warehouse Store Keeper or Vehicle Employee
                if (surveyReadingModel.WarehouseTransactionOperationId == WarehouseTransactionOperation.Offload.GetHashCode())
                {
                    query = string.Format(@"Select Email from Employee
                                    Inner Join EmployeeVehicle on EmployeeVehicle.EmployeeID = Employee.EmployeeID 
                                    Where EmployeeVehicle.VehicleID = {0}", surveyReadingModel.VehicleId);
                }
                else
                {
                    query = string.Format(@"Select Email from Employee
                                    Inner Join WarehouseStoreKeeper on WarehouseStoreKeeper.EmployeeID = Employee.EmployeeID 
                                    Where WarehouseStoreKeeper.WarehouseID = {0}", surveyReadingModel.WarehouseId != -1 ? surveyReadingModel.WarehouseId : surveyReadingModel.DamagedWarehouseId);
                }
                result = dbHelper.GetQueryList(query, ref recieversEmails);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static DateTime GetLastDayOfMonth(DateTime dtDate)
        {

            // set return value to the last day of the month
            // for any date passed in to the method
            // create a datetime variable set to the passed in date
            DateTime dtTo = dtDate;
            // overshoot the date by a month
            dtTo = dtTo.AddMonths(1);
            // remove all of the days in the next month
            // to get bumped down to the last day of the
            // previous month
            dtTo = dtTo.AddDays(-(dtTo.Day));
            // return the last day of the month
            return dtTo;

        }
        public static DateTime GetLastDayOfYear(DateTime dtDate)
        {
            DateTime n = new DateTime(dtDate.Year + 1, 1, 1);
            return n.AddDays(-1);

        }
        public GlobalErrors GetAppliedSurveyOrganizations(int surveyId, ref List<OrganizationModel> appliedOrganizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM SurveyOrganization
                inner join Organization on Organization.OrganizationID = SurveyOrganization.OrganizationID
                left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                where SurveyOrganization.SurveyID = {1} and SurveyOrganization.OrganizationID in ({2})",
                _requestRepository.LanguageId,
                surveyId,
                _requestRepository.CurrentOperator.OrganizationAccess
                );
                result = dbHelper.GetQueryList(query, ref appliedOrganizations);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedOrganizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyOrganization(int organizationId, ref List<OrganizationModel> appliedOrganizations)
        {
            DBHelper<OrganizationModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                dbHelper = new DBHelper<OrganizationModel>();
                string query = string.Format(@"SELECT distinct Organization.OrganizationID ,Organization.OrganizationCode, OrganizationLanguage.Description OrganizationName, Organization.IsRootOrganization, 
                IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationCodeName
                FROM Organization
                left outer join OrganizationLanguage on Organization.OrganizationID = OrganizationLanguage.OrganizationID and OrganizationLanguage.LanguageID = {0}
                where Organization.OrganizationID = {1}",
                _requestRepository.LanguageId,
                organizationId
                );
                result = dbHelper.GetQueryList(query, ref appliedOrganizations);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                appliedOrganizations = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ExecuteCloneSurveyProcedure(int surveyId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<string> dBHelper = new DBHelper<string>();
                Dictionary<string, object> inputParamters = new Dictionary<string, object>();
                Dictionary<string, object> outputParamters = new Dictionary<string, object>();
                Dictionary<string, object> resultParameters = new Dictionary<string, object>();
                object field = null;
                string storedProcedureName = "SP_Web_CloneSurvey";
                inputParamters.Add("@CopiedSurveyID", surveyId);
                outputParamters.Add("@Result", 0);
                string query = string.Format(@"if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].{0}') 
                        and OBJECTPROPERTY(id, N'IsProcedure') = 1) select x='1'", storedProcedureName);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && !string.IsNullOrEmpty(field.ToString()) && (field.ToString() == "1"))
                {
                    result = dBHelper.ExecuteProcedureWithParameters(storedProcedureName, inputParamters, outputParamters, ref resultParameters, 0);
                    //1 : Success else failed
                    if (resultParameters != null && resultParameters.ContainsKey("@Result") && int.Parse(resultParameters["@Result"].ToString()) == 1)
                        result = GlobalErrors.Success;
                    else
                    result = GlobalErrors.Error;
                }
                else result = GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #region [ECHO]
        public GlobalErrors GetCustomerSurveyList(ref List<SurveyModel> surveyList, bool isAfterSaveOrder = false)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string afterBeforSaveOrderSaveFilter = "";
            string selectionFilter = "";
            try
            {
                DBHelper<SurveyModel> dBHelper = new DBHelper<SurveyModel>();
                //if (isAfterSaveOrder)
                //{
                //    afterBeforSaveOrderSaveFilter = "and Survey.IsEchoOpenAfterSaveOrder = 1 ";
                //    selectionFilter = " Top (1) ";
                //}
                //else
                //{
                //    afterBeforSaveOrderSaveFilter = " and (Survey.IsEchoOpenAfterSaveOrder is null or Survey.IsEchoOpenAfterSaveOrder = 0)";
                //    selectionFilter = "";
                //}
                string query = string.Format(@"select distinct {5} Survey.*,SurveyLanguage.Description SurveyName,SurveyParentlanguage.Description GroupName
                                ,CASE WHEN SurveyCustomerHistory.SurveyID IS NULL THEN 0 ELSE 1 end  isFilled from survey
                                Left join SurveyLanguage on Survey.SurveyID=SurveyLanguage.SurveyID and SurveyLanguage.LanguageID= {0}
                                left outer join SurveyCustomer on SurveyCustomer.SurveyID=Survey.SurveyID  AND SurveyCustomer.CustomerID = {1} AND SurveyCustomer.OutletID = {2} 
                                left outer join  
                                (select  SurveyChannel.SurveyID, SurveyChannel.ChannelID
                                from SurveyChannel
                                inner join CustomerGroup on CustomerGroup.ChannelID = SurveyChannel.ChannelID and CustomerGroup.SubChannelID = SurveyChannel.SubChannelID
                                inner join CustomerOutletGroup COG on COG.GroupID = CustomerGroup.GroupID 
                                where COG.CustomerID = {1} and COG.OutletID = {2}) SC ON SC.SurveyID = Survey.SurveyID 
                                left outer join SurveyGroup on SurveyGroup.SurveyID = Survey.SurveyID and SurveyGroup.GroupID in (SELECT GroupID from CustomerOutletGroup where CustomerID = {1} and OutletID = {2})
                                left outer join SurveyCustomerHistory on SurveyCustomerHistory.SurveyID =Survey.SurveyID  AND SurveyCustomerHistory.CustomerID = {1} AND SurveyCustomerHistory.OutletID = {2}
                                left join SurveyParentlanguage on SurveyParentlanguage.ParentId =Survey.ParentId  AND SurveyParentlanguage.LanguageId = {0}
                                inner join SurveyOrganization on SurveyOrganization.SurveyID = Survey.SurveyID and SurveyOrganization.OrganizationID in ({6})
                                where ValidFrom <= {3} AND ValidTo >= {3} AND Survey.InActive=0 and Survey.SurveyTypeID=6 
                                and (Survey.AllCustomers =1 or SurveyCustomer.CustomerID is not null or SC.ChannelID is not null or SurveyGroup.GroupID is not null) 
                                AND SurveyCustomerHistory.SurveyID IS NULL
                                {4}
                                order by Survey.SurveyID Desc"
                                , _requestRepository.LanguageId, //0
                                _requestRepository.CurrentEchoOperator.CustomerId, //1
                                _requestRepository.CurrentEchoOperator.OutletId, //2
                                LocalUtilities.ParseDateToSQLString(DateTime.Now), //3
                                afterBeforSaveOrderSaveFilter, //4
                                selectionFilter, //5
                                _requestRepository.CurrentOperator.OrganizationId //6
                                );
                result = dBHelper.GetQueryList(query, ref surveyList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerSurveyQuestions(int surveyId, ref List<QuestionModel> questions, ref List<LOVModel> questionOptions)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<QuestionModel> dBHelper = new DBHelper<QuestionModel>();

                string query = string.Format(@"select Field.FieldID, Field.LOVID , Field.FieldTypeID, Field.FieldSubTypeID, FieldSubTypeLanguage.Description
                        , FieldLanguage.Description QuestionBody, Field.IsMandatory
                        from Survey
                        inner join Field on Field.DCFID = Survey.DCFID
                        inner join FieldLanguage on FieldLanguage.FieldID = Field.FieldID and FieldLanguage.LanguageID = {1}
                        left join FieldSubTypeLanguage on FieldSubTypeLanguage.FieldTypeID = Field.FieldTypeID and Field.FieldSubTypeID = FieldSubTypeLanguage.FieldSubTypeID and FieldSubTypeLanguage.LanguageID = {1}
                        where Survey.SurveyID = {0}
                        order by Sequence", surveyId, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref questions);
                if (result == GlobalErrors.Success && questions != null && questions.FindAll(q => (q.FieldTypeID == 5 || q.FieldTypeID == 6)).Count > 0)
                {
                    result = GetQuestionOptions(surveyId, ref questionOptions);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        private GlobalErrors GetQuestionOptions(int surveyId, ref List<LOVModel> options)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<LOVModel> dBHelper = new DBHelper<LOVModel>();

                string query = string.Format(@"select Field.FieldID, LOVOption.LOVID, LOVOption.LOVOptionID, LOVOptionLanguage.Description LOVName
                                                from LOVOption 
                                                inner join Field on LOVOption.LOVID = Field.LOVID 
                                                inner join Survey on Survey.DCFID = Field.DCFID
                                                left join LOVOptionLanguage  on LOVOptionLanguage.LOVOptionID = LOVOption.LOVOptionID and LOVOptionLanguage.LanguageID = {1}
                                                where Survey.surveyId = {0} order by Sequence", surveyId, _requestRepository.LanguageId);
                result = dBHelper.GetQueryList(query, ref options);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveQuestionAnswers(List<AnswerModel> surveyAnswers, string rootPath)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<int> dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                int readingId = -1;
                result = GetMaxReadingId(ref readingId, dbHelper);
                if (result == GlobalErrors.Success)
                {

                    string query = string.Format(@"INSERT INTO Reading(ReadingID,DCFID,EmployeeID,ReadingDate,Status,RouteHistoryID,Downloaded,GPSLongitude,GPSLatitude) 
                                                   VALUES ({0},{1},{3},{2},1,-1,1,NULL,NULL)"
                                                , readingId, surveyAnswers[0].DCFID, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), _requestRepository.CurrentEchoOperator.RouteEmployeeId);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        string surveyFolderName = "";
                        string custOut = _requestRepository.CurrentEchoOperator.CustomerId + "_" + _requestRepository.CurrentEchoOperator.OutletId;

                        foreach (AnswerModel answer in surveyAnswers)
                        {
                            string fieldValue = "";
                            if (answer.FieldTypeID == FieldTypes.CheckList.GetHashCode())
                            {
                                string[] options = answer.AnswerName.Split(',');
                                foreach (string option in options)
                                {
                                    query = string.Format(@"INSERT INTO CustomerAppSurveyReading (FieldID,ReadingID,LOVID,FieldTypeID,FieldValue) 
                                               VALUES ({0},{1},{2},{3},{4})"
                                              , answer.AnswerID
                                              , readingId
                                              , answer.LOVID.ToString()
                                              , answer.FieldTypeID
                                              , option == "" ? "-1" : option);
                                    result = dbHelper.ExecuteNonQuery(query);
                                    if (result != GlobalErrors.Success) break;
                                }
                                continue;
                            }

                            if (answer.FieldTypeID == FieldTypes.Image.GetHashCode())
                            {
                                surveyFolderName = "Echo\\Surveys\\" + surveyAnswers[0].SurveyID + "\\" + custOut + "\\" + answer.AnswerID;
                                fieldValue = Path.Combine(rootPath, "wwwroot", surveyFolderName);
                            }
                            else if (!string.IsNullOrEmpty(answer.AnswerName))
                            {
                                if (answer.FieldTypeID == FieldTypes.Date.GetHashCode())
                                    fieldValue = LocalUtilities.ParseDateToSQLString(DateTime.ParseExact(answer.AnswerName, "dd/MM/yyyy", CultureInfo.InvariantCulture));
                                else if (answer.FieldTypeID == FieldTypes.Time.GetHashCode())
                                    fieldValue = (DateTime.Parse(answer.AnswerName).ToString("hh:mm tt"));
                                else
                                    fieldValue = answer.AnswerName.Replace("'", "''");
                            }
                            query = string.Format(@"INSERT INTO CustomerAppSurveyReading (FieldID,ReadingID,LOVID,FieldTypeID,FieldValue) 
                                               VALUES ({0},{1},{2},{3},{4})"
                                           , answer.AnswerID
                                           , readingId
                                           , answer.LOVID != -1 ? answer.LOVID.ToString() : "NULL"
                                           , answer.FieldTypeID
                                           , answer.FieldTypeID == FieldTypes.Date.GetHashCode() && !string.IsNullOrEmpty(answer.AnswerName) ? fieldValue : "'" + fieldValue + "'");
                            result = dbHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success) break;
                        }
                        if (result == GlobalErrors.Success)
                        {
                            query = string.Format(@"INSERT INTO SurveyCustomerHistory (SurveyID,SurveyFillTypeID,EmployeeID,CustomerID,OutletID,ReadingID,RouteHistoryID,SurveyAssignmentID,UniqueID,StartFillingTime,EndFillingTime,GPSLatitude,GPSLongitude) 
                                                    VALUES ({0} ,1 ,{6} ,{1} ,{2} ,{3} ,-1 ,1 ,NULL ,{4} ,{5},0,0)"
                                                    , surveyAnswers[0].SurveyID, _requestRepository.CurrentEchoOperator.CustomerId, _requestRepository.CurrentEchoOperator.OutletId
                                                    , readingId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), _requestRepository.CurrentEchoOperator.RouteEmployeeId);
                            result = dbHelper.ExecuteNonQuery(query);
                        }
                        if (result == GlobalErrors.Success)
                        {
                            object field = null;
                            query = string.Format(@"Select Points From Survey where SurveyId = {0}", surveyAnswers[0].SurveyID);
                            result = dbHelper.ExecuteScalar(query, ref field);
                            if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && decimal.Parse(field.ToString()) > 0)
                            {
                                _orderManager.UpdateCustomersPoints(surveyAnswers[0].SurveyID.ToString(), CustomerPointsAction.Survey, decimal.Parse(field.ToString()), dbHelper);
                            }

                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public static GlobalErrors GetMaxReadingId(ref int maxReadingId, DBHelper<int> dBHelper)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"select isnull(max(ReadingID)+1, 1) from Reading (nolock) where RouteHistoryID = -1");
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && Int32.Parse(field.ToString()) > 0)
                {
                    maxReadingId = Int32.Parse(field.ToString());
                }
                else
                    maxReadingId = -1;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion
        public GlobalErrors GetLinkedToPromotionSurveys(int promotionId, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string promotionIDFilter = string.Empty;
            try
            {
                DBHelper<SurveyModel> dBHelper = new DBHelper<SurveyModel>();
                if (promotionId != -1)
                    promotionIDFilter = string.Format(" and Promotion.PromotionID <> {0} ", promotionId);
                string query = string.Format(@"select distinct Survey.SurveyID, SurveyLanguage.Description as SurveyName
                from Survey
                Inner join SurveyLanguage on Survey.SurveyID = SurveyLanguage.SurveyID and SurveyLanguage.LanguageID = {0} 
                Inner join SurveyOrganization on Survey.SurveyID = SurveyOrganization.SurveyID and SurveyOrganization.OrganizationID in ({1})
                left Join Promotion on Promotion.SurveyID = Survey.SurveyID {2} and Promotion.IsDeleted <> 1
                Where LinkedToProm = 1 and Survey.Inactive <> 1 and Promotion.SurveyID is null ", _requestRepository.LanguageId, _requestRepository.CurrentOperator.OrganizationAccess, promotionIDFilter);
                result = dBHelper.GetQueryList(query, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveys(int surveyTypeId, ref List<SurveyModel> surveys)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<SurveyModel> dBHelper = new DBHelper<SurveyModel>();
                string query = $@"Select Survey.SurveyID, SurveyLanguage.Description SurveyName From Survey 
                left join SurveyLanguage on SurveyLanguage.SurveyID = Survey.SurveyID and SurveyLanguage.LanguageID = {_requestRepository.LanguageId}
                where SurveyTypeID = {surveyTypeId} and Survey.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) and IsNull(Survey.InActive,0) = 0";
                
                result = dBHelper.GetQueryList(query, ref surveys);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public List<CreditReleaseAssignmentModel> FillCustomerOrganizationIdsAsList(List<CreditReleaseAssignmentModel> customersList, bool fillOrganizationIdsList, bool fillSDCIdsList)
        {
            List<CreditReleaseAssignmentModel> customersWithOrgIdsString = new List<CreditReleaseAssignmentModel>();
            try
            {
                customersWithOrgIdsString = customersList.GroupBy(c => new { c.CustomerId, c.OutletId }
                                 ).Select(grp => new CreditReleaseAssignmentModel
                                 {
                                     CustomerId = grp.Key.CustomerId,
                                     OutletId = grp.Key.OutletId,
                                     CustomerCode = grp.FirstOrDefault().CustomerCode,
                                     OutletCode = grp.FirstOrDefault().OutletCode,
                                     OutletName = grp.FirstOrDefault().OutletName,
                                     CustomerCodeName = grp.FirstOrDefault().CustomerCodeName,
                                     OutletCodeName = grp.FirstOrDefault().OutletCodeName,
                                     OrganizationIdsList = fillOrganizationIdsList ? grp.Select(co => co.OrganizationId).ToList() : new List<int>(),
                                 }).ToList();
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
            return customersWithOrgIdsString;
        }
        #region [Survey Images screens]
        public GlobalErrors GetSurveyCustomerImagesSharedTable(SurveyReportFilterModel filter, bool isExportMode, ref SharedTableResult<SurveyReportModel> surveyList, ref List<dynamic> reportData)
        {
            surveyList = new SharedTableResult<SurveyReportModel>();
            List<SurveyReportModel> list = new List<SurveyReportModel>();
            DBHelper<SurveyReportModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<SurveyReportModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( C.CustomerCode LIKE '%{0}%')
                        OR ( CL.Description LIKE '%{0}%' )
                        OR ( CO.CustomerCode LIKE '%{0}%' )
                        OR ( COL.Description LIKE '%{0}%' )
                        OR ( E.EmployeeCode LIKE '%{0}%' ) 
                        OR ( EL.Description LIKE '%{0}%' )
                        OR ( SL.Description LIKE '%{0}%' )
                        OR ( FL.Description LIKE '%{0}%' ))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.SurveyId != -1)
                    {
                        searchFilter += string.Format(" And (S.SurveyId = {0})", filter.SurveyId);
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += string.Format(" And (E.EmployeeID = {0})", filter.EmployeeId);
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(" And (CO.CustomerID= {0}) ", filter.CustomerId);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(" And (CO.OutletID= {0}) ", filter.OutletId);
                    }
                    if (filter.ReadingDateRange != null && filter.ReadingDateRange.Count == 2)
                    {
                        searchFilter += string.Format(" And (R.ReadingDate >= {0} and R.ReadingDate <= {1}) ",
                        LocalUtilities.ParseDateToSQLString(new DateTime(filter.ReadingDateRange[0].Year, filter.ReadingDateRange[0].Month, filter.ReadingDateRange[0].Day)),
                        LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.ReadingDateRange[1].Year, filter.ReadingDateRange[1].Month, filter.ReadingDateRange[1].Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"ORDER BY R.ReadingDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"ORDER BY {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                string mainQuery = $@" select distinct SL.Description as SurveyName , FL.Description as QuestionName,
                IsNull( E.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EL.Description , '--') as EmployeeCodeName,
                IsNull( C.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CL.Description , '--') as CustomerCodeName,
                IsNull( CO.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( COL.Description , '--') as OutletCodeName,
                E.EmployeeId, CO.CustomerId, CO.OutletId, S.SurveyId, R.ReadingDate,R.ReadingId,

                '{LocalUtilities.FOImagesURL}'+RH.DeviceSerial+'_'+Convert(nvarchar(max),RH.RouteHistoryID)+'/SurveyImages/'+
                'Cust' + '_' + convert(nvarchar,sch.CustomerID) + '_' + convert(nvarchar,sch.OutletID) + '_' + convert(nvarchar,sch.SurveyID) + '_' +
                convert(nvarchar,fvi.FieldID) + '_' + convert(nvarchar,sch.ReadingID) + '_' + convert(nvarchar,fvi.ImageID) + '_' +convert(nvarchar, fvi.RouteHistoryID) + '_' + 'SurveyImage.jpg' as ImagePath
                from FieldValueImages FVI 
                inner join Reading R on FVI.ReadingID = R.ReadingID and FVI.RouteHistoryID = R.RouteHistoryID
                inner join SurveyCustomerHistory sch on sch.ReadingID = R.ReadingID and sch.EmployeeID = R.EmployeeID and sch.RouteHistoryID = R.RouteHistoryID
                inner join Survey S on S.SurveyID = sch.SurveyID
                inner join SurveyOrganization SO on SO.SurveyID = S.SurveyID
                left join SurveyLanguage SL on SL.SurveyID = sch.SurveyID and SL.LanguageID = {_requestRepository.LanguageId}
                inner join Customer C on C.CustomerID = sch.CustomerID
                left join CustomerLanguage CL on CL.CustomerID = c.CustomerID and CL.LanguageID = {_requestRepository.LanguageId}
                inner join CustomerOutlet CO on CO.CustomerID = sch.CustomerID and CO.OutletID = sch.OutletID
                left join CustomerOutletLanguage COL on CO.CustomerID = COL.CustomerID and CO.OutletID = COL.OutletID and COL.LanguageID = {_requestRepository.LanguageId}
                inner join FieldLanguage FL on FL.FieldID = FVI.FieldID and FL.LanguageID = {_requestRepository.LanguageId}
                inner join Employee E on E.EmployeeID = R.EmployeeID
                left join EmployeeLanguage EL on EL.EmployeeID = R.EmployeeID and EL.LanguageID = {_requestRepository.LanguageId}
                inner join RouteHistory RH on RH.RouteHistoryID = FVI.RouteHistoryID
                where IsNull(S.Inactive,0) = 0 and SO.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) {searchFilter}";
                
                // list query
                string listQuery = string.Empty;
                if (isExportMode)
                {
                    DBHelper<dynamic> dbHelperDynamic = new DBHelper<dynamic>();

                    listQuery = string.Format(@" {0} {1} ",
                    mainQuery, //0
                    orderByFilter //1
                    );

                    result = dbHelperDynamic.GetQueryList(listQuery, ref reportData);
                }
                if (!isExportMode)
                {
                    listQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                    mainQuery, //0
                    orderByFilter, //1
                    filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                    filter.CustomListFilter.PageSize //3
                    );

                    string countQuery = string.Format(@"Select IsNull(Count(*),0) from ({0}) tt", mainQuery);
                    object objField = 0;
                    result = dbHelper.ExecuteScalar(countQuery, ref objField);
                    if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                    {
                        surveyList.TotalItems = int.Parse(objField.ToString().Trim());
                        if (surveyList.TotalItems <= 0)
                        {
                            surveyList.Data = list;
                            return GlobalErrors.Success;
                        }
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                    result = dbHelper.GetQueryList(listQuery, ref list);
                    surveyList.Data = surveyList.Data = list;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                surveyList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSurveyEmployeeImagesSharedTable(SurveyReportFilterModel filter, bool isExportMode, ref SharedTableResult<SurveyReportModel> surveyList, ref List<dynamic> reportData)
        {
            surveyList = new SharedTableResult<SurveyReportModel>();
            List<SurveyReportModel> list = new List<SurveyReportModel>();
            DBHelper<SurveyReportModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;

            try
            {
                dbHelper = new DBHelper<SurveyReportModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( 
                        ( C.CustomerCode LIKE '%{0}%')
                        OR ( CL.Description LIKE '%{0}%' )
                        OR ( CO.CustomerCode LIKE '%{0}%' )
                        OR ( COL.Description LIKE '%{0}%' )
                        OR ( E.EmployeeCode LIKE '%{0}%' ) 
                        OR ( EL.Description LIKE '%{0}%' )
                        OR ( SL.Description LIKE '%{0}%' )
                        OR ( FL.Description LIKE '%{0}%' ))", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.SurveyId != -1)
                    {
                        searchFilter += string.Format(" And (S.SurveyId = {0})", filter.SurveyId);
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += string.Format(" And (E.EmployeeID = {0})", filter.EmployeeId);
                    }
                    if (filter.ReadingDateRange != null && filter.ReadingDateRange.Count == 2)
                    {
                        searchFilter += string.Format(" And (R.ReadingDate >= {0} and R.ReadingDate <= {1}) ",
                        LocalUtilities.ParseDateToSQLString(new DateTime(filter.ReadingDateRange[0].Year, filter.ReadingDateRange[0].Month, filter.ReadingDateRange[0].Day)),
                        LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.ReadingDateRange[1].Year, filter.ReadingDateRange[1].Month, filter.ReadingDateRange[1].Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"ORDER BY R.ReadingDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"ORDER BY {0} {1} ",
                        filter.CustomListFilter.SortBy,
                        filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                string mainQuery = $@" select distinct SL.Description as SurveyName , FL.Description as QuestionName,
                IsNull( E.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EL.Description , '--') as EmployeeCodeName,
                E.EmployeeId, S.SurveyId, R.ReadingDate,r.ReadingId,
                '{LocalUtilities.FOImagesURL}'+'/'+RH.DeviceSerial+'_'+Convert(nvarchar(max),RH.RouteHistoryID)+'/SurveyImages/'+
                'Emp' + '_' + convert(nvarchar, EL.EmployeeID) + '_' + convert(nvarchar,sch.SurveyID)+ '_' +
                convert(nvarchar,fvi.FieldID) + '_' + convert(nvarchar,r.ReadingID) + '_' + convert(nvarchar,sch.UniqueID) +'_'+
                convert(nvarchar,fvi.ImageID) + '_' + convert(nvarchar,rh.RouteHistoryID) + '_' + 'SurveyImage.jpg' as ImagePath

                from FieldValueImages FVI 
                inner join Reading R on FVI.ReadingID = R.ReadingID and FVI.RouteHistoryID = R.RouteHistoryID
                inner join SurveyEmployeeHistory sch on sch.ReadingID = R.ReadingID and sch.EmployeeID = R.EmployeeID and sch.RouteHistoryID = R.RouteHistoryID
                inner join Survey S on S.SurveyID = sch.SurveyID
                inner join SurveyOrganization SO on SO.SurveyID = S.SurveyID
                left join SurveyLanguage SL on SL.SurveyID = sch.SurveyID and SL.LanguageID = {_requestRepository.LanguageId}
                inner join FieldLanguage FL on FL.FieldID = FVI.FieldID and FL.LanguageID = {_requestRepository.LanguageId}
                inner join Employee E on E.EmployeeID = R.EmployeeID
                left join EmployeeLanguage EL on EL.EmployeeID = R.EmployeeID and EL.LanguageID = {_requestRepository.LanguageId}
                inner join RouteHistory RH on RH.RouteHistoryID = FVI.RouteHistoryID
                where SO.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) {searchFilter}";

                // list query
                string listQuery = string.Empty;
                if (isExportMode)
                {
                    DBHelper<dynamic> dbHelperDynamic = new DBHelper<dynamic>();

                    listQuery = string.Format(@" {0} {1} ",
                    mainQuery, //0
                    orderByFilter //1
                    );

                    result = dbHelperDynamic.GetQueryList(listQuery, ref reportData);
                }
                if (!isExportMode)
                {
                    listQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                    mainQuery, //0
                    orderByFilter, //1
                    filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                    filter.CustomListFilter.PageSize //3
                    );

                    string countQuery = string.Format(@"Select IsNull(Count(*),0) from ({0}) tt", mainQuery);
                    object objField = 0;
                    result = dbHelper.ExecuteScalar(countQuery, ref objField);
                    if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                    {
                        surveyList.TotalItems = int.Parse(objField.ToString().Trim());
                        if (surveyList.TotalItems <= 0)
                        {
                            surveyList.Data = list;
                            return GlobalErrors.Success;
                        }
                    }
                    else
                    {
                        return GlobalErrors.Error;
                    }

                    result = dbHelper.GetQueryList(listQuery, ref list);
                    surveyList.Data = surveyList.Data = list;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                surveyList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}
