﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Reflection;
using System.Text;
using RestSharp;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using System.IO;
using System.Xml;
using Sonic.Web.ZATCAXML.ZATCA.BLL;
using Sonic.Web.ZATCAXML.ZATCA.HelperContracts;
using Sonic.Web.ZATCAXML;
using System.Net.Http;
using System.Net.Http.Headers;

namespace Sonic.Web.Core
{
    public class TransactionManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly AccountManager _accountManager;
        private readonly EmployeeManager _employeeManager;
        private readonly DocumentSequenceManager _documentSequenceManager;
        private readonly CurrencyManager _currencyManager;
        private readonly PromotionManager _promotionManager;
        private readonly PaymentManager _paymentManager;
        private ConfigurationManager _configurationManager;
        private readonly RouteManager _routeManager;
        //private readonly CustomerManager _customerManager;

        public TransactionManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _accountManager = new AccountManager(_requestRepository);
            _employeeManager = new EmployeeManager(_requestRepository);
            _documentSequenceManager = new DocumentSequenceManager(requestRepository);
            _currencyManager = new CurrencyManager(requestRepository);
            _promotionManager = new PromotionManager(requestRepository);
            _paymentManager = new PaymentManager(requestRepository);
            _configurationManager = new ConfigurationManager(requestRepository);
            _routeManager = new RouteManager(requestRepository);
            //_customerManager = new CustomerManager(requestRepository);
        }



        public GlobalErrors GetTransactions(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList, bool getUnpaidTransactions, TransactionType transactionType,bool isTestTransaction)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string divisionAccess = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string tableName = CoreDataBaseConstants.TableNames.Transaction;
                if (isTestTransaction)
                    tableName = CoreDataBaseConstants.TableNames.TestTransaction;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( ({1}.TransactionID LIKE '%{0}%')
                    OR ( {1}.TransactionDate LIKE '%{0}%')
                    OR ( WarehouseLanguage.Description LIKE '%{0}%' )
                    OR ( Warehouse.WarehouseCode LIKE '%{0}%' )
                    OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                    OR ( Employee.EmployeeCode LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({2}))
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    OR ( DivisionLanguage.Description LIKE '%{0}%')
                   )", filter.CustomListFilter.SearchFilter.Trim(),tableName, _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                    if (filter.DivisionId != -1)
                    {
                        searchFilter += string.Format(@" And {1}.DivisionID = {0}", filter.DivisionId,tableName);
                    }
                    if (filter.WarehouseId != -1)
                    {
                        searchFilter += string.Format(@" And {1}.WarehouseID= {0} ",  filter.WarehouseId, tableName);
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += string.Format(@" And {1}.EmployeeID= {0} ", filter.EmployeeId, tableName);
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += string.Format(@" And {1}.CustomerID= {0} ", filter.CustomerId, tableName);
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += string.Format(@" And {1}.OutletID= {0} ", filter.OutletId, tableName);
                    }
                    if (!string.IsNullOrEmpty(filter.TransactionId))
                    {
                        searchFilter += string.Format(@" And {1}.TransactionID like('%{0}%')  ", filter.TransactionId, tableName);
                    }
                    if (filter.ShowTransWithRemaining)
                    {
                        searchFilter += string.Format(" And {0}. RemainingAmount>0 ",tableName);
                    }
                    if (filter.FromToDate != null)
                    {
                        searchFilter += string.Format(" And  {2}.TransactionDate>={0} and  {2}.TransactionDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)),tableName);
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By {0}.TransactionDate",tableName);
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (filter.IncludeVoided)
                    {
                        searchFilter += string.Format(" And {0}.Voided >= 0 ",tableName);
                    }
                    else
                    {
                        searchFilter += string.Format(" And {0}.Voided != 1 ",tableName);
                    }
                    if (filter.NewCustomerOnly)
                    {
                        searchFilter += string.Format(" And Customer.New = 1 ");
                    }

                }
                string unpaidTransactionsCheck = string.Format(@" And ({1}.TransactionTypeID in ({0}) ) ", transactionType.GetHashCode(),tableName);
                if (getUnpaidTransactions)
                {
                    unpaidTransactionsCheck =string.Format(@" And (RouteHistory.Uploaded is null OR RouteHistory.Uploaded = 0) 
                                                 And ({0}.Voided is null OR {0}.Voided = 0)
                                                 And ({0}.RemainingAmount > 0) 
                                                 And ({0}.TransactionTypeID in (1,3,6))", tableName);

                }
                string supervisionJoin = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"  and {1}.EmployeeID {0}", _employeeManager.GetSupervisorAccess(),tableName);
                }
                if (!string.IsNullOrEmpty(_requestRepository.CurrentOperator.DivisionAccess) && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionAccess = "and Division.DivisionID in(" + _requestRepository.CurrentOperator.DivisionAccess + ")";
                }
                string mainQuery = string.Format(@"Select
                {9}.Tax ,
                {9}.TransactionID,
                {9}.TransactionDate,
                {9}.EmployeeID, 
                {9}.CreatedBy,
                {9}.CustomerID, 
                {9}.OutletID, 
                {9}.NetTotal,
                {9}.RemainingAmount, 
                {9}.Voided, 
                Case When {9}.Voided = 1 then '{5}' else  '---' end as VoidedString,
                {9}.DivisionID,
                {9}.WarehouseID,
                {9}.AccountID,
                {9}.CurrencyID,
                {9}.SelectedCurrencyID,
                {9}.OrganizationID,
                {9}.CreationReason,
                {9}.TransactionTypeID,
                {9}.RouteId,
                {9}.SalesMode,
                {9}.SourceTransactionID,
                {9}.RouteHistoryID,
                IsNull( Customer.CustomerCode, '--') + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutlet.CustomerCode, '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description, '--')as CustomerOutletHeader,
                IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode, 
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode, 
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull(DivisionLanguage.Description,'--') as DivisionName,
                IsNull(WarehouseLanguage.Description,'--') as WarehouseName,
                IsNull( Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') as OrganizationName     
                from {9} 
                inner join Customer on Customer.CustomerID = {9}.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = Customer.CustomerID And CustomerOutlet.OutletID = {9}.OutletID
				inner join Organization on Organization.OrganizationID = [Transaction].OrganizationID
                left outer join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.languageid = {2}
                and CustomerLanguage.OrganizationId in ({0})
                left outer join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                and CustomerOutletLanguage.LanguageID = {2}
                left outer join Employee on Employee.EmployeeID = {9}.EmployeeID
                left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {2}
				left outer join OrganizationLanguage on OrganizationLanguage.OrganizationID = [Transaction].OrganizationID And OrganizationLanguage.LanguageID =  {2}
                left outer join Division on {9}.DivisionID = Division.DivisionID
                left outer join DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.languageid = {2}
                left outer join Warehouse on Warehouse.WarehouseID = {9}.WarehouseID
                left outer join WarehouseLanguage on WarehouseLanguage.WarehouseID = Warehouse.WarehouseID and WarehouseLanguage.languageid = {2}
                left outer join RouteHistory on RouteHistory.RouteHistoryID = {9}.RouteHistoryID
                {3}
                where 1=1 {4} and {9}.CreationReason not in ({7})  {6} and {9}.OrganizationID in ({0}) {1} 
                 {8} 
                group by  {9}.Tax ,{9}.TransactionID,{9}.TransactionDate,{9}.EmployeeID, {9}.CreatedBy,
                {9}.CustomerID,{9}.OutletID,{9}.NetTotal,{9}.RemainingAmount,{9}.Voided, 
                {9}.Voided,{9}.DivisionID,{9}.WarehouseID,{9}.AccountID,{9}.CurrencyID,
                {9}.SelectedCurrencyID,{9}.OrganizationID,{9}.CreationReason,{9}.TransactionTypeID,
                {9}.RouteId,{9}.SalesMode,{9}.SourceTransactionID,{9}.RouteHistoryID,
                Customer.CustomerCode,CustomerLanguage.Description, CustomerOutlet.CustomerCode,CustomerOutletLanguage.Description,OrganizationLanguage.Description,Organization.OrganizationCode,
                CustomerOutlet.CustomerCode,EmployeeLanguage.Description,DivisionLanguage.Description,WarehouseLanguage.Description",
                _requestRepository.CurrentOperator.OrganizationAccess, //0
                unpaidTransactionsCheck, //1
                _requestRepository.LanguageId, //2
                orgAccessJoin, //3
                searchFilter, //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Caption, _requestRepository.LanguageId), //5
                supervisionJoin, //6
                TransactionCreationReason.DiscrepancyInvoice.GetHashCode(), //7
                divisionAccess, //8
                tableName //9
                );

                string invoicesQuery = string.Format(@" {0} {1} ",
                mainQuery, //0
                orderByFilter //1
                );

                if (!getUnpaidTransactions)
                {
                    invoicesQuery += string.Format(" OFFSET {0} ROWS FETCH NEXT {1} ROWS ONLY ",
                     (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //0
                    filter.CustomListFilter.PageSize //1
                    );
                }

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref transactions , true);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveInTempTransactionDetails(TransactionCommonData transationCommonData)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                if (transationCommonData != null && transationCommonData.SoldItems != null && transationCommonData.SoldItems.Count > 0)
                {
                    dBHelper.BeginTransaction();
                    string query = string.Empty;
                    query = string.Format(@"DELETE FROM TempTransactionDetails WHERE SessionId = '{0}'", _requestRepository.SessionId);
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.Success || result == GlobalErrors.SuccessWithZeroRowAffected)
                    {
                        foreach (ItemPackModel pack in transationCommonData.SoldItems)
                        {
                            query = string.Format(@"Insert Into TempTransactionDetails (SessionId,PackId,Quantity,Price,Tax,Discount,ExciseTax,GrossTotal,GrossWithDiscount,NetTotal) Values 
                            ('{0}',{1},{2},{3},{4},{5},{6},{7},{8},{9})", _requestRepository.SessionId, pack.PackId, pack.RequiredQty, pack.Price, pack.CalculatedTax, pack.CalculatedDiscount, pack.CalculatedRetailTax, pack.GrossTotal, pack.GrossTotal - pack.CalculatedDiscount, pack.NetTotal);
                            result = dBHelper.ExecuteNonQuery(query);
                            if (result != GlobalErrors.Success)
                                break;
                        }
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();

                    }
                    dBHelper.Dispose();
                    dBHelper = null;
                }
            }
            return result;
        }

        public static int getReportTypeID(TransactionHistory transaction)
        {
            int reportTypeID = -1;
            if (transaction.TransactionTypeID == TransactionType.Sales.GetHashCode())
            {
                if (transaction.CreationReason == TransactionCreationReason.iCashTopUp.GetHashCode())
                    reportTypeID = EmailReportTypes.ICashTopUp.GetHashCode();
                else
                    reportTypeID = EmailReportTypes.SalesInvoice.GetHashCode();
            }
            else if (transaction.TransactionTypeID == TransactionType.Return.GetHashCode())
            {
                reportTypeID = EmailReportTypes.Return.GetHashCode();
            }
            else if (transaction.TransactionTypeID == TransactionType.SalesExchange.GetHashCode())
            {
                reportTypeID = EmailReportTypes.Exchange.GetHashCode();
            }
            else if (transaction.TransactionTypeID == TransactionType.DeliveryNote.GetHashCode() ||
                transaction.CreationReason == TransactionCreationReason.DealerSalesBO.GetHashCode() ||
                transaction.CreationReason == TransactionCreationReason.OrderDeliveryFOInvoice.GetHashCode() ||
                transaction.CreationReason == TransactionCreationReason.PartialDeliveryInBO.GetHashCode() ||
                transaction.CreationReason == TransactionCreationReason.OrderManualDeliveryBOInvoice.GetHashCode())
            {
                reportTypeID = EmailReportTypes.Delivery.GetHashCode();
            }
            else if (transaction.PaymentTypeId == PaymentTypes.Cash || transaction.PaymentTypeId == PaymentTypes.CurrentDatedCheque ||
                transaction.PaymentTypeId == PaymentTypes.PostedDatedCheque || transaction.PaymentTypeId == PaymentTypes.CreditNote ||
                transaction.PaymentTypeId == PaymentTypes.CertifiedCheque || transaction.PaymentTypeId == PaymentTypes.Coupon ||
                transaction.PaymentTypeId == PaymentTypes.CreditCard || transaction.PaymentTypeId == PaymentTypes.EPayment ||
                transaction.PaymentTypeId == PaymentTypes.iCash || transaction.PaymentTypeId == PaymentTypes.RentFees ||
                 transaction.PaymentTypeId == PaymentTypes.AllowBankTransfer
            )
            {
                reportTypeID = EmailReportTypes.Collection.GetHashCode();
            }

            return reportTypeID;
        }



        public GlobalErrors DeleteTempTransactionDetails()
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = new DBHelper<int>();
            try
            {
                string query = string.Format(@"DELETE FROM TempTransactionDetails WHERE SessionId = '{0}'", _requestRepository.SessionId);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                    result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors MoveInvoiceTransaction(List<TransactionModel> transactionsList , int toEmplyeeId , int fromEmployeeId ,  DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Empty;
                StringBuilder values = new StringBuilder();
                foreach (TransactionModel transaction in transactionsList)
                {
                    values.AppendFormat("Update [Transaction] Set EmployeeID = {5} Where TransactionID = '{0}' AND EmployeeID={1}  AND CustomerID={2} And OutletID={3}  AND DivisionID={4}; ",
                    transaction.TransactionId, //0
                    fromEmployeeId, //1
                    transaction.CustomerId, //2
                    transaction.OutletId, //3
                    transaction.DivisionId, //4
                    toEmplyeeId // 5
                    );
                }
                query = string.Format(@"{0}", values.ToString().TrimEnd(','));
                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetICashTransactions(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string searchFilter1 = string.Empty;
                string searchFilter2 = string.Empty;
                string orderByFilter = string.Empty;
                string groupFilter = string.Empty;
                string supervisionJoin = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@" and [Transaction].EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( ([Transaction].TransactionID LIKE '%{0}%')
                    OR (TransactionDate LIKE '%{0}%')
                    OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                    OR ( Employee.EmployeeCode LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1}) )
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    
                   )", filter.CustomListFilter.SearchFilter.Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                    }

                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += " And ICashHistory.EmployeeID= " + filter.EmployeeId;
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += " And [Transaction].CustomerID= " + filter.CustomerId;
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += " And [Transaction].OutletID= " + filter.OutletId;
                    }
                    if (!string.IsNullOrEmpty(filter.ICashTransactionType))
                    {
                        if (filter.ICashTransactionType.ToLower() == "payment")
                        {
                            searchFilter2 += string.Format(" and CustomerPayment.PaymentTypeID= {0} ", PaymentTypes.iCash.GetHashCode());
                        }
                        else if (filter.ICashTransactionType.ToLower() == "top-up")
                        {
                            searchFilter1 += string.Format(" and [Transaction].CreationReason = {0} ", TransactionCreationReason.iCashTopUp.GetHashCode());
                        }
                        else if (filter.ICashTransactionType.ToLower() == "reversal")
                        {
                            searchFilter1 += string.Format(" and [Transaction].CreationReason = {0} ", TransactionCreationReason.ICashReversal.GetHashCode());
                        }
                    }
                    else
                    {
                        searchFilter2 += string.Format(" AND (CustomerPayment.PaymentTypeID = {0}) ", PaymentTypes.iCash.GetHashCode());
                        searchFilter1 += string.Format(" AND [Transaction].CreationReason IN ({0},{1}) ", TransactionCreationReason.iCashTopUp.GetHashCode(), TransactionCreationReason.ICashReversal.GetHashCode());
                    }
                    if (filter.groupId != -1)
                    {
                        groupFilter += string.Format(" inner join CustomerOutletGroup On CustomerOutlet.CustomerID = CustomerOutletGroup.CustomerID AND CustomerOutlet.OutletID = CustomerOutletGroup.OutletID " +
                            " and CustomerOutletGroup.GroupID = {0}", filter.groupId);
                    }
                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" And  TransactionDate >= {0} and  TransactionDate <= {1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By CustomerCodeName ,OutletCodeName,TransactionDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                }
                string declareTable = string.Format(@"DECLARE @Table as Table (
                           ICashTransactionID NVARCHAR(200),
                           TransactionID NVARCHAR(200),
                           TransactionDate Datetime,
                           EmployeeID INT,
                           CreatedBy INT,
                           CustomerID INT,
                           OutletID INT,
                           NetTotal Decimal(19,9),
                           RemainingAmount Decimal(19,9),
                           Voided Bit,
                           VoidedString NVARCHAR(200),
                           DivisionID INT,
                           CurrencyID INT,
                           SelectedCurrencyID INT,
                           OrganizationID INT,
                           CreationReason INT,
                           TransactionTypeID INT,
                           RouteId INT,
                           SalesMode INT,
                           SourceTransactionID NVARCHAR(200),
                           IsTopUp Bit,
                           IsReversal Bit,
                           IsPayment Bit,
                           ICashTransactionType NVARCHAR(200),
                           ICashAmount Decimal(19,9),
                           ICashBalanceBefore Decimal(19,9),
                           ICashBalanceAfter Decimal(19,9),
                           ICashCurrentBalance Decimal(19,9),
                           CustomerCodeName NVARCHAR(200),
						   OutletCodeName NVARCHAR(200) ,
						   EmployeeName  NVARCHAR(200)); 
                            ");

                string mainQuery1 = string.Format(@" 
                           INSERT INTO @Table
                           Select [Transaction].TransactionID ICashTransactionID,
                [Transaction].TransactionID,
                ICashHistory.UpdatedDate TransactionDate,
                ICashHistory.EmployeeID,
                [Transaction].CreatedBy,
                [Transaction].CustomerID,
                [Transaction].OutletID,
                [Transaction].NetTotal,
                [Transaction].RemainingAmount,
                [Transaction].Voided,
                Case When [Transaction].Voided = 1 then '{4}' else  '---' end as VoidedString,
                [Transaction].DivisionID,
                [Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,
                [Transaction].OrganizationID,
                [Transaction].CreationReason,
                [Transaction].TransactionTypeID,
                [Transaction].RouteId,
                [Transaction].SalesMode,
                [Transaction].SourceTransactionID,
                case when [Transaction].CreationReason = {8} then 1 else 0 end IsTopUp,
                case when [Transaction].CreationReason = {9} then 1 else 0 end IsReversal,
                0 IsPayment ,
                case when [Transaction].CreationReason = {8} then '{5}' else (case when [Transaction].CreationReason = {9} then '{6}' else '{7}' end )end  as ICashTransactionType,
                case when [Transaction].CreationReason = {8} then ICashHistory.BalanceDifference else -1 * ICashHistory.BalanceDifference end as ICashAmount,
                case when  [Transaction].CreationReason = {8}
                then ICashHistory.RemainingBalance - ICashHistory.BalanceDifference else ICashHistory.RemainingBalance + ICashHistory.BalanceDifference end As ICashBalanceBefore,
                ICashHistory.RemainingBalance  As ICashBalanceAfter,
                ICashBalance.Balance As ICashCurrentBalance,
                IsNull( CustomerLanguage.Description  , '--')       + ' ' + '-'+ ' ' + IsNull( Customer.CustomerCode , '--')as CustomerCodeName,
                IsNull( CustomerOutletLanguage.Description  , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutlet.CustomerCode , '--') as OutletCodeName,
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName
                FROM [Transaction]
                INNER JOIN ICashBalance ON ICashBalance.CustomerID = [Transaction].CustomerID AND ICashBalance.OutletID = [Transaction].OutletID
                INNER join ICashHistory on ICashHistory.TransactionID = [Transaction].TransactionID AND
                ICashHistory.CustomerID = [Transaction].CustomerID AND
                ICashHistory.OutletID = [Transaction].OutletID
                inner join Customer on Customer.CustomerID = [Transaction].CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = [Transaction].CustomerID And CustomerOutlet.OutletID = [Transaction].OutletID
                {2}               
                {11}		
                left outer join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.languageid = {1}
                and CustomerLanguage.OrganizationId in ({0})
                left outer join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                and CustomerOutletLanguage.LanguageID = {1}
				left outer join Employee on Employee.EmployeeID = ICashHistory.EmployeeID
                left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
                WHERE 1=1 AND [Transaction].OrganizationID in ({0}) {12} {3} {10} 
                ", _requestRepository.CurrentOperator.OrganizationAccess, //0
                _requestRepository.LanguageId, //1
                orgAccessJoin, //2
                searchFilter, //3
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Caption, _requestRepository.LanguageId), //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_TopUp_Caption, _requestRepository.LanguageId),//5
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Reversal_Caption, _requestRepository.LanguageId),//6
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Payment_Caption, _requestRepository.LanguageId),//7
                TransactionCreationReason.iCashTopUp.GetHashCode(),//8
                TransactionCreationReason.ICashReversal.GetHashCode(),//9
                searchFilter1,//10
                groupFilter, //11
                supervisionJoin //12
                );
                string mainQuery2 = string.Format(@"INSERT INTO @Table 
                           Select
                ICashHistory.CustomerPaymentID ICashTransactionID,
                [Transaction].TransactionID,
                ICashHistory.UpdatedDate TransactionDate,
                ICashHistory.EmployeeID,
                [Transaction].CreatedBy,
                [Transaction].CustomerID,
                [Transaction].OutletID,
                [Transaction].NetTotal,
                [Transaction].RemainingAmount,
                [Transaction].Voided,
                Case When [Transaction].Voided = 1 then '{4}' else  '---' end as VoidedString,
                [Transaction].DivisionID,
                [Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,
                [Transaction].OrganizationID,
                [Transaction].CreationReason,
                [Transaction].TransactionTypeID,
                [Transaction].RouteId,
                [Transaction].SalesMode,
                [Transaction].SourceTransactionID,
                0 IsTopUp,
                0 IsReversal,
                1 IsPayment,
                'Payment'  as ICashTransactionType,
                -1 * ICashHistory.BalanceDifference as ICashAmount,
                ICashHistory.RemainingBalance + ICashHistory.BalanceDifference As ICashBalanceBefore,
                ICashHistory.RemainingBalance  As ICashBalanceAfter,
                ICashBalance.Balance As ICashCurrentBalance,
                IsNull( CustomerLanguage.Description  , '--')       + ' ' + '-'+ ' ' + IsNull( Customer.CustomerCode , '--')as CustomerCodeName,
                IsNull( CustomerOutletLanguage.Description  , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutlet.CustomerCode , '--') as OutletCodeName,
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName
                FROM [Transaction]
                INNER JOIN CustomerPayment ON [Transaction].TransactionID = CustomerPayment.TransactionID
                AND [Transaction].CustomerID = CustomerPayment.CustomerID AND
                [Transaction].OutletID = CustomerPayment.OutletID AND
                [Transaction].DivisionID = CustomerPayment.DivisionID
                INNER JOIN ICashBalance ON ICashBalance.CustomerID = [Transaction].CustomerID AND ICashBalance.OutletID = [Transaction].OutletID
                INNER join ICashHistory on ICashHistory.TransactionID = [Transaction].TransactionID AND
                ICashHistory.CustomerID = [Transaction].CustomerID AND
                ICashHistory.OutletID = [Transaction].OutletID
                inner join Customer on Customer.CustomerID = [Transaction].CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = [Transaction].CustomerID And CustomerOutlet.OutletID = [Transaction].OutletID
                {2}                
                {5}	
               
                left outer join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.languageid = {1}
                and CustomerLanguage.OrganizationId in ({0})
                left outer join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                and CustomerOutletLanguage.LanguageID = {1}
				left outer join Employee on Employee.EmployeeID = ICashHistory.EmployeeID
                left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
                WHERE 1=1 AND CustomerPayment.OrganizationID in ({0}) {4} {3} 
                ", _requestRepository.CurrentOperator.OrganizationAccess, //0
                _requestRepository.LanguageId, //1
                orgAccessJoin, //2
                searchFilter, //3
                searchFilter2,//4
                groupFilter//5
                );
                string mainQuery3 = string.Format(@" SELECT * FROM @Table  ");

                string offsetQuery = string.Format(" OFFSET {0} ROWS FETCH NEXT {1} ROWS ONLY ",
                 (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize, //0
                filter.CustomListFilter.PageSize //1
                );
                string invoicesQuery = "";
                string countQuery = "";
                if (!string.IsNullOrEmpty(filter.ICashTransactionType) && !filter.ICashTransactionType.ToString().Equals("-1"))
                {
                    if (filter.ICashTransactionType.ToLower() == "payment")
                    {
                        invoicesQuery = string.Format(@" {0} {1} {4} {3} {2} {4} {3} ",
                            declareTable,//0
                            mainQuery2, //1
                            mainQuery3, //2
                            offsetQuery,//3
                            orderByFilter //4
                            );
                        countQuery = string.Format(@" {0} {1} 
                        Select IsNull(Count(*),0) From  @Table", declareTable, mainQuery2);
                    }
                    else if (filter.ICashTransactionType.ToLower() == "top-up" || filter.ICashTransactionType.ToLower() == "reversal")
                    {
                        invoicesQuery = string.Format(@" {0} {1} {4} {3}  {2} {4} {3} ",
                            declareTable,//0
                            mainQuery1, //1
                            mainQuery3, //2
                            offsetQuery,//3
                            orderByFilter //4
                            );
                        countQuery = string.Format(@"{0} {1} 
                        Select IsNull(Count(*),0) From  @Table", declareTable, mainQuery1);
                    }
                }
                else
                {
                    invoicesQuery = string.Format(@" {0} {1} {5} {4} {2} {5} {4} {3} {5} {4} ",
                           declareTable,//0
                           mainQuery1, //1
                           mainQuery2, //2
                           mainQuery3, //3
                           offsetQuery,//4
                           orderByFilter //5
                           );
                    countQuery = string.Format(@"{0} {1} {2} Select IsNull(Count(*),0) From  @Table", declareTable, mainQuery1, mainQuery2);
                }

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }
                result = dbHelper.GetQueryList(invoicesQuery, ref transactions , true);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetSourceTransactionData(string sourceTransactionId, ref TransactionModel transaction)
        {
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string query = string.Format(@"Select IsNull(EmployeeLanguage.Description,'--') as EmployeeName ,ICashHistory.UpdatedDate transactionDate ,  case when [Transaction].CreationReason = 25 then ICashHistory.BalanceDifference else -1 * ICashHistory.BalanceDifference end as ICashAmount From [Transaction]  
                    INNER join ICashHistory on ICashHistory.TransactionID = [Transaction].TransactionID AND
                    ICashHistory.CustomerID = [Transaction].CustomerID AND
                    ICashHistory.OutletID = [Transaction].OutletID
                    left outer join Employee on Employee.EmployeeID = ICashHistory.EmployeeID
                    left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
                    Where [Transaction].TransactionID = '{0}'", sourceTransactionId, _requestRepository.LanguageId);

                result = dbHelper.GetQuerySingle(query, ref transaction);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetCustomerAvailableCreditNotes(int customerId, int outletId, int divisionID, ref List<TransactionModel> creditNote)
        {
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string customerOutletFilter = string.Empty;
                string divisionFilter = string.Empty;
                string sourceTransactionID = string.Empty;
                dbHelper = new DBHelper<TransactionModel>();

                customerOutletFilter = string.Format(@" AND [Transaction].CustomerID = {0} ", customerId);
                if (outletId != -1)
                {
                    customerOutletFilter += string.Format(@" AND [Transaction].OutletID = {0} ", outletId);
                }

                if (_requestRepository.Configurations.UseSourceTransactionIDAsInvoiceName)
                {
                    sourceTransactionID = string.Format(@"isnull([Transaction].SourceTransactionID,[Transaction].TransactionID) DisplayTransactionID,");
                }
                else
                {
                    sourceTransactionID = string.Format(@"[Transaction].TransactionID DisplayTransactionID,");
                }


                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionFilter = string.Format(" AND [Transaction].DivisionID IN ({0})", divisionID);
                }

                string tableName = CoreDataBaseConstants.TableNames.CustOutTerritory;
                string customerTableJoin = string.Format(" inner join CustOutTerritory on CustOutTerritory.TerritoryID = ET.TerritoryID ");
                if (!_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                {
                    tableName = CoreDataBaseConstants.TableNames.RouteCustomer;
                    customerTableJoin = string.Format(" inner join RouteCustomer on RouteCustomer.RouteID = Route.RouteID ");
                }



                string queryy = string.Format(@"Select {5} [Transaction] .TransactionID TransactionID,[Transaction] .TransactionDate,[Transaction] .RemainingAmount ,0 ValuesUsed,1 DisableValuesUsed, 
                [Transaction] .NetTotal, [Transaction] .SourceTransactionID , [Transaction] .TransactionTypeID ,
                [Transaction] .Notes ,[Transaction] .DivisionID,[Transaction] .CollectionDiscount,[Transaction] .AccountID,[Transaction] .CustomerID,[Transaction] .OutletID,COL.Description OutletName 
                from [Transaction] 
                LEFT JOIN CustomerOutletLanguage COL ON COL.CustomerID = [Transaction] .CustomerID AND COL.OutletID = [Transaction] .OutletID AND COL.LanguageID = {0}
                inner join 
                (
                select T.CustomerID, T.OutletID, T.DivisionID, T.TransactionID, T.EmployeeID 
                from [Transaction] T
                Outer Apply (
                select top(1) RouteHistoryID, Uploaded, SyncDate 
                from RouteHistory
                inner join EmployeeTerritory ET on ET.EmployeeID = RouteHistory.EmployeeID
                inner join Route on Route.TerritoryID = ET.TerritoryID
                {7}
                where {6}.CustomerID = T.CustomerID and {6}.OutletID = T.OutletID And RouteHistory.EmployeeID = T.EmployeeID
                order by RouteHistoryID desc
                )tt
                where IsNull(tt.Uploaded,0) = 0 

                union

                select T.CustomerID, T.OutletID, T.DivisionID, T.TransactionID, T.EmployeeID 
                from [Transaction] T
                Cross Apply (
                select top(1) RouteHistoryID, Uploaded, SyncDate 
                from RouteHistory
                inner join EmployeeTerritory ET on ET.EmployeeID = RouteHistory.EmployeeID
                inner join Route on Route.TerritoryID = ET.TerritoryID
                {7}
                where {6}.CustomerID = T.CustomerID and {6}.OutletID = T.OutletID And RouteHistory.EmployeeID = T.EmployeeID
                order by RouteHistoryID desc
                )tt
                where tt.Uploaded = 1 and tt.SyncDate < T.TransactionDate

                ) rr on rr.TransactionID = [Transaction].TransactionID and rr.CustomerID = [Transaction].CustomerID and rr.OutletID = [Transaction].OutletID and rr.DivisionID = [Transaction].DivisionID
                where [Transaction].Posted = 1 and IsNull([Transaction].Voided,0) = 0 and [Transaction].RemainingAmount > 0 and [Transaction].TransactionTypeID = {1} AND [Transaction].OrganizationID IN ({3}) 
                {4} {2} ",
                _requestRepository.LanguageId,//0
                TransactionType.CreditNote.GetHashCode(),//1
                divisionFilter,//2
                _requestRepository.CurrentOperator.OrganizationAccess,//3
                customerOutletFilter,//4
                sourceTransactionID, //5
                tableName, //6
                customerTableJoin //7
                );

                result = dbHelper.GetQueryList(queryy, ref creditNote);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetDocumentReasonDataSource(int documentTypeId, ref List<TransactionDocumentReasonModel> documentReason)
        {
            DBHelper<TransactionDocumentReasonModel> DBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper = new DBHelper<TransactionDocumentReasonModel>();
                string query = string.Format(@"select DR.DocumentReasonID , DRl.Description DocumentReasonDescription
                                               from DocumentReason DR
                                               left join DocumentReasonLanguage DRL on DRL.DocumentReasonID = DR.DocumentReasonID and DRL.LanguageID = {0}
                                               inner join DocumentType DT on DT.DocumentTypeID = DR.DocumentTypeID
                                               where DR.Inactive <> 1 and DT.DocumentTypeID = {1}",
                                               _requestRepository.LanguageId, // 0
                                               documentTypeId // 1
                                               );
                result = DBHelper.GetQueryList(query, ref documentReason);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;

        }

        public GlobalErrors GetAllTaxesForGeneralPrice(ref List<TaxModel> taxes, int employeeId)
        {
            DBHelper<TaxModel> dbHelper = new DBHelper<TaxModel>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            string employeeOraganiztionAccess = string.Empty;
            if (employeeId > 0)
            {
                employeeOraganiztionAccess = string.Format(@" INNER join EmployeeOrganization on EmployeeOrganization.OrganizationID = PL.OrganizationID and EmployeeOrganization.EmployeeID ={0}", employeeId);
            }
            try
            {

                string query = string.Format(@"select * from (
                select distinct Cast(PD.Tax as decimal(19,{3})) Tax 
                from PriceDefinition PD
                inner join PriceList PL on PL.PriceListID = PD.PriceListID 
                {4}
                where PL.PriceListTypeID = {0} and PL.IsDeleted = 0 
                           and (PL.StartDate <= {1} and PL.EndDate >= {2})
                           ) t order by t.tax ",
                int.Parse(PriceListTypes.General.GetHashCode().ToString()),
                LocalUtilities.ParseDateToSQLString(DateTime.Now),
                LocalUtilities.ParseEndDateToSQLString(DateTime.Now),
                _requestRepository.Configurations.NumberOfDigits,
                employeeOraganiztionAccess);


                result = dbHelper.GetQueryList(query, ref taxes);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;

            }
            return result;
        }
    


        public GlobalErrors CheckIfCustomreRouteUploaded(int customerID, int outletID, ref bool isRouteUploaded)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string filter = string.Empty;
                object field = new object();
                dBHelper = new DBHelper<int>();

                if (_requestRepository.Configurations.AllowTerritoryCustomerVisit)
                {
                    filter = " inner join CustOutTerritory on RouteHistory.TerritoryID = CustOutTerritory.TerritoryID ";
                }
                else
                {
                    filter = " inner join RouteCustomer on RouteHistory.RouteID = RouteCustomer.RouteID ";
                }

                string query = string.Format(@"select Top(1) Uploaded from RouteHistory
                {0}
                where CustomerID = {1} and OutletID = {2}  order by RouteHistoryID desc ",
                filter, customerID, outletID);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    isRouteUploaded = Convert.ToBoolean(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public bool CheckIfTransactionHasUsedSerials(string transactionId, int customerId, int outletId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"select Count(*) from SerialCurrentStatus
                where TransactionID='{0}' and CustomerID={1} and OutletID={2} and IsCouponUsed=1", transactionId, customerId, outletId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public GlobalErrors UpdateContainerAfterVoiding(int customerID, int outletID, decimal DepositeBalance, decimal NoneDepositeBalance, int PackId, decimal Limit, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();

                string query = string.Format(@"UPDATE ContainerLimit SET DepositBalance = {0}, NoneDepositBalance = {1} WHERE CustomerID = {2} AND OutletID = {3} and PackID={4} and Limit = {5}"
                 , DepositeBalance, NoneDepositeBalance, customerID, outletID, PackId, Limit);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public static bool containerIsRelatedToTradingItem(int itemType, int itemID)
        {
            Dictionary<int, Dictionary<int, ItemPackModel>> ContainersWithNoTradingItems = new Dictionary<int, Dictionary<int, ItemPackModel>>();
            return itemType == ItemTypes.Container.GetHashCode() && (ContainersWithNoTradingItems == null || ContainersWithNoTradingItems.ContainsKey(itemID));
        }
        public GlobalErrors GetContainerAfterVoiding(string transactionId, int customerId, int outletId, int divisionID, ref List<ItemPackModel> items, DBHelper<ItemPackModel> dBHelper, DBHelper<int> dBHelper2)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<ItemPackModel> item = new List<ItemPackModel>();
            int packID = -1;
            int itemID = -1;
            decimal qty = 0;
            int transactionTypeID = -1;
            int salesTransactionTypeID = -1;
            List<int> modifiedPacks = new List<int>();
            decimal limit = 0;
            decimal depositBalance = 0;
            decimal nonDepositBalance = 0;
            try
            {

                string query = string.Format(@"SELECT Item.ItemID ,TransactionDetail.PackID,TransactionDetail.Quantity,TransactionDetail.Price,
                            TransactionDetail.SalesTransactionTypeID,[Transaction].TransactionTypeID,ContainerLimit.DepositBalance,ContainerLimit.NoneDepositBalance,ContainerLimit.Limit
                            FROM TransactionDetail 
                            INNER JOIN [transaction] on TransactionDetail.TransactionID=[transaction].TransactionID and TransactionDetail.CustomerID=[transaction].CustomerID 
                            and TransactionDetail.OutletID=[transaction].OutletID  and TransactionDetail.DivisionID=[transaction].DivisionID
                            INNER JOIN Pack ON TransactionDetail.PackID = Pack.PackID 
                            INNER JOIN Item ON Pack.ItemID = Item.ItemID and item.ItemType = 2
                            left join ContainerLimit on ContainerLimit.customerId = [transaction].customerid and ContainerLimit.outletId = [transaction].outletId and pack.PackID=ContainerLimit.PackID
                            WHERE ((TransactionDetail.TransactionID in ('{0}', (Select TransactionID FROM [Transaction] WHERE SourceTransactionID = '{0}'))) and TransactionDetail.CustomerID={1}
                            and TransactionDetail.OutletID={2}) and TransactionDetail.DivisionID = {3}", transactionId, customerId, outletId, divisionID);
                result = dBHelper.GetQueryList(query, ref item);
                if (item != null && item.Count > 0)
                {
                    foreach (ItemPackModel container in item)
                    {
                        itemID = container.ItemId;
                        packID = container.PackId;
                        qty = container.Quantity;
                        salesTransactionTypeID = container.SalesTransactionTypeId.GetHashCode();
                        transactionTypeID = container.TransactionTypeId;
                        //depositBalance = container.DepositBalance;
                        //nonDepositBalance = container.NoneDepositBalance;
                        limit = container.Limit;
                        if (transactionTypeID == TransactionType.Sales.GetHashCode() || transactionTypeID == TransactionType.SalesExchange.GetHashCode())
                        {
                            if (salesTransactionTypeID != -1 && salesTransactionTypeID == SalesTransactionTypes.FOC.GetHashCode() && container.NoneDepositBalance >= qty)
                            {
                                nonDepositBalance = container.NoneDepositBalance - qty;
                            }
                            else if (salesTransactionTypeID != -1 && salesTransactionTypeID == SalesTransactionTypes.Sales.GetHashCode() && container.DepositBalance >= qty)
                            {
                                depositBalance = container.DepositBalance - qty;
                            }
                            else
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        else if (transactionTypeID == TransactionType.ReturnExchange.GetHashCode() || transactionTypeID == TransactionType.Return.GetHashCode())
                        {
                            if (salesTransactionTypeID == SalesTransactionTypes.FOCReturn.GetHashCode() && container.NoneDepositBalance + qty <= limit)
                            {
                                nonDepositBalance = container.NoneDepositBalance + qty;
                            }
                            else if (salesTransactionTypeID == SalesTransactionTypes.None.GetHashCode())
                            {
                                depositBalance = container.DepositBalance + qty;
                            }
                            else
                            {
                                return GlobalErrors.Error;
                            }
                        }
                        if (!modifiedPacks.Contains(packID))
                        {
                            modifiedPacks.Add(packID);
                        }
                        for (int i = 0; i < modifiedPacks.Count(); i++)
                        {
                            result = UpdateContainerAfterVoiding(customerId, outletId, depositBalance, nonDepositBalance, packID, limit, dBHelper2);
                            if (result != GlobalErrors.Success)
                                return GlobalErrors.Error;
                        }
                    }
                }
                else
                {
                    return GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateOrderStatus(string orderID, int orderStatusID, int previousOrderStatusID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                    dbHelper = new DBHelper<int>();

                string query = string.Format(@"update SalesOrder Set OrderStatusID = {0},PreviousOrderStatus={1} Where OrderID in ('{2}')"
                 , orderStatusID, previousOrderStatusID, orderID);
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTransactionData(ref TransactionModel transactionModel, bool isTestTransaction)
        {
            return GetTransactionData(ref transactionModel, null, isTestTransaction);
        }
        public GlobalErrors GetTransactionData(ref TransactionModel transactionModel, DBHelper<int> main_dbHelper)
        {
            return GetTransactionData(ref transactionModel, main_dbHelper, false);
        }
        public GlobalErrors GetTransactionData(ref TransactionModel transactionModel, DBHelper<int> main_dbHelper, bool isTestTransaction)
        {
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string tableName = CoreDataBaseConstants.TableNames.Transaction;
            bool isReturnSerials = false;
            try
            {
                if (main_dbHelper == null)
                {
                    dbHelper = new DBHelper<TransactionModel>();
                }
                else
                {
                    dbHelper = new DBHelper<TransactionModel>(main_dbHelper.GetConnection(), main_dbHelper.GetDBTransaction());
                }

                if (isTestTransaction)
                    tableName = CoreDataBaseConstants.TableNames.TestTransaction;
                isReturnSerials = transactionModel.IsReturnSerials;

                string query = string.Format(@"Select 
                {5}.TransactionID,
                {5}.TransactionDate,
                {5}.EmployeeID, 
                {5}.CreatedBy,
                {5}.CustomerID, 
                {5}.OutletID, 
                {5}.NetTotal,
                {5}.GrossTotal, 
                {5}.Tax, 
                {5}.IncludedTaxAmount,
                {5}.Discount, 
                {5}.ExciseTax as CalculatedRetailTax,
                {5}.CurrencyID, 
                {5}.RemainingAmount, 
                {5}.RouteHistoryID, 
                {5}.Posted, 
                {5}.Downloaded, 
                {5}.Voided, 
                {5}.DivisionID,
                {5}.WarehouseID,
                {5}.CreationReason,
                {5}.AccountID,
                {5}.SourceTransactionID,
                {5}.TransactionTypeID,
                CustomerOutlet.Taxeable IsTaxeableOutlet,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode,
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode,
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull(DivisionLanguage.Description,'--') as DivisionName,
                IsNull(WarehouseLanguage.Description,'--') as WarehouseName,
                IsNull( Customer.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,
                IsNull( Employee.EmployeeCode , '--') + ' ' + '-'+ ' ' + IsNull( EmployeeLanguage.Description , '--') as EmployeeCodeName,
                IsNull( Warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( WarehouseLanguage.Description , '--') as WarehouseCodeName,
                IsNull( Division.DivisionCode , '--') + ' ' + '-'+ ' ' + IsNull( DivisionLanguage.Description , '--') as DivisionCodeName,
                returnss.NetTotal ReturnNetTotal,
				returnss.GrossTotal ReturnGrossTotal,
				returnss.Discount ReturnDiscount,
				returnss.Tax ReturnTax,
				returnss.ExciseTax ReturnCalculatedRetailTax,
                IsNull( ReturnWarehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( returnsWarehouse.Description , '--') as ReturnWarehouseCodeName
                From {5}
                left join {5} returnss on {5}.SourceTransactionID = returnss.TransactionID
				and {5}.CustomerID = returnss.CustomerID and {5}.OutletID = returnss.OutletID
				and {5}.DivisionID=returnss.DivisionID
				and returnss.TransactionTypeID = 4
                inner join customer on customer.customerID = {5}.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.customerID = {5}.CustomerID and CustomerOutlet.OutletID = {5}.OutletID
                inner join Employee on employee.EmployeeID = {5}.EmployeeID
                left join Warehouse on Warehouse.WarehouseID ={5}.WarehouseID
                left join Warehouse ReturnWarehouse on ReturnWarehouse.WarehouseID = returnss.WarehouseID
                left join Division on Division.DivisionID = {5}.DivisionID

                left outer join CustomerLanguage on {5}.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.languageid  = {2}
                and CustomerLanguage.OrganizationId in ({6})
                left outer join CustomerOutletLanguage on {5}.CustomerID = CustomerOutletLanguage.CustomerID and {5}.OutletID = CustomerOutletLanguage.OutletID
                and CustomerOutletLanguage.LanguageID  = {2}
                Inner join EmployeeLanguage on EmployeeLanguage.EmployeeID = {5}.EmployeeID And EmployeeLanguage.LanguageID = {2}
                left outer join DivisionLanguage on {5}.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.languageid  = {2}
                left outer join WarehouseLanguage on WarehouseLanguage.WarehouseID = {5}.WarehouseID and WarehouseLanguage.LanguageID = {2}
                left outer join WarehouseLanguage returnsWarehouse on returnsWarehouse.WarehouseID = returnss.WarehouseID and returnsWarehouse.LanguageID = {2}
                where  ({5}.TransactionID = '{0}') and ({5}.DivisionID = {1}) and ({5}.CustomerId = {3}) and ({5}.OutletId = {4})",
                transactionModel.TransactionId,
                transactionModel.DivisionId,
                _requestRepository.LanguageId,
                transactionModel.CustomerId,
                transactionModel.OutletId,
                tableName,
                _requestRepository.CurrentOperator.OrganizationAccess
                );


                result = dbHelper.GetQuerySingle(query, ref transactionModel);

                // GET DETAILS
                if (result == GlobalErrors.Success)
                {
                    transactionModel.IsReturnSerials = isReturnSerials;
                    transactionModel.AllItems = GetTransactionDetails(transactionModel, main_dbHelper,isTestTransaction);
                    transactionModel.SoldItems = transactionModel.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Sales).ToList();
                    transactionModel.PromotedItems = transactionModel.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.Promotion).ToList();
                    transactionModel.FOCItems = transactionModel.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.FOC).ToList();
                    transactionModel.ReturnItems = transactionModel.AllItems.Where(a => a.SalesTransactionTypeId == SalesTransactionTypes.None || a.SalesTransactionTypeId == SalesTransactionTypes.FOCReturn).ToList();
                }
                //if (result == GlobalErrors.Success)
                //{
                //transactionModel.Outlet = _customerManager.FillOutletData(transactionModel.CustomerId, transactionModel.OutletId, transactionModel.DivisionId);
                //}
            }

            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public List<ItemPackModel> GetTransactionDetails(TransactionModel transactionModel)
        {
            return GetTransactionDetails(transactionModel, null,false);
        }
        public List<ItemPackModel> GetTransactionDetails(TransactionModel transactionModel, DBHelper<int> main_dbHelper,bool isTestTransaction)
        {
            DBHelper<ItemPackModel> dbHelper = null;
            List<ItemPackModel> itemPacksList = null;
            var result = GlobalErrors.NotInitialized;
            string expiryBatchNo = string.Empty;
            try
            {
                string divisionAccess = string.Empty;
                string transactionTable = CoreDataBaseConstants.TableNames.Transaction;
                string transactionDetailTable = CoreDataBaseConstants.TableNames.TransactionDetail;
                if (isTestTransaction)
                {
                    transactionTable = CoreDataBaseConstants.TableNames.TestTransaction;
                    transactionDetailTable = CoreDataBaseConstants.TableNames.TestTransactionDetail;
                }
                dbHelper = new DBHelper<ItemPackModel>();
                itemPacksList = new List<ItemPackModel>();
                if (main_dbHelper == null)
                {
                    dbHelper = new DBHelper<ItemPackModel>();
                }
                else
                {
                    dbHelper = new DBHelper<ItemPackModel>(main_dbHelper.GetConnection(), main_dbHelper.GetDBTransaction());
                }

                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionAccess = string.Format(@"inner join Division D on D.DivisionID = {1}.DivisionID and D.DivisionID in({0})",
                        _requestRepository.CurrentOperator.DivisionAccess,transactionTable);
                }
                if ((!_requestRepository.Configurations.UseDefaultExpiryAndBatchForItems && _requestRepository.Configurations.AllowBatchSelectionInDelivery) ||
                    (transactionModel.TransactionTypeId == (int)TransactionType.Return && _requestRepository.Configurations.RestrictReturnFromInvoices) || transactionModel.IsReturnSerials)
                {
                    expiryBatchNo = string.Format(@" , {0}.BatchNo, {0}.ExpiryDate",transactionDetailTable);
                }
                string query = string.Format(@"Select {9}.PackID,
                {9}.SalesTransactionTypeID ,
                {9}.Price,
				{9}.IncludedTaxAmount,
                case SalesTransactionTypeID 
                when 2 then 'FOC' 
                when 4 then 'Promo' 
                else
                convert(varchar,CAST({9}.price as numeric(19,{5})))
                end as PriceString,
                ItemLanguage.Description AS itemName,
                Pack.Quantity PackQuantity ,
                PackTypeLanguage.Description Uom,
                Pack.Quantity PiecesInPack ,
                Pack.HasSerialNumber,
                Item.ItemCode,
                Item.PackDefinition,
                Item.ItemID,
                ItemCategory.DivisionID ItemDivisionID,
                Sum({9}.Discount) AS Discount, Sum({9}.Discount) AS CalculatedDiscount, Sum({9}.Discount) AS CalculatedDiscountTotal,
                Sum({9}.PromotedDiscount) AS PromotedDiscount,
                Sum({9}.Tax) AS Tax, Sum({9}.Tax) AS CalculatedTax,
                Sum(({9}.price * {9}.Quantity) + {9}.Tax - {9}.Discount) As NetTotal,
                Sum({9}.price * {9}.Quantity) AS GrossTotal,
                Sum({9}.Quantity) AS RequiredQty,
                sum({9}.ExciseTax) as CalculatedRetailTax,
                sum({9}.ExciseTax/{9}.Quantity) as RetailValue,
				PackStatusLanguage.Description PackStatus,item.InStock,item.InSCS
                {7}
                FROM  {9}
                inner join {8} ON {8}.TransactionID = {9}.TransactionID 
                and {8}.DivisionID = {9}.DivisionID and {8}.CustomerID = {9}.CustomerID
                and {8}.OutletID = {9}.OutletID
                inner join pack on pack.PackID={9}.PackID
                inner join item on Item.ItemID=Pack.ItemID
                INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND (PackTypeLanguage.LanguageID = {4})
                LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND (ItemLanguage.LanguageID = {4})
                Left Join PackStatusLanguage on {9}.PackStatusID = PackStatusLanguage.StatusID and PackStatusLanguage.LanguageID={4}            
                {6}
                WHERE
                ({8}.TransactionID = '{0}' or {8}.SourceTransactionID = '{0}') and {8}.CustomerID= {1} and {8}.OutletID= {2}
                and {8}.DivisionID = {3}
                group by 
                {9}.PackID,
                {9}.SalesTransactionTypeID ,
                {9}.Price,
				{9}.IncludedTaxAmount,
                ItemLanguage.Description,
                Pack.Quantity ,
                PackTypeLanguage.Description,
                Item.ItemCode,
                Item.PackDefinition,
                Item.ItemID,
                ItemCategory.DivisionID,
                Pack.HasSerialNumber,
                PackStatusLanguage.Description,
                item.InStock,item.InSCS
                {7}
                Order by {9}.PackID, SalesTransactionTypeID",
                transactionModel.TransactionId, //0
                transactionModel.CustomerId, //1
                transactionModel.OutletId, //2
                transactionModel.DivisionId, //3
                _requestRepository.LanguageId, //4
                _requestRepository.Configurations.NumberOfDigits, //5
                divisionAccess, //6
                expiryBatchNo, //7
                transactionTable, // 8
                transactionDetailTable //9
                );

                result = dbHelper.GetQueryList(query, ref itemPacksList);

                return itemPacksList;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return itemPacksList;
            }
        }
        public GlobalErrors GetDefaultPriceList(TransactionModel transaction, DBHelper<int> dBHelper)
        {
            DBHelper<ItemPackModel> dbHelper = null;
            List<ItemPackModel> itemPacksList = new List<ItemPackModel>();
            var result = GlobalErrors.NotInitialized;
            try
            {
                string divisionAccess = string.Empty;
                dbHelper = new DBHelper<ItemPackModel>();
                itemPacksList = new List<ItemPackModel>();

                string PacksString = String.Join(",", transaction.AllItems.Select(item => item.PackId).ToArray());
                string query = string.Format(@"SELECT PacKID,Price as DefaultPrice FROM PriceDefinition WHERE PacKID IN ({0}) and  PriceListID IN ({1})", PacksString, _requestRepository.Configurations.DefaultPriceListID);
                result = dbHelper.GetQueryList(query, ref itemPacksList);

                foreach (ItemPackModel pack in transaction.AllItems)
                {
                    if (itemPacksList != null && itemPacksList.Count > 0 && itemPacksList.FirstOrDefault(x => x.PackId == pack.PackId) != null)
                        pack.DefaultPrice = itemPacksList.First(x => x.PackId == pack.PackId).DefaultPrice;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result = GlobalErrors.Error;
            }
        }
        public GlobalErrors SaveICashReversalTransaction(TransactionModel transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dbHelper = null;
            string query = "";
            try
            {
                dbHelper = new DBHelper<int>();
                dbHelper.BeginTransaction();
                result = SaveTransactionHeader(transaction, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    query = string.Format(@" UPDATE iCashBalance " +
                                " SET Balance = ((Select Balance from iCashBalance where CustomerID = {1} AND OutletID = {2}) - {0}) " +
                                " WHERE CustomerID = {1} AND OutletID= {2}", transaction.NetTotal, transaction.CustomerId, transaction.OutletId);
                    result = dbHelper.ExecuteNonQuery(query);
                    if (result == GlobalErrors.Success)
                    {
                        query = string.Format("INSERT INTO ICashHistory " +
                                    " (CustomerID, OutletID, CustomerPaymentID, TransactionID, EmployeeID, RouteHistoryID, DivisionID, UpdatedDate, BalanceDifference, " +
                                    " RemainingBalance, Posted) " +
                                    " VALUES ({0}, {1}, '{2}', '{3}', {4}, {5}, {6}, {7}, {8}, {9} , 0)", transaction.CustomerId, transaction.OutletId, "", transaction.TransactionId, _requestRepository.CurrentOperator.EmployeeId,
                                    -1, transaction.DivisionId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now), transaction.NetTotal, transaction.ICashCurrentBalance - transaction.NetTotal, 1);
                        result = dbHelper.ExecuteNonQuery(query);
                        if (result == GlobalErrors.Success)
                        {
                            result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, transaction.DocumentType, transaction.TransactionId, _requestRepository.CurrentOperator.EmployeeId, transaction.DivisionId);
                        }
                    }
                }
                if (result == GlobalErrors.Success)
                {
                    dbHelper.CommitTransaction();
                }
                else
                {
                    dbHelper.RollBackTransaction();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        public GlobalErrors SaveTestTransaction(TransactionModel transaction, ref string itemsExceedAvlNamesString, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string errorMessage = string.Empty;
            bool commitNow = false;
            try
            {

                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    commitNow = true;
                }

                #region [Fill employee related data]

                int helperId = -1, driverId = -1, supervisorId = -1, salesRepID = -1, SalesManagerId = -1;
                result = _employeeManager.GetEmployeeRelatedStaff(transaction.EmployeeId, dbHelper, ref helperId, ref driverId, ref supervisorId, ref salesRepID, ref SalesManagerId);

                if (result == GlobalErrors.Success)
                {
                    transaction.HelperId = helperId;
                    transaction.DriverId = driverId;
                    transaction.SupervisorId = supervisorId;
                    transaction.SalesRepId = salesRepID;
                    transaction.SalesManagerId = SalesManagerId;
                }
                transaction.OrganizationId = _employeeManager.GetEmployeeOrganization(transaction.EmployeeId, dbHelper);

                #endregion

                #region [Save Transaction Header]

                if (result == GlobalErrors.Success)
                {
                    result = SaveTestTransactionHeader(transaction, dbHelper);
                }

                #endregion

         


                #region[Promotions]
                if (result == GlobalErrors.Success && transaction.CustomerPromotions != null && transaction.CustomerPromotions.Count > 0)
                {
                    result = _promotionManager.SavePromotionBenefitHistoryData(CoreDataBaseConstants.TableNames.TestPromotionBenefitHistory, transaction.TransactionId, transaction.CustomerId, transaction.OutletId, transaction.DivisionId, transaction.EmployeeId, transaction.CustomerPromotions, PromotionBenefitTransactionTypes.SalesInvoice, dbHelper);
                }
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                #endregion

                #region [Save Transaction Details]

                if (result == GlobalErrors.Success)
                {
                    int packSequence = 0;
                    AppliedBatch appliedBatch = new AppliedBatch();
                    foreach (ItemPackModel pack in transaction.AllItems)
                    {
                        if (pack.RequiredQty > 0)
                        {
                            packSequence++;
                            pack.Sequence = packSequence;
                            appliedBatch.ExpiryDate = LocalUtilities.DefaultExpiryDate;
                            appliedBatch.BatchNumber = LocalUtilities.DefaultBatchNo;
                            appliedBatch.PackId = pack.PackId;
                            appliedBatch.QuantityChange = pack.RequiredQty;
                            appliedBatch.RetailPrice = pack.RetailPrice;
                            appliedBatch.RetailTax = pack.RetailTax;
                            result = GetDefaultPriceList(transaction, dbHelper);
                            if (result == GlobalErrors.Success)
                                result = SaveTestTransactionDetailsOnBatchLevel(transaction, pack, dbHelper, appliedBatch);
                            if (result != GlobalErrors.Success)
                            {
                                return GlobalErrors.Error;
                            }
                        }
                    }
                }

                #endregion

 


                //#region [Update Max TransactionID]

                //if (result == GlobalErrors.Success)
                //{
                //    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, transaction.DocumentType, transaction.TransactionId, transaction.EmployeeId, transaction.DivisionId, transaction.SDCId);
                //}

                //#endregion

                if (commitNow)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (commitNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public GlobalErrors GeneratePaymentAfterSaveInvoice(TransactionModel transaction, DBHelper<int> dbHelper, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string customerPaymentsIDsString = string.Empty;
                var payment = new SavePaymentModel();
                result = validateAndPreparePaymentData(transaction, dbHelper, ref payment, ref errorMessage);
                if (result == GlobalErrors.Success)
                    result = _paymentManager.SavePayments(payment, dbHelper, ref customerPaymentsIDsString);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private GlobalErrors validateAndPreparePaymentData(TransactionModel transaction, DBHelper<int> dBHelper, ref SavePaymentModel paymentModel, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                var checkSequenceForPayment = new DocumentSequenceFilter();
                checkSequenceForPayment.EmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                checkSequenceForPayment.DivisionId = transaction.DivisionId;
                checkSequenceForPayment.DocumentType = DocumentTypes.Collection;
                string maxDocumentId = string.Empty;
                int accountId = -1;

                if (IsValidAccountAndDocumentSequence(checkSequenceForPayment, ref maxDocumentId, ref accountId, dBHelper))
                {
                    var transactionList = new List<TransactionModel>(); transactionList.Add(transaction);
                    transactionList.Select(x => { x.AppliedAmount = x.RemainingAmount; return x; }).ToList();
                    var payment = new PaymentModel();
                    var paymentList = new List<PaymentModel>();
                    payment.AccountId = transaction.Outlet.Account.AccountId;
                    payment.PaymentDate = DateTime.Now;
                    payment.PaymentStatusId = PaymentStatusTypes.FullyCollected;
                    payment.CustomerId = transaction.CustomerId;
                    payment.OutletId = transaction.OutletId;
                    payment.EmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                    payment.CreatedBy = _requestRepository.CurrentOperator.EmployeeId;
                    payment.CurrencyId = transaction.CurrencyId;
                    payment.BankId = -1;
                    payment.BranchId = -1;
                    payment.PaymentTypeId = PaymentTypes.Cash;
                    payment.AppliedAmount = transaction.NetTotal;
                    payment.RemainingAmount = transaction.RemainingAmount;
                    payment.Notes = "Generated From Creating Invoice " + transaction.TransactionId;
                    payment.AppliedPaymentId = string.Empty;
                    paymentList.Add(payment);

                    paymentModel.CustomerId = transaction.CustomerId;
                    paymentModel.OutletId = transaction.OutletId;
                    paymentModel.DivisionId = transaction.DivisionId;
                    paymentModel.EmployeeId = _requestRepository.CurrentOperator.EmployeeId;
                    paymentModel.TransactionsList = transactionList;
                    paymentModel.PaymentsList = paymentList;

                    result = GlobalErrors.Success;
                }
                else
                {
                    errorMessage = MessagesConstants.Desc_No_Document_Sequence;
                    result = GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public bool IsValidAccountAndDocumentSequence(DocumentSequenceFilter documentSequenceFilter, ref string documentId, ref int accountId, DBHelper<int> dBHelper)
        {
            try
            {
                documentId = _documentSequenceManager.GetMaxDocumentSequence(dBHelper, documentSequenceFilter.EmployeeId,
                    documentSequenceFilter.DocumentType, documentSequenceFilter.DivisionId);
                if (!string.IsNullOrEmpty(documentId))
                {
                    if (documentSequenceFilter.DocumentType == DocumentTypes.Collection) // also check for applied payment id
                    {
                        string appliedPaymentId = _documentSequenceManager.GetMaxDocumentSequence(dBHelper, documentSequenceFilter.EmployeeId, DocumentTypes.AppliedPayment, documentSequenceFilter.DivisionId);
                        if (string.IsNullOrEmpty(appliedPaymentId))
                        {
                            documentId = string.Empty;
                            return false;
                        }
                    }
                }
                else
                {
                    return false;
                }


                AccountModel empAccount = _accountManager.GetEmployeeAccount(documentSequenceFilter.EmployeeId, dBHelper);
                if (empAccount == null || empAccount.AccountId == -1)
                {
                    return false;
                }
                else
                {
                    accountId = empAccount.AccountId;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return true;
        }

        public GlobalErrors SaveTransactionWithoutStockPosting(TransactionModel transaction, DBHelper<int> dbHelper, ref string errorMessage)
        {
            return SaveTransactionWithoutStockPosting(transaction, true, dbHelper, ref errorMessage);
        }
        public GlobalErrors SaveTransactionWithoutStockPosting(TransactionModel transaction, bool saveDetails, DBHelper<int> dbHelper, ref string errorMessage)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;

            bool commitNow = false;
            try
            {

                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    dbHelper.BeginTransaction();
                    commitNow = true;
                }


                #region [Fill employee related data]

                int helperId = -1, driverId = -1, supervisorId = -1, salesRepID = -1, SalesManagerId = -1;
                result = _employeeManager.GetEmployeeRelatedStaff(transaction.EmployeeId, dbHelper, ref helperId, ref driverId, ref supervisorId, ref salesRepID, ref SalesManagerId);

                if (result == GlobalErrors.Success)
                {
                    transaction.HelperId = helperId;
                    transaction.DriverId = driverId;
                    transaction.SupervisorId = supervisorId;
                    transaction.SalesRepId = salesRepID;
                    transaction.SalesManagerId = SalesManagerId;
                }
                transaction.OrganizationId = _employeeManager.GetEmployeeOrganization(transaction.EmployeeId, dbHelper);

                #endregion

                #region [Save Transaction Header]

                if (result == GlobalErrors.Success)
                {
                    result = SaveTransactionHeader(transaction, dbHelper);
                }

                #endregion


                #region [Save Transaction Details]

                if (result == GlobalErrors.Success)
                {


                    #region [Save details]

                    if (saveDetails && result == GlobalErrors.Success)
                    {
                        result = SaveTransactionDetails(transaction, true, dbHelper);

                    }

                    #endregion
                }

                #endregion

                #region [Post Payments & Accounts]

                // Post non warehouse affect stock
                if (transaction.DocumentType != DocumentTypes.CreditNote && result == GlobalErrors.Success)
                {
                    // update transction account balances
                    result = _accountManager.UpdateAccountsAfterNewTransaction(dbHelper, transaction, ref errorMessage);
                }

                #endregion





                #region [Update Max TransactionID]

                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, transaction.DocumentType, transaction.TransactionId, transaction.EmployeeId, transaction.DivisionId);
                }

                #endregion

                if (commitNow)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dbHelper.CommitTransaction();
                    }
                    else
                    {
                        dbHelper.RollBackTransaction();
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (commitNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }

        public int getOrganizationBaseCurrency(int organizationId)
        {
            DBHelper<int> dbHelper = new DBHelper<int>();
            GlobalErrors result = GlobalErrors.NotInitialized;
            Object field = null;
            int currenctId = -1;
            try
            {
                string query = string.Format("Select CurrencyId From Currency Where OrganizationId = {0} And Base = 1", organizationId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && int.Parse(field.ToString()) > 0)
                {
                    currenctId = int.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return currenctId;
        }
        public GlobalErrors SaveTransactionHeader(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO {23} 
                (CustomerID , OutletID , TransactionID , EmployeeID , TransactionDate , TransactionTypeID ,
                Discount , Tax , RemainingAmount , SourceTransactionID , GrossTotal , NetTotal ,CurrencyID,
                GPSLatitude , GPSLongitude , Voided , Notes ,TransactionStatusID , RouteID, WarehouseID 
                , CreatedBy ,CreatedDate,Synchronized,AccountID,DivisionID,Posted,RouteHistoryID,VisitNo
                ,PromotedDiscount,SalesMode,SupervisorID,HelperID,CreationReason,CollectionDiscount,LPONumber,SalesManagerID,OrganizationID,DriverID,SalesRepID,IsUpdatedInFO,RefOrderID,SoldBy,Downloaded,SelectedCurrencyID, ExchangeRate, UpdatedDate, UpdatedBy,ExciseTax,DocumentReasonID, Description, UUID,FinalDiscount,DueDate,Temperature, SDCID , IncludedTaxAmount, RoundingDifference, InvoiceNumber)
                VALUES ({0},{1},'{2}',{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{24},{25},{26},{27},{28},{29},{30},{31},{32},{33},{34},{35},{36},{37},{38},{39},{40},{41},{42},{43},{44},{45},{46},{47},{48},{49},'{50}', '{51}',{52},{53},{54},{55} ,{56}, {57},{58})",
                 transaction.CustomerId,//0
                 transaction.OutletId,//1
                 transaction.TransactionId,//2
                 transaction.EmployeeId,//3
                 LocalUtilities.ParseDateAndTimeToSQL(transaction.TransactionDate),//4
                 (int)transaction.TransactionType.GetHashCode(),//5
                 transaction.Discount,//6
                 transaction.Tax,//7
                 transaction.RemainingAmount,//8
                 (string.IsNullOrEmpty(transaction.SourceTransactionId) ? "NULL" : "'" + transaction.SourceTransactionId + "'"),//9
                 transaction.GrossTotal,//10
                 transaction.NetTotal,//11
                 (transaction.CurrencyId == 0 ? "NULL" : transaction.CurrencyId.ToString()),//12
                 transaction.GPSLatitude,//13
                 transaction.GPSLongitude,//14
                 (transaction.Voided == true ? 1 : 0),//15
                 (transaction.Notes == null || string.IsNullOrEmpty(transaction.Notes.Trim()) ? "NULL" : "'" + transaction.Notes.Trim().Replace("'", "''") + "'"),//16
                 transaction.TransactionStatusId.GetHashCode(), //17
                 (transaction.RouteId == -1 ? "NULL" : transaction.RouteId.ToString()),//18
                 (transaction.WarehouseId == -1 ? "NULL" : transaction.WarehouseId.ToString()),//19
                 transaction.CreatedBy,//20
                 LocalUtilities.ParseDateAndTimeToSQL(transaction.CreatedDate),//21
                 0,//22
                 "[Transaction]",//23
                 (transaction.AccountId == -1 ? "NULL" : transaction.AccountId.ToString()),//24
                 transaction.DivisionId,//25
                 (transaction.Posted ? 1 : 0),//26
                 (transaction.RouteHistoryId == 0 ? "NULL" : transaction.RouteHistoryId.ToString()),//27
                 transaction.VisitNo.ToString(),//28
                 0,//29 //(transaction.PromotedDiscount == -1 ? "0" : transaction.PromotedDiscount.ToString()),
                 (transaction.SalesMode == SalesModes.None ? "NULL" : ((int)transaction.SalesMode).ToString()),//30
                 (transaction.SupervisorId == 0 || transaction.SupervisorId == -1 ? "NULL" : transaction.SupervisorId.ToString()),//31
                 (transaction.HelperId == 0 || transaction.HelperId == -1 ? "NULL" : transaction.HelperId.ToString()),//32
                  (int)transaction.CreationReason,//33
                 transaction.CollectionDiscount,//34
                 (string.IsNullOrEmpty(transaction.LPONumber) || string.IsNullOrEmpty(transaction.LPONumber.Trim()) ? "NULL" : "'" + transaction.LPONumber.Replace("'", "''").Trim() + "'"),//35
                 (transaction.SalesManagerId == 0 || transaction.SalesManagerId == -1 ? "NULL" : transaction.SalesManagerId.ToString()),//36
                 (transaction.OrganizationId == 0 || transaction.OrganizationId == -1 ? "NULL" : transaction.OrganizationId.ToString()),//37
                 (transaction.DriverId == 0 || transaction.DriverId == -1 ? "NULL" : transaction.DriverId.ToString()),//38
                 (transaction.SalesRepId == 0 || transaction.SalesRepId == -1 ? "NULL" : transaction.SalesRepId.ToString()),//39
                 (transaction.IsUpdatedInFO == true ? 1 : 0),//40
                 (string.IsNullOrEmpty(transaction.RefOrderId) ? "NULL" : "'" + transaction.RefOrderId + "'"),//41
                 (string.IsNullOrEmpty(transaction.SoldBy) ? "NULL" : "'" + transaction.SoldBy.Replace("'", "''") + "'"),//42
                 1,//43
                 transaction.SelectedCurrencyId,//44
                 transaction.ExchangeRate//45
                 , LocalUtilities.ParseDateAndTimeToSQL(transaction.TransactionDate),//46
                 _requestRepository.CurrentOperator.EmployeeId//47
                , transaction.CalculatedRetailTax //48
                , transaction.DocumentReasonID // 49
                , string.IsNullOrEmpty(transaction.ShipTo) ? "NULL" : transaction.ShipTo.Trim().Replace("'", "''") //50
                , System.Guid.NewGuid() //51
                , transaction.FinalDiscount //52
                , (transaction.DueDate != DateTime.MinValue && (transaction.SalesMode == SalesModes.CreditSales || transaction.TransactionTypeId == TransactionType.CreditNote.GetHashCode())) ? LocalUtilities.ParseDateAndTimeToSQL(transaction.DueDate) : "NULL" //53 
                , transaction.Tempreture //54
                , transaction.SDCId > 0 ? transaction.SDCId.ToString() : "NULL" // 55
                , _requestRepository.Configurations.ShowIncludedTaxAmount && _requestRepository.Configurations.IncludeTaxInPrice ? transaction.IncludedTaxAmount : 0 // 56
                , transaction.RoundingDifference == 0 ? "NULL": transaction.RoundingDifference.ToString(), // 57
                  (string.IsNullOrEmpty(transaction.InvoiceNumber) ? "NULL" : "'" + transaction.InvoiceNumber + "'")//58
                 ); 

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveTestTransactionHeader(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@"INSERT INTO TestTransaction
                (CustomerID , OutletID , TransactionID , EmployeeID , TransactionDate , TransactionTypeID ,
                Discount , Tax , RemainingAmount , SourceTransactionID , GrossTotal , NetTotal ,CurrencyID,
                GPSLatitude , GPSLongitude , Voided , Notes ,TransactionStatusID , RouteID, WarehouseID 
                , CreatedBy ,CreatedDate,Synchronized,AccountID,DivisionID,Posted,RouteHistoryID,VisitNo
                ,PromotedDiscount,SalesMode,SupervisorID,HelperID,CreationReason,CollectionDiscount,LPONumber,SalesManagerID,OrganizationID,DriverID,SalesRepID,IsUpdatedInFO,RefOrderID,SoldBy,Downloaded,SelectedCurrencyID, ExchangeRate, UpdatedDate, UpdatedBy,ExciseTax,DocumentReasonID, Description, UUID,FinalDiscount,DueDate,Temperature, SDCID , IncludedTaxAmount)
                VALUES ({0},{1},'{2}',{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21},{22},{24},{25},{26},{27},{28},{29},{30},{31},{32},{33},{34},{35},{36},{37},{38},{39},{40},{41},{42},{43},{44},{45},{46},{47},{48},{49},'{50}', '{51}',{52},{53},{54},{55} ,{56})",
                 transaction.CustomerId,//0
                 transaction.OutletId,//1
                 transaction.TransactionId,//2
                 transaction.EmployeeId,//3
                 LocalUtilities.ParseDateAndTimeToSQL(transaction.TransactionDate),//4
                 (int)transaction.TransactionType.GetHashCode(),//5
                 transaction.Discount,//6
                 transaction.Tax,//7
                 transaction.RemainingAmount,//8
                 (string.IsNullOrEmpty(transaction.SourceTransactionId) ? "NULL" : "'" + transaction.SourceTransactionId + "'"),//9
                 transaction.GrossTotal,//10
                 transaction.NetTotal,//11
                 (transaction.CurrencyId == 0 ? "NULL" : transaction.CurrencyId.ToString()),//12
                 transaction.GPSLatitude,//13
                 transaction.GPSLongitude,//14
                 (transaction.Voided == true ? 1 : 0),//15
                 (transaction.Notes == null || string.IsNullOrEmpty(transaction.Notes.Trim()) ? "NULL" : "'" + transaction.Notes.Trim().Replace("'", "''") + "'"),//16
                 transaction.TransactionStatusId.GetHashCode(), //17
                 (transaction.RouteId == -1 ? "NULL" : transaction.RouteId.ToString()),//18
                 (transaction.WarehouseId == -1 ? "NULL" : transaction.WarehouseId.ToString()),//19
                 transaction.CreatedBy,//20
                 LocalUtilities.ParseDateAndTimeToSQL(transaction.CreatedDate),//21
                 0,//22
                 "[Transaction]",//23
                 (transaction.AccountId == -1 ? "NULL" : transaction.AccountId.ToString()),//24
                 transaction.DivisionId,//25
                 (transaction.Posted ? 1 : 0),//26
                 (transaction.RouteHistoryId == 0 ? "NULL" : transaction.RouteHistoryId.ToString()),//27
                 transaction.VisitNo.ToString(),//28
                 0,//29 //(transaction.PromotedDiscount == -1 ? "0" : transaction.PromotedDiscount.ToString()),
                 (transaction.SalesMode == SalesModes.None ? "NULL" : ((int)transaction.SalesMode).ToString()),//30
                 (transaction.SupervisorId == 0 || transaction.SupervisorId == -1 ? "NULL" : transaction.SupervisorId.ToString()),//31
                 (transaction.HelperId == 0 || transaction.HelperId == -1 ? "NULL" : transaction.HelperId.ToString()),//32
                  (int)transaction.CreationReason,//33
                 transaction.CollectionDiscount,//34
                 (string.IsNullOrEmpty(transaction.LPONumber) || string.IsNullOrEmpty(transaction.LPONumber.Trim()) ? "NULL" : "'" + transaction.LPONumber.Replace("'", "''").Trim() + "'"),//35
                 (transaction.SalesManagerId == 0 || transaction.SalesManagerId == -1 ? "NULL" : transaction.SalesManagerId.ToString()),//36
                 (transaction.OrganizationId == 0 || transaction.OrganizationId == -1 ? "NULL" : transaction.OrganizationId.ToString()),//37
                 (transaction.DriverId == 0 || transaction.DriverId == -1 ? "NULL" : transaction.DriverId.ToString()),//38
                 (transaction.SalesRepId == 0 || transaction.SalesRepId == -1 ? "NULL" : transaction.SalesRepId.ToString()),//39
                 (transaction.IsUpdatedInFO == true ? 1 : 0),//40
                 (string.IsNullOrEmpty(transaction.RefOrderId) ? "NULL" : "'" + transaction.RefOrderId + "'"),//41
                 (string.IsNullOrEmpty(transaction.SoldBy) ? "NULL" : "'" + transaction.SoldBy.Replace("'", "''") + "'"),//42
                 1,//43
                 transaction.SelectedCurrencyId,//44
                 transaction.ExchangeRate//45
                 , LocalUtilities.ParseDateAndTimeToSQL(transaction.TransactionDate),//46
                 _requestRepository.CurrentOperator.EmployeeId//47
                , transaction.CalculatedRetailTax //48
                , transaction.DocumentReasonID // 49
                , string.IsNullOrEmpty(transaction.ShipTo) ? "NULL" : transaction.ShipTo.Trim().Replace("'", "''") //50
                , System.Guid.NewGuid() //51
                , transaction.FinalDiscount //52
                , (transaction.DueDate != DateTime.MinValue && (transaction.SalesMode == SalesModes.CreditSales || transaction.TransactionTypeId == TransactionType.CreditNote.GetHashCode())) ? LocalUtilities.ParseDateAndTimeToSQL(transaction.DueDate) : "NULL" //53 
                , transaction.Tempreture //54
                , transaction.SDCId > 0 ? transaction.SDCId.ToString() : "NULL" // 55
                , _requestRepository.Configurations.ShowIncludedTaxAmount && _requestRepository.Configurations.IncludeTaxInPrice ? transaction.IncludedTaxAmount : 0 // 56
                 );

                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveTransactionDetails(TransactionModel transaction, bool savePackBatch, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                foreach (ItemPackModel pack in transaction.AllItems)
                {

                    string query = string.Format(@" INSERT INTO  TransactionDetail(CustomerID,OutletID,TransactionID,PackID,Quantity,Price,BasePrice,Tax,BaseTax,Discount,BaseDiscount,PackStatusID,ReturnReason,SalesTransactionTypeID,BatchNo,ExpiryDate ,Warehoused,FOCTypeID, DivisionID,FinalDiscount,PromotedDiscount,ItemPromotedDiscount, AllItemDiscount, AchievementDiscount, UsedPriceListID,ExciseTax,BaseExciseTax, DiscountPercentage,TaxPercentage,BaseTaxPercentage)VALUES
                   ({0},{1},'{2}',{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},'{14}',{15},{16},{17},{18},{19},{20},{21},{22},{23}, {24},{25},{26},{27},{28},{29})",
                   transaction.CustomerId, //0
                   transaction.OutletId,//1
                   transaction.TransactionId,//2
                   pack.PackId,//3
                   pack.RequiredQty,//4
                   pack.Price,//5
                   pack.BasePrice,//6
                   pack.CalculatedTax,//7
                   pack.CalculatedBaseTax,//8
                   pack.CalculatedDiscountTotal,//9
                   pack.CalculatedDiscount,//10
                   (pack.PackStatusId == -1 ? 0 : pack.PackStatusId),//11
                   0,//12
                   pack.SalesTransactionTypeId.GetHashCode(),//13
                    savePackBatch ? pack.BatchNo : LocalUtilities.DefaultBatchNo,//14
                    savePackBatch ? LocalUtilities.ParseDateToSQLString(pack.ExpiryDate) : LocalUtilities.ParseDateToSQLString(LocalUtilities.DefaultExpiryDate),//15
                   0, //Warehoused      16
                   "NULL",//17
                   transaction.DivisionId,//18
                   0,//19
                   pack.CalculatedPromotedDiscount,//20
                   pack.ItemPromotedDiscount,//21
                   pack.AllItemDiscount,//22
                   0,//23
                   pack.UsedPriceListId,//24
                   pack.CalculatedRetailTax,//25
                   pack.RetailPrice * pack.RetailTax / 100,//26
                   pack.Discount,//27
                   pack.Tax,//28
                   pack.BaseTax); //29

                    result = dbHelper.ExecuteNonQuery(query);
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors SaveTransactionDetailsOnBatchLevel(TransactionModel transaction, ItemPackModel pack, DBHelper<int> dBHelper, Batch batch)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                // Apply calculations over applied batch quantity
                if (pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturn)
                {
                    CalculatePackTotal(pack);
                }

                string query = string.Format(@" INSERT INTO  TransactionDetail(CustomerID,OutletID,TransactionID,PackID,Quantity,Price,BasePrice,Tax,BaseTax,Discount,BaseDiscount,PackStatusID,ReturnReason,SalesTransactionTypeID,BatchNo,ExpiryDate ,Warehoused,FOCTypeID, DivisionID,FinalDiscount,PromotedDiscount,ItemPromotedDiscount, AllItemDiscount, AchievementDiscount, UsedPriceListID,ConsumerPriceListID , ConsumerPrice, Sequence,ExciseTax,BaseExciseTax,TaxPercentage,BaseTaxPercentage,NetTotal,DiscountPercentage,DynamicTargetDiscount,PromotedDiscountPercentage,DefaultPrice,RelatedToTargetDisPercentage, ShelfIncentiveDiscount, HeaderDiscount ,TaxIncludedInPrice , IncludedTaxAmount)VALUES
                ({0},{1},'{2}',{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},'{14}',{15},{16},{17},{18},{19},{20},{21},{22},{23}, {24},{25},{26},{27},{28},{29},{30},{31},{32},{33},{34},{35},{36},{37},{38},{39},{40},{41})",
                transaction.CustomerId,//0
                transaction.OutletId,//1
                transaction.TransactionId,//2
                pack.PackId,//3
                pack.RequiredQty,//4
                pack.Price,//5
                pack.BasePrice,//6
                pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturn || _requestRepository.Configurations.AllowTaxOverFreeItems ? pack.CalculatedTax : 0,//7
                _requestRepository.Configurations.IncludeTaxInPrice ? pack.CalculatedBaseTax : pack.CalculatedTax,//8 pack.CalculatedBaseTax,
                pack.CalculatedDiscountTotal, //9
                pack.CalculatedDiscount,//10
                (pack.PackStatusId == -1 ? 0 : pack.PackStatusId), //11
                //pack.ReasonId.ToString(),//12
                pack.ReturnReasonId, //12
                batch.SalesTransactionTypeId != -1? batch.SalesTransactionTypeId : pack.SalesTransactionTypeId.GetHashCode(),//13
                batch.BatchNumber,//14
                LocalUtilities.ParseDateToSQLString(batch.ExpiryDate),//15
                0, // 16  Warehoused 
                (pack.FOCTypeId == -1 ? "NULL" : pack.FOCTypeId.ToString()),//17
                transaction.DivisionId,//18
                0,  //19 finalDiscount,
                pack.CalculatedPromotedDiscount,//20
                pack.CalculatedItemPromotedDiscount,//21
                pack.CalculatedAllItemPromotedDiscount,//22
                pack.RetailCalculatedPromotedDiscount + pack.WholeSalesCalPromotedDiscount, //23 achievementDiscount, 
                pack.UsedPriceListId, //24
                pack.ConsumerPriceListId, //25
                pack.ConsumerPrice, //26
                pack.Sequence, //27
                pack.CalculatedRetailTax, //28
                pack.RetailPrice * pack.RetailTax / 100, //29
                pack.Tax, //30
                pack.BaseTax, //31
                pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturnAsDiscount ? pack.NetTotal : 0, //32
                pack.Discount, //33
                pack.DynamicCalTargetPromotedDiscount,//34
                pack.PromotedDiscount, //35
                pack.DefaultPrice, //36
                pack.RelatedToTargetDiscount, // 37
                pack.ShelfIncentiveDiscountAmount, // 38
                pack.ShelfIncentiveDiscountAmount, // 39 temporary... (Header discount should be Header discount + shelf incentive but header is not handled on web yet.)
                _requestRepository.Configurations.IncludeTaxInPrice ? pack.TaxIncludedInPrice : 0, // 40
                _requestRepository.Configurations.IncludeTaxInPrice && _requestRepository.Configurations.ShowIncludedTaxAmount ? pack.IncludedTaxAmount : 0 // 41
                );

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors SaveTestTransactionDetailsOnBatchLevel(TransactionModel transaction, ItemPackModel pack, DBHelper<int> dBHelper, Batch batch)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                // Apply calculations over applied batch quantity
                if (pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturn)
                {
                    CalculatePackTotal(pack);
                }

                string query = string.Format(@" INSERT INTO  TestTransactionDetail(CustomerID,OutletID,TransactionID,PackID,Quantity,Price,BasePrice,Tax,BaseTax,Discount,BaseDiscount,PackStatusID,ReturnReason,SalesTransactionTypeID,BatchNo,ExpiryDate ,Warehoused,FOCTypeID, DivisionID,FinalDiscount,PromotedDiscount,ItemPromotedDiscount, AllItemDiscount, AchievementDiscount, UsedPriceListID,ConsumerPriceListID , ConsumerPrice, Sequence,ExciseTax,BaseExciseTax,TaxPercentage,BaseTaxPercentage,NetTotal,DiscountPercentage,DynamicTargetDiscount,PromotedDiscountPercentage,DefaultPrice,RelatedToTargetDisPercentage, ShelfIncentiveDiscount, HeaderDiscount ,TaxIncludedInPrice , IncludedTaxAmount)VALUES
                ({0},{1},'{2}',{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},'{14}',{15},{16},{17},{18},{19},{20},{21},{22},{23}, {24},{25},{26},{27},{28},{29},{30},{31},{32},{33},{34},{35},{36},{37},{38},{39},{40},{41})",
                transaction.CustomerId,//0
                transaction.OutletId,//1
                transaction.TransactionId,//2
                pack.PackId,//3
                pack.RequiredQty,//4
                pack.Price,//5
                pack.BasePrice,//6
                pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturn || _requestRepository.Configurations.AllowTaxOverFreeItems ? pack.CalculatedTax : 0,//7
                _requestRepository.Configurations.IncludeTaxInPrice ? pack.CalculatedBaseTax : pack.CalculatedTax,//8 pack.CalculatedBaseTax,
                pack.CalculatedDiscountTotal, //9
                pack.CalculatedDiscount,//10
                (pack.PackStatusId == -1 ? 0 : pack.PackStatusId), //11
                //pack.ReasonId.ToString(),//12
                pack.ReturnReasonId, //12
                batch.SalesTransactionTypeId != -1 ? batch.SalesTransactionTypeId : pack.SalesTransactionTypeId.GetHashCode(),//13
                batch.BatchNumber,//14
                LocalUtilities.ParseDateToSQLString(batch.ExpiryDate),//15
                0, // 16  Warehoused 
                (pack.FOCTypeId == -1 ? "NULL" : pack.FOCTypeId.ToString()),//17
                transaction.DivisionId,//18
                0,  //19 finalDiscount,
                pack.CalculatedPromotedDiscount,//20
                pack.CalculatedItemPromotedDiscount,//21
                pack.CalculatedAllItemPromotedDiscount,//22
                pack.RetailCalculatedPromotedDiscount + pack.WholeSalesCalPromotedDiscount, //23 achievementDiscount, 
                pack.UsedPriceListId, //24
                pack.ConsumerPriceListId, //25
                pack.ConsumerPrice, //26
                pack.Sequence, //27
                pack.CalculatedRetailTax, //28
                pack.RetailPrice * pack.RetailTax / 100, //29
                pack.Tax, //30
                pack.BaseTax, //31
                pack.SalesTransactionTypeId != SalesTransactionTypes.FreeReturnAsDiscount ? pack.NetTotal : 0, //32
                pack.Discount, //33
                pack.DynamicCalTargetPromotedDiscount,//34
                pack.PromotedDiscount, //35
                pack.DefaultPrice, //36
                pack.RelatedToTargetDiscount, // 37
                pack.ShelfIncentiveDiscountAmount, // 38
                pack.ShelfIncentiveDiscountAmount, // 39 temporary... (Header discount should be Header discount + shelf incentive but header is not handled on web yet.)
                _requestRepository.Configurations.IncludeTaxInPrice ? pack.TaxIncludedInPrice : 0, // 40
                _requestRepository.Configurations.IncludeTaxInPrice && _requestRepository.Configurations.ShowIncludedTaxAmount ? pack.IncludedTaxAmount : 0 // 41
                );

                result = dBHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public void CalculatePackTotal(ItemPackModel itemPack)
        {
            try
            {
                itemPack.CalculatedTax = 0;
                itemPack.CalculatedDiscount = 0;
                itemPack.CalculatedPromotedDiscount = 0;
                itemPack.CalculatedDiscountTotal = 0;
                itemPack.CalculatedRetailTax = 0;
                itemPack.GrossTotal = 0;
                itemPack.NetTotal = 0;
                decimal addedExciseTax = 0;
                //itemPack.isCalculated = false;
                bool applyRoundingPerLine = _requestRepository.Configurations.ApplyRoundingOnCalculations;
                if (_requestRepository.Configurations.AllowTaxOverFreeItems && (itemPack.SalesTransactionTypeId == SalesTransactionTypes.Promotion || itemPack.SalesTransactionTypeId == SalesTransactionTypes.FOC))
                {
                    itemPack.GrossTotal = itemPack.BasePrice * itemPack.RequiredQty;
                    itemPack.Discount = 0;
                }
                else
                    itemPack.GrossTotal = itemPack.Price * itemPack.RequiredQty;

                if (applyRoundingPerLine)
                {
                    itemPack.GrossTotal = LocalUtilities.GetRoundedDecimal(itemPack.GrossTotal, _requestRepository.Configurations.NumberOfDigits);
                }
              
                    itemPack.CalculatedRetailTax = (itemPack.RetailTax * itemPack.RetailPrice / 100) * itemPack.RequiredQty;
                
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedRetailTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedRetailTax, _requestRepository.Configurations.NumberOfDigits);
                }
                if (_requestRepository.Configurations.IncludeExciseTaxInDiscount)
                {
                    addedExciseTax = itemPack.CalculatedRetailTax;
                    if (applyRoundingPerLine)
                    {
                        addedExciseTax = LocalUtilities.GetRoundedDecimal(addedExciseTax, _requestRepository.Configurations.NumberOfDigits);
                    }
                }
                if (itemPack.DiscountTypeId == DiscountValueTypes.Percentage.GetHashCode())
                {
                    itemPack.CalculatedDiscount = (itemPack.GrossTotal + addedExciseTax) * (itemPack.Discount / 100);
                }
                else
                {
                    itemPack.CalculatedDiscount = itemPack.Discount;
                    if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                    {
                        itemPack.CalculatedDiscount = itemPack.CalculatedDiscount * itemPack.RequiredQty;
                    }
                    itemPack.Discount = (100 * itemPack.CalculatedDiscount) / (itemPack.GrossTotal + addedExciseTax);
                }
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscount, _requestRepository.Configurations.NumberOfDigits);
                    itemPack.Discount = LocalUtilities.GetRoundedDecimal(itemPack.Discount, _requestRepository.Configurations.NumberOfDigits);
                }

                itemPack.CalculatedDiscountTotal = itemPack.CalculatedDiscount;

                itemPack.CalculatedItemPromotedDiscount = (itemPack.GrossTotal - itemPack.CalculatedDiscountTotal) * (itemPack.ItemPromotedDiscount / 100);
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedItemPromotedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedItemPromotedDiscount, _requestRepository.Configurations.NumberOfDigits);
                }

                itemPack.CalculatedAllItemPromotedDiscount = (itemPack.GrossTotal - itemPack.CalculatedDiscountTotal) * (itemPack.AllItemDiscount / 100);
                if (_requestRepository.Configurations.ApplyRoundingOnCalculations)
                {
                    itemPack.CalculatedAllItemPromotedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedAllItemPromotedDiscount, _requestRepository.Configurations.NumberOfDigits);
                }

                itemPack.CalculatedPromotedDiscount = ((itemPack.GrossTotal + addedExciseTax) - itemPack.CalculatedDiscountTotal) * (itemPack.PromotedDiscount / 100);
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedPromotedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedPromotedDiscount, _requestRepository.Configurations.NumberOfDigits);
                }
                itemPack.CalculatedDiscountTotal = itemPack.CalculatedDiscountTotal + itemPack.CalculatedPromotedDiscount;

                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedDiscountTotal = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscountTotal, _requestRepository.Configurations.NumberOfDigits);
                }

                itemPack.ShelfIncentiveDiscountAmount = (itemPack.GrossTotal - itemPack.CalculatedDiscountTotal) * itemPack.ShelfIncentiveDiscount / 100;
                if (applyRoundingPerLine)
                {
                    itemPack.ShelfIncentiveDiscountAmount = LocalUtilities.GetRoundedDecimal(itemPack.ShelfIncentiveDiscountAmount, _requestRepository.Configurations.NumberOfDigits);
                }
                if (!_requestRepository.Configurations.CalculateShelfIncentiveAfterTax)
                {
                    itemPack.CalculatedDiscountTotal += itemPack.ShelfIncentiveDiscountAmount;
                    if (applyRoundingPerLine)
                    {
                        itemPack.CalculatedDiscountTotal = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscountTotal, _requestRepository.Configurations.NumberOfDigits);
                    }
                }

                if (_requestRepository.Configurations.CalculateTaxBeforeDiscounts)
                {
                    if (_requestRepository.Configurations.IncludeTaxInPrice)
                    {
                        itemPack.CalculatedBaseTax = (itemPack.BasePrice * itemPack.RequiredQty + itemPack.CalculatedRetailTax) * (itemPack.BaseTax / 100);
                    }
                    itemPack.CalculatedTax = (itemPack.GrossTotal + itemPack.CalculatedRetailTax) * (itemPack.Tax / 100);
                }
                else
                {
                    if (_requestRepository.Configurations.IncludeTaxInPrice)
                    {
                        itemPack.CalculatedBaseTax = (itemPack.BasePrice * itemPack.RequiredQty + itemPack.CalculatedRetailTax - itemPack.CalculatedDiscountTotal) * (itemPack.BaseTax / 100);
                    }
                    itemPack.CalculatedTax = (itemPack.GrossTotal + itemPack.CalculatedRetailTax - itemPack.CalculatedDiscountTotal) * (itemPack.Tax / 100);
                }
                if (applyRoundingPerLine && !_requestRepository.Configurations.ApplyZATCARoundingRules)
                {
                    itemPack.CalculatedTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedTax, _requestRepository.Configurations.NumberOfDigits);
                    itemPack.CalculatedBaseTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedBaseTax, _requestRepository.Configurations.NumberOfDigits);
                }
                if (_requestRepository.Configurations.CalculateShelfIncentiveAfterTax)
                {
                    itemPack.CalculatedDiscountTotal += itemPack.ShelfIncentiveDiscountAmount;
                    if (applyRoundingPerLine)
                    {
                        itemPack.CalculatedDiscountTotal = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscountTotal, _requestRepository.Configurations.NumberOfDigits);
                    }
                }
                if (_requestRepository.Configurations.AllowTaxOverFreeItems && (itemPack.SalesTransactionTypeId == SalesTransactionTypes.Promotion || itemPack.SalesTransactionTypeId == SalesTransactionTypes.FOC))
                {
                    if (_requestRepository.Configurations.ExcludeBasePriceFromFreeItemsVAT)
                    {
                        itemPack.CalculatedTax = itemPack.CalculatedRetailTax * (itemPack.BaseTax / 100);
                        itemPack.CalculatedBaseTax = itemPack.CalculatedRetailTax * (itemPack.BaseTax / 100);
                    }
                    else
                    {
                        itemPack.CalculatedTax = itemPack.CalculatedRetailTax * itemPack.BaseTax / 100;
                        itemPack.CalculatedBaseTax = itemPack.CalculatedRetailTax * itemPack.BaseTax / 100;
                    }

                    if (applyRoundingPerLine && !_requestRepository.Configurations.ApplyZATCARoundingRules)
                    {
                        itemPack.CalculatedTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedTax, _requestRepository.Configurations.NumberOfDigits);
                        itemPack.CalculatedBaseTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedBaseTax, _requestRepository.Configurations.NumberOfDigits);
                    }
                    itemPack.NetTotal = itemPack.CalculatedTax + itemPack.CalculatedRetailTax;
                }
                else
                {
                    itemPack.NetTotal = itemPack.GrossTotal + itemPack.CalculatedTax + itemPack.CalculatedRetailTax - itemPack.CalculatedDiscountTotal;
                }

                // itemPack.isCalculated = true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public ItemPackModel CalculatePackTotals(ItemPackModel itemPack)
        {
            try
            {
                itemPack.CalculatedTax = 0;
                itemPack.CalculatedDiscount = 0;
                itemPack.CalculatedPromotedDiscount = 0;
                itemPack.CalculatedDiscountTotal = 0;
                itemPack.CalculatedRetailTax = 0;
                itemPack.GrossTotal = 0;
                itemPack.NetTotal = 0;
                //itemPack.isCalculated = false;
                bool applyRoundingPerLine = _requestRepository.Configurations.ApplyRoundingOnCalculations;
                if (_requestRepository.Configurations.AllowTaxOverFreeItems && (itemPack.SalesTransactionTypeId == SalesTransactionTypes.Promotion || itemPack.SalesTransactionTypeId == SalesTransactionTypes.FOC))
                {
                    itemPack.GrossTotal = itemPack.BasePrice * itemPack.RequiredQty;
                    itemPack.Discount = 0;
                }
                else
                    itemPack.GrossTotal = itemPack.Price * itemPack.RequiredQty;

                if (applyRoundingPerLine)
                {
                    itemPack.GrossTotal = LocalUtilities.GetRoundedDecimal(itemPack.GrossTotal, _requestRepository.Configurations.NumberOfDigits);
                }
                itemPack.CalculatedRetailTax = (itemPack.RetailTax * itemPack.RetailPrice / 100) * itemPack.RequiredQty;
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedRetailTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedRetailTax, _requestRepository.Configurations.NumberOfDigits);
                }
                if (itemPack.DiscountTypeId == DiscountValueTypes.Percentage.GetHashCode())
                {
                    itemPack.CalculatedDiscount = itemPack.GrossTotal * (itemPack.Discount / 100);
                }
                else
                {
                    itemPack.CalculatedDiscount = itemPack.Discount;
                    if (_requestRepository.Configurations.ApplyAmountDiscountPerQuantity)
                    {
                        itemPack.CalculatedDiscount = itemPack.CalculatedDiscount * itemPack.RequiredQty;
                    }
                    itemPack.Discount = (100 * itemPack.CalculatedDiscount) / itemPack.GrossTotal;
                }
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscount, _requestRepository.Configurations.NumberOfDigits);
                    itemPack.Discount = LocalUtilities.GetRoundedDecimal(itemPack.Discount, _requestRepository.Configurations.NumberOfDigits);
                }

                itemPack.CalculatedDiscountTotal = itemPack.CalculatedDiscount;

                itemPack.CalculatedPromotedDiscount = (itemPack.GrossTotal - itemPack.CalculatedDiscountTotal) * (itemPack.PromotedDiscount / 100);
                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedPromotedDiscount = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedPromotedDiscount, _requestRepository.Configurations.NumberOfDigits);
                }
                itemPack.CalculatedDiscountTotal = itemPack.CalculatedDiscountTotal + itemPack.CalculatedPromotedDiscount;

                if (applyRoundingPerLine)
                {
                    itemPack.CalculatedDiscountTotal = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedDiscountTotal, _requestRepository.Configurations.NumberOfDigits);
                }

                if (_requestRepository.Configurations.CalculateTaxBeforeDiscounts)
                {
                    itemPack.CalculatedTax = (itemPack.GrossTotal + itemPack.CalculatedRetailTax) * (itemPack.Tax / 100);
                }
                else
                {
                    itemPack.CalculatedTax = (itemPack.GrossTotal + itemPack.CalculatedRetailTax - itemPack.CalculatedDiscountTotal) * (itemPack.Tax / 100);
                }
                if (applyRoundingPerLine && !_requestRepository.Configurations.ApplyZATCARoundingRules)
                {
                    itemPack.CalculatedTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedTax, _requestRepository.Configurations.NumberOfDigits);
                }
                if (_requestRepository.Configurations.AllowTaxOverFreeItems && (itemPack.SalesTransactionTypeId == SalesTransactionTypes.Promotion || itemPack.SalesTransactionTypeId == SalesTransactionTypes.FOC))
                {
                    if (_requestRepository.Configurations.ExcludeBasePriceFromFreeItemsVAT)
                        itemPack.CalculatedTax = itemPack.CalculatedRetailTax * (itemPack.BaseTax / 100);
                    else
                        itemPack.CalculatedTax = (itemPack.GrossTotal + itemPack.CalculatedRetailTax) * (itemPack.BaseTax / 100);

                    if (applyRoundingPerLine && !_requestRepository.Configurations.ApplyZATCARoundingRules)
                    {
                        itemPack.CalculatedTax = LocalUtilities.GetRoundedDecimal(itemPack.CalculatedTax, _requestRepository.Configurations.NumberOfDigits);
                    }
                    itemPack.NetTotal = itemPack.CalculatedTax + itemPack.CalculatedRetailTax;
                }
                else
                {
                    itemPack.NetTotal = itemPack.GrossTotal + itemPack.CalculatedTax + itemPack.CalculatedRetailTax - itemPack.CalculatedDiscountTotal;
                }

                // itemPack.isCalculated = true;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return itemPack;
        }

        public decimal GetTransactionRemainingAmount(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            decimal remainingAmount = 0;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = string.Format(" Select RemainingAmount From [Transaction] Where TransactionID = '{0}' and DivisionID = {1} ", transaction.TransactionId, transaction.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    remainingAmount = decimal.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                remainingAmount = 0;
            }
            return remainingAmount;
        }
        public GlobalErrors GetTransactionBalanceChangeValue(TransactionModel transaction, ref decimal balanceChange, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"select NetTotal - ISNULL (pp.PaymentsTotal, 0)
                from [Transaction] T
                left join (
                select sum(AppliedAmount) PaymentsTotal, TransactionID, CustomerID, OutletID, DivisionID
                from CustomerPayment 
                where Posted = 1 and PaymentStatusID not in ({4})
                group by TransactionID, CustomerID, OutletID, DivisionID
                )pp on pp.TransactionID = T.TransactionID and pp.CustomerID = T.CustomerID and pp.OutletID = T.OutletID and pp.DivisionID = T.DivisionID
                where T.TransactionID =  '{0}' and T.CustomerID = {1} and T.OutletID = {2} and T.DivisionID = {3}",
                transaction.TransactionId,
                transaction.CustomerId,
                transaction.OutletId,
                transaction.DivisionId,
                PaymentStatusTypes.Voided.GetHashCode());
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && decimal.Parse(field.ToString()) > 0)
                {
                    balanceChange = decimal.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public bool CheckIfTranasctionPaymentCoveredOtherTransactions(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"Select IsNull(Count(*),0) Counttt From CustomerPayment
                where CustomerPaymentID in(Select CustomerPaymentID from CustomerPayment where TransactionID ='{0}' and CustomerID = {1} and OutletID = {2} and DivisionId = {3} and PaymentStatusID not in ({4}) ) 
                Group by CustomerPaymentID
                Having Count(*) > 1",
                transaction.TransactionId,
                transaction.CustomerId,
                transaction.OutletId,
                transaction.DivisionId,
                PaymentStatusTypes.Voided.GetHashCode());
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool IsAnyReturnDependantOnOrderTransaction(OrderModel order)
        {
            bool boolResult = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                TransactionModel orderTransaction = new TransactionModel();
                DBHelper<TransactionModel> dbHelper = new DBHelper<TransactionModel>();
                string query = string.Format(" SELECT TransactionID FROM [Transaction] WHERE SourceTransactionID = '{0}' And voided <> 1 ", order.OrderId);
                result = dbHelper.GetQuerySingle(query, ref orderTransaction);
                if (result == GlobalErrors.Success && orderTransaction != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                    DBHelper<int> dbHelper2 = new DBHelper<int>();
                    orderTransaction.CustomerId = order.CustomerId;
                    orderTransaction.OutletId = order.OutletId;

                    boolResult = CheckIfAnyReturnsDependOnTransaction(orderTransaction, dbHelper2);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return boolResult;
        }
        public bool IsOrderDeliveredInFO(OrderModel order)
        {
            bool boolResult = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = new object();
            try
            {
                TransactionModel orderTransaction = new TransactionModel();
                DBHelper<TransactionModel> dbHelper = new DBHelper<TransactionModel>();
                string query = string.Format(" SELECT count(*) count FROM [Transaction] WHERE SourceTransactionID = '{0}' And voided <> 1 and CreationReason = {1} ", order.OrderId, TransactionCreationReason.OrderDeliveryFOInvoice.GetHashCode());
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && int.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return boolResult;
        }
        public bool CheckIfAnyReturnsDependOnTransaction(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = $@"Select Count(*) FROM ReturnInvoicesHistory
                INNER JOIN [Transaction] On ReturnInvoicesHistory.ReturnTransactionID = [Transaction].TransactionID
                And ReturnInvoicesHistory.CustomerID = [Transaction].CustomerID
                And ReturnInvoicesHistory.OutletID = [Transaction].OutletID
                WHERE ReturnInvoicesHistory.SalesTransactionID = '{transaction.TransactionId}' AND ReturnInvoicesHistory.CustomerID = {transaction.CustomerId}
                AND ReturnInvoicesHistory.OutletID = {transaction.OutletId} And [Transaction].Voided <> 1";
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool CheckIfDNIsGeneratedFromBounceCheque(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"Select IsNull(Count(*),0) Counttt From CustomerPayment 
                where CustomerPaymentId = '{0}' and CustomerId = {1} and OutletId = {2} and DivisionId = {3} and PaymentStatusId = {4}",
                transaction.SourceTransactionId,
                transaction.CustomerId,
                transaction.OutletId,
                transaction.DivisionId,
                PaymentStatusTypes.Bounced.GetHashCode());
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool CheckIfCNIsGeneratedFromDownPayment(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"Select IsNull(Count(*),0) Counttt From CustomerUnallocatedPayment 
                where CustomerPaymentId = '{0}' and CustomerId = {1} and OutletId = {2} and DevisionID = {3} and (Voided is null or Voided = 0)",
                transaction.SourceTransactionId,
                transaction.CustomerId,
                transaction.OutletId,
                transaction.DivisionId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool InvoiceIsVoided(string tableName, TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"SELECT IsNull(Count(*),0)Rows from {4} Where TransactionID = '{0}' and [Transaction].CustomerID = {1} And [Transaction].OutletID = {2} And [Transaction].DivisionID = {3} And [Transaction].Voided = 1", transaction.TransactionId, transaction.CustomerId, transaction.OutletId, transaction.DivisionId,tableName);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool InvoiceIsUploaded(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"SELECT Uploaded from RouteHistory Where RouteHistory.RouteHistoryID = {0} ", transaction.RouteHistoryId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && (field.ToString().Equals("1") || field.ToString().ToLower().Equals("true")))
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool CustomerIsUploaded(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"select count(*) from(
select distinct
DENSE_RANK()  OVER (PARTITION BY Routehistory.routeId,Routehistory.Employeeid ORDER BY syncDate DESC) AS routeSeq,RouteHistory.RouteHistoryID, RouteHistory.RouteID,RouteHistory.syncDate
,RouteHistory.Uploaded
from RouteHistory
inner join RouteHistoryDetail on RouteHistoryDetail.RouteHistoryID=RouteHistory.RouteHistoryID
where RouteHistory.RouteID={0} and  RouteHistoryDetail.CustomerID={1} and RouteHistoryDetail.OutletID={2}
)t
where t.routeSeq=1 and t.Uploaded=1  ", transaction.RouteId, transaction.CustomerId, transaction.OutletId);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && (field.ToString().Equals("1") || field.ToString().ToLower().Equals("true")))
                    {
                        return true;
                    }
                    else
                    {
                        return false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }
        public bool InvoiceHasChild(string tableName, TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = new object();
                string query = string.Format(@"SELECT IsNull(Count(*),0)Rows from {4} Where SourceTransactionID ='{0}' And voided <> 1", transaction.TransactionId, transaction.CustomerId, transaction.OutletId, transaction.DivisionId, tableName);
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()) && Int32.Parse(field.ToString()) > 0)
                {
                    return true;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return false;
        }

        public GlobalErrors GetTransactionsHistory(CustomerFilter filter, ref SharedTableResult<TransactionHistory> transList)
        {
            List<TransactionHistory> transactions = new List<TransactionHistory>();
            DBHelper<TransactionHistory> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionHistory>(_requestRepository.CurrentOperator.EmployeeId);
                //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                //The Old Query Was One Part Contains Or Condition, So After Splitting It With Union, 
                //We Found A Case That The Order Date Is Greater Than The Transaction Date So We Added The Third 
                //Part Of The New Query
                //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
                //XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX




                string mainQuery = @"Select 
    {1} CustomerId , {2} OutletId ,
	SO.OrderID , SO.CreatedDate OrderDate , EL.Description OrderBy , SO.NetTotal + ISNULL(SO.DeliveryValue, 0) OrderValue ,
	TR.TransactionID , TR.CreatedDate InvoiceDate , EL2.Description DeliveredBy , TR.NetTotal InvoiceValue ,
CASE 
	When SO.OrderStatusID IS NULL THEN 9 
	ELSE SO.OrderStatusID
	END OrderStatusID , 
    OSL.Description Status,
CASE 
	WHEN  SO.OrderID IS NOT NULL THEN 'Order'
	WHEN  SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 'ICash'
	ELSE 'Invoice' END OrderType ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason <> {8} THEN 1
	ELSE 0 END IsTransaction ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 1
	ELSE 0 END IsTopUp ,
CASE 
	WHEN SO.OrderID IS NOT NULL THEN 1
	ELSE 0 END IsOrder,
	Customer.CustomerCode ,
	CustomerOutlet.CustomerCode OutletCode,
	CustomerLanguage.Description CustomerName ,
	CustomerOutletLanguage.Description OutletName ,
	SO.DesiredDeliveryDate ,
    OrderSourceLanguage.Description OrderSource,SO.DeliveryChargesId,
	SO.DeliveryValue, SO.DeliveryTax
FROM SalesOrder SO with (nolock)
FULL OUTER JOIN (Select * FROM [Transaction] Where [Transaction].TransactionTypeID = {7} AND CustomerID = {1} AND OutletID = {2} AND Voided <> 1) TR on TR.SourceTransactionID = SO.OrderID 
LEFT JOIN EmployeeLanguage EL on EL.EmployeeID = SO.EmployeeID AND EL.LanguageID = {0}
LEFT JOIN EmployeeLanguage EL2 on EL2.EmployeeID = TR.EmployeeID AND EL2.LanguageID = {0}
LEFT JOIN OrderStatusLanguage OSL on OSL.OrderStatusID = SO.OrderStatusID AND OSL.LanguageID = {0} 
LEFT JOIN OrderSourceLanguage ON OrderSourceLanguage.OrderSourceID = SO.OrderSourceID AND OrderSourceLanguage.LanguageID = {0} 
INNER JOIN Customer on Customer.CustomerID = {1}
INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = {1} AND CustomerOutlet.OutletID = {2}
LEFT JOIN CustomerLanguage on CustomerLanguage.CustomerID = {1} AND CustomerLanguage.LanguageID = {0}
and CustomerLanguage.OrganizationId in ({11})
LEFT JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = {1} AND CustomerOutletLanguage.OutletID = {2} AND  CustomerOutletLanguage.LanguageID = {0}
WHERE SO.CustomerID = {1} AND SO.OutletID = {2}
 {3}
 {4}
union
Select 
    {1} CustomerId , {2} OutletId ,
	SO.OrderID , SO.CreatedDate OrderDate , EL.Description OrderBy , SO.NetTotal + ISNULL(SO.DeliveryValue, 0) OrderValue ,
	TR.TransactionID , TR.CreatedDate InvoiceDate , EL2.Description DeliveredBy , TR.NetTotal InvoiceValue ,
CASE 
	When SO.OrderStatusID IS NULL THEN 9 
	ELSE SO.OrderStatusID
	END OrderStatusID , 
    OSL.Description Status,
CASE 
	WHEN  SO.OrderID IS NOT NULL THEN 'Order'
	WHEN  SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 'ICash'
	ELSE 'Invoice' END OrderType ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason <> {8} THEN 1
	ELSE 0 END IsTransaction ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 1
	ELSE 0 END IsTopUp ,
CASE 
	WHEN SO.OrderID IS NOT NULL THEN 1
	ELSE 0 END IsOrder,
	Customer.CustomerCode ,
	CustomerOutlet.CustomerCode OutletCode,
	CustomerLanguage.Description CustomerName ,
	CustomerOutletLanguage.Description OutletName ,
	SO.DesiredDeliveryDate ,
    OrderSourceLanguage.Description OrderSource,SO.DeliveryChargesId,
	SO.DeliveryValue, SO.DeliveryTax
FROM SalesOrder SO with (nolock)
full JOIN (Select * FROM [Transaction] Where [Transaction].TransactionTypeID = {7} AND CustomerID = {1} AND OutletID = {2} AND Voided <> 1) TR on TR.SourceTransactionID = SO.OrderID 
LEFT JOIN EmployeeLanguage EL on EL.EmployeeID = SO.EmployeeID AND EL.LanguageID = {0}
LEFT JOIN EmployeeLanguage EL2 on EL2.EmployeeID = TR.EmployeeID AND EL2.LanguageID = {0}
LEFT JOIN OrderStatusLanguage OSL on OSL.OrderStatusID = SO.OrderStatusID AND OSL.LanguageID = {0} 
LEFT JOIN OrderSourceLanguage ON OrderSourceLanguage.OrderSourceID = SO.OrderSourceID AND OrderSourceLanguage.LanguageID = {0} 
INNER JOIN Customer on Customer.CustomerID = {1}
INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = {1} AND CustomerOutlet.OutletID = {2}
LEFT JOIN CustomerLanguage on CustomerLanguage.CustomerID = {1} AND CustomerLanguage.LanguageID = {0}
LEFT JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = {1} AND CustomerOutletLanguage.OutletID = {2} AND  CustomerOutletLanguage.LanguageID = {0}
WHERE 
TR.CustomerID = {1}  AND
TR.OutletID = {2} 
{5}
{6}
 union
Select 
    {1} CustomerId , {2} OutletId ,
	SO.OrderID , SO.CreatedDate OrderDate , EL.Description OrderBy , SO.NetTotal + ISNULL(SO.DeliveryValue, 0) OrderValue ,
	TR.TransactionID , TR.CreatedDate InvoiceDate , EL2.Description DeliveredBy , TR.NetTotal InvoiceValue ,
CASE 
	When SO.OrderStatusID IS NULL THEN 9 
	ELSE SO.OrderStatusID
	END OrderStatusID , 
    OSL.Description Status,
CASE 
	WHEN  SO.OrderID IS NOT NULL THEN 'Order'
	WHEN  SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 'ICash'
	ELSE 'Invoice' END OrderType ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason <> {8} THEN 1
	ELSE 0 END IsTransaction ,
CASE 
	WHEN SO.OrderID IS NULL AND TR.CreationReason = {8} THEN 1
	ELSE 0 END IsTopUp ,
CASE 
	WHEN SO.OrderID IS NOT NULL THEN 1
	ELSE 0 END IsOrder,
	Customer.CustomerCode ,
	CustomerOutlet.CustomerCode OutletCode,
	CustomerLanguage.Description CustomerName ,
	CustomerOutletLanguage.Description OutletName ,
	SO.DesiredDeliveryDate ,
    OrderSourceLanguage.Description OrderSource,SO.DeliveryChargesId,
	SO.DeliveryValue, SO.DeliveryTax
FROM SalesOrder SO with (nolock)
full JOIN (Select * FROM [Transaction] Where [Transaction].TransactionTypeID = {7} AND CustomerID = {1} AND OutletID = {2} AND Voided <> 1) TR on TR.SourceTransactionID = SO.OrderID 
LEFT JOIN EmployeeLanguage EL on EL.EmployeeID = SO.EmployeeID AND EL.LanguageID = {0}
LEFT JOIN EmployeeLanguage EL2 on EL2.EmployeeID = TR.EmployeeID AND EL2.LanguageID = {0}
LEFT JOIN OrderStatusLanguage OSL on OSL.OrderStatusID = SO.OrderStatusID AND OSL.LanguageID = {0} 
LEFT JOIN OrderSourceLanguage ON OrderSourceLanguage.OrderSourceID = SO.OrderSourceID AND OrderSourceLanguage.LanguageID = {0} 
INNER JOIN Customer on Customer.CustomerID = {1}
INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = {1} AND CustomerOutlet.OutletID = {2}
LEFT JOIN CustomerLanguage on CustomerLanguage.CustomerID = {1} AND CustomerLanguage.LanguageID = {0}
LEFT JOIN CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = {1} AND CustomerOutletLanguage.OutletID = {2} AND  CustomerOutletLanguage.LanguageID = {0}
WHERE 
TR.CustomerID = {1} AND
TR.OutletID = {2}
{3}
{6}
/*OrderByPart*/
/*FetchingPart*/";
                string dateFilter1 = "";
                string dateFilter2 = "";

                string idFilter1 = "";
                string idFilter2 = "";






                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    idFilter1 = $" AND  SO.OrderID LIKE '%{filter.CustomListFilter.SearchFilter.Trim()}%'";
                    idFilter2 = $" AND  TR.TransactionID LIKE '%{filter.CustomListFilter.SearchFilter.Trim()}%'";
                }

                if (filter.FromToDate.Count == 2)
                {
                    dateFilter1 = $@"And Convert(date ,SO.OrderDate)  between Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date)} ) and Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date)} ) ";
                    dateFilter2 = $@"And Convert(date ,TR.TransactionDate) between Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date)} ) and Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date)} ) ";
                }
                mainQuery = string.Format(mainQuery,
                    _requestRepository.LanguageId,//0
                    filter.CustomerId,//1
                    filter.OutletId,//2
                    idFilter1,//3
                    dateFilter1,//4
                    idFilter2,//5
                    dateFilter2,//6
                    (int)TransactionType.Sales,//7
                    _requestRepository.LanguageId,//8
                    _requestRepository.LanguageId,//9
                    TransactionCreationReason.iCashTopUp.GetHashCode(), //10
                    _requestRepository.CurrentOperator.OrganizationAccess //11
                    );


                // get count
                var countQuery = $"select Count(*) From({mainQuery})t";
                string dataQuery = mainQuery.Replace("/*OrderByPart*/", "order by InvoiceDate DESC,OrderDate DESC")
                    .Replace("/*FetchingPart*/", string.Format(
                 @"OFFSET     {0} ROWS
                FETCH NEXT {1} ROWS ONLY", filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, filter.CustomListFilter.PageSize));
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    result = dbHelper.GetQueryList(dataQuery, ref transactions);
                    transList.Data = transactions;
                }
                else
                {
                    return GlobalErrors.Error;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetOrdersHistory(CustomerFilter filter, ref List<CRMOrderDetailsModel> ordersDetails)
        {
            DBHelper<CRMOrderDetailsModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string orderStatusColorSelection = string.Empty;
            try
            {
                int daysStart = 0;
                int daysEnd = 0;
                if (_requestRepository.Configurations.EnableBookedQuantity)
                {
                    string BookedQtyPeriod = _requestRepository.Configurations.BookedQtyPeriod;
                    if (!string.IsNullOrEmpty(BookedQtyPeriod) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim()) && BookedQtyPeriod.Trim().Split(',') != null && BookedQtyPeriod.Trim().Split(',').Length == 2)
                    {
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0].Trim()))
                        {
                            daysStart = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[0].Trim());
                        }
                        if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1].Trim()))
                        {
                            daysEnd = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[1].Trim());
                        }
                    }
                }
                if (_requestRepository.Configurations.UseMainStatusInOrderHistory)
                {
                    orderStatusColorSelection = $" IsNull(OrderMainStatusColor.OrderStatusColor,'Yellow') OrderStatusColor";
                }
                else
                {
                    orderStatusColorSelection = $" OrderStatusColorLanguage.Description OrderStatusColor";
                }
                int days = 0;
                string dateFilter = string.Empty;
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.Today)
                {
                    days = 1;
                }
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.InLast3Days)
                {
                    days = 3;
                }
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.InLast30Days)
                {
                    days = 30;
                }
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.InLast90Days)
                {
                    days = 90;
                }
                if (days == 1)
                {
                    dateFilter = $" And Convert(date ,SO.OrderDate)  between Convert(date ,  {LocalUtilities.ParseDateToSQLString(DateTime.Now)} ) and Convert(date ,  {LocalUtilities.ParseEndDateToSQLString(DateTime.Now)}) ";
                }
                if (days > 1)
                {
                    dateFilter = $" And SO.OrderDate >= DATEADD(DD, -{days}, CONVERT(date, GETDATE())) ";
                }
                if (filter.OrderHistoryFilterType == OrderHistoryFilterType.CustomRange && filter.FromToDate != null && filter.FromToDate.Count == 2)
                {
                    dateFilter = $" And Convert(date ,SO.OrderDate)  between Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date)} ) and Convert(date ,  {LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date)}) ";
                }
                bool isStockStatusMode = _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock && _requestRepository.Configurations.ConsiderStockStatusInOrderFlow;

                dbHelper = new DBHelper<CRMOrderDetailsModel>(_requestRepository.CurrentOperator.EmployeeId);
                string query = $@"Declare 
                @EmployeeID int = {_requestRepository.CurrentOperator.EmployeeId},
                @CustomerID int = {filter.CustomerId},
                @OutletID int = {filter.OutletId},
                @WarehouseID int = { Int32.Parse(filter.WarehouseIds)},
                @LanguageID int = {_requestRepository.LanguageId},
                @StarDateForBooked int = {daysStart},
                @EndDateForBooked int = {daysEnd},
                @CalculateBookedQty bit = {_requestRepository.Configurations.EnableBookedQuantity.GetHashCode()},
                @CalculateBlockedQty bit = {_requestRepository.Configurations.EnableBlockedQuantity.GetHashCode()};

                declare @BookedStock as table(ItemID int, bookedQty numeric(19, 9),StockStatusID int)
                if (@CalculateBookedQty = 1)
                begin
                insert into @BookedStock
                Select pack.ItemID, isnull(sum(SOD.Quantity * Pack.quantity), 0) bookedQty, SOD.StockStatusID
                 from salesorder SO
                inner join Employee on Employee.EmployeeId = SO.EmployeeId
                inner join SalesOrderDetail SOD on SO.Orderid = SOD.Orderid and SO.CustomerID = SOD.CustomerID and SO.OutletId = SOD.OutletId and
                SO.DivisionId = SOD.DivisionId
                inner join pack on pack.packID = SOD.PackID
                left outer join WarehouseTransaction WT on WT.SourceTransactionID = SO.OrderID and WT.DivisionId = SO.DivisionId
                AND WT.WarehouseTransactionStatusID = 1 and SO.OrderStatusID in (4)
                where 1 = 1 And
                (SO.WarehouseID in (@WarehouseID)OR(
                ISNULL(SO.WarehouseID, -1) = -1 and SO.EmployeeID in
                (select EmployeeID from EmployeeVehicle where VehicleID in
                (select VehicleID from VehicleLoadingWh where WarehouseID in (@WarehouseID)))))
                And(SO.OrderStatusID in (4, 1, 2, 3, 7, 14) OR(SO.OrderStatusID = 6 And SO.WarehouseTransactionID is null))
                And OrderTypeID = 1
                And SO.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) 
                And SO.DesiredDeliveryDate >= CONVERT(datetime, DATEADD(day, @StarDateForBooked, CONVERT(date, GETDATE())), 102)
                And SO.DesiredDeliveryDate <= CONVERT(datetime, DATEADD(day, @EndDateForBooked, CONVERT(date, GETDATE())), 102)
                group by pack.ItemID,SOD.StockStatusID
                end

                Declare @BlockedQty as table(ItemID int, WarehouseBlockedQty numeric(19, 9),StockStatusID int)
                if (@CalculateBlockedQty = 1)
                begin
                insert into @BlockedQty
                select pack.ItemID, isnull(sum(WarehouseBlockedQty.Quantity * Pack.quantity), 0) WarehouseBlockedQty, 
                WarehouseBlockedQty.StockStatusID from WarehouseBlockedQty
                inner join pack on pack.packID = WarehouseBlockedQty.PackID Where WarehouseBlockedQty.WarehouseId in (@WarehouseID)
                group by pack.ItemID,WarehouseBlockedQty.StockStatusID
                end

                Declare @ItemStock as table (ItemID int, AvailableQtyInPcs numeric(19, 9), StockStatusID int)
                insert into @ItemStock
                Select pack.ItemID, Sum(pack.Quantity * WarehouseStock.Quantity) AvailableQtyInPcs, WarehouseStock.StockStatusID
                From pack
                inner join WarehouseStock on WarehouseStock.PackID = pack.PackID and WarehouseStock.WarehouseID in (@WarehouseID)
                Where IsNull(WarehouseStock.IsReserved, 0) = 0
                group by pack.ItemID, WarehouseStock.StockStatusID

                
                SELECT tt.*,
                ((tt.GrossTotal - tt.NormalDiscountAmount - tt.PromotedDiscountAmount + tt.ExciseTax) * tt.Tax / 100) 
                +
                (tt.GrossTotal - tt.NormalDiscountAmount - tt.PromotedDiscountAmount + tt.ExciseTax)  As NetTotal
                From (
                SELECT Distinct Item.ItemType ItemTypeId, Item.ItemID, item.ItemCategoryID, Item.ModelID, 
                Pack.PackTypeID, Pack.PackID, Pack.Quantity PiecesInPack,
                PackTypeLanguage.Description Uom, ItemLanguage.Description ItemName, Item.ItemCode, 
                IsNull( Item.ItemCode , '--') + ' ' + '-'+ ' ' + IsNull( ItemLanguage.Description , '--') as ItemCodeName, 
                ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0) as StockQty,
                (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0) / Pack.Quantity) as ExistingQty,
                CASE WHEN SO.OrderDate >= DATEADD(DD,-3,CONVERT(date, GETDATE())) THEN 1 ELSE 0 END InLast3Days, 
                CASE WHEN SO.OrderDate >= DATEADD(DD,-30,CONVERT(date, GETDATE())) THEN 1 ELSE 0 END InLast30Days, 
                CASE WHEN SO.OrderDate >= DATEADD(DD,-90,CONVERT(date, GETDATE())) THEN 1 ELSE 0 END InLast90Days,
                SSC.Description Color, SSC.Description IconColor, 'fa fa-circle fa-2x' icon, SOD.StockStatusID, SOD.SalesOrderTypeID, SO.EmployeeId, EL.Description OrderBy,
                SOD.Discount, SOD.DiscountTypeId, SOD.Quantity RequiredQty,
                SO.OrderID, SO.CustomerID, SO.OutletID, SO.DivisionID, SO.OrganizationID OrderOrganizationID, SO.OrderDate, SO.NetTotal OrderNetTotal,
                OrderSubStatusLanguage.OrderSubStatusID, case when SO.Synchronized = 0 then  'Not sent to SAP yet' else OrderSubStatusLanguage.Description end as OrderSubStatus,
                OrderStatusLanguage.OrderStatusID, OrderStatusLanguage.Description OrderStatus, {orderStatusColorSelection}, SO.Synchronized,

                ISNULL(SOD.price, 0) Price, ISNULL(SOD.tax, 0) Tax, IsNull(SOD.ExciseTax, 0) ExciseTax,
				SOD.Quantity*Price As GrossTotal,
				SOD.Quantity*Price*SOD.Discount /100 As NormalDiscountAmount, 
                (SOD.Quantity * Price - (SOD.Quantity*Price*SOD.Discount /100))*SOD.PromotedDiscount /100 As PromotedDiscountAmount,
                CASE WHEN SO.OrderStatusID = 1 AND IsNull(SO.Synchronized,0) = 0 THEN 1 ELSE 0 END as AllowEdit,
                Case when (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0)) / Pack.Quantity <= 0 or SOD.SalesTransactionTypeID in (2,4) then 0 else 1 end As IsChecked,
                Case when (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0)) / Pack.Quantity <= 0 or SOD.SalesTransactionTypeID in (2,4) then 1 else 0 end As DisableCheckBox,
                Case when (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0)) / Pack.Quantity <= 0 then '#D3D3D3' 
                     when (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0)) / Pack.Quantity >= 0 and (ISNull(ItemStock.AvailableQtyInPcs,0) - isnull(bookedStock.bookedQty,0) + isnull(blockedQty.WarehouseBlockedQty,0)) / Pack.Quantity < (SOD.Quantity * Pack.Quantity) then '#FEF1CF' 
                     Else '' End As BackColor

                FROM Item
                INNER JOIN Pack ON Pack.ItemID = Item.ItemID
                INNER JOIN SalesOrderDetail SOD on SOD.PackID = Pack.PackID
                INNER JOIN SalesOrder SO on SO.OrderID = SOD.OrderID and SO.DivisionID = SOD.DivisionID and SO.CustomerID = SOD.CustomerID and SO.OutletID = SOD.OutletID
                LEFT join StockStatus on StockStatus.StockStatusID = SOD.StockStatusID and StockStatus.SalesOrderTypeID = SOD.SalesOrderTypeID
                LEFT join StockStatusColors SSC on SSC.ColorID = StockStatus.ColorID and SSC.LanguageID = 1
                LEFT JOIN ItemLanguage ON ItemLanguage.ItemID = Item.ItemID AND ItemLanguage.LanguageID = @LanguageID
                LEFT JOIN EmployeeLanguage EL ON EL.EmployeeId = SO.EmployeeId AND EL.LanguageID = @LanguageID
                LEFT JOIN PackTypeLanguage ON PackTypeLanguage.PackTypeID = Pack.PackTypeID AND PackTypeLanguage.LanguageID = @LanguageID
                LEFT OUTER join @BlockedQty blockedQty on blockedQty.ItemID = Item.ItemID and blockedQty.StockStatusID = SOD.StockStatusID
                LEFT OUTER join @BookedStock bookedStock on bookedStock.ItemID = Item.ItemID and bookedStock.StockStatusID = SOD.StockStatusID
                LEFT JOIN @ItemStock ItemStock on ItemStock.ItemID = Item.ItemID and ItemStock.StockStatusID = SOD.StockStatusID
                LEFT join OrderStatusLanguage on OrderStatusLanguage.OrderStatusID = SO.OrderStatusID and OrderStatusLanguage.LanguageID = @LanguageID
                LEFT join OrderSubStatus on OrderSubStatus.OrderStatusID = SO.OrderStatusID and OrderSubStatus.OrderSubStatusID = IsNull(SO.OrderSubStatusID,1)
                LEFT join OrderSubStatusLanguage on OrderSubStatusLanguage.OrderStatusID = SO.OrderStatusID and OrderSubStatusLanguage.OrderSubStatusID = IsNull(SO.OrderSubStatusID,1)
                and OrderSubStatusLanguage.LanguageID = @LanguageID
                LEFT join OrderStatusColorLanguage on  OrderStatusColorLanguage.OrderStatusColorID = OrderSubStatus.OrderStatusColorID and OrderStatusColorLanguage.LanguageID = 1
                LEFT join OrderMainStatusColor on OrderMainStatusColor.OrderStatusID = SO.OrderStatusID
                Where SO.OrganizationId in ({_requestRepository.CurrentOperator.OrganizationAccess}) And SO.CustomerId = @CustomerId and SO.OutletId = @OutletId {dateFilter}
                )tt
                Order By tt.OrderDate Desc";

                result = dbHelper.GetQueryList(query, ref ordersDetails, true);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, _requestRepository.CurrentOperator.EmployeeId);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors GetTransactionDetailsAsReport(TransactionHistory transactionModel, ref List<ItemPackModel> itemPacksList)
        {
            DBHelper<ItemPackModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();

                string query = string.Format(@"SELECT
											[Transaction].TransactionID,
                                            TransactionDetail.packId ,
											Item.ItemCode,
											ItemLanguage.Description AS itemName,
											PackTypeLanguage.Description Uom,
											SUM(CAST(ROUND( ISNULL(SOD.Quantity , 0)  , {1} )AS numeric(19, {1}))) AS OrderdQuantity ,  
											SUM(CAST(ROUND(TransactionDetail.Quantity , {1} )AS numeric(19, {1}))) AS RequiredQty ,
											CAST(ROUND(TransactionDetail.Price,{2}) AS numeric(19,{2}))  Price  , 
                                            SUM(CAST(ROUND(TransactionDetail.price * TransactionDetail.Quantity , {2} )AS numeric(19, {2}))) AS GrossTotal ,
											SUM(CAST(ROUND(TransactionDetail.Discount , {2} )AS numeric(19, {2}))) AS Discount ,
											SUM(CAST(ROUND(TransactionDetail.Tax , {2} )AS numeric(19, {2}))) AS Tax ,
                                            SUM(CAST(ROUND(TransactionDetail.ExciseTax , {2} )AS numeric(19, {2}))) AS CalculatedRetailTax ,
											SUM(CAST(ROUND((TransactionDetail.price * TransactionDetail.Quantity) + TransactionDetail.Tax + TransactionDetail.ExciseTax- TransactionDetail.Discount, {2} )AS numeric(19, {2}))) AS NetTotal ,
                                            Item.ItemID
                                            FROM  TransactionDetail with (nolock)
                                            inner join [Transaction]  with (nolock) ON [Transaction].TransactionID = TransactionDetail.TransactionID
                                            inner join pack on pack.PackID=TransactionDetail.PackID
                                            inner join item on Item.ItemID=Pack.ItemID
											LEFT JOIN SalesOrderDetail SOD with (nolock) on SOD.OrderID = [Transaction].SourceTransactionID AND SOD.PackID = TransactionDetail.PackID AND SOD.SalesTransactionTypeID = TransactionDetail.SalesTransactionTypeID
                                            INNER JOIN ItemCategory on Item.ItemCategoryID = ItemCategory .ItemCategoryID
                                            LEFT OUTER  JOIN PackTypeLanguage on PackTypeLanguage.PackTypeID=pack.PackTypeID AND PackTypeLanguage.LanguageID = {0}
                                            LEFT OUTER  JOIN ItemLanguage on ItemLanguage.ItemID=item.ItemID AND ItemLanguage.LanguageID = {0}
                                            WHERE
                                            [Transaction].TransactionID = '{3}' and [Transaction].CustomerID= {4} and [Transaction].OutletID= {5}
                                            and [Transaction].DivisionID = {6}
                                            Group by [Transaction].TransactionID,TransactionDetail.packId ,Item.ItemCode,ItemLanguage.Description ,PackTypeLanguage.Description ,TransactionDetail.Price,Item.ItemID,TransactionDetail.Sequence ,TransactionDetail.SalesTransactionTypeID
                                            Order by TransactionDetail.SalesTransactionTypeID,item.itemID,TransactionDetail.Sequence,ItemLanguage.Description"
                                            , _requestRepository.LanguageId
                                            , _requestRepository.Configurations.NumberOfStockDigits
                                            , _requestRepository.Configurations.NumberOfDigits
                                           , transactionModel.TransactionId,
                                           transactionModel.CustomerId,
                                           transactionModel.OutletId,
                                           transactionModel.DivisionId);

                result = dbHelper.GetQueryList(query, ref itemPacksList);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetOrderDetailsAsReport(TransactionHistory transactionModel, ref List<ItemPackModel> itemPacksList)
        {
            DBHelper<ItemPackModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                string selection = string.Empty;
                string groupBy = string.Empty;
                string stockStatusJoin = string.Empty;
                itemPacksList = new List<ItemPackModel>();
                string orderByColorStatus = string.Empty;
                if (_requestRepository.Configurations.ConsiderStockStatusInOrderFlow && _requestRepository.Configurations.ConsiderStockStatusInWarehouseStock)
                {
                    selection = string.Format(@"CAST(ROUND(SalesOrderDetail.Quantity, {0}) AS numeric(19,{0})) requiredQty,
                    ISNULL(SalesOrderDetail.ExciseTax, 0) CalculatedRetailTax, 
                    ISNULL(SalesOrderDetail.Discount, 0) Discount, 
                    ISNULL(SalesOrderDetail.PromotedDiscount, 0) PromotedDiscount, 
                    StockStatusColors.Description Color, ", _requestRepository.Configurations.NumberOfStockDigits);

                    stockStatusJoin = string.Format(@" INNER JOIN StockStatus on StockStatus.StockStatusID = SalesOrderDetail.StockStatusID
				    INNER JOIN StockStatusColors on StockStatusColors.ColorID = StockStatus.ColorID and StockStatusColors.LanguageID = 1 ");

                    orderByColorStatus = " ,  StockStatus.StockStatusID ";
                }
                else
                {
                    selection = string.Format(@" SUM(CAST(ROUND(SalesOrderDetail.Quantity, {0}) AS numeric(19,{0}))) requiredQty,
                    SUM(ISNULL(SalesOrderDetail.ExciseTax, 0)) CalculatedRetailTax, 
                    SUM(ISNULL(SalesOrderDetail.Discount, 0)) Discount, 
                    SUM(ISNULL(SalesOrderDetail.PromotedDiscount, 0)) PromotedDiscount,  ", _requestRepository.Configurations.NumberOfStockDigits);

                    groupBy = string.Format(@"group by Item.ItemCode,ItemLanguage.Description, PackTypeLanguage.Description,SalesOrderDetail.Price,  SalesOrderDetail.Tax,SalesOrderDetail.orderID,
                    SalesOrder.DeliveryChargesId,SalesOrder.DeliveryValue, SalesOrder.DeliveryTax");
                }
                string query = string.Format(@"
                SELECT   
                SalesOrderDetail.OrderID,
                Item.ItemCode, 
                ItemLanguage.Description ItemName, 
                PackTypeLanguage.Description  UOM, 
                SalesOrderDetail.Price, 
                SalesOrderDetail.Tax, 
                {4}
                SalesOrder.DeliveryChargesId,
				SalesOrder.DeliveryValue,
                SalesOrder.DeliveryTax
                FROM  SalesOrderDetail with (nolock)  
                INNER JOIN   SalesOrder  with (nolock)  ON SalesOrderDetail.OrderID = SalesOrder.OrderID     
                INNER JOIN   Pack ON SalesOrderDetail.PackID = Pack.PackID    
                left  JOIN   PackTypeLanguage ON Pack.PackTypeID = PackTypeLanguage.PackTypeID and PackTypeLanguage.LanguageID = {0}  
                INNER JOIN   Item ON Pack.ItemID = Item.ItemID  left  JOIN   ItemLanguage ON ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageID = {0}
				{5}
                WHERE SalesOrderDetail.OrderID = '{1}' AND SalesOrder.CustomerID = {2} AND SalesOrder.OutletID = {3}    
                {6}
				  order by Item.ItemCode, ItemLanguage.Description, PackTypeLanguage.Description {7}"
            , _requestRepository.LanguageId, transactionModel.OrderId, transactionModel.CustomerId, transactionModel.OutletId,selection, stockStatusJoin,groupBy,orderByColorStatus);
                result = dbHelper.GetQueryList(query, ref itemPacksList);
                if (result == GlobalErrors.Success && itemPacksList != null && itemPacksList.Count > 0)
                {
                    itemPacksList.ForEach(i =>
                    {
                        i.GrossTotal = i.Price * i.RequiredQty;
                        i.Discount = i.GrossTotal * i.Discount / 100;
                        i.NetTotal = i.GrossTotal - i.Discount;
                        i.PromotedDiscount = i.NetTotal * i.PromotedDiscount / 100;
                        i.NetTotal = i.NetTotal - i.PromotedDiscount;
                        i.Tax = i.NetTotal * i.Tax / 100;
                        i.NetTotal = i.NetTotal + i.Tax + i.CalculatedRetailTax;
                        i.Discount = i.PromotedDiscount + i.Discount;
                    });
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetReportDetails(int reportId, TransactionHistory transactionModel, ref ReportModel reportModel, DynamicTemplateReportFileModel dynamicTemplateReport, bool isSendEmailMode, int languageId)
        {
            DBHelper<ReportModel> dbHelper = null;
            DBHelper<dynamic> dbHelper2 = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ReportModel>();
                dbHelper2 = new DBHelper<dynamic>();
                List<dynamic> itemPacksList = new List<dynamic>();
                List<dynamic> itemName = new List<dynamic>();
                string reportQuery = string.Empty;

                if (transactionModel.reportMode == ReportMode.StockCountingResult && !isSendEmailMode)
                {

                }
                else
                {
                    if (isSendEmailMode)
                    {
                        if (dynamicTemplateReport != null)
                        {
                            reportModel.QueryString = dynamicTemplateReport.Query;
                            result = GlobalErrors.Success;
                        }
                        else
                        {
                            result = GlobalErrors.Error;
                        }

                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }

                    if (result == GlobalErrors.Success && reportModel != null)
                    {
                        if (!string.IsNullOrEmpty(reportModel.QueryString))
                        {
                            reportQuery = reportModel.QueryString;
                            reportQuery = reportQuery.Replace("@LanguageId", (_requestRepository != null ? _requestRepository.LanguageId.ToString() : languageId.ToString()));//1
                            if (!isSendEmailMode)
                            {
                                reportQuery = reportQuery.Replace("@OrganizationIDAccess", _requestRepository.CurrentOperator.OrganizationAccess);//2
                                reportQuery = reportQuery.Replace("@DivisionIDAccess", _requestRepository.CurrentOperator.DivisionAccess);//3
                            }
                            if (transactionModel.TransactionId != null)
                            {
                                if (transactionModel.TransactionId.Contains("'"))
                                {
                                    string transactionId =
                                        ((transactionModel.TransactionId.Equals(transactionModel.CustomerPaymentId)) ?
                                        string.Format(@"(select TOP 1 TransactionId from CustomerPayment where CustomerPaymentID = '{0}')",
                                        transactionModel.CustomerPaymentId) :
                                        transactionModel.TransactionId);
                                    reportQuery = reportQuery.Replace("@TransactionId", transactionId);//1
                                }
                                else
                                {
                                    string transactionId =
                                        ((transactionModel.TransactionId.Equals(transactionModel.CustomerPaymentId)) ?
                                        string.Format(@"(select TOP 1 TransactionId from CustomerPayment where CustomerPaymentID = '{0}')",
                                        transactionModel.CustomerPaymentId) :
                                        "'" + transactionModel.TransactionId + "'");
                                    reportQuery = reportQuery.Replace("@TransactionId", transactionId);//1
                                }
                            }
                            reportQuery = reportQuery.Replace("@DivisionId", transactionModel.DivisionId.ToString());//2

                            reportQuery = reportQuery.Replace("@CustomerID", transactionModel.CustomerId.ToString());
                            reportQuery = reportQuery.Replace("@OutletID", transactionModel.OutletId.ToString());
                            reportQuery = reportQuery.Replace("@WarehouseID", transactionModel.WarehouseID.ToString());
                            result = dbHelper2.GetQueryList(reportQuery, ref itemPacksList);
                            if (itemPacksList.Count > 0)
                            {
                                reportModel.TransactionDetails = itemPacksList;
                            }
                        }
                    }

                    return result;
                }
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
                if (dbHelper2 != null)
                {
                    dbHelper2.Dispose();
                    dbHelper2 = null;
                }
            }
        }

        public GlobalErrors GetReportModel(int reportId,ref ReportModel reportModel)
        {
            DBHelper<ReportModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<ReportModel>();
                string query = string.Format("SELECT ReportTitle, QueryString, enabled, ReportId from WebReport where ReportId = {0}", reportId);
                result = dbHelper.GetQuerySingle(query, ref reportModel);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }

        }
        public bool CheckIfDisplayUnitContainItems(int POSID, int customerID, int outletID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            object field = null;
            bool hasItem = false;
            DBHelper<int> dBHelper = null;
            try
            {
                dBHelper = new DBHelper<int>();

                string query = string.Format(@"select Count(*) from POSCustomerOutletCapacity where POSID ={0} AND  CustomerID ={1} AND  OutletID ={2} ", POSID, customerID, outletID);

                result = dBHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success && field != null && int.Parse(field.ToString().Trim()) > 0)
                {
                    hasItem = true;
                }
                return hasItem;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return hasItem;
            }
        }

        public GlobalErrors GetCustomerUnPaidTransactions(int customerId, int outletId, ref List<TransactionModel> transactions, DBHelper<int> dBHelper)
        {
            var result = GlobalErrors.NotInitialized;
            DBHelper<TransactionModel> dbHelper1 = null;
            try
            {
                dbHelper1 = new DBHelper<TransactionModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());

                string query = string.Format(@"Select * , TR.RemainingAmount AppliedAmount
                From [Transaction] TR
                Where TR.CustomerID = {0} AND TR.OutletID = {1} 
                And  (TR.Voided is null OR TR.Voided = 0) And (TR.RemainingAmount > 0)  And TR.TransactionTypeID in (1)
                order by TR.TransactionDate", customerId, outletId);

                result = dbHelper1.GetQueryList(query, ref transactions);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors CreateCreditNoteFromDownPayment(PaymentModel downPayment, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                TransactionModel creditNoteTransaction = new TransactionModel();
                string maxCreditNoteTransID = _documentSequenceManager.GetMaxDocumentSequence(dbHelper, downPayment.EmployeeId, DocumentTypes.CreditNote, downPayment.DivisionId);
                if (string.IsNullOrEmpty(maxCreditNoteTransID))
                {
                    return GlobalErrors.Error;
                }
                creditNoteTransaction = new TransactionModel();
                creditNoteTransaction.EmployeeId = downPayment.EmployeeId;
                creditNoteTransaction.UpdatedBy = downPayment.EmployeeId;
                creditNoteTransaction.CurrencyId = downPayment.CurrencyId;
                creditNoteTransaction.AccountId = downPayment.AccountId;
                creditNoteTransaction.CustomerId = downPayment.CustomerId;
                creditNoteTransaction.OutletId = downPayment.OutletId;
                creditNoteTransaction.DivisionId = downPayment.DivisionId;
                creditNoteTransaction.SourceTransactionId = downPayment.CustomerPaymentId;
                creditNoteTransaction.TransactionDate = DateTime.Now;
                creditNoteTransaction.UpdatedDate = DateTime.Now;
                creditNoteTransaction.GrossTotal = LocalUtilities.GetRoundedDecimal(downPayment.AppliedAmount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTransaction.NetTotal = LocalUtilities.GetRoundedDecimal(downPayment.AppliedAmount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTransaction.RemainingAmount = LocalUtilities.GetRoundedDecimal(downPayment.AppliedAmount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTransaction.Tax = 0;
                creditNoteTransaction.Discount = 0;
                creditNoteTransaction.TransactionTypeId = TransactionType.CreditNote.GetHashCode();
                creditNoteTransaction.TransactionType = TransactionType.CreditNote;
                creditNoteTransaction.TransactionStatusId = TransactionStatues.Approved.GetHashCode();
                creditNoteTransaction.CreatedDate = DateTime.Now;
                creditNoteTransaction.Notes = "Generated from creating down payment " + downPayment.Notes;
                creditNoteTransaction.TransactionId = maxCreditNoteTransID;
                creditNoteTransaction.SupervisorId = downPayment.SupervisorId;
                creditNoteTransaction.HelperId = downPayment.HelperId;
                creditNoteTransaction.SalesManagerId = downPayment.SalesManagerId;
                creditNoteTransaction.OrganizationId = downPayment.OrganizationId;
                creditNoteTransaction.DriverId = downPayment.DriverId;
                creditNoteTransaction.SalesRepId = downPayment.SalesRepId;
                creditNoteTransaction.Posted = true;
                result = SaveTransactionHeader(creditNoteTransaction, dbHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dbHelper, DocumentTypes.CreditNote, creditNoteTransaction.TransactionId, creditNoteTransaction.EmployeeId, creditNoteTransaction.DivisionId);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCreditNoteGeneratedFromDownPayment(string customerPaymentId, int customerId, int outletId, int divisionId, ref TransactionModel CNTransaction, DBHelper<TransactionModel> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format(@" Select * from [Transaction] where SourceTransactionID = '{0}' and CustomerID = {1} And OutletID = {2} and DivisionId = {3}",
                customerPaymentId,//0
                customerId,//1
                outletId, //2
                divisionId //3
                );
                result = dbHelper.GetQuerySingle(query, ref CNTransaction);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetTransactionAsVoided(string transactionID, int customerID, int outletID, int divisionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"UPDATE [Transaction] SET Voided = 1, TransactionStatusID = {4}
                WHERE TransactionID = '{0}' and CustomerID = {1} and OutletID = {2} and DivisionId = {3}",
                transactionID, //0
                customerID, //1
                outletID, //2
                divisionId, //3
                TransactionStatues.Voided.GetHashCode() //4
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetTestTransactionAsVoided(string transactionID, int customerID, int outletID, int divisionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"UPDATE TestTransaction SET Voided = 1, TransactionStatusID = {4}
                WHERE TransactionID = '{0}' and CustomerID = {1} and OutletID = {2} and DivisionId = {3}",
                transactionID, //0
                customerID, //1
                outletID, //2
                divisionId, //3
                TransactionStatues.Voided.GetHashCode() //4
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors VoidTransactionPayments(string transactionId, int customerId, int outletId, int divisionId, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"UPDATE [CustomerPayment] SET PaymentStatusId = {4}
                WHERE TransactionID = '{0}' and CustomerID = {1} and OutletID = {2} and DivisionId = {3}",
                transactionId, //0
                customerId, //1
                outletId, //2
                divisionId, //3
                PaymentStatusTypes.Voided.GetHashCode() //4
                );
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SetTransactionAsPosted(string transactionID, int customerID, int outletID, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"UPDATE [Transaction] SET Posted = 1
                WHERE TransactionID = '{0}' and CustomerID = {1} and OutletID = {2}",
                transactionID, //0
                customerID, //1
                outletID //2
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors DeleteTransactionDetails(TransactionModel transaction, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = string.Format(@"delete from [TransactionDetail] 
                WHERE TransactionID = '{0}' and CustomerID = {1} and OutletID = {2}",
                transaction.TransactionId, //0
                transaction.CustomerId, //1
                transaction.OutletId //2
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public CustomerOutletModel FillTransactionOutletData(int customerId, int outletId, int divisionId)
        {
            return FillTransactionOutletData(customerId, outletId, divisionId, null);
        }
        public CustomerOutletModel FillTransactionOutletData(int customerId, int outletId, int divisionId, DBHelper<int> dBHelper)
        {
            CustomerOutletModel outlet = null;
            DBHelper<CustomerOutletModel> dbHelper2 = null;
            string paymentTermString = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper2 = new DBHelper<CustomerOutletModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper2 = new DBHelper<CustomerOutletModel>();
                }
                if (_requestRepository.Configurations.CheckPaymentTermOnCustomerLevel)
                {
                    paymentTermString = string.Format(@" Customer.PaymentTermID");
                }
                else
                {
                    paymentTermString = string.Format(@" CustomerOutlet.PaymentTermID");
                }
                outlet = new CustomerOutletModel();
                string query = string.Format(@"select Customer.CustomerCode , CustomerOutlet.CustomerCode OutletCode , CustomerOutlet.Taxeable , CustomerOutlet.TaxNumber , CustomerOutlet.OnHold ,CustomerOutlet.IsMain, Customer.OnHold as CustomerOnHold ,
                                CustomerLanguage.Description CustomerName , CustomerOutletLanguage.Description OutletName , CustomerOutlet.CustomerTypeID , {3}, CustomerOutlet.Taxeable Taxable
                                FROM CustomerOutlet
                                LEFT OUTER JOIN Customer ON CustomerOutlet.CustomerID = Customer.CustomerID
                                LEFT OUTER JOIN CustomerLanguage ON CustomerOutlet.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
                                and CustomerLanguage.OrganizationId in ({4})
                                LEFT OUTER JOIN CustomerOutletLanguage ON CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID AND CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {0}
                                WHERE CustomerOutlet.CustomerID = {1}  AND CustomerOutlet.OutletID = {2}", _requestRepository.LanguageId, customerId, outletId, paymentTermString, _requestRepository.CurrentOperator.OrganizationAccess);
                var result = dbHelper2.GetQuerySingle(query, ref outlet);
                outlet.CustomerId = customerId;
                outlet.OutletId = outletId;
                if (outlet.CustomerTypeId == CustomerTypes.CashCustomer.GetHashCode())
                {
                    outlet.IsCredit = false;
                }
                else
                {
                    outlet.IsCredit = true;
                }
                ReadCustomerAccount(ref outlet, divisionId, dBHelper);
            }
            catch (Exception ex)
            {
                outlet = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return outlet;
        }
        public void ReadCustomerAccount(ref CustomerOutletModel outlet, int divisionId, DBHelper<int> dBHelper)
        {
            DBHelper<AccountModel> dBHelper2 = null;

            AccountModel account = new AccountModel();
            string query = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dBHelper2 = new DBHelper<AccountModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dBHelper2 = new DBHelper<AccountModel>();
                }
                string orgAcess = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAcess = string.Format(" And Account.OrganizationId in ({0}) ", _requestRepository.CurrentOperator.OrganizationAccess);
                }
                if (_requestRepository.Configurations.UsePayerAccount)
                {
                    query = string.Format(@"select Account.* ,1 as Priority 
                    from Account 
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    inner join CustomerOutlet on CustomerOutlet.CustomerID = PayerAssignment.CustomerID AND CustomerOutlet.OutletID = PayerAssignment.OutletID
                    where PayerAssignment.CustomerID = {0} and PayerAssignment.OutLetID = {1}
                    and PayerAssignment.DivisionID = {2}
                    UNION
                    select Account.* ,2 as Priority 
                    from Account 
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    where PayerAssignment.CustomerID = {0} AND PayerAssignment.OutletID = -1
                    UNION
                    select Account.* ,3 as Priority 
                    from Account
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    inner join CustomerOutletGroup on CustomerOutletGroup.GroupID = PayerAssignment.CustomerGroupID 
                    AND CustomerOutletGroup.CustomerID = {0}
                    AND CustomerOutletGroup.OutletID = {1}
                    where CustomerOutletGroup.CustomerID = {0}
                    UNION
                    select Account.* ,4 as Priority 
                    from Account
                    inner join AccountPayer on Account.AccountID = AccountPayer.AccountID
                    inner join Payer on AccountPayer.PayerID = Payer.PayerID
                    inner join PayerAssignment on PayerAssignment.PayerID = Payer.PayerID
                    where PayerAssignment.AllCustomers = 1
                    order by Priority", outlet.CustomerId, outlet.OutletId, divisionId);
                }
                else
                {
                    if (_requestRepository.Configurations.UseCustomerLevelAccount)
                    {
                        query = string.Format(@"select Account.*
                    from Account
                    Inner join AccountCust on Account.AccountID = AccountCust.AccountID
                    where CustomerID = {0} {1}", outlet.CustomerId, orgAcess);
                    }
                    else
                    {
                        query = string.Format(@"select Account.* ,1 as Priority
                    from Account
                    inner join AccountCustOutDiv on Account.AccountID = AccountCustOutDiv.AccountID
                    where CustomerID = {0} and OutLetID = {1} and DivisionID = {2}
                    UNION
                    select Account.* ,2 as Priority
                    from  Account inner join AccountCustOut on Account.AccountID = AccountCustOut.AccountID
                    where CustomerID = {0} and OutLetID = {1} {3} order by Priority", outlet.CustomerId, outlet.OutletId, divisionId, orgAcess);
                    }
                }
                var result = dBHelper2.GetQuerySingle(query, ref account);

                outlet.Account = account;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }

        public GlobalErrors GetDeliveryNotesBalanceChangeValue(TransactionModel transaction, ref List<TransactionModel> deliveryNotes)
        {
            return GetDeliveryNotesBalanceChangeValue(transaction, ref deliveryNotes, null);
        }
        public GlobalErrors GetDeliveryNotesBalanceChangeValue(TransactionModel transaction, ref List<TransactionModel> deliveryNotes, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            deliveryNotes = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper2 = null;
            string query = string.Empty;
            try
            {
                if (dBHelper != null)
                {
                    dbHelper2 = new DBHelper<TransactionModel>(dBHelper.GetConnection(), dBHelper.GetDBTransaction());
                }
                else
                {
                    dbHelper2 = new DBHelper<TransactionModel>();
                }
                object field = new object();
                if (!string.IsNullOrEmpty(transaction.DeliveryNotesTransactionIds))
                {
                    query = string.Format(@"select Sum(T.NetTotal) NetTotal,T.TransactionID, T.CustomerID, T.OutletID, T.DivisionID, T.EmployeeID,T.TransactionDate,T.SalesMode
                    from [Transaction] T
                    where T.TransactionID in  ({0}) and T.CustomerID = {1} and T.RefOrderID = '{2}' and T.DivisionID = {3}
                    and T.TransactionTypeID = {4}
                    group by T.TransactionID, T.CustomerID, T.OutletID,T.DivisionID, T.EmployeeID,T.TransactionDate,T.SalesMode",
                    transaction.DeliveryNotesTransactionIds,
                    transaction.CustomerId,
                    transaction.RefOrderId,
                    transaction.DivisionId,
                    TransactionType.DeliveryNote.GetHashCode());
                }
                else
                {
                    query = string.Format(@"select Sum(T.NetTotal) NetTotal,T.TransactionID, T.CustomerID, T.OutletID, T.DivisionID, T.EmployeeID,T.TransactionDate,T.SalesMode
                    from [Transaction] T
                    Inner Join DeliveryNotesTransaction on DeliveryNotesTransaction.DeliveryNoteID= T.TransactionID and 
                    DeliveryNotesTransaction.CustomerID= T.CustomerID and DeliveryNotesTransaction.OutletID= T.OutletID
                    and DeliveryNotesTransaction.DivisionID= T.DivisionID 
                    where DeliveryNotesTransaction.TransactionID = '{0}' and T.CustomerID = {1}  and T.DivisionID = {2}
                    group by T.TransactionID, T.CustomerID, T.OutletID,T.DivisionID, T.EmployeeID,T.TransactionDate,T.SalesMode",
                    transaction.TransactionId,
                    transaction.CustomerId,
                    transaction.DivisionId);
                }
                result = dbHelper2.GetQueryList(query, ref deliveryNotes);
                if (result == GlobalErrors.Success)
                {
                    // Fill Outlet Data
                    foreach (TransactionModel trans in deliveryNotes)
                    {
                        trans.Outlet = FillTransactionOutletData(trans.CustomerId, trans.OutletId, trans.DivisionId);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors VoidTransactionsRelatedToReturn(TransactionModel ReturnTransaction, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                // Void credit / debit notes.
                string query = $" Update [Transaction] set Voided = 1 where SourceTransactionID = '{ReturnTransaction.TransactionId}' and CustomerID = {ReturnTransaction.CustomerId} and OutletID = {ReturnTransaction.OutletId} ";
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;

                if (result == GlobalErrors.Success)
                {
                    // Void payment.
                    query = $@"
                    Update CustomerPayment set PaymentStatusID = {PaymentStatusTypes.Voided.GetHashCode()} where CustomerPayment.TransactionID = (
                    select TransactionID from [Transaction] where SourceTransactionID = '{ReturnTransaction.TransactionId}' and TransactionTypeID = {TransactionType.DebitNote.GetHashCode()}
                    and CustomerID = {ReturnTransaction.CustomerId} and OutletID = {ReturnTransaction.OutletId}
                    ) and CustomerPayment.CustomerID = {ReturnTransaction.CustomerId} and CustomerPayment.OutletID = {ReturnTransaction.OutletId}";
                    result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                    if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public string GetStringQRCode(int customerId, int outletId, string transactionId, ReportMode reportMode)
        {
            DBHelper<ReportModel> dbHelper1 = null;
            DBHelper<object> dbHelper2 = null;
            var result = GlobalErrors.NotInitialized;
            string QRString = string.Empty;
            string transIdFilter = string.Empty;
            string query = string.Empty;
            try
            {
                dbHelper1 = new DBHelper<ReportModel>();
                dbHelper2 = new DBHelper<object>();
                if (reportMode == ReportMode.Delivered || reportMode == ReportMode.Invoiced)
                {
                    transactionId = GetTransactionIdFromSource(transactionId);
                    if (transactionId == null)
                    {
                        return "";
                    }
                }
                ReportModel report = new ReportModel();

                query = string.Format("SELECT ReportTitle, QueryString, enabled, ReportId from WebReport where ReportId = {0}", ReportMode.QRQuery.GetHashCode());
                result = dbHelper1.GetQuerySingle(query, ref report);
                if (result == GlobalErrors.Success && report != null)
                {
                    string reportQuery = report.QueryString;
                    reportQuery = reportQuery.Replace("@TransactionID", transactionId);
                    reportQuery = reportQuery.Replace("@CustomerID", customerId.ToString());
                    reportQuery = reportQuery.Replace("@OutletID", outletId.ToString());
                    object obj = new object();
                    result = dbHelper2.ExecuteScalar(reportQuery, ref obj);
                    if (result == GlobalErrors.Success && obj != null)
                    {
                        QRString = (string)obj;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return QRString;
        }
        public string GetTransactionIdFromSource(string sourceTransactionId)
        {
            DBHelper<object> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            string transactionId = string.Empty;
            try
            {
                dbHelper = new DBHelper<object>();
                object obj = new object();
                string query = string.Format("SELECT TransactionId FROM [Transaction] WHERE SourceTransactionID = '{0}'", sourceTransactionId);
                result = dbHelper.ExecuteScalar(query, ref obj);
                if (result == GlobalErrors.Success && obj != null)
                {
                    transactionId = (string)obj;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return transactionId;
        }
        public GlobalErrors UpdateTransactionVoidedForOrderDeliveryBOInvoice(string transactionID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            string query = string.Empty;
            try
            {
                query = string.Format(@"Update Transaction Set Voided = 0, RouteHistoryID = null Where TransactionID = '{0}'", transactionID);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors UpdateDeliveryTransactionsVoided(string orderID, string transactionID, OrderStatus oldStatus, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.Error;
            string query = string.Empty;
            string transactionFilter = string.Empty;
            try
            {
                if (!string.IsNullOrEmpty(transactionID) && oldStatus == OrderStatus.Invoiced)
                {
                    transactionFilter = string.Format(" And [Transaction].TransactionID Not IN ('{0}')", transactionID);
                }
                query = string.Format(@"Update [Transaction] Set Voided = 1 Where [Transaction].SourceTransactionID = '{0}' {1} ", orderID, transactionFilter);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected) result = GlobalErrors.Success;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsCreditNoteUsed(string transactionID, ref bool isUsed, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                object field = null;
                string query = $@"SELECT COUNT(CustomerPayment.SourceTransactionID) AS CRNcount 
                FROM  CustomerPayment 
                INNER JOIN [Transaction] ON CustomerPayment.SourceTransactionID = [Transaction].TransactionID AND CustomerPayment.PaymentTypeID = 4 
                AND [Transaction].SourceTransactionID = '{transactionID}' AND [Transaction].Voided = 0 AND CustomerPayment.PaymentStatusID <> {PaymentStatusTypes.Voided.GetHashCode()}";
                result = dbHelper.ExecuteScalar(query, ref field);
                if (result == GlobalErrors.Success)
                {
                    if (field != null && !string.IsNullOrEmpty(field.ToString()) && decimal.Parse(field.ToString()) > 0)
                    {
                        isUsed = true;
                    }
                    else
                    {
                        isUsed = false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCRMUnpaidTransactionsForCustomers(CustomerFilter filter, ref SharedTableResult<TransactionHistory> sharedTransList, ref List<PayerAccountModel> accountList)
        {
            List<TransactionHistory> transactions = new List<TransactionHistory>();
            DBHelper<TransactionHistory> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionHistory>();
                StringBuilder mainQuery = new StringBuilder();
                string accountId = string.Empty;
                if (_requestRepository.Configurations.UsePayerAccount && _requestRepository.Configurations.AllowCollectionOnPayerAccount)
                {
                    result = GetCustomerPayerAccountIds(filter.CustomerId, filter.OutletId, ref accountList);
                    if (result == GlobalErrors.Success && accountList != null && accountList.Count > 0)
                    {
                        accountId = accountList[0].AccountId.ToString();
                    }
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (string.IsNullOrEmpty(accountId))
                    {
                        return result;
                    }
                }

                mainQuery.AppendFormat(@"Select distinct T.{2} As TransactionIdInUI,
	            T.TransactionID , T.TransactionDate InvoiceDate , EL2.Description DeliveredBy , T.NetTotal InvoiceValue ,
	            T.RemainingAmount,T.AccountID,T.DivisionID,T.CustomerID,T.OutletID,T.CurrencyID,
                IsNull( Customer.CustomerCode , '--') + ' - ' + IsNull( CustomerLanguage.Description , '--') as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' - ' + IsNull( CustomerOutletLanguage.Description , '--') as OutletCodeName,T.DueDate,
                T.TransactionDate, T.SourceTransactionID, CustomerOutlet.OrganizationId as CustomerOrganizationId, T.OrganizationId,
                Case when T.DueDate < {3} then '#FEF1CF' Else '' End As BackColor

                FROM [Transaction] T
                Inner join Customer on Customer.CustomerID = T.CustomerID
                Left join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.LanguageID = {0}
				inner join CustomerOutlet on CustomerOutlet.CustomerID = T.CustomerID AND CustomerOutlet.OutletID = t.OutletID
				Left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID =CustomerOutlet.CustomerID and  CustomerOutletLanguage.OutletID = CustomerOutlet.OutletID and CustomerOutletLanguage.LanguageID = {0}
                LEFT JOIN EmployeeLanguage EL2 on EL2.EmployeeID = T.EmployeeID AND EL2.LanguageID = {0}
                left join RouteHistory on RouteHistory.RouteHistoryId = T.RouteHistoryID
                where T.TransactionTypeID = {1} AND Voided <> 1 
                and IsNull(RouteHistory.Uploaded, 0) = 0 And (T.RemainingAmount > 0) ",
                _requestRepository.LanguageId,
                (int)TransactionType.Sales,
                _requestRepository.Configurations.UseSourceTransactionIDAsInvoiceName ? "SourceTransactionId" : "TransactionId",
                LocalUtilities.ParseDateToSQLString(DateTime.Now));

                if (!string.IsNullOrEmpty(accountId))
                {
                    mainQuery.AppendFormat($" AND T.AccountID in ({accountId}) ");
                }
                if (!string.IsNullOrEmpty(accountId))
                {
                    mainQuery.AppendFormat($" AND T.AccountID in ({accountId}) ");
                }
                if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                {
                    mainQuery.AppendFormat(@" AND (T.TransactionID LIKE '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());
                }

                if (filter.FromToDate.Count == 2)
                {
                    mainQuery.AppendFormat(@" And ( T.TransactionDate >= {0} AND T.TransactionDate <= {1})",
                    LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date), LocalUtilities.ParseDateToSQLString(filter.FromToDate[1].Date));
                }
                if (filter.ShowForOutletOnly)
                {
                    mainQuery.AppendFormat(@" AND (T.CustomerID = {0} AND T.OutletID = {1})", filter.CustomerId, filter.OutletId);
                }

                mainQuery.Append(" order by T.DueDate ");

                result = dbHelper.GetQueryList(mainQuery.ToString(), ref transactions);
                if (result == GlobalErrors.Success)
                {
                    if (transactions != null && transactions.ToList().Count > 0)
                    {
                        sharedTransList.Data = transactions;
                        sharedTransList.TotalItems = transactions.Count;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetCustomerPayerAccountIds(int customerId,int outletId,ref List<PayerAccountModel> accountList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<PayerAccountModel> dbHelper = new DBHelper<PayerAccountModel>();
            try
            {
                accountList = new List<PayerAccountModel>();
                string query = string.Format(@"select Payer.PayerCode, AccountPayer.AccountId, AccountLanguage.Description PayerName ,1 as Priority
                from AccountPayer
                inner join Payer on Payer.PayerID = AccountPayer.PayerID
                inner join PayerAssignment on PayerAssignment.PayerID = AccountPayer.PayerID
				Left join AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID and AccountLanguage.LanguageID = {2}
                where CustomerID = {0} and OutletID = {1}
                UNION
                select Payer.PayerCode, AccountPayer.AccountId, AccountLanguage.Description PayerName ,2 as Priority
                from  AccountPayer
                inner join Payer on Payer.PayerID = AccountPayer.PayerID
                inner join PayerAssignment on PayerAssignment.PayerID = AccountPayer.PayerID
                INNER JOIN CustomerOutletGroup ON CustomerOutletGroup.GroupID = PayerAssignment.CustomerGroupID 
				Left join AccountLanguage on AccountLanguage.AccountID = AccountPayer.AccountID and AccountLanguage.LanguageID = {2}
                WHERE CustomerOutletGroup.CustomerID = {0} AND CustomerOutletGroup.OutletID = {1}
                order by Priority", customerId, outletId,_requestRepository.LanguageId);
                result = dbHelper.GetQueryList(query, ref accountList);
                //if (result == GlobalErrors.Success && accountList != null && accountList.Count > 0)
                //{
                //    accountIds = string.Join(",", accountList);
                //}
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        public GlobalErrors GetVMTransactionsForSelectedCustomers(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and  ([Transaction].TransactionID LIKE '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.FromToDate != null && filter.FromToDate.Count == 2)
                    {
                        searchFilter += string.Format(" And  [Transaction].TransactionDate>={0} and  [Transaction].TransactionDate <= {1}"
                            , LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date),
                             LocalUtilities.ParseEndDateToSQLString(filter.FromToDate[1].Date));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By TransactionDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }

                }
                string mainQuery = string.Format(@" Select IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,[Transaction].TransactionID, [Transaction].TransactionDate,[Transaction].TransactionTypeID,
                CASE WHEN [Transaction].TransactionTypeID = 1 THEN '{5}' 
                when [Transaction].TransactionTypeID = 7 then '{6}' 
                when [Transaction].TransactionTypeID = 8 then '{7}' end as TransactionTypeName ,case when [Transaction].TransactionTypeID in ({1},{3}) then 'red' when [Transaction].TransactionTypeID = {2} then 'green' end as IconColor,'fa fa-circle fa-2x' Icon
                from [Transaction] 
	            inner join CustomerOutlet on CustomerOutlet.CustomerID = [Transaction].CustomerID and CustomerOutlet.OutletID = [Transaction].OutletID and CustomerOutlet.IsVendingMachine = 1
				left join CustomerOutletLanguage on CustomerOutletLanguage.CustomerID = CustomerOutlet.CustomerID and CustomerOutletLanguage.OutletID =CustomerOutlet.OutletID and  CustomerOutletLanguage.LanguageID = {8}
                where [Transaction].CustomerID = {0} and TransactionTypeID in ({1},{2},{3}) and Voided <> 1 {4}",
                filter.CustomerId, //0
                TransactionType.Sales.GetHashCode(), //1,
                TransactionType.Replenish.GetHashCode(), //2,
                TransactionType.Remove.GetHashCode(), //3,
                searchFilter, //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Invoice, _requestRepository.LanguageId), //5
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Replinsh, _requestRepository.LanguageId),//6
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Remove, _requestRepository.LanguageId), //7
                _requestRepository.LanguageId
                ) ;

                string invoicesQuery = string.Format(@" {0} {1} OFFSET     {2} ROWS
                                    FETCH NEXT {3} ROWS ONLY ",
                mainQuery, //0
                orderByFilter, //1
                (filter.CustomListFilter.Page) * filter.CustomListFilter.PageSize,
                filter.CustomListFilter.PageSize
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref transactions);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetVMTransactionsDetails(GeneralFilter filter, ref List<ItemPackModel> itemsList)
        {
            itemsList = new List<ItemPackModel>();
            DBHelper<ItemPackModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            string afterReplinshFilter = string.Empty;
            try
            {
                dbHelper = new DBHelper<ItemPackModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                if (filter != null)
                {
                    if(filter.TransactionType == TransactionType.Replenish)
                    {
                        afterReplinshFilter = string.Format(@" and S.IsAfterReplenish = 1 ");
                    }
                    else
                    {
                        afterReplinshFilter = string.Format(@" and S.IsAfterReplenish = 0 ");
                    }
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@" and (ItemLanguage.Description like '%{0}%' or Item.ItemCode like '%{0}%' )", filter.CustomListFilter.SearchFilter.Trim());
                    }
                }
                string mainQuery = string.Format(@" SELECT Sc.PackID, ISNULL(ItemCode, '--') + ' ' + '-' + ' ' + ISNULL(ItemLanguage.Description, '--') + ' ( ' + PackTypeLanguage.Description + ' ) ' AS ItemCodeName,
                ISNULL(  TransactionDetail.Quantity, 0)Quantity, ISNULL(Sc.Quantity, 0) AS StockQty
                FROM Pack
                INNER JOIN [Transaction] T ON T.TransactionID = '{1}'
                left join TransactionDetail on TransactionDetail.TransactionID = T.TransactionID and TransactionDetail.PackID  = Pack.PackID 
                 CROSS APPLY (
                    SELECT TOP 1 S.PackID, S.CountingDate,S.Quantity,S.IsAfterReplenish
                    FROM StockCounting S
                    WHERE T.CustomerID = S.CustomerID and T.OutletID = S.OutletID and T.RouteHistoryID = S.RouteHistoryID and Pack.PackID = S.PackID and 
	                S.CountingDate > = T.TransactionDate {4}
                    ORDER BY S.CountingDate Asc
                ) Sc
                INNER JOIN Item ON Item.ItemID = Pack.ItemID
                left join ItemLanguage on ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageID = {0}
				left join PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.PackTypeID and PackTypeLanguage.LanguageID = {0}
                where T.DivisionID = {2} {3}
                order by Sc.PackID",
                _requestRepository.LanguageId, //0
                filter.TransactionId, //1
                filter.DivisionId, //2
                searchFilter, //3
                afterReplinshFilter //4
                );
                result = dbHelper.GetQueryList(mainQuery, ref itemsList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                itemsList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #region[CRM]
        public GlobalErrors GetTransactionHeaderData(int customerId, int outletId, string transactionId, ref TransactionHistory transaction)
        {
            DBHelper<TransactionHistory> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionHistory>();

                string query = string.Format(@"Select TR.TransactionID , TR.TransactionDate InvoiceDate, CustomerLanguage.Description CustomerName , COL.Description OutletName , Customer.CustomerCode CustomerCode , CustomerOutlet.CustomerCode OutletCode , CustomerOutlet.TaxNumber , EmployeeLanguage.Description EmployeeName ,CustomerOutlet.CustomerTypeID, PaymentTermLanguage.Description PaymentTerm , TR.DueDate
        from [Transaction] TR
        INNER JOIN Customer on Customer.CustomerID = TR.CustomerID
        LEFT JOIN CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
        and CustomerLanguage.OrganizationId in ({4})
        INNER JOIN CustomerOutlet on CustomerOutlet.CustomerID = TR.CustomerID AND CustomerOutlet.OutletID = TR.OutletID
        LEFT JOIN CustomerOutletLanguage COL on COL.CustomerID = CustomerOutlet.CustomerID AND COL.OutletID = CustomerOutlet.OutletID AND COL.LanguageID = {0}
        LEFT JOIN EmployeeLanguage on EmployeeLanguage.EmployeeID = TR.EmployeeID AND EmployeeLanguage.LanguageID = {0} 
        LEFT JOIN PaymentTermLanguage on CustomerOutlet.PaymentTermID = PaymentTermLanguage.PaymentTermID AND PaymentTermLanguage.LanguageID = {0}
        Where TR.CustomerID = {1} AND TR.OutletID = {2} AND TR.TransactionID = '{3}'"
                                            , _requestRepository.LanguageId
                                            , customerId
                                            , outletId
                                            , transactionId
                                            ,_requestRepository.CurrentOperator.OrganizationAccess
                                            );

                result = dbHelper.GetQuerySingle(query, ref transaction);

                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetCustomerSalesSummaryHeader(CustomerFilter filter, ref SalesSummaryModel summary)
        {
            DBHelper<SalesSummaryModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<SalesSummaryModel>();
                string query = string.Format(@"select COUNT (*) TotalNumberOfInvoices , MAX(TransactionDate) LastInvoice ,  MIN(TransactionDate) FirstInvoice  , MIN(NetTotal) LowestInvoice  , AVG(NetTotal) AVGInvoiceAmount 
                        , MAX(NetTotal) HighestInvoice , (Select AVG(TransactionQ.Quantity) FROM (
                        Select SUM(Quantity) Quantity 
                        FROM TransactionDetail  with (nolock)
                        INNER JOIN  [Transaction] T with (nolock)  on T.TransactionID = TransactionDetail.TransactionID AND T.CustomerID = TransactionDetail.CustomerID AND T.OutletID = TransactionDetail.OutletID AND TransactionTypeID in (1 , 3 ) AND Voided<> 1
                        where TransactionDetail.CustomerID = {0}  AND TransactionDetail.OutletID = {1} AND SalesTransactionTypeID = 1 
                        Group by TransactionDetail.TransactionID , TransactionDetail.CustomerID , TransactionDetail.OutletID , TransactionDetail.DivisionID ) AS TransactionQ) AverageQuantityPerInvoice
                        From [Transaction] where CustomerID = {0} AND OutletID = {1} AND TransactionTypeID in ( 1 , 3 ) AND Voided <> 1 "
                , filter.CustomerId, filter.OutletId);

                result = dbHelper.GetQuerySingle(query, ref summary);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        public GlobalErrors GetMonthlySalesValue(CustomerFilter filter, ref List<MonthlySummaryModel> monthlySummaries)
        {
            DBHelper<MonthlySummaryModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<MonthlySummaryModel>();
                string query = string.Format(@"Select SUM(NetTotal) Value , YEAR(TransactionDate) Year,  DATEPART(QUARTER,TransactionDate) QUARTER , MONTH(TransactionDate)  Month
                        FROM [Transaction] Where CustomerID = {0} AND OutletID = {1} AND TransactionTypeID  in (1 , 3) AND Voided <> 1
                        Group by MONTH(TransactionDate) , DATEPART(QUARTER,TransactionDate) , YEAR(TransactionDate) ", filter.CustomerId, filter.OutletId);

                result = dbHelper.GetQueryList(query, ref monthlySummaries);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }
        internal GlobalErrors UpdateTargetsAgainstVoidedTransactions(string transactionId, DBHelper<int> dbHelper, TransactionModel transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            List<AchievementTargetCustomer> targets = null;
            object field = null;
            string lastInvoiceDate = string.Empty;
            string whereClause = string.Empty;
            string outletFilter = string.Empty;
            string lastInvQuery = string.Empty;
            int promotionLevel = -1;
            try {
                DBHelper<AchievementTargetCustomer> achDbHelper = new DBHelper<AchievementTargetCustomer>(dbHelper.GetConnection(), dbHelper.GetDBTransaction());
                targets = new List<AchievementTargetCustomer>();
                string queryString = string.Format(@"SELECT PH.AchievementID, PH.TargetID, ATC.PromotedOnTransactionID, Promotion.PromotionLevel
                FROM PromotionsHistory PH
                INNER JOIN Promotion on Promotion.PromotionID = PH.PromotionID and Promotion.AchievementID = PH.AchievementID and Promotion.Inactive <> 1
				and Promotion.IsDeleted <> 1
                INNER JOIN AchievementTargetCustomer ATC ON PH.AchievementID = ATC.AchievementID AND PH.TargetID = ATC.TargetID 
                AND PH.CustomerID = ATC.CustomerID AND ((PH.OutletID = ATC.OutletID and Promotion.PromotionLevel = 2) or (ATC.OutletID = -1 and Promotion.PromotionLevel = 1))
                WHERE PH.TransactionID = '{0}'", transactionId);
                result = achDbHelper.GetQueryList(queryString, ref targets);
                if (targets != null && targets.Count > 0)
                {
                    foreach (AchievementTargetCustomer targetCustomer in targets)
                    {
                        field = null;
                        lastInvoiceDate = string.Empty;
                        whereClause = string.Empty;
                        outletFilter = string.Empty;
                        promotionLevel = -1;
                        if (targetCustomer.PromotionLevel == PromotionLevel.OutletLevel.GetHashCode())
                        {
                            outletFilter = " AND OutletID = " + transaction.OutletId.ToString();
                        }
                        whereClause = "(CustomerID = " + transaction.CustomerId.ToString()
                                        + outletFilter
                                        + " AND AchievementID = " + targetCustomer.AchievementID
                                        + " AND TargetID = " + targetCustomer.TargetID + " )";
                        if (!string.IsNullOrEmpty(targetCustomer.PromotedOnTransactionID) && transactionId.Equals(targetCustomer.PromotedOnTransactionID))
                        {
                            //update the achievments target ispromoted 
                            queryString = string.Format(@"UPDATE AchievementTargetCustomer SET IsUpdatedInFO = 0, IsPromoted = 0,
                            PromotedOnTransactionID = NULL, LastInvoiceDate = NULL WHERE {0}", whereClause);

                        }
                        else
                        {
                            field = null;
                            lastInvQuery = string.Format(@"SELECT max(LastInvoiceDate) LastInvoiceDate 
                                from PromotionsHistory where {0} and TransactionID <> '{1}'", whereClause, transactionId);
                            result = dbHelper.ExecuteScalar(lastInvQuery, ref field);
                            if (result == GlobalErrors.Success && field != null && field.ToString() != "")
                            {
                                lastInvoiceDate = LocalUtilities.ParseDateAndTimeToSQL(Convert.ToDateTime(field.ToString()));
                            }
                            if (!string.IsNullOrEmpty(lastInvoiceDate))
                                queryString = string.Format(@"UPDATE AchievementTargetCustomer SET IsUpdatedInFO = 0, LastInvoiceDate = {1} WHERE {0}", whereClause, lastInvoiceDate);
                            else
                                continue;
                        }
                        result = dbHelper.ExecuteNonQuery(queryString);
                        if (result != GlobalErrors.Success) break;
                    }
                }
                else
                    result = GlobalErrors.SuccessWithZeroRowAffected;


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetMonthlySalesVolume(CustomerFilter filter, ref List<MonthlySummaryModel> monthlySummaries)
        {
            DBHelper<MonthlySummaryModel> dbHelper = null;
            var result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<MonthlySummaryModel>();
                string query = string.Format(@"Select SUM(Quantity) Value , YEAR(TransactionDate) Year,  DATEPART(QUARTER,TransactionDate) QUARTER , MONTH(TransactionDate)  Month
                        FROM TransactionDetail TD 
                        INNER JOIN [Transaction] T on T.TransactionID = TD.TransactionID AND T.CustomerID = TD.CustomerID AND T.OutletID = TD.OutletID
                        Where TD.CustomerID = {0} AND TD.OutletID = {1} AND TransactionTypeID  in (1 , 3) AND Voided <> 1
                        Group by MONTH(TransactionDate) , DATEPART(QUARTER,TransactionDate) , YEAR(TransactionDate) ", filter.CustomerId, filter.OutletId);

                result = dbHelper.GetQueryList(query, ref monthlySummaries);
                return result;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        public GlobalErrors GetTransactionsToSendEmail(EmailFilter filter, ref List<TransactionHistory> transactions, int languageId, bool isBackgroundService, int routeHistoryID, int type)
        {
            var result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<TransactionHistory> dBHelper = new DBHelper<TransactionHistory>();
                string query = string.Empty;

                if (_configurationManager == null)
                {
                    _configurationManager = new ConfigurationManager(null);
                }
                dynamic keyValue = null;
                var numberOfDaysToSendingTransactionsEmail = 0;
                result = _configurationManager.GetConfigurationValueFromDB($"NumberOfDaysToSendingTransactionsEmail", ref keyValue);
                if (result == GlobalErrors.Success)
                {
                    numberOfDaysToSendingTransactionsEmail = Convert.ToInt32(keyValue);
                }
                else
                {
                    return GlobalErrors.Error;
                }
                string routeHistoryFilter = "";
                string crossUnion = "";
                if (routeHistoryID > 0)
                {
                    routeHistoryFilter = string.Format(" AND T.RouteHistoryID = {0} ", routeHistoryID + "");
                }
                else {
                    crossUnion = $@" union all 
                               select T.TransactionID, T.CustomerID, T.OutletID, T.DivisionID from [Transaction] T
                               cross apply( select top 1 * from 
                               TransactionEmailHistory TEH where T.TransactionID = TEH.TransactionId and T.CustomerID = TEH.CustomerId and T.OutletID = TEH.OutletId 
                               and T.DivisionID = TEH.DivisionId order by TEH.SendDate desc)nn
                               where nn.Status = {EmailStatus.Success.GetHashCode()} and nn.Voided = 0  and T.Voided = 1";
                }

                if (type == 1)
                {
                    query = $@"{string.Format(CoreDataBaseConstants.CustOutConfigurationLevelFilterQuery, $"EmailPhrasesLanguage")}

                               Select T.*,T.Voided,C.CustomerCode CustomerCode,CL.Description CustomerName,CR.Code CurrencyCode,C.Email CustomerEmail,
                               CO.Email OutletEmail,C.CustomerCode +' - '+CL.Description CustomerCodeName,isnull(temp.KeyValue,{languageId}) LanguageID,
                               case when T.TransactionTypeID = 3 then  T.NetTotal - returnss.NetTotal
				               else T.NetTotal end AS NetTotal
                               from [Transaction] T
                               inner join Customer C on C.CustomerID = t.CustomerID
                               inner join CustomerOutlet CO on CO.CustomerID = T.CustomerID and CO.OutletID = T.OutletID
                               left join CustomerLanguage CL ON CL.CustomerID = C.CustomerID and CL.LanguageID = {languageId}
                               left join Currency CR on CR.CurrencyID = T.CurrencyID
                               left join [transaction] returnss on T.SourceTransactionID = returnss.TransactionID
				               and T.CustomerID = returnss.CustomerID and T.OutletID = returnss.OutletID
				               and T.DivisionID=returnss.DivisionID
				               and returnss.TransactionTypeID = 4
                               inner join (
                               select T.TransactionID, T.CustomerID, T.OutletID, T.DivisionID from [Transaction] T
                               left join  TransactionEmailHistory TEH on T.TransactionID = TEH.TransactionId and T.CustomerID = TEH.CustomerId and T.OutletID = TEH.OutletId 
                               and T.DivisionID = TEH.DivisionId 
                               where TEH.TransactionID is null and T.Voided <> 1   {routeHistoryFilter}
                               {crossUnion}
                               )TT on TT.TransactionID = T.TransactionId and TT.CustomerID = T.CustomerID and TT.OutletId = T.OutletID and TT.DivisionId = T.DivisionID  
                               left join @t temp on T.CustomerID = temp.CustomerID and T.OutletID = temp.OutletID
                               where CONVERT(date,T.TransactionDate) >= {LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(-numberOfDaysToSendingTransactionsEmail).Date)}
                               and ((CO.Email is Not null and CO.Email <> '') or (C.Email is Not null and C.Email <> ''))";
                }
                else {
                    query = $@"{string.Format(CoreDataBaseConstants.CustOutConfigurationLevelFilterQuery, $"EmailPhrasesLanguage")}

                               Select t.CustomerPaymentID, t.CustomerPaymentID as TransactionId,T.PaymentDate as TransactionDate,t.CustomerID,t.OutletID,t.PaymentTypeID,t.EmployeeID,t.VoucherNumber,t.VoucherDate,t.BankID,t.BranchID,t.CurrencyID,
                               t.PaymentStatusID,t.Posted,t.AccountID,T.PaymentStatusID,C.CustomerCode CustomerCode,CL.Description CustomerName,CR.Code CurrencyCode,C.Email CustomerEmail,
                               CO.Email OutletEmail,C.CustomerCode +' - '+CL.Description CustomerCodeName,isnull(temp.KeyValue,{languageId}) LanguageID,
                               sum(t.AppliedAmount) AppliedAmount,sum(t.RemainingAmount) RemainingAmount,sum(t.SecondCurrencyAmount) SecondCurrencyAmount, sum(ExchangeRate) ExchangeRate
                               from CustomerPayment T
                               inner join Customer C on C.CustomerID = t.CustomerID
                               inner join CustomerOutlet CO on CO.CustomerID = T.CustomerID and CO.OutletID = T.OutletID
                               left join CustomerLanguage CL ON CL.CustomerID = C.CustomerID and CL.LanguageID = {languageId}
                               left join Currency CR on CR.CurrencyID = T.CurrencyID 
                               inner join (
                               select distinct T.CustomerPaymentID, T.CustomerID, T.OutletID, T.DivisionID from CustomerPayment T
                               INNER JOIN [Transaction] trans on trans.TransactionID = T.TransactionID AND Trans.SalesMode = 2                               
                               left join  TransactionEmailHistory TEH on T.CustomerPaymentID = TEH.TransactionId and T.CustomerID = TEH.CustomerId and T.OutletID = TEH.OutletId 
                               and T.DivisionID = TEH.DivisionId 
                               where TEH.TransactionID is null and T.PaymentStatusID <> 5   {routeHistoryFilter}
                               )TT on TT.CustomerPaymentID = T.CustomerPaymentID and TT.CustomerID = T.CustomerID and TT.OutletId = T.OutletID and TT.DivisionId = T.DivisionID  
                               left join @t temp on T.CustomerID = temp.CustomerID and T.OutletID = temp.OutletID
                               where CONVERT(date,T.PaymentDate) >= {LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(-numberOfDaysToSendingTransactionsEmail).Date)}
                               AND T.AutoGeneratedByExchange <> 1 AND ((CO.Email is Not null and CO.Email <> '') or (C.Email is Not null and C.Email <> ''))
                               group by t.CustomerPaymentID,T.PaymentDate,t.CustomerID,t.OutletID,t.PaymentTypeID,t.EmployeeID,t.VoucherNumber,t.VoucherDate,t.BankID,t.BranchID,t.CurrencyID,
                               t.PaymentStatusID,t.Posted,t.AccountID,C.CustomerCode,CL.Description,CR.Code,C.Email,CO.Email,temp.KeyValue";

                }


                dBHelper.SetTimeOut(420);
                result = dBHelper.GetQueryList(query, ref transactions);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transactions = null;
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors PrepareTransactionAndSendEmail(EmailFilter filter, int languageId, ref TransactionHistory transactionHistory)
        {
            var result = GlobalErrors.NotInitialized;
            string query = "";
            try
            {
                DBHelper<TransactionHistory> dBHelper = new DBHelper<TransactionHistory>();
                if (filter.ReportTypeID == EmailReportTypes.Collection.GetHashCode())
                {
                    query = $@"{string.Format(CoreDataBaseConstants.CustOutConfigurationLevelFilterQuery, $"EmailPhrasesLanguage")}
                               select *,C.CustomerCode CustomerCode,CL.Description CustomerName,CR.Code CurrencyCode,C.Email CustomerEmail,CO.Email OutletEmail,C.CustomerCode +' - '+CL.Description CustomerCodeName
                               ,isnull(temp.KeyValue,{languageId}) LanguageID
                               from CustomerPayment t
                               inner join Customer C on C.CustomerID = t.CustomerID
                               inner join CustomerOutlet CO on CO.CustomerID = {filter.CustomerId} and CO.OutletID = {filter.OutletId}
                               left join CustomerLanguage CL ON CL.CustomerID = C.CustomerID and CL.LanguageID = {_requestRepository.LanguageId}
                               left join Currency CR on CR.CurrencyID = CO.CurrencyID 
                               left join @t temp on T.CustomerID = temp.CustomerID and T.OutletID = temp.OutletID
                               where t.CustomerID = {filter.CustomerId} and t.OutletID = {filter.OutletId} 
                               and t.DivisionID = {filter.DivisionId} and t.CustomerPaymentID = '{filter.TransactionId}'";
                }
                else
                {
                    query = $@"{string.Format(CoreDataBaseConstants.CustOutConfigurationLevelFilterQuery, $"EmailPhrasesLanguage")}
                                select t.*,C.CustomerCode CustomerCode,CL.Description CustomerName,CR.Code CurrencyCode,C.Email CustomerEmail,CO.Email OutletEmail,C.CustomerCode +' - '+CL.Description CustomerCodeName,
                                case when t.TransactionTypeID = 3 then  t.NetTotal - returnss.NetTotal 
				                else t.NetTotal end as NetTotal,
                               isnull(temp.KeyValue,{languageId}) LanguageID
                               from [Transaction] t
                               inner join Customer C on C.CustomerID = t.CustomerID
                               inner join CustomerOutlet CO on CO.CustomerID = {filter.CustomerId} and CO.OutletID = {filter.OutletId}
                               left join CustomerLanguage CL ON CL.CustomerID = C.CustomerID and CL.LanguageID = {_requestRepository.LanguageId}
                               left join Currency CR on CR.CurrencyID = CO.CurrencyID 
                               left join @t temp on T.CustomerID = temp.CustomerID and T.OutletID = temp.OutletID
                               left join [transaction] returnss on t.SourceTransactionID = returnss.TransactionID
				               and t.CustomerID = returnss.CustomerID and t.OutletID = returnss.OutletID
				               and t.DivisionID=returnss.DivisionID
				               and returnss.TransactionTypeID = 4
                               where t.CustomerID = {filter.CustomerId} and t.OutletID = {filter.OutletId} 
                               and t.DivisionID = {filter.DivisionId} and t.TransactionID = '{filter.TransactionId}' 
                               and t.TransactionTypeId = {filter.TransactionTypeId}";
                }

                result = dBHelper.GetQuerySingle(query, ref transactionHistory);


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transactionHistory = null;
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GetTransactionsList(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string divisionAccess = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string transactionFilter = string.Empty;
                string paymentFilter = string.Empty;
                string routeJoin = string.Empty;
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }


                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        transactionFilter += string.Format(@"and ( ([Transaction].TransactionID LIKE '%{0}%')
                    OR ( [Transaction].TransactionDate LIKE '%{0}%')
                    OR ( WarehouseLanguage.Description LIKE '%{0}%' )
                    OR ( Warehouse.WarehouseCode LIKE '%{0}%' )
                    OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                    OR ( Employee.EmployeeCode LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' )
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    OR ( DivisionLanguage.Description LIKE '%{0}%')
                   )", filter.CustomListFilter.SearchFilter.Trim());

                        paymentFilter += string.Format(@"and ( 
                        ( CustomerPayment.CustomerPaymentID LIKE '%{0}%')
                        OR ( CustomerPayment.PaymentDate LIKE '%{0}%')
                        OR ( CustomerLanguage.Description LIKE '%{0}%' and CustomerLanguage.OrganizationId in ({1}) )
                        OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                        OR ( Customer.CustomerCode LIKE '%{0}%' )
                        OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                        OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                        OR ( Employee.EmployeeCode LIKE '%{0}%' ))", filter.CustomListFilter.SearchFilter.Trim(), _requestRepository.CurrentOperator.OrganizationAccess);
                    }
                    if (filter.RouteId != -1)
                    {
                        routeJoin = string.Format(@"INNER JOIN RouteCustomer on RouteCustomer.CustomerID = CustomerOutlet.CustomerID 
                        AND RouteCustomer.OutletID = CustomerOutlet.OutletID AND RouteCustomer.RouteId = {0} ",
                        filter.RouteId);
                    }
                    if (filter.CustomerId != -1)
                    {
                        transactionFilter += " And [Transaction].CustomerID= " + filter.CustomerId;
                        paymentFilter += " And CustomerPayment.CustomerID= " + filter.CustomerId;
                    }
                    if (filter.OutletId != -1)
                    {
                        transactionFilter += " And [Transaction].OutletID= " + filter.OutletId;
                        paymentFilter += " And CustomerPayment.OutletID= " + filter.OutletId;
                    }
                    if (!string.IsNullOrEmpty(filter.TransactionId))
                    {
                        transactionFilter += string.Format(" And [Transaction].TransactionID like('%{0}%') ", filter.TransactionId);
                        paymentFilter += string.Format(" And CustomerPayment.CustomerPaymentID like('%{0}%') ", filter.TransactionId);
                    }
                    if (filter.FromToDate != null)
                    {
                        transactionFilter += string.Format(" And  [Transaction].TransactionDate>={0} and  [Transaction].TransactionDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)));

                        paymentFilter += string.Format(" And  CustomerPayment.PaymentDate>={0} and  CustomerPayment.PaymentDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.FromToDate[0].Year, filter.FromToDate[0].Month, filter.FromToDate[0].Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.FromToDate[1].Year, filter.FromToDate[1].Month, filter.FromToDate[1].Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By TransactionDate desc");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (filter.ReportTypeId == 1 || filter.ReportTypeId == 5)
                    {
                        transactionFilter += string.Format(" And [Transaction].TransactionTypeID = {0}  and [Transaction].CreationReason <> {1}", TransactionType.Sales.GetHashCode(), TransactionCreationReason.iCashTopUp.GetHashCode());
                        paymentFilter += string.Format(" And CustomerPayment.PaymentTypeID = -1");

                    }
                    if (filter.ReportTypeId == 2)
                    {
                        transactionFilter += string.Format(" And [Transaction].TransactionTypeID = {0}", TransactionType.Return.GetHashCode());
                        paymentFilter += string.Format(" And CustomerPayment.PaymentTypeID = -1");
                    }
                    if (filter.ReportTypeId == 3)
                    {
                        transactionFilter += string.Format(" And [Transaction].TransactionTypeID in ({0})", TransactionType.SalesExchange.GetHashCode());
                        paymentFilter += string.Format(" And CustomerPayment.PaymentTypeID = -1");
                    }
                    if (filter.ReportTypeId == 4)
                    {
                        transactionFilter += string.Format("  And [Transaction].CreationReason in ({0})", TransactionCreationReason.iCashTopUp.GetHashCode());
                        paymentFilter += string.Format(" And CustomerPayment.PaymentTypeID = -1");
                    }
                    if (filter.ReportTypeId == 6)
                    {
                        //paymentFilter += string.Format(" And CustomerPayment.AutoGeneratedByExchange <> 1");
                        transactionFilter += string.Format(" And [Transaction].TransactionTypeID = -1");
                    }
                    if (!filter.IncludeVoided)
                    {
                        transactionFilter += string.Format(" And [Transaction].Voided != 1 ");
                        paymentFilter += string.Format(" And CustomerPayment.PaymentStatusID <> 5 ");
                    }
                }
                string supervisionJoin = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"  and [Transaction].EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                if (!string.IsNullOrEmpty(_requestRepository.CurrentOperator.DivisionAccess) && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionAccess = "and Division.DivisionID in(" + _requestRepository.CurrentOperator.DivisionAccess + ")";
                }
                string mainQuery = string.Format(@"Select Distinct
                [Transaction].TransactionID,
                [Transaction].TransactionDate,
                [Transaction].EmployeeID, 
                [Transaction].CreatedBy,
                [Transaction].CustomerID, 
                [Transaction].OutletID,
                case when [Transaction].TransactionTypeID = 3 then  [Transaction].NetTotal - returnss.NetTotal 
				else [Transaction].NetTotal end as NetTotal, 
                [Transaction].RemainingAmount, 
	            -1 PaymentStatusID,
                [Transaction].Voided, 
                Case When [Transaction].Voided = 1 then '{4}' else  '---' end as VoidedString,
                CASE WHEN [Transaction].Voided = 0 THEN 1 ELSE 0 END AS ShowVoidBtn,
                CASE WHEN [Transaction].CreationReason = 25 THEN 0 ELSE 1 END AS ShowViewBtn, 
                [Transaction].DivisionID,
                [Transaction].WarehouseID,
                [Transaction].AccountID,
                [Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,
                [Transaction].OrganizationID,
                [Transaction].CreationReason,
                [Transaction].TransactionTypeID,
                [Transaction].RouteId,
                [Transaction].SalesMode,
                [Transaction].SourceTransactionID,
                IsNull( Customer.CustomerCode, '--') + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutlet.CustomerCode, '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutletLanguage.Description, '--')as CustomerOutletHeader,
                IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode, 
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode, 
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull(DivisionLanguage.Description,'--') as DivisionName,
                IsNull(WarehouseLanguage.Description,'--') as WarehouseName,
                0 IsPayment,
                -1 PaymentTypeID,
                '---' CustomerPaymentID,
                case when [Transaction].transactiontypeid=3 or [Transaction].transactiontypeid=4 then 'Exchange' else  TransTypeLanguage.Description end TransPaymentType,
                [Transaction].RouteHistoryID,
                [Transaction].RefOrderID
                from [Transaction] 
                left join [transaction] returnss on [Transaction].SourceTransactionID = returnss.TransactionID
				and [Transaction].CustomerID = returnss.CustomerID and [Transaction].OutletID = returnss.OutletID
				and [Transaction].DivisionID=returnss.DivisionID
				and returnss.TransactionTypeID = 4
                inner join Customer on Customer.CustomerID = [Transaction].CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                inner join CustomerOutlet on CustomerOutlet.CustomerID = [Transaction].CustomerID And CustomerOutlet.OutletID = [Transaction].OutletID
                left outer join CustomerLanguage on Customer.CustomerID = CustomerLanguage.CustomerID and CustomerLanguage.languageid = {1}
                and CustomerLanguage.OrganizationId in ({0})
                left outer join CustomerOutletLanguage on CustomerOutlet.CustomerID = CustomerOutletLanguage.CustomerID and CustomerOutlet.OutletID = CustomerOutletLanguage.OutletID
                and CustomerOutletLanguage.LanguageID = {1}
                left outer join Employee on Employee.EmployeeID = [Transaction].EmployeeID
                left outer join EmployeeLanguage on EmployeeLanguage.EmployeeID = Employee.EmployeeID And EmployeeLanguage.LanguageID = {1}
                left outer join Division on [Transaction].DivisionID = Division.DivisionID
                left outer join DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.languageid = {1}
                left outer join Warehouse on Warehouse.WarehouseID = [Transaction].WarehouseID
                left outer join WarehouseLanguage on WarehouseLanguage.WarehouseID = Warehouse.WarehouseID and WarehouseLanguage.languageid = {1}
                left outer join RouteHistory on RouteHistory.RouteHistoryID = [Transaction].RouteHistoryID
                LEFT OUTER JOIN TransTypeLanguage ON TransTypeLanguage.TransactionTypeID = [Transaction].TransactionTypeID AND TransTypeLanguage.LanguageID = {1}
                {2}
                {9}
                where 1=1 {7} {5} and [Transaction].TransactionTypeID not in ({10})  and ([Transaction].TransactionTypeID not in (5) or ([Transaction].TransactionTypeID = 5 and [Transaction].sourceTransactionid is null ))
                UNION 
                (Select Distinct CustomerPayment.CustomerPaymentID TransactionID,PaymentDate TransactionDate,CustomerPayment.EmployeeID EmployeeID,-1 CreatedBy,
                CustomerPayment.CustomerID CustomerID,CustomerPayment.OutletID OutletID,sum(AppliedAmount) NetTotal,
				sum(CustomerPayment.RemainingAmount) RemainingAmount,
                CustomerPayment.PaymentStatusID,
                Case When CustomerPayment.PaymentStatusID=5 then 1 else 0 end Voided, 
				Case When CustomerPayment.PaymentStatusID = 5 then 'Voided' else  '---' end as VoidedString,
                CASE WHEN CustomerPayment.PaymentStatusID = 5 THEN 0 ELSE 1 END AS ShowVoidBtn,
                1 ShowViewBtn, 
                CustomerPayment.DivisionID DivisionID, -1 WarehouseID,CustomerPayment.AccountID AccountID,CustomerPayment.CurrencyID CurrencyID,
                -1 SelectedCurrencyID,CustomerPayment.OrganizationID OrganizationID,-1 CreationReason,-1 TransactionTypeID,
                CustomerPayment.RouteHistoryID RouteId,-1 SalesMode, '' SourceTransactionID ,'---' CustomerOutletHeader,
                IsNull( CustomerLanguage.Description  , '--')       + ' ' + '-'+ ' ' + IsNull( Customer.CustomerCode , '--')as CustomerNameCode,
                IsNull( CustomerOutletLanguage.Description  , '--') + ' ' + '-'+ ' ' + IsNull( CustomerOutlet.CustomerCode , '--') as OutletNameCode,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode, 
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode, 
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull( DivisionLanguage.Description  , '--') DivisionName,
                '---' WarehouseName,
                1 IsPayment,
                CustomerPayment.PaymentTypeID PaymentTypeID,
                CustomerPayment.CustomerPaymentID CustomerPaymentID,
                PaymentTypeLanguage.Description TransPaymentType,
                CustomerPayment.RouteHistoryID,
                '---' RefOrderID
                From CustomerPayment 
                Inner Join [Transaction] On [Transaction].TransactionID = CustomerPayment.TransactionID And [Transaction].CustomerID = CustomerPayment.CustomerID And [Transaction].OutletID = CustomerPayment.OutletID And [Transaction].DivisionID = CustomerPayment.DivisionID
                and [Transaction].SalesMode =2
                Inner Join Customer On Customer.CustomerID = CustomerPayment.CustomerID
                inner join CustomerOrganization on CustomerOrganization.CustomerId = customer.CustomerID
                Inner Join CustomerOutlet On CustomerOutlet.CustomerID = CustomerPayment.CustomerID And CustomerOutlet.OutletID = CustomerPayment.OutletID
                Left Join CustomerLanguage On CustomerLanguage.CustomerID = Customer.CustomerID And CustomerLanguage.LanguageID = {1}
                and CustomerLanguage.OrganizationId in ({0})
                Left Join CustomerOutletLanguage On CustomerOutletLanguage.CustomerID = CustomerPayment.CustomerID And CustomerOutletLanguage.OutletID = CustomerPayment.OutletID And CustomerOutletLanguage.LanguageID = {1}
                Inner Join Employee on Employee.EmployeeID = CustomerPayment.EmployeeID
                Left Join EmployeeLanguage on EmployeeLanguage.EmployeeID = CustomerPayment.EmployeeID AND EmployeeLanguage.LanguageID = {1}
                left outer join RouteHistory on RouteHistory.RouteHistoryID = CustomerPayment.RouteHistoryID
                Left Join Division On Division.DivisionID = CustomerPayment.DivisionID
                Left Join DivisionLanguage On DivisionLanguage.DivisionID = Division.DivisionID And DivisionLanguage.LanguageID = {1}
                Left Join PaymentTypeLanguage On PaymentTypeLanguage.PaymentTypeID = CustomerPayment.PaymentTypeID And PaymentTypeLanguage.LanguageID = {1}
                Left Join BankLanguage On BankLanguage.BankID = CustomerPayment.BankID And BankLanguage.LanguageID = {1}
                Left Join BankBranchLanguage On BankBranchLanguage.BankID = CustomerPayment.BankID And BankBranchLanguage.BranchID = CustomerPayment.BranchID And BankBranchLanguage.LanguageID = {1}
                {2}
                {9}
                Where 1=1 And (CustomerPayment.OrganizationID in ({0})) {3} {5} {6} {8} and CustomerPayment.AutoGeneratedByExchange <> 1
                Group By CustomerPayment.DivisionId, Division.DivisionCode, DivisionLanguage.Description, CustomerPayment.EmployeeID,
				CustomerPayment.OrganizationID, CustomerPayment.CurrencyID, CustomerPayment.AccountID, CustomerPayment.BankID,
				CustomerPayment.BranchID, EmployeeLanguage.Description,Employee.EmployeeCode,CustomerPayment.CustomerID,
				CustomerPayment.OutletID,CustomerLanguage.Description,Customer.CustomerCode,CustomerOutletLanguage.Description ,
				CustomerOutlet.CustomerCode,CustomerPaymentID,CustomerPayment.PaymentDate,
				CustomerPayment.PaymentTypeID,PaymentTypeLanguage.Description ,VoucherNumber,VoucherDate,BankLanguage.Description,
                BankBranchLanguage.Description, CustomerPayment.PaymentStatusID,
				CustomerPayment.DivisionID,CustomerPayment.RouteHistoryID)",
                _requestRepository.CurrentOperator.OrganizationAccess, //0
                _requestRepository.LanguageId, //1
                orgAccessJoin, //2
                searchFilter, //3
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Caption, _requestRepository.LanguageId), //4
                supervisionJoin, //5
                divisionAccess, //6
                transactionFilter, //7
                paymentFilter, //8
                routeJoin, //9
                TransactionType.ReturnExchange.GetHashCode() //10
                );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);

                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref transactions , true);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }


        #endregion

        #region[Invoice Location]
        public GlobalErrors GetInvoicesLocations(GeneralFilter filter, ref List<TransactionModel> invoicesLocations)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<TransactionModel> dBHelper = new DBHelper<TransactionModel>();
            try
            {
                string searchFilter = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CO", _requestRepository.CurrentOperator.OrganizationAccess));
                }

                if (filter.TransactionId != null && !string.IsNullOrEmpty(filter.TransactionId.Trim()))
                {
                    searchFilter += $" And T.TransactionId = '{filter.TransactionId}'";
                }
                if (filter.EmployeeId != -1)
                {
                    searchFilter += $" And T.EmployeeId = {filter.EmployeeId}";
                }
                if (filter.RouteId != -1)
                {
                    searchFilter += $" And T.RouteId = {filter.RouteId}";
                }
                if (filter.FromToDate != null && filter.FromToDate.Count == 2)
                {
                    searchFilter += $" And T.TransactionDate >= {LocalUtilities.ParseDateToSQLString(filter.FromToDate[0].Date)} and T.TransactionDate <= {LocalUtilities.ParseEndDateToSQLString(filter.FromToDate[1].Date)}";
                }
                if (_requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    searchFilter += $" And T.DivisionId in ({_requestRepository.CurrentOperator.DivisionAccess}) ";
                }


                string query = @$" select T.TransactionID,T.TransactionDate,ISNULL(T.GPSLatitude,0) GPSLatitude,ISNULL(T.GPSLongitude,0)GPSLongitude,T.NetTotal,
                C.CustomerCode, CO.CustomerCode As OutletCode, C.CustomerID, CO.OutletID,R.RouteCode,E.EmployeeCode,RL.Description RouteName, EL.Description EmployeeName,
                IsNull(CL.Description, '--') as CustomerName,
                IsNull(COL.Description, '--') as OutletName,
                IsNull(C.CustomerCode, '--') + ' ' + '-' + ' ' + IsNull(CL.Description, '--') as CustomerCodeName,
                IsNull(CO.CustomerCode, '--') + ' ' + '-' + ' ' + IsNull(COL.Description, '--') as OutletCodeName,
                IsNull(R.RouteCode, '--') + ' ' + '-' + ' ' + IsNull(RL.Description, '--') as RouteCodeName,
                IsNull(E.EmployeeCode, '--') + ' ' + '-' + ' ' + IsNull(EL.Description, '--') as EmployeeCodeName,
                IsNull(transAccount.CreditLimit,0) CreditLimit, IsNull(transAccount.Balance,0) Balance
                from[Transaction] T
                left join Account transAccount on transAccount.AccountId = T.AccountId
                left join Route R on R.RouteId = T.RouteId
                left join RouteLanguage RL on RL.RouteId = T.RouteId and RL.LanguageId = {_requestRepository.LanguageId}

                inner join Employee E on E.EmployeeId = T.EmployeeId
                inner join EmployeeLanguage EL on EL.EmployeeId = T.EmployeeId and EL.LanguageId = {_requestRepository.LanguageId}

                inner join Customer C on C.CustomerID = T.CustomerID
                inner join CustomerOutlet CO on CO.CustomerID = T.CustomerID and CO.OutletID = T.OutletID
                
                left join CustomerLanguage CL on CL.CustomerID = T.CustomerID and CL.LanguageID = {_requestRepository.LanguageId}
                left join CustomerOutletLanguage COL on COL.CustomerID = T.CustomerID and COL.OutletID = T.OutletID and COL.LanguageID = {_requestRepository.LanguageId}
                {orgAccessJoin} 
                where T.OrganizationId in ({_requestRepository.CurrentOperator.OrganizationAccess}) {searchFilter} 
                order by T.TransactionDate ";

                result = dBHelper.GetQueryList(query, ref invoicesLocations);
            }
            catch (Exception ex)
            {
                result = GlobalErrors.Error;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            finally
            {
                if (dBHelper != null)
                {
                    dBHelper.Dispose();
                }

            }
            return result;
        }
        #endregion

        #region [Return]
        public GlobalErrors GetReturnTransactions(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string divisionAccess = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string vehicleFilter = string.Empty;
                string routeFilter = string.Empty;
                string warehouseSelectionString = string.Empty;
                string warehouseSearchString = string.Empty;

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.Configurations.RestoreBOReturnToWarehouse)
                {
                    vehicleFilter = string.Format(@" Inner join Warehouse on Warehouse.WarehouseID = [Transaction].WarehouseID
                    and warehousetypeid = 1 ");
                }
                if(filter != null && filter.FormProcessMode == ItemFormProcessMode.ReturnSerials)
                {
                    vehicleFilter = string.Format(@" Inner join Warehouse on Warehouse.WarehouseID = [Transaction].WarehouseID
                    and warehousetypeid in (1,4)
                    left outer join WarehouseLanguage on Warehouse.WarehouseId = WarehouseLanguage.warehouseId and WarehouseLanguage.LanguageID = {0}", _requestRepository.LanguageId);
                    warehouseSelectionString = ", IsNull( Warehouse.WarehouseCode , '--') + ' ' + '-'+ ' ' + IsNull( WarehouseLanguage.Description , '--') as ReturnWarehouseCodeName";
                    warehouseSearchString = string.Format(@" OR(WarehouseLanguage.Description LIKE '%{0}%')
                    OR(Warehouse.WarehouseCode LIKE '%{0}%')", filter.CustomListFilter.SearchFilter.Trim());

                }
                if (_requestRepository.Configurations.TransactionIDModeInBOTransactions == 2)
                {
                    routeFilter = string.Format(@" INNER JOIN [Route] On [Transaction].RouteID =[Route].RouteID ");
                }

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( ([Transaction].TransactionID LIKE '%{0}%')
                    OR ( [Transaction].TransactionDate LIKE '%{0}%')
                    OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                    OR ( Employee.EmployeeCode LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' )
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    OR ( DivisionLanguage.Description LIKE '%{0}%')
                    {1}
                   )", filter.CustomListFilter.SearchFilter.Trim(), warehouseSearchString);
                    }
                    if (filter.DivisionId != -1)
                    {
                        searchFilter += string.Format(@" And [Transaction].DivisionID = {0}", filter.DivisionId);
                    }
                    if (filter.WarehouseId != -1)
                    {
                        searchFilter += " And [Transaction].WarehouseID= " + filter.WarehouseId;
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += " And [Transaction].EmployeeID= " + filter.EmployeeId;
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += " And [Transaction].CustomerID= " + filter.CustomerId;
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += " And [Transaction].OutletID= " + filter.OutletId;
                    }
                    if (!string.IsNullOrEmpty(filter.TransactionId))
                    {
                        searchFilter += string.Format(" And [Transaction].TransactionID like('%{0}%') ", filter.TransactionId);
                    }
                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" And  [Transaction].TransactionDate>={0} and  [Transaction].TransactionDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By [Transaction].TransactionDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (filter.IncludeVoided)
                    {
                        searchFilter += string.Format(" And [Transaction].Voided >= 0 ");
                    }
                    else
                    {
                        searchFilter += string.Format(" And [Transaction].Voided != 1 ");
                    }

                }
                string supervisionJoin = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"  and [Transaction].EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                if (!string.IsNullOrEmpty(_requestRepository.CurrentOperator.DivisionAccess) && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionAccess = "and Division.DivisionID in(" + _requestRepository.CurrentOperator.DivisionAccess + ")";
                }
                string mainQuery = string.Format(@"select distinct [Transaction].TransactionID,
                [Transaction].TransactionDate,
                [Transaction].EmployeeID, 
                [Transaction].CreatedBy,
                [Transaction].CustomerID, 
                [Transaction].OutletID, 
                [Transaction].Voided, 
                Case When [Transaction].Voided = 1 then '{5}' else  '---' end as VoidedString,
                CASE WHEN [Transaction].Voided = 0 THEN 1 ELSE 0 END AS ShowVoidBtn,
                [Transaction].DivisionID,
                [Transaction].WarehouseID,
                [Transaction].AccountID,
                [Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,
                [Transaction].OrganizationID,
                [Transaction].CreationReason,
                [Transaction].TransactionTypeID,
                [Transaction].RouteId,
                [Transaction].SalesMode,
                [Transaction].SourceTransactionID,
                [Transaction].RouteHistoryID,
                IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode, 
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode, 
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull(DivisionLanguage.Description,'--') as DivisionName,
                [Transaction].NetTotal NetTotal {10}
                FROM [Transaction] 
                {8}
                INNER JOIN Customer ON  [Transaction].CustomerID=Customer.CustomerID 
                INNER JOIN CustomerLanguage ON  [Transaction].CustomerID=CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
                INNER JOIN CustomerOutlet ON [Transaction].CustomerID=CustomerOutlet.CustomerID AND [Transaction].OutletID=CustomerOutlet.OutletID
                INNER JOIN CustomerOutletLanguage ON [Transaction].CustomerID=CustomerOutletLanguage.CustomerID AND [Transaction].OutletID=CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {0} 
                INNER JOIN employee on employee.employeeid =[Transaction].employeeid
                INNER JOIN employeeLanguage on employeeLanguage.employeeid =[Transaction].employeeid AND employeeLanguage.LanguageID = {0}
                {9}
                LEFT JOIN RouteLanguage On [Transaction].RouteID =RouteLanguage.RouteID AND RouteLanguage.LanguageID = {0}
                LEFT OUTER JOIN Division on [Transaction].DivisionID = Division.DivisionID
                LEFT OUTER JOIN DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.LanguageID = {0}
                {3}
                WHERE [Transaction].TransactionTypeID = {2} And [Transaction].OrganizationID in ({6}) {1} {4} {7} ",
                _requestRepository.LanguageId, //0
                supervisionJoin, //1
                TransactionType.Return.GetHashCode(), //2
                orgAccessJoin, //3
                searchFilter, //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Caption, _requestRepository.LanguageId), //5
                _requestRepository.CurrentOperator.OrganizationAccess, //6
                divisionAccess, //7
                vehicleFilter, //8
                routeFilter, //9
                warehouseSelectionString //10
                );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref transactions , true);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region [Exchange]
        public GlobalErrors GetExchangeTransactions(GeneralFilter filter, ref SharedTableResult<TransactionModel> transList)
        {
            transList = new SharedTableResult<TransactionModel>();
            List<TransactionModel> transactions = new List<TransactionModel>();
            DBHelper<TransactionModel> dbHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelper = new DBHelper<TransactionModel>();
                string searchFilter = string.Empty;
                string orderByFilter = string.Empty;
                string divisionAccess = string.Empty;
                StringBuilder orgAccessJoin = new StringBuilder();
                string vehicleFilter = string.Empty;
                string routeFilter = string.Empty;

                if (_requestRepository.Configurations.ForceCustomerOrganizationSelection)
                {
                    orgAccessJoin.AppendLine(string.Format(CoreDataBaseConstants.CustOutAccountOrgAccessFilterQuery, "CustomerOutlet", _requestRepository.CurrentOperator.OrganizationAccess));
                }
                if (_requestRepository.Configurations.TransactionIDModeInBOTransactions == TransactionIDModeInBOInvoices.RouteCodeConcatenatedToFreeTextField.GetHashCode())
                {
                    routeFilter = string.Format(@" INNER JOIN [Route] On [Transaction].RouteID =[Route].RouteID ");
                }
                //if (!_requestRepository.Configurations.LimitBOSalesToWarehouseStock)
                //{
                //    vehicleFilter = string.Format(@" Inner join EmployeeVehicle on EmployeeVehicle.EmployeeID = [Transaction].EmployeeID
                //    and EmployeeVehicle.VehicleID = [Transaction].WarehouseID ");
                //}
                //else
                //{
                //    vehicleFilter = string.Format(@" Inner join Warehouse on Warehouse.WarehouseID = [Transaction].WarehouseID
                //    and warehousetypeid = 1 ");
                //}

                if (filter != null)
                {
                    if (!string.IsNullOrEmpty(filter.CustomListFilter.SearchFilter))
                    {
                        searchFilter = string.Format(@"and ( ([Transaction].TransactionID LIKE '%{0}%')
                    OR ( [Transaction].TransactionDate LIKE '%{0}%')
                    OR ( EmployeeLanguage.Description LIKE '%{0}%' )
                    OR ( Employee.EmployeeCode LIKE '%{0}%' )
                    OR ( CustomerOutletLanguage.Description LIKE '%{0}%' )
                    OR ( CustomerOutlet.CustomerCode LIKE '%{0}%' )
                    OR ( CustomerLanguage.Description LIKE '%{0}%' )
                    OR ( Customer.CustomerCode LIKE '%{0}%' )
                    OR ( DivisionLanguage.Description LIKE '%{0}%')
                   )", filter.CustomListFilter.SearchFilter.Trim());
                    }
                    if (filter.DivisionId != -1)
                    {
                        searchFilter += string.Format(@" And [Transaction].DivisionID = {0}", filter.DivisionId);
                    }
                    if (filter.WarehouseId != -1)
                    {
                        searchFilter += " And [Transaction].WarehouseID= " + filter.WarehouseId;
                    }
                    if (filter.EmployeeId != -1)
                    {
                        searchFilter += " And [Transaction].EmployeeID= " + filter.EmployeeId;
                    }
                    if (filter.CustomerId != -1)
                    {
                        searchFilter += " And [Transaction].CustomerID= " + filter.CustomerId;
                    }
                    if (filter.OutletId != -1)
                    {
                        searchFilter += " And [Transaction].OutletID= " + filter.OutletId;
                    }
                    if (!string.IsNullOrEmpty(filter.TransactionId))
                    {
                        searchFilter += string.Format(" And [Transaction].TransactionID like('%{0}%') ", filter.TransactionId);
                    }
                    if (filter.DateModel != null)
                    {
                        searchFilter += string.Format(" And  [Transaction].TransactionDate>={0} and  [Transaction].TransactionDate<={1}"
                            , LocalUtilities.ParseDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)),
                            LocalUtilities.ParseEndDateToSQLString(new DateTime(filter.DateModel.Year, filter.DateModel.Month, filter.DateModel.Day)));
                    }
                    if (string.IsNullOrEmpty(filter.CustomListFilter.SortBy))
                    {
                        orderByFilter = string.Format(@"Order By [Transaction].TransactionDate");
                    }
                    else
                    {
                        orderByFilter = string.Format(@"Order By {0} {1} "
                        , filter.CustomListFilter.SortBy, filter.CustomListFilter.IsSortAscending ? "ASC" : "DESC");
                    }
                    if (filter.IncludeVoided)
                    {
                        searchFilter += string.Format(" And [Transaction].Voided >= 0 ");
                    }
                    else
                    {
                        searchFilter += string.Format(" And [Transaction].Voided != 1 ");
                    }

                }
                string supervisionJoin = string.Empty;
                if (_requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Supervisor.GetHashCode() || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.SalesManager.GetHashCode()
                    || _requestRepository.CurrentOperator.EmployeeTypeId == EmployeeTypes.Director.GetHashCode())
                {
                    supervisionJoin = string.Format(@"  and [Transaction].EmployeeID {0}", _employeeManager.GetSupervisorAccess());
                }
                if (!string.IsNullOrEmpty(_requestRepository.CurrentOperator.DivisionAccess) && _requestRepository.Configurations.ControlTransactionOnDivisionLevel)
                {
                    divisionAccess = "and Division.DivisionID in(" + _requestRepository.CurrentOperator.DivisionAccess + ")";
                }
                string mainQuery = string.Format(@"select [Transaction].TransactionID,
                [Transaction].TransactionDate,
                [Transaction].EmployeeID, 
                [Transaction].CreatedBy,
                [Transaction].CustomerID, 
                [Transaction].OutletID, 
                [Transaction].Voided, 
                Case When [Transaction].Voided = 1 then '{5}' else  '---' end as VoidedString,
                [Transaction].DivisionID,
                [Transaction].WarehouseID,
                [Transaction].AccountID,
                [Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,
                [Transaction].OrganizationID,
                [Transaction].CreationReason,
                [Transaction].TransactionTypeID,
                [Transaction].RouteId,
                [Transaction].SalesMode,
                [Transaction].SourceTransactionID,
                [Transaction].RouteHistoryID,
                IsNull( Customer.CustomerCode, '--')       + ' ' + '-'+ ' ' + IsNull(CustomerLanguage.Description, '--')as CustomerCodeName,
                IsNull( CustomerOutlet.CustomerCode , '--') + ' ' + '-'+ ' ' + IsNull(CustomerOutletLanguage.Description, '--') as OutletCodeName,
                IsNull(CustomerLanguage.Description,'--') as CustomerName, 
                IsNull(CustomerOutletLanguage.Description,'--') as OutletName, 
                IsNull(Customer.CustomerCode,'--') as CustomerCode, 
                IsNull(CustomerOutlet.CustomerCode,'--') as OutletCode, 
                IsNull(EmployeeLanguage.Description,'--') as EmployeeName,
                IsNull(DivisionLanguage.Description,'--') as DivisionName,
                (CASE WHEN [Transaction].TransactionTypeID = 2 THEN -1 ELSE 1 END ) * SUM([Transaction].NetTotal)  - ISNULL(SUM(Rtn.NetTotal),0)*(CASE when [Transaction].TransactionTypeID=2 then -1 else 1 end) NetTotal
                FROM [Transaction] 
                INNER JOIN Customer ON  [Transaction].CustomerID=Customer.CustomerID 
                LEFT JOIN CustomerLanguage ON  [Transaction].CustomerID=CustomerLanguage.CustomerID AND CustomerLanguage.LanguageID = {0}
                INNER JOIN CustomerOutlet ON [Transaction].CustomerID=CustomerOutlet.CustomerID AND [Transaction].OutletID=CustomerOutlet.OutletID
                LEFT JOIN CustomerOutletLanguage ON [Transaction].CustomerID=CustomerOutletLanguage.CustomerID AND [Transaction].OutletID=CustomerOutletLanguage.OutletID AND CustomerOutletLanguage.LanguageID = {0} 
                INNER JOIN employee on employee.employeeid =[Transaction].employeeid
                LEFT JOIN employeeLanguage on employeeLanguage.employeeid =[Transaction].employeeid AND employeeLanguage.LanguageID = {0}
                {8}
                LEFT JOIN [Transaction] Rtn on [Transaction].SourceTransactionID =Rtn.TransactionID and [Transaction].CustomerID=Rtn.CustomerID and [Transaction].OutletID=Rtn.OutletID AND [Transaction].EmployeeID = Rtn.EmployeeID
                LEFT JOIN RouteLanguage On [Transaction].RouteID =RouteLanguage.RouteID AND RouteLanguage.LanguageID = {0}
                LEFT OUTER JOIN Division on [Transaction].DivisionID = Division.DivisionID
                LEFT OUTER JOIN DivisionLanguage on Division.DivisionID = DivisionLanguage.DivisionID and DivisionLanguage.LanguageID = {0}
                {3}
                WHERE [Transaction].TransactionTypeID in ({2}) And [Transaction].OrganizationID in ({6}) {1} {4} {7}
                GROUP BY [Transaction].TransactionID,[Transaction].TransactionDate,[Transaction].EmployeeID, 
                [Transaction].CreatedBy,[Transaction].CustomerID, [Transaction].OutletID, [Transaction].Voided, 
                [Transaction].DivisionID,[Transaction].WarehouseID,[Transaction].AccountID,[Transaction].CurrencyID,
                [Transaction].SelectedCurrencyID,[Transaction].OrganizationID, [Transaction].CreationReason,
                [Transaction].TransactionTypeID,[Transaction].RouteId,[Transaction].SalesMode,[Transaction].SourceTransactionID,
                [Transaction].RouteHistoryID,Customer.CustomerCode, CustomerLanguage.Description,
                CustomerOutlet.CustomerCode ,CustomerOutletLanguage.Description,CustomerLanguage.Description,
                CustomerOutletLanguage.Description,Customer.CustomerCode,CustomerOutlet.CustomerCode,
                EmployeeLanguage.Description,DivisionLanguage.Description",
                _requestRepository.LanguageId, //0
                supervisionJoin, //1
                TransactionType.SalesExchange.GetHashCode(), //2
                orgAccessJoin, //3
                searchFilter, //4
                ResourcesManager.TranslateKey(MessagesConstants.Desc_Voided_Caption, _requestRepository.LanguageId), //5
                _requestRepository.CurrentOperator.OrganizationAccess, //6
                divisionAccess, //7
                routeFilter //8
                );

                string invoicesQuery = string.Format(@" {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                filter.CustomListFilter.Page * filter.CustomListFilter.PageSize, //2
                filter.CustomListFilter.PageSize //3
                );

                string countQuery = string.Format(@"Select IsNull(Count(*),0) From ({0}) tt", mainQuery);
                // get count
                object objField = 0;
                result = dbHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    transList.TotalItems = int.Parse(objField.ToString().Trim());
                    if (transList.TotalItems <= 0)
                    {
                        transList.Data = transactions;
                        return GlobalErrors.Success;
                    }
                }
                else
                {
                    return GlobalErrors.Error;
                }

                result = dbHelper.GetQueryList(invoicesQuery, ref transactions , true);
                transList.Data = transactions;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                transList = null;
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors IsAnyPackResellable(List<ItemPackModel> orderItems, ref List<int> resellablePackStatuses, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                var orderPackStatuses = string.Join(',', orderItems.Select(i => i.PackStatusId).Distinct().ToList());
                if (!string.IsNullOrEmpty(orderPackStatuses))
                {
                    string query = $@"select PackStatus.StatusID  from PackStatus where PackStatus.ReSellable = {PackStatus.ReSellable.GetHashCode()} and PackStatus.StatusID in ({orderPackStatuses})";
                    result = dBHelper.GetQueryList(query, ref resellablePackStatuses);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error; ;
            }
            return result;
        }
        public bool GiveCreditOnReturn(CustomerTypes outletType)
        {
            try
            {
                if (outletType == CustomerTypes.CashCustomer)
                {
                    return _requestRepository.Configurations.GiveCreditOnReturnForCashCustomers;
                }
                else
                {
                    return _requestRepository.Configurations.GiveCreditOnReturnForCreditCustomers;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        public bool GivePartialCredit(CustomerTypes outletType)
        {
            try
            {
                if (outletType == CustomerTypes.CashCustomer)
                {
                    return _requestRepository.Configurations.GivePartialCreditForCashCustomer;
                }
                if (outletType == CustomerTypes.CreditCustomer || outletType == CustomerTypes.BillToBillCustomer)
                {
                    return _requestRepository.Configurations.GivePartialCreditForCreditCustomer;
                }
                return false;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
        }
        private GlobalErrors CreateCreditNoteOnExchange(DBHelper<int> dBHelper, TransactionModel returnTransaction, decimal Amount, string creditNoteID)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                TransactionModel creditNoteTrans = new TransactionModel();
                creditNoteTrans.EmployeeId = returnTransaction.EmployeeId;
                creditNoteTrans.CurrencyId = returnTransaction.CurrencyId;
                creditNoteTrans.CustomerId = returnTransaction.CustomerId;
                creditNoteTrans.RouteId = returnTransaction.RouteId;
                creditNoteTrans.OutletId = returnTransaction.OutletId;
                creditNoteTrans.DivisionId = returnTransaction.DivisionId;
                creditNoteTrans.SourceTransactionId = returnTransaction.TransactionId;
                creditNoteTrans.TransactionDate = returnTransaction.TransactionDate;
                creditNoteTrans.GrossTotal = decimal.Round(Amount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTrans.NetTotal = decimal.Round(Amount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTrans.RemainingAmount = decimal.Round(Amount, _requestRepository.Configurations.NumberOfDigits);
                creditNoteTrans.Tax = 0;
                creditNoteTrans.Discount = 0;
                creditNoteTrans.TransactionTypeId = TransactionType.CreditNote.GetHashCode();
                creditNoteTrans.TransactionType = TransactionType.CreditNote;
                creditNoteTrans.TransactionStatusId = TransactionStatues.Approved.GetHashCode();
                creditNoteTrans.CreatedDate = DateTime.Now;
                creditNoteTrans.CreatedBy = _requestRepository.CurrentOperator.EmployeeId;
                creditNoteTrans.Notes = "Generated from Approving a return. " + returnTransaction.Notes;
                creditNoteTrans.TransactionId = creditNoteID;
                creditNoteTrans.SupervisorId = returnTransaction.SupervisorId;
                creditNoteTrans.CreationReason = TransactionCreationReason.Normal;
                creditNoteTrans.HelperId = returnTransaction.HelperId;
                creditNoteTrans.SalesManagerId = returnTransaction.SalesManagerId;
                creditNoteTrans.OrganizationId = returnTransaction.OrganizationId;
                creditNoteTrans.DriverId = returnTransaction.DriverId;
                creditNoteTrans.SalesRepId = returnTransaction.SalesRepId;
                creditNoteTrans.UpdatedDate = DateTime.Now;
                creditNoteTrans.Posted = true;
                creditNoteTrans.AccountId = returnTransaction.Outlet.Account.AccountId;
                creditNoteTrans.Outlet = FillTransactionOutletData(creditNoteTrans.CustomerId, creditNoteTrans.OutletId, creditNoteTrans.DivisionId, dBHelper);
                //if (creditNoteTrans.Outlet != null && creditNoteTrans.Outlet.CustOutPaymentTerm != null)
                //{
                //    PaymentTermModel paymentTerm = new PaymentTermModel();
                //    paymentTerm = creditNoteTrans.Outlet.CustOutPaymentTerm;
                //    creditNoteTrans.DueDate = DateTime.Now.AddDays(paymentTerm.GetDays());
                //}
                result = SaveTransactionHeader(creditNoteTrans, dBHelper);
                if (result == GlobalErrors.Success)
                {
                    result = _documentSequenceManager.UpdateMaxTransactionID(dBHelper, DocumentTypes.CreditNote, creditNoteTrans.TransactionId, creditNoteTrans.EmployeeId, creditNoteTrans.DivisionId);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ApplyCreditNoteOnExchangeSales(CustomerOutletModel outlet, TransactionModel salesTransaction, string creditNoteTransID, string paymentCollectionID, decimal AppliedAmmount, string appliedPaymmentID, DBHelper<int> dBHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            bool commitNow = false;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<int>();
                    dBHelper.BeginTransaction();
                    commitNow = true;
                }
                int accountId = outlet.Account.AccountId;
                int employeeId = salesTransaction.EmployeeId;
                int divisionId = salesTransaction.DivisionId;
                if (GiveCreditOnReturn((CustomerTypes)outlet.CustomerTypeId))
                {
                    PaymentModel payment = new PaymentModel();
                    payment.CustomerPaymentId = paymentCollectionID;
                    payment.PaymentTypeId = PaymentTypes.CreditNote;
                    payment.PaymentStatusId = PaymentStatusTypes.Approved;
                    payment.CreditNoteId = creditNoteTransID;
                    payment.AppliedAmount = AppliedAmmount;
                    payment.RemainingAmount = payment.AppliedAmount;
                    payment.AppliedPaymentId = appliedPaymmentID;
                    payment.VoucherOwner = "";
                    payment.Notes = "";
                    payment.AutoGeneratedByExchange = true;
                    payment.PaymentDate = DateTime.Now;
                    payment.SourceTransactionId = creditNoteTransID;
                    payment.DivisionId = divisionId;
                    payment.CustomerId = outlet.CustomerId;
                    payment.OutletId = outlet.OutletId;
                    result = _paymentManager.InsertPayment(dBHelper, salesTransaction, payment, AppliedAmmount, accountId, employeeId, payment.PaymentDate);
                    if (result == GlobalErrors.Success)
                    {
                        result = _documentSequenceManager.UpdateMaxTransactionID(dBHelper, DocumentTypes.Collection, paymentCollectionID, employeeId, divisionId);
                    }
                }
                else result = GlobalErrors.Success;
                if (commitNow)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        public bool AllowSalesModeSelectionForCustomerInSales(int customerTypeId)
        {
            bool allowSalesModeSelectionForCashCustomersInSales =
                _requestRepository.Configurations.AllowSalesModeSelectionForCashCustomers.Split(',').Select(val => int.Parse(val)).Contains(1);

            return (_requestRepository.Configurations.AllowSalesModeSelection && customerTypeId == CustomerTypes.CreditCustomer.GetHashCode()) ||
                (allowSalesModeSelectionForCashCustomersInSales && customerTypeId == CustomerTypes.CashCustomer.GetHashCode());
        }

        #region[ZATCA]
        public GlobalErrors ArchiveZATCATransactions(TransactionModel sonicTransaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DataTable dt = new DataTable();
            DBHelper<int> dBHelper;
            try
            {
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierTaxNumber))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierTaxNumber", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierIdentificationSchemeID))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierIdentificationSchemeID", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierStreetName))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierStreetName", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierBuildingNumber))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierBuildingNumber", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierPlotIdentification))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierPlotIdentification", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierCityName))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierCityName", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierPostalZone))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierPostalZone", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierCitySubdivisionName))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierCitySubdivisionName", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierRegistrationName))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierRegistrationName", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                if (string.IsNullOrEmpty(_requestRepository.Configurations.SupplierCompanyID))
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Unable to send transactions to ZATCA, please check the value for the configuration SupplierCompanyID", null, string.Empty, 0);
                    return GlobalErrors.Error;
                }
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"Select  t.Nettotal, T.EmployeeID,T.DivisionID,T.CustomerID,T.OutletID,T.TransactionID,T.TransactionDate,T.TransactionTypeID,T.Tax,IsNull(Payments.PaymentTypeID,0)PaymentTypeID,T.Discount,StreetLanguage.Description StreetName,COL.Description OutletName,CO.TradeLicenceNumber,
                CO.PostalCode,CO.TaxNumber,CO.BuildingNumber,CityLanguage.Description CityName,AreaLanguage.Description AreaName,IsNull(CO.IsBusinessCustomer,1)IsBusinessCustomer,ReturnDetails.SalesTransactionIDS,IsNull(ReturnReason.ReturnReason,'Cancellation or suspension of the supplies after its occurrence either wholly or partially')ReturnReason,Customer.ExportCustomer From [Transaction] T
                Inner Join Customer On Customer.CustomerID = T.CustomerID
                outer apply(Select Top 1 TransactionID,CustomerID,OutletID,DivisionID,ReturnReasonLanguage.Description ReturnReason From TransactionDetail
                Inner Join ReturnReasonLanguage On ReturnReasonLanguage.ReturnReasonID = TransactionDetail.ReturnReason And ReturnReasonLanguage.LanguageID = 2 where TransactionDetail.TransactionID = T.TransactionID And TransactionDetail.CustomerID = T.CustomerID And TransactionDetail.OutletID = T.OutletID And TransactionDetail.DivisionID = T.DivisionID )ReturnReason 
                Outer Apply(Select Top 1 CP.PaymentTypeID From CustomerPayment CP Where PaymentStatusID Not In(5,6,11,12) And CP.CustomerID = T.CustomerID And CP.OutletID = T.OutletID And CP.TransactionID = T.TransactionID Order By CP.PaymentDate Desc)Payments
                Inner Join CustomerOutlet CO On CO.CustomerID = T.CustomerID And CO.OutletID = T.OutletID
                left Join StreetLanguage On StreetLanguage.StreetID = CO.StreetID And StreetLanguage.LanguageID = 2

                left Join (Select T.CustomerID,T.OutletID,ReturnInvoicesHistory.TransactionTypeID,ReturnTransactionID,String_Agg(T.GeneratedID,',')SalesTransactionIDS 
                From ReturnInvoicesHistory
                Inner Join ETransactions T On T.CustomerID = ReturnInvoicesHistory.CustomerID And T.OutletID = ReturnInvoicesHistory.OutletID
                And T.TransactionTypeID In (1,3)
                And T.TransactionID = ReturnInvoicesHistory.SalesTransactionID
                Group By T.CustomerID,T.OutletID,ReturnInvoicesHistory.TransactionTypeID,ReturnTransactionID) ReturnDetails On ReturnDetails.ReturnTransactionID = T.TransactionID
                And ReturnDetails.CustomerID = T.CustomerID And ReturnDetails.OutletID = T.OutletID 
                Inner Join CustomerOutletLanguage COL On COL.CustomerID = CO.CustomerID And COL.OutletID = CO.OutletID And COL.LanguageID = 2
                left Join CityLanguage On CityLanguage.CityID = CO.CityID And CityLanguage.LanguageID = 2
                left Join AreaLanguage On AreaLanguage.AreaID = CO.AreaID And AreaLanguage.LanguageID = 2
                left Join ETransactions E On E.TransactionID = T.TransactionID And E.CustomerID = T.CustomerID And E.OutletID = T.OutletID And E.TransactionTypeID = T.TransactionTypeID And E.DivisionID = T.DivisionID
                Where E.CustomerID Is Null And IsNull(T.Voided,0) = 0
                AND T.TransactionID = '{1}' AND T.CustomerID = {2} AND T.OutletID = {3} AND T.DivisionID = {4}
                order by TransactionDate desc",
                _requestRepository.LanguageId, // 0
                sonicTransaction.TransactionId, // 1
                sonicTransaction.CustomerId, // 2
                sonicTransaction.OutletId, // 3
                sonicTransaction.DivisionId // 4
                );

                result = dBHelper.GetQueryDataTable(query, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    string transactionQRQuery = string.Empty;
                    string transactionQRCode = string.Empty;
                    string supplierName = string.Empty;
                    DataRow row = dt.Rows[0];

                    #region[Fill Data Required For ZATCA Tranasction]
                    TransactionModel transaction = new TransactionModel();
                    transaction.TransactionId = row[CoreDataBaseConstants.QueryColumnsNames.TransactionID].ToString();
                    transaction.ReturnReason = row[CoreDataBaseConstants.QueryColumnsNames.ReturnReason].ToString();
                    transaction.CustomerId = int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.CustomerID].ToString());
                    transaction.NetTotal = decimal.Parse(row[CoreDataBaseConstants.QueryColumnsNames.NetTotal].ToString());
                    transaction.EmployeeId = int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.EmployeeID].ToString());
                    transaction.IsBusinessCustomer = bool.Parse(row[CoreDataBaseConstants.QueryColumnsNames.IsBusinessCustomer].ToString());
                    transaction.OutletId = int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.OutletID].ToString());
                    transaction.DivisionId = int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.DivisionID].ToString());
                    if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.ExportCustomer] != null && dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.ExportCustomer].ToString().Length > 0)
                    {
                        transaction.ExportCustomer = bool.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.ExportCustomer].ToString());
                    }
                    transaction.TransactionTypeId = int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.TransactionTypeID].ToString());
                    if (transaction.TransactionTypeId == (int)TransactionType.Return && row[CoreDataBaseConstants.QueryColumnsNames.SalesTransactionIDS] != null)
                    {
                        transaction.SalesTransactionIds = row[CoreDataBaseConstants.QueryColumnsNames.SalesTransactionIDS].ToString();
                    }
                    if (transaction.TransactionTypeId == (int)TransactionType.Return && row[CoreDataBaseConstants.QueryColumnsNames.ReturnReason] != null)
                    {
                        transaction.ReturnReason = row[CoreDataBaseConstants.QueryColumnsNames.ReturnReason].ToString();
                    }
                    transaction.Discount = decimal.Parse(row[CoreDataBaseConstants.QueryColumnsNames.Discount].ToString());
                    transaction.Tax = decimal.Parse(row[CoreDataBaseConstants.QueryColumnsNames.Tax].ToString());
                    transaction.TransactionDate = DateTime.Parse(row[CoreDataBaseConstants.QueryColumnsNames.TransactionDate].ToString());
                    transaction.ZatcaPaymentType = (PaymentTypes)int.Parse(row[CoreDataBaseConstants.QueryColumnsNames.PaymentTypeID].ToString());
                    transaction.AccountingCustomerParty = new AccountingCustomerParty();
                    transaction.AccountingCustomerParty.partyIdentification = new PartyIdentification();
                    transaction.AccountingCustomerParty.postalAddress = new PostalAddress();

                    if (row[CoreDataBaseConstants.QueryColumnsNames.StreetName] != null && row[CoreDataBaseConstants.QueryColumnsNames.StreetName].ToString().Length > 0)
                    {
                        transaction.AccountingCustomerParty.postalAddress.StreetName = row[CoreDataBaseConstants.QueryColumnsNames.StreetName].ToString();// اجبارى
                    }
                    else if (!_requestRepository.Configurations.AllowSkipZATCANationalAddress)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer street name for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    if (row[CoreDataBaseConstants.QueryColumnsNames.BuildingNumber] != null && row[CoreDataBaseConstants.QueryColumnsNames.BuildingNumber].ToString().Length > 0)
                    {
                        transaction.AccountingCustomerParty.postalAddress.BuildingNumber = row[CoreDataBaseConstants.QueryColumnsNames.BuildingNumber].ToString(); // اجبارى
                    }
                    else if (!_requestRepository.Configurations.AllowSkipZATCANationalAddress)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer building number for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    if (row[CoreDataBaseConstants.QueryColumnsNames.CityName] != null && row[CoreDataBaseConstants.QueryColumnsNames.CityName].ToString().Length > 0)
                    {
                        transaction.AccountingCustomerParty.postalAddress.CityName = row[CoreDataBaseConstants.QueryColumnsNames.CityName].ToString(); // اجبارى
                    }
                    else if (!_requestRepository.Configurations.AllowSkipZATCANationalAddress)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer city name for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    if (row[CoreDataBaseConstants.QueryColumnsNames.PostalCode] != null && row[CoreDataBaseConstants.QueryColumnsNames.PostalCode].ToString().Length > 0)
                    {
                        transaction.AccountingCustomerParty.postalAddress.PostalZone = row[CoreDataBaseConstants.QueryColumnsNames.PostalCode].ToString(); // اجبارى
                    }
                    else if (!_requestRepository.Configurations.AllowSkipZATCANationalAddress)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer postal code for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    if (row[CoreDataBaseConstants.QueryColumnsNames.AreaName] != null && row[CoreDataBaseConstants.QueryColumnsNames.AreaName].ToString().Length > 0)
                    {
                        transaction.AccountingCustomerParty.postalAddress.CitySubdivisionName = row[CoreDataBaseConstants.QueryColumnsNames.AreaName].ToString();// اجبارى
                    }
                    else if (!_requestRepository.Configurations.AllowSkipZATCANationalAddress)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer area name for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    transaction.CustomerName = row[CoreDataBaseConstants.QueryColumnsNames.OutletName].ToString();// اجبارى
                    if (transaction.IsBusinessCustomer)
                    {
                        if (row[CoreDataBaseConstants.QueryColumnsNames.TaxNumber] != null && row[CoreDataBaseConstants.QueryColumnsNames.TaxNumber].ToString().Length > 0)
                        {
                            string taxNumber = row[CoreDataBaseConstants.QueryColumnsNames.TaxNumber].ToString();
                            if (taxNumber.Length != 15 || !(taxNumber.StartsWith("3") && taxNumber.EndsWith("3")))
                            {
                                if (row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber] != null && row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber].ToString().Length > 0)
                                {
                                    transaction.AccountingCustomerParty.partyIdentification.ID = row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber].ToString();//رقم السجل التجارى
                                    transaction.AccountingCustomerParty.partyIdentification.schemeID = "CRN";//Check Document
                                    transaction.AccountingCustomerParty.partyTaxScheme.CompanyID = null;
                                }
                                else
                                {
                                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer trade license number for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Customer Tax Number Is Wrong For transaction: " + transaction.TransactionId, null, string.Empty, 0);
                                    return GlobalErrors.Error;
                                }
                            }
                            else
                            {
                                transaction.AccountingCustomerParty.partyIdentification.ID = null;
                                transaction.AccountingCustomerParty.partyIdentification.schemeID = null;
                                transaction.AccountingCustomerParty.partyTaxScheme.CompanyID = row[CoreDataBaseConstants.QueryColumnsNames.TaxNumber].ToString();// اجبارى //Tax Number
                            }
                        }
                        else if (row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber] != null && row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber].ToString().Length > 0)
                        {
                            transaction.AccountingCustomerParty.partyIdentification.ID = row[CoreDataBaseConstants.QueryColumnsNames.TradeLicenceNumber].ToString();//رقم السجل التجارى
                            transaction.AccountingCustomerParty.partyIdentification.schemeID = "CRN";//Check Document
                            transaction.AccountingCustomerParty.partyTaxScheme.CompanyID = null;
                        }
                        else
                        {
                            ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer trade license number for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                            ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No customer tax number for transaction: " + transaction.TransactionId, null, string.Empty, 0);
                            return GlobalErrors.Error;
                        }
                    }
                    else {
                        transaction.AccountingCustomerParty.partyIdentification.ID = "";
                        transaction.AccountingCustomerParty.partyIdentification.schemeID = "";
                        transaction.AccountingCustomerParty.partyTaxScheme.CompanyID = "";
                    }
                    string transactionDetailQuery = string.Format(@"select replace(ItemLanguage.Description,'&','') as ItemName, Item.ItemCode,  TransactionDetail.TaxPercentage, PackTypeLanguage.Description as UOM,* from TransactionDetail
                            inner join Pack on Pack.PackID = TransactionDetail.PackID
                            inner join Item on Item.ItemID = Pack.ItemID
                            inner join ItemLanguage on ItemLanguage.ItemID = Item.ItemID and ItemLanguage.LanguageID = 1
                            left join PackTypeLanguage on PackTypeLanguage.PackTypeID = Pack.packTypeID and PackTypeLanguage.LanguageID = 1
                            inner join [Transaction] on [Transaction].TransactionID = TransactionDetail.TransactionID and TransactionDetail.TransactionID =  '{0}'
                            where [Transaction].CustomerID = {1} and [Transaction].OutletID = {2} and [Transaction].DivisionID = {3} and [Transaction].TransactionTypeID = {4}",
                    transaction.TransactionId,//0
                    transaction.CustomerId,//1
                    transaction.OutletId,//2
                    transaction.DivisionId,//3
                    transaction.TransactionTypeId);//4
                    DataTable dtDetails = new DataTable();

                    result = dBHelper.GetQueryDataTable(transactionDetailQuery, ref dtDetails);
                    if (result != GlobalErrors.Success || dtDetails == null || dtDetails.Rows.Count == 0)
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error while getting details for transaction " + transaction.TransactionId, null, string.Empty, 0);
                        return GlobalErrors.Error;
                    }
                    else
                    {
                        ItemPackModel detail;
                        transaction.AllItems = new List<ItemPackModel>();
                        for (int id = 0; id < dtDetails.Rows.Count; id++)
                        {
                            detail = new ItemPackModel();
                            detail.ItemName = dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.ItemName].ToString();
                            detail.TaxPercentage = decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.TaxPercentage].ToString());
                            if (dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.BaseTaxPercentage] != null)
                            {
                                detail.BaseTaxPercentage = decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.BaseTaxPercentage].ToString());
                            }
                            detail.Discount = decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.Discount].ToString());
                            detail.Quantity = decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.Quantity].ToString());
                            detail.Price = decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.Price].ToString()) + decimal.Round(decimal.Parse(dtDetails.Rows[id][CoreDataBaseConstants.QueryColumnsNames.ExciseTax].ToString()) / detail.Quantity, 2);
                            if (detail.Price == 0 && detail.TaxPercentage == 0)
                            {
                                detail.TaxPercentage = detail.BaseTaxPercentage;
                            }
                            transaction.AllItems.Add(detail);
                        }
                        bool isValid = ArchiveTransaction(transaction);
                        if (!isValid) result = GlobalErrors.Error;
                    }
                    if (result != GlobalErrors.Success) return GlobalErrors.Error;
                }
                else result = GlobalErrors.Error;
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }


        private bool ArchiveTransaction(TransactionModel transaction)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<int> dBHelper = null;
            try
            {
                long employeeID = transaction.EmployeeId;

                dBHelper = new DBHelper<int>();
                dBHelper.BeginTransaction();

                string CSR = "", PrivateKey = "", PublicKey = "", SecretKey = "", PIH = "";
                int maxZATCATransactionID = 0;

                result = GetZATCACredentials(dBHelper, ref CSR, ref PrivateKey, ref PublicKey, ref SecretKey, ref maxZATCATransactionID, ref PIH, employeeID, transaction);
                if (result != GlobalErrors.Success)
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Archiving ZATCA Transactions : Error In Getting Credentials", null, string.Empty, 0);
                    return false;
                }
                //for information
                // VAT Category (O) "Not subject to VAT" (O)  غير خاضع لضريبة القيمة المضافة لابد ان يكون نسبة الضريبة صفر
                // VAT Category (E)   معفى من ضريبة القيمة المضافة نسبة الضريبة هتكون صفر ولابد من ذكر سبب الاعفاء :TaxExemptionReason
                // VAT Category (S)   ضريبة القيمة المضافة لابد من كتابة النسبة وتكون اكبر من صفر
                // VAT Category (Z)   Zero rated goods  البضائع الخاضعة للنسبة الصفرية 

                UBLXML ubl = new UBLXML();
                ZATCAInvoice inv = new ZATCAInvoice();
                ZATCAResult res = new ZATCAResult();
                maxZATCATransactionID++;
                inv.ID = transaction.TransactionId; // مثال SME00010
                DateTime date;
                //if (transaction.IsBusinessCustomer)
                //{
                //    date = DateTime.Now;
                //}
                //else
                //{
                date = transaction.TransactionDate;
                //}
                string year, month, day, hour, minute, second;
                year = date.Year.ToString();
                month = date.Month.ToString();
                day = date.Day.ToString();
                hour = date.Hour.ToString();
                minute = date.Minute.ToString();
                second = date.Second.ToString();
                if (month.Length == 1) month = "0" + month;
                if (day.Length == 1) day = "0" + day;
                if (hour.Length == 1) hour = "0" + hour;
                if (minute.Length == 1) minute = "0" + minute;
                if (second.Length == 1) second = "0" + second;
                inv.IssueDate = year + "-" + month + "-" + day;// "2021-01-05";
                inv.IssueTime = hour + ":" + minute + ":" + second;
                if (transaction.TransactionTypeId == (int)TransactionType.Return)
                {
                    inv.billingReference.InvoiceDocumentReferenceID = transaction.SalesTransactionIds;
                    inv.invoiceTypeCode.id = 381;
                    inv.UUID = Guid.NewGuid().ToString();
                }
                else
                {
                    inv.billingReference.InvoiceDocumentReferenceID = "";
                    inv.invoiceTypeCode.id = 388;
                }
                if (transaction.IsBusinessCustomer)
                    inv.invoiceTypeCode.Name = "0100000";
                else
                    inv.invoiceTypeCode.Name = "0200000";

                inv.DocumentCurrencyCode = "SAR";//العملة
                inv.TaxCurrencyCode = "SAR";

                // قيمة عداد الفاتورة
                inv.AdditionalDocumentReferenceICV.UUID = maxZATCATransactionID;
                //PaymentMeansCode
                //10 In cash
                //30 Credit
                //42 Payment to bank account
                //48 Bank card
                //1 Instrument not defined(Free text)
                PaymentMeans paymentMeansObj = new PaymentMeans();
                if (transaction.TransactionTypeId == (int)TransactionType.Return || transaction.TransactionTypeId == (int)TransactionType.ReturnExchange)
                {
                    paymentMeansObj.PaymentMeansCode = "1";
                }
                else
                {
                    switch (transaction.ZatcaPaymentType)
                    {
                        case PaymentTypes.None:
                            paymentMeansObj.PaymentMeansCode = "30";
                            break;
                        case PaymentTypes.AllowBankTransfer:
                            paymentMeansObj.PaymentMeansCode = "42";
                            break;
                        default:
                            paymentMeansObj.PaymentMeansCode = "10";
                            break;
                    }
                }
                paymentMeansObj.InstructionNote = transaction.ReturnReason;
                inv.paymentmeans.Add(paymentMeansObj); //"Cancellation or suspension of the supplies after its occurrence either wholly or partially"; //اجبارى فى الاشعارات
                                                       // inv.paymentmeans.payeefinancialaccount.ID = "";//اختيارى
                                                       // inv.paymentmeans.payeefinancialaccount.paymentnote = "Payment by credit";//اختيارى
                                                       //بيانات البائع
                inv.SupplierParty.partyIdentification.ID = _requestRepository.Configurations.SupplierTaxNumber;
                inv.SupplierParty.partyIdentification.schemeID = _requestRepository.Configurations.SupplierIdentificationSchemeID;//رقم السجل التجارى
                inv.SupplierParty.postalAddress.StreetName = _requestRepository.Configurations.SupplierStreetName;// اجبارى
                inv.SupplierParty.postalAddress.AdditionalStreetName = ""; //اختيارى
                inv.SupplierParty.postalAddress.BuildingNumber = _requestRepository.Configurations.SupplierBuildingNumber; // اجبارى
                inv.SupplierParty.postalAddress.PlotIdentification = _requestRepository.Configurations.SupplierPlotIdentification;//اختيارى
                inv.SupplierParty.postalAddress.CityName = _requestRepository.Configurations.SupplierCityName;
                inv.SupplierParty.postalAddress.PostalZone = _requestRepository.Configurations.SupplierPostalZone;
                inv.SupplierParty.postalAddress.CitySubdivisionName = _requestRepository.Configurations.SupplierCitySubdivisionName;
                inv.SupplierParty.postalAddress.country.IdentificationCode = "SA";
                inv.SupplierParty.partyLegalEntity.RegistrationName = _requestRepository.Configurations.SupplierRegistrationName;
                inv.SupplierParty.partyTaxScheme.CompanyID = _requestRepository.Configurations.SupplierCompanyID;


                //-------------------Testing Only -- TODO: Comment..
                //inv.SupplierParty.partyIdentification.ID = "4030318225";
                //inv.SupplierParty.partyIdentification.schemeID = "CRN";//رقم السجل التجارى
                //inv.SupplierParty.postalAddress.StreetName = "شارع الملك عبدالله";// اجبارى
                //inv.SupplierParty.postalAddress.AdditionalStreetName = ""; //اختيارى
                //inv.SupplierParty.postalAddress.BuildingNumber = "6789"; // اجبارى
                //inv.SupplierParty.postalAddress.PlotIdentification = "8988";//اختيارى
                //inv.SupplierParty.postalAddress.CityName = "Jeddah";
                //inv.SupplierParty.postalAddress.PostalZone = "76654";
                //inv.SupplierParty.postalAddress.CitySubdivisionName = "Jeddah-جدة";
                //inv.SupplierParty.postalAddress.country.IdentificationCode = "SA";
                //inv.SupplierParty.partyLegalEntity.RegistrationName = "الشركة العربية للتصدير";
                //inv.SupplierParty.partyTaxScheme.CompanyID = "310293023600003";
                //-------------------------------
                // بيانات المشترى اجبارى
                if (transaction.IsBusinessCustomer)
                {
                    inv.CustomerParty.partyIdentification.ID = transaction.AccountingCustomerParty.partyIdentification.ID;//رقم السجل التجارى
                    inv.CustomerParty.partyIdentification.schemeID = transaction.AccountingCustomerParty.partyIdentification.schemeID;//Check Document
                    inv.CustomerParty.postalAddress.StreetName = transaction.AccountingCustomerParty.postalAddress.StreetName;// اجبارى
                    inv.CustomerParty.postalAddress.BuildingNumber = transaction.AccountingCustomerParty.postalAddress.BuildingNumber; // اجبارى
                    inv.CustomerParty.postalAddress.CityName = transaction.AccountingCustomerParty.postalAddress.CityName; // اجبارى
                    inv.CustomerParty.postalAddress.PostalZone = transaction.AccountingCustomerParty.postalAddress.PostalZone; // اجبارى
                    inv.CustomerParty.postalAddress.CitySubdivisionName = transaction.AccountingCustomerParty.postalAddress.CitySubdivisionName;// اجبارى
                    inv.CustomerParty.postalAddress.country.IdentificationCode = "SA";// اجبارى
                    inv.CustomerParty.partyLegalEntity.RegistrationName = transaction.CustomerName;// اجبارى
                    inv.CustomerParty.partyTaxScheme.CompanyID = transaction.AccountingCustomerParty.partyTaxScheme.CompanyID;// اجبارى //Tax Number
                }
                else
                {
                    inv.CustomerParty.partyIdentification.ID = "";
                    inv.CustomerParty.partyIdentification.schemeID = "";
                    inv.CustomerParty.postalAddress.StreetName = "";
                    inv.CustomerParty.postalAddress.BuildingNumber = "";
                    inv.CustomerParty.postalAddress.CityName = "";
                    inv.CustomerParty.postalAddress.PostalZone = "";
                    inv.CustomerParty.postalAddress.CitySubdivisionName = "";
                    inv.CustomerParty.postalAddress.country.IdentificationCode = "";
                    inv.CustomerParty.partyLegalEntity.RegistrationName = "";
                    inv.CustomerParty.partyTaxScheme.CompanyID = "";
                }
                /*AllowanceCharge allowancecharge = new AllowanceCharge();

                allowancecharge.Amount = transaction.Discount;
                allowancecharge.AllowanceChargeReason = "discount"; //reason
                allowancecharge.taxCategory.ID = "S";
                allowancecharge.taxCategory.Percent = 15;
                inv.allowanceCharges.Add(allowancecharge);*/
                /*If Discount Applied On Transaction
                    invline.price.allowanceCharge.AllowanceChargeReason = "discount"; //سبب الخصم على مستوى المنتج
                    invline.price.allowanceCharge.Amount = detail.Discount;//قيم الخصم
                */
                // inv.legalMonetaryTotal.PrepaidAmount = 10;
                foreach (ItemPackModel detail in transaction.AllItems)
                {
                    InvoiceLine invline = new InvoiceLine();
                    invline.InvoiceQuantity = detail.Quantity;

                    invline.item.classifiedTaxCategory.Percent = detail.TaxPercentage;// نسبة الضريبة
                    if (transaction.ExportCustomer)
                        invline.item.classifiedTaxCategory.ID = "Z";// كود الضريبة
                    else
                        invline.item.classifiedTaxCategory.ID = "S";// كود الضريبة
                    invline.price.EncludingVat = false;

                    invline.item.Name = detail.ItemName;
                    invline.price.PriceAmount = detail.Price;
                    AllowanceCharge allowanceChargeObj = new AllowanceCharge();
                    allowanceChargeObj.ChargeIndicator = false;//If False Then It's Discount And If It's True Then It's Charges
                    allowanceChargeObj.AllowanceChargeReason = "discount"; //سبب الخصم على مستوى المنتج
                    allowanceChargeObj.Amount = detail.Discount;//قيم الخصم
                    invline.allowanceCharges.Add(allowanceChargeObj);

                    invline.taxTotal.TaxSubtotal.taxCategory.ID = invline.item.classifiedTaxCategory.ID;//كود الضريبة
                    invline.taxTotal.TaxSubtotal.taxCategory.Percent = detail.TaxPercentage;//نسبة الضريبة
                                                                                            //invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReason = "Private healthcare to citizen";
                                                                                            //invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReasonCode = "VATEX-SA-HEA";
                    if (transaction.ExportCustomer)
                    {
                        if (transaction.Tax > 0)
                        {
                            ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error in sending transaction: " + transaction.TransactionId+ " The customer is export while the tax for the transaction is not zero.", null, string.Empty, 0);
                            return false;
                        }
                        invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReason = "Export";
                        invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReasonCode = "VATEX-SA-32";
                    }
                    else
                    {
                        invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReason = "";
                        invline.taxTotal.TaxSubtotal.taxCategory.TaxExemptionReasonCode = "";
                    }
                    inv.InvoiceLines.Add(invline);
                }
                // here you can pass csid data
                if (PIH != null && PIH.Trim().Length > 0)
                    inv.AdditionalDocumentReferencePIH.EmbeddedDocumentBinaryObject = PIH;
                else
                    inv.AdditionalDocumentReferencePIH.EmbeddedDocumentBinaryObject = "NWZlY2ViNjZmZmM4NmYzOGQ5NTI3ODZjNmQ2OTZjNzljMmRiYzIzOWRkNGU5MWI0NjcyOWQ3M2EyN2ZiNTdlOQ==";
                inv.legalMonetaryTotal.PayableAmount = transaction.NetTotal;
                inv.cSIDInfo.CertPem = PublicKey;
                inv.cSIDInfo.PrivateKey = PrivateKey;
                //res = ubl.GenerateInvoiceXML(inv, GetETransactionsSoftCopyPath());
                res = CallGenerateInvoiceXMLAPI(inv, GetETransactionsSoftCopyPath());
                if (!res.IsValid)
                {
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error while creating XML for transaction : " + transaction.TransactionId, null, string.Empty, 0);
                    ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error Is : " + res.ErrorMessage, null, string.Empty, 0);
                    result = GlobalErrors.Error;
                    return false;
                }
                ApiRequestLogic apireqlogic = new ApiRequestLogic(_requestRepository.Configurations.UseZATCAProductionEnvironment);
                ComplianceCsrResponse tokenresponse = new ComplianceCsrResponse();
                InvoiceReportingRequest invrequestbody = new InvoiceReportingRequest();
                string csr = CSR;
                invrequestbody.invoice = res.EncodedInvoice;
                invrequestbody.invoiceHash = res.InvoiceHash;
                invrequestbody.uuid = res.UUID;
                string BinarySecurityToken = apireqlogic.ToBase64Encode(PublicKey);
                InvoiceClearanceResponse invoiceclearncemodel = null;
                InvoiceReportingResponse invoiceReportingModel = null;
                bool success = false;
                string qrcode = "";
                string signedxml = "";
                string warningMessages = "";
                string newPIH = res.InvoiceHash;
                if (transaction.IsBusinessCustomer)
                {
                    invoiceclearncemodel = apireqlogic.CallClearanceAPI(BinarySecurityToken, SecretKey, invrequestbody);
                    if (invoiceclearncemodel.IsSuccess)
                    {
                        success = true;
                        warningMessages = invoiceclearncemodel.WarningMessage;
                        if (warningMessages == null) warningMessages = "";
                        qrcode = invoiceclearncemodel.QRCode;
                        signedxml = invoiceclearncemodel.SingedXML;

                    }
                    else
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error in sending transaction: " + transaction.TransactionId, new Exception(invoiceclearncemodel.ErrorMessage), string.Empty, 0);
                        result = GlobalErrors.Error;
                        return false;
                    }
                }
                else
                {
                    success = true;
                    invoiceReportingModel = apireqlogic.CallReportingAPI(BinarySecurityToken, SecretKey, invrequestbody);
                    if (invoiceReportingModel.IsSuccess)
                    {
                        qrcode = res.QRCode;
                    }
                    else
                    {
                        ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error in sending transaction: " + transaction.TransactionId, new Exception(invoiceclearncemodel.ErrorMessage), string.Empty, 0);
                        result = GlobalErrors.Error;
                        return false;
                    }
                }
                if (success)
                {
                    string query = string.Format(@"Insert Into ETransactions (TransactionID,CustomerID,OutletID,DivisionID,TransactionTypeID,ArchiveDate,QRCode,PIH,GeneratedID,WarningMessages)
                        Select '{0}',{1},{2},{3},{4},{5},'{6}','{7}',{8},'{9}'",
                           transaction.TransactionId,
                           transaction.CustomerId,
                           transaction.OutletId,
                           transaction.DivisionId,
                           transaction.TransactionTypeId.GetHashCode(),
                           LocalUtilities.ParseDateAndTimeToSQL(date),
                           qrcode,
                           newPIH,
                           inv.AdditionalDocumentReferenceICV.UUID,
                           warningMessages.Replace("'", "''")
                           );
                    result = dBHelper.ExecuteNonQuery(query);
                    string PIHColumnName = "", ZATCATransactionIDColumnName;
                    if (result == GlobalErrors.Success)
                    {
                        if (transaction.TransactionTypeId == (int)TransactionType.Sales || transaction.TransactionTypeId == (int)TransactionType.SalesExchange)
                        {
                            if (transaction.IsBusinessCustomer)
                            {
                                PIHColumnName = CoreDataBaseConstants.QueryColumnsNames.StandardInvoicePIH;
                                ZATCATransactionIDColumnName = CoreDataBaseConstants.QueryColumnsNames.MaxStandardInvoiceID;
                            }
                            else
                            {
                                PIHColumnName = CoreDataBaseConstants.QueryColumnsNames.SimplifiedInvoicePIH;
                                ZATCATransactionIDColumnName = CoreDataBaseConstants.QueryColumnsNames.MaxSimplifiedInvoiceID;
                            }
                        }
                        else
                        {
                            if (transaction.IsBusinessCustomer)
                            {
                                PIHColumnName = CoreDataBaseConstants.QueryColumnsNames.StandardCreditNotePIH;
                                ZATCATransactionIDColumnName = CoreDataBaseConstants.QueryColumnsNames.MaxStandardCreditNoteID;
                            }
                            else
                            {
                                PIHColumnName = CoreDataBaseConstants.QueryColumnsNames.SimplifiedCreditNotePIH;
                                ZATCATransactionIDColumnName = CoreDataBaseConstants.QueryColumnsNames.MaxSimplifiedCreditNoteID;
                            }
                        }
                        query = string.Format("Update ZATCACredentials Set {0} = {1},{2} = '{3}' Where EmployeeID = {4}", ZATCATransactionIDColumnName, maxZATCATransactionID, PIHColumnName, newPIH, employeeID);
                        result = dBHelper.ExecuteNonQuery(query);
                        if (result != GlobalErrors.Success)
                        {
                            ErrorLogger.ETransactionsLogger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error In Updating ZATCA Credentials Table After Transaction : " + transaction.TransactionId, new Exception(invoiceclearncemodel.ErrorMessage), string.Empty, 0);
                        }
                    }
                    if (!Directory.Exists(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Signed By ZATCA")))
                    {
                        Directory.CreateDirectory(Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Signed By ZATCA"));
                    }
                    if (transaction.IsBusinessCustomer)
                    {
                        if (!Directory.Exists(Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Sales")))
                            Directory.CreateDirectory(Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Sales"));
                        if (!Directory.Exists(Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Returns")))
                            Directory.CreateDirectory(Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Returns"));
                        string filePath = "";
                        if (transaction.TransactionTypeId == (int)TransactionType.Sales || transaction.TransactionTypeId == (int)TransactionType.SalesExchange)
                        {
                            filePath = Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Sales", res.SingedXMLFileName);
                        }
                        else
                        {
                            filePath = Path.Combine(GetETransactionsSoftCopyPath(), "Signed By ZATCA", "Returns", res.SingedXMLFileName);
                        }
                        CreateFile(filePath, signedxml);
                    }
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            finally
            {
                if (dBHelper != null)
                {
                    if (result == GlobalErrors.Success)
                    {
                        dBHelper.CommitTransaction();
                    }
                    else
                    {
                        dBHelper.RollBackTransaction();
                    }
                }
            }
            return true;
        }
        public ZATCAResult CallGenerateInvoiceXMLAPI(ZATCAInvoice inv, string eTransactionPath)
        {
            string url = GetZATCAXMLGenerationAPIURL();
            if (string.IsNullOrEmpty(url))
            {
                ZATCAResult errorResult = new ZATCAResult();
                errorResult.IsValid = false;
                errorResult.ErrorMessage = "Invalid URL for Generate Invoice XML API";
                return errorResult;
            }
            using (var client = new HttpClient())
            {
                //POST Method
                var requestData = new
                {
                    Invoice = inv,
                    ETransactionsSoftCopyPath = eTransactionPath,
                    AllowSkipZATCANationalAddress = _requestRepository.Configurations.AllowSkipZATCANationalAddress
                };
                var data = new StringContent(JsonConvert.SerializeObject(requestData), Encoding.UTF8, "application/json");

                HttpResponseMessage responsePost = client.PostAsync(url, data).Result;

                string reponsestr = responsePost.Content.ReadAsStringAsync().Result;
                ZATCAResult result = new ZATCAResult();
                result.IsValid = false; // initial value -> false.
                if (responsePost.IsSuccessStatusCode)
                {
                    result = JsonConvert.DeserializeObject<ZATCAResult>(reponsestr);
                }
                if (responsePost.StatusCode == System.Net.HttpStatusCode.Accepted)
                {
                    result = JsonConvert.DeserializeObject<ZATCAResult>(reponsestr);
                }
                if (responsePost.StatusCode == System.Net.HttpStatusCode.BadRequest ||
                    responsePost.StatusCode == System.Net.HttpStatusCode.Unauthorized ||
                    responsePost.StatusCode == System.Net.HttpStatusCode.NotAcceptable ||
                    responsePost.StatusCode == System.Net.HttpStatusCode.InternalServerError)
                {
                    ZATCAResult errorResult = new ZATCAResult();
                    ErrorModel error = new ErrorModel();
                    error = JsonConvert.DeserializeObject<ErrorModel>(reponsestr);
                    errorResult.IsValid = false;
                    errorResult.ErrorMessage = error.Code + " : " + error.Message;
                    return errorResult;
                }
                return result;

            }
        }
        private static void CreateFile(string fileName, string content)
        {
            try
            {

                try
                {
                    // Check if file already exists. If yes, delete it.     
                    if (File.Exists(fileName))
                    {
                        File.Delete(fileName);
                    }

                    // Create a new file 
                    using (FileStream fs = File.Create(fileName))
                    {
                        // Add some text to file    
                        Byte[] title = new UTF8Encoding(true).GetBytes(content);
                        fs.Write(title, 0, title.Length);
                    }

                    // Open the stream and read it back.    
                    using (StreamReader sr = File.OpenText(fileName))
                    {
                        string s = "";
                        while ((s = sr.ReadLine()) != null)
                        {
                            Console.WriteLine(s);
                        }
                    }
                }
                catch (Exception Ex)
                {
                    Console.WriteLine(Ex.ToString());
                }
            }
            catch (Exception)
            {

                throw;
            }
        }
        private static GlobalErrors GetZATCACredentials(DBHelper<int> dBHelper, ref string CSR, ref string PrivateKey, ref string PublicKey, ref string SecretKey, ref int maxZATCATransactionID, ref string PIH, long employeeID, TransactionModel transaction)
        {
            GlobalErrors result = GlobalErrors.Error;
            try
            {
                string query = "Select * From ZATCACredentials Where EmployeeID = " + employeeID.ToString();
                DataTable dt = new DataTable();
                result = dBHelper.GetQueryDataTable(query, ref dt);

                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count == 1)
                {
                    CSR = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.CSR].ToString();
                    PrivateKey = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.PrivateKey].ToString();
                    PublicKey = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.PublicKey].ToString();
                    SecretKey = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SecretKey].ToString();
                    if (transaction.TransactionTypeId == (int)TransactionType.Sales || transaction.TransactionTypeId == (int)TransactionType.SalesExchange)
                    {
                        if (transaction.IsBusinessCustomer)
                        {
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.StandardInvoicePIH] != null)
                            {
                                PIH = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.StandardInvoicePIH].ToString();
                            }
                            maxZATCATransactionID = int.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.MaxStandardInvoiceID].ToString());
                        }
                        else
                        {
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SimplifiedInvoicePIH] != null)
                            {
                                PIH = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SimplifiedInvoicePIH].ToString();
                            }
                            maxZATCATransactionID = int.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.MaxSimplifiedInvoiceID].ToString());
                        }
                    }
                    else
                    {
                        if (transaction.IsBusinessCustomer)
                        {
                            maxZATCATransactionID = int.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.MaxStandardCreditNoteID].ToString());
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.StandardCreditNotePIH] != null)
                            {
                                PIH = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.StandardCreditNotePIH].ToString();
                            }
                        }
                        else
                        {
                            maxZATCATransactionID = int.Parse(dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.MaxSimplifiedCreditNoteID].ToString());
                            if (dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SimplifiedCreditNotePIH] != null)
                            {
                                PIH = dt.Rows[0][CoreDataBaseConstants.QueryColumnsNames.SimplifiedCreditNotePIH].ToString();
                            }
                        }
                    }
                    if (string.IsNullOrEmpty(CSR) || string.IsNullOrEmpty(PrivateKey) || string.IsNullOrEmpty(PublicKey) || string.IsNullOrEmpty(SecretKey))
                    {
                        result = GlobalErrors.Error;
                    }
                    else
                    {
                        result = GlobalErrors.Success;
                    }
                }
                else
                {
                    result = GlobalErrors.Error;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        private static string GetETransactionsSoftCopyPath()
        {
            try
            {
                var basePath1 = Path.Combine(Environment.CurrentDirectory, @"TransactionsSoftCopy\");
                string basePath = string.Empty;
                XmlDocument ds = new XmlDocument();
                //string originalDatasoucePath = Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase), "DataSources.xml");
                //originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());

                string rootPath = Directory.GetCurrentDirectory();
                string originalDatasoucePath = Path.Combine(rootPath, "DataSources.xml");
                originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());

                XmlTextReader reader = new XmlTextReader(originalDatasoucePath);
                ds.Load(reader);
                if (ds.SelectSingleNode("Connections/TransactionsSoftCopy") != null)
                {
                    basePath = ds.SelectSingleNode("Connections/TransactionsSoftCopy").InnerText.ToString().Trim();
                    return basePath;
                }
                else
                {
                    return basePath1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        private static string GetZATCAXMLGenerationAPIURL()
        {
            string url = string.Empty;
            try
            {
                XmlDocument ds = new XmlDocument();

                string rootPath = Directory.GetCurrentDirectory();
                string originalDatasoucePath = Path.Combine(rootPath, "DataSources.xml");
                originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());
                XmlTextReader reader = new XmlTextReader(originalDatasoucePath);
                ds.Load(reader);
                if (ds.SelectSingleNode("Connections/ZATCAXMLGeneration") != null)
                {
                    url = ds.SelectSingleNode("Connections/ZATCAXMLGeneration").InnerText.ToString().Trim();
                    return url;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return url;
            #endregion
        }
    }
}
