﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using System;
using System.Collections.Generic;
using System.Reflection;
using System.Text;
using System.Linq;
using Sonic.Web.SecureLibrary;

namespace Sonic.Web.Core.Validation
{
    public class ValidationManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly PromotionManager _promotionManager;
        private readonly ItemManager _itemMangager;
        public ValidationManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _promotionManager = new PromotionManager(_requestRepository);
            _itemMangager = new ItemManager(_requestRepository);
        }

        public GlobalErrors GetMaxID(string tableName, string columnName,ref int maxId)
        {
            return GetMaxID(tableName, columnName, ref maxId, null);
        }
        public GlobalErrors GetMaxID(string tableName, string columnName,ref int maxId, DBHelper<int> dbHelper)
        {
            bool disposeNow = false;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                    disposeNow = true;
                }
                object maxIdObj = null;
                string query = string.Format("select Max({1}) from {0} ", tableName, columnName);
                 result = dbHelper.ExecuteScalar(query, ref maxIdObj);
                if (result == GlobalErrors.Success)
                {
                    if (maxIdObj != null && !string.IsNullOrEmpty(maxIdObj.ToString()))
                    {
                        maxId = int.Parse(maxIdObj.ToString()) + 1;
                    }
                    else
                    {
                        maxId = 1;
                    }
                }
                else
                {
                    maxId = -1;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            finally
            {
                if (disposeNow && dbHelper != null)
                {
                    dbHelper.Dispose();
                    dbHelper = null;
                }
            }
            return result;
        }
        public bool CheckIfOrderFromEchoAndSelectionBenifit(TransactionCommonData transationCommonData, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string typeFilter = string.Empty;
            try
            {
                if (dbHelper == null)
                {
                    dbHelper = new DBHelper<int>();
                }
                string selectionPromoOutputDetailTypes = string.Format("{0}, {1}, {2}",
                   PromotionOutputDetailTypes.SummationOverGroup.GetHashCode(),
                   PromotionOutputDetailTypes.FreeItemsWithCertainValue.GetHashCode(),
                   PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage.GetHashCode());
                string query = string.Format(@"
                SELECT COUNT(*) FROM SalesOrder AS SO INNER JOIN PromotionBenefitHistory AS PBH ON SO.OrderID = PBH.TransactionID
                WHERE (PBH.TransactionID = '{0}') AND (PBH.DivisionID = {1}) AND (SO.CreationSource = {2}) AND (PBH.PackID = -1) AND (PBH.PromotionOptionDetailTypeID IN ({3}))"
                , transationCommonData.OrderId, transationCommonData.DivisionId, CreationSource.Echo.GetHashCode(), selectionPromoOutputDetailTypes);
                object refObj = null;
                result = dbHelper.ExecuteScalar(query, ref refObj);
                if (result == GlobalErrors.Success && refObj != null)
                {
                    if ((int)refObj > 0)
                    {
                        return true;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return false;
        }


        public bool CheckCostPrice(TransactionCommonData transationCommonData, ref string msgError)
        {
            try
            {
                decimal amount = 0;
                decimal costAmount = 0;
                foreach (ItemPackModel item in transationCommonData.SoldItems)
                {
                    amount = item.Price * item.RequiredQty - item.CalculatedDiscount;
                    costAmount = item.CostPrice * item.RequiredQty;
                    if (amount < costAmount)
                    {
                        msgError = string.Format(ResourcesManager.TranslateKey(MessagesConstants.Desc_Msg_Cost_Price_Larger_Than_Original, _requestRepository.LanguageId), item.ItemCodeName + " (" + item.Uom + ")");
                        return false;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return false;
            }
            return true;
        }
        #region [Order Bundles]
        public GlobalErrors GetPackItemsWithPrice(int customerId, int outletId, string packIds, ref List<ItemPackModel> items, bool includeTax)
        {
            DBHelper<ItemPackModel> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<ItemPackModel>();

                string taxSelection = " 0 As Tax";
                if (includeTax)
                {
                    taxSelection = " ISNULL(PriceTempTable.Tax, 0) As Tax ";
                }

                string priceDateFilter = " AND (PriceList.StartDate <= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")" + "AND (PriceList.EndDate >= " + LocalUtilities.ParseDateToSQLString(DateTime.Now) + ")";

                string query = string.Format(@"declare @x table (packid int,price numeric(19,9),tax numeric(19,9),pricelistid int,priority int,rownumber int)
                                    insert into @x
                                    SELECT packID , isnull(prices.Price,0) price, isnull(prices.Tax,0)tax, 
                                    prices.PriceListID, prices.priority, prices.rowNumber                     
                                    FROM (                      
                                    select PriceDefinition.PacKID, PriceDefinition.PriceListID , PriceDefinition.Price, PriceDefinition.Tax,
                                    tt.priority, PriceDefinition.CurrencyID                      , 
                                    row_number ( )  OVER (PARTITION BY packID ORDER BY tt. priority ASC) AS rowNumber,
                                    PriceQuantityRange.RangeStart, PriceQuantityRange.RangeEnd                     
                                    from PriceDefinition                      
                                    inner join(                      
                                    select PriceListID, 1 as priority from CustomerPrice                     
                                    where CustomerID = {0} and OutletID = {1}                      
                                    union                      
                                    select PriceListID, 2 as priority from GroupPrice                     
                                    where GroupPrice.GroupID in (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1})                      
                                    union                      
                                    select PriceListID, 3 as priority from ChannelPrice                      
                                    where  SubChannelID in (select SubChannelID from CustomerGroup where GroupID in 
                                    (SELECT GroupID FROM CustomerOutletGroup WHERE CustomerID = {0} and OutletID = {1}))
                                    union                      
                                    select PriceListID, 5 as priority from PriceDefinition                      
                                    Where PriceDefinition.PriceListID in ({2})) tt on tt.PriceListID = PriceDefinition.PriceListID and tt.PriceListID is not null    
                                    inner join PriceList on pricelist.PriceListID = PriceDefinition.PriceListID and PriceList.IsDeleted = 0 and PriceList.PriceListTypeID={4}  {3}
                                    inner join PriceQuantityRange on PriceDefinition.QuantityRangeID = PriceQuantityRange.PriceQuantityRangeID                      
                                    and ( 1 >= PriceQuantityRange.RangeStart and 1 <= PriceQuantityRange.RangeEnd ) ) as prices 
                                    WHERE prices.rowNumber = 1 AND (prices.priority is not null) 
                                    and (Prices.PriceListID is not null)
                                    
                                    SELECT Pack.ItemID,pack.Quantity as PiecesInPack ,ItemLanguage.Description ItemName ,Item.ItemCode ,Pack.PackID, PackTypeLanguage.Description UOM,
                                    PriceTempTable.Price, {7}
                                    FROM Pack
                                    INNER JOIN @x PriceTempTable ON Pack.PackID = PriceTempTable.PacKID
                                    INNER JOIN Item ON Pack.ItemID = Item.ItemID
                                    INNER JOIN PackTypeLanguage ON Pack.PackTypeID = PackTypeLanguage.PackTypeID AND PackTypeLanguage.LanguageID = {5} 
                                    INNER JOIN ItemCategory on ItemCategory.ItemCategoryID = Item.ItemCategoryID AND ItemCategory.DivisionID IN ( {6} )
                                    INNER JOIN ItemLanguage ON Pack.ItemID =ItemLanguage.ItemID AND ItemLanguage.LanguageID = {5}   
                                    WHERE  pack.ItemID in(SELECT Pack.ItemID FROM Pack
                                    ) and Pack.PackID in ({8}) ORDER BY ItemLanguage.Description
                                    ",
                                    customerId, //0
                                    outletId, //1
                                    _requestRepository.Configurations.DefaultPriceListID.ToString(), //2
                                    priceDateFilter, //3
                                    PriceListTypes.General.GetHashCode(), //4
                                    _requestRepository.LanguageId, //5
                                     _requestRepository.CurrentOperator.DivisionAccess, //6
                                     taxSelection, //7
                                     packIds //8
                                    );

                result = dBHelper.GetQueryList(query, ref items);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public void GetPromotionInputsAndOutputs(Promotion promotion, int customerId, int outletId, bool exculdeBenifitSelectionPromotion)
        {
            string customerOutletFilter = string.Empty;
            string likelySatisfiedFilter = string.Empty;
            string achievementTargetFilter = string.Empty;
            string promotionTypes = string.Empty;
            DBHelper<PromotionOptionDetail> dbHelper = null;
            List<PromotionOptionDetail> promoOptionsList = new List<PromotionOptionDetail>();
            List<PromotionOptionDetail> inputPromoOptionsList = new List<PromotionOptionDetail>();
            List<PromotionOptionDetail> outputPromoOptionsList = new List<PromotionOptionDetail>();
            try
            {
                dbHelper = new DBHelper<PromotionOptionDetail>();
                if (customerId != -1 && outletId != -1)
                {
                    customerOutletFilter = string.Format(" And PromotionCustomerAchievement.CustomerID = {0} And  (PromotionCustomerAchievement.OutletID = {1} OR (PromotionCustomerAchievement.OutletID =-1 AND Promotion.PromotionLevel = {2}))"
                        , customerId, outletId, PromotionLevel.CustomerLevel.GetHashCode());
                }
                promotionTypes = string.Format("{0},{1},{2},{3},{4},{5},{6},{7},{8},{9},{10},{11},{12},{13},{14},{15},{16},{17},{18},{19},{20},{21}",
                                (int)PromotionOutputDetailTypes.DiscountAmount,
                                (int)PromotionOutputDetailTypes.DiscountPercentage,
                                (int)PromotionOutputDetailTypes.ItemQuantity,
                                (int)PromotionOutputDetailTypes.DiscountAmountForItem,
                                (int)PromotionOutputDetailTypes.DiscountPercentageForItem,
                                (int)PromotionOutputDetailTypes.DiscountAmountForGroupItems,
                                (int)PromotionOutputDetailTypes.DiscountPercentageForGroupItems,
                                (int)PromotionOutputDetailTypes.AllItemDiscountAmount,
                                (int)PromotionOutputDetailTypes.AllItemDiscountPercentage,
                                (int)PromotionOutputDetailTypes.FixedPriceOverItem,
                                (int)PromotionOutputDetailTypes.FixedPriceOverAllItem,
                                (int)PromotionOutputDetailTypes.FixedPriceOverGroup,
                                (int)PromotionOutputDetailTypes.FreeItemsOnInvoicePercentage,
                                (int)PromotionOutputDetailTypes.FreeItemsWithCertainValue,
                                (int)PromotionOutputDetailTypes.RetailContractDiscount,
                                (int)PromotionOutputDetailTypes.OpenSteps,
                                (int)PromotionOutputDetailTypes.WholesalesContractsDiscount,
                                (int)PromotionOutputDetailTypes.DynamicTargetDiscount,
                                (int)PromotionOutputDetailTypes.DynamicTargetSummationOverGroup,
                                (int)PromotionOutputDetailTypes.DiscountPercentageOrQtyOverGroupWithSameAmount,
                                (int)PromotionOutputDetailTypes.SummationOverGroup,
                                (int)PromotionOutputDetailTypes.DiscountAmountOverGroup);
                if (!exculdeBenifitSelectionPromotion)
                {
                    promotionTypes = string.Format("{0},{1}, {2} ", promotionTypes,
                                (int)PromotionOutputDetailTypes.SummationOverGroup,
                                (int)PromotionOutputDetailTypes.GroupEqualQuantity);
                }
                likelySatisfiedFilter = string.Format(@" AND (PromotionOptionTypeID = {0} OR (PromotionOptionTypeID = {1} AND PromotionOptionDetail.PromotionOptionDetailTypeID IN ({2})))",
                        PromotionOptionTypes.Input.GetHashCode(), PromotionOptionTypes.Output.GetHashCode(), promotionTypes);

                achievementTargetFilter = string.Format(@" DECLARE @AchTable as Table (TargetID INT, CustomerID INT, OutletID INT, AchievementID INT, Value numeric(19,9), AchievementTypeID INT);
                         INSERT INTO @AchTable 
                         SELECT TargetID, CustomerID, OutletID, AchievementTargetCustomer.AchievementID, Value, Achievement.AchievementTypeID  FROM AchievementTargetCustomer 
                         INNER JOIN Achievement on AchievementTargetCustomer.AchievementID = Achievement.AchievementID 
                         WHERE FromDate <=   {0}  AND AchievementTargetCustomer.ToDate > {0};", LocalUtilities.ParseDateToSQLString(DateTime.Now));

                string query = string.Format(@"{5} SELECT Pack.ItemID ,PromotionOptionDetail.*,PromOptionDetailLanguage.Description,PackTypeLanguage.Description as PackTypeDescription ,
                Pack.Quantity PiecesInPack,PromotionCustomerAchievement.CustomerID , PromotionCustomerAchievement.OutletID,
                AchievementTargetCustomer.Value As TargetValue , PromotionCustomerAchievement.TargetID as TargetID  , AchievementTargetCustomer.AchievementID as AchievementID, AchievementTargetCustomer.AchievementTypeID as AchievementTypeID                 
                FROM PromotionOptionDetail
                Inner Join Promotion on Promotion.PromotionID = PromotionOptionDetail.PromotionID
                LEFT OUTER JOIN Pack ON PromotionOptionDetail.PackID = Pack.PackID
                INNER JOIN PromOptionDetailLanguage ON PromotionOptionDetail.PromotionID = PromOptionDetailLanguage.PromotionID
                AND PromotionOptionDetail.PromotionOptionID = PromOptionDetailLanguage.PromotionOptionID
                AND PromotionOptionDetail.PromotionOptionDetailID = PromOptionDetailLanguage.PromotionOptionDetailID
                AND PromOptionDetailLanguage.LanguageID = {0}
                left join PackTypeLanguage on PromotionOptionDetail.PackTypeID=PackTypeLanguage.PackTypeID and packTypeLanguage.LanguageID={0}
                Left join PromotionCustomerAchievement on PromotionCustomerAchievement.PromotionID = PromotionOptionDetail.PromotionID {2}
                LEFT JOIN @AchTable AchievementTargetCustomer on PromotionCustomerAchievement.TargetID = AchievementTargetCustomer.TargetID and  PromotionCustomerAchievement.CustomerID = AchievementTargetCustomer.CustomerID 
                AND PromotionCustomerAchievement.OutletID = AchievementTargetCustomer.OutletID
                AND PromotionCustomerAchievement.AchievementID = AchievementTargetCustomer.AchievementID
                WHERE PromotionOptionDetail.PromotionID = {1}
                {3}
                ORDER BY PromotionOptionDetail.PromotionOptionID ,PromotionOptionDetail.PromotionOptionDetailID ",
                _requestRepository.LanguageId, promotion.PromotionId, customerOutletFilter, likelySatisfiedFilter, LocalUtilities.ParseDateToSQLString(DateTime.Now), achievementTargetFilter);
                var result = dbHelper.GetQueryList(query, ref promoOptionsList);
                if (promotion.PromotionType == PromotionTypes.TargetPromotion || promotion.PromotionType == PromotionTypes.DynamicTargetPromotion)
                {
                    promoOptionsList.RemoveAll(x => x.AchievementId == -1);
                }
                if (result == GlobalErrors.Success && promoOptionsList.Count > 0)
                {
                    inputPromoOptionsList = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input).ToList();
                    outputPromoOptionsList = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Output).ToList();

                    promotion.IsWholeSaleContract = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input && p.PromotionOptionDetailTypeId == PromotionInputDetailTypes.CustomerMonthlyWholesalesContracts.GetHashCode()).ToList().Count > 0;
                    promotion.IsDynamicSalesAmount = promoOptionsList.Where(p => p.PromotionOptionTypeId == PromotionOptionTypes.Input && p.PromotionOptionDetailTypeId == PromotionInputDetailTypes.DynamicTargetSalesAmount.GetHashCode()).ToList().Count > 0;


                    if (inputPromoOptionsList.Count > 0)
                    {
                        promotion.PromotionInputs = FillInputsAndOutputs(true, inputPromoOptionsList);
                        promotion.PromotionOutputs = FillInputsAndOutputs(true, outputPromoOptionsList);
                    }


                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        public static List<PromotionGroupPackDetail> FillGroupBenefitDetailsForBundle(PromotionOptionDetail detail)
        {
            var groupDetails = new List<PromotionGroupPackDetail>();
            var query = string.Empty;
            DBHelper<PromotionGroupPackDetail> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<PromotionGroupPackDetail>();

                query = string.Format(@"SELECT Pack.ItemID, PromotionBenefitDetailGroup.PackGroupID, Pack.Quantity PackQuantity, PromotionBenefitDetailGroup.PackID, PromotionBenefitDetailGroup.{4} PromotionValue
                FROM PromotionBenefitDetailGroup
                INNER JOIN Pack ON  PromotionBenefitDetailGroup.PackID = Pack.PackID
                INNER JOIN Item on Item.ItemID = Pack.ItemID AND Item.Inactive = 0
                WHERE PromotionID = {0} AND PromotionOptionID = {1} AND PromotionOptionDetailID = {2} AND  PackgroupID = {3} "
                , detail.PromotionId
                , detail.PromotionOptionId
                , detail.PromotionOptionDetailId
                , detail.PackGroupId
                , detail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems ? CoreDataBaseConstants.QueryColumnsNames.DiscountValue : CoreDataBaseConstants.QueryColumnsNames.PriceValue);

                GlobalErrors result = dbHelper.GetQueryList(query, ref groupDetails);
                if (result == GlobalErrors.Success)
                {
                    detail.IsAllGroupItemsHavingSameUOM = groupDetails.GroupBy(j => j.PackQuantity).ToList().Count == 1;

                    if (detail.IsAllGroupItemsHavingSameUOM)
                    {
                        detail.PackGroupQuantity = groupDetails.FirstOrDefault().PackQuantity;
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return groupDetails;
        }
        private List<PromotionOption> FillInputsAndOutputs(bool isBundle, List<PromotionOptionDetail> detailsList)
        {
            List<PromotionOption> options = null;
            try
            {
                options = new List<PromotionOption>();
                foreach (PromotionOptionDetail promotionOptionDetail in detailsList)
                {
                    if (promotionOptionDetail.PromotionOptionTypeId == PromotionOptionTypes.Input)
                    {
                        promotionOptionDetail.InputOptionDetailTypeId = (PromotionInputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;

                        if (promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantity || promotionOptionDetail.InputOptionDetailTypeId == PromotionInputDetailTypes.GroupDifferntQuantityOnTypeLevel)
                        {
                            promotionOptionDetail.PackGroupDetails = PromotionManager.FillGroupPacksQuantityOld(promotionOptionDetail);
                        }
                    }
                    else if (promotionOptionDetail.PromotionOptionTypeId == PromotionOptionTypes.Output)
                    {
                        promotionOptionDetail.OutputOptionDetailTypeId = (PromotionOutputDetailTypes)promotionOptionDetail.PromotionOptionDetailTypeId;
                        if (isBundle && (promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.DiscountPercentageForGroupItems || promotionOptionDetail.OutputOptionDetailTypeId == PromotionOutputDetailTypes.FixedPriceOverGroup))
                        {
                            promotionOptionDetail.PackGroupDetails = PromotionManager.FillGroupBenefitDetailsForBundle(promotionOptionDetail);
                        }
                    }

                    if (!options.Any(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId))
                    {
                        PromotionOption promotionOption = new PromotionOption();
                        promotionOption.PromotionOptionId = promotionOptionDetail.PromotionOptionId;
                        promotionOption.PromotionOptionTypeId = promotionOptionDetail.PromotionOptionTypeId;
                        promotionOption.PromotionId = promotionOptionDetail.PromotionId;
                        promotionOption.ReferenceOptionId = promotionOptionDetail.ReferenceOptionId;
                        options.Add(promotionOption);
                    }
                    options.Find(a => a.PromotionOptionId == promotionOptionDetail.PromotionOptionId).PromotionOptionDetails.Add(promotionOptionDetail);
                }
            }
            catch (Exception ex)
            {
                options = null;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return options;
        }
        public GlobalErrors GetBundlesDetailsWarehouseStock(string packIds, TransactionCommonData transationCommonData, ref List<ItemPackModel> AvaliableItemStock,int employeeTypeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            DBHelper<ItemPackModel> dBHelper = null;
            string includeOrderQty = string.Empty;
            string includeLoadRequestQty = string.Empty;
            string bookedJoin = string.Empty;
            string bookedSelection = string.Empty;
            string bookedLoadRequestJoin = string.Empty;
            string warehouseIds = string.Empty;

            try
            {
                dBHelper = new DBHelper<ItemPackModel>();
                if(result != GlobalErrors.Success)
                {
                    return GlobalErrors.Error;
                }

                var employeeTypeFO = string.Format(@"{0},{1},{2},{3},{4},{5},{6},{7}",
         EmployeeTypes.Salesperson.GetHashCode(),
         EmployeeTypes.Deliveryperson.GetHashCode(),
         EmployeeTypes.Collector.GetHashCode(),
         EmployeeTypes.Presales.GetHashCode(),
         EmployeeTypes.Driver.GetHashCode(),
         EmployeeTypes.SalesRepresentative.GetHashCode(),
         EmployeeTypes.VanInCharge.GetHashCode(),
         EmployeeTypes.Merchandiser.GetHashCode());

                var employeeTypeIds = employeeTypeFO.Split(",").Select(int.Parse).ToList();
                var IsFOEmployee = employeeTypeIds.Contains(employeeTypeId);
                var warehouseFilterForPendingOrders = string.Empty;
                var loadingWarehousesIdsFilter = string.Empty;
                var vichelwarhouse = string.Empty;
                var joinEmployeeVichel = string.Empty;
                var joinVehicleLoadingWh = string.Empty;
                var vehicleQtyJoin = string.Empty;
                var vehicleSelectedQuantity = string.Empty;
                var organizationAccessSalesOrder = string.Empty;
                var organizationAccessWarehouse = string.Empty;
                string bookedOrderPeriod = string.Empty;
                string bookedLoadReqPeriod = string.Empty;
                string BookedQtyPeriod = _requestRepository.Configurations.BookedQtyPeriod;
                if (transationCommonData.warehouseId > 0 && _requestRepository.Configurations.AllowWarehouseSelectionInPendingOrders)
                {
                    warehouseFilterForPendingOrders = $" and  SO.WarehouseID = {transationCommonData.warehouseId}";
                    loadingWarehousesIdsFilter = $" and  w.WarehouseID = {transationCommonData.warehouseId}";
                }
                else
                {
                    if (IsFOEmployee)
                    {

                        result = OrderManager.GetLoadingWarehousesForEmployeeAsString(transationCommonData.EmployeeId, null, ref warehouseIds);
                        if (result != GlobalErrors.Success)
                            return result;
                        if (!string.IsNullOrEmpty(warehouseIds))
                            {
                                warehouseFilterForPendingOrders = string.Format(@" And ((SO.EmployeeID in (select EmployeeID from EmployeeVehicle 
                        where VehicleID in (select VehicleID from VehicleLoadingWh where warehouseid in ({0})))) 
                      ) ", warehouseIds);

                                loadingWarehousesIdsFilter = string.Format("and w.WarehouseID in ({0})", warehouseIds);
                            }

                        //loadingWarehousesIdsFilter = string.Format(@" And ((Employee.EmployeeTypeID != 1 and SO.EmployeeID in (select distinct EmployeeID from EmployeeVehicle
                        //where VehicleID in (select distinct VehicleID from VehicleLoadingWh where warehouseid in (select VehicleLoadingWh.WarehouseId
                        //from VehicleLoadingWh
                        //inner join Warehouse on Warehouse.WarehouseId = VehicleLoadingWh.WarehouseId and Warehouse.OrganizationID in ({0})
                        //inner join EmployeeVehicle on EmployeeVehicle.VehicleId = VehicleLoadingWh.VehicleId and EmployeeVehicle.EmployeeId = {1})))) 
                        //or Employee.EmployeeTypeID = 1)", _requestRepository.CurrentOperator.OrganizationAccess , transationCommonData.EmployeeId);

                        //vichelwarhouse = string.Format(@" and w.WarehouseID in (select distinct VehicleLoadingWh.WarehouseId
                        // from VehicleLoadingWh");
                        //joinEmployeeVichel = string.Format(@"inner join EmployeeVehicle on EmployeeVehicle.VehicleId = VehicleLoadingWh.VehicleId and EmployeeVehicle.EmployeeId = {0} )", transationCommonData.EmployeeId);
                        //joinVehicleLoadingWh = string.Format(@"inner join Warehouse on Warehouse.WarehouseId = VehicleLoadingWh.WarehouseId and Warehouse.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);

                    }
                    else
                    {


                        organizationAccessSalesOrder = string.Format(@"and SO.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);
                        organizationAccessWarehouse = string.Format(@"and w.OrganizationID in ({0})", _requestRepository.CurrentOperator.OrganizationAccess);

                        
                    }



                }
                //    employeeFilter = string.Format(@" And Employee.EmployeeTypeID IN ({0})", str);
                int daysStart = 0;
                int daysEnd = 0;

                if (!string.IsNullOrEmpty(BookedQtyPeriod) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim()) && BookedQtyPeriod.Trim().Split(',') != null && BookedQtyPeriod.Trim().Split(',').Length == 2)
                {
                    if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[0].Trim()))
                    {
                        daysStart = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[0].Trim());
                    }
                    if (!string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1]) && !string.IsNullOrEmpty(BookedQtyPeriod.Trim().Split(',')[1].Trim()))
                    {
                        daysEnd = Int32.Parse(BookedQtyPeriod.Trim().Split(',')[1].Trim());
                    }
                    bookedOrderPeriod = string.Format(@" and SO.DesiredDeliveryDate >= {0} and SO.DesiredDeliveryDate <= {1}", LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(daysStart)), LocalUtilities.ParseEndDateToSQLString(DateTime.Now.AddDays(daysEnd)));
                    bookedLoadReqPeriod = string.Format(@" and WT.TransactionDate >= {0} and WT.TransactionDate <= {1}", LocalUtilities.ParseDateToSQLString(DateTime.Now.AddDays(daysStart)), LocalUtilities.ParseEndDateToSQLString(DateTime.Now.AddDays(daysEnd)));
                }
                string query = string.Format(@" Select DISTINCT Item.ItemID, (isnull(availableStock.stockQty,0) {1})  AvailableQtyInPcs
                from Item
                inner join Pack on Pack.ItemID = Item.ItemID and Pack.PackID in ({0})
                {2}
                LEFT OUTER join(
                select pack.ItemID, isnull(sum(WS.quantity*Pack.quantity),0) stockQty 
                from warehousestock WS
                inner join Warehouse w on WS.warehouseID = w.warehouseID {3} and w.WarehouseTypeID = 1 {6}
                inner join pack on pack.packID = WS.PackID 
                group by pack.ItemID) availableStock on availableStock.ItemID = Item.ItemID
                {4}
                where item.Inactive <> 1",
                packIds, //0
                bookedSelection, //1
                bookedJoin, //2
                organizationAccessWarehouse, //3
                bookedLoadRequestJoin, //4
                transationCommonData.EmployeeId, //5
                loadingWarehousesIdsFilter//6
                );
                result = dBHelper.GetQueryList(query, ref AvaliableItemStock);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion
        #region[Contracted FOC]
        public GlobalErrors CheckForContractedFOC(TransactionCommonData transactionCommonData, ref List<AppliedContractedFOCModel> contractedFOCs)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<AppliedContractedFOCModel> allContractedFOCs = new List<AppliedContractedFOCModel>();
                DBHelper<AppliedContractedFOCModel> dBHelper = new DBHelper<AppliedContractedFOCModel>();
                DateTime currentDate = DateTime.Now;

                // Get Shelf Incentive ONLY (contract Type = 3)
                string query = $@"Select ContractedFOC.ContractID, ContractedFOCLanguage.Description ContractName,
                    ContractedFOC.CustomerID, ContractedFOC.OutletID, ContractedFOC.PeriodTypeID, PeriodTypeLanguage.Description PeriodType,
                    ContractedFOC.ValidFrom StartDate,ContractedFOC.ValidTo EndDate, ContractedFOC.OrganizationID,
                    ContractedFOCDetail.Value OriginalValue, ContractedFOCDetail.RemainingValue OriginalRemainingValue,  ContractedFOCDetail.RemainingValue 
                    from ContractedFOC
                    inner join ContractedFOCDetail on ContractedFOCDetail.ContractID = ContractedFOC.ContractID and 
			                    ContractedFOCDetail.CustomerID = ContractedFOC.CustomerID and ContractedFOCDetail.OutletID = ContractedFOC.OutletID
                    Left Join ContractTypeLanguage on ContractTypeLanguage.ContractTypeID = ContractedFOC.ContractTypeID and ContractTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                    LEFT JOIN ContractedFOCLanguage on ContractedFOCLanguage.ContractID = ContractedFOC.ContractID and ContractedFOCLanguage.LanguageID = {_requestRepository.LanguageId}
                    LEFT JOIN PeriodTypeLanguage on PeriodTypeLanguage.PeriodTypeID = ContractedFOC.PeriodTypeID and PeriodTypeLanguage.LanguageID = {_requestRepository.LanguageId}
                    where ContractedFOC.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) 
                    AND ContractedFOC.ValidFrom <= {LocalUtilities.ParseDateAndTimeToSQL(currentDate)} AND ContractedFOC.ValidTo >= {LocalUtilities.ParseDateAndTimeToSQL(currentDate)}
                    AND ContractedFOCDetail.RemainingValue > 0  AND ISNULL(ContractedFOC.IsDeleted,0) <> 1 AND ISNULL(ContractedFOC.Inactive,0) <> 1
                    AND ContractedFOC.CustomerID = {transactionCommonData.CustomerId} AND ContractedFOC.OutletID = {transactionCommonData.OutletId} AND ContractedFOC.ContractTypeID = {(int)ContractType.ShelfIncentive} Order by EndDate ASC";
                result = dBHelper.GetQueryList(query, ref allContractedFOCs);
                if (transactionCommonData.GetApplicableContractedFOCsOnly)
                {
                    if (result == GlobalErrors.Success && allContractedFOCs != null && allContractedFOCs.Count > 0)
                    {
                        decimal calculatedDiscountTotal = transactionCommonData.SoldItems.Sum(item => item.CalculatedDiscountTotal);
                        decimal eligibleAmountForFOC = transactionCommonData.GrossTotal - calculatedDiscountTotal;

                        if (eligibleAmountForFOC > 0)
                        {
                            foreach (AppliedContractedFOCModel foc in allContractedFOCs)
                            {

                                if (foc.RemainingValue >= eligibleAmountForFOC)
                                {
                                    foc.RemainingValue -= eligibleAmountForFOC;
                                    foc.TakenValue = eligibleAmountForFOC;
                                }
                                else
                                {
                                    foc.TakenValue = foc.RemainingValue;
                                    foc.RemainingValue = 0;
                                }
                                eligibleAmountForFOC -= foc.TakenValue;
                                contractedFOCs.Add(foc);
                                if (eligibleAmountForFOC == 0) break;
                            }
                        }
                        else
                        {
                            // if total calculated discount already equals the transaction's gross total, do not apply any FOC's
                            contractedFOCs = new List<AppliedContractedFOCModel>();
                        }
                    }
                }
                else
                {
                    contractedFOCs = allContractedFOCs;
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }

        public GlobalErrors ApplyContractedFOCs(ref TransactionCommonData transactionCommonData)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                if (transactionCommonData.ContractedFOCs != null && transactionCommonData.ContractedFOCs.Count > 0)
                {
                    decimal totalFOCAmount = transactionCommonData.ContractedFOCs.Sum(foc => foc.TakenValue);

                    decimal soldItemsTotalQuantityInPcs = transactionCommonData.SoldItems.Sum(item => item.RequiredQty * item.PiecesInPack);
                    decimal soldItemsGrossTotal = transactionCommonData.SoldItems.Sum(item => item.Price * item.RequiredQty);
                    if (totalFOCAmount > 0)
                    {
                        if (transactionCommonData.SoldItems.Any(x => x.SalesTransactionTypeId == SalesTransactionTypes.Sales))
                        {
                            var items = transactionCommonData.SoldItems.Where(x => x.SalesTransactionTypeId == SalesTransactionTypes.Sales);
                            foreach (ItemPackModel soldPack in items)
                            {
                                decimal calculationRatio = 0;
                                decimal itemFOCDiscountAmount = 0;
                                if (_requestRepository.Configurations.ProductDiscountCalculationMode == 1)  // Distribute discount amount over items' quantity
                                {
                                    decimal currentItemQuantityInPcs = soldPack.RequiredQty * soldPack.PiecesInPack;
                                    calculationRatio = currentItemQuantityInPcs / soldItemsTotalQuantityInPcs;
                                }
                                else // Distribute discount amount over items' gross
                                {
                                    decimal currentItemGrossTotal = soldPack.RequiredQty * soldPack.Price;
                                    calculationRatio = currentItemGrossTotal / soldItemsGrossTotal;
                                }
                                itemFOCDiscountAmount = calculationRatio * totalFOCAmount;
                                soldPack.ShelfIncentiveDiscountAmount = itemFOCDiscountAmount;
                                decimal soldPackTotal = (soldPack.RequiredQty * soldPack.Price) - soldPack.CalculatedDiscountTotal;
                                soldPack.ShelfIncentiveDiscount = (itemFOCDiscountAmount / soldPackTotal) * 100;
                                if (soldPack.ShelfIncentiveDiscount > 100) soldPack.ShelfIncentiveDiscount = 100;
                                //soldPack.HeaderDiscount = soldPack.ShelfIncentiveDiscount;
                                soldPack.CalculatedDiscountTotal += itemFOCDiscountAmount;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion

        #region[Header Discount]
        public GlobalErrors CheckForHeaderDiscount(ref TransactionCommonData transactionCommonData, ref List<HeaderDiscountModel> headerDiscountList)
        {
            GlobalErrors result = GlobalErrors.Success;
            try
            {
                DBHelper<HeaderDiscountModel> dBHelper = new DBHelper<HeaderDiscountModel>();
                string query = $@"Select Distinct HeaderDiscount.* from HeaderDiscount
                Inner join CustomerHeaderDiscount on 
                CustomerHeaderDiscount.HeaderDiscountID = HeaderDiscount.HeaderDiscountID AND 
                (
	                (CustomerId = {transactionCommonData.CustomerId} and OutletID = {transactionCommonData.OutletId}) OR 
	                (GroupID in (select GroupID from CustomerOutletGroup where CustomerID = {transactionCommonData.CustomerId} AND OutletId = {transactionCommonData.OutletId})) OR
	                (SubChannelID in (Select SubChannelID From CustomerGroup Where CustomerGroup.GroupID  IN (select GroupID from CustomerOutletGroup where CustomerID =  {transactionCommonData.CustomerId}  AND OutletId = {transactionCommonData.OutletId}))) OR
	                (AllCustomers = 1)
                )
                where HeaderDiscount.IsDeleted <> 1 AND HeaderDiscount.TypeID = {(int)HeaderDiscountTypes.NormalHeader}
                and (HeaderDiscount.SaleModeID = {transactionCommonData.SalesMode} OR HeaderDiscount.SaleModeID = -1)
                and  HeaderDiscount.OrganizationID in ({_requestRepository.CurrentOperator.OrganizationAccess}) 
                and {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)} >= StartDate AND {LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now)} <= EndDate";
                result = dBHelper.GetQueryList(query, ref headerDiscountList);
                // TODO make sure shelf incentive is accounted for in calculatedTotalDiscount
                if (result == GlobalErrors.Success && headerDiscountList != null && headerDiscountList.Count > 0) 
                {
                    decimal soldItemsGrossTotal = transactionCommonData.SoldItems.Sum(item => item.GrossTotal);
                    if (_requestRepository.Configurations.ApplyRoundingOnCalculations) soldItemsGrossTotal = LocalUtilities.GetRoundedDecimal(soldItemsGrossTotal, _requestRepository.Configurations.NumberOfDigits);

                    decimal calculatedTotalDiscount = transactionCommonData.SoldItems.Sum(item => item.CalculatedDiscountTotal);
                    if (_requestRepository.Configurations.ApplyRoundingOnCalculations) calculatedTotalDiscount = LocalUtilities.GetRoundedDecimal(calculatedTotalDiscount, _requestRepository.Configurations.NumberOfDigits);

                    decimal transactionTotal = soldItemsGrossTotal - calculatedTotalDiscount;
                    if (_requestRepository.Configurations.ApplyRoundingOnCalculations) transactionTotal = LocalUtilities.GetRoundedDecimal(transactionTotal, _requestRepository.Configurations.NumberOfDigits);

                    decimal totalHeaderDiscountPercentage = 0;

                    headerDiscountList.ForEach(disc =>
                    {
                        if (disc.DiscountTypeId == (int)DiscountValueTypes.Percentage)
                            totalHeaderDiscountPercentage += disc.Value;
                        else
                        {
                            decimal discountPct = (disc.Value / transactionTotal) * 100;
                            totalHeaderDiscountPercentage += discountPct;
                        }
                    });
                    transactionCommonData.HeaderDiscount = totalHeaderDiscountPercentage;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        #endregion
    }
}
