﻿using Sonic.Web.DAL;
using Sonic.Web.Model;
using Sonic.Web.Models;
using Sonic.Web.Resources;
using Sonic.Web.SecureLibrary;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Sonic.Web.Core
{
    public class WebFormManager
    {
        private readonly IRequestRepository _requestRepository;
        private readonly EmployeeManager _employeeManager;

        public WebFormManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
            _employeeManager = new EmployeeManager(requestRepository);
        }
        public GlobalErrors GetWebForm(string URL, int webFormId, WebFormType formType, ref WebFormModel formModel)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormModel> dBHelper = new DBHelper<WebFormModel>();
                string menuJoin = string.Empty;
                string condition = string.Empty;
                string query = string.Empty;
                if (formType == WebFormType.List)
                {
                    query = string.Format(@" Select WebForm.* , IsNull(WebMenuLanguage.Description , '--')MenuName ,
                    CASE  WHEN  (WebForm.PrintingQuery IS NOT NULL AND CAST(WebForm.PrintingQuery AS NVARCHAR(max)) <> '') 
                    OR (DATALENGTH(ISNULL(WebForm.PrintingQuery, '')) > 0) THEN 1 ELSE 0 END AS isPrintingQuery
                    From WebForm
                    Inner join WebMenu on WebMenu.MenuId = WebForm.WebMenuId and WebMenu.URL = '{0}' 
                    left join WebMenuLanguage on WebMenuLanguage.MenuId = WebMenu.MenuId and WebMenuLanguage.LanguageId = {1}",
                    URL, _requestRepository.LanguageId);
                }
                else if (formType == WebFormType.Entry)
                {
                    query = string.Format(" Select * From WebForm Where WebForm.WebFormId = '{0}' ", webFormId);
                }
                result = dBHelper.GetQuerySingle(query, ref formModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillWebFormColumns(int formId, ref List<WebFormColumnModel> columns)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormColumnModel> dbHelper = new DBHelper<WebFormColumnModel>();
                string query = string.Format(@"Select WebFormColumn.*, WebFormColumn.ColumnName as [Key] , WebFormColumn.ColumnDescription as Title From WebFormColumn Where WebFormId = {0}
                Order By WebFormColumn.ColumnIndex",
                formId //0
                );
                result = dbHelper.GetQueryList(query, ref columns);
                if (result == GlobalErrors.Success && columns.Count > 0)
                {
                    columns.ForEach(x =>
                    {
                        x.ColumnName = x.ColumnName.ToLower();
                        x.EntryColumnName = x.EntryColumnName == null ? null : x.EntryColumnName.ToLower();
                        x.Key = x.Key.ToLower();
                        x.IsSortable = x.Sortable;
                        x.NumberOfDigits = (x.ColumnTypeId == WebFormColumnType.NumberInDigitsFormat) ? true : false;
                        x.NumberOfStockDigits = (x.ColumnTypeId == WebFormColumnType.NumberInStockDigitsFormat) ? true : false;
                        x.IsDate = (x.ColumnTypeId == WebFormColumnType.DateTime) ? true : false;
                        x.IsExpiryDate = (x.ColumnTypeId == WebFormColumnType.Date) ? true : false;
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillWebFormProcedures(int formId, ref List<WebFormActionProcedure> procedures)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormActionProcedure> dbHelper = new DBHelper<WebFormActionProcedure>();
                string query = string.Format(@"Select * from WebFormActionProcedure Where WebFormId = {0}",
                formId //0
                );
                result = dbHelper.GetQueryList(query, ref procedures);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillWebFormFilters(int formId, ref List<WebFormFilterModel> filters)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormFilterModel> dbHelper = new DBHelper<WebFormFilterModel>();
                string query = string.Format(@"select WebFormFilter.*, WebFormFilterColumn.WebFormID, IsNull(WebFormFilterColumn.Sequence, 0)Sequence ,WebFormFilterColumn.ColumnName,WebFormFilterColumn.DefaultValue
                from WebFormFilter
                inner join WebFormFilterColumn on WebFormFilterColumn.WebFormFilterID = WebFormFilter.WebFormFilterID and WebFormFilterColumn.WebFormID = {0} Order By WebFormFilterColumn.Sequence",
                formId //0
                );
                result = dbHelper.GetQueryList(query, ref filters);
                if (result == GlobalErrors.Success && filters.Count > 0)
                {
                    List<ControlDataSourceModel> dataSourceList = null;
                    foreach (WebFormFilterModel filterModel in filters)
                    {
                        dataSourceList = new List<ControlDataSourceModel>();
                        filterModel.FormControlName = "control_" + filterModel.Sequence;
                        if (!filterModel.BuiltIn && (filterModel.FilterTypeId == WebFormControlType.DropDown || filterModel.FilterTypeId == WebFormControlType.MultiSelectDropDown))
                        {
                            result = FillControlFilterDataSource(filterModel.Query, ref dataSourceList);
                            if (result == GlobalErrors.Success && dataSourceList.Count > 0)
                            {
                                filterModel.DataSourceList = dataSourceList;
                            }
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public string GetWebFormQuery(int formId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string formQuery = string.Empty;
            try
            {
                DBHelper<string> dbHelper = new DBHelper<string>();
                string query = string.Format(@"select WebForm.Query From WebForm Where WebFormId = {0}", formId);
                result = dbHelper.GetQuerySingle(query, ref formQuery);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return formQuery;
        }
        public string GetWebFormPrintingQuery(int formId, bool isFromExport)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string formQuery = string.Empty;
            string query = string.Empty;
            DBHelper<string> dbHelper = new DBHelper<string>();
            try
            {
                query = string.Format(@"select WebForm.{1} From WebForm Where WebFormId = {0}",
                              formId,
                              isFromExport ? "Query" : "PrintingQuery");
                result = dbHelper.GetQuerySingle(query, ref formQuery);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return formQuery;
        }
        public GlobalErrors FillPrinitingQueryData(ref WebFormModel printModel, CustomListFilters SharedTableFilter)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            var data = new List<dynamic>();
            string primaryKeyCondition = string.Empty;
            string searchFilter = string.Empty;
            string filterCondition = string.Empty;
            DBHelper<dynamic> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<dynamic>();

                if (!printModel.IsFromExport && printModel.PrimaryKeyColumnList != null && printModel.PrimaryKeyColumnList.Count > 0)
                {
                    foreach (PrimaryKeyModel primary in printModel.PrimaryKeyColumnList)
                    {
                        if (primary.ColumnTypeId == WebFormColumnType.Date)
                        {
                            DateTime d = DateTime.Parse(primary.Value);
                            primaryKeyCondition += " And " + primary.ColumnName + '=' + LocalUtilities.ParseDateAndTimeToSQL(d);
                        }
                        else if (!string.IsNullOrEmpty(primary.Value))
                        {
                            if (primary.ColumnTypeId == WebFormColumnType.Text)
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + "'" + primary.Value.Replace("'", "''") + "'";
                            }
                            else
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + primary.Value;
                            }
                        }
                    }
                }
                else
                {
                    result = PrepareWebFormList(ref printModel, ref searchFilter, ref filterCondition, true, SharedTableFilter);
                }

                string entryQuery = string.Format(" select * from ({0}) tt Where 1=1 {1} {2} {3}",
                printModel.Query, //0 
                primaryKeyCondition, //1
                searchFilter, //2
                filterCondition // 3
                );

                result = dbHelper.GetQueryList(entryQuery, ref data);
                printModel.ReportData = data;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors PrepareWebFormList(ref WebFormModel form, ref string searchFilter, ref string filterCondition, bool isFiltered, CustomListFilters SharedTableFilter, string orderByFilter = "")
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                if (SharedTableFilter.Page < 0)
                    SharedTableFilter.Page = 0;
                if (SharedTableFilter.PageSize <= 0)
                    SharedTableFilter.PageSize = 100;
                if (!string.IsNullOrEmpty(SharedTableFilter.SearchFilter))
                {
                    SharedTableFilter.SearchFilter = SharedTableFilter.SearchFilter.Replace("'", "''");
                }

                if (!string.IsNullOrEmpty(SharedTableFilter.SearchFilter))
                {
                    searchFilter += " And ( ";
                    int index = 0;
                    // loop on clms
                    foreach (WebFormColumnModel clm in form.Columns.Where(x => x.IsVisible == true).ToList())
                    {
                        if (index > 0)
                        {
                            searchFilter += " OR ";
                        }
                        searchFilter += string.Format(@" ({0} LIKE '%{1}%') ",
                        clm.Key, //0
                        SharedTableFilter.SearchFilter.Trim() //1
                        );
                        index += 1;
                    }
                    searchFilter += " ) ";
                }
                if (!string.IsNullOrEmpty(SharedTableFilter.SortBy))
                {
                    orderByFilter = string.Format(@"Order By {0} {1} ",
                    SharedTableFilter.SortBy,
                    SharedTableFilter.IsSortAscending ? "ASC" : "DESC");
                }
                string queryy = GetWebFormQuery(form.WebFormId);
                queryy = queryy.ToLower();
                result = ReplaceSessionParameters(ref queryy);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                form.Query = queryy;

                #region [Filters]
                if (form.Filters != null && form.Filters.Count > 0)
                {
                    if(isFiltered)
                        form.Filters = form.Filters.Where(x => x.DefaultValue != "" || x.SelectedValue != "" || x.SelectedDateModelValue.Count == 2).ToList();
                    for (int index = 0; index < form.Filters.Count; index++)
                    {
                        switch ((WebFormControlType)form.Filters[index].FilterTypeId)
                        {
                            case WebFormControlType.DateRange:
                                DateTime FromDate = DateTime.MinValue;
                                DateTime toDate = DateTime.MinValue;
                                if (form.Filters[index].SelectedDateModelValue != null && form.Filters[index].SelectedDateModelValue.Count == 2)
                                {
                                    filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(form.Filters[index].SelectedDateModelValue[0].Date), LocalUtilities.ParseEndDateToSQLString(form.Filters[index].SelectedDateModelValue[1].Date));
                                }
                                else if (!isFiltered && form.Filters[index].DefaultValue != null && !string.IsNullOrEmpty(form.Filters[index].DefaultValue.Trim()))
                                {
                                    if (form.Filters[index].DefaultValue == DateDefaultValue.CurrentDay.GetHashCode().ToString())
                                    {
                                        FromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day);
                                        toDate = FromDate;
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(DateTime.Now), LocalUtilities.ParseEndDateToSQLString(DateTime.Now));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.CurrentMonth.GetHashCode().ToString())
                                    {
                                        FromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                                        toDate = (new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1)).AddMonths(1).AddDays(-1);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.CurrentYear.GetHashCode().ToString())
                                    {
                                        FromDate = new DateTime(DateTime.Now.Year, 1, 1);
                                        toDate = new DateTime(DateTime.Now.Year, 12, 31);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.CurrentWeek.GetHashCode().ToString())
                                    {
                                        FromDate = DateTime.Now.AddDays((_requestRepository.Configurations.RouteVisitStartDay - (int)DateTime.Now.DayOfWeek)).AddDays(-1);
                                        toDate = FromDate.AddDays(7).AddSeconds(-1);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.MonthToday.GetHashCode().ToString())
                                    {
                                        FromDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, 1);
                                        toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.YearToday.GetHashCode().ToString())
                                    {
                                        FromDate = new DateTime(DateTime.Now.Year, 1, 1);
                                        toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    else if (form.Filters[index].DefaultValue == DateDefaultValue.WeekToday.GetHashCode().ToString())
                                    {
                                        FromDate = DateTime.Now.AddDays((_requestRepository.Configurations.RouteVisitStartDay - (int)DateTime.Now.DayOfWeek)).AddDays(-1);
                                        toDate = new DateTime(DateTime.Now.Year, DateTime.Now.Month, DateTime.Now.Day, DateTime.Now.Hour, DateTime.Now.Minute, DateTime.Now.Second);
                                        filterCondition += string.Format(@" And ({0} >= {1} and {0} <= {2}) ", form.Filters[index].ColumnName, LocalUtilities.ParseDateToSQLString(FromDate), LocalUtilities.ParseDateToSQLString(toDate));
                                    }
                                    form.Filters[index].SelectedDateModelValue.Add(new DateModel(FromDate));
                                    form.Filters[index].SelectedDateModelValue.Add(new DateModel(toDate));
                                }
                                break;
                            case WebFormControlType.Text:
                                if (form.Filters[index].SelectedValue != null && !string.IsNullOrEmpty(form.Filters[index].SelectedValue.Trim()))
                                {
                                    filterCondition += string.Format(@" And ({0} = '{1}') ",form.Filters[index].ColumnName, form.Filters[index].SelectedValue.Replace("'", "''"));
                                }
                                break;
                            case WebFormControlType.Boolean:
                                if (form.Filters[index].SelectedValue != null && !string.IsNullOrEmpty(form.Filters[index].SelectedValue.Trim()))
                                {
                                    filterCondition += string.Format(@" And {0} = {1} ",form.Filters[index].ColumnName, form.Filters[index].SelectedValue); // bit 1 for true
                                }
                                break;
                            case WebFormControlType.DropDown:
                                if (form.Filters[index].SelectedValue != null && !string.IsNullOrEmpty(form.Filters[index].SelectedValue.Trim()) && form.Filters[index].SelectedValue.Trim() != "-1")
                                {
                                    filterCondition += " And " + form.Filters[index].ColumnName + '=' + form.Filters[index].SelectedValue;
                                }
                                break;
                            case WebFormControlType.Integer:
                            case WebFormControlType.NumberOfDigits:
                            case WebFormControlType.NumberOfStockDigits:
                                if (form.Filters[index].SelectedValue != null && !string.IsNullOrEmpty(form.Filters[index].SelectedValue.Trim()))
                                {
                                    filterCondition += string.Format(@" And {0} = {1}", form.Filters[index].ColumnName, form.Filters[index].SelectedValue);
                                }
                                break;
                        }
                    }
                }
                #endregion
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillWebFormData(WebFormModel form, CustomListFilters SharedTableFilter,bool isFiltered, ref SharedTableResult<dynamic> sharedTableDataSource)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            string filterCondition = string.Empty;
            try
            {
                string orderByFilter = form.DefaultSortingPattern;
                string searchFilter = string.Empty;
                result = PrepareWebFormList(ref form, ref searchFilter, ref filterCondition, isFiltered, SharedTableFilter, orderByFilter);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                sharedTableDataSource = new SharedTableResult<dynamic>();

                string mainQuery = string.Format(" ({0})tt Where 1=1 {1} {2}",
                form.Query, //0 
                searchFilter, //1 
                filterCondition // 2
                );

                string pageDataQuery = string.Format(@" Select * From {0} {1} OFFSET {2} ROWS FETCH NEXT {3} ROWS ONLY",
                mainQuery, //0
                orderByFilter, //1
                (SharedTableFilter.Page) * SharedTableFilter.PageSize, //2
                SharedTableFilter.PageSize //3
                );

                string countQuery = string.Format(@" Select Count(*) from {0}",
                mainQuery //0
                );

                DBHelper<int> dBHelper = new DBHelper<int>();
                object objField = 0;
                result = dBHelper.ExecuteScalar(countQuery, ref objField , true);
                if (result == GlobalErrors.Success && objField != null && !string.IsNullOrEmpty(objField.ToString()))
                {
                    DataTable dt = new DataTable();
                    result = dBHelper.GetQueryDataTable(pageDataQuery, ref dt , true);
                    if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                    {
                        List<dynamic> dataList = new List<dynamic>();
                        DynamicProperty dynamic;
                        for (int rowIndex = 0; rowIndex < dt.Rows.Count; rowIndex++)
                        {
                            dynamic = new DynamicProperty();
                            for (int clmIndex = 0; clmIndex < dt.Columns.Count; clmIndex++)
                            {
                                if (dt.Columns[clmIndex].DataType.FullName == "System.Boolean")
                                {

                                    if (dt.Rows[rowIndex][clmIndex] != null && !string.IsNullOrEmpty(dt.Rows[rowIndex][clmIndex].ToString()) &&
                                       (dt.Rows[rowIndex][clmIndex].ToString().ToLower() == "1" || dt.Rows[rowIndex][clmIndex].ToString().ToLower() == "true"))
                                    {
                                        dynamic[dt.Columns[clmIndex].ColumnName] = ResourcesManager.TranslateKey(MessagesConstants.Desc_Yes, _requestRepository.LanguageId);
                                    }
                                    else
                                    {
                                        dynamic[dt.Columns[clmIndex].ColumnName] = ResourcesManager.TranslateKey(MessagesConstants.Desc_No, _requestRepository.LanguageId);
                                    }
                                }
                                else
                                {
                                    if (form.Columns.Any(x => x.ColumnName == dt.Columns[clmIndex].ColumnName))
                                    {
                                        if (form.Columns.Find(x => x.ColumnName == dt.Columns[clmIndex].ColumnName).ColumnTypeId == WebFormColumnType.Integer || form.Columns.Find(x => x.ColumnName == dt.Columns[clmIndex].ColumnName).ColumnTypeId == WebFormColumnType.NumberInDigitsFormat || form.Columns.Find(x => x.ColumnName == dt.Columns[clmIndex].ColumnName).ColumnTypeId == WebFormColumnType.NumberInStockDigitsFormat)
                                        {
                                            dynamic[dt.Columns[clmIndex].ColumnName] = dt.Rows[rowIndex][clmIndex];
                                        }
                                        else
                                        {
                                            dynamic[dt.Columns[clmIndex].ColumnName] = dt.Rows[rowIndex][clmIndex].ToString();
                                        }
                                    }
                                }

                            }
                            dataList.Add(dynamic.Properties);
                        }

                        sharedTableDataSource.Data = dataList;
                        sharedTableDataSource.TotalItems = int.Parse(objField.ToString().Trim());
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillEntryControls(int formId, ref List<WebFormControlModel> controls)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormControlModel> dbHelper = new DBHelper<WebFormControlModel>();
                string query = string.Format(@"select WebFormControl.*, Case When ParentFilterControlIndex is null or ParentFilterControlIndex = -1 then 0 else 1 end as FilterBySpecificControl from WebFormControl where WebFormID = {0}",
                formId //0
                );
                result = dbHelper.GetQueryList(query, ref controls);
                if (result == GlobalErrors.Success && controls.Count > 0)
                {
                    List<ControlDataSourceModel> dataSourceList = null;
                    foreach (WebFormControlModel controlModel in controls)
                    {
                        dataSourceList = new List<ControlDataSourceModel>();
                        controlModel.ColumnName = controlModel.ColumnName.ToLower();
                        controlModel.DBColumnName = controlModel.DBColumnName.ToLower();
                        controlModel.TableName = controlModel.TableName.ToLower();
                        controlModel.FormControlName = "control_" + controlModel.ControlIndex;

                        // Fill controls data source for non-build in and not filtered by other control
                        if (!controlModel.BuiltIn && !controlModel.FilterBySpecificControl && (controlModel.ControlTypeId == WebFormControlType.DropDown || controlModel.ControlTypeId == WebFormControlType.MultiSelectDropDown))
                        {
                            result = FillControlFilterDataSource(controlModel.Query, ref dataSourceList);
                        }
                        if (controlModel.ControlTypeId == WebFormControlType.DisabledText && !controlModel.FilterBySpecificControl)
                        {
                            string value = string.Empty;
                            result = FillControlDisabledTextValue(controlModel.Query, ref value);
                            controlModel.SelectedValue = value;
                        }
                        if (result == GlobalErrors.Success && dataSourceList.Count > 0)
                        {
                            controlModel.DataSourceList = dataSourceList;
                        }
                        if (result != GlobalErrors.Success)
                        {
                            return result;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillEntryTables(int formId, ref List<WebFormTable> tables)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<WebFormTable> dbHelper = new DBHelper<WebFormTable>();
                string query = string.Format(@"select * from WebFormTable where WebFormID = {0} Order By Sequence",
                formId //0
                );
                result = dbHelper.GetQueryList(query, ref tables);
                if (result == GlobalErrors.Success && tables != null && tables.Count > 0)
                {
                    tables.ForEach(x =>
                    {
                        x.TableName = x.TableName.ToLower();
                    });
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillControlFilterDataSource(string controlQuery, ref List<ControlDataSourceModel> dataSourceList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                controlQuery = controlQuery.ToLower();
                result = ReplaceSessionParameters(ref controlQuery);
                if (result == GlobalErrors.Success)
                {
                    DBHelper<ControlDataSourceModel> dbHelper = new DBHelper<ControlDataSourceModel>();
                    result = dbHelper.GetQueryList(controlQuery, ref dataSourceList);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillControlDisabledTextValue(string controlQuery, ref string value)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                value = string.Empty;
                controlQuery = controlQuery.ToLower();
                result = ReplaceSessionParameters(ref controlQuery);
                if (result == GlobalErrors.Success)
                {
                    DBHelper<string> dbHelper = new DBHelper<string>();
                    object obj = null;
                    result = dbHelper.ExecuteScalar(controlQuery, ref obj);
                    if (result == GlobalErrors.Success)
                    {
                        if (obj != null)
                        {
                            value = obj.ToString();
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillSelectedValuesForMultiSelectControl(WebFormControlModel controlModel, List<PrimaryKeyModel> primaryKeysList, ref List<string> selectedValuesList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string primaryKeyCondition = string.Empty;
                if (primaryKeysList != null && primaryKeysList.Count > 0)
                {
                    foreach (PrimaryKeyModel primary in primaryKeysList)
                    {
                        if (primary.ColumnTypeId == WebFormColumnType.Date)
                        {
                            DateTime d = DateTime.Parse(primary.Value);
                            primaryKeyCondition += " And " + primary.ColumnName + '=' + LocalUtilities.ParseDateAndTimeToSQL(d);
                        }
                        else if (!string.IsNullOrEmpty(primary.Value))
                        {
                            if (primary.ColumnTypeId == WebFormColumnType.Text)
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + "'" + primary.Value.Replace("'", "''") + "'";
                            }
                            else
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + primary.Value;
                            }
                        }
                    }
                }
                string controlQuery = string.Format("Select {0} As ValueId From {1} Where 1=1 {2}",
                controlModel.DBColumnName, //0 
                controlModel.TableName, //1
                primaryKeyCondition //2 
                );
                DBHelper<string> dbHelper = new DBHelper<string>();
                result = dbHelper.GetQueryList(controlQuery, ref selectedValuesList);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors ReplaceSessionParameters(ref string query)
        {
            try
            {
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInLanguageId.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInLanguageId.ToString().ToLower(), _requestRepository.LanguageId.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInEmployeeId.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInEmployeeId.ToString().ToLower(), _requestRepository.CurrentOperator.EmployeeId.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInOrganizationAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInOrganizationAccess.ToString().ToLower(), _requestRepository.CurrentOperator.OrganizationAccess.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInDivisionAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParLoggedInDivisionAccess.ToString().ToLower(), _requestRepository.CurrentOperator.DivisionAccess.ToString());
                }
                if (query.Contains(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParSupervisorAccess.ToString().ToLower()))
                {
                    query = query.Replace(WebFormConstants.FilterParameterPrefix + WebFormConstants.ParSupervisorAccess.ToString().ToLower(), _employeeManager.GetSupervisorAccess());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public GlobalErrors FillControlDataSourceBasedOnParentControlValue(WebFormControlModel control, ref List<ControlDataSourceModel> dataSourceList, ref string disabledControlValue)
        {
            DBHelper<ControlDataSourceModel> dbHelperForDataSource = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dbHelperForDataSource = new DBHelper<ControlDataSourceModel>();
                string controlQuery;
                object field = null;
                string sqlQuery = string.Format("Select Query From WebFormControl Where ControlIndex = {0} And WebFormId = {1}",
                control.ControlIndex, //0 
                control.WebFormId //1
                );
                result = dbHelperForDataSource.ExecuteScalar(sqlQuery, ref field);
                if (result == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    controlQuery = field.ToString().Trim().ToLower();
                    result = ReplaceSessionParameters(ref controlQuery);
                    if (result == GlobalErrors.Success && !string.IsNullOrEmpty(control.ParentFilterControlValue))
                    {
                        if (controlQuery.Contains(WebFormConstants.FilterParameterPrefix + control.ParentFilterControlParameter.ToLower()))
                        {
                            controlQuery = controlQuery.Replace(WebFormConstants.FilterParameterPrefix + control.ParentFilterControlParameter.ToLower(), control.ParentFilterControlValue);
                        }
                        dbHelperForDataSource = new DBHelper<ControlDataSourceModel>();

                        if (control.ControlTypeId == WebFormControlType.DropDown || control.ControlTypeId == WebFormControlType.MultiSelectDropDown)
                        {
                            result = dbHelperForDataSource.GetQueryList(controlQuery, ref dataSourceList);
                            if (result == GlobalErrors.Success)
                            {
                                if (dataSourceList == null)
                                {
                                    dataSourceList = new List<ControlDataSourceModel>();
                                }
                            }
                            else
                            {
                                return result;
                            }
                        }
                        else if (control.ControlTypeId == WebFormControlType.DisabledText)
                        {
                            object obj = null;
                            control.SelectedValue = null;
                            result = dbHelperForDataSource.ExecuteScalar(controlQuery, ref obj);
                            if (result == GlobalErrors.Success)
                            {
                                if (obj != null && !string.IsNullOrEmpty(obj.ToString()))
                                {
                                    disabledControlValue = obj.ToString();
                                    control.SelectedValue = disabledControlValue;
                                }
                            }
                            else
                            {
                                return result;
                            }
                        }
                    }
                }
                else
                {
                    result = GlobalErrors.Error;
                    return result;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return GlobalErrors.Success;
        }
        public int GetMaxID(DBHelper<int> dBHelper, string tableName, string columnName)
        {
            object field = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string query = string.Format("Select IsNull(max({0}),0) + 1 maxID from {1}", tableName, columnName);
                result = dBHelper.ExecuteScalar(query, ref field);
                if (field != null && field != DBNull.Value && !string.IsNullOrEmpty(field.ToString()))
                {
                    return Int32.Parse(field.ToString());
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return -1;
        }
        public GlobalErrors SaveNewEntryFormData(WebFormModel entryForm, WebFormTable table,int attachedCount, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                #region[Check Duplicate Records]
                string primaryKeyCondition = string.Empty;
                int primaryIndex = 0;
                foreach (WebFormControlModel control in entryForm.Controls.Where(x => x.TableName == table.TableName && x.IsPrimary))
                {
                    if (primaryIndex > 0)
                    {
                        primaryKeyCondition += " And ";
                    }
                    if (control.ControlTypeId == WebFormControlType.Date && control.SelectedDateModelValue != null)
                    {
                        primaryKeyCondition += string.Format("  ({0}={1}) ", control.DBColumnName, LocalUtilities.ParseDateToSQLString(new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day)));
                    }
                    else if (!string.IsNullOrEmpty(control.SelectedValue.ToString()))
                    {
                        if (control.ControlTypeId == WebFormControlType.Text || control.ControlTypeId == WebFormControlType.DisabledText)
                        {
                            primaryKeyCondition += string.Format("  ({0}='{1}') ", control.DBColumnName, control.SelectedValue.Replace("'","''"));
                        }
                        else
                        {
                            primaryKeyCondition += string.Format("  ({0}={1}) ", control.DBColumnName, control.SelectedValue);
                        }
                    }
                    primaryIndex++;
                }

                entryForm.FilledPrimaryKeyCondition = primaryKeyCondition;
                object duplicateCount = null;
                string chekQuery = string.Format("Select count(*) from {0} Where 1=1 and {1}", table.TableName, primaryKeyCondition);
                result = dbHelper.ExecuteScalar(chekQuery, ref duplicateCount);

                if (result == GlobalErrors.Success)
                {
                    if (duplicateCount != null && !string.IsNullOrEmpty(duplicateCount.ToString()) && Int32.Parse(duplicateCount.ToString()) > 0)
                    {
                        result = GlobalErrors.DataAlreadyExists;
                        return result;
                    }
                }
                else
                {
                    return result;
                }
                #endregion



                string clmNames = " ( ";
                string clmValues = " Values( ";
                int index = 0;
                foreach (WebFormControlModel control in entryForm.Controls.Where(x => x.TableName == table.TableName && (x.IsPrimary || x.IsVisible)))
                {
                    if (index > 0)
                    {
                        clmNames += ",";
                        clmValues += ",";
                    }
                    clmNames += control.DBColumnName;
                    switch (control.ControlTypeId)
                    {
                        case WebFormControlType.Text:
                        case WebFormControlType.TextArea:
                        case WebFormControlType.DisabledText:
                            clmValues += string.Format(" {0} ", control.SelectedValue == null || string.IsNullOrEmpty(control.SelectedValue.Trim()) ? "Null" : "'" + control.SelectedValue.Replace("'", "''") + "'");
                            break;
                        case WebFormControlType.Date:
                            if (control.SelectedDateModelValue != null)
                            {
                                control.SelectedDateValue = new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day);
                                clmValues += string.Format(" {0} ", LocalUtilities.ParseDateToSQLString(new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day)));
                            }
                            else
                            {
                                clmValues += string.Format(" {0} ", "Null");
                            }
                            break;
                        default:
                            string value = "Null";
                            if (control.SelectedValue != null && !string.IsNullOrEmpty(control.SelectedValue.Trim()))
                            {
                                value = control.SelectedValue;
                            }
                            else if (!string.IsNullOrEmpty(control.DefaultValue))
                            {
                                value = control.DefaultValue;
                            }
                            clmValues += string.Format(" {0} ", value.Replace("'", "''"));
                            break;
                    }
                    index++;
                }
                if (table.HasAuditColumns)
                {
                    clmNames += ",CreatedBy,CreatedDate,UpdatedBy,UpdatedDate";
                    clmValues += string.Format(",{0},{1},{0},{1}", _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                }
                if (table.HasAttachmentColumn)
                {
                    clmNames += "," + CoreDataBaseConstants.QueryColumnsNames.IsAttachmentExists;
                    clmValues += string.Format(",{0}", attachedCount > 0 ? "1" : "0");
                }
                clmNames += " ) ";
                clmValues += " ) ";

                string clmAndValues = clmNames + clmValues;
                string query = string.Format(@"Insert into {0} {1}",
                table.TableName,
                clmAndValues
                );

                result = dbHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success && table.TableName == "organization" && entryForm.WebFormName.ToLower() == "organizationsentry")
                {
                    int organizationId = int.Parse(entryForm.Controls.First(c => c.IsPrimary && c.DBColumnName == "organizationid" && c.TableName == table.TableName).SelectedValue);
                    query = string.Format(@" INSERT INTO EmployeeOrganization VALUES ({0},{1},{2},{3},{2},{3})",
                    _requestRepository.CurrentOperator.EmployeeId, //0
                    organizationId, //1
                    _requestRepository.CurrentOperator.EmployeeId, //2
                    LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //3
                    );
                    result = dbHelper.ExecuteNonQuery(query);
                    if(result == GlobalErrors.Success && _requestRepository.CurrentOperator.EmployeeId != 0)
                    {
                        query = string.Format(@" INSERT INTO EmployeeOrganization VALUES ({0},{1},{2},{3},{2},{3})",
                        0, //0
                        organizationId, //1
                        _requestRepository.CurrentOperator.EmployeeId, //2
                        LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now) //3
                        );
                        result = dbHelper.ExecuteNonQuery(query);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors EditEntryFormData(WebFormModel entryForm, WebFormTable table,int attachedCount, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string primaryKeyCondition = string.Empty;
                string nonPrimaryEditableClms = string.Empty;
                int primaryIndex = 0;

                foreach (WebFormControlModel control in entryForm.Controls.Where(x => x.TableName == table.TableName && x.IsPrimary))
                {
                    if (primaryIndex > 0)
                    {
                        primaryKeyCondition += " And ";
                    }
                    if (control.ControlTypeId == WebFormControlType.Date && control.SelectedDateModelValue != null)
                    {
                        primaryKeyCondition += string.Format("  ({0}={1}) ", control.DBColumnName, LocalUtilities.ParseDateToSQLString(new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day)));
                    }
                    else if (!string.IsNullOrEmpty(control.SelectedValue.ToString()))
                    {
                        if (control.ControlTypeId == WebFormControlType.Text || control.ControlTypeId == WebFormControlType.DisabledText)
                        {
                            primaryKeyCondition += string.Format("  ({0}='{1}') ", control.DBColumnName, control.SelectedValue.Replace("'","''"));
                        }
                        else
                        {
                            primaryKeyCondition += string.Format("  ({0}={1}) ", control.DBColumnName, control.SelectedValue);
                        }
                    }
                    primaryIndex++;
                }

                entryForm.FilledPrimaryKeyCondition = primaryKeyCondition;

                int index = 0;
                foreach (WebFormControlModel control in entryForm.Controls.Where(x => x.TableName == table.TableName && !x.IsPrimary && x.IsVisible && x.AllowEdit))
                {
                    if (index > 0)
                    {
                        nonPrimaryEditableClms += ",";
                    }
                    switch (control.ControlTypeId)
                    {

                        case WebFormControlType.Text:
                        case WebFormControlType.TextArea:
                        case WebFormControlType.DisabledText:
                            nonPrimaryEditableClms += string.Format(" {0}={1} ", control.DBColumnName, control.SelectedValue == null || string.IsNullOrEmpty(control.SelectedValue.Trim()) ? "Null" : "'" + control.SelectedValue.Replace("'", "''") + "'");
                            break;
                        case WebFormControlType.Date:
                            if (control.SelectedDateModelValue != null)
                            {
                                control.SelectedDateValue = new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day);
                                nonPrimaryEditableClms += string.Format(" {0}={1} ", control.DBColumnName, LocalUtilities.ParseDateToSQLString(new DateTime(control.SelectedDateModelValue.Year, control.SelectedDateModelValue.Month, control.SelectedDateModelValue.Day)));
                            }
                            else
                            {
                                nonPrimaryEditableClms += string.Format(" {0}={1} ", control.DBColumnName, "NULL");
                            }
                            break;
                        default:
                            string value = "NULL";
                            if (control.SelectedValue != null && !string.IsNullOrEmpty(control.SelectedValue.Trim()))
                            {
                                value = control.SelectedValue;
                            }
                            else if (!string.IsNullOrEmpty(control.DefaultValue))
                            {
                                value = control.DefaultValue;
                            }
                            nonPrimaryEditableClms += string.Format(" {0}={1} ", control.DBColumnName, value.Replace("'", "''"));
                            break;
                    }
                    index++;
                }
                nonPrimaryEditableClms = nonPrimaryEditableClms.TrimEnd(',');

                if (table.HasAuditColumns)
                {
                    nonPrimaryEditableClms += string.Format(" ,{0}={1}, {2}={3} ", CoreDataBaseConstants.QueryColumnsNames.UpdatedBy, _requestRepository.CurrentOperator.EmployeeId, CoreDataBaseConstants.QueryColumnsNames.UpdatedDate, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                }
                if (table.HasAttachmentColumn)
                {
                    if (!string.IsNullOrEmpty(nonPrimaryEditableClms))
                    {
                        nonPrimaryEditableClms += ",";
                    }

                    nonPrimaryEditableClms += string.Format(" {0}={1} ", CoreDataBaseConstants.QueryColumnsNames.IsAttachmentExists, attachedCount > 0 ? "1" : "0");
                }
                string query = string.Format("Update {0} set {1} where 1=1 And {2} ", table.TableName, nonPrimaryEditableClms, primaryKeyCondition);
                result = dbHelper.ExecuteNonQuery(query);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveWebFormEntryLanguage(List<WebFormControlModel> primaryKeys, WebFormModel entryForm, WebFormTable table, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                List<int> languages = new List<int>();
                string descriptionClmNamess = string.Empty;
                StringBuilder clmValues = new StringBuilder();
                string clmNames = string.Empty;
                string primaryKeysNames = string.Empty;
                string primaryKeysValues = string.Empty;
                List<WebFormControlModel> descriptionControls = entryForm.Controls.Where(x => x.ControlTypeId == WebFormControlType.DescriptionText && x.TableName == table.TableName).ToList();

                descriptionControls.ForEach(control =>
                {
                    descriptionClmNamess += control.DBColumnName;
                    descriptionClmNamess += ",";
                    if (control.DescriptionLanguages.Any(x => x.LanguageId == _requestRepository.LanguageId))
                    {
                        control.DefaultDescription = control.DescriptionLanguages.First(x => x.LanguageId == _requestRepository.LanguageId).Description;
                    }
                    languages.AddRange(control.DescriptionLanguages.Select(x => x.LanguageId).ToList());
                });
                descriptionClmNamess = descriptionClmNamess.TrimEnd(',');
                languages = languages.Distinct().ToList();

                primaryKeysNames = string.Join(",", primaryKeys.Select(c => c.DBColumnName).ToList());
                primaryKeysValues = string.Join(",", primaryKeys.Select(c => c.SelectedValue).ToList());
                clmNames = string.Format("({0},{1},{2})", primaryKeysNames, CoreDataBaseConstants.QueryColumnsNames.LanguageID, descriptionClmNamess);

                foreach (int languageId in languages)
                {
                    string descriptionValues = string.Empty;
                    descriptionControls.ForEach(control =>
                    {
                        string description = string.Empty;

                        if (control.DescriptionLanguages.Any(c => c.LanguageId == languageId) && !string.IsNullOrEmpty(control.DescriptionLanguages.First(c => c.LanguageId == languageId).Description))
                        {
                            description = control.DescriptionLanguages.First(c => c.LanguageId == languageId).Description;
                        }
                        else
                        {
                            description = control.DefaultDescription;
                        }
                        descriptionValues += string.Format("'{0}',", description.Replace("'", "''"));
                    });
                    clmValues.AppendFormat("({0},{1},{2}),",
                    primaryKeysValues, //0
                    languageId, //1
                    descriptionValues.TrimEnd(',') //2
                    );
                }
                string q = "select * from MasterItemGroup ";
                DataTable dt = new DataTable();
                result = dbHelper.GetQueryDataTable(q, ref dt);
                string query = string.Format(@"Insert Into {0} {1} Values {2}",
                table.TableName, //0
                clmNames, //1
                clmValues.ToString().TrimEnd(',') //2
                );
                result = dbHelper.ExecuteNonQuery(query);



                //string descriptionClmName = entryForm.Controls.First(x => x.ControlTypeId == WebFormControlType.DescriptionText && x.TableName == table.TableName).DBColumnName;
                //List<TextLanguage> descriptions = entryForm.Controls.Find(x => x.ControlTypeId == WebFormControlType.DescriptionText && x.TableName == table.TableName).DescriptionLanguages;
                //string defaultDescription = string.Empty;
                //StringBuilder clmValues = new StringBuilder();
                //string clmNames = string.Empty;
                //string primaryKeysNames = string.Empty;
                //string primaryKeysValues = string.Empty;

                //if (descriptions.Any(x => x.LanguageId == _requestRepository.LanguageId))
                //{
                //    defaultDescription = descriptions.First(x => x.LanguageId == _requestRepository.LanguageId).Description;
                //}

                //primaryKeysNames += string.Join(",", primaryKeys.Select(c => c.DBColumnName).ToList());
                //primaryKeysValues += string.Join(",", primaryKeys.Select(c => c.SelectedValue).ToList());

                //clmNames += string.Format("({0},{1},{2})", primaryKeysNames, CoreDataBaseConstants.QueryColumnsNames.LanguageID, descriptionClmName);

                //foreach (TextLanguage descriptionObject in descriptions)
                //{
                //    clmValues.AppendFormat("({0},{1},'{2}'),",
                //    primaryKeysValues, //0
                //    descriptionObject.LanguageId, //1
                //    descriptionObject.Description == null || string.IsNullOrEmpty(descriptionObject.Description.Trim()) ? defaultDescription.Replace("'", "''") : descriptionObject.Description.Replace("'", "''") //2
                //    );
                //}
                //string query = string.Format(@"Insert Into {0} {1} Values {2}",
                //table.TableName, //0
                //clmNames, //1
                //clmValues.ToString().TrimEnd(',') //2
                //);
                //result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteDescriptions(List<WebFormControlModel> primaryKeys, WebFormModel entryForm, WebFormTable table, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string primaryKeyCondition = string.Empty;
                foreach (WebFormControlModel primaryKey in primaryKeys)
                {
                    primaryKeyCondition += string.Format(" And ({0}={1}) ", primaryKey.DBColumnName, primaryKey.SelectedValue);
                }
                string query = string.Format(" Delete From {0} Where 1=1 {1}", table.TableName, primaryKeyCondition);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors SaveWebFormEntryAssignemnt(List<WebFormControlModel> primaryKeys, WebFormModel entryForm, WebFormTable table, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                StringBuilder clmValues = new StringBuilder();
                string clmNames = string.Empty;

                string primaryKeysNames = string.Empty;
                string primaryKeysValues = string.Empty;

                string autidClmNames = string.Empty;
                string auditClmValues = string.Empty;

                WebFormControlModel multiSelectControl = entryForm.Controls.First(x => x.ControlTypeId == WebFormControlType.MultiSelectDropDown && x.TableName == table.TableName);

                primaryKeysNames = string.Join(",", primaryKeys.Select(c => c.DBColumnName).ToList());
                primaryKeysValues = string.Join(",", primaryKeys.Select(c => c.SelectedValue).ToList());
                if (table.HasAuditColumns)
                {
                    autidClmNames = ",CreatedBy,CreatedDate,UpdatedBy,UpdatedDate";
                    auditClmValues = string.Format(",{0},{1},{0},{1}", _requestRepository.CurrentOperator.EmployeeId, LocalUtilities.ParseDateAndTimeToSQL(DateTime.Now));
                }
                clmNames = string.Format("({0},{1}{2})", primaryKeysNames, multiSelectControl.DBColumnName, autidClmNames);

                foreach (string value in multiSelectControl.SelectedValuesList)
                {
                    clmValues.AppendFormat("({0},{1}{2}),",
                    primaryKeysValues, //0
                    value, //1
                    auditClmValues //2
                    );
                }
                string query = string.Format(@"Insert Into {0} {1} Values {2}",
                table.TableName, //0
                clmNames, //1
                clmValues.ToString().TrimEnd(',') //2
                );
                result = dbHelper.ExecuteNonQuery(query);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors DeleteFromAssignemntTable(List<WebFormControlModel> primaryKeys, WebFormModel entryForm, WebFormTable table, DBHelper<int> dbHelper)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                string primaryKeyCondition = string.Empty;
                foreach (WebFormControlModel primaryKey in primaryKeys)
                {
                    primaryKeyCondition += string.Format(" And ({0}={1}) ", primaryKey.DBColumnName, primaryKey.SelectedValue);
                }
                // To Do Later : never delete division or organization out of logged in access
                string query = string.Format(" Delete From {0} Where 1=1 {1}", table.TableName, primaryKeyCondition);
                result = dbHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors FillEntryWebFormDataOnEdit(WebFormModel form, List<PrimaryKeyModel> primaryKeysList)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {

                string query = GetWebFormQuery(form.WebFormId);
                query = query.ToLower();
                result = ReplaceSessionParameters(ref query);
                if (result != GlobalErrors.Success)
                {
                    return result;
                }
                form.Query = query;
                string primaryKeyCondition = string.Empty;
                if (primaryKeysList != null && primaryKeysList.Count > 0)
                {
                    foreach (PrimaryKeyModel primary in primaryKeysList)
                    {
                        if (primary.ColumnTypeId == WebFormColumnType.Date)
                        {
                            DateTime d = DateTime.Parse(primary.Value);
                            primaryKeyCondition += " And " + primary.ColumnName + '=' + LocalUtilities.ParseDateAndTimeToSQL(d);
                        }
                        else if (!string.IsNullOrEmpty(primary.Value))
                        {
                            if (primary.ColumnTypeId == WebFormColumnType.Text)
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + "'" + primary.Value.Replace("'", "''") + "'";
                            }
                            else
                            {
                                primaryKeyCondition += " And " + primary.ColumnName + '=' + primary.Value;
                            }
                        }
                    }
                }


                string entryQuery = string.Format(" select * from ({0}) tt Where 1=1 {1} ",
                form.Query, //0 
                primaryKeyCondition //1 
                );

                DBHelper<int> dBHelper = new DBHelper<int>();
                DataTable dt = new DataTable();
                result = dBHelper.GetQueryDataTable(entryQuery, ref dt);
                if (result == GlobalErrors.Success && dt != null && dt.Rows.Count > 0)
                {
                    for (int rowIndex = 0; rowIndex < dt.Rows.Count; rowIndex++)
                    {
                        for (int clmIndex = 0; clmIndex < dt.Columns.Count; clmIndex++)
                        {
                            string clmName = dt.Columns[clmIndex].ColumnName;
                            string value = dt.Rows[rowIndex][clmIndex].ToString();

                            if (form.Controls.Any(c => c.ColumnName == clmName && c.ControlTypeId != WebFormControlType.DescriptionText && c.ControlTypeId != WebFormControlType.Date))
                            {
                                form.Controls.First(c => c.ColumnName == clmName && c.ControlTypeId != WebFormControlType.Date).SelectedValue = value;
                            }
                            if (form.Controls.Any(c => c.ColumnName == clmName && c.ControlTypeId == WebFormControlType.Date))
                            {
                                form.Controls.First(c => c.ColumnName == clmName && c.ControlTypeId == WebFormControlType.Date).SelectedDateValue = (DateTime)dt.Rows[rowIndex][clmIndex];
                            }
                        }
                    }
                }
                if (form.Controls.Any(c => c.ControlTypeId == WebFormControlType.DescriptionText && c.TableName.Contains("language")))
                {
                    result = GeDescriptionControlValue(form, primaryKeyCondition);
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors GeDescriptionControlValue(WebFormModel entryForm, string PrimaryKeyCondition)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                DBHelper<TextLanguage> dbHelper = new DBHelper<TextLanguage>();
                List<TextLanguage> descriptionsList = new List<TextLanguage>();
                foreach (WebFormControlModel control in entryForm.Controls.Where(c => c.ControlTypeId == WebFormControlType.DescriptionText))
                {
                    string query = string.Format(@"Select {0} as description, LanguageId from {1} where 1=1 {2}", control.DBColumnName, control.TableName, PrimaryKeyCondition);
                    result = dbHelper.GetQueryList(query, ref descriptionsList);
                    if (result != GlobalErrors.Success)
                    {
                        return result;
                    }
                    if (descriptionsList != null)
                    {
                        control.DescriptionLanguages = descriptionsList;
                        if (control.DescriptionLanguages.Any(x => x.LanguageId == _requestRepository.LanguageId))
                        {
                            control.SelectedValue = control.DescriptionLanguages.First(x => x.LanguageId == _requestRepository.LanguageId).Description;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                result = GlobalErrors.Error;
            }
            return result;
        }
        public GlobalErrors getOrganizationDetailsForParent(int OrganizationId , ref OrganizationModel organizationModel)
        {

            GlobalErrors result = GlobalErrors.Error;
            string query = string.Empty;
            try
            {
                DBHelper<OrganizationModel> dBHelper = new DBHelper<OrganizationModel>();
                query = string.Format(@"select
                  IsNull(Organization.OrganizationCode , '--') + ' ' + '-'+ ' ' + IsNull( OrganizationLanguage.Description , '--') OrganizationCodeName 
				  from Organization
	    		  INNER JOIN  organizationlanguage ON organizationlanguage.organizationid = organization.OrganizationID AND
	  			  organizationlanguage.LanguageID = {0} where organization.OrganizationID = {1}", _requestRepository.LanguageId , OrganizationId);
                result = dBHelper.GetQuerySingle(query , ref organizationModel);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
            return result;
        }
    }
}
