﻿using InCube.Security;
using Sonic.Web.Model;
using System;
using System.IO;
using System.Reflection;
using System.Xml;

namespace Sonic.Web.DAL
{
    public class DBManager
    {
        private readonly IRequestRepository _requestRepository;

        public DBManager(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }
        #region [CONNECTION STRING]

        private static string GetConnectionStr(string Conn)
        {
            string decryptedConnection = EncryptionManager.Instance.DecryptPassword(Conn);
            if (decryptedConnection == null) return Conn;
            else return decryptedConnection;
        }
        public static GlobalErrors ReadConnectionString(ref string connectionString)
        {
            try
            {
                string databaseName = "InCube";
                string originalDatasoucePath = Path.Combine(System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase), "DataSources.xml");
                originalDatasoucePath = originalDatasoucePath.TrimStart("file:\\".ToCharArray());
                string datasource = string.Empty;
                string oldDatasource = string.Empty;
                if (File.Exists(originalDatasoucePath))
                {
                    XmlDocument doc = new XmlDocument();
                    XmlTextReader reader = new XmlTextReader(originalDatasoucePath);
                    doc.Load(reader);
                    if (doc.SelectSingleNode("Connections/Connection[Name = 'InCube']/Data") != null)
                    {
                        oldDatasource = doc.SelectSingleNode("Connections/Connection[Name = '" + databaseName + "']/Data").InnerText;
                        datasource = GetConnectionStr(oldDatasource);
                        if (datasource != null && !string.IsNullOrEmpty(datasource.Trim()) &&
                            (System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName == null
                            || System.Net.NetworkInformation.IPGlobalProperties.GetIPGlobalProperties().DomainName.ToLower() != LocalUtilities.DomainName))
                        {
                            string encryptedDatasource = EncryptionManager.Instance.EncryptData(datasource);
                            if (encryptedDatasource != oldDatasource)
                            {
                                doc.SelectSingleNode("Connections/Connection[Name = '" + databaseName + "']/Data").InnerText = encryptedDatasource;
                                reader.Close();
                                doc.Save(originalDatasoucePath);
                            }
                        }
                        else
                        {
                            reader.Close();
                        }
                    }
                }
                if (datasource != null && !string.IsNullOrEmpty(datasource.Trim()))
                {
                    connectionString = datasource;
                    return GlobalErrors.Success;
                }
                else
                    return GlobalErrors.Error;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return GlobalErrors.Error;
            }
        }

        #endregion
        public string ReadDatabaseVersion()
        {
            DBHelper<string> dBHelper = null;
            try
            {
                object value = null;
                dBHelper = new DBHelper<string>();
                string query = "select KeyValue from configuration where KeyName='DatabaseVersion'";
                GlobalErrors result = dBHelper.ExecuteScalar(query, ref value);
                if (result == GlobalErrors.Success && value != null && !string.IsNullOrEmpty(value.ToString()))
                {
                    return value.ToString();
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return string.Empty;
        }

        public static bool CheckIfProcedureExisted(string procedureName)
        {
            return CheckIfProcedureExisted(procedureName, null);
        }
        public static bool CheckIfProcedureExisted(string procedureName, DBHelper<string> dBHelper)
        {
            bool result = false;
            try
            {
                if (dBHelper == null)
                {
                    dBHelper = new DBHelper<string>();
                }
                string statement = string.Empty;
                object field = 0;
                statement = string.Format(@"if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].{0}') 
                        and OBJECTPROPERTY(id, N'IsProcedure') = 1) select x='1'", procedureName);
                dBHelper.ExecuteScalar(statement, ref field);
                if (dBHelper.ExecuteScalar(statement, ref field) == GlobalErrors.Success && field != null && !string.IsNullOrEmpty(field.ToString()))
                {
                    result = field.ToString() == "1";
                }
            }
            catch (Exception ex)
            {
                result = false;
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
    }
}