﻿using Sonic.Web.Model;
using System.Collections.Generic;

namespace Sonic.Web.DAL
{
    public class RequestRepository : IRequestRepository
    {
        public RequestRepository()
        {
            LanguageId = 1;
            Configurations = new Configurations(this);
            ConfigurationsList = new List<ConfigurationModel>();
            CustomerConfigurationsList = new List<ConfigurationModel>();
            GroupConfigurationsList = new List<ConfigurationModel>();
            ChannelConfigurationsList = new List<ConfigurationModel>();
        }

        public Configurations Configurations { get; set; }
        public List<ConfigurationModel> ConfigurationsList { get; set; }
        public List<ConfigurationModel> CustomerConfigurationsList { get; set; }
        public List<ConfigurationModel> GroupConfigurationsList { get; set; }
        public List<ConfigurationModel> ChannelConfigurationsList { get; set; }
        public EchoOperatorModel CurrentEchoOperator { get; set; }
        public OperatorModel CurrentOperator { get; set; }
        public int LanguageId { get; set; }
        public LoggedInUserModel LoginData { get; set; }

        public string SessionId { get; set; }
        public AndroidOperatorModel CurrentAndroidOperator { get; set; }
    }
}