﻿using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Data;
using System.Reflection;

namespace Sonic.Web.DAL
{
    public class Configurations
    {
        private readonly IRequestRepository _requestRepository;

        public Configurations(IRequestRepository requestRepository)
        {
            _requestRepository = requestRepository;
        }

        public Configurations()
        {
        }
        public bool AllowRetailTaxOnItemsForCustomer(int customerId, int outletId)
        {
            var config = _requestRepository.CustomerConfigurationsList.Find(a => a.KeyName.ToLower() == "AllowRetailTaxOnItems".ToLower());
            if (config != null && !string.IsNullOrEmpty(config.KeyValue))
            {
                return bool.Parse(config.KeyValue.Trim());
            }
            else
            {
                config = GetCustomerConfigurationValue(customerId, outletId, "AllowRetailTaxOnItems");
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    _requestRepository.CustomerConfigurationsList.Add(config);
                    return bool.Parse(config.KeyValue.Trim());
                }
            }
            return AllowRetailTaxOnItems;
        }
        public bool AllowAutoApproveOrderForCustomer(int customerId, int outletId)
        {
            var config = _requestRepository.CustomerConfigurationsList.Find(a => a.KeyName.ToLower() == "AutoApproveOrder".ToLower());
            if (config != null && !string.IsNullOrEmpty(config.KeyValue))
            {
                return bool.Parse(config.KeyValue.Trim());
            }
            else
            {
                config = GetCustomerConfigurationValue(customerId, outletId, "AutoApproveOrder");
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    _requestRepository.CustomerConfigurationsList.Add(config);
                    return bool.Parse(config.KeyValue.Trim());
                }
                else
                {
                    return GetBooleanValue("AutoApproveOrder");
                }
            }
            return AutoApproveOrder;
        }
        public bool AllowAutoDispatchOrderForCustomer(int customerId, int outletId)
        {
            var config = _requestRepository.CustomerConfigurationsList.Find(a => a.KeyName.ToLower() == "AutoDispatchOrder".ToLower());
            if (config != null && !string.IsNullOrEmpty(config.KeyValue))
            {
                return bool.Parse(config.KeyValue.Trim());
            }
            else
            {
                config = GetCustomerConfigurationValue(customerId, outletId, "AutoDispatchOrder");
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    _requestRepository.CustomerConfigurationsList.Add(config);
                    return bool.Parse(config.KeyValue.Trim());
                }
                else
                {
                    return GetBooleanValue("AutoDispatchOrder");
                }
            }
            return AutoDispatchOrder;
        }
        private ConfigurationModel GetCustomerConfigurationValue(int customerId, int outletId, string keyName)
        {
            ConfigurationModel configuration = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();

                configuration = new ConfigurationModel();
                string query = $@"select * from (
                select tt.ConfigurationID, tt.CustomerID, tt.OutletID, tt.KeyValue,tt.KeyName,
                row_number ( )  OVER (PARTITION BY tt.customerid,tt.outletid ORDER BY tt.Priority ASC) AS rowNumber from
                 ( 
                select CCO.ConfigurationID,  CCO.CustomerID ,CCO.OutletID , CCO.KeyValue, CCO.KeyName,1 Priority
                from ConfigurationCustOut CCO
                INNER JOIN Customer C on C.CustomerID = CCO.CustomerID
                INNER JOIN CustomerOutlet CO on CO.CustomerID = CCO.CustomerID AND CO.OutletID = CCO.OutletID
                WHERE KeyName = ('{keyName}')  
                UNION
                select ConfigurationID,COG.CustomerID, COG.OutletID ,KeyValue, CCG.KeyName,2 Priority
                from ConfigurationCustomerGroup CCG
                INNER JOIN CustomerGroup CG on CG.GroupID = CCG.GroupID
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CCG.GroupID
                WHERE KeyName = ('{keyName}') 
                UNION
                select 
                CC.ConfigurationID, COG.CustomerID, COG.OutletID ,CC.KeyValue, CC.KeyName,3 Priority 
                from ConfigurationChannel CC
                INNER JOIN Channel C on CC.ChannelID = C.ChannelID
                INNER JOIN SubChannel SC on (SC.ChannelID = C.ChannelID AND CC.SubChannelID = SC.SubChannelID AND CC.SubChannelID <> -1 )
                INNER JOIN CustomerGroup CG on CG.SubChannelID = SC.SubChannelID and CG.ChannelID = C.ChannelID 
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CG.GroupID
                WHERE KeyName = ('{keyName}') 
                UNION
                select 
                CC.ConfigurationID, COG.CustomerID, COG.OutletID ,CC.KeyValue, CC.KeyName,4 Priority 
                from ConfigurationChannel CC
                INNER JOIN Channel C on CC.ChannelID = C.ChannelID
                INNER JOIN SubChannel SC on SC.ChannelID = C.ChannelID AND ISNULL(CC.SubChannelID,-1) = -1
                INNER JOIN CustomerGroup CG on CG.SubChannelID = SC.SubChannelID and CG.ChannelID = C.ChannelID 
                INNER JOIN CustomerOutletGroup COG on COG.GroupID = CG.GroupID
                WHERE KeyName = ('{keyName}') 
                ) as tt ) customerLevel where customerLevel.rowNumber = 1 and CustomerId = {customerId} and outletId = {outletId}";
                var result = dbHelper.GetQuerySingle(query, ref configuration);

                return configuration;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }

        #region [Get Values]

        private bool GetBooleanValue(string keyName)
        {
            bool result = false;
            try
            {
                var config = _requestRepository.ConfigurationsList.Find(a => a.KeyName == keyName);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = bool.Parse(config.KeyValue.Trim());
                }
                else
                {
                    config = GetConfigurationValue(keyName);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        _requestRepository.ConfigurationsList.Add(config);
                        result = bool.Parse(config.KeyValue.Trim());
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Configuration Key Name : ", null, keyName, 0);
            }
            return result;
        }

        private int GetIntegerValue(string keyName)
        {
            int result = 0;
            try
            {
                var config = _requestRepository.ConfigurationsList.Find(a => a.KeyName == keyName);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = int.Parse(config.KeyValue.Trim());
                }
                else
                {
                    config = GetConfigurationValue(keyName);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        _requestRepository.ConfigurationsList.Add(config);
                        result = int.Parse(config.KeyValue.Trim());
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        private decimal GetDecimalValue(string keyName)
        {
            decimal result = 0;
            try
            {
                var config = _requestRepository.ConfigurationsList.Find(a => a.KeyName == keyName);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = decimal.Parse(config.KeyValue.Trim());
                }
                else
                {
                    config = GetConfigurationValue(keyName);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        _requestRepository.ConfigurationsList.Add(config);
                        result = decimal.Parse(config.KeyValue.Trim());
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private decimal GetDecimalValueBasedOnOrginization(string keyName)
        {
            decimal result = 0;
            try
            {
                var config = _requestRepository.ConfigurationsList.Find(a => a.KeyName == keyName);

                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = decimal.Parse(config.KeyValue.Trim());
                }
                else
                {
                    config = GetConfigurationValueBasedOnOrginization(keyName);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        _requestRepository.ConfigurationsList.Add(config);
                        result = decimal.Parse(config.KeyValue.Trim());
                    }

                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private string GetStringValue(string keyName)
        {
            string result = string.Empty;
            try
            {
                var config = _requestRepository.ConfigurationsList.Find(a => a.KeyName == keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = config.KeyValue.Trim();
                }
                else
                {
                    config = GetConfigurationValue(keyName);
                    if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                    {
                        _requestRepository.ConfigurationsList.Add(config);
                        result = config.KeyValue.Trim();
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private bool GetBooleanValue(string keyName, int employeeId)
        {
            bool result = false;
            try
            {

                var config = GetConfigurationValue(employeeId, keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {

                    result = bool.Parse(config.KeyValue.Trim());
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private int GetIntegerValue(string keyName, int employeeId)
        {
            int result = 0;
            try
            {

                var config = GetConfigurationValue(employeeId, keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {

                    result = int.Parse(config.KeyValue.Trim());
                }


            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }

        private string GetStringValue(string keyName, int employeeId)
        {
            string result = string.Empty;
            try
            {

                var config = GetConfigurationValue(employeeId, keyName);
                if (config != null && !string.IsNullOrEmpty(config.KeyValue))
                {
                    result = config.KeyValue.Trim();
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
            return result;
        }
        #endregion [Get Values]

        #region [Properties]
        public bool AllowSalesModeSelectionInOrder
        {
            get
            {
                return GetBooleanValue("AllowSalesModeSelectionInOrder");
            }
        }
        public string AllowSalesModeSelectionForCashCustomers
        {
            get
            {
                return GetStringValue("AllowSalesModeSelectionForCashCustomers");
            }
        }
        public bool AllowSalesModeSelection
        {
            get
            {
                return GetBooleanValue("AllowSalesModeSelection");
            }
        }
        public bool ApplyPriorityOnPromotionGroups
        {
            get
            {
                return GetBooleanValue("ApplyPriorityOnPromotionGroups");
            }
        }
        public bool ExcludeItemFromNextPromotion
        {
            get
            {
                return GetBooleanValue("ExcludeItemFromNextPromotion");
            }
        }
        public bool AutoGenerateInvoiceOnOrderPreparation
        {
            get
            {
                return GetBooleanValue("AutoGenerateInvoiceOnOrderPreparation");
            }
        }
        public bool IncludeReturnsInAchievements
        {
            get
            {
                return GetBooleanValue("IncludeReturnsInAchievements");
            }
        }
        public bool IncludeTaxInProductDiscount
        {
            get
            {
                return GetBooleanValue("IncludeTaxInProductDiscount");
            }
        }
        public bool IncludeTaxInPrice
        {
            get
            {
                return GetBooleanValue("IncludeTaxInPrice");
            }
        }
        public bool ShowIncludedTaxAmount
        {
            get
            {
                return GetBooleanValue("ShowIncludedTaxAmount");
            }
        }
        public bool UseSerialsForMultiplePackItems
        {
            get
            {
                return GetBooleanValue("UseSerialsForMultiplePackItems");
            }
        }
        public int BatchesListCalculationMode
        {
            get
            {
                return GetIntegerValue("BatchesListCalculationMode");
            }
        }
        public int BatchesListCalculationLimit
        {
            get
            {
                return GetIntegerValue("BatchesListCalculationLimit");
            }
        }
        public bool ForceAcceptInLoadRequest
        {
            get
            {
                return GetBooleanValue("ForceAcceptInLoadRequest");
            }
        }
        public bool IncludeFreeItemsInReturnFromInvoices
        {
            get
            {
                return GetBooleanValue("IncludeFreeItemsInReturnFromInvoices");
            }
        }
        public bool RecalculateBenefitOnReturn
        {
            get
            {
                return GetBooleanValue("RecalculateBenefitOnReturn");
            }
        }
        public bool LinkETransactionsWithReturns
        {
            get
            {
                return GetBooleanValue("LinkETransactionsWithReturns");
            }
        }
        public bool ForceSendTransactionToZATCA
        {
            get
            {
                return GetBooleanValue("ForceSendTransactionToZATCA");
            }
        }
        public bool AllowPartialDeliveryInProcessReturn
        {
            get
            {
                return GetBooleanValue("AllowPartialDeliveryInProcessReturn");
            }
        }
        public bool ForceReturnWithSoldPrice
        {
            get
            {
                return GetBooleanValue("ForceReturnWithSoldPrice");
            }
        }
        public bool CalculateRetailTaxBasedOnGeneralPriceList
        {
            get
            {
                return GetBooleanValue("CalculateRetailTaxBasedOnGeneralPriceList");
            }
        }
        public bool RestrictReturnFromInvoices
        {
            get
            {
                return GetBooleanValue("RestrictReturnFromInvoices");
            }
        }
        public bool RestrictReturnQtyFromInvoices
        {
            get
            {
                return GetBooleanValue("RestrictReturnQtyFromInvoices");
            }
        }
        public bool ForceChangeOperatorPasswordAtFirstLogin
        {
            get
            {
                return GetBooleanValue("ForceChangeOperatorPasswordAtFirstLogin");
            }
        }
        public int PasswordExpiryDays
        {
            get
            {
                return GetIntegerValue("PasswordExpiryDays");
            }
        }
        public int NumberOfFailedLogin
        {
            get
            {
                return GetIntegerValue("NumberOfFailedLogin");
            }
        }
        public int PromotionSequenceLevels
        {
            get
            {
                return GetIntegerValue("PromotionSequenceLevels");
            }
        }
        public bool ApplyGS1TrackAndTraceTemplate
        {
            get
            {
                return GetBooleanValue("ApplyGS1TrackAndTraceTemplate");
            }
        }
        public bool AutoAssignReturnOrder
        {
            get
            {
                return GetBooleanValue("AutoAssignReturnOrder");
            }
        }
        public bool AllowDispatchAnyOrderToDriver
        {
            get
            {
                return GetBooleanValue("AllowDispatchAnyOrderToDriver");
            }
        }
        public bool SplitOrderAutomatically
        {
            get
            {
                return GetBooleanValue("SplitOrderAutomatically");
            }
        }
        public bool ShowPrivacyPolicy
        {
            get
            {
                return GetBooleanValue("ShowPrivacyPolicy");
            }
        }
        public bool hasSupervisorApp
        {
            get
            {
                return GetBooleanValue("hasSupervisorApp");
            }
        }
        public bool EnableGeneratingSSCC
        {
            get
            {
                return GetBooleanValue("EnableGeneratingSSCC");
            }
        }
        public bool BlockEditSalesItemRestriction
        {
            get
            {
                return GetBooleanValue("BlockEditSalesItemRestriction");
            }
        }
        public bool ManageContractedFOCPlan
        {
            get
            {
                return GetBooleanValue("ManageContractedFOCPlan");
            }
        }

        public string SerialTemplateDateFormat
        {
            get
            {
                return GetStringValue("SerialTemplateDateFormat");
            }
        }
        public string SiteSymbol
        {
            get
            {
                return GetStringValue("SiteSymbol");
            }
        }
        public string DateFormat
        {
            get
            {
                return GetStringValue("DateFormat");
            }
        }
        public bool AllowEditItemInTransfer
        {
            get
            {
                return GetBooleanValue("AllowEditItemInTransfer");
            }
        }
        public string LimitItemsToMainWarehouseStock
        {
            get
            {
                return GetStringValue("LimitItemsToMainWarehouseStock");
            }
        }

        public int CreditNoteTaxType
        {
            get
            {
                return GetIntegerValue("CreditNoteTaxType");
            }
        }
        public decimal DefaultTaxValueForCreditNote
        {
            get
            {
                return GetDecimalValue("DefaultTaxValueForCreditNote");
            }
        }

        public bool ForceSingleSerials
        {
            get
            {
                return GetBooleanValue("ForceSingleSerials");
            }
        }
        public string OrdersToBeApprovedInFO
        {
            get
            {
                return GetStringValue("OrdersToBeApprovedInFO");
            }
        }
        public string ApplyApprovalCycleInWeb
        {
            get
            {
                return GetStringValue("ApplyApprovalCycleInWeb");
            }
        }
        public bool ApplyCurrencyPerOrganization
        {
            get
            {
                return GetBooleanValue("ApplyCurrencyPerOrganization");
            }
        }
        public bool ApplyTerritoryForContractedFOC
        {
            get
            {
                return GetBooleanValue("ApplyTerritoryForContractedFOC");
            }
        }
        public bool ForcePreviousLevelApproval
        {
            get
            {
                return GetBooleanValue("ForcePreviousLevelApproval");
            }
        }
        public bool ApplyTaxTypesInPrices
        {
            get
            {
                return GetBooleanValue("ApplyTaxTypesInPrices");
            }
        }

        public int RouteVisitStartDay
        {
            get
            {
                return GetIntegerValue("RouteVisitStartDay");
            }
        }
        public string SaleRestrictionCalculationMode
        {
            get
            {
                return GetStringValue("SaleRestrictionCalculationMode");
            }
        }
        public int DefaultRetailPriceListID
        {
            get
            {
                return GetIntegerValue("DefaultRetailPriceListID");
            }
        }
        public bool ConsiderCurrentPromotionsInDelivery
        {
            get
            {
                return GetBooleanValue("ConsiderCurrentPromotionsInDelivery");
            }
        }
        public bool CreateComplementaryOrder
        {
            get
            {
                return GetBooleanValue("CreateComplementaryOrder");
            }
        }
        public string DeliveryMode
        {
            get
            {
                return GetStringValue("DeliveryMode");
            }
        }
        public bool ApplyKeyForSaleOnHold
        {
            get
            {
                return GetBooleanValue("ApplyKeyForSaleOnHold");
            }
        }
        public bool ForceOrganizationFilterForPackGroups
        {
            get
            {
                return GetBooleanValue("ForceOrganizationFilterForPackGroups");
            }
        }
        public bool ForceStockPosting
        {
            get
            {
                return GetBooleanValue("ForceStockPosting");
            }
        }
        public bool ApproveCustomerAppOrdersInFO
        {
            get
            {
                return GetBooleanValue("ApproveCustomerAppOrdersInFO");
            }
        }
        public bool AllowPDCInDownPayment
        {
            get
            {
                return GetBooleanValue("AllowPDCInDownPayment");
            }
        }

        public bool CreateCreditNoteOnDownPayment
        {
            get
            {
                return GetBooleanValue("CreateCreditNoteOnDownPayment");
            }
        }

        public bool AutoExecuteOffloadRequestInBO
        {
            get
            {
                return GetBooleanValue("AutoExecuteOffloadRequestInBO");
            }
        }

        public bool CheckCustomerUniquenessEntry
        {
            get
            {
                return GetBooleanValue("CheckCustomerUniquenessEntry");
            }
        }

        public bool ForceCustomerBarcodeChecking
        {
            get
            {
                return GetBooleanValue("ForceCustomerBarcodeChecking");
            }
        }

        public bool ForceOrganizationSelectionOnLogin
        {
            get
            {
                if (LocalUtilities.IsSonic)
                {
                    return GetBooleanValue("ForceOrganizationSelectionOnLogin");
                }
                else
                {
                    return false;
                }
            }
        }

        public bool GetDivisionsUnderOrganizationAccess
        {
            get
            {
                return GetBooleanValue("GetDivisionsUnderOrganizationAccess");
            }
        }

        public bool AllowTripGeneration
        {
            get
            {
                return GetBooleanValue("AllowTripGeneration");
            }
        }

        public bool LimitBOSalesToWarehouseStock
        {
            get
            {
                return GetBooleanValue("LimitBOSalesToWarehouseStock");
            }
        }
        public bool RestoreBOReturnToWarehouse
        {
            get
            {
                return GetBooleanValue("RestoreBOReturnToWarehouse");
            }
        }

        public bool AcceptPDCPaymentOnReceipt
        {
            get
            {
                return GetBooleanValue("AcceptPDCPaymentOnReceipt");
            }
        }
        public bool CheckConsumerPrice
        {
            get
            {
                return GetBooleanValue("CheckConsumerPrice");
            }
        }
        public bool CheckCostPrice
        {
            get
            {
                return GetBooleanValue("CheckCostPrice");
            }
        }
        public int ConsumerPriceListID
        {
            get
            {
                return GetIntegerValue("ConsumerPriceListID");
            }
        }
        public int TransactionIDModeInBOTransactions
        {
            get
            {
                return GetIntegerValue("TransactionIDModeInBOTransactions");
            }
        }
        public bool EnableCustomerAppPoints
        {
            get
            {
                return GetBooleanValue("EnableCustomerAppPoints");
            }
        }

        public bool AllowCustomerAppLogin
        {
            get
            {
                return GetBooleanValue("AllowCustomerAppLogin");
            }
        }
        public bool AllowSameOperatorForMultiCustomer
        {
            get
            {
                return GetBooleanValue("AllowSameOperatorForMultiCustomer");
            }
        }
        public int CustomerAppCancellationPeriod
        {
            get
            {
                return GetIntegerValue("CustomerAppCancellationPeriod");
            }
        }

        public bool AffectMainWarehouseUponOrderBOInvoicing
        {
            get
            {
                return GetBooleanValue("AffectMainWarehouseUponOrderBOInvoicing");
            }
        }

        public bool AllowBatchSelectionInSales
        {
            get
            {
                return GetBooleanValue("AllowBatchSelectionInSales");
            }
        }

        public bool AllowBatchSelectionInWarehouseOperations
        {
            get
            {
                return GetBooleanValue("AllowBatchSelectionInWarehouseOperations");
            }
        }
        public bool AllowReAssignInovicedOrders
        {
            get
            {
                return GetBooleanValue("AllowReAssignInovicedOrders");
            }
        }
        public bool DeductPendingOrdersFromAvailableCredit
        {
            get
            {
                return GetBooleanValue("DeductPendingOrdersFromAvailableCredit");
            }
        }
        public bool AllowBatchSelectionInDelivery
        {
            get
            {
                return GetBooleanValue("AllowBatchSelectionInDelivery");
            }
        }
        public bool AllowWarehouseSelectionInPendingOrders
        {
            get
            {
                return GetBooleanValue("AllowWarehouseSelectionInPendingOrders");
            }
        }
        public bool AllowConversionInPromotion
        {
            get
            {
                return GetBooleanValue("AllowConversionInPromotion");
            }
        }

        public bool AllowDeliveryToCustomerExceedsLimit
        {
            get
            {
                return GetBooleanValue("AllowDeliveryToCustomerExceedsLimit");
            }
        }

        public bool AllowGivingCreditNoteOnReturn
        {
            get
            {
                return GetBooleanValue("AllowGivingCreditNoteOnReturn");
            }
        }

        public bool IncludeExciseTaxInDiscount
        {
            get
            {
                return GetBooleanValue("IncludeExciseTaxInDiscount");
            }
        }
        public bool AllowRetailTaxOnItems
        {
            get
            {
                return GetBooleanValue("AllowRetailTaxOnItems");
            }
        }

        public bool AllowSellCustomerExceedsLimit
        {
            get
            {
                return GetBooleanValue("AllowSellCustomerExceedsLimit");
            }
        }
        public bool AllowSellExpiredItems
        {
            get
            {
                return GetBooleanValue("AllowSellExpiredItems");
            }
        }

        public bool AllowSellReturns
        {
            get
            {
                return GetBooleanValue("AllowSellReturns");
            }
        }
        public bool RestoreNonSellableReturns
        {
            get
            {
                return GetBooleanValue("RestoreNonSellableReturns");
            }
        }

        public bool AllowTax
        {
            get
            {
                return GetBooleanValue("AllowTax");
            }
        }

        public bool AllowTaxOverFreeItems
        {
            get
            {
                return GetBooleanValue("AllowTaxOverFreeItems");
            }
        }

        public bool AllowTerritoryCustomerVisit
        {
            get
            {
                return GetBooleanValue("AllowTerritoryCustomerVisit");
            }
        }

        public bool ApplyAmountDiscountPerQuantity
        {
            get
            {
                return GetBooleanValue("ApplyAmountDiscountPerQuantity");
            }
        }

        public bool ApplyDivisionsOnDocumentSequence
        {
            get
            {
                return GetBooleanValue("ApplyDivisionsOnDocumentSequence");
            }
        }
        public bool ValidateExpiryDateOnYearAndMonthOnly
        {
            get
            {
                return GetBooleanValue("ValidateExpiryDateOnYearAndMonthOnly");
            }
        }

        public bool ApplyKeyTypesPrivileges
        {
            get
            {
                return GetBooleanValue("ApplyKeyTypesPrivileges");
            }
        }

        public bool ApplyPasswordForSpecialActions
        {
            get
            {
                return GetBooleanValue("ApplyPasswordForSpecialActions");
            }
        }

        public bool ApplyRoundingOnCalculations
        {
            get
            {
                return GetBooleanValue("ApplyRoundingOnCalculations");
            }
        }
        public bool ApplyZATCARoundingRules
        {
            get
            {
                return GetBooleanValue("ApplyZATCARoundingRules");
            }
        }

        public bool AutoApproveLoadOrders
        {
            get
            {
                return GetBooleanValue("AutoApproveLoadOrders");
            }
        }

        public bool AutoApprovePayment
        {
            get
            {
                return GetBooleanValue("AutoApprovePayment");
            }
        }

        public bool AutoExecuteLoadRequestInBO
        {
            get
            {
                return GetBooleanValue("AutoExecuteLoadRequestInBO");
            }
        }
        public bool ExecuteWarehouseTransactionsByStoreKeeperModule
        {
            get
            {
                return GetBooleanValue("ExecuteWarehouseTransactionsByStoreKeeperModule");
            }
        }
        public bool ExecuteOffLoadRequestByStoreKeeperModule
        {
            get
            {
                return GetBooleanValue("ExecuteOffLoadRequestByStoreKeeperModule");
            }
        }
        public bool BOInvoicing
        {
            get
            {
                return GetBooleanValue("BOInvoicing");
            }
        }

        public bool CalculateTaxBeforeDiscounts
        {
            get
            {
                return GetBooleanValue("CalculateTaxBeforeDiscounts");
            }
        }

        public bool CheckCreditLimitOnEmployeeDivisionAccount
        {
            get
            {
                return GetBooleanValue("CheckCreditLimitOnEmployeeDivisionAccount");
            }
        }

        public bool CheckCreditLimitOnOrders
        {
            get
            {
                return GetBooleanValue("CheckCreditLimitOnOrders");
            }
        }
        public bool AllowEditTransDateInWarehouseOperations
        {
            get
            {
                return GetBooleanValue("AllowEditTransDateInWarehouseOperations");
            }
        }
        public bool CheckEmployeeCustomersInOrders
        {
            get
            {
                return GetBooleanValue("CheckEmployeeCustomersInOrders");
            }
        }

        public bool CheckMainWHStockForLoad
        {
            get
            {
                return GetBooleanValue("CheckMainWHStockForLoad");
            }
        }

        public bool CheckPaymentTermsOnOrders
        {
            get
            {
                return GetBooleanValue("CheckPaymentTermsOnOrders");
            }
        }

        public bool CheckPaymentTermsOnOrdersOnAllDivision
        {
            get
            {
                return GetBooleanValue("CheckPaymentTermsOnOrdersOnAllDivision");
            }
        }

        public bool CheckPaymentTermViolation
        {
            get
            {
                return GetBooleanValue("CheckPaymentTermViolation");
            }
        }

        public bool CheckPaymentTermViolationOnDelivery
        {
            get
            {
                return GetBooleanValue("CheckPaymentTermViolationOnDelivery");
            }
        }

        public int ChequeBounceMode
        {
            get
            {
                return GetIntegerValue("ChequeBounceMode");
            }
        }

        public bool CloseCashCustomerOrderInvoice
        {
            get
            {
                return GetBooleanValue("CloseCashCustomerOrderInvoice");
            }
        }

        public bool ControlMainWarehouseByEmpOrgAccess
        {
            get
            {
                return GetBooleanValue("ControlMainWarehouseByEmpOrgAccess");
            }
        }
        public bool MatchNewGPSInformation
        {
            get
            {
                return GetBooleanValue("MatchNewGPSInformation");
            }
        }
        public bool ControlTransactionOnDivisionLevel
        {
            get
            {
                return GetBooleanValue("ControlTransactionOnDivisionLevel");
            }
        }
        public bool AllowPaymentTermCheckOverAllDivisions
        {
            get
            {
                return GetBooleanValue("AllowPaymentTermCheckOverAllDivisions");
            }
        }
        public bool UseSourceTransactionIDAsInvoiceName
        {
            get
            {
                return GetBooleanValue("UseSourceTransactionIDAsInvoiceName");
            }
        }

        public int CustomerInformationMode
        {
            get
            {
                return GetIntegerValue("CustomerInformationMode");
            }
        }
        public int ProductDiscountCalculationMode
        {
            get
            {
                return GetIntegerValue("ProductDiscountCalculationMode");
            }
        }

        public int DefaultDeliveryPeriodIndays
        {
            get
            {
                return GetIntegerValue("DefaultDeliveryPeriodIndays");
            }
        }

        public int DefaultPriceListID
        {
            get
            {
                return GetIntegerValue("DefaultPriceListID");
            }
        }

        public bool DefinePaymentTermForCashCustomer
        {
            get
            {
                return GetBooleanValue("DefinePaymentTermForCashCustomer");
            }
        }

        public bool DeliverOrdersUsingInvan
        {
            get
            {
                return GetBooleanValue("DeliverOrdersUsingInvan");
            }
        }

        public bool EnableEmployeeApprovalCycle
        {
            get
            {
                return GetBooleanValue("EnableEmployeeApprovalCycle");
            }
        }

        public bool ForceCustomerOrganizationSelection
        {
            get
            {
                return GetBooleanValue("ForceCustomerOrganizationSelection");
            }
        }

        public bool CustomerSelectionInOfflineMode
        {
            get
            {
                return GetBooleanValue("CustomerSelectionInOfflineMode");
            }
        }

        public bool ForceCustomerOrganizationAccess
        {
            get
            {
                return GetBooleanValue("ForceCustomerOrganizationAccess");
            }
        }

        public bool ForceLoadRequestForOrders
        {
            get
            {
                return GetBooleanValue("ForceLoadRequestForOrders");
            }
        }

        public bool ForcePaymentOnDiscrepancyInvoice
        {
            get
            {
                return GetBooleanValue("ForcePaymentOnDiscrepancyInvoice");
            }
        }

        public bool LinkItemsToWarehouse
        {
            get
            {
                return GetBooleanValue("LinkItemsToWarehouse");
            }
        }

        public bool enableSelectEmployeeForOrderInBO
        {
            get
            {
                return GetBooleanValue("enableSelectEmployeeForOrderInBO");
            }
        }

        public int NumberOfDigits
        {
            get
            {
                return GetIntegerValue("NumberOfDigits");
            }
        }

        public int NumberOfStockDigits
        {
            get
            {
                return GetIntegerValue("NumberOfStockDigits");
            }
        }

        public int NumberOfWarehouseChecks
        {
            get
            {
                return GetIntegerValue("NumberOfWarehouseChecks");
            }
        }

        public int NumberOfWarehouseChecksInCheckIn
        {
            get
            {
                return GetIntegerValue("NumberOfWarehouseChecksInCheckIn");
            }
        }

        public bool PostPDCAutomatically
        {
            get
            {
                return GetBooleanValue("PostPDCAutomatically");
            }
        }

        public bool ShowDivisionSelectionOnWHTransaction
        {
            get
            {
                return GetBooleanValue("ShowDivisionSelectionOnWHTransaction");
            }
        }
        public bool AllowSelectWarehouseInPO
        {
            get
            {
                return GetBooleanValue("AllowSelectWarehouseInPO");
            }
        }
        public bool UpdateEmployeeBalanceOnCreditSale
        {
            get
            {
                return GetBooleanValue("UpdateEmployeeBalanceOnCreditSale");
            }
        }
        public bool UpdateEmployeeBalanceOnCreditSaleForCashCustomerOnly
        {
            get
            {
                return GetBooleanValue("UpdateEmployeeBalanceOnCreditSaleForCashCustomerOnly");
            }
        }

        public bool UseCustomerLevelAccount
        {
            get
            {
                return GetBooleanValue("UseCustomerLevelAccount");
            }
        }

        public bool UseDefaultExpiryAndBatchForItems
        {
            get
            {
                return GetBooleanValue("UseDefaultExpiryAndBatchForItems");
            }
        }
        public bool EnableSplitOrder
        {
            get
            {
                return GetBooleanValue("EnableSplitOrder");
            }
        }
        public bool AllowInvoiceOrderBeforeAssignOrder
        {
            get
            {
                return GetBooleanValue("AllowInvoiceOrderBeforeAssignOrder");
            }
        }
        public bool EnableOrderPreparationCycle
        {
            get
            {
                return GetBooleanValue("EnableOrderPreparationCycle");
            }
        }

        public bool UseKeyForTargetedCustomerOnly
        {
            get
            {
                return GetBooleanValue("UseKeyForTargetedCustomerOnly");
            }
        }

        public bool ReleaseAllVehicleBoxesOnVerification
        {
            get
            {
                return GetBooleanValue("ReleaseAllVehicleBoxesOnVerification");
            }
        }

        public bool AllowPromotion
        {
            get
            {
                return GetBooleanValue("AllowPromotion");
            }
        }
        public bool RecalculatePromotionInDelivery
        {
            get
            {
                return GetBooleanValue("RecalculatePromotionInDelivery");
            }
        }

        public int InvoiceValueConsideredInPromotionPrerequisites
        {
            get
            {
                return GetIntegerValue("InvoiceValueConsideredInPromotionPrerequisites");
            }
        }

        public int InvoiceValueConsideredInPromotionBenefits
        {
            get
            {
                return GetIntegerValue("InvoiceValueConsideredInPromotionBenefits");
            }
        }

        public int SerialTrimStartLength
        {
            get
            {
                return GetIntegerValue("SerialTrimStartLength");
            }
        }
        public int SerialTrimEndLength
        {
            get
            {
                return GetIntegerValue("SerialTrimEndLength");
            }
        }


        public int PromotionCalculationSequence
        {
            get
            {
                return GetIntegerValue("PromotionCalculationSequence");
            }
        }

        public bool AffectVanStockInDeliveryInFO
        {
            get
            {
                return GetBooleanValue("AffectVanStockInDeliveryInFO");
            }
        }

        public bool AllowRemoveAssignmentForAcceptedLoadRequest
        {
            get
            {
                return GetBooleanValue("AllowRemoveAssignmentForAcceptedLoadRequest");
            }
        }

        public bool AutoDispatchOrder
        {
            get
            {
                return GetBooleanValue("AutoDispatchOrder");
            }
        }

        public bool ForceStockCheckingBeforeApprovingOrder
        {
            get
            {
                return GetBooleanValue("ForceStockCheckingBeforeApprovingOrder");
            }
        }

        public bool AutoApproveOrder
        {
            get
            {
                return GetBooleanValue("AutoApproveOrder");
            }
        }
        public bool AutoApproveNewCustomer
        {
            get
            {
                return GetBooleanValue("AutoApproveNewCustomer");
            }
        }



        public decimal PointsWeight
        {
            get
            {
                return 1;// GetDecimalValue("PointsWeight");
            }
        }

        public string WebVersion
        {
            get
            {
                return GetStringValue("WebVersion");
            }
        }
        public string CheckAvailableCreditToLoad
        {
            get
            {
                return GetStringValue("CheckAvailableCreditToLoad");
            }
        }
        public bool LinkVehicleToAccount
        {
            get
            {
                return GetBooleanValue("LinkVehicleToAccount");
            }
        }
        public string AllowLoadOverAvailableCredit
        {
            get
            {
                return GetStringValue("AllowLoadOverAvailableCredit");
            }
        }
        public string CategoryBrandCustomerAppMode
        {
            get
            {
                return GetStringValue("CategoryBrandCustomerAppMode");
            }
        }

        public string PaymentTypesForCreditCustomer
        {
            get
            {
                return GetStringValue("PaymentTypesForCreditCustomer");
            }
        }
        public string PaymentTypesForCashCustomer
        {
            get
            {
                return GetStringValue("PaymentTypesForCashCustomer");
            }
        }
        public bool AllowPayingExtraAtCollection
        {
            get
            {
                return GetBooleanValue("AllowPayingExtraAtCollection");
            }
        }

        public bool AutoCollectBOInvoices
        {
            get
            {
                return GetBooleanValue("AutoCollectBOInvoices");
            }
        }

        public decimal EchoFirstDiscountCustomerOutlet
        {
            get
            {
                return GetDecimalValueBasedOnOrginization("EchoFirstDiscountCustomerOutlet");
            }
        }
        public bool AllowFOC
        {
            get
            {
                return GetBooleanValue("AllowFOC");
            }
        }
        public bool CheckFOCLimit
        {
            get
            {
                return GetBooleanValue("CheckFOCLimit");
            }
        }
        public int CountOfAllowedReturns
        {
            get
            {
                return GetIntegerValue("CountOfAllowedReturns");
            }
        }
        public int ReportMargin
        {
            get
            {
                return GetIntegerValue("ReportMargin");
            }
        }

        public int ForecastingCalculationPeriod
        {
            get
            {
                return GetIntegerValue("ForecastingCalculationPeriod");
            }
        }
        public bool IncludeReturnsInForecasting
        {
            get
            {
                return GetBooleanValue("IncludeReturnsInForecasting");
            }
        }
        public bool SendLoadRequestAutomaticlly
        {
            get
            {
                return GetBooleanValue("SendLoadRequestAutomaticlly");
            }
        }

        public bool SendOffloadRequestAutomaticlly
        {
            get
            {
                return GetBooleanValue("SendOffloadRequestAutomaticlly");
            }
        }
        public bool SendSalesOrdersAutomatically
        {
            get
            {
                return GetBooleanValue("SendSalesOrdersAutomatically");
            }
        }
        public bool ForceOrganizationFilterForCustomerGroups
        {
            get
            {
                return GetBooleanValue("ForceOrganizationFilterForCustomerGroups");
            }
        }
        public int GeographicalLocationHierarchyLevel
        {
            get
            {
                return GetIntegerValue("GeographicalLocationHierarchyLevel");
            }
        }
        public bool ExcludePDCFromPaymentViolation
        {
            get
            {
                return GetBooleanValue("ExcludePDCFromPaymentViolation");
            }
        }
        public bool GiveCreditOnReturnForCashCustomers
        {
            get
            {
                return GetBooleanValue("GiveCreditOnReturnForCashCustomers");
            }
        }
        public bool GiveCreditOnReturnForCreditCustomers
        {
            get
            {
                return GetBooleanValue("GiveCreditOnReturnForCreditCustomers");
            }
        }
        public bool GivePartialCreditForCashCustomer
        {
            get
            {
                return GetBooleanValue("GivePartialCreditForCashCustomer");
            }
        }
        public bool GivePartialCreditForCreditCustomer
        {
            get
            {
                return GetBooleanValue("GivePartialCreditForCreditCustomer");
            }
        }
        public bool AllowVoidCouponWithKey
        {
            get
            {
                return GetBooleanValue("AllowVoidCouponWithKey ");
            }
        }
        public bool AllowVoidRedemptionWithKey
        {
            get
            {
                return GetBooleanValue("AllowVoidRedemptionWithKey  ");
            }
        }
        public bool ForceEqualityInPromotionPackGroup
        {
            get
            {
                return GetBooleanValue("ForceEqualityInPromotionPackGroup");
            }
        }
        public int EmailPhrasesLanguage
        {
            get
            {
                return GetIntegerValue("EmailPhrasesLanguage");
            }
        }
        public int NumberOfDaysToSendingTransactionsEmail
        {
            get
            {
                return GetIntegerValue("NumberOfDaysToSendingTransactionsEmail");
            }
        }
        public bool UseZatcaQRCode
        {
            get
            {
                return GetBooleanValue("UseZatcaQRCode");
            }
        }
        public bool CheckPaymentTermOnCustomerLevel
        {
            get
            {
                return GetBooleanValue("CheckPaymentTermOnCustomerLevel");
            }
        }
        public bool AllowEditPriceOnReturn
        {
            get
            {
                return GetBooleanValue("AllowEditPriceOnReturn");
            }
        }
        public bool UseReturnPriceListForReturns
        {
            get
            {
                return GetBooleanValue("UseReturnPriceListForReturns");
            }
        }
        public bool AggregateOrdersToOneLoadRequest
        {
            get
            {
                return GetBooleanValue("AggregateOrdersToOneLoadRequest");
            }
        }
        public string WeekendDays
        {
            get
            {
                return GetStringValue("WeekendDays");
            }
        }
        public int ExcelSheetDateFormat
        {
            get
            {
                return GetIntegerValue("ExcelSheetDateFormat");
            }
        }
        public string CompanyName
        {
            get
            {
                return GetStringValue("CompanyName");
            }
        }
        public string EPaymentTerminal
        {
            get
            {
                return GetStringValue("E-PaymentTerminal");
            }
        }
        public string EPaymentStore
        {
            get
            {
                return GetStringValue("E-PaymentStore");
            }
        }
        public int OnlineEPaymentExpiryDateLimit
        {
            get
            {
                return GetIntegerValue("OnlineEPaymentExpiryDateLimit");
            }
        }
        public int EPaymentCheckStatusLimit
        {
            get
            {
                return GetIntegerValue("EPaymentCheckStatusLimit");
            }
        }
        public string MerchantMessage
        {
            get
            {
                return GetStringValue("MerchantMessage");
            }
        }
        public string PaymentGateWayUserName
        {
            get
            {
                return GetStringValue("PaymentGateWayUserName");
            }
        }
        public string PaymentGateWayPassword
        {
            get
            {
                return GetStringValue("PaymentGateWayPassword");
            }
        }
        public string PaymentGateway
        {
            get
            {
                return GetStringValue("PaymentGateway");
            }
        }
        public bool UsePayerAccount
        {
            get
            {
                return GetBooleanValue("UsePayerAccount");
            }
        }
        public bool AllowCollectionOnPayerAccount
        {
            get
            {
                return GetBooleanValue("AllowCollectionOnPayerAccount");
            }
        }
        public string ApplyPayerProcess
        {
            get
            {
                return GetStringValue("ApplyPayerProcess");
            }
        }
        public bool EnableSalesDistributionChannel
        {
            get
            {
                return GetBooleanValue("EnableSalesDistributionChannel");
            }
        }
        public bool ExcludeBasePriceFromFreeItemsVAT
        {
            get
            {
                return GetBooleanValue("ExcludeBasePriceFromFreeItemsVAT");
            }
        }
        public bool RemoveHomeAndOfficesConceptFromCRM
        {
            get
            {
                return GetBooleanValue("RemoveHomeAndOfficesConceptFromCRM");
            }
        }
        public bool ConsiderStockStatusInWarehouseStock
        {
            get
            {
                return GetBooleanValue("ConsiderStockStatusInWarehouseStock");
            }
        }
        public bool ConsiderStockStatusInOrderFlow
        {
            get
            {
                return GetBooleanValue("ConsiderStockStatusInOrderFlow");
            }
        }
        public bool ApplyDiscountOnMaxPrice
        {
            get
            {
                return GetBooleanValue("ApplyDiscountOnMaxPrice");
            }
        }
        public bool UseOnlineCreditCard
        {
            get
            {
                return GetBooleanValue("UseOnlineCreditCard");
            }
        }
        public bool CalculateShelfIncentiveAfterTax
        {
            get
            {
                return GetBooleanValue("CalculateShelfIncentiveAfterTax");
            }
        }
        public bool AllowSelectAlternativeWarehouseInFO
        {
            get
            {
                return GetBooleanValue("AllowSelectAlternativeWarehouseInFO");
            }
        }
        public bool AllowTaxInWarehouseOperations
        {
            get
            {
                return GetBooleanValue("AllowTaxInWarehouseOperations");
            }
        }
        public int TerritoryScreenMode
        {
            get
            {
                int value = GetIntegerValue("TerritoryScreenMode");
                return value > 0 ? value : (int)Model.TerritoryScreenMode.AssignRoutesToCustomers;
            }
        }

        public string RestrictApprovalCycleToOrganizationLevel
        {
            get
            {
                return GetStringValue("RestrictApprovalCycleToOrganizationLevel");
            }
        }

        public bool PrintHeaderPerPage
        {
            get
            {
                return GetBooleanValue("PrintHeaderPerPage");
            }
        }

        public string EditableSalesOrderTypePrices
        {
            get
            {
                return GetStringValue("EditableSalesOrderTypePrices");
            }
        }
        // ZATCA
        public string SupplierCityName
        {
            get
            {
                return GetStringValue("SupplierCityName");
            }
        }

        public string SupplierRegistrationName
        {
            get
            {
                return GetStringValue("SupplierRegistrationName");
            }
        }
        public string SupplierCompanyID
        {
            get
            {
                return GetStringValue("SupplierCompanyID");
            }
        }
        public bool AllowSkipZATCANationalAddress
        {
            get
            {
                return GetBooleanValue("AllowSkipZATCANationalAddress");
            }
        }
        public string SupplierTaxNumber
        {
            get
            {
                return GetStringValue("SupplierTaxNumber");
            }
        }
        public string SupplierIdentificationSchemeID
        {
            get
            {
                return GetStringValue("SupplierIdentificationSchemeID");
            }
        }
        public string SupplierStreetName
        {
            get
            {
                return GetStringValue("SupplierStreetName");
            }
        }
        public string SupplierBuildingNumber
        {
            get
            {
                return GetStringValue("SupplierBuildingNumber");
            }
        }
        public string SupplierPlotIdentification
        {
            get
            {
                return GetStringValue("SupplierPlotIdentification");
            }
        }
        public string SupplierPostalZone
        {
            get
            {
                return GetStringValue("SupplierPostalZone");
            }
        }
        public string SupplierCitySubdivisionName
        {
            get
            {
                return GetStringValue("SupplierCitySubdivisionName");
            }
        }

        public bool UseZATCAProductionEnvironment
        {
            get
            {
                return GetBooleanValue("UseZATCAProductionEnvironment");
            }
        }
        public bool DistributeBenefitAmountPerQuantities
        {
            get
            {
                return GetBooleanValue("DistributeBenefitAmountPerQuantities");
            }
        }
        public bool AllowReAssignUploadedOrders
        {
            get
            {
                return GetBooleanValue("AllowReAssignUploadedOrders");
            }
        }
        public bool ApplyDocumentSequencePerSalesChannel
        {
            get
            {
                return GetBooleanValue("ApplyDocumentSequencePerSalesChannel");
            }
        }
        public bool EnableBlockedQuantity
        {
            get
            {
                return GetBooleanValue("EnableBlockedQuantity");
            }
        }
        public string BookedQtyPeriod
        {
            get
            {
                return GetStringValue("BookedQtyPeriod");
            }
        }
        public bool EnableBookedQuantity
        {
            get
            {
                return GetBooleanValue("EnableBookedQuantity");
            }
        }
        public bool CheckEditPriceOnPromotion
        {
            get
            {
                return GetBooleanValue("CheckEditPriceOnPromotion");
            }
        }
        public bool HideSalesPersonInfoInCRM
        {
            get
            {
                return GetBooleanValue("HideSalesPersonInfoInCRM");
            }
        }
        public string HideCRMOrderFields
        {
            get
            {
                return GetStringValue("HideCRMOrderFields");
            }
        }
        public bool SkipPlanDefinitionInCommision
        {
            get
            {
                return GetBooleanValue("SkipPlanDefinitionInCommision");
            }
        }
        public string NewCustomerCodeSequence
        {
            get
            {
                return GetStringValue("NewCustomerCodeSequence");
            }
        }
        public string NewOutletCodeSequence
        {
            get
            {
                return GetStringValue("NewOutletCodeSequence");
            }
        }
        public string EPaymentCountryNote
        {
            get
            {
                return GetStringValue("EPaymentCountryNote");
            }
        }
        public string EPaymentCurrency
        {
            get
            {
                return GetStringValue("EPaymentCurrency");
            }
        }
        public bool RestrictDataToCustomerOrganization
        {
            get
            {
                if (LocalUtilities.IsCRM)
                {
                    return GetBooleanValue("RestrictDataToCustomerOrganization");
                }
                else
                {
                    return false;
                }
            }
        }
        public bool SkipCRMVisit
        {
            get
            {
                return GetBooleanValue("SkipCRMVisit");
            }
        }
        public bool UseMainStatusInOrderHistory
        {
            get
            {
                return GetBooleanValue("UseMainStatusInOrderHistory");
            }
        }
        public bool ForceChequeApprovalProcess
        {
            get
            {
                return GetBooleanValue("ForceChequeApprovalProcess");
            }
        }
        public bool AllowPDCToAffectBalance
        {
            get
            {
                return GetBooleanValue("AllowPDCToAffectBalance");
            }
        }
        public bool ProcessReturnsInBO
        {
            get
            {
                return GetBooleanValue("ProcessReturnsInBO");
            }
        }
        public bool ApplyToleranceOverStockItems
        {
            get
            {
                return GetBooleanValue("ApplyToleranceOverStockItems");
            }
        }
        public bool SkipCRMOrderSourceDependency
        {
            get
            {
                return GetBooleanValue("SkipCRMOrderSourceDependency");
            }
        }
        public string OperationsAllowMultiPayerBranches
        {
            get
            {
                return GetStringValue("OperationsAllowMultiPayerBranches");
            }
        }
        public bool IncludePendingQuantityForBundle
        {
            get
            {
                return GetBooleanValue("IncludePendingQuantityForBundle");
            }
        }
        public bool IncludeApprovedQuantityForBundle
        {
            get
            {
                return GetBooleanValue("IncludeApprovedQuantityForBundle");
            }
        }
        #endregion [Properties]
        public ConfigurationModel GetConfigurationValue(string keyName)
        {
            return GetConfigurationValue(keyName, -1);
        }
        public ConfigurationModel GetConfigurationOnOrganization(string keyName, int organizationId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            ConfigurationModel configModel = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configModel = new ConfigurationModel();
                string query = string.Format(@"
                        SELECT KeyName, KeyValue, ConfigurationID FROM ConfigurationOrganization  WHERE (KeyName ='{0}') AND (OrganizationID = ({1}))
	                      ", keyName, organizationId);
                result = dbHelper.GetQuerySingle(query, ref configModel);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                configModel = null;
            }
            return configModel;
        }
        public ConfigurationModel GetConfigurationValueBasedOnOrginization(string keyName)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            ConfigurationModel configModel = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                dbHelper = new DBHelper<ConfigurationModel>();
                configModel = new ConfigurationModel();
                string query = string.Format(@"
                    SELECT TOP (1) KeyName, KeyValue, ConfigurationID FROM (
                        SELECT KeyName, KeyValue, ConfigurationID, 1 AS Priority FROM ConfigurationOrganization  WHERE (KeyName ='{0}') AND (OrganizationID IN ({1}))
	                        UNION
                        SELECT KeyName, KeyValue, ConfigurationID, 2 AS Priority FROM Configuration WHERE (KeyName = '{0}')) AS tt
                    ORDER BY Priority", keyName, _requestRepository.CurrentEchoOperator.RouteOrganizationIds);
                result = dbHelper.GetQuerySingle(query, ref configModel);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                configModel = null;
            }
            return configModel;
        }
        public ConfigurationModel GetConfigurationValue(string keyName, int employeeId)
        {
            GlobalErrors result = GlobalErrors.NotInitialized;
            ConfigurationModel configModel = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                int selectedEmployee = _requestRepository.CurrentOperator == null ? -1 : _requestRepository.CurrentOperator.EmployeeId;
                string selectedOperatorId = _requestRepository.CurrentOperator == null ? "-1" : _requestRepository.CurrentOperator.OperatorId.ToString();
                string selectedOrganizationId = _requestRepository.CurrentOperator == null ? "-1" : _requestRepository.CurrentOperator.OrganizationId.ToString();
                if (employeeId > 0)
                {
                    selectedEmployee = employeeId;
                    selectedOperatorId = string.Format(@"(select OperatorID from EmployeeOperator where EmployeeID = {0})", employeeId);
                    selectedOrganizationId = string.Format(@"(Select OrganizationID from Employee where EmployeeID = {0})", employeeId);
                }
                dbHelper = new DBHelper<ConfigurationModel>();
                configModel = new ConfigurationModel();
                string query = string.Format(@"Select * from (
                Select Configuration.KeyName, alllevels.KeyValue, alllevels.proirity ConfigurationLevelPriority,
                row_number() OVER (PARTITION BY Configuration.KeyName ORDER BY alllevels.proirity ASC) AS rowNumber
                from Configuration
                left outer join (
                select KeyName, KeyValue, 1 proirity from Configuration
                where EmployeeID = {0} AND KeyName = '{3}'
                union
                select KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
                where ConfigurationSecurityGroup.SecurityGroupID in
                (select SecurityGroupID from OperatorSecurityGroup where OperatorID = {1}) AND KeyName = '{3}'
                union
                select KeyName, KeyValue, 4 proirity from ConfigurationOrganization
                where ConfigurationOrganization.OrganizationID = {2} AND KeyName = '{3}'
                union
                select KeyName, KeyValue, 5 proirity from Configuration
                where EmployeeID = -1 AND KeyName = '{3}'

                ) allLevels on allLevels.KeyName = Configuration.KeyName)tt
                where tt.rowNumber = 1 and tt.ConfigurationLevelPriority is not null",
                selectedEmployee,
                selectedOperatorId,
               selectedOrganizationId,
                keyName);
                result = dbHelper.GetQuerySingle(query, ref configModel);

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                configModel = null;
            }
            return configModel;
        }

        public ConfigurationModel GetConfigurationValue(int employeeId, string keyName)
        {
            ConfigurationModel configuration = null;
            DBHelper<ConfigurationModel> dbHelper = null;
            try
            {
                int selectedEmployee = _requestRepository.CurrentOperator.EmployeeId;
                string selectedOperatorId = _requestRepository.CurrentOperator.OperatorId.ToString();
                string selectedOrganizationId = _requestRepository.CurrentOperator.OrganizationId.ToString();
                dbHelper = new DBHelper<ConfigurationModel>();

                configuration = new ConfigurationModel();
                if (employeeId > 0)
                {
                    selectedEmployee = employeeId;
                    selectedOperatorId = string.Format(@"(select OperatorID from EmployeeOperator where EmployeeID = {0})", employeeId);
                    selectedOrganizationId = string.Format(@"(Select OrganizationID from Employee where EmployeeID = {0})", employeeId);
                }
                string query = string.Format(@"Select * from (
                Select Configuration.KeyName, alllevels.KeyValue, alllevels.proirity ConfigurationLevelPriority,
                row_number() OVER (PARTITION BY Configuration.KeyName ORDER BY alllevels.proirity ASC) AS rowNumber
                from Configuration
                left outer join (
                select KeyName, KeyValue, 1 proirity from Configuration
                where EmployeeID = {0}  AND KeyName = '{1}'
                union
                select KeyName, KeyValue, 2 proirity from ConfigurationSecurityGroup
                where ConfigurationSecurityGroup.SecurityGroupID in
                (select SecurityGroupID from OperatorSecurityGroup where OperatorID = (select OperatorID from EmployeeOperator where EmployeeID = {0}) AND KeyName = '{1}')
                union
                select KeyName, KeyValue, 4 proirity from ConfigurationOrganization
                where ConfigurationOrganization.OrganizationID = (Select OrganizationID from Employee where EmployeeID = {0}) AND KeyName = '{1}'
                union
                select KeyName, KeyValue, 5 proirity from Configuration
                where EmployeeID = -1 AND KeyName = '{1}'
                ) allLevels on allLevels.KeyName = Configuration.KeyName)tt
                where tt.rowNumber = 1 and tt.ConfigurationLevelPriority is not null",
                employeeId, keyName);
                var result = dbHelper.GetQuerySingle(query, ref configuration);

                return configuration;
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return null;
            }
        }
    }
}