﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Runtime.CompilerServices;

namespace Sonic.Web.DAL
{
    public class ErrorLogger
    {
        public static void Logger(string className, string functionName, string errorMsg, Exception innerEx, string stackTrace, int userId, [CallerLineNumber] int lineNumber = 0)
        {
            try
            {
                string query = @"INSERT INTO ErrorLogger 
                (ErrorMessage,ErrorStackTrace,ErrorInnerExceptionMessage,ClassName,FunctionName,LineNumber, ErrorDate, CreatedBy, VersionNumber, Module)  
                VALUES 
                (@ErrorMessage, @ErrorStackTrace, @ErrorInnerExceptionMessage, @ClassName, @FunctionName, @LineNumber, @ErrorDate, @CreatedBy, @VersionNumber, @Module
                )";

                Dictionary<string, object> parameter = new Dictionary<string, object>();

                parameter.Add("ErrorMessage", errorMsg);
                parameter.Add("ErrorStackTrace", stackTrace);
                parameter.Add("ErrorInnerExceptionMessage", innerEx);
                parameter.Add("ClassName", className);
                parameter.Add("FunctionName", functionName);
                parameter.Add("LineNumber", lineNumber);
                parameter.Add("ErrorDate", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.sss"));
                parameter.Add("CreatedBy", userId);
                parameter.Add("VersionNumber", LocalUtilities.AppVersion);
                parameter.Add("Module", LocalUtilities.IsCRM ? "CRM" : "Sonic");

                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.ExecuteNonQuery(query, false, parameter);
            }
            catch (Exception ex)
            {
            }
        }
        public static void TrackQuery(int UserId, string className, string functionName, string QueryString, string ExecutionTime, [CallerLineNumber] int lineNumber = 0)
        {
            try
            {
                if (!LocalUtilities.IsCRM) return;

                string query = @"INSERT INTO QueryTracker 
                (UserID,Module,LogDate,ClassName,FunctionName,LineNumber,VersionNumber,QueryString,ExecutionTime)  
                VALUES 
                (@UserID, @Module, @LogDate, @ClassName, @FunctionName, @LineNumber, @VersionNumber, @QueryString, @ExecutionTime)";

                Dictionary<string, object> parameter = new Dictionary<string, object>();

                parameter.Add("UserID", UserId);
                parameter.Add("Module", LocalUtilities.IsCRM ? "CRM" : LocalUtilities.IsSonic ? "Sonic" : "");
                parameter.Add("LogDate", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.sss"));
                parameter.Add("ClassName", className);
                parameter.Add("FunctionName", functionName);
                parameter.Add("LineNumber", lineNumber);
                parameter.Add("VersionNumber", LocalUtilities.AppVersion);
                parameter.Add("QueryString", QueryString);
                parameter.Add("ExecutionTime", ExecutionTime);

                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.ExecuteNonQuery(query, false, parameter);
            }
            catch (Exception ex)
            {
            }
        }
        public static void LogErrorOnErrorFile(string className, string funcitonName, string errMsg, string stackTrace, int LineNumber = 0)
        {
            FileInfo fi;
            string str;
            string errorLogFilePath;
            StreamWriter sw = null;
            try
            {
                string ErrorLogFileName = "InCubelog.txt";
                const Int64 ErrorLogFileSize = 1048576;//.. 1 MB
                errorLogFilePath = Path.Combine(Directory.GetCurrentDirectory(), "wwwroot\\", ErrorLogFileName);
                if (File.Exists(errorLogFilePath) == false)
                {
                    File.Create(errorLogFilePath).Close();
                }

                fi = new FileInfo(errorLogFilePath);
                if (fi.Length > ErrorLogFileSize)
                {
                    fi.Delete();
                }
                File.Open(errorLogFilePath, FileMode.OpenOrCreate).Close();
                sw = new StreamWriter(errorLogFilePath, true);
                str = DateTime.Now.ToString("dd/MM/yyyy HH:mm:ss");
                str += string.Format("[Class: {0}] [Function: {1}] [LineNumber: {4}] [Error: {2}] [Stack: {3}]", className, funcitonName, errMsg, stackTrace, LineNumber);
                sw.WriteLine(str);
                sw.WriteLine("------------------------------------------------");

            }
            catch (Exception)
            {

            }

            finally
            {
                if (sw != null)
                {
                    sw.Flush();
                    sw.Close();
                    sw = null;
                }
            }
        }

        public static void ETransactionsLogger(string className, string functionName, string msg, Exception innerEx, string stackTrace, int userId, [CallerLineNumber] int lineNumber = 0) 
        {
            try 
            {
                string query = @"INSERT INTO ETransactionsLogger 
                (Message,StackTrace,InnerExceptionMessage,ClassName,FunctionName,LineNumber, Date, CreatedBy, VersionNumber, Module)  
                VALUES 
                (@Message, @StackTrace, @ErrorInnerExceptionMessage, @ClassName, @FunctionName, @LineNumber, @ErrorDate, @CreatedBy, @VersionNumber, @Module
                )";

                Dictionary<string, object> parameter = new Dictionary<string, object>();

                parameter.Add("Message", msg);
                parameter.Add("StackTrace", stackTrace);
                parameter.Add("ErrorInnerExceptionMessage", innerEx);
                parameter.Add("ClassName", className);
                parameter.Add("FunctionName", functionName);
                parameter.Add("LineNumber", lineNumber);
                parameter.Add("ErrorDate", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss.sss"));
                parameter.Add("CreatedBy", userId);
                parameter.Add("VersionNumber", LocalUtilities.AppVersion);
                parameter.Add("Module", LocalUtilities.IsCRM ? "CRM" : "Sonic");

                DBHelper<int> dBHelper = new DBHelper<int>();
                dBHelper.ExecuteNonQuery(query, false, parameter);
            }
            catch (Exception ex)
            {
            }

        }
    }
}