﻿using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.IO;
using System.Text;

namespace Sonic.Web.DAL
{
    public class LocalUtilities
    {
        #region[Static Members]

        private static string _proofImagesDistPath;
        private static string _customerAttachments;
        private static string _customerAttachmentsDummy;

        public const string ItemImageFolderPath = "Resources\\items-img";
        public const string ItemGroupImageFolderPath = "Resources\\itemGroups-img";
        public const string ItemCategoryImageFolderPath = "Resources\\categories-img";
        public const string BrandImageFolderPath = "Resources\\brands-img";
        public const string DivisionImageFolderPath = "Resources\\divisions-img";
        public const string BannerImageFolderPath = "Resources\\banners-img";
        public const string CustomerAppItemImageFolderPath = "wwwroot\\img\\Echo\\item";
        public const string CustomerAppCategoryImageFolderPath = "wwwroot\\img\\Echo\\category";
        public const string CustomerAppBrandImageFolderPath = "wwwroot\\img\\Echo\\brand";
        public const string CustomerAppDivisonImageFolderPath = "wwwroot\\img\\Echo\\divisions";
        public const string CustomerAppGroupImageFolderPath = "wwwroot\\img\\Echo\\itemGroup";
        public const string UserImageFolderPath = "wwwroot\\Users-Img";
        public const string CustomerAppBannerImageFolderPath = "wwwroot\\img\\Echo\\banner";
        public const string ItemAttachFolderPath = "Resources\\attachements\\Items\\";
        public const string CustomerAppItemAttachFolderPath = "wwwroot\\img\\echo\\item-attachements";
        public const string ImageExtension = ".png";
        public const string ATMSettlementsImages = "ATMSettlementImages";
        public const string ExpenseSettlementsImages = "VehicleExpensesImages";
        public const string ReportScheduleFolderPath = "~/PDFUtility/DynamicScheduledReport/ScheduledReportPDF.cshtml";
        public const string CustomizedReportsFolderPath = "~/PDFUtility/CustomizedReports/";
        public const string WebFormDefaultFolderPath = "~/PDFUtility/WebForm/WebFormPDF.cshtml";
        public const string WebFormCustomizedFolderPath = "~/PDFUtility/WebForm/WebFormCustomized/";
        public const string NewCustomerTemplateImages = "NewCustomerTemplateImages";
        public static int GestCustomerId = 0;
        public static string AllowedOriginsString { get; set; }
        public static List<string> AllowedOriginsList { get; set; }

        public static string ITrackServiceURL { get; set; }
        public static bool AutoSendTransaction { get; set; }
        public static WebApplication WebApplication { get; set; }
        public static DateTime DefaultExpiryDate = new DateTime(1990, 1, 1);
        public static string DefaultBatchNo = "1990/01/01";
        public static string DomainName = "incube.com";
        public static string AppVersion { get; set; }
        public static SystemEnvironment SystemEnvironment { get; set; }
        public static int TokenExpiryHours { get; set; }
        public static string ConnectionString { get; set; }
        public static bool IsCRM { get; set; }
        public static bool IsSonic { get; set; }
        public static string DashboardURL { get; set; }
        public static string ATReportURL { get; set; }
        public static string GridReportURL { get; set; }
        //public static string RDLCReportURL { get; set; }
        public static string CallCenterURL { get; set; }
        public static string CustomerAppNotificationID { get; set; }
        public static string CustomerAppNotificationSenderID { get; set; }
        public static string CRMAppPath { get; set; }
        public static string SonicAPIPath { get; set; }
        public static string CustomerAppServicePath { get; set; }
        public static string SonicFONotificationID { get; set; }
        public static string SonicFONotificationSenderID { get; set; }
        public static string CustomerLogoPath { get; set; }
        public static string SonicWebPath { get; set; } //Used with Echo (to send from echo to sonic)
        public static string OutletImagesSourcePath { get; set; }
        public static string FOImagesURL { get; set; }
        public static int SessionExpiryHours { get; set; }
        public static string ProofImagesSourcePath { get; set; }
        public static string ATMSettlementImagesSourcePath { get; set; }
        public static string FOImagesFolderPath { get; set; }
        public static string ExpenseSettlementImagesSourcePath { get; set; }
        public static string YearForROI { get; set; }

        public static string PrintEPaymentInErrorLogger { get; set; }
        public static string PrinterName { get; set; }
        public static string ThermalPrinterName { get; set; }

        public static string UsedSecurityKey { get; set; }
        public static string UsedIssuer { get; set; }
        public static string UsedAudience { get; set; }
        public static int UsedTimeout { get; set; }

        public static List<MessageBodyModel> MessageBodyForRequestKeyList { get; set; }
        public static string ProofImagesDistPath
        {
            get
            {
                return _proofImagesDistPath;
            }
        }
        public static string CustomerAttachments
        {
            get
            {
                return _customerAttachments;
            }
        }
        public static string CustomerAttachmentsDummy
        {
            get
            {
                return _customerAttachmentsDummy;
            }
        }
        public List<ConfigurationModel> CustomLevelConfigurations { get; set; }
        public List<ConfigurationModel> SpecificEmployeeConfigurations { get; set; }
        public static char SplitCharacterDashboardQueryString = '@';

        #endregion

        #region [METHODS]

        public static void PrepareDefaultFolderPath(string rootPath)
        {
            _proofImagesDistPath = Path.Combine(rootPath, "wwwroot", "ProofImages");
            _customerAttachments = Path.Combine(rootPath, "wwwroot", "CustomerAttachments");
            _customerAttachmentsDummy = Path.Combine(rootPath, "wwwroot", "CustomerAttachmentsDummy");
        }
        public static int GetWeekNumber(DateTime dt)
        {
            CultureInfo ciCurr = CultureInfo.CurrentCulture;
            int weekNum = ciCurr.Calendar.GetWeekOfYear(dt, CalendarWeekRule.FirstFourDayWeek, DayOfWeek.Saturday);
            return weekNum;
        }
        public string GetFormattedDecimal(decimal number, int numberOfDigits)
        {
            try
            {
                if (number == 0)
                    return "0";
                return decimal.Round(number, numberOfDigits, MidpointRounding.AwayFromZero).ToString("G29");
            }
            catch (Exception ex)
            {
                return number.ToString();
            }
        }
        public static decimal GetRoundedDecimal(decimal number, int digitFormat)
        {
            try
            {
                return decimal.Round(number, digitFormat, MidpointRounding.AwayFromZero);
            }
            catch (Exception ex)
            {
                return number;
            }
        }
        public static string ParseDateAndTimeToSQL(DateTime value)
        {
            try
            {
                string result = string.Empty;

                result = string.Format("CONVERT(datetime, '{0}/{1}/{2} {3}:{4}:{5}', 102 )", value.Year, value.Month, value.Day, value.Hour, value.Minute, value.Second);


                return result;
            }
            catch (Exception ex)
            {

                return string.Empty;
            }

        }
        public static string ParseDateToSQLString(DateTime value)
        {
            try
            {
                string result = string.Empty;
                result = "  CONVERT(datetime, '" + value.Year + "/" + value.Month + "/" + value.Day + " 00:00:00', 102) ";
                return result;
            }
            catch (Exception ex)
            {
                return string.Empty;
            }

        }
        public static string ParseEndDateToSQLString(DateTime value)
        {
            try
            {
                string result = string.Empty;
                result = "  CONVERT(datetime, '" + value.Year + "/" + value.Month + "/" + value.Day + " 23:59:59', 102) ";
                return result;
            }
            catch (Exception ex)
            {

                return string.Empty;
            }

        }
        /// <summary>
        ///  Convert a string representation of datetime  to datetime value
        /// </summary>
        /// <param name="dateString">Expected date string in the following format dd/mm/yyyy</param>
        /// <returns>Return resulted date</returns>
        public static DateTime ParseStringToDate(string dateString)
        {
            DateTime date = DateTime.Today;
            try
            {
                string[] serverDate = dateString.Split("/".ToCharArray());
                if (serverDate != null && serverDate.Length == 3)
                {
                    date = new DateTime((serverDate[2].Remove(4) == string.Empty ? 0 : int.Parse(serverDate[2].Remove(4))), (serverDate[0] == string.Empty ? 0 : int.Parse(serverDate[0])),(serverDate[1] == string.Empty ? 0 : int.Parse(serverDate[1])));
                }
            }
            catch (Exception ex)
            {
                // General.Common.ErrorLogger.LogError(((System.Reflection.MemberInfo)(typeof(InVanUIUtilities))).Name, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.StackTrace);

            }
            return date;
        }
        /// <summary>
        /// this function will return date string with format dd/MM/yyyy from any format
        /// </summary>
        /// <param name="date"></param>
        /// <returns></returns>
        public static string getDateAsStringFromDateFormat(string date, string format)
        {
            try
            {
                string outDate = string.Empty;
                outDate = date.Substring(format.IndexOf("dd"), 2);
                outDate += "/" + date.Substring(format.IndexOf("MM"), 2);
                outDate += "/" + date.Substring(format.IndexOf("yyyy"), 4);
                return outDate;
            }
            catch
            {
                return string.Empty;
            }
        }
        public static object ParseDateToSQLString(DateTime? timeToRun)
        {
            throw new NotImplementedException();
        }

        #endregion [METHODS]
    }
}
