﻿using Sonic.Web.Model;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;

namespace Sonic.Web.DAL
{
    public class ActiveTokens : IActiveTokens
    {
        private static List<string> _tokens;
        
 
        public List<string> GetTokens()
        {
            if (_tokens == null || _tokens.Count == 0)
            {
                FillActiveTokensDB();
            }
            return _tokens;
        }

        public GlobalErrors FillActiveTokensDB()
        {
            DBHelper<String> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                dBHelper = new DBHelper<String>();
                string query = string.Format(@"Select * from ActiveTokens");
                result = dBHelper.GetQueryList(query, ref _tokens);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }
            return result;
        }
        public GlobalErrors AddActiveTokens(string tokenString)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                FillActiveTokensDB();
                tokenString = "Bearer " + tokenString;
                dBHelper = new DBHelper<int>();
                string query = string.Format(@"Insert into ActiveTokens values ('{0}')", tokenString);
                result = dBHelper.ExecuteNonQuery(query);
                if (result == GlobalErrors.Success)
                {
                    if (!_tokens.Any(t => t == tokenString))
                    {
                        _tokens.Add(tokenString);
                    }
                }

            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }
            return result;
        }
        public GlobalErrors DeleteActiveTokens(string tokenString)
        {
            DBHelper<int> dBHelper = null;
            GlobalErrors result = GlobalErrors.NotInitialized;
            try
            {
                FillActiveTokensDB();

                dBHelper = new DBHelper<int>();
                string query = string.Format(@"Delete from ActiveTokens where ActiveToken = '{0}'", tokenString);
                result = dBHelper.ExecuteNoneQueryWithZeroRowAffectedCheck(query);
                if (result == GlobalErrors.SuccessWithZeroRowAffected)
                {
                    result = GlobalErrors.Success;
                }
                if (result == GlobalErrors.Success)
                {
                    if(_tokens.Any(t => t == tokenString))
                    {
                        _tokens.Remove(tokenString);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                return result;
            }
            return result;
        }
    }
}
