﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class AccountModel
    {
        public int AccountId { get; set; }
        public string AccountName { get; set; }
        public int OrganizationId { get; set; }
        public int AccountTypeId { get; set; }
        public string TypeName { get; set; }
        public decimal CreditLimit { get; set; }
        public decimal TotalCreditLimit { get; set; }
        public decimal Balance { get; set; }
        public decimal PendingOrdersTotal { get; set; }
        public bool GL { get; set; }
        public int CurrencyId { get; set; }
        public string CurrencyName { get; set; }
        public string OrganizationName { get; set; }
        public int ParentAccountId { get; set; }
        public decimal CommitmentLimit { get; set; }
        public int DivisionId { get; set; }
        public DataActions DataAction { get; set; }
        public string DivisionCodeName { get; set; }
        public string OrganizationCodeName { get; set; }
        public string CurrencyCodeName { get; set; }
        public CustomerAccountLevel AccountLevel { get; set; }
        public bool IsHidden { get; set; }
        public bool isCollapsed { get; set; }
        public AccountModel()
        {
            AccountLevel = CustomerAccountLevel.None;
            DivisionId = -1;
            DivisionCodeName = string.Empty;
            AccountId = -1;
            AccountName = string.Empty;
            OrganizationId = -1;
            AccountTypeId = -1;
            TypeName = string.Empty;
            CreditLimit = 0;
            Balance = 0;
            PendingOrdersTotal = 0;
            GL = false;
            CurrencyId = -1;
            CurrencyName = string.Empty;
            OrganizationName = string.Empty;
            ParentAccountId = -1;
            CommitmentLimit = 0;
        }
    }

   
}
