﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading.Tasks;

namespace Sonic.Web.Model
{
    public class OrderAPIModel
    {
        public string OrderNumber { get; set; }
        public string OrderDate { get; set; }
        public string SiteCode { get; set; }
        public string CustomerName { get; set; }
        public string Status { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal Tax { get; set; }
        public int TotalItems { get; set; }
        public List<ItemPackAPIModel> Details { get; set; }
    }

    public class SendOrderAPIModel
    {
        public string SiteCode { get; set; }
        public string CustomerName { get; set; }
        public string OrderNumber { get; set; }
        public string OrderDate { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal Tax { get; set; }
        public decimal Discount { get; set; }
        public string CreatedSource { get; set; }
        public string DeliveryDate { get; set; }
        public List<SendItemPackAPIModel> AllItems { get; set; }
    }

    public class OrderStatusAPIModel
    {
        public string Status { get; set; }
    }

    public class ItemPackAPIModel
    {
        public string ItemCode { get; set; }

        private string _itemName;
        public string ItemName
        {
            get
            {
                return _itemName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemName = "---";
                else
                    this._itemName = value;
            }
        }
        public string UOM { get; set; }
        public decimal Quantity { get; set; }
        public decimal Price { get; set; }
        public decimal ItemTax { get; set; }
    }

    public class SendItemPackAPIModel
    {

        public string ItemCode { get; set; }

        private string _itemName;
        public string ItemName
        {
            get
            {
                return _itemName;
            }
            set
            {
                if (string.IsNullOrEmpty(value))
                    this._itemName = "---";
                else
                    this._itemName = value;
            }
        }
        public string Category { get; set; }
        public string UOM { get; set; }
        public decimal Price { get; set; }
        public decimal Quantity { get; set; }
        public int PackId { get; set; }
        public int LineNumber { get; set; }
        public bool IsFOC { get; set; }
        public decimal DiscountAmount { get; set; }
        public decimal TaxAmount { get; set; }
        public decimal TotalAmount { get; set; }
    }
}
