﻿using System;
using System.Collections.Generic;

namespace Sonic.Web.Model
{
    public class BarcodeTemplateModel
    {
        public int TemplateId { set; get; }
        public string TemplateName { set; get; }
        public string TemplateCode { set; get; }
        public string TemplateCodeName { set; get; }
        public int Length { set; get; }
        public int StartIndex { get; set; }
        public int EndIndex { get; set; }
        public List<TextLanguage> TemplateDescriptionLanguages { get; set; }
        public List<TemplateFieldModel> TemplateFieldsList { get; set; }
        public bool ContainsGTIN { get; set; }
        public BarcodeTemplateModel()
        {
            TemplateId = -1;
            TemplateName = string.Empty;
            TemplateCode = string.Empty;
            TemplateCodeName = string.Empty;
            Length = 0;
            TemplateFieldsList = new List<TemplateFieldModel>();
            ContainsGTIN = false;
        }
    }
    public class TemplateFieldModel
    {
        public int FieldId { get; set; }
        public string FieldName { get; set; }
        public int FieldLength { get; set; }
        public int OldLength { get; set; }
        public int FieldSequence { get; set; }
        public int TemplateId { set; get; }
        public TemplateFieldModel()
        {
            FieldId = -1;
            FieldName = string.Empty;
            FieldLength = 0;
            FieldSequence = 0;
            OldLength = 0;
            TemplateId = -1;
        }
    }
    public class BarcodeValues
    {
        public DateModel ProductionDateModel { get; set; }
        public DateModel ExpiryDateModel { get; set; }
        public string BatchNo { get; set; }
        public string GLN { get; set; }
        public string GTIN { get; set; }
        public int Quantity { get; set; }
        public bool GenerateSubBarcodes { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
    }
}
