﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class ChattingUserModel
    {
        public int UserId { get; set; }
        public string UserName { get; set; }
        public string DeviceSerial { get; set; }
        public string DeviceName { get; set; }
        public string DeviceToken { get; set; }
        public ChattingConnectionStatus Status { get; set; }
        public ChattingAssignmentStatus AssignmentStatus { get; set; }
        public bool IsBOUser { get; set; }
        public int AssignedBOUserId { get; set; }
        public bool AddRemoveAssignment { get; set; }
        public int ChattingConnectionStatusValue { get; set; }
        public int ChattingAssignmentStatusValue { get; set; }
        public int Inactive { get; set; }
        public string ImagePath { get; set; }

        public ChattingUserModel()
        {
            UserId = -1;
            UserName = "";
            DeviceSerial = "";
            DeviceToken = "";
            Status = ChattingConnectionStatus.Offline;
            AssignmentStatus = ChattingAssignmentStatus.Remove;
            IsBOUser = false;
            AssignedBOUserId = -1;
            AddRemoveAssignment = false;
            Inactive = -1;
            ImagePath = string.Empty;

        }
    }
}
