﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.AspNetCore.SignalR;
using System.Threading.Tasks;



namespace Sonic.Web.Model
{
    public class MessageHub : Hub
    {
        public async Task NewMessage(ChattingHistoryModel msg)
        {
            await Clients.All.SendAsync("MessageReceived", msg);
        }

        public async Task MessageRead(ChattingHistoryModel msg)
        {
            await Clients.All.SendAsync("MessageRead", msg);
        }

        public async Task NewBroadCast(List<ChattingHistoryModel> broadcastList)
        {
            await Clients.Others.SendAsync("BroadCastReceived", broadcastList);
        }

        public async Task UpdateChattingUsers(ChattingUserModel user)
        {
            await Clients.Others.SendAsync("UpdateChattingUsers", user);
        }

        public async Task MediaDownloaded(ChattingHistoryModel msg)
        {
            await Clients.All.SendAsync("MediaDownloaded", msg);
        }

        public async Task SetMessageAsReceived(ChattingHistoryModel msg)
        {
            await Clients.All.SendAsync("SetMessageAsReceived", msg);
        }
    }
}
