﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class ChattingHistoryModel
    {
        //private string _messageDate;
        private string _readingDate;
        public string BroadcastId { get; set; }
        public string MessageId { get; set; }
        public int SenderId { get; set; }
        public int ReceiverId { get; set; }
        public string SenderName { get; set; }
        public string ReceiverName { get; set; }
        public string MessageBody { get; set; }
        public bool IsRead { get; set; }
        public bool IsMessageReceived { get; set; }
        public DateModel MessageDateTimeModel { get; set; }
        public DateModel ReadingDateTimeModel { get; set; }
        public string MessageDate { get; set; }
        //{
        //    get { return _messageDate; }
        //    set
        //    {
        //        _messageDate = value;
        //        //if (_messageDate != null)
        //        //{
        //        //    MessageDateTimeModel = new DateModel(_messageDate);
        //        //}
        //    }
        //}
        public string ReadingDate
        {
            get { return _readingDate; }
            set
            {
                _readingDate = value;
                //if (_readingDate != null)
                //{
                //    ReadingDateTimeModel = new DateModel(_readingDate);
                //}
            }
        }
        public string ReceiverDeviceToken { get; set; }
        public string ReceiverDeviceSerial { get; set; }
        public bool IsBOReceiver { get; set; }
        public string SenderDeviceToken { get; set; }
        public string SenderDeviceSerial { get; set; }
        public bool IsBOSender { get; set; }
        public int CustomerId { get; set; }
        public int LanguageId { get; set; }
        public int OutletId { get; set; }
        public string CustomerCode { get; set; }
        public string OutletName { get; set; }
        public string CustomerName { get; set; }
        public string OutletCode { get; set; }
        public string OutletHeaderDescription { get; set; }
        public string DateTimeForView { get; set; }
        public List<BroadcastReceiverModel> ReceiversList { get; set; }
        public List<CustomerOutletDescriptions> CustomerOutletDescriptions { get; set; }
        public string ImagePath { get; set; }
        public List<ChattingHistoryMediaModel> MediaList { get; set; }
        public bool HasMedia { get; set; }
        public bool HasText { get; set; }
        public bool IsBroadcast { get; set; }

        // ONLY NEEDED IN GETCHATTINGHISTORY
        public string FileName { get; set; }
        public ChattingMediaTypes MediaType { get; set; }
        public bool IsDownloaded { get; set; }
        public string DownloadDate { get; set; }
        // ...........
        public DateModel MediaExpiryDateModel { get; set; }
        public DateTime MessageDateTime { get; set; }
        public ChattingHistoryModel()
        {
            BroadcastId = string.Empty;
            MessageId = string.Empty;
            SenderId = -1;
            ReceiverId = -1;
            SenderName = string.Empty;
            ReceiverName = string.Empty;
            MessageBody = string.Empty;
            IsRead = false;
            IsMessageReceived = false;
            ReceiverDeviceToken = string.Empty;
            ReceiverDeviceSerial = string.Empty;
            IsBOReceiver = false;
            SenderDeviceToken = string.Empty;
            SenderDeviceSerial = string.Empty;
            IsBOSender = false;
            CustomerId = -1;
            OutletId = -1;
            CustomerCode = string.Empty;
            OutletName = string.Empty;
            CustomerName = string.Empty;
            OutletCode = string.Empty;
            OutletHeaderDescription = string.Empty;
            ReceiversList = new List<BroadcastReceiverModel>();
            CustomerOutletDescriptions = new List<CustomerOutletDescriptions>();
            ImagePath = string.Empty;
            MediaList = new List<ChattingHistoryMediaModel>();
            HasMedia = false;
            HasText = false;
            //ReadingDate = DateTime.MinValue;
            //MessageDate = DateTime.MinValue;
            //ReadingDateTimeModel = new DateModel();
            //MessageDateTimeModel = new DateModel();
        }
    }
    public class BroadcastReceiverModel
    {
        public string MessageId { get; set; }
        public int ReceiverId { get; set; }
        public string ReceiverName { get; set; }
        public bool IsBOReceiver { get; set; }
        public string ReceiverDeviceToken { get; set; }
        BroadcastReceiverModel()
        {
            MessageId = string.Empty;
            ReceiverId = -1;
            ReceiverName = string.Empty;
            IsBOReceiver = false;
            ReceiverDeviceToken = string.Empty;
        }

    }

    public class CustomerOutletDescriptions
    {
        public string OutletDescription { get; set; }
        public string CustomerDescription { get; set; }
        public int LanguageId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string CustomerCode { get; set; }
        public string OutletCode { get; set; }
        public CustomerOutletDescriptions()
        {
            CustomerId = -1;
            OutletId = -1;
            LanguageId = -1;
            OutletDescription = string.Empty;
            CustomerDescription = string.Empty;
            CustomerCode = string.Empty;
            OutletCode = string.Empty;
        }
    }

    public class ChattingHistoryMediaModel
    {
        //public string BroadcastId { get; set; }
        public string MessageId { get; set; }
        public string FileName { get; set; }
        public ChattingMediaTypes MediaType { get; set; }
        public bool IsDownloaded { get; set; }
        public string ImagePath { get; set; }
        public string DownloadDate { get; set; }
        public DateModel MediaExpiryDateModel { get; set; }

        public ChattingHistoryMediaModel()
        {
            //BroadcastId = string.Empty;
            MessageId = string.Empty;
            FileName = string.Empty;
            IsDownloaded = false;
            ImagePath = string.Empty;
        }
    }

}
