﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class ContractedFOCModel
    {
        public int ContractId { get; set; }
        public string ContractName { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string OrganizationCodeName { get; set; }
        public int OrganizationId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int PeriodTypeId { get; set; }
        public string ContractPeriod { get; set; }
        public string ContractType { get; set; }
        public int ContractTypeId { get; set; }
        public int DivisionId { get; set; }
        public int TerritoryId { get; set; }
        public int SubTypeId { get; set; }
        public DateModel fromToDate { get; set; }
        public bool Inactive { set; get; }
        public bool ForceFoc { set; get; }
        public bool IsTransferable { set; get; }
        public bool AllCustomers { set; get; }
        public int PackId { get; set; }
        public string ItemCodeName { get; set; }
        public decimal RequiredQty { get; set; }
        public decimal RemainingQuantity { get; set; }
        public decimal Value { set; get; }
        public decimal RemainingValue { set; get; }
        public decimal PercentageValue { set; get; }
        public decimal ValueofPercent { set; get; }
        public decimal ShelfValue { set; get; }
        public decimal ShelfRemainingValue { set; get; }
        public List<ItemPackModel> AddedItemsList { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public string ContractedFOCStatusName { get; set; }
        public bool IsPending { set; get; }
        public int Status { set; get; }
        public string RejectNote { set; get; }
        public bool IsDeleted { set; get; }
        public bool ShowApprove { set; get; }
        public bool ShowRequest { set; get; }
        public bool IsApprove { set; get; }
        public bool ShowEdit { set; get; }
        public bool ShowDelete { set; get; }
        public bool IsCreationLevel { set; get; }
        public bool ShowViewOriginal { set; get; }
        public bool IsOneTime { get; set; }
        private DateTime? _startDate;
        private DateTime? _endDate;
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
  
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
        public ContractedFOCModel()
        {
            ContractId = -1;
            ContractName = string.Empty;
            OrganizationId = -1;
            TerritoryId = -1;
            DivisionId = -1;
            ContractTypeId = -1;
            PeriodTypeId = -1;
            Inactive = false;
            ForceFoc = false;
            IsTransferable = false;
            AllCustomers = false;
            SubTypeId = -1;
            RemainingValue = -1;
            ShelfValue = -1;
            ShelfRemainingValue = -1;
            CustomerCodeName = string.Empty;
            OutletCodeName = string.Empty;
            OrganizationCodeName = string.Empty;
            ContractType = string.Empty;
            ContractPeriod = string.Empty;
            IsOneTime = false;
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
            AddedItemsList = new List<ItemPackModel>();
            DescriptionLanguages = new List<TextLanguage>();
            ContractedFOCStatusName = string.Empty;
            RejectNote = string.Empty;
            PercentageValue = -1;
            ValueofPercent = -1;
            Value = -1;
        }
    }
    public class ContractTypeModel
    {
        public int ContractTypeId { get; set; }
        public string ContractTypeName { get; set; }

    }
    public class ContractedFOCFilterModel
    {
        public CustomListFilters CustomListFilter { get; set; }
        public int OrganizationId { get; set; }
        public int ContractId { get; set; }
        public string ContractName { get; set; }
        public int ContractTypeId { get; set; }
        public int PeriodTypeId { get; set; }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int TerritoryId { set; get; }
        public int DivisionId { set; get; }

        public DateModel FromDate { get; set; }
        public DateModel ToDate { get; set; }
        public string ContractPeriod { get; set; }
        public string ContractType { get; set; }
        public bool IncludeInactive { get; set; }

        public ContractedFOCFilterModel()
        {
            OrganizationId = -1;
            ContractTypeId = -1;
            PeriodTypeId = -1;
            CustomerId = -1;
            OutletId = -1;
            FromDate = new DateModel();
            ToDate = new DateModel();
            CustomListFilter = new CustomListFilters();
            ContractName = string.Empty;
            IncludeInactive = false;
        }
    }

    public class AppliedContractedFOCModel
    {
        public int ContractId { get; set; }
        public string ContractName { get; set; }
        public int OrganizationId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int PeriodTypeId { get; set; }
        public string PeriodType { get; set; }
        public decimal OriginalValue { get; set; }
        public decimal OriginalRemainingValue { get; set; }
        public decimal TakenValue { get; set; }
        public decimal RemainingValue { get; set; }
        public List<int> FOCimagesSequence { get; set; }
        public DateModel StartDateModel { get; set; }
        public DateModel EndDateModel { get; set; }
        private DateTime? _startDate;
        private DateTime? _endDate;
        public DateTime? StartDate
        {
            get { return _startDate; }
            set
            {
                _startDate = value;
                if (_startDate != null)
                    StartDateModel = new DateModel(_startDate.Value);
            }
        }
        public DateTime? EndDate
        {
            get { return _endDate; }
            set
            {
                _endDate = value;
                if (_endDate != null)
                    EndDateModel = new DateModel(_endDate.Value);
            }
        }
    }

}
  
