﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model.Customer
{
    public class BlackListItemModel
    {
        private int _itemBlackListId = -1;
        public int ItemBlackListId
        {
            get 
            {
                return _itemBlackListId;
            }
            set 
            {
                _itemBlackListId = value;
            }
        }
        public string itemBlackListName { get; set; }
        public int OrganizationId { get; set; }
        public string organizationCodeName { get; set; }
        public List<ItemBlackListModel> AddedItemsList { get; set; }

        public List<int> ItemsId { get; set; }
        
        public List<TextLanguage> DescriptionLanguages { get; set; }
        public List<CustomerGroupModel> AppliedGroups { get; set; }
        public List<CustomerChannelModel> AppliedChannels { get; set; }
        public List<SimpleCustomerModel> AppliedCustomers { get; set; }
        public List<OrganizationModel> AppliedOrganizations { get; set; }
       
        public BlackListItemModel()
        {
            ItemBlackListId = -1;
            organizationCodeName = string.Empty;
            AddedItemsList = new List<ItemBlackListModel>();
            ItemsId = new List<int>();
            itemBlackListName = string.Empty;
            DescriptionLanguages = new List<TextLanguage>();
            AppliedGroups = new List<CustomerGroupModel>();
            AppliedChannels = new List<CustomerChannelModel>();
            AppliedCustomers = new List<SimpleCustomerModel>();
            AppliedOrganizations = new List<OrganizationModel>();
            
        }
    }
    public class ItemBlackListModel
    {
        public int ItemId { get; set; }
        public string ItemCodeName { get; set; }
        public int IsReturnsBlock { get; set; }
        public int IsSalesBlock { get; set; }
        public int ValueType { get; set; }
        public List<BlockTypeModel> BlockTypeList { get; set; }
       

        public ItemBlackListModel()
        {
            ItemId = -1;
            ItemCodeName = string.Empty;
            BlockTypeList = new List<BlockTypeModel>();
            IsReturnsBlock = -1;
            IsSalesBlock = -1;
        }
    }

    public class BlockTypeModel
    {
        public string blockTypeName { get; set; }
        public int blockTypeId { get; set; }
    }
}
