﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class CallsHistoryModel
    {
        public CallsHistoryModel()
        {
            IsEnded = false;
            IsEndedAutomatically = false;
            DurationTime = 0;
            EndNow = false;
            CallId = -1;
            EmployeeId = -1;
            CustomerId = -1;
            OutletId = -1;
            VisitId = -1;
        }
        public int CallId { set; get; }
        public int EmployeeId { set; get; }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public int VisitId { set; get; }
        public int DurationTime { set; get; } // int seconds
        public string CallDuration { set; get; } // HH:mm:ss format
        public bool IsEnded { set; get; }
        public bool IsEndedAutomatically { set; get; }
        public string TeleRepCodeName { get; set; }
        public DateTime CallDate { get; set; }
        public DateTime? StartDate { get; set; }
        public DateTime? EndDate { get; set; }
        public DateTime CreationDate { get; set; }
        public string Status { get; set; }
        public string Reason { get; set; }
        public string GenesysCallId { get; set; }
        public string ParticipantId { get; set; }
        public bool EndNow { get; set; }
    }
    public class GenesysTokenModel
    {
        public GenesysTokenModel()
        {
            EmployeeId = -1;
            TokenString = string.Empty;
        }
        public string TokenString { set; get; }
        public int ExpirySeconds { set; get; }
        public DateTime? ExpiryDate { set; get; }
        public int EmployeeId { set; get; }
    }
    public class CallEndTimeModel
    {
        public CallEndTimeModel()
        {
        }
        public string CallId { set; get; }
        public DateTime GenesysEndDate { set; get; }
        public DateTime? LocalEndDate { set; get; }
    }
    public class ActualCallsModel
    {
        public ActualCallsModel()
        {
            CustomerId = -1;
            OutletId = -1;
            Calls = new List<CallsHistoryModel>();
        }
        public int CustomerId { set; get; }
        public int OutletId { set; get; }
        public List<CallsHistoryModel> Calls { set; get; }
    }
}
