﻿using InCube.Security;
using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class CustomerFilter
    {
        private string _customerSignature = string.Empty;

        public DateModel TransactionDateModel { get; set; }
        public string CustomerCode { get; set; }
        public string OutletCode { get; set; }
        public string CustomerName { get; set; }
        public string Phone { get; set; }
        public string Email { get; set; }
        public int RegionId { get; set; }
        public int LandmarkId { get; set; }
        public int EmployeeId { get; set; }
        public string TransactionId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int ComplainTypeId { get; set; }
        public string Notes { get; set; }
        public CustomListFilters CustomListFilter { get; set; }
        public string CustomerSignature
        {
            get
            {
               return  _customerSignature;
            }
            set
            {
                if (value != null)
                {
                    var _decreptedCustomerOutletIds = EncryptionManager.Instance.DecryptData(value);
                    if (_decreptedCustomerOutletIds != null && !string.IsNullOrEmpty(_decreptedCustomerOutletIds) && _decreptedCustomerOutletIds != "-1")
                    {
                        var data = _decreptedCustomerOutletIds.Split(EncryptionManager.Instance.SignatureSeparator);
                        if (data != null && data.Length == 2)
                        {
                            CustomerId = int.Parse(data[0]);
                            OutletId = int.Parse(data[1]);
                        }
                    }
                }

            }
        }
        public List<DateModel> FromToDate { get; set; }
        public string IdentificationNumber { get; set; }
        public bool ShowForOutletOnly { get; set; }
        public EmployeeTypes EmployeeTypeId { get; set; }
        public DateModel TeleRepPlanDateModel { get; set; }
        public bool ShowUnplannedCustomers { get; set; }
        public int VisitStatusId { get; set; }
        public int ReasonId { get; set; }
        public string WarehouseIds { get; set; }
        public OrderHistoryFilterType OrderHistoryFilterType { get; set; }

        public CustomerFilter()
        {
            FromToDate = new List<DateModel>();

            EmployeeId = -1;
            RegionId = -1;
            LandmarkId = -1;
            ShowForOutletOnly = false;
            EmployeeTypeId = EmployeeTypes.None;
            ShowUnplannedCustomers = false;
            VisitStatusId = -1;
            ReasonId = -1;
            OrderHistoryFilterType = OrderHistoryFilterType.None;
            ComplainTypeId = -1;
            Notes = string.Empty;
        }
    }
}
